#declare rendering = false;

#if(rendering)
#declare dx = 3;
#declare dy = 2;
#declare dz = 3;

// perspective (default) camera
camera {
  location  <0, 5.0, -5>/2
  look_at   <dx/2, 0.0,  0>
  right     x*image_width/image_height
}  

// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <-20, 40, -20>
} 

#include "textures.inc"
#include "shapes.inc"  
#include "colors.inc"

background{LightSteelBlue} 
#end       
//##################################################################

#declare d = 0.01;
//##################################################################

#declare Floorboard = 
    box {<0,0,0> <dx/3,0.01,dz/8> texture {DMFWood6 rotate 90*y} }

#declare row1=
union{
    object{Floorboard}
    object{Floorboard translate 1*(dx/3+d)*x} 
    object{Floorboard translate 2*(dx/3+d)*x} 
}

#declare row2 =
union{
    object{row1}
    object{Floorboard translate 3*(dx/3+d)*x}
}

#declare Floor = 
difference {
    union {
        object {row1}
        object {row2 translate <(-0.5*dx/3),0,(dx/8+d)>}
        object {row1 translate 2*(dz/8+d)*z}
        object {row2 translate <(-0.5*dx/3),0,3*(dx/8+d)>}  
        object {row1 translate 4*(dz/8+d)*z}
        object {row2 translate <(-0.5*dx/3),0,5*(dx/8+d)>}  
        object {row1 translate 6*(dz/8+d)*z} 
        object {row2 translate <(-0.5*dx/3),0,7*(dx/8+d)>}
        box {<0,0,0> <dx,-0.001,dz> pigment{DarkBrown} }
    }//end union
    box {<0,0.1,0> <-dx/2,-0.1,1.1*dz> } 
    box {<0,0.1,0> <dx/2,-0.1,1.1*dz> translate dx*x } 
    bounded_by{ box{ <0,-0.001,0> <dx,0.01,dz>} }
}//end diff 
//##################################################################

#declare wall_texture = 
texture {
    pigment{
        gradient y 
        color_map {
        [0 White filter 0 ]
        [1 White filter 1] 
        }
    }
    normal {crackle scale 0.01}
}

#declare Walls =
union {
    box {<0,0,0> <dx,dy,0.1> texture {wall_texture scale dy} translate dz*z  }
    box {<0,0,0> <dx,dy,0.1> texture{wall_texture scale dy} rotate -90*y translate dx*x  }
    box {<0,0,0> <dx,dy,0.1> pigment{White filter 0.25}  no_image} 
    box {<0,0,0> <dx,dy,0.1> pigment{White filter 0.25} rotate -90*y no_image}   
    box {<0,0,0> <dx,0.1,dx> pigment{White filter 0.25} translate dy*y no_image}
}
//##################################################################
 
#declare rug =
difference { 
    height_field {
        function 200,200 { pattern{granite } }
    }
    cylinder {<0,0,0> <0,1,0> 0.25 scale <1,1,2> translate <0.5,0,0.5>inverse} 
    
    scale <1,0.1,1>
    pigment{Wheat}
}  
//################################################################## 


//##################################################################

 
#include "furniture.pov" 

#local POS = array[4][4]

#local BED = object {Bed rotate 90*y scale (2/8*dy)/39.75*0.75 translate <0.7,0,2.43> }

#local FIRST = <0.8,2,2.1>;

#local N1 = 7;
#local N=3; // 0 to 3 gives 4 => 4x4 gives 16 points
#local i=0;
#local j=0; 
#local m = 0;
#local n = 0;

#local RS = seed(1);
  
#local duvet =
union { 
#while(m<=N1)
    #local n=0;
    #while(n<=N1)
        bicubic_patch {
            type 1 
            flatness 0.1 
            u_steps 3 
            v_steps 3 
            #local col = <rand(RS),rand(RS),rand(RS)>;
            #local i=0; 
            #while (i<=N)
                #local j=0;
                #while(j<=N) 
                    #local XYZ = FIRST + <m*0.3,0,-n*0.24>/2 + 0.1*i*x - 0.08*j*z;
                    #local POS[i][j] = trace(BED,XYZ,-y) + 0.01*y;
                    //sphere {XYZ 0.05  translate -1.6*y pigment{Blue}}
                    //sphere{POS[i][j] 0.05 pigment{color rgb col} }                     
                    //#debug concat(str(i,0,1)," ",str(j,0,1)," ",vstr(3,POS[i][j],","0,-1),"\n")  
                    POS[i][j]
                    #local j=j+1;
                #end
            #local i=i+1;
            #end 
        }
        #local n=n+1;
    #end
    #local m=m+1;
#end 
}

#declare Room =
union {
    object {Floor}
    object {Walls}  
    object {bed_side_table rotate 90*y scale (2/8*dy)/39.75 translate <2.6,0,2.6>} 
    object {bed_side_table rotate 90*y scale (2/8*dy)/39.75 translate <2.6,0,0.6>}
    object {Lamp(true) scale 0.075 rotate 90*y translate <2.75,0.5,0.6>} 
    object {Lamp(false) scale 0.075 rotate 90*y translate <2.75,0.5,2.6>}
    object{BED}
    object{duvet pigment{RichBlue} }   
    object{rug translate <1,0,0.25>}
}

#if(rendering)object {Room}#end


