// Persistence of Vision Ray Tracer Scene Description File
// File: space.pov
// Vers: 3.5
// Desc: Entry for May-June 2002 round of IRTC "Dreaming"
// Date: 30/6/02
// Auth: James Taylor


#declare do_woman = true;
#declare do_fog = true; 
#declare do_blob = true;
#declare do_grid = true; 
#declare do_grass = true;    
#declare do_room = true;
//##################################################################
#include "colors.inc"
#include "finish.inc"
#include "rand.inc" 
#include "textures.inc" 
#include "shapes.inc"

#declare do_photons = false;
#declare do_rad = false;

global_settings {     
 #if (do_photons)
   photons {
     count 20000
     //spacing 0.05
     autostop 0
     jitter .4
     save_file "photon_map.ph"
     //load_file "photon_map.ph"
   }
   #end 
  #if(do_rad)
  #include "rad_def.inc"
  #declare rad_type = 8; 
   radiosity {
        Rad_Settings(rad_type,0,0) 
        save_file "rad_data.rad"
        //load_file "rad_data.rad" 
   }
  #end   
}

// perspective (default) camera
camera {
  location  <0,2,-5>
  look_at   <5,0,0>
  right     x*image_width/image_height
}


// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <-20, 40, -20>
}         
//##################################################################

#declare Nx = 20; //}
#declare Ny = 20; //}=20
#declare Nz = 20; //}

#declare dx = 3;
#declare dy = 2;
#declare dz = 3; 
//##################################################################

background {White}

//##################################################################
#if(!do_blob)
#declare obj = 
union {
    sphere {<0,0,0> 1/9 }    
    cylinder {<0,0,0> <dx,0,0> 1/10}
    cylinder {<0,0,0> <0,dy,0> 1/10} 
    cylinder {<0,0,0> <0,0,dz> 1/10} 
    pigment {Silver } 
}
#end 
 
//################################################################## 
#if(do_blob)
    #include "blob_macro.inc"
    #declare RS = seed(312);
    Blob() 
#end 
#if(do_grid)
#declare grid = 
    union { 
        #declare i=0;
        #while(i<=Nx)
            #declare j=0;
            #while(j<=Ny) 
                #declare k=0;
                #while(k<=Nz) 
                    #if(do_blob & (i<5) & (j>14) & (j<19) & (k<5) ) Blob() #end
                    object {obj translate <i*dx,j*dy,k*dz>} 
                    #declare k=k+1;
                #end
                #declare j=j+1;
            #end
            #declare i=i+1;
        #end
    }//end grid union 
object {grid translate -28*y} 
#end
//##################################################################
#if(do_fog)
    fog{ 
        fog_type 1
        distance 25
        turbulence <1,1,1>
        color LightSteelBlue
    }
#end
//##################################################################

// height of people is 3/4 of dy => sat down is 1/2 * 3/4  = 3/8*dy  
#if(do_woman)
    #declare do_hair = true;
    #declare do_butterfly = true;
    #include "woman.inc"
    #if(do_hair)#include "hair.inc"#end
    #declare woman_temp =
    union {
        object{woman }  
        #if(do_hair)object{hair}#end
        rotate 180*y 
    }
    #declare MIN = min_extent(woman_temp);
    #declare MAX = max_extent(woman_temp);

    #declare Woman = object {woman_temp scale (0.5*dy)/(MAX.y-MIN.y)}
    #undef woman_temp
    #undef woman
    #undef hair
    
    #if(do_butterfly)    
        #include "butterfly.inc"
        #declare MIN = min_extent(butterfly);
        #declare MAX = max_extent(butterfly);
        object{
            butterfly
            finish {ambient 0.5} 
            scale (0.1*dy)/(MAX.x-MIN.x) 
            rotate 145*y
            translate <-dx,0,0>+<5+0.4,0.12,0>+<-dx/4,dy/2,dz/3>
        }
    #end                                              
    object{Woman rotate -20*y translate <-dx,0,0>+<5.5,0,0.5> } 
#end 
//################################################################## 
#if(do_grass)
    #include "grass.inc"
    object {Grass translate <-dx,0,0>+<3,0,0>} 
#end  
//##################################################################
#if(do_room)
    #include "room.pov"
    object {Room translate <dx,-dy,0>+<3+0.1,0,0> }
#end
//END#OF#FiLE#######################################################
