//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 6 materials and 8 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 06/09/2002    (09.06.2002)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <     -3.547,      -2.954,       0.101>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.00000,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle          2.17856    // Vertical       2.179
  look_at   <     -4.679,      -6.008,       0.101>
}

//
// *******  L I G H T S *******
//

light_source {   // Arealight Internal lighting of mushroom
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.000, 0.000>*9.9990
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  fade_distance  2.0
  fade_power 1.0
  scale <1.309418, 1.386772, 1.0>
  translate  <-1.389018, -1.389018, 3.457778>
}


light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.2000
  translate  <0.0, -20.0, 20.0>
}


//
// ********  MATERIALS  *******
//

#include "irtcmcloud.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

union { // Eye
  sphere { // Eyeball
    <0,0,0>,1
    material {
      Corneatex
    }
  }
  disc { // Pupil
    <0,0,0>, <0,0,1>, 1.0
    material {
      Pupiltex
    }
    scale <0.07, 0.5, 1.0>
    translate  0.82001*z
  }
  disc { // Iris
    <0,0,0>, <0,0,1>, 1.0
    material {
      Iristex
    }
    scale <0.5, 0.5, 1.0>
    translate  0.82*z
  }
  scale 0.1
  rotate <-90.0, 0.0, -39.0>
  translate  <-4.7, -6.0, 0.1>
}




object { // Landfrom
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.236363, -2.953072, 0.000000>, <0.000000, -2.953072, 0.000000>, <1.236363, -2.953072, 0.000000>, 
      <-2.472726, -1.476536, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.476536, 0.000000>, <1.236363, -1.476536, 0.000000>, 
      <-2.472726, 0.000000, 0.000000>, <-1.236363, 0.000000, 0.000000>, <0.000000, 0.000000, 0.688576>, <1.184107, -0.424735, 0.688576>, 
      <-2.472726, 1.476536, 0.000000>, <-1.236363, 1.476536, 0.000000>, <0.355648, 1.414128, 0.688576>, <1.539754, 0.989394, 0.062598>
    }
  }
  material {
    Hillside
  }
  scale <5.221313, 5.057348, 3.621214>
  rotate 13.288233*z
  translate  <3.067054, 6.04272, 0.0>
}


#declare Mushroom_Centre = lathe {
  quadratic_spline
  16  // control points
  <0.0, 0.0>,
  <2.571821, 0.0>,
  <0.805385, 0.354054>,
  <0.316852, 1.129815>,
  <0.34355, 1.964532>,
  <0.452728, 2.759946>,
  <0.715254, 3.171988>,
  <1.104234, 3.380107>,
  <1.467867, 3.38554>,
  <1.754825, 3.135393>,
  <2.051906, 3.085282>,
  <2.132101, 3.308156>,
  <2.021044, 3.828195>,
  <1.613393, 4.525558>,
  <0.884989, 5.0>,
  <0.0, 5.0>
  rotate <90,0,90>
  material {
    MCloud
  }
}
union { // Mushroom_Cloud
  object { Mushroom_Centre }
  torus { // Mushroom_Ring
    1.8, 0.05  rotate -x*90
    material {
      MRing
    }
    no_shadow
    translate  2.0*z
  }
  translate  <-1.44941, -1.44941, 0.0>
}




