// This file contains the textures used in "The Pond"

//Landscape Textures

#declare Soil = material {
  texture {
    pigment { granite//spotted
      color_map {
        [ 0.000  color rgb<0.470, 0.350, 0.200> ]
        [ 0.800  color rgb<0.470, 0.350, 0.200> ]
        [ 1.000  color rgb<0.288, 0.596, 0.310> ]
      }
      scale     <0.005, 0.005, 0.005>
    }
    normal { bumps 0.5 turbulence .5 omega 2.000 lambda 0.500 scale 0.01 }
    finish { diffuse 0.44 ambient 0.13 specular 0.2 roughness 0.005 }
  }
}

#declare Mnt_Texture = material {
  texture {
    pigment { granite//spotted
      color_map {
        [ 0.000  color rgb<0.323, 0.240, 0.137> ]
//        [ 0.800  color rgb<0.395, 0.294, 0.168> ]
        [ 0.800  color rgb<0.323, 0.240, 0.137> ]
        [ 1.000  color rgb<0.288, 0.596, 0.310> ]
      }
      scale     <0.005, 0.005, 0.005>
    }
    normal { bumps 0.5 turbulence .5 omega 2.000 lambda 0.500 scale 0.05 }
    finish { diffuse 0.44 ambient 0.13 specular 0.2 roughness 0.005 }
  }
}
/*
#declare Grass = texture {
  pigment { granite //gradient y
    turbulence 0.5
    colour_map {
      [0.0  colour rgb <0.10,0.55,0.06>]
//    [0.65  colour rgb <0.4,0.21,0.04>]
      [0.7  colour rgb <0.9,0.9,0>]
      [0.75 colour rgb <0.10,0.45,0.09>]
//    [0.98 colour rgb <0.4,0.21,0.04>]
//    [1.0 colour rgb <0.4,0.21,0.04>]
      [1.0 colour rgb <0,0.5,0>]
    }
  scale <0.0005,0.0005,0.15>
  }
//normal {wrinkles 0.3 scale <0.0001,0.0001,1000>}
  finish{ ambient 0.2 diffuse 0.6 }
}*/

/*
#declare Grass_Text1 = texture { 
  pigment{ gradient z
    turbulence 0.4
    colour_map {
    [0.0  colour rgb <0.10,0.55,0.06>]
    [0.75 colour rgb <0.10,0.45,0.09>]
    [0.98 colour rgb <0.439216,0.219608,0.219608>]
    [1.0  colour rgb <0.4,0.21,0.04>]
    }
    scale <0.0001,0.0001,0.15>
  }
  finish{ ambient 0.2 diffuse 0.6 }
}*/


//Wood Textures

#declare DMFDarkOak = material {   
  texture {      
    pigment { wood
      color_map {
        [ 0.0     rgbft <0.6, 0.3, 0.18, 0.0, 0.0> ]
        [ 0.1     rgbft <0.6, 0.3, 0.18, 0.0, 0.0> ]
        [ 0.9     rgbft <0.3, 0.15, 0.09, 0.0, 0.0> ]
        [ 1.0     rgbft <0.3, 0.15, 0.09, 0.0, 0.0> ]
      }
      turbulence 0.04
      octaves 3
      ramp_wave
      scale  <0.2, 0.2, 1.0>
    }
    finish {ambient .15}
  }
}

#declare Wood1 = texture {   
  pigment { bozo
    color_map {
      [ 0.0     rgbft <0.204, 0.11, 0.078, 0.0, 0.0> ]
      [ 0.256   rgbft <0.231, 0.125, 0.09, 0.0, 0.0> ]
      [ 0.393   rgbft <0.247, 0.133, 0.09, 0.0, 0.0> ]
      [ 0.581   rgbft <0.204, 0.11, 0.075, 0.0, 0.0> ]
      [ 0.726   rgbft <0.259, 0.122, 0.102, 0.0, 0.0> ]
      [ 0.983   rgbft <0.231, 0.125, 0.086, 0.0, 0.0> ]
      [ 1.0     rgbft <0.204, 0.11, 0.078, 0.0, 0.0> ]
    }
    turbulence 0.04
    ramp_wave
    scale  <0.5, 0.5, 1.0>
    translate 10.0 * x
  }   
  finish { ambient 0.55 diffuse 0.8 }
}
texture {   
  pigment { wood
    color_map {
      [ 0.0     rgbft <0.545, 0.349, 0.247, 1.0, 0.0> ]
      [ 0.139   rgbft <0.0, 0.0, 0.0, 0.004, 0.0> ]
      [ 0.148   rgbft <0.0, 0.0, 0.0, 0.004, 0.0> ]
      [ 0.287   rgbft <0.545, 0.349, 0.247, 1.0, 0.0> ]
      [ 0.443   rgbft <0.545, 0.349, 0.247, 1.0, 0.0> ]
      [ 0.626   rgbft <0.0, 0.0, 0.0, 0.004, 0.0> ]
      [ 0.635   rgbft <0.0, 0.0, 0.0, 0.004, 0.0> ]
      [ 0.843   rgbft <0.545, 0.349, 0.247, 1.0, 0.0> ]
      [ 1.0     rgbft <0.545, 0.349, 0.247, 1.0, 0.0> ]
    }
    turbulence 0.04
    ramp_wave
    scale  <0.5, 0.5, 1.0>
    translate 10.0 * x
  }   
  finish { ambient 0.55 diffuse 0.8 }
}

#declare Rosewood = material {   
  texture { Wood1 }
}

#declare T_Wood33 = material {   
  texture {      
    pigment { wood
      color_map {
        [ 0.0     rgbft <0.55294, 0.21176, 0.0, 0.0, 0.0> ]
        [ 0.05    rgbft <0.55294, 0.21176, 0.0, 0.0, 0.0> ]
        [ 0.15    rgbft <0.32549, 0.13725, 0.0, 0.0, 0.0> ]
        [ 0.25    rgbft <0.55294, 0.21176, 0.0, 0.0, 0.0> ]
        [ 0.35    rgbft <0.32549, 0.11765, 0.0, 0.0, 0.0> ]
        [ 0.48    rgbft <0.55294, 0.21176, 0.0, 0.0, 0.0> ]
        [ 0.55    rgbft <0.29412, 0.13725, 0.01176, 0, 0> ]
        [ 0.65    rgbft <0.55294, 0.21176, 0.0, 0.0, 0.0> ]
        [ 0.78    rgbft <0.32549, 0.13725, 0.0, 0.0, 0.0> ]
        [ 0.85    rgbft <0.55294, 0.21176, 0.0, 0.0, 0.0> ]
        [ 0.96    rgbft <0.28627, 0.13725, 0.0, 0.0, 0.0> ]
        [ 1.0     rgbft <0.5451, 0.17647, 0.03529, 0.0, 0.0> ]
      }
      turbulence 0.0425
      ramp_wave
      scale  0.2
      translate 0.015 * x
    }
    finish {ambient .15}
  }
}

#declare Wood = texture { // for table  
  pigment { wood
    color_map {
      [ 0.0     rgbft <0.63, 0.36, 0.135, 0.0, 0.0> ]
      [ 0.25    rgbft <0.525, 0.294, 0.21, 0.0, 0.0> ]
      [ 0.25    rgbft <0.525, 0.294, 0.175, 0.0, 0.0> ]
      [ 0.4     rgbft <0.37, 0.215, 0.15, 0.0, 0.0> ]
      [ 0.4     rgbft <0.37, 0.215, 0.1, 0.0, 0.0> ]
      [ 0.5     rgbft <0.21, 0.126, 0.045, 0.0, 0.0> ]
      [ 0.7     rgbft <0.256, 0.184, 0.04, 0.0, 0.0> ]
      [ 0.98    rgbft <0.39, 0.252, 0.12, 0.0, 0.0> ]
      [ 1.0     rgbft <0.54, 0.36, 0.135, 0.0, 0.0> ]
    }
    turbulence 0.04
    omega 0.4
    ramp_wave
    scale  <0.1, 0.1, 1.0>
    rotate 356.0 * x
  }
}
texture {   
  pigment { wood
    color_map {
      [ 0.0     rgbft <0.4, 0.2, 0.08, 0.1, 0.0> ]
      [ 0.25    rgbft <0.44, 0.23, 0.09, 0.2, 0.0> ]
      [ 0.4     rgbft <0.45, 0.25, 0.09, 0.3, 0.0> ]
      [ 0.5     rgbft <0.4, 0.2, 0.08, 0.6, 0.0> ]
      [ 0.7     rgbft <0.46, 0.23, 0.1, 0.3, 0.0> ]
      [ 0.98    rgbft <0.44, 0.23, 0.09, 0.2, 0.0> ]
      [ 1.0     rgbft <0.4, 0.2, 0.08, 0.1, 0.0> ]
    }
    turbulence 0.05
    omega 0.65
    ramp_wave
    scale  <0.2, 0.2, 1.0>
    rotate 358.0 * x
  }
}

#declare T_Wood17_1 = material {   
  texture { Wood }
}


#declare Wood2 = texture {   
  pigment { wood
    color_map {
      [ 0.0     rgbft <0.63, 0.36, 0.135, 0.0, 0.0> ]
      [ 0.25    rgbft <0.525, 0.294, 0.21, 0.0, 0.0> ]
      [ 0.25    rgbft <0.525, 0.294, 0.175, 0.0, 0.0> ]
      [ 0.4     rgbft <0.37, 0.215, 0.15, 0.0, 0.0> ]
      [ 0.4     rgbft <0.37, 0.215, 0.1, 0.0, 0.0> ]
      [ 0.5     rgbft <0.21, 0.126, 0.045, 0.0, 0.0> ]
      [ 0.7     rgbft <0.256, 0.184, 0.04, 0.0, 0.0> ]
      [ 0.98    rgbft <0.39, 0.252, 0.12, 0.0, 0.0> ]
      [ 1.0     rgbft <0.54, 0.36, 0.135, 0.0, 0.0> ]
    }
    turbulence 0.04
    omega 0.4
    ramp_wave
    scale  <0.1, 0.1, 1.0>
    rotate 356.0 * x
  }
}
texture {   
  pigment { wood
    color_map {
      [ 0.0     rgbft <0.4, 0.2, 0.08, 0.1, 0.0> ]
      [ 0.25    rgbft <0.44, 0.23, 0.09, 0.2, 0.0> ]
      [ 0.4     rgbft <0.45, 0.25, 0.09, 0.3, 0.0> ]
      [ 0.5     rgbft <0.4, 0.2, 0.08, 0.6, 0.0> ]
      [ 0.7     rgbft <0.46, 0.23, 0.1, 0.3, 0.0> ]
      [ 0.98    rgbft <0.44, 0.23, 0.09, 0.2, 0.0> ]
      [ 1.0     rgbft <0.4, 0.2, 0.08, 0.1, 0.0> ]
    }
    turbulence 0.05
    omega 0.65
    ramp_wave
    scale  <0.2, 0.2, 1.0>
    rotate 358.0 * x
  }
  finish {ambient .2}
}

#declare T_Wood17 = material {   
  texture { Wood2 }
}


//Water Texture

#declare Lake_Water = material {   
  texture {      
//  pigment { color rgb <0.147, 0.147, 0.053> }
    pigment { color rgb <0.353, 0.478, 0.5255> }
    normal { bumps 0.1 scale 0.05 }
    finish { ambient 0.0 diffuse 0.01 /*specular 1.0*/ roughness 0.06 /*metallic 0.5*/ reflection .75 phong .3 }
  }   
  interior { ior 1.43 fade_distance 0.03 fade_power 100.0 }
}

   
//Lily Pads Textures

#declare White_Leaf = material {   
  texture {      
    pigment { color rgbft <1.0, 1.0, 1.0, 0.1, 0.05> }      
    finish { ambient /*rgb <1.0, 1.0, 0.8854>*/ .3}
  }
}


#declare Seed_Texture = material {   
  texture {      
    pigment { gradient z
      color_map {
        [ 0.0     rgbft <1.0, 0.63683, 0.2708, 0.0, 0.0> ]
        [ 0.423488  rgbft <1.0, 0.678333, 0.354133, 0.0, 0.0> ]
        [ 0.772242  rgbft <1.0, 0.789141, 0.346843, 0.0, 0.0> ]
        [ 1.0     rgbft <1.0, 1.0, 0.501961, 0.0, 0.0> ]
      }
    }      
    normal { agate , 0.8 agate_turb 1.1 }
    finish { ambient /*rgb <1.0, 1.0, 0.781233>*/ .3}
  }
}

#declare Green_Pad = material {   
  texture {      
    pigment { granite
      color_map {
        [ 0.0      rgbft <0.120, 0.442, 0.281, 0, 0> ]
        [ 0.099644 rgbft <0.325, 0.529, 0.325, 0, 0.0104> ]
        [ 1.0      rgbft <0.254, 0.475, 0.303, 0, 0.0104> ]
/*        [ 0.0     rgbft <0.0, 0.44, 0.22, 0.0, 0.0> ]
        [ 0.099644  rgbft <0.073203, 0.428758, 0.25098, 0.0, 0.0> ]
        [ 0.967972  rgbft <0.324756, 0.529378, 0.324756, 0.0, 0.0104> ]
        [ 1.0     rgbft <0.2, 0.6, 0.288318, 0.0, 0.0104> ]
*/      }
    turbulence 0.2
    octaves 1
    omega 0.0
    lambda 0.0
    frequency 2.0
    sine_wave
  }      
  finish { ambient /*rgb <0.306775, 0.581022, 0.148111>*/ .3 }
  }
}


// Moon Textures
   
#declare Halo = material {   
  texture {      
    pigment { onion
      color_map {
        [ 0.0  rgbft <1.00, 1.00, 1.00, 0.60, 0.0> ]
        [ 0.64 rgbft <1.0, 1.0, 1.0, 0.60, 0.0> ]
//        [ 0.65 rgbft <1.0, 1.0, 1.0, 1.00, 0.0> ]
//        [ 0.6  rgbft <1.0, 1.0, 1.0, 0.68, 0.0> ]
//        [ 0.75 rgbft <1.0, 1.0, 1.0, 0.70, 0.0> ]
        [ 0.80 rgbft <1.0, 1.0, 1.0, .80/*0.75*/, 0.0> ]
//        [ 0.95 rgbft <1.0, 1.0, 1.0, 0.95, 0.0> ]
//        [ 1.00 rgbft <1.0, 1.0, 1.0, 1.00, 0.0> ]
        [ 1.00 rgbft <1.0, 1.0, 1.0, 1.00, 0.0> ]
      }
    }      
    finish { ambient 1.0 diffuse 0.5 brilliance 0.0 specular 1.0 }
  }
}

#declare moon = material {   
  texture {      
    pigment {
      image_map {
        gif   "D:\Chun's philes\lake\final\others\Moray\moon.gif"
        interpolate 2
      }

    }      
    finish { ambient 0.5 diffuse 0.75 }
    scale  2.05
    translate    <1.03, 1.0, 0.0>
  }
}


// Owl Textures

#declare Wing_Tex = material {   
  texture {      
    pigment { spotted
      color_map {
        [ 0.0     rgbft <0.445, 0.447, 0.358, 0.0, 0.0> ]
        [ 0.19573  rgbft <0.85, 0.85, 0.85, 0.0, 0.0> ]
        [ 0.498221  rgbft <0.9375, 0.9375, 0.9375, 0.0, 0.0> ]
        [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
      }
      turbulence 1.0
      octaves 7
      omega 0.6
      lambda 3.0
      cubic_wave
    }      
    finish { ambient .4/*0.697833*/ diffuse 0.741 brilliance 0.0 phong_size 0.0 roughness 0.5 }      
    scale  1.1
    translate <-0.05, 0.0, -0.15>
  }
}

#declare Eye_Tex = material {   
  texture {      
    pigment {
      image_map {
        gif   "D:\Chun's philes\lake\final\eyes_texture.gif"
        map_type 1
        interpolate 4
      }
      scale  <-1,1,1>
      rotate 90*x
    }      
    scale  0.1
    rotate    <0.0, 45.0, -45.0>
  }
}

#declare Beak_Claws_Tex = material {   
  texture {      
    pigment { color rgb <0.176471, 0.176471, 0.176471> }      
    finish { ambient 0.5 diffuse 0.5 brilliance 10 phong_size 0 specular 0.5 roughness 0.0075 }
  }
}

#declare Head_Tex = material {   
   texture { 
     pigment { marble
       color_map {
         [ 0.0     rgbft <0.454683, 0.447229, 0.357783, 0.0, 0.0> ]
         [ 0.19573  rgbft <0.85, 0.85, 0.85, 0.0, 0.0> ]
         [ 0.498221  rgbft <0.9375, 0.9375, 0.9375, 0.0, 0.0> ]
         [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
       }
       turbulence 1.0
       octaves 8
       omega 0.7
       lambda 3.0
       cubic_wave
     }      
     finish { ambient .4/*0.697833*/ diffuse 0.741 brilliance 0 phong_size 0 roughness 0.5 }
   }   
     rotate -180.0 * z
     translate 0.05 * z
}

#declare Material1 = 
   material { 
     texture {      
       pigment { leopard
         pigment_map {
           [0.0 spotted
              color_map {
                [ 0.0     rgbft <0.403061, 0.404873, 0.343733, 0.0, 0.0> ]
                [ 0.19573  rgbft <0.718733, 0.718733, 0.718733, 0.0, 0.0> ]
                [ 0.498221  rgbft <0.9375, 0.9375, 0.9375, 0.0, 0.0> ]
                [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
              }
              turbulence 1.1
              octaves 7
              omega 0.6
              lambda 3.0
              cubic_wave
              scale  1.1
              translate    <0.04, 0.0, -0.15>
           ]
           [0.25 marble
              color_map {
                [ 0.0     rgbft <0.454683, 0.447229, 0.344, 0.0, 0.0> ]
                [ 0.19573  rgbft <0.85, 0.85, 0.85, 0.0, 0.0> ]
                [ 0.498221  rgbft <0.9375, 0.9375, 0.9375, 0.0, 0.0> ]
                [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
              }
              turbulence 1.0
              octaves 8
              omega 0.7
              lambda 3.0
              cubic_wave
           ]
         }
       }      
       normal { average
         normal_map {
           [
             bumps 0.3*2
             warp {turbulence 1}
             scale 0.2
           ]
           [
             bumps 0.2*2.5
             warp {turbulence 0.5}
             scale 0.001
           ]
         }
       }
       finish { ambient 0.4 diffuse 0.6*2 brilliance 0.6 }

/*         finish
         {
            ambient 0.697833
            diffuse 0.741
            brilliance 0.0
            phong_size 0.0
            roughness 0.5
         }*/
      }
   }

#declare Feet_Tex = material {   
  texture {      
    pigment { gradient z
      color_map {
        [ 0.0     rgbft <0.374978, 0.187489, 0.187489, 0.0, 0.0> ]
        [ 0.25    rgbft <0.387886, 0.257914, 0.257914, 0.0, 0.0> ]
        [ 0.5     rgbft <0.374978, 0.187489, 0.187489, 0.0, 0.0> ]
        [ 0.75    rgbft <0.387886, 0.257914, 0.257914, 0.0, 0.0> ]
        [ 1.0     rgbft <0.374978, 0.187489, 0.187489, 0.0, 0.0> ]
      }
      turbulence 0.5
      ramp_wave
    }
  }
}


//=========================================
// Leaf & Tree examples for the MakeTree macro
// (c) 1999 Gilles Tran tran@inapg.inra.fr
//=========================================
// Curved tree with long branches
// The curvature is obtained through the vpush vector <1,-0.8,0>
#include "colors.inc"
//=========================================
// Some tree textures
//=========================================
// simple tree texture for tests
//-----------------------------------------
#declare txtTree_0=texture{pigment{Tan} /*finish{ ambient .15}*/}
//-----------------------------------------
// tree texture with a image_map
//-----------------------------------------
//#declare txtTree_1=texture{pigment{image_map{png "treepig.png"  map_type 2  interpolate 2 }}}
//-----------------------------------------
// crackle tree textures
//-----------------------------------------
#declare colBark=rgb <1,0.6,0.31>; // nice brown
#declare txtTree_2=texture{pigment{crackle turbulence 0.4 lambda 3.2 color_map{[0 color colBark*.3][0.1 color colBark*.4][0.6 color colBark*.8] [1 color colBark*1.2]}}       
finish{ambient 0.1} scale <0.2,0.7,0.2>*1}                 
//-----------------------------------------
#declare colBark=rgb <1,0.8,0.51>*0.8; // dirty brown
#declare txtTree_3=texture{pigment{crackle turbulence 0.4 lambda 3.2 color_map{[0 color colBark*.3][0.1 color colBark*.4][0.6 color colBark*.8] [1 color colBark*1.2]}}       
finish{ambient 0.15} scale <0.2,0.7,0.2>*1}                 
//-----------------------------------------
#declare colBark=rgb <1,0.8,0.51>*2; // light brown
#declare txtTree_4=texture{pigment{crackle turbulence 0.4 lambda 3.2 color_map{[0 color colBark*.3][0.1 color colBark*.4][0.6 color colBark*.8] [1 color colBark*1.2]}}       
finish{ambient 0.1} scale <0.2,0.7,0.2>*1}                 

//-----------------------------------------
// birch-like tree texture
//-----------------------------------------
#declare colBark=rgb <1,0.8,0.64>; // light brown, white
#declare txtTree_5=texture{pigment{gradient y turbulence 0.7 lambda 4 color_map{[0 color colBark*.3] [0.1 color colBark][0.9 color colBark][1 color colBark*.4]}} finish{ambient 0.3}}
texture{pigment{bozo turbulence 0.7 lambda 4 color_map{[0 color colBark*.2][0.1 color colBark*.3] [0.3 color colBark*.4][0.4 color Clear][0.9 color Clear][1 color colBark*.4] }}finish{ambient 0.15}}                 

//-----------------------------------------
// spiral tree texture
//-----------------------------------------
#declare colBark=rgb <1,0.6,0.2>;
#declare txtTree_6=texture{pigment{spiral1 8 turbulence 0.5 lambda 4 color_map{[0 color colBark*.3] [0.3 color colBark*0.5][0.9 color colBark][1 color colBark*.4] }} finish{ambient 0.1} scale <1,3,1>}                
texture{pigment{bozo turbulence 0.7 lambda 3 color_map{[0 color Clear][0.1 color colBark*.1] [0.4 color Clear][0.9 color Clear][1 color colBark*.4] }} finish{ambient 0.1}}                 

//=========================================
// Leaf color and textures
//-----------------------------------------
// Simple leaf textures
//-----------------------------------------
#declare colLeaf=rgb <0.4,1,0.3>*0.4; // nice green
#declare txtLeaf_0=texture{pigment{colLeaf} finish{ambient 0.1 specular 0.3 roughness 0.01}}
//-----------------------------------------
#declare colLeaf=rgb <0.6,1,0.3>*0.8; // yellow clear green
#declare txtLeaf_1=texture{pigment{colLeaf} finish{ambient 0.12 specular 0.3 roughness 0.01}}
//-----------------------------------------
#declare colLeaf=rgb <0.65,1,0.3>*0.3; // olive green
#declare txtLeaf_3=texture{pigment{colLeaf} finish{ambient .5 specular 0.3 roughness 0.01}}
//-----------------------------------------
// Automn leaf (bad...)
//-----------------------------------------
#declare colLeaf_1=rgb <0.4,1,0.3>*0.4; // green
#declare colLeaf_2=rgb <1,0.8,0.3>*0.8; // yellow
#declare colLeaf_3=rgb <1,0.2,0.1>*0.8; // red
#declare txtLeaf_4=texture{
pigment{bozo turbulence 0.5        
        color_map{[0.0 color colLeaf_1][0.3 color colLeaf_2] [0.5 color colLeaf_3][0.7 color colLeaf_2][1.0 color colLeaf_1] }}       
        finish{ambient 0.1 specular 0.3 roughness 0.01}}                 
//-----------------------------------------
// Yellow and greenish (need scaling)
//-----------------------------------------
#declare colLeaf_1=rgb <0.7,1,0.2>*0.8; // greenish 
#declare colLeaf_2=rgb <1,0.7,0.2>*0.8; // yellow
#declare txtLeaf_5=texture{pigment{agate color_map{[0.0 color colLeaf_1][0.3 color colLeaf_2] [0.7 color colLeaf_2][1.0 color colLeaf_1] }}       
        finish{ambient 0.12 specular 0.3 roughness 0.01} scale 10}                 
  