#include "colors.inc"
#include "textures.inc"
#include "finish.inc"
#include "metals.inc"

#declare definition=300;
global_settings { max_trace_level 30 }
camera { location <0,0,-100>
  orthographic 
  direction z
  up definition*y*3/4
  right     definition*4/3*x
  look_at   <0.0, 0.0,  0.0>
  translate <0,-10,0>
}

background { Black } 
#local texttt=1;

#if (texttt)
#macro hline(tex,vert)
text { ttf "arialbd.ttf", tex,0.001,0
 scale definition/50
 translate <-definition*21/32,definition/2-(vert+1.5)*1.1*definition/50,0>
 texture { pigment { color rgb <0.9,0.5,0.1> } finish { ambient 1 diffuse 0 } } 
 no_shadow no_reflection }
#end
#macro line(tex,vert)
text { ttf "arial.ttf", tex,0.001,0
 scale definition/50
 translate <-definition*21/32,definition/2-(vert+1.5)*1.1*definition/50,0>
 texture { pigment { color rgb 1 } finish { ambient 1 diffuse 0} } 
 no_shadow no_reflection }
#end
#macro hline2(tex,vert)
text { ttf "arialbd.ttf", tex,0.001,0
 scale definition/50
 translate <+definition*1/32,definition/2-(vert+1.5)*1.1*definition/50,0>
 texture { pigment { color rgb <0.9,0.5,0.1> } finish { ambient 1 diffuse 0 } } 
 no_shadow no_reflection }
#end
#macro line2(tex,vert)
text { ttf "arial.ttf", tex,0.001,0
 scale definition/50
 translate <definition*1/32,definition/2-(vert+1.5)*1.1*definition/50,0>
 texture { pigment { color rgb 1 } finish { ambient 1 diffuse 0} } 
 no_shadow no_reflection }
#end
#macro sline(tex,vert)
text { ttf "arial.ttf", tex,0.001,0
 scale 2/3
 scale definition/50
 translate <-definition*21/32,definition/2-(vert+1.5)*1.1*definition/50,0>
 texture { pigment { color rgb 1 } finish { ambient 1 diffuse 0} } 
 no_shadow no_reflection }
#end
#declare top=7;

hline2("The World's Fastest 3D.",0+top)
line2("A triple 128-bit pipeline that computes over 500 billion intersections", 1+top)
line2("per second. Experience resolutions as high as 65536x65536",2+top)
line2("and speeds exceeding 90 frames per second bringing you richly",3+top)
line2("detailed worlds with amazing color and clarity. PovCard delivers", 4+top)
line2("800 million pixels* per second.",5+top)

#declare top=7;

hline("All You Have Ever Dreamed Of.",0+top)
line("Using true mathematical shapes instead of approximations",1+top)
line("made of triangles and polygons gives you the perfect smoothness",2+top)
line("at any distance. True radiosity for more than realistic scenes.",3+top)
line("Sub-surface scattering gives your objects this touch of",4+top)
line("realism that will make you believe it is a photograph",5+top)
line("made by a true professional. Non-linear transformations",6+top)
line("and curved rays allow you to deform any object as you",7+top)
line("want instantly, making Hollywood's latest FXs look boring",8+top)
line("in comparaison. Integrated sky, clouds, fogs and fires"9+top)
line("generators make your outdoor scenes look so real!",10+top)

hline("Highest Software Compatibility.",12+top)
line("PovCard offers full compatibility with all versions of", 13+top)
line("PovRay currently on the Internet. PovRay's revolutionary",14+top)
line("Magick Technology fueled the 3D revolution and continues", 15+top)
line("to provide support for DKBtrace, SuperPatch, as well as", 16+top)
line("MegaPov, ensuring that's yesterday's, today's and tomor-",17+top)
line("row's hottest raytracers will run right out of the box!", 18+top)

hline("Fully Scaleable and Render Farm Ready.",20+top)
line("If you ever need more accelaration, just add another card.",21+top)
line("There is no need to upgrade other parts of your computer",22+top)
line("(cpu, memory, disks,...) as long as it can cope with the",23+top)
line("astonishing speed of images delivered by the PovCards.",24+top)
line("Build easily a powerful renderfarm simply by adding more",25+top)
line("PovCards in your home computer. Only you set the limit!",26+top)

#declare top=-14;

hline2("A Raytracing Solution That Installs in Minutes.",28+top)
line2("Using just a screwdriver, you can install it in just a",29+top)
line2("matter of minutes. Once it's plugged in, your computer",30+top)
line2("gains a fantastic advantage for raytracing.",31+top)

line("Works with Linux, BSD, Solaris, DOS, Windows 3.11,95,98,ME,NT3.5,NT4.0,2K & XP, Apple OSs and more ...",42-4)
line("Available interfaces: ISA, PCI 32 bits, PCI 64 bits, VME 1U, standard VME, CPCI, SCSI, FireWire, parallel and serial.",41-4)
sline("FCC, CE and C-TICK certified.",42.8-4)
sline("*: depth of pixel from 3 to 96 bits, with 1 to 24 bits per component, with either RGB or RGBA components.",43.5-4)

#end

#declare Memory= 
union {
difference {
box { 0,<10,2,27.5> }
cylinder { <5,1.7,27.5>,<5,2.1,27.5>,1.6 }
cylinder { <5,1.8,3.5>,<5,2.1,3.5>,1.0 }
texture { pigment { color rgb <0.16,0.15,0.14> } finish { Glossy }}
translate <0,1.5,0> }
#declare i=0;
union {
#while(i<21)
cone { 0,0.5,<0,3,0>,1 scale <0.2,1,0.4>
texture { Soft_Silver }
translate <10,0,i*1.25+0.8> }
cone { 0,0.5,<0,3,0>,1 scale <0.2,1,0.4>
texture { Soft_Silver }
translate <0,0,i*1.25+0.8> }
#declare i=i+1;
#end
}
}
#include "maze.inc"

union {
difference {
box { 0,<49.5,3,49.5> texture { pigment { color rgb <0.36,0.25,0.20>*0.7 } finish { Shiny }}}
text { ttf "crystal.ttf", "POV",1,0
 rotate <90,0,0>
 scale <25,1,25>
 translate <7,3.90,24>
 texture { pigment { color rgb <0.36,0.25,0.20>*0.55 } finish { Shiny }}
}
 translate <102,1.4,7> }
#declare j=0;
union {
#while(j<39)
cone { 0,0.7,<0,3,0>,1 scale <0.2,1,0.4>
texture { Soft_Silver }
 translate <0,0,j*1.25+1> 
 translate <102,0,7> }
cone { 0,0.7,<0,3,0>,1 scale <0.2,1,0.4>
texture { Soft_Silver }
 translate <49.5,0,j*1.25+1> 
 translate <102,0,7> }
cone { 0,0.7,<0,3,0>,1 scale <0.4,1,0.2>
texture { Soft_Silver }
 translate <j*1.25+1,0,0> 
 translate <102,0,7> }
cone { 0,0.7,<0,3,0>,1 scale <0.4,1,0.2>
texture { Soft_Silver }
 translate <j*1.25+1,0,49.5> 
 translate <102,0,7> }
#declare j=j+1;
#end
}
#declare j=0;
#while (j<3)
#declare i=0;
#switch(j)
#case(2)
#declare k=11;
#break
#case(1)
#declare k=7;
#break
#case(0)
#declare k=6;
#break
#end
#while (i<k)
object { Memory 
translate <13.5*i+5,0,j*31+5>
}
#declare i=i+1;
#end
#declare j=j+1;
#end
#declare j=0;
#while(j<3)
#switch(j)
#case(0)
#declare k=106.20;
#declare m=11;
#break
#case(1)
#declare k=41.20;
#declare m=11;
#break
#case(2)
#declare k=57.20;
#declare m=37;
#break
#end
#declare i=0;
#while(i<m)
box { -1.6*y,<0.85,-1.61,-7> texture { T_Gold_3C }
translate <k+i*1.25,0,0> }
box { 0,<0.85,0.01,-7> texture { T_Gold_3C }
translate <k+i*1.25,0,0> }
#declare i=i+1;
#end
#declare j=j+1;
#end
#declare ss=seed(33542);
#declare i=0;
#while(i<12)
#declare j=0;
#while(j<24)
#if (rand(ss)<0.10)
sphere { 0,1.25 scale <0.4,0.1,0.4> texture { Soft_Silver }
translate <13.5*6+5+i*1.25,0.11,5+j*1.25>
}
#end
#declare j=j+1;
#end
#declare i=i+1;
#end
union { Maze(120,76,19700406,70)
 scale <1/2*1.25,1/10,1/2*1.25>
 texture { pigment { DarkGreen*1.1 } }
translate <1.25,0,1.25> }  
prism {
 linear_spline
 -1.6, 0.0,
 19,
 <0,99>,
 <155,99>,<155,0>,<120,0>,
 <120,-8>,<106,-8>,<106,0>,
 <104,0>,<104,-8>,<57,-8>,<57,0>,
 <55,0>,<55,-8>,<41,-8>,
 <41,0>,<16,0>,<16,-8>,
 <0,-8>,<0,99>
 texture { band z
  texture_map { 
   [0 pigment { DarkGreen }]
   [0.9 pigment { DarkGreen }]
   [0.9 pigment { color rgb 0.5 }]
   [0.999 pigment { color rgb 0.5 }]
   [0.999 pigment { DarkGreen }]
   [1 pigment { DarkGreen }]
               
  } scale 130
 }
}
difference {
prism {
 linear_spline
 -4.0, 15.5
 7,
 <0,94>,<-12,94>,<-12,93>,
 <-1,93>,<-1,-29>,<0,-29>,<0,94>
}
 box { <-8,-2,-30>,<2,-6,100> }
 cylinder { <-5.5,-2,90>,<-5.5,-2,100>,2.5 }
 box { <-8,4,90>,<-15,7,100> }
 box { <2,12,90>,<-16,16,99>}
 cylinder { <-3,6,-19>,<3,6,-19>,2.5}
 box { <3,1,-30>,<-5,-6,-24> }
 box { 0, 12 rotate <-45,0,0> translate <-5,11,-24> }
 box { <3,11,-30>,<-5,20,-24> }
 box { 0, <12,-12,12> rotate <45,0,0> translate <-5,1,-24> }
 texture { Aluminum }
 }
 rotate <-30,-15,0>
 rotate <0,-15,0>
 translate <20,-50,0>
 scale 1.28
}

light_source { <0,1000,0>,1 }
light_source { <200,100,-100>,1 }
light_source { <0,-100,-100>,1 }

plane { z, -2000 texture { pigment { White } finish { ambient 1.0 } } }
plane { x, -2000 texture { pigment { White*0.5 } finish { ambient 1.0 } } }
plane { -x, -2000 texture { pigment { White*0.5 } finish { ambient 1.0 } } }

#if (texttt)

#macro cline(tex,vert,hori)
text { ttf "arial.ttf", tex,0.001,0
 scale definition/50
 translate <definition*hori/32,definition/2-(vert+1.5)*1.1*definition/50,0>
 texture { pigment { color rgb 1 } finish { ambient 1 diffuse 0} } 
 no_shadow no_reflection }
#end

cline("96 Gigabytes, NoWait State Memory",20,1)
cline("PovChip",24,18)
cline("PCI Bus Connector",34,10)
#end
