
// This file describes the objects needed to make the sign with 0,0,0 in the
// middle of the top sign.

            //----------------------------------- Define my bolt ----------
#declare BOLT = blob {
      threshold 0.60
      cylinder { <0, 0, 0>, <0, 0, 0.06>, 0.03, 1.0 }
      texture { pigment { color rgb  <0.390, 0.410, 0.430> } finish { F_MetalA } }
    }

#declare SIGN = object {
    union {
            //---------------------------------- The top sign on the two posts -------------
            object {
              read_mesh ("SIGNTOP.pcm")   // Pull in the mesh for the Sign top.
              scale <0.1,0.1,0.1>                  // scale to 0,0 by 1,1 box before applyting material map.
              clipped_by { plane { -z, 0.0 } }
                texture {
                  material_map {
                     gif "signman.gif" map_type 0 once interpolate 2
                     textures_signs_material_map_d16()
                  }
                }
              translate <-0.5,-0.5,0.0>
            }
            object {                               // The black trim on the top sign
              read_mesh ("SIGNTBN.pcm")   // Pull in the mesh for the Sign top black trim.
              scale <0.1,0.1,0.1>
              clipped_by { plane { -z, 0.0 } }
              texture { pigment { color k_Acadia } finish { Glossy } }
              translate <-0.5,-0.5,-0.0001>
            }
            object {                               // The yellow outter edge of the top sign
              read_mesh ("SIGNTOE.pcm")   // Pull in the mesh for the Sign top outter edge.
              scale <0.1,0.1,0.1>
              clipped_by { plane { -z, 0.0 } }
              texture { pigment { color k_Lightning_Yellow } finish { Glossy } }
              translate <-0.5,-0.5,0.00>
            }

            //----------------------------------- The four bolts for the top of the sign ----------
            object {
              union {
                object { BOLT translate <0.30,0.30,0.00> }
                object { BOLT translate <0.70,0.30,0.00> }
                object { BOLT translate <0.30,0.70,0.00> }
                object { BOLT translate <0.70,0.70,0.00> }
              }
              translate <-0.5,-0.5,0.0>
            }

            //---------------------------------- The bottom sign on the two posts -------------
            object {
              read_mesh ("SIGNBOT.pcm") // Pull in the mesh for the Sign bottom.
              scale <0.1,0.1,0.1>                // scale to 0,0 by 1,1 box before applyting material map.
              translate <0.1,0.1,0.0>            // Missed on size so adjust here.
              clipped_by { plane { -z, 0.0 } }
                texture {
                  material_map {
                     gif "lasttxt.gif" map_type 0 once interpolate 2
                     textures_signs_material_map_d16()
                  }
                }
              translate <-0.5,(-0.5 - 1.2),0.0>
            }
            object {                              // The black trim on the bottom sign
              read_mesh ("SIGNBBN.pcm")  // Pull in the mesh for the Sign bottom black trim.
              scale <0.1,0.1,0.1>
              translate <0.1,0.1,0.0>             // Missed on size so adjust here.
              clipped_by { plane { -z, 0.0 } }
              texture { pigment { color k_Acadia } finish { Glossy } }
              translate <-0.5,(-0.5 - 1.2),-0.0001>
            }

            //----------------------------------- The four bolts for the bottom of the sign ----------
            object {
              union {
                object { BOLT translate <0.20,0.30,0.00> }
                object { BOLT translate <0.20,0.50,0.00> }
                object { BOLT translate <0.60,0.50,0.00> }
                object { BOLT translate <0.60,0.30,0.00> }
              }
              translate <0.1,0.1,0.0>            // Missed on size so adjust here.
              translate <-0.5,(-0.5 - 1.2),0.0>
            }




            //---------------------------------- The two posts for the signs ------------------
            #declare SIGNPST = object { read_mesh ("SIGNPST.pcm") }  // Pull in the mesh for the Sign post.
            #declare F_Posts = finish {
                ambient     0.40
                diffuse     0.30
                metallic
                brilliance  0.80
                specular    0.80
                roughness   0.10
                reflection  0.03
            }
            object {
              union {
                      object { SIGNPST scale <0.1,0.1,0.110> translate <-0.20,-6.20,0.01> }
                      object { SIGNPST scale <0.1,0.1,0.110> translate < 0.20,-6.20,0.01> }
                      blob   {
                            threshold 0.60
                            cylinder { <-0.218,-6.200,0.010>, <-0.218,0.250,0.010>, 0.0105, 1.0 }  // Left side of left post, post outward
                            cylinder { <-0.219,-6.200,0.020>, <-0.219,0.250,0.020>, 0.0105, 1.0 }
                            cylinder { <-0.228,-6.200,0.020>, <-0.228,0.250,0.020>, 0.0105, 1.0 }
                            cylinder { <-0.182,-6.200,0.010>, <-0.182,0.250,0.010>, 0.0105, 1.0 }  // Right side of left post,post outward
                            cylinder { <-0.181,-6.200,0.020>, <-0.181,0.250,0.020>, 0.0105, 1.0 }
                            cylinder { <-0.172,-6.200,0.020>, <-0.172,0.250,0.020>, 0.0105, 1.0 }
                            cylinder { < 0.182,-6.200,0.010>, < 0.182,0.250,0.010>, 0.0105, 1.0 }  // Left side of right post,post outward
                            cylinder { < 0.181,-6.200,0.020>, < 0.181,0.250,0.020>, 0.0105, 1.0 }
                            cylinder { < 0.172,-6.200,0.020>, < 0.172,0.250,0.020>, 0.0105, 1.0 }
                            cylinder { < 0.218,-6.200,0.010>, < 0.218,0.250,0.010>, 0.0105, 1.0 }  // Right side of right post,post outward
                            cylinder { < 0.219,-6.200,0.020>, < 0.219,0.250,0.020>, 0.0105, 1.0 }
                            cylinder { < 0.228,-6.200,0.020>, < 0.228,0.250,0.020>, 0.0105, 1.0 }
                          }
              }
              texture {
                 agate
                 scale 1.2
                 turbulence 0.5
                 frequency 4
                 texture_map {
                   [0.0  pigment { color rgb 0.20 * <0.94, 0.73, 0.60> } finish { F_Posts } ]
                   [0.1  pigment { color rgb 0.22 * <0.94, 0.73, 0.60> } finish { F_Posts } ]
                   [0.3  pigment { color rgb 0.30 * <0.94, 0.73, 0.60> } finish { F_Posts } ]
                   [0.5  pigment { color rgb 0.26 * <0.94, 0.73, 0.60> } finish { F_Posts } ]
                   [0.7  pigment { color rgb 0.24 * <0.94, 0.73, 0.60> } finish { F_Posts } ]
                   [0.9  pigment { color rgb 0.21 * <0.94, 0.73, 0.60> } finish { F_Posts } ]
                   [1.0  pigment { color rgb 0.28 * <0.94, 0.73, 0.60> } finish { F_Posts } ]
                 }
              }

            }

          } // End union of sign objects
    } // End the sign object itself

