#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"
#include "stones1.inc"
#include "stones2.inc"
#include "finish.inc"

global_settings {
	max_trace_level 250
	radiosity {
		count 100
		recursion_limit 1
		media on
		normal on
	}
}

camera {
	location <0, 3.5, -7.5>
	look_at <0.6, 2.5, 0>
}


/* object definitions */

//candle flame
#declare flame=
sphere {<0, 0, 0>, 1 hollow no_shadow
        pigment {Clear}
        finish {Luminous}
        interior {
                media {
                        emission 100*<1, 0.5, 0>
                        samples 10, 10
                        intervals 50
                        density {
                                spherical
                                density_map {
                                        [0 rgb <0.01, 0, 0>]
                                        //[0.05 rgb <0.01, 0.01, 0>]
                                        [0.15 rgb <0.01, 0.0025, 0>]
                                        [0.25 rgb <0.1, 0.05, 0>]
                                        [0.75 rgb <1, 0.5, 0>]
                                        [1 rgb <1, 1, 0>]
                                }
                        }
                }
        }
        scale <0.035, 0.1, 0.035>
}                                        

//candles
#declare clcol=<0.175, 0.175, 0.15>;
#declare cancol=rgb <0, 0, 0>;		//candle color
#declare candles=
union {        
        union {
                cone {<0, 0, 0>, 0.2, <0, 0.05, 0>, 0.03}
                cylinder {<0, 0, 0>, <0, 0.065, 0>, 0.03}
                cylinder {<0, 0, 0>, <0, 0.7, 0>, 0.025}
                cone {<0, 0.7, 0>, 0.03, <0, 0.75 0>, 0.05}
                cone {<-0.4, 0.6, 0>, 0.03, <-0.4, 0.65, 0>, 0.05}
                cone {< 0.4, 0.6, 0>, 0.03, < 0.4, 0.65, 0>, 0.05}
        
                difference {
                        torus {0.25, 0.025 scale <1, 0.25, 1> rotate x*90 translate <-0.15, 0.6, 0>}
                        box {<-1, 0, -1>, <0, 0.6, 1> inverse}
                }
                difference {
                        torus {0.25, 0.025 scale <1, 0.25, 1> rotate x*90 translate <0.15, 0.6, 0>}
                        box {<1, 0, -1>, <0, 0.6, 1> inverse}
                }
                texture {T_Gold_3E}
        }
        cone {<0, 0.75, 0>, 0.0295, <0, 1.25, 0>, 0.025 pigment {cancol} finish {Dull}}
        cone {<-0.4, 0.65, 0>, 0.0295, <-0.4, 1.15, 0>, 0.025 pigment {cancol} finish {Dull}}
        cone {< 0.4, 0.65, 0>, 0.0295, < 0.4, 1.15, 0>, 0.025 pigment {cancol} finish {Dull}}
        light_source {<0, 1.3, 0> color clcol looks_like {flame}}
        light_source {<-0.4, 1.2, 0> color clcol looks_like {flame}}
        light_source {<0.4, 1.2, 0> color clcol looks_like {flame}}
}

#declare cavetext=
texture {
	pigment {rgb <0.85, 0.85, 1>}
	normal {marble turbulence 0.8 rotate <15, 40, 75>}
	finish {Phong_Glossy reflection 0.2 ambient 0.3}
}

#declare rad=10;
#declare cave=
union {
	torus {rad, rad*0.25
		translate y*rad*0.25
		clipped_by {plane {y, rad*0.25}}
		clipped_by {cylinder {<0, -10, 0>, <0, 10, 0>, rad inverse}}
	}
	sphere {<0, rad*0.25, 0>, rad+rad*0.25 clipped_by {plane {-y, rad*0.25}}}
	disc {<0, 0, 0>, y, rad}
	hollow
	texture {cavetext scale rad}
	interior {
		media {
			samples 1, 1
			intervals 10
			absorption 0.45
			emission 0.1
			//scattering {5, 1 eccentricity 0.35}
			scattering {3, <0.095, 0.075, 0.02>}
			density {
				planar turbulence 0.5 lambda 9 octaves 8
				density_map {
					[0 rgb <0.001, 0.001, 0.001>]
					[0.5 rgb <0.001, 0.001, 0.001>]
					[0.25 rgb <0.05, 0.05, 0.05>]
					[1 rgb <0.075, 0.075, 0.075>]
				}
				scale <1, rad, 1>
			}
		}
	}
}

//texture for table & chairs
#declare tabletext=
texture {T_Wood22 finish {Shiny}}

//table
#declare tableleg=
prism {
	linear_sweep
	cubic_spline
	-0.1, 0.1, 14
	<1, 0>, <1, 0>, <1, 0.2>, <0.5, 0.4>, <0.2, 0.595>, <0, 0.595>, <0, 0.595>,
	<0, 0.3>, <0, 0.3>, <0.2, 0.3>, <0.5, 0.2>, <0.8, 0>, <1, 0>, <1, 0>
	rotate x*-90
	texture {tabletext}
	translate <0.5, 0, 0>
}
#declare table=
union {
	cylinder {<0, -0.05, 0>, <0, 0.05, 0>, 1
		scale <3, 2, 1.5> translate <0, 1.9, 0>
		texture {tabletext}
	}
	torus {1, 0.05 scale <3, 2, 1.5> translate <0, 1.9, 0>
		texture {tabletext}
	}
	torus {0.35, 0.05 translate <0, 1.25, 0> texture {tabletext}}
	torus {0.35, 0.05 translate <0, 0.75, 0> texture {tabletext}}
	difference {
		cylinder {<0, 0.25, 0>, <0, 1.95, 0>, 0.5}
		torus {0.5, 0.2 scale <1, 2, 1> translate <0, 1, 0>}
		texture {tabletext}
	}
	object {tableleg rotate y*45}
	object {tableleg rotate y*135}
	object {tableleg rotate y*-45}
	object {tableleg rotate y*-135}
}

//chair
#declare chair=
union {
        superellipsoid {<0.25, 0.25>
                scale <0.6, 0.05, 0.6>
                translate <0, 1, 0>
                texture {tabletext}
        }
        cylinder {<-0.55, 0, -0.55>, <-0.45, 1, -0.45>, 0.05 texture {tabletext}}
        cylinder {<-0.55, 0, 0.55>, <-0.45, 1, 0.45>, 0.05 texture {tabletext}}
        cylinder {<0.6, 0, 0.55>, <0.5, 1, 0.45>, 0.05 texture {tabletext}}
        cylinder {<0.6, 0, -0.55>, <0.5, 1, -0.45>, 0.05 texture {tabletext}}
        cylinder {<-0.55, 0.25, -0.55>, <0.55, 0.25, -0.55>, 0.025 texture {tabletext}}
        cylinder {<-0.55, 0.25, 0.55>, <0.55, 0.25, 0.55>, 0.025 texture {tabletext}}
        cylinder {<-0.55, 0.25, -0.55>, <-0.55, 0.25, 0.55>, 0.025 texture {tabletext}}
        cylinder {<0.55, 0.25, -0.55>, <0.55, 0.25, 0.55>, 0.025 texture {tabletext}}
        union {
        	union {
        		cylinder {<0, 0, -0.45>, <0, 1.15, -0.45>, 0.05}
        		sphere {<0, 1.15, -0.45>, 0.05}
        		texture {tabletext}
        	}
        	union {
        		cylinder {<0, 0, 0.45>, <0, 1.15, 0.45>, 0.05}
        		sphere {<0, 1.15, 0.45>, 0.05}
        		texture {tabletext}
        	}
        	cylinder {<0.05, 0.15, 0>, <0.05, 0.65, 0>, 0.02 texture {tabletext}}
        	cylinder {<0.05, 0.15, -0.175>, <0.05, 0.65, -0.175>, 0.02 texture {tabletext}}
        	cylinder {<0.05, 0.15, 0.175>, <0.05, 0.65, 0.175>, 0.02 texture {tabletext}}
        	difference {
        		cylinder {<0, 0.1, 0>, <0, 1.15, 0>, 0.475 scale <0.15, 1, 1>}
        		cylinder {<0, 0.09, 0>, <0, 1.16, 0>, 0.475 scale <0.15, 1, 1> translate <-0.05, 0, 0>}
        		box {<-1, 0.25, -0.475>, <1, 0.55, 0.475>}
        		cylinder {<-1, 0, 0>, <1, 0, 0>, 0.15 scale <1, 0.5, 1.5> translate <0, 1.15, -0.475>}
        		cylinder {<-1, 0, 0>, <1, 0, 0>, 0.15 scale <1, 0.5, 1.5> translate <0, 1.15, 0.475>}
        		cylinder {<-1, 0, 0>, <1, 0, 0>, 0.15 scale <1, 0.5, 1.5> translate <0, 0.55, -0.475>}
        		cylinder {<-1, 0, 0>, <1, 0, 0>, 0.15 scale <1, 0.5, 1.5> translate <0, 0.55, 0.475>}
        		plane {x, 0}
        		texture {tabletext}
        	}
		rotate <0, 0, -10>
        	translate <0.5, 1, 0>
        }
        scale <1, 1.2, 1>
}

//wine texture
#declare winetext=
texture {
        pigment {rgbf <0.7, 0.7, 0.5, 0.6>}
        finish {Shiny ambient 1.2}
}

//wine interior
#declare wineint=
interior {
        ior 1.2
        fade_power 1.2
        caustics 0.3
}

//glass interior
#declare glassint=
interior {
        ior 1.5
        fade_power 1
        caustics 0.7
}

//bottle interior
#declare bottleint=
interior {
        ior 1.5
        fade_power 1.2
        caustics 0.5
}

//glass
#declare glass=
merge {
        cone {<0, 0, 0>, 0.1, <0, 0.05, 0>, 0.02}
        cylinder {<0, 0, 0>, <0, 0.35, 0>, 0.02}
        sphere {<0, 0.75, 0>, 0.4 hollow scale <0.3, 1, 0.3>}
        clipped_by {plane {y, 0.8}}
        texture {T_Glass3}
        interior {glassint}
}

//liquid in glass
#declare liquid=
sphere {<0, 0.75, 0>, 0.38 scale <0.3, 0.85, 0.3>
        clipped_by {plane {y, 0.7}}
        texture {winetext}
        interior {wineint}
}

//wine bottle shape
#declare bottle=
lathe {
        cubic_spline
        10,
        <0, 0>, <0, 0>, <0.1, 0>, <0.12, 0.02>, <0.12, 0.5>, <0.06, 0.7>, <0.04, 0.8>, <0.04, 1>, <0.038, 1>, <0, 1>
}

//wine bottle
#declare winebottle=
union {
        object {bottle hollow
        	texture {T_Winebottle_Glass}
        	interior {ior 1.5 fade_power 1 caustics 0.2}
        }
        difference {
                cylinder {<0, 0, 0>, <0, 0.5, 0>, 0.2}
                object {bottle inverse scale 0.95}
                texture {winetext}
                interior {wineint}
        }
        object {bottle scale 1.001
                pigment {
                        image_map {png "label.png" map_type 2 once}
                        scale <0.35, 0.35, 0.35>
                        rotate y*-30
                        translate <0, 0.06, 0>
                }
                finish {Dull}
        }                
}

//plate
#declare plate=
union {
        cylinder {<0, 0, 0>, <0, 0.02, 0>, 0.3}
        difference {
                cone {<0, 0, 0>, 0.3, <0, 0.04, 0>, 0.5}
                cone {<0, 0.02, 0>, 0.29, <0, 0.05, 0>, 0.498}
        }
        pigment {White * 1.1} finish {Shiny}
}

//fork
#declare fork=
difference {
        prism {
                linear_sweep
                cubic_spline
                -0.05, 0.05, 14
                <0, 0.075>, <0, 0.075>, <0, 0.076>, <0, 0.076>, <0.125, 0.01>, <0.215, 0.11>, <0.6, 0.01>, <0.6, 0.01>,
                <0.6, 0>, <0.6, 0>, <0.215, 0.1>, <0.125, 0>, <0, 0.075>, <0, 0.075>
                rotate <0, 90, 90>
                scale <1, 0.3, 1>
                rotate <0, -90, 0>
        }
        cylinder {<0, -1, 0>, <0, 1, 0>, 0.1 scale <1, 1, 0.075>}
        cylinder {<0, -1, 0>, <0, 1, 0>, 0.1 scale <1, 1, 0.075> translate <0, 0, 0.0275>}
        cylinder {<0, -1, 0>, <0, 1, 0>, 0.1 scale <1, 1, 0.075> translate <0, 0, -0.0275>}
        difference {
                torus {0.1, 0.0775 rotate <0, 0, 90> translate <0.2, 0.05, 0>}
                plane {x, 0.201 inverse}
        }
        difference {
                torus {0.1, 0.0775 rotate <0, 0, 90> scale <3, 1, 1> translate <0.2, 0.05, 0>}
                plane {x, 0.199}
        }
        clipped_by {
                union {
                        cone {<0.4, 0.05, 0>, 0.1, <0.6, 0.05, 0>, 0.05}
                        cone {<-0.1, 0.05, 0>, 10, <0.4, 0.05, 0>, 0.1}
                }
        }
        texture {T_Silver_5E}
}

//knife
#declare knife=
union {
	union {
		cylinder {<-0.15, 0, 0>, <0.15, 0, 0>, 0.05}
		sphere {<0, 0, 0>, 0.05  scale <0.5, 1, 1> translate <-0.15, 0, 0>}
		sphere {<0, 0, 0>, 0.05 scale <1.5, 1, 1> translate <0.15, 0, 0>}
		scale <0.75, 0.4, 0.8>
		translate <0.425, 0.01, 0>
		pigment {Black} finish {Shiny}
	}
	cylinder {<0, -0.0005, 0>, <0, 0.0005, 0>, 0.3 scale <1, 1, 0.09>
		translate <0.225, 0.01, 0>
		texture {T_Silver_5E}
	}
}

//honey dew slice
#declare hdslice=
difference {
	sphere {<0, 0, 0>, 1}
	sphere {<0, 0, 0>, 0.5}
	plane {y, 0}
	plane {y, 0 inverse rotate x*-25}
	pigment {
		spherical
		color_map {
			[0 rgb <0.6, 1, 0>]
			[0.2 rgb <0.8, 0.9, 0>]
			[1 rgb <0.9, 1, 0>]
		}
	}
	normal {granite 0.1}
	finish {Shiny}
	scale <0.15, 0.15, 0.25>
}

//cloth
#declare cloth=
cylinder {<0, 2, 0>, <0, 2.001, 0>, 0.75
	scale <1, 1, 0.7>
	pigment {Red}
	finish {Dull}
}

//skeleton texture
#declare sktext=
texture {
        pigment {rgb <0.9, 0.9, 0.95>}
        finish {specular 0.5 roughness 0.15 ambient 0.3}
}

#declare skeye=
light_source {<0, 0, 0> color rgb <0.3, 0, 0>
	fade_distance 0.2
	fade_power 2
	//looks_like {sphere {<0, 0, 0>, 0.025 hollow pigment {Clear} finish {Dull}}}
	looks_like {
		sphere {<0, 0, 0>, 1 hollow
			pigment {Clear}
			interior {
				media {
					emission 10
					samples 1, 10
					intervals 30
					density {
						spherical
						density_map {
							[0 rgb 0]
							[0.5 rgb <0.1, 0, 0>]
							[1 rgb <0.2, 0, 0>]
						}
					}
				}
			}
			scale 0.035
		}
	}
}

//skeletal waiter
#include "skeleton1.pov"
#declare skelw=
union {
        //skeleton
        object {skeleton1
                rotate <-90, 180, 0>
                translate <0, 2.034666, 0>
        }
        //towel draped over arm
        union {
                difference {
                        cylinder {<0, 0, -0.2>, <0, 0, 0.1>, 0.05}
                        cylinder {<0, 0, -0.6>, <0, 0, 0.6>, 0.04}
                        plane {y, 0}
                }
                difference {
                        box {<-0.05, -0.5, -0.2>, <0.05, 0, 0.1>}
                        box {<-0.04, -1.1, -0.6>, <0.04, 0.1, 0.6>}
                }
                pigment {White}
                normal {wrinkles turbulence 0.4 scale 0.1}
                finish {Dull ambient 0.5}
                scale <1.3, 1, 1>
                rotate <-21, -20, 0>
                translate <-0.84, 2.62, -0.175>
        }
        object {skeye translate <-0.3, 3.8, 0>}
		object {skeye translate <-0.4275, 3.8, 0>}
        scale 1.1
}

//skeletal violinist
#declare vbody=		//violin body
prism {
        linear_sweep
        cubic_spline
        0, 0.3,
        44
        <0.4, -1.7>, <0, -1.8>, <-0.4, -1.7>, <-0.8, -1.4>, <-0.7, -0.8>, <-0.7, -0.5>, <-0.8, -0.4>, <-0.6, -0.42>, 
        <-0.5, -0.2>, <-0.45, 0>, <-0.45, 0.1>, <-0.45, 0.2>, <-0.55, 0.4>, <-0.65, 0.42>, <-0.7, 0.4>, <-0.7, 0.5>
        <-0.6, 0.6>, <-0.65, 0.7>, <-0.75, 1>, <-0.7, 1.2>, <-0.3, 1.6>, <0, 1.65>,
        <0.3, 1.6>, <0.7, 1.2>, <0.75, 1>, <0.65, 0.7>, <0.6, 0.6>,
        <0.7, 0.5>, <0.7, 0.4>, <0.65, 0.42>, <0.55, 0.4>, <0.45, 0.2>, <0.45, 0.1>, <0.45, 0>, <0.5, -0.2>,
        <0.6, -0.42>, <0.8, -0.4>, <0.7, -0.5>, <0.7, -0.8>, <0.8, -1.4>, <0.4, -1.7>, <0, -1.8>, <-0.4, -1.7>,
        <-0.4, -1.7>
        scale <1.15, 1, 0.75>
        translate <0, 0, -0.2>
}

//texture for violin body
#declare wtext=
texture {T_Wood14 finish {Shiny}}

//texture for parts of violin
#declare btext=
texture {pigment {Black} finish {Shiny}}

//skeleton2 definition - from poser object
#include "skeleton2.pov"
#declare skelv=
union {
        //skeleton
        object {skeleton2}
        //violin
        union {
                object {vbody texture {wtext}}
                box {<-0.25, 0.3, -0.35>, <0.25, 0.4, -0.34> texture {T_Wood3 finish {Shiny}}}
                cone {<0, 0, 3>, 0.15, <0, 0, 0.4>, 0.25 texture {btext} scale <1, 0.1, 1> translate <0, 0.3, 0>}
                cone {<0, 0, -1.05>, 0.25, <0, 0, -1.49>, 0.05 texture {btext} scale <1, 0.3, 1> translate <0, 0.3, 0>}
                difference {
                        cone {<0, 0, 3>, 0.15, <0, 0, 0.4>, 0.275 scale <1, 0.15, 1> translate <0, 0.3, 0>}
                        plane {y, 0.3 inverse}
                        texture {wtext}
                }
                difference {
                        box {<-0.225, 0, 1.6>, <0.225, 0.3, 0>}
                        object {vbody}
                        cylinder {<-0.3, 0.05, 0>, <0.3, 0.05, 0>, 0.295 scale <1, 1, 1.5> translate <0, 0, 1.6>}
                        texture {wtext}
                }
                superellipsoid {<0.2, 0.2>
                        scale <0.2, 0.05, 0.275>
                        translate <0, 0.27, 3.25>
                        texture {wtext}
                }
                cylinder {<-0.15, 0.35, 3.45>, <0.15, 0.35, 3.45>, 0.1 texture {wtext}}
                cylinder {<-0.3, 0.28, 3.3>, <0.3, 0.28, 3.3>, 0.02 texture {btext}}
                cylinder {<-0.3, 0.28, 3.1>, <0.3, 0.28, 3.1>, 0.02 texture {btext}}
                box {<-0.01, -0.035, -0.01>, <0.01, 0.035, 0.01> rotate <60, 0, 0> translate <0.29, 0.28, 3.3> texture {btext}}
                box {<-0.01, -0.035, -0.01>, <0.01, 0.035, 0.01> rotate <30, 0, 0> translate <0.29, 0.28, 3.1> texture {btext}}
                box {<-0.01, -0.035, -0.01>, <0.01, 0.035, 0.01> rotate <45, 0, 0> translate <-0.29, 0.28, 3.3> texture {btext}}
                box {<-0.01, -0.035, -0.01>, <0.01, 0.035, 0.01> rotate <145, 0, 0> translate <-0.29, 0.28, 3.1> texture {btext}}
                sphere {<-0.09, 0.4, -0.345>, 0.01 texture {T_Silver_5B}}
                sphere {<-0.03, 0.4, -0.345>, 0.01 texture {T_Silver_5B}}
                sphere {<0.03, 0.4, -0.345>, 0.01 texture {T_Silver_5B}}
                sphere {<0.09, 0.4, -0.345>, 0.01 texture {T_Silver_5B}}
                cylinder {<-0.09, 0.31, 3.2>, <-0.09, 0.4, -0.345>, 0.01 texture {T_Silver_5B}}
                cylinder {<-0.03, 0.31, 3.15>, <-0.03, 0.4, -0.345>, 0.01 texture {T_Silver_5B}}
                cylinder {<0.03, 0.31, 3.25>, <0.03, 0.4, -0.345>, 0.01 texture {T_Silver_5B}}
                cylinder {<0.09, 0.31, 3.15>, <0.09, 0.4, -0.345>, 0.01 texture {T_Silver_5B}}
                cylinder {<-0.09, 0.4, -0.345>, <-0.09, 0.35, -1.05>, 0.01 texture {T_Silver_5B}}
                cylinder {<-0.03, 0.4, -0.345>, <-0.03, 0.35, -1.05>, 0.01 texture {T_Silver_5B}} 
                cylinder {<0.03, 0.4, -0.345>, <0.03, 0.35, -1.05>, 0.01 texture {T_Silver_5B}} 
                cylinder {<0.09, 0.4, -0.345>, <0.09, 0.35, -1.05>, 0.01 texture {T_Silver_5B}}
                scale <0.2, 0.2, 0.2>
                rotate <20, 170, 10>
                translate <0.3, 3.35, 0.1>
        }
        //bow
        union {
                cylinder {<0, 0, 3>, <0, 0, -1.5>, 1 texture {wtext}}
                cylinder {<0, 0, 1.95>, <0, 0, -1.45>, 1
                        scale <1, 0.5, 1>
                        translate <-0.5, 0, 0>
                        pigment {White}
                        finish {Dull ambient 0.3}
                }
                scale <0.01, 0.01, 0.26>
                rotate <40, 178, -75>
                translate <0.15, 3.4, -0.2>
        }
        object {skeye translate <0.05, 3.7, 0.05>}
        object {skeye translate <0.19, 3.705, 0.095>}
        scale 1.1
}


/* object placements */

object {cave}
object {table}
object {chair rotate y*-20 translate <4.5, 0, -0.2>}
object {chair rotate y*185 translate <-2.75, 0, 0>}
object {candles rotate <0, -55, 0> translate <0, 2, 0>}
object {cloth}
object {winebottle rotate y*30 translate <0.8, 2, 0.5>}
object {plate translate <-2.2, 2, 0>}
object {plate translate <2.2, 2, 0>}
object {glass scale 0.8 translate <-1.7, 2, -0.65>}
object {glass scale 0.8 translate <1.7, 2, 0.65>}
object {liquid scale 0.8 translate <1.7, 2, 0.65>}
object {fork translate <1.95, 2, 0.75>}
object {fork rotate y*180 translate <-1.95, 2, -0.75>}
object {knife translate <1.95, 2, -0.75>}
object {knife rotate y*180 translate <-1.95, 2, 0.75>}
object {hdslice rotate y*-10 translate <2.15, 2.01, 0.075>}
object {hdslice scale <1, 1.2, 1> rotate y*-110 translate <2.125, 2.01, -0.1>}
object {hdslice scale <1.1, 1.2, 1> rotate y*100 translate <2.35, 2.01, -0.025>}
object {hdslice rotate <90, 90, 0> scale <1, 0.5, 1> rotate y*60 translate <2.2, 2.15, -0.02>}
object {skelw rotate y*18 translate <3, 0, 1.75>}
object {skelv rotate <0, -25, 0> translate <-1.9, 0, 3>}
