// Dfinition des tats


#include "colors.inc"
#include "textures.inc"
#include "glass.inc"




// Wine color
#declare KColor = color rgbft <1, .1, .3, .5, .3>;

// Wine color; only more translucent
#declare KColor2 = color rgbft <1, .1, .3, .5, .6>;

// Glass color
#declare GColor = color rgbf <.95, .95, .95, .98>;






/*
	How to make a full bottle (could be simpler)
	-------------------------

	* Model a bottle as a solid object
	* Cut away a scaled down (and simplified) version
	* Texture them independently:
		- the outer part has a glassy look
		- the inner part is wine color, except for a small bit at the top
*/


// Outer side of a full bottle (the sphere at the end closes the bottom)
#declare Bottle2_1 = merge
{
	lathe
	{
		cubic_spline
		15,
		<.3, .6>, <1, .3>, <1.7, 0>, <1.9, 0>, <2, 0>, <2, .1>,           // Cul
		<2, 4.5>, <1, 8>, <.7, 11>,                                       // Flanc
		<.7, 11.3>, <.8, 11.4>, <.8, 11.6>, <.7, 11.7>,                   // Elargissement col
		<.7, 12>, <.6, 12>                                                // Goulot
		sturm
		scale <.9, 1, .9>
	}
	intersection
	{
		sphere
		{
			<0, 0, 0>, .4
			scale <1, .25, 1>
		}
		plane { -y, 0 }
		translate .7 * y
	}
	interior { I_Glass }
}



// Inner side
#declare Bottle2_2 = merge
{
	lathe
	{
		cubic_spline
		11,
		<.3, .6>, <1, .3>, <1.7, 0>, <1.9, 0>, <2, 0>, <2, .1>,           // Cul
		<2, 4.5>, <1, 8>, <.7, 11>,                                       // Flanc
		<.7, 12>, <.6, 12>                                                // Goulot
		sturm
		scale <.9, 1, .9>
	}
	intersection
	{
		sphere
		{
			<0, 0, 0>, .4
			scale <1, .25, 1>
		}
		plane { -y, 0 }
		translate .7 * y
	}
	interior { I_Glass }
}



// This is a full bottle
#declare Bottle2 = union
{
	object
	{
		Bottle2_1
		#if (DEBUG)
			texture
			{
				pigment { color Green }
			}
		#else
			texture
			{
				pigment { color GColor }
				normal
				{
					bump_map
					{
						png "kabby/logo.png"
						map_type 0
						once
						bump_size 7
					}
					translate -.5 * x
					rotate 180 * y
					scale 2 * <1, 264 / 200, 1>
					translate 5.75 * y
				}
				finish
				{
					F_Glass3
					ambient .4
				}
			}
			texture
			{
				pigment
				{
					image_map
					{
						png "kabby/frontstick.png"
						map_type 2
						once
					}
				}
				finish
				{
					ambient .2
					diffuse .4
					specular 0
				}
				translate -.5 * x
				rotate -90 * y
				scale <1, 4, 1>
				translate .5 * y
			}
		#end
	}
	object
	{
		Bottle2_2
		texture
		{
			pigment
			{
				gradient y
				color_map
				{
		        	[   0 color KColor]
		        	[9.5/24 color KColor]
					[9.5/24 color GColor]
					[   1 color GColor]
				}
				scale <1, 24, 1>
			}
		}
		scale <.6, 1, .6>
		translate .1 * y
	}
}





/*
	How to make an empty bottle (could be simpler too)
	---------------------------

	* Use a lathe object making up both sides
	* Add a smaller (and simplified) version wearing the back side of the label
		(a simple cylinder for this purpose would not match the lathe closely enough)
	* Add a little ellipsoid in the bottom to close the path
*/
#macro EmptyBottle (ang)
	merge
	{
		union
		{
			lathe
			{
				cubic_spline
				27,
				<.3, .6>, <1, .3>, <1.7, 0>, <1.9, 0>, <2, 0>, <2, .1>,           // Cul
				<2, 4.5>, <1, 8>, <.7, 11>,                                       // Flanc
				<.7, 11.3>, <.8, 11.4>, <.8, 11.6>, <.7, 11.7>,                   // Elargissement col
				<.7, 12>, <.6, 12>,                                               // Goulot
				<.5, 12>, <.6, 12>,                                               // Retour
				<.6, 11>, <.9, 8>, <1.9, 4.5>,
				<1.9, .1>, <1.9, .1>, <1.8, .1>, <1.6, .1>, <1.1, .2>, <.4, .7>, <.3, .6>
				sturm
				scale <.9, 1, .9>
				rotate ang * y
				#if (DEBUG)
					texture
					{
						pigment { color Green }
					}
				#else
					texture
					{
						pigment
						{
							color GColor
/*
							function { (y - 3 * x) / 10 + .03 }
							turbulence .1 * y
							color_map
							{
								[0 color .98 * KColor2 + .02 * GColor]
								[.02 color GColor]
							}
							scale 20
*/
						}
						normal
						{
							bumps .2
							scale 10
						}
						normal
						{
							bump_map
							{
								png "kabby/logo.png"
								map_type 0
								once
								bump_size 7
							}
							translate -.5 * x
							rotate 180 * y
							scale 2 * <1, 264 / 200, 1>
							translate 5.75 * y
						}
						finish
						{
							F_Glass3
							ambient .4
						}
					}
					texture
					{
						pigment
						{
							image_map
							{
								png "kabby/frontstick.png"
								map_type 2
								once
							}
						}
						finish
						{
							ambient .2
							diffuse .4
							specular 0
						}
						translate -.5 * x
						rotate -90 * y
						scale <1, 4, 1>
						translate .5 * y
					}
				#end
			}
			lathe
			{
				cubic_spline
				12,
				<.5, 12>, <.6, 12>,                                               // Retour
				<.6, 11>, <.9, 8>, <1.9, 4.5>,
				<1.9, .1>, <1.9, .1>, <1.8, .1>, <1.6, .1>, <1.1, .2>, <.4, .7>, <.3, .6>
				sturm
				scale <.899, 1, .899>
				no_shadow
				texture
				{
					pigment
					{
						image_map
						{
							png "kabby/frontstick_back.png"
							map_type 2
							once
						}
					}
					finish
					{
						ambient .2
						diffuse .4
						specular 0
					}
					translate -.5 * x
					rotate -90 * y
					scale <1, 4, 1>
					translate .5 * y
				}
			}
		}
		intersection
		{
			sphere
			{
				<0, 0, 0>, .4
				scale <1, .25, 1>
			}
			plane { -y, 0 }
			texture
			{
				pigment { color GColor }
				finish
				{
					F_Glass3
					ambient .4
				}
			}
			interior { I_Glass }
			translate .7 * y
		}
	}
#end
