// Persistence of Vision Ray Tracer Scene Description File
// File: DeskPicture.inc
// Vers: 3.5
// Desc: A very simple desk picture
// Date: 8/31/2002
// Auth: Jeff M. Thomas
//

// ----------------------------------------

#macro mDeskPicture()
  #local ImageMap=
  texture
  {  pigment
    {
      image_map 
      {
        png "ionic5.png"
      }
      translate<.5,.5,0>
      scale<.65,.48,1>
    }
  }
  #declare DeskPicture=
  union
  {
    #local RoundCorners = true;
    #local Plaque=
    union               
    {
      box{ <-.325,-.24,-.015><.325,.24,.015> translate .01*z texture{ ImageMap  } }
      difference
      { 
        #if (!RoundCorners)
          cylinder{ -.35*x,.35*x .025 }
          plane{ y, 0 rotate 45*z translate .325*x }
          plane{ y, 0 rotate -45*z translate -.325*x }
        #else
          cylinder{ -.325*x,.325*x .025 }
        #end
        translate<0,.24,0>
      }
      difference
      {
        #if (!RoundCorners)
          cylinder{ -.35*x,.35*x .025 }
          plane{ y, 0 rotate 45*z rotate 180*x translate .325*x }
          plane{ y, 0 rotate -45*z rotate 180*x translate -.325*x }
        #else
          cylinder{ -.325*x,.325*x .025 }
        #end
        translate<0,-.24,0>
        }
      difference
      {
        #if (!RoundCorners)
          cylinder{ -.265*y,.265*y .025 }
          plane{ y, 0 rotate -45*z rotate 180*x translate .24*y }
          plane{ y, 0 rotate -45*z translate -.24*y }
        #else
          cylinder{ -.24*y,.24*y .025 }
        #end
        translate<.325,0,0>
      }
      difference
      {
        #if (!RoundCorners)
          cylinder{ -.265*y,.265*y .025 }
          plane{ y, 0 rotate 45*z rotate 180*x translate .24*y }
          plane{ y, 0 rotate 45*z translate -.24*y }
        #else
          cylinder{ -.24*y,.24*y .025 }
        #end
        translate<-.325,0,0>
      }
      #if (RoundCorners)
        sphere{0, .025 translate<.325,-.24,0>}                 
        sphere{0, .025 translate<.325,.24,0>}                 
        sphere{0, .025 translate<-.325,-.24,0>}                 
        sphere{0, .025 translate<-.325,.24,0>}                 
      #end
      texture{ pigment{ Black } finish{ phong .8 } }
    }
    object{ Plaque }
  }
#end // mLightSwitch
