// Persistence of Vision Ray Tracer Scene Description File
// File: Dog.inc
// Vers: 3.5
// Desc: Blob Dog
// Date: 08/28/2002
// Auth: Jeff M. Thomas
//

#macro mDog( Texture )
  #declare Dog=
  union
  {
    blob {
      // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
      threshold .6
      sphere { < 0.0,   .3,    0>, 2, .75 } // lower body
      sphere { < 0.0,   0,    0>, .65, .75 scale <1,.25,1>} //butt 
      sphere { < 0.0,   1,    .75>, .75, .75 } // upper body
      sphere { < 0.0,   1.5,    .8>, .45, 1 } // head
      sphere { < 0.0,   0,    0>, 1, .85 scale <.5,.5,1> rotate -55*x translate<0,1.75,1> } // snout
      //cylinder{ <0,0,0>,<0,0,.15> .275, 1  rotate -55*x translate<0,1.75,1.25> } // snout
    
      sphere { < -2.3,   .3,    0>, .55, .75 scale <.25,1,1>} // left haunch
      cylinder{ <-.55, .055, .65>,<-.55, .055, -0.27> .15, 1 } // left hind leg 
      sphere { < 2.3,   .3,    0>, .55, .75 scale <.25,1,1>} // right haunch 
      cylinder{ <-.55, .055, .65>,<-.55, .055, -0.27> .15, 1 } // right hind leg 
    
      cylinder{ <-.40, .75, .85>,<-.40, .05, .85> .15, .75 } // left front leg 
      cylinder{ < .40, .75, .85>,<-.40, .05, .85> .15, .75 } // right front leg 
    
      sphere { < 0.0,   0,    0>, .25, .85 scale <.5,.5,1> rotate 55*x translate<0,.75,-.5> } // tail
    
      texture{ Texture }
      // [sturm]
      //scale 2
    }
    sphere { < 0, 2.08, 1.22>, .075 pigment{ Black } } // nose
    
    sphere { < -.15, 1.79, .830>, .065 pigment{ White } } // left eye
    sphere { <  .15, 1.79, .830>, .065 pigment{ White } } // right eye
    
    //sphere { 0, .1 scale< .75, 1.5, .25 > pigment { Brown } translate< -.15, 1.9, .75 > }
      
    // left ear
    prism {
      linear_sweep
      linear_spline
      0, // sweep the following shape from here ...
      .15, // ... up through here
      4, // the number of points making up the shape ...
      <0,0>, <-.5,-.5>,<.5,-.5>, <0,0>
      //<3,5>, <-3,5>, <-5,0>, <-3,-5>, <3, -5>, <5,0>, <3,5>
      texture { Texture }
      scale <.25,.45,.45>       
      rotate <-95,0,0>
      rotate <-10,0,25>
      translate< -.25, 1.85, .605 >
    }    
    // right ear
    prism {
      linear_sweep
      linear_spline
      0, // sweep the following shape from here ...
      .15, // ... up through here
      4, // the number of points making up the shape ...
      <0,0>, <-.5,-.5>,<.5,-.5>, <0,0>
      //<3,5>, <-3,5>, <-5,0>, <-3,-5>, <3, -5>, <5,0>, <3,5>
      texture { Texture }
      scale <.25,.45,.45>       
      rotate <95,0,0>
      rotate <-10,0,25>
      translate< .25, 1.55, .605 >
    }    
  }
#end // macro Dog
