// Persistence of Vision Ray Tracer Scene Description File
// File: LightSwitch.inc
// Vers: 3.5
// Desc: A light switch
// Date: 08/31/2002
// Auth: Jeff M. Thomas
//

#macro mLightSwitch()
  #declare LightSwitch=
  union
  {
    #local Plaque=
    union               
    {
      box{ <-.325,-.24,-.025><.325,.24,.025> }
      difference
      {
        cylinder{ -.35*x,.35*x .025 }
        plane{ y, 0 rotate 45*z translate .325*x }
        plane{ y, 0 rotate -45*z translate -.325*x }
        translate<0,.24,0>
      }
      difference
      {
        cylinder{ -.35*x,.35*x .025 }
        plane{ y, 0 rotate 45*z rotate 180*x translate .325*x }
        plane{ y, 0 rotate -45*z rotate 180*x translate -.325*x }
        translate<0,-.24,0>
      }
      difference
      {
        cylinder{ -.265*y,.265*y .025 }
        plane{ y, 0 rotate -45*z rotate 180*x translate .24*y }
        plane{ y, 0 rotate -45*z translate -.24*y }
        translate<.325,0,0>
      }
      difference
      {
        cylinder{ -.265*y,.265*y .025 }
        plane{ y, 0 rotate 45*z rotate 180*x translate .24*y }
        plane{ y, 0 rotate 45*z translate -.24*y }
        translate<-.325,0,0>
      }
  /* for rounded corners
      sphere
      {
        0, .025
        translate<.325,-.24,0>
      }                 
  */
      texture{ pigment{ White } }
    }
    difference
    {
      object{ Plaque }
      box{ <-.02,-.06,-.0251><.02,.06,.0251> translate -.15*x }
      box{ <-.02,-.06,-.0251><.02,.06,.0251> translate  .15*x }
    }
    union
    {
      cylinder{ -.02*x,.02*x .06 }
      box{ <-.016,-.016,0>< .016, .016,-.15> }
      rotate -25*x
      texture{ pigment{ White } }
      translate <-.15,0,.04>
    }
    union
    {
      cylinder{ -.02*x,.02*x .06 }
      box{ <-.016,-.016,0>< .016, .016,-.15> }
      rotate 25*x
      texture{ pigment{ White } }
      translate <.15,0,.04>
    }
    cylinder{ 0, -.0011*z .0175 translate<-.15, .14,-.024> pigment{ Gray } }
    cylinder{ 0, -.0011*z .0175 translate< .15, .14,-.024> pigment{ Gray } }
    cylinder{ 0, -.0011*z .0175 translate<-.15,-.14,-.024> pigment{ Gray } }
    cylinder{ 0, -.0011*z .0175 translate< .15,-.14,-.024> pigment{ Gray } }
  }
#end // mLightSwitch

//mLightSwitch()
//object{ LightSwitch }

