// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc"    
#include "glass.inc"
#include "textures.inc"
#include "finish.inc"

#declare useAreaLights=true;  
#declare showCity=true;
#declare showWindowGlass=true;
#declare useFocalBlur=false;
  
#include "lamp.inc"  
#include "aloneInc.inc"  
#include "beerbott.inc"  
#include "pencil.inc"  
   
global_settings { 
  assumed_gamma 2.2 
  max_trace_level 100
}

camera {
  location  <1,5+11,-4-1>
  direction 1.6*z
  right     x*image_width/image_height
  look_at   <3.0-.5,4+9.5+0.3,5>
 
  #if (useFocalBlur)  
    aperture .2       
    blur_samples 120    
    focal_point <4,15,3>  
  #end  
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.00>*.5]
      [0.7 rgb <0.0,0.1,0.8>*.5]
    }
  }
}


plane {  y, -1  pigment {Black }}

union{   
  difference{
    box{<-5.5,8.5,-5.5>,<5.5,-.5,5.5>}
    box{<-5.0,8.0,-5.0>,<5.0,0,5.0>}
    object{windowHole translate<17/12,28/12,5>}  
    object{windowHole rotate<0,90,0> translate<5,28/12,4.5>} 
    texture{
      pigment{Salmon+White/1.5}
      finish{ambient .2} 
      normal{
        crackle .04
        scale <0.6,.6,.1>*.05
        turbulence .1
      }  
    }  
  }  
  box{<-5.5,0,-5.5>,<5.5,.2,5.5> pigment{LightWood} finish{ambient .2}}
  box{<-5.5,7.9,-5.5>,<5.5,7.85,5.5> pigment{White} finish{ambient .2}}
  object{windowFrame translate<17/12,28/12,5>}
  object{windowFrame rotate<0,90,0> translate<5,28/12,4.5>}

   
  light_source {
    <0,7,0>          
    color rgb <1, 1, .7>*.20 // light's color
   
    #if (useAreaLights)  
      area_light
      <.5, 0, 0> <0, 0, .5> 
      8, 8                
      adaptive 1          
      jitter     
    #end

    fade_distance 4
    fade_power 3  
  }  
  translate<0,11,0>
}       

box{<0,0,0>,<1,1,.001>
  pigment{
    image_map {
      png "city2.png" 
      map_type 0        
      interpolate 2     
      once           
    } // image_map      
  }
  finish{ambient 1}
  scale<532/429,1,1>*12
  translate<1.12,6.35,20>
}             

object{tableLamp translate<4,13.3,3>} 
object{picture scale 1.4 rotate<10,75,0> translate<4.25,13.28,2.25>}      
 
object{table translate<2.8,13.20,2.3>} 
object{tv2 scale .7  rotate<0,30,0> rotate<00,0,0> translate<2.5,13.3,3.5>}  
object{beerBottle scale .09  rotate<0,-10,0> translate<3.65,13.28,1.5> }
object{beerBottle scale .09  rotate<0,100,0> translate<3.125,13.29,1.25>  } 
object{a_Pencil  scale .02  rotate<0,125,0>translate<3.0,13.295,1.75> }  
object{perscriptionBottle scale 1/12 translate<3.0,13.29,2.5> }
object{perscriptionBottle scale 1/12 rotate<0,90,0> translate<3.1,13.29,2.35> }
object{perscriptionBottle scale 1/18 rotate<0,150,0> translate<3.05,13.29,2.2> }
object{perscriptionBottle scale 1/12 rotate<0,-90,0> translate<2.8,13.29,2.4> }
object{perscriptionBottle scale 1/18 rotate<0,-20,0> translate<1.5,13.29,2.8> } 
object{perscriptionBottle rotate<-90,45,0> translate<0,1,0> scale 1/12 translate<2.90,13.29,2.20> }

#include "wheel.inc"  
object{whlChair rotate<0,150,0> translate<.75,11,1> }

#include "E:\PoseRay\alone5.inc"
object{      alone5 scale 7.25 rotate<0,60,0> translate<1.4,11.15,1.4>  finish{ambient .2} }

object{beerBottle scale .09  rotate<0,100,0> translate<1.65,13.29,1.12>  } 
object{remoteControl scale 1.375 rotate<0,20,0>translate<2.2,13.26,1.0> finish{ambient .2}}  
object{envelopeStack scale .6  rotate<0,15,0>translate<1.9-.2,13.31,2.9-.4> } 
object{envelopeStack scale .6  rotate<0,0,0>translate<1.8-.2,13.31+.04,2.9-.4> } 
object{bottomMolding   finish{ambient .25} rotate<180,-90,0> scale <1.5,1.5,60>  translate<4.95,11.2,0>}

box{<5,13,4.4999>,<5.20,18,4.6> 
  texture{
    pigment{White*.9}
    finish{Shiny ambient .3}
  }  
}       

box{<5.20,13,4.5>,<5.24,18,4.46> 
  texture{
    pigment{White*.9}
    finish{Shiny ambient .3}
  }  
}   

#include "heater.inc"
object{wallHeater rotate<0,180,0> translate<-.3,11,4.5>}     
       
#if (showCity)
  #version 3.1;        
  #declare city_right_hand_drive = true;      
  #declare city_seed = 18+26+50;
  #declare city_night = true;
  #declare windows_lit = .5;    
  #declare traffic_lanes = 3; 
  #declare buildings_per_block = 5;  
  #declare traffic_spacing = 4;   
  #declare city_block_count = 4;
      
  #declare theCity= #include "CITY"
  object{theCity scale 2.5 translate <445,0,430 >} 
#end  
