#declare xF_Glass3 =
finish  {
    ambient 0.1
    diffuse 0.1
    reflection 0.1/2
    roughness 0.003
}   
   
#declare xT_Glass3 =
texture {
    pigment {rgbf <0.98, 0.98, 0.98, 0.98>}
    finish {xF_Glass3 } 
}  

#declare paneOfGlass =    
union{
  box {<0,0,0>,<1,-.01,1>
     interior{ior 1.01}
     texture {xT_Glass3} 
  } 


  height_field {
    tga            
    "rain4.tga" 
//    smooth  
    interior{ior 1.7}
    texture {xT_Glass3} 
    finish{ambient .5}
    scale<1,0.004,1>
  }  

/*
  height_field {
    tga            
    "sht.tga" 
//    smooth  
    scale<1,0.0015,1>
    interior{ior 1.01} 
    texture {xT_Glass3  
      pigment {
      granite
      color_map {
        [0.0  color rgbf <0.98, 0.98, 0.98, 0.85>]
        [1.0  color rgbf <0.98, 0.98, 0.98, 0.92>]
      }
      turbulence<1.5,0,1.5>      
      scale<1,1,5>
    } 
  }  
} */
}     
     
     
#declare bottomMolding =
prism {                                
  linear_sweep  
  quadratic_spline 
  0.0,       
  75,        
  21,           
  < 0, 0>,< 0, 0>,<0, 1>,< 0, 49>,<1, 50>,<174, 50>,<175, 49 >,< 175, 38>,
  < 136, 38>,< 135, 39>,< 135, 24>,
  < 96, 24>,< 95, 23>,< 95, 12>,< 51, 12>,<50, 11>,<50, 1>,<49, 0>,< 1, 0>,< 0, 0>,< 0, 0>
  sturm
  scale 1/75/12
  rotate<0,0,-90>   
  texture{
    pigment{White}
    finish{Shiny ambient .3}
    normal {
      bumps .2
      scale <100000000, .01, .01>
    } 
  }  
}   
   
   
#declare windowMolding=
prism {                                
  linear_sweep  
  quadratic_spline 
  0.0,         
  1/12,        
  26,           
  < 0, 0>,< 0, 0>,< 0, -72>,<1, -72>< 47, -74>,< 96, -76>,< 105, -110>,
  < 134, -132>,< 183, -139>,< 219, -146>,< 260, -152>,
  < 300, -180>,< 309, -206>,< 378, -208>,< 450, -210>,< 450, -200>,
  < 450, -193>,< 477, -193>,< 477, -210>,< 503, -210>,
  < 503, -1>,< 503, 0>,< 502, 0>,< 250, 0>,< 0, 0>,< 0, 0>
  sturm
  scale <0.0003521,1,0.0003521>
  texture{
    pigment{White}
    finish{Shiny ambient .3}
    normal {
      bumps .2
      scale <.01,100000000 , .01>
    } 
  } 
}
     
#declare windowSection=     
union{
  box{<0,.38,0>,<1.25,1.25,1.0>}
  box{<.38,0,0>,<.63,.4,1.0>}
  box{<.63,.18,0>,<.92,.5,1.0>} 
  rotate<180,0,0> 
  rotate<0,90,0> 
  translate<1,1.25,1.25>
  texture{
    pigment{White}
    finish{Shiny ambient .3}
    normal {
      bumps .2
      scale <.1, .1 , .1>
    } 
  } 

}

#declare window=
union{
  union{    
    difference{
      object{windowSection scale<34,1,1>}
      box{<-2,2,2>,<0,-2,-2> rotate<0,0,-45>}
      box{<0,2,2>,<2,-2,-2> rotate<0,0,45> translate<33,0,0>}
    }

    difference{
      object{windowSection scale<34,1,1>}
      box{<-2,2,2>,<0,-2,-2> rotate<0,0,-45>}
      box{<0,2,2>,<2,-2,-2> rotate<0,0,45> translate<33,0,0>}
      rotate<0,0,180>
      translate<33,28,0>
    }

    difference{
      object{windowSection scale<28,1,1>}
      box{<-2,2,2>,<0,-2,-2> rotate<0,0,-45>}
      box{<0,2,2>,<2,-2,-2> rotate<0,0,45> translate<28,0,0>}  
      rotate<0,0,-90> translate<0,28,0>
    }

    difference{
      object{windowSection scale<28,1,1>}
      box{<-2,2,2>,<0,-2,-2> rotate<0,0,-45>}
      box{<0,2,2>,<2,-2,-2> rotate<0,0,45> translate<28,0,0>}
      rotate<0,0,90>  
      translate<33,0,0>
    }   
    scale 1/12        
  } //union    
  #if (showWindowGlass)
    object{paneOfGlass   rotate<90,0,0>  scale<37,27,12>/12 translate<0,27,1>/12}
  #end  
} //union

#declare windowFrame=  
union{  
  difference{
     object{windowMolding scale<1,56,1>}
     box{<-2,0,-1>,<2,1,1> rotate<0,0,45> translate<0,54/12,0>} 
     translate<(33)/12,0,0>
  }   

  difference{
     object{windowMolding rotate<0,0,180> scale<1,56,1> translate<0,56/12,0>}
     box{<-2,0,-1>,<2,1,1> rotate<0,0,-45> translate<0,54/12,0>} 
  }   

  difference{
     object{windowMolding rotate<0,0,90> scale<37.25,1,1> translate<35.125/12,(56-2.25)/12,0>}
     box{<-2,0,-1>,<2,1,1> rotate<0,0,135> translate<0,54/12,0>} 
     box{<-2,0,-.05>,<2,1,.05> rotate<0,0,-135> translate<33/12,54/12,0>}
  }   
  
  superellipsoid {
    <0.07,  .07>  
    translate<1,-1,-1> scale 1/24  
    scale<39.25,1,3> 
    translate<-3.125,.01,1>/12     
    texture{
      pigment{White}
      finish{Shiny ambient .3}
      normal {
        bumps .1
        scale <2, .01, .01>
      } 
    }  
  }    

  difference{
    object{bottomMolding scale<39,1,1>}
    box{<0,1,1>,<-1,-1,-1> rotate<0,0,40> translate<0,-.75,0>/12}
    box{<0,1,1>,<1,-1,-1> rotate<0,0,-40> translate<39,-.75,0>/12}
    translate<-3.125,-1,-1>/12
  }  
  
  object{window}       
  object{window  scale<1,.98,1>translate<0,26.5,1.38>/12}       
} 

#declare windowHole= 
box{<0,0,-2>,<33/12,54/12,2>


 texture{
   pigment{
     brick
     scale 0.06
   }
   finish{Glossy ambient .3 crand .1 }  
   normal { bumps 0.3 scale 0.007 }
 } 
} 

#declare remoteControl=
superellipsoid {<0.1,.2>  
  texture{
    pigment{White*.1}
    finish{Shiny ambient .3} 
  }
  texture{
    pigment{
      image_map {
        png "tvlabel.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
        map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
        interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance      
        once
      } // image_map
      rotate<90,0,0> 
      scale <1.75,1,1.5>
      translate<-.875,0,-.75> 
    }
  }
  translate<1,1,1>
  scale<2.5,0.625,6>/24 
}      
     

#declare tv=
union{ 
  superellipsoid {<0.08, 0.08>   
    rotate<90,0,0>
    rotate<0,90,0>
    translate<0,1,1> 
    texture{
      pigment{White*.4}
      finish{Shiny ambient .6} 
    }
    texture{  
      pigment{
        image_map {
          tga "edgartv2.tga" 
          map_type 0        
          interpolate 2     
          once          
        } // image_map   
        translate<-.5,0,0>  
        scale 1.95
      }  
      finish{Shiny ambient .8}
    }
    scale<14,13, 7>/12
  }  
     
#declare Cymbals_Metal = texture {
  pigment { color rgb <0.55, 0.55, 0.30>*1.2 }
  normal { bumps 0.3 scale 0.07 }
  finish {
    phong 1.0
    phong_size 60
    reflection 0.25
  }
}      

#declare picture=
union{
  box{<0,0,0>,<5,7,.125>/12
    texture{
      pigment{
        image_map {
          jpeg "mom.jpg" 
          map_type 0        
          interpolate 2   
          once
        } // image_map  
        rotate<0,0,0>
        scale<5,7,1>/12
      }
      finish{ambient .6}
    }    
  } 
  box{<0,0,0>,<5,7,-.03125>/12
    texture{
      pigment { rgbf<1.0, 1.0, 1.0, 0.995> }
      finish  { Glass_Finish }
    }    
  } 
  
  union{
    difference{
      union{
        cylinder{<.1875,-1,0>/12,<.1875,8,0>/12, .1875/12  }
        box{<0,-1,0>/12,<.1875,8,.1875>/12}
      }
      box{<-2,0,-2>/12,<2,3,2>/12  rotate<0,0,-45> translate<0,7/12,0>}
      box{<-2,0,-2>/12,<2,-3,2>/12  rotate<0,0,45> }
    }  
   
    difference{
      union{
        cylinder{<4.8125,-1,0>/12,<4.8125,8,0>/12, .1875/12  }
        box{<4.8125,-1,0>/12,<5.00,8,.1875>/12}
      }
      box{<-2,0,-2>/12,<2,3,2>/12  rotate<0,0,45> translate<5,7,0>/12}
      box{<-2,0,-2>/12,<2,-3,2>/12  rotate<0,0,-45> translate<5,0,0>/12}
    }  
    difference{
      union{
        cylinder{<-1,.1875,0>/12,<6,.1875,0>/12, .1875/12  }
        box{<-1,0,0>/12,<6,.375,.1875>/12}
      }
      box{<-4,2,-2>/12,<0,-2,2>/12  rotate<0,0,-45> }
      box{<0,2,-2>/12,<4,-3,2>/12  rotate<0,0,45> translate<5,0,0>/12}
    }  
    difference{
      union{
        cylinder{<-1,6.8125,0>/12,<6,6.8125,0>/12, .1875/12  }
        box{<-1,7,0>/12,<6,6.625,.1875>/12}
      }
      box{<-4,2,-2>/12,<0,-2,2>/12  rotate<0,0,45> translate<0,7,0>/12}
      box{<0,2,-2>/12,<3,-3,2>/12  rotate<0,0,-45> translate<5,7,0>/12}
    }  
    texture{Cymbals_Metal scale<.01,.01,.01>/100} 
  }  
  
  box{<1.5,0,0>/12,<3.5,-6,.125>/12  
    pigment{Brown}
    rotate<-25,20,0>
    translate<0,5,1.2>/12
  }
}  
}
    
#declare tv2=
union{
  object{tv} 
  difference{
    box{<-1.2, -.1,-.5>,<1.2,2.1,1.2>}
    box{<-1.15,.05,-2>,<1.15,2,.95>}
  } 

  light_source {
    <-.2,1,1.8-1.3-.4>                    
    color rgb <1,1.0,1.1>*.35
    projected_through { object {tv} }   
    spotlight 
    radius 89
    falloff 90
    tightness 0
    point_at <0,.75,0>
    #if (useAreaLights)
      area_light
      <.5, 0, 0> <0, 0.5, 0> 
      8, 8               
      adaptive 1          
      jitter          
    #end
  }   
  
  light_source {
    <0,1,0>                    
    color rgb <1,1.0,1.1>*.725 
    spotlight  
    scale<1,3,1> 
    translate<0,-1.5,0>
    point_at <0,6,-2>
    radius 79
    falloff 80
    tightness 0    
  }   
}  

#declare bottleShape=   
merge{ 
   cylinder { <0, .15, 0>, <0, 3, 0>, 1}
   torus { 0.85, 0.15  translate<0,0.15,0>  } 
   torus { 0.70, 0.3  translate<0,3,0>  } 
   cylinder { <0, 0, 0>, <0, 0.15, 0>, 0.85}
   cylinder { <0, 3, 0>, <0, 4, 0>, 0.7}   
}    
       
#declare cutout=
  box{<.72,3.625,-.03>,<1,5,.03>}       

#declare Plexiglas_Ior = 1.5;   
#declare perscriptionBottle=
union{
  difference{
    object{bottleShape}   
    object{bottleShape scale .90 translate<0,0.1,0>} 
    cylinder { <0,2, 0>, <0, 5, 0>, 0.7*.90}   
      
    texture {
      pigment { rgbf <1.0, 0.85, 0,.75> }        
      finish {
        ambient 0.1
        diffuse 0.1
        reflection .0625
        specular .75
        roughness .025 
        crand .01
      }  
    }  
    
    texture{
      pigment{
        image_map {
          png "label1.png" 
          map_type 0        
          interpolate 2     
          once         
        } // image_map
      } 
      finish{ambient .25}
      scale<1,2,1> 
      translate<0,.5,0>
      rotate<0,45,0>
    }
    normal { bumps 0.1 scale .75 } 
    interior {Water_Int}  
  }  

  #declare yrot=0;
   difference{
     cylinder { <0, 3.5, 0>, <0, 4.1, 0>, 0.75 }    
     #while(yrot < 360)
       object{cutout rotate<0,yrot,0>}  
       #declare yrot=yrot+10;    
     #end
     texture{
       pigment{White} 
       finish{ambient .2}
     }  
   }  
  rotate<0,0,0>
}  

#declare envelope1=   
superellipsoid { <0.01, 1>  translate<1,1,1>  
  texture{
    pigment{White*.95}
  } 
  
  texture{
    pigment{
      image_map {
        png "env1.png" 
        map_type 0        
        interpolate 2   
        once           
      } // image_map    
      rotate<0,0,0> 
      scale 2
    }
    finish{ambient .5}
  }   
  scale<9.5,4,.07>/12 
  rotate<90,0,0>
}

#declare envelope2=   
superellipsoid { <0.01, 1>  translate<1,1,1>  
  texture{
    pigment{White*.95}
  } 
  texture{
    pigment{
      image_map {
        png "env2.png" 
        map_type 0       
        interpolate 2     
        once          
      } // image_map    
      rotate<0,0,0> 
      scale 2
    }
    finish{ambient .5}
  }   
  scale<9.5,4,.07>/12 
  rotate<90,0,0>
}

#declare fakeEnvelope=   
superellipsoid { <0.01, .5>  translate<1,1,1>  
  texture{
    pigment{White*.95}
    finish{ambient .4} 
  } 
  scale<9.5,4,.07>/12 
  rotate<90,0,0>
}

#declare envelopeStack=
union{
  object{fakeEnvelope}
  object{fakeEnvelope rotate<0,2,0>translate<.5,.07,.25>/12}
  object{fakeEnvelope rotate<0,-1,0>translate<-.25,.07*2,.25>/12}
  object{fakeEnvelope rotate<0,0,0>translate<-.1,.07*3,.25>/12}
  object{fakeEnvelope rotate<0,0,0>translate<0,.07*4,.25>/12}
  object{fakeEnvelope rotate<0,-2,0>translate<.1,.07*5,.4>/12}
  object{fakeEnvelope rotate<0,-3,0>translate<.2,.07*6,.6>/12}
  object{envelope2 rotate<0,-1,0>translate<0,.07*7,.7>/12}
  object{envelope1 rotate<0,30,0>translate<0,.07*8,.7>/12  rotate<-3.95,0,0>}       
}  


#declare table= 
union{
  superellipsoid {
    <1.0,  0.25>  
    scale<2,2,.1>  
    rotate<90,0,0>
    pigment{
      image_map {
        png "table2.png" 
        map_type 0  
        interpolate 2
        once    
      }  
      rotate<90,0,0>
      scale 4 
      translate<-2,0,-2>
    } 
    normal{
      bump_map{ 
        png "hf_table2.png" 
        map_type 0       
        interpolate 2    
        once         
        bump_size 2 
      } 
      rotate<90,0,0>
      scale 4 
      translate<-2,0,-2>   
    }
    finish {specular 0.7 roughness 0.2}
  }
  box{<-.2,0,-.5>,<.2,-3,.2> translate<-.25,0,0> pigment{MediumWood}}
  box{<-.2,0,-.5>,<.2,-3,.2> translate<.25,0,0> pigment{MediumWood}}
}  
