
#include "x-man.inc"
#include "colors.inc"
// --- textures ---
#include "finish.inc"     // Some basic finishes
#include "glass.inc"      // Glass textures/interiors
#include "golds.inc"      // Gold textures
#include "metals.inc"     // Metallic pigments, finishes, and textures
#include "stones.inc"     // Binding include-file for STONES1 and STONES2
#include "stones1.inc"    // Great stone-textures created by Mike Miller
#include "stones2.inc"    // More, done by Dan Farmer and Paul Novak
#include "woodmaps.inc"   // Basic wooden colormaps
#include "woods.inc"      // Great wooden textures created by Dan Farmer and Paul Novak
#include "woodmaps.inc"   // Basic wooden colormaps
#include "woods.inc"      // Great wooden textures created by Dan Farmer and Paul Novak

   
#include "GLASS.INC"    
#include "GOLDS.INC"    
#include "METALS.INC"   
   



camera
{
  location  <-1.3, 3.55, -35>
  rotate <0,0,0> 
  direction 1.5*z
  right     4/3*x
  look_at   <0, 4,  0>  
  aperture 1/3
  focal_point<0,1,-5> 
  blur_samples 6
   
}

media { scattering { 3, color rgb 0.3   extinction 0. } }
       
fog{
    color rgbt <0.8,0.7,0.6,0.7>
    fog_type 2
    fog_alt 0.5
    fog_offset 0.51
    distance 20
    turbulence 20
    turb_depth 0.1 
}        

light_source
{
  <2,1,-5>
  color rgb 0.1
 media_interaction off  
}

light_source
{  <0, .75, 5>                 
  color rgb <0.1,0.1,0.3>*0.01 
  media_interaction on
} 

sky_sphere {  pigment { color rgb 1 }}
plane { y, 0 pigment {rgb <0.4,0.35,0.3>}} 
plane {-y,0 translate <0,8,0> texture {pigment {color rgb 0.3}}}

//plane {-z,0 translate <0,0,5> pigment {color rgb 1}no_shadow}

difference {
 plane { -y, 0 pigment {rgb <0.7,0.7,0.8>}translate <0,20,0>}
 plane {-z,0 pigment {color rgb 0}}
 }
//Mann

object {
 Man // <0,0,0> Y:ca 4  
 translate <0,0,-0.3>
}  

//Rckwand
         
difference {
 box {
  <-100,0,0><100,100,0.2>
  texture { 
   pigment {color rgb <0.3,0.5,0.3>}
   }
  } 
 box { 
  <-1,0,-0.3,><1,4,0.3>
  texture {
   pigment {color rgb <0,0,0> }
  }
 }
translate <0,0,0>
}

// Tr 
union {
 union { 
  box {
   <0,0,-0.03><2,4,0.03> 
   texture { T_Wood22 rotate <85,0,0> translate <0.5,0,1>}
  }
  box {
   <0.1,0,-0.03><1.9,3.9,0.031> 
   texture { T_Wood22 rotate <85,0,0> translate <0.5,0,1>}
  }
  union { //Griff
  cylinder {<1.9,2,-0.01><1.9,2,0.01>,0.12}
  cylinder {<1.8,2,-0.04><1.8,2,0.04>,0.11}
  cylinder {<1.8,1.9,-0.04><1.8,1.9,0.04>,0.11}
  cylinder {<1.8,2,-0.07><1.8,2,0.07>,0.05}
  sphere {<1.8,2,0.15>,0.075}
  sphere {<1.8,2,-0.15>,0.075}
  texture {T_Gold_2B}
  }
 rotate <0,120,0>
 translate <-1,0,0> 
 }
 difference {  
  box { <-1.1,0,-0.05><1.1,4.1,0>}
  box { <-1,0,-0.3,><1,4,0.3>}
  texture {T_Wood22 rotate <85,0,0> translate <0.5,0,1>}
 }
}
//uhr 

union {
 cylinder {<0,0,0><0,0,-0.05>0.5 pigment {color rgb 1}}
  union {
   #declare Count=0;
   #while (Count < 12)
   sphere {<0,0.47,-0.05>,0.02 rotate <0,0,Count*360/12>}
   #declare Count=Count+1;
   #end
   texture { pigment {color rgb 0.2}
  }
 }                                                                
 box {<-0.01,-0.02,-0.05><0.01,0.4,-0.051> pigment {color rgb 0}rotate <0,0,-5>}
 box {<-0.01,-0.02,-0.05><0.01,0.25,-0.051> pigment {color rgb 0}rotate <0,0,-30>} 
 translate <0,4.7,0>
}

//scharank  mit Fchern

#declare Fach = 
union { 
 difference {
  box {<0.11,0.31,0.1><0.89,0.99,-0.51>
   texture {
    pigment {color rgb <0.2,0.4,0.7>}
    finish {phong 0.6}
    normal {bumps 0.3 scale 0.02}
   }
  }
  union {                                                                  
   cylinder {<0.2,0.4,-0.51><0.8,0.4,-0.51>0.01 }
   cylinder {<0.2,0.5,-0.51><0.8,0.5,-0.51>0.01 }
   cylinder {<0.2,0.6,-0.51><0.8,0.6,-0.51>0.01 }
   cylinder {<0.2,0.7,-0.51><0.8,0.7,-0.51>0.01 }
   sphere { <0.5,0.8,-0.51>,0.04} 
   texture {T_Brass_1A}
   }
  }
  torus {0.1,0.02 texture {T_Silver_1A} scale <1,0.5,0.5> translate <0.5,0.8,-0.51>}
 }

#declare Schrank = 
union {
 difference {
  box { <0,0.1,0><1,3.8,-0.5>}
   box {<0.1,0.3,0.1><0.9,1,-0.51>}  
   box {<0.1,1.2,0.1><0.9,1.9,-0.51>}
   box {<0.1,2.1,0.1><0.9,2.8,-0.51>}
   box {<0.1,3,0.1><0.9,3.7,-0.51>}
   cylinder {<0.2,0,-0.4><0.2,0.1,-0.4>0.05}
   cylinder {<0.8,0,-0.4><0.8,0.1,-0.4>0.05}
   texture {
    pigment {color rgb <0.3,0.5,0.6>}
    finish {phong 0.6}
    normal {bumps 0.3 scale 0.02}
    }
 }
object {Fach}
object {Fach translate <0,0.9,0>}
object {Fach translate <0,1.8,0>}
object {Fach translate <0,2.7,0>}
}
 
                          
 //rechts hundert Schraenke
 #declare Count=0;
 #while (Count < 100)
  object {
   Schrank
   translate <3+Count,0,0>
  }
 #declare Count=Count+1;
 #end
 
 //links hundert Schraenke
 #declare Count=0;
 #while (Count < 100)
  object {
   Schrank
   translate <-4-Count,0,0>
  }
 #declare Count=Count+1;
 #end
 
  
#declare Tisch = 
union {
 union {
  box {<-2,2,0><2,1.9,-1>}
  box {<-2,1.7,0><-1,0.8,-1>}
  pigment {color rgb 0.8}
  }
 union {
  cylinder {<-1.8,1.9,-0.2><-1.8,0,-0.2>,0.05}
  cylinder {<1.8,1.9,-0.2><1.8,0,-0.2>,0.05}
  cylinder {<-1.8,1.9,-0.8><-1.8,0,-0.8>,0.05}
  cylinder {<1.8,1.9,-0.8><1.8,0,-0.8>,0.05}
  texture {T_Brass_3C}
  }
  scale 0.8


 }   
 
 
 
 
 
 #declare Stuhl=
  union {
   union {                                        
    cylinder {<0.7,0.05,0.7><-0.7,0.05,-0.7>,0.05}
    cylinder {<-0.7,0.05,0.7><0.7,0.05,-0.7>,0.05}
    cylinder {<0,0,0><0,0.2,0>,0.1}
    cylinder {<0,0,0><0,0.7,0>,0.06} 
    cylinder {<0,0.7,0><0,1,0.6>,0.05}
    sphere {<0,1,0.6>0.05}
    cylinder {<0,1,0.6><0,1.7,0.7>,0.05}
    sphere {<0,1.9,0.7>,0.05}
    texture {T_Brass_3C}
    }
    union {
     cylinder {<0,1,0><0,1.2,0>0.6 pigment {color rgb 0.5}}
     sphere {<0,0,0>1 scale <0.4,0.15,0.6> translate <0,1.2,0> texture {pigment {color rgb <0.6,0.2,0.2>}}}
     sphere {<0,0,0>1 scale <0.4,0.4,.1> translate <0,2,0.6> texture {pigment {color rgb <0.6,0.2,0.2>}}}    
    }
    
   translate <0,0,0.2>
   
 scale 0.8
 } 
 


#declare Lampe =
 union {
  cylinder {<0,3.5,-0.5><0,30,-0.5>,0.02 pigment {color rgb <1,0.3,0>}}
  union {
   sphere {<0,3.5,-0.5>,0.03}
   cone {<0,3.5,-0.5>,0,<0,3.2,-0.5>,0.3 open}
   cone {<0,3.5,-0.5>,0,<0,3.2,-0.5>,0.15 open}
   texture {T_Silver_3D}
   }
  sphere {<0,3.42,-0.5> 0.02 pigment {color rgb <1,1,0.9>}no_shadow}
  light_source{  <0, 3.39, -0.5>  color rgb <0.3,0.2,0.1>*1.2 media_interaction on} 
  } 
  


    

 #declare CountA=0;
 #while (CountA < 15)

 union {
 
 
 #declare Count=0;
 #while (Count < 3)

union { 
  object {
   Tisch
   rotate <0,7*sin((5*(Count+CountA+1))),0>
   translate <4,0,-5>
  }
  object {Stuhl  rotate <0,5*sin((5*(Count+CountA+1))),0> translate <4,0,-5>}
  object { 
   Lampe
   translate <4,0,-5>
  }
 
translate <Count*6,0,0>
}
 #declare Count=Count+1;
 #end


#declare Count=0;
 #while (Count < 5)      


union { 
  object {
   Tisch
   rotate <0,7*cos((50*(Count+CountA+1))),0>
   translate <-4,0,-5>
  }  
  object {
   Stuhl
   rotate <0,5*cos((50*(Count-CountA+1))),0>
   translate <-4,0,-5>
  }
  object {
   Lampe
   translate <-4,0,-5>
  }
translate <-Count*6,0,0>
}
 #declare Count=Count+1;
 #end 
  
  
translate <0,0,-CountA*3>
}
 #declare CountA=CountA+1;
 #end
                