
// POV-Ray Object File - A Kitchen Knife
// created 19-Aug-02
// last update 29-Aug-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "KitchenKnife.inc" in another .pov file
// Required #include files: "GIncludeRH.inc", "KnifeBladeHF.png", "KnifeHandleHF.png"
//
// Objects:
// KitchenKnife
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Knife origin is at the center of the tip
// Handle extends into +X

#ifndef (RenderAllFiles)
	#include "GIncludeRH.inc" // uncomment for testing only
#end

//===============================================
//             Includes
//===============================================



//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare KBladeTex =
	texture {
		pigment {
			color rgb<.336,.357,.412>*0.6
		}
//		finish { specular 0.95 roughness 0.028 metallic reflection 0.24 }
//		finish { specular 0.95 roughness 0.028 metallic reflection 0.94 } // render
		finish { diffuse 0.92 specular 0.99 roughness 0.008 metallic reflection 0.67 } // test
	}

#declare KHandleTex =
	texture {
		pigment {
			wood // rings around Z-axis
			color_map {
				[ 0.0 color rgb <0.788,0.216,0.098>*0.7 ] // more reddish
				[ 0.4 color rgb <0.788,0.216,0.098>*0.3 ]
				[ 0.5 color rgb <0.788,0.216,0.098>*0.5 ]
				[ 1.0 color rgb <0.788,0.216,0.098>*0.2 ]
			}
			rotate y*90 // follow main table axis
			turbulence 0.02
			scale 0.2

		}
//		normal { bumps 0.1 scale <1,12,1> }
		finish { ambient 0.1 diffuse 0.6 specular 0.02 roughness 0.24 }
	}

#declare KRivetTex =
	texture {
		pigment {
			color rgb <0.906,0.776,0.145>*.3
		}
		finish { specular 0.95 roughness 0.028 metallic reflection 0.24 }
	}

//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare KnifeBladeHalf =
	height_field { // extruded into +Y
		png "KnifeBladeHF.png"
		smooth
		water_level 0.03
		scale <10,1/16,10*3/17>
		translate <0,-0.01,0>
		texture { KBladeTex }
	}

#declare KnifeHandleHalf =
	height_field { // extruded into +Y
		png "KnifeHandleHF.png"
		water_level 0.02
		scale <10,0.28,10*3/17>
		translate <0,0.03,0>
		texture { KHandleTex }
	}
#declare KnifeRivet =
	cylinder {
		<0,-0.31,0>,<0,0.31,0>,0.15
		texture { KRivetTex }
	}
#declare KitchenKnife =
	union {
		object { KnifeBladeHalf }
		object { KnifeBladeHalf scale <1,-1,1> }
		object { KnifeHandleHalf translate <0,0,0> }
		object { KnifeHandleHalf scale <1,-1,1> translate <0,0,0> }
		object { KnifeRivet translate <5.9,0,1> }
		object { KnifeRivet translate <7.5,0,1> }
		object { KnifeRivet translate <9,0,1> }
	} // end union

//===============================================
//             For Testing Only
//===============================================

#ifndef (RenderAllFiles)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 25
		location  <5, -18, 11> // overall
		look_at <5,0,0>
//		location  <5, -18, 0.0001> // ground view
//		look_at <5,0,0>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 1 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }


object { KitchenKnife scale 1 rotate x*0 translate <0,0,0> }
//object { KitchenKnife scale 1 rotate x*-90 translate <0,-2,0.4> }
object { KitchenKnife scale 1 rotate x*-90 translate <0,2,0.30> } // this height sets it on its side

#end
