
// POV-Ray Object File - An Orange
// created 2-Aug-02
// last update 21-Aug-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Orange.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// SOrange // simple version, just a texture-mapped sphere
// BestOrange // complex version
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Orange origin is at the base of the fruit
// Navel extends into +Y


#ifndef (RenderAllFiles)
	#include "GIncludeRH.inc"
#end

//===============================================
//             Includes
//===============================================



//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================


#declare SOrangeTex =
	texture {
		pigment { color rgb <.961,0.351,0.000> } // orange
		normal { bumps .38 scale .04}
		finish { specular .16 roughness .35 diffuse 0.8 }
	}

#declare SOrangeMapTex =
	texture {
		pigment {
			image_map { "OrangeSkin2.png" map_type 1 }
		}
		normal {
			bump_map { "OrangeSkin1BumpMap.png" map_type 1 bump_size 4 }
		}
		finish { ambient 0.014 diffuse 0.96 specular .96 roughness .025 diffuse 0.8 }
	}


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare SOrange =
	sphere {
		<0,0,0>, 1.68 // 3.36" diameter
	texture { SOrangeMapTex }
	rotate x*90 // put top of orange towards +Z
}

#include "Orange3UV.inc"
#declare BestOrange =
	object { Orange3_object scale 0.65 rotate x*90 }


//===============================================
//             For Testing Only
//===============================================

#ifndef (RenderAllFiles)
//#if (RenderThisFile = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 25
		location  <1, -1.4*Feet, 8.1>
		look_at <0,0,1>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 1 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }

object { BestOrange rotate z*120 translate <0,0,0.00> }
//object { SOrange rotate z*0 translate <0,0,0.00> }

#end
