/*

  ASCETA.POV

  Jaime Vives Piqueres, Aug-2002.

  IRTC "Loneliness"

*/
#version 3.5;

#include "rad_def.inc"
global_settings{
 assumed_gamma 1
 ambient_light 0
 radiosity{    
  Rad_Settings(Radiosity_Normal,off,off) 
 }
}

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

#declare use_litera=1;
#declare use_blur  =1;
#declare use_area  =1;

// dirty room
#declare p_wall1=
pigment{ 
 image_map{jpeg "im_plast01.jpg"}
 translate -.5
 scale 10
 warp{turbulence 1 lambda 2}
}
#declare p_wall2=
pigment{ 
 image_map{jpeg "im_conc03.jpg"}
 translate -.5
 scale 10
 warp{turbulence 1 lambda 2}
}
#declare t_wall=
texture{
 pigment{ 
  cells
  warp{turbulence 1 lambda 3}
  pigment_map{
   [0.0 p_wall1]
   [0.3 p_wall1]
   [1.0 p_wall2]
  }
 }
 normal{
  cells -1
  warp{turbulence 1 lambda 3}
 }
 finish{diffuse .7}
 scale .5
}
#declare room=
difference{
 box{-.5,.5 scale 1.1}
 box{-.5,.5 scale .9}
 box{-.1,.1 scale <1,1,2> rotate -30*x translate <0,.2,.45>}
 scale <2,2,6>
 texture{t_wall}
 translate 1*y
}
object{room}
union{
 cylinder{<0,-1,0>,<0,1,0>,.01}
 cylinder{<0,-1,0>,<0,1,0>,.01 translate -.1*x}
 cylinder{<0,-1,0>,<0,1,0>,.01 translate .1*x}
 pigment{Gray10}
 translate window_pos + .3*z
}


// dirty floor
#declare brs=(2*.9/6)*.99;
#declare r_floor=seed(528);
#declare nfi=19;
#declare nco=6;
#declare ibr=1;
#declare ifi=0;
#declare chk_floor=
union{
 #while (ifi<nfi)
  #declare ico=0;
  #while (ico<nco)
   box{<-brs*.5,0,-brs*.5>,<brs*.5,.11,brs*.5>
    #if (mod(ibr,2)=0)
     texture{pigment{White}}
    #else
     texture{pigment{Gray20+Orange*.6}}
    #end
    texture{
	pigment{
		cylindrical turbulence .1 lambda 4
                cubic_wave
		color_map{
			[0 DarkGreen*.1]
			[1 rgbt 1]               
		}
	}
	scale brs
    }
    rotate <-1+2*rand(r_floor),0,-1+2*rand(r_floor)>
    translate <-.9+brs*.5+brs*ico+.01,0,-3+brs*.5+brs*ifi>
    texture{
	pigment{
		cells turbulence 1 lambda 4
		color_map{
			[0 DarkTan*.1 transmit 0.7]
			[1 rgbt 1]               
		}
	}
	scale brs
    }
   }
   #declare ico=ico+1;
   #declare ibr=ibr+1;
  #end
  #declare ifi=ifi+1;
  #declare ibr=ibr+1;
 #end
}
object{chk_floor}

// *** poor bed ***
#if (use_litera)
#declare p_metal1=
pigment{ 
 image_map{jpeg "im_iron03.jpg"}
 translate -.5
 scale 10
 warp{turbulence 1 lambda 2}
}
#declare p_metal2=
pigment{ 
 image_map{jpeg "im_brass01.jpg"}
 translate -.5
 scale 10
 warp{turbulence 1 lambda 2}
}
#declare p_metal3=
pigment{ 
 image_map{jpeg "im_iron04.jpg"}
 translate -.5
 scale 10
 warp{turbulence 1 lambda 2}
}
#declare rusted_metal=
texture{
 pigment{ 
  cells
  warp{turbulence 1 lambda 3}
  pigment_map{
   [0.0 p_metal1]
   [0.3 p_metal1]
   [1.0 p_metal2]
  }
 }
 normal{
  cells -1
  warp{turbulence 1 lambda 3}
 }
 finish{F_MetalA}
 scale .1
}
#declare t_very_rusted_metal=
texture{
 pigment{ 
  cells
  warp{turbulence 1 lambda 3}
  pigment_map{
   [0.0 p_metal3]
   [0.3 p_metal3]
   [1.0 p_metal2]
  }
 }
 normal{
  cells -1
  warp{turbulence 1 lambda 3}
 }
 finish{metallic}
 scale .1
}
#include "i_liter.inc"
object{litera scale .0099 translate <.45,-.9,1.8>}
#end

// exterior
sphere{0,1 hollow
 scale 1100000
 pigment{SummerSky}
}
plane{y,0
 pigment{White}
}
#declare r_sun=seed(1241);
#declare window_pos=<0,1.4,2.74>;
#declare sun_pos=vrotate(<0,1000000,0>,<20+60*rand(r_sun),-20+40*rand(r_sun),0>);
#declare hit_norm=<0,0,0>;
#declare sun_hit=trace(room,window_pos,window_pos-sun_pos,hit_norm);
//cylinder{sun_pos,sun_hit,.01 pigment{Red} no_shadow}
light_source{
 window_pos
 White+SummerSky*.25
 spotlight radius .1 falloff 30 tightness 200 point_at sun_hit
 #if (use_area)
 area_light <1,0,0>,<0,1,0>,10,10 jitter adaptive 1 orient
 #end
 fade_distance 1000000
 fade_power 2
}
light_source{
 window_pos-.16*z
 White*.5
 #if (use_area)
 area_light <1,0,0>,<0,1,0>,10,10 jitter adaptive 1 orient
 #end
 fade_distance 6
 fade_power 2
}
light_source{
 sun_pos,(White*2+Gold)*2
 fade_distance 10000000
 fade_power 2
}


// blobman character
#declare Hair=off; // Warning : Turning hair on increase parsing time !
#include "bmpeople.inc"
#include "bm_pose.inc"
#declare BM_EyeLids=<.35,0,.35>;
#declare BM_Jaw=.25;
#declare BM_Mouth=1;
#declare BM_MouthShape=1;
#declare BM_HairStyle=2*Hair;
#declare BM_PoseNo=2;
Blob_Man(Female,1.8)
object {BlobMan 
 	scale .7
        transform BMO_Abdomen_L
        rotate 180*y
	translate <-.2,.1,-.1>
}


camera{
 location <-.2,1.1,-2.5>
 up <0,3.2,0> right <2.4,0,0>
 direction 3.5*z
 look_at <0,.6,1>
 #if (use_blur)
  aperture .08
  blur_samples 8*8
  focal_point <0,0,-.1>
 #end
}
