// ======================================
// Persistence of Vision Ray Tracer 3.5
// ======================================
// "barren.pov" by Edward m. Blake - August 2002
// requires Gilles Tran's Make Grass include,
// and Tom Aust's tomtree package.
// run at +h280 +w720
// --------------------------------------
// I found POV in March of 2002, and this is
// my first attempt at creating a "complete" scene.
// --------------------------------------
// In addition to the two include files
// this scene needs four files to run: 
// mountain.bmp
// material.bmp
// spdrtree.inc
// grass.inc
// ======================================
#include "colors.inc"
#include "spdrtree.inc"
#include "TOMTREE.inc"
#include "mgrass.pov"

#declare global = true;       //activate radiosity
#declare focal = true;        //activate focal blur
#declare general_fog = true;  //activate atmospheric fog
#declare ground_fog = true;   //activate ground fog
#declare smoothed = true;     //activate HF smooth method
#declare grass = true;        //activate grass

#if (grass = true)
    #include "grass.inc"
#end

#if (global = true)
    // My first time using radiosity.
    // I don't think it is necessary in this scene,
    // but I have been wanting to use it.
    
    global_settings {
    max_trace_level 10
    radiosity {
        pretrace_start 0.08
        pretrace_end   0.04
        count 35

        nearest_count 5
        error_bound 1.8
        recursion_limit 3

        low_error_factor 0.5
        gray_threshold 0.0
        minimum_reuse 0.015
        brightness 1

        adc_bailout 0.01/2
    }
    }
#end

light_source{<-3000,4000,-3000> rgb<.75,.75,.78>}  //the dim and distant sun

camera{
    location <55,18,-25>
    rotate y*-10 
    look_at<0,30,0> //look up at the hill
    #if (focal = true)
        focal_point <1,21,-1> //focus on the tree
        aperture 3.55          //extreme blur
        blur_samples 30       //heavy sampling      
    #end
}

#declare Sky = sky_sphere { //the dark sky, altered from skysph1 example.
  pigment {
    gradient y
    color_map {
      [0.75  rgb<.02,.01,.35>] //dark
      [1.00  rgb<.03,.01,.25>] //and darker blue
    }
    scale 2
    translate <-1, -1, -1>
  }
  pigment {
    bozo
    turbulence 0.6
    octaves 7
    omega .49876
    lambda 2.5432
    color_map {
      [0.0 color rgbf<.75, .75, .75, 0.1>]
      [0.4 color rgbf<.9, .9, .9, .9>]
      [0.7 color rgbf<1, 1, 1, 1>]
    }
    scale 6/10
    scale <1, 0.3, 0.3>
  }
  pigment {
    bozo
    turbulence 0.6
    octaves 8
    omega .5123
    lambda 2.56578
    color_map {
      [0.0 color rgbf<.375, .375, .375, 0.2>]
      [0.4 color rgbf<.45, .45, .45, .9>]
      [0.6 color rgbf<0.5, 0.5, 0.5, 1>]
    }
    scale 6/10
    scale <1, 0.3, 0.3>
  }
  rotate y*130 //turn the sky so you can't see the turbulence origin
}

//the two week texture_map.  A gradient from green to yellowed grey.
#declare tex_map = texture {
     material_map {
        "material.bmp" //height field mountain.bmp converted to 256 color
        #declare color_level = 0;
        #while (color_level < 255)  
            #if (color_level <= 125)
                texture{
                        pigment{
                        rgb<.1+(color_level/130),.94,(color_level/135)> 
                        turbulence 0.5 lambda 1.5 omega 0.8 octaves 5
                        }
                        normal{ripples .5 turbulence .7 scale 10}
                        finish{roughness .5 specular .5 }
                    }
            #else
                texture{
                    pigment{
                    rgb<1.06+(.2*(color_level-126)/255),.94+(.7*(color_level-126)/255),.92+(.9*(color_level-126)/255)>
                    turbulence 0.5 lambda 1.5 omega 0.8 octaves 5
                    }
                    normal{ripples .75 turbulence .7 scale 5}
                    finish{roughness .5 specular .5 }
                }
            #end
            #declare color_level = color_level + 1;
        #end
    }
rotate x*90
}

//fog
#if (general_fog = true)
    fog {  //nice general fog, slightly yellow
        fog_type 1
        distance 100
        color rgbft<.6,.6,.5,.955,.8>
    } 
#end

#if (ground_fog = true)
    fog {  //ground fog, to hide the lack of details
        fog_type   2
        distance   10
        color      rgb <.67,.67,.62>
        fog_offset 0.1
        fog_alt    6.5
        turbulence 0.8
    }
#end

#declare mountains = height_field{
        "mountain.bmp"
        #if (smoothed = true)
            smooth
        #end
        texture{tex_map}
        translate <-.5, 0, -.5>
        scale y*50
        scale<100,1,100>
}


sky_sphere { Sky }
object{ mountains }
object{mountains scale<1.5,0,1.5> rotate y*-90 translate y*-.5}
object{TREE scale 25 translate<1,18.5,-1>}

// this grass caused me trouble to no end.  At the time I was doing this I had no idea
// how I could apply the grass objects to a surface.  I think that i could use the trace 
// function to do it, but I will leave that for my next image.

#if (grass = true)  
    #declare g_patch =
    object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
    texture{txtGrass scale 40}
    scale .01
    }
    #declare height = 16;
    #declare grass_levels = 51;
    #while (grass_levels <= 56)
        #declare rotation = 0;
        #while (rotation <= 19)
            object{g_patch rotate y*(rand(rd)*180) translate<grass_levels,16,0> rotate y*rotation no_shadow}        
            #declare rotation = rotation + 1;
        #end
        #declare grass_levels = grass_levels + (5/50);
    #end
         
#end

