// divers

#ifndef (_divers_inc_)
#declare _divers_inc_=on;

#macro Chamfrain_Box(Min, Max, Larg)

#local dist=min(min(Max.x-Min.x, Max.y-Min.y), Max.z-Min.z);
#if (2*Larg>dist)
	#local Larg=dist/2;
#end
intersection{
	box{Min, Max}
	plane{y,0 rotate x*45 translate <0,Max.y-Larg, Max.z>}
	plane{y,0 rotate -x*45 translate <0,Max.y-Larg, Min.z>}
	plane{-y,0 rotate x*45 translate <0,Min.y+Larg, Min.z>}
	plane{-y,0 rotate -x*45 translate <0,Min.y+Larg, Max.z>}
	plane{y,0 rotate z*45 translate <Min.x,Max.y-Larg, 0>}
	plane{y,0 rotate -z*45 translate <Max.x,Max.y-Larg, 0>}
	plane{-y,0 rotate z*45 translate <Max.x,Min.y+Larg, 0>}
	plane{-y,0 rotate -z*45 translate <Min.x,Min.y+Larg, 0>}
	plane{x,0 rotate y*45 translate <Max.x-Larg,0,Min.z>}
	plane{x,0 rotate -y*45 translate <Max.x-Larg,0,Max.z>}
	plane{-x,0 rotate y*45 translate <Min.x+Larg,0,Max.z>}
	plane{-x,0 rotate -y*45 translate <Min.x+Larg,0,Min.z>}
	bounded_by{box{Min-0.001, Max+0.001}}
}
#end

#macro Planche(LnP, EpP, LgP, Chamf, StP)
object{
	Chamfrain_Box(<-LnP/2,-EpP,-LgP/2>,<LnP/2,0,LgP/2>,Chamf)
	texture{
		pigment{
			wood ramp_wave turbulence .05 lambda 3
			rotate y*(87+6*rand(StP))
			scale LgP
			warp{turbulence .01*LgP lambda 2}
			translate <LnP*rand(StP),3*EpP+LgP*rand(StP),LgP*(2+2*rand(StP))>
			color_map{
				[0 rgb <.4,.2,.05>]
				#local i=0.05;
				#while(i<0.95)
					[i rgb (<.4,.2,.05>*(.8+.6*rand(StP))+<.5,.4,.2>*rand(StP))]
					#local i=i+0.05+.1*rand(StP);
				#end
				[1 rgb <.4,.2,.05>]
			}
		}
		normal{
			average
			normal_map{
				[1 wrinkles .2 scale <.5,1,.3>*LnP]
				[1 granite scale<LnP,1,LgP/3> slope_map{[.9 <1,0>][.9 <1,-1>][1 <0,-1>]}]
			}
		}
		finish{phong .1 phong_size 10 specular .3 roughness .01}
	}
}
#end

#macro Frisouille(Largeur,Nb)

	#local i=0;
	#local Larg=(Largeur)/Nb;

	union{
	#while(i<Largeur)
		intersection{
			union{
				cylinder{-.5*z,0,Larg*.4}
				torus{Larg*.4, .5 rotate x*90}
				cylinder{-.5*z,0,Larg*.25 translate .5*Larg*x}
				torus{Larg*.25, .5 rotate x*90 translate .5*Larg*x}
				union{
					cylinder{-.6*z,0,Larg*.45 translate .15*Larg*y}
					torus{Larg*.45, .1 rotate x*90 translate .15*Larg*y-.5*z }
					cylinder{-.6*z,0,Larg*.30 translate .5*Larg*x+.10*Larg*y}
					torus{Larg*.30, .1 rotate x*90 translate .5*Larg*x+.10*Larg*y-.5*z }
					texture{pigment{color rgb <0.843,0.682,0.114>}finish{diffuse 1.3 brilliance 1.1 specular .5 roughness .01 metallic}}
				}
				union{
					cylinder{-.65*z,0,Larg*.65 translate .45*Larg*y}
					torus{Larg*.65, .05 rotate x*90 translate .45*Larg*y-.6*z}
					texture{pigment{color rgb <0.686,0.541,0.024>}finish{diffuse 1.3 brilliance 1.1 specular .5 roughness .01 metallic}}
				}
				union{
					cylinder{-.69*z,0,Larg*.1 translate -.05*Larg*y}
					torus{Larg*.1, .04 rotate x*90 translate -.05*Larg*y-.65*z}
					texture{pigment{color rgb <0.686,0.541,0.024>*.8}finish{diffuse 1.3 brilliance 1.1 specular .5 roughness .01 metallic}}
				}
			}
			box{<-Larg*.41,-Larg*.41,-.70>,<Larg*.751,0,.01>}
			texture{pigment{color rgb <0.800,0.808,0.267>}finish{diffuse 1.3 brilliance 1.1 specular .5 roughness .01 metallic}}
			translate <i,0,0>
		}
		#local i=i+Larg;
	#end
	}
#end

#end // _divers_inc_
