// fauteuils

#declare Dlarg = 25;
#declare Dep = 4;
#declare Dhaut = 60;
#declare Along = 40;
#declare Alarg = 8;
#declare Ahaut = 20;
#declare Aalt = 40;
#declare FR = 4;
#declare Dang = 20;
#declare DR=Dlarg/sin(radians(Dang));

#declare Flarg=2*(Dlarg+FR+Alarg)*1.05;


#declare Dossier = union{
	intersection{
		union{
			difference{
				cylinder{0, Dhaut*y, DR+Dep}
				cylinder{-.001*y, Dhaut*y*1.001, DR-Dep}
			}
			difference{
				cylinder{-FR*y, (Dhaut+FR)*y, DR+Dep-FR}
				cylinder{-FR*y*1.01, (Dhaut+FR)*y*1.01, DR-Dep+FR}
			}
			torus{DR+Dep-FR, FR}
			torus{DR+Dep-FR, FR translate Dhaut*y}
			#if (FR < Dep)
			torus{DR-Dep+FR, FR}
			torus{DR-Dep+FR, FR translate Dhaut*y}
			#end
		}
		plane{z, 0 rotate y*Dang}
		plane{-z, 0 rotate -y*Dang}
	}
	union {
		sphere {<-Dep+FR,0,0>, FR}
		sphere {<+Dep-FR,0,0>, FR}
		sphere {<-Dep+FR,Dhaut,0>, FR}
		sphere {<+Dep-FR,Dhaut,0>, FR}
		cylinder {<-Dep+FR,0,0>, <-Dep+FR,Dhaut,0>, FR}
		#if (FR < Dep)
		box{<-Dep+FR,0,-FR>, <+Dep-FR,Dhaut,0>}
		cylinder {<-Dep+FR,0,0>, <+Dep-FR,0,0>, FR}
		cylinder {<-Dep+FR,Dhaut,0>, <+Dep-FR,Dhaut,0>, FR}
		cylinder {<+Dep-FR,0,0>, <+Dep-FR,Dhaut,0>, FR}
		#end
		translate -DR*x
		rotate -y*Dang
	}
	union {
		sphere {<-Dep+FR,0,0>, FR}
		sphere {<+Dep-FR,0,0>, FR}
		sphere {<-Dep+FR,Dhaut,0>, FR}
		sphere {<+Dep-FR,Dhaut,0>, FR}
		cylinder {<-Dep+FR,0,0>, <-Dep+FR,Dhaut,0>, FR}
		#if (FR < Dep)
		box{<-Dep+FR,0,0>, <+Dep-FR,Dhaut,+FR>}
		cylinder {<-Dep+FR,0,0>, <+Dep-FR,0,0>, FR}
		cylinder {<-Dep+FR,Dhaut,0>, <+Dep-FR,Dhaut,0>, FR}
		cylinder {<+Dep-FR,0,0>, <+Dep-FR,Dhaut,0>, FR}
		#end
		translate -DR*x
		rotate y*Dang
	}
	translate DR*x
}

#include "shapes.inc"

#declare Accoudoir=union{
	Round_Box(<0,Aalt,0>,<Along, Aalt+Ahaut, Alarg>, FR/2, off)
	box{<6, 0, FR/2>, <Along-15, Aalt, Alarg-FR/2>
		texture {
			pigment{rgb .2}
			normal{wrinkles 0.5 scale .5}
			finish{specular .3 roughness .01}
		}
	}
}


#declare Siege = superellipsoid{<.2,.2> translate x scale <Dhaut/2.5, 3*Dep/2, Dlarg>}


#declare Fauteuil=union{
	object{Dossier rotate z*15 translate Aalt*y}
	object{Accoudoir translate <0,0,Dlarg+FR>}
	object{Accoudoir scale <1,1,-1> translate <0,0,-Dlarg-FR>}
	object{Siege rotate z*60 translate <2.5*Dep, Aalt-10,0>}
	texture{
		 pigment{color rgb <0.675,0.129,0.090>}
		 normal{granite .1 scale .1}
	}
}


// example

/*
camera{
	location <100,180,-200>
	angle 40
	look_at <0, Dhaut/2, 0>
}

light_source{ <20,10,-10>*1000 rgb 1.5 }

object{Fauteuil}
object{Fauteuil translate Flarg*z}
object{Fauteuil translate -Flarg*z}

*/

