// HP

#include "divers.inc"
#include "functions.inc"

#local LnHP=80;
#local HtHP=130;
#local LgHP=50;
#local BHP=4;

#declare HP=union{
	difference{
		Chamfrain_Box(<-LnHP/2,0,0>,<LnHP/2,HtHP,LgHP>,1.5)
		box{<BHP-LnHP/2,BHP,-.01>,<-BHP+LnHP/2,HtHP-BHP,3>}
		texture{
			pigment{wood turbulence .15 rotate y*3 scale .7 color_map{[0 rgb<.4,.2,.05>][1 rgb<.5,.3,.1>]}}
			normal{wood poly_wave 4 turbulence .08 scale <.4,.4,3>}
			finish{phong .3 phong_size 5 specular .5 roughness .01}
			translate y*HtHP/3
		}
	}
	box{<BHP-LnHP/2,BHP,2.5>,<-BHP+LnHP/2,HtHP-BHP,2.7>
		texture{
			pigment{color rgb <0.741,0.506,0.220>*.7}
			finish{phong .3 phong_size 5 specular .5 roughness .01}
		}
	}
	union{
		cylinder{2.4*z, 2.5*z, LnHP*.4 translate y*(5+LnHP*.4)}
		cylinder{2.4*z, 2.5*z, LnHP*.2 translate y*(10+LnHP)}
		cylinder{2.4*z, 2.5*z, LnHP*.1 translate <-LnHP/2+BHP+5+LnHP*.1,HtHP-BHP-5-LnHP*.1>}
		texture{pigment{rgb .1}}
	}
	object{
		isosurface{
			#local Xper=.7;
			#local Zper=.7;
			#local XZratio=1;
			#local Wave=.1;
			#local Ythick=.1;
			function{f_mesh1(x,y,z,Xper,Zper,XZratio,Wave,Ythick)}
			threshold .1
			accuracy .00001
			max_gradient 1
			contained_by{box{<BHP-LnHP/2,-.2,2>,<-BHP+LnHP/2,-.1,HtHP-BHP>}}
		}
		rotate -x*90
		texture{
			pigment{rgb .1}
			finish{phong .7 phong_size 20}
		}
	}
}

