#declare R1=1.2;
#declare R2=1;
#declare H1=5;
#declare L1=25;
#declare L2=L1+R1*1.3;
#declare H2=65;
#declare H3=80;
#declare L3=60;
#declare Dec3=15;
#declare Ang1=30;
#declare Ang2=50;

#declare Decal=(R1*1.3 + L2*sin(radians(5)));


#include "shapes.inc"

#declare Tex1=texture{
	pigment{rgb .5}
	finish{reflection .5 specular .4 roughness .01}
}
#declare Tex2=texture{
	pigment{rgb .1}
	normal{granite .1 scale .1}
	finish{phong .4 phong_size 5}
}


#declare Pied1=union{
	cylinder{0, L1*x, R1 texture{Tex1}}
	union{
		cylinder{L1*.99*x, L2*x, R1*1.3}
		sphere{L2*x, R1*1.3}
		texture{Tex2}
	}
	rotate -z*5
	translate Decal*y
}

#declare Pied=union{
	object{Pied1}
	object{Pied1 rotate y*120}
	object{Pied1 rotate -y*120}
	cylinder{Decal*y, H2*y, R1 texture{Tex1}}
	union {
		sphere{0, R1*3 scale <1,.75,1>}
		sphere{0, R1*2 scale <1,.8,1> translate R1*y}
		cylinder{0, R1*4*y, R1*1.3}
		texture{Tex2}
		translate Decal*y
	}
	union{
		cylinder{(H2-5)*y, (H2+5)*y, R1*1.3}
		torus{R1*1.3-(R1*1.3-R2)/2, (R1*1.3-R2)/2 translate (H2+5)*y}
		torus{R1*1.3-(R1*1.3-R2)/2, (R1*1.3-R2)/2 translate -(H2+5)*y}
		texture{Tex2}
	}
	cylinder{(H2+4)*y, H3*y, R2 texture{Tex1}}
}

#declare Manche1=union{
	union{
		Round_Box(<-R2-.2,H3, -R2+.2>,<R2+.2,H3+10, R2-.2>, .2, off)
		texture{Tex2}
	}
	union{
		cylinder{-(R2+.8)*z, (R2+.8)*z, R2*.5}
		cylinder{-(R2+.8)*z, -(R2+1)*z, R2*.8}
		texture{Tex1}
		translate (H3+8.5)*y
	}
}

#declare Manche2=union{
	union{
		Round_Box(<-R2-2,-1.2,-R2+.2><R2,1.2,-R2-.8>,.2, off)
		Round_Box(<-R2-2,-1.2, R2-.2><R2,1.2, R2+.8>,.2, off)
		cylinder{<-R2-2,-5,0>, <-R2-2,5,0>, R1*1.1}
		torus{R1*1.1-(R1*1.1-R2)/2, (R1*1.1-R2)/2 translate <-R2-2,-5,0>}
		torus{R1*1.1-(R1*1.1-R2)/2, (R1*1.1-R2)/2 translate <-R2-2, 5,0>}
		texture{Tex2}
	}
	cylinder{<-R2-2,-L3/2,0>, <-R2-2,L3/2,0>, R2 translate Dec3*y texture{Tex1}}
	union{
		cylinder{<-R2-2,-L3/2+5,0>, <-R2-2,-L3/2,0>, R2*1.3}
		sphere{<-R2-2,-L3/2,0>, R2*1.3}
		texture{Tex2}
		translate Dec3*y
	}
	union{
		union{
			Round_Box(<-R2-.2,Dec3+L3/2, -R2+.2>,<R2+.2,Dec3+L3/2+10, R2-.2>, .2, off)
			texture{Tex2}
		}
		union{
			cylinder{-(R2+.8)*z, (R2+.8)*z, R2*.5}
			cylinder{-(R2+.8)*z, -(R2+1)*z, R2*.8}
			texture{Tex1}
			translate (Dec3+L3/2+8.5)*y
		}
		translate (-R2-2)*x
	}
	union{
		Round_Box(<-R2-2,-1.2,-R2+.2><R2,1.2,-R2-.8>,.2, off)
		Round_Box(<-R2-2,-1.2, R2-.2><R2,1.2, R2+.8>,.2, off)
		difference{
			cone{<-R2-2,-5,0>, R1*1.1, <-R2-2,5,0>, R1*1.5}
			cone{<-R2-2,-5.001,0>, R2*1.1, <-R2-2,5.001,0>, R2*1.5}
			box{<-R2-2-R1*1.6, -5.5,-R1*1.6>,<-R2-2-R2*.4,5.5,R1*1.6>}
		}
		torus{R1*1.1-(R1*1.1-R2*1.1)/2, (R1*1.1-R2*1.1)/2 translate <-R2-2,-5,0>}
		torus{R1*1.5-(R1*1.5-R2*1.5)/2, (R1*1.1-R2*1.5)/2 translate <-R2-2, 5,0>}
		texture{Tex2}
		rotate -Ang2*z
		translate (-R2-2)*x + (Dec3+L3/2+8.5)*y
	}
}

#declare R3=R2*2.5;

#declare BouleMic=union{
	sphere{0, R3*.95 texture{Tex2}}
	union{
		#local i=0;
		#while (i<.7)
			torus{R3*.95*cos(asin(i)), R3*.05 scale <1,.7,1> translate i*R3*y}
			#if (i>0)
			torus{R3*.95*cos(asin(i)), R3*.05 scale <1,.7,1> translate -i*R3*y}
			#end
			torus{R3*.95*cos(asin(i)), R3*.05 scale <1,.7,1> rotate x*90 translate i*R3*z}
			#if (i>0)
			torus{R3*.95*cos(asin(i)), R3*.05 scale <1,.7,1> rotate x*90 translate -i*R3*z}
			#end
			torus{R3*.95*cos(asin(i)), R3*.05 scale <1,.7,1> rotate z*90 translate i*R3*x}
			#if (i>0)
			torus{R3*.95*cos(asin(i)), R3*.05 scale <1,.7,1> rotate z*90 translate -i*R3*x}
			#end
			#local i=i+.15;
		#end
		texture{Tex1}
	}
}

#declare Micro=union{
	cone{<0,-10,0>, (R2*1.1)-.5*R2*(1.5-1.1), <0,10,0>, R2*1.5+.5*R2*(1.5-1.1) texture{Tex1}}
	cone{<0,-10,0>, R2*.5, <0,-12,0>, R2*.4  texture{Tex2}}
	cone{<0,8,0>, R2*1.55+.3*R2*(1.5-1.1), <0,10,0>, R2*1.55+.5*R2*(1.5-1.1) texture{Tex2}}
	object{BouleMic translate <0,10+R2*1.2> texture{Tex1}}
	translate <-R2-2,0,0>
	rotate -Ang2*z
	translate (-R2-2)*x + (Dec3+L3/2+8.5)*y
}
#declare PM0=<0,-10,0>+<-R2-2,0,0>;
#declare PM1=<0,-12,0>+<-R2-2,0,0>;
#declare PM0=vrotate(PM0, <0,0,-Ang2>);
#declare PM1=vrotate(PM1, <0,0,-Ang2>);
#declare PM0=PM0+<-R2-2,(Dec3+L3/2+8.5),0>;
#declare PM1=PM1+<-R2-2,(Dec3+L3/2+8.5),0>;
#declare PM0=vrotate(PM0, <0,0,-Ang1>);
#declare PM1=vrotate(PM1, <0,0,-Ang1>);
#declare PM0=PM0+<-R2-2,(H3+8.5),0>;
#declare PM1=PM1+<-R2-2,(H3+8.5),0>;

#declare PiedMicro=union{
	object{Pied}
	object{Manche1}
	union{
		object{Manche2}
		object{Micro}
		rotate -Ang1*z translate (H3+8.5)*y
	}
	sphere_sweep{
		b_spline
		23,
		PM0+2*(PM0-PM1), R2*.3,
		PM0+(PM0-PM1), R2*.3,
		PM0, R2*.3,
		PM1, R2*.3,
		PM1+(PM1-PM0), R2*.3,
		PM1+(PM1-PM0)-<2,2,0>, R2*.3,
		PM1+(PM1-PM0)-<3,4,0>, R2*.3,
		PM1+(PM1-PM0)-<4,8,0>, R2*.3,
		<PM1.x-10,H2*.8,2>, R2*.3,
		<PM1.x-8,H2*.6,3>, R2*.3,
		<PM1.x-11,H2*.3,5>, R2*.3,
		<PM1.x-12,R2*.5,10>, R2*.3,
		<PM1.x-12,R2*.3,15>, R2*.3,
		<0,R2*.3,20>, R2*.3,
		<12,R2*.3,30>, R2*.3,
		<20,R2*.3,20>, R2*.3,
		<40,R2*.3,25>, R2*.3,
		<60,R2*.3,40>, R2*.3,
		<100,R2*.3,10>, R2*.3,
		<150,R2*.3,60>, R2*.3,
		<250,R2*.3,20>, R2*.3,
		<400,R2*.3,-60>, R2*.3
		<500,R2*.3,90>, R2*.3
		texture{Tex2}
	}
}


/*
plane{ y,0 pigment{rgb <.8,.5,.3>}}

light_source{ y*400, rgb <1,1,.6>*1.5
	spotlight
	radius 20 falloff 40 tightness 5
	rotate -x*20 rotate y*30
}

camera{
	location <-50,300, -400>
	angle 30
	look_at <0,H3*.8,0>
	rotate y*40
}

object{PiedMicro}

*/

