// scene


#include "divers.inc"


#macro Plancher(Min, Max, LnP, EpP, LgP, Chamf, Emax, Sd)

#local StP=seed(Sd);

#local j=Min.z+LgP/2;
#local Dec=0;
#local Dem=0;

#while(j<Max.z)
	#local Ecart=0;
	#local i=Min.x-rand(StP)*.1*LnP;
	#while(i<Max.x)
		#local D=Emax*rand(StP);
		object{Planche(LnP, EpP, LgP, Chamf, StP)
			rotate x*(1-2*rand(StP))*.5
			translate <i+Dem*LnP/2,Max.y+Emax*0.1*rand(StP),j+D>
		}
		#if (D>Dec) #local Dec=D; #end
		#local i=i+LnP+2*Emax*rand(StP);
	#end
	#local j=j+LgP+Dec;
	#local Dem=1-Dem;
#end
#end


/*
#local Xmin=-600;
#local Xmax=600;
#local Zmax=400;
#local Ys=100;
*/

union{
	Plancher(<Xmin,Ys,0>,<Xmax,Ys,Zmax+20>, 200,5,15,.3,.2,1342)
	union{
		cylinder{<Xmin,Ys,0>,<Xmax,Ys,0>,.5}
		cylinder{<Xmin,Ys,5>,<Xmax,Ys,5>,.5}
		cylinder{<Xmin,Ys-5,0>,<Xmax,Ys-5,0>,.5}
		box{<Xmin,Ys-5,-.5>,<Xmax,Ys,0>}
		box{<Xmin,Ys,0>,<Xmax,Ys+.5,5>}
		texture{
			pigment{rgb .1}
			normal{wrinkles .6 scale .5}
			finish{specular .7 roughness .01}
		}
	}
	box{<Xmin,0,0>,<Xmax,Ys,1>
		texture{
			pigment{color rgb <0.573,0.169,0.125>}
			normal{wrinkles 0.9 sine_wave scale 1.5 turbulence .5}
			finish{brilliance 1.5}
		}
	}
	object{
		Frisouille(Xmax-Xmin,50)
		translate <Xmin, Ys-5,0>
	}
	#local Chuchoteur=intersection{
		difference{
			cylinder{-35*x, 35*x, 20}
			cylinder{-34*x, 34*x, 19}
		}
		box{<-35.01,20.01,0>,<35.01,0,-20.01>}
		texture{
			pigment{color rgb <0.325,0.227,0.075>}
			normal{wrinkles 1.5 poly_wave 4 scale <20,.3,2>}
			finish{phong .3 phong_size 5 specular .5 roughness .01}
		}
	}
	object{Chuchoteur translate <Xmin*.4,Ys,20+10>}
	object{Chuchoteur translate <Xmax*.4,Ys,20+10>}
}


/*
camera{
	location -700*z+300*y
	angle 30
	look_at <0,Ys-30,100>
	rotate -y*30
}
light_source{ < 200, 300, -200>, rgb <1,1,.7>*1.4}
light_source{ <-200, 300, -200>, rgb <.7,.7,1>*1.3}

#include "hp.inc"
object{HP translate <0,Ys,20>}

*/
