//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 27 materials and 405 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//  Date : 08/29/2002    (29.08.2002)
//

/*Automatic Inclusions for all Moray scenes*/
#declare Handed="RHC"
/*End of automatic inclusions.*/

/* // Scene Comment

Copyright 2002 by Charles Fusner

*/ // End Scene Comment


// Scene Includes

#include "C:\cffiles\projects\povalone\skytests.inc"

// End Scene Includes

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.2
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

background { color <0.255,0.263,0.259> }

camera {  //  Camera camMainView
  location  <    -50.000,     -35.000,       4.200>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33558,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         12.27738    // Vertical       9.208
  look_at   <    -16.401,     -13.450,       4.450>
}

//
// *******  L I G H T S *******
//

light_source {   // pltStdLight2
  <0.0, 0.0, 0.0>
  color rgb <0.929, 0.929, 1.000>*0.1500
  shadowless
  media_interaction off
  translate  <61.686246, 54.996029, 20.0>
}

light_source {   // pltStdLight1
  <0.0, 0.0, 0.0>
  color rgb <0.929, 0.929, 1.000>*0.3000
  shadowless
  media_interaction off
  translate  <48.446463, -27.384844, 20.0>
}

light_source {   // pltStdLight
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.950>*0.5500
  media_interaction off
  translate  <-113.221861, 3.537135, 20.0>
}


//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//
// ********  MATERIALS  *******
//

#include "lonely.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare boxStep1 = object {
  box { // boxStep1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.0, 0.75>
    translate  <-13.999899, -17.160075, 0.0>
  }
}




//
// ********  OBJECTS  *******
//

#include "C:\cffiles\projects\povalone\bigbolt_sw.inc"

#declare BranchA_Ref = object {
  BranchA
  hollow
}
#declare BranchB_Ref = object {
  BranchB
  hollow
}
#declare BranchC_Ref = object {
  BranchC
  hollow
}
#declare BranchD_Ref = object {
  BranchD
  hollow
}
#declare BranchE_Ref = object {
  BranchE
  hollow
}
#declare LongBolt_Ref = object {
  LongBolt
  hollow
}
#declare BranchF_Ref = object {
  BranchF
  hollow
}
#declare BranchG_Ref = object {
  BranchG
  hollow
}
#declare BranchH_Ref = object {
  BranchH
  hollow
}
union { // Lightning1
  object { BranchA_Ref }
  object { BranchB_Ref }
  object { BranchC_Ref }
  object { BranchD_Ref }
  object { BranchE_Ref }
  object { LongBolt_Ref }
  object { BranchF_Ref }
  object { BranchG_Ref }
  object { BranchH_Ref }
  hollow
  scale 1.2
  rotate -180.0*z
  translate  <12833.05665, 9821.355434, 600.0>
  material {
    Lightning
    // Transform to world space
  }
}


object {   // hfIsland
  height_field {
    tga "C:\cffiles\projects\povalone\smallisland.tga"
    water_level 0.05
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <6.0, 6.0, 0.9>
  rotate <0.0, -0.0, -21.307144>
  translate  <-0.895749, -0.485049, 0.517119>
  material {
    IslandMaterials
    scale <1.0, 1.0, 1.9>
    translate <0.000000, 0.000000, -0.175000>
    // Transform to world space
  }
}








#include "C:\cffiles\projects\povalone\lilbolt_sw.inc"

#declare LilBolt_Ref = object {
  LilBolt
  hollow
}
#declare BranchX_Ref = object {
  BranchX
  hollow
}
#declare BranchY_Ref = object {
  BranchY
  hollow
}
#declare BranchZ_Ref = object {
  BranchZ
  hollow
}
union { // Lightning2
  object { LilBolt_Ref }
  object { BranchX_Ref }
  object { BranchY_Ref }
  object { BranchZ_Ref }
  material {
    Lightning
  }
  hollow
  translate  <12084.600571, 7000.0, 800.0>
}


box { // cubPlank
  <-1, -1, -1>, <1, 1, 1>
  scale <7.0, 1.0, 0.3>
  rotate <-2.715455, -1.245997, -32.577404>
  translate  <293.344493, 174.715828, -0.1>
  material {
    matBarrelBody
    // Transform to world space
  }
}


plane { // plnWaterLevel
  z,0
  hollow
  translate  0.1*z
  material {
    matWaterplane
    // Transform to world space
  }
}


sphere { // sphWaterfloor
  <0,0,0>,1
  scale <10000.0, 10000.0, 0.001>
  translate  -25.0*z
  material {
    matLakeBottom
    // Transform to world space
  }
}


#declare ExteriorShapeDif = difference {
  sphere { // Sphere001
    <0,0,0>,1
    scale <1.9, 0.5, 1.0>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <2.1, 0.6, 0.7>
    translate  0.4*z
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.6, 0.3>
    translate  -0.96*z
  }
}
#declare Exterior = intersection {
  object { ExteriorShapeDif }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale <2.0, 0.75, 1.0>
    rotate -90.0*x
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.6, 0.7>
    translate  <0.583484, 0.0, -0.055117>
  }
}
#declare InteriorShapeDif = difference {
  sphere { // Sphere002
    <0,0,0>,1
    scale <2.0, 0.5, 1.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <2.1, 0.6, 0.7>
    translate  0.4*z
  }
}
#declare Interior = intersection {
  object { InteriorShapeDif }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale <2.0, 0.75, 1.0>
    rotate -90.0*x
  }
  scale 0.95
}
#declare BoatDif = difference {
  object { Exterior }
  object { Interior }
  material {
    BoatWood
    // Transform to parent space
  }
}
#declare RowingBenches = union {
  box { // Bench1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, -0.45, 0.02>
    translate  <0.648667, 0.0, -0.4>
  }
  box { // Bench2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, -0.45, 0.02>
    translate  <-0.233272, 0.0, -0.4>
  }
  box { // BackEnd
    <-1, -1, -1>, <1, 1, 1>
    scale <0.175, -0.45, 0.02>
    rotate 90.0*y
    translate  <-0.903919, 0.0, -0.484963>
  }
  box { // Bench4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, -0.45, 0.02>
    translate  <1.62303, 0.0, -0.335>
  }
  box { // Floor
    <-1, -1, -1>, <1, 1, 1>
    scale <0.9, -0.45, 0.01>
    translate  -0.65*z
  }
}
#declare ShapeDif = difference {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale <2.0, 0.75, 1.0>
    rotate -90.0*x
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale <1.89, 0.49, 0.99>
  }
}
#declare BenchDif = difference {
  object { RowingBenches }
  object { ShapeDif }
}
#declare CSG006 = difference {
  torus { // Torus001
    0.03, 0.007  rotate -x*90
    // All transformations fixed
    rotate -90.0*x
    translate  0.28*z
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.04, 0.02, 0.02>
    translate  0.31*z
  }
  // All transformations fixed
}
#declare PaddleBlade = intersection {
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.1, 0.5, 0.01>
    translate  0.25*y
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 0.02>
    translate  <0.0, -0.25, -0.005>
  }
  // All transformations fixed
  rotate 90.0*x
  translate  1.5*z
}
#declare Paddle1 = union {
  cone { // Cone001
    <0,0,0>, 0.015, <0,0,1>, 0.01
    // All transformations fixed
    scale <1.0, 1.0, 1.5>
  }
  superellipsoid { // SuperQ001
    <1.0, 0.1>
    // All transformations fixed
    scale <0.01, 0.01, 0.1>
  }
  object { PaddleBlade }
  translate  -0.35*z
  material {
    DMFLightOak
  }
  // Scaling fixed
  // Rot X limited (75.0 to   150.0)
  // Rot Y limited (-90.0 to   45.0)
  // Translation fixed
  rotate <130.0, -62.0, 0.0>
  translate  0.271*z
}
#declare Lock1 = union {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.007, 0.007, 0.05>
    translate  0.2*z
  }
  object { CSG006 }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.015, 0.01>
    translate  0.2*z
  }
  object { Paddle1 }
  translate  -0.28*z
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate 14.689113*z
  translate  <0.0, -0.468554, 0.281682>
}
#declare CSG007 = difference {
  torus { // Torus002
    0.03, 0.007  rotate -x*90
    // All transformations fixed
    rotate -90.0*x
    translate  0.28*z
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.04, 0.02, 0.02>
    translate  0.31*z
  }
  // All transformations fixed
}
#declare PaddleBlade1 = intersection {
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.1, 0.5, 0.01>
    translate  0.25*y
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 0.02>
    translate  <0.0, -0.25, -0.005>
  }
  // All transformations fixed
  rotate 90.0*x
  translate  1.5*z
}
#declare Paddle2 = union {
  cone { // Cone002
    <0,0,0>, 0.015, <0,0,1>, 0.01
    // All transformations fixed
    scale <1.0, 1.0, 1.5>
  }
  superellipsoid { // SuperQ002
    <1.0, 0.1>
    // All transformations fixed
    scale <0.01, 0.01, 0.1>
  }
  object { PaddleBlade1 }
  translate  <0.0, 0.0, -0.35>
  material {
    DMFLightOak
  }
  // Scaling fixed
  // Rot X limited (-150.0 to   -75.0)
  // Rot Y limited (-45.0 to   90.0)
  // Translation fixed
  rotate <-110.0, 30.0, 0.0>
  translate  <0.0, -0.001471, 0.271>
}
#declare Lock2 = union {
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.007, 0.007, 0.05>
    translate  0.2*z
  }
  object { CSG007 }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.05, 0.015, 0.01>
    translate  0.2*z
  }
  object { Paddle2 }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate -27.896605*z
  translate  0.465*y
}
#declare PaddlesAndLocks = union {
  object { Lock1 }
  object { Lock2 }
  translate  -0.5*z
}
union { // ROWING_BOAT
  object { BoatDif }
  object { BenchDif }
  object { PaddlesAndLocks }
  scale 2.0
  rotate <-0.92116, -0.466589, -1.418231>
  translate  <36.011102, 13.23201, 1.1>
  material {
    BoatWood
    // Transform to parent space
  }
}


#declare HullA = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.0, 2.839089>,
  <-1.0, 0.663076>,
  <-1.0, -4.507456>,
  <-0.1475, -5.328463>,
  <1.0, -4.567708>,
  <1.0, 0.611241>,
  <0.0, 2.839089>,
  <-1.0, 0.663076>,
  <-1.0, -4.507456>
  rotate -x*90
  scale <17.825983, 14.346732, 10.166193>
  rotate -90.0*z
  translate  <7.549133, -2.269048, -7.582842>
}
#declare HullB = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.0, 2.839089>,
  <-1.0, 0.663076>,
  <-1.0, -4.507456>,
  <-0.1475, -5.328463>,
  <1.0, -4.567708>,
  <1.0, 0.611241>,
  <0.0, 2.839089>,
  <-1.0, 0.663076>,
  <-1.0, -4.507456>
  rotate -x*90
  scale <17.954964, 13.825254, 4.115042>
  rotate -90.0*z
  translate  <0.635177, -1.771971, 0.141767>
  material {
    B1_Planks_1
    // Transform to world space
    translate  <-311.509544, -211.346555, 5.0>
    rotate 122.339714*z rotate -2.5*y rotate 3.1*x
  }
}
#declare csgHull = difference {
  object { HullA }
  object { HullB }
  material {
    C2_RoughWoodA_1
    // Transform to world space
    translate  <-311.509544, -211.346555, 5.0>
    rotate 122.339714*z rotate -2.5*y rotate 3.1*x
  }
}
#declare Steps = union {
  object { boxStep1 }
  object { // boxStep2 -> boxStep1
    boxStep1
    scale <1.0, 1.0, 1.5>
    translate  <-2.0, 0.0, 0.246303>
  }
  object { // boxStep3 -> boxStep1
    boxStep1
    scale <1.0, 1.0, 2.0>
    translate  <-4.0, 0.0, 0.492607>
  }
  object { // boxStep4 -> boxStep1
    boxStep1
    scale <1.0, 1.0, 2.5>
    translate  <-6.0, 0.0, 0.73891>
  }
  object { // boxStep5 -> boxStep1
    boxStep1
    scale <1.0, 1.0, 3.0>
    translate  <-8.0, 0.0, 0.985213>
  }
  object { // boxStep6 -> boxStep1
    boxStep1
    scale <1.0, 1.0, 3.5>
    translate  <-10.0, 0.0, 1.231517>
  }
  object { // boxStep7 -> boxStep1
    boxStep1
    scale <1.0, 1.0, 4.0>
    translate  <-12.0, 0.0, 1.47782>
  }
  object { // boxStep8 -> boxStep1
    boxStep1
    scale <1.0, 1.0, 4.5>
    translate  <-14.0, 0.0, 1.724123>
  }
  object { // boxStep9 -> boxStep1
    boxStep1
    scale <1.0, 1.0, 5.0>
    translate  <-16.0, 0.0, 1.970427>
  }
  box { // boxCabinRoof
    <-1, -1, -1>, <1, 1, 1>
    scale <10.2, 15.2, 0.25>
    translate  <-21.799393, 0.619544, 7.342135>
  }
  translate  -26.712236*x
  material {
    C2_RoughWoodA_1
    // Transform to world space
    translate  <-311.509544, -211.346555, 5.0>
    rotate 122.339714*z rotate -2.5*y rotate 3.1*x
  }
}
#declare latSailFurl = lathe {
  quadratic_spline
  7  // control points
  <-5.920059, -8.226247>,
  <0.161305, -12.252207>,
  <1.347481, -3.402721>,
  <2.07672, 1.688983>,
  <1.402846, 5.716197>,
  <0.701898, 14.566655>,
  <0.072162, 15.427613>
  rotate <90,0,90>
  scale <0.75, 0.45, 1.3>
  rotate -90.0*x
  translate  <0.0, -2.868378, 10.973512>
  material {
    SailClothFurled
    rotate <-93.099998, 2.5, -128.007004>
    // Transform to world space
    translate  <-311.509544, -211.346555, 5.0>
    rotate 122.339714*z rotate -2.5*y rotate 3.1*x
  }
}
#declare bzTornSail = object {   object {
    bicubic_patch { 
        type 1 flatness 0.0100 u_steps 3 v_steps 3
        uv_vectors <0,1> <0,0> <1,0> <1,1>,
      <-2.011335, -1.975470, -0.084926>, <-1.011335, -2.005641, 0.145268>, <-0.011335, -1.975470, -0.115097>, <1.147181, -1.860167, -0.734160>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.060342, 0.150855>, <1.183046, -0.996067, 0.316240>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, -0.060342, 0.150855>, <1.158516, 0.145474, 0.708464>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 0.969829, 0.060342>, <0.000000, 0.969829, 0.301711>, <1.158516, 1.145474, 0.708464>
    }
  }
  material {
    SailTorn
  }
  scale <1.0, 4.5, 1.0>
  rotate 90.0*y
  translate  <0.366848, 2.138221, 33.00643>
}
#declare csgCabin = difference {
  box { // boxCabinBody
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 4.0>
    translate  <-48.511629, 1.0, 3.5>
    material {
      B1_Planks_1
      scale 0.25
      rotate <93.099998, 2.5, 0.0>
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  box { // boxDoorCut
    <-1, -1, -1>, <1, 1, 1>
    material {
      blackinterior
    }
    scale <2.0, 2.0, 3.2>
    translate  <-40.307388, -0.423699, 2.631615>
  }
}
#include "C:\cffiles\projects\povalone\sweeps.inc"

#declare Rope1_Ref = object {
  Rope1
}
#declare Rope2_Ref = object {
  Rope2
}
#declare Ropes = union {
  object { Rope1_Ref }
  object { Rope2_Ref }
}
#declare hfSnappedMast = object { 
  height_field {
    tga "C:\cffiles\projects\povalone\smallisland.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <1.4, 1.4, 2.0>
  translate  <0.0, 218.3536, 10.430666>
}
#declare csgSnappedMast = union {
  cylinder { // cylSnappedMast
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 15.0>
    translate  <0.0, 218.258574, -6.41937>
  }
  object { hfSnappedMast }
  box { // boxSnappedMast
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.999026, 0.250122>
    rotate <1.032841, -0.0, -0.0>
    translate  <-0.058974, 218.283762, 6.640575>
    material {
      C2_RoughWoodA_1
      // Transform to world space
      translate  <-138.004125, -63.330517, -5.808037>
      rotate -127.970566*z rotate 0.904752*y rotate -0.403968*x
      scale <1.0/0.5, 1.0/0.5, 1.0/1.0>
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  scale <0.5, 0.5, 1.0>
  rotate <0.403968, -0.904752, 127.970566>
  translate  <138.004125, 63.330517, 5.808037>
  material {
    C2_RoughWoodA_1
    // Transform to world space
    translate  <-311.509544, -211.346555, 5.0>
    rotate 122.339714*z rotate -2.5*y rotate 3.1*x
  }
}
#declare hfSnappedMast1 = object { 
  height_field {
    tga "C:\cffiles\projects\povalone\smallisland.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <1.4, 1.4, 2.0>
  translate  <0.0, 218.3536, 10.430666>
}
#declare csgSnappedMast1 = union {
  cylinder { // cylSnappedMast1
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 30.0>
    translate  <0.0, 218.258574, -21.5>
  }
  object { hfSnappedMast1 }
  scale <0.5, 0.5, 1.0>
  rotate <74.062416, 50.543488, -124.47554>
  translate  <-11.696572, 68.369841, -60.01129>
  material {
    C2_RoughWoodA_1
    // Transform to world space
    translate  <-311.509544, -211.346555, 5.0>
    rotate 122.339714*z rotate -2.5*y rotate 3.1*x
  }
}
#declare hfSnappedMast2 = object { 
  height_field {
    tga "C:\cffiles\projects\povalone\smallisland.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <1.4, 1.4, 2.0>
  translate  <0.0, 218.3536, 10.430666>
}
#declare csgSnappedMast2 = union {
  cylinder { // cylSnappedMast2
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 30.0>
    translate  <0.0, 218.258574, -21.5>
  }
  object { hfSnappedMast2 }
  scale <0.5, 0.5, 1.0>
  rotate <266.710358, -220.423187, -94.851898>
  translate  <108.117798, -117.827961, -75.581915>
  material {
    C2_RoughWoodA_1
    // Transform to world space
    translate  <-311.509544, -211.346555, 5.0>
    rotate 122.339714*z rotate -2.5*y rotate 3.1*x
  }
}
union { // grpSunkenShip
  object { csgHull }
  cylinder { // cylRearMast
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 20.0>
    translate  -49.515765*x
    material {
      C2_RoughWoodA_1
      rotate -90.0*y
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  box { // boxLintel
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.30778, 0.25>
    translate  <-38.490951, -0.379065, 5.811062>
    material {
      C2_RoughWoodA_1
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  object { Steps }
  cylinder { // Rigging1
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    rotate -60.0*x
    translate  <0.0, -6.973489, 35.086825>
    material {
      RopeTexture
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  object { latSailFurl }
  cylinder { // cylRearMastB
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.2, 30.0>
    rotate <-90.004196, -4.999997, 0.072065>
    translate  <-49.494124, -13.281648, 15.267079>
    material {
      C2_RoughWoodA_1
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  box { // boxUprightR
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.25, 3.0>
    translate  <-38.490951, 1.687289, 2.551463>
    material {
      C2_RoughWoodA_1
      rotate -90.0*x
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  box { // boxUprightL
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.25, 3.0>
    translate  <-38.490951, -2.445418, 2.551463>
    material {
      C2_RoughWoodA_1
      rotate -90.0*x
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  cylinder { // Rigging3
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 20.0>
    rotate -77.0*x
    translate  <0.0, -19.527903, 11.064122>
    material {
      RopeTexture
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  cylinder { // Rigging2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 8.0>
    rotate 60.0*x
    translate  <0.0, 6.889447, 35.086255>
    material {
      RopeTexture
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  box { // boxMainMastE
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 3.0, 0.25>
    translate  15.883972*z
    material {
      B1_Planks_1
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  cylinder { // Rigging12
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 20.0>
    rotate <55.726578, 3.038102, 4.455745>
    translate  <-1.907717, 16.433939, -1.617573>
    material {
      RopeTexture
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  cylinder { // Rigging11
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 20.0>
    rotate <56.519653, -3.150479, -4.515142>
    translate  <2.106601, 16.488266, -1.376152>
    material {
      RopeTexture
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  cylinder { // Rigging10
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 20.0>
    rotate <56.201801, -7.806617, -11.296899>
    translate  <5.095968, 15.944999, -1.442498>
    material {
      RopeTexture
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  cylinder { // Rigging9
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 20.0>
    rotate <-56.097439, -4.432103, 6.27597>
    translate  <2.919856, -16.438719, -1.511427>
    material {
      RopeTexture
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  cylinder { // Rigging8
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 20.0>
    rotate <-56.47686, -9.061416, 13.171951>
    translate  <5.83044, -15.847055, -1.528637>
    material {
      RopeTexture
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  cylinder { // Rigging7
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 20.0>
    rotate <-56.901798, 4.476467, -6.317196>
    translate  <-2.643776, -16.674463, -1.431927>
    material {
      RopeTexture
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  cylinder { // Rigging6
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 20.0>
    rotate <53.050442, 7.573765, 10.882954>
    translate  <-4.83866, 15.535403, -2.332764>
    material {
      RopeTexture
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  cylinder { // Rigging5
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 20.0>
    rotate <-56.500137, 9.15907, -13.318982>
    translate  <-5.868499, -15.908858, -1.28118>
    material {
      RopeTexture
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  cylinder { // Rigging4
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 20.0>
    rotate 77.0*x
    translate  <0.0, 19.733723, 11.01358>
    material {
      RopeTexture
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  cylinder { // cylMainMastC
    <0,0,1>, <0,0,0>, 1 
    material {
      C2_RoughWoodA_1
    }
    scale <0.6, 0.2, 40.0>
    rotate -90.0*x
    translate  <0.021641, -19.749407, 10.9072>
  }
  box { // boxMainMastD
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.25>
    translate  <0.0, 0.054327, 9.561732>
    material {
      C2_RoughWoodA_1
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  cone { // conMainMastA
    <0,0,0>, 0.5, <0,0,1>, 0.1
    scale <1.0, 1.0, 40.0>
    material {
      C2_RoughWoodA_1
      rotate -90.0*y
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  cylinder { // cylMainMastB
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.2, 15.0>
    rotate -90.0*x
    translate  <0.0, -7.621032, 35.074168>
    material {
      C2_RoughWoodA_1
      // Transform to world space
      translate  <-311.509544, -211.346555, 5.0>
      rotate 122.339714*z rotate -2.5*y rotate 3.1*x
    }
  }
  object { bzTornSail }
  object { csgCabin }
  object { Ropes }
  object { csgSnappedMast }
  object { csgSnappedMast1 }
  object { csgSnappedMast2 }
  no_shadow
  hollow
  rotate <-3.1, 2.5, -122.339714>
  translate  <311.509544, 211.346555, -5.0>
}


#declare latBarrelBody = lathe {
  cubic_spline
  4  // control points
  <0.328486, -12.9935>,
  <6.965615, -8.238121>,
  <6.895673, 8.657772>,
  <0.042939, 14.606747>
  rotate <90,0,90>
  material {
    matBarrelBody
    // Transform to parent space
  }
}
#declare grpBands = union {
  torus { // torBand1
    7.0, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  8.22065*z
  }
  torus { // torBand2
    7.7, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  3.120291*z
  }
  torus { // torBand3
    7.7, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  -2.633044*z
  }
  torus { // torBand4
    7.1, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  -7.852431*z
  }
}
#declare cprsX = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <-1.971128, 2.441839, 7.034477>
}
#declare cprsX1 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <-0.443254, 2.411281, 7.034477>
}
#declare cprsX2 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <1.145736, 2.411281, 7.034477>
}
#declare cprsX3 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <2.612496, 2.411281, 7.034477>
}
#declare csgdBarrelTop = difference {
  cylinder { // cylEndCap1
    <0,0,1>, <0,0,0>, 1 
    scale <1.005466, 1.0, 0.58386>
    translate  <0.0, 0.0, -0.673356>
    scale <6.9, 6.9, 1.540831>
    translate  8.701642*z
    material {
      matBarrelBody
      // Transform to parent space
    }
  }
  cone { // conTopCut
    <0,0,0>, 6.7, <0,0,1>, 6.6
    translate  8.003203*z
    material {
      matEndWood
      rotate -90.0*z
      translate <-0.058168, -2.152207, -0.004307>
      // Transform to parent space
    }
  }
  object { cprsX }
  object { cprsX1 }
  object { cprsX2 }
  object { cprsX3 }
  material {
    matEndWood
    // Transform to parent space
  }
}
#declare csgdBarrelBottom = difference {
  cylinder { // cylEndCap2
    <0,0,1>, <0,0,0>, 1 
    scale <6.94, 6.94, 0.89522>
    translate  -8.234364*z
    material {
      matEndWood
      // Transform to parent space
    }
  }
  cone { // conBottomCap
    <0,0,0>, 6.8, <0,0,1>, 6.7
    translate  -8.793643*z
  }
  material {
    matEndWood
    // Transform to parent space
  }
}
#declare grpTap = union {
  superellipsoid { // sqTap
    <1.0, 0.1>
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.0, -0.026919, 0.818766>
    scale <0.15, 0.15, 1.0>
    rotate <80.621185, 90.0, 0.0>
    translate  <3.192497, 0.004038, 3.323912>
  }
  superellipsoid { // sqTapB
    <1.0, 0.1>
    scale <0.35, 0.35, 1.5>
    rotate 90.0*y
    translate  <2.841847, 0.0, 2.444599>
  }
  cylinder { // cylTapB
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
    translate  <3.758571, 0.0, 1.461608>
  }
  cylinder { // cylTapC
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.0>
    translate  <3.197594, 0.0, 2.305224>
  }
  material {
    matIronDull
  }
  rotate <-90.0, -90.0, 0.0>
  translate  <0.042485, -5.333474, 6.601886>
}
union { // grpKeg
  object { latBarrelBody }
  object { grpBands }
  object { csgdBarrelTop }
  object { csgdBarrelBottom }
  object { grpTap }
  scale <0.075, 0.1, 0.075>
  rotate <90.0, 0.0, 19.87851>
  translate  <229.405262, 182.716338, -0.25>
}


#declare latBarrelBody1 = lathe {
  cubic_spline
  4  // control points
  <0.328486, -12.9935>,
  <6.965615, -8.238121>,
  <6.895673, 8.657772>,
  <0.042939, 14.606747>
  rotate <90,0,90>
  material {
    matBarrelBody
    // Transform to parent space
  }
}
#declare grpBands1 = union {
  torus { // torBand5
    7.0, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  8.22065*z
  }
  torus { // torBand6
    7.7, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  3.120291*z
  }
  torus { // torBand7
    7.7, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  -2.633044*z
  }
  torus { // torBand8
    7.1, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  -7.852431*z
  }
}
#declare cprsX4 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <-1.971128, 2.441839, 7.034477>
}
#declare cprsX5 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <-0.443254, 2.411281, 7.034477>
}
#declare cprsX6 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <1.145736, 2.411281, 7.034477>
}
#declare cprsX7 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <2.612496, 2.411281, 7.034477>
}
#declare csgdBarrelTop1 = difference {
  cylinder { // cylEndCap3
    <0,0,1>, <0,0,0>, 1 
    scale <1.005466, 1.0, 0.58386>
    translate  <0.0, 0.0, -0.673356>
    scale <6.9, 6.9, 1.540831>
    translate  8.701642*z
    material {
      matBarrelBody
      // Transform to parent space
    }
  }
  cone { // conTopCut1
    <0,0,0>, 6.7, <0,0,1>, 6.6
    translate  8.003203*z
    material {
      matEndWood
      rotate -90.0*z
      translate <-0.058168, -2.152207, -0.004307>
      // Transform to parent space
    }
  }
  object { cprsX4 }
  object { cprsX5 }
  object { cprsX6 }
  object { cprsX7 }
  material {
    matEndWood
    // Transform to parent space
  }
}
#declare csgdBarrelBottom1 = difference {
  cylinder { // cylEndCap4
    <0,0,1>, <0,0,0>, 1 
    scale <6.94, 6.94, 0.89522>
    translate  -8.234364*z
    material {
      matEndWood
      // Transform to parent space
    }
  }
  cone { // conBottomCap1
    <0,0,0>, 6.8, <0,0,1>, 6.7
    translate  -8.793643*z
  }
  material {
    matEndWood
    // Transform to parent space
  }
}
#declare grpTap1 = union {
  superellipsoid { // sqTap1
    <1.0, 0.1>
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.0, -0.026919, 0.818766>
    scale <0.15, 0.15, 1.0>
    rotate <80.621185, 90.0, 0.0>
    translate  <3.192497, 0.004038, 3.323912>
  }
  superellipsoid { // sqTapB1
    <1.0, 0.1>
    scale <0.35, 0.35, 1.5>
    rotate 90.0*y
    translate  <2.841847, 0.0, 2.444599>
  }
  cylinder { // cylTapB1
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
    translate  <3.758571, 0.0, 1.461608>
  }
  cylinder { // cylTapC1
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.0>
    translate  <3.197594, 0.0, 2.305224>
  }
  material {
    matIronDull
  }
  rotate <-90.0, -90.0, 0.0>
  translate  <0.042485, -5.333474, 6.601886>
}
union { // grpKeg1
  object { latBarrelBody1 }
  object { grpBands1 }
  object { csgdBarrelTop1 }
  object { csgdBarrelBottom1 }
  object { grpTap1 }
  scale <0.075, 0.1, 0.075>
  rotate <86.886833, 1.124929, 19.84794>
  translate  <218.106153, 125.566405, -0.25>
}


#declare latBarrelBody2 = lathe {
  cubic_spline
  4  // control points
  <0.328486, -12.9935>,
  <6.965615, -8.238121>,
  <6.895673, 8.657772>,
  <0.042939, 14.606747>
  rotate <90,0,90>
  material {
    matBarrelBody
    // Transform to parent space
  }
}
#declare grpBands2 = union {
  torus { // torBand9
    7.0, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  8.22065*z
  }
  torus { // torBand10
    7.7, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  3.120291*z
  }
  torus { // torBand11
    7.7, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  -2.633044*z
  }
  torus { // torBand12
    7.1, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  -7.852431*z
  }
}
#declare cprsX8 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <-1.971128, 2.441839, 7.034477>
}
#declare cprsX9 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <-0.443254, 2.411281, 7.034477>
}
#declare cprsX10 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <1.145736, 2.411281, 7.034477>
}
#declare cprsX11 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <2.612496, 2.411281, 7.034477>
}
#declare csgdBarrelTop2 = difference {
  cylinder { // cylEndCap5
    <0,0,1>, <0,0,0>, 1 
    scale <1.005466, 1.0, 0.58386>
    translate  <0.0, 0.0, -0.673356>
    scale <6.9, 6.9, 1.540831>
    translate  8.701642*z
    material {
      matBarrelBody
      // Transform to parent space
    }
  }
  cone { // conTopCut2
    <0,0,0>, 6.7, <0,0,1>, 6.6
    translate  8.003203*z
    material {
      matEndWood
      rotate -90.0*z
      translate <-0.058168, -2.152207, -0.004307>
      // Transform to parent space
    }
  }
  object { cprsX8 }
  object { cprsX9 }
  object { cprsX10 }
  object { cprsX11 }
  material {
    matEndWood
    // Transform to parent space
  }
}
#declare csgdBarrelBottom2 = difference {
  cylinder { // cylEndCap6
    <0,0,1>, <0,0,0>, 1 
    scale <6.94, 6.94, 0.89522>
    translate  -8.234364*z
    material {
      matEndWood
      // Transform to parent space
    }
  }
  cone { // conBottomCap2
    <0,0,0>, 6.8, <0,0,1>, 6.7
    translate  -8.793643*z
  }
  material {
    matEndWood
    // Transform to parent space
  }
}
#declare grpTap2 = union {
  superellipsoid { // sqTap2
    <1.0, 0.1>
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.0, -0.026919, 0.818766>
    scale <0.15, 0.15, 1.0>
    rotate <80.621185, 90.0, 0.0>
    translate  <3.192497, 0.004038, 3.323912>
  }
  superellipsoid { // sqTapB2
    <1.0, 0.1>
    scale <0.35, 0.35, 1.5>
    rotate 90.0*y
    translate  <2.841847, 0.0, 2.444599>
  }
  cylinder { // cylTapB2
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
    translate  <3.758571, 0.0, 1.461608>
  }
  cylinder { // cylTapC2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.0>
    translate  <3.197594, 0.0, 2.305224>
  }
  material {
    matIronDull
  }
  rotate <-90.0, -90.0, 0.0>
  translate  <0.042485, -5.333474, 6.601886>
}
union { // grpKeg2
  object { latBarrelBody2 }
  object { grpBands2 }
  object { csgdBarrelTop2 }
  object { csgdBarrelBottom2 }
  object { grpTap2 }
  scale <0.075, 0.1, 0.075>
  rotate <87.152527, 1.029031, 19.85293>
  translate  <122.341053, 79.646469, -0.25>
}


#declare latBarrelBody3 = lathe {
  cubic_spline
  4  // control points
  <0.328486, -12.9935>,
  <6.965615, -8.238121>,
  <6.895673, 8.657772>,
  <0.042939, 14.606747>
  rotate <90,0,90>
  material {
    matBarrelBody
    // Transform to parent space
  }
}
#declare grpBands3 = union {
  torus { // torBand13
    7.0, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  8.22065*z
  }
  torus { // torBand14
    7.7, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  3.120291*z
  }
  torus { // torBand15
    7.7, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  -2.633044*z
  }
  torus { // torBand16
    7.1, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  -7.852431*z
  }
}
#declare cprsX12 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <-1.971128, 2.441839, 7.034477>
}
#declare cprsX13 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <-0.443254, 2.411281, 7.034477>
}
#declare cprsX14 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <1.145736, 2.411281, 7.034477>
}
#declare cprsX15 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <2.612496, 2.411281, 7.034477>
}
#declare csgdBarrelTop3 = difference {
  cylinder { // cylEndCap7
    <0,0,1>, <0,0,0>, 1 
    scale <1.005466, 1.0, 0.58386>
    translate  <0.0, 0.0, -0.673356>
    scale <6.9, 6.9, 1.540831>
    translate  8.701642*z
    material {
      matBarrelBody
      // Transform to parent space
    }
  }
  cone { // conTopCut3
    <0,0,0>, 6.7, <0,0,1>, 6.6
    translate  8.003203*z
    material {
      matEndWood
      rotate -90.0*z
      translate <-0.058168, -2.152207, -0.004307>
      // Transform to parent space
    }
  }
  object { cprsX12 }
  object { cprsX13 }
  object { cprsX14 }
  object { cprsX15 }
  material {
    matEndWood
    // Transform to parent space
  }
}
#declare csgdBarrelBottom3 = difference {
  cylinder { // cylEndCap8
    <0,0,1>, <0,0,0>, 1 
    scale <6.94, 6.94, 0.89522>
    translate  -8.234364*z
    material {
      matEndWood
      // Transform to parent space
    }
  }
  cone { // conBottomCap3
    <0,0,0>, 6.8, <0,0,1>, 6.7
    translate  -8.793643*z
  }
  material {
    matEndWood
    // Transform to parent space
  }
}
#declare grpTap3 = union {
  superellipsoid { // sqTap3
    <1.0, 0.1>
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.0, -0.026919, 0.818766>
    scale <0.15, 0.15, 1.0>
    rotate <80.621185, 90.0, 0.0>
    translate  <3.192497, 0.004038, 3.323912>
  }
  superellipsoid { // sqTapB3
    <1.0, 0.1>
    scale <0.35, 0.35, 1.5>
    rotate 90.0*y
    translate  <2.841847, 0.0, 2.444599>
  }
  cylinder { // cylTapB3
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
    translate  <3.758571, 0.0, 1.461608>
  }
  cylinder { // cylTapC3
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.0>
    translate  <3.197594, 0.0, 2.305224>
  }
  material {
    matIronDull
  }
  rotate <-90.0, -90.0, 0.0>
  translate  <0.042485, -5.333474, 6.601886>
}
union { // grpKeg3
  object { latBarrelBody3 }
  object { grpBands3 }
  object { csgdBarrelTop3 }
  object { csgdBarrelBottom3 }
  object { grpTap3 }
  scale <0.075, 0.1, 0.075>
  rotate <93.320801, -1.199858, 19.843729>
  translate  <192.301879, 145.409015, -0.25>
}


box { // cubPlank1
  <-1, -1, -1>, <1, 1, 1>
  scale <7.0, 1.0, 0.3>
  rotate <-2.870383, 1.009523, 22.621738>
  translate  <275.336803, 192.661736, -0.1>
  material {
    matBarrelBody
    // Transform to world space
  }
}


box { // cubPlank2
  <-1, -1, -1>, <1, 1, 1>
  scale <7.0, 1.0, 0.3>
  rotate <-0.721018, -1.147849, 11.763577>
  translate  <201.91072, 178.463023, -0.1>
  material {
    matBarrelBody
    // Transform to world space
  }
}


box { // cubPlank4
  <-1, -1, -1>, <1, 1, 1>
  scale <7.0, 1.0, 0.3>
  rotate <-0.898768, 0.886861, -10.149426>
  translate  <152.096698, 131.865689, -0.1>
  material {
    matBarrelBody
    // Transform to world space
  }
}


#declare grpBoxside = union {
  box { // cubPlankBox1
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  6.95*y
  }
  box { // cubPlankBox2
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  4.9*y
  }
  box { // cubPlankBox3
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  2.85*y
  }
  box { // cubPlankBox4
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  0.8*y
  }
  box { // cubPlankBox5
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -1.25*y
  }
  box { // cubPlankBox6
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -3.3*y
  }
  box { // cubPlankBox7
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -5.35*y
  }
  box { // cubPlankBox8
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -7.4*y
  }
  box { // cubPlankBox9
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <6.973317, -0.145656, 0.3>
  }
  box { // cubPlankBox10
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <-6.973317, -0.145656, 0.3>
  }
  material {
    matBarrelBody_1
  }
}
#declare grpBoxside1 = union {
  box { // cubPlankBox11
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  6.95*y
  }
  box { // cubPlankBox12
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  4.9*y
  }
  box { // cubPlankBox13
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  2.85*y
  }
  box { // cubPlankBox14
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  0.8*y
  }
  box { // cubPlankBox15
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -1.25*y
  }
  box { // cubPlankBox16
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -3.3*y
  }
  box { // cubPlankBox17
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -5.35*y
  }
  box { // cubPlankBox18
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -7.4*y
  }
  box { // cubPlankBox19
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <6.973317, -0.145656, 0.3>
  }
  box { // cubPlankBox20
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <-6.973317, -0.145656, 0.3>
  }
  material {
    matBarrelBody_1
  }
  scale <1.025, 1.0, 1.0>
  rotate <90.0, 0.0, -90.0>
  translate  <-8.145621, -0.210851, -8.001382>
}
#declare grpBoxside2 = union {
  box { // cubPlankBox21
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  6.95*y
  }
  box { // cubPlankBox22
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  4.9*y
  }
  box { // cubPlankBox23
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  2.85*y
  }
  box { // cubPlankBox24
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  0.8*y
  }
  box { // cubPlankBox25
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -1.25*y
  }
  box { // cubPlankBox26
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -3.3*y
  }
  box { // cubPlankBox27
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -5.35*y
  }
  box { // cubPlankBox28
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -7.4*y
  }
  box { // cubPlankBox29
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <6.973317, -0.145656, 0.3>
  }
  box { // cubPlankBox30
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <-6.973317, -0.145656, 0.3>
  }
  material {
    matBarrelBody_1
  }
  scale <1.025, 1.0, 1.0>
  rotate <90.0, 0.0, 90.0>
  translate  <7.868413, -0.257268, -8.001382>
}
#declare grpBoxside3 = union {
  box { // cubPlankBox31
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  6.95*y
  }
  box { // cubPlankBox32
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  4.9*y
  }
  box { // cubPlankBox33
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  2.85*y
  }
  box { // cubPlankBox34
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  0.8*y
  }
  box { // cubPlankBox35
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -1.25*y
  }
  box { // cubPlankBox36
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -3.3*y
  }
  box { // cubPlankBox37
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -5.35*y
  }
  box { // cubPlankBox38
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -7.4*y
  }
  box { // cubPlankBox39
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <6.973317, -0.145656, 0.3>
  }
  box { // cubPlankBox40
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <-6.973317, -0.145656, 0.3>
  }
  material {
    matBarrelBody_1
  }
  scale <1.025, 1.0, 1.0>
  rotate <90.0, -90.0, 0.0>
  translate  <-0.301065, -8.519592, -8.001382>
}
#declare grpBoxside4 = union {
  box { // cubPlankBox41
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  6.95*y
  }
  box { // cubPlankBox42
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  4.9*y
  }
  box { // cubPlankBox43
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  2.85*y
  }
  box { // cubPlankBox44
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  0.8*y
  }
  box { // cubPlankBox45
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -1.25*y
  }
  box { // cubPlankBox46
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -3.3*y
  }
  box { // cubPlankBox47
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -5.35*y
  }
  box { // cubPlankBox48
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -7.4*y
  }
  box { // cubPlankBox49
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <6.973317, -0.145656, 0.3>
  }
  box { // cubPlankBox50
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <-6.973317, -0.145656, 0.3>
  }
  material {
    matBarrelBody_1
  }
  scale <1.025, 1.0, 1.0>
  rotate <-90.0, -90.0, 0.0>
  translate  <-0.301065, 8.050949, -8.001382>
}
union { // grpCrate
  object { grpBoxside }
  object { grpBoxside1 }
  object { grpBoxside2 }
  object { grpBoxside3 }
  object { grpBoxside4 }
  scale 0.15
  rotate <0.311341, 0.0, -4.762394>
  translate  <107.497527, 63.093387, 0.217126>
}


#declare grpBoxside5 = union {
  box { // cubPlankBox51
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  6.95*y
  }
  box { // cubPlankBox52
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  4.9*y
  }
  box { // cubPlankBox53
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  2.85*y
  }
  box { // cubPlankBox54
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  0.8*y
  }
  box { // cubPlankBox55
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -1.25*y
  }
  box { // cubPlankBox56
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -3.3*y
  }
  box { // cubPlankBox57
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -5.35*y
  }
  box { // cubPlankBox58
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -7.4*y
  }
  box { // cubPlankBox59
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <6.973317, -0.145656, 0.3>
  }
  box { // cubPlankBox60
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <-6.973317, -0.145656, 0.3>
  }
  material {
    matBarrelBody_1
  }
}
#declare grpBoxside6 = union {
  box { // cubPlankBox61
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  6.95*y
  }
  box { // cubPlankBox62
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  4.9*y
  }
  box { // cubPlankBox63
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  2.85*y
  }
  box { // cubPlankBox64
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  0.8*y
  }
  box { // cubPlankBox65
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -1.25*y
  }
  box { // cubPlankBox66
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -3.3*y
  }
  box { // cubPlankBox67
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -5.35*y
  }
  box { // cubPlankBox68
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -7.4*y
  }
  box { // cubPlankBox69
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <6.973317, -0.145656, 0.3>
  }
  box { // cubPlankBox70
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <-6.973317, -0.145656, 0.3>
  }
  material {
    matBarrelBody_1
  }
  scale <1.025, 1.0, 1.0>
  rotate <90.0, 0.0, -90.0>
  translate  <-8.145621, -0.210851, -8.001382>
}
#declare grpBoxside7 = union {
  box { // cubPlankBox71
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  6.95*y
  }
  box { // cubPlankBox72
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  4.9*y
  }
  box { // cubPlankBox73
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  2.85*y
  }
  box { // cubPlankBox74
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  0.8*y
  }
  box { // cubPlankBox75
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -1.25*y
  }
  box { // cubPlankBox76
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -3.3*y
  }
  box { // cubPlankBox77
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -5.35*y
  }
  box { // cubPlankBox78
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -7.4*y
  }
  box { // cubPlankBox79
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <6.973317, -0.145656, 0.3>
  }
  box { // cubPlankBox80
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <-6.973317, -0.145656, 0.3>
  }
  material {
    matBarrelBody_1
  }
  scale <1.025, 1.0, 1.0>
  rotate <90.0, 0.0, 90.0>
  translate  <7.868413, -0.257268, -8.001382>
}
#declare grpBoxside8 = union {
  box { // cubPlankBox81
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  6.95*y
  }
  box { // cubPlankBox82
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  4.9*y
  }
  box { // cubPlankBox83
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  2.85*y
  }
  box { // cubPlankBox84
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  0.8*y
  }
  box { // cubPlankBox85
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -1.25*y
  }
  box { // cubPlankBox86
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -3.3*y
  }
  box { // cubPlankBox87
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -5.35*y
  }
  box { // cubPlankBox88
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -7.4*y
  }
  box { // cubPlankBox89
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <6.973317, -0.145656, 0.3>
  }
  box { // cubPlankBox90
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <-6.973317, -0.145656, 0.3>
  }
  material {
    matBarrelBody_1
  }
  scale <1.025, 1.0, 1.0>
  rotate <90.0, -90.0, 0.0>
  translate  <-0.301065, -8.519592, -8.001382>
}
#declare grpBoxside9 = union {
  box { // cubPlankBox91
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  6.95*y
  }
  box { // cubPlankBox92
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  4.9*y
  }
  box { // cubPlankBox93
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  2.85*y
  }
  box { // cubPlankBox94
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  0.8*y
  }
  box { // cubPlankBox95
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -1.25*y
  }
  box { // cubPlankBox96
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -3.3*y
  }
  box { // cubPlankBox97
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -5.35*y
  }
  box { // cubPlankBox98
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -7.4*y
  }
  box { // cubPlankBox99
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <6.973317, -0.145656, 0.3>
  }
  box { // cubPlankBox100
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <-6.973317, -0.145656, 0.3>
  }
  material {
    matBarrelBody_1
  }
  scale <1.025, 1.0, 1.0>
  rotate <-90.0, -90.0, 0.0>
  translate  <-0.301065, 8.050949, -8.001382>
}
union { // grpCrate1
  object { grpBoxside5 }
  object { grpBoxside6 }
  object { grpBoxside7 }
  object { grpBoxside8 }
  object { grpBoxside9 }
  scale 0.15
  rotate <0.311341, 0.0, 2.269519>
  translate  <120.042806, 97.070184, 0.217126>
}


#declare grpBoxside10 = union {
  box { // cubPlankBox101
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  6.95*y
  }
  box { // cubPlankBox102
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  4.9*y
  }
  box { // cubPlankBox103
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  2.85*y
  }
  box { // cubPlankBox104
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  0.8*y
  }
  box { // cubPlankBox105
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -1.25*y
  }
  box { // cubPlankBox106
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -3.3*y
  }
  box { // cubPlankBox107
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -5.35*y
  }
  box { // cubPlankBox108
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -7.4*y
  }
  box { // cubPlankBox109
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <6.973317, -0.145656, 0.3>
  }
  box { // cubPlankBox110
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <-6.973317, -0.145656, 0.3>
  }
  material {
    matBarrelBody_1
  }
}
#declare grpBoxside11 = union {
  box { // cubPlankBox111
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  6.95*y
  }
  box { // cubPlankBox112
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  4.9*y
  }
  box { // cubPlankBox113
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  2.85*y
  }
  box { // cubPlankBox114
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  0.8*y
  }
  box { // cubPlankBox115
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -1.25*y
  }
  box { // cubPlankBox116
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -3.3*y
  }
  box { // cubPlankBox117
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -5.35*y
  }
  box { // cubPlankBox118
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -7.4*y
  }
  box { // cubPlankBox119
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <6.973317, -0.145656, 0.3>
  }
  box { // cubPlankBox120
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <-6.973317, -0.145656, 0.3>
  }
  material {
    matBarrelBody_1
  }
  scale <1.025, 1.0, 1.0>
  rotate <90.0, 0.0, -90.0>
  translate  <-8.145621, -0.210851, -8.001382>
}
#declare grpBoxside12 = union {
  box { // cubPlankBox121
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  6.95*y
  }
  box { // cubPlankBox122
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  4.9*y
  }
  box { // cubPlankBox123
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  2.85*y
  }
  box { // cubPlankBox124
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  0.8*y
  }
  box { // cubPlankBox125
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -1.25*y
  }
  box { // cubPlankBox126
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -3.3*y
  }
  box { // cubPlankBox127
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -5.35*y
  }
  box { // cubPlankBox128
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -7.4*y
  }
  box { // cubPlankBox129
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <6.973317, -0.145656, 0.3>
  }
  box { // cubPlankBox130
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <-6.973317, -0.145656, 0.3>
  }
  material {
    matBarrelBody_1
  }
  scale <1.025, 1.0, 1.0>
  rotate <90.0, 0.0, 90.0>
  translate  <7.868413, -0.257268, -8.001382>
}
#declare grpBoxside13 = union {
  box { // cubPlankBox131
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  6.95*y
  }
  box { // cubPlankBox132
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  4.9*y
  }
  box { // cubPlankBox133
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  2.85*y
  }
  box { // cubPlankBox134
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  0.8*y
  }
  box { // cubPlankBox135
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -1.25*y
  }
  box { // cubPlankBox136
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -3.3*y
  }
  box { // cubPlankBox137
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -5.35*y
  }
  box { // cubPlankBox138
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -7.4*y
  }
  box { // cubPlankBox139
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <6.973317, -0.145656, 0.3>
  }
  box { // cubPlankBox140
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <-6.973317, -0.145656, 0.3>
  }
  material {
    matBarrelBody_1
  }
  scale <1.025, 1.0, 1.0>
  rotate <90.0, -90.0, 0.0>
  translate  <-0.301065, -8.519592, -8.001382>
}
#declare grpBoxside14 = union {
  box { // cubPlankBox141
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  6.95*y
  }
  box { // cubPlankBox142
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  4.9*y
  }
  box { // cubPlankBox143
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  2.85*y
  }
  box { // cubPlankBox144
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  0.8*y
  }
  box { // cubPlankBox145
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -1.25*y
  }
  box { // cubPlankBox146
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -3.3*y
  }
  box { // cubPlankBox147
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -5.35*y
  }
  box { // cubPlankBox148
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -7.4*y
  }
  box { // cubPlankBox149
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <6.973317, -0.145656, 0.3>
  }
  box { // cubPlankBox150
    <-1, -1, -1>, <1, 1, 1>
    scale <8.05, 1.0, 0.3>
    rotate -90.0*z
    translate  <-6.973317, -0.145656, 0.3>
  }
  material {
    matBarrelBody_1
  }
  scale <1.025, 1.0, 1.0>
  rotate <-90.0, -90.0, 0.0>
  translate  <-0.301065, 8.050949, -8.001382>
}
union { // grpCrate2
  object { grpBoxside10 }
  object { grpBoxside11 }
  object { grpBoxside12 }
  object { grpBoxside13 }
  object { grpBoxside14 }
  scale 0.15
  rotate <3.966287, -3.149246, 47.43626>
  translate  <350.356388, 251.934793, 6.843799>
}


#declare latBarrelBody4 = lathe {
  cubic_spline
  4  // control points
  <0.328486, -12.9935>,
  <6.965615, -8.238121>,
  <6.895673, 8.657772>,
  <0.042939, 14.606747>
  rotate <90,0,90>
  material {
    matBarrelBody_1
    // Transform to world space
    translate  <-347.531074, -252.710445, -5.535196>
    rotate 11.077511*z rotate 0.522563*y rotate -5.681252*x
    scale 1.0/0.1
  }
}
#declare grpBands4 = union {
  torus { // torBand17
    7.0, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  8.22065*z
  }
  torus { // torBand18
    7.7, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  3.120291*z
  }
  torus { // torBand19
    7.7, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  -2.633044*z
  }
  torus { // torBand20
    7.1, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  -7.852431*z
  }
}
#declare cprsX16 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <-1.971128, 2.441839, 7.034477>
}
#declare cprsX17 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <-0.443254, 2.411281, 7.034477>
}
#declare cprsX18 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <1.145736, 2.411281, 7.034477>
}
#declare cprsX19 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <2.612496, 2.411281, 7.034477>
}
#declare csgdBarrelTop4 = difference {
  cylinder { // cylEndCap9
    <0,0,1>, <0,0,0>, 1 
    scale <1.005466, 1.0, 0.58386>
    translate  <0.0, 0.0, -0.673356>
    scale <6.9, 6.9, 1.540831>
    translate  8.701642*z
    material {
      matBarrelBody
      // Transform to parent space
    }
  }
  cone { // conTopCut4
    <0,0,0>, 6.7, <0,0,1>, 6.6
    translate  8.003203*z
    material {
      matEndWood
      rotate -90.0*z
      translate <-0.058168, -2.152207, -0.004307>
      // Transform to parent space
    }
  }
  object { cprsX16 }
  object { cprsX17 }
  object { cprsX18 }
  object { cprsX19 }
  material {
    matEndWood
    // Transform to parent space
  }
}
#declare csgdBarrelBottom4 = difference {
  cylinder { // cylEndCap10
    <0,0,1>, <0,0,0>, 1 
    scale <6.94, 6.94, 0.89522>
    translate  -8.234364*z
    material {
      matEndWood
      // Transform to parent space
    }
  }
  cone { // conBottomCap4
    <0,0,0>, 6.8, <0,0,1>, 6.7
    translate  -8.793643*z
  }
  material {
    matEndWood
    // Transform to parent space
  }
}
union { // grpKeg4
  object { latBarrelBody4 }
  object { grpBands4 }
  object { csgdBarrelTop4 }
  object { csgdBarrelBottom4 }
  scale 0.1
  rotate <5.681252, -0.522563, -11.077511>
  translate  <347.531074, 252.710445, 5.535196>
}


union { // grpPreserver
  torus { // torPreserveA
    1.5, 0.5  rotate -x*90
    material {
      matPreserverBody
    }
  }
  cylinder { // cylPreserverRing1
    <0,0,1>, <0,0,0>, 1 
    material {
      matPreservesRing
    }
    scale <0.55, 0.55, 0.5>
    rotate 90.0*x
    translate  <1.460627, 0.27394, -0.0>
  }
  cylinder { // cylPreserverRing2
    <0,0,1>, <0,0,0>, 1 
    material {
      matPreservesRing
    }
    scale <0.55, 0.55, 0.5>
    rotate <90.0, 0.0, -90.0>
    translate  <0.27394, -1.460627, -0.0>
  }
  cylinder { // cylPreserverRing3
    <0,0,1>, <0,0,0>, 1 
    material {
      matPreservesRing
    }
    scale <0.55, 0.55, 0.5>
    rotate <90.0, 0.0, 180.0>
    translate  <-1.460627, -0.27394, -0.0>
  }
  cylinder { // cylPreserverRing4
    <0,0,1>, <0,0,0>, 1 
    material {
      matPreservesRing
    }
    scale <0.55, 0.55, 0.5>
    rotate <90.0, 0.0, 90.0>
    translate  <-0.27394, 1.460627, -0.0>
  }
  scale <0.4, 0.4, 0.24>
  rotate <1.770145, 0.237221, 10.639848>
  translate  <75.185668, 57.162342, 0.096259>
}


#declare latBarrelBody5 = lathe {
  cubic_spline
  4  // control points
  <0.328486, -12.9935>,
  <6.965615, -8.238121>,
  <6.895673, 8.657772>,
  <0.042939, 14.606747>
  rotate <90,0,90>
  material {
    matBarrelBody_1
    // Transform to world space
    translate  <-348.577045, -254.244175, -5.526382>
    rotate 11.077511*z rotate 0.522563*y rotate -5.681252*x
    scale 1.0/0.1
  }
}
#declare grpBands5 = union {
  torus { // torBand21
    7.0, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  8.22065*z
  }
  torus { // torBand22
    7.7, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  3.120291*z
  }
  torus { // torBand23
    7.7, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  -2.633044*z
  }
  torus { // torBand24
    7.1, 0.1  rotate -x*90
    material {
      matIronDull
    }
    scale <1.0, 1.0, 2.25>
    translate  -7.852431*z
  }
}
#declare cprsX20 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <-1.971128, 2.441839, 7.034477>
}
#declare cprsX21 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <-0.443254, 2.411281, 7.034477>
}
#declare cprsX22 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <1.145736, 2.411281, 7.034477>
}
#declare cprsX23 = prism {
  conic_sweep
  linear_spline
  0.9,1.0
  13  // control points
  <-1.0, -1.0>,
  <0.0, -0.246285>,
  <1.0, -1.0>,
  <0.993631, -0.525622>,
  <0.171975, 0.044926>,
  <1.0, 0.6>,
  <1.0, 1.084926>,
  <-0.010616, 0.341826>,
  <-1.0, 1.0>,
  <-1.0, 0.419533>,
  <-0.171975, 0.010616>,
  <-1.0, -0.430149>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.0>
  translate  <2.612496, 2.411281, 7.034477>
}
#declare csgdBarrelTop5 = difference {
  cylinder { // cylEndCap11
    <0,0,1>, <0,0,0>, 1 
    scale <1.005466, 1.0, 0.58386>
    translate  <0.0, 0.0, -0.673356>
    scale <6.9, 6.9, 1.540831>
    translate  8.701642*z
    material {
      matBarrelBody
      // Transform to parent space
    }
  }
  cone { // conTopCut5
    <0,0,0>, 6.7, <0,0,1>, 6.6
    translate  8.003203*z
    material {
      matEndWood
      rotate -90.0*z
      translate <-0.058168, -2.152207, -0.004307>
      // Transform to parent space
    }
  }
  object { cprsX20 }
  object { cprsX21 }
  object { cprsX22 }
  object { cprsX23 }
  material {
    matEndWood
    // Transform to parent space
  }
}
#declare csgdBarrelBottom5 = difference {
  cylinder { // cylEndCap12
    <0,0,1>, <0,0,0>, 1 
    scale <6.94, 6.94, 0.89522>
    translate  -8.234364*z
    material {
      matEndWood
      // Transform to parent space
    }
  }
  cone { // conBottomCap5
    <0,0,0>, 6.8, <0,0,1>, 6.7
    translate  -8.793643*z
  }
  material {
    matEndWood
    // Transform to parent space
  }
}
union { // grpKeg5
  object { latBarrelBody5 }
  object { grpBands5 }
  object { csgdBarrelTop5 }
  object { csgdBarrelBottom5 }
  scale 0.1
  rotate <5.681252, -0.522563, -11.077511>
  translate  <348.577045, 254.244175, 5.526382>
}


#include "C:\cffiles\projects\povalone\ship3.inc"

#declare Ship_Hull_Ref = object {
  Ship_Object1
  material {
    matBluePaint
    // Transform to world space
    translate  <-9515.156838, -5098.962878, 30.0>
    rotate 80.257011*z
    scale 1.0/18.0
  }
}
#include "C:\cffiles\projects\povalone\untitled_sw.inc"

#declare SmokeA_Ref = object {
  SmokeA
}
#declare SmokeB_Ref = object {
  SmokeB
}
#declare SmokeC_Ref = object {
  SmokeC
}
#declare Smoke = merge {
  object { SmokeA_Ref }
  object { SmokeB_Ref }
  object { SmokeC_Ref }
  scale 0.055556
  rotate <-0.0, -0.0, 80.257011>
  translate  <189.732216, -568.933859, 1.975176>
  material {
    matTrailingSmoke
    scale <1.0, 177.0, 1.0>
    rotate 10.971779*z
    translate <9486.555664, 5256.375977, 0.000000>
    // Transform to world space
    translate  <-9515.156838, -5098.962878, 30.0>
    rotate 80.257011*z
    scale 1.0/18.0
  }
}
#declare AnchorA = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  7  // control points
  <1.307856, 0.002123>,
  <0.008493, -0.624204>,
  <-1.392781, 0.019108>,
  <0.002123, -1.021231>,
  <1.307856, 0.002123>,
  <0.008493, -0.624204>,
  <-1.392781, 0.019108>
  rotate -x*90
  scale <1.0, 1.0, 0.1>
}
#declare Anchor = union {
  object { AnchorA }
  box { // AnchorB
    <-1, -1, -1>, <1, 1, 1>
    scale <0.123444, 1.511324, 0.1>
    translate  <-0.018262, 0.639155, 0.1>
  }
  box { // AnchorC
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.598245, -0.077632, -0.1>
    rotate <-180.0, 0.0, 179.952072>
    translate  <-0.018262, 1.479188, 0.1>
  }
  torus { // AnchorD
    0.2, 0.05  rotate -x*90
    scale <1.0, 1.0, 2.0>
    translate  <0.0, 2.282697, 0.1>
  }
  scale 0.3
  rotate <90.0, -0.0, 19.813141>
  translate  <8.935977, -2.053154, 2.662741>
  material {
    VaguerMetal
    // Transform to world space
    translate  <-9515.156838, -5098.962878, 30.0>
    rotate 80.257011*z
    scale 1.0/18.0
  }
}
union { // BackgroundShip1
  object { Ship_Hull_Ref }
  object { Smoke }
  box { // cubCabins
    <-1, -1, -1>, <1, 1, 1>
    scale <1.809549, 5.06119, 1.111111>
    rotate <-0.0, -0.0, 90.045174>
    translate  <-2.501115, -0.000925, 4.710137>
    material {
      matGreyPaint
      // Transform to world space
      translate  <-9515.156838, -5098.962878, 30.0>
      rotate 80.257011*z
      scale 1.0/18.0
    }
  }
  box { // cubControlHouse
    <-1, -1, -1>, <1, 1, 1>
    scale <1.147964, 2.602773, 1.111111>
    rotate <-0.0, -0.0, 90.045174>
    translate  <-1.308342, 0.031704, 5.524807>
    material {
      matGreyPaint
      // Transform to world space
      translate  <-9515.156838, -5098.962878, 30.0>
      rotate 80.257011*z
      scale 1.0/18.0
    }
  }
  cylinder { // cylSmokeStackA
    <0,0,1>, <0,0,0>, 1 
    scale <0.416018, 0.400381, 2.371942>
    rotate <-0.0, -0.0, 80.257011>
    translate  <-1.987797, 0.00771, 6.07544>
    material {
      VaguelyMetallic
      // Transform to world space
      translate  <-9515.156838, -5098.962878, 30.0>
      rotate 80.257011*z
      scale 1.0/18.0
    }
  }
  cylinder { // cylSmokeStackB
    <0,0,1>, <0,0,0>, 1 
    scale <0.416018, 0.400381, 2.371942>
    rotate <-0.0, -0.0, 80.257011>
    translate  <-0.995184, 0.020142, 6.07544>
    material {
      VaguelyMetallic
      // Transform to world space
      translate  <-9515.156838, -5098.962878, 30.0>
      rotate 80.257011*z
      scale 1.0/18.0
    }
  }
  cylinder { // cylSmokeStackC
    <0,0,1>, <0,0,0>, 1 
    scale <0.416018, 0.400381, 2.371942>
    rotate <-0.0, -0.0, 80.257011>
    translate  <-0.03004, -0.004271, 6.07544>
    material {
      VaguelyMetallic
      // Transform to world space
      translate  <-9515.156838, -5098.962878, 30.0>
      rotate 80.257011*z
      scale 1.0/18.0
    }
  }
  box { // cubWindow1
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <1.88717, -1.806797, 5.255076>
  }
  box { // cubWindow2
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <0.985614, -1.804221, 5.255076>
  }
  box { // cubWindow3
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <0.256191, -1.802363, 5.255076>
  }
  box { // cubWindow4
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <-0.543986, -1.808699, 5.255076>
  }
  box { // cubWindow5
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <-1.463971, -1.804543, 5.255076>
  }
  box { // cubWindow6
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <-2.386236, -1.813217, 5.255076>
  }
  box { // cubWindow7
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <-0.037317, -0.483241, -0.263889>
    rotate <180.0, 0.0, 179.951477>
    translate  <2.57319, 0.924991, 5.255076>
  }
  box { // cubWindow8
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.029902, 0.817492, 0.263889>
    rotate <-0.0, 0.0, 179.951477>
    translate  <1.29549, 0.057125, 6.178254>
  }
  box { // cubWindow9
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <-0.037317, -0.483241, -0.263889>
    rotate <180.0, 0.0, 179.951477>
    translate  <2.560949, -0.694617, 5.255076>
  }
  box { // cubWindow10
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <-3.265643, -1.808909, 5.255076>
  }
  box { // cubWindow11
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <-4.122186, -1.814045, 5.255076>
  }
  box { // cubWindow12
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <-5.069434, -1.806483, 5.255076>
  }
  box { // cubWindow13
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <-6.002159, -1.816113, 5.255076>
  }
  box { // cubWindow14
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <-7.006518, -1.815234, 5.255076>
  }
  box { // cubWindow15
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <0.594601, -1.117997, 6.178254>
  }
  box { // cubWindow16
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <-0.145592, -1.115976, 6.178254>
  }
  box { // cubWindow17
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <-0.950211, -1.118412, 6.178254>
  }
  box { // cubWindow18
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <-1.790609, -1.115081, 6.178254>
  }
  box { // cubWindow19
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <-2.592455, -1.115985, 6.139788>
  }
  box { // cubWindow20
    <-1, -1, -1>, <1, 1, 1>
    material {
      matLuminence
    }
    scale <0.011111, 0.180556, 0.236111>
    rotate <-0.0, -0.0, 89.892326>
    translate  <-3.37559, -1.121713, 6.139788>
  }
  object { Anchor }
  torus { // AnchorD1
    0.35, 0.075  rotate -x*90
    material {
      VaguelyMetallic
    }
    scale <0.555556, 0.555556, 0.111111>
    rotate <97.949135, 9.43223, 15.632996>
    translate  <8.936048, -2.036319, 3.447899>
  }
  scale 18.0
  rotate -80.257011*z
  translate  <9515.156838, 5098.962878, -30.0>
  material {
    VaguelyMetallic
    // Transform to world space
  }
}


