#      Sweepconvert.pl  ver 0.9 by C Fusner
# This file can be freely used by all POV-Ray/Moray users. It can be shared as long as
# the file "sconvert.txt" (containing the Quickstart Guide) is included and it is
# provided intact as it appears in the IRTC submission of which this converter is a part.
# Sweep convert is provided "as is" with no expressed or implied warranty or promise
# of support. 
#

my $currpath = '.';
my $infilename = 'sweep.pov';

if (@ARGV) {
   foreach (@ARGV) {
      if (m/\.pov/) { $infilename=$_; }
      if (m/\/|\\/) { $currpath=$_; }
   }
}

#declarations
our $count=0;
our %cp;
our %Bound;
our %SplineType;
our %PointsNeeded;
sub ProcessSphere(@);
sub ObtainSphere(@);
sub ObtainObject(@);

# establish default values
my $sanelabel=0;

#main parse and process
    $groupname = $udofilename = $incfilename = $infilename;
    $udofilename =~ s/(.*)\.pov/$1\_sw.udo/;
    $incfilename =~ s/(.*)\.pov/$1\_sw.inc/;
    $groupname =~ s/(.*)\.pov/$1/;
    open (INPUTFILE, "<$currpath\\$infilename" ) || die "Couldn't open source file. Check file name and current working directory.\n";
    open (INCFILE,">$currpath\\$incfilename") || die "Couldn't create INC file\n";
    open (UDOFILE,">$currpath\\$udofilename") || die "Couldn't create UDO file\n";

    print INCFILE "\/\/  Sphere sweep definition file.\n\/\/  Converted to sphere_sweep with sweepcovert.pl (by C Fusner)\n\/\/";
    print UDOFILE "\;  Sphere sweep UDO file.\n\;  Converted to sphere_sweep with sweepcovert.pl (by C Fusner)\n\;";

    while (<INPUTFILE>) {
       if (m/sphere.*\/\/\s*cp_(\w{1,40})_.*/) {
           if (!$PointsNeeded{$1}) { #new sweep detected, let's put some defaults on it...
               $SplineType{$1}="linear";
               $PointsNeeded{$1}=2;
               $Bound{$1}="";
           }
           ObtainSphere($_ , $1);
       }
       elsif (m/.*\/\/(\s*)?(.*)_(linear|cubic|b)_spline/) {
           $SplineType{$2}=$3;
           if ($3 eq 'linear') { $PointsNeeded{$2}=2; }
           else { $PointsNeeded{$2}=4; }
       }
       elsif (m/.*\/\/\s*(.*)_bound/) {
           $Bound{$1} = ObtainObject($_ ,$1);
       }
       else {
           chomp;
           if ( /Moray.*\(c\)/ && !$sanelabel) {
               print INCFILE "\n\/\/  Derived from original output generated by\n$_\n\/\/  in file $currpath\\$infilename\n\n";
               s/\/\//\;/;
               print UDOFILE "\n\;  Derived from original output generated by\n$_\n\;  in file $currpath\\$infilename\n\n";
               $sanelabel=1;
           }

       }

   }
close(INPUTFILE);

#now process the sweeps collected...
print UDOFILE "Name \'$groupname\'\nIncludeFile \'$incfilename\'\n\n";

foreach $sweepid (keys %cp) {
    $elements=$#{$cp{$sweepid}}+1;
    if ($elements < $PointsNeeded{$sweepid}) { die "$sweepid: Unable to make $SplineType{$sweepid} spline. $elements sphere(s) found. Need at least $PointsNeeded{$sweepid}.\n";}

    if ($PointsNeeded{$sweepid}==2) {
        $udostart=0;
        $udoend = $elements;
        $udoverts=$elements;
    }
    else {
        $udostart=1;
        $udoend = $elements-1;
        $udoverts=$elements-2;
    }


    print UDOFILE "[$sweepid\:Vertices\]\n$udoverts\n";

    for ($i = $udostart; $i < $udoend; $i++ ) {
        my $numeric= qr/[\+|\-]?\d+\.?\d*/;
        my $vector= qr/\<($numeric)\s*\,\s*($numeric)\s*\,\s*($numeric)\s*\>/;
        if ($cp{$sweepid}[$i] =~ m/$vector/) {
           print UDOFILE "$1 $2 $3\n";
        }
    }

    $udoedges=$udoverts-1;
    print UDOFILE "\n\[$sweepid\:Edges\]\n$udoedges\n";
    for ($i=0; $i<$udoedges; $i++) {
        my $j=$i+1;
        print UDOFILE "$i $j\n";
    }

    print INCFILE "#declare $sweepid=\nsphere_sweep {\n    $SplineType{$sweepid}\_spline\n    $elements\,\n    ";
    $cp{$sweepid}[$#{$cp{$sweepid}}] =~ s/(.*),(\n    )/$1$2/;
    print INCFILE @{$cp{$sweepid}};
    print INCFILE "\n    tolerance .001\n\n";
    print INCFILE "    bounded_by { $Bound{$sweepid} }\n" if ($Bound{$sweepid});
    print INCFILE "}\n";

    $count++;
} #next sweepid

#and shut down...
close (INCFILE);
close (UDOFILE);
print "\nConversion of \"$groupname\" completed.\n$count ";
if ($count==1) {print 'sweep ';}
else{ print 'sweeps '; }
print "found and converted.\n";
exit;


sub ProcessSphere(@) {
    my $current=$_[0];
    my $sweepname = $_[1];
    my $numeric= qr/[\+|\-]?\d+\.?\d*/;
    my $vector= qr/\<$numeric\s*\,\s*$numeric\s*\,\s*$numeric\s*\>/;
    my $altvector = qr/$numeric\*[xyz]/;
    my $radius=1;

    if ($_[0] =~ /scale\s*($vector)/) {
        ($xs,$ys,$zs)= $1 =~ /$numeric/g;
        $radius = ($xs+$ys+$zs)/3;
    }
    if ($_[0] =~ /scale\s*($numeric)/) {
        $radius = $1;
    }

    if ($_[0] =~ /sphere\s*\{\s*$vector\s*\,$numeric.*translate\s*($vector|$altvector)/ )
    {
        push @{$cp{$sweepname}}, "$1, $radius,\n    ";
    }
    else {
       die "Bad sphere found by ProcessSphere\n";
    }
}

sub ObtainSphere(@) { #isolate and consolidate a complete sphere object...
    my $current=$_[0];
    my $sweepname = $_[1];
    chomp($current);
    $current =~ s/(\/\/.*)$//;
    #check count of opening and close curly braces to see if we're done already...
    my $OB=$current=~tr/\{/\{/;
    my $CB=$current=~tr/\}/\}/;
    if ($OB && $OB==$CB) {
        return ProcessSphere($current,$sweepname);
    }
    else { #keep collecting lines until you reach the closing '}'...
        while ($nextline=<INPUTFILE>) {
            chomp $nextline;
            $nextline =~ s/(\/\/.*)$//;
            $current .= $nextline;
            $OB=$current=~tr/\{/\{/;
            $CB=$current=~tr/\}/\}/;
            if ($OB && $OB==$CB) {  #stop and process when final closing '}' has been found...
                return ProcessSphere($current,$sweepname);
            }
       }
    }
}

sub ObtainObject(@) { #isolate and consolidate a complete sphere object...
    my $current=$_[0];
    my $sweepname = $_[1];
    chomp($current);
    $current =~ s/(\/\/.*)$//;
    #check count of opening and close curly braces to see if we're done already...
    my $OB=$current=~tr/\{/\{/;
    my $CB=$current=~tr/\}/\}/;
    if ($OB && $OB==$CB) {
        $current =~ s/\s{2,}/ /g;
        return $current;
    }
    else { #keep collecting lines until you reach the closing '}'...
        while ($nextline=<INPUTFILE>) {
            chomp $nextline;
            $nextline =~ s/(\/\/.*)$//;
            $current .= $nextline;
            $OB=$current=~tr/\{/\{/;
            $CB=$current=~tr/\}/\}/;
            if ($OB && $OB==$CB) {  #stop and process when final closing '}' has been found...
                $current =~ s/\s{2,}/ /g;
                return $current;
            }
       }
    }
}