// Height Field Image Map for "Circles.pov" Scene
//
// Command Line : +FT +A0.0 +R3 +W1280 +H1024

/**************************/
/* Standard Includes */
#include "colors.inc"
/**************************/

/**************************/
/* Global Settings */
global_settings {
  assumed_gamma 2.2
  hf_gray_16
}
/**************************/

/**************************/
/* Camera */
camera { location <0, 0, -10> look_at <0, 0, 0> }
/**************************/

/**************************/
/* Light Sources */
light_source { <0, 20, -100> color White }
light_source {<10, 20, -100>  color Red }
/**************************/

/**************************/
/* Switch Plane */
#declare Plane = 1;
/**************************/

/**************************/
/* Foot Print */
#declare Foot_Print = merge {
  box {
    <0,0,0>,
    <1,0.5,1>
  }
  box {
    <0.1,   0, 0.1>,
    <0.9, 0.4, 0.9>
    translate x*.4
  }
  box {
    <0.1,   0, 0.1>,
    <0.9, 0.4, 0.9>
    translate z*-.4
  }
  box {
    <0.1,   0, 0.1>,
    <0.9, 0.4, 0.9>
    translate z*.4
  }
  box {
    <0.2,   0, 0.2>,
    <0.8, 0.3, 0.8>
    translate x*.7
  }
  box {
    <0.2,   0, 0.2>,
    <0.8, 0.3, 0.8>
    translate z*-.7
  }
  box {
    <0.2,   0, 0.2>,
    <0.8, 0.3, 0.8>
    translate z*.7
  }
  box {
    <0.3,   0, 0.3>,
    <0.7, 0.2, 0.7>
    translate x*.9
  }
  box {
    <0.3,   0, 0.3>,
    <0.7, 0.2, 0.7>
    translate z*-.9
  }
  box {
    <0.3,   0, 0.3>,
    <0.7, 0.2, 0.7>
    translate z*.9
  }
  pigment {
    rgbt <1,1,1,1>
  }
  no_shadow
}
/**************************/

/**************************/
/* Footsteps on Plane */
#declare FS_Plane = union {
  difference {   
    plane { z, 10
      pigment {
        bozo
        color_map {
          [0 0.5*White]
          [1 White]
        }
        scale 4
      }
      no_shadow
    }
    object { Foot_Print rotate x*90 rotate z*90 translate x*40 translate y*-38 translate z*39.9 scale .25}
    object { Foot_Print rotate x*90 rotate z*90 translate x*37 translate y*-35 translate z*39.9 scale .25}
    object { Foot_Print rotate x*90 rotate z*90 translate x*40 translate y*-32 translate z*39.9 scale .25}
    object { Foot_Print rotate x*90 rotate z*90 translate x*37 translate y*-29 translate z*39.9 scale .25}
    object { Foot_Print rotate x*90 rotate z*90 translate x*40 translate y*-26 translate z*39.9 scale .25}
    object { Foot_Print rotate x*90 rotate z*90 translate x*37 translate y*-23 translate z*39.9 scale .25}
    object { Foot_Print rotate x*90 rotate z*90 translate x*40 translate y*-20 translate z*39.9 scale .25}
    object { Foot_Print rotate x*90 rotate z*90 translate x*37 translate y*-17 translate z*39.9 scale .25}  
  }
  plane { z, 10
    pigment {
      bozo
      color_map {
        [0 0.5*White]
        [1 White]
      }
      scale 4
      translate z*.25
    }
  }
}  
#if (Plane)
 object { FS_Plane }
#end
/**************************/

