// Persistence of Vision Ray Tracer Scene Description File
// File: Cliche.pov
// Vers: 3.5
// Desc: Loneliness IRTC entry
// Date: 2002/08/13
// Auth: Joo Paulo Silva
// mail: jpgargoyle@sapo.pt
//
//    +AM2 +A0.0 +R2 -J                                                 
//  ===> test selection (sphere area)
//    +AM2 +A0.0 +R2 -J +sc0.500626 +sr0.464107 +ec0.730914 +er0.721202 

#version 3.5;        

#include "Lines.inc"           
#include "colors.inc"                

// ----- Used during tests
#declare Radiosity=on;                                  
#declare meFog=on; 
#declare meLight=on;

global_settings {
  //assumed_gamma 1.0
  
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.01
      count 500

      nearest_count 10
      error_bound 0.02
      recursion_limit 1

      low_error_factor 0.2
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1

      adc_bailout 0.01/2 
      
      always_sample off
    }
  #end
}

// ----- Default texture (used by the boxes)
#default {
  texture {
    pigment {color White * 1.5}
    finish {
        ambient 0.0 +0.1
        diffuse 0.6 -0.2        
        specular 0.3
    }
  }
}

// ----------------------------------------

// ----- won't work without one
camera {
  right x*image_width/image_height
  location  <-1,2.75,-4>       
  sky   <0.21,1,0>
  look_at   <-0.5,1,0>
}

// ----- An area light to cast softer shadows
#if (meLight)
light_source {
  0*x                 
  color rgb 0.950     
  area_light
  <8, 0, 0> <0, 0, 8> 
  4, 4                
  adaptive 0          
  jitter              
  circular            
  orient              
  translate <0, 80, -40>  
}
#end           
           

// ----- A little Fog to fade the horizon
// ----- so it wont show where the cubes finish ;)
#if (meFog)
  fog {
    fog_type   2
    distance   10
    color      rgb 1 
    fog_offset 0.1
    fog_alt    0.5
    turbulence 0.8
  }
#end  

// ----- My Sky Sphere
sphere {
  <0, 0, 0>, 1
  texture {
    pigment {  
      gradient z
      color_map {
        [0.0 color Blue+0.75]
        [0.2 color SlateBlue*0.75]
      }
    }
    finish { diffuse 1 ambient 0 }
  }
  hollow on
  no_shadow
  scale 3000
}

// ----------------------------------------

// ----- "ground" plane, with a squared grid
#declare Color01 = color red 1 green 1 blue 1 filter 1.0; // transparent color to let see textures under it
plane {        
  y, 0
  material {  
    texture { pigment { White*1.5 }  // "base" color
      finish {
        ambient 0.5
        diffuse 0.2
        specular 0.3 
      } 
    }
    texture { LinesX(Color01,Black,1) }  // Lines parallel to the X axis
    texture { LinesZ(Color01,Black,1) }  // Lines parallel to the z axis
  translate<0.5,0,0.5>
  }
}

// ----- THE sphere!!!
// Raio means Radius
#declare Raio = 0.25;
#declare Raio2 = Raio-0.05;

sphere { <0,Raio,0>, Raio
  pigment {color Black }
    finish {
      ambient 0.2
      reflection 0.12
      specular 1.0
      roughness 0.001
    }
}
                     
// ----- dimensions of the boxes "array"
#declare x_start = -30;
#declare x_end = x_start+80;
#declare z_start = -5;       
#declare z_end = z_start+150;

#declare R1 = seed(5);
#declare _x = x_start;
#while (_x < x_end)
      #declare _z = z_start;  
      #while (_z < z_end)
            #if ((_x != 0) | (_z != 0))  // don't put a box at the sphere place (0,0)
               box { <-Raio2, 0, -Raio2>, <Raio2, 2*Raio2, +Raio2> 
                 rotate <0,50*rand(R1)-25,0>
                 translate <_x, 0, _z> 
               }
            #end
      #declare _z = _z+1;   
      #end
#declare _x = _x+1;   
#end

// ----- and that's all folks :)
