//  Persistence of Vision Raytracer V3.5
//  World definition file.
//
// This file was done by Txemi Jendrix for the IRTC TOpic "Loneliness"
// on 30/8/2002. It's free for non-commercial use.
// http://www.txemijendrix.com
// tji@txemijendrix.com
//
//  Contains 10 lights, 29 materials and 418 primitives.
//
//  This file was generated for POV-Ray V3.5 by
//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//  Date : 08/30/2002    (30.08.2002)
//

global_settings {
  adc_bailout 0.003922
  ambient_light <0.0,0.0,0.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera03
  location  <     37.527,      -4.314,       7.045>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.52426,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         33.25000    // Vertical      22.167
  look_at   <      3.061,       5.351,       6.158>
}

//
// *******  L I G H T S *******
//

light_source {   // Light004
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*3.0000
  fade_distance  3.0
  fade_power 2.0
  translate  11.25*z
}

light_source {   // Spotlight Spotlight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.853, 0.147>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    15.000  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
  rotate <0.0, 80.0, -25.0>
  translate  <25.311744, 0.0, 4.049879>
}

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.3570
  fade_distance  150.0
  fade_power 2.0
  translate  <302.305546, 8.089429, 300.728978>
}


light_source {   // Arealight Arealight001
  <0.0, 0.0, 0.0>
  color rgb <0.914, 0.957, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 2
  adaptive 1
  fade_distance  15.0
  fade_power 2.0
  translate  10.494248*z
}


light_source {   // Spotlight Spotlight002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.853, 0.147>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    15.000  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
  rotate <0.0, 80.0, -25.0>
  translate  <28.063608, 6.227903, 4.049879>
}

light_source {   // Light009
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.600, 0.000>
  fade_distance  0.3
  fade_power 2.0
  translate  <-2.5, -2.5, 11.25>
}

light_source {   // Light010
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.600, 0.000>
  fade_distance  0.3
  fade_power 2.0
  translate  <2.5, -2.5, 11.25>
}

light_source {   // Light011
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.600, 0.000>
  fade_distance  0.3
  fade_power 2.0
  translate  <2.5, 2.5, 11.25>
}

light_source {   // Light012
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.600, 0.000>
  fade_distance  0.3
  fade_power 2.0
  translate  <-2.5, 2.5, 11.25>
}


//
// ********  MATERIALS  *******
//

#include "fantasma.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Cylndr001 = object {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 10.0>
    translate  <-2.0, 2.0, -5.0>
  }
}
#declare Cylndr005 = object {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 11.0>
    translate  <-1.85, 1.85, -5.5>
  }
}
#declare cristales_panel1 = union {
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.8, 2.1>
    translate  <-2.1, 0.0, 2.5>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.8, 2.1>
    translate  <-2.1, 0.0, -2.5>
  }
  material {
    negro_txt
  }
}
#declare panel = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.0, 5.0>
    translate  -2.1*x
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.7, 2.0>
    translate  <-2.1, 0.0, 2.5>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.7, 2.0>
    translate  <-2.1, 0.0, -2.5>
  }
  object { cristales_panel1 }
  translate  2.1*x
}
#declare cristales_panel = union {
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.8, 2.1>
    translate  <-2.1, 0.0, 2.5>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.8, 2.1>
    translate  <-2.1, 0.0, -2.5>
  }
  material {
    cristal_cabina_txt
  }
  translate  2.1*x
}
#declare panel_cabina_1 = union {
  object { panel }
  object { cristales_panel }
  translate  -2.1*x
}
#declare Cylndr009 = object {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.1>
  }
}
#declare bisagra = union {
  object { Cylndr009 }
  object { // Cylndr010 -> Cylndr009
    Cylndr009
    material {
      negro_txt
    }
    scale <1.0, 1.0, 3.0>
    translate  0.105*z
  }
  object { // Cylndr011 -> Cylndr009
    Cylndr009
    translate  0.409048*z
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <0.04, 0.04, 0.42>
    translate  0.045704*z
  }
  translate  -4.0*z
}
#declare Cylndr014 = object {
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    material {
      luz_amarilla_txt
    }
    hollow
    scale <0.2, 0.2, 10.0>
    translate  <-2.0, 2.0, -5.0>
  }
}
#declare Cylndr018 = object {
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    material {
      techo_txt
    }
    hollow
    scale <0.1, 0.1, 11.0>
    translate  <-1.85, 1.85, -5.5>
  }
}
#declare letrero_base = difference {
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.1, 0.5>
    translate  10.5*z
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <1.7, 0.2, 0.435177>
    translate  10.5*z
  }
}
#declare letrero_1 = union {
  object { letrero_base }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    material {
      letreros_txt
    }
    scale <1.71, 0.05, 0.436>
    translate  10.5*z
  }
  translate  -2.1*y
}
#declare Cylndr022 = object {
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 10.0>
    translate  <-2.0, 2.0, -5.0>
  }
}
#declare Cylndr026 = object {
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 11.0>
    translate  <-1.85, 1.85, -5.5>
  }
}
#declare letrero_base1 = difference {
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.1, 0.5>
    translate  10.5*z
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    scale <1.7, 0.2, 0.435177>
    translate  10.5*z
  }
}
#declare restairepanel = union {
  box { // restaire
    <-1, -1, -1>, <1, 1, 1>
    scale <0.447984, 0.14, 0.07936>
    translate  11.266294*z
  }
  box { // restaire2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.447984, 0.14, 0.07936>
    translate  <1.153568, 0.0, 11.266294>
  }
  box { // restaire3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.447984, 0.14, 0.07936>
    translate  <-1.15357, 0.0, 11.266294>
  }
  scale <1.0, 0.5, 0.75>
  translate  <0.0, -2.098362, 2.883666>
}
#declare restaire_paneles = union {
  object { restairepanel }
  object { // restairepanel1 -> restairepanel
    restairepanel
    rotate -90.0*z
  }
  object { // restairepanel2 -> restairepanel
    restairepanel
    rotate -180.0*z
  }
  object { // restairepanel3 -> restairepanel
    restairepanel
    rotate 90.0*z
  }
}
#declare resta_Aire_tejado = union {
  object { restaire_paneles }
  object { // restaire_paneles1 -> restaire_paneles
    restaire_paneles
    translate  -0.2*z
  }
  rotate -0.0*x
  translate  <0.0, -0.0, -0.0>
}
#declare CSG001 = difference {
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    scale <1.71, 0.05, 0.218>
    rotate -0.0*x
    translate  <0.0, -2.1, 11.25>
  }
  object { resta_Aire_tejado }
  scale <1.0, 1.0, 2.0>
  rotate 0.0*x
  translate  <0.0, 2.1, -12.0>
}
#declare letrero_5 = union {
  object { letrero_base1 }
  object { CSG001 }
  translate  -2.1*y
}
#declare resp_bas = union {
  sphere { // Sphere001
    <0,0,0>,1
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
  }
  sphere { // Sphere002
    <0,0,0>,1
    translate  5.0*z
  }
}
#declare resp_bas1 = union {
  sphere { // Sphere003
    <0,0,0>,1
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
  }
  sphere { // Sphere004
    <0,0,0>,1
    translate  5.0*z
  }
  scale <0.9, 0.9, 0.98>
  translate  0.057823*z
}
#declare resp_hueco = difference {
  object { resp_bas }
  object { resp_bas1 }
  scale <0.125, 0.125, 0.15>
  rotate -90.0*y
  translate  <0.375978, 0.0, 11.257227>
}
#declare respira = difference {
  object { resp_hueco }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale <0.55, 0.14, 0.12525>
    translate  11.131175*z
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    scale <0.55, 0.14, 0.12525>
    translate  <0.0, 0.150416, 11.273942>
  }
  translate  -1.149644*x
}
#declare respiradero = union {
  object { respira }
  object { // respira1 -> respira
    respira
    translate  1.149644*x
  }
  object { // respira2 -> respira
    respira
    translate  2.29928*x
  }
  translate  <0.0, -2.089998, 0.042937>
}
#declare respiraderos = union {
  object { respiradero }
  object { // respiradero1 -> respiradero
    respiradero
    rotate -90.0*z
  }
  object { // respiradero2 -> respiradero
    respiradero
    rotate -180.0*z
  }
  object { // respiradero3 -> respiradero
    respiradero
    rotate 90.0*z
  }
}
#declare SuperQ002 = object {
  superellipsoid { // SuperQ002
    <0.1, 0.1>
    material {
      T_Stone35
    }
    scale <2.25, 0.25, 0.5>
    translate  -2.00618*y
  }
}
#declare Sphere005 = object {
  sphere { // Sphere005
    <0,0,0>,1
    scale 0.15
    translate  <-0.283719, -0.524263, 0.0>
  }
}
#declare CSG002 = union {
  object { Sphere005 }
  object { // Sphere006 -> Sphere005
    Sphere005
    translate  0.35*y
  }
  object { // Sphere007 -> Sphere005
    Sphere005
    translate  0.7*y
  }
  object { // Sphere008 -> Sphere005
    Sphere005
    translate  1.05*y
  }
  translate  -0.064762*x
}
#declare Sphere009 = object {
  sphere { // Sphere009
    <0,0,0>,1
    scale <0.15, 0.15, 0.075>
    translate  <-0.283719, -0.524263, 0.152965>
  }
}
#declare CSG005 = union {
  object { Sphere009 }
  object { // Sphere010 -> Sphere009
    Sphere009
    translate  0.35*y
  }
  object { // Sphere011 -> Sphere009
    Sphere009
    translate  0.7*y
  }
  object { // Sphere012 -> Sphere009
    Sphere009
    translate  1.05*y
  }
  translate  -0.064762*x
}


#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -6.0,0.0
  9  // control points
  <0.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 0.5>,
  <0.969388, 0.739796>,
  <0.918367, 0.877551>,
  <0.746599, 0.962585>,
  <0.5, 1.0>,
  <0.0, 1.0>,
  <0.0, -1.0>
  rotate -x*90
  material {
    T_Stone35
  }
  scale 0.6
  rotate 90.0*x
  translate  <5.003439, -5.873029, -0.477388>
}


#declare Cylndr059 = object {
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.2>
    rotate -90.0*y
    translate  <1.1, -1.0, 0.2>
  }
}
#declare bordes_resta3 = union {
  object { Cylndr059 }
  object { // Cylndr060 -> Cylndr059
    Cylndr059
    rotate <0.0, -0.0, -90.0>
    translate  <0.002625, 0.006538, 0.0>
  }
  object { // Cylndr061 -> Cylndr059
    Cylndr059
    rotate <0.0, -0.0, -180.0>
    translate  <0.013075, -0.0, 0.0>
  }
  object { // Cylndr062 -> Cylndr059
    Cylndr059
    rotate <0.0, -0.0, 90.0>
    translate  <0.013125, 0.00005, 0.0>
  }
}
#declare bilbao_baldosa29 = difference {
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.2>
  }
  object { bordes_resta3 }
  material {
    T_Stone44
  }
  scale 0.45
  translate  <2.742625, -9.021028, 0.033866>
}
#declare baldosa_plana1 = union {
  object { bilbao_baldosa29 }
  object { // bilbao_baldosa30 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 0.9025, 0.0>
  }
  object { // bilbao_baldosa31 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 1.805, 0.0>
  }
  object { // bilbao_baldosa32 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 2.7075, 0.0>
  }
  object { // bilbao_baldosa33 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 3.61, 0.0>
  }
  object { // bilbao_baldosa42 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 4.5125, 0.0>
  }
  object { // bilbao_baldosa43 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 5.415, 0.0>
  }
  object { // bilbao_baldosa44 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 6.3175, 0.0>
  }
  object { // bilbao_baldosa45 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 7.22, 0.0>
  }
  object { // bilbao_baldosa46 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 8.1225, 0.0>
  }
  object { // bilbao_baldosa47 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 9.025, 0.0>
  }
  object { // bilbao_baldosa48 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 9.9275, 0.0>
  }
  object { // bilbao_baldosa49 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 10.83, 0.0>
  }
  object { // bilbao_baldosa50 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 11.7325, 0.0>
  }
  object { // bilbao_baldosa51 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 12.635, 0.0>
  }
  object { // bilbao_baldosa52 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 13.5375, 0.0>
  }
  object { // bilbao_baldosa53 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 14.44, 0.0>
  }
  object { // bilbao_baldosa54 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 15.3425, 0.0>
  }
  object { // bilbao_baldosa55 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 16.245, 0.0>
  }
  object { // bilbao_baldosa56 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 17.1475, 0.0>
  }
  object { // bilbao_baldosa57 -> bilbao_baldosa29
    bilbao_baldosa29
    rotate -0.0*z
    translate  <0.0, 18.05, 0.0>
  }
  translate  0.9025*x
}
#declare CSG008 = union {
  object { baldosa_plana1 }
  object { // baldosa_plana2 -> baldosa plana1
    baldosa_plana1
    translate  18.9525*y
  }
}


#declare Cylndr032 = object {
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.2>
    rotate -90.0*y
    translate  <1.1, -1.0, 0.2>
  }
}
#declare bordes_resta1 = union {
  object { Cylndr032 }
  object { // Cylndr033 -> Cylndr032
    Cylndr032
    rotate <0.0, -0.0, -90.0>
    translate  <0.002625, 0.006538, 0.0>
  }
  object { // Cylndr034 -> Cylndr032
    Cylndr032
    rotate <0.0, -0.0, -180.0>
    translate  <0.013075, -0.0, 0.0>
  }
  object { // Cylndr035 -> Cylndr032
    Cylndr032
    rotate <0.0, -0.0, 90.0>
    translate  <0.013125, 0.00005, 0.0>
  }
}
#declare Cylndr036 = object {
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 0.6>
    rotate -90.0*x
    translate  <0.333333, 0.618076, 0.200834>
  }
}
#declare canales1 = union {
  object { Cylndr036 }
  object { // Cylndr037 -> Cylndr036
    Cylndr036
    rotate <0.0, -0.0, -90.0>
    translate  <0.002625, 0.006538, 0.0>
  }
  object { // Cylndr038 -> Cylndr036
    Cylndr036
    rotate <0.0, -0.0, -180.0>
    translate  <0.666666, 0.0, 0.0>
  }
  object { // Cylndr039 -> Cylndr036
    Cylndr036
    rotate <0.0, -0.0, 90.0>
    translate  <0.013125, 0.00005, 0.0>
  }
  translate  0.023*z
}
#declare Cylndr040 = object {
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 0.6>
    rotate -90.0*x
    translate  <0.0, 0.618076, 0.200834>
  }
}
#declare canales2 = union {
  object { Cylndr040 }
  object { // Cylndr041 -> Cylndr040
    Cylndr040
    rotate <0.0, -0.0, -90.0>
    translate  <0.3, 0.333333, 0.0>
  }
  object { // Cylndr042 -> Cylndr040
    Cylndr040
    rotate <0.0, -0.0, -180.0>
    translate  <0.013075, 0.009331, 0.0>
  }
  object { // Cylndr043 -> Cylndr040
    Cylndr040
    rotate <0.0, -0.0, 90.0>
    translate  <0.34929, -0.333333, 0.0>
  }
  translate  <-0.333333, 0.0, 0.023>
}
#declare Torus003 = object {
  torus { // Torus003
    0.2, 0.05  rotate -x*90
    translate  <-0.43, -0.43, 0.2>
  }
}
#declare flor = union {
  object { Torus003 }
  object { // Torus004 -> Torus003
    Torus003
    rotate -90.0*z
  }
  object { // Torus005 -> Torus003
    Torus003
    rotate -180.0*z
  }
  object { // Torus006 -> Torus003
    Torus003
    rotate 90.0*z
  }
  torus { // Torus002
    0.4, 0.075  rotate -x*90
    translate  0.23*z
  }
}
#declare bilbao_baldosa = difference {
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.2>
  }
  object { bordes_resta1 }
  object { canales1 }
  object { canales2 }
  object { flor }
  material {
    T_Stone44
  }
  scale 0.45
  translate  <2.742625, -9.021028, 0.033866>
}
#declare baldosa_entera = union {
  object { bilbao_baldosa }
  object { // bilbao_baldosa1 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 0.9025, 0.0>
  }
  object { // bilbao_baldosa2 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 1.805, 0.0>
  }
  object { // bilbao_baldosa3 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 2.7075, 0.0>
  }
  object { // bilbao_baldosa4 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 3.61, 0.0>
  }
  object { // bilbao_baldosa5 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 4.5125, 0.0>
  }
  object { // bilbao_baldosa6 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 5.415, 0.0>
  }
  object { // bilbao_baldosa7 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 6.3175, 0.0>
  }
  object { // bilbao_baldosa8 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 7.22, 0.0>
  }
  object { // bilbao_baldosa9 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 8.1225, 0.0>
  }
  object { // bilbao_baldosa10 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 9.025, 0.0>
  }
  object { // bilbao_baldosa11 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 9.9275, 0.0>
  }
  object { // bilbao_baldosa12 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 10.83, 0.0>
  }
  object { // bilbao_baldosa13 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 11.7325, 0.0>
  }
  object { // bilbao_baldosa14 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 12.635, 0.0>
  }
  object { // bilbao_baldosa15 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 13.5375, 0.0>
  }
  object { // bilbao_baldosa16 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 14.44, 0.0>
  }
  object { // bilbao_baldosa17 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 15.3425, 0.0>
  }
  object { // bilbao_baldosa18 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 16.245, 0.0>
  }
  object { // bilbao_baldosa19 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 17.1475, 0.0>
  }
  object { // bilbao_baldosa20 -> bilbao_baldosa
    bilbao_baldosa
    rotate -0.0*z
    translate  <0.0, 18.05, 0.0>
  }
  translate  -5.415*x
}
#declare Cylndr044 = object {
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.2>
    rotate -90.0*y
    translate  <1.1, -1.0, 0.2>
  }
}
#declare bordes_resta2 = union {
  object { Cylndr044 }
  object { // Cylndr045 -> Cylndr044
    Cylndr044
    rotate <0.0, -0.0, -90.0>
    translate  <0.002625, 0.006538, 0.0>
  }
  object { // Cylndr046 -> Cylndr044
    Cylndr044
    rotate <0.0, -0.0, -180.0>
    translate  <0.013075, -0.0, 0.0>
  }
  object { // Cylndr047 -> Cylndr044
    Cylndr044
    rotate <0.0, -0.0, 90.0>
    translate  <0.013125, 0.00005, 0.0>
  }
}
#declare Cylndr048 = object {
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 0.6>
    rotate -90.0*x
    translate  <0.333333, 0.618076, 0.200834>
  }
}
#declare canales3 = union {
  object { Cylndr048 }
  object { // Cylndr049 -> Cylndr048
    Cylndr048
    rotate <0.0, -0.0, -90.0>
    translate  <0.002625, 0.006538, 0.0>
  }
  object { // Cylndr050 -> Cylndr048
    Cylndr048
    rotate <0.0, -0.0, -180.0>
    translate  <0.666666, 0.0, 0.0>
  }
  object { // Cylndr051 -> Cylndr048
    Cylndr048
    rotate <0.0, -0.0, 90.0>
    translate  <0.013125, 0.00005, 0.0>
  }
  translate  0.023*z
}
#declare Cylndr052 = object {
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    scale <0.075, 0.075, 0.6>
    rotate -90.0*x
    translate  <0.0, 0.618076, 0.200834>
  }
}
#declare canales4 = union {
  object { Cylndr052 }
  object { // Cylndr053 -> Cylndr052
    Cylndr052
    rotate <0.0, -0.0, -90.0>
    translate  <0.3, 0.333333, 0.0>
  }
  object { // Cylndr054 -> Cylndr052
    Cylndr052
    rotate <0.0, -0.0, -180.0>
    translate  <0.013075, 0.009331, 0.0>
  }
  object { // Cylndr055 -> Cylndr052
    Cylndr052
    rotate <0.0, -0.0, 90.0>
    translate  <0.34929, -0.333333, 0.0>
  }
  translate  <-0.333333, 0.0, 0.023>
}
#declare Torus007 = object {
  torus { // Torus007
    0.2, 0.05  rotate -x*90
    translate  <-0.43, -0.43, 0.2>
  }
}
#declare flor1 = union {
  object { Torus007 }
  object { // Torus008 -> Torus007
    Torus007
    rotate -90.0*z
  }
  object { // Torus009 -> Torus007
    Torus007
    rotate -180.0*z
  }
  object { // Torus010 -> Torus007
    Torus007
    rotate 90.0*z
  }
  torus { // Torus011
    0.4, 0.075  rotate -x*90
    translate  0.23*z
  }
}
#declare bilbao_baldosa21 = difference {
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.2>
  }
  object { bordes_resta2 }
  object { canales3 }
  object { canales4 }
  object { flor1 }
  material {
    T_Stone44
  }
  scale 0.45
  translate  <1.84012, -9.021028, 0.033866>
}
#declare baldosa_partida = union {
  object { bilbao_baldosa21 }
  object { // bilbao_baldosa22 -> bilbao_baldosa21
    bilbao_baldosa21
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 0.9025, -0.0>
  }
  object { // bilbao_baldosa23 -> bilbao_baldosa21
    bilbao_baldosa21
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 1.805, -0.0>
  }
  object { // bilbao_baldosa24 -> bilbao_baldosa21
    bilbao_baldosa21
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 2.7075, -0.0>
  }
  object { // bilbao_baldosa25 -> bilbao_baldosa21
    bilbao_baldosa21
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 3.61, -0.0>
  }
  object { // bilbao_baldosa26 -> bilbao_baldosa21
    bilbao_baldosa21
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 4.5125, -0.0>
  }
  object { // bilbao_baldosa27 -> bilbao_baldosa21
    bilbao_baldosa21
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 5.415, -0.0>
  }
  object { // bilbao_baldosa28 -> bilbao_baldosa21
    bilbao_baldosa21
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 6.3175, -0.0>
  }
  object { // bilbao_baldosa34 -> bilbao_baldosa21
    bilbao_baldosa21
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 11.7325, -0.0>
  }
  object { // bilbao_baldosa35 -> bilbao_baldosa21
    bilbao_baldosa21
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 12.635, -0.0>
  }
  object { // bilbao_baldosa36 -> bilbao_baldosa21
    bilbao_baldosa21
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 13.5375, -0.0>
  }
  object { // bilbao_baldosa37 -> bilbao_baldosa21
    bilbao_baldosa21
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 14.44, -0.0>
  }
  object { // bilbao_baldosa38 -> bilbao_baldosa21
    bilbao_baldosa21
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 15.3425, -0.0>
  }
  object { // bilbao_baldosa39 -> bilbao_baldosa21
    bilbao_baldosa21
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 16.245, -0.0>
  }
  object { // bilbao_baldosa40 -> bilbao_baldosa21
    bilbao_baldosa21
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 17.1475, -0.0>
  }
  object { // bilbao_baldosa41 -> bilbao_baldosa21
    bilbao_baldosa21
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 18.05, -0.0>
  }
}
#declare baldosa_entera14 = object {
  object { // baldosa_entera14 -> baldosa entera
    baldosa_entera
    translate  <5.415, 18.9525, 0.0>
  }
}


#declare juego_bolas = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.148170, -0.085546, 1.347625>, <-0.134886, -0.108556, 1.347625>, <-0.108556, -0.134886, 1.347625>, <-0.085546, -0.148170, 1.347625>, 
      <-0.168590, -0.097335, 1.347625>, <-0.155305, -0.120345, 1.347625>, <-0.120345, -0.155305, 1.347625>, <-0.097336, -0.168590, 1.347625>, 
      <-0.185583, -0.107146, 1.367246>, <-0.168944, -0.135966, 1.367246>, <-0.135966, -0.168944, 1.367246>, <-0.107146, -0.185583, 1.367246>, 
      <-0.185583, -0.107146, 1.390825>, <-0.168944, -0.135966, 1.390825>, <-0.135966, -0.168944, 1.390825>, <-0.107146, -0.185583, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.110758, -0.063946, 1.390825>, <-0.100828, -0.081146, 1.390825>, <-0.081146, -0.100828, 1.390825>, <-0.063946, -0.110758, 1.390825>, 
      <-0.110758, -0.063946, 1.367246>, <-0.100828, -0.081146, 1.367246>, <-0.081146, -0.100828, 1.367246>, <-0.063946, -0.110758, 1.367246>, 
      <-0.127751, -0.073757, 1.347625>, <-0.114466, -0.096767, 1.347625>, <-0.096767, -0.114466, 1.347625>, <-0.073757, -0.127751, 1.347625>, 
      <-0.148170, -0.085546, 1.347625>, <-0.134886, -0.108556, 1.347625>, <-0.108556, -0.134886, 1.347625>, <-0.085546, -0.148170, 1.347625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.148170, -0.085546, 1.434025>, <-0.134886, -0.108556, 1.434025>, <-0.108556, -0.134886, 1.434025>, <-0.085546, -0.148170, 1.434025>, 
      <-0.127751, -0.073757, 1.434025>, <-0.114466, -0.096767, 1.434025>, <-0.096767, -0.114466, 1.434025>, <-0.073757, -0.127751, 1.434025>, 
      <-0.110758, -0.063946, 1.414403>, <-0.100828, -0.081146, 1.414403>, <-0.081146, -0.100828, 1.414403>, <-0.063946, -0.110758, 1.414403>, 
      <-0.110758, -0.063946, 1.390825>, <-0.100828, -0.081146, 1.390825>, <-0.081146, -0.100828, 1.390825>, <-0.063946, -0.110758, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.185583, -0.107146, 1.390825>, <-0.168944, -0.135966, 1.390825>, <-0.135966, -0.168944, 1.390825>, <-0.107146, -0.185583, 1.390825>, 
      <-0.185583, -0.107146, 1.414403>, <-0.168944, -0.135966, 1.414403>, <-0.135966, -0.168944, 1.414403>, <-0.107146, -0.185583, 1.414403>, 
      <-0.168590, -0.097335, 1.434025>, <-0.155305, -0.120345, 1.434025>, <-0.120345, -0.155305, 1.434025>, <-0.097336, -0.168590, 1.434025>, 
      <-0.148170, -0.085546, 1.434025>, <-0.134886, -0.108556, 1.434025>, <-0.108556, -0.134886, 1.434025>, <-0.085546, -0.148170, 1.434025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.085546, -0.148170, 1.347625>, <-0.062537, -0.161455, 1.347625>, <-0.026569, -0.171092, 1.347625>, <0.000000, -0.171092, 1.347625>, 
      <-0.097336, -0.168590, 1.347625>, <-0.074326, -0.181875, 1.347625>, <-0.026569, -0.194671, 1.347625>, <0.000000, -0.194671, 1.347625>, 
      <-0.107146, -0.185583, 1.367246>, <-0.078327, -0.202222, 1.367246>, <-0.033278, -0.214292, 1.367246>, <0.000000, -0.214292, 1.367246>, 
      <-0.107146, -0.185583, 1.390825>, <-0.078327, -0.202222, 1.390825>, <-0.033278, -0.214292, 1.390825>, <0.000000, -0.214292, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.063946, -0.110758, 1.390825>, <-0.046746, -0.120688, 1.390825>, <-0.019861, -0.127892, 1.390825>, <0.000000, -0.127892, 1.390825>, 
      <-0.063946, -0.110758, 1.367246>, <-0.046746, -0.120688, 1.367246>, <-0.019861, -0.127892, 1.367246>, <0.000000, -0.127892, 1.367246>, 
      <-0.073757, -0.127751, 1.347625>, <-0.050747, -0.141035, 1.347625>, <-0.026569, -0.147514, 1.347625>, <0.000000, -0.147514, 1.347625>, 
      <-0.085546, -0.148170, 1.347625>, <-0.062537, -0.161455, 1.347625>, <-0.026569, -0.171092, 1.347625>, <0.000000, -0.171092, 1.347625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.085546, -0.148170, 1.434025>, <-0.062537, -0.161455, 1.434025>, <-0.026569, -0.171092, 1.434025>, <0.000000, -0.171092, 1.434025>, 
      <-0.073757, -0.127751, 1.434025>, <-0.050747, -0.141035, 1.434025>, <-0.026569, -0.147514, 1.434025>, <0.000000, -0.147514, 1.434025>, 
      <-0.063946, -0.110758, 1.414403>, <-0.046746, -0.120688, 1.414403>, <-0.019861, -0.127892, 1.414403>, <0.000000, -0.127892, 1.414403>, 
      <-0.063946, -0.110758, 1.390825>, <-0.046746, -0.120688, 1.390825>, <-0.019861, -0.127892, 1.390825>, <0.000000, -0.127892, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.107146, -0.185583, 1.390825>, <-0.078327, -0.202222, 1.390825>, <-0.033278, -0.214292, 1.390825>, <0.000000, -0.214292, 1.390825>, 
      <-0.107146, -0.185583, 1.414403>, <-0.078327, -0.202222, 1.414403>, <-0.033278, -0.214292, 1.414403>, <0.000000, -0.214292, 1.414403>, 
      <-0.097336, -0.168590, 1.434025>, <-0.074326, -0.181875, 1.434025>, <-0.026569, -0.194671, 1.434025>, <0.000000, -0.194671, 1.434025>, 
      <-0.085546, -0.148170, 1.434025>, <-0.062537, -0.161455, 1.434025>, <-0.026569, -0.171092, 1.434025>, <0.000000, -0.171092, 1.434025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.171092, 1.347625>, <0.026569, -0.171092, 1.347625>, <0.062537, -0.161455, 1.347625>, <0.085546, -0.148170, 1.347625>, 
      <0.000000, -0.194671, 1.347625>, <0.026569, -0.194671, 1.347625>, <0.074326, -0.181875, 1.347625>, <0.097335, -0.168590, 1.347625>, 
      <0.000000, -0.214292, 1.367246>, <0.033278, -0.214292, 1.367246>, <0.078327, -0.202222, 1.367246>, <0.107146, -0.185583, 1.367246>, 
      <0.000000, -0.214292, 1.390825>, <0.033278, -0.214292, 1.390825>, <0.078327, -0.202222, 1.390825>, <0.107146, -0.185583, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.127892, 1.390825>, <0.019861, -0.127892, 1.390825>, <0.046746, -0.120688, 1.390825>, <0.063946, -0.110758, 1.390825>, 
      <0.000000, -0.127892, 1.367246>, <0.019861, -0.127892, 1.367246>, <0.046746, -0.120688, 1.367246>, <0.063946, -0.110758, 1.367246>, 
      <0.000000, -0.147514, 1.347625>, <0.026569, -0.147514, 1.347625>, <0.050747, -0.141035, 1.347625>, <0.073757, -0.127751, 1.347625>, 
      <0.000000, -0.171092, 1.347625>, <0.026569, -0.171092, 1.347625>, <0.062537, -0.161455, 1.347625>, <0.085546, -0.148170, 1.347625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.171092, 1.434025>, <0.026569, -0.171092, 1.434025>, <0.062537, -0.161455, 1.434025>, <0.085546, -0.148170, 1.434025>, 
      <0.000000, -0.147514, 1.434025>, <0.026569, -0.147514, 1.434025>, <0.050747, -0.141035, 1.434025>, <0.073757, -0.127751, 1.434025>, 
      <0.000000, -0.127892, 1.414403>, <0.019861, -0.127892, 1.414403>, <0.046746, -0.120688, 1.414403>, <0.063946, -0.110758, 1.414403>, 
      <0.000000, -0.127892, 1.390825>, <0.019861, -0.127892, 1.390825>, <0.046746, -0.120688, 1.390825>, <0.063946, -0.110758, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.214292, 1.390825>, <0.033278, -0.214292, 1.390825>, <0.078327, -0.202222, 1.390825>, <0.107146, -0.185583, 1.390825>, 
      <0.000000, -0.214292, 1.414403>, <0.033278, -0.214292, 1.414403>, <0.078327, -0.202222, 1.414403>, <0.107146, -0.185583, 1.414403>, 
      <0.000000, -0.194671, 1.434025>, <0.026569, -0.194671, 1.434025>, <0.074326, -0.181875, 1.434025>, <0.097336, -0.168590, 1.434025>, 
      <0.000000, -0.171092, 1.434025>, <0.026569, -0.171092, 1.434025>, <0.062537, -0.161455, 1.434025>, <0.085546, -0.148170, 1.434025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.085546, -0.148170, 1.347625>, <0.108556, -0.134886, 1.347625>, <0.134886, -0.108556, 1.347625>, <0.148170, -0.085546, 1.347625>, 
      <0.097335, -0.168590, 1.347625>, <0.120345, -0.155305, 1.347625>, <0.155305, -0.120345, 1.347625>, <0.168590, -0.097336, 1.347625>, 
      <0.107146, -0.185583, 1.367246>, <0.135966, -0.168944, 1.367246>, <0.168944, -0.135966, 1.367246>, <0.185583, -0.107146, 1.367246>, 
      <0.107146, -0.185583, 1.390825>, <0.135966, -0.168944, 1.390825>, <0.168944, -0.135966, 1.390825>, <0.185583, -0.107146, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.063946, -0.110758, 1.390825>, <0.081146, -0.100828, 1.390825>, <0.100828, -0.081146, 1.390825>, <0.110758, -0.063946, 1.390825>, 
      <0.063946, -0.110758, 1.367246>, <0.081146, -0.100828, 1.367246>, <0.100828, -0.081146, 1.367246>, <0.110758, -0.063946, 1.367246>, 
      <0.073757, -0.127751, 1.347625>, <0.096767, -0.114466, 1.347625>, <0.114466, -0.096767, 1.347625>, <0.127751, -0.073757, 1.347625>, 
      <0.085546, -0.148170, 1.347625>, <0.108556, -0.134886, 1.347625>, <0.134886, -0.108556, 1.347625>, <0.148170, -0.085546, 1.347625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.085546, -0.148170, 1.434025>, <0.108556, -0.134886, 1.434025>, <0.134886, -0.108556, 1.434025>, <0.148170, -0.085546, 1.434025>, 
      <0.073757, -0.127751, 1.434025>, <0.096767, -0.114466, 1.434025>, <0.114466, -0.096767, 1.434025>, <0.127751, -0.073757, 1.434025>, 
      <0.063946, -0.110758, 1.414403>, <0.081146, -0.100828, 1.414403>, <0.100828, -0.081146, 1.414403>, <0.110758, -0.063946, 1.414403>, 
      <0.063946, -0.110758, 1.390825>, <0.081146, -0.100828, 1.390825>, <0.100828, -0.081146, 1.390825>, <0.110758, -0.063946, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107146, -0.185583, 1.390825>, <0.135966, -0.168944, 1.390825>, <0.168944, -0.135966, 1.390825>, <0.185583, -0.107146, 1.390825>, 
      <0.107146, -0.185583, 1.414403>, <0.135966, -0.168944, 1.414403>, <0.168944, -0.135966, 1.414403>, <0.185583, -0.107146, 1.414403>, 
      <0.097336, -0.168590, 1.434025>, <0.120345, -0.155305, 1.434025>, <0.155305, -0.120345, 1.434025>, <0.168590, -0.097336, 1.434025>, 
      <0.085546, -0.148170, 1.434025>, <0.108556, -0.134886, 1.434025>, <0.134886, -0.108556, 1.434025>, <0.148170, -0.085546, 1.434025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.148170, -0.085546, 1.347625>, <0.161455, -0.062537, 1.347625>, <0.171092, -0.026569, 1.347625>, <0.171092, 0.000000, 1.347625>, 
      <0.168590, -0.097336, 1.347625>, <0.181874, -0.074326, 1.347625>, <0.194671, -0.026569, 1.347625>, <0.194671, 0.000000, 1.347625>, 
      <0.185583, -0.107146, 1.367246>, <0.202222, -0.078327, 1.367246>, <0.214292, -0.033278, 1.367246>, <0.214292, 0.000000, 1.367246>, 
      <0.185583, -0.107146, 1.390825>, <0.202222, -0.078327, 1.390825>, <0.214292, -0.033278, 1.390825>, <0.214292, 0.000000, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.110758, -0.063946, 1.390825>, <0.120688, -0.046746, 1.390825>, <0.127892, -0.019861, 1.390825>, <0.127892, 0.000000, 1.390825>, 
      <0.110758, -0.063946, 1.367246>, <0.120688, -0.046746, 1.367246>, <0.127892, -0.019861, 1.367246>, <0.127892, 0.000000, 1.367246>, 
      <0.127751, -0.073757, 1.347625>, <0.141035, -0.050747, 1.347625>, <0.147514, -0.026569, 1.347625>, <0.147514, 0.000000, 1.347625>, 
      <0.148170, -0.085546, 1.347625>, <0.161455, -0.062537, 1.347625>, <0.171092, -0.026569, 1.347625>, <0.171092, 0.000000, 1.347625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.148170, -0.085546, 1.434025>, <0.161455, -0.062537, 1.434025>, <0.171092, -0.026569, 1.434025>, <0.171092, 0.000000, 1.434025>, 
      <0.127751, -0.073757, 1.434025>, <0.141035, -0.050747, 1.434025>, <0.147514, -0.026569, 1.434025>, <0.147514, 0.000000, 1.434025>, 
      <0.110758, -0.063946, 1.414403>, <0.120688, -0.046746, 1.414403>, <0.127892, -0.019861, 1.414403>, <0.127892, 0.000000, 1.414403>, 
      <0.110758, -0.063946, 1.390825>, <0.120688, -0.046746, 1.390825>, <0.127892, -0.019861, 1.390825>, <0.127892, 0.000000, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.185583, -0.107146, 1.390825>, <0.202222, -0.078327, 1.390825>, <0.214292, -0.033278, 1.390825>, <0.214292, 0.000000, 1.390825>, 
      <0.185583, -0.107146, 1.414403>, <0.202222, -0.078327, 1.414403>, <0.214292, -0.033278, 1.414403>, <0.214292, 0.000000, 1.414403>, 
      <0.168590, -0.097336, 1.434025>, <0.181875, -0.074326, 1.434025>, <0.194671, -0.026569, 1.434025>, <0.194671, 0.000000, 1.434025>, 
      <0.148170, -0.085546, 1.434025>, <0.161455, -0.062537, 1.434025>, <0.171092, -0.026569, 1.434025>, <0.171092, 0.000000, 1.434025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.171092, 0.000000, 1.347625>, <0.171092, 0.026569, 1.347625>, <0.161455, 0.062537, 1.347625>, <0.148170, 0.085546, 1.347625>, 
      <0.194671, 0.000000, 1.347625>, <0.194671, 0.026569, 1.347625>, <0.181875, 0.074326, 1.347625>, <0.168590, 0.097336, 1.347625>, 
      <0.214292, 0.000000, 1.367246>, <0.214292, 0.033278, 1.367246>, <0.202222, 0.078327, 1.367246>, <0.185583, 0.107146, 1.367246>, 
      <0.214292, 0.000000, 1.390825>, <0.214292, 0.033278, 1.390825>, <0.202222, 0.078327, 1.390825>, <0.185583, 0.107146, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.127892, 0.000000, 1.390825>, <0.127892, 0.019861, 1.390825>, <0.120688, 0.046746, 1.390825>, <0.110758, 0.063946, 1.390825>, 
      <0.127892, 0.000000, 1.367246>, <0.127892, 0.019861, 1.367246>, <0.120688, 0.046746, 1.367246>, <0.110758, 0.063946, 1.367246>, 
      <0.147514, 0.000000, 1.347625>, <0.147514, 0.026569, 1.347625>, <0.141035, 0.050747, 1.347625>, <0.127751, 0.073757, 1.347625>, 
      <0.171092, 0.000000, 1.347625>, <0.171092, 0.026569, 1.347625>, <0.161455, 0.062537, 1.347625>, <0.148170, 0.085546, 1.347625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.171092, 0.000000, 1.434025>, <0.171092, 0.026569, 1.434025>, <0.161455, 0.062537, 1.434025>, <0.148170, 0.085546, 1.434025>, 
      <0.147514, 0.000000, 1.434025>, <0.147514, 0.026569, 1.434025>, <0.141035, 0.050747, 1.434025>, <0.127751, 0.073757, 1.434025>, 
      <0.127892, 0.000000, 1.414403>, <0.127892, 0.019861, 1.414403>, <0.120688, 0.046746, 1.414403>, <0.110758, 0.063946, 1.414403>, 
      <0.127892, 0.000000, 1.390825>, <0.127892, 0.019861, 1.390825>, <0.120688, 0.046746, 1.390825>, <0.110758, 0.063946, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.214292, 0.000000, 1.390825>, <0.214292, 0.033278, 1.390825>, <0.202222, 0.078327, 1.390825>, <0.185583, 0.107146, 1.390825>, 
      <0.214292, 0.000000, 1.414403>, <0.214292, 0.033278, 1.414403>, <0.202222, 0.078327, 1.414403>, <0.185583, 0.107146, 1.414403>, 
      <0.194671, 0.000000, 1.434025>, <0.194671, 0.026569, 1.434025>, <0.181875, 0.074326, 1.434025>, <0.168590, 0.097336, 1.434025>, 
      <0.171092, 0.000000, 1.434025>, <0.171092, 0.026569, 1.434025>, <0.161455, 0.062537, 1.434025>, <0.148170, 0.085546, 1.434025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.148170, 0.085546, 1.347625>, <0.134886, 0.108556, 1.347625>, <0.108556, 0.134886, 1.347625>, <0.085546, 0.148170, 1.347625>, 
      <0.168590, 0.097336, 1.347625>, <0.155305, 0.120345, 1.347625>, <0.120345, 0.155305, 1.347625>, <0.097336, 0.168590, 1.347625>, 
      <0.185583, 0.107146, 1.367246>, <0.168944, 0.135966, 1.367246>, <0.135966, 0.168944, 1.367246>, <0.107146, 0.185583, 1.367246>, 
      <0.185583, 0.107146, 1.390825>, <0.168944, 0.135966, 1.390825>, <0.135966, 0.168944, 1.390825>, <0.107146, 0.185583, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.110758, 0.063946, 1.390825>, <0.100828, 0.081146, 1.390825>, <0.081146, 0.100828, 1.390825>, <0.063946, 0.110758, 1.390825>, 
      <0.110758, 0.063946, 1.367246>, <0.100828, 0.081146, 1.367246>, <0.081146, 0.100828, 1.367246>, <0.063946, 0.110758, 1.367246>, 
      <0.127751, 0.073757, 1.347625>, <0.114466, 0.096767, 1.347625>, <0.096767, 0.114466, 1.347625>, <0.073757, 0.127751, 1.347625>, 
      <0.148170, 0.085546, 1.347625>, <0.134886, 0.108556, 1.347625>, <0.108556, 0.134886, 1.347625>, <0.085546, 0.148170, 1.347625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.148170, 0.085546, 1.434025>, <0.134886, 0.108556, 1.434025>, <0.108556, 0.134886, 1.434025>, <0.085546, 0.148170, 1.434025>, 
      <0.127751, 0.073757, 1.434025>, <0.114466, 0.096767, 1.434025>, <0.096767, 0.114466, 1.434025>, <0.073757, 0.127751, 1.434025>, 
      <0.110758, 0.063946, 1.414403>, <0.100828, 0.081146, 1.414403>, <0.081146, 0.100828, 1.414403>, <0.063946, 0.110758, 1.414403>, 
      <0.110758, 0.063946, 1.390825>, <0.100828, 0.081146, 1.390825>, <0.081146, 0.100828, 1.390825>, <0.063946, 0.110758, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.185583, 0.107146, 1.390825>, <0.168944, 0.135966, 1.390825>, <0.135966, 0.168944, 1.390825>, <0.107146, 0.185583, 1.390825>, 
      <0.185583, 0.107146, 1.414403>, <0.168944, 0.135966, 1.414403>, <0.135966, 0.168944, 1.414403>, <0.107146, 0.185583, 1.414403>, 
      <0.168590, 0.097336, 1.434025>, <0.155305, 0.120345, 1.434025>, <0.120345, 0.155305, 1.434025>, <0.097336, 0.168590, 1.434025>, 
      <0.148170, 0.085546, 1.434025>, <0.134886, 0.108556, 1.434025>, <0.108556, 0.134886, 1.434025>, <0.085546, 0.148170, 1.434025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.085546, 0.148170, 1.347625>, <0.062537, 0.161455, 1.347625>, <0.026569, 0.171092, 1.347625>, <0.000000, 0.171092, 1.347625>, 
      <0.097336, 0.168590, 1.347625>, <0.074326, 0.181874, 1.347625>, <0.026569, 0.194671, 1.347625>, <0.000000, 0.194671, 1.347625>, 
      <0.107146, 0.185583, 1.367246>, <0.078327, 0.202222, 1.367246>, <0.033278, 0.214292, 1.367246>, <0.000000, 0.214292, 1.367246>, 
      <0.107146, 0.185583, 1.390825>, <0.078327, 0.202222, 1.390825>, <0.033278, 0.214292, 1.390825>, <0.000000, 0.214292, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.063946, 0.110758, 1.390825>, <0.046746, 0.120688, 1.390825>, <0.019861, 0.127892, 1.390825>, <0.000000, 0.127892, 1.390825>, 
      <0.063946, 0.110758, 1.367246>, <0.046746, 0.120688, 1.367246>, <0.019861, 0.127892, 1.367246>, <0.000000, 0.127892, 1.367246>, 
      <0.073757, 0.127751, 1.347625>, <0.050747, 0.141035, 1.347625>, <0.026569, 0.147514, 1.347625>, <0.000000, 0.147514, 1.347625>, 
      <0.085546, 0.148170, 1.347625>, <0.062537, 0.161455, 1.347625>, <0.026569, 0.171092, 1.347625>, <0.000000, 0.171092, 1.347625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.085546, 0.148170, 1.434025>, <0.062537, 0.161455, 1.434025>, <0.026569, 0.171092, 1.434025>, <0.000000, 0.171092, 1.434025>, 
      <0.073757, 0.127751, 1.434025>, <0.050747, 0.141035, 1.434025>, <0.026569, 0.147514, 1.434025>, <0.000000, 0.147514, 1.434025>, 
      <0.063946, 0.110758, 1.414403>, <0.046746, 0.120688, 1.414403>, <0.019861, 0.127892, 1.414403>, <0.000000, 0.127892, 1.414403>, 
      <0.063946, 0.110758, 1.390825>, <0.046746, 0.120688, 1.390825>, <0.019861, 0.127892, 1.390825>, <0.000000, 0.127892, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107146, 0.185583, 1.390825>, <0.078327, 0.202222, 1.390825>, <0.033278, 0.214292, 1.390825>, <0.000000, 0.214292, 1.390825>, 
      <0.107146, 0.185583, 1.414403>, <0.078327, 0.202222, 1.414403>, <0.033278, 0.214292, 1.414403>, <0.000000, 0.214292, 1.414403>, 
      <0.097336, 0.168590, 1.434025>, <0.074326, 0.181875, 1.434025>, <0.026569, 0.194671, 1.434025>, <0.000000, 0.194671, 1.434025>, 
      <0.085546, 0.148170, 1.434025>, <0.062537, 0.161455, 1.434025>, <0.026569, 0.171092, 1.434025>, <0.000000, 0.171092, 1.434025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.171092, 1.347625>, <-0.026569, 0.171092, 1.347625>, <-0.062537, 0.161455, 1.347625>, <-0.085546, 0.148170, 1.347625>, 
      <0.000000, 0.194671, 1.347625>, <-0.026569, 0.194671, 1.347625>, <-0.074326, 0.181875, 1.347625>, <-0.097336, 0.168590, 1.347625>, 
      <0.000000, 0.214292, 1.367246>, <-0.033278, 0.214292, 1.367246>, <-0.078327, 0.202222, 1.367246>, <-0.107146, 0.185583, 1.367246>, 
      <0.000000, 0.214292, 1.390825>, <-0.033278, 0.214292, 1.390825>, <-0.078327, 0.202222, 1.390825>, <-0.107146, 0.185583, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.127892, 1.390825>, <-0.019861, 0.127892, 1.390825>, <-0.046746, 0.120688, 1.390825>, <-0.063946, 0.110758, 1.390825>, 
      <0.000000, 0.127892, 1.367246>, <-0.019861, 0.127892, 1.367246>, <-0.046746, 0.120688, 1.367246>, <-0.063946, 0.110758, 1.367246>, 
      <0.000000, 0.147514, 1.347625>, <-0.026569, 0.147514, 1.347625>, <-0.050747, 0.141035, 1.347625>, <-0.073757, 0.127751, 1.347625>, 
      <0.000000, 0.171092, 1.347625>, <-0.026569, 0.171092, 1.347625>, <-0.062537, 0.161455, 1.347625>, <-0.085546, 0.148170, 1.347625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.171092, 1.434025>, <-0.026569, 0.171092, 1.434025>, <-0.062537, 0.161455, 1.434025>, <-0.085546, 0.148170, 1.434025>, 
      <0.000000, 0.147514, 1.434025>, <-0.026569, 0.147514, 1.434025>, <-0.050747, 0.141035, 1.434025>, <-0.073757, 0.127751, 1.434025>, 
      <0.000000, 0.127892, 1.414403>, <-0.019861, 0.127892, 1.414403>, <-0.046746, 0.120688, 1.414403>, <-0.063946, 0.110758, 1.414403>, 
      <0.000000, 0.127892, 1.390825>, <-0.019861, 0.127892, 1.390825>, <-0.046746, 0.120688, 1.390825>, <-0.063946, 0.110758, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.214292, 1.390825>, <-0.033278, 0.214292, 1.390825>, <-0.078327, 0.202222, 1.390825>, <-0.107146, 0.185583, 1.390825>, 
      <0.000000, 0.214292, 1.414403>, <-0.033278, 0.214292, 1.414403>, <-0.078327, 0.202222, 1.414403>, <-0.107146, 0.185583, 1.414403>, 
      <0.000000, 0.194671, 1.434025>, <-0.026569, 0.194671, 1.434025>, <-0.074326, 0.181875, 1.434025>, <-0.097336, 0.168590, 1.434025>, 
      <0.000000, 0.171092, 1.434025>, <-0.026569, 0.171092, 1.434025>, <-0.062537, 0.161455, 1.434025>, <-0.085546, 0.148170, 1.434025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.085546, 0.148170, 1.347625>, <-0.108556, 0.134886, 1.347625>, <-0.134886, 0.108556, 1.347625>, <-0.148170, 0.085546, 1.347625>, 
      <-0.097336, 0.168590, 1.347625>, <-0.120345, 0.155305, 1.347625>, <-0.155305, 0.120345, 1.347625>, <-0.168590, 0.097336, 1.347625>, 
      <-0.107146, 0.185583, 1.367246>, <-0.135966, 0.168944, 1.367246>, <-0.168944, 0.135966, 1.367246>, <-0.185583, 0.107146, 1.367246>, 
      <-0.107146, 0.185583, 1.390825>, <-0.135966, 0.168944, 1.390825>, <-0.168944, 0.135966, 1.390825>, <-0.185583, 0.107146, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.063946, 0.110758, 1.390825>, <-0.081146, 0.100828, 1.390825>, <-0.100828, 0.081146, 1.390825>, <-0.110758, 0.063946, 1.390825>, 
      <-0.063946, 0.110758, 1.367246>, <-0.081146, 0.100828, 1.367246>, <-0.100828, 0.081146, 1.367246>, <-0.110758, 0.063946, 1.367246>, 
      <-0.073757, 0.127751, 1.347625>, <-0.096767, 0.114466, 1.347625>, <-0.114466, 0.096767, 1.347625>, <-0.127751, 0.073757, 1.347625>, 
      <-0.085546, 0.148170, 1.347625>, <-0.108556, 0.134886, 1.347625>, <-0.134886, 0.108556, 1.347625>, <-0.148170, 0.085546, 1.347625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.085546, 0.148170, 1.434025>, <-0.108556, 0.134886, 1.434025>, <-0.134886, 0.108556, 1.434025>, <-0.148170, 0.085546, 1.434025>, 
      <-0.073757, 0.127751, 1.434025>, <-0.096767, 0.114466, 1.434025>, <-0.114466, 0.096767, 1.434025>, <-0.127751, 0.073757, 1.434025>, 
      <-0.063946, 0.110758, 1.414403>, <-0.081146, 0.100828, 1.414403>, <-0.100828, 0.081146, 1.414403>, <-0.110758, 0.063946, 1.414403>, 
      <-0.063946, 0.110758, 1.390825>, <-0.081146, 0.100828, 1.390825>, <-0.100828, 0.081146, 1.390825>, <-0.110758, 0.063946, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.107146, 0.185583, 1.390825>, <-0.135966, 0.168944, 1.390825>, <-0.168944, 0.135966, 1.390825>, <-0.185583, 0.107146, 1.390825>, 
      <-0.107146, 0.185583, 1.414403>, <-0.135966, 0.168944, 1.414403>, <-0.168944, 0.135966, 1.414403>, <-0.185583, 0.107146, 1.414403>, 
      <-0.097336, 0.168590, 1.434025>, <-0.120345, 0.155305, 1.434025>, <-0.155305, 0.120345, 1.434025>, <-0.168590, 0.097336, 1.434025>, 
      <-0.085546, 0.148170, 1.434025>, <-0.108556, 0.134886, 1.434025>, <-0.134886, 0.108556, 1.434025>, <-0.148170, 0.085546, 1.434025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.148170, 0.085546, 1.347625>, <-0.161455, 0.062537, 1.347625>, <-0.171092, 0.026569, 1.347625>, <-0.171092, 0.000000, 1.347625>, 
      <-0.168590, 0.097336, 1.347625>, <-0.181874, 0.074326, 1.347625>, <-0.194671, 0.026569, 1.347625>, <-0.194671, 0.000000, 1.347625>, 
      <-0.185583, 0.107146, 1.367246>, <-0.202222, 0.078327, 1.367246>, <-0.214292, 0.033278, 1.367246>, <-0.214292, 0.000000, 1.367246>, 
      <-0.185583, 0.107146, 1.390825>, <-0.202222, 0.078327, 1.390825>, <-0.214292, 0.033278, 1.390825>, <-0.214292, 0.000000, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.110758, 0.063946, 1.390825>, <-0.120688, 0.046746, 1.390825>, <-0.127892, 0.019861, 1.390825>, <-0.127892, 0.000000, 1.390825>, 
      <-0.110758, 0.063946, 1.367246>, <-0.120688, 0.046746, 1.367246>, <-0.127892, 0.019861, 1.367246>, <-0.127892, 0.000000, 1.367246>, 
      <-0.127751, 0.073757, 1.347625>, <-0.141035, 0.050747, 1.347625>, <-0.147514, 0.026569, 1.347625>, <-0.147514, 0.000000, 1.347625>, 
      <-0.148170, 0.085546, 1.347625>, <-0.161455, 0.062537, 1.347625>, <-0.171092, 0.026569, 1.347625>, <-0.171092, 0.000000, 1.347625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.148170, 0.085546, 1.434025>, <-0.161455, 0.062537, 1.434025>, <-0.171092, 0.026569, 1.434025>, <-0.171092, 0.000000, 1.434025>, 
      <-0.127751, 0.073757, 1.434025>, <-0.141035, 0.050747, 1.434025>, <-0.147514, 0.026569, 1.434025>, <-0.147514, 0.000000, 1.434025>, 
      <-0.110758, 0.063946, 1.414403>, <-0.120688, 0.046746, 1.414403>, <-0.127892, 0.019861, 1.414403>, <-0.127892, 0.000000, 1.414403>, 
      <-0.110758, 0.063946, 1.390825>, <-0.120688, 0.046746, 1.390825>, <-0.127892, 0.019861, 1.390825>, <-0.127892, 0.000000, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.185583, 0.107146, 1.390825>, <-0.202222, 0.078327, 1.390825>, <-0.214292, 0.033278, 1.390825>, <-0.214292, 0.000000, 1.390825>, 
      <-0.185583, 0.107146, 1.414403>, <-0.202222, 0.078327, 1.414403>, <-0.214292, 0.033278, 1.414403>, <-0.214292, 0.000000, 1.414403>, 
      <-0.168590, 0.097336, 1.434025>, <-0.181875, 0.074326, 1.434025>, <-0.194671, 0.026569, 1.434025>, <-0.194671, 0.000000, 1.434025>, 
      <-0.148170, 0.085546, 1.434025>, <-0.161455, 0.062537, 1.434025>, <-0.171092, 0.026569, 1.434025>, <-0.171092, 0.000000, 1.434025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.171092, 0.000000, 1.347625>, <-0.171092, -0.026569, 1.347625>, <-0.161455, -0.062537, 1.347625>, <-0.148170, -0.085546, 1.347625>, 
      <-0.194671, 0.000000, 1.347625>, <-0.194671, -0.026569, 1.347625>, <-0.181875, -0.074326, 1.347625>, <-0.168590, -0.097335, 1.347625>, 
      <-0.214292, 0.000000, 1.367246>, <-0.214292, -0.033278, 1.367246>, <-0.202222, -0.078327, 1.367246>, <-0.185583, -0.107146, 1.367246>, 
      <-0.214292, 0.000000, 1.390825>, <-0.214292, -0.033278, 1.390825>, <-0.202222, -0.078327, 1.390825>, <-0.185583, -0.107146, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.127892, 0.000000, 1.390825>, <-0.127892, -0.019861, 1.390825>, <-0.120688, -0.046746, 1.390825>, <-0.110758, -0.063946, 1.390825>, 
      <-0.127892, 0.000000, 1.367246>, <-0.127892, -0.019861, 1.367246>, <-0.120688, -0.046746, 1.367246>, <-0.110758, -0.063946, 1.367246>, 
      <-0.147514, 0.000000, 1.347625>, <-0.147514, -0.026569, 1.347625>, <-0.141035, -0.050747, 1.347625>, <-0.127751, -0.073757, 1.347625>, 
      <-0.171092, 0.000000, 1.347625>, <-0.171092, -0.026569, 1.347625>, <-0.161455, -0.062537, 1.347625>, <-0.148170, -0.085546, 1.347625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.171092, 0.000000, 1.434025>, <-0.171092, -0.026569, 1.434025>, <-0.161455, -0.062537, 1.434025>, <-0.148170, -0.085546, 1.434025>, 
      <-0.147514, 0.000000, 1.434025>, <-0.147514, -0.026569, 1.434025>, <-0.141035, -0.050747, 1.434025>, <-0.127751, -0.073757, 1.434025>, 
      <-0.127892, 0.000000, 1.414403>, <-0.127892, -0.019861, 1.414403>, <-0.120688, -0.046746, 1.414403>, <-0.110758, -0.063946, 1.414403>, 
      <-0.127892, 0.000000, 1.390825>, <-0.127892, -0.019861, 1.390825>, <-0.120688, -0.046746, 1.390825>, <-0.110758, -0.063946, 1.390825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.214292, 0.000000, 1.390825>, <-0.214292, -0.033278, 1.390825>, <-0.202222, -0.078327, 1.390825>, <-0.185583, -0.107146, 1.390825>, 
      <-0.214292, 0.000000, 1.414403>, <-0.214292, -0.033278, 1.414403>, <-0.202222, -0.078327, 1.414403>, <-0.185583, -0.107146, 1.414403>, 
      <-0.194671, 0.000000, 1.434025>, <-0.194671, -0.026569, 1.434025>, <-0.181875, -0.074326, 1.434025>, <-0.168590, -0.097335, 1.434025>, 
      <-0.171092, 0.000000, 1.434025>, <-0.171092, -0.026569, 1.434025>, <-0.161455, -0.062537, 1.434025>, <-0.148170, -0.085546, 1.434025>
    }
  }
}
#declare freno = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.701393, -0.181002, 1.079135>, <0.670459, -0.181002, 1.100821>, <0.629214, -0.181002, 1.129737>, <0.598280, -0.181002, 1.151424>, 
      <0.704994, -0.170564, 1.082132>, <0.674060, -0.170564, 1.103819>, <0.647968, -0.154234, 1.135215>, <0.617034, -0.154234, 1.156902>, 
      <0.709795, -0.156648, 1.086128>, <0.694014, -0.140317, 1.110295>, <0.657820, -0.134874, 1.140038>, <0.642038, -0.118543, 1.164205>, 
      <0.713396, -0.146210, 1.089126>, <0.697615, -0.129880, 1.113293>, <0.676573, -0.108106, 1.145515>, <0.660792, -0.091775, 1.169682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.051306, 0.133785, 1.198201>, <0.249933, 0.133785, 1.165478>, <0.514769, 0.133785, 1.121848>, <0.713396, 0.133785, 1.089126>, 
      <0.051306, 0.049787, 1.198201>, <0.249933, 0.049787, 1.165478>, <0.514769, 0.049787, 1.121848>, <0.713396, 0.049787, 1.089126>, 
      <0.051306, -0.062212, 1.198201>, <0.249933, -0.062212, 1.165478>, <0.514769, -0.062212, 1.121848>, <0.713396, -0.062212, 1.089126>, 
      <0.051306, -0.146210, 1.198201>, <0.249933, -0.146210, 1.165478>, <0.514769, -0.146210, 1.121848>, <0.713396, -0.146210, 1.089126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.701393, 0.168998, 1.079135>, <0.704994, 0.158435, 1.082132>, <0.709795, 0.144349, 1.086128>, <0.713396, 0.133785, 1.089126>, 
      <0.505729, 0.168998, 1.101239>, <0.509330, 0.158435, 1.104236>, <0.511168, 0.144349, 1.118851>, <0.514769, 0.133785, 1.121848>, 
      <0.244844, 0.168998, 1.130711>, <0.245482, 0.158435, 1.144326>, <0.249296, 0.144349, 1.151862>, <0.249933, 0.133785, 1.165478>, 
      <0.049180, 0.168998, 1.152815>, <0.049818, 0.158435, 1.166430>, <0.050668, 0.144349, 1.184585>, <0.051306, 0.133785, 1.198201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.598280, -0.181002, 1.151424>, <0.438260, -0.181002, 1.181581>, <0.224901, -0.181002, 1.221790>, <0.064881, -0.181002, 1.251946>, 
      <0.629214, -0.181002, 1.129737>, <0.469194, -0.181002, 1.159894>, <0.220191, -0.181002, 1.192050>, <0.060171, -0.181002, 1.222207>, 
      <0.670459, -0.181002, 1.100821>, <0.474795, -0.181002, 1.122925>, <0.249554, -0.181002, 1.160450>, <0.053891, -0.181002, 1.182554>, 
      <0.701393, -0.181002, 1.079135>, <0.505729, -0.181002, 1.101239>, <0.244844, -0.181002, 1.130711>, <0.049180, -0.181002, 1.152815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.660792, -0.091775, 1.169682>, <0.676573, -0.108106, 1.145515>, <0.697615, -0.129880, 1.113293>, <0.713396, -0.146210, 1.089126>, 
      <0.660792, -0.040438, 1.169682>, <0.676573, -0.056768, 1.145515>, <0.697615, -0.045881, 1.113293>, <0.713396, -0.062212, 1.089126>, 
      <0.660792, 0.028013, 1.169682>, <0.676573, 0.044343, 1.145515>, <0.697615, 0.033456, 1.113293>, <0.713396, 0.049787, 1.089126>, 
      <0.660792, 0.079350, 1.169682>, <0.676573, 0.095681, 1.145515>, <0.697615, 0.117455, 1.113293>, <0.713396, 0.133785, 1.089126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.598280, -0.181002, 1.151424>, <0.438260, -0.181002, 1.181581>, <0.224901, -0.181002, 1.221790>, <0.064881, -0.181002, 1.251946>, 
      <0.617034, -0.154234, 1.156902>, <0.457014, -0.154234, 1.187058>, <0.224901, -0.154234, 1.221790>, <0.064881, -0.154234, 1.251946>, 
      <0.642038, -0.118543, 1.164205>, <0.463265, -0.118543, 1.188884>, <0.243654, -0.118543, 1.227267>, <0.064881, -0.118543, 1.251946>, 
      <0.660792, -0.091775, 1.169682>, <0.482019, -0.091775, 1.194361>, <0.243654, -0.091775, 1.227267>, <0.064881, -0.091775, 1.251946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.064881, -0.091775, 1.251946>, <0.060809, -0.108106, 1.235823>, <0.055379, -0.129880, 1.214324>, <0.051306, -0.146210, 1.198201>, 
      <0.064881, -0.040438, 1.251946>, <0.060809, -0.056768, 1.235823>, <0.055379, -0.045881, 1.214324>, <0.051306, -0.062212, 1.198201>, 
      <0.064881, 0.028013, 1.251946>, <0.060809, 0.044343, 1.235823>, <0.055379, 0.033456, 1.214324>, <0.051306, 0.049787, 1.198201>, 
      <0.064881, 0.079350, 1.251946>, <0.060809, 0.095681, 1.235823>, <0.055379, 0.117455, 1.214324>, <0.051306, 0.133785, 1.198201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.064881, -0.091775, 1.251946>, <0.243654, -0.091775, 1.227267>, <0.482019, -0.091775, 1.194361>, <0.660792, -0.091775, 1.169682>, 
      <0.064881, -0.040438, 1.251946>, <0.243654, -0.040438, 1.227267>, <0.482019, -0.040438, 1.194361>, <0.660792, -0.040438, 1.169682>, 
      <0.064881, 0.028013, 1.251946>, <0.243654, 0.028013, 1.227267>, <0.482019, 0.028013, 1.194361>, <0.660792, 0.028013, 1.169682>, 
      <0.064881, 0.079350, 1.251946>, <0.243654, 0.079350, 1.227267>, <0.482019, 0.079350, 1.194361>, <0.660792, 0.079350, 1.169682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.064881, -0.181002, 1.251946>, <0.060171, -0.181002, 1.222207>, <0.053891, -0.181002, 1.182554>, <0.049180, -0.181002, 1.152815>, 
      <0.064881, -0.154234, 1.251946>, <0.060171, -0.154234, 1.222207>, <0.054528, -0.170564, 1.196170>, <0.049818, -0.170564, 1.166430>, 
      <0.064881, -0.118543, 1.251946>, <0.060809, -0.134874, 1.235823>, <0.054741, -0.140317, 1.200709>, <0.050668, -0.156648, 1.184585>, 
      <0.064881, -0.091775, 1.251946>, <0.060809, -0.108106, 1.235823>, <0.055379, -0.129880, 1.214324>, <0.051306, -0.146210, 1.198201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.598280, 0.168998, 1.151424>, <0.617034, 0.142104, 1.156902>, <0.642038, 0.106245, 1.164205>, <0.660792, 0.079350, 1.169682>, 
      <0.629214, 0.168998, 1.129737>, <0.647968, 0.142104, 1.135215>, <0.657820, 0.122575, 1.140038>, <0.676573, 0.095681, 1.145515>, 
      <0.670459, 0.168998, 1.100821>, <0.674060, 0.158435, 1.103819>, <0.694014, 0.128019, 1.110295>, <0.697615, 0.117455, 1.113293>, 
      <0.701393, 0.168998, 1.079135>, <0.704994, 0.158435, 1.082132>, <0.709795, 0.144349, 1.086128>, <0.713396, 0.133785, 1.089126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.064881, 0.168998, 1.251946>, <0.064881, 0.142104, 1.251946>, <0.064881, 0.106245, 1.251946>, <0.064881, 0.079350, 1.251946>, 
      <0.224901, 0.168998, 1.221790>, <0.224901, 0.142104, 1.221790>, <0.243654, 0.106245, 1.227267>, <0.243654, 0.079350, 1.227267>, 
      <0.438260, 0.168998, 1.181581>, <0.457014, 0.142104, 1.187058>, <0.463265, 0.106245, 1.188884>, <0.482019, 0.079350, 1.194361>, 
      <0.598280, 0.168998, 1.151424>, <0.617034, 0.142104, 1.156902>, <0.642038, 0.106245, 1.164205>, <0.660792, 0.079350, 1.169682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.049180, 0.168998, 1.152815>, <0.244844, 0.168998, 1.130711>, <0.505729, 0.168998, 1.101239>, <0.701393, 0.168998, 1.079135>, 
      <0.053891, 0.168998, 1.182554>, <0.249554, 0.168998, 1.160450>, <0.474795, 0.168998, 1.122925>, <0.670459, 0.168998, 1.100821>, 
      <0.060171, 0.168998, 1.222207>, <0.220191, 0.168998, 1.192050>, <0.469194, 0.168998, 1.159894>, <0.629214, 0.168998, 1.129737>, 
      <0.064881, 0.168998, 1.251946>, <0.224901, 0.168998, 1.221790>, <0.438260, 0.168998, 1.181581>, <0.598280, 0.168998, 1.151424>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.049180, 0.168998, 1.152815>, <0.049818, 0.158435, 1.166430>, <0.050668, 0.144349, 1.184585>, <0.051306, 0.133785, 1.198201>, 
      <0.053891, 0.168998, 1.182554>, <0.054528, 0.158435, 1.196170>, <0.054741, 0.128019, 1.200709>, <0.055379, 0.117455, 1.214324>, 
      <0.060171, 0.168998, 1.222207>, <0.060171, 0.142104, 1.222207>, <0.060809, 0.122575, 1.235823>, <0.060809, 0.095681, 1.235823>, 
      <0.064881, 0.168998, 1.251946>, <0.064881, 0.142104, 1.251946>, <0.064881, 0.106245, 1.251946>, <0.064881, 0.079350, 1.251946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.598280, -0.181002, 1.151424>, <0.598280, -0.181002, 1.151424>, <0.598280, -0.181002, 1.151424>, <0.598280, -0.181002, 1.151424>, 
      <0.629214, -0.181002, 1.129737>, <0.629214, -0.181002, 1.129737>, <0.629214, -0.181002, 1.129737>, <0.629214, -0.181002, 1.129737>, 
      <0.670459, -0.181002, 1.100821>, <0.670459, -0.181002, 1.100821>, <0.670459, -0.181002, 1.100821>, <0.670459, -0.181002, 1.100821>, 
      <0.701393, -0.181002, 1.079135>, <0.701393, -0.181002, 1.079135>, <0.701393, -0.181002, 1.079135>, <0.701393, -0.181002, 1.079135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.064881, -0.181002, 1.251946>, <0.064881, -0.181002, 1.251946>, <0.064881, -0.181002, 1.251946>, <0.064881, -0.181002, 1.251946>, 
      <0.224901, -0.181002, 1.221790>, <0.224901, -0.181002, 1.221790>, <0.224901, -0.181002, 1.221790>, <0.224901, -0.181002, 1.221790>, 
      <0.438260, -0.181002, 1.181581>, <0.438260, -0.181002, 1.181581>, <0.438260, -0.181002, 1.181581>, <0.438260, -0.181002, 1.181581>, 
      <0.598280, -0.181002, 1.151424>, <0.598280, -0.181002, 1.151424>, <0.598280, -0.181002, 1.151424>, <0.598280, -0.181002, 1.151424>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.049180, -0.181002, 1.152815>, <0.049180, -0.181002, 1.152815>, <0.049180, -0.181002, 1.152815>, <0.049180, -0.181002, 1.152815>, 
      <0.053891, -0.181002, 1.182554>, <0.053891, -0.181002, 1.182554>, <0.053891, -0.181002, 1.182554>, <0.053891, -0.181002, 1.182554>, 
      <0.060171, -0.181002, 1.222207>, <0.060171, -0.181002, 1.222207>, <0.060171, -0.181002, 1.222207>, <0.060171, -0.181002, 1.222207>, 
      <0.064881, -0.181002, 1.251946>, <0.064881, -0.181002, 1.251946>, <0.064881, -0.181002, 1.251946>, <0.064881, -0.181002, 1.251946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.765585, -0.180500, 0.948006>, <0.765585, -0.180500, 0.978117>, <0.765585, -0.180500, 1.018264>, <0.765585, -0.180500, 1.048374>, 
      <0.765585, -0.170358, 0.942869>, <0.765585, -0.170358, 0.972979>, <0.765585, -0.170358, 1.025038>, <0.765585, -0.170358, 1.055148>, 
      <0.765585, -0.156836, 0.936018>, <0.765585, -0.156836, 0.978040>, <0.765585, -0.156836, 1.022158>, <0.765585, -0.156836, 1.064180>, 
      <0.765585, -0.146694, 0.930881>, <0.765585, -0.146694, 0.972903>, <0.765585, -0.146694, 1.028932>, <0.765585, -0.146694, 1.070954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.234415, 0.148588, 0.930881>, <0.065585, 0.148588, 0.930881>, <0.465585, 0.148588, 0.930881>, <0.765585, 0.148588, 0.930881>, 
      <-0.234415, 0.060003, 0.930881>, <0.065585, 0.060003, 0.930881>, <0.465585, 0.060003, 0.930881>, <0.765585, 0.060003, 0.930881>, 
      <-0.234415, -0.058109, 0.930881>, <0.065585, -0.058109, 0.930881>, <0.465585, -0.058109, 0.930881>, <0.765585, -0.058109, 0.930881>, 
      <-0.234415, -0.146694, 0.930881>, <0.065585, -0.146694, 0.930881>, <0.465585, -0.146694, 0.930881>, <0.765585, -0.146694, 0.930881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.765585, 0.180500, 0.948006>, <0.765585, 0.170926, 0.942869>, <0.765585, 0.158162, 0.936018>, <0.765585, 0.148588, 0.930881>, 
      <0.465585, 0.180500, 0.948006>, <0.465585, 0.170926, 0.942869>, <0.465585, 0.158162, 0.936018>, <0.465585, 0.148588, 0.930881>, 
      <0.065585, 0.180500, 0.948006>, <0.065585, 0.170926, 0.942869>, <0.065585, 0.158162, 0.936018>, <0.065585, 0.148588, 0.930881>, 
      <-0.234415, 0.180500, 0.948006>, <-0.234415, 0.170926, 0.942869>, <-0.234415, 0.158162, 0.936018>, <-0.234415, 0.148588, 0.930881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.765585, -0.180500, 1.048374>, <0.465585, -0.180500, 1.048374>, <0.065585, -0.180500, 1.048374>, <-0.234415, -0.180500, 1.048374>, 
      <0.765585, -0.180500, 1.018264>, <0.465585, -0.180500, 1.018264>, <0.065585, -0.180500, 1.018264>, <-0.234415, -0.180500, 1.018264>, 
      <0.765585, -0.180500, 0.978117>, <0.465585, -0.180500, 0.978117>, <0.065585, -0.180500, 0.978117>, <-0.234415, -0.180500, 0.978117>, 
      <0.765585, -0.180500, 0.948006>, <0.465585, -0.180500, 0.948006>, <0.065585, -0.180500, 0.948006>, <-0.234415, -0.180500, 0.948006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.765585, -0.146694, 1.070954>, <0.765585, -0.146694, 1.028932>, <0.765585, -0.146694, 0.972903>, <0.765585, -0.146694, 0.930881>, 
      <0.765585, -0.058109, 1.070954>, <0.765585, -0.058109, 1.028932>, <0.765585, -0.058109, 0.972903>, <0.765585, -0.058109, 0.930881>, 
      <0.765585, 0.060003, 1.070954>, <0.765585, 0.060003, 1.028932>, <0.765585, 0.060003, 0.972903>, <0.765585, 0.060003, 0.930881>, 
      <0.765585, 0.148588, 1.070954>, <0.765585, 0.148588, 1.028932>, <0.765585, 0.148588, 0.972903>, <0.765585, 0.148588, 0.930881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.765585, -0.180500, 1.048374>, <0.465585, -0.180500, 1.048374>, <0.065585, -0.180500, 1.048374>, <-0.234415, -0.180500, 1.048374>, 
      <0.765585, -0.170358, 1.055148>, <0.465585, -0.170358, 1.055148>, <0.065585, -0.170358, 1.055148>, <-0.234415, -0.170358, 1.055148>, 
      <0.765585, -0.156836, 1.064180>, <0.465585, -0.156836, 1.064180>, <0.065585, -0.156836, 1.064180>, <-0.234415, -0.156836, 1.064180>, 
      <0.765585, -0.146694, 1.070954>, <0.465585, -0.146694, 1.070954>, <0.065585, -0.146694, 1.070954>, <-0.234415, -0.146694, 1.070954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.234415, -0.146694, 1.070954>, <-0.234415, -0.146694, 1.028932>, <-0.234415, -0.146694, 0.972903>, <-0.234415, -0.146694, 0.930881>, 
      <-0.234415, -0.058109, 1.070954>, <-0.234415, -0.058109, 1.028932>, <-0.234415, -0.058109, 0.972903>, <-0.234415, -0.058109, 0.930881>, 
      <-0.234415, 0.060003, 1.070954>, <-0.234415, 0.060003, 1.028932>, <-0.234415, 0.060003, 0.972903>, <-0.234415, 0.060003, 0.930881>, 
      <-0.234415, 0.148588, 1.070954>, <-0.234415, 0.148588, 1.028932>, <-0.234415, 0.148588, 0.972903>, <-0.234415, 0.148588, 0.930881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.234415, -0.146694, 1.070954>, <0.065585, -0.146694, 1.070954>, <0.465585, -0.146694, 1.070954>, <0.765585, -0.146694, 1.070954>, 
      <-0.234415, -0.058109, 1.070954>, <0.065585, -0.058109, 1.070954>, <0.465585, -0.058109, 1.070954>, <0.765585, -0.058109, 1.070954>, 
      <-0.234415, 0.060003, 1.070954>, <0.065585, 0.060003, 1.070954>, <0.465585, 0.060003, 1.070954>, <0.765585, 0.060003, 1.070954>, 
      <-0.234415, 0.148588, 1.070954>, <0.065585, 0.148588, 1.070954>, <0.465585, 0.148588, 1.070954>, <0.765585, 0.148588, 1.070954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.234415, -0.180500, 1.048374>, <-0.234415, -0.180500, 1.018264>, <-0.234415, -0.180500, 0.978117>, <-0.234415, -0.180500, 0.948006>, 
      <-0.234415, -0.170358, 1.055148>, <-0.234415, -0.170358, 1.025038>, <-0.234415, -0.170358, 0.972979>, <-0.234415, -0.170358, 0.942869>, 
      <-0.234415, -0.156836, 1.064180>, <-0.234415, -0.156836, 1.022158>, <-0.234415, -0.156836, 0.978040>, <-0.234415, -0.156836, 0.936018>, 
      <-0.234415, -0.146694, 1.070954>, <-0.234415, -0.146694, 1.028932>, <-0.234415, -0.146694, 0.972903>, <-0.234415, -0.146694, 0.930881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.765585, 0.180500, 1.048374>, <0.765585, 0.170926, 1.055148>, <0.765585, 0.158162, 1.064180>, <0.765585, 0.148588, 1.070954>, 
      <0.765585, 0.180500, 1.018264>, <0.765585, 0.170926, 1.025038>, <0.765585, 0.158162, 1.022158>, <0.765585, 0.148588, 1.028932>, 
      <0.765585, 0.180500, 0.978117>, <0.765585, 0.170926, 0.972979>, <0.765585, 0.158162, 0.978040>, <0.765585, 0.148588, 0.972903>, 
      <0.765585, 0.180500, 0.948006>, <0.765585, 0.170926, 0.942869>, <0.765585, 0.158162, 0.936018>, <0.765585, 0.148588, 0.930881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.234415, 0.180500, 1.048374>, <-0.234415, 0.170926, 1.055148>, <-0.234415, 0.158162, 1.064180>, <-0.234415, 0.148588, 1.070954>, 
      <0.065585, 0.180500, 1.048374>, <0.065585, 0.170926, 1.055148>, <0.065585, 0.158162, 1.064180>, <0.065585, 0.148588, 1.070954>, 
      <0.465585, 0.180500, 1.048374>, <0.465585, 0.170926, 1.055148>, <0.465585, 0.158162, 1.064180>, <0.465585, 0.148588, 1.070954>, 
      <0.765585, 0.180500, 1.048374>, <0.765585, 0.170926, 1.055148>, <0.765585, 0.158162, 1.064180>, <0.765585, 0.148588, 1.070954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.234415, 0.180500, 0.948006>, <0.065585, 0.180500, 0.948006>, <0.465585, 0.180500, 0.948006>, <0.765585, 0.180500, 0.948006>, 
      <-0.234415, 0.180500, 0.978117>, <0.065585, 0.180500, 0.978117>, <0.465585, 0.180500, 0.978117>, <0.765585, 0.180500, 0.978117>, 
      <-0.234415, 0.180500, 1.018264>, <0.065585, 0.180500, 1.018264>, <0.465585, 0.180500, 1.018264>, <0.765585, 0.180500, 1.018264>, 
      <-0.234415, 0.180500, 1.048374>, <0.065585, 0.180500, 1.048374>, <0.465585, 0.180500, 1.048374>, <0.765585, 0.180500, 1.048374>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.234415, 0.180500, 0.948006>, <-0.234415, 0.170926, 0.942869>, <-0.234415, 0.158162, 0.936018>, <-0.234415, 0.148588, 0.930881>, 
      <-0.234415, 0.180500, 0.978117>, <-0.234415, 0.170926, 0.972979>, <-0.234415, 0.158162, 0.978040>, <-0.234415, 0.148588, 0.972903>, 
      <-0.234415, 0.180500, 1.018264>, <-0.234415, 0.170926, 1.025038>, <-0.234415, 0.158162, 1.022158>, <-0.234415, 0.148588, 1.028932>, 
      <-0.234415, 0.180500, 1.048374>, <-0.234415, 0.170926, 1.055148>, <-0.234415, 0.158162, 1.064180>, <-0.234415, 0.148588, 1.070954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.765585, -0.180500, 1.048374>, <0.765585, -0.180500, 1.048374>, <0.765585, -0.180500, 1.048374>, <0.765585, -0.180500, 1.048374>, 
      <0.765585, -0.180500, 1.018264>, <0.765585, -0.180500, 1.018264>, <0.765585, -0.180500, 1.018264>, <0.765585, -0.180500, 1.018264>, 
      <0.765585, -0.180500, 0.978117>, <0.765585, -0.180500, 0.978117>, <0.765585, -0.180500, 0.978117>, <0.765585, -0.180500, 0.978117>, 
      <0.765585, -0.180500, 0.948006>, <0.765585, -0.180500, 0.948006>, <0.765585, -0.180500, 0.948006>, <0.765585, -0.180500, 0.948006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.234415, -0.180500, 1.048374>, <-0.234415, -0.180500, 1.048374>, <-0.234415, -0.180500, 1.048374>, <-0.234415, -0.180500, 1.048374>, 
      <0.065585, -0.180500, 1.048374>, <0.065585, -0.180500, 1.048374>, <0.065585, -0.180500, 1.048374>, <0.065585, -0.180500, 1.048374>, 
      <0.465585, -0.180500, 1.048374>, <0.465585, -0.180500, 1.048374>, <0.465585, -0.180500, 1.048374>, <0.465585, -0.180500, 1.048374>, 
      <0.765585, -0.180500, 1.048374>, <0.765585, -0.180500, 1.048374>, <0.765585, -0.180500, 1.048374>, <0.765585, -0.180500, 1.048374>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.234415, -0.180500, 0.948006>, <-0.234415, -0.180500, 0.948006>, <-0.234415, -0.180500, 0.948006>, <-0.234415, -0.180500, 0.948006>, 
      <-0.234415, -0.180500, 0.978117>, <-0.234415, -0.180500, 0.978117>, <-0.234415, -0.180500, 0.978117>, <-0.234415, -0.180500, 0.978117>, 
      <-0.234415, -0.180500, 1.018264>, <-0.234415, -0.180500, 1.018264>, <-0.234415, -0.180500, 1.018264>, <-0.234415, -0.180500, 1.018264>, 
      <-0.234415, -0.180500, 1.048374>, <-0.234415, -0.180500, 1.048374>, <-0.234415, -0.180500, 1.048374>, <-0.234415, -0.180500, 1.048374>
    }
  }
  material {
    negro_txt
  }
}
#declare tornillos = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.006989, -0.065228, 1.527933>, <-0.030832, -0.065228, 1.527933>, <-0.063015, -0.033045, 1.527933>, <-0.063015, 0.004776, 1.527933>, 
      <0.006989, -0.043822, 1.456856>, <-0.030832, -0.043822, 1.456856>, <-0.041609, -0.033045, 1.456856>, <-0.041609, 0.004776, 1.456856>, 
      <0.006989, -0.065228, 1.354730>, <-0.030832, -0.065228, 1.354730>, <-0.063015, -0.033045, 1.354730>, <-0.063015, 0.004776, 1.354730>, 
      <0.006989, -0.065228, 1.280500>, <-0.030832, -0.065228, 1.280500>, <-0.063015, -0.033045, 1.280500>, <-0.063015, 0.004776, 1.280500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.006989, -0.158024, 1.588623>, <-0.080967, -0.158024, 1.588623>, <-0.155811, -0.083181, 1.588623>, <-0.155811, 0.004776, 1.588623>, 
      <0.006989, -0.175466, 1.550021>, <-0.080967, -0.175466, 1.550021>, <-0.173253, -0.083181, 1.550021>, <-0.173253, 0.004776, 1.550021>, 
      <0.006989, -0.074821, 1.559784>, <-0.030832, -0.074821, 1.559784>, <-0.072607, -0.033045, 1.559784>, <-0.072607, 0.004776, 1.559784>, 
      <0.006989, -0.065228, 1.527933>, <-0.030832, -0.065228, 1.527933>, <-0.063015, -0.033045, 1.527933>, <-0.063015, 0.004776, 1.527933>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.006989, 0.074780, 1.280500>, <0.044810, 0.074780, 1.280500>, <0.076993, 0.042597, 1.280500>, <0.076993, 0.004776, 1.280500>, 
      <0.006989, 0.074780, 1.354730>, <0.044810, 0.074780, 1.354730>, <0.076993, 0.042597, 1.354730>, <0.076993, 0.004776, 1.354730>, 
      <0.006989, 0.053374, 1.456856>, <0.044810, 0.053374, 1.456856>, <0.055587, 0.042597, 1.456856>, <0.055587, 0.004776, 1.456856>, 
      <0.006989, 0.074780, 1.527933>, <0.044810, 0.074780, 1.527933>, <0.076993, 0.042597, 1.527933>, <0.076993, 0.004776, 1.527933>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.063015, 0.004776, 1.527933>, <-0.063015, 0.042597, 1.527933>, <-0.030832, 0.074780, 1.527933>, <0.006989, 0.074780, 1.527933>, 
      <-0.041609, 0.004776, 1.456856>, <-0.041609, 0.042597, 1.456856>, <-0.030832, 0.053374, 1.456856>, <0.006989, 0.053374, 1.456856>, 
      <-0.063015, 0.004776, 1.354730>, <-0.063015, 0.042597, 1.354730>, <-0.030832, 0.074780, 1.354730>, <0.006989, 0.074780, 1.354730>, 
      <-0.063015, 0.004776, 1.280500>, <-0.063015, 0.042597, 1.280500>, <-0.030832, 0.074780, 1.280500>, <0.006989, 0.074780, 1.280500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.155811, 0.004776, 1.588623>, <-0.155811, 0.092732, 1.588623>, <-0.080967, 0.167576, 1.588623>, <0.006989, 0.167576, 1.588623>, 
      <-0.173253, 0.004776, 1.550021>, <-0.173253, 0.092732, 1.550021>, <-0.080967, 0.185018, 1.550021>, <0.006989, 0.185018, 1.550021>, 
      <-0.072607, 0.004776, 1.559784>, <-0.072607, 0.042597, 1.559784>, <-0.030832, 0.084372, 1.559784>, <0.006989, 0.084372, 1.559784>, 
      <-0.063015, 0.004776, 1.527933>, <-0.063015, 0.042597, 1.527933>, <-0.030832, 0.074780, 1.527933>, <0.006989, 0.074780, 1.527933>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.076993, 0.004776, 1.280500>, <0.076993, -0.033045, 1.280500>, <0.044810, -0.065228, 1.280500>, <0.006989, -0.065228, 1.280500>, 
      <0.076993, 0.004776, 1.354730>, <0.076993, -0.033045, 1.354730>, <0.044810, -0.065228, 1.354730>, <0.006989, -0.065228, 1.354730>, 
      <0.055587, 0.004776, 1.456856>, <0.055587, -0.033045, 1.456856>, <0.044810, -0.043822, 1.456856>, <0.006989, -0.043822, 1.456856>, 
      <0.076993, 0.004776, 1.527933>, <0.076993, -0.033045, 1.527933>, <0.044810, -0.065228, 1.527933>, <0.006989, -0.065228, 1.527933>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.169789, 0.004776, 1.588623>, <0.187231, 0.004776, 1.550021>, <0.086585, 0.004776, 1.559784>, <0.076993, 0.004776, 1.527933>, 
      <0.169789, 0.092732, 1.588623>, <0.187231, 0.092732, 1.550021>, <0.086585, 0.042597, 1.559784>, <0.076993, 0.042597, 1.527933>, 
      <0.094946, 0.167576, 1.588623>, <0.094946, 0.185018, 1.550021>, <0.044810, 0.084372, 1.559784>, <0.044810, 0.074780, 1.527933>, 
      <0.006989, 0.167576, 1.588623>, <0.006989, 0.185018, 1.550021>, <0.006989, 0.084372, 1.559784>, <0.006989, 0.074780, 1.527933>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.006989, -0.158024, 1.588623>, <0.006989, -0.175466, 1.550021>, <0.006989, -0.074821, 1.559784>, <0.006989, -0.065228, 1.527933>, 
      <0.094946, -0.158024, 1.588623>, <0.094946, -0.175466, 1.550021>, <0.044810, -0.074821, 1.559784>, <0.044810, -0.065228, 1.527933>, 
      <0.169789, -0.083181, 1.588623>, <0.187231, -0.083181, 1.550021>, <0.086585, -0.033045, 1.559784>, <0.076993, -0.033045, 1.527933>, 
      <0.169789, 0.004776, 1.588623>, <0.187231, 0.004776, 1.550021>, <0.086585, 0.004776, 1.559784>, <0.076993, 0.004776, 1.527933>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265585, 0.215074, 0.047300>, <0.240030, 0.215074, 0.047300>, <0.218285, 0.215074, 0.025555>, <0.218285, 0.215074, 0.000000>, 
      <0.265585, 0.167049, 0.032837>, <0.240030, 0.167049, 0.032837>, <0.232748, 0.167049, 0.025555>, <0.232748, 0.167049, 0.000000>, 
      <0.265585, 0.098045, 0.047300>, <0.240030, 0.098045, 0.047300>, <0.218285, 0.098045, 0.025555>, <0.218285, 0.098045, 0.000000>, 
      <0.265585, 0.047890, 0.047300>, <0.240030, 0.047890, 0.047300>, <0.218285, 0.047890, 0.025555>, <0.218285, 0.047890, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265585, 0.256081, 0.110000>, <0.206154, 0.256081, 0.110000>, <0.155585, 0.256081, 0.059430>, <0.155585, 0.256081, 0.000000>, 
      <0.265585, 0.229998, 0.121785>, <0.206154, 0.229998, 0.121785>, <0.143800, 0.229998, 0.059430>, <0.143800, 0.229998, 0.000000>, 
      <0.265585, 0.236595, 0.053781>, <0.240030, 0.236595, 0.053781>, <0.211803, 0.236595, 0.025555>, <0.211803, 0.236595, 0.000000>, 
      <0.265585, 0.215074, 0.047300>, <0.240030, 0.215074, 0.047300>, <0.218285, 0.215074, 0.025555>, <0.218285, 0.215074, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265585, 0.047890, -0.047300>, <0.291140, 0.047890, -0.047300>, <0.312885, 0.047890, -0.025555>, <0.312885, 0.047890, 0.000000>, 
      <0.265585, 0.098045, -0.047300>, <0.291140, 0.098045, -0.047300>, <0.312885, 0.098045, -0.025555>, <0.312885, 0.098045, 0.000000>, 
      <0.265585, 0.167049, -0.032837>, <0.291140, 0.167049, -0.032837>, <0.298421, 0.167049, -0.025555>, <0.298421, 0.167049, 0.000000>, 
      <0.265585, 0.215074, -0.047300>, <0.291140, 0.215074, -0.047300>, <0.312885, 0.215074, -0.025555>, <0.312885, 0.215074, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.218285, 0.215074, 0.000000>, <0.218285, 0.215074, -0.025555>, <0.240030, 0.215074, -0.047300>, <0.265585, 0.215074, -0.047300>, 
      <0.232748, 0.167049, 0.000000>, <0.232748, 0.167049, -0.025555>, <0.240030, 0.167049, -0.032837>, <0.265585, 0.167049, -0.032837>, 
      <0.218285, 0.098045, 0.000000>, <0.218285, 0.098045, -0.025555>, <0.240030, 0.098045, -0.047300>, <0.265585, 0.098045, -0.047300>, 
      <0.218285, 0.047890, 0.000000>, <0.218285, 0.047890, -0.025555>, <0.240030, 0.047890, -0.047300>, <0.265585, 0.047890, -0.047300>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.155585, 0.256081, 0.000000>, <0.155585, 0.256081, -0.059430>, <0.206154, 0.256081, -0.110000>, <0.265585, 0.256081, -0.110000>, 
      <0.143800, 0.229998, 0.000000>, <0.143800, 0.229998, -0.059430>, <0.206154, 0.229998, -0.121785>, <0.265585, 0.229998, -0.121785>, 
      <0.211803, 0.236595, 0.000000>, <0.211803, 0.236595, -0.025555>, <0.240030, 0.236595, -0.053781>, <0.265585, 0.236595, -0.053781>, 
      <0.218285, 0.215074, 0.000000>, <0.218285, 0.215074, -0.025555>, <0.240030, 0.215074, -0.047300>, <0.265585, 0.215074, -0.047300>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312885, 0.047890, 0.000000>, <0.312885, 0.047890, 0.025555>, <0.291140, 0.047890, 0.047300>, <0.265585, 0.047890, 0.047300>, 
      <0.312885, 0.098045, 0.000000>, <0.312885, 0.098045, 0.025555>, <0.291140, 0.098045, 0.047300>, <0.265585, 0.098045, 0.047300>, 
      <0.298421, 0.167049, 0.000000>, <0.298421, 0.167049, 0.025555>, <0.291140, 0.167049, 0.032837>, <0.265585, 0.167049, 0.032837>, 
      <0.312885, 0.215074, 0.000000>, <0.312885, 0.215074, 0.025555>, <0.291140, 0.215074, 0.047300>, <0.265585, 0.215074, 0.047300>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.375585, 0.256081, 0.000000>, <0.387370, 0.229998, 0.000000>, <0.319366, 0.236595, 0.000000>, <0.312885, 0.215074, 0.000000>, 
      <0.375585, 0.256081, -0.059430>, <0.387370, 0.229998, -0.059430>, <0.319366, 0.236595, -0.025555>, <0.312885, 0.215074, -0.025555>, 
      <0.325015, 0.256081, -0.110000>, <0.325015, 0.229998, -0.121785>, <0.291140, 0.236595, -0.053781>, <0.291140, 0.215074, -0.047300>, 
      <0.265585, 0.256081, -0.110000>, <0.265585, 0.229998, -0.121785>, <0.265585, 0.236595, -0.053781>, <0.265585, 0.215074, -0.047300>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265585, 0.256081, 0.110000>, <0.265585, 0.229998, 0.121785>, <0.265585, 0.236595, 0.053781>, <0.265585, 0.215074, 0.047300>, 
      <0.325015, 0.256081, 0.110000>, <0.325015, 0.229998, 0.121785>, <0.291140, 0.236595, 0.053781>, <0.291140, 0.215074, 0.047300>, 
      <0.375585, 0.256081, 0.059430>, <0.387370, 0.229998, 0.059430>, <0.319366, 0.236595, 0.025555>, <0.312885, 0.215074, 0.025555>, 
      <0.375585, 0.256081, 0.000000>, <0.387370, 0.229998, 0.000000>, <0.319366, 0.236595, 0.000000>, <0.312885, 0.215074, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265585, -0.215074, 0.047300>, <0.240030, -0.215074, 0.047300>, <0.218285, -0.215074, 0.025555>, <0.218285, -0.215074, 0.000000>, 
      <0.265585, -0.167049, 0.032837>, <0.240030, -0.167049, 0.032837>, <0.232748, -0.167049, 0.025555>, <0.232748, -0.167049, 0.000000>, 
      <0.265585, -0.098045, 0.047300>, <0.240030, -0.098045, 0.047300>, <0.218285, -0.098045, 0.025555>, <0.218285, -0.098045, 0.000000>, 
      <0.265585, -0.047890, 0.047300>, <0.240030, -0.047890, 0.047300>, <0.218285, -0.047890, 0.025555>, <0.218285, -0.047890, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265585, -0.256081, 0.110000>, <0.206154, -0.256081, 0.110000>, <0.155585, -0.256081, 0.059430>, <0.155585, -0.256081, 0.000000>, 
      <0.265585, -0.229998, 0.121785>, <0.206154, -0.229998, 0.121785>, <0.143800, -0.229998, 0.059430>, <0.143800, -0.229998, 0.000000>, 
      <0.265585, -0.236595, 0.053781>, <0.240030, -0.236595, 0.053781>, <0.211803, -0.236595, 0.025555>, <0.211803, -0.236595, 0.000000>, 
      <0.265585, -0.215074, 0.047300>, <0.240030, -0.215074, 0.047300>, <0.218285, -0.215074, 0.025555>, <0.218285, -0.215074, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265585, -0.047890, -0.047300>, <0.291140, -0.047890, -0.047300>, <0.312885, -0.047890, -0.025555>, <0.312885, -0.047890, 0.000000>, 
      <0.265585, -0.098045, -0.047300>, <0.291140, -0.098045, -0.047300>, <0.312885, -0.098045, -0.025555>, <0.312885, -0.098045, 0.000000>, 
      <0.265585, -0.167049, -0.032837>, <0.291140, -0.167049, -0.032837>, <0.298421, -0.167049, -0.025555>, <0.298421, -0.167049, 0.000000>, 
      <0.265585, -0.215074, -0.047300>, <0.291140, -0.215074, -0.047300>, <0.312885, -0.215074, -0.025555>, <0.312885, -0.215074, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.218285, -0.215074, 0.000000>, <0.218285, -0.215074, -0.025555>, <0.240030, -0.215074, -0.047300>, <0.265585, -0.215074, -0.047300>, 
      <0.232748, -0.167049, 0.000000>, <0.232748, -0.167049, -0.025555>, <0.240030, -0.167049, -0.032837>, <0.265585, -0.167049, -0.032837>, 
      <0.218285, -0.098045, 0.000000>, <0.218285, -0.098045, -0.025555>, <0.240030, -0.098045, -0.047300>, <0.265585, -0.098045, -0.047300>, 
      <0.218285, -0.047890, 0.000000>, <0.218285, -0.047890, -0.025555>, <0.240030, -0.047890, -0.047300>, <0.265585, -0.047890, -0.047300>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.155585, -0.256081, 0.000000>, <0.155585, -0.256081, -0.059430>, <0.206154, -0.256081, -0.110000>, <0.265585, -0.256081, -0.110000>, 
      <0.143800, -0.229998, 0.000000>, <0.143800, -0.229998, -0.059430>, <0.206154, -0.229998, -0.121785>, <0.265585, -0.229998, -0.121785>, 
      <0.211803, -0.236595, 0.000000>, <0.211803, -0.236595, -0.025555>, <0.240030, -0.236595, -0.053781>, <0.265585, -0.236595, -0.053781>, 
      <0.218285, -0.215074, 0.000000>, <0.218285, -0.215074, -0.025555>, <0.240030, -0.215074, -0.047300>, <0.265585, -0.215074, -0.047300>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312885, -0.047890, 0.000000>, <0.312885, -0.047890, 0.025555>, <0.291140, -0.047890, 0.047300>, <0.265585, -0.047890, 0.047300>, 
      <0.312885, -0.098045, 0.000000>, <0.312885, -0.098045, 0.025555>, <0.291140, -0.098045, 0.047300>, <0.265585, -0.098045, 0.047300>, 
      <0.298421, -0.167049, 0.000000>, <0.298421, -0.167049, 0.025555>, <0.291140, -0.167049, 0.032837>, <0.265585, -0.167049, 0.032837>, 
      <0.312885, -0.215074, 0.000000>, <0.312885, -0.215074, 0.025555>, <0.291140, -0.215074, 0.047300>, <0.265585, -0.215074, 0.047300>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.375585, -0.256081, 0.000000>, <0.387370, -0.229998, 0.000000>, <0.319366, -0.236595, 0.000000>, <0.312885, -0.215074, 0.000000>, 
      <0.375585, -0.256081, -0.059430>, <0.387370, -0.229998, -0.059430>, <0.319366, -0.236595, -0.025555>, <0.312885, -0.215074, -0.025555>, 
      <0.325015, -0.256081, -0.110000>, <0.325015, -0.229998, -0.121785>, <0.291140, -0.236595, -0.053781>, <0.291140, -0.215074, -0.047300>, 
      <0.265585, -0.256081, -0.110000>, <0.265585, -0.229998, -0.121785>, <0.265585, -0.236595, -0.053781>, <0.265585, -0.215074, -0.047300>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265585, -0.256081, 0.110000>, <0.265585, -0.229998, 0.121785>, <0.265585, -0.236595, 0.053781>, <0.265585, -0.215074, 0.047300>, 
      <0.325015, -0.256081, 0.110000>, <0.325015, -0.229998, 0.121785>, <0.291140, -0.236595, 0.053781>, <0.291140, -0.215074, 0.047300>, 
      <0.375585, -0.256081, 0.059430>, <0.387370, -0.229998, 0.059430>, <0.319366, -0.236595, 0.025555>, <0.312885, -0.215074, 0.025555>, 
      <0.375585, -0.256081, 0.000000>, <0.387370, -0.229998, 0.000000>, <0.319366, -0.236595, 0.000000>, <0.312885, -0.215074, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.006989, 0.074780, 1.280500>, <0.044810, 0.074780, 1.280500>, <0.076993, 0.042597, 1.280500>, <0.076993, 0.004776, 1.280500>, 
      <-0.030832, 0.074780, 1.280500>, <0.006989, 0.074780, 1.280500>, <0.056308, 0.042597, 1.243945>, <0.076993, 0.004776, 1.280500>, 
      <-0.063015, 0.042597, 1.280500>, <-0.042330, 0.042597, 1.243945>, <0.056308, 0.042597, 1.243945>, <0.076993, 0.004776, 1.280500>, 
      <-0.063015, 0.004776, 1.280500>, <-0.042330, 0.004776, 1.243945>, <0.056308, 0.004776, 1.243945>, <0.076993, 0.004776, 1.280500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.063015, 0.004776, 1.280500>, <-0.063015, 0.042597, 1.280500>, <-0.030832, 0.074780, 1.280500>, <0.006989, 0.074780, 1.280500>, 
      <-0.063015, -0.033045, 1.280500>, <-0.063015, 0.004776, 1.280500>, <-0.030832, 0.054095, 1.243945>, <0.006989, 0.074780, 1.280500>, 
      <-0.030832, -0.065228, 1.280500>, <-0.030832, -0.044543, 1.243945>, <-0.030832, 0.054095, 1.243945>, <0.006989, 0.074780, 1.280500>, 
      <0.006989, -0.065228, 1.280500>, <0.006989, -0.044543, 1.243945>, <0.006989, 0.054095, 1.243945>, <0.006989, 0.074780, 1.280500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.006989, 0.167576, 1.588623>, <0.006989, 0.137986, 1.654112>, <0.006989, 0.076640, 1.682865>, <0.006989, 0.004776, 1.682865>, 
      <-0.080967, 0.167576, 1.588623>, <-0.080967, 0.137986, 1.654112>, <-0.064875, 0.076640, 1.682865>, <0.006989, 0.004776, 1.682865>, 
      <-0.155811, 0.092732, 1.588623>, <-0.126221, 0.092732, 1.654112>, <-0.064875, 0.076640, 1.682865>, <0.006989, 0.004776, 1.682865>, 
      <-0.155811, 0.004776, 1.588623>, <-0.126221, 0.004776, 1.654112>, <-0.064875, 0.004776, 1.682865>, <0.006989, 0.004776, 1.682865>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.169789, 0.004776, 1.588623>, <0.140199, 0.004776, 1.654112>, <0.078853, 0.004776, 1.682865>, <0.006989, 0.004776, 1.682865>, 
      <0.169789, 0.092732, 1.588623>, <0.140199, 0.092732, 1.654112>, <0.078853, 0.076640, 1.682865>, <0.006989, 0.004776, 1.682865>, 
      <0.094946, 0.167576, 1.588623>, <0.094946, 0.137986, 1.654112>, <0.078853, 0.076640, 1.682865>, <0.006989, 0.004776, 1.682865>, 
      <0.006989, 0.167576, 1.588623>, <0.006989, 0.137986, 1.654112>, <0.006989, 0.076640, 1.682865>, <0.006989, 0.004776, 1.682865>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.006989, -0.158024, 1.588623>, <0.006989, -0.128434, 1.654112>, <0.006989, -0.067088, 1.682865>, <0.006989, 0.004776, 1.682865>, 
      <0.094946, -0.158024, 1.588623>, <0.094946, -0.128434, 1.654112>, <0.078853, -0.067088, 1.682865>, <0.006989, 0.004776, 1.682865>, 
      <0.169789, -0.083181, 1.588623>, <0.140199, -0.083181, 1.654112>, <0.078853, -0.067088, 1.682865>, <0.006989, 0.004776, 1.682865>, 
      <0.169789, 0.004776, 1.588623>, <0.140199, 0.004776, 1.654112>, <0.078853, 0.004776, 1.682865>, <0.006989, 0.004776, 1.682865>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.155811, 0.004776, 1.588623>, <-0.126221, 0.004776, 1.654112>, <-0.064875, 0.004776, 1.682865>, <0.006989, 0.004776, 1.682865>, 
      <-0.155811, -0.083181, 1.588623>, <-0.126221, -0.083181, 1.654112>, <-0.064875, -0.067088, 1.682865>, <0.006989, 0.004776, 1.682865>, 
      <-0.080967, -0.158024, 1.588623>, <-0.080967, -0.128434, 1.654112>, <-0.064875, -0.067088, 1.682865>, <0.006989, 0.004776, 1.682865>, 
      <0.006989, -0.158024, 1.588623>, <0.006989, -0.128434, 1.654112>, <0.006989, -0.067088, 1.682865>, <0.006989, 0.004776, 1.682865>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265585, 0.047890, -0.047300>, <0.291140, 0.047890, -0.047300>, <0.312885, 0.047890, -0.025555>, <0.312885, 0.047890, 0.000000>, 
      <0.240030, 0.047890, -0.047300>, <0.265585, 0.047890, -0.047300>, <0.298908, 0.023190, -0.025555>, <0.312885, 0.047890, 0.000000>, 
      <0.218285, 0.047890, -0.025555>, <0.232261, 0.023190, -0.025555>, <0.298908, 0.023190, -0.025555>, <0.312885, 0.047890, 0.000000>, 
      <0.218285, 0.047890, 0.000000>, <0.232261, 0.023190, 0.000000>, <0.298908, 0.023190, 0.000000>, <0.312885, 0.047890, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.218285, 0.047890, 0.000000>, <0.218285, 0.047890, -0.025555>, <0.240030, 0.047890, -0.047300>, <0.265585, 0.047890, -0.047300>, 
      <0.218285, 0.047890, 0.025555>, <0.218285, 0.047890, 0.000000>, <0.240030, 0.023190, -0.033324>, <0.265585, 0.047890, -0.047300>, 
      <0.240030, 0.047890, 0.047300>, <0.240030, 0.023190, 0.033324>, <0.240030, 0.023190, -0.033324>, <0.265585, 0.047890, -0.047300>, 
      <0.265585, 0.047890, 0.047300>, <0.265585, 0.023190, 0.033324>, <0.265585, 0.023190, -0.033324>, <0.265585, 0.047890, -0.047300>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265585, 0.256081, -0.110000>, <0.265585, 0.300330, -0.090007>, <0.265585, 0.319757, -0.048557>, <0.265585, 0.319757, 0.000000>, 
      <0.206154, 0.256081, -0.110000>, <0.206154, 0.300330, -0.090007>, <0.217028, 0.319757, -0.048557>, <0.265585, 0.319757, 0.000000>, 
      <0.155585, 0.256081, -0.059430>, <0.175578, 0.300330, -0.059430>, <0.217028, 0.319757, -0.048557>, <0.265585, 0.319757, 0.000000>, 
      <0.155585, 0.256081, 0.000000>, <0.175578, 0.300330, 0.000000>, <0.217028, 0.319757, 0.000000>, <0.265585, 0.319757, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.375585, 0.256081, 0.000000>, <0.355591, 0.300330, 0.000000>, <0.314141, 0.319757, 0.000000>, <0.265585, 0.319757, 0.000000>, 
      <0.375585, 0.256081, -0.059430>, <0.355591, 0.300330, -0.059430>, <0.314141, 0.319757, -0.048557>, <0.265585, 0.319757, 0.000000>, 
      <0.325015, 0.256081, -0.110000>, <0.325015, 0.300330, -0.090007>, <0.314141, 0.319757, -0.048557>, <0.265585, 0.319757, 0.000000>, 
      <0.265585, 0.256081, -0.110000>, <0.265585, 0.300330, -0.090007>, <0.265585, 0.319757, -0.048557>, <0.265585, 0.319757, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265585, 0.256081, 0.110000>, <0.265585, 0.300330, 0.090007>, <0.265585, 0.319757, 0.048557>, <0.265585, 0.319757, 0.000000>, 
      <0.325015, 0.256081, 0.110000>, <0.325015, 0.300330, 0.090007>, <0.314141, 0.319757, 0.048557>, <0.265585, 0.319757, 0.000000>, 
      <0.375585, 0.256081, 0.059430>, <0.355591, 0.300330, 0.059430>, <0.314141, 0.319757, 0.048557>, <0.265585, 0.319757, 0.000000>, 
      <0.375585, 0.256081, 0.000000>, <0.355591, 0.300330, 0.000000>, <0.314141, 0.319757, 0.000000>, <0.265585, 0.319757, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.155585, 0.256081, 0.000000>, <0.175578, 0.300330, 0.000000>, <0.217028, 0.319757, 0.000000>, <0.265585, 0.319757, 0.000000>, 
      <0.155585, 0.256081, 0.059430>, <0.175578, 0.300330, 0.059430>, <0.217028, 0.319757, 0.048557>, <0.265585, 0.319757, 0.000000>, 
      <0.206154, 0.256081, 0.110000>, <0.206154, 0.300330, 0.090007>, <0.217028, 0.319757, 0.048557>, <0.265585, 0.319757, 0.000000>, 
      <0.265585, 0.256081, 0.110000>, <0.265585, 0.300330, 0.090007>, <0.265585, 0.319757, 0.048557>, <0.265585, 0.319757, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265585, -0.047890, -0.047300>, <0.291140, -0.047890, -0.047300>, <0.312885, -0.047890, -0.025555>, <0.312885, -0.047890, 0.000000>, 
      <0.240030, -0.047890, -0.047300>, <0.265585, -0.047890, -0.047300>, <0.298908, -0.023190, -0.025555>, <0.312885, -0.047890, 0.000000>, 
      <0.218285, -0.047890, -0.025555>, <0.232261, -0.023190, -0.025555>, <0.298908, -0.023190, -0.025555>, <0.312885, -0.047890, 0.000000>, 
      <0.218285, -0.047890, 0.000000>, <0.232261, -0.023190, 0.000000>, <0.298908, -0.023190, 0.000000>, <0.312885, -0.047890, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.218285, -0.047890, 0.000000>, <0.218285, -0.047890, -0.025555>, <0.240030, -0.047890, -0.047300>, <0.265585, -0.047890, -0.047300>, 
      <0.218285, -0.047890, 0.025555>, <0.218285, -0.047890, 0.000000>, <0.240030, -0.023190, -0.033324>, <0.265585, -0.047890, -0.047300>, 
      <0.240030, -0.047890, 0.047300>, <0.240030, -0.023190, 0.033324>, <0.240030, -0.023190, -0.033324>, <0.265585, -0.047890, -0.047300>, 
      <0.265585, -0.047890, 0.047300>, <0.265585, -0.023190, 0.033324>, <0.265585, -0.023190, -0.033324>, <0.265585, -0.047890, -0.047300>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265585, -0.256081, -0.110000>, <0.265585, -0.300330, -0.090007>, <0.265585, -0.319757, -0.048557>, <0.265585, -0.319757, 0.000000>, 
      <0.206154, -0.256081, -0.110000>, <0.206154, -0.300330, -0.090007>, <0.217028, -0.319757, -0.048557>, <0.265585, -0.319757, 0.000000>, 
      <0.155585, -0.256081, -0.059430>, <0.175578, -0.300330, -0.059430>, <0.217028, -0.319757, -0.048557>, <0.265585, -0.319757, 0.000000>, 
      <0.155585, -0.256081, 0.000000>, <0.175578, -0.300330, 0.000000>, <0.217028, -0.319757, 0.000000>, <0.265585, -0.319757, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.375585, -0.256081, 0.000000>, <0.355591, -0.300330, 0.000000>, <0.314141, -0.319757, 0.000000>, <0.265585, -0.319757, 0.000000>, 
      <0.375585, -0.256081, -0.059430>, <0.355591, -0.300330, -0.059430>, <0.314141, -0.319757, -0.048557>, <0.265585, -0.319757, 0.000000>, 
      <0.325015, -0.256081, -0.110000>, <0.325015, -0.300330, -0.090007>, <0.314141, -0.319757, -0.048557>, <0.265585, -0.319757, 0.000000>, 
      <0.265585, -0.256081, -0.110000>, <0.265585, -0.300330, -0.090007>, <0.265585, -0.319757, -0.048557>, <0.265585, -0.319757, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265585, -0.256081, 0.110000>, <0.265585, -0.300330, 0.090007>, <0.265585, -0.319757, 0.048557>, <0.265585, -0.319757, 0.000000>, 
      <0.325015, -0.256081, 0.110000>, <0.325015, -0.300330, 0.090007>, <0.314141, -0.319757, 0.048557>, <0.265585, -0.319757, 0.000000>, 
      <0.375585, -0.256081, 0.059430>, <0.355591, -0.300330, 0.059430>, <0.314141, -0.319757, 0.048557>, <0.265585, -0.319757, 0.000000>, 
      <0.375585, -0.256081, 0.000000>, <0.355591, -0.300330, 0.000000>, <0.314141, -0.319757, 0.000000>, <0.265585, -0.319757, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.155585, -0.256081, 0.000000>, <0.175578, -0.300330, 0.000000>, <0.217028, -0.319757, 0.000000>, <0.265585, -0.319757, 0.000000>, 
      <0.155585, -0.256081, 0.059430>, <0.175578, -0.300330, 0.059430>, <0.217028, -0.319757, 0.048557>, <0.265585, -0.319757, 0.000000>, 
      <0.206154, -0.256081, 0.110000>, <0.206154, -0.300330, 0.090007>, <0.217028, -0.319757, 0.048557>, <0.265585, -0.319757, 0.000000>, 
      <0.265585, -0.256081, 0.110000>, <0.265585, -0.300330, 0.090007>, <0.265585, -0.319757, 0.048557>, <0.265585, -0.319757, 0.000000>
    }
  }
  material {
    negro_txt
  }
}
#declare horquilla = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.466158, 0.190441, 1.278364>, <-0.493667, 0.191626, 1.280719>, <-0.509199, 0.230088, 1.357108>, <-0.481690, 0.231274, 1.359463>, 
      <-0.371399, 0.190441, 1.044400>, <-0.398908, 0.191626, 1.046755>, <-0.410492, 0.230088, 1.100736>, <-0.382983, 0.231274, 1.103090>, 
      <-0.230464, 0.190441, 0.737839>, <-0.242857, 0.191259, 0.737968>, <-0.251227, 0.230473, 0.765617>, <-0.238833, 0.231274, 0.765742>, 
      <-0.150295, 0.190441, 0.498483>, <-0.162687, 0.191259, 0.498611>, <-0.165059, 0.230473, 0.504762>, <-0.152666, 0.231274, 0.504888>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.466158, -0.196163, 1.272191>, <-0.187839, -0.184168, 1.248608>, <0.187437, -0.184168, 1.248608>, <0.465757, -0.196163, 1.272191>, 
      <-0.466158, -0.138172, 1.273117>, <-0.187839, -0.126177, 1.249534>, <0.187437, -0.126177, 1.249534>, <0.465757, -0.138172, 1.273117>, 
      <-0.466158, -0.060852, 1.274352>, <-0.187592, -0.060852, 1.250628>, <0.187190, -0.060852, 1.250628>, <0.465757, -0.060852, 1.274352>, 
      <-0.466158, -0.002861, 1.275278>, <-0.187592, -0.002861, 1.251553>, <0.187190, -0.002861, 1.251553>, <0.465756, -0.002861, 1.275278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.007637, -0.196163, -0.136217>, <0.010703, -0.196935, -0.148129>, <0.014846, -0.236232, -0.146544>, <0.011847, -0.236996, -0.134615>, 
      <-0.040949, -0.183927, 0.052566>, <-0.037883, -0.184699, 0.040654>, <-0.033115, -0.248449, 0.044222>, <-0.036114, -0.249213, 0.056152>, 
      <-0.088019, -0.196163, 0.310273>, <-0.100393, -0.196980, 0.310393>, <-0.102963, -0.236196, 0.314226>, <-0.090587, -0.236996, 0.314343>, 
      <-0.150295, -0.196163, 0.495397>, <-0.162669, -0.196980, 0.495517>, <-0.165041, -0.236196, 0.501276>, <-0.152666, -0.236996, 0.501393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.481690, -0.236996, 1.352474>, <-0.508987, -0.235819, 1.350161>, <-0.493455, -0.197339, 1.274504>, <-0.466158, -0.196163, 1.272191>, 
      <-0.382983, -0.236996, 1.097150>, <-0.410280, -0.235819, 1.094837>, <-0.398696, -0.197339, 1.041466>, <-0.371399, -0.196163, 1.039153>, 
      <-0.238890, -0.236996, 0.761199>, <-0.251265, -0.236196, 0.761081>, <-0.242881, -0.196980, 0.733954>, <-0.230506, -0.196163, 0.733834>, 
      <-0.152666, -0.236996, 0.501393>, <-0.165041, -0.236196, 0.501276>, <-0.162669, -0.196980, 0.495517>, <-0.150295, -0.196163, 0.495397>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.481690, -0.002861, 1.355968>, <-0.506253, -0.002861, 1.353877>, <-0.490721, -0.002861, 1.277370>, <-0.466158, -0.002861, 1.275278>, 
      <-0.481690, -0.073101, 1.354920>, <-0.506253, -0.073101, 1.352828>, <-0.490721, -0.060852, 1.276444>, <-0.466158, -0.060852, 1.274352>, 
      <-0.481690, -0.166755, 1.353522>, <-0.508987, -0.165579, 1.351209>, <-0.493455, -0.139349, 1.275430>, <-0.466158, -0.138172, 1.273117>, 
      <-0.481690, -0.236996, 1.352474>, <-0.508987, -0.235819, 1.350161>, <-0.493455, -0.197339, 1.274504>, <-0.466158, -0.196163, 1.272191>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.481690, 0.231274, 1.359463>, <-0.509199, 0.230088, 1.357108>, <-0.493667, 0.191626, 1.280719>, <-0.466158, 0.190441, 1.278364>, 
      <-0.481690, 0.161033, 1.358415>, <-0.509199, 0.159848, 1.356060>, <-0.493667, 0.133636, 1.279793>, <-0.466158, 0.132450, 1.277438>, 
      <-0.481690, 0.067379, 1.357017>, <-0.506253, 0.067379, 1.354925>, <-0.490721, 0.055129, 1.278296>, <-0.466158, 0.055129, 1.276204>, 
      <-0.481690, -0.002861, 1.355968>, <-0.506253, -0.002861, 1.353877>, <-0.490721, -0.002861, 1.277370>, <-0.466158, -0.002861, 1.275278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.152666, 0.231274, 0.504888>, <0.037115, 0.243544, 0.506812>, <0.291525, 0.243804, 0.506853>, <0.481288, 0.231274, 0.504888>, 
      <-0.238833, 0.231274, 0.765742>, <-0.049053, 0.243544, 0.767667>, <0.286450, 0.243804, 0.763176>, <0.476213, 0.231274, 0.761210>, 
      <-0.382983, 0.231274, 1.103090>, <-0.095407, 0.243668, 1.127706>, <0.193712, 0.243668, 1.127706>, <0.481288, 0.231274, 1.103090>, 
      <-0.481690, 0.231274, 1.359463>, <-0.194114, 0.243668, 1.384079>, <0.193712, 0.243668, 1.384079>, <0.481288, 0.231274, 1.359463>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.007637, 0.190441, -0.136217>, <-0.040950, 0.178205, 0.053495>, <-0.087977, 0.190441, 0.312426>, <-0.150295, 0.190441, 0.498483>, 
      <0.010689, 0.191209, -0.148132>, <-0.037898, 0.178973, 0.041579>, <-0.100370, 0.191259, 0.312554>, <-0.162687, 0.191259, 0.498611>, 
      <0.014831, 0.230514, -0.146548>, <-0.033131, 0.242731, 0.045267>, <-0.102924, 0.230473, 0.316662>, <-0.165059, 0.230473, 0.504762>, 
      <0.011847, 0.231274, -0.134615>, <-0.036115, 0.243491, 0.057200>, <-0.090531, 0.231274, 0.316787>, <-0.152666, 0.231274, 0.504888>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481288, 0.231274, 1.359463>, <0.508797, 0.230088, 1.357108>, <0.493266, 0.191626, 1.280719>, <0.465756, 0.190441, 1.278364>, 
      <0.481288, 0.231274, 1.103090>, <0.508797, 0.230088, 1.100736>, <0.493266, 0.191626, 1.046755>, <0.465756, 0.190441, 1.044400>, 
      <0.476213, 0.231274, 0.761210>, <0.489430, 0.230401, 0.761073>, <0.473192, 0.191295, 0.732510>, <0.459974, 0.190441, 0.732376>, 
      <0.481288, 0.231274, 0.504888>, <0.494505, 0.230401, 0.504751>, <0.478975, 0.191295, 0.498617>, <0.465756, 0.190441, 0.498483>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481288, -0.002861, 1.355968>, <0.193437, -0.002861, 1.380484>, <-0.193839, -0.002861, 1.380484>, <-0.481690, -0.002861, 1.355968>, 
      <0.481288, 0.067379, 1.357017>, <0.193437, 0.067379, 1.381532>, <-0.193839, 0.067379, 1.381532>, <-0.481690, 0.067379, 1.357017>, 
      <0.481288, 0.161033, 1.358415>, <0.193712, 0.173427, 1.383030>, <-0.194114, 0.173427, 1.383030>, <-0.481690, 0.161033, 1.358415>, 
      <0.481288, 0.231274, 1.359463>, <0.193712, 0.243668, 1.384079>, <-0.194114, 0.243668, 1.384079>, <-0.481690, 0.231274, 1.359463>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481288, -0.236996, 1.352474>, <0.193691, -0.249391, 1.376844>, <-0.194093, -0.249391, 1.376844>, <-0.481690, -0.236996, 1.352474>, 
      <0.481288, -0.166755, 1.353522>, <0.193691, -0.179150, 1.377892>, <-0.194093, -0.179150, 1.377892>, <-0.481690, -0.166755, 1.353522>, 
      <0.481288, -0.073101, 1.354920>, <0.193437, -0.073101, 1.379435>, <-0.193839, -0.073101, 1.379435>, <-0.481690, -0.073101, 1.354920>, 
      <0.481288, -0.002861, 1.355968>, <0.193437, -0.002861, 1.380484>, <-0.193839, -0.002861, 1.380484>, <-0.481690, -0.002861, 1.355968>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481288, -0.236996, 0.501393>, <0.291524, -0.249526, 0.503233>, <0.037116, -0.249266, 0.503195>, <-0.152666, -0.236996, 0.501393>, 
      <0.476210, -0.236996, 0.756667>, <0.286446, -0.249526, 0.758507>, <-0.049109, -0.249266, 0.763001>, <-0.238890, -0.236996, 0.761199>, 
      <0.481288, -0.236996, 1.097150>, <0.193691, -0.249391, 1.121519>, <-0.095386, -0.249391, 1.121519>, <-0.382983, -0.236996, 1.097150>, 
      <0.481288, -0.236996, 1.352474>, <0.193691, -0.249391, 1.376844>, <-0.194093, -0.249391, 1.376844>, <-0.481690, -0.236996, 1.352474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511054, -0.236996, -0.143922>, <0.511452, -0.236155, -0.156971>, <0.501564, -0.196994, -0.145737>, <0.500641, -0.196163, -0.132714>, 
      <0.505155, -0.249444, 0.049388>, <0.505553, -0.248604, 0.036340>, <0.488252, -0.184995, 0.042134>, <0.487330, -0.184163, 0.055156>, 
      <0.485142, -0.236996, 0.307631>, <0.498342, -0.236124, 0.307503>, <0.483642, -0.197016, 0.306856>, <0.470441, -0.196163, 0.306731>, 
      <0.481288, -0.236996, 0.501393>, <0.494488, -0.236124, 0.501265>, <0.478958, -0.197016, 0.495522>, <0.465757, -0.196163, 0.495397>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465757, -0.196163, 1.272191>, <0.493053, -0.197339, 1.274504>, <0.508585, -0.235819, 1.350161>, <0.481288, -0.236996, 1.352474>, 
      <0.465757, -0.196163, 1.039153>, <0.493053, -0.197339, 1.041466>, <0.508585, -0.235819, 1.094837>, <0.481288, -0.236996, 1.097150>, 
      <0.459972, -0.196163, 0.728363>, <0.473173, -0.197016, 0.728488>, <0.489410, -0.236124, 0.756539>, <0.476210, -0.236996, 0.756667>, 
      <0.465757, -0.196163, 0.495397>, <0.478958, -0.197016, 0.495522>, <0.494488, -0.236124, 0.501265>, <0.481288, -0.236996, 0.501393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465757, -0.196163, 1.272191>, <0.187437, -0.184168, 1.248608>, <-0.187839, -0.184168, 1.248608>, <-0.466158, -0.196163, 1.272191>, 
      <0.465757, -0.196163, 1.039153>, <0.187437, -0.184168, 1.015569>, <-0.093080, -0.184168, 1.015569>, <-0.371399, -0.196163, 1.039153>, 
      <0.459972, -0.196163, 0.728363>, <0.275550, -0.184239, 0.726612>, <-0.046101, -0.183987, 0.732046>, <-0.230506, -0.196163, 0.733834>, 
      <0.465757, -0.196163, 0.495397>, <0.281334, -0.184239, 0.493646>, <0.034110, -0.183987, 0.493608>, <-0.150295, -0.196163, 0.495397>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465756, -0.002861, 1.275278>, <0.490319, -0.002861, 1.277370>, <0.505851, -0.002861, 1.353877>, <0.481288, -0.002861, 1.355968>, 
      <0.465757, -0.060852, 1.274352>, <0.490319, -0.060852, 1.276444>, <0.505851, -0.073101, 1.352828>, <0.481288, -0.073101, 1.354920>, 
      <0.465757, -0.138172, 1.273117>, <0.493053, -0.139349, 1.275430>, <0.508585, -0.165579, 1.351209>, <0.481288, -0.166755, 1.353522>, 
      <0.465757, -0.196163, 1.272191>, <0.493053, -0.197339, 1.274504>, <0.508585, -0.235819, 1.350161>, <0.481288, -0.236996, 1.352474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465756, 0.190441, 1.278364>, <0.187457, 0.178447, 1.254542>, <-0.187859, 0.178447, 1.254542>, <-0.466158, 0.190441, 1.278364>, 
      <0.465756, 0.132450, 1.277438>, <0.187457, 0.120456, 1.253617>, <-0.187859, 0.120456, 1.253617>, <-0.466158, 0.132450, 1.277438>, 
      <0.465756, 0.055129, 1.276204>, <0.187190, 0.055129, 1.252479>, <-0.187592, 0.055129, 1.252479>, <-0.466158, 0.055129, 1.276204>, 
      <0.465756, -0.002861, 1.275278>, <0.187190, -0.002861, 1.251553>, <-0.187592, -0.002861, 1.251553>, <-0.466158, -0.002861, 1.275278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465756, 0.190441, 1.278364>, <0.493266, 0.191626, 1.280719>, <0.508797, 0.230088, 1.357108>, <0.481288, 0.231274, 1.359463>, 
      <0.465756, 0.132450, 1.277438>, <0.493266, 0.133636, 1.279793>, <0.508797, 0.159848, 1.356060>, <0.481288, 0.161033, 1.358415>, 
      <0.465756, 0.055129, 1.276204>, <0.490319, 0.055129, 1.278296>, <0.505851, 0.067379, 1.354925>, <0.481288, 0.067379, 1.357017>, 
      <0.465756, -0.002861, 1.275278>, <0.490319, -0.002861, 1.277370>, <0.505851, -0.002861, 1.353877>, <0.481288, -0.002861, 1.355968>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465756, 0.190441, 0.498483>, <0.281336, 0.178518, 0.496613>, <0.034109, 0.178265, 0.496573>, <-0.150295, 0.190441, 0.498483>, 
      <0.459974, 0.190441, 0.732376>, <0.275553, 0.178518, 0.730506>, <-0.046060, 0.178265, 0.735930>, <-0.230464, 0.190441, 0.737839>, 
      <0.465756, 0.190441, 1.044400>, <0.187457, 0.178447, 1.020578>, <-0.093100, 0.178447, 1.020578>, <-0.371399, 0.190441, 1.044400>, 
      <0.465756, 0.190441, 1.278364>, <0.187457, 0.178447, 1.254542>, <-0.187859, 0.178447, 1.254542>, <-0.466158, 0.190441, 1.278364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500641, 0.190441, -0.132714>, <0.352740, 0.190441, -0.133765>, <0.155538, 0.190441, -0.135166>, <0.007637, 0.190441, -0.136217>, 
      <0.487328, 0.178440, 0.056085>, <0.339427, 0.178440, 0.055034>, <0.106951, 0.178205, 0.054545>, <-0.040950, 0.178205, 0.053495>, 
      <0.470444, 0.190441, 0.308893>, <0.286023, 0.178518, 0.307022>, <0.096427, 0.178265, 0.310516>, <-0.087977, 0.190441, 0.312426>, 
      <0.465756, 0.190441, 0.498483>, <0.281336, 0.178518, 0.496613>, <0.034109, 0.178265, 0.496573>, <-0.150295, 0.190441, 0.498483>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511054, 0.231274, -0.143922>, <0.505155, 0.243721, 0.050438>, <0.485145, 0.231274, 0.310078>, <0.481288, 0.231274, 0.504888>, 
      <0.511450, 0.230438, -0.156971>, <0.505551, 0.242885, 0.037389>, <0.498362, 0.230401, 0.309941>, <0.494505, 0.230401, 0.504751>, 
      <0.501559, 0.191269, -0.145737>, <0.488246, 0.179268, 0.043062>, <0.483662, 0.191295, 0.309027>, <0.478975, 0.191295, 0.498617>, 
      <0.500641, 0.190441, -0.132714>, <0.487328, 0.178440, 0.056085>, <0.470444, 0.190441, 0.308893>, <0.465756, 0.190441, 0.498483>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.007637, 0.190441, -0.136217>, <0.010689, 0.191209, -0.148132>, <0.014831, 0.230514, -0.146548>, <0.011847, 0.231274, -0.134615>, 
      <0.155538, 0.190441, -0.135166>, <0.158590, 0.191209, -0.147082>, <0.164593, 0.230514, -0.149340>, <0.161609, 0.231274, -0.137407>, 
      <0.352740, 0.190441, -0.133765>, <0.353658, 0.191269, -0.146788>, <0.361688, 0.230438, -0.154179>, <0.361292, 0.231274, -0.141130>, 
      <0.500641, 0.190441, -0.132714>, <0.501559, 0.191269, -0.145737>, <0.511450, 0.230438, -0.156971>, <0.511054, 0.231274, -0.143922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.007637, -0.196163, -0.136217>, <-0.040949, -0.183927, 0.052566>, <-0.088019, -0.196163, 0.310273>, <-0.150295, -0.196163, 0.495397>, 
      <0.155538, -0.196163, -0.135166>, <0.106953, -0.183927, 0.053616>, <0.096387, -0.183987, 0.308485>, <0.034110, -0.183987, 0.493608>, 
      <0.352740, -0.196163, -0.133765>, <0.339428, -0.184163, 0.054106>, <0.286019, -0.184239, 0.304980>, <0.281334, -0.184239, 0.493646>, 
      <0.500641, -0.196163, -0.132714>, <0.487330, -0.184163, 0.055156>, <0.470441, -0.196163, 0.306731>, <0.465757, -0.196163, 0.495397>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.011847, 0.231274, -0.134615>, <-0.036115, 0.243491, 0.057200>, <-0.090531, 0.231274, 0.316787>, <-0.152666, 0.231274, 0.504888>, 
      <0.161609, 0.231274, -0.137407>, <0.113648, 0.243491, 0.054408>, <0.099250, 0.243544, 0.318712>, <0.037115, 0.243544, 0.506812>, 
      <0.361292, 0.231274, -0.141130>, <0.355393, 0.243721, 0.053230>, <0.295382, 0.243804, 0.312044>, <0.291525, 0.243804, 0.506853>, 
      <0.511054, 0.231274, -0.143922>, <0.505155, 0.243721, 0.050438>, <0.485145, 0.231274, 0.310078>, <0.481288, 0.231274, 0.504888>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.011847, -0.236996, -0.134615>, <-0.036114, -0.249213, 0.056152>, <-0.090587, -0.236996, 0.314343>, <-0.152666, -0.236996, 0.501393>, 
      <0.161609, -0.236996, -0.137407>, <0.113648, -0.249213, 0.053359>, <0.099194, -0.249266, 0.316145>, <0.037116, -0.249266, 0.503195>, 
      <0.361292, -0.236996, -0.141130>, <0.355392, -0.249444, 0.052180>, <0.295378, -0.249526, 0.309471>, <0.291524, -0.249526, 0.503233>, 
      <0.511054, -0.236996, -0.143922>, <0.505155, -0.249444, 0.049388>, <0.485142, -0.236996, 0.307631>, <0.481288, -0.236996, 0.501393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.011847, -0.236996, -0.134615>, <0.014846, -0.236232, -0.146544>, <0.010703, -0.196935, -0.148129>, <0.007637, -0.196163, -0.136217>, 
      <0.161609, -0.236996, -0.137407>, <0.164608, -0.236232, -0.149336>, <0.158604, -0.196935, -0.147078>, <0.155538, -0.196163, -0.135166>, 
      <0.361292, -0.236996, -0.141130>, <0.361690, -0.236155, -0.154178>, <0.353662, -0.196994, -0.146787>, <0.352740, -0.196163, -0.133765>, 
      <0.511054, -0.236996, -0.143922>, <0.511452, -0.236155, -0.156971>, <0.501564, -0.196994, -0.145737>, <0.500641, -0.196163, -0.132714>
    }
  }
}
#declare embellecedor = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.023747, -0.120075, 0.165509>, <0.002099, -0.120075, 0.210274>, <0.053324, -0.120075, 0.261500>, <0.098089, -0.120075, 0.287345>, 
      <0.062361, -0.120034, 0.115794>, <0.088207, -0.120034, 0.160559>, <0.103039, -0.120034, 0.175391>, <0.147804, -0.120034, 0.201237>, 
      <0.177172, -0.119979, 0.049508>, <0.177284, -0.119979, 0.049701>, <0.213898, -0.119979, 0.086315>, <0.214090, -0.119979, 0.086426>, 
      <0.263281, -0.119937, -0.000207>, <0.263392, -0.119937, -0.000014>, <0.263612, -0.119937, 0.000206>, <0.263805, -0.119937, 0.000318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.097344, -0.162566, 0.208000>, <-0.064900, -0.162566, 0.264194>, <-0.000596, -0.162566, 0.328498>, <0.055598, -0.162566, 0.360942>, 
      <-0.073471, -0.155312, 0.194217>, <-0.041027, -0.155312, 0.250411>, <0.013187, -0.155312, 0.304626>, <0.069381, -0.155312, 0.337070>, 
      <-0.045826, -0.132823, 0.178256>, <-0.019981, -0.132823, 0.223021>, <0.040577, -0.132823, 0.283579>, <0.085342, -0.132823, 0.309424>, 
      <-0.023747, -0.120075, 0.165509>, <0.002099, -0.120075, 0.210274>, <0.053324, -0.120075, 0.261500>, <0.098089, -0.120075, 0.287345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.163581, -0.162566, 0.246242>, <-0.125198, -0.162566, 0.312722>, <-0.049124, -0.162566, 0.388796>, <0.017356, -0.162566, 0.427179>, 
      <-0.147917, -0.176685, 0.237198>, <-0.109534, -0.176685, 0.303679>, <-0.040080, -0.176685, 0.373132>, <0.026400, -0.176685, 0.411515>, 
      <-0.116561, -0.168406, 0.219094>, <-0.084117, -0.168406, 0.275289>, <-0.011691, -0.168406, 0.347715>, <0.044503, -0.168406, 0.380159>, 
      <-0.097344, -0.162566, 0.208000>, <-0.064900, -0.162566, 0.264194>, <-0.000596, -0.162566, 0.328498>, <0.055598, -0.162566, 0.360942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.163581, -0.102865, 0.246242>, <-0.125198, -0.102865, 0.312722>, <-0.049124, -0.102865, 0.388796>, <0.017356, -0.102865, 0.427179>, 
      <-0.163581, -0.120775, 0.246242>, <-0.125198, -0.120775, 0.312722>, <-0.049124, -0.120775, 0.388796>, <0.017356, -0.120775, 0.427179>, 
      <-0.175808, -0.151546, 0.253301>, <-0.137425, -0.151546, 0.319781>, <-0.056183, -0.151546, 0.401023>, <0.010297, -0.151546, 0.439406>, 
      <-0.163581, -0.162566, 0.246242>, <-0.125198, -0.162566, 0.312722>, <-0.049124, -0.162566, 0.388796>, <0.017356, -0.162566, 0.427179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.098089, -0.120075, 0.287345>, <0.142855, -0.120075, 0.313190>, <0.212830, -0.120075, 0.331940>, <0.264521, -0.120075, 0.331940>, 
      <0.147804, -0.120034, 0.201237>, <0.192570, -0.120034, 0.227082>, <0.212830, -0.120034, 0.232511>, <0.264521, -0.120034, 0.232511>, 
      <0.214090, -0.119979, 0.086426>, <0.214283, -0.119979, 0.086537>, <0.264299, -0.119979, 0.099939>, <0.264521, -0.119979, 0.099939>, 
      <0.263805, -0.119937, 0.000318>, <0.263998, -0.119937, 0.000429>, <0.264299, -0.119937, 0.000510>, <0.264521, -0.119937, 0.000510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.055598, -0.162566, 0.360942>, <0.111793, -0.162566, 0.393386>, <0.199633, -0.162566, 0.416923>, <0.264521, -0.162566, 0.416923>, 
      <0.069381, -0.155312, 0.337070>, <0.125576, -0.155312, 0.369513>, <0.199633, -0.155312, 0.389357>, <0.264521, -0.155312, 0.389357>, 
      <0.085342, -0.132823, 0.309424>, <0.130108, -0.132823, 0.335270>, <0.212830, -0.132823, 0.357435>, <0.264521, -0.132823, 0.357435>, 
      <0.098089, -0.120075, 0.287345>, <0.142855, -0.120075, 0.313190>, <0.212830, -0.120075, 0.331940>, <0.264521, -0.120075, 0.331940>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.017356, -0.162566, 0.427179>, <0.083837, -0.162566, 0.465561>, <0.187756, -0.162566, 0.493407>, <0.264521, -0.162566, 0.493407>, 
      <0.026400, -0.176685, 0.411515>, <0.092881, -0.176685, 0.449897>, <0.187756, -0.176685, 0.475319>, <0.264521, -0.176685, 0.475319>, 
      <0.044503, -0.168406, 0.380159>, <0.100698, -0.168406, 0.412603>, <0.199633, -0.168406, 0.439112>, <0.264521, -0.168406, 0.439112>, 
      <0.055598, -0.162566, 0.360942>, <0.111793, -0.162566, 0.393386>, <0.199633, -0.162566, 0.416923>, <0.264521, -0.162566, 0.416923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.017356, -0.102865, 0.427179>, <0.083837, -0.102865, 0.465561>, <0.187756, -0.102865, 0.493407>, <0.264521, -0.102865, 0.493407>, 
      <0.017356, -0.120775, 0.427179>, <0.083837, -0.120775, 0.465561>, <0.187756, -0.120775, 0.493407>, <0.264521, -0.120775, 0.493407>, 
      <0.010297, -0.151546, 0.439406>, <0.076778, -0.151546, 0.477788>, <0.187756, -0.151546, 0.507525>, <0.264521, -0.151546, 0.507525>, 
      <0.017356, -0.162566, 0.427179>, <0.083837, -0.162566, 0.465561>, <0.187756, -0.162566, 0.493407>, <0.264521, -0.162566, 0.493407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, -0.120075, 0.331940>, <0.316212, -0.120075, 0.331940>, <0.386187, -0.120075, 0.313190>, <0.430953, -0.120075, 0.287345>, 
      <0.264521, -0.120034, 0.232511>, <0.316212, -0.120034, 0.232511>, <0.336473, -0.120034, 0.227082>, <0.381238, -0.120034, 0.201237>, 
      <0.264521, -0.119979, 0.099939>, <0.264744, -0.119979, 0.099939>, <0.314759, -0.119979, 0.086537>, <0.314952, -0.119979, 0.086426>, 
      <0.264521, -0.119937, 0.000510>, <0.264744, -0.119937, 0.000510>, <0.265045, -0.119937, 0.000429>, <0.265237, -0.119937, 0.000318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, -0.162566, 0.416923>, <0.329409, -0.162566, 0.416923>, <0.417250, -0.162566, 0.393386>, <0.473444, -0.162566, 0.360942>, 
      <0.264521, -0.155312, 0.389357>, <0.329409, -0.155312, 0.389357>, <0.403467, -0.155312, 0.369513>, <0.459661, -0.155312, 0.337070>, 
      <0.264521, -0.132823, 0.357435>, <0.316212, -0.132823, 0.357435>, <0.398935, -0.132823, 0.335270>, <0.443700, -0.132823, 0.309424>, 
      <0.264521, -0.120075, 0.331940>, <0.316212, -0.120075, 0.331940>, <0.386187, -0.120075, 0.313190>, <0.430953, -0.120075, 0.287345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, -0.162566, 0.493407>, <0.341286, -0.162566, 0.493407>, <0.445205, -0.162566, 0.465561>, <0.511686, -0.162566, 0.427179>, 
      <0.264521, -0.176685, 0.475319>, <0.341286, -0.176685, 0.475319>, <0.436162, -0.176685, 0.449897>, <0.502642, -0.176685, 0.411515>, 
      <0.264521, -0.168406, 0.439112>, <0.329409, -0.168406, 0.439112>, <0.428344, -0.168406, 0.412603>, <0.484539, -0.168406, 0.380159>, 
      <0.264521, -0.162566, 0.416923>, <0.329409, -0.162566, 0.416923>, <0.417250, -0.162566, 0.393386>, <0.473444, -0.162566, 0.360942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, -0.102865, 0.493407>, <0.341286, -0.102865, 0.493407>, <0.445205, -0.102865, 0.465561>, <0.511686, -0.102865, 0.427179>, 
      <0.264521, -0.120775, 0.493407>, <0.341286, -0.120775, 0.493407>, <0.445205, -0.120775, 0.465561>, <0.511686, -0.120775, 0.427179>, 
      <0.264521, -0.151546, 0.507525>, <0.341286, -0.151546, 0.507525>, <0.452265, -0.151546, 0.477788>, <0.518745, -0.151546, 0.439406>, 
      <0.264521, -0.162566, 0.493407>, <0.341286, -0.162566, 0.493407>, <0.445205, -0.162566, 0.465561>, <0.511686, -0.162566, 0.427179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.430953, -0.120075, 0.287345>, <0.475718, -0.120075, 0.261500>, <0.526944, -0.120075, 0.210274>, <0.552789, -0.120075, 0.165509>, 
      <0.381238, -0.120034, 0.201237>, <0.426004, -0.120034, 0.175391>, <0.440836, -0.120034, 0.160560>, <0.466681, -0.120034, 0.115794>, 
      <0.314952, -0.119979, 0.086426>, <0.315145, -0.119979, 0.086315>, <0.351759, -0.119979, 0.049701>, <0.351870, -0.119979, 0.049508>, 
      <0.265237, -0.119937, 0.000318>, <0.265430, -0.119937, 0.000206>, <0.265650, -0.119937, -0.000014>, <0.265762, -0.119937, -0.000207>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.473444, -0.162566, 0.360942>, <0.529639, -0.162566, 0.328498>, <0.593942, -0.162566, 0.264194>, <0.626386, -0.162566, 0.208000>, 
      <0.459661, -0.155312, 0.337070>, <0.515856, -0.155312, 0.304626>, <0.570070, -0.155312, 0.250412>, <0.602514, -0.155312, 0.194217>, 
      <0.443700, -0.132823, 0.309424>, <0.488466, -0.132823, 0.283579>, <0.549023, -0.132823, 0.223022>, <0.574868, -0.132823, 0.178256>, 
      <0.430953, -0.120075, 0.287345>, <0.475718, -0.120075, 0.261500>, <0.526944, -0.120075, 0.210274>, <0.552789, -0.120075, 0.165509>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511686, -0.162566, 0.427179>, <0.578166, -0.162566, 0.388796>, <0.654240, -0.162566, 0.312722>, <0.692623, -0.162566, 0.246242>, 
      <0.502642, -0.176685, 0.411515>, <0.569123, -0.176685, 0.373132>, <0.638576, -0.176685, 0.303679>, <0.676959, -0.176685, 0.237198>, 
      <0.484539, -0.168406, 0.380159>, <0.540733, -0.168406, 0.347715>, <0.613159, -0.168406, 0.275289>, <0.645603, -0.168406, 0.219095>, 
      <0.473444, -0.162566, 0.360942>, <0.529639, -0.162566, 0.328498>, <0.593942, -0.162566, 0.264194>, <0.626386, -0.162566, 0.208000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511686, -0.102865, 0.427179>, <0.578166, -0.102865, 0.388796>, <0.654240, -0.102865, 0.312722>, <0.692623, -0.102865, 0.246242>, 
      <0.511686, -0.120775, 0.427179>, <0.578166, -0.120775, 0.388796>, <0.654240, -0.120775, 0.312722>, <0.692623, -0.120775, 0.246242>, 
      <0.518745, -0.151546, 0.439406>, <0.585226, -0.151546, 0.401023>, <0.666467, -0.151546, 0.319782>, <0.704850, -0.151546, 0.253301>, 
      <0.511686, -0.162566, 0.427179>, <0.578166, -0.162566, 0.388796>, <0.654240, -0.162566, 0.312722>, <0.692623, -0.162566, 0.246242>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.552789, -0.120075, 0.165509>, <0.578635, -0.120075, 0.120743>, <0.597384, -0.120075, 0.050768>, <0.597384, -0.120075, -0.000923>, 
      <0.466681, -0.120034, 0.115794>, <0.492526, -0.120034, 0.071028>, <0.497955, -0.120034, 0.050768>, <0.497955, -0.120034, -0.000923>, 
      <0.351870, -0.119979, 0.049508>, <0.351981, -0.119979, 0.049315>, <0.365383, -0.119979, -0.000700>, <0.365383, -0.119979, -0.000923>, 
      <0.265762, -0.119937, -0.000207>, <0.265873, -0.119937, -0.000399>, <0.265954, -0.119937, -0.000700>, <0.265954, -0.119937, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.626386, -0.162566, 0.208000>, <0.658830, -0.162566, 0.151805>, <0.682367, -0.162566, 0.063965>, <0.682367, -0.162566, -0.000923>, 
      <0.602514, -0.155312, 0.194217>, <0.634957, -0.155312, 0.138023>, <0.654801, -0.155312, 0.063965>, <0.654801, -0.155312, -0.000923>, 
      <0.574868, -0.132823, 0.178256>, <0.600714, -0.132823, 0.133491>, <0.622879, -0.132823, 0.050768>, <0.622879, -0.132823, -0.000923>, 
      <0.552789, -0.120075, 0.165509>, <0.578635, -0.120075, 0.120743>, <0.597384, -0.120075, 0.050768>, <0.597384, -0.120075, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.692623, -0.162566, 0.246242>, <0.731005, -0.162566, 0.179761>, <0.758851, -0.162566, 0.075842>, <0.758851, -0.162566, -0.000923>, 
      <0.676959, -0.176685, 0.237198>, <0.715341, -0.176685, 0.170718>, <0.740763, -0.176685, 0.075842>, <0.740763, -0.176685, -0.000923>, 
      <0.645603, -0.168406, 0.219095>, <0.678047, -0.168406, 0.162900>, <0.704556, -0.168406, 0.063965>, <0.704556, -0.168406, -0.000923>, 
      <0.626386, -0.162566, 0.208000>, <0.658830, -0.162566, 0.151805>, <0.682367, -0.162566, 0.063965>, <0.682367, -0.162566, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.692623, -0.102865, 0.246242>, <0.731005, -0.102865, 0.179761>, <0.758851, -0.102865, 0.075842>, <0.758851, -0.102865, -0.000923>, 
      <0.692623, -0.120775, 0.246242>, <0.731005, -0.120775, 0.179761>, <0.758851, -0.120775, 0.075842>, <0.758851, -0.120775, -0.000923>, 
      <0.704850, -0.151546, 0.253301>, <0.743232, -0.151546, 0.186821>, <0.772969, -0.151546, 0.075842>, <0.772969, -0.151546, -0.000923>, 
      <0.692623, -0.162566, 0.246242>, <0.731005, -0.162566, 0.179761>, <0.758851, -0.162566, 0.075842>, <0.758851, -0.162566, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.597384, -0.120075, -0.000923>, <0.597384, -0.120075, -0.052614>, <0.578635, -0.120075, -0.122589>, <0.552789, -0.120075, -0.167355>, 
      <0.497955, -0.120034, -0.000923>, <0.497955, -0.120034, -0.052614>, <0.492526, -0.120034, -0.072874>, <0.466681, -0.120034, -0.117640>, 
      <0.365383, -0.119979, -0.000923>, <0.365383, -0.119979, -0.001146>, <0.351981, -0.119979, -0.051161>, <0.351870, -0.119979, -0.051354>, 
      <0.265954, -0.119937, -0.000923>, <0.265954, -0.119937, -0.001146>, <0.265873, -0.119937, -0.001447>, <0.265762, -0.119937, -0.001639>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.682367, -0.162566, -0.000923>, <0.682367, -0.162566, -0.065811>, <0.658830, -0.162566, -0.153651>, <0.626386, -0.162566, -0.209846>, 
      <0.654801, -0.155312, -0.000923>, <0.654801, -0.155312, -0.065811>, <0.634957, -0.155312, -0.139869>, <0.602514, -0.155312, -0.196063>, 
      <0.622879, -0.132823, -0.000923>, <0.622879, -0.132823, -0.052614>, <0.600714, -0.132823, -0.135337>, <0.574868, -0.132823, -0.180102>, 
      <0.597384, -0.120075, -0.000923>, <0.597384, -0.120075, -0.052614>, <0.578635, -0.120075, -0.122589>, <0.552789, -0.120075, -0.167355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.758851, -0.162566, -0.000923>, <0.758851, -0.162566, -0.077688>, <0.731005, -0.162566, -0.181607>, <0.692623, -0.162566, -0.248088>, 
      <0.740763, -0.176685, -0.000923>, <0.740763, -0.176685, -0.077688>, <0.715341, -0.176685, -0.172564>, <0.676959, -0.176685, -0.239044>, 
      <0.704556, -0.168406, -0.000923>, <0.704556, -0.168406, -0.065811>, <0.678047, -0.168406, -0.164746>, <0.645603, -0.168406, -0.220941>, 
      <0.682367, -0.162566, -0.000923>, <0.682367, -0.162566, -0.065811>, <0.658830, -0.162566, -0.153651>, <0.626386, -0.162566, -0.209846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.758851, -0.102865, -0.000923>, <0.758851, -0.102865, -0.077688>, <0.731005, -0.102865, -0.181607>, <0.692623, -0.102865, -0.248088>, 
      <0.758851, -0.120775, -0.000923>, <0.758851, -0.120775, -0.077688>, <0.731005, -0.120775, -0.181607>, <0.692623, -0.120775, -0.248088>, 
      <0.772969, -0.151546, -0.000923>, <0.772969, -0.151546, -0.077688>, <0.743232, -0.151546, -0.188666>, <0.704850, -0.151546, -0.255147>, 
      <0.758851, -0.162566, -0.000923>, <0.758851, -0.162566, -0.077688>, <0.731005, -0.162566, -0.181607>, <0.692623, -0.162566, -0.248088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.552789, -0.120075, -0.167355>, <0.526944, -0.120075, -0.212120>, <0.475718, -0.120075, -0.263346>, <0.430953, -0.120075, -0.289191>, 
      <0.466681, -0.120034, -0.117640>, <0.440836, -0.120034, -0.162406>, <0.426004, -0.120034, -0.177237>, <0.381238, -0.120034, -0.203083>, 
      <0.351870, -0.119979, -0.051354>, <0.351759, -0.119979, -0.051547>, <0.315145, -0.119979, -0.088161>, <0.314952, -0.119979, -0.088272>, 
      <0.265762, -0.119937, -0.001639>, <0.265650, -0.119937, -0.001832>, <0.265430, -0.119937, -0.002052>, <0.265237, -0.119937, -0.002164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.626386, -0.162566, -0.209846>, <0.593942, -0.162566, -0.266040>, <0.529639, -0.162566, -0.330344>, <0.473444, -0.162566, -0.362788>, 
      <0.602514, -0.155312, -0.196063>, <0.570070, -0.155312, -0.252258>, <0.515856, -0.155312, -0.306472>, <0.459661, -0.155312, -0.338915>, 
      <0.574868, -0.132823, -0.180102>, <0.549023, -0.132823, -0.224868>, <0.488466, -0.132823, -0.285425>, <0.443700, -0.132823, -0.311270>, 
      <0.552789, -0.120075, -0.167355>, <0.526944, -0.120075, -0.212120>, <0.475718, -0.120075, -0.263346>, <0.430953, -0.120075, -0.289191>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.692623, -0.162566, -0.248088>, <0.654240, -0.162566, -0.314568>, <0.578166, -0.162566, -0.390642>, <0.511686, -0.162566, -0.429025>, 
      <0.676959, -0.176685, -0.239044>, <0.638576, -0.176685, -0.305525>, <0.569123, -0.176685, -0.374978>, <0.502642, -0.176685, -0.413361>, 
      <0.645603, -0.168406, -0.220941>, <0.613159, -0.168406, -0.277135>, <0.540733, -0.168406, -0.349561>, <0.484539, -0.168406, -0.382005>, 
      <0.626386, -0.162566, -0.209846>, <0.593942, -0.162566, -0.266040>, <0.529639, -0.162566, -0.330344>, <0.473444, -0.162566, -0.362788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.692623, -0.102865, -0.248088>, <0.654240, -0.102865, -0.314568>, <0.578166, -0.102865, -0.390642>, <0.511686, -0.102865, -0.429025>, 
      <0.692623, -0.120775, -0.248088>, <0.654240, -0.120775, -0.314568>, <0.578166, -0.120775, -0.390642>, <0.511686, -0.120775, -0.429025>, 
      <0.704850, -0.151546, -0.255147>, <0.666467, -0.151546, -0.321628>, <0.585225, -0.151546, -0.402869>, <0.518745, -0.151546, -0.441252>, 
      <0.692623, -0.162566, -0.248088>, <0.654240, -0.162566, -0.314568>, <0.578166, -0.162566, -0.390642>, <0.511686, -0.162566, -0.429025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.430953, -0.120075, -0.289191>, <0.386187, -0.120075, -0.315037>, <0.316212, -0.120075, -0.333786>, <0.264521, -0.120075, -0.333786>, 
      <0.381238, -0.120034, -0.203083>, <0.336473, -0.120034, -0.228928>, <0.316212, -0.120034, -0.234357>, <0.264521, -0.120034, -0.234357>, 
      <0.314952, -0.119979, -0.088272>, <0.314759, -0.119979, -0.088383>, <0.264744, -0.119979, -0.101785>, <0.264521, -0.119979, -0.101785>, 
      <0.265237, -0.119937, -0.002164>, <0.265045, -0.119937, -0.002275>, <0.264744, -0.119937, -0.002356>, <0.264521, -0.119937, -0.002356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.473444, -0.162566, -0.362788>, <0.417250, -0.162566, -0.395232>, <0.329409, -0.162566, -0.418768>, <0.264521, -0.162566, -0.418768>, 
      <0.459661, -0.155312, -0.338915>, <0.403467, -0.155312, -0.371360>, <0.329409, -0.155312, -0.391203>, <0.264521, -0.155312, -0.391203>, 
      <0.443700, -0.132823, -0.311270>, <0.398935, -0.132823, -0.337116>, <0.316212, -0.132823, -0.359281>, <0.264521, -0.132823, -0.359281>, 
      <0.430953, -0.120075, -0.289191>, <0.386187, -0.120075, -0.315037>, <0.316212, -0.120075, -0.333786>, <0.264521, -0.120075, -0.333786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511686, -0.162566, -0.429025>, <0.445205, -0.162566, -0.467407>, <0.341286, -0.162566, -0.495253>, <0.264521, -0.162566, -0.495253>, 
      <0.502642, -0.176685, -0.413361>, <0.436162, -0.176685, -0.451743>, <0.341286, -0.176685, -0.477165>, <0.264521, -0.176685, -0.477165>, 
      <0.484539, -0.168406, -0.382005>, <0.428344, -0.168406, -0.414449>, <0.329409, -0.168406, -0.440958>, <0.264521, -0.168406, -0.440958>, 
      <0.473444, -0.162566, -0.362788>, <0.417250, -0.162566, -0.395232>, <0.329409, -0.162566, -0.418768>, <0.264521, -0.162566, -0.418768>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511686, -0.102865, -0.429025>, <0.445205, -0.102865, -0.467407>, <0.341286, -0.102865, -0.495253>, <0.264521, -0.102865, -0.495253>, 
      <0.511686, -0.120775, -0.429025>, <0.445205, -0.120775, -0.467407>, <0.341286, -0.120775, -0.495253>, <0.264521, -0.120775, -0.495253>, 
      <0.518745, -0.151546, -0.441252>, <0.452265, -0.151546, -0.479635>, <0.341286, -0.151546, -0.509371>, <0.264521, -0.151546, -0.509371>, 
      <0.511686, -0.162566, -0.429025>, <0.445205, -0.162566, -0.467407>, <0.341286, -0.162566, -0.495253>, <0.264521, -0.162566, -0.495253>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, -0.120075, -0.333786>, <0.212830, -0.120075, -0.333786>, <0.142855, -0.120075, -0.315037>, <0.098089, -0.120075, -0.289191>, 
      <0.264521, -0.120034, -0.234357>, <0.212830, -0.120034, -0.234357>, <0.192570, -0.120034, -0.228928>, <0.147804, -0.120034, -0.203083>, 
      <0.264521, -0.119979, -0.101785>, <0.264299, -0.119979, -0.101785>, <0.214283, -0.119979, -0.088383>, <0.214090, -0.119979, -0.088272>, 
      <0.264521, -0.119937, -0.002356>, <0.264299, -0.119937, -0.002356>, <0.263998, -0.119937, -0.002275>, <0.263805, -0.119937, -0.002164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, -0.162566, -0.418768>, <0.199633, -0.162566, -0.418768>, <0.111793, -0.162566, -0.395232>, <0.055598, -0.162566, -0.362788>, 
      <0.264521, -0.155312, -0.391203>, <0.199633, -0.155312, -0.391203>, <0.125576, -0.155312, -0.371360>, <0.069381, -0.155312, -0.338915>, 
      <0.264521, -0.132823, -0.359281>, <0.212830, -0.132823, -0.359281>, <0.130108, -0.132823, -0.337116>, <0.085342, -0.132823, -0.311270>, 
      <0.264521, -0.120075, -0.333786>, <0.212830, -0.120075, -0.333786>, <0.142855, -0.120075, -0.315037>, <0.098089, -0.120075, -0.289191>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, -0.162566, -0.495253>, <0.187756, -0.162566, -0.495253>, <0.083837, -0.162566, -0.467408>, <0.017356, -0.162566, -0.429025>, 
      <0.264521, -0.176685, -0.477165>, <0.187756, -0.176685, -0.477165>, <0.092881, -0.176685, -0.451744>, <0.026400, -0.176685, -0.413361>, 
      <0.264521, -0.168406, -0.440958>, <0.199633, -0.168406, -0.440958>, <0.100698, -0.168406, -0.414449>, <0.044503, -0.168406, -0.382005>, 
      <0.264521, -0.162566, -0.418768>, <0.199633, -0.162566, -0.418768>, <0.111793, -0.162566, -0.395232>, <0.055598, -0.162566, -0.362788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, -0.102865, -0.495253>, <0.187756, -0.102865, -0.495253>, <0.083837, -0.102865, -0.467408>, <0.017356, -0.102865, -0.429025>, 
      <0.264521, -0.120775, -0.495253>, <0.187756, -0.120775, -0.495253>, <0.083837, -0.120775, -0.467408>, <0.017356, -0.120775, -0.429025>, 
      <0.264521, -0.151546, -0.509371>, <0.187756, -0.151546, -0.509371>, <0.076778, -0.151546, -0.479635>, <0.010297, -0.151546, -0.441252>, 
      <0.264521, -0.162566, -0.495253>, <0.187756, -0.162566, -0.495253>, <0.083837, -0.162566, -0.467408>, <0.017356, -0.162566, -0.429025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.098089, -0.120075, -0.289191>, <0.053324, -0.120075, -0.263346>, <0.002099, -0.120075, -0.212120>, <-0.023747, -0.120075, -0.167355>, 
      <0.147804, -0.120034, -0.203083>, <0.103039, -0.120034, -0.177237>, <0.088207, -0.120034, -0.162406>, <0.062361, -0.120034, -0.117640>, 
      <0.214090, -0.119979, -0.088272>, <0.213898, -0.119979, -0.088161>, <0.177284, -0.119979, -0.051547>, <0.177172, -0.119979, -0.051354>, 
      <0.263805, -0.119937, -0.002164>, <0.263612, -0.119937, -0.002052>, <0.263392, -0.119937, -0.001832>, <0.263281, -0.119937, -0.001639>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.055598, -0.162566, -0.362788>, <-0.000596, -0.162566, -0.330344>, <-0.064900, -0.162566, -0.266040>, <-0.097344, -0.162566, -0.209846>, 
      <0.069381, -0.155312, -0.338915>, <0.013187, -0.155312, -0.306472>, <-0.041028, -0.155312, -0.252258>, <-0.073471, -0.155312, -0.196063>, 
      <0.085342, -0.132823, -0.311270>, <0.040577, -0.132823, -0.285425>, <-0.019981, -0.132823, -0.224868>, <-0.045826, -0.132823, -0.180102>, 
      <0.098089, -0.120075, -0.289191>, <0.053324, -0.120075, -0.263346>, <0.002099, -0.120075, -0.212120>, <-0.023747, -0.120075, -0.167355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.017356, -0.162566, -0.429025>, <-0.049124, -0.162566, -0.390642>, <-0.125198, -0.162566, -0.314568>, <-0.163581, -0.162566, -0.248088>, 
      <0.026400, -0.176685, -0.413361>, <-0.040080, -0.176685, -0.374978>, <-0.109534, -0.176685, -0.305525>, <-0.147917, -0.176685, -0.239044>, 
      <0.044503, -0.168406, -0.382005>, <-0.011691, -0.168406, -0.349561>, <-0.084117, -0.168406, -0.277135>, <-0.116561, -0.168406, -0.220941>, 
      <0.055598, -0.162566, -0.362788>, <-0.000596, -0.162566, -0.330344>, <-0.064900, -0.162566, -0.266040>, <-0.097344, -0.162566, -0.209846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.017356, -0.102865, -0.429025>, <-0.049124, -0.102865, -0.390642>, <-0.125198, -0.102865, -0.314568>, <-0.163581, -0.102865, -0.248088>, 
      <0.017356, -0.120775, -0.429025>, <-0.049124, -0.120775, -0.390642>, <-0.125198, -0.120775, -0.314568>, <-0.163581, -0.120775, -0.248088>, 
      <0.010297, -0.151546, -0.441252>, <-0.056183, -0.151546, -0.402869>, <-0.137425, -0.151546, -0.321628>, <-0.175808, -0.151546, -0.255147>, 
      <0.017356, -0.162566, -0.429025>, <-0.049124, -0.162566, -0.390642>, <-0.125198, -0.162566, -0.314568>, <-0.163581, -0.162566, -0.248088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.023747, -0.120075, -0.167355>, <-0.049592, -0.120075, -0.122589>, <-0.068342, -0.120075, -0.052614>, <-0.068342, -0.120075, -0.000923>, 
      <0.062361, -0.120034, -0.117640>, <0.036516, -0.120034, -0.072874>, <0.031087, -0.120034, -0.052614>, <0.031087, -0.120034, -0.000923>, 
      <0.177172, -0.119979, -0.051354>, <0.177061, -0.119979, -0.051161>, <0.163659, -0.119979, -0.001146>, <0.163659, -0.119979, -0.000923>, 
      <0.263281, -0.119937, -0.001639>, <0.263169, -0.119937, -0.001447>, <0.263089, -0.119937, -0.001146>, <0.263089, -0.119937, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.097344, -0.162566, -0.209846>, <-0.129788, -0.162566, -0.153651>, <-0.153324, -0.162566, -0.065811>, <-0.153324, -0.162566, -0.000923>, 
      <-0.073471, -0.155312, -0.196063>, <-0.105915, -0.155312, -0.139869>, <-0.125759, -0.155312, -0.065811>, <-0.125759, -0.155312, -0.000923>, 
      <-0.045826, -0.132823, -0.180102>, <-0.071671, -0.132823, -0.135336>, <-0.093837, -0.132823, -0.052614>, <-0.093837, -0.132823, -0.000923>, 
      <-0.023747, -0.120075, -0.167355>, <-0.049592, -0.120075, -0.122589>, <-0.068342, -0.120075, -0.052614>, <-0.068342, -0.120075, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.163581, -0.162566, -0.248088>, <-0.201963, -0.162566, -0.181607>, <-0.229808, -0.162566, -0.077688>, <-0.229808, -0.162566, -0.000923>, 
      <-0.147917, -0.176685, -0.239044>, <-0.186299, -0.176685, -0.172564>, <-0.211721, -0.176685, -0.077688>, <-0.211721, -0.176685, -0.000923>, 
      <-0.116561, -0.168406, -0.220941>, <-0.149004, -0.168406, -0.164746>, <-0.175514, -0.168406, -0.065811>, <-0.175514, -0.168406, -0.000923>, 
      <-0.097344, -0.162566, -0.209846>, <-0.129788, -0.162566, -0.153651>, <-0.153324, -0.162566, -0.065811>, <-0.153324, -0.162566, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.163581, -0.102865, -0.248088>, <-0.201963, -0.102865, -0.181607>, <-0.229808, -0.102865, -0.077688>, <-0.229808, -0.102865, -0.000923>, 
      <-0.163581, -0.120775, -0.248088>, <-0.201963, -0.120775, -0.181607>, <-0.229808, -0.120775, -0.077688>, <-0.229808, -0.120775, -0.000923>, 
      <-0.175808, -0.151546, -0.255147>, <-0.214190, -0.151546, -0.188666>, <-0.243927, -0.151546, -0.077688>, <-0.243927, -0.151546, -0.000923>, 
      <-0.163581, -0.162566, -0.248088>, <-0.201963, -0.162566, -0.181607>, <-0.229808, -0.162566, -0.077688>, <-0.229808, -0.162566, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.068342, -0.120075, -0.000923>, <-0.068342, -0.120075, 0.050768>, <-0.049592, -0.120075, 0.120743>, <-0.023747, -0.120075, 0.165509>, 
      <0.031087, -0.120034, -0.000923>, <0.031087, -0.120034, 0.050768>, <0.036516, -0.120034, 0.071028>, <0.062361, -0.120034, 0.115794>, 
      <0.163659, -0.119979, -0.000923>, <0.163659, -0.119979, -0.000700>, <0.177061, -0.119979, 0.049315>, <0.177172, -0.119979, 0.049508>, 
      <0.263089, -0.119937, -0.000923>, <0.263089, -0.119937, -0.000700>, <0.263169, -0.119937, -0.000399>, <0.263281, -0.119937, -0.000207>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.153324, -0.162566, -0.000923>, <-0.153324, -0.162566, 0.063965>, <-0.129788, -0.162566, 0.151805>, <-0.097344, -0.162566, 0.208000>, 
      <-0.125759, -0.155312, -0.000923>, <-0.125759, -0.155312, 0.063965>, <-0.105915, -0.155312, 0.138022>, <-0.073471, -0.155312, 0.194217>, 
      <-0.093837, -0.132823, -0.000923>, <-0.093837, -0.132823, 0.050768>, <-0.071671, -0.132823, 0.133490>, <-0.045826, -0.132823, 0.178256>, 
      <-0.068342, -0.120075, -0.000923>, <-0.068342, -0.120075, 0.050768>, <-0.049592, -0.120075, 0.120743>, <-0.023747, -0.120075, 0.165509>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.229808, -0.162566, -0.000923>, <-0.229808, -0.162566, 0.075842>, <-0.201963, -0.162566, 0.179761>, <-0.163581, -0.162566, 0.246242>, 
      <-0.211721, -0.176685, -0.000923>, <-0.211721, -0.176685, 0.075842>, <-0.186299, -0.176685, 0.170717>, <-0.147917, -0.176685, 0.237198>, 
      <-0.175514, -0.168406, -0.000923>, <-0.175514, -0.168406, 0.063965>, <-0.149004, -0.168406, 0.162900>, <-0.116561, -0.168406, 0.219094>, 
      <-0.153324, -0.162566, -0.000923>, <-0.153324, -0.162566, 0.063965>, <-0.129788, -0.162566, 0.151805>, <-0.097344, -0.162566, 0.208000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.229808, -0.102865, -0.000923>, <-0.229808, -0.102865, 0.075842>, <-0.201963, -0.102865, 0.179761>, <-0.163581, -0.102865, 0.246242>, 
      <-0.229808, -0.120775, -0.000923>, <-0.229808, -0.120775, 0.075842>, <-0.201963, -0.120775, 0.179761>, <-0.163581, -0.120775, 0.246242>, 
      <-0.243927, -0.151546, -0.000923>, <-0.243927, -0.151546, 0.075842>, <-0.214190, -0.151546, 0.186820>, <-0.175808, -0.151546, 0.253301>, 
      <-0.229808, -0.162566, -0.000923>, <-0.229808, -0.162566, 0.075842>, <-0.201963, -0.162566, 0.179761>, <-0.163581, -0.162566, 0.246242>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.023747, 0.120081, 0.165509>, <0.002099, 0.120081, 0.210274>, <0.053324, 0.120081, 0.261500>, <0.098089, 0.120081, 0.287345>, 
      <0.062361, 0.120039, 0.115794>, <0.088207, 0.120039, 0.160559>, <0.103039, 0.120039, 0.175391>, <0.147804, 0.120039, 0.201237>, 
      <0.177172, 0.119984, 0.049508>, <0.177284, 0.119984, 0.049701>, <0.213898, 0.119984, 0.086315>, <0.214090, 0.119984, 0.086426>, 
      <0.263281, 0.119943, -0.000207>, <0.263392, 0.119943, -0.000014>, <0.263612, 0.119943, 0.000206>, <0.263805, 0.119943, 0.000318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.097344, 0.162572, 0.208000>, <-0.064900, 0.162572, 0.264194>, <-0.000596, 0.162572, 0.328498>, <0.055598, 0.162572, 0.360942>, 
      <-0.073471, 0.155318, 0.194217>, <-0.041027, 0.155318, 0.250411>, <0.013187, 0.155318, 0.304626>, <0.069381, 0.155318, 0.337070>, 
      <-0.045826, 0.132828, 0.178256>, <-0.019981, 0.132828, 0.223021>, <0.040577, 0.132828, 0.283579>, <0.085342, 0.132828, 0.309424>, 
      <-0.023747, 0.120081, 0.165509>, <0.002099, 0.120081, 0.210274>, <0.053324, 0.120081, 0.261500>, <0.098089, 0.120081, 0.287345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.163581, 0.162572, 0.246242>, <-0.125198, 0.162572, 0.312722>, <-0.049124, 0.162572, 0.388796>, <0.017356, 0.162572, 0.427179>, 
      <-0.147917, 0.176690, 0.237198>, <-0.109534, 0.176690, 0.303679>, <-0.040080, 0.176690, 0.373132>, <0.026400, 0.176690, 0.411515>, 
      <-0.116561, 0.168411, 0.219094>, <-0.084117, 0.168411, 0.275289>, <-0.011691, 0.168411, 0.347715>, <0.044503, 0.168411, 0.380159>, 
      <-0.097344, 0.162572, 0.208000>, <-0.064900, 0.162572, 0.264194>, <-0.000596, 0.162572, 0.328498>, <0.055598, 0.162572, 0.360942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.163581, 0.102871, 0.246242>, <-0.125198, 0.102871, 0.312722>, <-0.049124, 0.102871, 0.388796>, <0.017356, 0.102871, 0.427179>, 
      <-0.163581, 0.120781, 0.246242>, <-0.125198, 0.120781, 0.312722>, <-0.049124, 0.120781, 0.388796>, <0.017356, 0.120781, 0.427179>, 
      <-0.175808, 0.151551, 0.253301>, <-0.137425, 0.151551, 0.319782>, <-0.056183, 0.151551, 0.401023>, <0.010297, 0.151551, 0.439406>, 
      <-0.163581, 0.162572, 0.246242>, <-0.125198, 0.162572, 0.312722>, <-0.049124, 0.162572, 0.388796>, <0.017356, 0.162572, 0.427179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.098089, 0.120081, 0.287345>, <0.142855, 0.120081, 0.313190>, <0.212830, 0.120081, 0.331940>, <0.264521, 0.120081, 0.331940>, 
      <0.147804, 0.120039, 0.201237>, <0.192570, 0.120039, 0.227082>, <0.212830, 0.120039, 0.232511>, <0.264521, 0.120039, 0.232511>, 
      <0.214090, 0.119984, 0.086426>, <0.214283, 0.119984, 0.086537>, <0.264299, 0.119984, 0.099939>, <0.264521, 0.119984, 0.099939>, 
      <0.263805, 0.119943, 0.000318>, <0.263998, 0.119943, 0.000429>, <0.264299, 0.119943, 0.000510>, <0.264521, 0.119943, 0.000510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.055598, 0.162572, 0.360942>, <0.111793, 0.162572, 0.393386>, <0.199633, 0.162572, 0.416923>, <0.264521, 0.162572, 0.416923>, 
      <0.069381, 0.155318, 0.337070>, <0.125576, 0.155318, 0.369513>, <0.199633, 0.155318, 0.389357>, <0.264521, 0.155318, 0.389357>, 
      <0.085342, 0.132828, 0.309424>, <0.130108, 0.132828, 0.335270>, <0.212830, 0.132828, 0.357435>, <0.264521, 0.132828, 0.357435>, 
      <0.098089, 0.120081, 0.287345>, <0.142855, 0.120081, 0.313190>, <0.212830, 0.120081, 0.331940>, <0.264521, 0.120081, 0.331940>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.017356, 0.162572, 0.427179>, <0.083837, 0.162572, 0.465561>, <0.187756, 0.162572, 0.493407>, <0.264521, 0.162572, 0.493407>, 
      <0.026400, 0.176690, 0.411515>, <0.092881, 0.176690, 0.449897>, <0.187756, 0.176690, 0.475319>, <0.264521, 0.176690, 0.475319>, 
      <0.044503, 0.168411, 0.380159>, <0.100698, 0.168411, 0.412603>, <0.199633, 0.168411, 0.439112>, <0.264521, 0.168411, 0.439112>, 
      <0.055598, 0.162572, 0.360942>, <0.111793, 0.162572, 0.393386>, <0.199633, 0.162572, 0.416923>, <0.264521, 0.162572, 0.416923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.017356, 0.102871, 0.427179>, <0.083837, 0.102871, 0.465561>, <0.187756, 0.102871, 0.493407>, <0.264521, 0.102871, 0.493407>, 
      <0.017356, 0.120781, 0.427179>, <0.083837, 0.120781, 0.465561>, <0.187756, 0.120781, 0.493407>, <0.264521, 0.120781, 0.493407>, 
      <0.010297, 0.151551, 0.439406>, <0.076778, 0.151551, 0.477788>, <0.187756, 0.151551, 0.507525>, <0.264521, 0.151551, 0.507525>, 
      <0.017356, 0.162572, 0.427179>, <0.083837, 0.162572, 0.465561>, <0.187756, 0.162572, 0.493407>, <0.264521, 0.162572, 0.493407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, 0.120081, 0.331940>, <0.316212, 0.120081, 0.331940>, <0.386187, 0.120081, 0.313190>, <0.430953, 0.120081, 0.287345>, 
      <0.264521, 0.120039, 0.232511>, <0.316212, 0.120039, 0.232511>, <0.336473, 0.120039, 0.227082>, <0.381238, 0.120039, 0.201237>, 
      <0.264521, 0.119984, 0.099939>, <0.264744, 0.119984, 0.099939>, <0.314759, 0.119984, 0.086537>, <0.314952, 0.119984, 0.086426>, 
      <0.264521, 0.119943, 0.000510>, <0.264744, 0.119943, 0.000510>, <0.265045, 0.119943, 0.000429>, <0.265237, 0.119943, 0.000318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, 0.162572, 0.416923>, <0.329409, 0.162572, 0.416923>, <0.417250, 0.162572, 0.393386>, <0.473444, 0.162572, 0.360942>, 
      <0.264521, 0.155318, 0.389357>, <0.329409, 0.155318, 0.389357>, <0.403467, 0.155318, 0.369513>, <0.459661, 0.155318, 0.337070>, 
      <0.264521, 0.132828, 0.357435>, <0.316212, 0.132828, 0.357435>, <0.398935, 0.132828, 0.335270>, <0.443700, 0.132828, 0.309424>, 
      <0.264521, 0.120081, 0.331940>, <0.316212, 0.120081, 0.331940>, <0.386187, 0.120081, 0.313190>, <0.430953, 0.120081, 0.287345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, 0.162572, 0.493407>, <0.341286, 0.162572, 0.493407>, <0.445205, 0.162572, 0.465561>, <0.511686, 0.162572, 0.427179>, 
      <0.264521, 0.176690, 0.475319>, <0.341286, 0.176690, 0.475319>, <0.436162, 0.176690, 0.449897>, <0.502642, 0.176690, 0.411515>, 
      <0.264521, 0.168411, 0.439112>, <0.329409, 0.168411, 0.439112>, <0.428344, 0.168411, 0.412603>, <0.484539, 0.168411, 0.380159>, 
      <0.264521, 0.162572, 0.416923>, <0.329409, 0.162572, 0.416923>, <0.417250, 0.162572, 0.393386>, <0.473444, 0.162572, 0.360942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, 0.102871, 0.493407>, <0.341286, 0.102871, 0.493407>, <0.445205, 0.102871, 0.465561>, <0.511686, 0.102871, 0.427179>, 
      <0.264521, 0.120781, 0.493407>, <0.341286, 0.120781, 0.493407>, <0.445205, 0.120781, 0.465561>, <0.511686, 0.120781, 0.427179>, 
      <0.264521, 0.151551, 0.507525>, <0.341286, 0.151551, 0.507525>, <0.452265, 0.151551, 0.477788>, <0.518745, 0.151551, 0.439406>, 
      <0.264521, 0.162572, 0.493407>, <0.341286, 0.162572, 0.493407>, <0.445205, 0.162572, 0.465561>, <0.511686, 0.162572, 0.427179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.430953, 0.120081, 0.287345>, <0.475718, 0.120081, 0.261500>, <0.526944, 0.120081, 0.210274>, <0.552789, 0.120081, 0.165509>, 
      <0.381238, 0.120039, 0.201237>, <0.426004, 0.120039, 0.175391>, <0.440836, 0.120039, 0.160560>, <0.466681, 0.120039, 0.115794>, 
      <0.314952, 0.119984, 0.086426>, <0.315145, 0.119984, 0.086315>, <0.351759, 0.119984, 0.049701>, <0.351870, 0.119984, 0.049508>, 
      <0.265237, 0.119943, 0.000318>, <0.265430, 0.119943, 0.000206>, <0.265650, 0.119943, -0.000014>, <0.265762, 0.119943, -0.000207>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.473444, 0.162572, 0.360942>, <0.529639, 0.162572, 0.328498>, <0.593942, 0.162572, 0.264194>, <0.626386, 0.162572, 0.208000>, 
      <0.459661, 0.155318, 0.337070>, <0.515856, 0.155318, 0.304626>, <0.570070, 0.155318, 0.250412>, <0.602514, 0.155318, 0.194217>, 
      <0.443700, 0.132828, 0.309424>, <0.488466, 0.132828, 0.283579>, <0.549023, 0.132828, 0.223022>, <0.574868, 0.132828, 0.178256>, 
      <0.430953, 0.120081, 0.287345>, <0.475718, 0.120081, 0.261500>, <0.526944, 0.120081, 0.210274>, <0.552789, 0.120081, 0.165509>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511686, 0.162572, 0.427179>, <0.578166, 0.162572, 0.388796>, <0.654240, 0.162572, 0.312722>, <0.692623, 0.162572, 0.246242>, 
      <0.502642, 0.176690, 0.411515>, <0.569123, 0.176690, 0.373132>, <0.638576, 0.176690, 0.303679>, <0.676959, 0.176690, 0.237198>, 
      <0.484539, 0.168411, 0.380159>, <0.540733, 0.168411, 0.347715>, <0.613159, 0.168411, 0.275289>, <0.645603, 0.168411, 0.219095>, 
      <0.473444, 0.162572, 0.360942>, <0.529639, 0.162572, 0.328498>, <0.593942, 0.162572, 0.264194>, <0.626386, 0.162572, 0.208000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511686, 0.102871, 0.427179>, <0.578166, 0.102871, 0.388796>, <0.654240, 0.102871, 0.312722>, <0.692623, 0.102871, 0.246242>, 
      <0.511686, 0.120781, 0.427179>, <0.578166, 0.120781, 0.388796>, <0.654240, 0.120781, 0.312722>, <0.692623, 0.120781, 0.246242>, 
      <0.518745, 0.151551, 0.439406>, <0.585226, 0.151551, 0.401023>, <0.666467, 0.151551, 0.319782>, <0.704850, 0.151551, 0.253301>, 
      <0.511686, 0.162572, 0.427179>, <0.578166, 0.162572, 0.388796>, <0.654240, 0.162572, 0.312722>, <0.692623, 0.162572, 0.246242>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.552789, 0.120081, 0.165509>, <0.578635, 0.120081, 0.120743>, <0.597384, 0.120081, 0.050768>, <0.597384, 0.120081, -0.000923>, 
      <0.466681, 0.120039, 0.115794>, <0.492526, 0.120039, 0.071028>, <0.497955, 0.120039, 0.050768>, <0.497955, 0.120039, -0.000923>, 
      <0.351870, 0.119984, 0.049508>, <0.351981, 0.119984, 0.049315>, <0.365383, 0.119984, -0.000700>, <0.365383, 0.119984, -0.000923>, 
      <0.265762, 0.119943, -0.000207>, <0.265873, 0.119943, -0.000399>, <0.265954, 0.119943, -0.000700>, <0.265954, 0.119943, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.626386, 0.162572, 0.208000>, <0.658830, 0.162572, 0.151805>, <0.682367, 0.162572, 0.063965>, <0.682367, 0.162572, -0.000923>, 
      <0.602514, 0.155318, 0.194217>, <0.634957, 0.155318, 0.138022>, <0.654801, 0.155318, 0.063965>, <0.654801, 0.155318, -0.000923>, 
      <0.574868, 0.132828, 0.178256>, <0.600714, 0.132828, 0.133491>, <0.622879, 0.132828, 0.050768>, <0.622879, 0.132828, -0.000923>, 
      <0.552789, 0.120081, 0.165509>, <0.578635, 0.120081, 0.120743>, <0.597384, 0.120081, 0.050768>, <0.597384, 0.120081, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.692623, 0.162572, 0.246242>, <0.731005, 0.162572, 0.179761>, <0.758851, 0.162572, 0.075842>, <0.758851, 0.162572, -0.000923>, 
      <0.676959, 0.176690, 0.237198>, <0.715341, 0.176690, 0.170718>, <0.740763, 0.176690, 0.075842>, <0.740763, 0.176690, -0.000923>, 
      <0.645603, 0.168411, 0.219095>, <0.678047, 0.168411, 0.162900>, <0.704556, 0.168411, 0.063965>, <0.704556, 0.168411, -0.000923>, 
      <0.626386, 0.162572, 0.208000>, <0.658830, 0.162572, 0.151805>, <0.682367, 0.162572, 0.063965>, <0.682367, 0.162572, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.692623, 0.102871, 0.246242>, <0.731005, 0.102871, 0.179761>, <0.758851, 0.102871, 0.075842>, <0.758851, 0.102871, -0.000923>, 
      <0.692623, 0.120781, 0.246242>, <0.731005, 0.120781, 0.179761>, <0.758851, 0.120781, 0.075842>, <0.758851, 0.120781, -0.000923>, 
      <0.704850, 0.151551, 0.253301>, <0.743232, 0.151551, 0.186821>, <0.772969, 0.151551, 0.075842>, <0.772969, 0.151551, -0.000923>, 
      <0.692623, 0.162572, 0.246242>, <0.731005, 0.162572, 0.179761>, <0.758851, 0.162572, 0.075842>, <0.758851, 0.162572, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.597384, 0.120081, -0.000923>, <0.597384, 0.120081, -0.052614>, <0.578635, 0.120081, -0.122589>, <0.552789, 0.120081, -0.167355>, 
      <0.497955, 0.120039, -0.000923>, <0.497955, 0.120039, -0.052614>, <0.492526, 0.120039, -0.072874>, <0.466681, 0.120039, -0.117640>, 
      <0.365383, 0.119984, -0.000923>, <0.365383, 0.119984, -0.001146>, <0.351981, 0.119984, -0.051161>, <0.351870, 0.119984, -0.051354>, 
      <0.265954, 0.119943, -0.000923>, <0.265954, 0.119943, -0.001146>, <0.265873, 0.119943, -0.001447>, <0.265762, 0.119943, -0.001639>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.682367, 0.162572, -0.000923>, <0.682367, 0.162572, -0.065811>, <0.658830, 0.162572, -0.153651>, <0.626386, 0.162572, -0.209846>, 
      <0.654801, 0.155318, -0.000923>, <0.654801, 0.155318, -0.065811>, <0.634957, 0.155318, -0.139869>, <0.602514, 0.155318, -0.196063>, 
      <0.622879, 0.132828, -0.000923>, <0.622879, 0.132828, -0.052614>, <0.600714, 0.132828, -0.135337>, <0.574868, 0.132828, -0.180102>, 
      <0.597384, 0.120081, -0.000923>, <0.597384, 0.120081, -0.052614>, <0.578635, 0.120081, -0.122589>, <0.552789, 0.120081, -0.167355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.758851, 0.162572, -0.000923>, <0.758851, 0.162572, -0.077688>, <0.731005, 0.162572, -0.181607>, <0.692623, 0.162572, -0.248088>, 
      <0.740763, 0.176690, -0.000923>, <0.740763, 0.176690, -0.077688>, <0.715341, 0.176690, -0.172564>, <0.676959, 0.176690, -0.239044>, 
      <0.704556, 0.168411, -0.000923>, <0.704556, 0.168411, -0.065811>, <0.678047, 0.168411, -0.164746>, <0.645603, 0.168411, -0.220941>, 
      <0.682367, 0.162572, -0.000923>, <0.682367, 0.162572, -0.065811>, <0.658830, 0.162572, -0.153651>, <0.626386, 0.162572, -0.209846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.758851, 0.102871, -0.000923>, <0.758851, 0.102871, -0.077688>, <0.731005, 0.102871, -0.181607>, <0.692623, 0.102871, -0.248088>, 
      <0.758851, 0.120781, -0.000923>, <0.758851, 0.120781, -0.077688>, <0.731005, 0.120781, -0.181607>, <0.692623, 0.120781, -0.248088>, 
      <0.772969, 0.151551, -0.000923>, <0.772969, 0.151551, -0.077688>, <0.743232, 0.151551, -0.188666>, <0.704850, 0.151551, -0.255147>, 
      <0.758851, 0.162572, -0.000923>, <0.758851, 0.162572, -0.077688>, <0.731005, 0.162572, -0.181607>, <0.692623, 0.162572, -0.248088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.552789, 0.120081, -0.167355>, <0.526944, 0.120081, -0.212120>, <0.475718, 0.120081, -0.263346>, <0.430953, 0.120081, -0.289191>, 
      <0.466681, 0.120039, -0.117640>, <0.440836, 0.120039, -0.162406>, <0.426004, 0.120039, -0.177237>, <0.381238, 0.120039, -0.203083>, 
      <0.351870, 0.119984, -0.051354>, <0.351759, 0.119984, -0.051547>, <0.315145, 0.119984, -0.088161>, <0.314952, 0.119984, -0.088272>, 
      <0.265762, 0.119943, -0.001639>, <0.265650, 0.119943, -0.001832>, <0.265430, 0.119943, -0.002052>, <0.265237, 0.119943, -0.002164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.626386, 0.162572, -0.209846>, <0.593942, 0.162572, -0.266040>, <0.529639, 0.162572, -0.330344>, <0.473444, 0.162572, -0.362788>, 
      <0.602514, 0.155318, -0.196063>, <0.570070, 0.155318, -0.252258>, <0.515856, 0.155318, -0.306472>, <0.459661, 0.155318, -0.338915>, 
      <0.574868, 0.132828, -0.180102>, <0.549023, 0.132828, -0.224868>, <0.488466, 0.132828, -0.285425>, <0.443700, 0.132828, -0.311270>, 
      <0.552789, 0.120081, -0.167355>, <0.526944, 0.120081, -0.212120>, <0.475718, 0.120081, -0.263346>, <0.430953, 0.120081, -0.289191>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.692623, 0.162572, -0.248088>, <0.654240, 0.162572, -0.314568>, <0.578166, 0.162572, -0.390642>, <0.511686, 0.162572, -0.429025>, 
      <0.676959, 0.176690, -0.239044>, <0.638576, 0.176690, -0.305525>, <0.569123, 0.176690, -0.374978>, <0.502642, 0.176690, -0.413361>, 
      <0.645603, 0.168411, -0.220941>, <0.613159, 0.168411, -0.277135>, <0.540733, 0.168411, -0.349561>, <0.484539, 0.168411, -0.382005>, 
      <0.626386, 0.162572, -0.209846>, <0.593942, 0.162572, -0.266040>, <0.529639, 0.162572, -0.330344>, <0.473444, 0.162572, -0.362788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.692623, 0.102871, -0.248088>, <0.654240, 0.102871, -0.314568>, <0.578166, 0.102871, -0.390642>, <0.511686, 0.102871, -0.429025>, 
      <0.692623, 0.120781, -0.248088>, <0.654240, 0.120781, -0.314568>, <0.578166, 0.120781, -0.390642>, <0.511686, 0.120781, -0.429025>, 
      <0.704850, 0.151551, -0.255147>, <0.666467, 0.151551, -0.321628>, <0.585226, 0.151551, -0.402869>, <0.518745, 0.151551, -0.441252>, 
      <0.692623, 0.162572, -0.248088>, <0.654240, 0.162572, -0.314568>, <0.578166, 0.162572, -0.390642>, <0.511686, 0.162572, -0.429025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.430953, 0.120081, -0.289191>, <0.386187, 0.120081, -0.315037>, <0.316212, 0.120081, -0.333786>, <0.264521, 0.120081, -0.333786>, 
      <0.381238, 0.120039, -0.203083>, <0.336473, 0.120039, -0.228928>, <0.316212, 0.120039, -0.234357>, <0.264521, 0.120039, -0.234357>, 
      <0.314952, 0.119984, -0.088272>, <0.314759, 0.119984, -0.088383>, <0.264744, 0.119984, -0.101785>, <0.264521, 0.119984, -0.101785>, 
      <0.265237, 0.119943, -0.002164>, <0.265045, 0.119943, -0.002275>, <0.264744, 0.119943, -0.002356>, <0.264521, 0.119943, -0.002356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.473444, 0.162572, -0.362788>, <0.417250, 0.162572, -0.395232>, <0.329409, 0.162572, -0.418768>, <0.264521, 0.162572, -0.418768>, 
      <0.459661, 0.155318, -0.338915>, <0.403467, 0.155318, -0.371359>, <0.329409, 0.155318, -0.391203>, <0.264521, 0.155318, -0.391203>, 
      <0.443700, 0.132828, -0.311270>, <0.398935, 0.132828, -0.337116>, <0.316212, 0.132828, -0.359281>, <0.264521, 0.132828, -0.359281>, 
      <0.430953, 0.120081, -0.289191>, <0.386187, 0.120081, -0.315037>, <0.316212, 0.120081, -0.333786>, <0.264521, 0.120081, -0.333786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511686, 0.162572, -0.429025>, <0.445205, 0.162572, -0.467407>, <0.341286, 0.162572, -0.495253>, <0.264521, 0.162572, -0.495253>, 
      <0.502642, 0.176690, -0.413361>, <0.436162, 0.176690, -0.451744>, <0.341286, 0.176690, -0.477165>, <0.264521, 0.176690, -0.477165>, 
      <0.484539, 0.168411, -0.382005>, <0.428344, 0.168411, -0.414449>, <0.329409, 0.168411, -0.440958>, <0.264521, 0.168411, -0.440958>, 
      <0.473444, 0.162572, -0.362788>, <0.417250, 0.162572, -0.395232>, <0.329409, 0.162572, -0.418768>, <0.264521, 0.162572, -0.418768>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511686, 0.102871, -0.429025>, <0.445205, 0.102871, -0.467407>, <0.341286, 0.102871, -0.495253>, <0.264521, 0.102871, -0.495253>, 
      <0.511686, 0.120781, -0.429025>, <0.445205, 0.120781, -0.467407>, <0.341286, 0.120781, -0.495253>, <0.264521, 0.120781, -0.495253>, 
      <0.518745, 0.151551, -0.441252>, <0.452265, 0.151551, -0.479635>, <0.341286, 0.151551, -0.509371>, <0.264521, 0.151551, -0.509371>, 
      <0.511686, 0.162572, -0.429025>, <0.445205, 0.162572, -0.467407>, <0.341286, 0.162572, -0.495253>, <0.264521, 0.162572, -0.495253>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, 0.120081, -0.333786>, <0.212830, 0.120081, -0.333786>, <0.142855, 0.120081, -0.315037>, <0.098089, 0.120081, -0.289191>, 
      <0.264521, 0.120039, -0.234357>, <0.212830, 0.120039, -0.234357>, <0.192570, 0.120039, -0.228928>, <0.147804, 0.120039, -0.203083>, 
      <0.264521, 0.119984, -0.101785>, <0.264299, 0.119984, -0.101785>, <0.214283, 0.119984, -0.088383>, <0.214090, 0.119984, -0.088272>, 
      <0.264521, 0.119943, -0.002356>, <0.264299, 0.119943, -0.002356>, <0.263998, 0.119943, -0.002275>, <0.263805, 0.119943, -0.002164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, 0.162572, -0.418768>, <0.199633, 0.162572, -0.418768>, <0.111793, 0.162572, -0.395232>, <0.055598, 0.162572, -0.362788>, 
      <0.264521, 0.155318, -0.391203>, <0.199633, 0.155318, -0.391203>, <0.125576, 0.155318, -0.371360>, <0.069381, 0.155318, -0.338915>, 
      <0.264521, 0.132828, -0.359281>, <0.212830, 0.132828, -0.359281>, <0.130108, 0.132828, -0.337116>, <0.085342, 0.132828, -0.311270>, 
      <0.264521, 0.120081, -0.333786>, <0.212830, 0.120081, -0.333786>, <0.142855, 0.120081, -0.315037>, <0.098089, 0.120081, -0.289191>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, 0.162572, -0.495253>, <0.187756, 0.162572, -0.495253>, <0.083837, 0.162572, -0.467408>, <0.017356, 0.162572, -0.429025>, 
      <0.264521, 0.176690, -0.477165>, <0.187756, 0.176690, -0.477165>, <0.092881, 0.176690, -0.451744>, <0.026400, 0.176690, -0.413361>, 
      <0.264521, 0.168411, -0.440958>, <0.199633, 0.168411, -0.440958>, <0.100698, 0.168411, -0.414449>, <0.044503, 0.168411, -0.382005>, 
      <0.264521, 0.162572, -0.418768>, <0.199633, 0.162572, -0.418768>, <0.111793, 0.162572, -0.395232>, <0.055598, 0.162572, -0.362788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.264521, 0.102871, -0.495253>, <0.187756, 0.102871, -0.495253>, <0.083837, 0.102871, -0.467408>, <0.017356, 0.102871, -0.429025>, 
      <0.264521, 0.120781, -0.495253>, <0.187756, 0.120781, -0.495253>, <0.083837, 0.120781, -0.467408>, <0.017356, 0.120781, -0.429025>, 
      <0.264521, 0.151551, -0.509371>, <0.187756, 0.151551, -0.509371>, <0.076778, 0.151551, -0.479635>, <0.010297, 0.151551, -0.441252>, 
      <0.264521, 0.162572, -0.495253>, <0.187756, 0.162572, -0.495253>, <0.083837, 0.162572, -0.467408>, <0.017356, 0.162572, -0.429025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.098089, 0.120081, -0.289191>, <0.053324, 0.120081, -0.263346>, <0.002099, 0.120081, -0.212120>, <-0.023747, 0.120081, -0.167355>, 
      <0.147804, 0.120039, -0.203083>, <0.103039, 0.120039, -0.177237>, <0.088207, 0.120039, -0.162406>, <0.062361, 0.120039, -0.117640>, 
      <0.214090, 0.119984, -0.088272>, <0.213898, 0.119984, -0.088161>, <0.177284, 0.119984, -0.051547>, <0.177172, 0.119984, -0.051354>, 
      <0.263805, 0.119943, -0.002164>, <0.263612, 0.119943, -0.002052>, <0.263392, 0.119943, -0.001832>, <0.263281, 0.119943, -0.001639>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.055598, 0.162572, -0.362788>, <-0.000596, 0.162572, -0.330344>, <-0.064900, 0.162572, -0.266040>, <-0.097344, 0.162572, -0.209846>, 
      <0.069381, 0.155318, -0.338915>, <0.013187, 0.155318, -0.306472>, <-0.041027, 0.155318, -0.252258>, <-0.073471, 0.155318, -0.196063>, 
      <0.085342, 0.132828, -0.311270>, <0.040577, 0.132828, -0.285425>, <-0.019981, 0.132828, -0.224868>, <-0.045826, 0.132828, -0.180102>, 
      <0.098089, 0.120081, -0.289191>, <0.053324, 0.120081, -0.263346>, <0.002099, 0.120081, -0.212120>, <-0.023747, 0.120081, -0.167355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.017356, 0.162572, -0.429025>, <-0.049124, 0.162572, -0.390642>, <-0.125198, 0.162572, -0.314568>, <-0.163581, 0.162572, -0.248088>, 
      <0.026400, 0.176690, -0.413361>, <-0.040080, 0.176690, -0.374978>, <-0.109534, 0.176690, -0.305525>, <-0.147917, 0.176690, -0.239044>, 
      <0.044503, 0.168411, -0.382005>, <-0.011691, 0.168411, -0.349561>, <-0.084117, 0.168411, -0.277135>, <-0.116561, 0.168411, -0.220941>, 
      <0.055598, 0.162572, -0.362788>, <-0.000596, 0.162572, -0.330344>, <-0.064900, 0.162572, -0.266040>, <-0.097344, 0.162572, -0.209846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.017356, 0.102871, -0.429025>, <-0.049124, 0.102871, -0.390642>, <-0.125198, 0.102871, -0.314568>, <-0.163581, 0.102871, -0.248088>, 
      <0.017356, 0.120781, -0.429025>, <-0.049124, 0.120781, -0.390642>, <-0.125198, 0.120781, -0.314568>, <-0.163581, 0.120781, -0.248088>, 
      <0.010297, 0.151551, -0.441252>, <-0.056183, 0.151551, -0.402869>, <-0.137425, 0.151551, -0.321628>, <-0.175808, 0.151551, -0.255147>, 
      <0.017356, 0.162572, -0.429025>, <-0.049124, 0.162572, -0.390642>, <-0.125198, 0.162572, -0.314568>, <-0.163581, 0.162572, -0.248088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.023747, 0.120081, -0.167355>, <-0.049592, 0.120081, -0.122589>, <-0.068342, 0.120081, -0.052614>, <-0.068342, 0.120081, -0.000923>, 
      <0.062361, 0.120039, -0.117640>, <0.036516, 0.120039, -0.072874>, <0.031087, 0.120039, -0.052614>, <0.031087, 0.120039, -0.000923>, 
      <0.177172, 0.119984, -0.051354>, <0.177061, 0.119984, -0.051161>, <0.163659, 0.119984, -0.001146>, <0.163659, 0.119984, -0.000923>, 
      <0.263281, 0.119943, -0.001639>, <0.263169, 0.119943, -0.001447>, <0.263089, 0.119943, -0.001146>, <0.263089, 0.119943, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.097344, 0.162572, -0.209846>, <-0.129788, 0.162572, -0.153651>, <-0.153324, 0.162572, -0.065811>, <-0.153324, 0.162572, -0.000923>, 
      <-0.073471, 0.155318, -0.196063>, <-0.105915, 0.155318, -0.139869>, <-0.125759, 0.155318, -0.065811>, <-0.125759, 0.155318, -0.000923>, 
      <-0.045826, 0.132828, -0.180102>, <-0.071671, 0.132828, -0.135336>, <-0.093837, 0.132828, -0.052614>, <-0.093837, 0.132828, -0.000923>, 
      <-0.023747, 0.120081, -0.167355>, <-0.049592, 0.120081, -0.122589>, <-0.068342, 0.120081, -0.052614>, <-0.068342, 0.120081, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.163581, 0.162572, -0.248088>, <-0.201963, 0.162572, -0.181607>, <-0.229808, 0.162572, -0.077688>, <-0.229808, 0.162572, -0.000923>, 
      <-0.147917, 0.176690, -0.239044>, <-0.186299, 0.176690, -0.172564>, <-0.211721, 0.176690, -0.077688>, <-0.211721, 0.176690, -0.000923>, 
      <-0.116561, 0.168411, -0.220941>, <-0.149004, 0.168411, -0.164746>, <-0.175514, 0.168411, -0.065811>, <-0.175514, 0.168411, -0.000923>, 
      <-0.097344, 0.162572, -0.209846>, <-0.129788, 0.162572, -0.153651>, <-0.153324, 0.162572, -0.065811>, <-0.153324, 0.162572, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.163581, 0.102871, -0.248088>, <-0.201963, 0.102871, -0.181607>, <-0.229808, 0.102871, -0.077688>, <-0.229808, 0.102871, -0.000923>, 
      <-0.163581, 0.120781, -0.248088>, <-0.201963, 0.120781, -0.181607>, <-0.229808, 0.120781, -0.077688>, <-0.229808, 0.120781, -0.000923>, 
      <-0.175808, 0.151551, -0.255147>, <-0.214190, 0.151551, -0.188666>, <-0.243927, 0.151551, -0.077688>, <-0.243927, 0.151551, -0.000923>, 
      <-0.163581, 0.162572, -0.248088>, <-0.201963, 0.162572, -0.181607>, <-0.229808, 0.162572, -0.077688>, <-0.229808, 0.162572, -0.000923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.068342, 0.120081, -0.000923>, <-0.068342, 0.120081, 0.050768>, <-0.049592, 0.120081, 0.120743>, <-0.023747, 0.120081, 0.165509>, 
      <0.031087, 0.120039, -0.000923>, <0.031087, 0.120039, 0.050768>, <0.036516, 0.120039, 0.071028>, <0.062361, 0.120039, 0.115794>, 
      <0.163659, 0.119984, -0.000923>, <0.163659, 0.119984, -0.000700>, <0.177061, 0.119984, 0.049315>, <0.177172, 0.119984, 0.049508>, 
      <0.263089, 0.119943, -0.000923>, <0.263089, 0.119943, -0.000700>, <0.263169, 0.119943, -0.000399>, <0.263281, 0.119943, -0.000207>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.153324, 0.162572, -0.000923>, <-0.153324, 0.162572, 0.063965>, <-0.129788, 0.162572, 0.151805>, <-0.097344, 0.162572, 0.208000>, 
      <-0.125759, 0.155318, -0.000923>, <-0.125759, 0.155318, 0.063965>, <-0.105915, 0.155318, 0.138022>, <-0.073471, 0.155318, 0.194217>, 
      <-0.093837, 0.132828, -0.000923>, <-0.093837, 0.132828, 0.050768>, <-0.071671, 0.132828, 0.133490>, <-0.045826, 0.132828, 0.178256>, 
      <-0.068342, 0.120081, -0.000923>, <-0.068342, 0.120081, 0.050768>, <-0.049592, 0.120081, 0.120743>, <-0.023747, 0.120081, 0.165509>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.229808, 0.162572, -0.000923>, <-0.229808, 0.162572, 0.075842>, <-0.201963, 0.162572, 0.179761>, <-0.163581, 0.162572, 0.246242>, 
      <-0.211721, 0.176690, -0.000923>, <-0.211721, 0.176690, 0.075842>, <-0.186299, 0.176690, 0.170717>, <-0.147917, 0.176690, 0.237198>, 
      <-0.175514, 0.168411, -0.000923>, <-0.175514, 0.168411, 0.063965>, <-0.149004, 0.168411, 0.162900>, <-0.116561, 0.168411, 0.219094>, 
      <-0.153324, 0.162572, -0.000923>, <-0.153324, 0.162572, 0.063965>, <-0.129788, 0.162572, 0.151805>, <-0.097344, 0.162572, 0.208000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.229808, 0.102871, -0.000923>, <-0.229808, 0.102871, 0.075842>, <-0.201963, 0.102871, 0.179761>, <-0.163581, 0.102871, 0.246242>, 
      <-0.229808, 0.120781, -0.000923>, <-0.229808, 0.120781, 0.075842>, <-0.201963, 0.120781, 0.179761>, <-0.163581, 0.120781, 0.246242>, 
      <-0.243927, 0.151551, -0.000923>, <-0.243927, 0.151551, 0.075842>, <-0.214190, 0.151551, 0.186820>, <-0.175808, 0.151551, 0.253301>, 
      <-0.229808, 0.162572, -0.000923>, <-0.229808, 0.162572, 0.075842>, <-0.201963, 0.162572, 0.179761>, <-0.163581, 0.162572, 0.246242>
    }
  }
  material {
    Negativ4
  }
}
#declare rueda_nueva = difference {
  superellipsoid { // SuperQ006
    <1.0, 0.1>
    scale <1.0, 1.0, 0.2>
    rotate -90.0*x
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    scale 0.52
    rotate -90.0*x
    translate  -0.25*y
  }
  material {
    negro_txt
  }
  scale <0.88, 0.77, 0.88>
  translate  <0.272265, 0.0, 0.00133>
}
#declare rueda = union {
  object { juego_bolas }
  object { freno }
  object { tornillos }
  object { horquilla }
  object { embellecedor }
  object { rueda_nueva }
  translate  4.88*z
}
#declare apoyo_rueda = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.523575, -0.522434, 1.544039>, <0.221041, -0.522434, 1.543716>, <-0.182337, -0.522434, 1.543286>, <-0.484870, -0.522434, 1.542963>, 
      <0.573997, -0.525190, 1.506070>, <0.271464, -0.525190, 1.505747>, <-0.232759, -0.525190, 1.505209>, <-0.535293, -0.525190, 1.504886>, 
      <0.641227, -0.528865, 1.455444>, <0.237849, -0.528865, 1.455013>, <-0.199144, -0.528865, 1.454547>, <-0.602522, -0.528865, 1.454117>, 
      <0.691649, -0.531621, 1.417474>, <0.288271, -0.531621, 1.417044>, <-0.249566, -0.531621, 1.416470>, <-0.652945, -0.531621, 1.416039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.523575, -0.522434, 1.544039>, <0.392191, -0.522434, 1.812665>, <0.217013, -0.522434, 2.170833>, <0.085629, -0.522434, 2.439459>, 
      <0.573997, -0.525190, 1.506070>, <0.442613, -0.525190, 1.774696>, <0.229412, -0.525190, 2.208910>, <0.098028, -0.525190, 2.477536>, 
      <0.641227, -0.528865, 1.455444>, <0.471820, -0.528865, 1.800116>, <0.283967, -0.528865, 2.183633>, <0.114560, -0.528865, 2.528305>, 
      <0.691649, -0.531621, 1.417474>, <0.522242, -0.531621, 1.762147>, <0.296366, -0.531621, 2.221710>, <0.126959, -0.531621, 2.566382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.523575, 0.509189, 1.544039>, <0.221041, 0.509189, 1.543716>, <-0.182337, 0.509189, 1.543286>, <-0.484870, 0.509189, 1.542963>, 
      <0.523575, 0.199702, 1.544039>, <0.221041, 0.199702, 1.543716>, <-0.182337, 0.199702, 1.543286>, <-0.484870, 0.199702, 1.542963>, 
      <0.523575, -0.212947, 1.544039>, <0.221041, -0.212947, 1.543716>, <-0.182337, -0.212947, 1.543286>, <-0.484870, -0.212947, 1.542963>, 
      <0.523575, -0.522434, 1.544039>, <0.221041, -0.522434, 1.543716>, <-0.182337, -0.522434, 1.543286>, <-0.484870, -0.522434, 1.542963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.691649, 0.518377, 1.417474>, <0.288271, 0.518377, 1.417044>, <-0.249566, 0.518377, 1.416470>, <-0.652945, 0.518377, 1.416039>, 
      <0.641227, 0.515621, 1.455444>, <0.237849, 0.515621, 1.455013>, <-0.199144, 0.515621, 1.454547>, <-0.602522, 0.515621, 1.454117>, 
      <0.573997, 0.511946, 1.506070>, <0.271464, 0.511946, 1.505747>, <-0.232759, 0.511946, 1.505209>, <-0.535293, 0.511946, 1.504886>, 
      <0.523575, 0.509189, 1.544039>, <0.221041, 0.509189, 1.543716>, <-0.182337, 0.509189, 1.543286>, <-0.484870, 0.509189, 1.542963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.691649, 0.518377, 1.417474>, <0.522242, 0.518377, 1.762147>, <0.296366, 0.518377, 2.221710>, <0.126959, 0.518377, 2.566382>, 
      <0.641227, 0.515621, 1.455444>, <0.471820, 0.515621, 1.800116>, <0.283967, 0.515621, 2.183633>, <0.114560, 0.515621, 2.528305>, 
      <0.573997, 0.511946, 1.506070>, <0.442613, 0.511946, 1.774696>, <0.229412, 0.511946, 2.208910>, <0.098028, 0.511946, 2.477536>, 
      <0.523575, 0.509189, 1.544039>, <0.392191, 0.509189, 1.812665>, <0.217013, 0.509189, 2.170833>, <0.085629, 0.509189, 2.439459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.085629, 0.509189, 2.439459>, <0.217013, 0.509189, 2.170833>, <0.392191, 0.509189, 1.812665>, <0.523575, 0.509189, 1.544039>, 
      <0.085629, 0.199702, 2.439459>, <0.217013, 0.199702, 2.170833>, <0.392191, 0.199702, 1.812665>, <0.523575, 0.199702, 1.544039>, 
      <0.085629, -0.212947, 2.439459>, <0.217013, -0.212947, 2.170833>, <0.392191, -0.212947, 1.812665>, <0.523575, -0.212947, 1.544039>, 
      <0.085629, -0.522434, 2.439459>, <0.217013, -0.522434, 2.170833>, <0.392191, -0.522434, 1.812665>, <0.523575, -0.522434, 1.544039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.484870, 0.509189, 1.542963>, <-0.535293, 0.511946, 1.504886>, <-0.602522, 0.515621, 1.454117>, <-0.652945, 0.518377, 1.416039>, 
      <-0.484870, 0.199702, 1.542963>, <-0.535293, 0.202458, 1.504886>, <-0.602522, 0.200621, 1.454117>, <-0.652945, 0.203377, 1.416039>, 
      <-0.484870, -0.212947, 1.542963>, <-0.535293, -0.215703, 1.504886>, <-0.602522, -0.213866, 1.454117>, <-0.652945, -0.216622, 1.416039>, 
      <-0.484870, -0.522434, 1.542963>, <-0.535293, -0.525190, 1.504886>, <-0.602522, -0.528865, 1.454117>, <-0.652945, -0.531621, 1.416039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.126959, 0.518377, 2.566382>, <0.296366, 0.518377, 2.221710>, <0.522242, 0.518377, 1.762147>, <0.691649, 0.518377, 1.417474>, 
      <0.126959, 0.203377, 2.566382>, <0.296366, 0.203377, 2.221710>, <0.522242, 0.203377, 1.762147>, <0.691649, 0.203377, 1.417474>, 
      <0.126959, -0.216622, 2.566382>, <0.296366, -0.216622, 2.221710>, <0.522242, -0.216622, 1.762147>, <0.691649, -0.216622, 1.417474>, 
      <0.126959, -0.531621, 2.566382>, <0.296366, -0.531621, 2.221710>, <0.522242, -0.531621, 1.762147>, <0.691649, -0.531621, 1.417474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.126959, 0.518377, 2.566382>, <0.114560, 0.515621, 2.528305>, <0.098028, 0.511946, 2.477536>, <0.085629, 0.509189, 2.439459>, 
      <0.126959, 0.203377, 2.566382>, <0.114560, 0.200621, 2.528305>, <0.098028, 0.202458, 2.477536>, <0.085629, 0.199702, 2.439459>, 
      <0.126959, -0.216622, 2.566382>, <0.114560, -0.213866, 2.528305>, <0.098028, -0.215703, 2.477536>, <0.085629, -0.212947, 2.439459>, 
      <0.126959, -0.531621, 2.566382>, <0.114560, -0.528865, 2.528305>, <0.098028, -0.525190, 2.477536>, <0.085629, -0.522434, 2.439459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.652945, 0.518377, 1.416039>, <-0.249566, 0.518377, 1.416470>, <0.288271, 0.518377, 1.417044>, <0.691649, 0.518377, 1.417474>, 
      <-0.652945, 0.203377, 1.416039>, <-0.249566, 0.203377, 1.416470>, <0.288271, 0.203377, 1.417044>, <0.691649, 0.203377, 1.417474>, 
      <-0.652945, -0.216622, 1.416039>, <-0.249566, -0.216622, 1.416470>, <0.288271, -0.216622, 1.417044>, <0.691649, -0.216622, 1.417474>, 
      <-0.652945, -0.531621, 1.416039>, <-0.249566, -0.531621, 1.416470>, <0.288271, -0.531621, 1.417044>, <0.691649, -0.531621, 1.417474>
    }
  }
  translate  <-0.083454, 0.0, 4.88>
}

/*
#declare HgtFld001 = object { 
  height_field {
    tga "C:\TXEMI\MORAY FOR WINDOWS\Maps\murohf.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    muro_txt
  }
  scale <46.153847, 34.615387, 1.5>
  rotate <90.0, 0.0, 180.0>
  translate  <11.229691, -2.099982, 31.549207>
} */
#declare tabla_puerta11 = difference {
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.2, 1.0>
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.04>
    translate  <-1.0, -0.2, -1.02>
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.04>
    translate  <1.0, -0.2, -1.02>
  }
  scale <1.0, 1.0, 25.0>
  translate  5.0*z
}
#declare Cylndr123 = object {
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    material {
      hierro_txt
    }
    scale <0.1, 0.1, 12.0>
    translate  <-18.100597, 0.027209, 34.975719>
  }
}
#declare tabla_puerta = difference {
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.2, 1.0>
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.04>
    translate  <-1.0, -0.2, -1.02>
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.04>
    translate  <1.0, -0.2, -1.02>
  }
  scale <1.0, 1.0, 25.0>
  translate  5.0*z
}
#declare Cylndr132 = object {
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    material {
      hierro_txt
    }
    scale <0.1, 0.1, 12.0>
    translate  <-18.100597, 0.027209, 34.975719>
  }
}
#declare Cube068 = object {
  box { // Cube068
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 1.0>
    translate  <-16.001297, 14.74706, 1.117024>
  }
}


#declare emboque1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.654791, 0.654791, 0.643969>, <-0.805149, 0.504433, 0.643969>, <-0.926154, 0.212638, 0.643969>, <-0.926154, 0.000000, 0.643969>, 
      <-0.634767, 0.634767, 0.497494>, <-0.785125, 0.484409, 0.497494>, <-0.897832, 0.212638, 0.497495>, <-0.897832, 0.000000, 0.497495>, 
      <-0.654791, 0.654791, 0.295866>, <-0.805149, 0.504433, 0.295866>, <-0.926154, 0.212638, 0.295866>, <-0.926154, 0.000000, 0.295866>, 
      <-0.654791, 0.654791, 0.146679>, <-0.805149, 0.504433, 0.146679>, <-0.926154, 0.212638, 0.146679>, <-0.926154, 0.000000, 0.146679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.742825, 0.742825, 0.790647>, <-0.913398, 0.572252, 0.790647>, <-1.050672, 0.241227, 0.790647>, <-1.050672, 0.000000, 0.790647>, 
      <-0.728701, 0.728701, 0.736496>, <-0.899274, 0.558128, 0.736496>, <-1.030694, 0.241227, 0.736493>, <-1.030694, 0.000000, 0.736493>, 
      <-0.662538, 0.662538, 0.700637>, <-0.812896, 0.512180, 0.700637>, <-0.937112, 0.212638, 0.700640>, <-0.937112, 0.000000, 0.700640>, 
      <-0.654791, 0.654791, 0.643969>, <-0.805149, 0.504433, 0.643969>, <-0.926154, 0.212638, 0.643969>, <-0.926154, 0.000000, 0.643969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.720540, 0.720540, 1.772140>, <-0.885996, 0.555084, 1.772140>, <-1.019152, 0.233990, 1.772140>, <-1.019152, 0.000000, 1.772140>, 
      <-0.733900, 0.733900, 1.772140>, <-0.899356, 0.568445, 1.772140>, <-1.038047, 0.233990, 1.772140>, <-1.038047, 0.000000, 1.772140>, 
      <-0.742293, 0.742293, 1.736491>, <-0.912866, 0.571720, 1.736491>, <-1.049919, 0.241227, 1.736492>, <-1.049919, 0.000000, 1.736492>, 
      <-0.742825, 0.742825, 1.717613>, <-0.913398, 0.572252, 1.717613>, <-1.050672, 0.241227, 1.717613>, <-1.050672, 0.000000, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.698924, 0.698924, 1.717613>, <-0.859416, 0.538432, 1.717613>, <-0.988577, 0.226970, 1.717613>, <-0.988577, 0.000000, 1.717613>, 
      <-0.699496, 0.699496, 1.736349>, <-0.859988, 0.539003, 1.736349>, <-0.989386, 0.226970, 1.736349>, <-0.989386, 0.000000, 1.736349>, 
      <-0.707279, 0.707279, 1.772140>, <-0.872735, 0.541824, 1.772140>, <-1.000398, 0.233990, 1.772140>, <-1.000398, 0.000000, 1.772140>, 
      <-0.720540, 0.720540, 1.772140>, <-0.885996, 0.555084, 1.772140>, <-1.019152, 0.233990, 1.772140>, <-1.019152, 0.000000, 1.772140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.698924, 0.698924, 1.063284>, <-0.859416, 0.538432, 1.063284>, <-0.988577, 0.226970, 1.063284>, <-0.988577, 0.000000, 1.063284>, 
      <-0.698924, 0.698924, 1.259583>, <-0.859416, 0.538432, 1.259583>, <-0.988577, 0.226970, 1.259583>, <-0.988577, 0.000000, 1.259583>, 
      <-0.692944, 0.692944, 1.521496>, <-0.853436, 0.532452, 1.521496>, <-0.980118, 0.226970, 1.521496>, <-0.980118, 0.000000, 1.521496>, 
      <-0.698924, 0.698924, 1.717613>, <-0.859416, 0.538432, 1.717613>, <-0.988577, 0.226970, 1.717613>, <-0.988577, 0.000000, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.926154, 0.000000, 0.643969>, <-0.926154, -0.212638, 0.643969>, <-0.805149, -0.504433, 0.643969>, <-0.654791, -0.654791, 0.643969>, 
      <-0.897832, 0.000000, 0.497495>, <-0.897832, -0.212638, 0.497495>, <-0.785125, -0.484409, 0.497494>, <-0.634767, -0.634767, 0.497494>, 
      <-0.926154, 0.000000, 0.295866>, <-0.926154, -0.212638, 0.295866>, <-0.805149, -0.504433, 0.295866>, <-0.654791, -0.654791, 0.295866>, 
      <-0.926154, 0.000000, 0.146679>, <-0.926154, -0.212638, 0.146679>, <-0.805149, -0.504433, 0.146679>, <-0.654791, -0.654791, 0.146679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.050672, 0.000000, 0.790647>, <-1.050672, -0.241227, 0.790647>, <-0.913398, -0.572252, 0.790647>, <-0.742825, -0.742825, 0.790647>, 
      <-1.030694, 0.000000, 0.736493>, <-1.030694, -0.241227, 0.736493>, <-0.899274, -0.558128, 0.736496>, <-0.728701, -0.728701, 0.736496>, 
      <-0.937112, 0.000000, 0.700640>, <-0.937112, -0.212638, 0.700640>, <-0.812896, -0.512180, 0.700637>, <-0.662538, -0.662538, 0.700637>, 
      <-0.926154, 0.000000, 0.643969>, <-0.926154, -0.212638, 0.643969>, <-0.805149, -0.504433, 0.643969>, <-0.654791, -0.654791, 0.643969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.019152, 0.000000, 1.772140>, <-1.019152, -0.233990, 1.772140>, <-0.885996, -0.555084, 1.772140>, <-0.720540, -0.720540, 1.772140>, 
      <-1.038047, 0.000000, 1.772140>, <-1.038047, -0.233990, 1.772140>, <-0.899356, -0.568445, 1.772140>, <-0.733900, -0.733900, 1.772140>, 
      <-1.049919, 0.000000, 1.736492>, <-1.049919, -0.241227, 1.736492>, <-0.912866, -0.571720, 1.736491>, <-0.742293, -0.742293, 1.736491>, 
      <-1.050672, 0.000000, 1.717613>, <-1.050672, -0.241227, 1.717613>, <-0.913398, -0.572252, 1.717613>, <-0.742825, -0.742825, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.988577, 0.000000, 1.717613>, <-0.988577, -0.226970, 1.717613>, <-0.859416, -0.538432, 1.717613>, <-0.698924, -0.698924, 1.717613>, 
      <-0.989386, 0.000000, 1.736349>, <-0.989386, -0.226970, 1.736349>, <-0.859988, -0.539003, 1.736349>, <-0.699496, -0.699496, 1.736349>, 
      <-1.000398, 0.000000, 1.772140>, <-1.000398, -0.233990, 1.772140>, <-0.872735, -0.541824, 1.772140>, <-0.707279, -0.707279, 1.772140>, 
      <-1.019152, 0.000000, 1.772140>, <-1.019152, -0.233990, 1.772140>, <-0.885996, -0.555084, 1.772140>, <-0.720540, -0.720540, 1.772140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.988577, 0.000000, 1.063284>, <-0.988577, -0.226970, 1.063284>, <-0.859416, -0.538432, 1.063284>, <-0.698924, -0.698924, 1.063284>, 
      <-0.988577, 0.000000, 1.259583>, <-0.988577, -0.226970, 1.259583>, <-0.859416, -0.538432, 1.259583>, <-0.698924, -0.698924, 1.259583>, 
      <-0.980118, 0.000000, 1.521496>, <-0.980118, -0.226970, 1.521496>, <-0.853436, -0.532452, 1.521496>, <-0.692944, -0.692944, 1.521496>, 
      <-0.988577, 0.000000, 1.717613>, <-0.988577, -0.226970, 1.717613>, <-0.859416, -0.538432, 1.717613>, <-0.698924, -0.698924, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.654791, -0.654791, 0.643969>, <-0.504433, -0.805149, 0.643969>, <-0.212638, -0.926154, 0.643969>, <0.000000, -0.926154, 0.643969>, 
      <-0.634767, -0.634767, 0.497494>, <-0.484409, -0.785125, 0.497494>, <-0.212638, -0.897832, 0.497495>, <0.000000, -0.897832, 0.497495>, 
      <-0.654791, -0.654791, 0.295866>, <-0.504433, -0.805149, 0.295866>, <-0.212638, -0.926154, 0.295866>, <0.000000, -0.926154, 0.295866>, 
      <-0.654791, -0.654791, 0.146679>, <-0.504433, -0.805149, 0.146679>, <-0.212638, -0.926154, 0.146679>, <0.000000, -0.926154, 0.146679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.742825, -0.742825, 0.790647>, <-0.572252, -0.913398, 0.790647>, <-0.241227, -1.050672, 0.790647>, <0.000000, -1.050672, 0.790647>, 
      <-0.728701, -0.728701, 0.736496>, <-0.558128, -0.899274, 0.736496>, <-0.241227, -1.030694, 0.736493>, <0.000000, -1.030694, 0.736493>, 
      <-0.662538, -0.662538, 0.700637>, <-0.512180, -0.812896, 0.700637>, <-0.212638, -0.937112, 0.700640>, <0.000000, -0.937112, 0.700640>, 
      <-0.654791, -0.654791, 0.643969>, <-0.504433, -0.805149, 0.643969>, <-0.212638, -0.926154, 0.643969>, <0.000000, -0.926154, 0.643969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.720540, -0.720540, 1.772140>, <-0.555084, -0.885996, 1.772140>, <-0.233990, -1.019152, 1.772140>, <0.000000, -1.019152, 1.772140>, 
      <-0.733900, -0.733900, 1.772140>, <-0.568445, -0.899356, 1.772140>, <-0.233990, -1.038047, 1.772140>, <0.000000, -1.038047, 1.772140>, 
      <-0.742293, -0.742293, 1.736491>, <-0.571720, -0.912866, 1.736491>, <-0.241227, -1.049919, 1.736492>, <0.000000, -1.049919, 1.736492>, 
      <-0.742825, -0.742825, 1.717613>, <-0.572252, -0.913398, 1.717613>, <-0.241227, -1.050672, 1.717613>, <0.000000, -1.050672, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.698924, -0.698924, 1.717613>, <-0.538432, -0.859416, 1.717613>, <-0.226970, -0.988577, 1.717613>, <0.000000, -0.988577, 1.717613>, 
      <-0.699496, -0.699496, 1.736349>, <-0.539003, -0.859988, 1.736349>, <-0.226970, -0.989386, 1.736349>, <0.000000, -0.989386, 1.736349>, 
      <-0.707279, -0.707279, 1.772140>, <-0.541824, -0.872735, 1.772140>, <-0.233990, -1.000398, 1.772140>, <0.000000, -1.000398, 1.772140>, 
      <-0.720540, -0.720540, 1.772140>, <-0.555084, -0.885996, 1.772140>, <-0.233990, -1.019152, 1.772140>, <0.000000, -1.019152, 1.772140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.698924, -0.698924, 1.063284>, <-0.538432, -0.859416, 1.063284>, <-0.226970, -0.988577, 1.063284>, <0.000000, -0.988577, 1.063284>, 
      <-0.698924, -0.698924, 1.259583>, <-0.538432, -0.859416, 1.259583>, <-0.226970, -0.988577, 1.259583>, <0.000000, -0.988577, 1.259583>, 
      <-0.692944, -0.692944, 1.521496>, <-0.532452, -0.853436, 1.521496>, <-0.226970, -0.980118, 1.521496>, <0.000000, -0.980118, 1.521496>, 
      <-0.698924, -0.698924, 1.717613>, <-0.538432, -0.859416, 1.717613>, <-0.226970, -0.988577, 1.717613>, <0.000000, -0.988577, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.926154, 0.643969>, <0.212638, -0.926154, 0.643969>, <0.504433, -0.805149, 0.643969>, <0.654791, -0.654791, 0.643969>, 
      <0.000000, -0.897832, 0.497495>, <0.212638, -0.897832, 0.497495>, <0.484409, -0.785125, 0.497494>, <0.634767, -0.634767, 0.497494>, 
      <0.000000, -0.926154, 0.295866>, <0.212638, -0.926154, 0.295866>, <0.504433, -0.805149, 0.295866>, <0.654791, -0.654791, 0.295866>, 
      <0.000000, -0.926154, 0.146679>, <0.212638, -0.926154, 0.146679>, <0.504433, -0.805149, 0.146679>, <0.654791, -0.654791, 0.146679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.050672, 0.790647>, <0.241227, -1.050672, 0.790647>, <0.572252, -0.913398, 0.790647>, <0.742825, -0.742825, 0.790647>, 
      <0.000000, -1.030694, 0.736493>, <0.241227, -1.030694, 0.736493>, <0.558128, -0.899274, 0.736496>, <0.728701, -0.728701, 0.736496>, 
      <0.000000, -0.937112, 0.700640>, <0.212638, -0.937112, 0.700640>, <0.512180, -0.812896, 0.700637>, <0.662538, -0.662538, 0.700637>, 
      <0.000000, -0.926154, 0.643969>, <0.212638, -0.926154, 0.643969>, <0.504433, -0.805149, 0.643969>, <0.654791, -0.654791, 0.643969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.019152, 1.772140>, <0.233990, -1.019152, 1.772140>, <0.555084, -0.885996, 1.772140>, <0.720540, -0.720540, 1.772140>, 
      <0.000000, -1.038047, 1.772140>, <0.233990, -1.038047, 1.772140>, <0.568445, -0.899356, 1.772140>, <0.733900, -0.733900, 1.772140>, 
      <0.000000, -1.049919, 1.736492>, <0.241227, -1.049919, 1.736492>, <0.571720, -0.912866, 1.736491>, <0.742293, -0.742293, 1.736491>, 
      <0.000000, -1.050672, 1.717613>, <0.241227, -1.050672, 1.717613>, <0.572252, -0.913398, 1.717613>, <0.742825, -0.742825, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.988577, 1.717613>, <0.226970, -0.988577, 1.717613>, <0.538432, -0.859416, 1.717613>, <0.698924, -0.698924, 1.717613>, 
      <0.000000, -0.989386, 1.736349>, <0.226970, -0.989386, 1.736349>, <0.539003, -0.859988, 1.736349>, <0.699496, -0.699496, 1.736349>, 
      <0.000000, -1.000398, 1.772140>, <0.233990, -1.000398, 1.772140>, <0.541824, -0.872735, 1.772140>, <0.707279, -0.707279, 1.772140>, 
      <0.000000, -1.019152, 1.772140>, <0.233990, -1.019152, 1.772140>, <0.555084, -0.885996, 1.772140>, <0.720540, -0.720540, 1.772140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.988577, 1.063284>, <0.226970, -0.988577, 1.063284>, <0.538432, -0.859416, 1.063284>, <0.698924, -0.698924, 1.063284>, 
      <0.000000, -0.988577, 1.259583>, <0.226970, -0.988577, 1.259583>, <0.538432, -0.859416, 1.259583>, <0.698924, -0.698924, 1.259583>, 
      <0.000000, -0.980118, 1.521496>, <0.226970, -0.980118, 1.521496>, <0.532452, -0.853436, 1.521496>, <0.692944, -0.692944, 1.521496>, 
      <0.000000, -0.988577, 1.717613>, <0.226970, -0.988577, 1.717613>, <0.538432, -0.859416, 1.717613>, <0.698924, -0.698924, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.654791, -0.654791, 0.643969>, <0.805149, -0.504433, 0.643969>, <0.926154, -0.212638, 0.643969>, <0.926154, 0.000000, 0.643969>, 
      <0.634767, -0.634767, 0.497494>, <0.785125, -0.484409, 0.497494>, <0.897832, -0.212638, 0.497495>, <0.897832, 0.000000, 0.497495>, 
      <0.654791, -0.654791, 0.295866>, <0.805149, -0.504433, 0.295866>, <0.926154, -0.212638, 0.295866>, <0.926154, 0.000000, 0.295866>, 
      <0.654791, -0.654791, 0.146679>, <0.805149, -0.504433, 0.146679>, <0.926154, -0.212638, 0.146679>, <0.926154, 0.000000, 0.146679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.742825, -0.742825, 0.790647>, <0.913398, -0.572252, 0.790647>, <1.050672, -0.241227, 0.790647>, <1.050672, 0.000000, 0.790647>, 
      <0.728701, -0.728701, 0.736496>, <0.899274, -0.558128, 0.736496>, <1.030694, -0.241227, 0.736493>, <1.030694, 0.000000, 0.736493>, 
      <0.662538, -0.662538, 0.700637>, <0.812896, -0.512180, 0.700637>, <0.937112, -0.212638, 0.700640>, <0.937112, 0.000000, 0.700640>, 
      <0.654791, -0.654791, 0.643969>, <0.805149, -0.504433, 0.643969>, <0.926154, -0.212638, 0.643969>, <0.926154, 0.000000, 0.643969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.720540, -0.720540, 1.772140>, <0.885996, -0.555084, 1.772140>, <1.019152, -0.233990, 1.772140>, <1.019152, 0.000000, 1.772140>, 
      <0.733900, -0.733900, 1.772140>, <0.899356, -0.568445, 1.772140>, <1.038047, -0.233990, 1.772140>, <1.038047, 0.000000, 1.772140>, 
      <0.742293, -0.742293, 1.736491>, <0.912866, -0.571720, 1.736491>, <1.049919, -0.241227, 1.736492>, <1.049919, 0.000000, 1.736492>, 
      <0.742825, -0.742825, 1.717613>, <0.913398, -0.572252, 1.717613>, <1.050672, -0.241227, 1.717613>, <1.050672, 0.000000, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.698924, -0.698924, 1.717613>, <0.859416, -0.538432, 1.717613>, <0.988577, -0.226970, 1.717613>, <0.988577, 0.000000, 1.717613>, 
      <0.699496, -0.699496, 1.736349>, <0.859988, -0.539003, 1.736349>, <0.989386, -0.226970, 1.736349>, <0.989386, 0.000000, 1.736349>, 
      <0.707279, -0.707279, 1.772140>, <0.872735, -0.541824, 1.772140>, <1.000398, -0.233990, 1.772140>, <1.000398, 0.000000, 1.772140>, 
      <0.720540, -0.720540, 1.772140>, <0.885996, -0.555084, 1.772140>, <1.019152, -0.233990, 1.772140>, <1.019152, 0.000000, 1.772140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.698924, -0.698924, 1.063284>, <0.859416, -0.538432, 1.063284>, <0.988577, -0.226970, 1.063284>, <0.988577, 0.000000, 1.063284>, 
      <0.698924, -0.698924, 1.259583>, <0.859416, -0.538432, 1.259583>, <0.988577, -0.226970, 1.259583>, <0.988577, 0.000000, 1.259583>, 
      <0.692944, -0.692944, 1.521496>, <0.853436, -0.532452, 1.521496>, <0.980118, -0.226970, 1.521496>, <0.980118, 0.000000, 1.521496>, 
      <0.698924, -0.698924, 1.717613>, <0.859416, -0.538432, 1.717613>, <0.988577, -0.226970, 1.717613>, <0.988577, 0.000000, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.926154, 0.000000, 0.643969>, <0.926154, 0.212638, 0.643969>, <0.805149, 0.504433, 0.643969>, <0.654791, 0.654791, 0.643969>, 
      <0.897832, 0.000000, 0.497495>, <0.897832, 0.212638, 0.497495>, <0.785125, 0.484409, 0.497494>, <0.634767, 0.634767, 0.497494>, 
      <0.926154, 0.000000, 0.295866>, <0.926154, 0.212638, 0.295866>, <0.805149, 0.504433, 0.295866>, <0.654791, 0.654791, 0.295866>, 
      <0.926154, 0.000000, 0.146679>, <0.926154, 0.212638, 0.146679>, <0.805149, 0.504433, 0.146679>, <0.654791, 0.654791, 0.146679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.050672, 0.000000, 0.790647>, <1.050672, 0.241227, 0.790647>, <0.913398, 0.572252, 0.790647>, <0.742825, 0.742825, 0.790647>, 
      <1.030694, 0.000000, 0.736493>, <1.030694, 0.241227, 0.736493>, <0.899274, 0.558128, 0.736496>, <0.728701, 0.728701, 0.736496>, 
      <0.937112, 0.000000, 0.700640>, <0.937112, 0.212638, 0.700640>, <0.812896, 0.512180, 0.700637>, <0.662538, 0.662538, 0.700637>, 
      <0.926154, 0.000000, 0.643969>, <0.926154, 0.212638, 0.643969>, <0.805149, 0.504433, 0.643969>, <0.654791, 0.654791, 0.643969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.019152, 0.000000, 1.772140>, <1.019152, 0.233990, 1.772140>, <0.885996, 0.555084, 1.772140>, <0.720540, 0.720540, 1.772140>, 
      <1.038047, 0.000000, 1.772140>, <1.038047, 0.233990, 1.772140>, <0.899356, 0.568445, 1.772140>, <0.733900, 0.733900, 1.772140>, 
      <1.049919, 0.000000, 1.736492>, <1.049919, 0.241227, 1.736492>, <0.912866, 0.571720, 1.736491>, <0.742293, 0.742293, 1.736491>, 
      <1.050672, 0.000000, 1.717613>, <1.050672, 0.241227, 1.717613>, <0.913398, 0.572252, 1.717613>, <0.742825, 0.742825, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988577, 0.000000, 1.717613>, <0.988577, 0.226970, 1.717613>, <0.859416, 0.538432, 1.717613>, <0.698924, 0.698924, 1.717613>, 
      <0.989386, 0.000000, 1.736349>, <0.989386, 0.226970, 1.736349>, <0.859988, 0.539003, 1.736349>, <0.699496, 0.699496, 1.736349>, 
      <1.000398, 0.000000, 1.772140>, <1.000398, 0.233990, 1.772140>, <0.872735, 0.541824, 1.772140>, <0.707279, 0.707279, 1.772140>, 
      <1.019152, 0.000000, 1.772140>, <1.019152, 0.233990, 1.772140>, <0.885996, 0.555084, 1.772140>, <0.720540, 0.720540, 1.772140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988577, 0.000000, 1.063284>, <0.988577, 0.226970, 1.063284>, <0.859416, 0.538432, 1.063284>, <0.698924, 0.698924, 1.063284>, 
      <0.988577, 0.000000, 1.259583>, <0.988577, 0.226970, 1.259583>, <0.859416, 0.538432, 1.259583>, <0.698924, 0.698924, 1.259583>, 
      <0.980118, 0.000000, 1.521496>, <0.980118, 0.226970, 1.521496>, <0.853436, 0.532452, 1.521496>, <0.692944, 0.692944, 1.521496>, 
      <0.988577, 0.000000, 1.717613>, <0.988577, 0.226970, 1.717613>, <0.859416, 0.538432, 1.717613>, <0.698924, 0.698924, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.654791, 0.654791, 0.643969>, <0.504433, 0.805149, 0.643969>, <0.212638, 0.926154, 0.643969>, <0.000000, 0.926154, 0.643969>, 
      <0.634767, 0.634767, 0.497494>, <0.484409, 0.785125, 0.497494>, <0.212638, 0.897832, 0.497495>, <0.000000, 0.897832, 0.497495>, 
      <0.654791, 0.654791, 0.295866>, <0.504433, 0.805149, 0.295866>, <0.212638, 0.926154, 0.295866>, <0.000000, 0.926154, 0.295866>, 
      <0.654791, 0.654791, 0.146679>, <0.504433, 0.805149, 0.146679>, <0.212638, 0.926154, 0.146679>, <0.000000, 0.926154, 0.146679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.742825, 0.742825, 0.790647>, <0.572252, 0.913398, 0.790647>, <0.241227, 1.050672, 0.790647>, <0.000000, 1.050672, 0.790647>, 
      <0.728701, 0.728701, 0.736496>, <0.558128, 0.899274, 0.736496>, <0.241227, 1.030694, 0.736493>, <0.000000, 1.030694, 0.736493>, 
      <0.662538, 0.662538, 0.700637>, <0.512180, 0.812896, 0.700637>, <0.212638, 0.937112, 0.700640>, <0.000000, 0.937112, 0.700640>, 
      <0.654791, 0.654791, 0.643969>, <0.504433, 0.805149, 0.643969>, <0.212638, 0.926154, 0.643969>, <0.000000, 0.926154, 0.643969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.720540, 0.720540, 1.772140>, <0.555084, 0.885996, 1.772140>, <0.233990, 1.019152, 1.772140>, <0.000000, 1.019152, 1.772140>, 
      <0.733900, 0.733900, 1.772140>, <0.568445, 0.899356, 1.772140>, <0.233990, 1.038047, 1.772140>, <0.000000, 1.038047, 1.772140>, 
      <0.742293, 0.742293, 1.736491>, <0.571720, 0.912866, 1.736491>, <0.241227, 1.049919, 1.736492>, <0.000000, 1.049919, 1.736492>, 
      <0.742825, 0.742825, 1.717613>, <0.572252, 0.913398, 1.717613>, <0.241227, 1.050672, 1.717613>, <0.000000, 1.050672, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.698924, 0.698924, 1.717613>, <0.538432, 0.859416, 1.717613>, <0.226970, 0.988577, 1.717613>, <0.000000, 0.988577, 1.717613>, 
      <0.699496, 0.699496, 1.736349>, <0.539003, 0.859988, 1.736349>, <0.226970, 0.989386, 1.736349>, <0.000000, 0.989386, 1.736349>, 
      <0.707279, 0.707279, 1.772140>, <0.541824, 0.872735, 1.772140>, <0.233990, 1.000398, 1.772140>, <0.000000, 1.000398, 1.772140>, 
      <0.720540, 0.720540, 1.772140>, <0.555084, 0.885996, 1.772140>, <0.233990, 1.019152, 1.772140>, <0.000000, 1.019152, 1.772140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.698924, 0.698924, 1.063284>, <0.538432, 0.859416, 1.063284>, <0.226970, 0.988577, 1.063284>, <0.000000, 0.988577, 1.063284>, 
      <0.698924, 0.698924, 1.259583>, <0.538432, 0.859416, 1.259583>, <0.226970, 0.988577, 1.259583>, <0.000000, 0.988577, 1.259583>, 
      <0.692944, 0.692944, 1.521496>, <0.532452, 0.853436, 1.521496>, <0.226970, 0.980118, 1.521496>, <0.000000, 0.980118, 1.521496>, 
      <0.698924, 0.698924, 1.717613>, <0.538432, 0.859416, 1.717613>, <0.226970, 0.988577, 1.717613>, <0.000000, 0.988577, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.926154, 0.643969>, <-0.212638, 0.926154, 0.643969>, <-0.504433, 0.805149, 0.643969>, <-0.654791, 0.654791, 0.643969>, 
      <0.000000, 0.897832, 0.497495>, <-0.212638, 0.897832, 0.497495>, <-0.484409, 0.785125, 0.497494>, <-0.634767, 0.634767, 0.497494>, 
      <0.000000, 0.926154, 0.295866>, <-0.212638, 0.926154, 0.295866>, <-0.504433, 0.805149, 0.295866>, <-0.654791, 0.654791, 0.295866>, 
      <0.000000, 0.926154, 0.146679>, <-0.212638, 0.926154, 0.146679>, <-0.504433, 0.805149, 0.146679>, <-0.654791, 0.654791, 0.146679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.050672, 0.790647>, <-0.241227, 1.050672, 0.790647>, <-0.572252, 0.913398, 0.790647>, <-0.742825, 0.742825, 0.790647>, 
      <0.000000, 1.030694, 0.736493>, <-0.241227, 1.030694, 0.736493>, <-0.558128, 0.899274, 0.736496>, <-0.728701, 0.728701, 0.736496>, 
      <0.000000, 0.937112, 0.700640>, <-0.212638, 0.937112, 0.700640>, <-0.512180, 0.812896, 0.700637>, <-0.662538, 0.662538, 0.700637>, 
      <0.000000, 0.926154, 0.643969>, <-0.212638, 0.926154, 0.643969>, <-0.504433, 0.805149, 0.643969>, <-0.654791, 0.654791, 0.643969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.019152, 1.772140>, <-0.233990, 1.019152, 1.772140>, <-0.555084, 0.885996, 1.772140>, <-0.720540, 0.720540, 1.772140>, 
      <0.000000, 1.038047, 1.772140>, <-0.233990, 1.038047, 1.772140>, <-0.568445, 0.899356, 1.772140>, <-0.733900, 0.733900, 1.772140>, 
      <0.000000, 1.049919, 1.736492>, <-0.241227, 1.049919, 1.736492>, <-0.571720, 0.912866, 1.736491>, <-0.742293, 0.742293, 1.736491>, 
      <0.000000, 1.050672, 1.717613>, <-0.241227, 1.050672, 1.717613>, <-0.572252, 0.913398, 1.717613>, <-0.742825, 0.742825, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.988577, 1.717613>, <-0.226970, 0.988577, 1.717613>, <-0.538432, 0.859416, 1.717613>, <-0.698924, 0.698924, 1.717613>, 
      <0.000000, 0.989386, 1.736349>, <-0.226970, 0.989386, 1.736349>, <-0.539003, 0.859988, 1.736349>, <-0.699496, 0.699496, 1.736349>, 
      <0.000000, 1.000398, 1.772140>, <-0.233990, 1.000398, 1.772140>, <-0.541824, 0.872735, 1.772140>, <-0.707279, 0.707279, 1.772140>, 
      <0.000000, 1.019152, 1.772140>, <-0.233990, 1.019152, 1.772140>, <-0.555084, 0.885996, 1.772140>, <-0.720540, 0.720540, 1.772140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.988577, 1.063284>, <-0.226970, 0.988577, 1.063284>, <-0.538432, 0.859416, 1.063284>, <-0.698924, 0.698924, 1.063284>, 
      <0.000000, 0.988577, 1.259583>, <-0.226970, 0.988577, 1.259583>, <-0.538432, 0.859416, 1.259583>, <-0.698924, 0.698924, 1.259583>, 
      <0.000000, 0.980118, 1.521496>, <-0.226970, 0.980118, 1.521496>, <-0.532452, 0.853436, 1.521496>, <-0.692944, 0.692944, 1.521496>, 
      <0.000000, 0.988577, 1.717613>, <-0.226970, 0.988577, 1.717613>, <-0.538432, 0.859416, 1.717613>, <-0.698924, 0.698924, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.742825, 0.742825, 0.790647>, <-0.756835, 0.756835, 0.844363>, <-0.742825, 0.742825, 0.924239>, <-0.742825, 0.742825, 0.981493>, 
      <-0.572252, 0.913398, 0.790647>, <-0.586262, 0.927408, 0.844363>, <-0.572252, 0.913398, 0.924239>, <-0.572252, 0.913398, 0.981493>, 
      <-0.241227, 1.050672, 0.790647>, <-0.241227, 1.070488, 0.844362>, <-0.241227, 1.050672, 0.924239>, <-0.241227, 1.050672, 0.981493>, 
      <0.000000, 1.050672, 0.790647>, <0.000000, 1.070488, 0.844362>, <0.000000, 1.050672, 0.924239>, <0.000000, 1.050672, 0.981493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.050672, 0.000000, 0.790647>, <-1.070488, 0.000000, 0.844362>, <-1.050672, 0.000000, 0.924239>, <-1.050672, 0.000000, 0.981493>, 
      <-1.050672, 0.241227, 0.790647>, <-1.070488, 0.241227, 0.844362>, <-1.050672, 0.241227, 0.924239>, <-1.050672, 0.241227, 0.981493>, 
      <-0.913398, 0.572252, 0.790647>, <-0.927408, 0.586262, 0.844363>, <-0.913398, 0.572252, 0.924239>, <-0.913398, 0.572252, 0.981493>, 
      <-0.742825, 0.742825, 0.790647>, <-0.756835, 0.756835, 0.844363>, <-0.742825, 0.742825, 0.924239>, <-0.742825, 0.742825, 0.981493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.742825, -0.742825, 0.790647>, <-0.756835, -0.756835, 0.844363>, <-0.742825, -0.742825, 0.924239>, <-0.742825, -0.742825, 0.981493>, 
      <-0.913398, -0.572252, 0.790647>, <-0.927408, -0.586262, 0.844363>, <-0.913398, -0.572252, 0.924239>, <-0.913398, -0.572252, 0.981493>, 
      <-1.050672, -0.241227, 0.790647>, <-1.070488, -0.241227, 0.844362>, <-1.050672, -0.241227, 0.924239>, <-1.050672, -0.241227, 0.981493>, 
      <-1.050672, 0.000000, 0.790647>, <-1.070488, 0.000000, 0.844362>, <-1.050672, 0.000000, 0.924239>, <-1.050672, 0.000000, 0.981493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.050672, 0.790647>, <0.000000, -1.070488, 0.844362>, <0.000000, -1.050672, 0.924239>, <0.000000, -1.050672, 0.981493>, 
      <-0.241227, -1.050672, 0.790647>, <-0.241227, -1.070488, 0.844362>, <-0.241227, -1.050672, 0.924239>, <-0.241227, -1.050672, 0.981493>, 
      <-0.572252, -0.913398, 0.790647>, <-0.586262, -0.927408, 0.844363>, <-0.572252, -0.913398, 0.924239>, <-0.572252, -0.913398, 0.981493>, 
      <-0.742825, -0.742825, 0.790647>, <-0.756835, -0.756835, 0.844363>, <-0.742825, -0.742825, 0.924239>, <-0.742825, -0.742825, 0.981493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.742825, -0.742825, 0.790647>, <0.756835, -0.756835, 0.844363>, <0.742825, -0.742825, 0.924239>, <0.742825, -0.742825, 0.981493>, 
      <0.572252, -0.913398, 0.790647>, <0.586262, -0.927408, 0.844363>, <0.572252, -0.913398, 0.924239>, <0.572252, -0.913398, 0.981493>, 
      <0.241227, -1.050672, 0.790647>, <0.241227, -1.070488, 0.844362>, <0.241227, -1.050672, 0.924239>, <0.241227, -1.050672, 0.981493>, 
      <0.000000, -1.050672, 0.790647>, <0.000000, -1.070488, 0.844362>, <0.000000, -1.050672, 0.924239>, <0.000000, -1.050672, 0.981493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.050672, 0.000000, 0.790647>, <1.070488, 0.000000, 0.844362>, <1.050672, 0.000000, 0.924239>, <1.050672, 0.000000, 0.981493>, 
      <1.050672, -0.241227, 0.790647>, <1.070488, -0.241227, 0.844362>, <1.050672, -0.241227, 0.924239>, <1.050672, -0.241227, 0.981493>, 
      <0.913398, -0.572252, 0.790647>, <0.927408, -0.586262, 0.844363>, <0.913398, -0.572252, 0.924239>, <0.913398, -0.572252, 0.981493>, 
      <0.742825, -0.742825, 0.790647>, <0.756835, -0.756835, 0.844363>, <0.742825, -0.742825, 0.924239>, <0.742825, -0.742825, 0.981493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.742825, 0.742825, 0.790647>, <0.756835, 0.756835, 0.844363>, <0.742825, 0.742825, 0.924239>, <0.742825, 0.742825, 0.981493>, 
      <0.913398, 0.572252, 0.790647>, <0.927408, 0.586262, 0.844363>, <0.913398, 0.572252, 0.924239>, <0.913398, 0.572252, 0.981493>, 
      <1.050672, 0.241227, 0.790647>, <1.070488, 0.241227, 0.844362>, <1.050672, 0.241227, 0.924239>, <1.050672, 0.241227, 0.981493>, 
      <1.050672, 0.000000, 0.790647>, <1.070488, 0.000000, 0.844362>, <1.050672, 0.000000, 0.924239>, <1.050672, 0.000000, 0.981493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.050672, 0.790647>, <0.000000, 1.070488, 0.844362>, <0.000000, 1.050672, 0.924239>, <0.000000, 1.050672, 0.981493>, 
      <0.241227, 1.050672, 0.790647>, <0.241227, 1.070488, 0.844362>, <0.241227, 1.050672, 0.924239>, <0.241227, 1.050672, 0.981493>, 
      <0.572252, 0.913398, 0.790647>, <0.586262, 0.927408, 0.844363>, <0.572252, 0.913398, 0.924239>, <0.572252, 0.913398, 0.981493>, 
      <0.742825, 0.742825, 0.790647>, <0.756835, 0.756835, 0.844363>, <0.742825, 0.742825, 0.924239>, <0.742825, 0.742825, 0.981493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.742825, 0.742825, 0.981493>, <-0.742825, 0.742825, 1.202329>, <-0.749045, 0.749045, 1.496952>, <-0.742825, 0.742825, 1.717613>, 
      <-0.572252, 0.913398, 0.981493>, <-0.572252, 0.913398, 1.202329>, <-0.578472, 0.919617, 1.496952>, <-0.572252, 0.913398, 1.717613>, 
      <-0.241227, 1.050672, 0.981493>, <-0.241227, 1.050672, 1.202329>, <-0.241227, 1.059469, 1.496952>, <-0.241227, 1.050672, 1.717613>, 
      <0.000000, 1.050672, 0.981493>, <0.000000, 1.050672, 1.202329>, <0.000000, 1.059469, 1.496952>, <0.000000, 1.050672, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.050672, 0.000000, 0.981493>, <-1.050672, 0.000000, 1.202329>, <-1.059469, 0.000000, 1.496952>, <-1.050672, 0.000000, 1.717613>, 
      <-1.050672, 0.241227, 0.981493>, <-1.050672, 0.241227, 1.202329>, <-1.059469, 0.241227, 1.496952>, <-1.050672, 0.241227, 1.717613>, 
      <-0.913398, 0.572252, 0.981493>, <-0.913398, 0.572252, 1.202329>, <-0.919617, 0.578472, 1.496952>, <-0.913398, 0.572252, 1.717613>, 
      <-0.742825, 0.742825, 0.981493>, <-0.742825, 0.742825, 1.202329>, <-0.749045, 0.749045, 1.496952>, <-0.742825, 0.742825, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.742825, -0.742825, 0.981493>, <-0.742825, -0.742825, 1.202329>, <-0.749045, -0.749045, 1.496952>, <-0.742825, -0.742825, 1.717613>, 
      <-0.913398, -0.572252, 0.981493>, <-0.913398, -0.572252, 1.202329>, <-0.919617, -0.578472, 1.496952>, <-0.913398, -0.572252, 1.717613>, 
      <-1.050672, -0.241227, 0.981493>, <-1.050672, -0.241227, 1.202329>, <-1.059469, -0.241227, 1.496952>, <-1.050672, -0.241227, 1.717613>, 
      <-1.050672, 0.000000, 0.981493>, <-1.050672, 0.000000, 1.202329>, <-1.059469, 0.000000, 1.496952>, <-1.050672, 0.000000, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.050672, 0.981493>, <0.000000, -1.050672, 1.202329>, <0.000000, -1.059469, 1.496952>, <0.000000, -1.050672, 1.717613>, 
      <-0.241227, -1.050672, 0.981493>, <-0.241227, -1.050672, 1.202329>, <-0.241227, -1.059469, 1.496952>, <-0.241227, -1.050672, 1.717613>, 
      <-0.572252, -0.913398, 0.981493>, <-0.572252, -0.913398, 1.202329>, <-0.578472, -0.919617, 1.496952>, <-0.572252, -0.913398, 1.717613>, 
      <-0.742825, -0.742825, 0.981493>, <-0.742825, -0.742825, 1.202329>, <-0.749045, -0.749045, 1.496952>, <-0.742825, -0.742825, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.742825, -0.742825, 0.981493>, <0.742825, -0.742825, 1.202329>, <0.749045, -0.749045, 1.496952>, <0.742825, -0.742825, 1.717613>, 
      <0.572252, -0.913398, 0.981493>, <0.572252, -0.913398, 1.202329>, <0.578472, -0.919617, 1.496952>, <0.572252, -0.913398, 1.717613>, 
      <0.241227, -1.050672, 0.981493>, <0.241227, -1.050672, 1.202329>, <0.241227, -1.059469, 1.496952>, <0.241227, -1.050672, 1.717613>, 
      <0.000000, -1.050672, 0.981493>, <0.000000, -1.050672, 1.202329>, <0.000000, -1.059469, 1.496952>, <0.000000, -1.050672, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.050672, 0.000000, 0.981493>, <1.050672, 0.000000, 1.202329>, <1.059469, 0.000000, 1.496952>, <1.050672, 0.000000, 1.717613>, 
      <1.050672, -0.241227, 0.981493>, <1.050672, -0.241227, 1.202329>, <1.059469, -0.241227, 1.496952>, <1.050672, -0.241227, 1.717613>, 
      <0.913398, -0.572252, 0.981493>, <0.913398, -0.572252, 1.202329>, <0.919617, -0.578472, 1.496952>, <0.913398, -0.572252, 1.717613>, 
      <0.742825, -0.742825, 0.981493>, <0.742825, -0.742825, 1.202329>, <0.749045, -0.749045, 1.496952>, <0.742825, -0.742825, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.742825, 0.742825, 0.981493>, <0.742825, 0.742825, 1.202329>, <0.749045, 0.749045, 1.496952>, <0.742825, 0.742825, 1.717613>, 
      <0.913398, 0.572252, 0.981493>, <0.913398, 0.572252, 1.202329>, <0.919617, 0.578472, 1.496952>, <0.913398, 0.572252, 1.717613>, 
      <1.050672, 0.241227, 0.981493>, <1.050672, 0.241227, 1.202329>, <1.059469, 0.241227, 1.496952>, <1.050672, 0.241227, 1.717613>, 
      <1.050672, 0.000000, 0.981493>, <1.050672, 0.000000, 1.202329>, <1.059469, 0.000000, 1.496952>, <1.050672, 0.000000, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.050672, 0.981493>, <0.000000, 1.050672, 1.202329>, <0.000000, 1.059469, 1.496952>, <0.000000, 1.050672, 1.717613>, 
      <0.241227, 1.050672, 0.981493>, <0.241227, 1.050672, 1.202329>, <0.241227, 1.059469, 1.496952>, <0.241227, 1.050672, 1.717613>, 
      <0.572252, 0.913398, 0.981493>, <0.572252, 0.913398, 1.202329>, <0.578472, 0.919617, 1.496952>, <0.572252, 0.913398, 1.717613>, 
      <0.742825, 0.742825, 0.981493>, <0.742825, 0.742825, 1.202329>, <0.749045, 0.749045, 1.496952>, <0.742825, 0.742825, 1.717613>
    }
  }
  translate  24.0*z
}
#declare abrazadera_base = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.698924, -0.723006, 0.681592>, <0.864147, -0.557783, 0.681592>, <0.940109, -0.228578, 0.681592>, <0.988577, 0.000000, 0.681592>, 
      <0.692885, -0.716967, 0.457648>, <0.858108, -0.551744, 0.457648>, <0.931566, -0.228578, 0.457648>, <0.980035, 0.000000, 0.457648>, 
      <0.685606, -0.709688, 0.157882>, <0.850829, -0.544465, 0.157882>, <0.921271, -0.228578, 0.157882>, <0.969740, 0.000000, 0.157882>, 
      <0.698924, -0.723006, -0.065433>, <0.864147, -0.557783, -0.065433>, <0.940109, -0.228578, -0.065433>, <0.988577, 0.000000, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.698924, -0.723006, -0.065433>, <0.540318, -0.881613, -0.065433>, <0.000000, -0.988577, -0.065433>, <0.000000, -0.988577, -0.065433>, 
      <0.700048, -0.724130, -0.084277>, <0.541441, -0.882737, -0.084277>, <0.000000, -0.988577, -0.065433>, <0.000000, -0.988577, -0.065433>, 
      <0.741718, -0.765800, -0.073373>, <0.573034, -0.934483, -0.073373>, <0.000000, -1.050672, -0.054527>, <0.000000, -1.050672, -0.054527>, 
      <0.742825, -0.766907, -0.054527>, <0.574142, -0.935590, -0.054527>, <0.000000, -1.050672, -0.054527>, <0.000000, -1.050672, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988577, 0.000000, 0.681592>, <1.033449, 0.211614, 0.681592>, <1.001418, 0.504587, 0.681592>, <1.005090, 0.720875, 0.681592>, 
      <0.980035, 0.000000, 0.457648>, <1.024907, 0.211614, 0.457648>, <0.992877, 0.504587, 0.457648>, <0.996549, 0.720875, 0.457648>, 
      <0.969740, 0.000000, 0.157882>, <1.014611, 0.211614, 0.157882>, <0.982584, 0.504587, 0.157882>, <0.986255, 0.720875, 0.157882>, 
      <0.988577, 0.000000, -0.065433>, <1.033449, 0.211614, -0.065433>, <1.001418, 0.504587, -0.065433>, <1.005090, 0.720875, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988577, 0.000000, -0.065433>, <0.940109, -0.228578, -0.065433>, <0.864147, -0.557783, -0.065433>, <0.698924, -0.723006, -0.065433>, 
      <0.990167, 0.000000, -0.084279>, <0.941698, -0.228578, -0.084279>, <0.865271, -0.558907, -0.084277>, <0.700048, -0.724130, -0.084277>, 
      <1.049105, 0.000000, -0.073376>, <0.996297, -0.242227, -0.073376>, <0.917021, -0.590496, -0.073373>, <0.741718, -0.765800, -0.073373>, 
      <1.050672, 0.000000, -0.054527>, <0.997864, -0.242227, -0.054527>, <0.918128, -0.591604, -0.054527>, <0.742825, -0.766907, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.005090, 0.720875, 0.681592>, <1.006372, 0.796394, 0.681592>, <0.996682, 0.897582, 0.681592>, <1.005090, 0.972643, 0.681592>, 
      <0.996549, 0.720875, 0.457648>, <0.997831, 0.796394, 0.457648>, <0.988141, 0.897582, 0.457648>, <0.996549, 0.972643, 0.457648>, 
      <0.986255, 0.720875, 0.157882>, <0.987538, 0.796394, 0.157882>, <0.977847, 0.897582, 0.157882>, <0.986255, 0.972643, 0.157882>, 
      <1.005090, 0.720875, -0.065433>, <1.006372, 0.796394, -0.065433>, <0.996682, 0.897582, -0.065433>, <1.005090, 0.972643, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.005090, 0.720875, -0.065433>, <1.001418, 0.504587, -0.065433>, <1.033449, 0.211614, -0.065433>, <0.988577, 0.000000, -0.065433>, 
      <1.006679, 0.720875, -0.084277>, <1.003007, 0.504587, -0.084277>, <1.035039, 0.211614, -0.084279>, <0.990167, 0.000000, -0.084279>, 
      <1.065609, 0.720875, -0.073373>, <1.061939, 0.504587, -0.073373>, <1.095182, 0.211355, -0.073376>, <1.049105, 0.000000, -0.073376>, 
      <1.067175, 0.720875, -0.054527>, <1.063506, 0.504587, -0.054527>, <1.096749, 0.211355, -0.054527>, <1.050672, 0.000000, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.005090, 0.972643, 0.681592>, <1.008870, 1.006387, 0.681592>, <1.022605, 1.053109, 0.681592>, <1.045150, 1.078499, 0.681592>, 
      <0.996549, 0.972643, 0.457648>, <1.000329, 1.006387, 0.457648>, <1.016566, 1.059148, 0.457648>, <1.039110, 1.084538, 0.457648>, 
      <0.986255, 0.972643, 0.157882>, <0.990035, 1.006387, 0.157882>, <1.009287, 1.066426, 0.157882>, <1.031832, 1.091817, 0.157882>, 
      <1.005090, 0.972643, -0.065433>, <1.008870, 1.006387, -0.065433>, <1.022605, 1.053109, -0.065433>, <1.045150, 1.078499, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.005090, 0.972643, -0.065433>, <0.996682, 0.897582, -0.065433>, <1.006372, 0.796394, -0.065433>, <1.005090, 0.720875, -0.065433>, 
      <1.006679, 0.972643, -0.084277>, <0.998271, 0.897582, -0.084277>, <1.007962, 0.796394, -0.084277>, <1.006679, 0.720875, -0.084277>, 
      <1.065609, 0.972643, -0.073373>, <1.060355, 0.897296, -0.073373>, <1.066891, 0.796394, -0.073373>, <1.065609, 0.720875, -0.073373>, 
      <1.067175, 0.972643, -0.054527>, <1.061922, 0.897296, -0.054527>, <1.068457, 0.796394, -0.054527>, <1.067175, 0.720875, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.045150, 1.078499, 0.681592>, <1.064234, 1.099991, 0.681592>, <1.104327, 1.114846, 0.681592>, <1.133009, 1.116708, 0.681592>, 
      <1.039110, 1.084538, 0.457648>, <1.058194, 1.106031, 0.457648>, <1.104327, 1.123387, 0.457648>, <1.133009, 1.125249, 0.457648>, 
      <1.031832, 1.091817, 0.157882>, <1.050916, 1.113309, 0.157882>, <1.104327, 1.133681, 0.157882>, <1.133009, 1.135543, 0.157882>, 
      <1.045150, 1.078499, -0.065433>, <1.064234, 1.099991, -0.065433>, <1.104327, 1.114846, -0.065433>, <1.133009, 1.116708, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.045150, 1.078499, -0.065433>, <1.022605, 1.053109, -0.065433>, <1.008870, 1.006387, -0.065433>, <1.005090, 0.972643, -0.065433>, 
      <1.046274, 1.077375, -0.084277>, <1.023729, 1.051985, -0.084277>, <1.010459, 1.006387, -0.084277>, <1.006679, 0.972643, -0.084277>, 
      <1.087943, 1.035705, -0.073373>, <1.075601, 1.020337, -0.073373>, <1.066980, 0.992306, -0.073373>, <1.065609, 0.972643, -0.073373>, 
      <1.089051, 1.034598, -0.054527>, <1.076709, 1.019229, -0.054527>, <1.068546, 0.992306, -0.054527>, <1.067175, 0.972643, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.133009, 1.054623, -0.054527>, <1.118527, 1.054090, -0.054527>, <1.098124, 1.045897, -0.054527>, <1.089051, 1.034598, -0.054527>, 
      <1.133009, 1.056189, -0.073373>, <1.118527, 1.055657, -0.073373>, <1.097017, 1.047004, -0.073373>, <1.087943, 1.035705, -0.073373>, 
      <1.133009, 1.115119, -0.084277>, <1.104327, 1.113257, -0.084277>, <1.065357, 1.098868, -0.084277>, <1.046274, 1.077375, -0.084277>, 
      <1.133009, 1.116708, -0.065433>, <1.104327, 1.114846, -0.065433>, <1.064234, 1.099991, -0.065433>, <1.045150, 1.078499, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.633537, 1.079768, 0.681592>, <1.633537, 1.072224, 0.681592>, <1.641071, 1.055001, 0.681592>, <1.633537, 1.054623, 0.681592>, 
      <1.633537, 1.078095, 0.460763>, <1.633537, 1.070552, 0.460763>, <1.641071, 1.046206, 0.460932>, <1.633537, 1.045827, 0.460932>, 
      <1.633537, 1.079768, 0.166309>, <1.633537, 1.072224, 0.166309>, <1.641071, 1.055001, 0.166309>, <1.633537, 1.054623, 0.166309>, 
      <1.633537, 1.079768, -0.054527>, <1.633537, 1.072224, -0.054527>, <1.641071, 1.055001, -0.054527>, <1.633537, 1.054623, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.633537, 1.054623, 0.681592>, <1.483567, 1.047089, 0.681592>, <1.283066, 1.060142, 0.681592>, <1.133009, 1.054623, 0.681592>, 
      <1.633537, 1.045827, 0.460932>, <1.483567, 1.038294, 0.460932>, <1.283066, 1.051346, 0.460932>, <1.133009, 1.045827, 0.460932>, 
      <1.633537, 1.054623, 0.166309>, <1.483567, 1.047089, 0.166309>, <1.283066, 1.041851, 0.165550>, <1.133009, 1.036332, 0.165550>, 
      <1.633537, 1.054623, -0.054527>, <1.483567, 1.047089, -0.054527>, <1.283066, 1.060142, -0.054527>, <1.133009, 1.054623, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.698924, -0.723006, 0.681592>, <-0.864147, -0.557783, 0.681592>, <-0.940109, -0.228578, 0.681592>, <-0.988577, 0.000000, 0.681592>, 
      <-0.692885, -0.716967, 0.457648>, <-0.858108, -0.551744, 0.457648>, <-0.931566, -0.228578, 0.457648>, <-0.980035, 0.000000, 0.457648>, 
      <-0.685606, -0.709688, 0.157882>, <-0.850829, -0.544465, 0.157882>, <-0.921271, -0.228578, 0.157882>, <-0.969740, 0.000000, 0.157882>, 
      <-0.698924, -0.723006, -0.065433>, <-0.864147, -0.557783, -0.065433>, <-0.940109, -0.228578, -0.065433>, <-0.988577, 0.000000, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.698924, -0.723006, -0.065433>, <-0.540318, -0.881613, -0.065433>, <0.000000, -0.988577, -0.065433>, <0.000000, -0.988577, -0.065433>, 
      <-0.700048, -0.724130, -0.084277>, <-0.541441, -0.882737, -0.084277>, <0.000000, -0.988577, -0.065433>, <0.000000, -0.988577, -0.065433>, 
      <-0.741718, -0.765800, -0.073373>, <-0.573034, -0.934483, -0.073373>, <0.000000, -1.050672, -0.054527>, <0.000000, -1.050672, -0.054527>, 
      <-0.742825, -0.766907, -0.054527>, <-0.574142, -0.935590, -0.054527>, <0.000000, -1.050672, -0.054527>, <0.000000, -1.050672, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.988577, 0.000000, 0.681592>, <-1.033449, 0.211614, 0.681592>, <-1.001418, 0.504587, 0.681592>, <-1.005090, 0.720875, 0.681592>, 
      <-0.980035, 0.000000, 0.457648>, <-1.024907, 0.211614, 0.457648>, <-0.992877, 0.504587, 0.457648>, <-0.996549, 0.720875, 0.457648>, 
      <-0.969740, 0.000000, 0.157882>, <-1.014611, 0.211614, 0.157882>, <-0.982584, 0.504587, 0.157882>, <-0.986255, 0.720875, 0.157882>, 
      <-0.988577, 0.000000, -0.065433>, <-1.033449, 0.211614, -0.065433>, <-1.001418, 0.504587, -0.065433>, <-1.005090, 0.720875, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.988577, 0.000000, -0.065433>, <-0.940109, -0.228578, -0.065433>, <-0.864147, -0.557783, -0.065433>, <-0.698924, -0.723006, -0.065433>, 
      <-0.990167, 0.000000, -0.084279>, <-0.941698, -0.228578, -0.084279>, <-0.865271, -0.558907, -0.084277>, <-0.700048, -0.724130, -0.084277>, 
      <-1.049105, 0.000000, -0.073376>, <-0.996297, -0.242227, -0.073376>, <-0.917021, -0.590496, -0.073373>, <-0.741718, -0.765800, -0.073373>, 
      <-1.050672, 0.000000, -0.054527>, <-0.997864, -0.242227, -0.054527>, <-0.918128, -0.591604, -0.054527>, <-0.742825, -0.766907, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.005090, 0.720875, 0.681592>, <-1.006372, 0.796394, 0.681592>, <-0.996682, 0.897582, 0.681592>, <-1.005090, 0.972643, 0.681592>, 
      <-0.996549, 0.720875, 0.457648>, <-0.997831, 0.796394, 0.457648>, <-0.988141, 0.897582, 0.457648>, <-0.996549, 0.972643, 0.457648>, 
      <-0.986255, 0.720875, 0.157882>, <-0.987538, 0.796394, 0.157882>, <-0.977847, 0.897582, 0.157882>, <-0.986255, 0.972643, 0.157882>, 
      <-1.005090, 0.720875, -0.065433>, <-1.006372, 0.796394, -0.065433>, <-0.996682, 0.897582, -0.065433>, <-1.005090, 0.972643, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.005090, 0.720875, -0.065433>, <-1.001418, 0.504587, -0.065433>, <-1.033449, 0.211614, -0.065433>, <-0.988577, 0.000000, -0.065433>, 
      <-1.006679, 0.720875, -0.084277>, <-1.003007, 0.504587, -0.084277>, <-1.035039, 0.211614, -0.084279>, <-0.990167, 0.000000, -0.084279>, 
      <-1.065609, 0.720875, -0.073373>, <-1.061939, 0.504587, -0.073373>, <-1.095182, 0.211355, -0.073376>, <-1.049105, 0.000000, -0.073376>, 
      <-1.067175, 0.720875, -0.054527>, <-1.063506, 0.504587, -0.054527>, <-1.096749, 0.211355, -0.054527>, <-1.050672, 0.000000, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.005090, 0.972643, 0.681592>, <-1.008870, 1.006387, 0.681592>, <-1.022605, 1.053109, 0.681592>, <-1.045150, 1.078499, 0.681592>, 
      <-0.996549, 0.972643, 0.457648>, <-1.000329, 1.006387, 0.457648>, <-1.016566, 1.059148, 0.457648>, <-1.039110, 1.084538, 0.457648>, 
      <-0.986255, 0.972643, 0.157882>, <-0.990035, 1.006387, 0.157882>, <-1.009287, 1.066426, 0.157882>, <-1.031832, 1.091817, 0.157882>, 
      <-1.005090, 0.972643, -0.065433>, <-1.008870, 1.006387, -0.065433>, <-1.022605, 1.053109, -0.065433>, <-1.045150, 1.078499, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.005090, 0.972643, -0.065433>, <-0.996682, 0.897582, -0.065433>, <-1.006372, 0.796394, -0.065433>, <-1.005090, 0.720875, -0.065433>, 
      <-1.006679, 0.972643, -0.084277>, <-0.998271, 0.897582, -0.084277>, <-1.007962, 0.796394, -0.084277>, <-1.006679, 0.720875, -0.084277>, 
      <-1.065609, 0.972643, -0.073373>, <-1.060355, 0.897296, -0.073373>, <-1.066891, 0.796394, -0.073373>, <-1.065609, 0.720875, -0.073373>, 
      <-1.067175, 0.972643, -0.054527>, <-1.061922, 0.897296, -0.054527>, <-1.068457, 0.796394, -0.054527>, <-1.067175, 0.720875, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.045150, 1.078499, -0.065433>, <-1.022605, 1.053109, -0.065433>, <-1.008870, 1.006387, -0.065433>, <-1.005090, 0.972643, -0.065433>, 
      <-1.046274, 1.077375, -0.084277>, <-1.023729, 1.051985, -0.084277>, <-1.010459, 1.006387, -0.084277>, <-1.006679, 0.972643, -0.084277>, 
      <-1.087943, 1.035705, -0.073373>, <-1.075601, 1.020337, -0.073373>, <-1.066980, 0.992306, -0.073373>, <-1.065609, 0.972643, -0.073373>, 
      <-1.089051, 1.034598, -0.054527>, <-1.076709, 1.019229, -0.054527>, <-1.068546, 0.992306, -0.054527>, <-1.067175, 0.972643, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.133009, 1.054623, 0.681592>, <-1.118527, 1.054090, 0.681592>, <-1.098124, 1.045897, 0.681592>, <-1.089051, 1.034598, 0.681592>, 
      <-1.133009, 1.045827, 0.460932>, <-1.118527, 1.045295, 0.460932>, <-1.104344, 1.039677, 0.460932>, <-1.095270, 1.028378, 0.460932>, 
      <-1.133009, 1.036332, 0.165550>, <-1.118527, 1.035800, 0.165550>, <-1.111058, 1.032963, 0.165550>, <-1.101984, 1.021664, 0.165550>, 
      <-1.133009, 1.054623, -0.054527>, <-1.118527, 1.054090, -0.054527>, <-1.098124, 1.045897, -0.054527>, <-1.089051, 1.034598, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.133009, 1.054623, -0.054527>, <-1.118527, 1.054090, -0.054527>, <-1.098124, 1.045897, -0.054527>, <-1.089051, 1.034598, -0.054527>, 
      <-1.133009, 1.056189, -0.073373>, <-1.118527, 1.055657, -0.073373>, <-1.097017, 1.047004, -0.073373>, <-1.087943, 1.035705, -0.073373>, 
      <-1.133009, 1.115119, -0.084277>, <-1.104327, 1.113257, -0.084277>, <-1.065357, 1.098868, -0.084277>, <-1.046274, 1.077375, -0.084277>, 
      <-1.133009, 1.116708, -0.065433>, <-1.104327, 1.114846, -0.065433>, <-1.064234, 1.099991, -0.065433>, <-1.045150, 1.078499, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.633537, 1.079768, 0.681592>, <-1.633537, 1.072224, 0.681592>, <-1.641071, 1.055001, 0.681592>, <-1.633537, 1.054623, 0.681592>, 
      <-1.633537, 1.078095, 0.460763>, <-1.633537, 1.070552, 0.460763>, <-1.641071, 1.046206, 0.460932>, <-1.633537, 1.045827, 0.460932>, 
      <-1.633537, 1.079768, 0.166309>, <-1.633537, 1.072224, 0.166309>, <-1.641071, 1.055001, 0.166309>, <-1.633537, 1.054623, 0.166309>, 
      <-1.633537, 1.079768, -0.054527>, <-1.633537, 1.072224, -0.054527>, <-1.641071, 1.055001, -0.054527>, <-1.633537, 1.054623, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.633537, 1.054623, 0.681592>, <-1.483567, 1.047089, 0.681592>, <-1.283066, 1.060142, 0.681592>, <-1.133009, 1.054623, 0.681592>, 
      <-1.633537, 1.045827, 0.460932>, <-1.483567, 1.038294, 0.460932>, <-1.283066, 1.051346, 0.460932>, <-1.133009, 1.045827, 0.460932>, 
      <-1.633537, 1.054623, 0.166309>, <-1.483567, 1.047089, 0.166309>, <-1.283066, 1.041851, 0.165550>, <-1.133009, 1.036332, 0.165550>, 
      <-1.633537, 1.054623, -0.054527>, <-1.483567, 1.047089, -0.054527>, <-1.283066, 1.060142, -0.054527>, <-1.133009, 1.054623, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.633537, 1.116708, 0.681592>, <-1.633537, 1.125249, 0.457648>, <-1.633537, 1.116708, 0.158675>, <-1.633537, 1.116708, -0.065433>, 
      <-1.641071, 1.116330, 0.681592>, <-1.641071, 1.124871, 0.457648>, <-1.641071, 1.116330, 0.158675>, <-1.641071, 1.116330, -0.065433>, 
      <-1.633537, 1.099107, 0.681592>, <-1.633537, 1.100731, 0.457491>, <-1.633537, 1.099107, 0.158675>, <-1.633537, 1.099107, -0.065433>, 
      <-1.633537, 1.091564, 0.681592>, <-1.633537, 1.093188, 0.457491>, <-1.633537, 1.091564, 0.158675>, <-1.633537, 1.091564, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.133009, 1.116708, 0.681592>, <-1.133009, 1.125249, 0.457648>, <-1.133009, 1.135543, 0.157882>, <-1.133009, 1.116708, -0.065433>, 
      <-1.282852, 1.126439, 0.681592>, <-1.282852, 1.134980, 0.457648>, <-1.282852, 1.145274, 0.157882>, <-1.282852, 1.126439, -0.065433>, 
      <-1.483567, 1.124242, 0.681592>, <-1.483567, 1.132783, 0.457648>, <-1.483567, 1.124242, 0.158675>, <-1.483567, 1.124242, -0.065433>, 
      <-1.633537, 1.116708, 0.681592>, <-1.633537, 1.125249, 0.457648>, <-1.633537, 1.116708, 0.158675>, <-1.633537, 1.116708, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.045150, 1.078499, 0.681592>, <-1.039110, 1.084538, 0.457648>, <-1.031832, 1.091817, 0.157882>, <-1.045150, 1.078499, -0.065433>, 
      <-1.064234, 1.099991, 0.681592>, <-1.058194, 1.106031, 0.457648>, <-1.050916, 1.113309, 0.157882>, <-1.064234, 1.099991, -0.065433>, 
      <-1.104327, 1.114846, 0.681592>, <-1.104327, 1.123387, 0.457648>, <-1.104327, 1.133681, 0.157882>, <-1.104327, 1.114846, -0.065433>, 
      <-1.133009, 1.116708, 0.681592>, <-1.133009, 1.125249, 0.457648>, <-1.133009, 1.135543, 0.157882>, <-1.133009, 1.116708, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.005090, 0.972643, 0.681592>, <-1.005805, 0.972643, 0.700332>, <-1.016906, 0.972643, 0.736120>, <-1.035660, 0.972643, 0.736120>, 
      <-1.008870, 1.006387, 0.681592>, <-1.009585, 1.006387, 0.700332>, <-1.019390, 0.999468, 0.736120>, <-1.038143, 0.999468, 0.736120>, 
      <-1.022605, 1.053109, 0.681592>, <-1.023111, 1.052603, 0.700332>, <-1.035966, 1.049695, 0.736120>, <-1.049227, 1.036434, 0.736120>, 
      <-1.045150, 1.078499, 0.681592>, <-1.045655, 1.077993, 0.700332>, <-1.053505, 1.070143, 0.736120>, <-1.066766, 1.056882, 0.736120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.005090, 0.720875, 0.681592>, <-1.005805, 0.720875, 0.700332>, <-1.016906, 0.720875, 0.736120>, <-1.035660, 0.720875, 0.736120>, 
      <-1.006372, 0.796394, 0.681592>, <-1.007087, 0.796394, 0.700332>, <-1.018188, 0.796394, 0.736120>, <-1.036942, 0.796394, 0.736120>, 
      <-0.996682, 0.897582, 0.681592>, <-0.997397, 0.897582, 0.700332>, <-1.009944, 0.897434, 0.736120>, <-1.028698, 0.897434, 0.736120>, 
      <-1.005090, 0.972643, 0.681592>, <-1.005805, 0.972643, 0.700332>, <-1.016906, 0.972643, 0.736120>, <-1.035660, 0.972643, 0.736120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.988577, 0.000000, 0.681592>, <-0.989292, 0.000000, 0.700333>, <-1.000398, 0.000000, 0.736120>, <-1.019152, 0.000000, 0.736120>, 
      <-1.033449, 0.211614, 0.681592>, <-1.034164, 0.211614, 0.700333>, <-1.045872, 0.211485, 0.736120>, <-1.064627, 0.211485, 0.736120>, 
      <-1.001418, 0.504587, 0.681592>, <-1.002133, 0.504587, 0.700332>, <-1.013235, 0.504587, 0.736120>, <-1.031989, 0.504587, 0.736120>, 
      <-1.005090, 0.720875, 0.681592>, <-1.005805, 0.720875, 0.700332>, <-1.016906, 0.720875, 0.736120>, <-1.035660, 0.720875, 0.736120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.698924, -0.723006, 0.681592>, <-0.699430, -0.723512, 0.700332>, <-0.707279, -0.731362, 0.736120>, <-0.720540, -0.744623, 0.736120>, 
      <-0.864147, -0.557783, 0.681592>, <-0.864653, -0.558289, 0.700332>, <-0.877466, -0.561175, 0.736120>, <-0.890727, -0.574436, 0.736120>, 
      <-0.940109, -0.228578, 0.681592>, <-0.940824, -0.228578, 0.700333>, <-0.949802, -0.235302, 0.736120>, <-0.968556, -0.235302, 0.736120>, 
      <-0.988577, 0.000000, 0.681592>, <-0.989292, 0.000000, 0.700333>, <-1.000398, 0.000000, 0.736120>, <-1.019152, 0.000000, 0.736120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.988577, 0.681592>, <0.000000, -0.980035, 0.457648>, <0.000000, -0.988577, -0.065433>, <0.000000, -0.988577, -0.065433>, 
      <-0.224303, -0.988577, 0.681592>, <-0.224303, -0.980035, 0.457648>, <0.000000, -0.988577, -0.065433>, <0.000000, -0.988577, -0.065433>, 
      <-0.540318, -0.881613, 0.681592>, <-0.534278, -0.875574, 0.457648>, <-0.526999, -0.868295, 0.157882>, <-0.540318, -0.881613, -0.065433>, 
      <-0.698924, -0.723006, 0.681592>, <-0.692885, -0.716967, 0.457648>, <-0.685606, -0.709688, 0.157882>, <-0.698924, -0.723006, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.988577, 0.681592>, <0.000000, -0.989292, 0.700333>, <0.000000, -1.000398, 0.736120>, <0.000000, -1.019152, 0.736120>, 
      <-0.224303, -0.988577, 0.681592>, <-0.224303, -0.989292, 0.700333>, <-0.231320, -1.000398, 0.736120>, <-0.231320, -1.019152, 0.736120>, 
      <-0.540318, -0.881613, 0.681592>, <-0.540823, -0.882118, 0.700332>, <-0.543712, -0.894930, 0.736120>, <-0.556972, -0.908191, 0.736120>, 
      <-0.698924, -0.723006, 0.681592>, <-0.699430, -0.723512, 0.700332>, <-0.707279, -0.731362, 0.736120>, <-0.720540, -0.744623, 0.736120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.698924, -0.723006, 0.681592>, <0.692885, -0.716967, 0.457648>, <0.685606, -0.709688, 0.157882>, <0.698924, -0.723006, -0.065433>, 
      <0.540318, -0.881613, 0.681592>, <0.534278, -0.875574, 0.457648>, <0.526999, -0.868295, 0.157882>, <0.540318, -0.881613, -0.065433>, 
      <0.224303, -0.988577, 0.681592>, <0.224303, -0.980035, 0.457648>, <0.000000, -0.988577, -0.065433>, <0.000000, -0.988577, -0.065433>, 
      <0.000000, -0.988577, 0.681592>, <0.000000, -0.980035, 0.457648>, <0.000000, -0.988577, -0.065433>, <0.000000, -0.988577, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988577, 0.000000, 0.681592>, <0.989292, 0.000000, 0.700333>, <1.000398, 0.000000, 0.736120>, <1.019152, 0.000000, 0.736120>, 
      <0.940109, -0.228578, 0.681592>, <0.940824, -0.228578, 0.700333>, <0.949802, -0.235302, 0.736120>, <0.968556, -0.235302, 0.736120>, 
      <0.864147, -0.557783, 0.681592>, <0.864653, -0.558289, 0.700332>, <0.877466, -0.561175, 0.736120>, <0.890727, -0.574436, 0.736120>, 
      <0.698924, -0.723006, 0.681592>, <0.699430, -0.723512, 0.700332>, <0.707279, -0.731362, 0.736120>, <0.720540, -0.744623, 0.736120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.005090, 0.720875, 0.681592>, <1.005805, 0.720875, 0.700332>, <1.016906, 0.720875, 0.736120>, <1.035660, 0.720875, 0.736120>, 
      <1.001418, 0.504587, 0.681592>, <1.002133, 0.504587, 0.700332>, <1.013235, 0.504587, 0.736120>, <1.031989, 0.504587, 0.736120>, 
      <1.033449, 0.211614, 0.681592>, <1.034164, 0.211614, 0.700333>, <1.045872, 0.211485, 0.736120>, <1.064627, 0.211485, 0.736120>, 
      <0.988577, 0.000000, 0.681592>, <0.989292, 0.000000, 0.700333>, <1.000398, 0.000000, 0.736120>, <1.019152, 0.000000, 0.736120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.005090, 0.972643, 0.681592>, <1.005805, 0.972643, 0.700332>, <1.016906, 0.972643, 0.736120>, <1.035660, 0.972643, 0.736120>, 
      <0.996682, 0.897582, 0.681592>, <0.997397, 0.897582, 0.700332>, <1.009944, 0.897434, 0.736120>, <1.028698, 0.897434, 0.736120>, 
      <1.006372, 0.796394, 0.681592>, <1.007087, 0.796394, 0.700332>, <1.018188, 0.796394, 0.736120>, <1.036942, 0.796394, 0.736120>, 
      <1.005090, 0.720875, 0.681592>, <1.005805, 0.720875, 0.700332>, <1.016906, 0.720875, 0.736120>, <1.035660, 0.720875, 0.736120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.045150, 1.078499, 0.681592>, <1.045655, 1.077993, 0.700332>, <1.053505, 1.070143, 0.736120>, <1.066766, 1.056882, 0.736120>, 
      <1.022605, 1.053109, 0.681592>, <1.023111, 1.052603, 0.700332>, <1.035966, 1.049695, 0.736120>, <1.049227, 1.036434, 0.736120>, 
      <1.008870, 1.006387, 0.681592>, <1.009585, 1.006387, 0.700332>, <1.019390, 0.999468, 0.736120>, <1.038143, 0.999468, 0.736120>, 
      <1.005090, 0.972643, 0.681592>, <1.005805, 0.972643, 0.700332>, <1.016906, 0.972643, 0.736120>, <1.035660, 0.972643, 0.736120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.133009, 1.116708, 0.681592>, <1.133009, 1.115994, 0.700332>, <1.133009, 1.104892, 0.736120>, <1.133009, 1.086138, 0.736120>, 
      <1.104327, 1.114846, 0.681592>, <1.104327, 1.114131, 0.700332>, <1.111313, 1.103772, 0.736120>, <1.111313, 1.085018, 0.736120>, 
      <1.064234, 1.099991, 0.681592>, <1.064739, 1.099486, 0.700332>, <1.067649, 1.086633, 0.736120>, <1.080910, 1.073372, 0.736120>, 
      <1.045150, 1.078499, 0.681592>, <1.045655, 1.077993, 0.700332>, <1.053505, 1.070143, 0.736120>, <1.066766, 1.056882, 0.736120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.633537, 1.116708, 0.681592>, <1.633537, 1.125249, 0.457648>, <1.633537, 1.116708, 0.158675>, <1.633537, 1.116708, -0.065433>, 
      <1.483567, 1.124242, 0.681592>, <1.483567, 1.132783, 0.457648>, <1.483567, 1.124242, 0.158675>, <1.483567, 1.124242, -0.065433>, 
      <1.282852, 1.126439, 0.681592>, <1.282852, 1.134980, 0.457648>, <1.282852, 1.145274, 0.157882>, <1.282852, 1.126439, -0.065433>, 
      <1.133009, 1.116708, 0.681592>, <1.133009, 1.125249, 0.457648>, <1.133009, 1.135543, 0.157882>, <1.133009, 1.116708, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.633537, 1.091564, 0.681592>, <1.633537, 1.093188, 0.457491>, <1.633537, 1.091564, 0.158675>, <1.633537, 1.091564, -0.065433>, 
      <1.633537, 1.099107, 0.681592>, <1.633537, 1.100731, 0.457491>, <1.633537, 1.099107, 0.158675>, <1.633537, 1.099107, -0.065433>, 
      <1.641071, 1.116330, 0.681592>, <1.641071, 1.124871, 0.457648>, <1.641071, 1.116330, 0.158675>, <1.641071, 1.116330, -0.065433>, 
      <1.633537, 1.116708, 0.681592>, <1.633537, 1.125249, 0.457648>, <1.633537, 1.116708, 0.158675>, <1.633537, 1.116708, -0.065433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.633537, 1.086138, 0.736120>, <-1.633537, 1.104892, 0.736120>, <-1.633537, 1.115994, 0.700332>, <-1.633537, 1.116708, 0.681592>, 
      <-1.633651, 1.086138, 0.736120>, <-1.633651, 1.104892, 0.736120>, <-1.641071, 1.115615, 0.700332>, <-1.641071, 1.116330, 0.681592>, 
      <-1.633537, 1.085870, 0.736120>, <-1.633537, 1.102321, 0.736120>, <-1.633537, 1.098988, 0.698043>, <-1.633537, 1.099107, 0.681592>, 
      <-1.633537, 1.085756, 0.736120>, <-1.633537, 1.102206, 0.736120>, <-1.633537, 1.091445, 0.698043>, <-1.633537, 1.091564, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.133009, 1.086138, 0.736120>, <-1.133009, 1.104892, 0.736120>, <-1.133009, 1.115994, 0.700332>, <-1.133009, 1.116708, 0.681592>, 
      <-1.282968, 1.093879, 0.736120>, <-1.282968, 1.112633, 0.736120>, <-1.282852, 1.125725, 0.700332>, <-1.282852, 1.126439, 0.681592>, 
      <-1.483378, 1.086253, 0.736120>, <-1.483378, 1.105007, 0.736120>, <-1.483567, 1.123528, 0.700332>, <-1.483567, 1.124242, 0.681592>, 
      <-1.633537, 1.086138, 0.736120>, <-1.633537, 1.104892, 0.736120>, <-1.633537, 1.115994, 0.700332>, <-1.633537, 1.116708, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.066766, 1.056882, 0.736120>, <-1.053505, 1.070143, 0.736120>, <-1.045655, 1.077993, 0.700332>, <-1.045150, 1.078499, 0.681592>, 
      <-1.080910, 1.073372, 0.736120>, <-1.067649, 1.086633, 0.736120>, <-1.064739, 1.099486, 0.700332>, <-1.064234, 1.099991, 0.681592>, 
      <-1.111313, 1.085018, 0.736120>, <-1.111313, 1.103772, 0.736120>, <-1.104327, 1.114131, 0.700332>, <-1.104327, 1.114846, 0.681592>, 
      <-1.133009, 1.086138, 0.736120>, <-1.133009, 1.104892, 0.736120>, <-1.133009, 1.115994, 0.700332>, <-1.133009, 1.116708, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.035660, 0.972643, 0.736120>, <-1.054554, 0.972643, 0.736120>, <-1.066423, 0.972643, 0.700471>, <-1.067175, 0.972643, 0.681592>, 
      <-1.038143, 0.999468, 0.736120>, <-1.057037, 0.999468, 0.736120>, <-1.067794, 0.992306, 0.700471>, <-1.068546, 0.992306, 0.681592>, 
      <-1.049227, 1.036434, 0.736120>, <-1.062587, 1.023074, 0.736120>, <-1.076177, 1.019761, 0.700471>, <-1.076709, 1.019229, 0.681592>, 
      <-1.066766, 1.056882, 0.736120>, <-1.080126, 1.043522, 0.736120>, <-1.088519, 1.035130, 0.700471>, <-1.089051, 1.034598, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.035660, 0.720875, 0.736120>, <-1.054554, 0.720875, 0.736120>, <-1.066423, 0.720875, 0.700471>, <-1.067175, 0.720875, 0.681592>, 
      <-1.036942, 0.796394, 0.736120>, <-1.055836, 0.796394, 0.736120>, <-1.067704, 0.796394, 0.700471>, <-1.068457, 0.796394, 0.681592>, 
      <-1.028698, 0.897434, 0.736120>, <-1.047591, 0.897434, 0.736120>, <-1.061169, 0.897296, 0.700471>, <-1.061922, 0.897296, 0.681592>, 
      <-1.035660, 0.972643, 0.736120>, <-1.054554, 0.972643, 0.736120>, <-1.066423, 0.972643, 0.700471>, <-1.067175, 0.972643, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.019152, 0.000000, 0.736120>, <-1.038047, 0.000000, 0.736120>, <-1.049919, 0.000000, 0.700472>, <-1.050672, 0.000000, 0.681592>, 
      <-1.064627, 0.211485, 0.736120>, <-1.083521, 0.211485, 0.736120>, <-1.095997, 0.211355, 0.700472>, <-1.096749, 0.211355, 0.681592>, 
      <-1.031989, 0.504587, 0.736120>, <-1.050883, 0.504587, 0.736120>, <-1.062753, 0.504587, 0.700471>, <-1.063506, 0.504587, 0.681592>, 
      <-1.035660, 0.720875, 0.736120>, <-1.054554, 0.720875, 0.736120>, <-1.066423, 0.720875, 0.700471>, <-1.067175, 0.720875, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.720540, -0.744623, 0.736120>, <-0.733900, -0.757983, 0.736120>, <-0.742293, -0.766375, 0.700471>, <-0.742825, -0.766907, 0.681592>, 
      <-0.890727, -0.574436, 0.736120>, <-0.904087, -0.587796, 0.736120>, <-0.917596, -0.591072, 0.700471>, <-0.918128, -0.591604, 0.681592>, 
      <-0.968556, -0.235302, 0.736120>, <-0.987451, -0.235302, 0.736120>, <-0.997112, -0.242227, 0.700472>, <-0.997864, -0.242227, 0.681592>, 
      <-1.019152, 0.000000, 0.736120>, <-1.038047, 0.000000, 0.736120>, <-1.049919, 0.000000, 0.700472>, <-1.050672, 0.000000, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.019152, 0.736120>, <0.000000, -1.038047, 0.736120>, <0.000000, -1.049919, 0.700472>, <0.000000, -1.050672, 0.681592>, 
      <-0.231320, -1.019152, 0.736120>, <-0.231320, -1.038047, 0.736120>, <-0.238554, -1.049919, 0.700472>, <-0.238554, -1.050672, 0.681592>, 
      <-0.556972, -0.908191, 0.736120>, <-0.570332, -0.921551, 0.736120>, <-0.573610, -0.935058, 0.700471>, <-0.574142, -0.935590, 0.681592>, 
      <-0.720540, -0.744623, 0.736120>, <-0.733900, -0.757983, 0.736120>, <-0.742293, -0.766375, 0.700471>, <-0.742825, -0.766907, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.720540, -0.744623, 0.736120>, <0.707279, -0.731362, 0.736120>, <0.699430, -0.723512, 0.700332>, <0.698924, -0.723006, 0.681592>, 
      <0.556972, -0.908191, 0.736120>, <0.543712, -0.894930, 0.736120>, <0.540823, -0.882118, 0.700332>, <0.540318, -0.881613, 0.681592>, 
      <0.231320, -1.019152, 0.736120>, <0.231320, -1.000398, 0.736120>, <0.224303, -0.989292, 0.700333>, <0.224303, -0.988577, 0.681592>, 
      <0.000000, -1.019152, 0.736120>, <0.000000, -1.000398, 0.736120>, <0.000000, -0.989292, 0.700333>, <0.000000, -0.988577, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.019152, 0.000000, 0.736120>, <1.038047, 0.000000, 0.736120>, <1.049919, 0.000000, 0.700472>, <1.050672, 0.000000, 0.681592>, 
      <0.968556, -0.235302, 0.736120>, <0.987451, -0.235302, 0.736120>, <0.997112, -0.242227, 0.700472>, <0.997864, -0.242227, 0.681592>, 
      <0.890727, -0.574436, 0.736120>, <0.904087, -0.587796, 0.736120>, <0.917596, -0.591072, 0.700471>, <0.918128, -0.591604, 0.681592>, 
      <0.720540, -0.744623, 0.736120>, <0.733900, -0.757983, 0.736120>, <0.742293, -0.766375, 0.700471>, <0.742825, -0.766907, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.035660, 0.720875, 0.736120>, <1.054554, 0.720875, 0.736120>, <1.066423, 0.720875, 0.700471>, <1.067175, 0.720875, 0.681592>, 
      <1.031989, 0.504587, 0.736120>, <1.050883, 0.504587, 0.736120>, <1.062753, 0.504587, 0.700471>, <1.063506, 0.504587, 0.681592>, 
      <1.064627, 0.211485, 0.736120>, <1.083521, 0.211485, 0.736120>, <1.095997, 0.211355, 0.700472>, <1.096749, 0.211355, 0.681592>, 
      <1.019152, 0.000000, 0.736120>, <1.038047, 0.000000, 0.736120>, <1.049919, 0.000000, 0.700472>, <1.050672, 0.000000, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.035660, 0.972643, 0.736120>, <1.054554, 0.972643, 0.736120>, <1.066423, 0.972643, 0.700471>, <1.067175, 0.972643, 0.681592>, 
      <1.028698, 0.897434, 0.736120>, <1.047591, 0.897434, 0.736120>, <1.061169, 0.897296, 0.700471>, <1.061922, 0.897296, 0.681592>, 
      <1.036942, 0.796394, 0.736120>, <1.055836, 0.796394, 0.736120>, <1.067704, 0.796394, 0.700471>, <1.068457, 0.796394, 0.681592>, 
      <1.035660, 0.720875, 0.736120>, <1.054554, 0.720875, 0.736120>, <1.066423, 0.720875, 0.700471>, <1.067175, 0.720875, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.066766, 1.056882, 0.736120>, <1.080126, 1.043522, 0.736120>, <1.088519, 1.035130, 0.700471>, <1.089051, 1.034598, 0.681592>, 
      <1.049227, 1.036434, 0.736120>, <1.062587, 1.023074, 0.736120>, <1.076177, 1.019761, 0.700471>, <1.076709, 1.019229, 0.681592>, 
      <1.038143, 0.999468, 0.736120>, <1.057037, 0.999468, 0.736120>, <1.067794, 0.992306, 0.700471>, <1.068546, 0.992306, 0.681592>, 
      <1.035660, 0.972643, 0.736120>, <1.054554, 0.972643, 0.736120>, <1.066423, 0.972643, 0.700471>, <1.067175, 0.972643, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.133009, 1.086138, 0.736120>, <1.133009, 1.067244, 0.736120>, <1.133009, 1.055376, 0.700471>, <1.133009, 1.054623, 0.681592>, 
      <1.111313, 1.085018, 0.736120>, <1.111313, 1.066124, 0.736120>, <1.118527, 1.054843, 0.700471>, <1.118527, 1.054090, 0.681592>, 
      <1.080910, 1.073372, 0.736120>, <1.094270, 1.060012, 0.736120>, <1.097592, 1.046429, 0.700471>, <1.098124, 1.045897, 0.681592>, 
      <1.066766, 1.056882, 0.736120>, <1.080126, 1.043522, 0.736120>, <1.088519, 1.035130, 0.700471>, <1.089051, 1.034598, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.633537, 1.086138, 0.736120>, <1.633537, 1.104892, 0.736120>, <1.633537, 1.115994, 0.700332>, <1.633537, 1.116708, 0.681592>, 
      <1.483378, 1.086253, 0.736120>, <1.483378, 1.105007, 0.736120>, <1.483567, 1.123528, 0.700332>, <1.483567, 1.124242, 0.681592>, 
      <1.282968, 1.093879, 0.736120>, <1.282968, 1.112633, 0.736120>, <1.282852, 1.125725, 0.700332>, <1.282852, 1.126439, 0.681592>, 
      <1.133009, 1.086138, 0.736120>, <1.133009, 1.104892, 0.736120>, <1.133009, 1.115994, 0.700332>, <1.133009, 1.116708, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.633537, 1.085756, 0.736120>, <1.633537, 1.102206, 0.736120>, <1.633537, 1.091445, 0.698043>, <1.633537, 1.091564, 0.681592>, 
      <1.633537, 1.085870, 0.736120>, <1.633537, 1.102321, 0.736120>, <1.633537, 1.098988, 0.698043>, <1.633537, 1.099107, 0.681592>, 
      <1.633651, 1.086138, 0.736120>, <1.633651, 1.104892, 0.736120>, <1.641071, 1.115615, 0.700332>, <1.641071, 1.116330, 0.681592>, 
      <1.633537, 1.086138, 0.736120>, <1.633537, 1.104892, 0.736120>, <1.633537, 1.115994, 0.700332>, <1.633537, 1.116708, 0.681592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.633537, 1.054623, 0.681592>, <-1.633537, 1.055376, 0.700471>, <-1.633537, 1.067244, 0.736120>, <-1.633537, 1.086138, 0.736120>, 
      <-1.641071, 1.055001, 0.681592>, <-1.641071, 1.055754, 0.700471>, <-1.633651, 1.067244, 0.736120>, <-1.633651, 1.086138, 0.736120>, 
      <-1.633537, 1.072224, 0.681592>, <-1.633537, 1.072349, 0.698048>, <-1.633537, 1.069414, 0.736120>, <-1.633537, 1.085870, 0.736120>, 
      <-1.633537, 1.079768, 0.681592>, <-1.633537, 1.079892, 0.698048>, <-1.633537, 1.069299, 0.736120>, <-1.633537, 1.085756, 0.736120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.133009, 1.054623, 0.681592>, <-1.133009, 1.055376, 0.700471>, <-1.133009, 1.067244, 0.736120>, <-1.133009, 1.086138, 0.736120>, 
      <-1.283066, 1.060142, 0.681592>, <-1.283066, 1.060895, 0.700471>, <-1.282968, 1.074985, 0.736120>, <-1.282968, 1.093879, 0.736120>, 
      <-1.483567, 1.047089, 0.681592>, <-1.483567, 1.047842, 0.700471>, <-1.483378, 1.067359, 0.736120>, <-1.483378, 1.086253, 0.736120>, 
      <-1.633537, 1.054623, 0.681592>, <-1.633537, 1.055376, 0.700471>, <-1.633537, 1.067244, 0.736120>, <-1.633537, 1.086138, 0.736120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.089051, 1.034598, 0.681592>, <-1.088519, 1.035130, 0.700471>, <-1.080126, 1.043522, 0.736120>, <-1.066766, 1.056882, 0.736120>, 
      <-1.098124, 1.045897, 0.681592>, <-1.097592, 1.046429, 0.700471>, <-1.094270, 1.060012, 0.736120>, <-1.080910, 1.073372, 0.736120>, 
      <-1.118527, 1.054090, 0.681592>, <-1.118527, 1.054843, 0.700471>, <-1.111313, 1.066124, 0.736120>, <-1.111313, 1.085018, 0.736120>, 
      <-1.133009, 1.054623, 0.681592>, <-1.133009, 1.055376, 0.700471>, <-1.133009, 1.067244, 0.736120>, <-1.133009, 1.086138, 0.736120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.067175, 0.972643, 0.681592>, <-1.075971, 0.972643, 0.460932>, <-1.085466, 0.972643, 0.165550>, <-1.067175, 0.972643, -0.054527>, 
      <-1.068546, 0.992306, 0.681592>, <-1.077342, 0.992306, 0.460932>, <-1.086837, 0.992306, 0.165550>, <-1.068546, 0.992306, -0.054527>, 
      <-1.076709, 1.019229, 0.681592>, <-1.082928, 1.013009, 0.460932>, <-1.089642, 1.006295, 0.165550>, <-1.076709, 1.019229, -0.054527>, 
      <-1.089051, 1.034598, 0.681592>, <-1.095270, 1.028378, 0.460932>, <-1.101984, 1.021664, 0.165550>, <-1.089051, 1.034598, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.067175, 0.720875, 0.681592>, <-1.075971, 0.720875, 0.460932>, <-1.085466, 0.720875, 0.165550>, <-1.067175, 0.720875, -0.054527>, 
      <-1.068457, 0.796394, 0.681592>, <-1.077252, 0.796394, 0.460932>, <-1.086747, 0.796394, 0.165550>, <-1.068457, 0.796394, -0.054527>, 
      <-1.061922, 0.897296, 0.681592>, <-1.070717, 0.897296, 0.460932>, <-1.080212, 0.897296, 0.165550>, <-1.061922, 0.897296, -0.054527>, 
      <-1.067175, 0.972643, 0.681592>, <-1.075971, 0.972643, 0.460932>, <-1.085466, 0.972643, 0.165550>, <-1.067175, 0.972643, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.050672, 0.000000, 0.681592>, <-1.059469, 0.000000, 0.460932>, <-1.068965, 0.000000, 0.165550>, <-1.050672, 0.000000, -0.054527>, 
      <-1.096749, 0.211355, 0.681592>, <-1.105546, 0.211355, 0.460932>, <-1.115043, 0.211355, 0.165550>, <-1.096749, 0.211355, -0.054527>, 
      <-1.063506, 0.504587, 0.681592>, <-1.072301, 0.504587, 0.460932>, <-1.081796, 0.504587, 0.165550>, <-1.063506, 0.504587, -0.054527>, 
      <-1.067175, 0.720875, 0.681592>, <-1.075971, 0.720875, 0.460932>, <-1.085466, 0.720875, 0.165550>, <-1.067175, 0.720875, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.742825, -0.766907, 0.681592>, <-0.749045, -0.773127, 0.460932>, <-0.755759, -0.779841, 0.165550>, <-0.742825, -0.766907, -0.054527>, 
      <-0.918128, -0.591604, 0.681592>, <-0.924348, -0.597823, 0.460932>, <-0.931062, -0.604537, 0.165550>, <-0.918128, -0.591604, -0.054527>, 
      <-0.997864, -0.242227, 0.681592>, <-1.006661, -0.242227, 0.460932>, <-1.016158, -0.242227, 0.165550>, <-0.997864, -0.242227, -0.054527>, 
      <-1.050672, 0.000000, 0.681592>, <-1.059469, 0.000000, 0.460932>, <-1.068965, 0.000000, 0.165550>, <-1.050672, 0.000000, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.050672, 0.681592>, <0.000000, -1.059469, 0.460932>, <0.000000, -1.050672, -0.054527>, <0.000000, -1.050672, -0.054527>, 
      <-0.238554, -1.050672, 0.681592>, <-0.238554, -1.059469, 0.460932>, <0.000000, -1.050672, -0.054527>, <0.000000, -1.050672, -0.054527>, 
      <-0.574142, -0.935590, 0.681592>, <-0.580361, -0.941810, 0.460932>, <-0.587075, -0.948524, 0.165550>, <-0.574142, -0.935590, -0.054527>, 
      <-0.742825, -0.766907, 0.681592>, <-0.749045, -0.773127, 0.460932>, <-0.755759, -0.779841, 0.165550>, <-0.742825, -0.766907, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.742825, -0.766907, 0.681592>, <0.749045, -0.773127, 0.460932>, <0.755759, -0.779841, 0.165550>, <0.742825, -0.766907, -0.054527>, 
      <0.574142, -0.935590, 0.681592>, <0.580361, -0.941810, 0.460932>, <0.587075, -0.948524, 0.165550>, <0.574142, -0.935590, -0.054527>, 
      <0.238554, -1.050672, 0.681592>, <0.238554, -1.059469, 0.460932>, <0.000000, -1.050672, -0.054527>, <0.000000, -1.050672, -0.054527>, 
      <0.000000, -1.050672, 0.681592>, <0.000000, -1.059469, 0.460932>, <0.000000, -1.050672, -0.054527>, <0.000000, -1.050672, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.742825, -0.766907, 0.681592>, <0.742293, -0.766375, 0.700471>, <0.733900, -0.757983, 0.736120>, <0.720540, -0.744623, 0.736120>, 
      <0.574142, -0.935590, 0.681592>, <0.573610, -0.935058, 0.700471>, <0.570332, -0.921551, 0.736120>, <0.556972, -0.908191, 0.736120>, 
      <0.238554, -1.050672, 0.681592>, <0.238554, -1.049919, 0.700472>, <0.231320, -1.038047, 0.736120>, <0.231320, -1.019152, 0.736120>, 
      <0.000000, -1.050672, 0.681592>, <0.000000, -1.049919, 0.700472>, <0.000000, -1.038047, 0.736120>, <0.000000, -1.019152, 0.736120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.050672, 0.000000, 0.681592>, <1.059469, 0.000000, 0.460932>, <1.068965, 0.000000, 0.165550>, <1.050672, 0.000000, -0.054527>, 
      <0.997864, -0.242227, 0.681592>, <1.006661, -0.242227, 0.460932>, <1.016158, -0.242227, 0.165550>, <0.997864, -0.242227, -0.054527>, 
      <0.918128, -0.591604, 0.681592>, <0.924348, -0.597823, 0.460932>, <0.931062, -0.604537, 0.165550>, <0.918128, -0.591604, -0.054527>, 
      <0.742825, -0.766907, 0.681592>, <0.749045, -0.773127, 0.460932>, <0.755759, -0.779841, 0.165550>, <0.742825, -0.766907, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.067175, 0.720875, 0.681592>, <1.075971, 0.720875, 0.460932>, <1.085466, 0.720875, 0.165550>, <1.067175, 0.720875, -0.054527>, 
      <1.063506, 0.504587, 0.681592>, <1.072301, 0.504587, 0.460932>, <1.081796, 0.504587, 0.165550>, <1.063506, 0.504587, -0.054527>, 
      <1.096749, 0.211355, 0.681592>, <1.105546, 0.211355, 0.460932>, <1.115043, 0.211355, 0.165550>, <1.096749, 0.211355, -0.054527>, 
      <1.050672, 0.000000, 0.681592>, <1.059469, 0.000000, 0.460932>, <1.068965, 0.000000, 0.165550>, <1.050672, 0.000000, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.067175, 0.972643, 0.681592>, <1.075971, 0.972643, 0.460932>, <1.085466, 0.972643, 0.165550>, <1.067175, 0.972643, -0.054527>, 
      <1.061922, 0.897296, 0.681592>, <1.070717, 0.897296, 0.460932>, <1.080212, 0.897296, 0.165550>, <1.061922, 0.897296, -0.054527>, 
      <1.068457, 0.796394, 0.681592>, <1.077252, 0.796394, 0.460932>, <1.086747, 0.796394, 0.165550>, <1.068457, 0.796394, -0.054527>, 
      <1.067175, 0.720875, 0.681592>, <1.075971, 0.720875, 0.460932>, <1.085466, 0.720875, 0.165550>, <1.067175, 0.720875, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.089051, 1.034598, 0.681592>, <1.095270, 1.028378, 0.460932>, <1.101984, 1.021664, 0.165550>, <1.089051, 1.034598, -0.054527>, 
      <1.076709, 1.019229, 0.681592>, <1.082928, 1.013009, 0.460932>, <1.089642, 1.006295, 0.165550>, <1.076709, 1.019229, -0.054527>, 
      <1.068546, 0.992306, 0.681592>, <1.077342, 0.992306, 0.460932>, <1.086837, 0.992306, 0.165550>, <1.068546, 0.992306, -0.054527>, 
      <1.067175, 0.972643, 0.681592>, <1.075971, 0.972643, 0.460932>, <1.085466, 0.972643, 0.165550>, <1.067175, 0.972643, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.133009, 1.054623, 0.681592>, <1.133009, 1.045827, 0.460932>, <1.133009, 1.036332, 0.165550>, <1.133009, 1.054623, -0.054527>, 
      <1.118527, 1.054090, 0.681592>, <1.118527, 1.045295, 0.460932>, <1.118527, 1.035800, 0.165550>, <1.118527, 1.054090, -0.054527>, 
      <1.098124, 1.045897, 0.681592>, <1.104344, 1.039677, 0.460932>, <1.111058, 1.032963, 0.165550>, <1.098124, 1.045897, -0.054527>, 
      <1.089051, 1.034598, 0.681592>, <1.095270, 1.028378, 0.460932>, <1.101984, 1.021664, 0.165550>, <1.089051, 1.034598, -0.054527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.633537, 1.054623, 0.681592>, <1.633537, 1.055376, 0.700471>, <1.633537, 1.067244, 0.736120>, <1.633537, 1.086138, 0.736120>, 
      <1.483567, 1.047089, 0.681592>, <1.483567, 1.047842, 0.700471>, <1.483378, 1.067359, 0.736120>, <1.483378, 1.086253, 0.736120>, 
      <1.283066, 1.060142, 0.681592>, <1.283066, 1.060895, 0.700471>, <1.282968, 1.074985, 0.736120>, <1.282968, 1.093879, 0.736120>, 
      <1.133009, 1.054623, 0.681592>, <1.133009, 1.055376, 0.700471>, <1.133009, 1.067244, 0.736120>, <1.133009, 1.086138, 0.736120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.633537, 1.079768, 0.681592>, <1.633537, 1.079892, 0.698048>, <1.633537, 1.069299, 0.736120>, <1.633537, 1.085756, 0.736120>, 
      <1.633537, 1.072224, 0.681592>, <1.633537, 1.072349, 0.698048>, <1.633537, 1.069414, 0.736120>, <1.633537, 1.085870, 0.736120>, 
      <1.641071, 1.055001, 0.681592>, <1.641071, 1.055754, 0.700471>, <1.633651, 1.067244, 0.736120>, <1.633651, 1.086138, 0.736120>, 
      <1.633537, 1.054623, 0.681592>, <1.633537, 1.055376, 0.700471>, <1.633537, 1.067244, 0.736120>, <1.633537, 1.086138, 0.736120>
    }
  }
}
#declare abrazadera1 = union {
  object { abrazadera_base }
  sphere { // Sphere013
    <0,0,0>,1
    scale <0.2, 0.075, 0.2>
    translate  <1.368858, 1.012184, 0.308466>
  }
  sphere { // Sphere014
    <0,0,0>,1
    scale <0.2, 0.075, 0.2>
    translate  <-1.36886, 1.012184, 0.308466>
  }
  material {
    Negativ4
  }
}

//
// ********  OBJECTS  *******
//

difference { // base_arbol
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.2>
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    scale 0.5
    translate  -0.25*z
  }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.025, 0.3>
  }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 1.2, 0.3>
  }
  material {
    T_Stone44
  }
  scale 1.75
  translate  <2.33546, 18.501287, 0.0>
}


#include "colors.inc"
#include "txttree.inc"
#include "maketree.pov" // tree & leaf macro
#declare dofile   = false;
#declare dotexture   = true;
#declare ftname="KHTree.inc" // file name for tree
#declare fvname="KHFoliage.inc" // file name for foliage
#declare ffname="KHLeaf.inc" // file name for leaf
#declare txtTree=texture{txtTree_3} // Bark texture
#declare rsd           = 1433.000;
#declare rd=seed(rsd);
#declare rdl=seed(rsd);
#declare level0  = 5.000;
#declare nseg0 = 15.000;
#declare dotop   = true;
#declare nb			= 3.000;
#declare lb0			= 15.000;
#declare rb0        = 1.400;
#declare ab0			= 35.000;
#declare qlb			= 0.670;
#declare qrb			= 0.590;
#declare qab			= 0.880;
#declare stdax		= 10.000;
#declare stday		= 10.000;
#declare branchproba= 1.000;
#declare jb			= 0.700;
#declare fgnarl		= 0.250;
#declare stdlseg		= 0.500;
#declare twigproba  = 0.590;
#declare v0			= <0.000,1.000,0.000>;
#declare pos0			= <0.000,0.000,0.000>;
#declare vpush		= <0.000,-1.000,0.000>;
#declare fpush		= 0.200;
#declare aboveground= 0.000;
#declare belowsky   = 140.000;
#declare rootproba  = 0.000;
#declare nroot		= 0.000;
#declare vroot		= <0.000,0.000,0.000>;
#declare yroot		= <0.000,0.500,0.000>;
#declare leafproba  = 0.800;
#declare leaflevel  = 4.000;
#declare alz0			= 100.000;
#declare alx0			= -10.000;
#declare stdalx		= 40.000;
#declare stdlsize   = 0.100;
#declare txtLeaf		= texture{txtLeaf_0}
#declare lsize		= 0.300;
#declare seg			= 10.000;
#declare ll			= 5.000;
#declare wl			= 1.200;
#declare fl			= 0.500;
#declare lpow			= 1.000;
#declare al			= 100.000;
#declare apow			= 1.000;
#declare ndents		= 0.000;
#declare nlobes		= 3.000;
#declare alobes		= 110.000;
#declare qlobes		= 0.700;
#declare ls			= 3.000;
#declare ws			= 0.120;
#declare as			= 10.000;
		object{
        #if (leafproba>0)
        #declare Leaf=object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
                 ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)
                 #if (dotexture=false)  // no texture applied to tree segments, so the leaf texture must be used for the individual leaf
                        texture{txtLeaf}
                 #end
        } 
        #end
        MakeTree()
        #if (dotexture = true) // texture is already applied to tree so that we can safely apply the leaf texture to the leaves
                texture {txtLeaf}
        #else
                texture {txtTree} // apply tree texture  regardless of the tree structure
        #end
			scale <0.500,0.500,0.500>
			rotate <90.000,0.000,90.000>
			translate <2.352,18.500,0.315>
}


#declare columnas_suma = union {
  object { Cylndr001 }
  object { // Cylndr002 -> Cylndr001
    Cylndr001
    rotate -90.0*z
  }
  object { // Cylndr003 -> Cylndr001
    Cylndr001
    rotate -180.0*z
  }
  object { // Cylndr004 -> Cylndr001
    Cylndr001
    rotate 90.0*z
  }
}
#declare resta_columna = union {
  object { Cylndr005 }
  object { // Cylndr006 -> Cylndr005
    Cylndr005
    rotate -90.0*z
  }
  object { // Cylndr007 -> Cylndr005
    Cylndr005
    rotate -180.0*z
  }
  object { // Cylndr008 -> Cylndr005
    Cylndr005
    rotate 90.0*z
  }
  material {
    negro_txt
  }
}
#declare columnas = difference {
  object { columnas_suma }
  object { resta_columna }
}
#declare hueco_puerta = difference {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.0, 5.0>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.7, 4.75>
    translate  -0.296146*z
  }
  rotate -90.0*z
  translate  -2.1*y
}
#declare cabina_base = union {
  object { panel_cabina_1 }
  object { // panel_cabina_2 -> panel_cabina 1
    panel_cabina_1
    rotate -90.0*z
  }
  object { // panel_cabina_3 -> panel_cabina 1
    panel_cabina_1
    rotate -180.0*z
  }
  object { hueco_puerta }
}
#declare hueco_puerta1 = difference {
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.0, 5.0>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.7, 4.75>
    translate  -0.296146*z
  }
  scale <1.111111, 1.111111, 1.025641>
  rotate <0.0, 0.0, 0.0>
  translate  <-0.033857, -0.008193, 0.217858>
}
#declare cristales_puerta1 = union {
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.7, 2.0>
    rotate -90.0*z
    translate  <-1.8, 0.089408, 2.287698>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.685, 2.0>
    rotate -90.0*z
    translate  <-1.8, 0.089408, -2.574809>
  }
  material {
    cristal_cabinaold_txt
  }
  scale <1.11, 1.01, 1.03>
  rotate -90.0*z
  translate  <-0.094367, -2.000796, 0.151938>
}
#declare puerta_base = difference {
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.0, 5.0>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.7, 2.0>
    translate  2.5*z
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.7, 2.0>
    translate  -2.5*z
  }
  object { hueco_puerta1 }
  object { cristales_puerta1 }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <2.333333, 0.111111, 0.102564>
    rotate <-0.0, 0.0, 90.0>
    translate  <-0.00057, -0.008193, -5.005981>
  }
  scale <0.9, 0.9, 0.975>
  rotate -90.0*z
  translate  <-1.800385, 0.089408, -0.212411>
}
#declare manilla_puerta = union {
  torus { // Torus001
    1.8, 0.2  rotate -x*90
    scale <0.25, 0.15, 0.5>
    translate  <-2.552189, 0.08491, -0.2032>
  }
  superellipsoid { // SuperQ001
    <0.1, 0.1>
    material {
      negro_txt
    }
    scale <0.6, 0.11, 0.3>
    translate  <-2.551657, 0.08948, -0.20359>
  }
  translate  <-0.256639, 0.0, -0.0>
}
#declare cristales_puerta = union {
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.7, 2.0>
    rotate -90.0*z
    translate  <-1.8, 0.089408, 2.230704>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 1.7, 2.0>
    rotate -90.0*z
    translate  <-1.8, 0.089408, -2.651477>
  }
  material {
    cristal_cabinaold_txt
  }
}
#declare puerta = union {
  object { puerta_base }
  object { manilla_puerta }
  object { cristales_puerta }
  object { bisagra }
  object { // bisagra1 -> bisagra
    bisagra
    translate  3.5*z
  }
  object { // bisagra2 -> bisagra
    bisagra
    translate  7.0*z
  }
  rotate 30.0*z
  translate  <1.807758, -2.219879, 0.0>
}
#declare balda = union {
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.75, 0.1>
    translate  <0.0, 0.245035, -0.065657>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    material {
      negro_txt
    }
    scale <0.1, 0.1, 4.0>
    rotate 90.0*y
    translate  <-2.0, -0.510125, -0.063683>
  }
  material {
    metal_txt
  }
  rotate 10.0*x
  translate  <0.0, 1.025, 0.007714>
}
#declare columnas_suma1 = union {
  object { Cylndr014 }
  object { // Cylndr015 -> Cylndr014
    Cylndr014
    rotate -90.0*z
  }
  object { // Cylndr016 -> Cylndr014
    Cylndr014
    rotate -180.0*z
  }
  object { // Cylndr017 -> Cylndr014
    Cylndr014
    rotate 90.0*z
  }
}
#declare resta_columna1 = union {
  object { Cylndr018 }
  object { // Cylndr019 -> Cylndr018
    Cylndr018
    rotate -90.0*z
  }
  object { // Cylndr020 -> Cylndr018
    Cylndr018
    rotate -180.0*z
  }
  object { // Cylndr021 -> Cylndr018
    Cylndr018
    rotate 90.0*z
  }
}
#declare columnas_letrero = difference {
  object { columnas_suma1 }
  object { resta_columna1 }
  scale <1.0, 1.0, 0.1>
  translate  10.5*z
}
#declare letreros = union {
  object { columnas_letrero }
  object { letrero_1 }
  object { // letrero_4 -> letrero 1
    letrero_1
    rotate 90.0*z
  }
  object { // letrero_3 -> letrero 1
    letrero_1
    rotate -180.0*z
  }
  object { // letrero_2 -> letrero 1
    letrero_1
    rotate -90.0*z
  }
  box { // trick1
    <-1, -1, -1>, <1, 1, 1>
    material {
      techo_txt
    }
    scale <2.0, 0.01, 0.725>
    translate  <0.0, 1.95, 10.691881>
  }
  box { // trick2
    <-1, -1, -1>, <1, 1, 1>
    material {
      techo_txt
    }
    scale <0.01, 2.0, 0.725>
    translate  <-1.95, 0.0, 10.691881>
  }
  translate  -5.000792*z
}
#declare columnas_suma2 = union {
  object { Cylndr022 }
  object { // Cylndr023 -> Cylndr022
    Cylndr022
    rotate -90.0*z
  }
  object { // Cylndr024 -> Cylndr022
    Cylndr022
    rotate -180.0*z
  }
  object { // Cylndr025 -> Cylndr022
    Cylndr022
    rotate 90.0*z
  }
}
#declare resta_columna2 = union {
  object { Cylndr026 }
  object { // Cylndr027 -> Cylndr026
    Cylndr026
    rotate -90.0*z
  }
  object { // Cylndr028 -> Cylndr026
    Cylndr026
    rotate -180.0*z
  }
  object { // Cylndr029 -> Cylndr026
    Cylndr026
    rotate 90.0*z
  }
}
#declare columnas_letrero1 = difference {
  object { columnas_suma2 }
  object { resta_columna2 }
  scale <1.0, 1.0, 0.1>
  translate  10.5*z
}
//
// Include file contains 'RotSweep001'
//
#include "cabina4.inc"
#declare RotSweep001 = object {
  RotSweep001_Raw
  rotate -45.0*z
  translate  10.987151*z
}
#declare respiraderos_tejado = union {
  object { respiraderos }
  object { // respiraderos1 -> respiraderos
    respiraderos
    translate  -0.2*z
  }
  scale <1.0, 1.0, 2.0>
  translate  -12.0*z
}
#declare tejado = union {
  object { columnas_letrero1 }
  object { letrero_5 }
  object { // letrero_6 -> letrero 5
    letrero_5
    rotate 90.0*z
  }
  object { // letrero_7 -> letrero 5
    letrero_5
    rotate -180.0*z
  }
  object { // letrero_8 -> letrero 5
    letrero_5
    rotate -90.0*z
  }
  object { RotSweep001 }
  object { respiraderos_tejado }
  scale <1.0, 1.0, 0.5>
  translate  0.999208*z
}
#declare base_cabina = union {
  object { SuperQ002 }
  object { // SuperQ003 -> SuperQ002
    SuperQ002
    rotate -90.0*z
  }
  object { // SuperQ004 -> SuperQ002
    SuperQ002
    rotate -180.0*z
  }
  object { // SuperQ005 -> SuperQ002
    SuperQ002
    rotate 90.0*z
  }
  translate  -5.5*z
}
#declare cabina_media = union {
  object { columnas }
  object { cabina_base }
  object { puerta }
  object { balda }
  box { // suelo
    <-1, -1, -1>, <1, 1, 1>
    material {
      suelo_cabina_txt
    }
    scale <2.0, 2.0, 0.1>
    translate  -5.000792*z
  }
  object { letreros }
  box { // techo
    <-1, -1, -1>, <1, 1, 1>
    material {
      techo_txt
    }
    scale <2.0, 2.0, 0.05>
    translate  4.999208*z
  }
  object { tejado }
  object { base_cabina }
  superellipsoid { // tablon
    <0.1, 0.1>
    material {
      tablon_txt
      translate <0.118898, 0.000000, 0.249686>
    }
    scale <1.725, 0.01, 1.725>
    translate  <0.0, 2.027099, 2.10694>
  }
  material {
    cabina_sucia
  }
  translate  5.808911*z
}
#declare hierro_tf = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.826665, -4.124612, 2.117226>, <-2.794604, -4.021104, 2.117226>, <-2.825602, -3.802974, 2.117226>, <-2.719797, -3.779585, 2.117226>, 
      <-2.827949, -4.039292, 1.541823>, <-2.795889, -3.935784, 1.541823>, <-2.825602, -3.911723, 1.545137>, <-2.719797, -3.888333, 1.545137>, 
      <-2.829710, -4.036298, 0.753107>, <-2.796351, -3.959886, 0.753107>, <-2.802091, -3.916175, 0.759683>, <-2.719797, -3.902782, 0.759683>, 
      <-2.830993, -4.125198, 0.178245>, <-2.797634, -4.048785, 0.178245>, <-2.802091, -3.883882, 0.178245>, <-2.719797, -3.870489, 0.178245>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.719797, -3.664666, 0.048131>, <-2.719797, -3.675193, 0.120419>, <-2.719797, -3.866438, 0.105307>, <-2.719797, -3.870489, 0.178245>, 
      <-2.931350, -3.770066, 0.048131>, <-2.931350, -3.780593, 0.120419>, <-2.802091, -3.879830, 0.105307>, <-2.802091, -3.883882, 0.178245>, 
      <-2.797837, -4.210611, 0.048131>, <-2.797612, -4.187728, 0.149031>, <-2.797862, -4.064597, 0.075998>, <-2.797634, -4.048785, 0.178245>, 
      <-2.831283, -4.444588, 0.048131>, <-2.831058, -4.421704, 0.149031>, <-2.831221, -4.141010, 0.075998>, <-2.830993, -4.125198, 0.178245>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.719797, -3.317409, 4.421641>, <-2.719797, -3.577426, 4.447925>, <-2.719797, -3.924117, 4.482971>, <-2.719797, -4.184134, 4.509254>, 
      <-2.750314, -3.577426, 4.421641>, <-2.750314, -3.837444, 4.447925>, <-2.750237, -3.924117, 4.482971>, <-2.750237, -4.184134, 4.509254>, 
      <-2.791004, -3.924117, 4.421641>, <-2.790945, -3.921008, 4.447741>, <-2.790900, -4.184134, 4.482971>, <-2.790823, -4.184134, 4.509254>, 
      <-2.821521, -4.184134, 4.421641>, <-2.821462, -4.181026, 4.447741>, <-2.821340, -4.184134, 4.482971>, <-2.821262, -4.184134, 4.509254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.719797, -3.870489, 0.178245>, <-2.289283, -3.800427, 0.178245>, <-1.696494, -3.801097, 0.178245>, <-1.265871, -3.870489, 0.178245>, 
      <-2.719797, -3.866438, 0.105307>, <-2.289283, -3.796376, 0.105307>, <-1.696494, -3.797046, 0.105307>, <-1.265871, -3.866438, 0.105307>, 
      <-2.719797, -3.675193, 0.120419>, <-2.329390, -3.480684, 0.120419>, <-1.657025, -3.482191, 0.120419>, <-1.265871, -3.675193, 0.120419>, 
      <-2.719797, -3.664666, 0.048131>, <-2.329390, -3.470157, 0.048131>, <-1.657025, -3.471664, 0.048131>, <-1.265871, -3.664666, 0.048131>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.719797, -3.779585, 2.117226>, <-2.293901, -3.685436, 2.117226>, <-1.692015, -3.686565, 2.117226>, <-1.265871, -3.779585, 2.117226>, 
      <-2.719797, -3.888333, 1.545137>, <-2.293901, -3.794185, 1.545137>, <-1.692015, -3.795314, 1.545137>, <-1.265871, -3.888333, 1.545137>, 
      <-2.719797, -3.902782, 0.759683>, <-2.289283, -3.832720, 0.759683>, <-1.696494, -3.833391, 0.759683>, <-1.265871, -3.902782, 0.759683>, 
      <-2.719797, -3.870489, 0.178245>, <-2.289283, -3.800427, 0.178245>, <-1.696494, -3.801097, 0.178245>, <-1.265871, -3.870489, 0.178245>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.719797, -4.184134, 4.509254>, <-2.283619, -4.184134, 4.509254>, <-1.702049, -4.184134, 4.509254>, <-1.265871, -4.184134, 4.509254>, 
      <-2.719797, -3.924117, 4.482971>, <-2.283619, -3.924117, 4.482971>, <-1.702049, -3.924117, 4.482971>, <-1.265871, -3.924117, 4.482971>, 
      <-2.719797, -3.577426, 4.447925>, <-2.283619, -3.577426, 4.447925>, <-1.702049, -3.577426, 4.447925>, <-1.265871, -3.577426, 4.447925>, 
      <-2.719797, -3.317409, 4.421641>, <-2.283619, -3.317409, 4.421641>, <-1.702049, -3.317409, 4.421641>, <-1.265871, -3.317409, 4.421641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.265871, -3.870489, 0.178245>, <-1.181611, -3.884067, 0.178245>, <-1.177165, -4.048785, 0.178245>, <-1.139148, -4.125198, 0.178245>, 
      <-1.265871, -3.866438, 0.105307>, <-1.181611, -3.880016, 0.105307>, <-1.177165, -4.064597, 0.075998>, <-1.139148, -4.141010, 0.075998>, 
      <-1.265871, -3.675193, 0.120419>, <-1.053295, -3.780082, 0.120419>, <-1.177165, -4.187728, 0.149031>, <-1.139148, -4.421704, 0.149031>, 
      <-1.265871, -3.664666, 0.048131>, <-1.053295, -3.769555, 0.048131>, <-1.177165, -4.210611, 0.048131>, <-1.139148, -4.444588, 0.048131>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.265871, -3.779585, 2.117226>, <-1.158139, -3.803100, 2.117226>, <-1.177165, -4.021104, 2.117226>, <-1.139148, -4.124612, 2.117226>, 
      <-1.265871, -3.888333, 1.545137>, <-1.158139, -3.911849, 1.545137>, <-1.177165, -3.935784, 1.541823>, <-1.139148, -4.039292, 1.541823>, 
      <-1.265871, -3.902782, 0.759683>, <-1.181611, -3.916360, 0.759683>, <-1.177165, -3.959886, 0.753106>, <-1.139148, -4.036298, 0.753106>, 
      <-1.265871, -3.870489, 0.178245>, <-1.181611, -3.884067, 0.178245>, <-1.177165, -4.048785, 0.178245>, <-1.139148, -4.125198, 0.178245>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.265871, -4.184134, 4.509254>, <-1.227854, -4.184134, 4.509254>, <-1.177165, -4.184134, 4.509254>, <-1.139148, -4.184134, 4.509254>, 
      <-1.265871, -3.924117, 4.482971>, <-1.227854, -3.924117, 4.482971>, <-1.177165, -4.184134, 4.482971>, <-1.139148, -4.184134, 4.482971>, 
      <-1.265871, -3.577426, 4.447925>, <-1.227854, -3.837444, 4.447925>, <-1.177165, -3.921008, 4.447740>, <-1.139148, -4.181026, 4.447740>, 
      <-1.265871, -3.317409, 4.421641>, <-1.227854, -3.577426, 4.421641>, <-1.177165, -3.924117, 4.421641>, <-1.139148, -4.184134, 4.421641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.719797, -3.461839, 2.328012>, <-2.719797, -3.418510, 2.956100>, <-2.719797, -3.360738, 3.793552>, <-2.719797, -3.317409, 4.421641>, 
      <-2.751716, -3.756476, 2.328012>, <-2.751716, -3.713147, 2.956100>, <-2.750314, -3.620756, 3.793552>, <-2.750314, -3.577426, 4.421641>, 
      <-2.794275, -4.149325, 2.328012>, <-2.792862, -4.165667, 2.960708>, <-2.792425, -3.998979, 3.793177>, <-2.791004, -3.924117, 4.421641>, 
      <-2.826194, -4.443962, 2.328012>, <-2.824782, -4.460304, 2.960708>, <-2.822942, -4.258996, 3.793177>, <-2.821521, -4.184134, 4.421641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.265871, -3.461839, 2.328012>, <-1.265871, -3.418510, 2.956100>, <-1.265871, -3.360738, 3.793552>, <-1.265871, -3.317409, 4.421641>, 
      <-1.702049, -3.461839, 2.328012>, <-1.702049, -3.418510, 2.956100>, <-1.702049, -3.360738, 3.793552>, <-1.702049, -3.317409, 4.421641>, 
      <-2.283619, -3.461839, 2.328012>, <-2.283619, -3.418510, 2.956100>, <-2.283619, -3.360738, 3.793552>, <-2.283619, -3.317409, 4.421641>, 
      <-2.719797, -3.461839, 2.328012>, <-2.719797, -3.418510, 2.956100>, <-2.719797, -3.360738, 3.793552>, <-2.719797, -3.317409, 4.421641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.139148, -4.443962, 2.328012>, <-1.139148, -4.460304, 2.960708>, <-1.139148, -4.258996, 3.793177>, <-1.139148, -4.184134, 4.421641>, 
      <-1.177165, -4.149325, 2.328012>, <-1.177165, -4.165667, 2.960708>, <-1.177165, -3.998979, 3.793177>, <-1.177165, -3.924117, 4.421641>, 
      <-1.227854, -3.756476, 2.328012>, <-1.227854, -3.713147, 2.956100>, <-1.227854, -3.620756, 3.793552>, <-1.227854, -3.577426, 4.421641>, 
      <-1.265871, -3.461839, 2.328012>, <-1.265871, -3.418510, 2.956100>, <-1.265871, -3.360738, 3.793552>, <-1.265871, -3.317409, 4.421641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.719797, -3.779585, 2.117226>, <-2.719797, -3.758222, 2.229605>, <-2.719797, -3.557162, 2.264776>, <-2.719797, -3.461839, 2.328012>, 
      <-2.825602, -3.802974, 2.117226>, <-2.825602, -3.781612, 2.229605>, <-2.751716, -3.851800, 2.264776>, <-2.751716, -3.756476, 2.328012>, 
      <-2.794604, -4.021104, 2.117226>, <-2.794351, -4.037941, 2.230777>, <-2.794531, -4.146361, 2.213258>, <-2.794275, -4.149325, 2.328012>, 
      <-2.826665, -4.124612, 2.117226>, <-2.826411, -4.141450, 2.230777>, <-2.826450, -4.440998, 2.213258>, <-2.826194, -4.443962, 2.328012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.265871, -3.779585, 2.117226>, <-1.265871, -3.758222, 2.229605>, <-1.265871, -3.557162, 2.264776>, <-1.265871, -3.461839, 2.328012>, 
      <-1.692015, -3.686565, 2.117226>, <-1.692015, -3.665203, 2.229605>, <-1.702049, -3.557162, 2.264776>, <-1.702049, -3.461839, 2.328012>, 
      <-2.293901, -3.685436, 2.117226>, <-2.293901, -3.664074, 2.229605>, <-2.283619, -3.557162, 2.264776>, <-2.283619, -3.461839, 2.328012>, 
      <-2.719797, -3.779585, 2.117226>, <-2.719797, -3.758222, 2.229605>, <-2.719797, -3.557162, 2.264776>, <-2.719797, -3.461839, 2.328012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.139148, -4.124612, 2.117226>, <-1.139148, -4.141450, 2.230777>, <-1.139148, -4.440998, 2.213257>, <-1.139148, -4.443962, 2.328012>, 
      <-1.177165, -4.021104, 2.117226>, <-1.177165, -4.037941, 2.230777>, <-1.177165, -4.146361, 2.213257>, <-1.177165, -4.149325, 2.328012>, 
      <-1.158139, -3.803100, 2.117226>, <-1.158139, -3.781738, 2.229605>, <-1.227854, -3.851800, 2.264776>, <-1.227854, -3.756476, 2.328012>, 
      <-1.265871, -3.779585, 2.117226>, <-1.265871, -3.758222, 2.229605>, <-1.265871, -3.557162, 2.264776>, <-1.265871, -3.461839, 2.328012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.719797, -3.636224, -1.430399>, <-2.719797, -3.644756, -0.986840>, <-2.719797, -3.600734, -0.390880>, <-2.719797, -3.664666, 0.048131>, 
      <-2.754233, -3.892368, -1.430399>, <-2.754233, -3.900900, -0.986840>, <-2.931350, -3.706134, -0.390880>, <-2.931350, -3.770066, 0.048131>, 
      <-2.800148, -4.233893, -1.430399>, <-2.799125, -4.227173, -0.986682>, <-2.798804, -4.308765, -0.384647>, <-2.797837, -4.210611, 0.048131>, 
      <-2.834584, -4.490037, -1.430399>, <-2.833561, -4.483317, -0.986682>, <-2.832249, -4.542741, -0.384647>, <-2.831283, -4.444588, 0.048131>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.265871, -3.636224, -1.430399>, <-1.265871, -3.644756, -0.986840>, <-1.265871, -3.600734, -0.390880>, <-1.265871, -3.664666, 0.048131>, 
      <-1.702049, -3.636224, -1.430399>, <-1.702049, -3.644756, -0.986840>, <-1.657025, -3.407731, -0.390880>, <-1.657025, -3.471664, 0.048131>, 
      <-2.283619, -3.636224, -1.430399>, <-2.283619, -3.644756, -0.986840>, <-2.329390, -3.406225, -0.390880>, <-2.329390, -3.470157, 0.048131>, 
      <-2.719797, -3.636224, -1.430399>, <-2.719797, -3.644756, -0.986840>, <-2.719797, -3.600734, -0.390880>, <-2.719797, -3.664666, 0.048131>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.139148, -4.490037, -1.430399>, <-1.139148, -4.483317, -0.986682>, <-1.139148, -4.542741, -0.384647>, <-1.139148, -4.444588, 0.048131>, 
      <-1.177165, -4.233893, -1.430399>, <-1.177165, -4.227173, -0.986682>, <-1.177165, -4.308765, -0.384647>, <-1.177165, -4.210611, 0.048131>, 
      <-1.227854, -3.892368, -1.430399>, <-1.227854, -3.900900, -0.986840>, <-1.053295, -3.705623, -0.390880>, <-1.053295, -3.769555, 0.048131>, 
      <-1.265871, -3.636224, -1.430399>, <-1.265871, -3.644756, -0.986840>, <-1.265871, -3.600734, -0.390880>, <-1.265871, -3.664666, 0.048131>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.719797, -4.469177, -1.575510>, <-2.719797, -4.219291, -1.531977>, <-2.719797, -3.886110, -1.473933>, <-2.719797, -3.636224, -1.430399>, 
      <-2.754365, -4.469177, -1.575510>, <-2.754365, -4.219291, -1.531977>, <-2.754233, -4.142254, -1.473933>, <-2.754233, -3.892368, -1.430399>, 
      <-2.800456, -4.469177, -1.575510>, <-2.800323, -4.475435, -1.531977>, <-2.800249, -4.234559, -1.474375>, <-2.800148, -4.233893, -1.430399>, 
      <-2.835024, -4.469177, -1.575510>, <-2.834892, -4.475435, -1.531977>, <-2.834685, -4.490703, -1.474375>, <-2.834584, -4.490037, -1.430399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.265871, -4.469177, -1.575510>, <-1.265871, -4.219291, -1.531977>, <-1.265871, -3.886110, -1.473933>, <-1.265871, -3.636224, -1.430399>, 
      <-1.702049, -4.469177, -1.575510>, <-1.702049, -4.219291, -1.531977>, <-1.702049, -3.886110, -1.473933>, <-1.702049, -3.636224, -1.430399>, 
      <-2.283619, -4.469177, -1.575510>, <-2.283619, -4.219291, -1.531977>, <-2.283619, -3.886110, -1.473933>, <-2.283619, -3.636224, -1.430399>, 
      <-2.719797, -4.469177, -1.575510>, <-2.719797, -4.219291, -1.531977>, <-2.719797, -3.886110, -1.473933>, <-2.719797, -3.636224, -1.430399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.139148, -4.469177, -1.575510>, <-1.139148, -4.475435, -1.531977>, <-1.139148, -4.490703, -1.474375>, <-1.139148, -4.490037, -1.430399>, 
      <-1.177165, -4.469177, -1.575510>, <-1.177165, -4.475435, -1.531977>, <-1.177165, -4.234559, -1.474375>, <-1.177165, -4.233893, -1.430399>, 
      <-1.227854, -4.469177, -1.575510>, <-1.227854, -4.219291, -1.531977>, <-1.227854, -4.142254, -1.473933>, <-1.227854, -3.892368, -1.430399>, 
      <-1.265871, -4.469177, -1.575510>, <-1.265871, -4.219291, -1.531977>, <-1.265871, -3.886110, -1.473933>, <-1.265871, -3.636224, -1.430399>
    }
  }
}
#declare ranura_dinero = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.303651, -4.306982, 4.618827>, <1.303651, -4.306982, 4.579097>, <1.303651, -4.306982, 4.526123>, <1.303651, -4.306982, 4.486393>, 
      <1.283382, -4.206396, 4.607460>, <1.283382, -4.206396, 4.567730>, <1.283382, -4.206396, 4.537490>, <1.283382, -4.206396, 4.497760>, 
      <1.303651, -4.066100, 4.618827>, <1.303651, -4.066100, 4.579097>, <1.303651, -4.066100, 4.526123>, <1.303651, -4.066100, 4.486393>, 
      <1.303651, -3.962864, 4.618827>, <1.303651, -3.962864, 4.579097>, <1.303651, -3.962864, 4.526123>, <1.303651, -3.962864, 4.486393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.372995, -4.306982, 4.657717>, <1.372995, -4.306982, 4.594653>, <1.372995, -4.306982, 4.510568>, <1.372995, -4.306982, 4.447504>, 
      <1.363631, -4.328280, 4.652465>, <1.363631, -4.328280, 4.589401>, <1.363631, -4.328280, 4.515819>, <1.363631, -4.328280, 4.452755>, 
      <1.308334, -4.330221, 4.621454>, <1.308334, -4.330221, 4.581723>, <1.308334, -4.330221, 4.523497>, <1.308334, -4.330221, 4.483766>, 
      <1.303651, -4.306982, 4.618827>, <1.303651, -4.306982, 4.579097>, <1.303651, -4.306982, 4.526123>, <1.303651, -4.306982, 4.486393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.372995, -4.149261, 4.657717>, <1.372995, -4.149261, 4.594653>, <1.372995, -4.149261, 4.510568>, <1.372995, -4.149261, 4.447504>, 
      <1.356488, -4.192437, 4.647607>, <1.356488, -4.192437, 4.584543>, <1.356488, -4.192437, 4.520677>, <1.356488, -4.192437, 4.457613>, 
      <1.391572, -4.264730, 4.668135>, <1.391572, -4.264730, 4.605070>, <1.391572, -4.264730, 4.500150>, <1.391572, -4.264730, 4.437086>, 
      <1.372995, -4.306982, 4.657717>, <1.372995, -4.306982, 4.594653>, <1.372995, -4.306982, 4.510568>, <1.372995, -4.306982, 4.447504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.433294, -4.149261, 4.694646>, <1.433294, -4.149261, 4.609424>, <1.433294, -4.149261, 4.495796>, <1.433294, -4.149261, 4.410574>, 
      <1.422519, -4.166423, 4.688376>, <1.422519, -4.166423, 4.603154>, <1.422519, -4.166423, 4.502067>, <1.422519, -4.166423, 4.416845>, 
      <1.380395, -4.129905, 4.662249>, <1.380395, -4.129905, 4.599185>, <1.380395, -4.129905, 4.506035>, <1.380395, -4.129905, 4.442971>, 
      <1.372995, -4.149261, 4.657717>, <1.372995, -4.149261, 4.594653>, <1.372995, -4.149261, 4.510568>, <1.372995, -4.149261, 4.447504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.303651, -4.306982, 4.486393>, <0.929195, -4.306982, 4.486393>, <0.429920, -4.306982, 4.486393>, <0.055464, -4.306982, 4.486393>, 
      <1.283382, -4.206396, 4.497760>, <0.908926, -4.206396, 4.497760>, <0.450189, -4.206396, 4.497760>, <0.075733, -4.206396, 4.497760>, 
      <1.303651, -4.066100, 4.486393>, <0.929195, -4.066100, 4.486393>, <0.429920, -4.066100, 4.486393>, <0.055464, -4.066100, 4.486393>, 
      <1.303651, -3.962864, 4.486393>, <0.929195, -3.962864, 4.486393>, <0.429920, -3.962864, 4.486393>, <0.055464, -3.962864, 4.486393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.372995, -4.306982, 4.447504>, <0.956932, -4.306982, 4.447504>, <0.402183, -4.306982, 4.447504>, <-0.013880, -4.306982, 4.447504>, 
      <1.363631, -4.328280, 4.452755>, <0.947568, -4.328280, 4.452755>, <0.411547, -4.328280, 4.452755>, <-0.004516, -4.328280, 4.452755>, 
      <1.308334, -4.330221, 4.483766>, <0.933878, -4.330221, 4.483766>, <0.425237, -4.330221, 4.483766>, <0.050781, -4.330221, 4.483766>, 
      <1.303651, -4.306982, 4.486393>, <0.929195, -4.306982, 4.486393>, <0.429920, -4.306982, 4.486393>, <0.055464, -4.306982, 4.486393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.372995, -4.149261, 4.447504>, <0.956932, -4.149261, 4.447504>, <0.402183, -4.149261, 4.447504>, <-0.013880, -4.149261, 4.447504>, 
      <1.356488, -4.192437, 4.457613>, <0.940426, -4.192437, 4.457613>, <0.418689, -4.192437, 4.457613>, <0.002627, -4.192437, 4.457613>, 
      <1.391572, -4.264730, 4.437086>, <0.975509, -4.264730, 4.437086>, <0.383606, -4.264730, 4.437086>, <-0.032457, -4.264730, 4.437086>, 
      <1.372995, -4.306982, 4.447504>, <0.956932, -4.306982, 4.447504>, <0.402183, -4.306982, 4.447504>, <-0.013880, -4.306982, 4.447504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.433294, -4.149261, 4.410574>, <0.981052, -4.149261, 4.410574>, <0.378063, -4.149261, 4.410574>, <-0.074179, -4.149261, 4.410574>, 
      <1.422519, -4.166423, 4.416845>, <0.970276, -4.166423, 4.416845>, <0.388838, -4.166423, 4.416845>, <-0.063404, -4.166423, 4.416845>, 
      <1.380395, -4.129905, 4.442971>, <0.964333, -4.129905, 4.442971>, <0.394782, -4.129905, 4.442971>, <-0.021280, -4.129905, 4.442971>, 
      <1.372995, -4.149261, 4.447504>, <0.956932, -4.149261, 4.447504>, <0.402183, -4.149261, 4.447504>, <-0.013880, -4.149261, 4.447504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.055464, -4.306982, 4.486393>, <0.055464, -4.306982, 4.526123>, <0.055464, -4.306982, 4.579097>, <0.055464, -4.306982, 4.618827>, 
      <0.075733, -4.206396, 4.497760>, <0.075733, -4.206396, 4.537490>, <0.075733, -4.206396, 4.567730>, <0.075733, -4.206396, 4.607460>, 
      <0.055464, -4.066100, 4.486393>, <0.055464, -4.066100, 4.526123>, <0.055464, -4.066100, 4.579097>, <0.055464, -4.066100, 4.618827>, 
      <0.055464, -3.962864, 4.486393>, <0.055464, -3.962864, 4.526123>, <0.055464, -3.962864, 4.579097>, <0.055464, -3.962864, 4.618827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.013880, -4.306982, 4.447504>, <-0.013880, -4.306982, 4.510568>, <-0.013880, -4.306982, 4.594653>, <-0.013880, -4.306982, 4.657717>, 
      <-0.004516, -4.328280, 4.452755>, <-0.004516, -4.328280, 4.515819>, <-0.004516, -4.328280, 4.589401>, <-0.004516, -4.328280, 4.652465>, 
      <0.050781, -4.330221, 4.483766>, <0.050781, -4.330221, 4.523497>, <0.050781, -4.330221, 4.581723>, <0.050781, -4.330221, 4.621454>, 
      <0.055464, -4.306982, 4.486393>, <0.055464, -4.306982, 4.526123>, <0.055464, -4.306982, 4.579097>, <0.055464, -4.306982, 4.618827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.013880, -4.149261, 4.447504>, <-0.013880, -4.149261, 4.510568>, <-0.013880, -4.149261, 4.594653>, <-0.013880, -4.149261, 4.657717>, 
      <0.002627, -4.192437, 4.457613>, <0.002627, -4.192437, 4.520677>, <0.002627, -4.192437, 4.584543>, <0.002627, -4.192437, 4.647607>, 
      <-0.032457, -4.264730, 4.437086>, <-0.032457, -4.264730, 4.500150>, <-0.032457, -4.264730, 4.605070>, <-0.032457, -4.264730, 4.668135>, 
      <-0.013880, -4.306982, 4.447504>, <-0.013880, -4.306982, 4.510568>, <-0.013880, -4.306982, 4.594653>, <-0.013880, -4.306982, 4.657717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.074179, -4.149261, 4.410574>, <-0.074179, -4.149261, 4.495796>, <-0.074179, -4.149261, 4.609424>, <-0.074179, -4.149261, 4.694646>, 
      <-0.063404, -4.166423, 4.416845>, <-0.063404, -4.166423, 4.502067>, <-0.063404, -4.166423, 4.603154>, <-0.063404, -4.166423, 4.688376>, 
      <-0.021280, -4.129905, 4.442971>, <-0.021280, -4.129905, 4.506035>, <-0.021280, -4.129905, 4.599185>, <-0.021280, -4.129905, 4.662249>, 
      <-0.013880, -4.149261, 4.447504>, <-0.013880, -4.149261, 4.510568>, <-0.013880, -4.149261, 4.594653>, <-0.013880, -4.149261, 4.657717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.055464, -4.306982, 4.618827>, <0.429920, -4.306982, 4.618827>, <0.929195, -4.306982, 4.618827>, <1.303651, -4.306982, 4.618827>, 
      <0.075733, -4.206396, 4.607460>, <0.450189, -4.206396, 4.607460>, <0.908926, -4.206396, 4.607460>, <1.283382, -4.206396, 4.607460>, 
      <0.055464, -4.066100, 4.618827>, <0.429920, -4.066100, 4.618827>, <0.929195, -4.066100, 4.618827>, <1.303651, -4.066100, 4.618827>, 
      <0.055464, -3.962864, 4.618827>, <0.429920, -3.962864, 4.618827>, <0.929195, -3.962864, 4.618827>, <1.303651, -3.962864, 4.618827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.013880, -4.306982, 4.657717>, <0.402183, -4.306982, 4.657717>, <0.956932, -4.306982, 4.657717>, <1.372995, -4.306982, 4.657717>, 
      <-0.004516, -4.328280, 4.652465>, <0.411547, -4.328280, 4.652465>, <0.947568, -4.328280, 4.652465>, <1.363631, -4.328280, 4.652465>, 
      <0.050781, -4.330221, 4.621454>, <0.425237, -4.330221, 4.621454>, <0.933878, -4.330221, 4.621454>, <1.308334, -4.330221, 4.621454>, 
      <0.055464, -4.306982, 4.618827>, <0.429920, -4.306982, 4.618827>, <0.929195, -4.306982, 4.618827>, <1.303651, -4.306982, 4.618827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.013880, -4.149261, 4.657717>, <0.402183, -4.149261, 4.657717>, <0.956932, -4.149261, 4.657717>, <1.372995, -4.149261, 4.657717>, 
      <0.002627, -4.192437, 4.647607>, <0.418689, -4.192437, 4.647607>, <0.940426, -4.192437, 4.647607>, <1.356488, -4.192437, 4.647607>, 
      <-0.032457, -4.264730, 4.668135>, <0.383606, -4.264730, 4.668135>, <0.975509, -4.264730, 4.668135>, <1.391572, -4.264730, 4.668135>, 
      <-0.013880, -4.306982, 4.657717>, <0.402183, -4.306982, 4.657717>, <0.956932, -4.306982, 4.657717>, <1.372995, -4.306982, 4.657717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.074179, -4.149261, 4.694646>, <0.378063, -4.149261, 4.694646>, <0.981052, -4.149261, 4.694646>, <1.433294, -4.149261, 4.694646>, 
      <-0.063404, -4.166423, 4.688376>, <0.388838, -4.166423, 4.688376>, <0.970276, -4.166423, 4.688376>, <1.422519, -4.166423, 4.688376>, 
      <-0.021280, -4.129905, 4.662249>, <0.394782, -4.129905, 4.662249>, <0.964333, -4.129905, 4.662249>, <1.380395, -4.129905, 4.662249>, 
      <-0.013880, -4.149261, 4.657717>, <0.402183, -4.149261, 4.657717>, <0.956932, -4.149261, 4.657717>, <1.372995, -4.149261, 4.657717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.433294, -4.149261, 4.694646>, <1.463364, -4.101368, 4.712146>, <1.473007, -4.018783, 4.716471>, <1.490027, -3.962864, 4.725825>, 
      <0.981052, -4.149261, 4.694646>, <1.011122, -4.101368, 4.712146>, <0.986725, -4.018783, 4.716471>, <1.003745, -3.962864, 4.725825>, 
      <0.378063, -4.149261, 4.694646>, <0.347993, -4.101368, 4.712146>, <0.372390, -4.018783, 4.716471>, <0.355370, -3.962864, 4.725825>, 
      <-0.074179, -4.149261, 4.694646>, <-0.104249, -4.101368, 4.712146>, <-0.113892, -4.018783, 4.716471>, <-0.130912, -3.962864, 4.725825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.433294, -4.149261, 4.410574>, <1.463364, -4.101368, 4.393074>, <1.473007, -4.018783, 4.388749>, <1.490027, -3.962864, 4.379395>, 
      <1.433294, -4.149261, 4.495796>, <1.463364, -4.101368, 4.478296>, <1.473007, -4.018783, 4.492678>, <1.490027, -3.962864, 4.483324>, 
      <1.433294, -4.149261, 4.609424>, <1.463364, -4.101368, 4.626924>, <1.473007, -4.018783, 4.612542>, <1.490027, -3.962864, 4.621896>, 
      <1.433294, -4.149261, 4.694646>, <1.463364, -4.101368, 4.712146>, <1.473007, -4.018783, 4.716471>, <1.490027, -3.962864, 4.725825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.074179, -4.149261, 4.410574>, <-0.104249, -4.101368, 4.393074>, <-0.113892, -4.018783, 4.388749>, <-0.130912, -3.962864, 4.379395>, 
      <0.378063, -4.149261, 4.410574>, <0.347993, -4.101368, 4.393074>, <0.372390, -4.018783, 4.388749>, <0.355370, -3.962864, 4.379395>, 
      <0.981052, -4.149261, 4.410574>, <1.011122, -4.101368, 4.393074>, <0.986725, -4.018783, 4.388749>, <1.003745, -3.962864, 4.379395>, 
      <1.433294, -4.149261, 4.410574>, <1.463364, -4.101368, 4.393074>, <1.473007, -4.018783, 4.388749>, <1.490027, -3.962864, 4.379395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.074179, -4.149261, 4.694646>, <-0.104249, -4.101368, 4.712146>, <-0.113892, -4.018783, 4.716471>, <-0.130912, -3.962864, 4.725825>, 
      <-0.074179, -4.149261, 4.609424>, <-0.104249, -4.101368, 4.626924>, <-0.113892, -4.018783, 4.612542>, <-0.130912, -3.962864, 4.621896>, 
      <-0.074179, -4.149261, 4.495796>, <-0.104249, -4.101368, 4.478296>, <-0.113892, -4.018783, 4.492678>, <-0.130912, -3.962864, 4.483324>, 
      <-0.074179, -4.149261, 4.410574>, <-0.104249, -4.101368, 4.393074>, <-0.113892, -4.018783, 4.388749>, <-0.130912, -3.962864, 4.379395>
    }
  }
}
#declare tf_2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.111759, -4.799288, 0.126216>, <-1.047334, -4.791338, 0.126504>, <-1.112630, -4.647924, 0.131708>, <-1.113004, -4.583054, 0.134061>, 
      <-1.111759, -4.799300, 0.086018>, <-1.047334, -4.791350, 0.086307>, <-1.113501, -4.646050, 0.069693>, <-1.113875, -4.581180, 0.072046>, 
      <-1.111759, -4.799618, 0.032421>, <-1.033541, -4.788177, 0.029698>, <-1.111833, -4.619038, 0.011539>, <-1.111845, -4.542090, -0.006774>, 
      <-1.111759, -4.799329, -0.007775>, <-1.033541, -4.787888, -0.010498>, <-1.111788, -4.619784, -0.050506>, <-1.111800, -4.542836, -0.068818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.111759, -4.798703, 2.122954>, <-1.051950, -4.792290, 2.121192>, <-1.090761, -4.664836, 2.086153>, <-1.081762, -4.607464, 2.070381>, 
      <-1.111759, -4.798862, 1.523933>, <-1.051950, -4.792448, 1.522170>, <-1.105156, -4.653038, 1.505433>, <-1.096157, -4.595667, 1.489662>, 
      <-1.111759, -4.799112, 0.725237>, <-1.047334, -4.791162, 0.725526>, <-1.104476, -4.665468, 0.712403>, <-1.104850, -4.600597, 0.714757>, 
      <-1.111759, -4.799288, 0.126216>, <-1.047334, -4.791338, 0.126504>, <-1.112630, -4.647924, 0.131708>, <-1.113004, -4.583054, 0.134061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.111759, -4.798703, 2.340019>, <-1.055606, -4.793355, 2.338286>, <-1.075320, -4.678326, 2.301023>, <-1.059703, -4.626736, 2.284310>, 
      <-1.111759, -4.806678, 2.275390>, <-1.055606, -4.801330, 2.273657>, <-1.074535, -4.684434, 2.236539>, <-1.058918, -4.632844, 2.219826>, 
      <-1.111759, -4.798686, 2.188074>, <-1.051950, -4.792273, 2.186311>, <-1.089156, -4.666151, 2.150897>, <-1.080157, -4.608780, 2.135125>, 
      <-1.111759, -4.798703, 2.122954>, <-1.051950, -4.792290, 2.121192>, <-1.090761, -4.664836, 2.086153>, <-1.081762, -4.607464, 2.070381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.111759, -4.497421, 4.564458>, <-1.111759, -4.490180, 4.601870>, <-1.112627, -4.371922, 4.572147>, <-1.111759, -4.374079, 4.534112>, 
      <-1.111759, -4.625375, 3.903301>, <-1.111759, -4.618134, 3.940713>, <-1.097146, -4.410380, 3.894050>, <-1.096278, -4.412537, 3.856016>, 
      <-1.111759, -4.716228, 3.008374>, <-1.055606, -4.710880, 3.006642>, <-1.083554, -4.614262, 2.977308>, <-1.067937, -4.562672, 2.960596>, 
      <-1.111759, -4.798703, 2.340019>, <-1.055606, -4.793355, 2.338286>, <-1.075320, -4.678326, 2.301023>, <-1.059703, -4.626736, 2.284310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.111759, -4.603675, -1.582904>, <-1.111757, -4.612567, -1.640579>, <-1.111759, -4.779308, -1.707248>, <-1.111759, -4.786502, -1.649337>, 
      <-1.111770, -4.534410, -1.133619>, <-1.111769, -4.543302, -1.191295>, <-1.111759, -4.840015, -1.218521>, <-1.111759, -4.847208, -1.160609>, 
      <-1.111470, -4.548295, -0.523378>, <-1.111458, -4.625243, -0.505065>, <-1.033541, -4.784341, -0.502969>, <-1.111759, -4.795782, -0.500246>, 
      <-1.111800, -4.542836, -0.068818>, <-1.111788, -4.619784, -0.050506>, <-1.033541, -4.787888, -0.010498>, <-1.111759, -4.799329, -0.007775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.865306, -4.799288, 0.126216>, <-2.342897, -4.861163, 0.124266>, <-1.633858, -4.863716, 0.123878>, <-1.111759, -4.799288, 0.126216>, 
      <-2.865306, -4.799300, 0.086018>, <-2.342897, -4.861174, 0.084069>, <-1.633858, -4.863728, 0.083681>, <-1.111759, -4.799300, 0.086018>, 
      <-2.865306, -4.799618, 0.032421>, <-2.345634, -4.879482, 0.049930>, <-1.631975, -4.875713, 0.050531>, <-1.111759, -4.799618, 0.032421>, 
      <-2.865306, -4.799329, -0.007775>, <-2.345634, -4.879193, 0.009734>, <-1.631975, -4.875424, 0.010335>, <-1.111759, -4.799329, -0.007775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.865306, -4.798703, 2.122954>, <-2.342581, -4.856321, 2.136441>, <-1.634600, -4.854764, 2.138366>, <-1.111759, -4.798703, 2.122954>, 
      <-2.865306, -4.798862, 1.523933>, <-2.342581, -4.856480, 1.537419>, <-1.634600, -4.854923, 1.539344>, <-1.111759, -4.798862, 1.523933>, 
      <-2.865306, -4.799112, 0.725237>, <-2.342897, -4.860987, 0.723288>, <-1.633858, -4.863540, 0.722900>, <-1.111759, -4.799112, 0.725237>, 
      <-2.865306, -4.799288, 0.126216>, <-2.342897, -4.861163, 0.124266>, <-1.633858, -4.863716, 0.123878>, <-1.111759, -4.799288, 0.126216>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.865306, -4.798703, 2.340019>, <-2.342019, -4.849983, 2.356882>, <-1.635206, -4.848557, 2.356169>, <-1.111759, -4.798703, 2.340019>, 
      <-2.865306, -4.806678, 2.275390>, <-2.342019, -4.857958, 2.292253>, <-1.635206, -4.856532, 2.291540>, <-1.111759, -4.806678, 2.275390>, 
      <-2.865306, -4.798686, 2.188074>, <-2.342581, -4.856304, 2.201560>, <-1.634600, -4.854747, 2.203485>, <-1.111759, -4.798686, 2.188074>, 
      <-2.865306, -4.798703, 2.122954>, <-2.342581, -4.856321, 2.136441>, <-1.634600, -4.854764, 2.138366>, <-1.111759, -4.798703, 2.122954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.865306, -4.497421, 4.564458>, <-2.339242, -4.497421, 4.564458>, <-1.637823, -4.497421, 4.564458>, <-1.111759, -4.497421, 4.564458>, 
      <-2.865306, -4.625375, 3.903301>, <-2.339242, -4.625375, 3.903301>, <-1.637823, -4.625375, 3.903301>, <-1.111759, -4.625375, 3.903301>, 
      <-2.865306, -4.716228, 3.008374>, <-2.342019, -4.767508, 3.025237>, <-1.635206, -4.766082, 3.024524>, <-1.111759, -4.716228, 3.008374>, 
      <-2.865306, -4.798703, 2.340019>, <-2.342019, -4.849983, 2.356882>, <-1.635206, -4.848557, 2.356169>, <-1.111759, -4.798703, 2.340019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.909878, -4.622497, 2.282074>, <-2.896507, -4.675359, 2.299458>, <-2.922235, -4.793125, 2.338184>, <-2.865306, -4.798703, 2.340019>, 
      <-2.902932, -4.559532, 2.958957>, <-2.889560, -4.612394, 2.976341>, <-2.922235, -4.710650, 3.006540>, <-2.865306, -4.716228, 3.008374>, 
      <-2.878560, -4.411272, 3.855419>, <-2.877817, -4.409187, 3.893461>, <-2.865306, -4.618134, 3.940713>, <-2.865306, -4.625375, 3.903301>, 
      <-2.865306, -4.374079, 4.534112>, <-2.864563, -4.371994, 4.572154>, <-2.865306, -4.490180, 4.601870>, <-2.865306, -4.497421, 4.564458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.890521, -4.602637, 2.077062>, <-2.882957, -4.661457, 2.090830>, <-2.925801, -4.792035, 2.121394>, <-2.865306, -4.798703, 2.122954>, 
      <-2.892367, -4.603463, 2.139093>, <-2.884803, -4.662282, 2.152861>, <-2.925801, -4.792018, 2.186513>, <-2.865306, -4.798686, 2.188074>, 
      <-2.910513, -4.628245, 2.220280>, <-2.897141, -4.681107, 2.237664>, <-2.922235, -4.801100, 2.273555>, <-2.865306, -4.806678, 2.275390>, 
      <-2.909878, -4.622497, 2.282074>, <-2.896507, -4.675359, 2.299458>, <-2.922235, -4.793125, 2.338184>, <-2.865306, -4.798703, 2.340019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.845919, -4.593893, 0.132686>, <-2.851736, -4.655512, 0.130745>, <-2.926799, -4.792005, 0.126445>, <-2.865306, -4.799288, 0.126216>, 
      <-2.858735, -4.612781, 0.715712>, <-2.864551, -4.674400, 0.713770>, <-2.926799, -4.791829, 0.725467>, <-2.865306, -4.799112, 0.725237>, 
      <-2.873168, -4.594877, 1.493900>, <-2.865604, -4.653696, 1.507667>, <-2.925801, -4.792194, 1.522372>, <-2.865306, -4.798862, 1.523933>, 
      <-2.890521, -4.602637, 2.077062>, <-2.882957, -4.661457, 2.090830>, <-2.925801, -4.792035, 2.121394>, <-2.865306, -4.798703, 2.122954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.843411, -4.533206, -0.066120>, <-2.849979, -4.613042, -0.048617>, <-2.946307, -4.786880, -0.010504>, <-2.865306, -4.799329, -0.007775>, 
      <-2.842706, -4.532850, -0.003762>, <-2.849275, -4.612687, 0.013742>, <-2.946307, -4.787170, 0.029692>, <-2.865306, -4.799618, 0.032421>, 
      <-2.844550, -4.591874, 0.070371>, <-2.850366, -4.653493, 0.068429>, <-2.926799, -4.792017, 0.086248>, <-2.865306, -4.799300, 0.086018>, 
      <-2.845919, -4.593893, 0.132686>, <-2.851736, -4.655512, 0.130745>, <-2.926799, -4.792005, 0.126445>, <-2.865306, -4.799288, 0.126216>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.865306, -4.603675, -1.582904>, <-2.866103, -4.612894, -1.640522>, <-2.865306, -4.779308, -1.707248>, <-2.865306, -4.786502, -1.649337>, 
      <-2.859086, -4.531711, -1.133093>, <-2.859882, -4.540929, -1.190711>, <-2.865306, -4.840015, -1.218521>, <-2.865306, -4.847208, -1.160609>, 
      <-2.848558, -4.535803, -0.521657>, <-2.855127, -4.615640, -0.504153>, <-2.946307, -4.783334, -0.502975>, <-2.865306, -4.795782, -0.500246>, 
      <-2.843411, -4.533206, -0.066120>, <-2.849979, -4.613042, -0.048617>, <-2.946307, -4.786880, -0.010504>, <-2.865306, -4.799329, -0.007775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.111759, -4.497421, 4.564458>, <-1.111759, -4.490180, 4.601870>, <-1.112627, -4.371922, 4.572147>, <-1.111759, -4.374079, 4.534112>, 
      <-1.637823, -4.497421, 4.564458>, <-1.637823, -4.490180, 4.601870>, <-1.638691, -4.371922, 4.572147>, <-1.637823, -4.374079, 4.534112>, 
      <-2.339242, -4.497421, 4.564458>, <-2.339242, -4.490180, 4.601870>, <-2.338499, -4.371994, 4.572154>, <-2.339242, -4.374079, 4.534112>, 
      <-2.865306, -4.497421, 4.564458>, <-2.865306, -4.490180, 4.601870>, <-2.864563, -4.371994, 4.572154>, <-2.865306, -4.374079, 4.534112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.111759, -4.786502, -1.649337>, <-1.111759, -4.847208, -1.160609>, <-1.111759, -4.795782, -0.500246>, <-1.111759, -4.799329, -0.007775>, 
      <-1.637823, -4.786502, -1.649337>, <-1.637823, -4.847208, -1.160609>, <-1.631975, -4.871877, -0.482136>, <-1.631975, -4.875424, 0.010335>, 
      <-2.339242, -4.786502, -1.649337>, <-2.339242, -4.847208, -1.160609>, <-2.345634, -4.875646, -0.482737>, <-2.345634, -4.879193, 0.009734>, 
      <-2.865306, -4.786502, -1.649337>, <-2.865306, -4.847208, -1.160609>, <-2.865306, -4.795782, -0.500246>, <-2.865306, -4.799329, -0.007775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.111759, -4.603675, -1.582904>, <-1.111757, -4.612567, -1.640579>, <-1.111759, -4.779308, -1.707248>, <-1.111759, -4.786502, -1.649337>, 
      <-1.637823, -4.603675, -1.582904>, <-1.637821, -4.612567, -1.640579>, <-1.637823, -4.779308, -1.707248>, <-1.637823, -4.786502, -1.649337>, 
      <-2.339242, -4.603675, -1.582904>, <-2.340039, -4.612894, -1.640522>, <-2.339242, -4.779308, -1.707248>, <-2.339242, -4.786502, -1.649337>, 
      <-2.865306, -4.603675, -1.582904>, <-2.866103, -4.612894, -1.640522>, <-2.865306, -4.779308, -1.707248>, <-2.865306, -4.786502, -1.649337>
    }
  }
  material {
    negro_txt
  }
}
#declare tf_1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.809850, -4.770406, 2.123512>, <-2.778431, -4.575078, 2.123512>, <-2.887152, -4.196801, 2.123512>, <-2.705120, -4.119316, 2.123512>, 
      <-2.811122, -4.770561, 1.536235>, <-2.779703, -4.575234, 1.536235>, <-2.887152, -4.303475, 1.545387>, <-2.705120, -4.225990, 1.545387>, 
      <-2.812819, -4.770807, 0.753200>, <-2.780128, -4.602034, 0.753200>, <-2.866516, -4.299247, 0.752956>, <-2.705120, -4.240050, 0.752956>, 
      <-2.814091, -4.770980, 0.165924>, <-2.781400, -4.602206, 0.165924>, <-2.866516, -4.267599, 0.165924>, <-2.705120, -4.208402, 0.165924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.705120, -4.006695, 0.034561>, <-2.705120, -4.016803, 0.106063>, <-2.705120, -4.204514, 0.093816>, <-2.705120, -4.208402, 0.165924>, 
      <-2.912441, -4.109987, 0.034561>, <-2.912441, -4.120095, 0.106063>, <-2.866516, -4.263712, 0.093816>, <-2.866516, -4.267599, 0.165924>, 
      <-2.781599, -4.541721, 0.034561>, <-2.781514, -4.541330, 0.073968>, <-2.781485, -4.602218, 0.126515>, <-2.781400, -4.602206, 0.165924>, 
      <-2.814376, -4.771018, 0.034561>, <-2.814291, -4.770627, 0.073968>, <-2.814177, -4.770991, 0.126515>, <-2.814091, -4.770980, 0.165924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.705120, -3.666383, 4.450040>, <-2.705120, -3.912665, 4.476576>, <-2.705120, -4.241041, 4.511958>, <-2.705120, -4.487323, 4.538494>, 
      <-2.735026, -3.912665, 4.450040>, <-2.735026, -4.158947, 4.476576>, <-2.734951, -4.241041, 4.511958>, <-2.734951, -4.487323, 4.538494>, 
      <-2.774902, -4.241041, 4.450040>, <-2.774844, -4.237658, 4.476359>, <-2.774801, -4.487323, 4.511958>, <-2.774725, -4.487323, 4.538494>, 
      <-2.804809, -4.487323, 4.450040>, <-2.804751, -4.483940, 4.476359>, <-2.804632, -4.487323, 4.511958>, <-2.804556, -4.487323, 4.538494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.705120, -4.208402, 0.165924>, <-2.303808, -4.061208, 0.165924>, <-1.682050, -4.062484, 0.165924>, <-1.280272, -4.208402, 0.165924>, 
      <-2.705120, -4.204514, 0.093816>, <-2.303808, -4.057320, 0.093816>, <-1.682050, -4.058597, 0.093816>, <-1.280272, -4.204514, 0.093816>, 
      <-2.705120, -4.016803, 0.106063>, <-2.322521, -3.826184, 0.106063>, <-1.663603, -3.827660, 0.106063>, <-1.280272, -4.016803, 0.106063>, 
      <-2.705120, -4.006695, 0.034561>, <-2.322521, -3.816076, 0.034561>, <-1.663603, -3.817553, 0.034561>, <-1.280272, -4.006695, 0.034561>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.705120, -4.119316, 2.123512>, <-2.311815, -3.951899, 2.123512>, <-1.674332, -3.953684, 2.123512>, <-1.280272, -4.119316, 2.123512>, 
      <-2.705120, -4.225990, 1.545387>, <-2.311815, -4.058574, 1.545387>, <-1.674332, -4.060359, 1.545387>, <-1.280272, -4.225990, 1.545387>, 
      <-2.705120, -4.240050, 0.752956>, <-2.303808, -4.092856, 0.752956>, <-1.682050, -4.094132, 0.752956>, <-1.280272, -4.240050, 0.752956>, 
      <-2.705120, -4.208402, 0.165924>, <-2.303808, -4.061208, 0.165924>, <-1.682050, -4.062484, 0.165924>, <-1.280272, -4.208402, 0.165924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.705120, -4.487323, 4.538494>, <-2.277665, -4.487323, 4.538494>, <-1.707726, -4.487323, 4.538494>, <-1.280272, -4.487323, 4.538494>, 
      <-2.705120, -4.241041, 4.511958>, <-2.277665, -4.241041, 4.511958>, <-1.707726, -4.241041, 4.511958>, <-1.280272, -4.241041, 4.511958>, 
      <-2.705120, -3.912665, 4.476576>, <-2.277665, -3.912665, 4.476576>, <-1.707726, -3.912665, 4.476576>, <-1.280272, -3.912665, 4.476576>, 
      <-2.705120, -3.666383, 4.450040>, <-2.277665, -3.666383, 4.450040>, <-1.707726, -3.666383, 4.450040>, <-1.280272, -3.666383, 4.450040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.280272, -4.208402, 0.165924>, <-1.117818, -4.267402, 0.165924>, <-1.193340, -4.602206, 0.165924>, <-1.156084, -4.770980, 0.165924>, 
      <-1.280272, -4.204514, 0.093816>, <-1.117818, -4.263514, 0.093816>, <-1.193340, -4.602218, 0.126515>, <-1.156084, -4.770991, 0.126515>, 
      <-1.280272, -4.016803, 0.106063>, <-1.071948, -4.119594, 0.106063>, <-1.193340, -4.541330, 0.073968>, <-1.156084, -4.770627, 0.073968>, 
      <-1.280272, -4.006695, 0.034561>, <-1.071948, -4.109486, 0.034561>, <-1.193340, -4.541721, 0.034561>, <-1.156084, -4.771018, 0.034561>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.280272, -4.119316, 2.123512>, <-1.096958, -4.196366, 2.123512>, <-1.193340, -4.575078, 2.123512>, <-1.156084, -4.770406, 2.123512>, 
      <-1.280272, -4.225990, 1.545387>, <-1.096958, -4.303040, 1.545387>, <-1.193340, -4.575234, 1.536235>, <-1.156084, -4.770561, 1.536235>, 
      <-1.280272, -4.240050, 0.752956>, <-1.117818, -4.299050, 0.752956>, <-1.193340, -4.602034, 0.753201>, <-1.156084, -4.770807, 0.753201>, 
      <-1.280272, -4.208402, 0.165924>, <-1.117818, -4.267402, 0.165924>, <-1.193340, -4.602206, 0.165924>, <-1.156084, -4.770980, 0.165924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.280272, -4.487323, 4.538494>, <-1.243016, -4.487323, 4.538494>, <-1.193340, -4.487323, 4.538494>, <-1.156084, -4.487323, 4.538494>, 
      <-1.280272, -4.241041, 4.511958>, <-1.243016, -4.241041, 4.511958>, <-1.193340, -4.487323, 4.511958>, <-1.156084, -4.487323, 4.511958>, 
      <-1.280272, -3.912665, 4.476576>, <-1.243016, -4.158947, 4.476576>, <-1.193340, -4.237658, 4.476359>, <-1.156084, -4.483940, 4.476359>, 
      <-1.280272, -3.666383, 4.450040>, <-1.243016, -3.912665, 4.450040>, <-1.193340, -4.241041, 4.450040>, <-1.156084, -4.487323, 4.450040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.705120, -3.807924, 2.336320>, <-2.705120, -3.765462, 2.970436>, <-2.705120, -3.708845, 3.815924>, <-2.705120, -3.666383, 4.450040>, 
      <-2.736400, -4.096669, 2.336320>, <-2.736400, -4.054206, 2.970436>, <-2.735026, -3.955128, 3.815924>, <-2.735026, -3.912665, 4.450040>, 
      <-2.778108, -4.481661, 2.336320>, <-2.776732, -4.404386, 2.971413>, <-2.776295, -4.322611, 3.815484>, <-2.774902, -4.241041, 4.450040>, 
      <-2.809389, -4.770406, 2.336320>, <-2.808012, -4.693130, 2.971413>, <-2.806201, -4.568893, 3.815484>, <-2.804809, -4.487323, 4.450040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.280272, -3.807924, 2.336320>, <-1.280272, -3.765462, 2.970436>, <-1.280272, -3.708845, 3.815924>, <-1.280272, -3.666383, 4.450040>, 
      <-1.707726, -3.807924, 2.336320>, <-1.707726, -3.765462, 2.970436>, <-1.707726, -3.708845, 3.815924>, <-1.707726, -3.666383, 4.450040>, 
      <-2.277665, -3.807924, 2.336320>, <-2.277665, -3.765462, 2.970436>, <-2.277665, -3.708845, 3.815924>, <-2.277665, -3.666383, 4.450040>, 
      <-2.705120, -3.807924, 2.336320>, <-2.705120, -3.765462, 2.970436>, <-2.705120, -3.708845, 3.815924>, <-2.705120, -3.666383, 4.450040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.156084, -4.770406, 2.336320>, <-1.156084, -4.693130, 2.971413>, <-1.156084, -4.568893, 3.815484>, <-1.156084, -4.487323, 4.450040>, 
      <-1.193340, -4.481661, 2.336320>, <-1.193340, -4.404386, 2.971413>, <-1.193340, -4.322611, 3.815484>, <-1.193340, -4.241041, 4.450040>, 
      <-1.243016, -4.096669, 2.336320>, <-1.243016, -4.054206, 2.970436>, <-1.243016, -3.955128, 3.815924>, <-1.243016, -3.912665, 4.450040>, 
      <-1.280272, -3.807924, 2.336320>, <-1.280272, -3.765462, 2.970436>, <-1.280272, -3.708845, 3.815924>, <-1.280272, -3.666383, 4.450040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.705120, -4.119316, 2.123512>, <-2.705120, -4.098784, 2.234782>, <-2.705120, -3.901342, 2.272477>, <-2.705120, -3.807924, 2.336320>, 
      <-2.887152, -4.196801, 2.123512>, <-2.887152, -4.176270, 2.234782>, <-2.736400, -4.190086, 2.272477>, <-2.736400, -4.096669, 2.336320>, 
      <-2.778431, -4.575078, 2.123512>, <-2.778293, -4.575062, 2.187354>, <-2.778245, -4.489373, 2.272945>, <-2.778108, -4.481661, 2.336320>, 
      <-2.809850, -4.770406, 2.123512>, <-2.809712, -4.770389, 2.187354>, <-2.809526, -4.778117, 2.272945>, <-2.809389, -4.770406, 2.336320>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.280272, -4.119316, 2.123512>, <-1.280272, -4.098784, 2.234782>, <-1.280272, -3.901342, 2.272477>, <-1.280272, -3.807924, 2.336320>, 
      <-1.674332, -3.953684, 2.123512>, <-1.674332, -3.933153, 2.234782>, <-1.707726, -3.901342, 2.272477>, <-1.707726, -3.807924, 2.336320>, 
      <-2.311815, -3.951899, 2.123512>, <-2.311815, -3.931368, 2.234782>, <-2.277665, -3.901342, 2.272477>, <-2.277665, -3.807924, 2.336320>, 
      <-2.705120, -4.119316, 2.123512>, <-2.705120, -4.098784, 2.234782>, <-2.705120, -3.901342, 2.272477>, <-2.705120, -3.807924, 2.336320>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.156084, -4.770406, 2.123512>, <-1.156084, -4.770389, 2.187354>, <-1.156084, -4.778117, 2.272945>, <-1.156084, -4.770406, 2.336320>, 
      <-1.193340, -4.575078, 2.123512>, <-1.193340, -4.575062, 2.187354>, <-1.193340, -4.489373, 2.272945>, <-1.193340, -4.481661, 2.336320>, 
      <-1.096958, -4.196366, 2.123512>, <-1.096958, -4.175835, 2.234782>, <-1.243016, -4.190086, 2.272477>, <-1.243016, -4.096669, 2.336320>, 
      <-1.280272, -4.119316, 2.123512>, <-1.280272, -4.098784, 2.234782>, <-1.280272, -3.901342, 2.272477>, <-1.280272, -3.807924, 2.336320>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.705120, -3.978822, -1.458157>, <-2.705120, -3.987184, -1.010342>, <-2.705120, -3.944004, -0.408924>, <-2.705120, -4.006695, 0.034561>, 
      <-2.738867, -4.221308, -1.458157>, <-2.738867, -4.229670, -1.010342>, <-2.912441, -4.047296, -0.408924>, <-2.912441, -4.109987, 0.034561>, 
      <-2.783863, -4.544622, -1.458157>, <-2.782862, -4.545811, -1.010317>, <-2.782569, -4.546169, -0.413258>, <-2.781599, -4.541721, 0.034561>, 
      <-2.817611, -4.787108, -1.458157>, <-2.816609, -4.788297, -1.010317>, <-2.815346, -4.775466, -0.413258>, <-2.814376, -4.771018, 0.034561>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.280272, -3.978822, -1.458157>, <-1.280272, -3.987184, -1.010342>, <-1.280272, -3.944004, -0.408924>, <-1.280272, -4.006695, 0.034561>, 
      <-1.707726, -3.978822, -1.458157>, <-1.707726, -3.987184, -1.010342>, <-1.663603, -3.754862, -0.408924>, <-1.663603, -3.817553, 0.034561>, 
      <-2.277665, -3.978822, -1.458157>, <-2.277665, -3.987184, -1.010342>, <-2.322521, -3.753386, -0.408924>, <-2.322521, -3.816076, 0.034561>, 
      <-2.705120, -3.978822, -1.458157>, <-2.705120, -3.987184, -1.010342>, <-2.705120, -3.944004, -0.408924>, <-2.705120, -4.006695, 0.034561>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.156084, -4.787108, -1.458157>, <-1.156084, -4.788297, -1.010317>, <-1.156084, -4.775466, -0.413258>, <-1.156084, -4.771018, 0.034561>, 
      <-1.193340, -4.544622, -1.458157>, <-1.193340, -4.545811, -1.010317>, <-1.193340, -4.546169, -0.413258>, <-1.193340, -4.541721, 0.034561>, 
      <-1.243016, -4.221308, -1.458157>, <-1.243016, -4.229670, -1.010342>, <-1.071948, -4.046796, -0.408924>, <-1.071948, -4.109486, 0.034561>, 
      <-1.280272, -3.978822, -1.458157>, <-1.280272, -3.987184, -1.010342>, <-1.280272, -3.944004, -0.408924>, <-1.280272, -4.006695, 0.034561>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.705120, -4.766666, -1.604660>, <-2.705120, -4.530312, -1.560709>, <-2.705120, -4.215175, -1.502108>, <-2.705120, -3.978822, -1.458157>, 
      <-2.738996, -4.766666, -1.604660>, <-2.738996, -4.530312, -1.560709>, <-2.738867, -4.457661, -1.502108>, <-2.738867, -4.221308, -1.458157>, 
      <-2.784165, -4.766666, -1.604660>, <-2.784036, -4.772798, -1.560709>, <-2.783962, -4.544504, -1.502534>, <-2.783863, -4.544622, -1.458157>, 
      <-2.818042, -4.766666, -1.604660>, <-2.817912, -4.772798, -1.560709>, <-2.817710, -4.786990, -1.502534>, <-2.817611, -4.787108, -1.458157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.280272, -4.766666, -1.604660>, <-1.280272, -4.530312, -1.560709>, <-1.280272, -4.215175, -1.502108>, <-1.280272, -3.978822, -1.458157>, 
      <-1.707726, -4.766666, -1.604660>, <-1.707726, -4.530312, -1.560709>, <-1.707726, -4.215175, -1.502108>, <-1.707726, -3.978822, -1.458157>, 
      <-2.277665, -4.766666, -1.604660>, <-2.277665, -4.530312, -1.560709>, <-2.277665, -4.215175, -1.502108>, <-2.277665, -3.978822, -1.458157>, 
      <-2.705120, -4.766666, -1.604660>, <-2.705120, -4.530312, -1.560709>, <-2.705120, -4.215175, -1.502108>, <-2.705120, -3.978822, -1.458157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.156084, -4.766666, -1.604660>, <-1.156084, -4.772798, -1.560709>, <-1.156084, -4.786990, -1.502534>, <-1.156084, -4.787108, -1.458157>, 
      <-1.193340, -4.766666, -1.604660>, <-1.193340, -4.772798, -1.560709>, <-1.193340, -4.544504, -1.502534>, <-1.193340, -4.544622, -1.458157>, 
      <-1.243016, -4.766666, -1.604660>, <-1.243016, -4.530312, -1.560709>, <-1.243016, -4.457661, -1.502108>, <-1.243016, -4.221308, -1.458157>, 
      <-1.280272, -4.766666, -1.604660>, <-1.280272, -4.530312, -1.560709>, <-1.280272, -4.215175, -1.502108>, <-1.280272, -3.978822, -1.458157>
    }
  }
  material {
    negro_txt
  }
}
#declare panel_frente = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.062027, -3.347424, -1.452793>, <0.062027, -3.347424, -1.035553>, <0.062027, -3.347424, -0.479233>, <0.062027, -3.347424, -0.061993>, 
      <0.242884, -3.347424, -1.473761>, <0.242884, -3.347424, -1.056521>, <0.243830, -3.347424, -0.479233>, <0.243830, -3.347424, -0.061993>, 
      <0.484026, -3.347424, -1.501717>, <0.484972, -3.347424, -1.063510>, <0.485288, -3.347424, -0.500201>, <0.486234, -3.347424, -0.061993>, 
      <0.664883, -3.347424, -1.522685>, <0.665829, -3.347424, -1.084477>, <0.667091, -3.347424, -0.500201>, <0.668037, -3.347424, -0.061993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.668037, -3.347424, -0.061993>, <0.665741, -3.537299, -0.042077>, <0.662722, -3.798342, -0.053271>, <0.660383, -3.980341, 0.004395>, 
      <0.486234, -3.347424, -0.061993>, <0.483938, -3.537299, -0.042077>, <0.469551, -3.798342, -0.053271>, <0.467212, -3.980341, 0.004395>, 
      <0.243830, -3.347424, -0.061993>, <0.230166, -3.537299, -0.042077>, <0.223315, -3.790466, -0.015521>, <0.209650, -3.980341, 0.004395>, 
      <0.062027, -3.347424, -0.061993>, <0.048363, -3.537299, -0.042077>, <0.030143, -3.790466, -0.015521>, <0.016479, -3.980341, 0.004395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.282027, -3.347424, -0.061993>, <1.282027, -3.347424, -0.479233>, <1.282027, -3.347424, -1.035553>, <1.282027, -3.347424, -1.452793>, 
      <1.097830, -3.347424, -0.061993>, <1.097830, -3.347424, -0.479233>, <1.096884, -3.347424, -1.056521>, <1.096884, -3.347424, -1.473761>, 
      <0.852234, -3.347424, -0.061993>, <0.851288, -3.347424, -0.500201>, <0.850972, -3.347424, -1.063510>, <0.850026, -3.347424, -1.501717>, 
      <0.668037, -3.347424, -0.061993>, <0.667091, -3.347424, -0.500201>, <0.665829, -3.347424, -1.084477>, <0.664883, -3.347424, -1.522685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.282027, -3.347424, -0.061993>, <1.298646, -3.537299, -0.042077>, <1.320804, -3.790466, -0.015521>, <1.337423, -3.980341, 0.004395>, 
      <1.097830, -3.347424, -0.061993>, <1.114449, -3.537299, -0.042077>, <1.117692, -3.790466, -0.015521>, <1.134311, -3.980341, 0.004395>, 
      <0.852234, -3.347424, -0.061993>, <0.849938, -3.537299, -0.042077>, <0.865834, -3.798342, -0.053271>, <0.863495, -3.980341, 0.004395>, 
      <0.668037, -3.347424, -0.061993>, <0.665741, -3.537299, -0.042077>, <0.662722, -3.798342, -0.053271>, <0.660383, -3.980341, 0.004395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016479, -3.980341, 0.004395>, <0.030143, -3.790466, -0.015521>, <0.048363, -3.537299, -0.042077>, <0.062027, -3.347424, -0.061993>, 
      <0.016479, -3.980478, -0.452882>, <0.030143, -3.790603, -0.472798>, <0.048363, -3.537299, -0.459317>, <0.062027, -3.347424, -0.479233>, 
      <0.016479, -3.980678, -1.062585>, <0.030143, -3.790665, -1.042464>, <0.048363, -3.537436, -1.055674>, <0.062027, -3.347424, -1.035553>, 
      <0.016479, -3.980799, -1.519862>, <0.030143, -3.790786, -1.499741>, <0.048363, -3.537436, -1.472914>, <0.062027, -3.347424, -1.452793>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.337423, -3.980341, 0.004395>, <1.320804, -3.790466, -0.015521>, <1.298646, -3.537299, -0.042077>, <1.282027, -3.347424, -0.061993>, 
      <1.337423, -3.980478, -0.452882>, <1.320804, -3.790603, -0.472798>, <1.298646, -3.537299, -0.459317>, <1.282027, -3.347424, -0.479233>, 
      <1.337423, -3.980678, -1.062585>, <1.320804, -3.790665, -1.042464>, <1.298646, -3.537436, -1.055674>, <1.282027, -3.347424, -1.035553>, 
      <1.337423, -3.980799, -1.519862>, <1.320804, -3.790786, -1.499741>, <1.298646, -3.537436, -1.472914>, <1.282027, -3.347424, -1.452793>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.659903, -3.980300, 0.138534>, <0.657757, -3.980119, 0.738219>, <0.654896, -3.979860, 1.537799>, <0.652751, -3.979696, 2.137484>, 
      <0.466876, -3.980300, 0.138534>, <0.464730, -3.980119, 0.738219>, <0.464015, -3.979860, 1.537799>, <0.461869, -3.979696, 2.137484>, 
      <0.209506, -3.980300, 0.138534>, <0.209506, -3.980119, 0.738219>, <0.207360, -3.979860, 1.537799>, <0.207360, -3.979696, 2.137484>, 
      <0.016479, -3.980300, 0.138534>, <0.016479, -3.980119, 0.738219>, <0.016479, -3.979860, 1.537799>, <0.016479, -3.979696, 2.137484>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.337423, -3.980300, 0.138534>, <1.337423, -3.980119, 0.738219>, <1.337423, -3.979860, 1.537799>, <1.337423, -3.979696, 2.137484>, 
      <1.134167, -3.980300, 0.138534>, <1.134167, -3.980119, 0.738219>, <1.132021, -3.979860, 1.537799>, <1.132021, -3.979696, 2.137484>, 
      <0.863159, -3.980300, 0.138534>, <0.861013, -3.980119, 0.738219>, <0.860298, -3.979860, 1.537799>, <0.858153, -3.979696, 2.137484>, 
      <0.659903, -3.980300, 0.138534>, <0.657757, -3.980119, 0.738219>, <0.654896, -3.979860, 1.537799>, <0.652751, -3.979696, 2.137484>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.726398, -3.980300, 0.138534>, <3.724892, -3.980119, 0.738219>, <3.719959, -3.979860, 1.537799>, <3.721507, -3.979696, 2.137484>, 
      <3.009705, -3.980300, 0.138534>, <3.008200, -3.980119, 0.738219>, <3.004734, -3.979860, 1.537799>, <3.006282, -3.979696, 2.137484>, 
      <2.054115, -3.980300, 0.138534>, <2.054115, -3.980119, 0.738219>, <2.052648, -3.979860, 1.537799>, <2.052648, -3.979696, 2.137484>, 
      <1.337423, -3.980300, 0.138534>, <1.337423, -3.980119, 0.738219>, <1.337423, -3.979860, 1.537799>, <1.337423, -3.979696, 2.137484>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.643928, -3.979696, 4.603492>, <0.643814, -3.979696, 4.635359>, <0.643662, -3.979696, 4.677848>, <0.643548, -3.979696, 4.709715>, 
      <0.455693, -3.979696, 4.603492>, <0.455579, -3.979696, 4.635359>, <0.455541, -3.979696, 4.677848>, <0.455427, -3.979696, 4.709715>, 
      <0.204713, -3.979696, 4.603492>, <0.204713, -3.979696, 4.635359>, <0.204599, -3.979696, 4.677848>, <0.204599, -3.979696, 4.709715>, 
      <0.016479, -3.979696, 4.603492>, <0.016479, -3.979696, 4.635359>, <0.016479, -3.979696, 4.677848>, <0.016479, -3.979696, 4.709715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.337423, -3.979696, 4.603492>, <1.337423, -3.979696, 4.635359>, <1.337423, -3.979696, 4.677848>, <1.337423, -3.979696, 4.709715>, 
      <1.129374, -3.979696, 4.603492>, <1.129374, -3.979696, 4.635359>, <1.129260, -3.979696, 4.677848>, <1.129260, -3.979696, 4.709715>, 
      <0.851977, -3.979696, 4.603492>, <0.851862, -3.979696, 4.635359>, <0.851824, -3.979696, 4.677848>, <0.851710, -3.979696, 4.709715>, 
      <0.643928, -3.979696, 4.603492>, <0.643814, -3.979696, 4.635359>, <0.643662, -3.979696, 4.677848>, <0.643548, -3.979696, 4.709715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.742962, -3.979696, 4.603492>, <3.741714, -3.979696, 4.635516>, <3.744860, -3.979696, 4.680532>, <3.731614, -3.979696, 4.709715>, 
      <3.021300, -3.979696, 4.603492>, <3.020052, -3.979696, 4.635516>, <3.026602, -3.979696, 4.680532>, <3.013357, -3.979696, 4.709715>, 
      <2.059085, -3.979696, 4.603492>, <2.059085, -3.979696, 4.635359>, <2.055681, -3.979696, 4.677848>, <2.055681, -3.979696, 4.709715>, 
      <1.337423, -3.979696, 4.603492>, <1.337423, -3.979696, 4.635359>, <1.337423, -3.979696, 4.677848>, <1.337423, -3.979696, 4.709715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.852667, -3.979696, 2.137484>, <-2.792920, -3.874762, 2.137484>, <-2.859895, -3.620810, 2.137484>, <-2.742494, -3.592564, 2.137484>, 
      <-2.854006, -3.979860, 1.537799>, <-2.794258, -3.874926, 1.537799>, <-2.859895, -3.732922, 1.547701>, <-2.742494, -3.704677, 1.547701>, 
      <-2.855790, -3.980119, 0.738219>, <-2.799001, -3.904369, 0.738219>, <-2.835633, -3.736544, 0.737954>, <-2.742494, -3.719572, 0.737954>, 
      <-2.857129, -3.980300, 0.138534>, <-2.800340, -3.904550, 0.138534>, <-2.835633, -3.703252, 0.138534>, <-2.742494, -3.686280, 0.138534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.846925, -3.979696, 4.709715>, <-2.815596, -3.979696, 4.709715>, <-2.773823, -3.979696, 4.709715>, <-2.742494, -3.979696, 4.709715>, 
      <-2.846991, -3.979696, 4.677848>, <-2.815662, -3.979696, 4.677848>, <-2.773823, -3.979696, 4.677848>, <-2.742494, -3.979696, 4.677848>, 
      <-2.847026, -3.979696, 4.635359>, <-2.815645, -3.979696, 4.635359>, <-2.773875, -4.010768, 4.610563>, <-2.742494, -4.010768, 4.610563>, 
      <-2.847097, -3.979696, 4.603492>, <-2.815716, -3.979696, 4.603492>, <-2.773875, -3.979696, 4.603492>, <-2.742494, -3.979696, 4.603492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.112959, -3.979696, 2.137484>, <-1.095152, -4.008128, 2.137484>, <-1.034681, -3.979696, 2.137484>, <-1.001134, -3.979696, 2.137484>, 
      <-1.112959, -3.979860, 1.537799>, <-1.095152, -4.008291, 1.537799>, <-1.034681, -3.979860, 1.537799>, <-1.001134, -3.979860, 1.537799>, 
      <-1.112959, -3.980119, 0.738219>, <-1.091615, -4.006001, 0.738219>, <-1.034681, -3.980119, 0.738219>, <-1.001134, -3.980119, 0.738219>, 
      <-1.112959, -3.980300, 0.138534>, <-1.091615, -4.006182, 0.138534>, <-1.034681, -3.980300, 0.138534>, <-1.001134, -3.980300, 0.138534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.112959, -3.979696, 4.709715>, <-1.079412, -3.979696, 4.709715>, <-1.034681, -3.979696, 4.709715>, <-1.001134, -3.979696, 4.709715>, 
      <-1.112959, -3.979696, 4.677848>, <-1.079412, -3.979696, 4.677848>, <-1.034681, -3.979696, 4.677848>, <-1.001134, -3.979696, 4.677848>, 
      <-1.112959, -3.979696, 4.635359>, <-1.079412, -3.979696, 4.635359>, <-1.034681, -3.979696, 4.635359>, <-1.001134, -3.979696, 4.635359>, 
      <-1.112959, -3.979696, 4.603492>, <-1.079412, -3.979696, 4.603492>, <-1.034681, -3.979696, 4.603492>, <-1.001134, -3.979696, 4.603492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.742494, -3.474092, 0.004395>, <-2.742494, -3.484944, 0.078919>, <-2.742494, -3.682104, 0.063340>, <-2.742494, -3.686280, 0.138534>, 
      <-2.891094, -3.520707, 0.004395>, <-2.891094, -3.531560, 0.078919>, <-2.835633, -3.699076, 0.063340>, <-2.835633, -3.703252, 0.138534>, 
      <-2.795256, -3.837550, 0.004395>, <-2.795166, -3.837537, 0.044637>, <-2.800430, -3.904563, 0.098293>, <-2.800340, -3.904550, 0.138534>, 
      <-2.857428, -3.980341, 0.004395>, <-2.857338, -3.980329, 0.044637>, <-2.857219, -3.980312, 0.098293>, <-2.857129, -3.980300, 0.138534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.001134, -3.980341, 0.004395>, <-1.001134, -3.980329, 0.044637>, <-1.001134, -3.980312, 0.098293>, <-1.001134, -3.980300, 0.138534>, 
      <-1.034681, -3.980341, 0.004395>, <-1.034681, -3.980329, 0.044637>, <-1.034681, -3.980312, 0.098293>, <-1.034681, -3.980300, 0.138534>, 
      <-1.098468, -4.010597, 0.004395>, <-1.098468, -4.010585, 0.044637>, <-1.091615, -4.006194, 0.098293>, <-1.091615, -4.006182, 0.138534>, 
      <-1.112959, -3.980341, 0.004395>, <-1.112959, -3.980329, 0.044637>, <-1.112959, -3.980312, 0.098293>, <-1.112959, -3.980300, 0.138534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.660383, -3.980341, 0.004395>, <0.659890, -4.018700, 0.016550>, <0.660047, -3.980312, 0.098293>, <0.659903, -3.980300, 0.138534>, 
      <0.467212, -3.980341, 0.004395>, <0.466718, -4.018700, 0.016550>, <0.467020, -3.980312, 0.098293>, <0.466876, -3.980300, 0.138534>, 
      <0.209650, -3.980341, 0.004395>, <0.209650, -3.980329, 0.044637>, <0.209506, -3.980312, 0.098293>, <0.209506, -3.980300, 0.138534>, 
      <0.016479, -3.980341, 0.004395>, <0.016479, -3.980329, 0.044637>, <0.016479, -3.980312, 0.098293>, <0.016479, -3.980300, 0.138534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.337423, -3.980341, 0.004395>, <1.337423, -3.980329, 0.044637>, <1.337423, -3.980312, 0.098293>, <1.337423, -3.980300, 0.138534>, 
      <1.134311, -3.980341, 0.004395>, <1.134311, -3.980329, 0.044637>, <1.134167, -3.980312, 0.098293>, <1.134167, -3.980300, 0.138534>, 
      <0.863495, -3.980341, 0.004395>, <0.863002, -4.018700, 0.016550>, <0.863303, -3.980312, 0.098293>, <0.863159, -3.980300, 0.138534>, 
      <0.660383, -3.980341, 0.004395>, <0.659890, -4.018700, 0.016550>, <0.660047, -3.980312, 0.098293>, <0.659903, -3.980300, 0.138534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.726863, -3.980341, 0.004395>, <3.726724, -3.980329, 0.044637>, <3.726499, -3.980312, 0.098293>, <3.726398, -3.980300, 0.138534>, 
      <3.010031, -3.980341, 0.004395>, <3.009892, -3.980329, 0.044637>, <3.009806, -3.980312, 0.098293>, <3.009705, -3.980300, 0.138534>, 
      <2.054255, -3.980341, 0.004395>, <2.054255, -3.980329, 0.044637>, <2.054115, -3.980312, 0.098293>, <2.054115, -3.980300, 0.138534>, 
      <1.337423, -3.980341, 0.004395>, <1.337423, -3.980329, 0.044637>, <1.337423, -3.980312, 0.098293>, <1.337423, -3.980300, 0.138534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.742494, -3.116095, 4.513169>, <-2.742494, -3.375175, 4.540266>, <-2.742494, -3.725698, 4.545685>, <-2.742494, -3.979696, 4.603492>, 
      <-2.773955, -3.375175, 4.513169>, <-2.773955, -3.634256, 4.540266>, <-2.773875, -3.725698, 4.545685>, <-2.773875, -3.979696, 4.603492>, 
      <-2.782820, -3.726820, 4.513169>, <-2.782758, -3.726820, 4.540266>, <-2.815777, -3.979696, 4.576395>, <-2.815716, -3.979696, 4.603492>, 
      <-2.847364, -3.979696, 4.513169>, <-2.847303, -3.979696, 4.540266>, <-2.847158, -3.979696, 4.576395>, <-2.847097, -3.979696, 4.603492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.001134, -3.979696, 4.513169>, <-1.001134, -3.979696, 4.540266>, <-1.001134, -3.979696, 4.576395>, <-1.001134, -3.979696, 4.603492>, 
      <-1.034681, -3.979696, 4.513169>, <-1.034681, -3.979696, 4.540266>, <-1.034681, -3.979696, 4.576395>, <-1.034681, -3.979696, 4.603492>, 
      <-1.103891, -4.011995, 4.513169>, <-1.103891, -4.011995, 4.540266>, <-1.079412, -3.979696, 4.576395>, <-1.079412, -3.979696, 4.603492>, 
      <-1.112959, -3.979696, 4.513169>, <-1.112959, -3.979696, 4.540266>, <-1.112959, -3.979696, 4.576395>, <-1.112959, -3.979696, 4.603492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.739275, -3.979696, 4.513169>, <3.739405, -3.979696, 4.540288>, <3.744018, -3.979696, 4.576393>, <3.742962, -3.979696, 4.603492>, 
      <3.018719, -3.979696, 4.513169>, <3.018850, -3.979696, 4.540288>, <3.022357, -3.979696, 4.576393>, <3.021300, -3.979696, 4.603492>, 
      <2.057979, -3.979696, 4.513169>, <2.057979, -3.979696, 4.540266>, <2.059085, -3.979696, 4.576395>, <2.059085, -3.979696, 4.603492>, 
      <1.337423, -3.979696, 4.513169>, <1.337423, -3.979696, 4.540266>, <1.337423, -3.979696, 4.576395>, <1.337423, -3.979696, 4.603492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.742494, -3.686280, 0.138534>, <-2.300111, -3.605668, 0.138534>, <-1.686124, -3.606435, 0.138534>, <-1.243601, -3.686280, 0.138534>, 
      <-2.742494, -3.682104, 0.063340>, <-2.300111, -3.601492, 0.063340>, <-1.686124, -3.602259, 0.063340>, <-1.243601, -3.682104, 0.063340>, 
      <-2.742494, -3.484944, 0.078919>, <-2.313441, -3.350353, 0.078919>, <-1.673023, -3.351536, 0.078919>, <-1.243601, -3.484944, 0.078919>, 
      <-2.742494, -3.474092, 0.004395>, <-2.313441, -3.339500, 0.004395>, <-1.673023, -3.340683, 0.004395>, <-1.243601, -3.474092, 0.004395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.742494, -3.592564, 2.137484>, <-2.305302, -3.487378, 2.137484>, <-1.681093, -3.488629, 2.137484>, <-1.243601, -3.592564, 2.137484>, 
      <-2.742494, -3.704677, 1.547701>, <-2.305302, -3.599491, 1.547701>, <-1.681093, -3.600741, 1.547701>, <-1.243601, -3.704677, 1.547701>, 
      <-2.742494, -3.719572, 0.737954>, <-2.300111, -3.638960, 0.737954>, <-1.686124, -3.639727, 0.737954>, <-1.243601, -3.719572, 0.737954>, 
      <-2.742494, -3.686280, 0.138534>, <-2.300111, -3.605668, 0.138534>, <-1.686124, -3.606435, 0.138534>, <-1.243601, -3.686280, 0.138534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.742494, -3.979696, 4.603492>, <-2.292826, -3.979696, 4.603492>, <-1.693269, -3.979696, 4.603492>, <-1.243601, -3.979696, 4.603492>, 
      <-2.742494, -3.725698, 4.545685>, <-2.292826, -3.725698, 4.545685>, <-1.693269, -3.725698, 4.545685>, <-1.243601, -3.725698, 4.545685>, 
      <-2.742494, -3.375175, 4.540266>, <-2.292826, -3.375175, 4.540266>, <-1.693269, -3.375175, 4.540266>, <-1.243601, -3.375175, 4.540266>, 
      <-2.742494, -3.116095, 4.513169>, <-2.292826, -3.116095, 4.513169>, <-1.693269, -3.116095, 4.513169>, <-1.243601, -3.116095, 4.513169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.742494, -3.979696, 4.709715>, <-2.292826, -3.979696, 4.709715>, <-1.693269, -3.979696, 4.709715>, <-1.243601, -3.979696, 4.709715>, 
      <-2.742494, -3.979696, 4.677848>, <-2.292826, -3.979696, 4.677848>, <-1.693269, -3.979696, 4.677848>, <-1.243601, -3.979696, 4.677848>, 
      <-2.742494, -4.010768, 4.610563>, <-2.292826, -4.010768, 4.610563>, <-1.693269, -4.010768, 4.610563>, <-1.243601, -4.010768, 4.610563>, 
      <-2.742494, -3.979696, 4.603492>, <-2.292826, -3.979696, 4.603492>, <-1.693269, -3.979696, 4.603492>, <-1.243601, -3.979696, 4.603492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.243601, -3.686280, 0.138534>, <-1.148614, -3.703419, 0.138534>, <-1.174369, -3.905834, 0.138534>, <-1.112959, -3.980300, 0.138534>, 
      <-1.243601, -3.682104, 0.063340>, <-1.148614, -3.699242, 0.063340>, <-1.174369, -3.905846, 0.098293>, <-1.112959, -3.980312, 0.098293>, 
      <-1.243601, -3.484944, 0.078919>, <-1.093813, -3.531479, 0.078919>, <-1.180713, -3.838867, 0.044637>, <-1.112959, -3.980329, 0.044637>, 
      <-1.243601, -3.474092, 0.004395>, <-1.093813, -3.520626, 0.004395>, <-1.180713, -3.838879, 0.004395>, <-1.112959, -3.980341, 0.004395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.243601, -3.592564, 2.137484>, <-1.124346, -3.620896, 2.137484>, <-1.178022, -3.875815, 2.137484>, <-1.112959, -3.979696, 2.137484>, 
      <-1.243601, -3.704677, 1.547701>, <-1.124346, -3.733008, 1.547701>, <-1.178022, -3.875978, 1.537799>, <-1.112959, -3.979860, 1.537799>, 
      <-1.243601, -3.719572, 0.737954>, <-1.148614, -3.736711, 0.737954>, <-1.174369, -3.905652, 0.738219>, <-1.112959, -3.980119, 0.738219>, 
      <-1.243601, -3.686280, 0.138534>, <-1.148614, -3.703419, 0.138534>, <-1.174369, -3.905834, 0.138534>, <-1.112959, -3.980300, 0.138534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.243601, -3.979696, 4.603492>, <-1.204409, -3.979696, 4.603492>, <-1.152152, -3.979696, 4.603492>, <-1.112959, -3.979696, 4.603492>, 
      <-1.243601, -3.725698, 4.545685>, <-1.204409, -3.725698, 4.545685>, <-1.152152, -3.979696, 4.576395>, <-1.112959, -3.979696, 4.576395>, 
      <-1.243601, -3.375175, 4.540266>, <-1.204409, -3.634256, 4.540266>, <-1.183789, -3.727423, 4.540266>, <-1.112959, -3.979696, 4.540266>, 
      <-1.243601, -3.116095, 4.513169>, <-1.204409, -3.375175, 4.513169>, <-1.183789, -3.727423, 4.513169>, <-1.112959, -3.979696, 4.513169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.243601, -3.979696, 4.709715>, <-1.204409, -3.979696, 4.709715>, <-1.152152, -3.979696, 4.709715>, <-1.112959, -3.979696, 4.709715>, 
      <-1.243601, -3.979696, 4.677848>, <-1.204409, -3.979696, 4.677848>, <-1.152152, -3.979696, 4.677848>, <-1.112959, -3.979696, 4.677848>, 
      <-1.243601, -4.010768, 4.610563>, <-1.204409, -4.010768, 4.610563>, <-1.152152, -3.979696, 4.635359>, <-1.112959, -3.979696, 4.635359>, 
      <-1.243601, -3.979696, 4.603492>, <-1.204409, -3.979696, 4.603492>, <-1.152152, -3.979696, 4.603492>, <-1.112959, -3.979696, 4.603492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.001134, -3.980300, 0.138534>, <-0.695850, -3.980300, 0.138534>, <-0.288805, -3.980300, 0.138534>, <0.016479, -3.980300, 0.138534>, 
      <-1.001134, -3.980312, 0.098293>, <-0.695850, -3.980312, 0.098293>, <-0.288805, -3.980312, 0.098293>, <0.016479, -3.980312, 0.098293>, 
      <-1.001134, -3.980329, 0.044637>, <-0.695850, -3.980329, 0.044637>, <-0.288805, -3.980329, 0.044637>, <0.016479, -3.980329, 0.044637>, 
      <-1.001134, -3.980341, 0.004395>, <-0.695850, -3.980341, 0.004395>, <-0.288805, -3.980341, 0.004395>, <0.016479, -3.980341, 0.004395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.001134, -3.979696, 2.137484>, <-0.695850, -3.979696, 2.137484>, <-0.288805, -3.979696, 2.137484>, <0.016479, -3.979696, 2.137484>, 
      <-1.001134, -3.979860, 1.537799>, <-0.695850, -3.979860, 1.537799>, <-0.288805, -3.979860, 1.537799>, <0.016479, -3.979860, 1.537799>, 
      <-1.001134, -3.980119, 0.738219>, <-0.695850, -3.980119, 0.738219>, <-0.288805, -3.980119, 0.738219>, <0.016479, -3.980119, 0.738219>, 
      <-1.001134, -3.980300, 0.138534>, <-0.695850, -3.980300, 0.138534>, <-0.288805, -3.980300, 0.138534>, <0.016479, -3.980300, 0.138534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.001134, -3.979696, 4.603492>, <-0.695850, -3.979696, 4.603492>, <-0.288805, -3.979696, 4.603492>, <0.016479, -3.979696, 4.603492>, 
      <-1.001134, -3.979696, 4.576395>, <-0.695850, -3.979696, 4.576395>, <-0.288805, -3.979696, 4.576395>, <0.016479, -3.979696, 4.576395>, 
      <-1.001134, -3.979696, 4.540266>, <-0.695850, -3.979696, 4.540266>, <-0.288805, -3.979696, 4.540266>, <0.016479, -3.979696, 4.540266>, 
      <-1.001134, -3.979696, 4.513169>, <-0.695850, -3.979696, 4.513169>, <-0.288805, -3.979696, 4.513169>, <0.016479, -3.979696, 4.513169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.001134, -3.979696, 4.709715>, <-0.695850, -3.979696, 4.709715>, <-0.288805, -3.979696, 4.709715>, <0.016479, -3.979696, 4.709715>, 
      <-1.001134, -3.979696, 4.677848>, <-0.695850, -3.979696, 4.677848>, <-0.288805, -3.979696, 4.677848>, <0.016479, -3.979696, 4.677848>, 
      <-1.001134, -3.979696, 4.635359>, <-0.695850, -3.979696, 4.635359>, <-0.288805, -3.979696, 4.635359>, <0.016479, -3.979696, 4.635359>, 
      <-1.001134, -3.979696, 4.603492>, <-0.695850, -3.979696, 4.603492>, <-0.288805, -3.979696, 4.603492>, <0.016479, -3.979696, 4.603492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.962919, -3.980300, 0.138534>, <-2.931182, -3.980300, 0.138534>, <-2.876166, -4.005694, 0.138534>, <-2.857129, -3.980300, 0.138534>, 
      <-2.962919, -3.980312, 0.098293>, <-2.931182, -3.980312, 0.098293>, <-2.876256, -4.005706, 0.098293>, <-2.857219, -3.980312, 0.098293>, 
      <-2.962919, -3.980329, 0.044637>, <-2.931272, -3.980329, 0.044637>, <-2.869972, -4.009345, 0.044637>, <-2.857338, -3.980329, 0.044637>, 
      <-2.962919, -3.980341, 0.004395>, <-2.931272, -3.980341, 0.004395>, <-2.870062, -4.009357, 0.004395>, <-2.857428, -3.980341, 0.004395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.962919, -3.979696, 2.137484>, <-2.929843, -3.979696, 2.137484>, <-2.869033, -4.008440, 2.137484>, <-2.852667, -3.979696, 2.137484>, 
      <-2.962919, -3.979860, 1.537799>, <-2.929843, -3.979860, 1.537799>, <-2.870371, -4.008603, 1.537799>, <-2.854006, -3.979860, 1.537799>, 
      <-2.962919, -3.980119, 0.738219>, <-2.931182, -3.980119, 0.738219>, <-2.874827, -4.005512, 0.738219>, <-2.855790, -3.980119, 0.738219>, 
      <-2.962919, -3.980300, 0.138534>, <-2.931182, -3.980300, 0.138534>, <-2.876166, -4.005694, 0.138534>, <-2.857129, -3.980300, 0.138534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.962919, -3.979696, 4.603492>, <-2.928173, -3.979696, 4.603492>, <-2.881844, -3.979696, 4.603492>, <-2.847097, -3.979696, 4.603492>, 
      <-2.962919, -3.979696, 4.576395>, <-2.928173, -3.979696, 4.576395>, <-2.881905, -3.979696, 4.576395>, <-2.847158, -3.979696, 4.576395>, 
      <-2.962919, -3.979696, 4.540266>, <-2.928253, -3.979696, 4.540266>, <-2.855876, -4.013286, 4.540266>, <-2.847303, -3.979696, 4.540266>, 
      <-2.962919, -3.979696, 4.513169>, <-2.928253, -3.979696, 4.513169>, <-2.855937, -4.013286, 4.513169>, <-2.847364, -3.979696, 4.513169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.962919, -3.979696, 4.709715>, <-2.928121, -3.979696, 4.709715>, <-2.881723, -3.979696, 4.709715>, <-2.846925, -3.979696, 4.709715>, 
      <-2.962919, -3.979696, 4.677848>, <-2.928121, -3.979696, 4.677848>, <-2.881789, -3.979696, 4.677848>, <-2.846991, -3.979696, 4.677848>, 
      <-2.962919, -3.979696, 4.635359>, <-2.928173, -3.979696, 4.635359>, <-2.881773, -3.979696, 4.635359>, <-2.847026, -3.979696, 4.635359>, 
      <-2.962919, -3.979696, 4.603492>, <-2.928173, -3.979696, 4.603492>, <-2.881844, -3.979696, 4.603492>, <-2.847097, -3.979696, 4.603492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.726398, -3.980300, 0.138534>, <-3.497354, -3.980300, 0.138534>, <-3.191963, -3.980300, 0.138534>, <-2.962919, -3.980300, 0.138534>, 
      <-3.726499, -3.980312, 0.098293>, <-3.497455, -3.980312, 0.098293>, <-3.191963, -3.980312, 0.098293>, <-2.962919, -3.980312, 0.098293>, 
      <-3.726724, -3.980329, 0.044637>, <-3.497541, -3.980329, 0.044637>, <-3.192102, -3.980329, 0.044637>, <-2.962919, -3.980329, 0.044637>, 
      <-3.726863, -3.980341, 0.004395>, <-3.497680, -3.980341, 0.004395>, <-3.192102, -3.980341, 0.004395>, <-2.962919, -3.980341, 0.004395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.721507, -3.979696, 2.137484>, <-3.493931, -3.979696, 2.137484>, <-3.190495, -3.979696, 2.137484>, <-2.962919, -3.979696, 2.137484>, 
      <-3.719959, -3.979860, 1.537799>, <-3.492382, -3.979860, 1.537799>, <-3.190495, -3.979860, 1.537799>, <-2.962919, -3.979860, 1.537799>, 
      <-3.724892, -3.980119, 0.738219>, <-3.495849, -3.980119, 0.738219>, <-3.191963, -3.980119, 0.738219>, <-2.962919, -3.980119, 0.738219>, 
      <-3.726398, -3.980300, 0.138534>, <-3.497354, -3.980300, 0.138534>, <-3.191963, -3.980300, 0.138534>, <-2.962919, -3.980300, 0.138534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.742962, -3.979696, 4.603492>, <-3.508950, -3.979696, 4.603492>, <-3.196932, -3.979696, 4.603492>, <-2.962919, -3.979696, 4.603492>, 
      <-3.744018, -3.979696, 4.576393>, <-3.510006, -3.979696, 4.576393>, <-3.196932, -3.979696, 4.576395>, <-2.962919, -3.979696, 4.576395>, 
      <-3.739405, -3.979696, 4.540288>, <-3.506499, -3.979696, 4.540288>, <-3.195826, -3.979696, 4.540266>, <-2.962919, -3.979696, 4.540266>, 
      <-3.739275, -3.979696, 4.513169>, <-3.506368, -3.979696, 4.513169>, <-3.195826, -3.979696, 4.513169>, <-2.962919, -3.979696, 4.513169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.731614, -3.979696, 4.709715>, <-3.501006, -3.979696, 4.709715>, <-3.193528, -3.979696, 4.709715>, <-2.962919, -3.979696, 4.709715>, 
      <-3.744860, -3.979696, 4.680532>, <-3.514251, -3.979696, 4.680532>, <-3.193528, -3.979696, 4.677848>, <-2.962919, -3.979696, 4.677848>, 
      <-3.741714, -3.979696, 4.635516>, <-3.507701, -3.979696, 4.635516>, <-3.196932, -3.979696, 4.635359>, <-2.962919, -3.979696, 4.635359>, 
      <-3.742962, -3.979696, 4.603492>, <-3.508950, -3.979696, 4.603492>, <-3.196932, -3.979696, 4.603492>, <-2.962919, -3.979696, 4.603492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.962919, -3.979696, 4.997980>, <-2.962919, -3.979696, 5.048252>, <-2.962919, -3.979696, 5.115282>, <-2.962919, -3.979696, 5.165554>, 
      <-3.143220, -3.979696, 4.997980>, <-3.143220, -3.979696, 5.048252>, <-3.050409, -3.979696, 5.115282>, <-3.050409, -3.979696, 5.165554>, 
      <-3.383622, -3.979696, 4.997980>, <-3.307307, -3.979696, 5.070900>, <-3.259873, -3.979696, 5.115282>, <-3.167061, -3.979696, 5.165554>, 
      <-3.563923, -3.979696, 4.997980>, <-3.487608, -3.979696, 5.070900>, <-3.347362, -3.979696, 5.115282>, <-3.254550, -3.979696, 5.165554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.846282, -3.979696, 4.997980>, <-2.846169, -3.979696, 5.048252>, <-2.846020, -3.979696, 5.115282>, <-2.845908, -3.979696, 5.165554>, 
      <-2.881273, -3.979696, 4.997980>, <-2.881161, -3.979696, 5.048252>, <-2.881124, -3.979696, 5.115282>, <-2.881011, -3.979696, 5.165554>, 
      <-2.927928, -3.979696, 4.997980>, <-2.927928, -3.979696, 5.048252>, <-2.927816, -3.979696, 5.115282>, <-2.927816, -3.979696, 5.165554>, 
      <-2.962919, -3.979696, 4.997980>, <-2.962919, -3.979696, 5.048252>, <-2.962919, -3.979696, 5.115282>, <-2.962919, -3.979696, 5.165554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.742494, -3.979696, 4.997980>, <-2.742494, -3.979696, 5.048252>, <-2.742494, -3.979696, 5.115282>, <-2.742494, -3.979696, 5.165554>, 
      <-2.773630, -3.979696, 4.997980>, <-2.773630, -3.979696, 5.048252>, <-2.773518, -3.979696, 5.115282>, <-2.773518, -3.979696, 5.165554>, 
      <-2.815145, -3.979696, 4.997980>, <-2.815033, -3.979696, 5.048252>, <-2.814996, -3.979696, 5.115282>, <-2.814883, -3.979696, 5.165554>, 
      <-2.846282, -3.979696, 4.997980>, <-2.846169, -3.979696, 5.048252>, <-2.846020, -3.979696, 5.115282>, <-2.845908, -3.979696, 5.165554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.243601, -3.979696, 4.997980>, <-1.243601, -3.979696, 5.048252>, <-1.243601, -3.979696, 5.115282>, <-1.243601, -3.979696, 5.165554>, 
      <-1.693269, -3.979696, 4.997980>, <-1.693269, -3.979696, 5.048252>, <-1.693269, -3.979696, 5.115282>, <-1.693269, -3.979696, 5.165554>, 
      <-2.292826, -3.979696, 4.997980>, <-2.292826, -3.979696, 5.048252>, <-2.292826, -3.979696, 5.115282>, <-2.292826, -3.979696, 5.165554>, 
      <-2.742494, -3.979696, 4.997980>, <-2.742494, -3.979696, 5.048252>, <-2.742494, -3.979696, 5.115282>, <-2.742494, -3.979696, 5.165554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.112959, -3.979696, 4.997980>, <-1.112959, -3.979696, 5.048252>, <-1.112959, -3.979696, 5.115282>, <-1.112959, -3.979696, 5.165554>, 
      <-1.152152, -3.979696, 4.997980>, <-1.152152, -3.979696, 5.048252>, <-1.152152, -3.979696, 5.115282>, <-1.152152, -3.979696, 5.165554>, 
      <-1.204409, -3.979696, 4.997980>, <-1.204409, -3.979696, 5.048252>, <-1.204409, -3.979696, 5.115282>, <-1.204409, -3.979696, 5.165554>, 
      <-1.243601, -3.979696, 4.997980>, <-1.243601, -3.979696, 5.048252>, <-1.243601, -3.979696, 5.115282>, <-1.243601, -3.979696, 5.165554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.001134, -3.979696, 4.997980>, <-1.001134, -3.979696, 5.048252>, <-1.001134, -3.979696, 5.115282>, <-1.001134, -3.979696, 5.165554>, 
      <-1.034681, -3.979696, 4.997980>, <-1.034681, -3.979696, 5.048252>, <-1.034681, -3.979696, 5.115282>, <-1.034681, -3.979696, 5.165554>, 
      <-1.079412, -3.979696, 4.997980>, <-1.079412, -3.979696, 5.048252>, <-1.079412, -3.979696, 5.115282>, <-1.079412, -3.979696, 5.165554>, 
      <-1.112959, -3.979696, 4.997980>, <-1.112959, -3.979696, 5.048252>, <-1.112959, -3.979696, 5.115282>, <-1.112959, -3.979696, 5.165554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016479, -3.979696, 4.997980>, <0.016479, -3.979696, 5.048252>, <0.016479, -3.979696, 5.115282>, <0.016479, -3.979696, 5.165554>, 
      <-0.288805, -3.979696, 4.997980>, <-0.288805, -3.979696, 5.048252>, <-0.288805, -3.979696, 5.115282>, <-0.288805, -3.979696, 5.165554>, 
      <-0.695850, -3.979696, 4.997980>, <-0.695850, -3.979696, 5.048252>, <-0.695850, -3.979696, 5.115282>, <-0.695850, -3.979696, 5.165554>, 
      <-1.001134, -3.979696, 4.997980>, <-1.001134, -3.979696, 5.048252>, <-1.001134, -3.979696, 5.115282>, <-1.001134, -3.979696, 5.165554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.642517, -3.979696, 4.997980>, <0.642337, -3.979696, 5.048252>, <0.642097, -3.979696, 5.115282>, <0.641917, -3.979696, 5.165554>, 
      <0.454705, -3.979696, 4.997980>, <0.454525, -3.979696, 5.048252>, <0.454465, -3.979696, 5.115282>, <0.454286, -3.979696, 5.165554>, 
      <0.204290, -3.979696, 4.997980>, <0.204290, -3.979696, 5.048252>, <0.204110, -3.979696, 5.115282>, <0.204110, -3.979696, 5.165554>, 
      <0.016479, -3.979696, 4.997980>, <0.016479, -3.979696, 5.048252>, <0.016479, -3.979696, 5.115282>, <0.016479, -3.979696, 5.165554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.337423, -3.979696, 4.997980>, <1.337423, -3.979696, 5.048252>, <1.337423, -3.979696, 5.115282>, <1.337423, -3.979696, 5.165554>, 
      <1.128951, -3.979696, 4.997980>, <1.128951, -3.979696, 5.048252>, <1.128771, -3.979696, 5.115282>, <1.128771, -3.979696, 5.165554>, 
      <0.850989, -3.979696, 4.997980>, <0.850809, -3.979696, 5.048252>, <0.850749, -3.979696, 5.115282>, <0.850569, -3.979696, 5.165554>, 
      <0.642517, -3.979696, 4.997980>, <0.642337, -3.979696, 5.048252>, <0.642097, -3.979696, 5.115282>, <0.641917, -3.979696, 5.165554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.563923, -3.979696, 4.997980>, <3.487608, -3.979696, 5.070900>, <3.347362, -3.979696, 5.115282>, <3.254550, -3.979696, 5.165554>, 
      <2.895973, -3.979696, 4.997980>, <2.819658, -3.979696, 5.070900>, <2.772224, -3.979696, 5.115282>, <2.679412, -3.979696, 5.165554>, 
      <2.005373, -3.979696, 4.997980>, <2.005373, -3.979696, 5.048252>, <1.912561, -3.979696, 5.115282>, <1.912561, -3.979696, 5.165554>, 
      <1.337423, -3.979696, 4.997980>, <1.337423, -3.979696, 5.048252>, <1.337423, -3.979696, 5.115282>, <1.337423, -3.979696, 5.165554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.962919, -3.979696, 4.709715>, <-2.962919, -3.979696, 4.796194>, <-2.962919, -3.979696, 4.911500>, <-2.962919, -3.979696, 4.997980>, 
      <-3.193528, -3.979696, 4.709715>, <-3.193528, -3.979696, 4.796194>, <-3.143220, -3.979696, 4.911500>, <-3.143220, -3.979696, 4.997980>, 
      <-3.501006, -3.979696, 4.709715>, <-3.459658, -3.979696, 4.800819>, <-3.455957, -3.979696, 4.928863>, <-3.383622, -3.979696, 4.997980>, 
      <-3.731614, -3.979696, 4.709715>, <-3.690267, -3.979696, 4.800819>, <-3.636258, -3.979696, 4.928863>, <-3.563923, -3.979696, 4.997980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.846925, -3.979696, 4.709715>, <-2.846746, -3.979696, 4.796194>, <-2.846475, -3.979696, 4.911500>, <-2.846282, -3.979696, 4.997980>, 
      <-2.881723, -3.979696, 4.709715>, <-2.881545, -3.979696, 4.796194>, <-2.881466, -3.979696, 4.911500>, <-2.881273, -3.979696, 4.997980>, 
      <-2.928121, -3.979696, 4.709715>, <-2.928121, -3.979696, 4.796194>, <-2.927928, -3.979696, 4.911500>, <-2.927928, -3.979696, 4.997980>, 
      <-2.962919, -3.979696, 4.709715>, <-2.962919, -3.979696, 4.796194>, <-2.962919, -3.979696, 4.911500>, <-2.962919, -3.979696, 4.997980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.742494, -3.979696, 4.709715>, <-2.742494, -3.979696, 4.796194>, <-2.742494, -3.979696, 4.911500>, <-2.742494, -3.979696, 4.997980>, 
      <-2.773823, -3.979696, 4.709715>, <-2.773823, -3.979696, 4.796194>, <-2.773630, -3.979696, 4.911500>, <-2.773630, -3.979696, 4.997980>, 
      <-2.815596, -3.979696, 4.709715>, <-2.815417, -3.979696, 4.796194>, <-2.815339, -3.979696, 4.911500>, <-2.815145, -3.979696, 4.997980>, 
      <-2.846925, -3.979696, 4.709715>, <-2.846746, -3.979696, 4.796194>, <-2.846475, -3.979696, 4.911500>, <-2.846282, -3.979696, 4.997980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.243601, -3.979696, 4.709715>, <-1.243601, -3.979696, 4.796194>, <-1.243601, -3.979696, 4.911500>, <-1.243601, -3.979696, 4.997980>, 
      <-1.693269, -3.979696, 4.709715>, <-1.693269, -3.979696, 4.796194>, <-1.693269, -3.979696, 4.911500>, <-1.693269, -3.979696, 4.997980>, 
      <-2.292826, -3.979696, 4.709715>, <-2.292826, -3.979696, 4.796194>, <-2.292826, -3.979696, 4.911500>, <-2.292826, -3.979696, 4.997980>, 
      <-2.742494, -3.979696, 4.709715>, <-2.742494, -3.979696, 4.796194>, <-2.742494, -3.979696, 4.911500>, <-2.742494, -3.979696, 4.997980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.112959, -3.979696, 4.709715>, <-1.112959, -3.979696, 4.796194>, <-1.112959, -3.979696, 4.911500>, <-1.112959, -3.979696, 4.997980>, 
      <-1.152152, -3.979696, 4.709715>, <-1.152152, -3.979696, 4.796194>, <-1.152152, -3.979696, 4.911500>, <-1.152152, -3.979696, 4.997980>, 
      <-1.204409, -3.979696, 4.709715>, <-1.204409, -3.979696, 4.796194>, <-1.204409, -3.979696, 4.911500>, <-1.204409, -3.979696, 4.997980>, 
      <-1.243601, -3.979696, 4.709715>, <-1.243601, -3.979696, 4.796194>, <-1.243601, -3.979696, 4.911500>, <-1.243601, -3.979696, 4.997980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.001134, -3.979696, 4.709715>, <-1.001134, -3.979696, 4.796194>, <-1.001134, -3.979696, 4.911500>, <-1.001134, -3.979696, 4.997980>, 
      <-1.034681, -3.979696, 4.709715>, <-1.034681, -3.979696, 4.796194>, <-1.034681, -3.979696, 4.911500>, <-1.034681, -3.979696, 4.997980>, 
      <-1.079412, -3.979696, 4.709715>, <-1.079412, -3.979696, 4.796194>, <-1.079412, -3.979696, 4.911500>, <-1.079412, -3.979696, 4.997980>, 
      <-1.112959, -3.979696, 4.709715>, <-1.112959, -3.979696, 4.796194>, <-1.112959, -3.979696, 4.911500>, <-1.112959, -3.979696, 4.997980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016479, -3.979696, 4.709715>, <0.016479, -3.979696, 4.796194>, <0.016479, -3.979696, 4.911500>, <0.016479, -3.979696, 4.997980>, 
      <-0.288805, -3.979696, 4.709715>, <-0.288805, -3.979696, 4.796194>, <-0.288805, -3.979696, 4.911500>, <-0.288805, -3.979696, 4.997980>, 
      <-0.695850, -3.979696, 4.709715>, <-0.695850, -3.979696, 4.796194>, <-0.695850, -3.979696, 4.911500>, <-0.695850, -3.979696, 4.997980>, 
      <-1.001134, -3.979696, 4.709715>, <-1.001134, -3.979696, 4.796194>, <-1.001134, -3.979696, 4.911500>, <-1.001134, -3.979696, 4.997980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.643548, -3.979696, 4.709715>, <0.643239, -3.979696, 4.796194>, <0.642826, -3.979696, 4.911500>, <0.642517, -3.979696, 4.997980>, 
      <0.455427, -3.979696, 4.709715>, <0.455118, -3.979696, 4.796194>, <0.455015, -3.979696, 4.911500>, <0.454705, -3.979696, 4.997980>, 
      <0.204599, -3.979696, 4.709715>, <0.204599, -3.979696, 4.796194>, <0.204290, -3.979696, 4.911500>, <0.204290, -3.979696, 4.997980>, 
      <0.016479, -3.979696, 4.709715>, <0.016479, -3.979696, 4.796194>, <0.016479, -3.979696, 4.911500>, <0.016479, -3.979696, 4.997980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.337423, -3.979696, 4.709715>, <1.337423, -3.979696, 4.796194>, <1.337423, -3.979696, 4.911500>, <1.337423, -3.979696, 4.997980>, 
      <1.129260, -3.979696, 4.709715>, <1.129260, -3.979696, 4.796194>, <1.128951, -3.979696, 4.911500>, <1.128951, -3.979696, 4.997980>, 
      <0.851710, -3.979696, 4.709715>, <0.851401, -3.979696, 4.796194>, <0.851298, -3.979696, 4.911500>, <0.850989, -3.979696, 4.997980>, 
      <0.643548, -3.979696, 4.709715>, <0.643239, -3.979696, 4.796194>, <0.642826, -3.979696, 4.911500>, <0.642517, -3.979696, 4.997980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.731614, -3.979696, 4.709715>, <3.690267, -3.979696, 4.800819>, <3.636258, -3.979696, 4.928863>, <3.563923, -3.979696, 4.997980>, 
      <3.013357, -3.979696, 4.709715>, <2.972009, -3.979696, 4.800819>, <2.968308, -3.979696, 4.928863>, <2.895973, -3.979696, 4.997980>, 
      <2.055681, -3.979696, 4.709715>, <2.055681, -3.979696, 4.796194>, <2.005373, -3.979696, 4.911500>, <2.005373, -3.979696, 4.997980>, 
      <1.337423, -3.979696, 4.709715>, <1.337423, -3.979696, 4.796194>, <1.337423, -3.979696, 4.911500>, <1.337423, -3.979696, 4.997980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.962919, -3.979696, 2.354788>, <-2.962919, -3.979696, 3.002302>, <-2.962919, -3.979696, 3.865655>, <-2.962919, -3.979696, 4.513169>, 
      <-3.193679, -3.979696, 2.354788>, <-3.193679, -3.979696, 3.002302>, <-3.195826, -3.979696, 3.865655>, <-3.195826, -3.979696, 4.513169>, 
      <-3.501360, -3.979696, 2.354788>, <-3.506202, -3.979696, 3.002288>, <-3.503246, -3.979696, 3.865659>, <-3.506368, -3.979696, 4.513169>, 
      <-3.732120, -3.979696, 2.354788>, <-3.736962, -3.979696, 3.002288>, <-3.736153, -3.979696, 3.865659>, <-3.739275, -3.979696, 4.513169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.852182, -3.979696, 2.354788>, <-2.850736, -3.979696, 3.002302>, <-2.848828, -3.979696, 3.865655>, <-2.847364, -3.979696, 4.513169>, 
      <-2.861973, -4.011442, 2.354788>, <-2.860527, -4.011442, 3.002302>, <-2.857402, -4.013286, 3.865655>, <-2.855937, -4.013286, 4.513169>, 
      <-2.929698, -3.979696, 2.354788>, <-2.929698, -3.979696, 3.002302>, <-2.928253, -3.979696, 3.865655>, <-2.928253, -3.979696, 4.513169>, 
      <-2.962919, -3.979696, 2.354788>, <-2.962919, -3.979696, 3.002302>, <-2.962919, -3.979696, 3.865655>, <-2.962919, -3.979696, 4.513169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.742494, -3.264992, 2.354788>, <-2.742494, -3.137358, 2.991168>, <-2.742494, -3.160764, 3.865655>, <-2.742494, -3.116095, 4.513169>, 
      <-2.940730, -3.353069, 2.354788>, <-2.940730, -3.225436, 2.991168>, <-2.773955, -3.419844, 3.865655>, <-2.773955, -3.375175, 4.513169>, 
      <-2.788251, -3.772409, 2.354788>, <-2.786806, -3.772409, 3.002302>, <-2.784284, -3.726820, 3.865655>, <-2.782820, -3.726820, 4.513169>, 
      <-2.852182, -3.979696, 2.354788>, <-2.850736, -3.979696, 3.002302>, <-2.848828, -3.979696, 3.865655>, <-2.847364, -3.979696, 4.513169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.243601, -3.264992, 2.354788>, <-1.243601, -3.137358, 2.991168>, <-1.243601, -3.160764, 3.865655>, <-1.243601, -3.116095, 4.513169>, 
      <-1.655402, -3.084378, 2.354788>, <-1.655402, -2.956745, 2.991168>, <-1.693269, -3.160764, 3.865655>, <-1.693269, -3.116095, 4.513169>, 
      <-2.331562, -3.082411, 2.354788>, <-2.331562, -2.954778, 2.991168>, <-2.292826, -3.160764, 3.865655>, <-2.292826, -3.116095, 4.513169>, 
      <-2.742494, -3.264992, 2.354788>, <-2.742494, -3.137358, 2.991168>, <-2.742494, -3.160764, 3.865655>, <-2.742494, -3.116095, 4.513169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.112959, -3.979696, 2.354788>, <-1.112959, -3.979696, 3.002302>, <-1.112959, -3.979696, 3.865655>, <-1.112959, -3.979696, 4.513169>, 
      <-1.182985, -3.773287, 2.354788>, <-1.182985, -3.773287, 3.002302>, <-1.183789, -3.727423, 3.865655>, <-1.183789, -3.727423, 4.513169>, 
      <-1.043992, -3.352539, 2.354788>, <-1.043992, -3.224906, 2.991168>, <-1.204409, -3.419844, 3.865655>, <-1.204409, -3.375175, 4.513169>, 
      <-1.243601, -3.264992, 2.354788>, <-1.243601, -3.137358, 2.991168>, <-1.243601, -3.160764, 3.865655>, <-1.243601, -3.116095, 4.513169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.001134, -3.979696, 2.354788>, <-1.001134, -3.979696, 3.002302>, <-1.001134, -3.979696, 3.865655>, <-1.001134, -3.979696, 4.513169>, 
      <-1.034681, -3.979696, 2.354788>, <-1.034681, -3.979696, 3.002302>, <-1.034681, -3.979696, 3.865655>, <-1.034681, -3.979696, 4.513169>, 
      <-1.102181, -4.011466, 2.354788>, <-1.102181, -4.011466, 3.002302>, <-1.103891, -4.011995, 3.865655>, <-1.103891, -4.011995, 4.513169>, 
      <-1.112959, -3.979696, 2.354788>, <-1.112959, -3.979696, 3.002302>, <-1.112959, -3.979696, 3.865655>, <-1.112959, -3.979696, 4.513169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016479, -3.979696, 2.354788>, <0.016479, -3.979696, 3.002302>, <0.016479, -3.979696, 3.865655>, <0.016479, -3.979696, 4.513169>, 
      <-0.288805, -3.979696, 2.354788>, <-0.288805, -3.979696, 3.002302>, <-0.288805, -3.979696, 3.865655>, <-0.288805, -3.979696, 4.513169>, 
      <-0.695850, -3.979696, 2.354788>, <-0.695850, -3.979696, 3.002302>, <-0.695850, -3.979696, 3.865655>, <-0.695850, -3.979696, 4.513169>, 
      <-1.001134, -3.979696, 2.354788>, <-1.001134, -3.979696, 3.002302>, <-1.001134, -3.979696, 3.865655>, <-1.001134, -3.979696, 4.513169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.651973, -3.979696, 2.354788>, <0.649657, -3.979696, 3.002302>, <0.646568, -3.979696, 3.865655>, <0.644251, -3.979696, 4.513169>, 
      <0.461325, -3.979696, 2.354788>, <0.459008, -3.979696, 3.002302>, <0.458236, -3.979696, 3.865655>, <0.455919, -3.979696, 4.513169>, 
      <0.207127, -3.979696, 2.354788>, <0.207127, -3.979696, 3.002302>, <0.204810, -3.979696, 3.865655>, <0.204810, -3.979696, 4.513169>, 
      <0.016479, -3.979696, 2.354788>, <0.016479, -3.979696, 3.002302>, <0.016479, -3.979696, 3.865655>, <0.016479, -3.979696, 4.513169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.337423, -3.979696, 2.354788>, <1.337423, -3.979696, 3.002302>, <1.337423, -3.979696, 3.865655>, <1.337423, -3.979696, 4.513169>, 
      <1.131788, -3.979696, 2.354788>, <1.131788, -3.979696, 3.002302>, <1.129471, -3.979696, 3.865655>, <1.129471, -3.979696, 4.513169>, 
      <0.857608, -3.979696, 2.354788>, <0.855292, -3.979696, 3.002302>, <0.854519, -3.979696, 3.865655>, <0.852203, -3.979696, 4.513169>, 
      <0.651973, -3.979696, 2.354788>, <0.649657, -3.979696, 3.002302>, <0.646568, -3.979696, 3.865655>, <0.644251, -3.979696, 4.513169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.732120, -3.979696, 2.354788>, <3.736962, -3.979696, 3.002288>, <3.736153, -3.979696, 3.865659>, <3.739275, -3.979696, 4.513169>, 
      <3.013711, -3.979696, 2.354788>, <3.018553, -3.979696, 3.002288>, <3.015597, -3.979696, 3.865659>, <3.018719, -3.979696, 4.513169>, 
      <2.055832, -3.979696, 2.354788>, <2.055832, -3.979696, 3.002302>, <2.057979, -3.979696, 3.865655>, <2.057979, -3.979696, 4.513169>, 
      <1.337423, -3.979696, 2.354788>, <1.337423, -3.979696, 3.002302>, <1.337423, -3.979696, 3.865655>, <1.337423, -3.979696, 4.513169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.962919, -3.979696, 2.137484>, <-2.962919, -3.979679, 2.202675>, <-2.962919, -3.979696, 2.289597>, <-2.962919, -3.979696, 2.354788>, 
      <-3.190495, -3.979696, 2.137484>, <-3.190495, -3.979679, 2.202675>, <-3.193679, -3.979696, 2.289597>, <-3.193679, -3.979696, 2.354788>, 
      <-3.493931, -3.979696, 2.137484>, <-3.494099, -3.979678, 2.202752>, <-3.500872, -3.979696, 2.289521>, <-3.501360, -3.979696, 2.354788>, 
      <-3.721507, -3.979696, 2.137484>, <-3.721676, -3.979678, 2.202752>, <-3.731632, -3.979696, 2.289521>, <-3.732120, -3.979696, 2.354788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.852667, -3.979696, 2.137484>, <-2.852521, -3.979679, 2.202675>, <-2.852327, -3.979696, 2.289597>, <-2.852182, -3.979696, 2.354788>, 
      <-2.869033, -4.008440, 2.137484>, <-2.868887, -4.008422, 2.202675>, <-2.862118, -4.011442, 2.289597>, <-2.861973, -4.011442, 2.354788>, 
      <-2.929843, -3.979696, 2.137484>, <-2.929843, -3.979679, 2.202675>, <-2.929698, -3.979696, 2.289597>, <-2.929698, -3.979696, 2.354788>, 
      <-2.962919, -3.979696, 2.137484>, <-2.962919, -3.979679, 2.202675>, <-2.962919, -3.979696, 2.289597>, <-2.962919, -3.979696, 2.354788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.742494, -3.592564, 2.137484>, <-2.742494, -3.570542, 2.253338>, <-2.742494, -3.288182, 2.239161>, <-2.742494, -3.264992, 2.354788>, 
      <-2.859895, -3.620810, 2.137484>, <-2.859895, -3.598788, 2.253338>, <-2.940730, -3.376260, 2.239161>, <-2.940730, -3.353069, 2.354788>, 
      <-2.792920, -3.874762, 2.137484>, <-2.792774, -3.874745, 2.202675>, <-2.788397, -3.772409, 2.289597>, <-2.788251, -3.772409, 2.354788>, 
      <-2.852667, -3.979696, 2.137484>, <-2.852521, -3.979679, 2.202675>, <-2.852327, -3.979696, 2.289597>, <-2.852182, -3.979696, 2.354788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.243601, -3.592564, 2.137484>, <-1.243601, -3.570542, 2.253338>, <-1.243601, -3.288182, 2.239161>, <-1.243601, -3.264992, 2.354788>, 
      <-1.681093, -3.488629, 2.137484>, <-1.681093, -3.466606, 2.253338>, <-1.655402, -3.107568, 2.239161>, <-1.655402, -3.084378, 2.354788>, 
      <-2.305302, -3.487378, 2.137484>, <-2.305302, -3.465356, 2.253338>, <-2.331562, -3.105601, 2.239161>, <-2.331562, -3.082411, 2.354788>, 
      <-2.742494, -3.592564, 2.137484>, <-2.742494, -3.570542, 2.253338>, <-2.742494, -3.288182, 2.239161>, <-2.742494, -3.264992, 2.354788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.112959, -3.979696, 2.137484>, <-1.112959, -3.979679, 2.202675>, <-1.112959, -3.979696, 2.289597>, <-1.112959, -3.979696, 2.354788>, 
      <-1.178022, -3.875815, 2.137484>, <-1.178022, -3.875798, 2.202675>, <-1.182985, -3.773287, 2.289597>, <-1.182985, -3.773287, 2.354788>, 
      <-1.124346, -3.620896, 2.137484>, <-1.124346, -3.598873, 2.253338>, <-1.043992, -3.375729, 2.239161>, <-1.043992, -3.352539, 2.354788>, 
      <-1.243601, -3.592564, 2.137484>, <-1.243601, -3.570542, 2.253338>, <-1.243601, -3.288182, 2.239161>, <-1.243601, -3.264992, 2.354788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.001134, -3.979696, 2.137484>, <-1.001134, -3.979679, 2.202675>, <-1.001134, -3.979696, 2.289597>, <-1.001134, -3.979696, 2.354788>, 
      <-1.034681, -3.979696, 2.137484>, <-1.034681, -3.979679, 2.202675>, <-1.034681, -3.979696, 2.289597>, <-1.034681, -3.979696, 2.354788>, 
      <-1.095152, -4.008128, 2.137484>, <-1.095152, -4.008110, 2.202675>, <-1.102181, -4.011466, 2.289597>, <-1.102181, -4.011466, 2.354788>, 
      <-1.112959, -3.979696, 2.137484>, <-1.112959, -3.979679, 2.202675>, <-1.112959, -3.979696, 2.289597>, <-1.112959, -3.979696, 2.354788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016479, -3.979696, 2.137484>, <0.016479, -3.979679, 2.202675>, <0.016479, -3.979696, 2.289597>, <0.016479, -3.979696, 2.354788>, 
      <-0.288805, -3.979696, 2.137484>, <-0.288805, -3.979679, 2.202675>, <-0.288805, -3.979696, 2.289597>, <-0.288805, -3.979696, 2.354788>, 
      <-0.695850, -3.979696, 2.137484>, <-0.695850, -3.979679, 2.202675>, <-0.695850, -3.979696, 2.289597>, <-0.695850, -3.979696, 2.354788>, 
      <-1.001134, -3.979696, 2.137484>, <-1.001134, -3.979679, 2.202675>, <-1.001134, -3.979696, 2.289597>, <-1.001134, -3.979696, 2.354788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.652751, -3.979696, 2.137484>, <0.652518, -3.979679, 2.202675>, <0.652207, -3.979696, 2.289597>, <0.651973, -3.979696, 2.354788>, 
      <0.461869, -3.979696, 2.137484>, <0.461636, -3.979679, 2.202675>, <0.461558, -3.979696, 2.289597>, <0.461325, -3.979696, 2.354788>, 
      <0.207360, -3.979696, 2.137484>, <0.207360, -3.979679, 2.202675>, <0.207127, -3.979696, 2.289597>, <0.207127, -3.979696, 2.354788>, 
      <0.016479, -3.979696, 2.137484>, <0.016479, -3.979679, 2.202675>, <0.016479, -3.979696, 2.289597>, <0.016479, -3.979696, 2.354788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.337423, -3.979696, 2.137484>, <1.337423, -3.979679, 2.202675>, <1.337423, -3.979696, 2.289597>, <1.337423, -3.979696, 2.354788>, 
      <1.132021, -3.979696, 2.137484>, <1.132021, -3.979679, 2.202675>, <1.131788, -3.979696, 2.289597>, <1.131788, -3.979696, 2.354788>, 
      <0.858153, -3.979696, 2.137484>, <0.857919, -3.979679, 2.202675>, <0.857842, -3.979696, 2.289597>, <0.857608, -3.979696, 2.354788>, 
      <0.652751, -3.979696, 2.137484>, <0.652518, -3.979679, 2.202675>, <0.652207, -3.979696, 2.289597>, <0.651973, -3.979696, 2.354788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.721507, -3.979696, 2.137484>, <3.721676, -3.979678, 2.202752>, <3.731632, -3.979696, 2.289521>, <3.732120, -3.979696, 2.354788>, 
      <3.006282, -3.979696, 2.137484>, <3.006450, -3.979678, 2.202752>, <3.013223, -3.979696, 2.289521>, <3.013711, -3.979696, 2.354788>, 
      <2.052648, -3.979696, 2.137484>, <2.052648, -3.979679, 2.202675>, <2.055832, -3.979696, 2.289597>, <2.055832, -3.979696, 2.354788>, 
      <1.337423, -3.979696, 2.137484>, <1.337423, -3.979679, 2.202675>, <1.337423, -3.979696, 2.289597>, <1.337423, -3.979696, 2.354788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.962919, -3.980799, -1.519862>, <-2.962919, -3.980678, -1.062585>, <-2.962919, -3.980478, -0.452882>, <-2.962919, -3.980341, 0.004395>, 
      <-3.193679, -3.980799, -1.519862>, <-3.193679, -3.980678, -1.062585>, <-3.192102, -3.980478, -0.452882>, <-3.192102, -3.980341, 0.004395>, 
      <-3.501360, -3.980799, -1.519862>, <-3.500102, -3.980678, -1.062584>, <-3.499258, -3.980478, -0.452882>, <-3.497680, -3.980341, 0.004395>, 
      <-3.732120, -3.980799, -1.519862>, <-3.730862, -3.980678, -1.062584>, <-3.728440, -3.980478, -0.452882>, <-3.726863, -3.980341, 0.004395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.860831, -3.980799, -1.519862>, <-2.859810, -3.980678, -1.062585>, <-2.858449, -3.980478, -0.452882>, <-2.857428, -3.980341, 0.004395>, 
      <-2.872478, -4.009124, -1.519862>, <-2.871458, -4.009003, -1.062585>, <-2.871083, -4.009495, -0.452882>, <-2.870062, -4.009357, 0.004395>, 
      <-2.932293, -3.980799, -1.519862>, <-2.932293, -3.980678, -1.062585>, <-2.931272, -3.980478, -0.452882>, <-2.931272, -3.980341, 0.004395>, 
      <-2.962919, -3.980799, -1.519862>, <-2.962919, -3.980678, -1.062585>, <-2.962919, -3.980478, -0.452882>, <-2.962919, -3.980341, 0.004395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.742494, -3.444770, -1.519862>, <-2.742494, -3.453566, -1.062585>, <-2.742494, -3.408182, -0.448193>, <-2.742494, -3.474092, 0.004395>, 
      <-2.777995, -3.605579, -1.519862>, <-2.777995, -3.614375, -1.062585>, <-2.891094, -3.454797, -0.448193>, <-2.891094, -3.520707, 0.004395>, 
      <-2.798199, -3.828493, -1.519862>, <-2.797179, -3.828372, -1.062585>, <-2.796276, -3.837687, -0.452882>, <-2.795256, -3.837550, 0.004395>, 
      <-2.860831, -3.980799, -1.519862>, <-2.859810, -3.980678, -1.062585>, <-2.858449, -3.980478, -0.452882>, <-2.857428, -3.980341, 0.004395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.243601, -3.444770, -1.519862>, <-1.243601, -3.453566, -1.062585>, <-1.243601, -3.408182, -0.448193>, <-1.243601, -3.474092, 0.004395>, 
      <-1.693269, -3.444770, -1.519862>, <-1.693269, -3.453566, -1.062585>, <-1.673023, -3.274773, -0.448193>, <-1.673023, -3.340683, 0.004395>, 
      <-2.292826, -3.444770, -1.519862>, <-2.292826, -3.453566, -1.062585>, <-2.313441, -3.273590, -0.448193>, <-2.313441, -3.339500, 0.004395>, 
      <-2.742494, -3.444770, -1.519862>, <-2.742494, -3.453566, -1.062585>, <-2.742494, -3.408182, -0.448193>, <-2.742494, -3.474092, 0.004395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.112959, -3.980799, -1.519862>, <-1.112959, -3.980678, -1.062585>, <-1.112959, -3.980478, -0.452882>, <-1.112959, -3.980341, 0.004395>, 
      <-1.181175, -3.829994, -1.519862>, <-1.181175, -3.829873, -1.062585>, <-1.180713, -3.839016, -0.452882>, <-1.180713, -3.838879, 0.004395>, 
      <-1.204409, -3.605579, -1.519862>, <-1.204409, -3.614375, -1.062585>, <-1.093813, -3.454717, -0.448193>, <-1.093813, -3.520626, 0.004395>, 
      <-1.243601, -3.444770, -1.519862>, <-1.243601, -3.453566, -1.062585>, <-1.243601, -3.408182, -0.448193>, <-1.243601, -3.474092, 0.004395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.001134, -3.980799, -1.519862>, <-1.001134, -3.980678, -1.062585>, <-1.001134, -3.980478, -0.452882>, <-1.001134, -3.980341, 0.004395>, 
      <-1.034681, -3.980799, -1.519862>, <-1.034681, -3.980678, -1.062585>, <-1.034681, -3.980478, -0.452882>, <-1.034681, -3.980341, 0.004395>, 
      <-1.099133, -4.011365, -1.519862>, <-1.099133, -4.011244, -1.062585>, <-1.098468, -4.010734, -0.452882>, <-1.098468, -4.010597, 0.004395>, 
      <-1.112959, -3.980799, -1.519862>, <-1.112959, -3.980678, -1.062585>, <-1.112959, -3.980478, -0.452882>, <-1.112959, -3.980341, 0.004395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016479, -3.980799, -1.519862>, <0.016479, -3.980678, -1.062585>, <0.016479, -3.980478, -0.452882>, <0.016479, -3.980341, 0.004395>, 
      <-0.288733, -3.974304, -1.521115>, <-0.288733, -3.974183, -1.063838>, <-0.288805, -3.980478, -0.452882>, <-0.288805, -3.980341, 0.004395>, 
      <-0.695850, -3.980799, -1.519862>, <-0.695850, -3.980678, -1.062585>, <-0.695850, -3.980478, -0.452882>, <-0.695850, -3.980341, 0.004395>, 
      <-1.001134, -3.980799, -1.519862>, <-1.001134, -3.980678, -1.062585>, <-1.001134, -3.980478, -0.452882>, <-1.001134, -3.980341, 0.004395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.666675, -4.016288, -1.513013>, <0.666167, -3.824968, -1.452438>, <0.665421, -3.548083, -1.519783>, <0.664883, -3.347424, -1.522685>, 
      <0.471315, -4.016288, -1.513013>, <0.470807, -3.824968, -1.452438>, <0.484564, -3.548083, -1.498816>, <0.484026, -3.347424, -1.501717>, 
      <0.211793, -3.984955, -1.519060>, <0.225457, -3.794942, -1.498939>, <0.229219, -3.537436, -1.493881>, <0.242884, -3.347424, -1.473761>, 
      <0.016479, -3.980799, -1.519862>, <0.030143, -3.790786, -1.499741>, <0.048363, -3.537436, -1.472914>, <0.062027, -3.347424, -1.452793>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.337423, -3.980799, -1.519862>, <1.320804, -3.790786, -1.499741>, <1.298646, -3.537436, -1.472914>, <1.282027, -3.347424, -1.452793>, 
      <1.135921, -3.983132, -1.519412>, <1.119302, -3.793119, -1.499291>, <1.113503, -3.537436, -1.493881>, <1.096884, -3.347424, -1.473761>, 
      <0.868191, -4.016288, -1.513013>, <0.867684, -3.824968, -1.452438>, <0.850564, -3.548083, -1.498816>, <0.850026, -3.347424, -1.501717>, 
      <0.666675, -4.016288, -1.513013>, <0.666167, -3.824968, -1.452438>, <0.665421, -3.548083, -1.519783>, <0.664883, -3.347424, -1.522685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.732120, -3.980799, -1.519862>, <3.730862, -3.980678, -1.062584>, <3.728440, -3.980478, -0.452882>, <3.726863, -3.980341, 0.004395>, 
      <3.013711, -3.980799, -1.519862>, <3.012453, -3.980678, -1.062584>, <3.011609, -3.980478, -0.452882>, <3.010031, -3.980341, 0.004395>, 
      <2.055782, -3.972482, -1.521467>, <2.055782, -3.972361, -1.064190>, <2.054255, -3.980478, -0.452882>, <2.054255, -3.980341, 0.004395>, 
      <1.337423, -3.980799, -1.519862>, <1.337423, -3.980678, -1.062585>, <1.337423, -3.980478, -0.452882>, <1.337423, -3.980341, 0.004395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.962919, -3.980799, -1.723224>, <-2.962919, -3.980799, -1.662215>, <-2.962919, -3.980815, -1.580871>, <-2.962919, -3.980799, -1.519862>, 
      <-3.193528, -3.980799, -1.723224>, <-3.193528, -3.980799, -1.662215>, <-3.193679, -3.980815, -1.580871>, <-3.193679, -3.980799, -1.519862>, 
      <-3.501006, -3.980799, -1.723224>, <-3.520754, -3.980799, -1.665500>, <-3.501528, -3.980815, -1.580871>, <-3.501360, -3.980799, -1.519862>, 
      <-3.731614, -3.980799, -1.723224>, <-3.751363, -3.980799, -1.665500>, <-3.732288, -3.980815, -1.580871>, <-3.732120, -3.980799, -1.519862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.861284, -3.980799, -1.723224>, <-2.861148, -3.980799, -1.662215>, <-2.860967, -3.980815, -1.580871>, <-2.860831, -3.980799, -1.519862>, 
      <-2.891775, -3.980799, -1.723224>, <-2.891639, -3.980799, -1.662215>, <-2.872615, -4.009140, -1.580871>, <-2.872478, -4.009124, -1.519862>, 
      <-2.932429, -3.980799, -1.723224>, <-2.932429, -3.980799, -1.662215>, <-2.932293, -3.980815, -1.580871>, <-2.932293, -3.980799, -1.519862>, 
      <-2.962919, -3.980799, -1.723224>, <-2.962919, -3.980799, -1.662215>, <-2.962919, -3.980815, -1.580871>, <-2.962919, -3.980799, -1.519862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.742494, -3.980799, -1.723224>, <-2.742494, -3.854045, -1.606970>, <-2.742494, -3.605579, -1.580871>, <-2.742494, -3.444770, -1.519862>, 
      <-2.778131, -3.980799, -1.723224>, <-2.778131, -3.854045, -1.606970>, <-2.777995, -3.766387, -1.580871>, <-2.777995, -3.605579, -1.519862>, 
      <-2.825647, -3.980799, -1.723224>, <-2.825511, -3.980799, -1.662215>, <-2.798336, -3.828509, -1.580871>, <-2.798199, -3.828493, -1.519862>, 
      <-2.861284, -3.980799, -1.723224>, <-2.861148, -3.980799, -1.662215>, <-2.860967, -3.980815, -1.580871>, <-2.860831, -3.980799, -1.519862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.243601, -3.980799, -1.723224>, <-1.243601, -3.854045, -1.606970>, <-1.243601, -3.605579, -1.580871>, <-1.243601, -3.444770, -1.519862>, 
      <-1.693269, -3.980799, -1.723224>, <-1.693269, -3.854045, -1.606970>, <-1.693269, -3.605579, -1.580871>, <-1.693269, -3.444770, -1.519862>, 
      <-2.292826, -3.980799, -1.723224>, <-2.292826, -3.854045, -1.606970>, <-2.292826, -3.605579, -1.580871>, <-2.292826, -3.444770, -1.519862>, 
      <-2.742494, -3.980799, -1.723224>, <-2.742494, -3.854045, -1.606970>, <-2.742494, -3.605579, -1.580871>, <-2.742494, -3.444770, -1.519862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.112959, -3.980799, -1.723224>, <-1.112959, -3.980799, -1.662215>, <-1.112959, -3.980815, -1.580871>, <-1.112959, -3.980799, -1.519862>, 
      <-1.152152, -3.980799, -1.723224>, <-1.152152, -3.980799, -1.662215>, <-1.181175, -3.830010, -1.580871>, <-1.181175, -3.829994, -1.519862>, 
      <-1.204409, -3.980799, -1.723224>, <-1.204409, -3.854045, -1.606970>, <-1.204409, -3.766387, -1.580871>, <-1.204409, -3.605579, -1.519862>, 
      <-1.243601, -3.980799, -1.723224>, <-1.243601, -3.854045, -1.606970>, <-1.243601, -3.605579, -1.580871>, <-1.243601, -3.444770, -1.519862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.001134, -3.980799, -1.723224>, <-1.001134, -3.980799, -1.662215>, <-1.001134, -3.980815, -1.580871>, <-1.001134, -3.980799, -1.519862>, 
      <-1.034681, -3.980799, -1.723224>, <-1.034681, -3.980799, -1.662215>, <-1.034681, -3.980815, -1.580871>, <-1.034681, -3.980799, -1.519862>, 
      <-1.079412, -3.980799, -1.723224>, <-1.079412, -3.980799, -1.662215>, <-1.099133, -4.011381, -1.580871>, <-1.099133, -4.011365, -1.519862>, 
      <-1.112959, -3.980799, -1.723224>, <-1.112959, -3.980799, -1.662215>, <-1.112959, -3.980815, -1.580871>, <-1.112959, -3.980799, -1.519862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016479, -3.980799, -1.723224>, <0.016479, -3.980799, -1.662215>, <0.016479, -3.980815, -1.580871>, <0.016479, -3.980799, -1.519862>, 
      <-0.288805, -3.980799, -1.723224>, <-0.288805, -3.980799, -1.662215>, <-0.288733, -3.974320, -1.582124>, <-0.288733, -3.974304, -1.521115>, 
      <-0.695850, -3.980799, -1.723224>, <-0.695850, -3.980799, -1.662215>, <-0.695850, -3.980815, -1.580871>, <-0.695850, -3.980799, -1.519862>, 
      <-1.001134, -3.980799, -1.723224>, <-1.001134, -3.980799, -1.662215>, <-1.001134, -3.980815, -1.580871>, <-1.001134, -3.980799, -1.519862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.666564, -3.980799, -1.723224>, <0.666446, -3.985340, -1.659430>, <0.666837, -4.077260, -1.532318>, <0.666675, -4.016288, -1.513013>, 
      <0.471538, -3.980799, -1.723224>, <0.471421, -3.985340, -1.659430>, <0.471477, -4.077260, -1.532318>, <0.471315, -4.016288, -1.513013>, 
      <0.211504, -3.980799, -1.723224>, <0.211504, -3.980799, -1.662215>, <0.211793, -3.984971, -1.580069>, <0.211793, -3.984955, -1.519060>, 
      <0.016479, -3.980799, -1.723224>, <0.016479, -3.980799, -1.662215>, <0.016479, -3.980815, -1.580871>, <0.016479, -3.980799, -1.519862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.337423, -3.980799, -1.723224>, <1.337423, -3.980799, -1.662215>, <1.337423, -3.980815, -1.580871>, <1.337423, -3.980799, -1.519862>, 
      <1.136165, -3.980799, -1.723224>, <1.136165, -3.980799, -1.662215>, <1.135921, -3.983148, -1.580420>, <1.135921, -3.983132, -1.519412>, 
      <0.867822, -3.980799, -1.723224>, <0.867704, -3.985340, -1.659430>, <0.868353, -4.077260, -1.532318>, <0.868191, -4.016288, -1.513013>, 
      <0.666564, -3.980799, -1.723224>, <0.666446, -3.985340, -1.659430>, <0.666837, -4.077260, -1.532318>, <0.666675, -4.016288, -1.513013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.731614, -3.980799, -1.723224>, <3.751363, -3.980799, -1.665500>, <3.732288, -3.980815, -1.580871>, <3.732120, -3.980799, -1.519862>, 
      <3.013357, -3.980799, -1.723224>, <3.033106, -3.980799, -1.665500>, <3.013879, -3.980815, -1.580871>, <3.013711, -3.980799, -1.519862>, 
      <2.055681, -3.980799, -1.723224>, <2.055681, -3.980799, -1.662215>, <2.055782, -3.972498, -1.582475>, <2.055782, -3.972482, -1.521467>, 
      <1.337423, -3.980799, -1.723224>, <1.337423, -3.980799, -1.662215>, <1.337423, -3.980815, -1.580871>, <1.337423, -3.980799, -1.519862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.962919, -3.980799, -2.011489>, <-2.962919, -3.980799, -1.925009>, <-2.962919, -3.980799, -1.809703>, <-2.962919, -3.980799, -1.723224>, 
      <-3.143220, -3.980799, -2.011489>, <-3.143220, -3.980799, -1.925009>, <-3.193528, -3.980799, -1.809703>, <-3.193528, -3.980799, -1.723224>, 
      <-3.383622, -3.980799, -2.011489>, <-3.455957, -3.980799, -1.942372>, <-3.468620, -3.980799, -1.817885>, <-3.501006, -3.980799, -1.723224>, 
      <-3.563923, -3.980799, -2.011489>, <-3.636258, -3.980799, -1.942372>, <-3.699229, -3.980799, -1.817885>, <-3.731614, -3.980799, -1.723224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.861928, -3.980799, -2.011489>, <-2.861735, -3.980799, -1.925009>, <-2.861478, -3.980799, -1.809703>, <-2.861284, -3.980799, -1.723224>, 
      <-2.892225, -3.980799, -2.011489>, <-2.892032, -3.980799, -1.925009>, <-2.891968, -3.980799, -1.809703>, <-2.891775, -3.980799, -1.723224>, 
      <-2.932622, -3.980799, -2.011489>, <-2.932622, -3.980799, -1.925009>, <-2.932429, -3.980799, -1.809703>, <-2.932429, -3.980799, -1.723224>, 
      <-2.962919, -3.980799, -2.011489>, <-2.962919, -3.980799, -1.925009>, <-2.962919, -3.980799, -1.809703>, <-2.962919, -3.980799, -1.723224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.742494, -3.980799, -2.011489>, <-2.742494, -3.980799, -1.925009>, <-2.742494, -4.044532, -1.781677>, <-2.742494, -3.980799, -1.723224>, 
      <-2.778324, -3.980799, -2.011489>, <-2.778324, -3.980799, -1.925009>, <-2.778131, -4.044532, -1.781677>, <-2.778131, -3.980799, -1.723224>, 
      <-2.826098, -3.980799, -2.011489>, <-2.825905, -3.980799, -1.925009>, <-2.825840, -3.980799, -1.809703>, <-2.825647, -3.980799, -1.723224>, 
      <-2.861928, -3.980799, -2.011489>, <-2.861735, -3.980799, -1.925009>, <-2.861478, -3.980799, -1.809703>, <-2.861284, -3.980799, -1.723224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.243601, -3.980799, -2.011489>, <-1.243601, -3.980799, -1.925009>, <-1.243601, -4.044532, -1.781677>, <-1.243601, -3.980799, -1.723224>, 
      <-1.693269, -3.980799, -2.011489>, <-1.693269, -3.980799, -1.925009>, <-1.693269, -4.044532, -1.781677>, <-1.693269, -3.980799, -1.723224>, 
      <-2.292826, -3.980799, -2.011489>, <-2.292826, -3.980799, -1.925009>, <-2.292826, -4.044532, -1.781677>, <-2.292826, -3.980799, -1.723224>, 
      <-2.742494, -3.980799, -2.011489>, <-2.742494, -3.980799, -1.925009>, <-2.742494, -4.044532, -1.781677>, <-2.742494, -3.980799, -1.723224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.112959, -3.980799, -2.011489>, <-1.112959, -3.980799, -1.925009>, <-1.112959, -3.980799, -1.809703>, <-1.112959, -3.980799, -1.723224>, 
      <-1.152152, -3.980799, -2.011489>, <-1.152152, -3.980799, -1.925009>, <-1.152152, -3.980799, -1.809703>, <-1.152152, -3.980799, -1.723224>, 
      <-1.204409, -3.980799, -2.011489>, <-1.204409, -3.980799, -1.925009>, <-1.204409, -4.044532, -1.781677>, <-1.204409, -3.980799, -1.723224>, 
      <-1.243601, -3.980799, -2.011489>, <-1.243601, -3.980799, -1.925009>, <-1.243601, -4.044532, -1.781677>, <-1.243601, -3.980799, -1.723224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.001134, -3.980799, -2.011489>, <-1.001134, -3.980799, -1.925009>, <-1.001134, -3.980799, -1.809703>, <-1.001134, -3.980799, -1.723224>, 
      <-1.034681, -3.980799, -2.011489>, <-1.034681, -3.980799, -1.925009>, <-1.034681, -3.980799, -1.809703>, <-1.034681, -3.980799, -1.723224>, 
      <-1.079412, -3.980799, -2.011489>, <-1.079412, -3.980799, -1.925009>, <-1.079412, -3.980799, -1.809703>, <-1.079412, -3.980799, -1.723224>, 
      <-1.112959, -3.980799, -2.011489>, <-1.112959, -3.980799, -1.925009>, <-1.112959, -3.980799, -1.809703>, <-1.112959, -3.980799, -1.723224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016479, -3.980799, -2.011489>, <0.016479, -3.980799, -1.925009>, <0.016479, -3.980799, -1.809703>, <0.016479, -3.980799, -1.723224>, 
      <-0.288805, -3.980799, -2.011489>, <-0.288805, -3.980799, -1.925009>, <-0.288805, -3.980799, -1.809703>, <-0.288805, -3.980799, -1.723224>, 
      <-0.695850, -3.980799, -2.011489>, <-0.695850, -3.980799, -1.925009>, <-0.695850, -3.980799, -1.809703>, <-0.695850, -3.980799, -1.723224>, 
      <-1.001134, -3.980799, -2.011489>, <-1.001134, -3.980799, -1.925009>, <-1.001134, -3.980799, -1.809703>, <-1.001134, -3.980799, -1.723224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.667595, -3.980799, -2.011489>, <0.667286, -3.980799, -1.925009>, <0.666723, -3.974657, -1.809485>, <0.666564, -3.980799, -1.723224>, 
      <0.472260, -3.980799, -2.011489>, <0.471951, -3.980799, -1.925009>, <0.471698, -3.974657, -1.809485>, <0.471538, -3.980799, -1.723224>, 
      <0.211814, -3.980799, -2.011489>, <0.211814, -3.980799, -1.925009>, <0.211504, -3.980799, -1.809703>, <0.211504, -3.980799, -1.723224>, 
      <0.016479, -3.980799, -2.011489>, <0.016479, -3.980799, -1.925009>, <0.016479, -3.980799, -1.809703>, <0.016479, -3.980799, -1.723224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.337423, -3.980799, -2.011489>, <1.337423, -3.980799, -1.925009>, <1.337423, -3.980799, -1.809703>, <1.337423, -3.980799, -1.723224>, 
      <1.136475, -3.980799, -2.011489>, <1.136475, -3.980799, -1.925009>, <1.136165, -3.980799, -1.809703>, <1.136165, -3.980799, -1.723224>, 
      <0.868544, -3.980799, -2.011489>, <0.868234, -3.980799, -1.925009>, <0.867981, -3.974657, -1.809485>, <0.867822, -3.980799, -1.723224>, 
      <0.667595, -3.980799, -2.011489>, <0.667286, -3.980799, -1.925009>, <0.666723, -3.974657, -1.809485>, <0.666564, -3.980799, -1.723224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.563923, -3.980799, -2.011489>, <3.636258, -3.980799, -1.942372>, <3.699229, -3.980799, -1.817885>, <3.731614, -3.980799, -1.723224>, 
      <2.895973, -3.980799, -2.011489>, <2.968308, -3.980799, -1.942372>, <2.980971, -3.980799, -1.817885>, <3.013357, -3.980799, -1.723224>, 
      <2.005373, -3.980799, -2.011489>, <2.005373, -3.980799, -1.925009>, <2.055681, -3.980799, -1.809703>, <2.055681, -3.980799, -1.723224>, 
      <1.337423, -3.980799, -2.011489>, <1.337423, -3.980799, -1.925009>, <1.337423, -3.980799, -1.809703>, <1.337423, -3.980799, -1.723224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.962919, -3.980799, -2.179063>, <-2.962919, -3.980799, -2.128790>, <-2.962919, -3.980799, -2.061761>, <-2.962919, -3.980799, -2.011489>, 
      <-3.050409, -3.980799, -2.179063>, <-3.050409, -3.980799, -2.128790>, <-3.143220, -3.980799, -2.061761>, <-3.143220, -3.980799, -2.011489>, 
      <-3.167061, -3.980799, -2.179063>, <-3.259873, -3.980799, -2.128790>, <-3.307307, -3.980799, -2.084409>, <-3.383622, -3.980799, -2.011489>, 
      <-3.254550, -3.980799, -2.179063>, <-3.347362, -3.980799, -2.128790>, <-3.487608, -3.980799, -2.084409>, <-3.563923, -3.980799, -2.011489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.862302, -3.980799, -2.179063>, <-2.862190, -3.980799, -2.128790>, <-2.862040, -3.980799, -2.061761>, <-2.861928, -3.980799, -2.011489>, 
      <-2.892487, -3.980799, -2.179063>, <-2.892375, -3.980799, -2.128790>, <-2.892338, -3.980799, -2.061761>, <-2.892225, -3.980799, -2.011489>, 
      <-2.932734, -3.980799, -2.179063>, <-2.932734, -3.980799, -2.128790>, <-2.932622, -3.980799, -2.061761>, <-2.932622, -3.980799, -2.011489>, 
      <-2.962919, -3.980799, -2.179063>, <-2.962919, -3.980799, -2.128790>, <-2.962919, -3.980799, -2.061761>, <-2.962919, -3.980799, -2.011489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.742494, -3.980799, -2.179063>, <-2.742494, -3.980799, -2.128790>, <-2.742494, -3.980799, -2.061761>, <-2.742494, -3.980799, -2.011489>, 
      <-2.778436, -3.980799, -2.179063>, <-2.778436, -3.980799, -2.128790>, <-2.778324, -3.980799, -2.061761>, <-2.778324, -3.980799, -2.011489>, 
      <-2.826360, -3.980799, -2.179063>, <-2.826247, -3.980799, -2.128790>, <-2.826210, -3.980799, -2.061761>, <-2.826098, -3.980799, -2.011489>, 
      <-2.862302, -3.980799, -2.179063>, <-2.862190, -3.980799, -2.128790>, <-2.862040, -3.980799, -2.061761>, <-2.861928, -3.980799, -2.011489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.243601, -3.980799, -2.179063>, <-1.243601, -3.980799, -2.128790>, <-1.243601, -3.980799, -2.061761>, <-1.243601, -3.980799, -2.011489>, 
      <-1.693269, -3.980799, -2.179063>, <-1.693269, -3.980799, -2.128790>, <-1.693269, -3.980799, -2.061761>, <-1.693269, -3.980799, -2.011489>, 
      <-2.292826, -3.980799, -2.179063>, <-2.292826, -3.980799, -2.128790>, <-2.292826, -3.980799, -2.061761>, <-2.292826, -3.980799, -2.011489>, 
      <-2.742494, -3.980799, -2.179063>, <-2.742494, -3.980799, -2.128790>, <-2.742494, -3.980799, -2.061761>, <-2.742494, -3.980799, -2.011489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.112959, -3.980799, -2.179063>, <-1.112959, -3.980799, -2.128790>, <-1.112959, -3.980799, -2.061761>, <-1.112959, -3.980799, -2.011489>, 
      <-1.152152, -3.980799, -2.179063>, <-1.152152, -3.980799, -2.128790>, <-1.152152, -3.980799, -2.061761>, <-1.152152, -3.980799, -2.011489>, 
      <-1.204409, -3.980799, -2.179063>, <-1.204409, -3.980799, -2.128790>, <-1.204409, -3.980799, -2.061761>, <-1.204409, -3.980799, -2.011489>, 
      <-1.243601, -3.980799, -2.179063>, <-1.243601, -3.980799, -2.128790>, <-1.243601, -3.980799, -2.061761>, <-1.243601, -3.980799, -2.011489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.001134, -3.980799, -2.179063>, <-1.001134, -3.980799, -2.128790>, <-1.001134, -3.980799, -2.061761>, <-1.001134, -3.980799, -2.011489>, 
      <-1.034681, -3.980799, -2.179063>, <-1.034681, -3.980799, -2.128790>, <-1.034681, -3.980799, -2.061761>, <-1.034681, -3.980799, -2.011489>, 
      <-1.079412, -3.980799, -2.179063>, <-1.079412, -3.980799, -2.128790>, <-1.079412, -3.980799, -2.061761>, <-1.079412, -3.980799, -2.011489>, 
      <-1.112959, -3.980799, -2.179063>, <-1.112959, -3.980799, -2.128790>, <-1.112959, -3.980799, -2.061761>, <-1.112959, -3.980799, -2.011489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016479, -3.980799, -2.179063>, <0.016479, -3.980799, -2.128790>, <0.016479, -3.980799, -2.061761>, <0.016479, -3.980799, -2.011489>, 
      <-0.288805, -3.980799, -2.179063>, <-0.288805, -3.980799, -2.128790>, <-0.288805, -3.980799, -2.061761>, <-0.288805, -3.980799, -2.011489>, 
      <-0.695850, -3.980799, -2.179063>, <-0.695850, -3.980799, -2.128790>, <-0.695850, -3.980799, -2.061761>, <-0.695850, -3.980799, -2.011489>, 
      <-1.001134, -3.980799, -2.179063>, <-1.001134, -3.980799, -2.128790>, <-1.001134, -3.980799, -2.061761>, <-1.001134, -3.980799, -2.011489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.668195, -3.980799, -2.179063>, <0.668015, -3.980799, -2.128790>, <0.667775, -3.980799, -2.061761>, <0.667595, -3.980799, -2.011489>, 
      <0.472680, -3.980799, -2.179063>, <0.472500, -3.980799, -2.128790>, <0.472440, -3.980799, -2.061761>, <0.472260, -3.980799, -2.011489>, 
      <0.211994, -3.980799, -2.179063>, <0.211994, -3.980799, -2.128790>, <0.211814, -3.980799, -2.061761>, <0.211814, -3.980799, -2.011489>, 
      <0.016479, -3.980799, -2.179063>, <0.016479, -3.980799, -2.128790>, <0.016479, -3.980799, -2.061761>, <0.016479, -3.980799, -2.011489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.337423, -3.980799, -2.179063>, <1.337423, -3.980799, -2.128790>, <1.337423, -3.980799, -2.061761>, <1.337423, -3.980799, -2.011489>, 
      <1.136654, -3.980799, -2.179063>, <1.136654, -3.980799, -2.128790>, <1.136475, -3.980799, -2.061761>, <1.136475, -3.980799, -2.011489>, 
      <0.868963, -3.980799, -2.179063>, <0.868783, -3.980799, -2.128790>, <0.868723, -3.980799, -2.061761>, <0.868544, -3.980799, -2.011489>, 
      <0.668195, -3.980799, -2.179063>, <0.668015, -3.980799, -2.128790>, <0.667775, -3.980799, -2.061761>, <0.667595, -3.980799, -2.011489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.254550, -3.980799, -2.179063>, <3.347362, -3.980799, -2.128790>, <3.487608, -3.980799, -2.084409>, <3.563923, -3.980799, -2.011489>, 
      <2.679412, -3.980799, -2.179063>, <2.772224, -3.980799, -2.128790>, <2.819658, -3.980799, -2.084409>, <2.895973, -3.980799, -2.011489>, 
      <1.912561, -3.980799, -2.179063>, <1.912561, -3.980799, -2.128790>, <2.005373, -3.980799, -2.061761>, <2.005373, -3.980799, -2.011489>, 
      <1.337423, -3.980799, -2.179063>, <1.337423, -3.980799, -2.128790>, <1.337423, -3.980799, -2.061761>, <1.337423, -3.980799, -2.011489>
    }
  }
  material {
    azultf_txt
    scale <7.55, 7.5, 7.5>
    translate <-3.773702, 0.000000, -2.238637>
  }
}
#declare caja_dinero = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.254550, -3.659555, -5.076846>, <3.254550, -3.750548, -5.076846>, <3.345444, -3.958628, -5.076846>, <3.254550, -3.962864, -5.076846>, 
      <2.279423, -3.659555, -5.122887>, <2.279423, -3.750548, -5.122887>, <2.370317, -3.958628, -5.122887>, <2.279423, -3.962864, -5.122887>, 
      <0.976719, -3.659555, -5.077520>, <0.976719, -3.750548, -5.077520>, <0.976719, -3.871871, -5.077520>, <0.976719, -3.962864, -5.077520>, 
      <0.000505, -3.659555, -5.077520>, <0.000505, -3.750548, -5.077520>, <0.000505, -3.871871, -5.077520>, <0.000505, -3.962864, -5.077520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.254550, -3.659555, -2.315459>, <-3.254550, -3.750548, -2.315459>, <-3.345444, -3.958628, -2.315459>, <-3.254550, -3.962864, -2.315459>, 
      <-2.279119, -3.659555, -2.269417>, <-2.279119, -3.750548, -2.269417>, <-2.370013, -3.958628, -2.269417>, <-2.279119, -3.962864, -2.269417>, 
      <-0.976011, -3.659555, -2.314785>, <-0.976011, -3.750548, -2.314785>, <-0.976011, -3.871871, -2.314785>, <-0.976011, -3.962864, -2.314785>, 
      <0.000505, -3.659555, -2.314785>, <0.000505, -3.750548, -2.314785>, <0.000505, -3.871871, -2.314785>, <0.000505, -3.962864, -2.314785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.254550, -3.962864, -2.315459>, <2.279423, -3.962864, -2.269418>, <0.976719, -3.962864, -2.314785>, <0.000505, -3.962864, -2.314785>, 
      <3.345444, -3.958628, -2.315459>, <2.370317, -3.958628, -2.269418>, <0.976719, -3.871871, -2.314785>, <0.000505, -3.871871, -2.314785>, 
      <3.254550, -3.750548, -2.315459>, <2.279423, -3.750548, -2.269418>, <0.976719, -3.750548, -2.314785>, <0.000505, -3.750548, -2.314785>, 
      <3.254550, -3.659555, -2.315459>, <2.279423, -3.659555, -2.269418>, <0.976719, -3.659555, -2.314785>, <0.000505, -3.659555, -2.314785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.563923, -3.962864, -2.483033>, <3.487608, -3.962864, -2.410114>, <3.359985, -3.962864, -2.320438>, <3.254550, -3.962864, -2.315459>, 
      <3.654834, -3.958995, -2.483033>, <3.578518, -3.958995, -2.410114>, <3.450879, -3.958628, -2.320438>, <3.345444, -3.958628, -2.315459>, 
      <3.563923, -3.750548, -2.483033>, <3.487608, -3.750548, -2.410114>, <3.359985, -3.750548, -2.320438>, <3.254550, -3.750548, -2.315459>, 
      <3.563923, -3.659555, -2.483033>, <3.487608, -3.659555, -2.410114>, <3.359985, -3.659555, -2.320438>, <3.254550, -3.659555, -2.315459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.731614, -3.962864, -2.771299>, <3.710534, -3.962864, -2.673497>, <3.636258, -3.962864, -2.552150>, <3.563923, -3.962864, -2.483033>, 
      <3.822532, -3.959169, -2.771299>, <3.801452, -3.959169, -2.673497>, <3.727169, -3.958995, -2.552150>, <3.654834, -3.958995, -2.483033>, 
      <3.731614, -3.750548, -2.771299>, <3.710534, -3.750548, -2.673497>, <3.636258, -3.750548, -2.552150>, <3.563923, -3.750548, -2.483033>, 
      <3.731614, -3.659555, -2.771299>, <3.710534, -3.659555, -2.673497>, <3.636258, -3.659555, -2.552150>, <3.563923, -3.659555, -2.483033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.732120, -3.962864, -3.263364>, <3.733650, -3.962864, -3.115752>, <3.762719, -3.962864, -2.915604>, <3.731614, -3.962864, -2.771299>, 
      <3.823037, -3.959169, -3.263364>, <3.824568, -3.959169, -3.115752>, <3.853636, -3.959169, -2.915604>, <3.822532, -3.959169, -2.771299>, 
      <3.732120, -3.750548, -3.263364>, <3.733650, -3.750548, -3.115752>, <3.762719, -3.750548, -2.915604>, <3.731614, -3.750548, -2.771299>, 
      <3.732120, -3.659555, -3.263364>, <3.733650, -3.659555, -3.115752>, <3.762719, -3.659555, -2.915604>, <3.731614, -3.659555, -2.771299>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.721507, -3.962864, -3.746256>, <3.721507, -3.962864, -3.601354>, <3.730618, -3.962864, -3.408259>, <3.732120, -3.962864, -3.263364>, 
      <3.812424, -3.959159, -3.746256>, <3.812424, -3.959159, -3.601354>, <3.821535, -3.959169, -3.408259>, <3.823037, -3.959169, -3.263364>, 
      <3.721507, -3.750548, -3.746256>, <3.721507, -3.750548, -3.601354>, <3.730618, -3.750548, -3.408259>, <3.732120, -3.750548, -3.263364>, 
      <3.721507, -3.659555, -3.746256>, <3.721507, -3.659555, -3.601354>, <3.730618, -3.659555, -3.408259>, <3.732120, -3.659555, -3.263364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.732120, -3.962864, -4.188080>, <3.730588, -3.962864, -4.055503>, <3.721507, -3.962864, -3.878842>, <3.721507, -3.962864, -3.746256>, 
      <3.823037, -3.959169, -4.188080>, <3.821506, -3.959169, -4.055503>, <3.812424, -3.959159, -3.878842>, <3.812424, -3.959159, -3.746256>, 
      <3.732120, -3.750548, -4.188080>, <3.730588, -3.750548, -4.055503>, <3.721507, -3.750548, -3.878842>, <3.721507, -3.750548, -3.746256>, 
      <3.732120, -3.659555, -4.188080>, <3.730588, -3.659555, -4.055503>, <3.721507, -3.659555, -3.878842>, <3.721507, -3.659555, -3.746256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.731614, -3.962864, -4.621007>, <3.761113, -3.962864, -4.494523>, <3.733620, -3.962864, -4.317949>, <3.732120, -3.962864, -4.188080>, 
      <3.822532, -3.959169, -4.621007>, <3.852031, -3.959169, -4.494523>, <3.824538, -3.959169, -4.317949>, <3.823037, -3.959169, -4.188080>, 
      <3.731614, -3.750548, -4.621007>, <3.761113, -3.750548, -4.494523>, <3.733620, -3.750548, -4.317949>, <3.732120, -3.750548, -4.188080>, 
      <3.731614, -3.659555, -4.621007>, <3.761113, -3.659555, -4.494523>, <3.733620, -3.659555, -4.317949>, <3.732120, -3.659555, -4.188080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.563923, -3.962864, -4.909272>, <3.636258, -3.962864, -4.840155>, <3.708891, -3.962864, -4.718440>, <3.731614, -3.962864, -4.621007>, 
      <3.654833, -3.958995, -4.909272>, <3.727168, -3.958995, -4.840155>, <3.799809, -3.959169, -4.718440>, <3.822532, -3.959169, -4.621007>, 
      <3.563923, -3.750548, -4.909272>, <3.636258, -3.750548, -4.840155>, <3.708891, -3.750548, -4.718440>, <3.731614, -3.750548, -4.621007>, 
      <3.563923, -3.659555, -4.909272>, <3.636258, -3.659555, -4.840155>, <3.708891, -3.659555, -4.718440>, <3.731614, -3.659555, -4.621007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.254550, -3.962864, -5.076846>, <3.359985, -3.962864, -5.071868>, <3.487608, -3.962864, -4.982192>, <3.563923, -3.962864, -4.909272>, 
      <3.345444, -3.958628, -5.076846>, <3.450879, -3.958628, -5.071868>, <3.578518, -3.958995, -4.982192>, <3.654833, -3.958995, -4.909272>, 
      <3.254550, -3.750548, -5.076846>, <3.359985, -3.750548, -5.071868>, <3.487608, -3.750548, -4.982192>, <3.563923, -3.750548, -4.909272>, 
      <3.254550, -3.659555, -5.076846>, <3.359985, -3.659555, -5.071868>, <3.487608, -3.659555, -4.982192>, <3.563923, -3.659555, -4.909272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.563923, -3.962864, -4.909272>, <1.427502, -4.053774, -4.909272>, <-1.427502, -4.053774, -4.909272>, <-3.563923, -3.962864, -4.909272>, 
      <3.487608, -3.962864, -4.982192>, <1.351187, -4.053774, -4.982192>, <-1.351187, -4.053774, -4.982192>, <-3.487608, -3.962864, -4.982192>, 
      <3.359985, -3.962864, -5.071868>, <1.409372, -4.053758, -5.071868>, <-1.409372, -4.053758, -5.071869>, <-3.359985, -3.962864, -5.071869>, 
      <3.254550, -3.962864, -5.076846>, <1.303937, -4.053758, -5.076846>, <-1.303937, -4.053758, -5.076846>, <-3.254550, -3.962864, -5.076846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.731614, -3.962864, -4.621007>, <1.494492, -4.053781, -4.621007>, <-1.494492, -4.053781, -4.621007>, <-3.731614, -3.962864, -4.621007>, 
      <3.708891, -3.962864, -4.718440>, <1.471769, -4.053781, -4.718440>, <-1.471769, -4.053781, -4.718440>, <-3.708891, -3.962864, -4.718440>, 
      <3.636258, -3.962864, -4.840155>, <1.499838, -4.053774, -4.840155>, <-1.499838, -4.053774, -4.840155>, <-3.636258, -3.962864, -4.840155>, 
      <3.563923, -3.962864, -4.909272>, <1.427502, -4.053774, -4.909272>, <-1.427502, -4.053774, -4.909272>, <-3.563923, -3.962864, -4.909272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.732120, -3.962864, -4.188080>, <1.494694, -4.053781, -4.188080>, <-1.494694, -4.053781, -4.188080>, <-3.732120, -3.962864, -4.188080>, 
      <3.733620, -3.962864, -4.317949>, <1.496195, -4.053781, -4.317949>, <-1.496195, -4.053781, -4.317949>, <-3.733620, -3.962864, -4.317949>, 
      <3.761113, -3.962864, -4.494523>, <1.523991, -4.053781, -4.494523>, <-1.523991, -4.053781, -4.494523>, <-3.761113, -3.962864, -4.494523>, 
      <3.731614, -3.962864, -4.621007>, <1.494492, -4.053781, -4.621007>, <-1.494492, -4.053781, -4.621007>, <-3.731614, -3.962864, -4.621007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.721507, -3.962864, -3.746256>, <1.490454, -4.053781, -3.746256>, <-1.490454, -4.053781, -3.746256>, <-3.721507, -3.962864, -3.746256>, 
      <3.721507, -3.962864, -3.878842>, <1.490454, -4.053781, -3.878842>, <-1.490454, -4.053781, -3.878842>, <-3.721507, -3.962864, -3.878842>, 
      <3.730588, -3.962864, -4.055503>, <1.493162, -4.053781, -4.055503>, <-1.493162, -4.053781, -4.055503>, <-3.730588, -3.962864, -4.055503>, 
      <3.732120, -3.962864, -4.188080>, <1.494694, -4.053781, -4.188080>, <-1.494694, -4.053781, -4.188080>, <-3.732120, -3.962864, -4.188080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.732120, -3.962864, -3.263364>, <1.494694, -4.053782, -3.263364>, <-1.494694, -4.053782, -3.263364>, <-3.732120, -3.962864, -3.263364>, 
      <3.730618, -3.962864, -3.408259>, <1.493192, -4.053782, -3.408259>, <-1.493192, -4.053782, -3.408259>, <-3.730618, -3.962864, -3.408259>, 
      <3.721507, -3.962864, -3.601354>, <1.490454, -4.053781, -3.601354>, <-1.490454, -4.053781, -3.601354>, <-3.721507, -3.962864, -3.601354>, 
      <3.721507, -3.962864, -3.746256>, <1.490454, -4.053781, -3.746256>, <-1.490454, -4.053781, -3.746256>, <-3.721507, -3.962864, -3.746256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.731614, -3.962864, -2.771299>, <1.494492, -4.053781, -2.771299>, <-1.494492, -4.053781, -2.771299>, <-3.731614, -3.962864, -2.771299>, 
      <3.762719, -3.962864, -2.915604>, <1.525597, -4.053781, -2.915604>, <-1.525597, -4.053781, -2.915604>, <-3.762719, -3.962864, -2.915604>, 
      <3.733650, -3.962864, -3.115752>, <1.496225, -4.053782, -3.115752>, <-1.496225, -4.053782, -3.115752>, <-3.733650, -3.962864, -3.115752>, 
      <3.732120, -3.962864, -3.263364>, <1.494694, -4.053782, -3.263364>, <-1.494694, -4.053782, -3.263364>, <-3.732120, -3.962864, -3.263364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.563923, -3.962864, -2.483033>, <1.427502, -4.053774, -2.483033>, <-1.427502, -4.053774, -2.483033>, <-3.563923, -3.962864, -2.483033>, 
      <3.636258, -3.962864, -2.552150>, <1.499838, -4.053774, -2.552150>, <-1.499838, -4.053774, -2.552150>, <-3.636258, -3.962864, -2.552150>, 
      <3.710534, -3.962864, -2.673497>, <1.473412, -4.053781, -2.673497>, <-1.473412, -4.053781, -2.673497>, <-3.710534, -3.962864, -2.673497>, 
      <3.731614, -3.962864, -2.771299>, <1.494492, -4.053781, -2.771299>, <-1.494492, -4.053781, -2.771299>, <-3.731614, -3.962864, -2.771299>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.254550, -3.962864, -2.315459>, <1.303937, -4.053758, -2.315459>, <-1.303937, -4.053758, -2.315459>, <-3.254550, -3.962864, -2.315459>, 
      <3.359985, -3.962864, -2.320438>, <1.409372, -4.053758, -2.320438>, <-1.409372, -4.053758, -2.320436>, <-3.359985, -3.962864, -2.320436>, 
      <3.487608, -3.962864, -2.410114>, <1.351187, -4.053774, -2.410114>, <-1.351187, -4.053774, -2.410114>, <-3.487608, -3.962864, -2.410114>, 
      <3.563923, -3.962864, -2.483033>, <1.427502, -4.053774, -2.483033>, <-1.427502, -4.053774, -2.483033>, <-3.563923, -3.962864, -2.483033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.563923, -3.962864, -2.483033>, <-3.654834, -3.958995, -2.483033>, <-3.563923, -3.750548, -2.483033>, <-3.563923, -3.659555, -2.483033>, 
      <-3.487608, -3.962864, -2.410114>, <-3.578518, -3.958995, -2.410114>, <-3.487608, -3.750548, -2.410114>, <-3.487608, -3.659555, -2.410114>, 
      <-3.359985, -3.962864, -2.320436>, <-3.450879, -3.958628, -2.320436>, <-3.359985, -3.750548, -2.320436>, <-3.359985, -3.659555, -2.320436>, 
      <-3.254550, -3.962864, -2.315459>, <-3.345444, -3.958628, -2.315459>, <-3.254550, -3.750548, -2.315459>, <-3.254550, -3.659555, -2.315459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.731614, -3.962864, -2.771299>, <-3.822532, -3.959169, -2.771299>, <-3.731614, -3.750548, -2.771299>, <-3.731614, -3.659555, -2.771299>, 
      <-3.710534, -3.962864, -2.673497>, <-3.801452, -3.959169, -2.673497>, <-3.710534, -3.750548, -2.673497>, <-3.710534, -3.659555, -2.673497>, 
      <-3.636258, -3.962864, -2.552150>, <-3.727169, -3.958995, -2.552150>, <-3.636258, -3.750548, -2.552150>, <-3.636258, -3.659555, -2.552150>, 
      <-3.563923, -3.962864, -2.483033>, <-3.654834, -3.958995, -2.483033>, <-3.563923, -3.750548, -2.483033>, <-3.563923, -3.659555, -2.483033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.732120, -3.962864, -3.263364>, <-3.823037, -3.959169, -3.263364>, <-3.732120, -3.750548, -3.263364>, <-3.732120, -3.659555, -3.263364>, 
      <-3.733650, -3.962864, -3.115752>, <-3.824568, -3.959169, -3.115752>, <-3.733650, -3.750548, -3.115752>, <-3.733650, -3.659555, -3.115752>, 
      <-3.762719, -3.962864, -2.915604>, <-3.853636, -3.959169, -2.915604>, <-3.762719, -3.750548, -2.915604>, <-3.762719, -3.659555, -2.915604>, 
      <-3.731614, -3.962864, -2.771299>, <-3.822532, -3.959169, -2.771299>, <-3.731614, -3.750548, -2.771299>, <-3.731614, -3.659555, -2.771299>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.721507, -3.962864, -3.746256>, <-3.812424, -3.959159, -3.746256>, <-3.721507, -3.750548, -3.746256>, <-3.721507, -3.659555, -3.746256>, 
      <-3.721507, -3.962864, -3.601354>, <-3.812424, -3.959159, -3.601354>, <-3.721507, -3.750548, -3.601354>, <-3.721507, -3.659555, -3.601354>, 
      <-3.730618, -3.962864, -3.408259>, <-3.821535, -3.959169, -3.408259>, <-3.730618, -3.750548, -3.408259>, <-3.730618, -3.659555, -3.408259>, 
      <-3.732120, -3.962864, -3.263364>, <-3.823037, -3.959169, -3.263364>, <-3.732120, -3.750548, -3.263364>, <-3.732120, -3.659555, -3.263364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.732120, -3.962864, -4.188080>, <-3.823037, -3.959169, -4.188080>, <-3.732120, -3.750548, -4.188080>, <-3.732120, -3.659555, -4.188080>, 
      <-3.730588, -3.962864, -4.055503>, <-3.821506, -3.959169, -4.055503>, <-3.730588, -3.750548, -4.055503>, <-3.730588, -3.659555, -4.055503>, 
      <-3.721507, -3.962864, -3.878842>, <-3.812424, -3.959159, -3.878842>, <-3.721507, -3.750548, -3.878842>, <-3.721507, -3.659555, -3.878842>, 
      <-3.721507, -3.962864, -3.746256>, <-3.812424, -3.959159, -3.746256>, <-3.721507, -3.750548, -3.746256>, <-3.721507, -3.659555, -3.746256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.731614, -3.962864, -4.621007>, <-3.822532, -3.959169, -4.621007>, <-3.731614, -3.750548, -4.621007>, <-3.731614, -3.659555, -4.621007>, 
      <-3.761113, -3.962864, -4.494523>, <-3.852031, -3.959169, -4.494523>, <-3.761113, -3.750548, -4.494523>, <-3.761113, -3.659555, -4.494523>, 
      <-3.733620, -3.962864, -4.317949>, <-3.824538, -3.959169, -4.317949>, <-3.733620, -3.750548, -4.317949>, <-3.733620, -3.659555, -4.317949>, 
      <-3.732120, -3.962864, -4.188080>, <-3.823037, -3.959169, -4.188080>, <-3.732120, -3.750548, -4.188080>, <-3.732120, -3.659555, -4.188080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.563923, -3.962864, -4.909272>, <-3.654833, -3.958995, -4.909272>, <-3.563923, -3.750548, -4.909272>, <-3.563923, -3.659555, -4.909272>, 
      <-3.636258, -3.962864, -4.840155>, <-3.727168, -3.958995, -4.840155>, <-3.636258, -3.750548, -4.840155>, <-3.636258, -3.659555, -4.840155>, 
      <-3.708891, -3.962864, -4.718440>, <-3.799809, -3.959169, -4.718440>, <-3.708891, -3.750548, -4.718440>, <-3.708891, -3.659555, -4.718440>, 
      <-3.731614, -3.962864, -4.621007>, <-3.822532, -3.959169, -4.621007>, <-3.731614, -3.750548, -4.621007>, <-3.731614, -3.659555, -4.621007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.254550, -3.962864, -5.076846>, <-3.345444, -3.958628, -5.076846>, <-3.254550, -3.750548, -5.076846>, <-3.254550, -3.659555, -5.076846>, 
      <-3.359985, -3.962864, -5.071869>, <-3.450879, -3.958628, -5.071869>, <-3.359985, -3.750548, -5.071869>, <-3.359985, -3.659555, -5.071869>, 
      <-3.487608, -3.962864, -4.982192>, <-3.578518, -3.958995, -4.982192>, <-3.487608, -3.750548, -4.982192>, <-3.487608, -3.659555, -4.982192>, 
      <-3.563923, -3.962864, -4.909272>, <-3.654833, -3.958995, -4.909272>, <-3.563923, -3.750548, -4.909272>, <-3.563923, -3.659555, -4.909272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000505, -3.962864, -5.077520>, <0.000505, -3.871871, -5.077520>, <0.000505, -3.750548, -5.077520>, <0.000505, -3.659555, -5.077520>, 
      <-0.976011, -3.962864, -5.077520>, <-0.976011, -3.871871, -5.077520>, <-0.976011, -3.750548, -5.077520>, <-0.976011, -3.659555, -5.077520>, 
      <-2.279119, -3.962864, -5.122888>, <-2.370013, -3.958628, -5.122888>, <-2.279119, -3.750548, -5.122888>, <-2.279119, -3.659555, -5.122888>, 
      <-3.254550, -3.962864, -5.076846>, <-3.345444, -3.958628, -5.076846>, <-3.254550, -3.750548, -5.076846>, <-3.254550, -3.659555, -5.076846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000505, -3.659555, -2.314785>, <-0.976011, -3.659555, -2.314785>, <-2.279119, -3.659555, -2.269417>, <-3.254550, -3.659555, -2.315459>, 
      <0.976719, -3.659555, -2.314785>, <0.000202, -3.659555, -2.314785>, <-0.328506, -3.568661, -2.269417>, <-3.254550, -3.659555, -2.315459>, 
      <2.279423, -3.659555, -2.269418>, <0.328809, -3.568661, -2.269418>, <-0.328506, -3.568661, -2.269417>, <-3.254550, -3.659555, -2.315459>, 
      <3.254550, -3.659555, -2.315459>, <1.303937, -3.568661, -2.315459>, <-1.303937, -3.568661, -2.315459>, <-3.254550, -3.659555, -2.315459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.254550, -3.962864, -2.315459>, <-1.303937, -4.053758, -2.315459>, <1.303937, -4.053758, -2.315459>, <3.254550, -3.962864, -2.315459>, 
      <-2.279119, -3.962864, -2.269417>, <-0.328506, -4.053758, -2.269417>, <0.328809, -4.053758, -2.269418>, <3.254550, -3.962864, -2.315459>, 
      <-0.976011, -3.962864, -2.314785>, <0.000202, -3.962864, -2.314785>, <0.328809, -4.053758, -2.269418>, <3.254550, -3.962864, -2.315459>, 
      <0.000505, -3.962864, -2.314785>, <0.976719, -3.962864, -2.314785>, <2.279423, -3.962864, -2.269418>, <3.254550, -3.962864, -2.315459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000505, -3.962864, -5.077520>, <0.976719, -3.962864, -5.077520>, <2.279423, -3.962864, -5.122887>, <3.254550, -3.962864, -5.076846>, 
      <-0.976011, -3.962864, -5.077520>, <0.000202, -3.962864, -5.077520>, <0.328809, -4.053758, -5.122887>, <3.254550, -3.962864, -5.076846>, 
      <-2.279119, -3.962864, -5.122888>, <-0.328506, -4.053758, -5.122888>, <0.328809, -4.053758, -5.122887>, <3.254550, -3.962864, -5.076846>, 
      <-3.254550, -3.962864, -5.076846>, <-1.303937, -4.053758, -5.076846>, <1.303937, -4.053758, -5.076846>, <3.254550, -3.962864, -5.076846>
    }
  }
  material {
    suelo_cabina_txt
  }
}
#declare frente_caja = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.254550, -3.542932, -5.165554>, <3.254550, -3.633925, -5.165554>, <3.345444, -3.842005, -5.165554>, <3.254550, -3.846240, -5.165554>, 
      <2.279423, -3.542932, -5.211595>, <2.279423, -3.633925, -5.211595>, <2.370317, -3.842005, -5.211595>, <2.279423, -3.846240, -5.211595>, 
      <0.976719, -3.542932, -5.166228>, <0.976719, -3.633925, -5.166228>, <0.976719, -3.755248, -5.166228>, <0.976719, -3.846240, -5.166228>, 
      <0.000505, -3.542932, -5.166228>, <0.000505, -3.633925, -5.166228>, <0.000505, -3.755248, -5.166228>, <0.000505, -3.846240, -5.166228>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.732120, -3.846240, -2.354788>, <3.732397, -3.847364, -2.161368>, <3.734774, -3.858436, -1.903638>, <3.735911, -3.863663, -1.710288>, 
      <3.823037, -3.842546, -2.354788>, <3.823314, -3.843670, -2.161368>, <3.822424, -3.854864, -1.903638>, <3.823562, -3.860092, -1.710288>, 
      <3.732120, -3.633925, -2.354788>, <3.731468, -3.635776, -2.161231>, <3.729012, -3.650622, -1.903638>, <3.725828, -3.659225, -1.710288>, 
      <3.732120, -3.542932, -2.354788>, <3.731468, -3.544783, -2.161231>, <3.724691, -3.563006, -1.903638>, <3.721507, -3.571608, -1.710288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.731614, -3.846240, -4.709715>, <3.776480, -3.846240, -4.004663>, <3.731108, -3.842137, -3.061254>, <3.732120, -3.846240, -2.354788>, 
      <3.822532, -3.842546, -4.709715>, <3.867397, -3.842546, -4.004663>, <3.822025, -3.838442, -3.061254>, <3.823037, -3.842546, -2.354788>, 
      <3.731614, -3.633925, -4.709715>, <3.776480, -3.633925, -4.004663>, <3.734500, -3.627171, -3.061230>, <3.732120, -3.633925, -2.354788>, 
      <3.731614, -3.542932, -4.709715>, <3.776480, -3.542932, -4.004663>, <3.734500, -3.536178, -3.061230>, <3.732120, -3.542932, -2.354788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.563923, -3.846240, -4.997980>, <3.636258, -3.846240, -4.928863>, <3.725261, -3.846240, -4.809561>, <3.731614, -3.846240, -4.709715>, 
      <3.654833, -3.842372, -4.997980>, <3.727168, -3.842372, -4.928863>, <3.816178, -3.842546, -4.809561>, <3.822532, -3.842546, -4.709715>, 
      <3.563923, -3.633925, -4.997980>, <3.636258, -3.633925, -4.928863>, <3.725261, -3.633925, -4.809561>, <3.731614, -3.633925, -4.709715>, 
      <3.563923, -3.542932, -4.997980>, <3.636258, -3.542932, -4.928863>, <3.725261, -3.542932, -4.809561>, <3.731614, -3.542932, -4.709715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.254550, -3.846240, -5.165554>, <3.359985, -3.846240, -5.160576>, <3.487608, -3.846240, -5.070900>, <3.563923, -3.846240, -4.997980>, 
      <3.345444, -3.842005, -5.165554>, <3.450879, -3.842005, -5.160576>, <3.578518, -3.842372, -5.070900>, <3.654833, -3.842372, -4.997980>, 
      <3.254550, -3.633925, -5.165554>, <3.359985, -3.633925, -5.160576>, <3.487608, -3.633925, -5.070900>, <3.563923, -3.633925, -4.997980>, 
      <3.254550, -3.542932, -5.165554>, <3.359985, -3.542932, -5.160576>, <3.487608, -3.542932, -5.070900>, <3.563923, -3.542932, -4.997980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.732120, -3.846240, -2.354788>, <-3.823037, -3.842546, -2.354788>, <-3.732120, -3.633925, -2.354788>, <-3.732120, -3.542932, -2.354788>, 
      <-3.731468, -3.848091, -2.161231>, <-3.822385, -3.844397, -2.161231>, <-3.731468, -3.635776, -2.161231>, <-3.731468, -3.544783, -2.161231>, 
      <-3.724691, -3.866314, -1.903638>, <-3.815614, -3.862753, -1.903638>, <-3.724691, -3.653998, -1.903638>, <-3.724691, -3.563006, -1.903638>, 
      <-3.721507, -3.874917, -1.710288>, <-3.812430, -3.871356, -1.710288>, <-3.721507, -3.662601, -1.710288>, <-3.721507, -3.571608, -1.710288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.731614, -3.846240, -4.709715>, <-3.822532, -3.842546, -4.709715>, <-3.731614, -3.633925, -4.709715>, <-3.731614, -3.542932, -4.709715>, 
      <-3.776480, -3.846240, -4.004663>, <-3.867397, -3.842546, -4.004663>, <-3.776480, -3.633925, -4.004663>, <-3.776480, -3.542932, -4.004663>, 
      <-3.734500, -3.839486, -3.061230>, <-3.825418, -3.835792, -3.061230>, <-3.734500, -3.627171, -3.061230>, <-3.734500, -3.536178, -3.061230>, 
      <-3.732120, -3.846240, -2.354788>, <-3.823037, -3.842546, -2.354788>, <-3.732120, -3.633925, -2.354788>, <-3.732120, -3.542932, -2.354788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.563923, -3.846240, -4.997980>, <-3.654833, -3.842372, -4.997980>, <-3.563923, -3.633925, -4.997980>, <-3.563923, -3.542932, -4.997980>, 
      <-3.636258, -3.846240, -4.928863>, <-3.727168, -3.842372, -4.928863>, <-3.636258, -3.633925, -4.928863>, <-3.636258, -3.542932, -4.928863>, 
      <-3.725261, -3.846240, -4.809561>, <-3.816178, -3.842546, -4.809561>, <-3.725261, -3.633925, -4.809561>, <-3.725261, -3.542932, -4.809561>, 
      <-3.731614, -3.846240, -4.709715>, <-3.822532, -3.842546, -4.709715>, <-3.731614, -3.633925, -4.709715>, <-3.731614, -3.542932, -4.709715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.254550, -3.846240, -5.165554>, <-3.345444, -3.842005, -5.165554>, <-3.254550, -3.633925, -5.165554>, <-3.254550, -3.542932, -5.165554>, 
      <-3.359985, -3.846240, -5.160577>, <-3.450879, -3.842005, -5.160577>, <-3.359985, -3.633925, -5.160577>, <-3.359985, -3.542932, -5.160577>, 
      <-3.487608, -3.846240, -5.070900>, <-3.578518, -3.842372, -5.070900>, <-3.487608, -3.633925, -5.070900>, <-3.487608, -3.542932, -5.070900>, 
      <-3.563923, -3.846240, -4.997980>, <-3.654833, -3.842372, -4.997980>, <-3.563923, -3.633925, -4.997980>, <-3.563923, -3.542932, -4.997980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000505, -3.846240, -5.166228>, <0.000505, -3.755248, -5.166228>, <0.000505, -3.633925, -5.166228>, <0.000505, -3.542932, -5.166228>, 
      <-0.976011, -3.846240, -5.166228>, <-0.976011, -3.755248, -5.166228>, <-0.976011, -3.633925, -5.166228>, <-0.976011, -3.542932, -5.166228>, 
      <-2.279119, -3.846240, -5.211596>, <-2.370013, -3.842005, -5.211596>, <-2.279119, -3.633925, -5.211596>, <-2.279119, -3.542932, -5.211596>, 
      <-3.254550, -3.846240, -5.165554>, <-3.345444, -3.842005, -5.165554>, <-3.254550, -3.633925, -5.165554>, <-3.254550, -3.542932, -5.165554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.563923, -3.846240, -4.997980>, <1.427502, -3.937151, -4.997980>, <-1.427502, -3.937151, -4.997980>, <-3.563923, -3.846240, -4.997980>, 
      <3.487608, -3.846240, -5.070900>, <1.351187, -3.937151, -5.070900>, <-1.351187, -3.937151, -5.070900>, <-3.487608, -3.846240, -5.070900>, 
      <3.359985, -3.846240, -5.160576>, <1.409372, -3.937134, -5.160576>, <-1.409372, -3.937134, -5.160577>, <-3.359985, -3.846240, -5.160577>, 
      <3.254550, -3.846240, -5.165554>, <1.303937, -3.937134, -5.165554>, <-1.303937, -3.937134, -5.165554>, <-3.254550, -3.846240, -5.165554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.731614, -3.846240, -4.709715>, <1.494492, -3.937158, -4.709715>, <-1.494492, -3.937158, -4.709715>, <-3.731614, -3.846240, -4.709715>, 
      <3.725261, -3.846240, -4.809561>, <1.488139, -3.937158, -4.809561>, <-1.488139, -3.937158, -4.809561>, <-3.725261, -3.846240, -4.809561>, 
      <3.636258, -3.846240, -4.928863>, <1.499838, -3.937151, -4.928863>, <-1.499838, -3.937151, -4.928863>, <-3.636258, -3.846240, -4.928863>, 
      <3.563923, -3.846240, -4.997980>, <1.427502, -3.937151, -4.997980>, <-1.427502, -3.937151, -4.997980>, <-3.563923, -3.846240, -4.997980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.732120, -3.846240, -2.354788>, <1.494694, -3.937158, -2.354788>, <-1.494694, -3.937158, -2.354788>, <-3.732120, -3.846240, -2.354788>, 
      <3.731108, -3.842137, -3.061254>, <1.493682, -3.933054, -3.061254>, <-1.497075, -3.930404, -3.061230>, <-3.734500, -3.839486, -3.061230>, 
      <3.776480, -3.846240, -4.004663>, <1.539357, -3.937158, -4.004663>, <-1.539357, -3.937158, -4.004663>, <-3.776480, -3.846240, -4.004663>, 
      <3.731614, -3.846240, -4.709715>, <1.494492, -3.937158, -4.709715>, <-1.494492, -3.937158, -4.709715>, <-3.731614, -3.846240, -4.709715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.735911, -3.863663, -1.710288>, <1.500538, -3.954756, -1.710288>, <-1.485993, -3.962466, -1.710288>, <-3.721507, -3.874917, -1.710288>, 
      <3.734774, -3.858436, -1.903638>, <1.499401, -3.949530, -1.903638>, <-1.489176, -3.953864, -1.903638>, <-3.724691, -3.866314, -1.903638>, 
      <3.732397, -3.847364, -2.161368>, <1.494971, -3.938281, -2.161368>, <-1.494042, -3.939008, -2.161231>, <-3.731468, -3.848091, -2.161231>, 
      <3.732120, -3.846240, -2.354788>, <1.494694, -3.937158, -2.354788>, <-1.494694, -3.937158, -2.354788>, <-3.732120, -3.846240, -2.354788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.254550, -3.846240, -5.165554>, <1.303937, -3.937134, -5.165554>, <-1.303937, -3.937134, -5.165554>, <-3.254550, -3.846240, -5.165554>, 
      <2.279423, -3.846240, -5.211595>, <0.328809, -3.937134, -5.211595>, <-0.328506, -3.937134, -5.211596>, <-3.254550, -3.846240, -5.165554>, 
      <0.976719, -3.846240, -5.166228>, <0.000202, -3.846240, -5.166228>, <-0.328506, -3.937134, -5.211596>, <-3.254550, -3.846240, -5.165554>, 
      <0.000505, -3.846240, -5.166228>, <-0.976011, -3.846240, -5.166228>, <-2.279119, -3.846240, -5.211596>, <-3.254550, -3.846240, -5.165554>
    }
  }
}
#declare fondo_caja = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.715580, -0.016544, -5.210660>, <1.486232, -0.016544, -5.210660>, <-1.486232, -0.016544, -5.210660>, <-3.715580, -0.016544, -5.210660>, 
      <3.636017, -0.016544, -5.286683>, <1.406669, -0.016544, -5.286683>, <-1.406669, -0.016544, -5.286683>, <-3.636017, -0.016544, -5.286683>, 
      <3.502964, -0.016544, -5.380175>, <1.467138, -0.016544, -5.380175>, <-1.467138, -0.016544, -5.380176>, <-3.502964, -0.016544, -5.380176>, 
      <3.393042, -0.016544, -5.385365>, <1.357217, -0.016544, -5.385365>, <-1.357217, -0.016544, -5.385365>, <-3.393042, -0.016544, -5.385365>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.890407, -0.016544, -4.910128>, <1.556163, -0.016544, -4.910128>, <-1.556163, -0.016544, -4.910128>, <-3.890407, -0.016544, -4.910128>, 
      <3.883783, -0.016544, -5.014223>, <1.549539, -0.016544, -5.014223>, <-1.549539, -0.016544, -5.014223>, <-3.883783, -0.016544, -5.014223>, 
      <3.790993, -0.016544, -5.138602>, <1.561645, -0.016544, -5.138602>, <-1.561645, -0.016544, -5.138602>, <-3.790993, -0.016544, -5.138602>, 
      <3.715580, -0.016544, -5.210660>, <1.486232, -0.016544, -5.210660>, <-1.486232, -0.016544, -5.210660>, <-3.715580, -0.016544, -5.210660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.890934, -0.016544, -2.454992>, <1.556373, -0.016544, -2.454992>, <-1.556373, -0.016544, -2.454992>, <-3.890934, -0.016544, -2.454992>, 
      <3.892511, -0.016544, -3.191531>, <1.557951, -0.016544, -3.191531>, <-1.557951, -0.016544, -3.191531>, <-3.892511, -0.016544, -3.191531>, 
      <3.937181, -0.016544, -4.175074>, <1.602937, -0.016544, -4.175074>, <-1.602937, -0.016544, -4.175074>, <-3.937181, -0.016544, -4.175074>, 
      <3.890407, -0.016544, -4.910128>, <1.556163, -0.016544, -4.910128>, <-1.556163, -0.016544, -4.910128>, <-3.890407, -0.016544, -4.910128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.879869, -0.016544, 0.009420>, <1.551948, -0.016544, 0.009420>, <-1.551948, -0.016544, 0.009420>, <-3.879869, -0.016544, 0.009420>, 
      <3.879869, -0.016544, -0.729911>, <1.551948, -0.016544, -0.729911>, <-1.551948, -0.016544, -0.729911>, <-3.879869, -0.016544, -0.729911>, 
      <3.889350, -0.016544, -1.715663>, <1.554790, -0.016544, -1.715663>, <-1.554790, -0.016544, -1.715663>, <-3.889350, -0.016544, -1.715663>, 
      <3.890934, -0.016544, -2.454992>, <1.556373, -0.016544, -2.454992>, <-1.556373, -0.016544, -2.454992>, <-3.890934, -0.016544, -2.454992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.890934, -0.016544, 2.454992>, <1.556373, -0.016544, 2.454992>, <-1.556373, -0.016544, 2.454992>, <-3.890934, -0.016544, 2.454992>, 
      <3.889356, -0.016544, 1.721314>, <1.554796, -0.016544, 1.721314>, <-1.554796, -0.016544, 1.721314>, <-3.889356, -0.016544, 1.721314>, 
      <3.879869, -0.016544, 0.743099>, <1.551948, -0.016544, 0.743099>, <-1.551948, -0.016544, 0.743099>, <-3.879869, -0.016544, 0.743099>, 
      <3.879869, -0.016544, 0.009420>, <1.551948, -0.016544, 0.009420>, <-1.551948, -0.016544, 0.009420>, <-3.879869, -0.016544, 0.009420>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.890407, -0.016544, 4.910128>, <1.556163, -0.016544, 4.910128>, <-1.556163, -0.016544, 4.910128>, <-3.890407, -0.016544, 4.910128>, 
      <3.937181, -0.016544, 4.175074>, <1.602937, -0.016544, 4.175074>, <-1.602937, -0.016544, 4.175074>, <-3.937181, -0.016544, 4.175074>, 
      <3.892517, -0.016544, 3.191531>, <1.557957, -0.016544, 3.191531>, <-1.557957, -0.016544, 3.191531>, <-3.892517, -0.016544, 3.191531>, 
      <3.890934, -0.016544, 2.454992>, <1.556373, -0.016544, 2.454992>, <-1.556373, -0.016544, 2.454992>, <-3.890934, -0.016544, 2.454992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.715580, -0.016544, 5.210660>, <1.486232, -0.016544, 5.210660>, <-1.486232, -0.016544, 5.210660>, <-3.715580, -0.016544, 5.210660>, 
      <3.790993, -0.016544, 5.138602>, <1.561645, -0.016544, 5.138602>, <-1.561645, -0.016544, 5.138602>, <-3.790993, -0.016544, 5.138602>, 
      <3.883783, -0.016544, 5.014223>, <1.549539, -0.016544, 5.014223>, <-1.549539, -0.016544, 5.014223>, <-3.883783, -0.016544, 5.014223>, 
      <3.890407, -0.016544, 4.910128>, <1.556163, -0.016544, 4.910128>, <-1.556163, -0.016544, 4.910128>, <-3.890407, -0.016544, 4.910128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.393042, -0.016544, 5.385365>, <1.357217, -0.016544, 5.385365>, <-1.357217, -0.016544, 5.385365>, <-3.393042, -0.016544, 5.385365>, 
      <3.502964, -0.016544, 5.380175>, <1.467138, -0.016544, 5.380175>, <-1.467138, -0.016544, 5.380176>, <-3.502964, -0.016544, 5.380176>, 
      <3.636017, -0.016544, 5.286683>, <1.406669, -0.016544, 5.286683>, <-1.406669, -0.016544, 5.286683>, <-3.636017, -0.016544, 5.286683>, 
      <3.715580, -0.016544, 5.210660>, <1.486232, -0.016544, 5.210660>, <-1.486232, -0.016544, 5.210660>, <-3.715580, -0.016544, 5.210660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.393042, -0.016544, 5.385365>, <-1.357217, -0.016544, 5.385365>, <1.357217, -0.016544, 5.385365>, <3.393042, -0.016544, 5.385365>, 
      <-2.376103, -0.016544, 5.433366>, <-0.340278, -0.016544, 5.433366>, <0.340595, -0.016544, 5.433365>, <3.393042, -0.016544, 5.385365>, 
      <-1.017544, -0.016544, 5.386068>, <0.000211, -0.016544, 5.386068>, <0.340595, -0.016544, 5.433365>, <3.393042, -0.016544, 5.385365>, 
      <0.000527, -0.016544, 5.386068>, <1.018282, -0.016544, 5.386068>, <2.376420, -0.016544, 5.433365>, <3.393042, -0.016544, 5.385365>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000527, -0.016544, -5.386068>, <1.018282, -0.016544, -5.386068>, <2.376420, -0.016544, -5.433365>, <3.393042, -0.016544, -5.385365>, 
      <-1.017544, -0.016544, -5.386068>, <0.000211, -0.016544, -5.386068>, <0.340595, -0.016544, -5.433365>, <3.393042, -0.016544, -5.385365>, 
      <-2.376103, -0.016544, -5.433366>, <-0.340278, -0.016544, -5.433366>, <0.340595, -0.016544, -5.433365>, <3.393042, -0.016544, -5.385365>, 
      <-3.393042, -0.016544, -5.385365>, <-1.357217, -0.016544, -5.385365>, <1.357217, -0.016544, -5.385365>, <3.393042, -0.016544, -5.385365>
    }
  }
}
#declare caja_base = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.257667, -3.947422, -5.170500>, <3.363202, -3.947422, -5.165519>, <3.490947, -3.947422, -5.075756>, <3.567336, -3.947422, -5.002766>, 
      <3.223491, -3.669236, -5.116258>, <3.329027, -3.669236, -5.111276>, <3.453532, -3.669306, -5.023286>, <3.529921, -3.669306, -4.950296>, 
      <3.234863, -3.282680, -5.134307>, <3.339344, -3.282680, -5.129375>, <3.466740, -3.282680, -5.040007>, <3.542364, -3.282680, -4.967747>, 
      <3.225090, -2.997791, -5.118795>, <3.329571, -2.997791, -5.113864>, <3.456038, -2.997791, -5.024998>, <3.531662, -2.997791, -4.952738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.358419, -4.083084, -5.330412>, <3.467219, -4.083084, -5.325277>, <3.598915, -4.083084, -5.232738>, <3.677666, -4.083084, -5.157491>, 
      <3.321213, -4.083084, -5.271360>, <3.430013, -4.083084, -5.266225>, <3.558247, -4.083084, -5.175706>, <3.636998, -4.083084, -5.100459>, 
      <3.266022, -4.015435, -5.183762>, <3.371558, -4.015435, -5.178780>, <3.500127, -4.015661, -5.088630>, <3.576516, -4.015661, -5.015640>, 
      <3.257667, -3.947422, -5.170500>, <3.363202, -3.947422, -5.165519>, <3.490947, -3.947422, -5.075756>, <3.567336, -3.947422, -5.002766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.462288, -3.947422, -5.495270>, <3.574452, -3.947422, -5.489976>, <3.710221, -3.947422, -5.394575>, <3.791408, -3.947422, -5.317000>, 
      <3.460478, -4.018569, -5.492398>, <3.572642, -4.018569, -5.487104>, <3.708232, -4.018829, -5.391785>, <3.789418, -4.018829, -5.314211>, 
      <3.396388, -4.083084, -5.390676>, <3.505188, -4.083084, -5.385540>, <3.640420, -4.083084, -5.290944>, <3.719170, -4.083084, -5.215697>, 
      <3.358419, -4.083084, -5.330412>, <3.467219, -4.083084, -5.325277>, <3.598915, -4.083084, -5.232738>, <3.677666, -4.083084, -5.157491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.567336, -3.947422, -5.002766>, <3.639740, -3.947422, -4.933583>, <3.728828, -3.947422, -4.814166>, <3.735188, -3.947422, -4.714224>, 
      <3.529921, -3.669306, -4.950296>, <3.602326, -3.669306, -4.881113>, <3.689615, -3.669034, -4.764674>, <3.695974, -3.669034, -4.664732>, 
      <3.542364, -3.282680, -4.967747>, <3.614045, -3.282680, -4.899255>, <3.702746, -3.282680, -4.780167>, <3.709042, -3.282680, -4.681225>, 
      <3.531662, -2.997791, -4.952738>, <3.603343, -2.997791, -4.884247>, <3.691540, -2.997791, -4.766024>, <3.697836, -2.997791, -4.667082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.677666, -4.083084, -5.157491>, <3.752310, -4.083084, -5.086168>, <3.844153, -4.083084, -4.963058>, <3.850709, -4.083084, -4.860025>, 
      <3.636998, -4.083084, -5.100459>, <3.711642, -4.083084, -5.029136>, <3.801259, -4.083084, -4.908921>, <3.807815, -4.083084, -4.805888>, 
      <3.576516, -4.015661, -5.015640>, <3.648920, -4.015661, -4.946457>, <3.738316, -4.014782, -4.826141>, <3.744676, -4.014782, -4.726199>, 
      <3.567336, -3.947422, -5.002766>, <3.639740, -3.947422, -4.933583>, <3.728828, -3.947422, -4.814166>, <3.735188, -3.947422, -4.714224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.791408, -3.947422, -5.317000>, <3.868360, -3.947422, -5.243472>, <3.963044, -3.947422, -5.116554>, <3.969803, -3.947422, -5.010335>, 
      <3.789418, -4.018829, -5.314211>, <3.866371, -4.018829, -5.240682>, <3.960990, -4.017816, -5.113962>, <3.967750, -4.017816, -5.007743>, 
      <3.719170, -4.083084, -5.215697>, <3.793815, -4.083084, -5.144374>, <3.887917, -4.083084, -5.018293>, <3.894473, -4.083084, -4.915260>, 
      <3.677666, -4.083084, -5.157491>, <3.752310, -4.083084, -5.086168>, <3.844153, -4.083084, -4.963058>, <3.850709, -4.083084, -4.860025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.735188, -3.947422, -4.714224>, <3.780096, -3.947422, -4.008497>, <3.737208, -3.947422, -3.064196>, <3.735694, -3.947422, -2.357043>, 
      <3.695974, -3.669034, -4.664732>, <3.740883, -3.669034, -3.959005>, <3.697576, -3.666101, -3.039190>, <3.696062, -3.666101, -2.332037>, 
      <3.709042, -3.282680, -4.681225>, <3.753501, -3.282680, -3.982555>, <3.711043, -3.282680, -3.040625>, <3.709544, -3.282680, -2.340544>, 
      <3.697836, -2.997791, -4.667082>, <3.742295, -2.997791, -3.968412>, <3.699836, -2.997791, -3.033554>, <3.698337, -2.997791, -2.333473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.850709, -4.083084, -4.860025>, <3.897006, -4.083084, -4.132471>, <3.852792, -4.083084, -3.158965>, <3.851230, -4.083084, -2.429941>, 
      <3.807815, -4.083084, -4.805888>, <3.854112, -4.083084, -4.078334>, <3.803944, -4.083084, -3.128144>, <3.802382, -4.083084, -2.399121>, 
      <3.744676, -4.014782, -4.726199>, <3.789584, -4.014782, -4.020472>, <3.745234, -4.004396, -3.069260>, <3.743720, -4.004396, -2.362107>, 
      <3.735188, -3.947422, -4.714224>, <3.780096, -3.947422, -4.008497>, <3.737208, -3.947422, -3.064196>, <3.735694, -3.947422, -2.357043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.969803, -3.947422, -5.010335>, <4.017532, -3.947422, -4.260280>, <3.971950, -3.947422, -3.256665>, <3.970340, -3.947422, -2.505094>, 
      <3.967750, -4.017816, -5.007743>, <4.015479, -4.017816, -4.257688>, <3.970240, -4.006052, -3.255585>, <3.968630, -4.006052, -2.504015>, 
      <3.894473, -4.083084, -4.915260>, <3.940770, -4.083084, -4.187706>, <3.902406, -4.083084, -3.190269>, <3.900844, -4.083084, -2.461245>, 
      <3.850709, -4.083084, -4.860025>, <3.897006, -4.083084, -4.132471>, <3.852792, -4.083084, -3.158965>, <3.851230, -4.083084, -2.429941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.735694, -3.947422, -2.357043>, <3.734173, -3.947422, -1.647211>, <3.725071, -3.947423, -0.700789>, <3.725071, -3.947423, 0.009044>, 
      <3.696062, -3.666101, -2.332037>, <3.694541, -3.666101, -1.622206>, <3.685409, -3.665086, -0.700886>, <3.685409, -3.665086, 0.008948>, 
      <3.709544, -3.282680, -2.340544>, <3.708038, -3.282680, -1.637810>, <3.698995, -3.282681, -0.693755>, <3.698995, -3.282681, 0.008981>, 
      <3.698337, -2.997791, -2.333473>, <3.696832, -2.997791, -1.630739>, <3.687820, -2.997791, -0.693782>, <3.687820, -2.997791, 0.008953>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.851230, -4.083084, -2.429941>, <3.849663, -4.083084, -1.698156>, <3.840279, -4.083084, -0.722463>, <3.840279, -4.083084, 0.009324>, 
      <3.802382, -4.083084, -2.399121>, <3.800815, -4.083084, -1.667336>, <3.786885, -4.083084, -0.722593>, <3.786885, -4.083084, 0.009194>, 
      <3.743720, -4.004396, -2.362107>, <3.742200, -4.004396, -1.652276>, <3.732498, -4.000298, -0.700771>, <3.732498, -4.000298, 0.009062>, 
      <3.735694, -3.947422, -2.357043>, <3.734173, -3.947422, -1.647211>, <3.725071, -3.947423, -0.700789>, <3.725071, -3.947423, 0.009044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.970340, -3.947422, -2.505094>, <3.968724, -3.947422, -1.750676>, <3.959050, -3.947423, -0.744807>, <3.959050, -3.947423, 0.009612>, 
      <3.968630, -4.006052, -2.504015>, <3.967014, -4.006052, -1.749597>, <3.957477, -4.001492, -0.744811>, <3.957477, -4.001492, 0.009608>, 
      <3.900844, -4.083084, -2.461245>, <3.899277, -4.083084, -1.729460>, <3.894371, -4.083084, -0.722332>, <3.894371, -4.083084, 0.009455>, 
      <3.851230, -4.083084, -2.429941>, <3.849663, -4.083084, -1.698156>, <3.840279, -4.083084, -0.722463>, <3.840279, -4.083084, 0.009324>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.725071, -3.947423, 0.009044>, <3.725071, -3.947423, 0.713451>, <3.734179, -3.947423, 1.652638>, <3.735694, -3.947423, 2.357043>, 
      <3.685409, -3.665086, 0.008948>, <3.685409, -3.665086, 0.713355>, <3.694547, -3.666102, 1.627632>, <3.696062, -3.666102, 2.332037>, 
      <3.698995, -3.282681, 0.008981>, <3.698995, -3.282681, 0.706344>, <3.708044, -3.282681, 1.643182>, <3.709544, -3.282681, 2.340544>, 
      <3.687820, -2.997791, 0.008953>, <3.687820, -2.997791, 0.706316>, <3.696837, -2.997791, 1.636111>, <3.698337, -2.997791, 2.333473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.840279, -4.083084, 0.009324>, <3.840279, -4.083084, 0.735516>, <3.849669, -4.083084, 1.703750>, <3.851230, -4.083084, 2.429941>, 
      <3.786885, -4.083084, 0.009194>, <3.786885, -4.083084, 0.735387>, <3.800821, -4.083084, 1.672930>, <3.802382, -4.083084, 2.399121>, 
      <3.732498, -4.000298, 0.009062>, <3.732498, -4.000298, 0.713469>, <3.742205, -4.004396, 1.657702>, <3.743720, -4.004396, 2.362107>, 
      <3.725071, -3.947423, 0.009044>, <3.725071, -3.947423, 0.713451>, <3.734179, -3.947423, 1.652638>, <3.735694, -3.947423, 2.357043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.959050, -3.947423, 0.009612>, <3.959050, -3.947423, 0.758264>, <3.968730, -3.947423, 1.756443>, <3.970340, -3.947423, 2.505094>, 
      <3.957477, -4.001492, 0.009608>, <3.957477, -4.001492, 0.758260>, <3.967020, -4.006052, 1.755364>, <3.968630, -4.006052, 2.504015>, 
      <3.894371, -4.083084, 0.009455>, <3.894371, -4.083084, 0.735648>, <3.899283, -4.083084, 1.735054>, <3.900844, -4.083084, 2.461245>, 
      <3.840279, -4.083084, 0.009324>, <3.840279, -4.083084, 0.735516>, <3.849669, -4.083084, 1.703750>, <3.851230, -4.083084, 2.429941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.735694, -3.947423, 2.357043>, <3.737214, -3.947423, 3.064196>, <3.780096, -3.947423, 4.008497>, <3.735188, -3.947423, 4.714224>, 
      <3.696062, -3.666102, 2.332037>, <3.697582, -3.666102, 3.039190>, <3.740883, -3.669034, 3.959005>, <3.695974, -3.669034, 4.664732>, 
      <3.709544, -3.282681, 2.340544>, <3.711049, -3.282681, 3.040625>, <3.753501, -3.282681, 3.982555>, <3.709042, -3.282681, 4.681225>, 
      <3.698337, -2.997791, 2.333473>, <3.699842, -2.997791, 3.033554>, <3.742295, -2.997791, 3.968412>, <3.697836, -2.997791, 4.667082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.851230, -4.083084, 2.429941>, <3.852798, -4.083084, 3.158965>, <3.897006, -4.083084, 4.132471>, <3.850709, -4.083084, 4.860025>, 
      <3.802382, -4.083084, 2.399121>, <3.803950, -4.083084, 3.128144>, <3.854112, -4.083084, 4.078334>, <3.807815, -4.083084, 4.805888>, 
      <3.743720, -4.004396, 2.362107>, <3.745240, -4.004396, 3.069260>, <3.789584, -4.014782, 4.020472>, <3.744676, -4.014782, 4.726199>, 
      <3.735694, -3.947423, 2.357043>, <3.737214, -3.947423, 3.064196>, <3.780096, -3.947423, 4.008497>, <3.735188, -3.947423, 4.714224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.970340, -3.947423, 2.505094>, <3.971956, -3.947423, 3.256665>, <4.017532, -3.947423, 4.260280>, <3.969803, -3.947423, 5.010335>, 
      <3.968630, -4.006052, 2.504015>, <3.970246, -4.006052, 3.255585>, <4.015479, -4.017816, 4.257688>, <3.967750, -4.017816, 5.007743>, 
      <3.900844, -4.083084, 2.461245>, <3.902412, -4.083084, 3.190269>, <3.940770, -4.083084, 4.187706>, <3.894473, -4.083084, 4.915260>, 
      <3.851230, -4.083084, 2.429941>, <3.852798, -4.083084, 3.158965>, <3.897006, -4.083084, 4.132471>, <3.850709, -4.083084, 4.860025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.735188, -3.947423, 4.714224>, <3.728828, -3.947423, 4.814166>, <3.639740, -3.947423, 4.933583>, <3.567336, -3.947423, 5.002766>, 
      <3.695974, -3.669034, 4.664732>, <3.689615, -3.669034, 4.764674>, <3.602326, -3.669306, 4.881113>, <3.529921, -3.669306, 4.950296>, 
      <3.709042, -3.282681, 4.681225>, <3.702746, -3.282681, 4.780167>, <3.614045, -3.282681, 4.899255>, <3.542364, -3.282681, 4.967747>, 
      <3.697836, -2.997791, 4.667082>, <3.691540, -2.997791, 4.766024>, <3.603343, -2.997791, 4.884247>, <3.531662, -2.997791, 4.952738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.850709, -4.083084, 4.860025>, <3.844153, -4.083084, 4.963058>, <3.752310, -4.083084, 5.086168>, <3.677666, -4.083084, 5.157491>, 
      <3.807815, -4.083084, 4.805888>, <3.801259, -4.083084, 4.908921>, <3.711642, -4.083084, 5.029136>, <3.636998, -4.083084, 5.100459>, 
      <3.744676, -4.014782, 4.726199>, <3.738316, -4.014782, 4.826141>, <3.648920, -4.015661, 4.946457>, <3.576516, -4.015661, 5.015640>, 
      <3.735188, -3.947423, 4.714224>, <3.728828, -3.947423, 4.814166>, <3.639740, -3.947423, 4.933583>, <3.567336, -3.947423, 5.002766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.969803, -3.947423, 5.010335>, <3.963044, -3.947423, 5.116554>, <3.868360, -3.947423, 5.243472>, <3.791408, -3.947423, 5.317000>, 
      <3.967750, -4.017816, 5.007743>, <3.960990, -4.017816, 5.113962>, <3.866371, -4.018829, 5.240682>, <3.789418, -4.018829, 5.314211>, 
      <3.894473, -4.083084, 4.915260>, <3.887917, -4.083084, 5.018293>, <3.793815, -4.083084, 5.144374>, <3.719170, -4.083084, 5.215697>, 
      <3.850709, -4.083084, 4.860025>, <3.844153, -4.083084, 4.963058>, <3.752310, -4.083084, 5.086168>, <3.677666, -4.083084, 5.157491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.567336, -3.947423, 5.002766>, <3.490947, -3.947423, 5.075756>, <3.363202, -3.947423, 5.165519>, <3.257667, -3.947423, 5.170500>, 
      <3.529921, -3.669306, 4.950296>, <3.453532, -3.669306, 5.023286>, <3.329027, -3.669236, 5.111276>, <3.223491, -3.669236, 5.116258>, 
      <3.542364, -3.282681, 4.967747>, <3.466740, -3.282681, 5.040007>, <3.339344, -3.282681, 5.129375>, <3.234863, -3.282681, 5.134307>, 
      <3.531662, -2.997791, 4.952738>, <3.456038, -2.997791, 5.024998>, <3.329571, -2.997791, 5.113864>, <3.225090, -2.997791, 5.118795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.677666, -4.083084, 5.157491>, <3.598915, -4.083084, 5.232738>, <3.467219, -4.083084, 5.325277>, <3.358419, -4.083084, 5.330412>, 
      <3.636998, -4.083084, 5.100459>, <3.558247, -4.083084, 5.175706>, <3.430013, -4.083084, 5.266225>, <3.321213, -4.083084, 5.271360>, 
      <3.576516, -4.015661, 5.015640>, <3.500127, -4.015661, 5.088630>, <3.371558, -4.015436, 5.178780>, <3.266022, -4.015436, 5.183762>, 
      <3.567336, -3.947423, 5.002766>, <3.490947, -3.947423, 5.075756>, <3.363202, -3.947423, 5.165519>, <3.257667, -3.947423, 5.170500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.791408, -3.947423, 5.317000>, <3.710221, -3.947423, 5.394575>, <3.574452, -3.947423, 5.489976>, <3.462288, -3.947423, 5.495270>, 
      <3.789418, -4.018829, 5.314211>, <3.708232, -4.018829, 5.391785>, <3.572642, -4.018570, 5.487104>, <3.460478, -4.018570, 5.492398>, 
      <3.719170, -4.083084, 5.215697>, <3.640420, -4.083084, 5.290944>, <3.505188, -4.083084, 5.385540>, <3.396388, -4.083084, 5.390676>, 
      <3.677666, -4.083084, 5.157491>, <3.598915, -4.083084, 5.232738>, <3.467219, -4.083084, 5.325277>, <3.358419, -4.083084, 5.330412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.257667, -3.947423, 5.170500>, <2.281302, -3.947423, 5.216586>, <0.976946, -3.947423, 5.171175>, <-0.000506, -3.947423, 5.171175>, 
      <3.223491, -3.669236, 5.116258>, <2.247126, -3.669236, 5.162344>, <0.976951, -3.667386, 5.116565>, <-0.000500, -3.667386, 5.116565>, 
      <3.234863, -3.282681, 5.134307>, <2.268262, -3.282681, 5.179932>, <0.967175, -3.282681, 5.134977>, <-0.000502, -3.282681, 5.134977>, 
      <3.225090, -2.997791, 5.118795>, <2.258489, -2.997791, 5.164421>, <0.967176, -2.997791, 5.119464>, <-0.000501, -2.997791, 5.119464>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.358419, -4.083084, 5.330412>, <2.351857, -4.083084, 5.377924>, <1.007161, -4.083084, 5.331108>, <-0.000522, -4.083084, 5.331108>, 
      <3.321213, -4.083084, 5.271360>, <2.314652, -4.083084, 5.318872>, <1.007167, -4.083084, 5.268192>, <-0.000515, -4.083084, 5.268192>, 
      <3.266022, -4.015436, 5.183762>, <2.289657, -4.015436, 5.229848>, <0.976945, -4.009176, 5.183218>, <-0.000507, -4.009176, 5.183218>, 
      <3.257667, -3.947423, 5.170500>, <2.281302, -3.947423, 5.216586>, <0.976946, -3.947423, 5.171175>, <-0.000506, -3.947423, 5.171175>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.462288, -3.947423, 5.495270>, <2.424595, -3.947423, 5.544252>, <1.038310, -3.947423, 5.495988>, <-0.000538, -3.947423, 5.495988>, 
      <3.460478, -4.018570, 5.492398>, <2.422786, -4.018570, 5.541379>, <1.038310, -4.011426, 5.493403>, <-0.000537, -4.011426, 5.493403>, 
      <3.396388, -4.083084, 5.390676>, <2.389827, -4.083084, 5.438188>, <1.007154, -4.083084, 5.395163>, <-0.000528, -4.083084, 5.395163>, 
      <3.358419, -4.083084, 5.330412>, <2.351857, -4.083084, 5.377924>, <1.007161, -4.083084, 5.331108>, <-0.000522, -4.083084, 5.331108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000506, -3.947423, 5.171175>, <-0.977654, -3.947423, 5.171175>, <-2.281606, -3.947423, 5.216585>, <-3.257667, -3.947423, 5.170500>, 
      <-0.000500, -3.667386, 5.116565>, <-0.977649, -3.667386, 5.116565>, <-2.247430, -3.669236, 5.162342>, <-3.223491, -3.669236, 5.116258>, 
      <-0.000502, -3.282681, 5.134977>, <-0.967879, -3.282681, 5.134977>, <-2.268563, -3.282681, 5.179931>, <-3.234863, -3.282681, 5.134307>, 
      <-0.000501, -2.997791, 5.119464>, <-0.967878, -2.997791, 5.119464>, <-2.258790, -2.997791, 5.164420>, <-3.225090, -2.997791, 5.118795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000522, -4.083084, 5.331108>, <-1.007891, -4.083084, 5.331108>, <-2.352171, -4.083084, 5.377922>, <-3.358419, -4.083084, 5.330412>, 
      <-0.000515, -4.083084, 5.268192>, <-1.007885, -4.083084, 5.268192>, <-2.314965, -4.083084, 5.318870>, <-3.321213, -4.083084, 5.271360>, 
      <-0.000507, -4.009176, 5.183218>, <-0.977655, -4.009176, 5.183218>, <-2.289961, -4.015436, 5.229846>, <-3.266022, -4.015436, 5.183762>, 
      <-0.000506, -3.947423, 5.171175>, <-0.977654, -3.947423, 5.171175>, <-2.281606, -3.947423, 5.216585>, <-3.257667, -3.947423, 5.170500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000538, -3.947423, 5.495988>, <-1.039063, -3.947423, 5.495988>, <-2.424918, -3.947423, 5.544250>, <-3.462288, -3.947423, 5.495270>, 
      <-0.000537, -4.011426, 5.493403>, <-1.039062, -4.011426, 5.493403>, <-2.423108, -4.018570, 5.541378>, <-3.460478, -4.018570, 5.492398>, 
      <-0.000528, -4.083084, 5.395163>, <-1.007897, -4.083084, 5.395163>, <-2.390140, -4.083084, 5.438186>, <-3.396388, -4.083084, 5.390676>, 
      <-0.000522, -4.083084, 5.331108>, <-1.007891, -4.083084, 5.331108>, <-2.352171, -4.083084, 5.377922>, <-3.358419, -4.083084, 5.330412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.257667, -3.947423, 5.170500>, <-3.363202, -3.947423, 5.165517>, <-3.490947, -3.947423, 5.075756>, <-3.567336, -3.947423, 5.002766>, 
      <-3.223491, -3.669236, 5.116258>, <-3.329027, -3.669236, 5.111275>, <-3.453532, -3.669306, 5.023286>, <-3.529921, -3.669306, 4.950296>, 
      <-3.234863, -3.282681, 5.134307>, <-3.339344, -3.282681, 5.129374>, <-3.466740, -3.282681, 5.040007>, <-3.542364, -3.282681, 4.967747>, 
      <-3.225090, -2.997791, 5.118795>, <-3.329571, -2.997791, 5.113862>, <-3.456038, -2.997791, 5.024998>, <-3.531662, -2.997791, 4.952738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.358419, -4.083084, 5.330412>, <-3.467219, -4.083084, 5.325276>, <-3.598915, -4.083084, 5.232738>, <-3.677666, -4.083084, 5.157491>, 
      <-3.321213, -4.083084, 5.271360>, <-3.430013, -4.083084, 5.266224>, <-3.558247, -4.083084, 5.175706>, <-3.636998, -4.083084, 5.100459>, 
      <-3.266022, -4.015436, 5.183762>, <-3.371558, -4.015436, 5.178779>, <-3.500127, -4.015661, 5.088630>, <-3.576516, -4.015661, 5.015640>, 
      <-3.257667, -3.947423, 5.170500>, <-3.363202, -3.947423, 5.165517>, <-3.490947, -3.947423, 5.075756>, <-3.567336, -3.947423, 5.002766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.462288, -3.947423, 5.495270>, <-3.574452, -3.947423, 5.489974>, <-3.710221, -3.947423, 5.394575>, <-3.791408, -3.947423, 5.317000>, 
      <-3.460478, -4.018570, 5.492398>, <-3.572642, -4.018570, 5.487102>, <-3.708232, -4.018829, 5.391785>, <-3.789418, -4.018829, 5.314211>, 
      <-3.396388, -4.083084, 5.390676>, <-3.505188, -4.083084, 5.385539>, <-3.640420, -4.083084, 5.290944>, <-3.719170, -4.083084, 5.215697>, 
      <-3.358419, -4.083084, 5.330412>, <-3.467219, -4.083084, 5.325276>, <-3.598915, -4.083084, 5.232738>, <-3.677666, -4.083084, 5.157491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.567336, -3.947423, 5.002766>, <-3.639740, -3.947423, 4.933583>, <-3.728828, -3.947423, 4.814166>, <-3.735188, -3.947423, 4.714224>, 
      <-3.529921, -3.669306, 4.950296>, <-3.602326, -3.669306, 4.881113>, <-3.689615, -3.669034, 4.764674>, <-3.695974, -3.669034, 4.664732>, 
      <-3.542364, -3.282681, 4.967747>, <-3.614045, -3.282681, 4.899255>, <-3.702746, -3.282681, 4.780167>, <-3.709042, -3.282681, 4.681225>, 
      <-3.531662, -2.997791, 4.952738>, <-3.603343, -2.997791, 4.884247>, <-3.691540, -2.997791, 4.766024>, <-3.697836, -2.997791, 4.667082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.677666, -4.083084, 5.157491>, <-3.752310, -4.083084, 5.086168>, <-3.844153, -4.083084, 4.963058>, <-3.850709, -4.083084, 4.860025>, 
      <-3.636998, -4.083084, 5.100459>, <-3.711642, -4.083084, 5.029136>, <-3.801259, -4.083084, 4.908921>, <-3.807815, -4.083084, 4.805888>, 
      <-3.576516, -4.015661, 5.015640>, <-3.648920, -4.015661, 4.946457>, <-3.738316, -4.014782, 4.826141>, <-3.744676, -4.014782, 4.726199>, 
      <-3.567336, -3.947423, 5.002766>, <-3.639740, -3.947423, 4.933583>, <-3.728828, -3.947423, 4.814166>, <-3.735188, -3.947423, 4.714224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.791408, -3.947423, 5.317000>, <-3.868360, -3.947423, 5.243472>, <-3.963044, -3.947423, 5.116554>, <-3.969803, -3.947423, 5.010335>, 
      <-3.789418, -4.018829, 5.314211>, <-3.866371, -4.018829, 5.240682>, <-3.960990, -4.017816, 5.113962>, <-3.967750, -4.017816, 5.007743>, 
      <-3.719170, -4.083084, 5.215697>, <-3.793815, -4.083084, 5.144374>, <-3.887917, -4.083084, 5.018293>, <-3.894473, -4.083084, 4.915260>, 
      <-3.677666, -4.083084, 5.157491>, <-3.752310, -4.083084, 5.086168>, <-3.844153, -4.083084, 4.963058>, <-3.850709, -4.083084, 4.860025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.735188, -3.947423, 4.714224>, <-3.780096, -3.947423, 4.008497>, <-3.737214, -3.947423, 3.064196>, <-3.735694, -3.947423, 2.357043>, 
      <-3.695974, -3.669034, 4.664732>, <-3.740883, -3.669034, 3.959005>, <-3.697582, -3.666102, 3.039190>, <-3.696062, -3.666102, 2.332037>, 
      <-3.709042, -3.282681, 4.681225>, <-3.753501, -3.282681, 3.982555>, <-3.711049, -3.282681, 3.040625>, <-3.709544, -3.282681, 2.340544>, 
      <-3.697836, -2.997791, 4.667082>, <-3.742295, -2.997791, 3.968412>, <-3.699842, -2.997791, 3.033554>, <-3.698337, -2.997791, 2.333473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.850709, -4.083084, 4.860025>, <-3.897006, -4.083084, 4.132471>, <-3.852798, -4.083084, 3.158965>, <-3.851230, -4.083084, 2.429941>, 
      <-3.807815, -4.083084, 4.805888>, <-3.854112, -4.083084, 4.078334>, <-3.803950, -4.083084, 3.128144>, <-3.802382, -4.083084, 2.399121>, 
      <-3.744676, -4.014782, 4.726199>, <-3.789584, -4.014782, 4.020472>, <-3.745240, -4.004396, 3.069260>, <-3.743720, -4.004396, 2.362107>, 
      <-3.735188, -3.947423, 4.714224>, <-3.780096, -3.947423, 4.008497>, <-3.737214, -3.947423, 3.064196>, <-3.735694, -3.947423, 2.357043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.969803, -3.947423, 5.010335>, <-4.017532, -3.947423, 4.260280>, <-3.971956, -3.947423, 3.256665>, <-3.970340, -3.947423, 2.505094>, 
      <-3.967750, -4.017816, 5.007743>, <-4.015479, -4.017816, 4.257688>, <-3.970246, -4.006052, 3.255585>, <-3.968630, -4.006052, 2.504015>, 
      <-3.894473, -4.083084, 4.915260>, <-3.940770, -4.083084, 4.187706>, <-3.902412, -4.083084, 3.190269>, <-3.900844, -4.083084, 2.461245>, 
      <-3.850709, -4.083084, 4.860025>, <-3.897006, -4.083084, 4.132471>, <-3.852798, -4.083084, 3.158965>, <-3.851230, -4.083084, 2.429941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.735694, -3.947423, 2.357043>, <-3.734179, -3.947423, 1.652638>, <-3.725071, -3.947423, 0.713451>, <-3.725071, -3.947423, 0.009044>, 
      <-3.696062, -3.666102, 2.332037>, <-3.694547, -3.666102, 1.627632>, <-3.685409, -3.665086, 0.713355>, <-3.685409, -3.665086, 0.008948>, 
      <-3.709544, -3.282681, 2.340544>, <-3.708044, -3.282681, 1.643182>, <-3.698995, -3.282681, 0.706344>, <-3.698995, -3.282681, 0.008981>, 
      <-3.698337, -2.997791, 2.333473>, <-3.696837, -2.997791, 1.636111>, <-3.687820, -2.997791, 0.706316>, <-3.687820, -2.997791, 0.008953>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.851230, -4.083084, 2.429941>, <-3.849669, -4.083084, 1.703750>, <-3.840279, -4.083084, 0.735516>, <-3.840279, -4.083084, 0.009324>, 
      <-3.802382, -4.083084, 2.399121>, <-3.800821, -4.083084, 1.672930>, <-3.786885, -4.083084, 0.735387>, <-3.786885, -4.083084, 0.009194>, 
      <-3.743720, -4.004396, 2.362107>, <-3.742205, -4.004396, 1.657702>, <-3.732498, -4.000298, 0.713469>, <-3.732498, -4.000298, 0.009062>, 
      <-3.735694, -3.947423, 2.357043>, <-3.734179, -3.947423, 1.652638>, <-3.725071, -3.947423, 0.713451>, <-3.725071, -3.947423, 0.009044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.970340, -3.947423, 2.505094>, <-3.968730, -3.947423, 1.756443>, <-3.959050, -3.947423, 0.758264>, <-3.959050, -3.947423, 0.009612>, 
      <-3.968630, -4.006052, 2.504015>, <-3.967020, -4.006052, 1.755364>, <-3.957477, -4.001492, 0.758260>, <-3.957477, -4.001492, 0.009608>, 
      <-3.900844, -4.083084, 2.461245>, <-3.899283, -4.083084, 1.735054>, <-3.894371, -4.083084, 0.735648>, <-3.894371, -4.083084, 0.009455>, 
      <-3.851230, -4.083084, 2.429941>, <-3.849669, -4.083084, 1.703750>, <-3.840279, -4.083084, 0.735516>, <-3.840279, -4.083084, 0.009324>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.725071, -3.947423, 0.009044>, <-3.725071, -3.947423, -0.700789>, <-3.734173, -3.947422, -1.647211>, <-3.735694, -3.947422, -2.357043>, 
      <-3.685409, -3.665086, 0.008948>, <-3.685409, -3.665086, -0.700886>, <-3.694541, -3.666101, -1.622206>, <-3.696062, -3.666101, -2.332037>, 
      <-3.698995, -3.282681, 0.008981>, <-3.698995, -3.282681, -0.693755>, <-3.708038, -3.282680, -1.637810>, <-3.709544, -3.282680, -2.340544>, 
      <-3.687820, -2.997791, 0.008953>, <-3.687820, -2.997791, -0.693782>, <-3.696832, -2.997791, -1.630739>, <-3.698337, -2.997791, -2.333473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.840279, -4.083084, 0.009324>, <-3.840279, -4.083084, -0.722463>, <-3.849663, -4.083084, -1.698156>, <-3.851230, -4.083084, -2.429941>, 
      <-3.786885, -4.083084, 0.009194>, <-3.786885, -4.083084, -0.722593>, <-3.800815, -4.083084, -1.667336>, <-3.802382, -4.083084, -2.399121>, 
      <-3.732498, -4.000298, 0.009062>, <-3.732498, -4.000298, -0.700771>, <-3.742200, -4.004396, -1.652276>, <-3.743720, -4.004396, -2.362107>, 
      <-3.725071, -3.947423, 0.009044>, <-3.725071, -3.947423, -0.700789>, <-3.734173, -3.947422, -1.647211>, <-3.735694, -3.947422, -2.357043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.959050, -3.947423, 0.009612>, <-3.959050, -3.947423, -0.744807>, <-3.968724, -3.947422, -1.750676>, <-3.970340, -3.947422, -2.505094>, 
      <-3.957477, -4.001492, 0.009608>, <-3.957477, -4.001492, -0.744811>, <-3.967014, -4.006052, -1.749597>, <-3.968630, -4.006052, -2.504015>, 
      <-3.894371, -4.083084, 0.009455>, <-3.894371, -4.083084, -0.722332>, <-3.899277, -4.083084, -1.729460>, <-3.900844, -4.083084, -2.461245>, 
      <-3.840279, -4.083084, 0.009324>, <-3.840279, -4.083084, -0.722463>, <-3.849663, -4.083084, -1.698156>, <-3.851230, -4.083084, -2.429941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.735694, -3.947422, -2.357043>, <-3.737208, -3.947422, -3.064196>, <-3.780096, -3.947422, -4.008497>, <-3.735188, -3.947422, -4.714224>, 
      <-3.696062, -3.666101, -2.332037>, <-3.697576, -3.666101, -3.039190>, <-3.740883, -3.669034, -3.959005>, <-3.695974, -3.669034, -4.664732>, 
      <-3.709544, -3.282680, -2.340544>, <-3.711043, -3.282680, -3.040625>, <-3.753501, -3.282680, -3.982555>, <-3.709042, -3.282680, -4.681225>, 
      <-3.698337, -2.997791, -2.333473>, <-3.699836, -2.997791, -3.033554>, <-3.742295, -2.997791, -3.968412>, <-3.697836, -2.997791, -4.667082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.851230, -4.083084, -2.429941>, <-3.852792, -4.083084, -3.158965>, <-3.897006, -4.083084, -4.132471>, <-3.850709, -4.083084, -4.860025>, 
      <-3.802382, -4.083084, -2.399121>, <-3.803944, -4.083084, -3.128144>, <-3.854112, -4.083084, -4.078334>, <-3.807815, -4.083084, -4.805888>, 
      <-3.743720, -4.004396, -2.362107>, <-3.745234, -4.004396, -3.069260>, <-3.789584, -4.014782, -4.020472>, <-3.744676, -4.014782, -4.726199>, 
      <-3.735694, -3.947422, -2.357043>, <-3.737208, -3.947422, -3.064196>, <-3.780096, -3.947422, -4.008497>, <-3.735188, -3.947422, -4.714224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.970340, -3.947422, -2.505094>, <-3.971950, -3.947422, -3.256665>, <-4.017532, -3.947422, -4.260280>, <-3.969803, -3.947422, -5.010335>, 
      <-3.968630, -4.006052, -2.504015>, <-3.970240, -4.006052, -3.255585>, <-4.015479, -4.017816, -4.257688>, <-3.967750, -4.017816, -5.007743>, 
      <-3.900844, -4.083084, -2.461245>, <-3.902406, -4.083084, -3.190269>, <-3.940770, -4.083084, -4.187706>, <-3.894473, -4.083084, -4.915260>, 
      <-3.851230, -4.083084, -2.429941>, <-3.852792, -4.083084, -3.158965>, <-3.897006, -4.083084, -4.132471>, <-3.850709, -4.083084, -4.860025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.735188, -3.947422, -4.714224>, <-3.728828, -3.947422, -4.814166>, <-3.639740, -3.947422, -4.933583>, <-3.567336, -3.947422, -5.002766>, 
      <-3.695974, -3.669034, -4.664732>, <-3.689615, -3.669034, -4.764674>, <-3.602326, -3.669306, -4.881113>, <-3.529921, -3.669306, -4.950296>, 
      <-3.709042, -3.282680, -4.681225>, <-3.702746, -3.282680, -4.780167>, <-3.614045, -3.282680, -4.899255>, <-3.542364, -3.282680, -4.967747>, 
      <-3.697836, -2.997791, -4.667082>, <-3.691540, -2.997791, -4.766024>, <-3.603343, -2.997791, -4.884247>, <-3.531662, -2.997791, -4.952738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.850709, -4.083084, -4.860025>, <-3.844153, -4.083084, -4.963058>, <-3.752310, -4.083084, -5.086168>, <-3.677666, -4.083084, -5.157491>, 
      <-3.807815, -4.083084, -4.805888>, <-3.801259, -4.083084, -4.908921>, <-3.711642, -4.083084, -5.029136>, <-3.636998, -4.083084, -5.100459>, 
      <-3.744676, -4.014782, -4.726199>, <-3.738316, -4.014782, -4.826141>, <-3.648920, -4.015661, -4.946457>, <-3.576516, -4.015661, -5.015640>, 
      <-3.735188, -3.947422, -4.714224>, <-3.728828, -3.947422, -4.814166>, <-3.639740, -3.947422, -4.933583>, <-3.567336, -3.947422, -5.002766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.969803, -3.947422, -5.010335>, <-3.963044, -3.947422, -5.116554>, <-3.868360, -3.947422, -5.243472>, <-3.791408, -3.947422, -5.317000>, 
      <-3.967750, -4.017816, -5.007743>, <-3.960990, -4.017816, -5.113962>, <-3.866371, -4.018829, -5.240682>, <-3.789418, -4.018829, -5.314211>, 
      <-3.894473, -4.083084, -4.915260>, <-3.887917, -4.083084, -5.018293>, <-3.793815, -4.083084, -5.144374>, <-3.719170, -4.083084, -5.215697>, 
      <-3.850709, -4.083084, -4.860025>, <-3.844153, -4.083084, -4.963058>, <-3.752310, -4.083084, -5.086168>, <-3.677666, -4.083084, -5.157491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.567336, -3.947422, -5.002766>, <-3.490947, -3.947422, -5.075756>, <-3.363202, -3.947422, -5.165517>, <-3.257667, -3.947422, -5.170500>, 
      <-3.529921, -3.669306, -4.950296>, <-3.453532, -3.669306, -5.023286>, <-3.329027, -3.669236, -5.111275>, <-3.223491, -3.669236, -5.116258>, 
      <-3.542364, -3.282680, -4.967747>, <-3.466740, -3.282680, -5.040007>, <-3.339344, -3.282680, -5.129374>, <-3.234863, -3.282680, -5.134307>, 
      <-3.531662, -2.997791, -4.952738>, <-3.456038, -2.997791, -5.024998>, <-3.329571, -2.997791, -5.113862>, <-3.225090, -2.997791, -5.118795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.677666, -4.083084, -5.157491>, <-3.598915, -4.083084, -5.232738>, <-3.467219, -4.083084, -5.325276>, <-3.358419, -4.083084, -5.330412>, 
      <-3.636998, -4.083084, -5.100459>, <-3.558247, -4.083084, -5.175706>, <-3.430013, -4.083084, -5.266224>, <-3.321213, -4.083084, -5.271360>, 
      <-3.576516, -4.015661, -5.015640>, <-3.500127, -4.015661, -5.088630>, <-3.371558, -4.015435, -5.178779>, <-3.266022, -4.015435, -5.183762>, 
      <-3.567336, -3.947422, -5.002766>, <-3.490947, -3.947422, -5.075756>, <-3.363202, -3.947422, -5.165517>, <-3.257667, -3.947422, -5.170500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.791408, -3.947422, -5.317000>, <-3.710221, -3.947422, -5.394575>, <-3.574452, -3.947422, -5.489974>, <-3.462288, -3.947422, -5.495270>, 
      <-3.789418, -4.018829, -5.314211>, <-3.708232, -4.018829, -5.391785>, <-3.572642, -4.018569, -5.487102>, <-3.460478, -4.018569, -5.492398>, 
      <-3.719170, -4.083084, -5.215697>, <-3.640420, -4.083084, -5.290944>, <-3.505188, -4.083084, -5.385539>, <-3.396388, -4.083084, -5.390676>, 
      <-3.677666, -4.083084, -5.157491>, <-3.598915, -4.083084, -5.232738>, <-3.467219, -4.083084, -5.325276>, <-3.358419, -4.083084, -5.330412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.257667, -3.947422, -5.170500>, <-2.281606, -3.947422, -5.216585>, <-0.977654, -3.947422, -5.171175>, <-0.000506, -3.947422, -5.171175>, 
      <-3.223491, -3.669236, -5.116258>, <-2.247430, -3.669236, -5.162342>, <-0.977649, -3.667386, -5.116565>, <-0.000500, -3.667386, -5.116565>, 
      <-3.234863, -3.282680, -5.134307>, <-2.268563, -3.282680, -5.179931>, <-0.967879, -3.282680, -5.134977>, <-0.000502, -3.282680, -5.134977>, 
      <-3.225090, -2.997791, -5.118795>, <-2.258790, -2.997791, -5.164420>, <-0.967878, -2.997791, -5.119464>, <-0.000501, -2.997791, -5.119464>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.358419, -4.083084, -5.330412>, <-2.352171, -4.083084, -5.377922>, <-1.007891, -4.083084, -5.331108>, <-0.000522, -4.083084, -5.331108>, 
      <-3.321213, -4.083084, -5.271360>, <-2.314965, -4.083084, -5.318870>, <-1.007885, -4.083084, -5.268192>, <-0.000515, -4.083084, -5.268192>, 
      <-3.266022, -4.015435, -5.183762>, <-2.289961, -4.015435, -5.229846>, <-0.977655, -4.009175, -5.183218>, <-0.000507, -4.009175, -5.183218>, 
      <-3.257667, -3.947422, -5.170500>, <-2.281606, -3.947422, -5.216585>, <-0.977654, -3.947422, -5.171175>, <-0.000506, -3.947422, -5.171175>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.462288, -3.947422, -5.495270>, <-2.424918, -3.947422, -5.544250>, <-1.039063, -3.947422, -5.495988>, <-0.000538, -3.947422, -5.495988>, 
      <-3.460478, -4.018569, -5.492398>, <-2.423108, -4.018569, -5.541378>, <-1.039062, -4.011426, -5.493403>, <-0.000537, -4.011426, -5.493403>, 
      <-3.396388, -4.083084, -5.390676>, <-2.390140, -4.083084, -5.438186>, <-1.007897, -4.083084, -5.395163>, <-0.000528, -4.083084, -5.395163>, 
      <-3.358419, -4.083084, -5.330412>, <-2.352171, -4.083084, -5.377922>, <-1.007891, -4.083084, -5.331108>, <-0.000522, -4.083084, -5.331108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000506, -3.947422, -5.171175>, <0.976946, -3.947422, -5.171175>, <2.281302, -3.947422, -5.216586>, <3.257667, -3.947422, -5.170500>, 
      <-0.000500, -3.667386, -5.116565>, <0.976951, -3.667386, -5.116565>, <2.247126, -3.669236, -5.162344>, <3.223491, -3.669236, -5.116258>, 
      <-0.000502, -3.282680, -5.134977>, <0.967175, -3.282680, -5.134977>, <2.268262, -3.282680, -5.179932>, <3.234863, -3.282680, -5.134307>, 
      <-0.000501, -2.997791, -5.119464>, <0.967176, -2.997791, -5.119464>, <2.258489, -2.997791, -5.164421>, <3.225090, -2.997791, -5.118795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000522, -4.083084, -5.331108>, <1.007161, -4.083084, -5.331108>, <2.351857, -4.083084, -5.377924>, <3.358419, -4.083084, -5.330412>, 
      <-0.000515, -4.083084, -5.268192>, <1.007167, -4.083084, -5.268192>, <2.314652, -4.083084, -5.318872>, <3.321213, -4.083084, -5.271360>, 
      <-0.000507, -4.009175, -5.183218>, <0.976945, -4.009175, -5.183218>, <2.289657, -4.015435, -5.229848>, <3.266022, -4.015435, -5.183762>, 
      <-0.000506, -3.947422, -5.171175>, <0.976946, -3.947422, -5.171175>, <2.281302, -3.947422, -5.216586>, <3.257667, -3.947422, -5.170500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000538, -3.947422, -5.495988>, <1.038310, -3.947422, -5.495988>, <2.424595, -3.947422, -5.544252>, <3.462288, -3.947422, -5.495270>, 
      <-0.000537, -4.011426, -5.493403>, <1.038310, -4.011426, -5.493403>, <2.422786, -4.018569, -5.541379>, <3.460478, -4.018569, -5.492398>, 
      <-0.000528, -4.083084, -5.395163>, <1.007154, -4.083084, -5.395163>, <2.389827, -4.083084, -5.438188>, <3.396388, -4.083084, -5.390676>, 
      <-0.000522, -4.083084, -5.331108>, <1.007161, -4.083084, -5.331108>, <2.351857, -4.083084, -5.377924>, <3.358419, -4.083084, -5.330412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.462288, -3.947422, -5.495270>, <3.492378, -2.764542, -5.543030>, <3.493410, -1.182787, -5.544667>, <3.462288, 0.000000, -5.495270>, 
      <2.424595, -3.947422, -5.544252>, <2.454686, -2.764542, -5.592011>, <2.455718, -1.182787, -5.593648>, <2.424595, 0.000000, -5.544252>, 
      <1.038310, -3.947422, -5.495988>, <1.038305, -2.764160, -5.543769>, <1.038305, -1.183195, -5.545408>, <1.038310, 0.000000, -5.495988>, 
      <-0.000538, -3.947422, -5.495988>, <-0.000542, -2.764160, -5.543769>, <-0.000543, -1.183195, -5.545408>, <-0.000538, 0.000000, -5.495988>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.791408, -3.947422, -5.317000>, <3.824358, -2.764556, -5.363210>, <3.825488, -1.182771, -5.364794>, <3.791408, 0.000000, -5.317000>, 
      <3.710221, -3.947422, -5.394575>, <3.743172, -2.764556, -5.440784>, <3.744302, -1.182771, -5.442368>, <3.710221, 0.000000, -5.394575>, 
      <3.574452, -3.947422, -5.489976>, <3.604544, -2.764542, -5.537736>, <3.605575, -1.182787, -5.539373>, <3.574452, 0.000000, -5.489976>, 
      <3.462288, -3.947422, -5.495270>, <3.492378, -2.764542, -5.543030>, <3.493410, -1.182787, -5.544667>, <3.462288, 0.000000, -5.495270>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.969803, -3.947422, -5.010335>, <4.004306, -2.764500, -5.053882>, <4.005489, -1.182832, -5.055375>, <3.969803, 0.000000, -5.010335>, 
      <3.963044, -3.947422, -5.116554>, <3.997547, -2.764500, -5.160100>, <3.998730, -1.182832, -5.161594>, <3.963044, 0.000000, -5.116554>, 
      <3.868360, -3.947422, -5.243472>, <3.901311, -2.764556, -5.289682>, <3.902441, -1.182771, -5.291266>, <3.868360, 0.000000, -5.243472>, 
      <3.791408, -3.947422, -5.317000>, <3.824358, -2.764556, -5.363210>, <3.825488, -1.182771, -5.364794>, <3.791408, 0.000000, -5.317000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.970340, -3.947422, -2.505094>, <4.004866, -2.763900, -2.526878>, <4.006050, -1.183474, -2.527625>, <3.970340, 0.000000, -2.505094>, 
      <3.971950, -3.947422, -3.256665>, <4.006476, -2.763900, -3.278448>, <4.007660, -1.183474, -3.279196>, <3.971950, 0.000000, -3.256665>, 
      <4.017532, -3.947422, -4.260280>, <4.052035, -2.764500, -4.303826>, <4.053218, -1.182832, -4.305320>, <4.017532, 0.000000, -4.260280>, 
      <3.969803, -3.947422, -5.010335>, <4.004306, -2.764500, -5.053882>, <4.005489, -1.182832, -5.055375>, <3.969803, 0.000000, -5.010335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.959050, -3.947423, 0.009612>, <3.993483, -2.763697, 0.009696>, <3.994665, -1.183691, 0.009699>, <3.959050, 0.000000, 0.009612>, 
      <3.959050, -3.947423, -0.744807>, <3.993483, -2.763697, -0.744724>, <3.994665, -1.183691, -0.744721>, <3.959050, 0.000000, -0.744807>, 
      <3.968724, -3.947422, -1.750676>, <4.003250, -2.763900, -1.772460>, <4.004434, -1.183474, -1.773208>, <3.968724, 0.000000, -1.750676>, 
      <3.970340, -3.947422, -2.505094>, <4.004866, -2.763900, -2.526878>, <4.006050, -1.183474, -2.527625>, <3.970340, 0.000000, -2.505094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.970340, -3.947423, 2.505094>, <4.004866, -2.763900, 2.526878>, <4.006050, -1.183474, 2.527625>, <3.970340, 0.000000, 2.505094>, 
      <3.968730, -3.947423, 1.756443>, <4.003256, -2.763900, 1.778227>, <4.004441, -1.183474, 1.778975>, <3.968730, 0.000000, 1.756443>, 
      <3.959050, -3.947423, 0.758264>, <3.993483, -2.763697, 0.758348>, <3.994665, -1.183691, 0.758351>, <3.959050, 0.000000, 0.758264>, 
      <3.959050, -3.947423, 0.009612>, <3.993483, -2.763697, 0.009696>, <3.994665, -1.183691, 0.009699>, <3.959050, 0.000000, 0.009612>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.969803, -3.947423, 5.010335>, <4.004306, -2.764500, 5.053882>, <4.005489, -1.182832, 5.055375>, <3.969803, 0.000000, 5.010335>, 
      <4.017532, -3.947423, 4.260280>, <4.052035, -2.764500, 4.303826>, <4.053218, -1.182832, 4.305320>, <4.017532, 0.000000, 4.260280>, 
      <3.971956, -3.947423, 3.256665>, <4.006482, -2.763900, 3.278448>, <4.007666, -1.183474, 3.279196>, <3.971956, 0.000000, 3.256665>, 
      <3.970340, -3.947423, 2.505094>, <4.004866, -2.763900, 2.526878>, <4.006050, -1.183474, 2.527625>, <3.970340, 0.000000, 2.505094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.791408, -3.947423, 5.317000>, <3.824358, -2.764557, 5.363210>, <3.825488, -1.182771, 5.364794>, <3.791408, 0.000000, 5.317000>, 
      <3.868360, -3.947423, 5.243472>, <3.901311, -2.764557, 5.289682>, <3.902441, -1.182771, 5.291266>, <3.868360, 0.000000, 5.243472>, 
      <3.963044, -3.947423, 5.116554>, <3.997547, -2.764500, 5.160100>, <3.998730, -1.182832, 5.161594>, <3.963044, 0.000000, 5.116554>, 
      <3.969803, -3.947423, 5.010335>, <4.004306, -2.764500, 5.053882>, <4.005489, -1.182832, 5.055375>, <3.969803, 0.000000, 5.010335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.462288, -3.947423, 5.495270>, <3.492378, -2.764542, 5.543030>, <3.493410, -1.182787, 5.544667>, <3.462288, 0.000000, 5.495270>, 
      <3.574452, -3.947423, 5.489976>, <3.604544, -2.764542, 5.537736>, <3.605575, -1.182787, 5.539373>, <3.574452, 0.000000, 5.489976>, 
      <3.710221, -3.947423, 5.394575>, <3.743172, -2.764557, 5.440784>, <3.744302, -1.182771, 5.442368>, <3.710221, 0.000000, 5.394575>, 
      <3.791408, -3.947423, 5.317000>, <3.824358, -2.764557, 5.363210>, <3.825488, -1.182771, 5.364794>, <3.791408, 0.000000, 5.317000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000538, -3.947423, 5.495988>, <-0.000542, -2.764160, 5.543769>, <-0.000543, -1.183195, 5.545408>, <-0.000538, 0.000000, 5.495988>, 
      <1.038310, -3.947423, 5.495988>, <1.038305, -2.764160, 5.543769>, <1.038305, -1.183195, 5.545408>, <1.038310, 0.000000, 5.495988>, 
      <2.424595, -3.947423, 5.544252>, <2.454686, -2.764542, 5.592012>, <2.455718, -1.182787, 5.593648>, <2.424595, 0.000000, 5.544252>, 
      <3.462288, -3.947423, 5.495270>, <3.492378, -2.764542, 5.543030>, <3.493410, -1.182787, 5.544667>, <3.462288, 0.000000, 5.495270>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.462288, -3.947423, 5.495270>, <-3.492378, -2.764542, 5.543030>, <-3.493410, -1.182787, 5.544667>, <-3.462288, 0.000000, 5.495270>, 
      <-2.424918, -3.947423, 5.544250>, <-2.455009, -2.764542, 5.592010>, <-2.456041, -1.182787, 5.593647>, <-2.424918, 0.000000, 5.544250>, 
      <-1.039063, -3.947423, 5.495988>, <-1.039067, -2.764160, 5.543769>, <-1.039068, -1.183195, 5.545408>, <-1.039063, 0.000000, 5.495988>, 
      <-0.000538, -3.947423, 5.495988>, <-0.000542, -2.764160, 5.543769>, <-0.000543, -1.183195, 5.545408>, <-0.000538, 0.000000, 5.495988>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.791408, -3.947423, 5.317000>, <-3.824358, -2.764557, 5.363210>, <-3.825488, -1.182771, 5.364794>, <-3.791408, 0.000000, 5.317000>, 
      <-3.710221, -3.947423, 5.394575>, <-3.743172, -2.764557, 5.440784>, <-3.744302, -1.182771, 5.442368>, <-3.710221, 0.000000, 5.394575>, 
      <-3.574452, -3.947423, 5.489974>, <-3.604544, -2.764542, 5.537734>, <-3.605575, -1.182787, 5.539372>, <-3.574452, 0.000000, 5.489974>, 
      <-3.462288, -3.947423, 5.495270>, <-3.492378, -2.764542, 5.543030>, <-3.493410, -1.182787, 5.544667>, <-3.462288, 0.000000, 5.495270>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.969803, -3.947423, 5.010335>, <-4.004306, -2.764500, 5.053882>, <-4.005489, -1.182832, 5.055375>, <-3.969803, 0.000000, 5.010335>, 
      <-3.963044, -3.947423, 5.116554>, <-3.997547, -2.764500, 5.160100>, <-3.998730, -1.182832, 5.161594>, <-3.963044, 0.000000, 5.116554>, 
      <-3.868360, -3.947423, 5.243472>, <-3.901311, -2.764557, 5.289682>, <-3.902441, -1.182771, 5.291266>, <-3.868360, 0.000000, 5.243472>, 
      <-3.791408, -3.947423, 5.317000>, <-3.824358, -2.764557, 5.363210>, <-3.825488, -1.182771, 5.364794>, <-3.791408, 0.000000, 5.317000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.970340, -3.947423, 2.505094>, <-4.004866, -2.763900, 2.526878>, <-4.006050, -1.183474, 2.527625>, <-3.970340, 0.000000, 2.505094>, 
      <-3.971956, -3.947423, 3.256665>, <-4.006482, -2.763900, 3.278448>, <-4.007666, -1.183474, 3.279196>, <-3.971956, 0.000000, 3.256665>, 
      <-4.017532, -3.947423, 4.260280>, <-4.052035, -2.764500, 4.303826>, <-4.053218, -1.182832, 4.305320>, <-4.017532, 0.000000, 4.260280>, 
      <-3.969803, -3.947423, 5.010335>, <-4.004306, -2.764500, 5.053882>, <-4.005489, -1.182832, 5.055375>, <-3.969803, 0.000000, 5.010335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.959050, -3.947423, 0.009612>, <-3.993483, -2.763697, 0.009696>, <-3.994665, -1.183691, 0.009699>, <-3.959050, 0.000000, 0.009612>, 
      <-3.959050, -3.947423, 0.758264>, <-3.993483, -2.763697, 0.758348>, <-3.994665, -1.183691, 0.758351>, <-3.959050, 0.000000, 0.758264>, 
      <-3.968730, -3.947423, 1.756443>, <-4.003256, -2.763900, 1.778227>, <-4.004441, -1.183474, 1.778975>, <-3.968730, 0.000000, 1.756443>, 
      <-3.970340, -3.947423, 2.505094>, <-4.004866, -2.763900, 2.526878>, <-4.006050, -1.183474, 2.527625>, <-3.970340, 0.000000, 2.505094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.970340, -3.947422, -2.505094>, <-4.004866, -2.763900, -2.526878>, <-4.006050, -1.183474, -2.527625>, <-3.970340, 0.000000, -2.505094>, 
      <-3.968724, -3.947422, -1.750676>, <-4.003250, -2.763900, -1.772460>, <-4.004434, -1.183474, -1.773208>, <-3.968724, 0.000000, -1.750676>, 
      <-3.959050, -3.947423, -0.744807>, <-3.993483, -2.763697, -0.744724>, <-3.994665, -1.183691, -0.744721>, <-3.959050, 0.000000, -0.744807>, 
      <-3.959050, -3.947423, 0.009612>, <-3.993483, -2.763697, 0.009696>, <-3.994665, -1.183691, 0.009699>, <-3.959050, 0.000000, 0.009612>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.969803, -3.947422, -5.010335>, <-4.004306, -2.764500, -5.053882>, <-4.005489, -1.182832, -5.055375>, <-3.969803, 0.000000, -5.010335>, 
      <-4.017532, -3.947422, -4.260280>, <-4.052035, -2.764500, -4.303826>, <-4.053218, -1.182832, -4.305320>, <-4.017532, 0.000000, -4.260280>, 
      <-3.971950, -3.947422, -3.256665>, <-4.006476, -2.763900, -3.278448>, <-4.007660, -1.183474, -3.279196>, <-3.971950, 0.000000, -3.256665>, 
      <-3.970340, -3.947422, -2.505094>, <-4.004866, -2.763900, -2.526878>, <-4.006050, -1.183474, -2.527625>, <-3.970340, 0.000000, -2.505094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.791408, -3.947422, -5.317000>, <-3.824358, -2.764556, -5.363210>, <-3.825488, -1.182771, -5.364794>, <-3.791408, 0.000000, -5.317000>, 
      <-3.868360, -3.947422, -5.243472>, <-3.901311, -2.764556, -5.289682>, <-3.902441, -1.182771, -5.291266>, <-3.868360, 0.000000, -5.243472>, 
      <-3.963044, -3.947422, -5.116554>, <-3.997547, -2.764500, -5.160100>, <-3.998730, -1.182832, -5.161594>, <-3.963044, 0.000000, -5.116554>, 
      <-3.969803, -3.947422, -5.010335>, <-4.004306, -2.764500, -5.053882>, <-4.005489, -1.182832, -5.055375>, <-3.969803, 0.000000, -5.010335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.462288, -3.947422, -5.495270>, <-3.492378, -2.764542, -5.543030>, <-3.493410, -1.182787, -5.544667>, <-3.462288, 0.000000, -5.495270>, 
      <-3.574452, -3.947422, -5.489974>, <-3.604544, -2.764542, -5.537734>, <-3.605575, -1.182787, -5.539372>, <-3.574452, 0.000000, -5.489974>, 
      <-3.710221, -3.947422, -5.394575>, <-3.743172, -2.764556, -5.440784>, <-3.744302, -1.182771, -5.442368>, <-3.710221, 0.000000, -5.394575>, 
      <-3.791408, -3.947422, -5.317000>, <-3.824358, -2.764556, -5.363210>, <-3.825488, -1.182771, -5.364794>, <-3.791408, 0.000000, -5.317000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000538, -3.947422, -5.495988>, <-0.000542, -2.764160, -5.543769>, <-0.000543, -1.183195, -5.545408>, <-0.000538, 0.000000, -5.495988>, 
      <-1.039063, -3.947422, -5.495988>, <-1.039067, -2.764160, -5.543769>, <-1.039068, -1.183195, -5.545408>, <-1.039063, 0.000000, -5.495988>, 
      <-2.424918, -3.947422, -5.544250>, <-2.455009, -2.764542, -5.592010>, <-2.456041, -1.182787, -5.593647>, <-2.424918, 0.000000, -5.544250>, 
      <-3.462288, -3.947422, -5.495270>, <-3.492378, -2.764542, -5.543030>, <-3.493410, -1.182787, -5.544667>, <-3.462288, 0.000000, -5.495270>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.462288, 0.000000, -5.495270>, <3.460751, 0.058384, -5.492832>, <3.389580, 0.000000, -5.379870>, <3.358419, 0.000000, -5.330412>, 
      <2.424595, 0.000000, -5.544252>, <2.423059, 0.058384, -5.541813>, <2.383018, 0.000000, -5.427382>, <2.351857, 0.000000, -5.377924>, 
      <1.038310, 0.000000, -5.495988>, <1.038310, 0.049421, -5.493923>, <1.007156, 0.000000, -5.380572>, <1.007161, 0.000000, -5.331108>, 
      <-0.000538, 0.000000, -5.495988>, <-0.000537, 0.049421, -5.493923>, <-0.000526, 0.000000, -5.380572>, <-0.000522, 0.000000, -5.331108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.791408, 0.000000, -5.317000>, <3.789716, 0.058701, -5.314629>, <3.711788, 0.000000, -5.205344>, <3.677666, 0.000000, -5.157491>, 
      <3.710221, 0.000000, -5.394575>, <3.708530, 0.058701, -5.392203>, <3.633037, 0.000000, -5.280591>, <3.598915, 0.000000, -5.232738>, 
      <3.574452, 0.000000, -5.489976>, <3.572916, 0.058384, -5.487537>, <3.498380, 0.000000, -5.374734>, <3.467219, 0.000000, -5.325277>, 
      <3.462288, 0.000000, -5.495270>, <3.460751, 0.058384, -5.492832>, <3.389580, 0.000000, -5.379870>, <3.358419, 0.000000, -5.330412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.969803, 0.000000, -5.010335>, <3.968069, 0.057464, -5.008147>, <3.886437, 0.000000, -4.905118>, <3.850709, 0.000000, -4.860025>, 
      <3.963044, 0.000000, -5.116554>, <3.961310, 0.057464, -5.114366>, <3.879881, 0.000000, -5.008150>, <3.844153, 0.000000, -4.963058>, 
      <3.868360, 0.000000, -5.243472>, <3.866669, 0.058701, -5.241100>, <3.786432, 0.000000, -5.134021>, <3.752310, 0.000000, -5.086168>, 
      <3.791408, 0.000000, -5.317000>, <3.789716, 0.058701, -5.314629>, <3.711788, 0.000000, -5.205344>, <3.677666, 0.000000, -5.157491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.970340, 0.000000, -2.505094>, <3.969066, 0.042224, -2.504290>, <3.886963, 0.000000, -2.452487>, <3.851230, 0.000000, -2.429941>, 
      <3.971950, 0.000000, -3.256665>, <3.970676, 0.042224, -3.255861>, <3.888525, 0.000000, -3.181510>, <3.852792, 0.000000, -3.158965>, 
      <4.017532, 0.000000, -4.260280>, <4.015798, 0.057464, -4.258092>, <3.932734, 0.000000, -4.177564>, <3.897006, 0.000000, -4.132471>, 
      <3.969803, 0.000000, -5.010335>, <3.968069, 0.057464, -5.008147>, <3.886437, 0.000000, -4.905118>, <3.850709, 0.000000, -4.860025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.959050, 0.000000, 0.009612>, <3.957978, 0.035615, 0.009609>, <3.875910, 0.000000, 0.009410>, <3.840279, 0.000000, 0.009324>, 
      <3.959050, 0.000000, -0.744807>, <3.957978, 0.035615, -0.744810>, <3.875910, 0.000000, -0.722377>, <3.840279, 0.000000, -0.722463>, 
      <3.968724, 0.000000, -1.750676>, <3.967450, 0.042224, -1.749872>, <3.885396, 0.000000, -1.720702>, <3.849663, 0.000000, -1.698156>, 
      <3.970340, 0.000000, -2.505094>, <3.969066, 0.042224, -2.504290>, <3.886963, 0.000000, -2.452487>, <3.851230, 0.000000, -2.429941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.970340, 0.000000, 2.505094>, <3.969066, 0.042224, 2.504290>, <3.886963, 0.000000, 2.452487>, <3.851230, 0.000000, 2.429941>, 
      <3.968730, 0.000000, 1.756443>, <3.967456, 0.042224, 1.755639>, <3.885402, 0.000000, 1.726296>, <3.849669, 0.000000, 1.703750>, 
      <3.959050, 0.000000, 0.758264>, <3.957978, 0.035615, 0.758262>, <3.875910, 0.000000, 0.735603>, <3.840279, 0.000000, 0.735516>, 
      <3.959050, 0.000000, 0.009612>, <3.957978, 0.035615, 0.009609>, <3.875910, 0.000000, 0.009410>, <3.840279, 0.000000, 0.009324>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.969803, 0.000000, 5.010335>, <3.968069, 0.057464, 5.008147>, <3.886437, 0.000000, 4.905118>, <3.850709, 0.000000, 4.860025>, 
      <4.017532, 0.000000, 4.260280>, <4.015798, 0.057464, 4.258092>, <3.932734, 0.000000, 4.177564>, <3.897006, 0.000000, 4.132471>, 
      <3.971956, 0.000000, 3.256665>, <3.970682, 0.042224, 3.255861>, <3.888531, 0.000000, 3.181510>, <3.852798, 0.000000, 3.158965>, 
      <3.970340, 0.000000, 2.505094>, <3.969066, 0.042224, 2.504290>, <3.886963, 0.000000, 2.452487>, <3.851230, 0.000000, 2.429941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.791408, 0.000000, 5.317000>, <3.789716, 0.058701, 5.314629>, <3.711788, 0.000000, 5.205344>, <3.677666, 0.000000, 5.157491>, 
      <3.868360, 0.000000, 5.243472>, <3.866669, 0.058701, 5.241100>, <3.786432, 0.000000, 5.134021>, <3.752310, 0.000000, 5.086168>, 
      <3.963044, 0.000000, 5.116554>, <3.961310, 0.057464, 5.114366>, <3.879881, 0.000000, 5.008150>, <3.844153, 0.000000, 4.963058>, 
      <3.969803, 0.000000, 5.010335>, <3.968069, 0.057464, 5.008147>, <3.886437, 0.000000, 4.905118>, <3.850709, 0.000000, 4.860025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.462288, 0.000000, 5.495270>, <3.460751, 0.058384, 5.492832>, <3.389580, 0.000000, 5.379870>, <3.358419, 0.000000, 5.330412>, 
      <3.574452, 0.000000, 5.489976>, <3.572916, 0.058384, 5.487537>, <3.498380, 0.000000, 5.374734>, <3.467219, 0.000000, 5.325277>, 
      <3.710221, 0.000000, 5.394575>, <3.708530, 0.058701, 5.392203>, <3.633037, 0.000000, 5.280591>, <3.598915, 0.000000, 5.232738>, 
      <3.791408, 0.000000, 5.317000>, <3.789716, 0.058701, 5.314629>, <3.711788, 0.000000, 5.205344>, <3.677666, 0.000000, 5.157491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000538, 0.000000, 5.495988>, <-0.000537, 0.049421, 5.493923>, <-0.000526, 0.000000, 5.380572>, <-0.000522, 0.000000, 5.331108>, 
      <1.038310, 0.000000, 5.495988>, <1.038310, 0.049421, 5.493923>, <1.007156, 0.000000, 5.380572>, <1.007161, 0.000000, 5.331108>, 
      <2.424595, 0.000000, 5.544252>, <2.423059, 0.058384, 5.541813>, <2.383018, 0.000000, 5.427382>, <2.351857, 0.000000, 5.377924>, 
      <3.462288, 0.000000, 5.495270>, <3.460751, 0.058384, 5.492832>, <3.389580, 0.000000, 5.379870>, <3.358419, 0.000000, 5.330412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.462288, 0.000000, 5.495270>, <-3.460751, 0.058384, 5.492832>, <-3.389580, 0.000000, 5.379870>, <-3.358419, 0.000000, 5.330412>, 
      <-2.424918, 0.000000, 5.544250>, <-2.423382, 0.058384, 5.541812>, <-2.383331, 0.000000, 5.427380>, <-2.352171, 0.000000, 5.377922>, 
      <-1.039063, 0.000000, 5.495988>, <-1.039062, 0.049421, 5.493923>, <-1.007896, 0.000000, 5.380572>, <-1.007891, 0.000000, 5.331108>, 
      <-0.000538, 0.000000, 5.495988>, <-0.000537, 0.049421, 5.493923>, <-0.000526, 0.000000, 5.380572>, <-0.000522, 0.000000, 5.331108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.791408, 0.000000, 5.317000>, <-3.789716, 0.058701, 5.314629>, <-3.711788, 0.000000, 5.205344>, <-3.677666, 0.000000, 5.157491>, 
      <-3.710221, 0.000000, 5.394575>, <-3.708530, 0.058701, 5.392203>, <-3.633037, 0.000000, 5.280591>, <-3.598915, 0.000000, 5.232738>, 
      <-3.574452, 0.000000, 5.489974>, <-3.572916, 0.058384, 5.487536>, <-3.498380, 0.000000, 5.374733>, <-3.467219, 0.000000, 5.325276>, 
      <-3.462288, 0.000000, 5.495270>, <-3.460751, 0.058384, 5.492832>, <-3.389580, 0.000000, 5.379870>, <-3.358419, 0.000000, 5.330412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.969803, 0.000000, 5.010335>, <-3.968069, 0.057464, 5.008147>, <-3.886437, 0.000000, 4.905118>, <-3.850709, 0.000000, 4.860025>, 
      <-3.963044, 0.000000, 5.116554>, <-3.961310, 0.057464, 5.114366>, <-3.879881, 0.000000, 5.008150>, <-3.844153, 0.000000, 4.963058>, 
      <-3.868360, 0.000000, 5.243472>, <-3.866669, 0.058701, 5.241100>, <-3.786432, 0.000000, 5.134021>, <-3.752310, 0.000000, 5.086168>, 
      <-3.791408, 0.000000, 5.317000>, <-3.789716, 0.058701, 5.314629>, <-3.711788, 0.000000, 5.205344>, <-3.677666, 0.000000, 5.157491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.970340, 0.000000, 2.505094>, <-3.969066, 0.042224, 2.504290>, <-3.886963, 0.000000, 2.452487>, <-3.851230, 0.000000, 2.429941>, 
      <-3.971956, 0.000000, 3.256665>, <-3.970682, 0.042224, 3.255861>, <-3.888531, 0.000000, 3.181510>, <-3.852798, 0.000000, 3.158965>, 
      <-4.017532, 0.000000, 4.260280>, <-4.015798, 0.057464, 4.258092>, <-3.932734, 0.000000, 4.177564>, <-3.897006, 0.000000, 4.132471>, 
      <-3.969803, 0.000000, 5.010335>, <-3.968069, 0.057464, 5.008147>, <-3.886437, 0.000000, 4.905118>, <-3.850709, 0.000000, 4.860025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.959050, 0.000000, 0.009612>, <-3.957978, 0.035615, 0.009609>, <-3.875910, 0.000000, 0.009410>, <-3.840279, 0.000000, 0.009324>, 
      <-3.959050, 0.000000, 0.758264>, <-3.957978, 0.035615, 0.758262>, <-3.875910, 0.000000, 0.735603>, <-3.840279, 0.000000, 0.735516>, 
      <-3.968730, 0.000000, 1.756443>, <-3.967456, 0.042224, 1.755639>, <-3.885402, 0.000000, 1.726296>, <-3.849669, 0.000000, 1.703750>, 
      <-3.970340, 0.000000, 2.505094>, <-3.969066, 0.042224, 2.504290>, <-3.886963, 0.000000, 2.452487>, <-3.851230, 0.000000, 2.429941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.970340, 0.000000, -2.505094>, <-3.969066, 0.042224, -2.504290>, <-3.886963, 0.000000, -2.452487>, <-3.851230, 0.000000, -2.429941>, 
      <-3.968724, 0.000000, -1.750676>, <-3.967450, 0.042224, -1.749872>, <-3.885396, 0.000000, -1.720702>, <-3.849663, 0.000000, -1.698156>, 
      <-3.959050, 0.000000, -0.744807>, <-3.957978, 0.035615, -0.744810>, <-3.875910, 0.000000, -0.722377>, <-3.840279, 0.000000, -0.722463>, 
      <-3.959050, 0.000000, 0.009612>, <-3.957978, 0.035615, 0.009609>, <-3.875910, 0.000000, 0.009410>, <-3.840279, 0.000000, 0.009324>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.969803, 0.000000, -5.010335>, <-3.968069, 0.057464, -5.008147>, <-3.886437, 0.000000, -4.905118>, <-3.850709, 0.000000, -4.860025>, 
      <-4.017532, 0.000000, -4.260280>, <-4.015798, 0.057464, -4.258092>, <-3.932734, 0.000000, -4.177564>, <-3.897006, 0.000000, -4.132471>, 
      <-3.971950, 0.000000, -3.256665>, <-3.970676, 0.042224, -3.255861>, <-3.888525, 0.000000, -3.181510>, <-3.852792, 0.000000, -3.158965>, 
      <-3.970340, 0.000000, -2.505094>, <-3.969066, 0.042224, -2.504290>, <-3.886963, 0.000000, -2.452487>, <-3.851230, 0.000000, -2.429941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.791408, 0.000000, -5.317000>, <-3.789716, 0.058701, -5.314629>, <-3.711788, 0.000000, -5.205344>, <-3.677666, 0.000000, -5.157491>, 
      <-3.868360, 0.000000, -5.243472>, <-3.866669, 0.058701, -5.241100>, <-3.786432, 0.000000, -5.134021>, <-3.752310, 0.000000, -5.086168>, 
      <-3.963044, 0.000000, -5.116554>, <-3.961310, 0.057464, -5.114366>, <-3.879881, 0.000000, -5.008150>, <-3.844153, 0.000000, -4.963058>, 
      <-3.969803, 0.000000, -5.010335>, <-3.968069, 0.057464, -5.008147>, <-3.886437, 0.000000, -4.905118>, <-3.850709, 0.000000, -4.860025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.462288, 0.000000, -5.495270>, <-3.460751, 0.058384, -5.492832>, <-3.389580, 0.000000, -5.379870>, <-3.358419, 0.000000, -5.330412>, 
      <-3.574452, 0.000000, -5.489974>, <-3.572916, 0.058384, -5.487536>, <-3.498380, 0.000000, -5.374733>, <-3.467219, 0.000000, -5.325276>, 
      <-3.710221, 0.000000, -5.394575>, <-3.708530, 0.058701, -5.392203>, <-3.633037, 0.000000, -5.280591>, <-3.598915, 0.000000, -5.232738>, 
      <-3.791408, 0.000000, -5.317000>, <-3.789716, 0.058701, -5.314629>, <-3.711788, 0.000000, -5.205344>, <-3.677666, 0.000000, -5.157491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000538, 0.000000, -5.495988>, <-0.000537, 0.049421, -5.493923>, <-0.000526, 0.000000, -5.380572>, <-0.000522, 0.000000, -5.331108>, 
      <-1.039063, 0.000000, -5.495988>, <-1.039062, 0.049421, -5.493923>, <-1.007896, 0.000000, -5.380572>, <-1.007891, 0.000000, -5.331108>, 
      <-2.424918, 0.000000, -5.544250>, <-2.423382, 0.058384, -5.541812>, <-2.383331, 0.000000, -5.427380>, <-2.352171, 0.000000, -5.377922>, 
      <-3.462288, 0.000000, -5.495270>, <-3.460751, 0.058384, -5.492832>, <-3.389580, 0.000000, -5.379870>, <-3.358419, 0.000000, -5.330412>
    }
  }
}
#declare cerradura_base = union {
  cone { // Cone001
    <0,0,0>, 0.85, <0,0,1>, 0.75
    scale <1.0, 1.0, 0.2>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    scale <0.675, 0.675, 0.25>
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    scale <0.55, 0.55, 0.275>
  }
}
#declare cerradura_dinero = difference {
  object { cerradura_base }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.1, 0.175>
    translate  0.139059*z
  }
  scale 0.5
  rotate <90.0, -0.0, -0.0>
  translate  <0.060641, -3.9864, -3.71858>
}
#declare dial_base = union {
  cone { // Cone002
    <0,0,0>, 1.0, <0,0,1>, 0.85
    scale <1.0, 1.0, 0.1>
    translate  0.1*z
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.1>
  }
}
#declare resta_botones = union {
  object { CSG002 }
  object { // CSG003 -> CSG002
    CSG002
    translate  0.35*x
  }
  object { // CSG004 -> CSG002
    CSG002
    translate  0.7*x
  }
  translate  0.213224*z
}
#declare dial_resta = difference {
  object { dial_base }
  object { resta_botones }
}
#declare resta_botones1 = union {
  object { CSG005 }
  object { // CSG006 -> CSG005
    CSG005
    translate  0.35*x
  }
  object { // CSG007 -> CSG005
    CSG005
    translate  0.7*x
  }
  material {
    dial_cabina_txt
    scale 1.4
    translate <-0.511726, -0.701400, 0.000000>
  }
}
#declare dial_cabina = union {
  object { dial_resta }
  object { resta_botones1 }
  scale 1.5
  rotate <90.0, 0.0, -0.0>
  translate  <1.31337, -3.889053, 1.822132>
}
#declare visor = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.298557, -4.099655, 3.134125>, <0.631022, -4.099655, 3.134125>, <1.870462, -4.099655, 3.134125>, <2.800041, -4.099655, 3.134125>, 
      <-0.292524, -4.066825, 3.139115>, <0.637055, -4.066825, 3.139115>, <1.864429, -4.066825, 3.139115>, <2.794008, -4.066825, 3.139115>, 
      <-0.298557, -4.020905, 3.134125>, <0.631022, -4.020905, 3.134125>, <1.870462, -4.020905, 3.134125>, <2.800041, -4.020905, 3.134125>, 
      <-0.298557, -3.987155, 3.134125>, <0.631022, -3.987155, 3.134125>, <1.870462, -3.987155, 3.134125>, <2.800041, -3.987155, 3.134125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.330176, -4.159214, 3.107978>, <0.618375, -4.159214, 3.107978>, <1.883109, -4.159214, 3.107978>, <2.831660, -4.159214, 3.107978>, 
      <-0.315085, -4.156955, 3.123403>, <0.633466, -4.156955, 3.123403>, <1.868018, -4.156955, 3.123403>, <2.816569, -4.156955, 3.123403>, 
      <-0.302436, -4.120760, 3.130918>, <0.627144, -4.120760, 3.130918>, <1.874340, -4.120760, 3.130918>, <2.803920, -4.120760, 3.130918>, 
      <-0.298557, -4.099655, 3.134125>, <0.631022, -4.099655, 3.134125>, <1.870462, -4.099655, 3.134125>, <2.800041, -4.099655, 3.134125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.386958, -4.112890, 3.043769>, <0.595662, -4.112890, 3.043769>, <1.905822, -4.112890, 3.043769>, <2.888442, -4.112890, 3.043769>, 
      <-0.379283, -4.139725, 3.052448>, <0.603337, -4.139725, 3.052448>, <1.898147, -4.139725, 3.052448>, <2.880767, -4.139725, 3.052448>, 
      <-0.350506, -4.162258, 3.087198>, <0.598045, -4.162258, 3.087198>, <1.903439, -4.162258, 3.087198>, <2.851990, -4.162258, 3.087198>, 
      <-0.330176, -4.159214, 3.107978>, <0.618375, -4.159214, 3.107978>, <1.883109, -4.159214, 3.107978>, <2.831660, -4.159214, 3.107978>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.800041, -4.099655, 3.134125>, <2.800041, -4.099655, 3.379912>, <2.800041, -4.099655, 3.707627>, <2.800041, -4.099655, 3.953413>, 
      <2.794008, -4.066825, 3.139115>, <2.794008, -4.066825, 3.384901>, <2.794008, -4.066825, 3.702638>, <2.794008, -4.066825, 3.948424>, 
      <2.800041, -4.020905, 3.134125>, <2.800041, -4.020905, 3.379912>, <2.800041, -4.020905, 3.707627>, <2.800041, -4.020905, 3.953413>, 
      <2.800041, -3.987155, 3.134125>, <2.800041, -3.987155, 3.379912>, <2.800041, -3.987155, 3.707627>, <2.800041, -3.987155, 3.953413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.831660, -4.159214, 3.107978>, <2.831660, -4.159214, 3.369453>, <2.831660, -4.159214, 3.718086>, <2.831660, -4.159214, 3.979560>, 
      <2.816569, -4.156955, 3.123403>, <2.816569, -4.156955, 3.384878>, <2.816569, -4.156955, 3.702661>, <2.816569, -4.156955, 3.964136>, 
      <2.803920, -4.120760, 3.130918>, <2.803920, -4.120760, 3.376704>, <2.803920, -4.120760, 3.710834>, <2.803920, -4.120760, 3.956620>, 
      <2.800041, -4.099655, 3.134125>, <2.800041, -4.099655, 3.379912>, <2.800041, -4.099655, 3.707627>, <2.800041, -4.099655, 3.953413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.888442, -4.112890, 3.043769>, <2.888442, -4.112890, 3.343769>, <2.888442, -4.112890, 3.743769>, <2.888442, -4.112890, 4.043769>, 
      <2.880767, -4.139725, 3.052448>, <2.880767, -4.139725, 3.352448>, <2.880767, -4.139725, 3.735090>, <2.880767, -4.139725, 4.035090>, 
      <2.851990, -4.162258, 3.087198>, <2.851990, -4.162258, 3.348673>, <2.851990, -4.162258, 3.738865>, <2.851990, -4.162258, 4.000340>, 
      <2.831660, -4.159214, 3.107978>, <2.831660, -4.159214, 3.369453>, <2.831660, -4.159214, 3.718086>, <2.831660, -4.159214, 3.979560>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.800041, -4.099655, 3.953413>, <1.870462, -4.099655, 3.953413>, <0.631022, -4.099655, 3.953413>, <-0.298557, -4.099655, 3.953413>, 
      <2.794008, -4.066825, 3.948424>, <1.864429, -4.066825, 3.948424>, <0.637055, -4.066825, 3.948424>, <-0.292524, -4.066825, 3.948424>, 
      <2.800041, -4.020905, 3.953413>, <1.870462, -4.020905, 3.953413>, <0.631022, -4.020905, 3.953413>, <-0.298557, -4.020905, 3.953413>, 
      <2.800041, -3.987155, 3.953413>, <1.870462, -3.987155, 3.953413>, <0.631022, -3.987155, 3.953413>, <-0.298557, -3.987155, 3.953413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.831660, -4.159214, 3.979560>, <1.883109, -4.159214, 3.979560>, <0.618375, -4.159214, 3.979560>, <-0.330176, -4.159214, 3.979560>, 
      <2.816569, -4.156955, 3.964136>, <1.868018, -4.156955, 3.964136>, <0.633466, -4.156955, 3.964136>, <-0.315085, -4.156955, 3.964136>, 
      <2.803920, -4.120760, 3.956620>, <1.874340, -4.120760, 3.956620>, <0.627144, -4.120760, 3.956620>, <-0.302436, -4.120760, 3.956620>, 
      <2.800041, -4.099655, 3.953413>, <1.870462, -4.099655, 3.953413>, <0.631022, -4.099655, 3.953413>, <-0.298557, -4.099655, 3.953413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.888442, -4.112890, 4.043769>, <1.905822, -4.112890, 4.043769>, <0.595662, -4.112890, 4.043769>, <-0.386958, -4.112890, 4.043769>, 
      <2.880767, -4.139725, 4.035090>, <1.898147, -4.139725, 4.035090>, <0.603337, -4.139725, 4.035090>, <-0.379283, -4.139725, 4.035090>, 
      <2.851990, -4.162258, 4.000340>, <1.903439, -4.162258, 4.000340>, <0.598045, -4.162258, 4.000340>, <-0.350506, -4.162258, 4.000340>, 
      <2.831660, -4.159214, 3.979560>, <1.883109, -4.159214, 3.979560>, <0.618375, -4.159214, 3.979560>, <-0.330176, -4.159214, 3.979560>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.298557, -4.099655, 3.953413>, <-0.298557, -4.099655, 3.707627>, <-0.298557, -4.099655, 3.379912>, <-0.298557, -4.099655, 3.134125>, 
      <-0.292524, -4.066825, 3.948424>, <-0.292524, -4.066825, 3.702638>, <-0.292524, -4.066825, 3.384901>, <-0.292524, -4.066825, 3.139115>, 
      <-0.298557, -4.020905, 3.953413>, <-0.298557, -4.020905, 3.707627>, <-0.298557, -4.020905, 3.379912>, <-0.298557, -4.020905, 3.134125>, 
      <-0.298557, -3.987155, 3.953413>, <-0.298557, -3.987155, 3.707627>, <-0.298557, -3.987155, 3.379912>, <-0.298557, -3.987155, 3.134125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.330176, -4.159214, 3.979560>, <-0.330176, -4.159214, 3.718086>, <-0.330176, -4.159214, 3.369453>, <-0.330176, -4.159214, 3.107978>, 
      <-0.315085, -4.156955, 3.964136>, <-0.315085, -4.156955, 3.702661>, <-0.315085, -4.156955, 3.384878>, <-0.315085, -4.156955, 3.123403>, 
      <-0.302436, -4.120760, 3.956620>, <-0.302436, -4.120760, 3.710834>, <-0.302436, -4.120760, 3.376704>, <-0.302436, -4.120760, 3.130918>, 
      <-0.298557, -4.099655, 3.953413>, <-0.298557, -4.099655, 3.707627>, <-0.298557, -4.099655, 3.379912>, <-0.298557, -4.099655, 3.134125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.386958, -4.112890, 4.043769>, <-0.386958, -4.112890, 3.743769>, <-0.386958, -4.112890, 3.343769>, <-0.386958, -4.112890, 3.043769>, 
      <-0.379283, -4.139725, 4.035090>, <-0.379283, -4.139725, 3.735090>, <-0.379283, -4.139725, 3.352448>, <-0.379283, -4.139725, 3.052448>, 
      <-0.350506, -4.162258, 4.000340>, <-0.350506, -4.162258, 3.738865>, <-0.350506, -4.162258, 3.348673>, <-0.350506, -4.162258, 3.087198>, 
      <-0.330176, -4.159214, 3.979560>, <-0.330176, -4.159214, 3.718086>, <-0.330176, -4.159214, 3.369453>, <-0.330176, -4.159214, 3.107978>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.386958, -4.112890, 3.043769>, <-0.398948, -4.070969, 3.030210>, <-0.386958, -4.006346, 3.043769>, <-0.386958, -3.960684, 3.043769>, 
      <-0.386958, -4.112890, 3.343769>, <-0.398948, -4.070969, 3.330210>, <-0.386958, -4.006346, 3.343769>, <-0.386958, -3.960684, 3.343769>, 
      <-0.386958, -4.112890, 3.743769>, <-0.398948, -4.070969, 3.757327>, <-0.386958, -4.006346, 3.743769>, <-0.386958, -3.960684, 3.743769>, 
      <-0.386958, -4.112890, 4.043769>, <-0.398948, -4.070969, 4.057327>, <-0.386958, -4.006346, 4.043769>, <-0.386958, -3.960684, 4.043769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.888442, -4.112890, 3.043769>, <2.900432, -4.070969, 3.030210>, <2.888442, -4.006346, 3.043769>, <2.888442, -3.960684, 3.043769>, 
      <1.905822, -4.112890, 3.043769>, <1.917812, -4.070969, 3.030210>, <1.905822, -4.006346, 3.043769>, <1.905822, -3.960684, 3.043769>, 
      <0.595662, -4.112890, 3.043769>, <0.583672, -4.070969, 3.030210>, <0.595662, -4.006346, 3.043769>, <0.595662, -3.960684, 3.043769>, 
      <-0.386958, -4.112890, 3.043769>, <-0.398948, -4.070969, 3.030210>, <-0.386958, -4.006346, 3.043769>, <-0.386958, -3.960684, 3.043769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.888442, -4.112890, 4.043769>, <2.900432, -4.070969, 4.057327>, <2.888442, -4.006346, 4.043769>, <2.888442, -3.960684, 4.043769>, 
      <2.888442, -4.112890, 3.743769>, <2.900432, -4.070969, 3.757327>, <2.888442, -4.006346, 3.743769>, <2.888442, -3.960684, 3.743769>, 
      <2.888442, -4.112890, 3.343769>, <2.900432, -4.070969, 3.330210>, <2.888442, -4.006346, 3.343769>, <2.888442, -3.960684, 3.343769>, 
      <2.888442, -4.112890, 3.043769>, <2.900432, -4.070969, 3.030210>, <2.888442, -4.006346, 3.043769>, <2.888442, -3.960684, 3.043769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.386958, -4.112890, 4.043769>, <-0.398948, -4.070969, 4.057327>, <-0.386958, -4.006346, 4.043769>, <-0.386958, -3.960684, 4.043769>, 
      <0.595662, -4.112890, 4.043769>, <0.583672, -4.070969, 4.057327>, <0.595662, -4.006346, 4.043769>, <0.595662, -3.960684, 4.043769>, 
      <1.905822, -4.112890, 4.043769>, <1.917812, -4.070969, 4.057327>, <1.905822, -4.006346, 4.043769>, <1.905822, -3.960684, 4.043769>, 
      <2.888442, -4.112890, 4.043769>, <2.900432, -4.070969, 4.057327>, <2.888442, -4.006346, 4.043769>, <2.888442, -3.960684, 4.043769>
    }
  }
  scale 0.75
  translate  <0.421576, -0.96577, 1.217886>
}
#declare sPatchObj = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.982024, -4.721854, -1.938570>, <-1.900213, -4.785023, -1.958692>, <-1.885687, -4.906951, -1.975436>, <-1.950043, -4.990297, -1.975436>, 
      <-1.938105, -4.704026, -1.778457>, <-1.856295, -4.767195, -1.798578>, <-1.820820, -4.865518, -1.723278>, <-1.885176, -4.948864, -1.723278>, 
      <-1.843463, -4.600105, -1.595371>, <-1.740854, -4.622016, -1.550565>, <-1.691412, -4.737209, -1.485216>, <-1.783710, -4.768904, -1.426117>, 
      <-1.784079, -4.547927, -1.448285>, <-1.681471, -4.569838, -1.403480>, <-1.620127, -4.642327, -1.249793>, <-1.712425, -4.674022, -1.190694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.068482, -4.663376, -2.485133>, <-2.002131, -4.720484, -2.502443>, <-1.995361, -4.824294, -2.516847>, <-2.053575, -4.891929, -2.516847>, 
      <-2.045052, -4.677725, -2.320477>, <-1.978701, -4.734833, -2.337787>, <-1.959847, -4.849540, -2.354618>, <-2.018061, -4.917175, -2.354618>, 
      <-2.025929, -4.739676, -2.098636>, <-1.944118, -4.802846, -2.118757>, <-1.927017, -4.933350, -2.136097>, <-1.991372, -5.016696, -2.136097>, 
      <-1.982024, -4.721854, -1.938570>, <-1.900213, -4.785023, -1.958692>, <-1.885687, -4.906951, -1.975436>, <-1.950043, -4.990297, -1.975436>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.112630, -4.641868, -2.856395>, <-2.066302, -4.707012, -2.874081>, <-2.083271, -4.800708, -2.888798>, <-2.149990, -4.848156, -2.888798>, 
      <-2.079855, -4.653006, -2.749512>, <-2.033527, -4.718150, -2.767198>, <-2.050870, -4.813577, -2.778142>, <-2.117589, -4.861025, -2.778142>, 
      <-2.084251, -4.653718, -2.595950>, <-2.017900, -4.710827, -2.613259>, <-2.019890, -4.806856, -2.628895>, <-2.078104, -4.874491, -2.628895>, 
      <-2.068482, -4.663376, -2.485133>, <-2.002131, -4.720484, -2.502443>, <-1.995361, -4.824294, -2.516847>, <-2.053575, -4.891929, -2.516847>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.647402, -4.466637, -4.373066>, <-2.580564, -4.510237, -4.391354>, <-2.562167, -4.603583, -4.406573>, <-2.606898, -4.672153, -4.406573>, 
      <-2.533776, -4.531860, -3.905773>, <-2.466939, -4.575460, -3.924061>, <-2.453559, -4.668045, -3.945104>, <-2.498289, -4.736615, -3.945104>, 
      <-2.254207, -4.593755, -3.318098>, <-2.207879, -4.658899, -3.335783>, <-2.216886, -4.747637, -3.345126>, <-2.283605, -4.795085, -3.345126>, 
      <-2.112630, -4.641868, -2.856395>, <-2.066302, -4.707012, -2.874081>, <-2.083271, -4.800708, -2.888798>, <-2.149990, -4.848156, -2.888798>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.945971, -4.163518, -6.283582>, <-2.895677, -4.217932, -6.318398>, <-2.903854, -4.309459, -6.347372>, <-2.963976, -4.365029, -6.347372>, 
      <-2.780900, -4.343381, -5.749541>, <-2.730605, -4.397795, -5.784358>, <-2.709410, -4.510140, -5.817385>, <-2.769531, -4.565710, -5.817385>, 
      <-2.784881, -4.387722, -4.938460>, <-2.718043, -4.431322, -4.956748>, <-2.698175, -4.522858, -4.984460>, <-2.742905, -4.591428, -4.984460>, 
      <-2.647402, -4.466637, -4.373066>, <-2.580564, -4.510237, -4.391354>, <-2.562167, -4.603583, -4.406573>, <-2.606898, -4.672153, -4.406573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.515996, -3.520210, -7.183149>, <-3.542454, -3.491900, -7.255268>, <-3.614248, -3.514860, -7.315284>, <-3.674062, -3.570761, -7.315284>, 
      <-3.291375, -3.760548, -7.359508>, <-3.317833, -3.732238, -7.431627>, <-3.347815, -3.799303, -7.501242>, <-3.407630, -3.855204, -7.501242>, 
      <-3.050900, -4.049187, -6.623049>, <-3.000606, -4.103601, -6.657866>, <-3.043999, -4.164819, -6.729358>, <-3.104121, -4.220389, -6.729358>, 
      <-2.945971, -4.163518, -6.283582>, <-2.895677, -4.217932, -6.318398>, <-2.903854, -4.309459, -6.347372>, <-2.963976, -4.365029, -6.347372>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.245208, -2.773372, -5.263497>, <-4.299804, -2.717512, -5.288027>, <-4.393960, -2.718649, -5.308440>, <-4.452510, -2.775873, -5.308440>, 
      <-4.108068, -2.913677, -5.888972>, <-4.162664, -2.857817, -5.913502>, <-4.246296, -2.870439, -5.963442>, <-4.304845, -2.927664, -5.963442>, 
      <-3.910484, -3.098119, -6.873420>, <-3.936941, -3.069809, -6.945539>, <-4.038973, -3.061424, -7.018844>, <-4.098787, -3.117325, -7.018844>, 
      <-3.515996, -3.520210, -7.183149>, <-3.542454, -3.491900, -7.255268>, <-3.614248, -3.514860, -7.315284>, <-3.674062, -3.570761, -7.315284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.467835, -2.546406, -2.841961>, <-4.522828, -2.486267, -2.849817>, <-4.618871, -2.482198, -2.856354>, <-4.679288, -2.537446, -2.856354>, 
      <-4.421734, -2.596799, -3.571466>, <-4.476728, -2.536661, -3.579322>, <-4.571963, -2.536444, -3.595101>, <-4.632380, -2.591692, -3.595101>, 
      <-4.398493, -2.616549, -4.564389>, <-4.453089, -2.560690, -4.588919>, <-4.553173, -2.554987, -4.602213>, <-4.611722, -2.612212, -4.602213>, 
      <-4.245208, -2.773372, -5.263497>, <-4.299804, -2.717512, -5.288027>, <-4.393960, -2.718649, -5.308440>, <-4.452510, -2.775873, -5.308440>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.517216, -2.476032, -0.959193>, <-4.569587, -2.413135, -0.961183>, <-4.665525, -2.404388, -0.962840>, <-4.728441, -2.456774, -0.962840>, 
      <-4.523320, -2.489045, -1.524429>, <-4.575691, -2.426148, -1.526420>, <-4.671725, -2.413857, -1.531488>, <-4.734641, -2.466243, -1.531488>, 
      <-4.503411, -2.507517, -2.279004>, <-4.558404, -2.447378, -2.286860>, <-4.654817, -2.440629, -2.290255>, <-4.715234, -2.495877, -2.290255>, 
      <-4.467835, -2.546406, -2.841961>, <-4.522828, -2.486267, -2.849817>, <-4.618871, -2.482198, -2.856354>, <-4.679288, -2.537446, -2.856354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.427077, -2.459513, 0.932313>, <-4.488507, -2.406014, 0.924137>, <-4.584372, -2.412872, 0.917333>, <-4.638140, -2.474611, 0.917333>, 
      <-4.485007, -2.468450, 0.367228>, <-4.546437, -2.414951, 0.359052>, <-4.643870, -2.427762, 0.355946>, <-4.697637, -2.489501, 0.355946>, 
      <-4.511083, -2.462957, -0.391259>, <-4.563454, -2.400060, -0.393250>, <-4.659368, -2.394987, -0.398224>, <-4.722284, -2.447373, -0.398224>, 
      <-4.517216, -2.476032, -0.959193>, <-4.569587, -2.413135, -0.961183>, <-4.665525, -2.404388, -0.962840>, <-4.728441, -2.456774, -0.962840>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.212406, -2.429008, 2.014130>, <-4.253086, -2.359953, 1.997421>, <-4.345641, -2.337068, 1.983516>, <-4.416181, -2.378623, 1.983516>, 
      <-4.319093, -2.451524, 1.701605>, <-4.359773, -2.382469, 1.684896>, <-4.459689, -2.365902, 1.677359>, <-4.530229, -2.407457, 1.677359>, 
      <-4.393325, -2.454307, 1.261546>, <-4.454756, -2.400808, 1.253370>, <-4.549818, -2.404224, 1.243372>, <-4.603586, -2.465963, 1.243372>, 
      <-4.427077, -2.459513, 0.932313>, <-4.488507, -2.406014, 0.924137>, <-4.584372, -2.412872, 0.917333>, <-4.638140, -2.474611, 0.917333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.865178, -2.340927, 2.578317>, <-3.893931, -2.274105, 2.615878>, <-3.931680, -2.255607, 2.702575>, <-3.948290, -2.300201, 2.769194>, 
      <-3.969347, -2.367351, 2.409061>, <-3.998099, -2.300529, 2.446622>, <-4.072047, -2.279134, 2.466871>, <-4.088657, -2.323727, 2.533491>, 
      <-4.147784, -2.415370, 2.203431>, <-4.188464, -2.346315, 2.186722>, <-4.249896, -2.312862, 2.240537>, <-4.320436, -2.354417, 2.240537>, 
      <-4.212406, -2.429008, 2.014130>, <-4.253086, -2.359953, 1.997421>, <-4.345641, -2.337068, 1.983516>, <-4.416181, -2.378623, 1.983516>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.950043, -4.990297, -1.975436>, <-2.014398, -5.073644, -1.975436>, <-2.136035, -5.090434, -1.958692>, <-2.217845, -5.027264, -1.938570>, 
      <-1.885176, -4.948864, -1.723278>, <-1.949531, -5.032210, -1.723278>, <-2.127034, -5.051068, -1.708848>, <-2.208845, -4.987899, -1.688726>, 
      <-1.783710, -4.768904, -1.426117>, <-1.947101, -4.825012, -1.321497>, <-2.047559, -4.838684, -1.314362>, <-2.229202, -4.799896, -1.393680>, 
      <-1.712425, -4.674022, -1.190694>, <-1.875816, -4.730130, -1.086074>, <-2.052426, -4.741240, -1.080838>, <-2.234069, -4.702452, -1.160155>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.053575, -4.891929, -2.516847>, <-2.111789, -4.959564, -2.516847>, <-2.215449, -4.968324, -2.502443>, <-2.281800, -4.911216, -2.485133>, 
      <-2.018061, -4.917175, -2.354618>, <-2.076275, -4.984810, -2.354618>, <-2.190771, -5.005808, -2.339802>, <-2.257122, -4.948700, -2.322492>, 
      <-1.991372, -5.016696, -2.136097>, <-2.055728, -5.100043, -2.136097>, <-2.142035, -5.116677, -2.125249>, <-2.223845, -5.053507, -2.105127>, 
      <-1.950043, -4.990297, -1.975436>, <-2.014398, -5.073644, -1.975436>, <-2.136035, -5.090434, -1.958692>, <-2.217845, -5.027264, -1.938570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.149990, -4.848156, -2.888798>, <-2.216708, -4.895604, -2.888798>, <-2.310782, -4.880878, -2.874081>, <-2.357110, -4.815735, -2.856395>, 
      <-2.117589, -4.861025, -2.778142>, <-2.184307, -4.908474, -2.778142>, <-2.279285, -4.892377, -2.761779>, <-2.325613, -4.827234, -2.744093>, 
      <-2.078104, -4.874491, -2.628895>, <-2.136318, -4.942126, -2.628895>, <-2.232592, -4.942286, -2.615422>, <-2.298943, -4.885178, -2.598112>, 
      <-2.053575, -4.891929, -2.516847>, <-2.111789, -4.959564, -2.516847>, <-2.215449, -4.968324, -2.502443>, <-2.281800, -4.911216, -2.485133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.606898, -4.672153, -4.406573>, <-2.651628, -4.740723, -4.406573>, <-2.744472, -4.761503, -4.391354>, <-2.811310, -4.717903, -4.373066>, 
      <-2.498289, -4.736615, -3.945104>, <-2.543020, -4.805185, -3.945104>, <-2.636000, -4.821638, -3.931929>, <-2.702838, -4.778038, -3.913640>, 
      <-2.283605, -4.795085, -3.345126>, <-2.350323, -4.842533, -3.345126>, <-2.438672, -4.834188, -3.330062>, <-2.484999, -4.769045, -3.312376>, 
      <-2.149990, -4.848156, -2.888798>, <-2.216708, -4.895604, -2.888798>, <-2.310782, -4.880878, -2.874081>, <-2.357110, -4.815735, -2.856395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.963976, -4.365029, -6.347372>, <-3.024098, -4.420599, -6.347372>, <-3.115984, -4.421561, -6.318398>, <-3.166279, -4.367146, -6.283582>, 
      <-2.769531, -4.565710, -5.817385>, <-2.829653, -4.621280, -5.817385>, <-2.940585, -4.610056, -5.784897>, <-2.990880, -4.555642, -5.750080>, 
      <-2.742905, -4.591428, -4.984460>, <-2.787636, -4.659998, -4.984460>, <-2.879502, -4.686644, -4.963266>, <-2.946339, -4.643044, -4.944978>, 
      <-2.606898, -4.672153, -4.406573>, <-2.651628, -4.740723, -4.406573>, <-2.744472, -4.761503, -4.391354>, <-2.811310, -4.717903, -4.373066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.674062, -3.570761, -7.315284>, <-3.733876, -3.626662, -7.315284>, <-3.761635, -3.696740, -7.255268>, <-3.735178, -3.725050, -7.183149>, 
      <-3.407630, -3.855204, -7.501242>, <-3.467444, -3.911104, -7.501242>, <-3.537450, -3.936629, -7.432069>, <-3.510993, -3.964939, -7.359950>, 
      <-3.104121, -4.220389, -6.729358>, <-3.164243, -4.275959, -6.729358>, <-3.226399, -4.302900, -6.654244>, <-3.276694, -4.248486, -6.619427>, 
      <-2.963976, -4.365029, -6.347372>, <-3.024098, -4.420599, -6.347372>, <-3.115984, -4.421561, -6.318398>, <-3.166279, -4.367146, -6.283582>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.452510, -2.775873, -5.308440>, <-4.511059, -2.833098, -5.308440>, <-4.514349, -2.927204, -5.288027>, <-4.459754, -2.983063, -5.263497>, 
      <-4.304845, -2.927664, -5.963442>, <-4.363395, -2.984888, -5.963442>, <-4.377121, -3.067617, -5.912453>, <-4.322526, -3.123477, -5.887923>, 
      <-4.098787, -3.117325, -7.018844>, <-4.158602, -3.173226, -7.018844>, <-4.155141, -3.275668, -6.944934>, <-4.128684, -3.303978, -6.872814>, 
      <-3.674062, -3.570761, -7.315284>, <-3.733876, -3.626662, -7.315284>, <-3.761635, -3.696740, -7.255268>, <-3.735178, -3.725050, -7.183149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.679288, -2.537446, -2.856354>, <-4.739706, -2.592695, -2.856354>, <-4.744219, -2.688717, -2.849817>, <-4.689226, -2.748856, -2.841961>, 
      <-4.632380, -2.591692, -3.595101>, <-4.692798, -2.646941, -3.595101>, <-4.695406, -2.742116, -3.579328>, <-4.640413, -2.802255, -3.571473>, 
      <-4.611722, -2.612212, -4.602213>, <-4.670272, -2.669436, -4.602213>, <-4.668040, -2.769946, -4.588691>, <-4.613444, -2.825805, -4.564161>, 
      <-4.452510, -2.775873, -5.308440>, <-4.511059, -2.833098, -5.308440>, <-4.514349, -2.927204, -5.288027>, <-4.459754, -2.983063, -5.263497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.728441, -2.456774, -0.962840>, <-4.791356, -2.509160, -0.962840>, <-4.800132, -2.605096, -0.961183>, <-4.747761, -2.667993, -0.959193>, 
      <-4.734641, -2.466243, -1.531488>, <-4.797557, -2.518629, -1.531488>, <-4.809889, -2.614551, -1.526644>, <-4.757518, -2.677448, -1.524653>, 
      <-4.715234, -2.495877, -2.290255>, <-4.775651, -2.551126, -2.290255>, <-4.781881, -2.647516, -2.286954>, <-4.726888, -2.707655, -2.279099>, 
      <-4.679288, -2.537446, -2.856354>, <-4.739706, -2.592695, -2.856354>, <-4.744219, -2.688717, -2.849817>, <-4.689226, -2.748856, -2.841961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.638140, -2.474611, 0.917333>, <-4.691908, -2.536350, 0.917333>, <-4.685531, -2.632249, 0.924137>, <-4.624100, -2.685747, 0.932313>, 
      <-4.697637, -2.489501, 0.355946>, <-4.751405, -2.551241, 0.355946>, <-4.738236, -2.648755, 0.358137>, <-4.676806, -2.702254, 0.366313>, 
      <-4.722284, -2.447373, -0.398224>, <-4.785200, -2.499759, -0.398224>, <-4.790322, -2.595590, -0.392659>, <-4.737951, -2.658487, -0.390669>, 
      <-4.728441, -2.456774, -0.962840>, <-4.791356, -2.509160, -0.962840>, <-4.800132, -2.605096, -0.961183>, <-4.747761, -2.667993, -0.959193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.416181, -2.378623, 1.983516>, <-4.486720, -2.420178, 1.983516>, <-4.511568, -2.512225, 1.997421>, <-4.470888, -2.581280, 2.014130>, 
      <-4.530229, -2.407457, 1.677359>, <-4.600769, -2.449012, 1.677359>, <-4.625186, -2.541753, 1.689779>, <-4.584506, -2.610808, 1.706488>, 
      <-4.603586, -2.465963, 1.243372>, <-4.657354, -2.527702, 1.243372>, <-4.655014, -2.622691, 1.251859>, <-4.593583, -2.676190, 1.260035>, 
      <-4.638140, -2.474611, 0.917333>, <-4.691908, -2.536350, 0.917333>, <-4.685531, -2.632249, 0.924137>, <-4.624100, -2.685747, 0.932313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.948290, -2.300201, 2.769194>, <-3.964900, -2.344795, 2.835814>, <-3.954796, -2.437513, 2.859996>, <-3.926044, -2.504335, 2.822435>, 
      <-4.088657, -2.323727, 2.533491>, <-4.105267, -2.368321, 2.600110>, <-4.118249, -2.460596, 2.617504>, <-4.089497, -2.527418, 2.579943>, 
      <-4.320436, -2.354417, 2.240537>, <-4.390976, -2.395972, 2.240537>, <-4.410349, -2.485920, 2.271492>, <-4.369669, -2.554975, 2.288200>, 
      <-4.416181, -2.378623, 1.983516>, <-4.486720, -2.420178, 1.983516>, <-4.511568, -2.512225, 1.997421>, <-4.470888, -2.581280, 2.014130>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.217845, -5.027264, -1.938570>, <-2.299656, -4.964095, -1.918449>, <-2.314182, -4.842167, -1.901704>, <-2.249827, -4.758821, -1.901704>, 
      <-2.208845, -4.987899, -1.688726>, <-2.290656, -4.924729, -1.668605>, <-2.315523, -4.822039, -1.752433>, <-2.251168, -4.738692, -1.752433>, 
      <-2.229202, -4.799896, -1.393680>, <-2.345921, -4.774971, -1.444647>, <-2.393946, -4.646828, -1.518124>, <-2.288955, -4.610774, -1.585350>, 
      <-2.234069, -4.702452, -1.160155>, <-2.350788, -4.677527, -1.211123>, <-2.410715, -4.583379, -1.382543>, <-2.305724, -4.547326, -1.449769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.281800, -4.911216, -2.485133>, <-2.348151, -4.854107, -2.467823>, <-2.354922, -4.750298, -2.453418>, <-2.296708, -4.682662, -2.453418>, 
      <-2.257122, -4.948700, -2.322492>, <-2.323473, -4.891590, -2.305183>, <-2.342408, -4.777030, -2.288362>, <-2.284194, -4.709395, -2.288362>, 
      <-2.223845, -5.053507, -2.105127>, <-2.305656, -4.990338, -2.085006>, <-2.312690, -4.864574, -2.067868>, <-2.248334, -4.781228, -2.067868>, 
      <-2.217845, -5.027264, -1.938570>, <-2.299656, -4.964095, -1.918449>, <-2.314182, -4.842167, -1.901704>, <-2.249827, -4.758821, -1.901704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.357110, -4.815735, -2.856395>, <-2.403438, -4.750592, -2.838710>, <-2.386469, -4.656896, -2.823992>, <-2.319750, -4.609448, -2.823992>, 
      <-2.325613, -4.827234, -2.744093>, <-2.371940, -4.762091, -2.726407>, <-2.354534, -4.666692, -2.715485>, <-2.287816, -4.619244, -2.715485>, 
      <-2.298943, -4.885178, -2.598112>, <-2.365294, -4.828069, -2.580802>, <-2.363395, -4.732198, -2.565177>, <-2.305181, -4.664562, -2.565177>, 
      <-2.281800, -4.911216, -2.485133>, <-2.348151, -4.854107, -2.467823>, <-2.354922, -4.750298, -2.453418>, <-2.296708, -4.682662, -2.453418>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.811310, -4.717903, -4.373066>, <-2.878147, -4.674302, -4.354778>, <-2.896544, -4.580957, -4.339560>, <-2.851814, -4.512387, -4.339560>, 
      <-2.702838, -4.778038, -3.913640>, <-2.769675, -4.734438, -3.895352>, <-2.783027, -4.641764, -3.874299>, <-2.738297, -4.573194, -3.874299>, 
      <-2.484999, -4.769045, -3.312376>, <-2.531327, -4.703902, -3.294691>, <-2.522258, -4.615244, -3.285378>, <-2.455540, -4.567795, -3.285378>, 
      <-2.357110, -4.815735, -2.856395>, <-2.403438, -4.750592, -2.838710>, <-2.386469, -4.656896, -2.823992>, <-2.319750, -4.609448, -2.823992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.166279, -4.367146, -6.283582>, <-3.216573, -4.312732, -6.248765>, <-3.208395, -4.221206, -6.219792>, <-3.148274, -4.165636, -6.219792>, 
      <-2.990880, -4.555642, -5.750080>, <-3.041174, -4.501228, -5.715263>, <-3.064673, -4.387238, -5.682500>, <-3.004551, -4.331668, -5.682500>, 
      <-2.946339, -4.643044, -4.944978>, <-3.013177, -4.599444, -4.926690>, <-3.033030, -4.507846, -4.898963>, <-2.988300, -4.439276, -4.898963>, 
      <-2.811310, -4.717903, -4.373066>, <-2.878147, -4.674302, -4.354778>, <-2.896544, -4.580957, -4.339560>, <-2.851814, -4.512387, -4.339560>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.735178, -3.725050, -7.183149>, <-3.708720, -3.753360, -7.111030>, <-3.636926, -3.730400, -7.051014>, <-3.577112, -3.674499, -7.051014>, 
      <-3.510993, -3.964939, -7.359950>, <-3.484535, -3.993249, -7.287830>, <-3.453153, -3.927637, -7.217654>, <-3.393338, -3.871736, -7.217654>, 
      <-3.276694, -4.248486, -6.619427>, <-3.326989, -4.194072, -6.584610>, <-3.286871, -4.130548, -6.513164>, <-3.226749, -4.074978, -6.513164>, 
      <-3.166279, -4.367146, -6.283582>, <-3.216573, -4.312732, -6.248765>, <-3.208395, -4.221206, -6.219792>, <-3.148274, -4.165636, -6.219792>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.459754, -2.983063, -5.263497>, <-4.405158, -3.038923, -5.238967>, <-4.311001, -3.037786, -5.218554>, <-4.252452, -2.980561, -5.218554>, 
      <-4.322526, -3.123477, -5.887923>, <-4.267930, -3.179336, -5.863393>, <-4.184149, -3.166895, -5.813397>, <-4.125600, -3.109670, -5.813397>, 
      <-4.128684, -3.303978, -6.872814>, <-4.102226, -3.332289, -6.800695>, <-3.997463, -3.343448, -6.724088>, <-3.937649, -3.287547, -6.724088>, 
      <-3.735178, -3.725050, -7.183149>, <-3.708720, -3.753360, -7.111030>, <-3.636926, -3.730400, -7.051014>, <-3.577112, -3.674499, -7.051014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.689226, -2.748856, -2.841961>, <-4.634232, -2.808995, -2.834106>, <-4.538190, -2.813064, -2.827568>, <-4.477772, -2.757815, -2.827568>, 
      <-4.640413, -2.802255, -3.571473>, <-4.585419, -2.862394, -3.563617>, <-4.490191, -2.862621, -3.547838>, <-4.429774, -2.807373, -3.547838>, 
      <-4.613444, -2.825805, -4.564161>, <-4.558848, -2.881664, -4.539631>, <-4.458621, -2.887540, -4.526324>, <-4.400072, -2.830316, -4.526324>, 
      <-4.459754, -2.983063, -5.263497>, <-4.405158, -3.038923, -5.238967>, <-4.311001, -3.037786, -5.218554>, <-4.252452, -2.980561, -5.218554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.747761, -2.667993, -0.959193>, <-4.695391, -2.730890, -0.957202>, <-4.599452, -2.739637, -0.955545>, <-4.536537, -2.687251, -0.955545>, 
      <-4.757518, -2.677448, -1.524653>, <-4.705148, -2.740345, -1.522663>, <-4.609091, -2.752615, -1.517595>, <-4.546176, -2.700229, -1.517595>, 
      <-4.726888, -2.707655, -2.279099>, <-4.671894, -2.767794, -2.271243>, <-4.575489, -2.774553, -2.267848>, <-4.515072, -2.719305, -2.267848>, 
      <-4.689226, -2.748856, -2.841961>, <-4.634232, -2.808995, -2.834106>, <-4.538190, -2.813064, -2.827568>, <-4.477772, -2.757815, -2.827568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.624100, -2.685747, 0.932313>, <-4.562670, -2.739246, 0.940489>, <-4.466805, -2.732389, 0.947293>, <-4.413037, -2.670650, 0.947293>, 
      <-4.676806, -2.702254, 0.366313>, <-4.615375, -2.755753, 0.374489>, <-4.517962, -2.742943, 0.377609>, <-4.464194, -2.681204, 0.377609>, 
      <-4.737951, -2.658487, -0.390669>, <-4.685581, -2.721384, -0.388678>, <-4.589646, -2.726433, -0.383707>, <-4.526730, -2.674047, -0.383707>, 
      <-4.747761, -2.667993, -0.959193>, <-4.695391, -2.730890, -0.957202>, <-4.599452, -2.739637, -0.955545>, <-4.536537, -2.687251, -0.955545>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.470888, -2.581280, 2.014130>, <-4.430208, -2.650336, 2.030839>, <-4.337653, -2.673220, 2.044744>, <-4.267113, -2.631665, 2.044744>, 
      <-4.584506, -2.610808, 1.706488>, <-4.543826, -2.679863, 1.723197>, <-4.443942, -2.696635, 1.730732>, <-4.373402, -2.655080, 1.730732>, 
      <-4.593583, -2.676190, 1.260035>, <-4.532153, -2.729689, 1.268211>, <-4.437086, -2.726257, 1.278244>, <-4.383318, -2.664518, 1.278244>, 
      <-4.624100, -2.685747, 0.932313>, <-4.562670, -2.739246, 0.940489>, <-4.466805, -2.732389, 0.947293>, <-4.413037, -2.670650, 0.947293>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.926044, -2.504335, 2.822435>, <-3.897292, -2.571157, 2.784874>, <-3.859542, -2.589654, 2.698178>, <-3.842932, -2.545060, 2.631558>, 
      <-4.089497, -2.527418, 2.579943>, <-4.060745, -2.594240, 2.542383>, <-3.986797, -2.615636, 2.522133>, <-3.970186, -2.571042, 2.455514>, 
      <-4.369669, -2.554975, 2.288200>, <-4.328988, -2.624030, 2.304909>, <-4.267686, -2.657807, 2.251450>, <-4.197146, -2.616252, 2.251450>, 
      <-4.470888, -2.581280, 2.014130>, <-4.430208, -2.650336, 2.030839>, <-4.337653, -2.673220, 2.044744>, <-4.267113, -2.631665, 2.044744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.249827, -4.758821, -1.901704>, <-2.185471, -4.675475, -1.901704>, <-2.063835, -4.658684, -1.918449>, <-1.982024, -4.721854, -1.938570>, 
      <-2.251168, -4.738692, -1.752433>, <-2.186812, -4.655346, -1.752433>, <-2.019916, -4.640856, -1.758335>, <-1.938105, -4.704026, -1.778457>, 
      <-2.288955, -4.610774, -1.585350>, <-2.126083, -4.554844, -1.689637>, <-2.024529, -4.561439, -1.674437>, <-1.843463, -4.600105, -1.595371>, 
      <-2.305724, -4.547326, -1.449769>, <-2.142853, -4.491396, -1.554057>, <-1.965145, -4.509261, -1.527351>, <-1.784079, -4.547927, -1.448285>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.296708, -4.682662, -2.453418>, <-2.238493, -4.615027, -2.453418>, <-2.134833, -4.606267, -2.467823>, <-2.068482, -4.663376, -2.485133>, 
      <-2.284194, -4.709395, -2.288362>, <-2.225979, -4.641759, -2.288362>, <-2.111403, -4.620616, -2.303168>, <-2.045052, -4.677725, -2.320477>, 
      <-2.248334, -4.781228, -2.067868>, <-2.183978, -4.697881, -2.067868>, <-2.107740, -4.676507, -2.078515>, <-2.025929, -4.739676, -2.098636>, 
      <-2.249827, -4.758821, -1.901704>, <-2.185471, -4.675475, -1.901704>, <-2.063835, -4.658684, -1.918449>, <-1.982024, -4.721854, -1.938570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.319750, -4.609448, -2.823992>, <-2.253032, -4.562000, -2.823992>, <-2.158957, -4.576726, -2.838710>, <-2.112630, -4.641868, -2.856395>, 
      <-2.287816, -4.619244, -2.715485>, <-2.221097, -4.571796, -2.715485>, <-2.126182, -4.587864, -2.731827>, <-2.079855, -4.653006, -2.749512>, 
      <-2.305181, -4.664562, -2.565177>, <-2.246966, -4.596927, -2.565177>, <-2.150602, -4.596610, -2.578640>, <-2.084251, -4.653718, -2.595950>, 
      <-2.296708, -4.682662, -2.453418>, <-2.238493, -4.615027, -2.453418>, <-2.134833, -4.606267, -2.467823>, <-2.068482, -4.663376, -2.485133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.851814, -4.512387, -4.339560>, <-2.807083, -4.443817, -4.339560>, <-2.714239, -4.423037, -4.354778>, <-2.647402, -4.466637, -4.373066>, 
      <-2.738297, -4.573194, -3.874299>, <-2.693567, -4.504624, -3.874299>, <-2.600614, -4.488260, -3.887484>, <-2.533776, -4.531860, -3.905773>, 
      <-2.455540, -4.567795, -3.285378>, <-2.388821, -4.520347, -3.285378>, <-2.300534, -4.528612, -3.300412>, <-2.254207, -4.593755, -3.318098>, 
      <-2.319750, -4.609448, -2.823992>, <-2.253032, -4.562000, -2.823992>, <-2.158957, -4.576726, -2.838710>, <-2.112630, -4.641868, -2.856395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.148274, -4.165636, -6.219792>, <-3.088152, -4.110066, -6.219792>, <-2.996266, -4.109104, -6.248765>, <-2.945971, -4.163518, -6.283582>, 
      <-3.004551, -4.331668, -5.682500>, <-2.944429, -4.276098, -5.682500>, <-2.831194, -4.288967, -5.714724>, <-2.780900, -4.343381, -5.749541>, 
      <-2.988300, -4.439276, -4.898963>, <-2.943569, -4.370706, -4.898963>, <-2.851718, -4.344122, -4.920172>, <-2.784881, -4.387722, -4.938460>, 
      <-2.851814, -4.512387, -4.339560>, <-2.807083, -4.443817, -4.339560>, <-2.714239, -4.423037, -4.354778>, <-2.647402, -4.466637, -4.373066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.577112, -3.674499, -7.051014>, <-3.517297, -3.618598, -7.051014>, <-3.489538, -3.548520, -7.111030>, <-3.515996, -3.520210, -7.183149>, 
      <-3.393338, -3.871736, -7.217654>, <-3.333524, -3.815835, -7.217654>, <-3.264917, -3.788858, -7.287389>, <-3.291375, -3.760548, -7.359508>, 
      <-3.226749, -4.074978, -6.513164>, <-3.166627, -4.019408, -6.513164>, <-3.101195, -3.994772, -6.588232>, <-3.050900, -4.049187, -6.623049>, 
      <-3.148274, -4.165636, -6.219792>, <-3.088152, -4.110066, -6.219792>, <-2.996266, -4.109104, -6.248765>, <-2.945971, -4.163518, -6.283582>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.252452, -2.980561, -5.218554>, <-4.193902, -2.923337, -5.218554>, <-4.190613, -2.829231, -5.238967>, <-4.245208, -2.773372, -5.263497>, 
      <-4.125600, -3.109670, -5.813397>, <-4.067050, -3.052446, -5.813397>, <-4.053472, -2.969536, -5.864442>, <-4.108068, -2.913677, -5.888972>, 
      <-3.937649, -3.287547, -6.724088>, <-3.877834, -3.231646, -6.724088>, <-3.884026, -3.126430, -6.801301>, <-3.910484, -3.098119, -6.873420>, 
      <-3.577112, -3.674499, -7.051014>, <-3.517297, -3.618598, -7.051014>, <-3.489538, -3.548520, -7.111030>, <-3.515996, -3.520210, -7.183149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.477772, -2.757815, -2.827568>, <-4.417355, -2.702567, -2.827568>, <-4.412841, -2.606544, -2.834106>, <-4.467835, -2.546406, -2.841961>, 
      <-4.429774, -2.807373, -3.547838>, <-4.369357, -2.752124, -3.547838>, <-4.366741, -2.656938, -3.563610>, <-4.421734, -2.596799, -3.571466>, 
      <-4.400072, -2.830316, -4.526324>, <-4.341522, -2.773091, -4.526324>, <-4.343898, -2.672409, -4.539859>, <-4.398493, -2.616549, -4.564389>, 
      <-4.252452, -2.980561, -5.218554>, <-4.193902, -2.923337, -5.218554>, <-4.190613, -2.829231, -5.238967>, <-4.245208, -2.773372, -5.263497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.536537, -2.687251, -0.955545>, <-4.473621, -2.634865, -0.955545>, <-4.464846, -2.538929, -0.957202>, <-4.517216, -2.476032, -0.959193>, 
      <-4.546176, -2.700229, -1.517595>, <-4.483260, -2.647843, -1.517595>, <-4.470950, -2.551942, -1.522438>, <-4.523320, -2.489045, -1.524429>, 
      <-4.515072, -2.719305, -2.267848>, <-4.454655, -2.664056, -2.267848>, <-4.448417, -2.567655, -2.271148>, <-4.503411, -2.507517, -2.279004>, 
      <-4.477772, -2.757815, -2.827568>, <-4.417355, -2.702567, -2.827568>, <-4.412841, -2.606544, -2.834106>, <-4.467835, -2.546406, -2.841961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.413037, -2.670650, 0.947293>, <-4.359270, -2.608911, 0.947293>, <-4.365646, -2.513012, 0.940489>, <-4.427077, -2.459513, 0.932313>, 
      <-4.464194, -2.681204, 0.377609>, <-4.410427, -2.619465, 0.377609>, <-4.423576, -2.521949, 0.375404>, <-4.485007, -2.468450, 0.367228>, 
      <-4.526730, -2.674047, -0.383707>, <-4.463814, -2.621661, -0.383707>, <-4.458712, -2.525854, -0.389268>, <-4.511083, -2.462957, -0.391259>, 
      <-4.536537, -2.687251, -0.955545>, <-4.473621, -2.634865, -0.955545>, <-4.464846, -2.538929, -0.957202>, <-4.517216, -2.476032, -0.959193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.267113, -2.631665, 2.044744>, <-4.196573, -2.590111, 2.044744>, <-4.171725, -2.498063, 2.030839>, <-4.212406, -2.429008, 2.014130>, 
      <-4.373402, -2.655080, 1.730732>, <-4.302863, -2.613525, 1.730732>, <-4.278412, -2.520579, 1.718314>, <-4.319093, -2.451524, 1.701605>, 
      <-4.383318, -2.664518, 1.278244>, <-4.329551, -2.602779, 1.278244>, <-4.331895, -2.507805, 1.269722>, <-4.393325, -2.454307, 1.261546>, 
      <-4.413037, -2.670650, 0.947293>, <-4.359270, -2.608911, 0.947293>, <-4.365646, -2.513012, 0.940489>, <-4.427077, -2.459513, 0.932313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.842932, -2.545060, 2.631558>, <-3.826322, -2.500466, 2.564939>, <-3.836426, -2.407749, 2.540757>, <-3.865178, -2.340927, 2.578317>, 
      <-3.970186, -2.571042, 2.455514>, <-3.953576, -2.526448, 2.388895>, <-3.940595, -2.434173, 2.371500>, <-3.969347, -2.367351, 2.409061>, 
      <-4.197146, -2.616252, 2.251450>, <-4.126606, -2.574697, 2.251450>, <-4.107103, -2.484425, 2.220140>, <-4.147784, -2.415370, 2.203431>, 
      <-4.267113, -2.631665, 2.044744>, <-4.196573, -2.590111, 2.044744>, <-4.171725, -2.498063, 2.030839>, <-4.212406, -2.429008, 2.014130>
    }
  }
}
#declare boton_dinero = union {
  torus { // Torus012
    1.5, 0.25  rotate -x*90
    scale <0.04, 0.04, 0.1>
    rotate -90.0*x
    translate  <0.0, 0.0, 8.0>
  }
  superellipsoid { // SuperQ007
    <1.0, 0.1>
    scale <0.05, 0.05, 0.1>
    rotate -90.0*x
    translate  <0.0, -0.04314, 8.0>
  }
  scale 4.444445
  rotate <-0.0, 0.0, -0.0>
  translate  <2.223759, -3.982859, -30.88319>
}
#declare phonebox = union {
  object { hierro_tf }
  object { ranura_dinero }
  object { tf_2 }
  object { tf_1 }
  object { panel_frente }
  object { caja_dinero }
  object { frente_caja }
  object { fondo_caja }
  object { caja_base }
  object { cerradura_dinero }
  superellipsoid { // tapa_cambios
    <0.1, 0.1>
    scale <0.585, 0.05, 0.75>
    rotate <-0.0, -0.0, -0.0>
    translate  <0.679743, -3.876784, -0.696948>
  }
  object { dial_cabina }
  object { visor }
  object { sPatchObj }
  object { boton_dinero }
  cone { // Cone003
    <0,0,0>, 0.6, <0,0,1>, 1.2
    scale <0.444444, 0.444444, 0.222222>
    rotate <0.0, 90.0, 0.0>
    translate  <-4.17967, -2.459395, 2.33775>
  }
  material {
    metal_txt
  }
  scale 0.2
  translate  <-0.880321, 1.986218, 7.650761>
}
union { // cabina
  object { cabina_media }
  object { phonebox }
  hollow
}




union { // bordillo
  object { TransSweep001 }
  object { // TransSweep002 -> TransSweep001
    TransSweep001
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 3.61, -0.0>
  }
  object { // TransSweep003 -> TransSweep001
    TransSweep001
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 7.22, -0.0>
  }
  object { // TransSweep004 -> TransSweep001
    TransSweep001
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 10.83, -0.0>
  }
  object { // TransSweep005 -> TransSweep001
    TransSweep001
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 14.44, -0.0>
  }
  object { // TransSweep006 -> TransSweep001
    TransSweep001
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 18.05, -0.0>
  }
  object { // TransSweep007 -> TransSweep001
    TransSweep001
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 21.66, -0.0>
  }
  object { // TransSweep008 -> TransSweep001
    TransSweep001
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 25.27, -0.0>
  }
  object { // TransSweep009 -> TransSweep001
    TransSweep001
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 28.88, -0.0>
  }
  object { // TransSweep010 -> TransSweep001
    TransSweep001
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 32.49, -0.0>
  }
  object { // TransSweep011 -> TransSweep001
    TransSweep001
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 36.1, -0.0>
  }
}


union { // baldosas_planas
  object { CSG008 }
  object { // CSG009 -> CSG008
    CSG008
    translate  0.9025*x
  }
  object { // CSG011 -> CSG008
    CSG008
    translate  -18.05*x
  }
  object { // CSG010 -> CSG008
    CSG008
    translate  -17.1475*x
  }
  object { // CSG012 -> CSG008
    CSG008
    translate  <-18.05, 37.905, 0.0>
  }
  object { // CSG013 -> CSG008
    CSG008
    translate  <-17.1475, 37.905, 0.0>
  }
}


union { // suelo_baldosas
  object { baldosa_entera }
  object { baldosa_partida }
  object { // baldosa_partida1 -> baldosa_partida
    baldosa_partida
    translate  -0.9025*x
  }
  object { // baldosa_partida2 -> baldosa_partida
    baldosa_partida
    translate  -1.805*x
  }
  object { // baldosa_partida3 -> baldosa_partida
    baldosa_partida
    translate  -2.7075*x
  }
  object { // baldosa_partida4 -> baldosa_partida
    baldosa_partida
    translate  -3.61*x
  }
  object { // baldosa_entera1 -> baldosa entera
    baldosa_entera
    translate  -0.9025*x
  }
  object { // baldosa_entera2 -> baldosa entera
    baldosa_entera
    translate  -1.805*x
  }
  object { // baldosa_entera3 -> baldosa entera
    baldosa_entera
    translate  -2.7075*x
  }
  object { // baldosa_entera4 -> baldosa entera
    baldosa_entera
    translate  -3.61*x
  }
  object { // baldosa_entera5 -> baldosa entera
    baldosa_entera
    translate  -4.5125*x
  }
  object { // baldosa_entera6 -> baldosa entera
    baldosa_entera
    translate  -5.415*x
  }
  object { // baldosa_entera7 -> baldosa entera
    baldosa_entera
    translate  5.415*x
  }
  object { // baldosa_entera8 -> baldosa entera
    baldosa_entera
    translate  <-0.9025, 18.9525, 0.0>
  }
  object { // baldosa_entera9 -> baldosa entera
    baldosa_entera
    translate  <-1.805, 18.9525, 0.0>
  }
  object { // baldosa_entera10 -> baldosa entera
    baldosa_entera
    translate  <-3.61, 18.9525, 0.0>
  }
  object { // baldosa_entera11 -> baldosa entera
    baldosa_entera
    translate  <-4.5125, 18.9525, 0.0>
  }
  object { // baldosa_entera12 -> baldosa entera
    baldosa_entera
    translate  <-5.415, 18.9525, 0.0>
  }
  object { // baldosa_entera13 -> baldosa entera
    baldosa_entera
    translate  <-2.7075, 18.9525, 0.0>
  }
  object { baldosa_entera14 }
  object { // baldosa_entera15 -> baldosa entera14
    baldosa_entera14
    translate  <-0.9025, -0.0, 0.0>
  }
  object { // baldosa_entera16 -> baldosa entera14
    baldosa_entera14
    translate  <-1.805, -0.0, 0.0>
  }
  object { // baldosa_entera17 -> baldosa entera14
    baldosa_entera14
    translate  <-2.7075, -0.0, 0.0>
  }
  object { // baldosa_entera18 -> baldosa entera14
    baldosa_entera14
    translate  <-3.61, -0.0, 0.0>
  }
  object { // baldosa_entera20 -> baldosa entera14
    baldosa_entera14
    translate  <-5.415, -0.0, 0.0>
  }
  object { // baldosa_entera19 -> baldosa entera14
    baldosa_entera14
    translate  <-4.5125, -0.0, 0.0>
  }
  object { // baldosa_entera37 -> baldosa entera
    baldosa_entera
    translate  <-4.5125, 37.905, 0.0>
  }
  object { // baldosa_entera36 -> baldosa entera
    baldosa_entera
    translate  <-5.415, 37.905, 0.0>
  }
  object { // baldosa_entera35 -> baldosa entera
    baldosa_entera
    translate  <-9.9275, 37.905, 0.0>
  }
  object { // baldosa_entera34 -> baldosa entera
    baldosa_entera
    translate  <-9.025, 37.905, 0.0>
  }
  object { // baldosa_entera33 -> baldosa entera
    baldosa_entera
    translate  <-8.1225, 37.905, 0.0>
  }
  object { // baldosa_entera32 -> baldosa entera
    baldosa_entera
    translate  <-7.22, 37.905, 0.0>
  }
  object { // baldosa_entera31 -> baldosa entera
    baldosa_entera
    translate  <-6.3175, 37.905, 0.0>
  }
  object { // baldosa_entera30 -> baldosa entera
    baldosa_entera
    translate  -9.025*x
  }
  object { // baldosa_entera29 -> baldosa entera
    baldosa_entera
    translate  -6.3175*x
  }
  object { // baldosa_entera28 -> baldosa entera
    baldosa_entera
    translate  -8.1225*x
  }
  object { // baldosa_entera27 -> baldosa entera
    baldosa_entera
    translate  -7.22*x
  }
  object { // baldosa_entera26 -> baldosa entera
    baldosa_entera
    translate  -9.9275*x
  }
  object { // baldosa_entera25 -> baldosa entera
    baldosa_entera
    translate  <-9.9275, 18.9525, 0.0>
  }
  object { // baldosa_entera24 -> baldosa entera
    baldosa_entera
    translate  <-9.025, 18.9525, 0.0>
  }
  object { // baldosa_entera23 -> baldosa entera
    baldosa_entera
    translate  <-8.1225, 18.9525, 0.0>
  }
  object { // baldosa_entera22 -> baldosa entera
    baldosa_entera
    translate  <-7.22, 18.9525, 0.0>
  }
  object { // baldosa_entera21 -> baldosa entera
    baldosa_entera
    translate  <-6.3175, 18.9525, 0.0>
  }
}


#declare tapa = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.764291, -6.989155, 0.056665>, <2.145240, -6.935871, 0.056665>, <1.317664, -6.824308, 0.056665>, <0.720905, -6.651272, 0.056665>, 
      <2.778961, -6.955047, 0.187147>, <2.159910, -6.901763, 0.187147>, <1.347002, -6.792334, 0.185199>, <0.750243, -6.619298, 0.185199>, 
      <2.764291, -6.989155, 0.373209>, <2.145240, -6.935871, 0.373209>, <1.317664, -6.824308, 0.373209>, <0.720905, -6.651272, 0.373209>, 
      <2.764291, -6.989155, 0.508870>, <2.145240, -6.935871, 0.508870>, <1.317664, -6.824308, 0.508870>, <0.720905, -6.651272, 0.508870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.702948, -7.131785, -0.036765>, <2.064875, -7.077423, -0.036765>, <1.211898, -6.963664, -0.036765>, <0.596364, -6.787006, -0.036765>, 
      <2.705902, -7.127178, -0.090851>, <2.067830, -7.072818, -0.090851>, <1.225493, -6.948848, -0.095377>, <0.609958, -6.772190, -0.095377>, 
      <2.758413, -7.002823, 0.004379>, <2.139362, -6.949538, 0.004379>, <1.304264, -6.838913, -0.002044>, <0.707504, -6.665877, -0.002044>, 
      <2.764291, -6.989155, 0.056665>, <2.145240, -6.935871, 0.056665>, <1.317664, -6.824308, 0.056665>, <0.720905, -6.651272, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.774579, 7.004686, 0.508870>, <3.371229, 7.056318, 0.508870>, <4.171967, 7.004316, 0.508870>, <4.770842, 7.001933, 0.508870>, 
      <2.774579, 7.004686, 0.373209>, <3.371229, 7.056318, 0.373209>, <4.171967, 7.004316, 0.373209>, <4.770842, 7.001933, 0.373209>, 
      <2.789171, 6.970502, 0.187136>, <3.385821, 7.022134, 0.187136>, <4.171795, 6.969945, 0.187901>, <4.770670, 6.967562, 0.187901>, 
      <2.774579, 7.004686, 0.056665>, <3.371229, 7.056318, 0.056665>, <4.171967, 7.004316, 0.056665>, <4.770842, 7.001933, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.806232, -7.002911, 0.056665>, <4.193642, -7.000366, 0.056665>, <3.374631, -7.041690, 0.056665>, <2.764291, -6.989155, 0.056665>, 
      <4.805798, -6.968538, 0.187900>, <4.193207, -6.965994, 0.187900>, <3.389300, -7.007582, 0.187147>, <2.778961, -6.955047, 0.187147>, 
      <4.806232, -7.002911, 0.373209>, <4.193642, -7.000366, 0.373209>, <3.374631, -7.041690, 0.373209>, <2.764291, -6.989155, 0.373209>, 
      <4.806232, -7.002911, 0.508870>, <4.193642, -7.000366, 0.508870>, <3.374631, -7.041690, 0.508870>, <2.764291, -6.989155, 0.508870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.808041, -7.145821, -0.036765>, <4.176504, -7.143224, -0.036765>, <3.332210, -7.185394, -0.036765>, <2.702948, -7.131785, -0.036765>, 
      <4.808490, -7.142738, -0.087896>, <4.176953, -7.140141, -0.087896>, <3.335165, -7.180789, -0.090851>, <2.705902, -7.127178, -0.090851>, 
      <4.806396, -7.015890, 0.007112>, <4.193806, -7.013345, 0.007112>, <3.368753, -7.055357, 0.004379>, <2.758413, -7.002823, 0.004379>, 
      <4.806232, -7.002911, 0.056665>, <4.193642, -7.000366, 0.056665>, <3.374631, -7.041690, 0.056665>, <2.764291, -6.989155, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.770842, 7.001933, 0.508870>, <5.346749, 6.999641, 0.508870>, <6.116786, 7.039321, 0.508870>, <6.690504, 6.989102, 0.508870>, 
      <4.770842, 7.001933, 0.373209>, <5.346749, 6.999641, 0.373209>, <6.116786, 7.039321, 0.373209>, <6.690504, 6.989102, 0.373209>, 
      <4.770670, 6.967562, 0.187901>, <5.346577, 6.965270, 0.187901>, <6.102415, 7.005202, 0.187177>, <6.676133, 6.954982, 0.187177>, 
      <4.770842, 7.001933, 0.056665>, <5.346749, 6.999641, 0.056665>, <6.116786, 7.039321, 0.056665>, <6.690504, 6.989102, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.656743, -7.005330, 0.056665>, <6.103756, -7.054331, 0.056665>, <5.361382, -7.005218, 0.056665>, <4.806232, -7.002911, 0.056665>, 
      <6.642620, -6.971134, 0.187184>, <6.089633, -7.020134, 0.187184>, <5.360947, -6.970846, 0.187900>, <4.805798, -6.968538, 0.187900>, 
      <6.656743, -7.005330, 0.373209>, <6.103756, -7.054331, 0.373209>, <5.361382, -7.005218, 0.373209>, <4.806232, -7.002911, 0.373209>, 
      <6.656743, -7.005330, 0.508870>, <6.103756, -7.054331, 0.508870>, <5.361382, -7.005218, 0.508870>, <4.806232, -7.002911, 0.508870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.715785, -7.148290, -0.036765>, <6.145650, -7.198294, -0.036765>, <5.380360, -7.148175, -0.036765>, <4.808041, -7.145821, -0.036765>, 
      <6.712176, -7.144896, -0.090748>, <6.142041, -7.194901, -0.090748>, <5.380809, -7.145093, -0.087896>, <4.808490, -7.142738, -0.087896>, 
      <6.662386, -7.018995, 0.004510>, <6.109399, -7.067995, 0.004510>, <5.361546, -7.018197, 0.007112>, <4.806396, -7.015890, 0.007112>, 
      <6.656743, -7.005330, 0.056665>, <6.103756, -7.054331, 0.056665>, <5.361382, -7.005218, 0.056665>, <4.806232, -7.002911, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.690504, 6.989102, 0.508870>, <7.321466, 6.933870, 0.508870>, <8.165542, 6.825355, 0.508870>, <8.774580, 6.651471, 0.508870>, 
      <6.690504, 6.989102, 0.373209>, <7.321466, 6.933870, 0.373209>, <8.165542, 6.825355, 0.373209>, <8.774580, 6.651471, 0.373209>, 
      <6.676133, 6.954982, 0.187177>, <7.307094, 6.899752, 0.187177>, <8.136205, 6.793377, 0.185198>, <8.745242, 6.619492, 0.185198>, 
      <6.690504, 6.989102, 0.056665>, <7.321466, 6.933870, 0.056665>, <8.165542, 6.825355, 0.056665>, <8.774580, 6.651471, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.808041, -7.145821, -0.036765>, <4.805362, -7.164214, 0.268285>, <4.800645, -7.232223, 0.726747>, <4.798139, -7.058473, 0.978154>, 
      <5.380360, -7.148175, -0.036765>, <5.377680, -7.166568, 0.268285>, <5.375616, -7.232223, 0.731285>, <5.373110, -7.058473, 0.982692>, 
      <6.145650, -7.198294, -0.036765>, <6.164486, -7.216005, 0.245016>, <6.142187, -7.264976, 0.728540>, <6.142024, -7.096286, 0.955725>, 
      <6.715785, -7.148290, -0.036765>, <6.734621, -7.166000, 0.245016>, <6.713426, -7.227162, 0.674977>, <6.713262, -7.058473, 0.902162>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.702948, -7.131785, -0.036765>, <2.688102, -7.154928, 0.235005>, <2.716334, -7.221738, 0.651678>, <2.719827, -7.058473, 0.870646>, 
      <3.332210, -7.185394, -0.036765>, <3.317364, -7.208538, 0.235005>, <3.336780, -7.261824, 0.708460>, <3.340273, -7.098558, 0.927428>, 
      <4.176504, -7.143224, -0.036765>, <4.173825, -7.161617, 0.268285>, <4.176338, -7.232223, 0.721820>, <4.173831, -7.058473, 0.973227>, 
      <4.808041, -7.145821, -0.036765>, <4.805362, -7.164214, 0.268285>, <4.800645, -7.232223, 0.726747>, <4.798139, -7.058473, 0.978154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.596364, -6.787006, -0.036765>, <0.554874, -6.832224, 0.142116>, <0.423651, -6.764926, 0.519813>, <0.596364, -6.787006, 0.593618>, 
      <1.211898, -6.963664, -0.036765>, <1.170409, -7.008882, 0.142116>, <1.015065, -6.840534, 0.772540>, <1.187778, -6.862614, 0.846344>, 
      <2.064875, -7.077423, -0.036765>, <2.050030, -7.100567, 0.235005>, <2.072781, -7.180160, 0.592782>, <2.076274, -7.016894, 0.811750>, 
      <2.702948, -7.131785, -0.036765>, <2.688102, -7.154928, 0.235005>, <2.716334, -7.221738, 0.651678>, <2.719827, -7.058473, 0.870646>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.771556, 7.144835, -0.036765>, <4.772894, 7.141683, -0.087872>, <4.770906, 7.014910, 0.007116>, <4.770842, 7.001933, 0.056665>, 
      <4.154160, 7.147267, -0.036765>, <4.155498, 7.144115, -0.087872>, <4.172032, 7.017293, 0.007116>, <4.171967, 7.004316, 0.056665>, 
      <3.328702, 7.200334, -0.036765>, <3.332346, 7.196738, -0.090931>, <3.365376, 7.070027, 0.004340>, <3.371229, 7.056318, 0.056665>, 
      <2.713553, 7.147646, -0.036765>, <2.717197, 7.144050, -0.090931>, <2.768727, 7.018396, 0.004340>, <2.774579, 7.004686, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.750590, 7.131742, -0.036765>, <6.745747, 7.127306, -0.090604>, <6.696250, 7.002742, 0.004486>, <6.690504, 6.989102, 0.056665>, 
      <6.159083, 7.182991, -0.036765>, <6.154240, 7.178554, -0.090604>, <6.122532, 7.052962, 0.004486>, <6.116786, 7.039321, 0.056665>, 
      <5.365274, 7.142497, -0.036765>, <5.366613, 7.139345, -0.087872>, <5.346814, 7.012618, 0.007116>, <5.346749, 6.999641, 0.056665>, 
      <4.771556, 7.144835, -0.036765>, <4.772894, 7.141683, -0.087872>, <4.770906, 7.014910, 0.007116>, <4.770842, 7.001933, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.899120, 6.787222, -0.036765>, <8.885526, 6.772402, -0.095380>, <8.787981, 6.666078, -0.002047>, <8.774580, 6.651471, 0.056665>, 
      <8.270930, 6.964744, -0.036765>, <8.257334, 6.949926, -0.095380>, <8.178944, 6.839962, -0.002047>, <8.165542, 6.825355, 0.056665>, 
      <7.400947, 7.075395, -0.036765>, <7.396104, 7.070958, -0.090604>, <7.327212, 6.947512, 0.004486>, <7.321466, 6.933870, 0.056665>, 
      <6.750590, 7.131742, -0.036765>, <6.745747, 7.127306, -0.090604>, <6.696250, 7.002742, 0.004486>, <6.690504, 6.989102, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.774580, 6.651471, 0.056665>, <8.993802, 6.588881, 0.056665>, <9.342794, 6.437539, 0.056665>, <9.397534, 6.216226, 0.056665>, 
      <8.745242, 6.619492, 0.185198>, <8.964464, 6.556903, 0.185198>, <9.309061, 6.407780, 0.184652>, <9.363801, 6.186467, 0.184652>, 
      <8.774580, 6.651471, 0.373209>, <8.993802, 6.588881, 0.373209>, <9.342794, 6.437539, 0.373209>, <9.397534, 6.216226, 0.373209>, 
      <8.774580, 6.651471, 0.508870>, <8.993802, 6.588881, 0.508870>, <9.342794, 6.437539, 0.508870>, <9.397534, 6.216226, 0.508870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.899120, 6.787222, -0.036765>, <9.124542, 6.723519, -0.036765>, <9.484550, 6.570355, -0.036765>, <9.541341, 6.343094, -0.036765>, 
      <8.885526, 6.772402, -0.095380>, <9.110946, 6.708700, -0.095380>, <9.468409, 6.556115, -0.097033>, <9.525200, 6.328854, -0.097033>, 
      <8.787981, 6.666078, -0.002047>, <9.007203, 6.603488, -0.002047>, <9.358706, 6.451577, -0.003710>, <9.413446, 6.230264, -0.003710>, 
      <8.774580, 6.651471, 0.056665>, <8.993802, 6.588881, 0.056665>, <9.342794, 6.437539, 0.056665>, <9.397534, 6.216226, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.899120, 6.787222, 0.593618>, <9.091786, 6.653983, 0.593618>, <9.484550, 6.570355, 0.593618>, <9.541341, 6.343094, 0.593618>, 
      <9.071060, 6.765332, 0.517973>, <9.263726, 6.632094, 0.517973>, <9.660714, 6.570355, 0.524838>, <9.717506, 6.343094, 0.524838>, 
      <8.940610, 6.832445, 0.142114>, <9.166031, 6.768742, 0.142114>, <9.532247, 6.612435, 0.141332>, <9.589039, 6.385174, 0.141332>, 
      <8.899120, 6.787222, -0.036765>, <9.124542, 6.723519, -0.036765>, <9.484550, 6.570355, -0.036765>, <9.541341, 6.343094, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.766494, 7.058723, 0.901482>, <6.763511, 7.224827, 0.673160>, <6.775802, 7.154841, 0.243523>, <6.750590, 7.131742, -0.036765>, 
      <7.413888, 7.016394, 0.841630>, <7.410906, 7.182498, 0.613309>, <7.426158, 7.098494, 0.243523>, <7.400947, 7.075395, -0.036765>, 
      <8.306761, 6.862634, 0.854225>, <8.478701, 6.840745, 0.778581>, <8.312419, 7.009968, 0.142114>, <8.270930, 6.964744, -0.036765>, 
      <8.899120, 6.787222, 0.593618>, <9.071060, 6.765332, 0.517973>, <8.940610, 6.832445, 0.142114>, <8.899120, 6.787222, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.746721, 7.058723, 0.977505>, <4.751732, 7.232246, 0.726159>, <4.763573, 7.163632, 0.268018>, <4.771556, 7.144835, -0.036765>, 
      <5.353064, 7.058723, 0.982125>, <5.358076, 7.232246, 0.730780>, <5.357291, 7.161294, 0.268018>, <5.365274, 7.142497, -0.036765>, 
      <6.163983, 7.098118, 0.957183>, <6.161001, 7.264222, 0.728862>, <6.184294, 7.206090, 0.243523>, <6.159083, 7.182991, -0.036765>, 
      <6.766494, 7.058723, 0.901482>, <6.763511, 7.224827, 0.673160>, <6.775802, 7.154841, 0.243523>, <6.750590, 7.131742, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.719827, 7.058723, 0.870646>, <2.718536, 7.224287, 0.652914>, <2.695236, 7.165724, 0.235556>, <2.713553, 7.147646, -0.036765>, 
      <3.324870, 7.098303, 0.926610>, <3.323579, 7.263867, 0.708877>, <3.310385, 7.218412, 0.235556>, <3.328702, 7.200334, -0.036765>, 
      <4.137826, 7.058723, 0.972865>, <4.142838, 7.232246, 0.721520>, <4.146176, 7.166064, 0.268018>, <4.154160, 7.147267, -0.036765>, 
      <4.746721, 7.058723, 0.977505>, <4.751732, 7.232246, 0.726159>, <4.763573, 7.163632, 0.268018>, <4.771556, 7.144835, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.596364, 6.787222, 0.593618>, <0.423652, 6.765138, 0.519813>, <0.554875, 6.832445, 0.142114>, <0.596364, 6.787222, -0.036765>, 
      <1.187779, 6.862838, 0.846344>, <1.015066, 6.840755, 0.772540>, <1.173415, 7.012790, 0.142114>, <1.214904, 6.967567, -0.036765>, 
      <2.076364, 7.016630, 0.811129>, <2.075073, 7.182194, 0.593396>, <2.053292, 7.110740, 0.235556>, <2.071609, 7.092662, -0.036765>, 
      <2.719827, 7.058723, 0.870646>, <2.718536, 7.224287, 0.652914>, <2.695236, 7.165724, 0.235556>, <2.713553, 7.147646, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.720906, 6.651471, 0.056665>, <1.320577, 6.828118, 0.056665>, <2.151758, 6.950790, 0.056665>, <2.774579, 7.004686, 0.056665>, 
      <0.707505, 6.666078, -0.002047>, <1.307176, 6.842725, -0.002047>, <2.145906, 6.964500, 0.004340>, <2.768727, 7.018396, 0.004340>, 
      <0.609960, 6.772402, -0.095380>, <1.228499, 6.952748, -0.095380>, <2.075253, 7.089066, -0.090931>, <2.717197, 7.144050, -0.090931>, 
      <0.596364, 6.787222, -0.036765>, <1.214904, 6.967567, -0.036765>, <2.071609, 7.092662, -0.036765>, <2.713553, 7.147646, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.720906, 6.651471, 0.508870>, <1.320577, 6.828118, 0.508870>, <2.151758, 6.950790, 0.508870>, <2.774579, 7.004686, 0.508870>, 
      <0.720906, 6.651471, 0.373209>, <1.320577, 6.828118, 0.373209>, <2.151758, 6.950790, 0.373209>, <2.774579, 7.004686, 0.373209>, 
      <0.750243, 6.619492, 0.185198>, <1.349915, 6.796139, 0.185198>, <2.166351, 6.916606, 0.187136>, <2.789171, 6.970502, 0.187136>, 
      <0.720906, 6.651471, 0.056665>, <1.320577, 6.828118, 0.056665>, <2.151758, 6.950790, 0.056665>, <2.774579, 7.004686, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.397534, 6.216226, 0.056665>, <9.547601, 5.609508, 0.056665>, <9.397534, 4.757889, 0.056665>, <9.397534, 4.132888, 0.056665>, 
      <9.363801, 6.186467, 0.184652>, <9.513868, 5.579749, 0.184652>, <9.363339, 4.737832, 0.186406>, <9.363339, 4.112831, 0.186406>, 
      <9.397534, 6.216226, 0.373209>, <9.547601, 5.609508, 0.373209>, <9.397534, 4.757889, 0.373209>, <9.397534, 4.132888, 0.373209>, 
      <9.397534, 6.216226, 0.508870>, <9.547601, 5.609508, 0.508870>, <9.397534, 4.757889, 0.508870>, <9.397534, 4.132888, 0.508870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, 6.343094, -0.036765>, <9.695957, 5.724364, -0.036765>, <9.541341, 4.854996, -0.036765>, <9.541341, 4.217239, -0.036765>, 
      <9.525200, 6.328854, -0.097033>, <9.679816, 5.710124, -0.097033>, <9.526676, 4.846394, -0.091521>, <9.526676, 4.208637, -0.091521>, 
      <9.413446, 6.230264, -0.003710>, <9.563514, 5.623546, -0.003710>, <9.411985, 4.766366, 0.001833>, <9.411985, 4.141364, 0.001833>, 
      <9.397534, 6.216226, 0.056665>, <9.547601, 5.609508, 0.056665>, <9.397534, 4.757889, 0.056665>, <9.397534, 4.132888, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, 6.343094, 0.593618>, <9.695957, 5.724364, 0.593618>, <9.541341, 4.854996, 0.593618>, <9.541341, 4.217239, 0.593618>, 
      <9.717506, 6.343094, 0.524838>, <9.872122, 5.724364, 0.524838>, <9.717572, 4.854996, 0.525011>, <9.717572, 4.217239, 0.525011>, 
      <9.589039, 6.385174, 0.141332>, <9.743655, 5.766444, 0.141332>, <9.589712, 4.883368, 0.143844>, <9.589712, 4.245611, 0.143844>, 
      <9.541341, 6.343094, -0.036765>, <9.695957, 5.724364, -0.036765>, <9.541341, 4.854996, -0.036765>, <9.541341, 4.217239, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.748404, 6.343094, 1.124544>, <4.747654, 6.561974, 1.113211>, <4.743126, 6.934219, 1.157847>, <4.746721, 7.058723, 0.977505>, 
      <5.353740, 6.343094, 1.128434>, <5.352990, 6.561974, 1.117101>, <5.349469, 6.934219, 1.162467>, <5.353064, 7.058723, 0.982125>, 
      <6.163084, 6.343094, 1.113936>, <6.163860, 6.561905, 1.102701>, <6.166298, 6.969230, 1.134348>, <6.163983, 7.098118, 0.957183>, 
      <6.764752, 6.343094, 1.047288>, <6.765529, 6.561905, 1.036052>, <6.768808, 6.929835, 1.078647>, <6.766494, 7.058723, 0.901482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.719827, 6.343094, 1.021298>, <2.719827, 6.562181, 1.009683>, <2.720863, 6.925929, 1.045284>, <2.719827, 7.058723, 0.870646>, 
      <3.325485, 6.343094, 1.088370>, <3.325485, 6.562181, 1.076755>, <3.325905, 6.965509, 1.101248>, <3.324870, 7.098303, 0.926610>, 
      <4.139056, 6.343094, 1.120629>, <4.138306, 6.561974, 1.109296>, <4.134231, 6.934219, 1.153207>, <4.137826, 7.058723, 0.972865>, 
      <4.748404, 6.343094, 1.124544>, <4.747654, 6.561974, 1.113211>, <4.743126, 6.934219, 1.157847>, <4.746721, 7.058723, 0.977505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045856, 6.343094, 0.593618>, <0.010935, 6.570355, 0.593618>, <0.403699, 6.653983, 0.593618>, <0.596364, 6.787222, 0.593618>, 
      <0.738287, 6.343094, 0.893606>, <0.795078, 6.570355, 0.893606>, <0.995113, 6.729600, 0.846344>, <1.187779, 6.862838, 0.846344>, 
      <1.885362, 6.343094, 0.928888>, <1.885362, 6.562181, 0.917272>, <2.077399, 6.883835, 0.985767>, <2.076364, 7.016630, 0.811129>, 
      <2.719827, 6.343094, 1.021298>, <2.719827, 6.562181, 1.009683>, <2.720863, 6.925929, 1.045284>, <2.719827, 7.058723, 0.870646>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097952, 6.216226, 0.056665>, <0.152692, 6.437539, 0.056665>, <0.502215, 6.587050, 0.056665>, <0.720906, 6.651471, 0.056665>, 
      <0.082040, 6.230264, -0.003710>, <0.136780, 6.451577, -0.003710>, <0.488813, 6.601658, -0.002047>, <0.707505, 6.666078, -0.002047>, 
      <-0.029715, 6.328854, -0.097033>, <0.027076, 6.556115, -0.097033>, <0.385074, 6.706834, -0.095380>, <0.609960, 6.772402, -0.095380>, 
      <-0.045856, 6.343094, -0.036765>, <0.010935, 6.570355, -0.036765>, <0.371479, 6.721653, -0.036765>, <0.596364, 6.787222, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097952, 6.216226, 0.508870>, <0.152692, 6.437539, 0.508870>, <0.502215, 6.587050, 0.508870>, <0.720906, 6.651471, 0.508870>, 
      <0.097952, 6.216226, 0.373209>, <0.152692, 6.437539, 0.373209>, <0.502215, 6.587050, 0.373209>, <0.720906, 6.651471, 0.373209>, 
      <0.131685, 6.186467, 0.184652>, <0.186425, 6.407780, 0.184652>, <0.531552, 6.555072, 0.185198>, <0.750243, 6.619492, 0.185198>, 
      <0.097952, 6.216226, 0.056665>, <0.152692, 6.437539, 0.056665>, <0.502215, 6.587050, 0.056665>, <0.720906, 6.651471, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.397534, 4.132888, 0.056665>, <9.397534, 3.507886, 0.056665>, <9.397534, 2.674551, 0.056665>, <9.397534, 2.049550, 0.056665>, 
      <9.363339, 4.112831, 0.186406>, <9.363339, 3.487830, 0.186406>, <9.363054, 2.664521, 0.187488>, <9.363054, 2.039520, 0.187488>, 
      <9.397534, 4.132888, 0.373209>, <9.397534, 3.507886, 0.373209>, <9.397534, 2.674551, 0.373209>, <9.397534, 2.049550, 0.373209>, 
      <9.397534, 4.132888, 0.508870>, <9.397534, 3.507886, 0.508870>, <9.397534, 2.674551, 0.508870>, <9.397534, 2.049550, 0.508870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, 4.217239, -0.036765>, <9.541341, 3.579482, -0.036765>, <9.541341, 2.729141, -0.036765>, <9.541341, 2.091384, -0.036765>, 
      <9.526676, 4.208637, -0.091521>, <9.526676, 3.570881, -0.091521>, <9.527679, 2.725167, -0.087775>, <9.527679, 2.087410, -0.087775>, 
      <9.411985, 4.141364, 0.001833>, <9.411985, 3.516363, 0.001833>, <9.410993, 2.678467, 0.005598>, <9.410993, 2.053466, 0.005598>, 
      <9.397534, 4.132888, 0.056665>, <9.397534, 3.507886, 0.056665>, <9.397534, 2.674551, 0.056665>, <9.397534, 2.049550, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, 4.217239, 0.593618>, <9.541341, 3.579482, 0.593618>, <9.541341, 2.729141, 0.593618>, <9.541341, 2.091384, 0.593618>, 
      <9.717572, 4.217239, 0.525011>, <9.717572, 3.579482, 0.525011>, <9.717639, 2.729141, 0.525183>, <9.717639, 2.091384, 0.525183>, 
      <9.589712, 4.245611, 0.143844>, <9.589712, 3.607855, 0.143844>, <9.590128, 2.743333, 0.145396>, <9.590128, 2.105577, 0.145396>, 
      <9.541341, 4.217239, -0.036765>, <9.541341, 3.579482, -0.036765>, <9.541341, 2.729141, -0.036765>, <9.541341, 2.091384, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.756456, 4.217239, 1.124628>, <4.754040, 4.854996, 1.124603>, <4.750586, 5.706190, 1.157521>, <4.748404, 6.343094, 1.124544>, 
      <5.356879, 4.217239, 1.128510>, <5.354463, 4.854996, 1.128484>, <5.355922, 5.706190, 1.161411>, <5.353740, 6.343094, 1.128434>, 
      <6.159644, 4.217239, 1.113620>, <6.162145, 4.854996, 1.113589>, <6.160825, 5.706176, 1.146642>, <6.163084, 6.343094, 1.113936>, 
      <6.756416, 4.217239, 1.047393>, <6.758917, 4.854996, 1.047361>, <6.762494, 5.706176, 1.079994>, <6.764752, 6.343094, 1.047288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.719827, 4.217239, 1.021298>, <2.719827, 4.854996, 1.021298>, <2.719827, 5.706232, 1.055064>, <2.719827, 6.343094, 1.021298>, 
      <3.327896, 4.217239, 1.088535>, <3.327896, 4.854996, 1.088535>, <3.325485, 5.706232, 1.122136>, <3.325485, 6.343094, 1.088370>, 
      <4.144694, 4.217239, 1.120673>, <4.142279, 4.854996, 1.120648>, <4.141238, 5.706190, 1.153606>, <4.139056, 6.343094, 1.120629>, 
      <4.756456, 4.217239, 1.124628>, <4.754040, 4.854996, 1.124603>, <4.750586, 5.706190, 1.157521>, <4.748404, 6.343094, 1.124544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045856, 4.217239, 0.593618>, <-0.045856, 4.854996, 0.593618>, <-0.200472, 5.724364, 0.593618>, <-0.045856, 6.343094, 0.593618>, 
      <0.738287, 4.217239, 0.893606>, <0.738287, 4.854996, 0.893606>, <0.583671, 5.724364, 0.893606>, <0.738287, 6.343094, 0.893606>, 
      <1.885347, 4.217239, 0.929026>, <1.885347, 4.854996, 0.929026>, <1.885362, 5.706232, 0.962654>, <1.885362, 6.343094, 0.928888>, 
      <2.719827, 4.217239, 1.021298>, <2.719827, 4.854996, 1.021298>, <2.719827, 5.706232, 1.055064>, <2.719827, 6.343094, 1.021298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097952, 4.132888, 0.056665>, <0.097952, 4.757889, 0.056665>, <-0.052115, 5.609508, 0.056665>, <0.097952, 6.216226, 0.056665>, 
      <0.083501, 4.141364, 0.001833>, <0.083501, 4.766366, 0.001833>, <-0.068028, 5.623546, -0.003710>, <0.082040, 6.230264, -0.003710>, 
      <-0.031191, 4.208637, -0.091521>, <-0.031191, 4.846394, -0.091521>, <-0.184331, 5.710124, -0.097033>, <-0.029715, 6.328854, -0.097033>, 
      <-0.045856, 4.217239, -0.036765>, <-0.045856, 4.854996, -0.036765>, <-0.200472, 5.724364, -0.036765>, <-0.045856, 6.343094, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097952, 4.132888, 0.508870>, <0.097952, 4.757889, 0.508870>, <-0.052115, 5.609508, 0.508870>, <0.097952, 6.216226, 0.508870>, 
      <0.097952, 4.132888, 0.373209>, <0.097952, 4.757889, 0.373209>, <-0.052115, 5.609508, 0.373209>, <0.097952, 6.216226, 0.373209>, 
      <0.132147, 4.112831, 0.186406>, <0.132147, 4.737832, 0.186406>, <-0.018383, 5.579749, 0.184652>, <0.131685, 6.186467, 0.184652>, 
      <0.097952, 4.132888, 0.056665>, <0.097952, 4.757889, 0.056665>, <-0.052115, 5.609508, 0.056665>, <0.097952, 6.216226, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.397534, 2.049550, 0.056665>, <9.397534, 1.424549, 0.056665>, <9.397534, 0.591214, 0.056665>, <9.397534, -0.033788, 0.056665>, 
      <9.363054, 2.039520, 0.187488>, <9.363054, 1.414519, 0.187488>, <9.362959, 0.591378, 0.187847>, <9.362959, -0.033624, 0.187847>, 
      <9.397534, 2.049550, 0.373209>, <9.397534, 1.424549, 0.373209>, <9.397534, 0.591214, 0.373209>, <9.397534, -0.033788, 0.373209>, 
      <9.397534, 2.049550, 0.508870>, <9.397534, 1.424549, 0.508870>, <9.397534, 0.591214, 0.508870>, <9.397534, -0.033788, 0.508870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, 2.091384, -0.036765>, <9.541341, 1.453628, -0.036765>, <9.541341, 0.603286, -0.036765>, <9.541341, -0.034471, -0.036765>, 
      <9.527679, 2.087410, -0.087775>, <9.527679, 1.449654, -0.087775>, <9.528031, 0.603349, -0.086462>, <9.528031, -0.034408, -0.086462>, 
      <9.410993, 2.053466, 0.005598>, <9.410993, 1.428464, 0.005598>, <9.410646, 0.591151, 0.006916>, <9.410646, -0.033850, 0.006916>, 
      <9.397534, 2.049550, 0.056665>, <9.397534, 1.424549, 0.056665>, <9.397534, 0.591214, 0.056665>, <9.397534, -0.033788, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, 2.091384, 0.593618>, <9.541341, 1.453628, 0.593618>, <9.541341, 0.603286, 0.593618>, <9.541341, -0.034471, 0.593618>, 
      <9.717639, 2.091384, 0.525183>, <9.717639, 1.453628, 0.525183>, <9.717706, 0.603286, 0.525355>, <9.717706, -0.034471, 0.525355>, 
      <9.590128, 2.105577, 0.145396>, <9.590128, 1.467820, 0.145396>, <9.590266, 0.603054, 0.145911>, <9.590266, -0.034703, 0.145911>, 
      <9.541341, 2.091384, -0.036765>, <9.541341, 1.453628, -0.036765>, <9.541341, 0.603286, -0.036765>, <9.541341, -0.034471, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.764508, 2.091384, 1.124713>, <4.762092, 2.729141, 1.124687>, <4.758872, 3.579482, 1.124653>, <4.756456, 4.217239, 1.124628>, 
      <5.360018, 2.091384, 1.128586>, <5.357602, 2.729141, 1.128561>, <5.359294, 3.579482, 1.128535>, <5.356879, 4.217239, 1.128510>, 
      <6.156204, 2.091384, 1.113305>, <6.158705, 2.729141, 1.113273>, <6.157143, 3.579482, 1.113652>, <6.159644, 4.217239, 1.113620>, 
      <6.748079, 2.091384, 1.047500>, <6.750580, 2.729141, 1.047468>, <6.753915, 3.579482, 1.047425>, <6.756416, 4.217239, 1.047393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.719827, 2.091384, 1.021298>, <2.719827, 2.729141, 1.021298>, <2.719827, 3.579482, 1.021298>, <2.719827, 4.217239, 1.021298>, 
      <3.330306, 2.091384, 1.088699>, <3.330306, 2.729141, 1.088699>, <3.327896, 3.579482, 1.088535>, <3.327896, 4.217239, 1.088535>, 
      <4.150333, 2.091384, 1.120718>, <4.147917, 2.729141, 1.120693>, <4.147110, 3.579482, 1.120699>, <4.144694, 4.217239, 1.120673>, 
      <4.764508, 2.091384, 1.124713>, <4.762092, 2.729141, 1.124687>, <4.758872, 3.579482, 1.124653>, <4.756456, 4.217239, 1.124628>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045856, 2.091384, 0.593618>, <-0.045856, 2.729141, 0.593618>, <-0.045856, 3.579482, 0.593618>, <-0.045856, 4.217239, 0.593618>, 
      <0.738287, 2.091384, 0.893606>, <0.738287, 2.729141, 0.893606>, <0.738287, 3.579482, 0.893606>, <0.738287, 4.217239, 0.893606>, 
      <1.885331, 2.091384, 0.929165>, <1.885331, 2.729141, 0.929165>, <1.885347, 3.579482, 0.929026>, <1.885347, 4.217239, 0.929026>, 
      <2.719827, 2.091384, 1.021298>, <2.719827, 2.729141, 1.021298>, <2.719827, 3.579482, 1.021298>, <2.719827, 4.217239, 1.021298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097952, 2.049550, 0.056665>, <0.097952, 2.674551, 0.056665>, <0.097952, 3.507886, 0.056665>, <0.097952, 4.132888, 0.056665>, 
      <0.084493, 2.053466, 0.005598>, <0.084493, 2.678467, 0.005598>, <0.083501, 3.516363, 0.001833>, <0.083501, 4.141364, 0.001833>, 
      <-0.032194, 2.087410, -0.087775>, <-0.032194, 2.725167, -0.087775>, <-0.031191, 3.570881, -0.091521>, <-0.031191, 4.208637, -0.091521>, 
      <-0.045856, 2.091384, -0.036765>, <-0.045856, 2.729141, -0.036765>, <-0.045856, 3.579482, -0.036765>, <-0.045856, 4.217239, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097952, 2.049550, 0.508870>, <0.097952, 2.674551, 0.508870>, <0.097952, 3.507886, 0.508870>, <0.097952, 4.132888, 0.508870>, 
      <0.097952, 2.049550, 0.373209>, <0.097952, 2.674551, 0.373209>, <0.097952, 3.507886, 0.373209>, <0.097952, 4.132888, 0.373209>, 
      <0.132432, 2.039520, 0.187488>, <0.132432, 2.664521, 0.187488>, <0.132147, 3.487830, 0.186406>, <0.132147, 4.112831, 0.186406>, 
      <0.097952, 2.049550, 0.056665>, <0.097952, 2.674551, 0.056665>, <0.097952, 3.507886, 0.056665>, <0.097952, 4.132888, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.397534, -0.033788, 0.056665>, <9.397534, -0.635641, 0.056665>, <9.397534, -1.438112, 0.056665>, <9.397534, -2.039965, 0.056665>, 
      <9.362959, -0.033624, 0.187847>, <9.362959, -0.635477, 0.187847>, <9.363054, -1.428132, 0.187492>, <9.363054, -2.029985, 0.187492>, 
      <9.397534, -0.033788, 0.373209>, <9.397534, -0.635641, 0.373209>, <9.397534, -1.438112, 0.373209>, <9.397534, -2.039965, 0.373209>, 
      <9.397534, -0.033788, 0.508870>, <9.397534, -0.635641, 0.508870>, <9.397534, -1.438112, 0.508870>, <9.397534, -2.039965, 0.508870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, -0.034471, -0.036765>, <9.541341, -0.648607, -0.036765>, <9.541341, -1.467454, -0.036765>, <9.541341, -2.081590, -0.036765>, 
      <9.528031, -0.034408, -0.086462>, <9.528031, -0.648544, -0.086462>, <9.527683, -1.463501, -0.087762>, <9.527683, -2.077637, -0.087762>, 
      <9.410646, -0.033850, 0.006916>, <9.410646, -0.635703, 0.006916>, <9.410990, -1.442007, 0.005611>, <9.410990, -2.043860, 0.005611>, 
      <9.397534, -0.033788, 0.056665>, <9.397534, -0.635641, 0.056665>, <9.397534, -1.438112, 0.056665>, <9.397534, -2.039965, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, -0.034471, 0.593618>, <9.541341, -0.648607, 0.593618>, <9.541341, -1.467454, 0.593618>, <9.541341, -2.081590, 0.593618>, 
      <9.717706, -0.034471, 0.525355>, <9.717706, -0.648607, 0.525355>, <9.717769, -1.467454, 0.525519>, <9.717769, -2.081590, 0.525519>, 
      <9.590266, -0.034703, 0.145911>, <9.590266, -0.648839, 0.145911>, <9.590129, -1.481576, 0.145401>, <9.590129, -2.095712, 0.145401>, 
      <9.541341, -0.034471, -0.036765>, <9.541341, -0.648607, -0.036765>, <9.541341, -1.467454, -0.036765>, <9.541341, -2.081590, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.772561, -0.034471, 1.124798>, <4.770146, 0.603286, 1.124772>, <4.766924, 1.453628, 1.124739>, <4.764508, 2.091384, 1.124713>, 
      <5.363157, -0.034471, 1.128663>, <5.360741, 0.603286, 1.128638>, <5.362434, 1.453628, 1.128612>, <5.360018, 2.091384, 1.128586>, 
      <6.152764, -0.034471, 1.112988>, <6.155265, 0.603286, 1.112956>, <6.153703, 1.453628, 1.113337>, <6.156204, 2.091384, 1.113305>, 
      <6.739742, -0.034471, 1.047607>, <6.742243, 0.603286, 1.047574>, <6.745578, 1.453628, 1.047532>, <6.748079, 2.091384, 1.047500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.719827, -0.034471, 1.021298>, <2.719827, 0.603286, 1.021298>, <2.719827, 1.453628, 1.021298>, <2.719827, 2.091384, 1.021298>, 
      <3.332717, -0.034471, 1.088863>, <3.332717, 0.603286, 1.088863>, <3.330306, 1.453628, 1.088699>, <3.330306, 2.091384, 1.088699>, 
      <4.155972, -0.034471, 1.120763>, <4.153556, 0.603286, 1.120737>, <4.152748, 1.453628, 1.120744>, <4.150333, 2.091384, 1.120718>, 
      <4.772561, -0.034471, 1.124798>, <4.770146, 0.603286, 1.124772>, <4.766924, 1.453628, 1.124739>, <4.764508, 2.091384, 1.124713>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045856, -0.034471, 0.593618>, <-0.045856, 0.603286, 0.593618>, <-0.045856, 1.453628, 0.593618>, <-0.045856, 2.091384, 0.593618>, 
      <0.738287, -0.034471, 0.893606>, <0.738287, 0.603286, 0.893606>, <0.738287, 1.453628, 0.893606>, <0.738287, 2.091384, 0.893606>, 
      <1.885316, -0.034471, 0.929302>, <1.885316, 0.603286, 0.929302>, <1.885331, 1.453628, 0.929165>, <1.885331, 2.091384, 0.929165>, 
      <2.719827, -0.034471, 1.021298>, <2.719827, 0.603286, 1.021298>, <2.719827, 1.453628, 1.021298>, <2.719827, 2.091384, 1.021298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097952, -0.033788, 0.056665>, <0.097952, 0.591214, 0.056665>, <0.097952, 1.424549, 0.056665>, <0.097952, 2.049550, 0.056665>, 
      <0.084840, -0.033850, 0.006916>, <0.084840, 0.591151, 0.006916>, <0.084493, 1.428464, 0.005598>, <0.084493, 2.053466, 0.005598>, 
      <-0.032546, -0.034408, -0.086462>, <-0.032546, 0.603349, -0.086462>, <-0.032194, 1.449654, -0.087775>, <-0.032194, 2.087410, -0.087775>, 
      <-0.045856, -0.034471, -0.036765>, <-0.045856, 0.603286, -0.036765>, <-0.045856, 1.453628, -0.036765>, <-0.045856, 2.091384, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097952, -0.033788, 0.508870>, <0.097952, 0.591214, 0.508870>, <0.097952, 1.424549, 0.508870>, <0.097952, 2.049550, 0.508870>, 
      <0.097952, -0.033788, 0.373209>, <0.097952, 0.591214, 0.373209>, <0.097952, 1.424549, 0.373209>, <0.097952, 2.049550, 0.373209>, 
      <0.132527, -0.033624, 0.187847>, <0.132527, 0.591378, 0.187847>, <0.132432, 1.414519, 0.187488>, <0.132432, 2.039520, 0.187488>, 
      <0.097952, -0.033788, 0.056665>, <0.097952, 0.591214, 0.056665>, <0.097952, 1.424549, 0.056665>, <0.097952, 2.049550, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.397534, -2.039965, 0.056665>, <9.397534, -2.641819, 0.056665>, <9.397534, -3.444289, 0.056665>, <9.397534, -4.046142, 0.056665>, 
      <9.363054, -2.029985, 0.187492>, <9.363054, -2.631838, 0.187492>, <9.363323, -3.424647, 0.186465>, <9.363323, -4.026501, 0.186465>, 
      <9.397534, -2.039965, 0.373209>, <9.397534, -2.641819, 0.373209>, <9.397534, -3.444289, 0.373209>, <9.397534, -4.046142, 0.373209>, 
      <9.397534, -2.039965, 0.508870>, <9.397534, -2.641819, 0.508870>, <9.397534, -3.444289, 0.508870>, <9.397534, -4.046142, 0.508870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, -2.081590, -0.036765>, <9.541341, -2.695726, -0.036765>, <9.541341, -3.514574, -0.036765>, <9.541341, -4.128710, -0.036765>, 
      <9.527683, -2.077637, -0.087762>, <9.527683, -2.691773, -0.087762>, <9.526729, -3.506185, -0.091323>, <9.526729, -4.120321, -0.091323>, 
      <9.410990, -2.043860, 0.005611>, <9.410990, -2.645713, 0.005611>, <9.411933, -3.452557, 0.002032>, <9.411933, -4.054410, 0.002032>, 
      <9.397534, -2.039965, 0.056665>, <9.397534, -2.641819, 0.056665>, <9.397534, -3.444289, 0.056665>, <9.397534, -4.046142, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, -2.081590, 0.593618>, <9.541341, -2.695726, 0.593618>, <9.541341, -3.514574, 0.593618>, <9.541341, -4.128710, 0.593618>, 
      <9.717769, -2.081590, 0.525519>, <9.717769, -2.695726, 0.525519>, <9.717832, -3.514574, 0.525682>, <9.717832, -4.128710, 0.525682>, 
      <9.590129, -2.095712, 0.145401>, <9.590129, -2.709848, 0.145401>, <9.589735, -3.542360, 0.143929>, <9.589735, -4.156496, 0.143929>, 
      <9.541341, -2.081590, -0.036765>, <9.541341, -2.695726, -0.036765>, <9.541341, -3.514574, -0.036765>, <9.541341, -4.128710, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.780315, -2.081590, 1.124879>, <4.777989, -1.467454, 1.124855>, <4.774888, -0.648607, 1.124822>, <4.772561, -0.034471, 1.124798>, 
      <5.366180, -2.081590, 1.128736>, <5.363854, -1.467454, 1.128712>, <5.365483, -0.648607, 1.128687>, <5.363157, -0.034471, 1.128663>, 
      <6.149451, -2.081590, 1.112683>, <6.151859, -1.467455, 1.112652>, <6.150355, -0.648607, 1.113019>, <6.152764, -0.034471, 1.112988>, 
      <6.731714, -2.081590, 1.047711>, <6.734122, -1.467455, 1.047680>, <6.737334, -0.648607, 1.047638>, <6.739742, -0.034471, 1.047607>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.719827, -2.081590, 1.021298>, <2.719827, -1.467454, 1.021298>, <2.719827, -0.648607, 1.021298>, <2.719827, -0.034471, 1.021298>, 
      <3.335038, -2.081590, 1.089020>, <3.335038, -1.467454, 1.089020>, <3.332717, -0.648607, 1.088863>, <3.332717, -0.034471, 1.088863>, 
      <4.161401, -2.081590, 1.120804>, <4.159075, -1.467454, 1.120780>, <4.158298, -0.648607, 1.120787>, <4.155972, -0.034471, 1.120763>, 
      <4.780315, -2.081590, 1.124879>, <4.777989, -1.467454, 1.124855>, <4.774888, -0.648607, 1.124822>, <4.772561, -0.034471, 1.124798>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045856, -2.081590, 0.593618>, <-0.045856, -1.467454, 0.593618>, <-0.045856, -0.648607, 0.593618>, <-0.045856, -0.034471, 0.593618>, 
      <0.738287, -2.081590, 0.893606>, <0.738287, -1.467454, 0.893606>, <0.738287, -0.648607, 0.893606>, <0.738287, -0.034471, 0.893606>, 
      <1.885302, -2.081590, 0.929434>, <1.885302, -1.467454, 0.929434>, <1.885316, -0.648607, 0.929302>, <1.885316, -0.034471, 0.929302>, 
      <2.719827, -2.081590, 1.021298>, <2.719827, -1.467454, 1.021298>, <2.719827, -0.648607, 1.021298>, <2.719827, -0.034471, 1.021298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097952, -2.039965, 0.056665>, <0.097952, -1.438112, 0.056665>, <0.097952, -0.635641, 0.056665>, <0.097952, -0.033788, 0.056665>, 
      <0.084496, -2.043860, 0.005611>, <0.084496, -1.442007, 0.005611>, <0.084840, -0.635703, 0.006916>, <0.084840, -0.033850, 0.006916>, 
      <-0.032197, -2.077637, -0.087762>, <-0.032197, -1.463501, -0.087762>, <-0.032546, -0.648544, -0.086462>, <-0.032546, -0.034408, -0.086462>, 
      <-0.045856, -2.081590, -0.036765>, <-0.045856, -1.467454, -0.036765>, <-0.045856, -0.648607, -0.036765>, <-0.045856, -0.034471, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097952, -2.039965, 0.508870>, <0.097952, -1.438112, 0.508870>, <0.097952, -0.635641, 0.508870>, <0.097952, -0.033788, 0.508870>, 
      <0.097952, -2.039965, 0.373209>, <0.097952, -1.438112, 0.373209>, <0.097952, -0.635641, 0.373209>, <0.097952, -0.033788, 0.373209>, 
      <0.132433, -2.029985, 0.187492>, <0.132433, -1.428132, 0.187492>, <0.132527, -0.635477, 0.187847>, <0.132527, -0.033624, 0.187847>, 
      <0.097952, -2.039965, 0.056665>, <0.097952, -1.438112, 0.056665>, <0.097952, -0.635641, 0.056665>, <0.097952, -0.033788, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.397534, -4.046142, 0.056665>, <9.397534, -4.697108, 0.056665>, <9.548927, -5.582912, 0.056665>, <9.397534, -6.216028, 0.056665>, 
      <9.363323, -4.026501, 0.186465>, <9.363323, -4.677466, 0.186465>, <9.515195, -5.553157, 0.184653>, <9.363801, -6.186273, 0.184653>, 
      <9.397534, -4.046142, 0.373209>, <9.397534, -4.697108, 0.373209>, <9.548927, -5.582912, 0.373209>, <9.397534, -6.216028, 0.373209>, 
      <9.397534, -4.046142, 0.508870>, <9.397534, -4.697108, 0.508870>, <9.548927, -5.582912, 0.508870>, <9.397534, -6.216028, 0.508870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, -4.128710, -0.036765>, <9.541341, -4.792961, -0.036765>, <9.697330, -5.697204, -0.036765>, <9.541341, -6.342879, -0.036765>, 
      <9.526729, -4.120321, -0.091323>, <9.526729, -4.784572, -0.091323>, <9.681190, -5.682967, -0.097030>, <9.525201, -6.328642, -0.097030>, 
      <9.411933, -4.054410, 0.002032>, <9.411933, -4.705376, 0.002032>, <9.564839, -5.596948, -0.003708>, <9.413446, -6.230064, -0.003708>, 
      <9.397534, -4.046142, 0.056665>, <9.397534, -4.697108, 0.056665>, <9.548927, -5.582912, 0.056665>, <9.397534, -6.216028, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, -4.128710, 0.593618>, <9.541341, -4.792961, 0.593618>, <9.697330, -5.697204, 0.593618>, <9.541341, -6.342879, 0.593618>, 
      <9.717832, -4.128710, 0.525682>, <9.717832, -4.792961, 0.525682>, <9.873888, -5.697204, 0.525857>, <9.717899, -6.342879, 0.525857>, 
      <9.589735, -4.156496, 0.143929>, <9.589735, -4.820747, 0.143929>, <9.745029, -5.739278, 0.141333>, <9.589040, -6.384954, 0.141333>, 
      <9.541341, -4.128710, -0.036765>, <9.541341, -4.792961, -0.036765>, <9.697330, -5.697204, -0.036765>, <9.541341, -6.342879, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.788069, -4.128710, 1.124960>, <4.785743, -3.514574, 1.124936>, <4.782641, -2.695726, 1.124903>, <4.780315, -2.081590, 1.124879>, 
      <5.369203, -4.128710, 1.128809>, <5.366876, -3.514574, 1.128784>, <5.368506, -2.695726, 1.128760>, <5.366180, -2.081590, 1.128736>, 
      <6.146138, -4.128710, 1.112377>, <6.148546, -3.514574, 1.112346>, <6.147042, -2.695726, 1.112715>, <6.149451, -2.081590, 1.112683>, 
      <6.723686, -4.128710, 1.047816>, <6.726095, -3.514574, 1.047785>, <6.729306, -2.695726, 1.047743>, <6.731714, -2.081590, 1.047711>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.719827, -4.128710, 1.021298>, <2.719827, -3.514574, 1.021298>, <2.719827, -2.695726, 1.021298>, <2.719827, -2.081590, 1.021298>, 
      <3.337359, -4.128710, 1.089177>, <3.337359, -3.514574, 1.089177>, <3.335038, -2.695726, 1.089020>, <3.335038, -2.081590, 1.089020>, 
      <4.166832, -4.128710, 1.120845>, <4.164505, -3.514574, 1.120821>, <4.163727, -2.695726, 1.120829>, <4.161401, -2.081590, 1.120804>, 
      <4.788069, -4.128710, 1.124960>, <4.785743, -3.514574, 1.124936>, <4.782641, -2.695726, 1.124903>, <4.780315, -2.081590, 1.124879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045856, -4.128710, 0.593618>, <-0.045856, -3.514574, 0.593618>, <-0.045856, -2.695726, 0.593618>, <-0.045856, -2.081590, 0.593618>, 
      <0.738287, -4.128710, 0.893606>, <0.738287, -3.514574, 0.893606>, <0.738287, -2.695726, 0.893606>, <0.738287, -2.081590, 0.893606>, 
      <1.885287, -4.128710, 0.929566>, <1.885287, -3.514574, 0.929566>, <1.885302, -2.695726, 0.929434>, <1.885302, -2.081590, 0.929434>, 
      <2.719827, -4.128710, 1.021298>, <2.719827, -3.514574, 1.021298>, <2.719827, -2.695726, 1.021298>, <2.719827, -2.081590, 1.021298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097952, -4.046142, 0.056665>, <0.097952, -3.444289, 0.056665>, <0.097952, -2.641819, 0.056665>, <0.097952, -2.039965, 0.056665>, 
      <0.083553, -4.054410, 0.002032>, <0.083553, -3.452557, 0.002032>, <0.084496, -2.645713, 0.005611>, <0.084496, -2.043860, 0.005611>, 
      <-0.031244, -4.120321, -0.091323>, <-0.031244, -3.506185, -0.091323>, <-0.032197, -2.691773, -0.087762>, <-0.032197, -2.077637, -0.087762>, 
      <-0.045856, -4.128710, -0.036765>, <-0.045856, -3.514574, -0.036765>, <-0.045856, -2.695726, -0.036765>, <-0.045856, -2.081590, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097952, -4.046142, 0.508870>, <0.097952, -3.444289, 0.508870>, <0.097952, -2.641819, 0.508870>, <0.097952, -2.039965, 0.508870>, 
      <0.097952, -4.046142, 0.373209>, <0.097952, -3.444289, 0.373209>, <0.097952, -2.641819, 0.373209>, <0.097952, -2.039965, 0.373209>, 
      <0.132162, -4.026501, 0.186465>, <0.132162, -3.424647, 0.186465>, <0.132433, -2.631838, 0.187492>, <0.132433, -2.029985, 0.187492>, 
      <0.097952, -4.046142, 0.056665>, <0.097952, -3.444289, 0.056665>, <0.097952, -2.641819, 0.056665>, <0.097952, -2.039965, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.397534, -6.216028, 0.056665>, <9.344512, -6.437759, 0.056665>, <8.993658, -6.588182, 0.056665>, <8.774580, -6.651272, 0.056665>, 
      <9.363801, -6.186273, 0.184653>, <9.310779, -6.408004, 0.184653>, <8.964320, -6.556207, 0.185199>, <8.745242, -6.619298, 0.185199>, 
      <9.397534, -6.216028, 0.373209>, <9.344512, -6.437759, 0.373209>, <8.993658, -6.588182, 0.373209>, <8.774580, -6.651272, 0.373209>, 
      <9.397534, -6.216028, 0.508870>, <9.344512, -6.437759, 0.508870>, <8.993658, -6.588182, 0.508870>, <8.774580, -6.651272, 0.508870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, -6.342879, -0.036765>, <9.486331, -6.570577, -0.036765>, <9.124398, -6.722792, -0.036765>, <8.899122, -6.787006, -0.036765>, 
      <9.525201, -6.328642, -0.097030>, <9.470191, -6.556340, -0.097030>, <9.110802, -6.707976, -0.095377>, <8.885528, -6.772190, -0.095377>, 
      <9.413446, -6.230064, -0.003708>, <9.360424, -6.451795, -0.003708>, <9.007059, -6.602786, -0.002044>, <8.787981, -6.665877, -0.002044>, 
      <9.397534, -6.216028, 0.056665>, <9.344512, -6.437759, 0.056665>, <8.993658, -6.588182, 0.056665>, <8.774580, -6.651272, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, -6.342879, 0.593618>, <9.486331, -6.570577, 0.593618>, <9.091788, -6.653768, 0.593618>, <8.899122, -6.787006, 0.593618>, 
      <9.717899, -6.342879, 0.525857>, <9.662890, -6.570577, 0.525857>, <9.264430, -6.632327, 0.519460>, <9.071764, -6.765565, 0.519460>, 
      <9.589040, -6.384954, 0.141333>, <9.534030, -6.612651, 0.141333>, <9.165888, -6.768010, 0.142116>, <8.940613, -6.832224, 0.142116>, 
      <9.541341, -6.342879, -0.036765>, <9.486331, -6.570577, -0.036765>, <9.124398, -6.722792, -0.036765>, <8.899122, -6.787006, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.796456, -6.342879, 1.125049>, <4.794176, -5.679460, 1.158292>, <4.790586, -4.792961, 1.124986>, <4.788069, -4.128710, 1.124960>, 
      <5.372473, -6.342879, 1.128889>, <5.370192, -5.679460, 1.162131>, <5.371719, -4.792961, 1.128835>, <5.369203, -4.128710, 1.128809>, 
      <6.142554, -6.342879, 1.112046>, <6.144915, -5.679447, 1.145029>, <6.143533, -4.792961, 1.112412>, <6.146138, -4.128710, 1.112377>, 
      <6.715004, -6.342879, 1.047931>, <6.717365, -5.679447, 1.080914>, <6.721082, -4.792961, 1.047851>, <6.723686, -4.128710, 1.047816>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.719827, -6.342879, 1.021298>, <2.719827, -5.679505, 1.055410>, <2.719827, -4.792961, 1.021298>, <2.719827, -4.128710, 1.021298>, 
      <3.339870, -6.342879, 1.089347>, <3.339870, -5.679505, 1.123458>, <3.337359, -4.792961, 1.089177>, <3.337359, -4.128710, 1.089177>, 
      <4.172705, -6.342879, 1.120891>, <4.170424, -5.679460, 1.154134>, <4.169348, -4.792961, 1.120872>, <4.166832, -4.128710, 1.120845>, 
      <4.796456, -6.342879, 1.125049>, <4.794176, -5.679460, 1.158292>, <4.790586, -4.792961, 1.124986>, <4.788069, -4.128710, 1.124960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045856, -6.342879, 0.593618>, <-0.201845, -5.697204, 0.593618>, <-0.045856, -4.792961, 0.593618>, <-0.045856, -4.128710, 0.593618>, 
      <0.738287, -6.342879, 0.893606>, <0.582298, -5.697204, 0.893606>, <0.738287, -4.792961, 0.893606>, <0.738287, -4.128710, 0.893606>, 
      <1.885272, -6.342879, 0.929708>, <1.885272, -5.679505, 0.963820>, <1.885287, -4.792961, 0.929566>, <1.885287, -4.128710, 0.929566>, 
      <2.719827, -6.342879, 1.021298>, <2.719827, -5.679505, 1.055410>, <2.719827, -4.792961, 1.021298>, <2.719827, -4.128710, 1.021298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097952, -6.216028, 0.056665>, <-0.053442, -5.582912, 0.056665>, <0.097952, -4.697108, 0.056665>, <0.097952, -4.046142, 0.056665>, 
      <0.082040, -6.230064, -0.003708>, <-0.069354, -5.596948, -0.003708>, <0.083553, -4.705376, 0.002032>, <0.083553, -4.054410, 0.002032>, 
      <-0.029715, -6.328642, -0.097030>, <-0.185704, -5.682967, -0.097030>, <-0.031244, -4.784572, -0.091323>, <-0.031244, -4.120321, -0.091323>, 
      <-0.045856, -6.342879, -0.036765>, <-0.201845, -5.697204, -0.036765>, <-0.045856, -4.792961, -0.036765>, <-0.045856, -4.128710, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097952, -6.216028, 0.508870>, <-0.053442, -5.582912, 0.508870>, <0.097952, -4.697108, 0.508870>, <0.097952, -4.046142, 0.508870>, 
      <0.097952, -6.216028, 0.373209>, <-0.053442, -5.582912, 0.373209>, <0.097952, -4.697108, 0.373209>, <0.097952, -4.046142, 0.373209>, 
      <0.131685, -6.186273, 0.184653>, <-0.019709, -5.553157, 0.184653>, <0.132162, -4.677466, 0.186465>, <0.132162, -4.026501, 0.186465>, 
      <0.097952, -6.216028, 0.056665>, <-0.053442, -5.582912, 0.056665>, <0.097952, -4.697108, 0.056665>, <0.097952, -4.046142, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.774580, -6.651272, 0.056665>, <8.155569, -6.829538, 0.056665>, <7.298398, -6.948473, 0.056665>, <6.656743, -7.005330, 0.056665>, 
      <8.745242, -6.619298, 0.185199>, <8.126231, -6.797563, 0.185199>, <7.284274, -6.914276, 0.187184>, <6.642620, -6.971134, 0.187184>, 
      <8.774580, -6.651272, 0.373209>, <8.155569, -6.829538, 0.373209>, <7.298398, -6.948473, 0.373209>, <6.656743, -7.005330, 0.373209>, 
      <8.774580, -6.651272, 0.508870>, <8.155569, -6.829538, 0.508870>, <7.298398, -6.948473, 0.508870>, <6.656743, -7.005330, 0.508870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.899122, -6.787006, -0.036765>, <8.260646, -6.969000, -0.036765>, <7.377154, -7.090283, -0.036765>, <6.715785, -7.148290, -0.036765>, 
      <8.885528, -6.772190, -0.095377>, <8.247051, -6.954184, -0.095377>, <7.373545, -7.086890, -0.090748>, <6.712176, -7.144896, -0.090748>, 
      <8.787981, -6.665877, -0.002044>, <8.168970, -6.844142, -0.002044>, <7.304041, -6.962138, 0.004510>, <6.662386, -7.018995, 0.004510>, 
      <8.774580, -6.651272, 0.056665>, <8.155569, -6.829538, 0.056665>, <7.298398, -6.948473, 0.056665>, <6.656743, -7.005330, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.899122, -6.787006, 0.593618>, <8.289994, -6.862654, 0.855266>, <7.376158, -7.014592, 0.840004>, <6.713262, -7.058473, 0.902162>, 
      <9.071764, -6.765565, 0.519460>, <8.462636, -6.841214, 0.781108>, <7.376321, -7.183282, 0.612819>, <6.713426, -7.227162, 0.674977>, 
      <8.940613, -6.832224, 0.142116>, <8.302137, -7.014219, 0.142116>, <7.395990, -7.107994, 0.245016>, <6.734621, -7.166000, 0.245016>, 
      <8.899122, -6.787006, -0.036765>, <8.260646, -6.969000, -0.036765>, <7.377154, -7.090283, -0.036765>, <6.715785, -7.148290, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.798139, -7.058473, 0.978154>, <4.796341, -6.933878, 1.158437>, <4.797209, -6.561758, 1.114081>, <4.796456, -6.342879, 1.125049>, 
      <5.373110, -7.058473, 0.982692>, <5.371312, -6.933878, 1.162974>, <5.373225, -6.561758, 1.117921>, <5.372473, -6.342879, 1.128889>, 
      <6.142024, -7.096286, 0.955725>, <6.141897, -6.965678, 1.131624>, <6.141776, -6.561695, 1.101167>, <6.142554, -6.342879, 1.112046>, 
      <6.713262, -7.058473, 0.902162>, <6.713136, -6.927863, 1.078061>, <6.714226, -6.561695, 1.037052>, <6.715004, -6.342879, 1.047931>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.719827, -7.058473, 0.870646>, <2.722633, -6.927348, 1.046509>, <2.719827, -6.561974, 1.010032>, <2.719827, -6.342879, 1.021298>, 
      <3.340273, -7.098558, 0.927428>, <3.343079, -6.967433, 1.103291>, <3.339870, -6.561974, 1.078080>, <3.339870, -6.342879, 1.089347>, 
      <4.173831, -7.058473, 0.973227>, <4.172033, -6.933878, 1.153510>, <4.173457, -6.561758, 1.109923>, <4.172705, -6.342879, 1.120891>, 
      <4.798139, -7.058473, 0.978154>, <4.796341, -6.933878, 1.158437>, <4.797209, -6.561758, 1.114081>, <4.796456, -6.342879, 1.125049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.596364, -6.787006, 0.593618>, <0.403698, -6.653768, 0.593618>, <0.009154, -6.570577, 0.593618>, <-0.045856, -6.342879, 0.593618>, 
      <1.187778, -6.862614, 0.846344>, <0.995112, -6.729375, 0.846344>, <0.793296, -6.570577, 0.893606>, <0.738287, -6.342879, 0.893606>, 
      <2.076274, -7.016894, 0.811750>, <2.079080, -6.885770, 0.987612>, <1.885272, -6.561974, 0.918442>, <1.885272, -6.342879, 0.929708>, 
      <2.719827, -7.058473, 0.870646>, <2.722633, -6.927348, 1.046509>, <2.719827, -6.561974, 1.010032>, <2.719827, -6.342879, 1.021298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.720905, -6.651272, 0.056665>, <0.501942, -6.587782, 0.056665>, <0.150974, -6.437758, 0.056665>, <0.097952, -6.216028, 0.056665>, 
      <0.707504, -6.665877, -0.002044>, <0.488542, -6.602387, -0.002044>, <0.135062, -6.451794, -0.003708>, <0.082040, -6.230064, -0.003708>, 
      <0.609958, -6.772190, -0.095377>, <0.384799, -6.707569, -0.095377>, <0.025295, -6.556340, -0.097030>, <-0.029715, -6.328642, -0.097030>, 
      <0.596364, -6.787006, -0.036765>, <0.371204, -6.722386, -0.036765>, <0.009154, -6.570577, -0.036765>, <-0.045856, -6.342879, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.720905, -6.651272, 0.508870>, <0.501942, -6.587782, 0.508870>, <0.150974, -6.437758, 0.508870>, <0.097952, -6.216028, 0.508870>, 
      <0.720905, -6.651272, 0.373209>, <0.501942, -6.587782, 0.373209>, <0.150974, -6.437758, 0.373209>, <0.097952, -6.216028, 0.373209>, 
      <0.750243, -6.619298, 0.185199>, <0.531280, -6.555808, 0.185199>, <0.184706, -6.408003, 0.184653>, <0.131685, -6.186273, 0.184653>, 
      <0.720905, -6.651272, 0.056665>, <0.501942, -6.587782, 0.056665>, <0.150974, -6.437758, 0.056665>, <0.097952, -6.216028, 0.056665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, 6.343094, 0.593618>, <8.755118, 6.343094, 0.900580>, <7.603643, 6.343094, 0.954362>, <6.764752, 6.343094, 1.047288>, 
      <9.484550, 6.570355, 0.593618>, <8.698326, 6.570355, 0.900580>, <7.604420, 6.561905, 0.943126>, <6.765529, 6.561905, 1.036052>, 
      <9.091786, 6.653983, 0.593618>, <8.499427, 6.729395, 0.854225>, <7.416202, 6.887506, 1.018795>, <6.768808, 6.929835, 1.078647>, 
      <8.899120, 6.787222, 0.593618>, <8.306761, 6.862634, 0.854225>, <7.413888, 7.016394, 0.841630>, <6.766494, 7.058723, 0.901482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, 4.217239, 0.593618>, <8.752511, 4.217239, 0.900705>, <7.597746, 4.217239, 0.954025>, <6.756416, 4.217239, 1.047393>, 
      <9.541341, 4.854996, 0.593618>, <8.752511, 4.854996, 0.900705>, <7.600247, 4.854996, 0.953993>, <6.758917, 4.854996, 1.047361>, 
      <9.695957, 5.724364, 0.593618>, <8.909734, 5.724364, 0.900580>, <7.601385, 5.706176, 0.987068>, <6.762494, 5.706176, 1.079994>, 
      <9.541341, 6.343094, 0.593618>, <8.755118, 6.343094, 0.900580>, <7.603643, 6.343094, 0.954362>, <6.764752, 6.343094, 1.047288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, 2.091384, 0.593618>, <8.749906, 2.091384, 0.900830>, <7.591850, 2.091384, 0.953688>, <6.748079, 2.091384, 1.047500>, 
      <9.541341, 2.729141, 0.593618>, <8.749906, 2.729141, 0.900830>, <7.594350, 2.729141, 0.953656>, <6.750580, 2.729141, 1.047468>, 
      <9.541341, 3.579482, 0.593618>, <8.752511, 3.579482, 0.900705>, <7.595246, 3.579482, 0.954056>, <6.753915, 3.579482, 1.047425>, 
      <9.541341, 4.217239, 0.593618>, <8.752511, 4.217239, 0.900705>, <7.597746, 4.217239, 0.954025>, <6.756416, 4.217239, 1.047393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, -0.034471, 0.593618>, <8.747301, -0.034471, 0.900954>, <7.585952, -0.034471, 0.953350>, <6.739742, -0.034471, 1.047607>, 
      <9.541341, 0.603286, 0.593618>, <8.747301, 0.603286, 0.900954>, <7.588454, 0.603286, 0.953317>, <6.742243, 0.603286, 1.047574>, 
      <9.541341, 1.453628, 0.593618>, <8.749906, 1.453628, 0.900830>, <7.589348, 1.453628, 0.953720>, <6.745578, 1.453628, 1.047532>, 
      <9.541341, 2.091384, 0.593618>, <8.749906, 2.091384, 0.900830>, <7.591850, 2.091384, 0.953688>, <6.748079, 2.091384, 1.047500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, -2.081590, 0.593618>, <8.744793, -2.081590, 0.901074>, <7.580274, -2.081590, 0.953024>, <6.731714, -2.081590, 1.047711>, 
      <9.541341, -1.467454, 0.593618>, <8.744793, -1.467454, 0.901074>, <7.582682, -1.467455, 0.952993>, <6.734122, -1.467455, 1.047680>, 
      <9.541341, -0.648607, 0.593618>, <8.747301, -0.648607, 0.900954>, <7.583544, -0.648607, 0.953381>, <6.737334, -0.648607, 1.047638>, 
      <9.541341, -0.034471, 0.593618>, <8.747301, -0.034471, 0.900954>, <7.585952, -0.034471, 0.953350>, <6.739742, -0.034471, 1.047607>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, -4.128710, 0.593618>, <8.742285, -4.128710, 0.901193>, <7.574595, -4.128710, 0.952698>, <6.723686, -4.128710, 1.047816>, 
      <9.541341, -3.514574, 0.593618>, <8.742285, -3.514574, 0.901193>, <7.577003, -3.514574, 0.952666>, <6.726095, -3.514574, 1.047785>, 
      <9.541341, -2.695726, 0.593618>, <8.744793, -2.695726, 0.901074>, <7.577865, -2.695726, 0.953056>, <6.729306, -2.695726, 1.047743>, 
      <9.541341, -2.081590, 0.593618>, <8.744793, -2.081590, 0.901074>, <7.580274, -2.081590, 0.953024>, <6.731714, -2.081590, 1.047711>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.541341, -6.342879, 0.593618>, <8.739574, -6.342879, 0.901321>, <7.568454, -6.342879, 0.952344>, <6.715004, -6.342879, 1.047931>, 
      <9.697330, -5.697204, 0.593618>, <8.895562, -5.697204, 0.901321>, <7.570814, -5.679447, 0.985326>, <6.717365, -5.679447, 1.080914>, 
      <9.541341, -4.792961, 0.593618>, <8.742285, -4.792961, 0.901193>, <7.571990, -4.792961, 0.952732>, <6.721082, -4.792961, 1.047851>, 
      <9.541341, -4.128710, 0.593618>, <8.742285, -4.128710, 0.901193>, <7.574595, -4.128710, 0.952698>, <6.723686, -4.128710, 1.047816>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.899122, -6.787006, 0.593618>, <8.289994, -6.862654, 0.855266>, <7.376158, -7.014592, 0.840004>, <6.713262, -7.058473, 0.902162>, 
      <9.091788, -6.653768, 0.593618>, <8.482660, -6.729417, 0.855266>, <7.376031, -6.883983, 1.015903>, <6.713136, -6.927863, 1.078061>, 
      <9.486331, -6.570577, 0.593618>, <8.684564, -6.570577, 0.901321>, <7.567674, -6.561695, 0.941465>, <6.714226, -6.561695, 1.037052>, 
      <9.541341, -6.342879, 0.593618>, <8.739574, -6.342879, 0.901321>, <7.568454, -6.342879, 0.952344>, <6.715004, -6.342879, 1.047931>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045856, 6.343094, 0.593618>, <-0.222486, 6.343094, 0.526044>, <-0.093554, 6.385174, 0.141332>, <-0.045856, 6.343094, -0.036765>, 
      <0.010935, 6.570355, 0.593618>, <-0.165695, 6.570355, 0.526044>, <-0.036763, 6.612435, 0.141332>, <0.010935, 6.570355, -0.036765>, 
      <0.403699, 6.653983, 0.593618>, <0.230986, 6.631900, 0.519813>, <0.329990, 6.766876, 0.142114>, <0.371479, 6.721653, -0.036765>, 
      <0.596364, 6.787222, 0.593618>, <0.423652, 6.765138, 0.519813>, <0.554875, 6.832445, 0.142114>, <0.596364, 6.787222, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045856, 4.217239, 0.593618>, <-0.222486, 4.217239, 0.526044>, <-0.094227, 4.245611, 0.143844>, <-0.045856, 4.217239, -0.036765>, 
      <-0.045856, 4.854996, 0.593618>, <-0.222486, 4.854996, 0.526044>, <-0.094227, 4.883368, 0.143844>, <-0.045856, 4.854996, -0.036765>, 
      <-0.200472, 5.724364, 0.593618>, <-0.377102, 5.724364, 0.526044>, <-0.248170, 5.766444, 0.141332>, <-0.200472, 5.724364, -0.036765>, 
      <-0.045856, 6.343094, 0.593618>, <-0.222486, 6.343094, 0.526044>, <-0.093554, 6.385174, 0.141332>, <-0.045856, 6.343094, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045856, 2.091384, 0.593618>, <-0.222486, 2.091384, 0.526044>, <-0.094643, 2.105577, 0.145396>, <-0.045856, 2.091384, -0.036765>, 
      <-0.045856, 2.729141, 0.593618>, <-0.222486, 2.729141, 0.526044>, <-0.094643, 2.743333, 0.145396>, <-0.045856, 2.729141, -0.036765>, 
      <-0.045856, 3.579482, 0.593618>, <-0.222486, 3.579482, 0.526044>, <-0.094227, 3.607855, 0.143844>, <-0.045856, 3.579482, -0.036765>, 
      <-0.045856, 4.217239, 0.593618>, <-0.222486, 4.217239, 0.526044>, <-0.094227, 4.245611, 0.143844>, <-0.045856, 4.217239, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045856, -0.034471, 0.593618>, <-0.222486, -0.034471, 0.526044>, <-0.094781, -0.034703, 0.145911>, <-0.045856, -0.034471, -0.036765>, 
      <-0.045856, 0.603286, 0.593618>, <-0.222486, 0.603286, 0.526044>, <-0.094781, 0.603054, 0.145911>, <-0.045856, 0.603286, -0.036765>, 
      <-0.045856, 1.453628, 0.593618>, <-0.222486, 1.453628, 0.526044>, <-0.094643, 1.467820, 0.145396>, <-0.045856, 1.453628, -0.036765>, 
      <-0.045856, 2.091384, 0.593618>, <-0.222486, 2.091384, 0.526044>, <-0.094643, 2.105577, 0.145396>, <-0.045856, 2.091384, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045856, -2.081590, 0.593618>, <-0.222486, -2.081590, 0.526044>, <-0.094644, -2.095712, 0.145401>, <-0.045856, -2.081590, -0.036765>, 
      <-0.045856, -1.467454, 0.593618>, <-0.222486, -1.467454, 0.526044>, <-0.094644, -1.481576, 0.145401>, <-0.045856, -1.467454, -0.036765>, 
      <-0.045856, -0.648607, 0.593618>, <-0.222486, -0.648607, 0.526044>, <-0.094781, -0.648839, 0.145911>, <-0.045856, -0.648607, -0.036765>, 
      <-0.045856, -0.034471, 0.593618>, <-0.222486, -0.034471, 0.526044>, <-0.094781, -0.034703, 0.145911>, <-0.045856, -0.034471, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045856, -4.128710, 0.593618>, <-0.222486, -4.128710, 0.526044>, <-0.094250, -4.156496, 0.143929>, <-0.045856, -4.128710, -0.036765>, 
      <-0.045856, -3.514574, 0.593618>, <-0.222486, -3.514574, 0.526044>, <-0.094250, -3.542360, 0.143929>, <-0.045856, -3.514574, -0.036765>, 
      <-0.045856, -2.695726, 0.593618>, <-0.222486, -2.695726, 0.526044>, <-0.094644, -2.709848, 0.145401>, <-0.045856, -2.695726, -0.036765>, 
      <-0.045856, -2.081590, 0.593618>, <-0.222486, -2.081590, 0.526044>, <-0.094644, -2.095712, 0.145401>, <-0.045856, -2.081590, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.045856, -6.342879, 0.593618>, <-0.222486, -6.342879, 0.526044>, <-0.093554, -6.384954, 0.141333>, <-0.045856, -6.342879, -0.036765>, 
      <-0.201845, -5.697204, 0.593618>, <-0.378475, -5.697204, 0.526044>, <-0.249543, -5.739278, 0.141333>, <-0.201845, -5.697204, -0.036765>, 
      <-0.045856, -4.792961, 0.593618>, <-0.222486, -4.792961, 0.526044>, <-0.094250, -4.820746, 0.143929>, <-0.045856, -4.792961, -0.036765>, 
      <-0.045856, -4.128710, 0.593618>, <-0.222486, -4.128710, 0.526044>, <-0.094250, -4.156496, 0.143929>, <-0.045856, -4.128710, -0.036765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.596364, -6.787006, 0.593618>, <0.423651, -6.764926, 0.519813>, <0.554874, -6.832224, 0.142116>, <0.596364, -6.787006, -0.036765>, 
      <0.403698, -6.653768, 0.593618>, <0.230985, -6.631688, 0.519813>, <0.329715, -6.767604, 0.142116>, <0.371204, -6.722386, -0.036765>, 
      <0.009154, -6.570577, 0.593618>, <-0.167476, -6.570577, 0.526044>, <-0.038545, -6.612651, 0.141333>, <0.009154, -6.570577, -0.036765>, 
      <-0.045856, -6.342879, 0.593618>, <-0.222486, -6.342879, 0.526044>, <-0.093554, -6.384954, 0.141333>, <-0.045856, -6.342879, -0.036765>
    }
  }
  material {
    tapa_txt
  }
}
#declare contendor_base = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.441965, -5.862558, -6.313737>, <7.437966, -5.862129, -6.327972>, <7.408265, -5.829194, -6.309290>, <7.411431, -5.828764, -6.294846>, 
      <7.441965, -6.025282, -6.313737>, <7.437966, -6.024852, -6.327972>, <7.408265, -6.012194, -6.309290>, <7.411431, -6.011764, -6.294846>, 
      <7.441965, -6.242247, -6.313737>, <7.437966, -6.242676, -6.327972>, <7.408265, -6.255334, -6.309290>, <7.411431, -6.255764, -6.294846>, 
      <7.441965, -6.404970, -6.313737>, <7.437966, -6.405400, -6.327972>, <7.408265, -6.438334, -6.309290>, <7.411431, -6.438764, -6.294846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.972524, -5.862558, -6.426511>, <7.969358, -5.862128, -6.440954>, <8.004102, -5.829193, -6.435908>, <8.008101, -5.828764, -6.421673>, 
      <7.813356, -5.862558, -6.392679>, <7.810190, -5.862128, -6.407122>, <7.825102, -5.829193, -6.397860>, <7.829100, -5.828764, -6.383625>, 
      <7.601132, -5.862558, -6.347570>, <7.597133, -5.862129, -6.361804>, <7.587266, -5.829194, -6.347338>, <7.590432, -5.828764, -6.332894>, 
      <7.441965, -5.862558, -6.313737>, <7.437966, -5.862129, -6.327972>, <7.408265, -5.829194, -6.309290>, <7.411431, -5.828764, -6.294846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.972524, -6.404970, -6.426511>, <7.969358, -6.405400, -6.440954>, <8.004102, -6.438336, -6.435908>, <8.008101, -6.438764, -6.421673>, 
      <7.972524, -6.242247, -6.426511>, <7.969358, -6.242677, -6.440954>, <8.004102, -6.255335, -6.435908>, <8.008101, -6.255764, -6.421673>, 
      <7.972524, -6.025282, -6.426511>, <7.969358, -6.024852, -6.440954>, <8.004102, -6.012193, -6.435908>, <8.008101, -6.011764, -6.421673>, 
      <7.972524, -5.862558, -6.426511>, <7.969358, -5.862128, -6.440954>, <8.004102, -5.829193, -6.435908>, <8.008101, -5.828764, -6.421673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.441965, -6.404970, -6.313737>, <7.437966, -6.405400, -6.327972>, <7.408265, -6.438334, -6.309290>, <7.411431, -6.438764, -6.294846>, 
      <7.601132, -6.404970, -6.347570>, <7.597133, -6.405400, -6.361804>, <7.587266, -6.438334, -6.347337>, <7.590432, -6.438764, -6.332894>, 
      <7.813356, -6.404970, -6.392679>, <7.810190, -6.405400, -6.407122>, <7.825102, -6.438336, -6.397860>, <7.829100, -6.438764, -6.383625>, 
      <7.972524, -6.404970, -6.426511>, <7.969358, -6.405400, -6.440954>, <8.004102, -6.438336, -6.435908>, <8.008101, -6.438764, -6.421673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.726178, -5.862558, -5.174572>, <7.648463, -5.862558, -5.518117>, <7.537195, -5.872783, -5.974784>, <7.441965, -5.862558, -6.313737>, 
      <7.726178, -6.025282, -5.174572>, <7.648463, -6.025282, -5.518117>, <7.537195, -6.035507, -5.974784>, <7.441965, -6.025282, -6.313737>, 
      <7.726178, -6.242247, -5.174572>, <7.648463, -6.242247, -5.518117>, <7.537195, -6.232022, -5.974784>, <7.441965, -6.242247, -6.313737>, 
      <7.726178, -6.404970, -5.174572>, <7.648463, -6.404970, -5.518117>, <7.537195, -6.394745, -5.974784>, <7.441965, -6.404970, -6.313737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.256737, -5.862558, -5.287346>, <8.179022, -5.862558, -5.630891>, <8.047907, -5.872804, -6.082600>, <7.972524, -5.862558, -6.426511>, 
      <8.097570, -5.862558, -5.253514>, <8.019855, -5.862558, -5.597059>, <7.888739, -5.872804, -6.048768>, <7.813356, -5.862558, -6.392679>, 
      <7.885346, -5.862558, -5.208404>, <7.807631, -5.862558, -5.551949>, <7.696363, -5.872783, -6.008616>, <7.601132, -5.862558, -6.347570>, 
      <7.726178, -5.862558, -5.174572>, <7.648463, -5.862558, -5.518117>, <7.537195, -5.872783, -5.974784>, <7.441965, -5.862558, -6.313737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.256737, -6.404970, -5.287346>, <8.179022, -6.404970, -5.630891>, <8.047907, -6.394724, -6.082600>, <7.972524, -6.404970, -6.426511>, 
      <8.256737, -6.242247, -5.287346>, <8.179022, -6.242247, -5.630891>, <8.047907, -6.232001, -6.082600>, <7.972524, -6.242247, -6.426511>, 
      <8.256737, -6.025282, -5.287346>, <8.179022, -6.025282, -5.630891>, <8.047907, -6.035528, -6.082600>, <7.972524, -6.025282, -6.426511>, 
      <8.256737, -5.862558, -5.287346>, <8.179022, -5.862558, -5.630891>, <8.047907, -5.872804, -6.082600>, <7.972524, -5.862558, -6.426511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.726178, -6.404970, -5.174572>, <7.648463, -6.404970, -5.518117>, <7.537195, -6.394745, -5.974784>, <7.441965, -6.404970, -6.313737>, 
      <7.885346, -6.404970, -5.208404>, <7.807631, -6.404970, -5.551949>, <7.696363, -6.394745, -6.008616>, <7.601132, -6.404970, -6.347570>, 
      <8.097570, -6.404970, -5.253514>, <8.019855, -6.404970, -5.597059>, <7.888739, -6.394724, -6.048768>, <7.813356, -6.404970, -6.392679>, 
      <8.256737, -6.404970, -5.287346>, <8.179022, -6.404970, -5.630891>, <8.047907, -6.394724, -6.082600>, <7.972524, -6.404970, -6.426511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.411431, -5.828764, -6.294846>, <7.485394, -5.818730, -5.957391>, <7.614786, -5.828764, -5.514348>, <7.691058, -5.828764, -5.177258>, 
      <7.411431, -6.011764, -6.294846>, <7.485394, -6.001730, -5.957391>, <7.614786, -6.011764, -5.514348>, <7.691058, -6.011764, -5.177258>, 
      <7.411431, -6.255764, -6.294846>, <7.485394, -6.265798, -5.957391>, <7.614786, -6.255764, -5.514348>, <7.691058, -6.255764, -5.177258>, 
      <7.411431, -6.438764, -6.294846>, <7.485394, -6.448799, -5.957391>, <7.614786, -6.438764, -5.514348>, <7.691058, -6.438764, -5.177258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.008101, -5.828764, -6.421673>, <8.101502, -5.818750, -6.089072>, <8.211455, -5.828764, -5.641175>, <8.287727, -5.828764, -5.304084>, 
      <7.829100, -5.828764, -6.383625>, <7.922502, -5.818750, -6.051024>, <8.032454, -5.828764, -5.603127>, <8.108726, -5.828764, -5.266036>, 
      <7.590432, -5.828764, -6.332894>, <7.664395, -5.818730, -5.995438>, <7.793786, -5.828764, -5.552396>, <7.870058, -5.828764, -5.215305>, 
      <7.411431, -5.828764, -6.294846>, <7.485394, -5.818730, -5.957391>, <7.614786, -5.828764, -5.514348>, <7.691058, -5.828764, -5.177258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.008101, -6.438764, -6.421673>, <8.101502, -6.448778, -6.089072>, <8.211455, -6.438764, -5.641175>, <8.287727, -6.438764, -5.304084>, 
      <8.008101, -6.255764, -6.421673>, <8.101502, -6.265778, -6.089072>, <8.211455, -6.255764, -5.641175>, <8.287727, -6.255764, -5.304084>, 
      <8.008101, -6.011764, -6.421673>, <8.101502, -6.001750, -6.089072>, <8.211455, -6.011764, -5.641175>, <8.287727, -6.011764, -5.304084>, 
      <8.008101, -5.828764, -6.421673>, <8.101502, -5.818750, -6.089072>, <8.211455, -5.828764, -5.641175>, <8.287727, -5.828764, -5.304084>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.411431, -6.438764, -6.294846>, <7.485394, -6.448799, -5.957391>, <7.614786, -6.438764, -5.514348>, <7.691058, -6.438764, -5.177258>, 
      <7.590432, -6.438764, -6.332894>, <7.664395, -6.448799, -5.995438>, <7.793786, -6.438764, -5.552396>, <7.870058, -6.438764, -5.215305>, 
      <7.829100, -6.438764, -6.383625>, <7.922502, -6.448778, -6.051024>, <8.032454, -6.438764, -5.603127>, <8.108726, -6.438764, -5.266036>, 
      <8.008101, -6.438764, -6.421673>, <8.101502, -6.448778, -6.089072>, <8.211455, -6.438764, -5.641175>, <8.287727, -6.438764, -5.304084>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.691058, -5.828764, -5.177258>, <7.823153, -5.828764, -4.593450>, <7.971559, -5.818628, -3.808851>, <8.105886, -5.828764, -3.225641>, 
      <7.691058, -6.011764, -5.177258>, <7.823153, -6.011764, -4.593450>, <7.971559, -6.001628, -3.808851>, <8.105886, -6.011764, -3.225641>, 
      <7.691058, -6.255764, -5.177258>, <7.823153, -6.255764, -4.593450>, <7.971559, -6.265899, -3.808851>, <8.105886, -6.255764, -3.225641>, 
      <7.691058, -6.438764, -5.177258>, <7.823153, -6.438764, -4.593450>, <7.971559, -6.448899, -3.808851>, <8.105886, -6.438764, -3.225641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.287727, -5.828764, -5.304084>, <8.419822, -5.828764, -4.720276>, <8.588058, -5.818628, -3.939891>, <8.702557, -5.828764, -3.352467>, 
      <8.108726, -5.828764, -5.266036>, <8.240822, -5.828764, -4.682228>, <8.409057, -5.818628, -3.901844>, <8.523556, -5.828764, -3.314419>, 
      <7.870058, -5.828764, -5.215305>, <8.002154, -5.828764, -4.631498>, <8.150560, -5.818628, -3.846898>, <8.284887, -5.828764, -3.263689>, 
      <7.691058, -5.828764, -5.177258>, <7.823153, -5.828764, -4.593450>, <7.971559, -5.818628, -3.808851>, <8.105886, -5.828764, -3.225641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.287727, -6.438764, -5.304084>, <8.419822, -6.438764, -4.720276>, <8.588058, -6.448899, -3.939891>, <8.702557, -6.438764, -3.352467>, 
      <8.287727, -6.255764, -5.304084>, <8.419822, -6.255764, -4.720276>, <8.588058, -6.265899, -3.939891>, <8.702557, -6.255764, -3.352467>, 
      <8.287727, -6.011764, -5.304084>, <8.419822, -6.011764, -4.720276>, <8.588058, -6.001628, -3.939891>, <8.702557, -6.011764, -3.352467>, 
      <8.287727, -5.828764, -5.304084>, <8.419822, -5.828764, -4.720276>, <8.588058, -5.818628, -3.939891>, <8.702557, -5.828764, -3.352467>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.691058, -6.438764, -5.177258>, <7.823153, -6.438764, -4.593450>, <7.971559, -6.448899, -3.808851>, <8.105886, -6.438764, -3.225641>, 
      <7.870058, -6.438764, -5.215305>, <8.002154, -6.438764, -4.631498>, <8.150560, -6.448899, -3.846898>, <8.284887, -6.438764, -3.263689>, 
      <8.108726, -6.438764, -5.266036>, <8.240822, -6.438764, -4.682228>, <8.409057, -6.448899, -3.901844>, <8.523556, -6.438764, -3.314419>, 
      <8.287727, -6.438764, -5.304084>, <8.419822, -6.438764, -4.720276>, <8.588058, -6.448899, -3.939891>, <8.702557, -6.438764, -3.352467>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.138942, -5.862558, -3.232667>, <8.025063, -5.872694, -3.817177>, <7.857587, -5.862558, -4.593663>, <7.726178, -5.862558, -5.174572>, 
      <8.138942, -6.025282, -3.232667>, <8.025063, -6.035417, -3.817177>, <7.857587, -6.025282, -4.593663>, <7.726178, -6.025282, -5.174572>, 
      <8.138942, -6.242247, -3.232667>, <8.025063, -6.232112, -3.817177>, <7.857587, -6.242247, -4.593663>, <7.726178, -6.242247, -5.174572>, 
      <8.138942, -6.404970, -3.232667>, <8.025063, -6.394835, -3.817177>, <7.857587, -6.404970, -4.593663>, <7.726178, -6.404970, -5.174572>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.669502, -5.862558, -3.345441>, <8.535794, -5.872694, -3.925736>, <8.388146, -5.862558, -4.706437>, <8.256737, -5.862558, -5.287346>, 
      <8.510334, -5.862558, -3.311609>, <8.376627, -5.872694, -3.891904>, <8.228978, -5.862558, -4.672605>, <8.097570, -5.862558, -5.253514>, 
      <8.298110, -5.862558, -3.266499>, <8.184231, -5.872694, -3.851009>, <8.016754, -5.862558, -4.627495>, <7.885346, -5.862558, -5.208404>, 
      <8.138942, -5.862558, -3.232667>, <8.025063, -5.872694, -3.817177>, <7.857587, -5.862558, -4.593663>, <7.726178, -5.862558, -5.174572>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.669502, -6.404970, -3.345441>, <8.535794, -6.394835, -3.925736>, <8.388146, -6.404970, -4.706437>, <8.256737, -6.404970, -5.287346>, 
      <8.669502, -6.242247, -3.345441>, <8.535794, -6.232112, -3.925736>, <8.388146, -6.242247, -4.706437>, <8.256737, -6.242247, -5.287346>, 
      <8.669502, -6.025282, -3.345441>, <8.535794, -6.035417, -3.925736>, <8.388146, -6.025282, -4.706437>, <8.256737, -6.025282, -5.287346>, 
      <8.669502, -5.862558, -3.345441>, <8.535794, -5.872694, -3.925736>, <8.388146, -5.862558, -4.706437>, <8.256737, -5.862558, -5.287346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.138942, -6.404970, -3.232667>, <8.025063, -6.394835, -3.817177>, <7.857587, -6.404970, -4.593663>, <7.726178, -6.404970, -5.174572>, 
      <8.298110, -6.404970, -3.266499>, <8.184231, -6.394835, -3.851009>, <8.016754, -6.404970, -4.627495>, <7.885346, -6.404970, -5.208404>, 
      <8.510334, -6.404970, -3.311609>, <8.376627, -6.394835, -3.891904>, <8.228978, -6.404970, -4.672605>, <8.097570, -6.404970, -5.253514>, 
      <8.669502, -6.404970, -3.345441>, <8.535794, -6.394835, -3.925736>, <8.388146, -6.404970, -4.706437>, <8.256737, -6.404970, -5.287346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.105886, -5.828764, -3.225641>, <8.109104, -5.829007, -3.211671>, <8.141685, -5.862314, -3.218596>, <8.138942, -5.862558, -3.232667>, 
      <8.105886, -6.011764, -3.225641>, <8.109104, -6.012007, -3.211671>, <8.141685, -6.025038, -3.218596>, <8.138942, -6.025282, -3.232667>, 
      <8.105886, -6.255764, -3.225641>, <8.109104, -6.255521, -3.211671>, <8.141685, -6.242491, -3.218596>, <8.138942, -6.242247, -3.232667>, 
      <8.105886, -6.438764, -3.225641>, <8.109104, -6.438521, -3.211671>, <8.141685, -6.405214, -3.218596>, <8.138942, -6.404970, -3.232667>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.702557, -5.828764, -3.352467>, <8.705299, -5.829007, -3.338396>, <8.672720, -5.862314, -3.331471>, <8.669502, -5.862558, -3.345441>, 
      <8.523556, -5.828764, -3.314419>, <8.526298, -5.829007, -3.300349>, <8.513553, -5.862314, -3.297639>, <8.510334, -5.862558, -3.311609>, 
      <8.284887, -5.828764, -3.263689>, <8.288105, -5.829007, -3.249719>, <8.300852, -5.862314, -3.252428>, <8.298110, -5.862558, -3.266499>, 
      <8.105886, -5.828764, -3.225641>, <8.109104, -5.829007, -3.211671>, <8.141685, -5.862314, -3.218596>, <8.138942, -5.862558, -3.232667>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.702557, -6.438764, -3.352467>, <8.705299, -6.438521, -3.338396>, <8.672720, -6.405214, -3.331471>, <8.669502, -6.404970, -3.345441>, 
      <8.702557, -6.255764, -3.352467>, <8.705299, -6.255521, -3.338396>, <8.672720, -6.242491, -3.331471>, <8.669502, -6.242247, -3.345441>, 
      <8.702557, -6.011764, -3.352467>, <8.705299, -6.012007, -3.338396>, <8.672720, -6.025038, -3.331471>, <8.669502, -6.025282, -3.345441>, 
      <8.702557, -5.828764, -3.352467>, <8.705299, -5.829007, -3.338396>, <8.672720, -5.862314, -3.331471>, <8.669502, -5.862558, -3.345441>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.105886, -6.438764, -3.225641>, <8.109104, -6.438521, -3.211671>, <8.141685, -6.405214, -3.218596>, <8.138942, -6.404970, -3.232667>, 
      <8.284887, -6.438764, -3.263689>, <8.288105, -6.438521, -3.249719>, <8.300852, -6.405214, -3.252428>, <8.298110, -6.404970, -3.266499>, 
      <8.523556, -6.438764, -3.314419>, <8.526298, -6.438521, -3.300349>, <8.513553, -6.405214, -3.297639>, <8.510334, -6.404970, -3.311609>, 
      <8.702557, -6.438764, -3.352467>, <8.705299, -6.438521, -3.338396>, <8.672720, -6.405214, -3.331471>, <8.669502, -6.404970, -3.345441>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.441965, 5.862558, -6.313737>, <7.437966, 5.862129, -6.327972>, <7.408265, 5.829194, -6.309290>, <7.411431, 5.828764, -6.294846>, 
      <7.441965, 6.025282, -6.313737>, <7.437966, 6.024852, -6.327972>, <7.408265, 6.012194, -6.309290>, <7.411431, 6.011764, -6.294846>, 
      <7.441965, 6.242247, -6.313737>, <7.437966, 6.242676, -6.327972>, <7.408265, 6.255334, -6.309290>, <7.411431, 6.255764, -6.294846>, 
      <7.441965, 6.404970, -6.313737>, <7.437966, 6.405400, -6.327972>, <7.408265, 6.438334, -6.309290>, <7.411431, 6.438764, -6.294846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.972524, 5.862558, -6.426511>, <7.969358, 5.862128, -6.440954>, <8.004102, 5.829193, -6.435908>, <8.008101, 5.828764, -6.421673>, 
      <7.813356, 5.862558, -6.392679>, <7.810190, 5.862128, -6.407122>, <7.825102, 5.829193, -6.397860>, <7.829100, 5.828764, -6.383625>, 
      <7.601132, 5.862558, -6.347570>, <7.597133, 5.862129, -6.361804>, <7.587266, 5.829194, -6.347338>, <7.590432, 5.828764, -6.332894>, 
      <7.441965, 5.862558, -6.313737>, <7.437966, 5.862129, -6.327972>, <7.408265, 5.829194, -6.309290>, <7.411431, 5.828764, -6.294846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.972524, 6.404970, -6.426511>, <7.969358, 6.405400, -6.440954>, <8.004102, 6.438336, -6.435908>, <8.008101, 6.438764, -6.421673>, 
      <7.972524, 6.242247, -6.426511>, <7.969358, 6.242677, -6.440954>, <8.004102, 6.255335, -6.435908>, <8.008101, 6.255764, -6.421673>, 
      <7.972524, 6.025282, -6.426511>, <7.969358, 6.024852, -6.440954>, <8.004102, 6.012193, -6.435908>, <8.008101, 6.011764, -6.421673>, 
      <7.972524, 5.862558, -6.426511>, <7.969358, 5.862128, -6.440954>, <8.004102, 5.829193, -6.435908>, <8.008101, 5.828764, -6.421673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.441965, 6.404970, -6.313737>, <7.437966, 6.405400, -6.327972>, <7.408265, 6.438334, -6.309290>, <7.411431, 6.438764, -6.294846>, 
      <7.601132, 6.404970, -6.347570>, <7.597133, 6.405400, -6.361804>, <7.587266, 6.438334, -6.347337>, <7.590432, 6.438764, -6.332894>, 
      <7.813356, 6.404970, -6.392679>, <7.810190, 6.405400, -6.407122>, <7.825102, 6.438336, -6.397860>, <7.829100, 6.438764, -6.383625>, 
      <7.972524, 6.404970, -6.426511>, <7.969358, 6.405400, -6.440954>, <8.004102, 6.438336, -6.435908>, <8.008101, 6.438764, -6.421673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.726178, 5.862558, -5.174572>, <7.648463, 5.862558, -5.518117>, <7.537195, 5.872783, -5.974784>, <7.441965, 5.862558, -6.313737>, 
      <7.726178, 6.025282, -5.174572>, <7.648463, 6.025282, -5.518117>, <7.537195, 6.035507, -5.974784>, <7.441965, 6.025282, -6.313737>, 
      <7.726178, 6.242247, -5.174572>, <7.648463, 6.242247, -5.518117>, <7.537195, 6.232022, -5.974784>, <7.441965, 6.242247, -6.313737>, 
      <7.726178, 6.404970, -5.174572>, <7.648463, 6.404970, -5.518117>, <7.537195, 6.394745, -5.974784>, <7.441965, 6.404970, -6.313737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.256737, 5.862558, -5.287346>, <8.179022, 5.862558, -5.630891>, <8.047907, 5.872804, -6.082600>, <7.972524, 5.862558, -6.426511>, 
      <8.097570, 5.862558, -5.253514>, <8.019855, 5.862558, -5.597059>, <7.888739, 5.872804, -6.048768>, <7.813356, 5.862558, -6.392679>, 
      <7.885346, 5.862558, -5.208404>, <7.807631, 5.862558, -5.551949>, <7.696363, 5.872783, -6.008616>, <7.601132, 5.862558, -6.347570>, 
      <7.726178, 5.862558, -5.174572>, <7.648463, 5.862558, -5.518117>, <7.537195, 5.872783, -5.974784>, <7.441965, 5.862558, -6.313737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.256737, 6.404970, -5.287346>, <8.179022, 6.404970, -5.630891>, <8.047907, 6.394724, -6.082600>, <7.972524, 6.404970, -6.426511>, 
      <8.256737, 6.242247, -5.287346>, <8.179022, 6.242247, -5.630891>, <8.047907, 6.232001, -6.082600>, <7.972524, 6.242247, -6.426511>, 
      <8.256737, 6.025282, -5.287346>, <8.179022, 6.025282, -5.630891>, <8.047907, 6.035528, -6.082600>, <7.972524, 6.025282, -6.426511>, 
      <8.256737, 5.862558, -5.287346>, <8.179022, 5.862558, -5.630891>, <8.047907, 5.872804, -6.082600>, <7.972524, 5.862558, -6.426511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.726178, 6.404970, -5.174572>, <7.648463, 6.404970, -5.518117>, <7.537195, 6.394745, -5.974784>, <7.441965, 6.404970, -6.313737>, 
      <7.885346, 6.404970, -5.208404>, <7.807631, 6.404970, -5.551949>, <7.696363, 6.394745, -6.008616>, <7.601132, 6.404970, -6.347570>, 
      <8.097570, 6.404970, -5.253514>, <8.019855, 6.404970, -5.597059>, <7.888739, 6.394724, -6.048768>, <7.813356, 6.404970, -6.392679>, 
      <8.256737, 6.404970, -5.287346>, <8.179022, 6.404970, -5.630891>, <8.047907, 6.394724, -6.082600>, <7.972524, 6.404970, -6.426511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.411431, 5.828764, -6.294846>, <7.485394, 5.818730, -5.957391>, <7.614786, 5.828764, -5.514348>, <7.691058, 5.828764, -5.177258>, 
      <7.411431, 6.011764, -6.294846>, <7.485394, 6.001730, -5.957391>, <7.614786, 6.011764, -5.514348>, <7.691058, 6.011764, -5.177258>, 
      <7.411431, 6.255764, -6.294846>, <7.485394, 6.265798, -5.957391>, <7.614786, 6.255764, -5.514348>, <7.691058, 6.255764, -5.177258>, 
      <7.411431, 6.438764, -6.294846>, <7.485394, 6.448799, -5.957391>, <7.614786, 6.438764, -5.514348>, <7.691058, 6.438764, -5.177258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.008101, 5.828764, -6.421673>, <8.101502, 5.818750, -6.089072>, <8.211455, 5.828764, -5.641175>, <8.287727, 5.828764, -5.304084>, 
      <7.829100, 5.828764, -6.383625>, <7.922502, 5.818750, -6.051024>, <8.032454, 5.828764, -5.603127>, <8.108726, 5.828764, -5.266036>, 
      <7.590432, 5.828764, -6.332894>, <7.664395, 5.818730, -5.995438>, <7.793786, 5.828764, -5.552396>, <7.870058, 5.828764, -5.215305>, 
      <7.411431, 5.828764, -6.294846>, <7.485394, 5.818730, -5.957391>, <7.614786, 5.828764, -5.514348>, <7.691058, 5.828764, -5.177258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.008101, 6.438764, -6.421673>, <8.101502, 6.448778, -6.089072>, <8.211455, 6.438764, -5.641175>, <8.287727, 6.438764, -5.304084>, 
      <8.008101, 6.255764, -6.421673>, <8.101502, 6.265778, -6.089072>, <8.211455, 6.255764, -5.641175>, <8.287727, 6.255764, -5.304084>, 
      <8.008101, 6.011764, -6.421673>, <8.101502, 6.001750, -6.089072>, <8.211455, 6.011764, -5.641175>, <8.287727, 6.011764, -5.304084>, 
      <8.008101, 5.828764, -6.421673>, <8.101502, 5.818750, -6.089072>, <8.211455, 5.828764, -5.641175>, <8.287727, 5.828764, -5.304084>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.411431, 6.438764, -6.294846>, <7.485394, 6.448799, -5.957391>, <7.614786, 6.438764, -5.514348>, <7.691058, 6.438764, -5.177258>, 
      <7.590432, 6.438764, -6.332894>, <7.664395, 6.448799, -5.995438>, <7.793786, 6.438764, -5.552396>, <7.870058, 6.438764, -5.215305>, 
      <7.829100, 6.438764, -6.383625>, <7.922502, 6.448778, -6.051024>, <8.032454, 6.438764, -5.603127>, <8.108726, 6.438764, -5.266036>, 
      <8.008101, 6.438764, -6.421673>, <8.101502, 6.448778, -6.089072>, <8.211455, 6.438764, -5.641175>, <8.287727, 6.438764, -5.304084>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.691058, 5.828764, -5.177258>, <7.823153, 5.828764, -4.593450>, <7.971559, 5.818628, -3.808851>, <8.105886, 5.828764, -3.225641>, 
      <7.691058, 6.011764, -5.177258>, <7.823153, 6.011764, -4.593450>, <7.971559, 6.001628, -3.808851>, <8.105886, 6.011764, -3.225641>, 
      <7.691058, 6.255764, -5.177258>, <7.823153, 6.255764, -4.593450>, <7.971559, 6.265899, -3.808851>, <8.105886, 6.255764, -3.225641>, 
      <7.691058, 6.438764, -5.177258>, <7.823153, 6.438764, -4.593450>, <7.971559, 6.448899, -3.808851>, <8.105886, 6.438764, -3.225641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.287727, 5.828764, -5.304084>, <8.419822, 5.828764, -4.720276>, <8.588058, 5.818628, -3.939891>, <8.702557, 5.828764, -3.352467>, 
      <8.108726, 5.828764, -5.266036>, <8.240822, 5.828764, -4.682228>, <8.409057, 5.818628, -3.901844>, <8.523556, 5.828764, -3.314419>, 
      <7.870058, 5.828764, -5.215305>, <8.002154, 5.828764, -4.631498>, <8.150560, 5.818628, -3.846898>, <8.284887, 5.828764, -3.263689>, 
      <7.691058, 5.828764, -5.177258>, <7.823153, 5.828764, -4.593450>, <7.971559, 5.818628, -3.808851>, <8.105886, 5.828764, -3.225641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.287727, 6.438764, -5.304084>, <8.419822, 6.438764, -4.720276>, <8.588058, 6.448899, -3.939891>, <8.702557, 6.438764, -3.352467>, 
      <8.287727, 6.255764, -5.304084>, <8.419822, 6.255764, -4.720276>, <8.588058, 6.265899, -3.939891>, <8.702557, 6.255764, -3.352467>, 
      <8.287727, 6.011764, -5.304084>, <8.419822, 6.011764, -4.720276>, <8.588058, 6.001628, -3.939891>, <8.702557, 6.011764, -3.352467>, 
      <8.287727, 5.828764, -5.304084>, <8.419822, 5.828764, -4.720276>, <8.588058, 5.818628, -3.939891>, <8.702557, 5.828764, -3.352467>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.691058, 6.438764, -5.177258>, <7.823153, 6.438764, -4.593450>, <7.971559, 6.448899, -3.808851>, <8.105886, 6.438764, -3.225641>, 
      <7.870058, 6.438764, -5.215305>, <8.002154, 6.438764, -4.631498>, <8.150560, 6.448899, -3.846898>, <8.284887, 6.438764, -3.263689>, 
      <8.108726, 6.438764, -5.266036>, <8.240822, 6.438764, -4.682228>, <8.409057, 6.448899, -3.901844>, <8.523556, 6.438764, -3.314419>, 
      <8.287727, 6.438764, -5.304084>, <8.419822, 6.438764, -4.720276>, <8.588058, 6.448899, -3.939891>, <8.702557, 6.438764, -3.352467>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.138942, 5.862558, -3.232667>, <8.025063, 5.872694, -3.817177>, <7.857587, 5.862558, -4.593663>, <7.726178, 5.862558, -5.174572>, 
      <8.138942, 6.025282, -3.232667>, <8.025063, 6.035417, -3.817177>, <7.857587, 6.025282, -4.593663>, <7.726178, 6.025282, -5.174572>, 
      <8.138942, 6.242247, -3.232667>, <8.025063, 6.232112, -3.817177>, <7.857587, 6.242247, -4.593663>, <7.726178, 6.242247, -5.174572>, 
      <8.138942, 6.404970, -3.232667>, <8.025063, 6.394835, -3.817177>, <7.857587, 6.404970, -4.593663>, <7.726178, 6.404970, -5.174572>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.669502, 5.862558, -3.345441>, <8.535794, 5.872694, -3.925736>, <8.388146, 5.862558, -4.706437>, <8.256737, 5.862558, -5.287346>, 
      <8.510334, 5.862558, -3.311609>, <8.376627, 5.872694, -3.891904>, <8.228978, 5.862558, -4.672605>, <8.097570, 5.862558, -5.253514>, 
      <8.298110, 5.862558, -3.266499>, <8.184231, 5.872694, -3.851009>, <8.016754, 5.862558, -4.627495>, <7.885346, 5.862558, -5.208404>, 
      <8.138942, 5.862558, -3.232667>, <8.025063, 5.872694, -3.817177>, <7.857587, 5.862558, -4.593663>, <7.726178, 5.862558, -5.174572>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.669502, 6.404970, -3.345441>, <8.535794, 6.394835, -3.925736>, <8.388146, 6.404970, -4.706437>, <8.256737, 6.404970, -5.287346>, 
      <8.669502, 6.242247, -3.345441>, <8.535794, 6.232112, -3.925736>, <8.388146, 6.242247, -4.706437>, <8.256737, 6.242247, -5.287346>, 
      <8.669502, 6.025282, -3.345441>, <8.535794, 6.035417, -3.925736>, <8.388146, 6.025282, -4.706437>, <8.256737, 6.025282, -5.287346>, 
      <8.669502, 5.862558, -3.345441>, <8.535794, 5.872694, -3.925736>, <8.388146, 5.862558, -4.706437>, <8.256737, 5.862558, -5.287346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.138942, 6.404970, -3.232667>, <8.025063, 6.394835, -3.817177>, <7.857587, 6.404970, -4.593663>, <7.726178, 6.404970, -5.174572>, 
      <8.298110, 6.404970, -3.266499>, <8.184231, 6.394835, -3.851009>, <8.016754, 6.404970, -4.627495>, <7.885346, 6.404970, -5.208404>, 
      <8.510334, 6.404970, -3.311609>, <8.376627, 6.394835, -3.891904>, <8.228978, 6.404970, -4.672605>, <8.097570, 6.404970, -5.253514>, 
      <8.669502, 6.404970, -3.345441>, <8.535794, 6.394835, -3.925736>, <8.388146, 6.404970, -4.706437>, <8.256737, 6.404970, -5.287346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.105886, 5.828764, -3.225641>, <8.109104, 5.829007, -3.211671>, <8.141685, 5.862314, -3.218596>, <8.138942, 5.862558, -3.232667>, 
      <8.105886, 6.011764, -3.225641>, <8.109104, 6.012007, -3.211671>, <8.141685, 6.025038, -3.218596>, <8.138942, 6.025282, -3.232667>, 
      <8.105886, 6.255764, -3.225641>, <8.109104, 6.255521, -3.211671>, <8.141685, 6.242491, -3.218596>, <8.138942, 6.242247, -3.232667>, 
      <8.105886, 6.438764, -3.225641>, <8.109104, 6.438521, -3.211671>, <8.141685, 6.405214, -3.218596>, <8.138942, 6.404970, -3.232667>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.702557, 5.828764, -3.352467>, <8.705299, 5.829007, -3.338396>, <8.672720, 5.862314, -3.331471>, <8.669502, 5.862558, -3.345441>, 
      <8.523556, 5.828764, -3.314419>, <8.526298, 5.829007, -3.300349>, <8.513553, 5.862314, -3.297639>, <8.510334, 5.862558, -3.311609>, 
      <8.284887, 5.828764, -3.263689>, <8.288105, 5.829007, -3.249719>, <8.300852, 5.862314, -3.252428>, <8.298110, 5.862558, -3.266499>, 
      <8.105886, 5.828764, -3.225641>, <8.109104, 5.829007, -3.211671>, <8.141685, 5.862314, -3.218596>, <8.138942, 5.862558, -3.232667>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.702557, 6.438764, -3.352467>, <8.705299, 6.438521, -3.338396>, <8.672720, 6.405214, -3.331471>, <8.669502, 6.404970, -3.345441>, 
      <8.702557, 6.255764, -3.352467>, <8.705299, 6.255521, -3.338396>, <8.672720, 6.242491, -3.331471>, <8.669502, 6.242247, -3.345441>, 
      <8.702557, 6.011764, -3.352467>, <8.705299, 6.012007, -3.338396>, <8.672720, 6.025038, -3.331471>, <8.669502, 6.025282, -3.345441>, 
      <8.702557, 5.828764, -3.352467>, <8.705299, 5.829007, -3.338396>, <8.672720, 5.862314, -3.331471>, <8.669502, 5.862558, -3.345441>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.105886, 6.438764, -3.225641>, <8.109104, 6.438521, -3.211671>, <8.141685, 6.405214, -3.218596>, <8.138942, 6.404970, -3.232667>, 
      <8.284887, 6.438764, -3.263689>, <8.288105, 6.438521, -3.249719>, <8.300852, 6.405214, -3.252428>, <8.298110, 6.404970, -3.266499>, 
      <8.523556, 6.438764, -3.314419>, <8.526298, 6.438521, -3.300349>, <8.513553, 6.405214, -3.297639>, <8.510334, 6.404970, -3.311609>, 
      <8.702557, 6.438764, -3.352467>, <8.705299, 6.438521, -3.338396>, <8.672720, 6.405214, -3.331471>, <8.669502, 6.404970, -3.345441>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.310158, -5.682382, -1.892719>, <9.262045, -5.682382, -1.882493>, <9.222006, -5.723315, -1.873982>, <9.222006, -5.772503, -1.873982>, 
      <9.328056, -5.682382, -1.804070>, <9.279943, -5.682382, -1.793844>, <9.239927, -5.723315, -1.785339>, <9.239927, -5.772503, -1.785339>, 
      <9.357753, -5.682382, -1.686642>, <9.320400, -5.682382, -1.678703>, <9.268222, -5.734316, -1.667769>, <9.268222, -5.772503, -1.667769>, 
      <9.367122, -5.682382, -1.596691>, <9.329770, -5.682382, -1.588752>, <9.279192, -5.734316, -1.578000>, <9.279192, -5.772503, -1.578000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.125307, -5.682382, -2.553617>, <9.088754, -5.682382, -2.520704>, <9.058334, -5.723315, -2.493315>, <9.058334, -5.772503, -2.493315>, 
      <9.158458, -5.682382, -2.519280>, <9.121906, -5.682382, -2.486367>, <9.082082, -5.723315, -2.469342>, <9.082082, -5.772503, -2.469342>, 
      <9.189201, -5.682382, -2.460223>, <9.151801, -5.682382, -2.452273>, <9.105286, -5.734268, -2.428145>, <9.105286, -5.772503, -2.428145>, 
      <9.202057, -5.682382, -2.414258>, <9.164658, -5.682382, -2.406309>, <9.113907, -5.734268, -2.395521>, <9.113907, -5.772503, -2.395521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.222006, -5.772503, -1.873982>, <9.222006, -5.821691, -1.873982>, <9.262045, -5.862624, -1.882493>, <9.310158, -5.862624, -1.892719>, 
      <9.239927, -5.772503, -1.785339>, <9.239927, -5.821691, -1.785339>, <9.279943, -5.862624, -1.793844>, <9.328056, -5.862624, -1.804070>, 
      <9.268222, -5.772503, -1.667769>, <9.268222, -5.810690, -1.667769>, <9.320400, -5.862624, -1.678703>, <9.357753, -5.862624, -1.686642>, 
      <9.279192, -5.772503, -1.578000>, <9.279192, -5.810690, -1.578000>, <9.329770, -5.862624, -1.588752>, <9.367122, -5.862624, -1.596691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.058334, -5.772503, -2.493315>, <9.058334, -5.821690, -2.493315>, <9.088754, -5.862624, -2.520704>, <9.125307, -5.862624, -2.553617>, 
      <9.082082, -5.772503, -2.469342>, <9.082082, -5.821690, -2.469342>, <9.121906, -5.862624, -2.486367>, <9.158458, -5.862624, -2.519280>, 
      <9.105286, -5.772503, -2.428145>, <9.105286, -5.810738, -2.428145>, <9.151801, -5.862624, -2.452273>, <9.189201, -5.862624, -2.460223>, 
      <9.113907, -5.772503, -2.395521>, <9.113907, -5.810738, -2.395521>, <9.164658, -5.862624, -2.406309>, <9.202057, -5.862624, -2.414258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.310158, -5.862624, -1.892719>, <9.358270, -5.862624, -1.902946>, <9.398309, -5.821690, -1.911456>, <9.398309, -5.772503, -1.911456>, 
      <9.328056, -5.862624, -1.804070>, <9.376170, -5.862624, -1.814297>, <9.416193, -5.821690, -1.822803>, <9.416193, -5.772503, -1.822803>, 
      <9.357753, -5.862624, -1.686642>, <9.395125, -5.862624, -1.694586>, <9.447082, -5.810710, -1.705479>, <9.447082, -5.772503, -1.705479>, 
      <9.367122, -5.862624, -1.596691>, <9.404494, -5.862624, -1.604635>, <9.455145, -5.810710, -1.615401>, <9.455145, -5.772503, -1.615401>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.125307, -5.862624, -2.553617>, <9.161861, -5.862624, -2.586529>, <9.192280, -5.821690, -2.613919>, <9.192280, -5.772503, -2.613919>, 
      <9.158458, -5.862624, -2.519280>, <9.195012, -5.862624, -2.552193>, <9.234313, -5.821690, -2.568727>, <9.234313, -5.772503, -2.568727>, 
      <9.189201, -5.862624, -2.460223>, <9.226600, -5.862624, -2.468173>, <9.272838, -5.810738, -2.492219>, <9.272838, -5.772503, -2.492219>, 
      <9.202057, -5.862624, -2.414258>, <9.239456, -5.862624, -2.422208>, <9.290209, -5.810738, -2.432996>, <9.290209, -5.772503, -2.432996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.398309, -5.772503, -1.911456>, <9.398309, -5.723315, -1.911456>, <9.358270, -5.682382, -1.902946>, <9.310158, -5.682382, -1.892719>, 
      <9.416193, -5.772503, -1.822803>, <9.416193, -5.723315, -1.822803>, <9.376170, -5.682382, -1.814297>, <9.328056, -5.682382, -1.804070>, 
      <9.447082, -5.772503, -1.705479>, <9.447082, -5.734296, -1.705479>, <9.395125, -5.682382, -1.694586>, <9.357753, -5.682382, -1.686642>, 
      <9.455145, -5.772503, -1.615401>, <9.455145, -5.734296, -1.615401>, <9.404494, -5.682382, -1.604635>, <9.367122, -5.682382, -1.596691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.192280, -5.772503, -2.613919>, <9.192280, -5.723315, -2.613919>, <9.161861, -5.682382, -2.586529>, <9.125307, -5.682382, -2.553617>, 
      <9.234313, -5.772503, -2.568727>, <9.234313, -5.723315, -2.568727>, <9.195012, -5.682382, -2.552193>, <9.158458, -5.682382, -2.519280>, 
      <9.272838, -5.772503, -2.492219>, <9.272838, -5.734268, -2.492219>, <9.226600, -5.682382, -2.468173>, <9.189201, -5.682382, -2.460223>, 
      <9.290209, -5.772503, -2.432996>, <9.290209, -5.734268, -2.432996>, <9.239456, -5.682382, -2.422208>, <9.202057, -5.682382, -2.414258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.032068, -5.654445, -1.184012>, <9.050017, -5.662826, -1.189673>, <9.073282, -5.680065, -1.194359>, <9.091894, -5.682382, -1.202880>, 
      <9.045466, -5.654445, -1.120985>, <9.063414, -5.662826, -1.126645>, <9.083509, -5.680065, -1.146246>, <9.102122, -5.682382, -1.154767>, 
      <9.056613, -5.708068, -1.068536>, <9.072818, -5.708068, -1.082393>, <9.092197, -5.723315, -1.104012>, <9.110631, -5.723315, -1.114727>, 
      <9.056613, -5.772503, -1.068536>, <9.072818, -5.772503, -1.082393>, <9.092197, -5.772503, -1.104012>, <9.110631, -5.772503, -1.114727>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.007522, -5.772503, -1.299492>, <9.027212, -5.772503, -1.296954>, <9.054075, -5.772503, -1.285547>, <9.073156, -5.772503, -1.291032>, 
      <9.007522, -5.708066, -1.299492>, <9.027212, -5.708066, -1.296954>, <9.054075, -5.723315, -1.285547>, <9.073156, -5.723315, -1.291032>, 
      <9.018671, -5.654445, -1.247041>, <9.036619, -5.662826, -1.252701>, <9.063054, -5.680065, -1.242473>, <9.081667, -5.682382, -1.250993>, 
      <9.032068, -5.654445, -1.184012>, <9.050017, -5.662826, -1.189673>, <9.073282, -5.680065, -1.194359>, <9.091894, -5.682382, -1.202880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.032068, -5.890561, -1.184012>, <9.050017, -5.882180, -1.189673>, <9.073282, -5.864941, -1.194359>, <9.091894, -5.862624, -1.202880>, 
      <9.018671, -5.890561, -1.247041>, <9.036619, -5.882180, -1.252701>, <9.063054, -5.864941, -1.242473>, <9.081667, -5.862624, -1.250993>, 
      <9.007522, -5.836939, -1.299492>, <9.027212, -5.836939, -1.296954>, <9.054075, -5.821691, -1.285547>, <9.073156, -5.821691, -1.291032>, 
      <9.007522, -5.772503, -1.299492>, <9.027212, -5.772503, -1.296954>, <9.054075, -5.772503, -1.285547>, <9.073156, -5.772503, -1.291032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.056613, -5.772503, -1.068536>, <9.072818, -5.772503, -1.082393>, <9.092197, -5.772503, -1.104012>, <9.110631, -5.772503, -1.114727>, 
      <9.056613, -5.836938, -1.068536>, <9.072818, -5.836938, -1.082393>, <9.092197, -5.821691, -1.104012>, <9.110631, -5.821691, -1.114727>, 
      <9.045466, -5.890561, -1.120985>, <9.063414, -5.882180, -1.126645>, <9.083509, -5.864941, -1.146246>, <9.102122, -5.862624, -1.154767>, 
      <9.032068, -5.890561, -1.184012>, <9.050017, -5.882180, -1.189673>, <9.073282, -5.864941, -1.194359>, <9.091894, -5.862624, -1.202880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.091894, -5.682382, -1.202880>, <9.141971, -5.688615, -1.225804>, <9.215322, -5.682382, -1.249670>, <9.256512, -5.682382, -1.286758>, 
      <9.102122, -5.682382, -1.154767>, <9.152198, -5.688615, -1.177691>, <9.248234, -5.682382, -1.213116>, <9.289425, -5.682382, -1.250204>, 
      <9.110631, -5.723315, -1.114727>, <9.170650, -5.723315, -1.149614>, <9.265223, -5.723315, -1.173332>, <9.316814, -5.723315, -1.219784>, 
      <9.110631, -5.772503, -1.114727>, <9.170650, -5.772503, -1.149614>, <9.265223, -5.772503, -1.173332>, <9.316814, -5.772503, -1.219784>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.073156, -5.772503, -1.291032>, <9.112975, -5.772503, -1.302478>, <9.165419, -5.772503, -1.326007>, <9.196209, -5.772503, -1.353730>, 
      <9.073156, -5.723315, -1.291032>, <9.112975, -5.723315, -1.302478>, <9.165419, -5.723315, -1.326007>, <9.196209, -5.723315, -1.353730>, 
      <9.081667, -5.682382, -1.250993>, <9.131744, -5.688615, -1.273917>, <9.182408, -5.682382, -1.286224>, <9.223598, -5.682382, -1.323311>, 
      <9.091894, -5.682382, -1.202880>, <9.141971, -5.688615, -1.225804>, <9.215322, -5.682382, -1.249670>, <9.256512, -5.682382, -1.286758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.091894, -5.862624, -1.202880>, <9.141971, -5.856390, -1.225804>, <9.215322, -5.862624, -1.249670>, <9.256512, -5.862624, -1.286758>, 
      <9.081667, -5.862624, -1.250993>, <9.131744, -5.856390, -1.273917>, <9.182408, -5.862624, -1.286224>, <9.223598, -5.862624, -1.323311>, 
      <9.073156, -5.821691, -1.291032>, <9.112975, -5.821691, -1.302478>, <9.165419, -5.821690, -1.326007>, <9.196209, -5.821690, -1.353730>, 
      <9.073156, -5.772503, -1.291032>, <9.112975, -5.772503, -1.302478>, <9.165419, -5.772503, -1.326007>, <9.196209, -5.772503, -1.353730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.110631, -5.772503, -1.114727>, <9.170650, -5.772503, -1.149614>, <9.265223, -5.772503, -1.173332>, <9.316814, -5.772503, -1.219784>, 
      <9.110631, -5.821691, -1.114727>, <9.170650, -5.821691, -1.149614>, <9.265223, -5.821690, -1.173332>, <9.316814, -5.821690, -1.219784>, 
      <9.102122, -5.862624, -1.154767>, <9.152198, -5.856390, -1.177691>, <9.248234, -5.862624, -1.213116>, <9.289425, -5.862624, -1.250204>, 
      <9.091894, -5.862624, -1.202880>, <9.141971, -5.856390, -1.225804>, <9.215322, -5.862624, -1.249670>, <9.256512, -5.862624, -1.286758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.256512, -5.682382, -1.286758>, <9.297702, -5.682382, -1.323845>, <9.338506, -5.682382, -1.389504>, <9.357137, -5.682382, -1.441706>, 
      <9.289425, -5.682382, -1.250204>, <9.330615, -5.682382, -1.287291>, <9.385287, -5.682382, -1.374304>, <9.403918, -5.682382, -1.426506>, 
      <9.316814, -5.723315, -1.219784>, <9.368403, -5.723315, -1.266236>, <9.419932, -5.723315, -1.348326>, <9.442846, -5.723315, -1.413858>, 
      <9.316814, -5.772503, -1.219784>, <9.368403, -5.772503, -1.266236>, <9.419932, -5.772503, -1.348326>, <9.442846, -5.772503, -1.413858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.196209, -5.772503, -1.353730>, <9.226998, -5.772503, -1.381453>, <9.257050, -5.772503, -1.430698>, <9.271427, -5.772503, -1.469555>, 
      <9.196209, -5.723315, -1.353730>, <9.226998, -5.723315, -1.381453>, <9.257050, -5.723315, -1.430698>, <9.271427, -5.723315, -1.469555>, 
      <9.223598, -5.682382, -1.323311>, <9.264789, -5.682382, -1.360399>, <9.291726, -5.682382, -1.404704>, <9.310356, -5.682382, -1.456906>, 
      <9.256512, -5.682382, -1.286758>, <9.297702, -5.682382, -1.323845>, <9.338506, -5.682382, -1.389504>, <9.357137, -5.682382, -1.441706>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.256512, -5.862624, -1.286758>, <9.297702, -5.862624, -1.323845>, <9.338506, -5.862624, -1.389504>, <9.357137, -5.862624, -1.441706>, 
      <9.223598, -5.862624, -1.323311>, <9.264789, -5.862624, -1.360399>, <9.291726, -5.862624, -1.404704>, <9.310356, -5.862624, -1.456906>, 
      <9.196209, -5.821690, -1.353730>, <9.226998, -5.821690, -1.381453>, <9.257050, -5.821690, -1.430698>, <9.271427, -5.821690, -1.469555>, 
      <9.196209, -5.772503, -1.353730>, <9.226998, -5.772503, -1.381453>, <9.257050, -5.772503, -1.430698>, <9.271427, -5.772503, -1.469555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.316814, -5.772503, -1.219784>, <9.368403, -5.772503, -1.266236>, <9.419932, -5.772503, -1.348326>, <9.442846, -5.772503, -1.413858>, 
      <9.316814, -5.821690, -1.219784>, <9.368403, -5.821690, -1.266236>, <9.419932, -5.821690, -1.348326>, <9.442846, -5.821690, -1.413858>, 
      <9.289425, -5.862624, -1.250204>, <9.330615, -5.862624, -1.287291>, <9.385287, -5.862624, -1.374304>, <9.403918, -5.862624, -1.426506>, 
      <9.256512, -5.862624, -1.286758>, <9.297702, -5.862624, -1.323845>, <9.338506, -5.862624, -1.389504>, <9.357137, -5.862624, -1.441706>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.357137, -5.682382, -1.441706>, <9.372797, -5.682382, -1.485587>, <9.371950, -5.682382, -1.550350>, <9.367122, -5.682382, -1.596691>, 
      <9.403918, -5.682382, -1.426506>, <9.419578, -5.682382, -1.470387>, <9.409322, -5.682382, -1.558294>, <9.404494, -5.682382, -1.604635>, 
      <9.442846, -5.723315, -1.413858>, <9.462840, -5.723315, -1.471038>, <9.460546, -5.734296, -1.555066>, <9.455145, -5.734296, -1.615401>, 
      <9.442846, -5.772503, -1.413858>, <9.462840, -5.772503, -1.471038>, <9.460546, -5.772503, -1.555066>, <9.455145, -5.772503, -1.615401>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.271427, -5.772503, -1.469555>, <9.282746, -5.772503, -1.500145>, <9.283149, -5.772503, -1.545624>, <9.279192, -5.772503, -1.578000>, 
      <9.271427, -5.723315, -1.469555>, <9.282746, -5.723315, -1.500145>, <9.283149, -5.734316, -1.545624>, <9.279192, -5.734316, -1.578000>, 
      <9.310356, -5.682382, -1.456906>, <9.326017, -5.682382, -1.500787>, <9.334598, -5.682382, -1.542410>, <9.329770, -5.682382, -1.588752>, 
      <9.357137, -5.682382, -1.441706>, <9.372797, -5.682382, -1.485587>, <9.371950, -5.682382, -1.550350>, <9.367122, -5.682382, -1.596691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.357137, -5.862624, -1.441706>, <9.372797, -5.862624, -1.485587>, <9.371950, -5.862624, -1.550350>, <9.367122, -5.862624, -1.596691>, 
      <9.310356, -5.862624, -1.456906>, <9.326017, -5.862624, -1.500787>, <9.334598, -5.862624, -1.542410>, <9.329770, -5.862624, -1.588752>, 
      <9.271427, -5.821690, -1.469555>, <9.282746, -5.821690, -1.500145>, <9.283149, -5.810690, -1.545624>, <9.279192, -5.810690, -1.578000>, 
      <9.271427, -5.772503, -1.469555>, <9.282746, -5.772503, -1.500145>, <9.283149, -5.772503, -1.545624>, <9.279192, -5.772503, -1.578000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.442846, -5.772503, -1.413858>, <9.462840, -5.772503, -1.471038>, <9.460546, -5.772503, -1.555066>, <9.455145, -5.772503, -1.615401>, 
      <9.442846, -5.821690, -1.413858>, <9.462840, -5.821690, -1.471038>, <9.460546, -5.810710, -1.555066>, <9.455145, -5.810710, -1.615401>, 
      <9.403918, -5.862624, -1.426506>, <9.419578, -5.862624, -1.470387>, <9.409322, -5.862624, -1.558294>, <9.404494, -5.862624, -1.604635>, 
      <9.357137, -5.862624, -1.441706>, <9.372797, -5.862624, -1.485587>, <9.371950, -5.862624, -1.550350>, <9.367122, -5.862624, -1.596691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.310158, -5.682382, -1.892719>, <9.278535, -5.682382, -2.049346>, <9.245097, -5.682382, -2.260377>, <9.202057, -5.682382, -2.414258>, 
      <9.358270, -5.682382, -1.902946>, <9.326648, -5.682382, -2.059573>, <9.282497, -5.682382, -2.268327>, <9.239456, -5.682382, -2.422208>, 
      <9.398309, -5.723315, -1.911456>, <9.366710, -5.723315, -2.068088>, <9.335179, -5.734268, -2.279667>, <9.290209, -5.734268, -2.432996>, 
      <9.398309, -5.772503, -1.911456>, <9.366710, -5.772503, -2.068088>, <9.335179, -5.772503, -2.279667>, <9.290209, -5.772503, -2.432996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.222006, -5.772503, -1.873982>, <9.190341, -5.772503, -2.030600>, <9.154733, -5.772503, -2.241037>, <9.113907, -5.772503, -2.395521>, 
      <9.222006, -5.723315, -1.873982>, <9.190341, -5.723315, -2.030600>, <9.154733, -5.734268, -2.241037>, <9.113907, -5.734268, -2.395521>, 
      <9.262045, -5.682382, -1.882493>, <9.230422, -5.682382, -2.039119>, <9.207698, -5.682382, -2.252427>, <9.164658, -5.682382, -2.406309>, 
      <9.310158, -5.682382, -1.892719>, <9.278535, -5.682382, -2.049346>, <9.245097, -5.682382, -2.260377>, <9.202057, -5.682382, -2.414258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.310158, -5.862624, -1.892719>, <9.278535, -5.862624, -2.049346>, <9.245097, -5.862624, -2.260377>, <9.202057, -5.862624, -2.414258>, 
      <9.262045, -5.862624, -1.882493>, <9.230422, -5.862624, -2.039119>, <9.207698, -5.862624, -2.252427>, <9.164658, -5.862624, -2.406309>, 
      <9.222006, -5.821691, -1.873982>, <9.190341, -5.821691, -2.030600>, <9.154733, -5.810738, -2.241037>, <9.113907, -5.810738, -2.395521>, 
      <9.222006, -5.772503, -1.873982>, <9.190341, -5.772503, -2.030600>, <9.154733, -5.772503, -2.241037>, <9.113907, -5.772503, -2.395521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.398309, -5.772503, -1.911456>, <9.366710, -5.772503, -2.068088>, <9.335179, -5.772503, -2.279667>, <9.290209, -5.772503, -2.432996>, 
      <9.398309, -5.821690, -1.911456>, <9.366710, -5.821690, -2.068088>, <9.335179, -5.810738, -2.279667>, <9.290209, -5.810738, -2.432996>, 
      <9.358270, -5.862624, -1.902946>, <9.326648, -5.862624, -2.059573>, <9.282497, -5.862624, -2.268327>, <9.239456, -5.862624, -2.422208>, 
      <9.310158, -5.862624, -1.892719>, <9.278535, -5.862624, -2.049346>, <9.245097, -5.862624, -2.260377>, <9.202057, -5.862624, -2.414258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.125307, -5.682382, -2.553617>, <9.086809, -5.682382, -2.593491>, <9.023072, -5.682382, -2.637114>, <8.970358, -5.682382, -2.654242>, 
      <9.161861, -5.682382, -2.586529>, <9.123362, -5.682382, -2.626404>, <9.038282, -5.682382, -2.685836>, <8.985568, -5.682382, -2.702963>, 
      <9.192280, -5.723315, -2.613919>, <9.144207, -5.723315, -2.665604>, <9.065338, -5.721462, -2.725127>, <8.998207, -5.721462, -2.746940>, 
      <9.192280, -5.772503, -2.613919>, <9.144207, -5.772503, -2.665604>, <9.065338, -5.772503, -2.725127>, <8.998207, -5.772503, -2.746940>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.058334, -5.772503, -2.493315>, <9.029175, -5.772503, -2.522748>, <8.981913, -5.772503, -2.555728>, <8.942509, -5.772503, -2.568532>, 
      <9.058334, -5.723315, -2.493315>, <9.029175, -5.723315, -2.522748>, <8.981913, -5.723315, -2.555728>, <8.942509, -5.723315, -2.568532>, 
      <9.088754, -5.682382, -2.520704>, <9.050256, -5.682382, -2.560579>, <9.008414, -5.682382, -2.590161>, <8.955699, -5.682382, -2.607289>, 
      <9.125307, -5.682382, -2.553617>, <9.086809, -5.682382, -2.593491>, <9.023072, -5.682382, -2.637114>, <8.970358, -5.682382, -2.654242>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.125307, -5.862624, -2.553617>, <9.086809, -5.862624, -2.593491>, <9.023072, -5.862624, -2.637114>, <8.970358, -5.862624, -2.654242>, 
      <9.088754, -5.862624, -2.520704>, <9.050256, -5.862624, -2.560579>, <9.008414, -5.862624, -2.590161>, <8.955699, -5.862624, -2.607289>, 
      <9.058334, -5.821690, -2.493315>, <9.029175, -5.821690, -2.522748>, <8.981913, -5.821691, -2.555728>, <8.942509, -5.821691, -2.568532>, 
      <9.058334, -5.772503, -2.493315>, <9.029175, -5.772503, -2.522748>, <8.981913, -5.772503, -2.555728>, <8.942509, -5.772503, -2.568532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.192280, -5.772503, -2.613919>, <9.144207, -5.772503, -2.665604>, <9.065338, -5.772503, -2.725127>, <8.998207, -5.772503, -2.746940>, 
      <9.192280, -5.821690, -2.613919>, <9.144207, -5.821690, -2.665604>, <9.065338, -5.823544, -2.725127>, <8.998207, -5.823544, -2.746940>, 
      <9.161861, -5.862624, -2.586529>, <9.123362, -5.862624, -2.626404>, <9.038282, -5.862624, -2.685836>, <8.985568, -5.862624, -2.702963>, 
      <9.125307, -5.862624, -2.553617>, <9.086809, -5.862624, -2.593491>, <9.023072, -5.862624, -2.637114>, <8.970358, -5.862624, -2.654242>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.970358, -5.682382, -2.654242>, <8.917645, -5.682382, -2.671370>, <8.840963, -5.688250, -2.664811>, <8.785856, -5.682382, -2.663911>, 
      <8.985568, -5.682382, -2.702963>, <8.932854, -5.682382, -2.720091>, <8.830737, -5.688250, -2.712924>, <8.775630, -5.682382, -2.712024>, 
      <8.998207, -5.721462, -2.746940>, <8.932258, -5.721462, -2.768368>, <8.836357, -5.723315, -2.748232>, <8.767119, -5.723315, -2.752062>, 
      <8.998207, -5.772503, -2.746940>, <8.932258, -5.772503, -2.768368>, <8.836357, -5.772503, -2.748232>, <8.767119, -5.772503, -2.752062>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.942509, -5.772503, -2.568532>, <8.903105, -5.772503, -2.581335>, <8.845472, -5.772503, -2.582504>, <8.804593, -5.772503, -2.575760>, 
      <8.942509, -5.723315, -2.568532>, <8.903105, -5.723315, -2.581335>, <8.845472, -5.723315, -2.582504>, <8.804593, -5.723315, -2.575760>, 
      <8.955699, -5.682382, -2.607289>, <8.902986, -5.682382, -2.624417>, <8.851190, -5.688250, -2.616699>, <8.796082, -5.682382, -2.615798>, 
      <8.970358, -5.682382, -2.654242>, <8.917645, -5.682382, -2.671370>, <8.840963, -5.688250, -2.664811>, <8.785856, -5.682382, -2.663911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.970358, -5.862624, -2.654242>, <8.917645, -5.862624, -2.671370>, <8.840963, -5.856755, -2.664811>, <8.785856, -5.862624, -2.663911>, 
      <8.955699, -5.862624, -2.607289>, <8.902986, -5.862624, -2.624417>, <8.851190, -5.856755, -2.616699>, <8.796082, -5.862624, -2.615798>, 
      <8.942509, -5.821691, -2.568532>, <8.903105, -5.821691, -2.581335>, <8.845472, -5.821690, -2.582504>, <8.804593, -5.821690, -2.575760>, 
      <8.942509, -5.772503, -2.568532>, <8.903105, -5.772503, -2.581335>, <8.845472, -5.772503, -2.582504>, <8.804593, -5.772503, -2.575760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.998207, -5.772503, -2.746940>, <8.932258, -5.772503, -2.768368>, <8.836357, -5.772503, -2.748232>, <8.767119, -5.772503, -2.752062>, 
      <8.998207, -5.823544, -2.746940>, <8.932258, -5.823544, -2.768368>, <8.836357, -5.821690, -2.748232>, <8.767119, -5.821690, -2.752062>, 
      <8.985568, -5.862624, -2.702963>, <8.932854, -5.862624, -2.720091>, <8.830737, -5.856755, -2.712924>, <8.775630, -5.862624, -2.712024>, 
      <8.970358, -5.862624, -2.654242>, <8.917645, -5.862624, -2.671370>, <8.840963, -5.856755, -2.664811>, <8.785856, -5.862624, -2.663911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.785856, -5.682382, -2.663911>, <8.765665, -5.680232, -2.663581>, <8.743206, -5.664088, -2.654335>, <8.724928, -5.656248, -2.650231>, 
      <8.775630, -5.682382, -2.712024>, <8.755439, -5.680232, -2.711694>, <8.728932, -5.664088, -2.716161>, <8.710654, -5.656248, -2.712057>, 
      <8.767119, -5.723315, -2.752062>, <8.746362, -5.723315, -2.753211>, <8.719279, -5.709051, -2.760073>, <8.698776, -5.709051, -2.763506>, 
      <8.767119, -5.772503, -2.752062>, <8.746362, -5.772503, -2.753211>, <8.719279, -5.772503, -2.760073>, <8.698776, -5.772503, -2.763506>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.804593, -5.772503, -2.575760>, <8.785026, -5.772503, -2.572533>, <8.767134, -5.772503, -2.548596>, <8.751079, -5.772503, -2.536954>, 
      <8.804593, -5.723315, -2.575760>, <8.785026, -5.723315, -2.572533>, <8.767134, -5.709051, -2.548596>, <8.751079, -5.709051, -2.536954>, 
      <8.796082, -5.682382, -2.615798>, <8.775891, -5.680232, -2.615468>, <8.757480, -5.664088, -2.592509>, <8.739202, -5.656248, -2.588405>, 
      <8.785856, -5.682382, -2.663911>, <8.765665, -5.680232, -2.663581>, <8.743206, -5.664088, -2.654335>, <8.724928, -5.656248, -2.650231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.785856, -5.862624, -2.663911>, <8.765665, -5.864774, -2.663581>, <8.743206, -5.880918, -2.654335>, <8.724928, -5.888759, -2.650231>, 
      <8.796082, -5.862624, -2.615798>, <8.775891, -5.864774, -2.615468>, <8.757480, -5.880918, -2.592509>, <8.739202, -5.888759, -2.588405>, 
      <8.804593, -5.821690, -2.575760>, <8.785026, -5.821690, -2.572533>, <8.767134, -5.835955, -2.548596>, <8.751079, -5.835955, -2.536954>, 
      <8.804593, -5.772503, -2.575760>, <8.785026, -5.772503, -2.572533>, <8.767134, -5.772503, -2.548596>, <8.751079, -5.772503, -2.536954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.767119, -5.772503, -2.752062>, <8.746362, -5.772503, -2.753211>, <8.719279, -5.772503, -2.760073>, <8.698776, -5.772503, -2.763506>, 
      <8.767119, -5.821690, -2.752062>, <8.746362, -5.821690, -2.753211>, <8.719279, -5.835955, -2.760073>, <8.698776, -5.835955, -2.763506>, 
      <8.775630, -5.862624, -2.712024>, <8.755439, -5.864774, -2.711694>, <8.728932, -5.880918, -2.716161>, <8.710654, -5.888759, -2.712057>, 
      <8.785856, -5.862624, -2.663911>, <8.765665, -5.864774, -2.663581>, <8.743206, -5.880918, -2.654335>, <8.724928, -5.888759, -2.650231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.578887, 6.969054, -3.253138>, <2.586582, 6.920472, -3.253138>, <2.592986, 6.880042, -3.294070>, <2.592985, 6.880042, -3.343258>, 
      <2.668352, 6.982288, -3.253138>, <2.676046, 6.933706, -3.253138>, <2.682445, 6.893301, -3.294070>, <2.682445, 6.893301, -3.343258>, 
      <2.787173, 7.005800, -3.253138>, <2.793147, 6.968083, -3.253138>, <2.801334, 6.915404, -3.305071>, <2.801334, 6.915404, -3.343258>, 
      <2.877491, 7.010449, -3.253138>, <2.883465, 6.972732, -3.253138>, <2.891554, 6.921661, -3.305071>, <2.891554, 6.921661, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.909222, 6.819046, -3.253138>, <1.940176, 6.780819, -3.253138>, <1.965936, 6.749009, -3.294070>, <1.965936, 6.749009, -3.343258>, 
      <1.945246, 6.850354, -3.253138>, <1.976201, 6.812128, -3.253138>, <1.991118, 6.771470, -3.294070>, <1.991118, 6.771470, -3.343258>, 
      <2.005831, 6.877965, -3.253138>, <2.011812, 6.840201, -3.253138>, <2.033473, 6.792485, -3.305023>, <2.033473, 6.792485, -3.343258>, 
      <2.052405, 6.888398, -3.253138>, <2.058386, 6.850633, -3.253138>, <2.066504, 6.799387, -3.305023>, <2.066504, 6.799387, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.592985, 6.880042, -3.343258>, <2.592985, 6.880042, -3.392446>, <2.586582, 6.920472, -3.433379>, <2.578887, 6.969054, -3.433379>, 
      <2.682445, 6.893301, -3.343258>, <2.682445, 6.893301, -3.392446>, <2.676046, 6.933706, -3.433379>, <2.668351, 6.982288, -3.433379>, 
      <2.801334, 6.915404, -3.343258>, <2.801334, 6.915404, -3.381445>, <2.793147, 6.968083, -3.433379>, <2.787173, 7.005800, -3.433379>, 
      <2.891554, 6.921661, -3.343258>, <2.891554, 6.921661, -3.381445>, <2.883465, 6.972732, -3.433379>, <2.877491, 7.010449, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.965936, 6.749009, -3.343258>, <1.965936, 6.749009, -3.392446>, <1.940176, 6.780819, -3.433379>, <1.909222, 6.819046, -3.433379>, 
      <1.991118, 6.771470, -3.343258>, <1.991118, 6.771470, -3.392446>, <1.976201, 6.812128, -3.433379>, <1.945246, 6.850354, -3.433379>, 
      <2.033473, 6.792485, -3.343258>, <2.033473, 6.792485, -3.381493>, <2.011812, 6.840201, -3.433379>, <2.005831, 6.877965, -3.433379>, 
      <2.066504, 6.799387, -3.343258>, <2.066504, 6.799387, -3.381493>, <2.058386, 6.850633, -3.433379>, <2.052405, 6.888398, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.578887, 6.969054, -3.433379>, <2.571192, 7.017636, -3.433379>, <2.564789, 7.058066, -3.392446>, <2.564789, 7.058066, -3.343258>, 
      <2.668351, 6.982288, -3.433379>, <2.660656, 7.030870, -3.433379>, <2.654256, 7.071286, -3.392446>, <2.654256, 7.071286, -3.343258>, 
      <2.787173, 7.005800, -3.433379>, <2.781195, 7.043536, -3.433379>, <2.773036, 7.095992, -3.381465>, <2.773036, 7.095992, -3.343258>, 
      <2.877491, 7.010449, -3.433379>, <2.871514, 7.048186, -3.433379>, <2.863413, 7.099329, -3.381465>, <2.863413, 7.099329, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.909222, 6.819046, -3.433379>, <1.878267, 6.857272, -3.433379>, <1.852507, 6.889082, -3.392446>, <1.852507, 6.889082, -3.343258>, 
      <1.945246, 6.850354, -3.433379>, <1.914291, 6.888580, -3.433379>, <1.899836, 6.928693, -3.392446>, <1.899836, 6.928693, -3.343258>, 
      <2.005831, 6.877965, -3.433379>, <1.999849, 6.915729, -3.433379>, <1.978256, 6.963162, -3.381493>, <1.978256, 6.963162, -3.343258>, 
      <2.052405, 6.888398, -3.433379>, <2.046423, 6.926162, -3.433379>, <2.038307, 6.977409, -3.381493>, <2.038307, 6.977409, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.564789, 7.058066, -3.343258>, <2.564790, 7.058066, -3.294070>, <2.571193, 7.017636, -3.253138>, <2.578887, 6.969054, -3.253138>, 
      <2.654256, 7.071286, -3.343258>, <2.654257, 7.071286, -3.294070>, <2.660657, 7.030870, -3.253138>, <2.668352, 6.982288, -3.253138>, 
      <2.773036, 7.095992, -3.343258>, <2.773036, 7.095992, -3.305051>, <2.781195, 7.043536, -3.253138>, <2.787173, 7.005800, -3.253138>, 
      <2.863413, 7.099329, -3.343258>, <2.863413, 7.099329, -3.305051>, <2.871514, 7.048186, -3.253138>, <2.877491, 7.010449, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.852507, 6.889082, -3.343258>, <1.852507, 6.889082, -3.294070>, <1.878267, 6.857272, -3.253138>, <1.909222, 6.819046, -3.253138>, 
      <1.899836, 6.928693, -3.343258>, <1.899836, 6.928693, -3.294070>, <1.914291, 6.888580, -3.253138>, <1.945246, 6.850354, -3.253138>, 
      <1.978256, 6.963162, -3.343258>, <1.978256, 6.963162, -3.305023>, <1.999849, 6.915729, -3.253138>, <2.005831, 6.877965, -3.253138>, 
      <2.038307, 6.977409, -3.343258>, <2.038307, 6.977409, -3.305023>, <2.046423, 6.926162, -3.253138>, <2.052405, 6.888398, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.272069, 6.654255, -3.225200>, <3.267356, 6.672475, -3.233581>, <3.263893, 6.695953, -3.250821>, <3.256359, 6.714986, -3.253138>, 
      <3.335711, 6.664335, -3.225200>, <3.330998, 6.682555, -3.233582>, <3.312476, 6.703648, -3.250821>, <3.304941, 6.722681, -3.253138>, 
      <3.388672, 6.672723, -3.278823>, <3.375682, 6.689631, -3.278823>, <3.355107, 6.710114, -3.294070>, <3.345371, 6.729084, -3.294070>, 
      <3.388672, 6.672723, -3.343258>, <3.375682, 6.689631, -3.343258>, <3.355107, 6.710114, -3.343258>, <3.345371, 6.729084, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.155463, 6.635786, -3.343258>, <3.159028, 6.655317, -3.343258>, <3.171825, 6.681547, -3.343258>, <3.167346, 6.700888, -3.343258>, 
      <3.155463, 6.635786, -3.278821>, <3.159028, 6.655317, -3.278821>, <3.171825, 6.681547, -3.294070>, <3.167346, 6.700888, -3.294070>, 
      <3.208426, 6.644176, -3.225200>, <3.203713, 6.662395, -3.233581>, <3.215311, 6.688259, -3.250821>, <3.207776, 6.707292, -3.253137>, 
      <3.272069, 6.654255, -3.225200>, <3.267356, 6.672475, -3.233581>, <3.263893, 6.695953, -3.250821>, <3.256359, 6.714986, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.272069, 6.654255, -3.461316>, <3.267356, 6.672475, -3.452935>, <3.263893, 6.695953, -3.435696>, <3.256359, 6.714986, -3.433379>, 
      <3.208426, 6.644176, -3.461316>, <3.203713, 6.662395, -3.452935>, <3.215311, 6.688259, -3.435695>, <3.207776, 6.707292, -3.433378>, 
      <3.155463, 6.635786, -3.407694>, <3.159028, 6.655317, -3.407694>, <3.171825, 6.681547, -3.392446>, <3.167346, 6.700888, -3.392446>, 
      <3.155463, 6.635786, -3.343258>, <3.159028, 6.655317, -3.343258>, <3.171825, 6.681547, -3.343258>, <3.167346, 6.700888, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.388672, 6.672723, -3.343258>, <3.375682, 6.689631, -3.343258>, <3.355107, 6.710114, -3.343258>, <3.345371, 6.729084, -3.343258>, 
      <3.388672, 6.672723, -3.407694>, <3.375682, 6.689631, -3.407694>, <3.355107, 6.710114, -3.392446>, <3.345371, 6.729084, -3.392446>, 
      <3.335711, 6.664335, -3.461316>, <3.330998, 6.682555, -3.452935>, <3.312476, 6.703648, -3.435696>, <3.304941, 6.722681, -3.433379>, 
      <3.272069, 6.654255, -3.461316>, <3.267356, 6.672475, -3.452935>, <3.263893, 6.695953, -3.435696>, <3.256359, 6.714986, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.256359, 6.714986, -3.253138>, <3.236087, 6.766195, -3.259371>, <3.216092, 6.840694, -3.253138>, <3.181211, 6.883769, -3.253138>, 
      <3.304941, 6.722681, -3.253138>, <3.284669, 6.773890, -3.259371>, <3.254318, 6.871649, -3.253138>, <3.219437, 6.914723, -3.253138>, 
      <3.345371, 6.729084, -3.294070>, <3.313673, 6.790846, -3.294070>, <3.294938, 6.886532, -3.294070>, <3.251249, 6.940482, -3.294070>, 
      <3.345371, 6.729084, -3.343258>, <3.313673, 6.790846, -3.343258>, <3.294938, 6.886532, -3.343258>, <3.251249, 6.940482, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.167346, 6.700888, -3.343258>, <3.158000, 6.741252, -3.343258>, <3.137248, 6.794855, -3.343258>, <3.111174, 6.827054, -3.343258>, 
      <3.167346, 6.700888, -3.294070>, <3.158000, 6.741252, -3.294070>, <3.137248, 6.794855, -3.294070>, <3.111174, 6.827054, -3.294070>, 
      <3.207776, 6.707292, -3.253137>, <3.187504, 6.758500, -3.259371>, <3.177866, 6.809739, -3.253137>, <3.142985, 6.852814, -3.253137>, 
      <3.256359, 6.714986, -3.253138>, <3.236087, 6.766195, -3.259371>, <3.216092, 6.840694, -3.253138>, <3.181211, 6.883769, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.256359, 6.714986, -3.433379>, <3.236087, 6.766195, -3.427146>, <3.216092, 6.840694, -3.433379>, <3.181211, 6.883769, -3.433379>, 
      <3.207776, 6.707292, -3.433378>, <3.187504, 6.758500, -3.427145>, <3.177866, 6.809739, -3.433378>, <3.142985, 6.852814, -3.433378>, 
      <3.167346, 6.700888, -3.392446>, <3.158000, 6.741252, -3.392446>, <3.137248, 6.794855, -3.392446>, <3.111174, 6.827054, -3.392446>, 
      <3.167346, 6.700888, -3.343258>, <3.158000, 6.741252, -3.343258>, <3.137248, 6.794855, -3.343258>, <3.111174, 6.827054, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.345371, 6.729084, -3.343258>, <3.313673, 6.790846, -3.343258>, <3.294938, 6.886532, -3.343258>, <3.251249, 6.940482, -3.343258>, 
      <3.345371, 6.729084, -3.392446>, <3.313673, 6.790846, -3.392446>, <3.294938, 6.886532, -3.392446>, <3.251249, 6.940482, -3.392446>, 
      <3.304941, 6.722681, -3.433379>, <3.284669, 6.773890, -3.427146>, <3.254318, 6.871649, -3.433379>, <3.219437, 6.914723, -3.433379>, 
      <3.256359, 6.714986, -3.433379>, <3.236087, 6.766195, -3.427146>, <3.216092, 6.840694, -3.433379>, <3.181211, 6.883769, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.181211, 6.883769, -3.253138>, <3.146330, 6.926843, -3.253138>, <3.082897, 6.971029, -3.253138>, <3.031742, 6.992366, -3.253138>, 
      <3.219437, 6.914723, -3.253138>, <3.184556, 6.957798, -3.253138>, <3.100524, 7.016949, -3.253138>, <3.049369, 7.038286, -3.253138>, 
      <3.251249, 6.940482, -3.294070>, <3.207560, 6.994434, -3.294070>, <3.128279, 7.050187, -3.294071>, <3.064037, 7.076499, -3.294071>, 
      <3.251249, 6.940482, -3.343258>, <3.207560, 6.994434, -3.343258>, <3.128279, 7.050187, -3.343258>, <3.064037, 7.076499, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.111174, 6.827054, -3.343258>, <3.085100, 6.859252, -3.343258>, <3.037496, 6.891838, -3.343258>, <2.999445, 6.908230, -3.343258>, 
      <3.111174, 6.827054, -3.294070>, <3.085100, 6.859252, -3.294070>, <3.037496, 6.891838, -3.294070>, <2.999445, 6.908230, -3.294070>, 
      <3.142985, 6.852814, -3.253137>, <3.108104, 6.895889, -3.253137>, <3.065269, 6.925108, -3.253138>, <3.014114, 6.946445, -3.253138>, 
      <3.181211, 6.883769, -3.253138>, <3.146330, 6.926843, -3.253138>, <3.082897, 6.971029, -3.253138>, <3.031742, 6.992366, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.181211, 6.883769, -3.433379>, <3.146330, 6.926843, -3.433379>, <3.082897, 6.971029, -3.433379>, <3.031742, 6.992366, -3.433379>, 
      <3.142985, 6.852814, -3.433378>, <3.108104, 6.895888, -3.433378>, <3.065269, 6.925108, -3.433379>, <3.014114, 6.946445, -3.433379>, 
      <3.111174, 6.827054, -3.392446>, <3.085100, 6.859252, -3.392446>, <3.037496, 6.891838, -3.392446>, <2.999445, 6.908230, -3.392446>, 
      <3.111174, 6.827054, -3.343258>, <3.085100, 6.859252, -3.343258>, <3.037496, 6.891838, -3.343258>, <2.999445, 6.908230, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.251249, 6.940482, -3.343258>, <3.207560, 6.994434, -3.343258>, <3.128279, 7.050187, -3.343258>, <3.064037, 7.076499, -3.343258>, 
      <3.251249, 6.940482, -3.392446>, <3.207560, 6.994434, -3.392446>, <3.128279, 7.050187, -3.392445>, <3.064037, 7.076499, -3.392445>, 
      <3.219437, 6.914723, -3.433379>, <3.184556, 6.957798, -3.433379>, <3.100524, 7.016949, -3.433379>, <3.049369, 7.038286, -3.433379>, 
      <3.181211, 6.883769, -3.433379>, <3.146330, 6.926843, -3.433379>, <3.082897, 6.971029, -3.433379>, <3.031742, 6.992366, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.031742, 6.992366, -3.253138>, <2.988740, 7.010301, -3.253138>, <2.924021, 7.012844, -3.253138>, <2.877491, 7.010449, -3.253138>, 
      <3.049369, 7.038286, -3.253138>, <3.006367, 7.056222, -3.253138>, <2.918044, 7.050581, -3.253138>, <2.871514, 7.048186, -3.253138>, 
      <3.064037, 7.076499, -3.294071>, <3.007981, 7.099458, -3.294071>, <2.923948, 7.101564, -3.305051>, <2.863413, 7.099329, -3.305051>, 
      <3.064037, 7.076499, -3.343258>, <3.007981, 7.099458, -3.343258>, <2.923948, 7.101564, -3.343258>, <2.863413, 7.099329, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.999445, 6.908230, -3.343258>, <2.969489, 6.921134, -3.343258>, <2.924093, 6.923917, -3.343258>, <2.891554, 6.921661, -3.343258>, 
      <2.999445, 6.908230, -3.294070>, <2.969489, 6.921134, -3.294070>, <2.924093, 6.923917, -3.305071>, <2.891554, 6.921661, -3.305071>, 
      <3.014114, 6.946445, -3.253138>, <2.971113, 6.964380, -3.253138>, <2.929995, 6.975127, -3.253138>, <2.883465, 6.972732, -3.253138>, 
      <3.031742, 6.992366, -3.253138>, <2.988740, 7.010301, -3.253138>, <2.924021, 7.012844, -3.253138>, <2.877491, 7.010449, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.031742, 6.992366, -3.433379>, <2.988740, 7.010301, -3.433379>, <2.924021, 7.012844, -3.433379>, <2.877491, 7.010449, -3.433379>, 
      <3.014114, 6.946445, -3.433379>, <2.971113, 6.964380, -3.433379>, <2.929995, 6.975127, -3.433379>, <2.883465, 6.972732, -3.433379>, 
      <2.999445, 6.908230, -3.392446>, <2.969489, 6.921134, -3.392446>, <2.924093, 6.923917, -3.381445>, <2.891554, 6.921661, -3.381445>, 
      <2.999445, 6.908230, -3.343258>, <2.969489, 6.921134, -3.343258>, <2.924093, 6.923917, -3.343258>, <2.891554, 6.921661, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.064037, 7.076499, -3.343258>, <3.007981, 7.099458, -3.343258>, <2.923948, 7.101564, -3.343258>, <2.863413, 7.099329, -3.343258>, 
      <3.064037, 7.076499, -3.392445>, <3.007981, 7.099458, -3.392445>, <2.923948, 7.101564, -3.381465>, <2.863413, 7.099329, -3.381465>, 
      <3.049369, 7.038286, -3.433379>, <3.006367, 7.056222, -3.433379>, <2.918044, 7.050581, -3.433379>, <2.871514, 7.048186, -3.433379>, 
      <3.031742, 6.992366, -3.433379>, <2.988740, 7.010301, -3.433379>, <2.924021, 7.012844, -3.433379>, <2.877491, 7.010449, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.578887, 6.969054, -3.253138>, <2.420820, 6.945672, -3.253138>, <2.208328, 6.923325, -3.253138>, <2.052405, 6.888398, -3.253138>, 
      <2.571193, 7.017636, -3.253138>, <2.413125, 6.994254, -3.253138>, <2.202347, 6.961089, -3.253138>, <2.046423, 6.926162, -3.253138>, 
      <2.564790, 7.058066, -3.294070>, <2.406718, 7.034709, -3.294070>, <2.193779, 7.014293, -3.305023>, <2.038307, 6.977409, -3.305023>, 
      <2.564789, 7.058066, -3.343258>, <2.406718, 7.034709, -3.343258>, <2.193779, 7.014293, -3.343258>, <2.038307, 6.977409, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.592985, 6.880042, -3.343258>, <2.434925, 6.856618, -3.343258>, <2.222913, 6.832071, -3.343258>, <2.066504, 6.799387, -3.343258>, 
      <2.592986, 6.880042, -3.294070>, <2.434925, 6.856618, -3.294070>, <2.222913, 6.832071, -3.305023>, <2.066504, 6.799387, -3.305023>, 
      <2.586582, 6.920472, -3.253138>, <2.428515, 6.897090, -3.253138>, <2.214310, 6.885561, -3.253138>, <2.058386, 6.850633, -3.253138>, 
      <2.578887, 6.969054, -3.253138>, <2.420820, 6.945672, -3.253138>, <2.208328, 6.923325, -3.253138>, <2.052405, 6.888398, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.578887, 6.969054, -3.433379>, <2.420820, 6.945672, -3.433379>, <2.208328, 6.923325, -3.433379>, <2.052405, 6.888398, -3.433379>, 
      <2.586582, 6.920472, -3.433379>, <2.428514, 6.897090, -3.433379>, <2.214310, 6.885561, -3.433379>, <2.058386, 6.850633, -3.433379>, 
      <2.592985, 6.880042, -3.392446>, <2.434924, 6.856618, -3.392446>, <2.222913, 6.832071, -3.381493>, <2.066504, 6.799387, -3.381493>, 
      <2.592985, 6.880042, -3.343258>, <2.434925, 6.856618, -3.343258>, <2.222913, 6.832071, -3.343258>, <2.066504, 6.799387, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.564789, 7.058066, -3.343258>, <2.406718, 7.034709, -3.343258>, <2.193779, 7.014293, -3.343258>, <2.038307, 6.977409, -3.343258>, 
      <2.564789, 7.058066, -3.392446>, <2.406718, 7.034709, -3.392446>, <2.193779, 7.014293, -3.381493>, <2.038307, 6.977409, -3.381493>, 
      <2.571192, 7.017636, -3.433379>, <2.413125, 6.994254, -3.433379>, <2.202347, 6.961089, -3.433379>, <2.046423, 6.926162, -3.433379>, 
      <2.578887, 6.969054, -3.433379>, <2.420820, 6.945672, -3.433379>, <2.208328, 6.923325, -3.433379>, <2.052405, 6.888398, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.909222, 6.819046, -3.253138>, <1.867387, 6.782686, -3.253138>, <1.820488, 6.721321, -3.253138>, <1.800624, 6.669575, -3.253138>, 
      <1.878267, 6.857272, -3.253138>, <1.836432, 6.820913, -3.253138>, <1.772629, 6.739060, -3.253138>, <1.752766, 6.687314, -3.253138>, 
      <1.852507, 6.889082, -3.294070>, <1.798377, 6.843781, -3.294070>, <1.734807, 6.768135, -3.292217>, <1.709512, 6.702238, -3.292217>, 
      <1.852507, 6.889082, -3.343258>, <1.798377, 6.843781, -3.343258>, <1.734807, 6.768135, -3.343258>, <1.709512, 6.702238, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.965936, 6.749009, -3.343258>, <1.935017, 6.721430, -3.343258>, <1.899608, 6.675959, -3.343258>, <1.884760, 6.637280, -3.343258>, 
      <1.965936, 6.749009, -3.294070>, <1.935017, 6.721430, -3.294070>, <1.899608, 6.675959, -3.294070>, <1.884760, 6.637280, -3.294070>, 
      <1.940176, 6.780819, -3.253138>, <1.898341, 6.744461, -3.253138>, <1.866609, 6.704225, -3.253138>, <1.846746, 6.652480, -3.253138>, 
      <1.909222, 6.819046, -3.253138>, <1.867387, 6.782686, -3.253138>, <1.820488, 6.721321, -3.253138>, <1.800624, 6.669575, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.909222, 6.819046, -3.433379>, <1.867387, 6.782686, -3.433379>, <1.820488, 6.721321, -3.433379>, <1.800624, 6.669575, -3.433379>, 
      <1.940176, 6.780819, -3.433379>, <1.898341, 6.744461, -3.433379>, <1.866609, 6.704225, -3.433379>, <1.846746, 6.652480, -3.433379>, 
      <1.965936, 6.749009, -3.392446>, <1.935017, 6.721430, -3.392446>, <1.899608, 6.675959, -3.392446>, <1.884760, 6.637280, -3.392446>, 
      <1.965936, 6.749009, -3.343258>, <1.935017, 6.721430, -3.343258>, <1.899608, 6.675959, -3.343258>, <1.884760, 6.637280, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.852507, 6.889082, -3.343258>, <1.798377, 6.843781, -3.343258>, <1.734807, 6.768135, -3.343258>, <1.709512, 6.702238, -3.343258>, 
      <1.852507, 6.889082, -3.392446>, <1.798377, 6.843781, -3.392446>, <1.734807, 6.768135, -3.394298>, <1.709512, 6.702238, -3.394298>, 
      <1.878267, 6.857272, -3.433379>, <1.836432, 6.820913, -3.433379>, <1.772629, 6.739060, -3.433379>, <1.752766, 6.687314, -3.433379>, 
      <1.909222, 6.819046, -3.433379>, <1.867387, 6.782686, -3.433379>, <1.820488, 6.721321, -3.433379>, <1.800624, 6.669575, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.800624, 6.669575, -3.253138>, <1.780761, 6.617830, -3.253138>, <1.783298, 6.540912, -3.259006>, <1.781313, 6.485833, -3.253138>, 
      <1.752766, 6.687314, -3.253138>, <1.732903, 6.635570, -3.253138>, <1.734715, 6.533217, -3.259006>, <1.732731, 6.478138, -3.253138>, 
      <1.709512, 6.702238, -3.292217>, <1.684661, 6.637501, -3.292217>, <1.699751, 6.540678, -3.294070>, <1.692302, 6.471736, -3.294070>, 
      <1.709512, 6.702238, -3.343258>, <1.684661, 6.637501, -3.343258>, <1.699751, 6.540678, -3.343258>, <1.692302, 6.471736, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.884760, 6.637280, -3.343258>, <1.869912, 6.598600, -3.343258>, <1.865729, 6.541107, -3.343258>, <1.870323, 6.499931, -3.343258>, 
      <1.884760, 6.637280, -3.294070>, <1.869912, 6.598600, -3.294070>, <1.865729, 6.541107, -3.294070>, <1.870323, 6.499931, -3.294070>, 
      <1.846746, 6.652480, -3.253138>, <1.826883, 6.600735, -3.253138>, <1.831879, 6.548606, -3.259006>, <1.829895, 6.493528, -3.253138>, 
      <1.800624, 6.669575, -3.253138>, <1.780761, 6.617830, -3.253138>, <1.783298, 6.540912, -3.259006>, <1.781313, 6.485833, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.800624, 6.669575, -3.433379>, <1.780761, 6.617830, -3.433379>, <1.783298, 6.540912, -3.427510>, <1.781313, 6.485833, -3.433379>, 
      <1.846746, 6.652480, -3.433379>, <1.826883, 6.600735, -3.433379>, <1.831880, 6.548606, -3.427510>, <1.829895, 6.493528, -3.433379>, 
      <1.884760, 6.637280, -3.392446>, <1.869912, 6.598600, -3.392446>, <1.865729, 6.541107, -3.392446>, <1.870323, 6.499931, -3.392446>, 
      <1.884760, 6.637280, -3.343258>, <1.869912, 6.598600, -3.343258>, <1.865729, 6.541107, -3.343258>, <1.870323, 6.499931, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.709512, 6.702238, -3.343258>, <1.684661, 6.637501, -3.343258>, <1.699751, 6.540678, -3.343258>, <1.692302, 6.471736, -3.343258>, 
      <1.709512, 6.702238, -3.394298>, <1.684661, 6.637501, -3.394298>, <1.699751, 6.540678, -3.392446>, <1.692302, 6.471736, -3.392446>, 
      <1.752766, 6.687314, -3.433379>, <1.732903, 6.635570, -3.433379>, <1.734715, 6.533217, -3.427510>, <1.732731, 6.478138, -3.433379>, 
      <1.800624, 6.669575, -3.433379>, <1.780761, 6.617830, -3.433379>, <1.783298, 6.540912, -3.427510>, <1.781313, 6.485833, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.781313, 6.485833, -3.253138>, <1.780586, 6.465652, -3.250988>, <1.788643, 6.442740, -3.234843>, <1.791785, 6.424272, -3.227003>, 
      <1.732731, 6.478138, -3.253138>, <1.732003, 6.457957, -3.250988>, <1.726155, 6.431722, -3.234843>, <1.729297, 6.413254, -3.227003>, 
      <1.692302, 6.471736, -3.294070>, <1.690068, 6.451067, -3.294070>, <1.681798, 6.424379, -3.279806>, <1.677296, 6.404084, -3.279806>, 
      <1.692302, 6.471736, -3.343258>, <1.690068, 6.451067, -3.343258>, <1.681798, 6.424379, -3.343258>, <1.677296, 6.404084, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.870323, 6.499931, -3.343258>, <1.872523, 6.480222, -3.343258>, <1.895490, 6.461101, -3.343258>, <1.906276, 6.444460, -3.343258>, 
      <1.870323, 6.499931, -3.294070>, <1.872523, 6.480222, -3.294070>, <1.895490, 6.461101, -3.279805>, <1.906276, 6.444460, -3.279805>, 
      <1.829895, 6.493528, -3.253138>, <1.829167, 6.473347, -3.250988>, <1.851132, 6.453759, -3.234843>, <1.854273, 6.435290, -3.227003>, 
      <1.781313, 6.485833, -3.253138>, <1.780586, 6.465652, -3.250988>, <1.788643, 6.442740, -3.234843>, <1.791785, 6.424272, -3.227003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.781313, 6.485833, -3.433379>, <1.780586, 6.465652, -3.435529>, <1.788643, 6.442740, -3.451673>, <1.791785, 6.424272, -3.459514>, 
      <1.829895, 6.493528, -3.433379>, <1.829168, 6.473347, -3.435529>, <1.851132, 6.453759, -3.451673>, <1.854273, 6.435290, -3.459514>, 
      <1.870323, 6.499931, -3.392446>, <1.872523, 6.480222, -3.392446>, <1.895490, 6.461101, -3.406710>, <1.906276, 6.444460, -3.406710>, 
      <1.870323, 6.499931, -3.343258>, <1.872523, 6.480222, -3.343258>, <1.895490, 6.461101, -3.343258>, <1.906276, 6.444460, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.692302, 6.471736, -3.343258>, <1.690068, 6.451067, -3.343258>, <1.681798, 6.424379, -3.343258>, <1.677296, 6.404084, -3.343258>, 
      <1.692302, 6.471736, -3.392446>, <1.690068, 6.451067, -3.392446>, <1.681798, 6.424379, -3.406710>, <1.677296, 6.404084, -3.406710>, 
      <1.732731, 6.478138, -3.433379>, <1.732003, 6.457957, -3.435529>, <1.726155, 6.431722, -3.451673>, <1.729297, 6.413254, -3.459514>, 
      <1.781313, 6.485833, -3.433379>, <1.780586, 6.465652, -3.435529>, <1.788643, 6.442740, -3.451673>, <1.791785, 6.424272, -3.459514>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.578887, -6.999162, -3.253138>, <2.586582, -6.950579, -3.253138>, <2.592986, -6.910150, -3.294070>, <2.592985, -6.910150, -3.343258>, 
      <2.668352, -7.012395, -3.253138>, <2.676046, -6.963814, -3.253138>, <2.682445, -6.923407, -3.294070>, <2.682445, -6.923407, -3.343258>, 
      <2.787173, -7.035906, -3.253138>, <2.793147, -6.998190, -3.253138>, <2.801334, -6.945511, -3.305071>, <2.801334, -6.945511, -3.343258>, 
      <2.877491, -7.040556, -3.253138>, <2.883465, -7.002839, -3.253138>, <2.891554, -6.951767, -3.305071>, <2.891554, -6.951767, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.909222, -6.849153, -3.253138>, <1.940176, -6.810926, -3.253138>, <1.965936, -6.779116, -3.294070>, <1.965936, -6.779116, -3.343258>, 
      <1.945246, -6.880462, -3.253138>, <1.976201, -6.842235, -3.253138>, <1.991118, -6.801577, -3.294070>, <1.991118, -6.801577, -3.343258>, 
      <2.005831, -6.908071, -3.253138>, <2.011812, -6.870307, -3.253138>, <2.033473, -6.822592, -3.305023>, <2.033473, -6.822592, -3.343258>, 
      <2.052405, -6.918504, -3.253138>, <2.058386, -6.880740, -3.253138>, <2.066504, -6.829494, -3.305023>, <2.066504, -6.829494, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.592985, -6.910150, -3.343258>, <2.592985, -6.910150, -3.392446>, <2.586582, -6.950578, -3.433379>, <2.578887, -6.999162, -3.433379>, 
      <2.682445, -6.923407, -3.343258>, <2.682445, -6.923407, -3.392446>, <2.676046, -6.963813, -3.433379>, <2.668351, -7.012395, -3.433379>, 
      <2.801334, -6.945511, -3.343258>, <2.801334, -6.945511, -3.381445>, <2.793147, -6.998190, -3.433379>, <2.787173, -7.035906, -3.433379>, 
      <2.891554, -6.951767, -3.343258>, <2.891554, -6.951767, -3.381445>, <2.883465, -7.002839, -3.433379>, <2.877491, -7.040556, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.965936, -6.779116, -3.343258>, <1.965936, -6.779116, -3.392446>, <1.940176, -6.810926, -3.433379>, <1.909222, -6.849153, -3.433379>, 
      <1.991118, -6.801577, -3.343258>, <1.991118, -6.801577, -3.392446>, <1.976201, -6.842235, -3.433379>, <1.945246, -6.880462, -3.433379>, 
      <2.033473, -6.822592, -3.343258>, <2.033473, -6.822592, -3.381493>, <2.011812, -6.870307, -3.433379>, <2.005831, -6.908071, -3.433379>, 
      <2.066504, -6.829494, -3.343258>, <2.066504, -6.829494, -3.381493>, <2.058386, -6.880740, -3.433379>, <2.052405, -6.918504, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.578887, -6.999162, -3.433379>, <2.571192, -7.047743, -3.433379>, <2.564789, -7.088173, -3.392446>, <2.564789, -7.088173, -3.343258>, 
      <2.668351, -7.012395, -3.433379>, <2.660656, -7.060978, -3.433379>, <2.654256, -7.101392, -3.392446>, <2.654256, -7.101392, -3.343258>, 
      <2.787173, -7.035906, -3.433379>, <2.781195, -7.073643, -3.433379>, <2.773036, -7.126099, -3.381465>, <2.773036, -7.126099, -3.343258>, 
      <2.877491, -7.040556, -3.433379>, <2.871514, -7.078292, -3.433379>, <2.863413, -7.129436, -3.381465>, <2.863413, -7.129436, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.909222, -6.849153, -3.433379>, <1.878267, -6.887378, -3.433379>, <1.852507, -6.919190, -3.392446>, <1.852507, -6.919190, -3.343258>, 
      <1.945246, -6.880462, -3.433379>, <1.914291, -6.918687, -3.433379>, <1.899836, -6.958800, -3.392446>, <1.899836, -6.958800, -3.343258>, 
      <2.005831, -6.908071, -3.433379>, <1.999849, -6.945835, -3.433379>, <1.978256, -6.993269, -3.381493>, <1.978256, -6.993269, -3.343258>, 
      <2.052405, -6.918504, -3.433379>, <2.046423, -6.956268, -3.433379>, <2.038307, -7.007515, -3.381493>, <2.038307, -7.007515, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.564789, -7.088173, -3.343258>, <2.564790, -7.088173, -3.294070>, <2.571193, -7.047743, -3.253138>, <2.578887, -6.999162, -3.253138>, 
      <2.654256, -7.101392, -3.343258>, <2.654257, -7.101392, -3.294070>, <2.660657, -7.060978, -3.253138>, <2.668352, -7.012395, -3.253138>, 
      <2.773036, -7.126099, -3.343258>, <2.773036, -7.126099, -3.305051>, <2.781195, -7.073643, -3.253138>, <2.787173, -7.035906, -3.253138>, 
      <2.863413, -7.129436, -3.343258>, <2.863413, -7.129436, -3.305051>, <2.871514, -7.078292, -3.253138>, <2.877491, -7.040556, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.852507, -6.919190, -3.343258>, <1.852507, -6.919190, -3.294070>, <1.878267, -6.887378, -3.253138>, <1.909222, -6.849153, -3.253138>, 
      <1.899836, -6.958800, -3.343258>, <1.899836, -6.958800, -3.294070>, <1.914291, -6.918687, -3.253138>, <1.945246, -6.880462, -3.253138>, 
      <1.978256, -6.993269, -3.343258>, <1.978256, -6.993269, -3.305023>, <1.999849, -6.945835, -3.253138>, <2.005831, -6.908071, -3.253138>, 
      <2.038307, -7.007515, -3.343258>, <2.038307, -7.007515, -3.305023>, <2.046423, -6.956268, -3.253138>, <2.052405, -6.918504, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.272069, -6.684362, -3.225200>, <3.267356, -6.702582, -3.233581>, <3.263893, -6.726060, -3.250821>, <3.256359, -6.745094, -3.253138>, 
      <3.335711, -6.694442, -3.225200>, <3.330998, -6.712662, -3.233582>, <3.312476, -6.733755, -3.250821>, <3.304941, -6.752788, -3.253138>, 
      <3.388672, -6.702830, -3.278823>, <3.375682, -6.719738, -3.278823>, <3.355107, -6.740221, -3.294070>, <3.345371, -6.759191, -3.294070>, 
      <3.388672, -6.702830, -3.343258>, <3.375682, -6.719738, -3.343258>, <3.355107, -6.740221, -3.343258>, <3.345371, -6.759191, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.155463, -6.665894, -3.343258>, <3.159028, -6.685424, -3.343258>, <3.171825, -6.711654, -3.343258>, <3.167346, -6.730995, -3.343258>, 
      <3.155463, -6.665894, -3.278821>, <3.159028, -6.685424, -3.278821>, <3.171825, -6.711654, -3.294070>, <3.167346, -6.730995, -3.294070>, 
      <3.208426, -6.674282, -3.225200>, <3.203713, -6.692502, -3.233581>, <3.215311, -6.718366, -3.250821>, <3.207776, -6.737398, -3.253137>, 
      <3.272069, -6.684362, -3.225200>, <3.267356, -6.702582, -3.233581>, <3.263893, -6.726060, -3.250821>, <3.256359, -6.745094, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.272069, -6.684362, -3.461316>, <3.267356, -6.702582, -3.452935>, <3.263893, -6.726060, -3.435696>, <3.256359, -6.745094, -3.433379>, 
      <3.208426, -6.674282, -3.461316>, <3.203713, -6.692502, -3.452935>, <3.215311, -6.718366, -3.435695>, <3.207776, -6.737398, -3.433378>, 
      <3.155463, -6.665894, -3.407694>, <3.159028, -6.685424, -3.407694>, <3.171825, -6.711654, -3.392446>, <3.167346, -6.730995, -3.392446>, 
      <3.155463, -6.665894, -3.343258>, <3.159028, -6.685424, -3.343258>, <3.171825, -6.711654, -3.343258>, <3.167346, -6.730995, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.388672, -6.702830, -3.343258>, <3.375682, -6.719738, -3.343258>, <3.355107, -6.740221, -3.343258>, <3.345371, -6.759191, -3.343258>, 
      <3.388672, -6.702830, -3.407694>, <3.375682, -6.719738, -3.407694>, <3.355107, -6.740221, -3.392446>, <3.345371, -6.759191, -3.392446>, 
      <3.335711, -6.694442, -3.461316>, <3.330998, -6.712662, -3.452935>, <3.312476, -6.733755, -3.435696>, <3.304941, -6.752788, -3.433379>, 
      <3.272069, -6.684362, -3.461316>, <3.267356, -6.702582, -3.452935>, <3.263893, -6.726060, -3.435696>, <3.256359, -6.745094, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.256359, -6.745094, -3.253138>, <3.236087, -6.796302, -3.259371>, <3.216092, -6.870801, -3.253138>, <3.181211, -6.913875, -3.253138>, 
      <3.304941, -6.752788, -3.253138>, <3.284669, -6.803997, -3.259371>, <3.254318, -6.901756, -3.253138>, <3.219437, -6.944830, -3.253138>, 
      <3.345371, -6.759191, -3.294070>, <3.313673, -6.820954, -3.294070>, <3.294938, -6.916639, -3.294070>, <3.251249, -6.970590, -3.294070>, 
      <3.345371, -6.759191, -3.343258>, <3.313673, -6.820954, -3.343258>, <3.294938, -6.916639, -3.343258>, <3.251249, -6.970590, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.167346, -6.730995, -3.343258>, <3.158000, -6.771359, -3.343258>, <3.137248, -6.824962, -3.343258>, <3.111174, -6.857161, -3.343258>, 
      <3.167346, -6.730995, -3.294070>, <3.158000, -6.771359, -3.294070>, <3.137248, -6.824962, -3.294070>, <3.111174, -6.857161, -3.294070>, 
      <3.207776, -6.737398, -3.253137>, <3.187504, -6.788607, -3.259371>, <3.177866, -6.839846, -3.253137>, <3.142985, -6.882922, -3.253137>, 
      <3.256359, -6.745094, -3.253138>, <3.236087, -6.796302, -3.259371>, <3.216092, -6.870801, -3.253138>, <3.181211, -6.913875, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.256359, -6.745094, -3.433379>, <3.236087, -6.796302, -3.427146>, <3.216092, -6.870801, -3.433379>, <3.181211, -6.913875, -3.433379>, 
      <3.207776, -6.737398, -3.433378>, <3.187504, -6.788607, -3.427145>, <3.177866, -6.839846, -3.433378>, <3.142985, -6.882921, -3.433378>, 
      <3.167346, -6.730995, -3.392446>, <3.158000, -6.771359, -3.392446>, <3.137248, -6.824962, -3.392446>, <3.111174, -6.857161, -3.392446>, 
      <3.167346, -6.730995, -3.343258>, <3.158000, -6.771359, -3.343258>, <3.137248, -6.824962, -3.343258>, <3.111174, -6.857161, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.345371, -6.759191, -3.343258>, <3.313673, -6.820954, -3.343258>, <3.294938, -6.916639, -3.343258>, <3.251249, -6.970590, -3.343258>, 
      <3.345371, -6.759191, -3.392446>, <3.313673, -6.820954, -3.392446>, <3.294938, -6.916639, -3.392446>, <3.251249, -6.970590, -3.392446>, 
      <3.304941, -6.752788, -3.433379>, <3.284669, -6.803997, -3.427146>, <3.254318, -6.901756, -3.433379>, <3.219437, -6.944830, -3.433379>, 
      <3.256359, -6.745094, -3.433379>, <3.236087, -6.796302, -3.427146>, <3.216092, -6.870801, -3.433379>, <3.181211, -6.913875, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.181211, -6.913875, -3.253138>, <3.146330, -6.956950, -3.253138>, <3.082897, -7.001136, -3.253138>, <3.031742, -7.022472, -3.253138>, 
      <3.219437, -6.944830, -3.253138>, <3.184556, -6.987905, -3.253138>, <3.100524, -7.047056, -3.253138>, <3.049369, -7.068393, -3.253138>, 
      <3.251249, -6.970590, -3.294070>, <3.207560, -7.024541, -3.294070>, <3.128279, -7.080294, -3.294071>, <3.064037, -7.106606, -3.294071>, 
      <3.251249, -6.970590, -3.343258>, <3.207560, -7.024541, -3.343258>, <3.128279, -7.080294, -3.343258>, <3.064037, -7.106606, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.111174, -6.857161, -3.343258>, <3.085100, -6.889359, -3.343258>, <3.037496, -6.921946, -3.343258>, <2.999445, -6.938338, -3.343258>, 
      <3.111174, -6.857161, -3.294070>, <3.085100, -6.889359, -3.294070>, <3.037496, -6.921946, -3.294070>, <2.999445, -6.938338, -3.294070>, 
      <3.142985, -6.882922, -3.253137>, <3.108104, -6.925996, -3.253137>, <3.065269, -6.955215, -3.253138>, <3.014114, -6.976551, -3.253138>, 
      <3.181211, -6.913875, -3.253138>, <3.146330, -6.956950, -3.253138>, <3.082897, -7.001136, -3.253138>, <3.031742, -7.022472, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.181211, -6.913875, -3.433379>, <3.146330, -6.956950, -3.433379>, <3.082897, -7.001136, -3.433379>, <3.031742, -7.022472, -3.433379>, 
      <3.142985, -6.882921, -3.433378>, <3.108104, -6.925995, -3.433378>, <3.065269, -6.955215, -3.433379>, <3.014114, -6.976551, -3.433379>, 
      <3.111174, -6.857161, -3.392446>, <3.085100, -6.889359, -3.392446>, <3.037496, -6.921946, -3.392446>, <2.999445, -6.938338, -3.392446>, 
      <3.111174, -6.857161, -3.343258>, <3.085100, -6.889359, -3.343258>, <3.037496, -6.921946, -3.343258>, <2.999445, -6.938338, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.251249, -6.970590, -3.343258>, <3.207560, -7.024541, -3.343258>, <3.128279, -7.080294, -3.343258>, <3.064037, -7.106606, -3.343258>, 
      <3.251249, -6.970590, -3.392446>, <3.207560, -7.024541, -3.392446>, <3.128279, -7.080294, -3.392445>, <3.064037, -7.106606, -3.392445>, 
      <3.219437, -6.944830, -3.433379>, <3.184556, -6.987905, -3.433379>, <3.100524, -7.047056, -3.433379>, <3.049369, -7.068393, -3.433379>, 
      <3.181211, -6.913875, -3.433379>, <3.146330, -6.956950, -3.433379>, <3.082897, -7.001136, -3.433379>, <3.031742, -7.022472, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.031742, -7.022472, -3.253138>, <2.988740, -7.040408, -3.253138>, <2.924021, -7.042951, -3.253138>, <2.877491, -7.040556, -3.253138>, 
      <3.049369, -7.068393, -3.253138>, <3.006367, -7.086329, -3.253138>, <2.918044, -7.080687, -3.253138>, <2.871514, -7.078292, -3.253138>, 
      <3.064037, -7.106606, -3.294071>, <3.007981, -7.129565, -3.294071>, <2.923948, -7.131671, -3.305051>, <2.863413, -7.129436, -3.305051>, 
      <3.064037, -7.106606, -3.343258>, <3.007981, -7.129565, -3.343258>, <2.923948, -7.131671, -3.343258>, <2.863413, -7.129436, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.999445, -6.938338, -3.343258>, <2.969489, -6.951242, -3.343258>, <2.924093, -6.954024, -3.343258>, <2.891554, -6.951767, -3.343258>, 
      <2.999445, -6.938338, -3.294070>, <2.969489, -6.951242, -3.294070>, <2.924093, -6.954024, -3.305071>, <2.891554, -6.951767, -3.305071>, 
      <3.014114, -6.976551, -3.253138>, <2.971113, -6.994487, -3.253138>, <2.929995, -7.005234, -3.253138>, <2.883465, -7.002839, -3.253138>, 
      <3.031742, -7.022472, -3.253138>, <2.988740, -7.040408, -3.253138>, <2.924021, -7.042951, -3.253138>, <2.877491, -7.040556, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.031742, -7.022472, -3.433379>, <2.988740, -7.040408, -3.433379>, <2.924021, -7.042951, -3.433379>, <2.877491, -7.040556, -3.433379>, 
      <3.014114, -6.976551, -3.433379>, <2.971113, -6.994487, -3.433379>, <2.929995, -7.005234, -3.433379>, <2.883465, -7.002839, -3.433379>, 
      <2.999445, -6.938338, -3.392446>, <2.969489, -6.951242, -3.392446>, <2.924093, -6.954024, -3.381445>, <2.891554, -6.951767, -3.381445>, 
      <2.999445, -6.938338, -3.343258>, <2.969489, -6.951242, -3.343258>, <2.924093, -6.954024, -3.343258>, <2.891554, -6.951767, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.064037, -7.106606, -3.343258>, <3.007981, -7.129565, -3.343258>, <2.923948, -7.131671, -3.343258>, <2.863413, -7.129436, -3.343258>, 
      <3.064037, -7.106606, -3.392445>, <3.007981, -7.129565, -3.392445>, <2.923948, -7.131671, -3.381465>, <2.863413, -7.129436, -3.381465>, 
      <3.049369, -7.068393, -3.433379>, <3.006367, -7.086329, -3.433379>, <2.918044, -7.080687, -3.433379>, <2.871514, -7.078292, -3.433379>, 
      <3.031742, -7.022472, -3.433379>, <2.988740, -7.040408, -3.433379>, <2.924021, -7.042951, -3.433379>, <2.877491, -7.040556, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.578887, -6.999162, -3.253138>, <2.420820, -6.975779, -3.253138>, <2.208328, -6.953432, -3.253138>, <2.052405, -6.918504, -3.253138>, 
      <2.571193, -7.047743, -3.253138>, <2.413125, -7.024361, -3.253138>, <2.202347, -6.991196, -3.253138>, <2.046423, -6.956268, -3.253138>, 
      <2.564790, -7.088173, -3.294070>, <2.406718, -7.064815, -3.294070>, <2.193779, -7.044400, -3.305023>, <2.038307, -7.007515, -3.305023>, 
      <2.564789, -7.088173, -3.343258>, <2.406718, -7.064815, -3.343258>, <2.193779, -7.044400, -3.343258>, <2.038307, -7.007515, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.592985, -6.910150, -3.343258>, <2.434925, -6.886725, -3.343258>, <2.222913, -6.862178, -3.343258>, <2.066504, -6.829494, -3.343258>, 
      <2.592986, -6.910150, -3.294070>, <2.434925, -6.886725, -3.294070>, <2.222913, -6.862178, -3.305023>, <2.066504, -6.829494, -3.305023>, 
      <2.586582, -6.950579, -3.253138>, <2.428515, -6.927197, -3.253138>, <2.214310, -6.915668, -3.253138>, <2.058386, -6.880740, -3.253138>, 
      <2.578887, -6.999162, -3.253138>, <2.420820, -6.975779, -3.253138>, <2.208328, -6.953432, -3.253138>, <2.052405, -6.918504, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.578887, -6.999162, -3.433379>, <2.420820, -6.975779, -3.433379>, <2.208328, -6.953432, -3.433379>, <2.052405, -6.918504, -3.433379>, 
      <2.586582, -6.950578, -3.433379>, <2.428514, -6.927197, -3.433379>, <2.214310, -6.915668, -3.433379>, <2.058386, -6.880740, -3.433379>, 
      <2.592985, -6.910150, -3.392446>, <2.434924, -6.886725, -3.392446>, <2.222913, -6.862178, -3.381493>, <2.066504, -6.829494, -3.381493>, 
      <2.592985, -6.910150, -3.343258>, <2.434925, -6.886725, -3.343258>, <2.222913, -6.862178, -3.343258>, <2.066504, -6.829494, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.564789, -7.088173, -3.343258>, <2.406718, -7.064815, -3.343258>, <2.193779, -7.044400, -3.343258>, <2.038307, -7.007515, -3.343258>, 
      <2.564789, -7.088173, -3.392446>, <2.406718, -7.064815, -3.392446>, <2.193779, -7.044400, -3.381493>, <2.038307, -7.007515, -3.381493>, 
      <2.571192, -7.047743, -3.433379>, <2.413125, -7.024361, -3.433379>, <2.202347, -6.991196, -3.433379>, <2.046423, -6.956268, -3.433379>, 
      <2.578887, -6.999162, -3.433379>, <2.420820, -6.975779, -3.433379>, <2.208328, -6.953432, -3.433379>, <2.052405, -6.918504, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.909222, -6.849153, -3.253138>, <1.867387, -6.812794, -3.253138>, <1.820488, -6.751428, -3.253138>, <1.800624, -6.699682, -3.253138>, 
      <1.878267, -6.887378, -3.253138>, <1.836432, -6.851020, -3.253138>, <1.772629, -6.769167, -3.253138>, <1.752766, -6.717422, -3.253138>, 
      <1.852507, -6.919190, -3.294070>, <1.798377, -6.873888, -3.294070>, <1.734807, -6.798242, -3.292217>, <1.709512, -6.732345, -3.292217>, 
      <1.852507, -6.919190, -3.343258>, <1.798377, -6.873888, -3.343258>, <1.734807, -6.798242, -3.343258>, <1.709512, -6.732345, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.965936, -6.779116, -3.343258>, <1.935017, -6.751538, -3.343258>, <1.899608, -6.706066, -3.343258>, <1.884760, -6.667386, -3.343258>, 
      <1.965936, -6.779116, -3.294070>, <1.935017, -6.751538, -3.294070>, <1.899608, -6.706066, -3.294070>, <1.884760, -6.667386, -3.294070>, 
      <1.940176, -6.810926, -3.253138>, <1.898341, -6.774568, -3.253138>, <1.866609, -6.734332, -3.253138>, <1.846746, -6.682587, -3.253138>, 
      <1.909222, -6.849153, -3.253138>, <1.867387, -6.812794, -3.253138>, <1.820488, -6.751428, -3.253138>, <1.800624, -6.699682, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.909222, -6.849153, -3.433379>, <1.867387, -6.812794, -3.433379>, <1.820488, -6.751428, -3.433379>, <1.800624, -6.699682, -3.433379>, 
      <1.940176, -6.810926, -3.433379>, <1.898341, -6.774568, -3.433379>, <1.866609, -6.734332, -3.433379>, <1.846746, -6.682587, -3.433379>, 
      <1.965936, -6.779116, -3.392446>, <1.935017, -6.751538, -3.392446>, <1.899608, -6.706066, -3.392446>, <1.884760, -6.667386, -3.392446>, 
      <1.965936, -6.779116, -3.343258>, <1.935017, -6.751538, -3.343258>, <1.899608, -6.706066, -3.343258>, <1.884760, -6.667386, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.852507, -6.919190, -3.343258>, <1.798377, -6.873888, -3.343258>, <1.734807, -6.798242, -3.343258>, <1.709512, -6.732345, -3.343258>, 
      <1.852507, -6.919190, -3.392446>, <1.798377, -6.873888, -3.392446>, <1.734807, -6.798242, -3.394298>, <1.709512, -6.732345, -3.394298>, 
      <1.878267, -6.887378, -3.433379>, <1.836432, -6.851020, -3.433379>, <1.772629, -6.769167, -3.433379>, <1.752766, -6.717422, -3.433379>, 
      <1.909222, -6.849153, -3.433379>, <1.867387, -6.812794, -3.433379>, <1.820488, -6.751428, -3.433379>, <1.800624, -6.699682, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.800624, -6.699682, -3.253138>, <1.780761, -6.647937, -3.253138>, <1.783298, -6.571019, -3.259006>, <1.781313, -6.515940, -3.253138>, 
      <1.752766, -6.717422, -3.253138>, <1.732903, -6.665676, -3.253138>, <1.734715, -6.563324, -3.259006>, <1.732731, -6.508245, -3.253138>, 
      <1.709512, -6.732345, -3.292217>, <1.684661, -6.667608, -3.292217>, <1.699751, -6.570784, -3.294070>, <1.692302, -6.501842, -3.294070>, 
      <1.709512, -6.732345, -3.343258>, <1.684661, -6.667608, -3.343258>, <1.699751, -6.570784, -3.343258>, <1.692302, -6.501842, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.884760, -6.667386, -3.343258>, <1.869912, -6.628707, -3.343258>, <1.865729, -6.571214, -3.343258>, <1.870323, -6.530038, -3.343258>, 
      <1.884760, -6.667386, -3.294070>, <1.869912, -6.628707, -3.294070>, <1.865729, -6.571214, -3.294070>, <1.870323, -6.530038, -3.294070>, 
      <1.846746, -6.682587, -3.253138>, <1.826883, -6.630842, -3.253138>, <1.831879, -6.578714, -3.259006>, <1.829895, -6.523634, -3.253138>, 
      <1.800624, -6.699682, -3.253138>, <1.780761, -6.647937, -3.253138>, <1.783298, -6.571019, -3.259006>, <1.781313, -6.515940, -3.253138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.800624, -6.699682, -3.433379>, <1.780761, -6.647937, -3.433379>, <1.783298, -6.571019, -3.427510>, <1.781313, -6.515940, -3.433379>, 
      <1.846746, -6.682587, -3.433379>, <1.826883, -6.630842, -3.433379>, <1.831880, -6.578714, -3.427510>, <1.829895, -6.523634, -3.433379>, 
      <1.884760, -6.667386, -3.392446>, <1.869912, -6.628707, -3.392446>, <1.865729, -6.571214, -3.392446>, <1.870323, -6.530038, -3.392446>, 
      <1.884760, -6.667386, -3.343258>, <1.869912, -6.628707, -3.343258>, <1.865729, -6.571214, -3.343258>, <1.870323, -6.530038, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.709512, -6.732345, -3.343258>, <1.684661, -6.667608, -3.343258>, <1.699751, -6.570784, -3.343258>, <1.692302, -6.501842, -3.343258>, 
      <1.709512, -6.732345, -3.394298>, <1.684661, -6.667608, -3.394298>, <1.699751, -6.570784, -3.392446>, <1.692302, -6.501842, -3.392446>, 
      <1.752766, -6.717422, -3.433379>, <1.732903, -6.665676, -3.433379>, <1.734715, -6.563324, -3.427510>, <1.732731, -6.508245, -3.433379>, 
      <1.800624, -6.699682, -3.433379>, <1.780761, -6.647937, -3.433379>, <1.783298, -6.571019, -3.427510>, <1.781313, -6.515940, -3.433379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.781313, -6.515940, -3.253138>, <1.780586, -6.495759, -3.250988>, <1.788643, -6.472848, -3.234843>, <1.791785, -6.454379, -3.227003>, 
      <1.732731, -6.508245, -3.253138>, <1.732003, -6.488064, -3.250988>, <1.726155, -6.461829, -3.234843>, <1.729297, -6.443361, -3.227003>, 
      <1.692302, -6.501842, -3.294070>, <1.690068, -6.481174, -3.294070>, <1.681798, -6.454487, -3.279806>, <1.677296, -6.434191, -3.279806>, 
      <1.692302, -6.501842, -3.343258>, <1.690068, -6.481174, -3.343258>, <1.681798, -6.454487, -3.343258>, <1.677296, -6.434191, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.870323, -6.530038, -3.343258>, <1.872523, -6.510329, -3.343258>, <1.895490, -6.491208, -3.343258>, <1.906276, -6.474566, -3.343258>, 
      <1.870323, -6.530038, -3.294070>, <1.872523, -6.510329, -3.294070>, <1.895490, -6.491208, -3.279805>, <1.906276, -6.474566, -3.279805>, 
      <1.829895, -6.523634, -3.253138>, <1.829167, -6.503454, -3.250988>, <1.851132, -6.483866, -3.234843>, <1.854273, -6.465397, -3.227003>, 
      <1.781313, -6.515940, -3.253138>, <1.780586, -6.495759, -3.250988>, <1.788643, -6.472848, -3.234843>, <1.791785, -6.454379, -3.227003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.781313, -6.515940, -3.433379>, <1.780586, -6.495759, -3.435529>, <1.788643, -6.472848, -3.451673>, <1.791785, -6.454379, -3.459514>, 
      <1.829895, -6.523634, -3.433379>, <1.829168, -6.503454, -3.435529>, <1.851132, -6.483866, -3.451673>, <1.854273, -6.465397, -3.459514>, 
      <1.870323, -6.530038, -3.392446>, <1.872523, -6.510329, -3.392446>, <1.895490, -6.491208, -3.406710>, <1.906276, -6.474566, -3.406710>, 
      <1.870323, -6.530038, -3.343258>, <1.872523, -6.510329, -3.343258>, <1.895490, -6.491208, -3.343258>, <1.906276, -6.474566, -3.343258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.692302, -6.501842, -3.343258>, <1.690068, -6.481174, -3.343258>, <1.681798, -6.454487, -3.343258>, <1.677296, -6.434191, -3.343258>, 
      <1.692302, -6.501842, -3.392446>, <1.690068, -6.481174, -3.392446>, <1.681798, -6.454487, -3.406710>, <1.677296, -6.434191, -3.406710>, 
      <1.732731, -6.508245, -3.433379>, <1.732003, -6.488064, -3.435529>, <1.726155, -6.461829, -3.451673>, <1.729297, -6.443361, -3.459514>, 
      <1.781313, -6.515940, -3.433379>, <1.780586, -6.495759, -3.435529>, <1.788643, -6.472848, -3.451673>, <1.791785, -6.454379, -3.459514>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.354780, 5.682382, -1.892719>, <9.306667, 5.682382, -1.882493>, <9.266628, 5.723315, -1.873982>, <9.266628, 5.772503, -1.873982>, 
      <9.372678, 5.682382, -1.804070>, <9.324566, 5.682382, -1.793844>, <9.284550, 5.723315, -1.785339>, <9.284550, 5.772503, -1.785339>, 
      <9.402376, 5.682382, -1.686642>, <9.365024, 5.682382, -1.678703>, <9.312844, 5.734315, -1.667769>, <9.312844, 5.772503, -1.667769>, 
      <9.411746, 5.682382, -1.596691>, <9.374394, 5.682382, -1.588751>, <9.323814, 5.734315, -1.578000>, <9.323814, 5.772503, -1.578000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.169930, 5.682382, -2.553617>, <9.133376, 5.682382, -2.520704>, <9.102957, 5.723315, -2.493315>, <9.102957, 5.772503, -2.493315>, 
      <9.203081, 5.682382, -2.519280>, <9.166528, 5.682382, -2.486367>, <9.126705, 5.723315, -2.469342>, <9.126705, 5.772503, -2.469342>, 
      <9.233823, 5.682382, -2.460223>, <9.196423, 5.682382, -2.452273>, <9.149908, 5.734268, -2.428145>, <9.149908, 5.772503, -2.428145>, 
      <9.246679, 5.682382, -2.414258>, <9.209280, 5.682382, -2.406309>, <9.158530, 5.734268, -2.395521>, <9.158530, 5.772503, -2.395521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.266628, 5.772503, -1.873982>, <9.266628, 5.821691, -1.873982>, <9.306667, 5.862624, -1.882493>, <9.354780, 5.862624, -1.892719>, 
      <9.284550, 5.772503, -1.785339>, <9.284550, 5.821691, -1.785339>, <9.324566, 5.862624, -1.793844>, <9.372678, 5.862624, -1.804070>, 
      <9.312844, 5.772503, -1.667769>, <9.312844, 5.810690, -1.667769>, <9.365024, 5.862624, -1.678703>, <9.402376, 5.862624, -1.686642>, 
      <9.323814, 5.772503, -1.578000>, <9.323814, 5.810690, -1.578000>, <9.374394, 5.862624, -1.588751>, <9.411746, 5.862624, -1.596691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.102957, 5.772503, -2.493315>, <9.102957, 5.821690, -2.493315>, <9.133376, 5.862624, -2.520704>, <9.169930, 5.862624, -2.553617>, 
      <9.126705, 5.772503, -2.469342>, <9.126705, 5.821690, -2.469342>, <9.166528, 5.862624, -2.486367>, <9.203081, 5.862624, -2.519280>, 
      <9.149908, 5.772503, -2.428145>, <9.149908, 5.810738, -2.428145>, <9.196423, 5.862624, -2.452273>, <9.233823, 5.862624, -2.460223>, 
      <9.158530, 5.772503, -2.395521>, <9.158530, 5.810738, -2.395521>, <9.209280, 5.862624, -2.406309>, <9.246679, 5.862624, -2.414258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.354780, 5.862624, -1.892719>, <9.402893, 5.862624, -1.902946>, <9.442932, 5.821691, -1.911456>, <9.442932, 5.772503, -1.911456>, 
      <9.372678, 5.862624, -1.804070>, <9.420792, 5.862624, -1.814297>, <9.460816, 5.821691, -1.822804>, <9.460816, 5.772503, -1.822804>, 
      <9.402376, 5.862624, -1.686642>, <9.439748, 5.862624, -1.694586>, <9.491705, 5.810710, -1.705479>, <9.491705, 5.772503, -1.705479>, 
      <9.411746, 5.862624, -1.596691>, <9.449118, 5.862624, -1.604635>, <9.499767, 5.810710, -1.615401>, <9.499767, 5.772503, -1.615401>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.169930, 5.862624, -2.553617>, <9.206483, 5.862624, -2.586529>, <9.236902, 5.821690, -2.613919>, <9.236902, 5.772503, -2.613919>, 
      <9.203081, 5.862624, -2.519280>, <9.239634, 5.862624, -2.552193>, <9.278935, 5.821690, -2.568727>, <9.278935, 5.772503, -2.568727>, 
      <9.233823, 5.862624, -2.460223>, <9.271222, 5.862624, -2.468173>, <9.317461, 5.810738, -2.492219>, <9.317461, 5.772503, -2.492219>, 
      <9.246679, 5.862624, -2.414258>, <9.284078, 5.862624, -2.422208>, <9.334831, 5.810738, -2.432996>, <9.334831, 5.772503, -2.432996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.442932, 5.772503, -1.911456>, <9.442932, 5.723315, -1.911456>, <9.402893, 5.682382, -1.902946>, <9.354780, 5.682382, -1.892719>, 
      <9.460816, 5.772503, -1.822804>, <9.460816, 5.723315, -1.822804>, <9.420792, 5.682382, -1.814297>, <9.372678, 5.682382, -1.804070>, 
      <9.491705, 5.772503, -1.705479>, <9.491705, 5.734296, -1.705479>, <9.439748, 5.682382, -1.694586>, <9.402376, 5.682382, -1.686642>, 
      <9.499767, 5.772503, -1.615401>, <9.499767, 5.734296, -1.615401>, <9.449118, 5.682382, -1.604635>, <9.411746, 5.682382, -1.596691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.236902, 5.772503, -2.613919>, <9.236902, 5.723315, -2.613919>, <9.206483, 5.682382, -2.586529>, <9.169930, 5.682382, -2.553617>, 
      <9.278935, 5.772503, -2.568727>, <9.278935, 5.723315, -2.568727>, <9.239634, 5.682382, -2.552193>, <9.203081, 5.682382, -2.519280>, 
      <9.317461, 5.772503, -2.492219>, <9.317461, 5.734268, -2.492219>, <9.271222, 5.682382, -2.468173>, <9.233823, 5.682382, -2.460223>, 
      <9.334831, 5.772503, -2.432996>, <9.334831, 5.734268, -2.432996>, <9.284078, 5.682382, -2.422208>, <9.246679, 5.682382, -2.414258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.076690, 5.654445, -1.184012>, <9.094639, 5.662826, -1.189673>, <9.117904, 5.680065, -1.194359>, <9.136517, 5.682382, -1.202880>, 
      <9.090088, 5.654445, -1.120985>, <9.108036, 5.662826, -1.126645>, <9.128131, 5.680065, -1.146246>, <9.146744, 5.682382, -1.154767>, 
      <9.101236, 5.708068, -1.068536>, <9.117442, 5.708068, -1.082393>, <9.136820, 5.723315, -1.104012>, <9.155254, 5.723315, -1.114727>, 
      <9.101236, 5.772503, -1.068536>, <9.117442, 5.772503, -1.082393>, <9.136820, 5.772503, -1.104012>, <9.155254, 5.772503, -1.114727>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.052145, 5.772503, -1.299492>, <9.071835, 5.772503, -1.296954>, <9.098698, 5.772503, -1.285547>, <9.117778, 5.772503, -1.291032>, 
      <9.052145, 5.708066, -1.299492>, <9.071835, 5.708066, -1.296954>, <9.098698, 5.723315, -1.285547>, <9.117778, 5.723315, -1.291032>, 
      <9.063294, 5.654445, -1.247041>, <9.081242, 5.662826, -1.252701>, <9.107677, 5.680065, -1.242473>, <9.126290, 5.682382, -1.250993>, 
      <9.076690, 5.654445, -1.184012>, <9.094639, 5.662826, -1.189673>, <9.117904, 5.680065, -1.194359>, <9.136517, 5.682382, -1.202880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.076690, 5.890561, -1.184012>, <9.094639, 5.882180, -1.189673>, <9.117904, 5.864941, -1.194359>, <9.136517, 5.862624, -1.202880>, 
      <9.063294, 5.890561, -1.247041>, <9.081242, 5.882180, -1.252701>, <9.107677, 5.864941, -1.242473>, <9.126290, 5.862624, -1.250993>, 
      <9.052145, 5.836939, -1.299492>, <9.071835, 5.836939, -1.296954>, <9.098698, 5.821691, -1.285547>, <9.117778, 5.821691, -1.291032>, 
      <9.052145, 5.772503, -1.299492>, <9.071835, 5.772503, -1.296954>, <9.098698, 5.772503, -1.285547>, <9.117778, 5.772503, -1.291032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.101236, 5.772503, -1.068536>, <9.117442, 5.772503, -1.082393>, <9.136820, 5.772503, -1.104012>, <9.155254, 5.772503, -1.114727>, 
      <9.101236, 5.836938, -1.068536>, <9.117442, 5.836938, -1.082393>, <9.136820, 5.821691, -1.104012>, <9.155254, 5.821691, -1.114727>, 
      <9.090088, 5.890561, -1.120985>, <9.108036, 5.882180, -1.126645>, <9.128131, 5.864941, -1.146246>, <9.146744, 5.862624, -1.154767>, 
      <9.076690, 5.890561, -1.184012>, <9.094639, 5.882180, -1.189673>, <9.117904, 5.864941, -1.194359>, <9.136517, 5.862624, -1.202880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.136517, 5.682382, -1.202880>, <9.186594, 5.688615, -1.225804>, <9.259944, 5.682382, -1.249670>, <9.301134, 5.682382, -1.286758>, 
      <9.146744, 5.682382, -1.154767>, <9.196822, 5.688615, -1.177691>, <9.292857, 5.682382, -1.213116>, <9.334047, 5.682382, -1.250204>, 
      <9.155254, 5.723315, -1.114727>, <9.215273, 5.723315, -1.149614>, <9.309847, 5.723315, -1.173332>, <9.361437, 5.723315, -1.219784>, 
      <9.155254, 5.772503, -1.114727>, <9.215273, 5.772503, -1.149614>, <9.309847, 5.772503, -1.173332>, <9.361437, 5.772503, -1.219784>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.117778, 5.772503, -1.291032>, <9.157598, 5.772503, -1.302478>, <9.210042, 5.772503, -1.326007>, <9.240831, 5.772503, -1.353730>, 
      <9.117778, 5.723315, -1.291032>, <9.157598, 5.723315, -1.302478>, <9.210042, 5.723315, -1.326007>, <9.240831, 5.723315, -1.353730>, 
      <9.126290, 5.682382, -1.250993>, <9.176367, 5.688615, -1.273917>, <9.227030, 5.682382, -1.286224>, <9.268221, 5.682382, -1.323311>, 
      <9.136517, 5.682382, -1.202880>, <9.186594, 5.688615, -1.225804>, <9.259944, 5.682382, -1.249670>, <9.301134, 5.682382, -1.286758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.136517, 5.862624, -1.202880>, <9.186594, 5.856390, -1.225804>, <9.259944, 5.862624, -1.249670>, <9.301134, 5.862624, -1.286758>, 
      <9.126290, 5.862624, -1.250993>, <9.176367, 5.856390, -1.273917>, <9.227030, 5.862624, -1.286224>, <9.268221, 5.862624, -1.323311>, 
      <9.117778, 5.821691, -1.291032>, <9.157598, 5.821691, -1.302478>, <9.210042, 5.821690, -1.326007>, <9.240831, 5.821690, -1.353730>, 
      <9.117778, 5.772503, -1.291032>, <9.157598, 5.772503, -1.302478>, <9.210042, 5.772503, -1.326007>, <9.240831, 5.772503, -1.353730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.155254, 5.772503, -1.114727>, <9.215273, 5.772503, -1.149614>, <9.309847, 5.772503, -1.173332>, <9.361437, 5.772503, -1.219784>, 
      <9.155254, 5.821691, -1.114727>, <9.215273, 5.821691, -1.149614>, <9.309847, 5.821691, -1.173332>, <9.361437, 5.821691, -1.219784>, 
      <9.146744, 5.862624, -1.154767>, <9.196822, 5.856390, -1.177691>, <9.292857, 5.862624, -1.213116>, <9.334047, 5.862624, -1.250204>, 
      <9.136517, 5.862624, -1.202880>, <9.186594, 5.856390, -1.225804>, <9.259944, 5.862624, -1.249670>, <9.301134, 5.862624, -1.286758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.301134, 5.682382, -1.286758>, <9.342324, 5.682382, -1.323845>, <9.383130, 5.682382, -1.389504>, <9.401760, 5.682382, -1.441706>, 
      <9.334047, 5.682382, -1.250204>, <9.375238, 5.682382, -1.287291>, <9.429910, 5.682382, -1.374304>, <9.448540, 5.682382, -1.426506>, 
      <9.361437, 5.723315, -1.219784>, <9.413027, 5.723315, -1.266236>, <9.464554, 5.723316, -1.348326>, <9.487469, 5.723316, -1.413858>, 
      <9.361437, 5.772503, -1.219784>, <9.413027, 5.772503, -1.266236>, <9.464554, 5.772503, -1.348326>, <9.487469, 5.772503, -1.413858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.240831, 5.772503, -1.353730>, <9.271621, 5.772503, -1.381453>, <9.301672, 5.772503, -1.430698>, <9.316050, 5.772503, -1.469555>, 
      <9.240831, 5.723315, -1.353730>, <9.271621, 5.723315, -1.381453>, <9.301672, 5.723315, -1.430698>, <9.316050, 5.723315, -1.469555>, 
      <9.268221, 5.682382, -1.323311>, <9.309411, 5.682382, -1.360399>, <9.336350, 5.682382, -1.404704>, <9.354979, 5.682382, -1.456906>, 
      <9.301134, 5.682382, -1.286758>, <9.342324, 5.682382, -1.323845>, <9.383130, 5.682382, -1.389504>, <9.401760, 5.682382, -1.441706>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.301134, 5.862624, -1.286758>, <9.342324, 5.862624, -1.323845>, <9.383130, 5.862624, -1.389504>, <9.401760, 5.862624, -1.441706>, 
      <9.268221, 5.862624, -1.323311>, <9.309411, 5.862624, -1.360399>, <9.336350, 5.862624, -1.404704>, <9.354979, 5.862624, -1.456906>, 
      <9.240831, 5.821690, -1.353730>, <9.271621, 5.821690, -1.381453>, <9.301672, 5.821691, -1.430698>, <9.316050, 5.821691, -1.469555>, 
      <9.240831, 5.772503, -1.353730>, <9.271621, 5.772503, -1.381453>, <9.301672, 5.772503, -1.430698>, <9.316050, 5.772503, -1.469555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.361437, 5.772503, -1.219784>, <9.413027, 5.772503, -1.266236>, <9.464554, 5.772503, -1.348326>, <9.487469, 5.772503, -1.413858>, 
      <9.361437, 5.821691, -1.219784>, <9.413027, 5.821691, -1.266236>, <9.464554, 5.821690, -1.348326>, <9.487469, 5.821690, -1.413858>, 
      <9.334047, 5.862624, -1.250204>, <9.375238, 5.862624, -1.287291>, <9.429910, 5.862624, -1.374304>, <9.448540, 5.862624, -1.426506>, 
      <9.301134, 5.862624, -1.286758>, <9.342324, 5.862624, -1.323845>, <9.383130, 5.862624, -1.389504>, <9.401760, 5.862624, -1.441706>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.401760, 5.682382, -1.441706>, <9.417420, 5.682382, -1.485587>, <9.416574, 5.682382, -1.550350>, <9.411746, 5.682382, -1.596691>, 
      <9.448540, 5.682382, -1.426506>, <9.464200, 5.682382, -1.470387>, <9.453945, 5.682382, -1.558294>, <9.449118, 5.682382, -1.604635>, 
      <9.487469, 5.723316, -1.413858>, <9.507462, 5.723316, -1.471038>, <9.505167, 5.734296, -1.555066>, <9.499767, 5.734296, -1.615401>, 
      <9.487469, 5.772503, -1.413858>, <9.507462, 5.772503, -1.471038>, <9.505167, 5.772503, -1.555066>, <9.499767, 5.772503, -1.615401>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.316050, 5.772503, -1.469555>, <9.327369, 5.772503, -1.500145>, <9.327771, 5.772503, -1.545624>, <9.323814, 5.772503, -1.578000>, 
      <9.316050, 5.723315, -1.469555>, <9.327369, 5.723315, -1.500145>, <9.327771, 5.734315, -1.545624>, <9.323814, 5.734315, -1.578000>, 
      <9.354979, 5.682382, -1.456906>, <9.370640, 5.682382, -1.500787>, <9.379221, 5.682382, -1.542410>, <9.374394, 5.682382, -1.588751>, 
      <9.401760, 5.682382, -1.441706>, <9.417420, 5.682382, -1.485587>, <9.416574, 5.682382, -1.550350>, <9.411746, 5.682382, -1.596691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.401760, 5.862624, -1.441706>, <9.417420, 5.862624, -1.485587>, <9.416574, 5.862624, -1.550350>, <9.411746, 5.862624, -1.596691>, 
      <9.354979, 5.862624, -1.456906>, <9.370640, 5.862624, -1.500787>, <9.379221, 5.862624, -1.542410>, <9.374394, 5.862624, -1.588751>, 
      <9.316050, 5.821691, -1.469555>, <9.327369, 5.821691, -1.500145>, <9.327771, 5.810690, -1.545624>, <9.323814, 5.810690, -1.578000>, 
      <9.316050, 5.772503, -1.469555>, <9.327369, 5.772503, -1.500145>, <9.327771, 5.772503, -1.545624>, <9.323814, 5.772503, -1.578000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.487469, 5.772503, -1.413858>, <9.507462, 5.772503, -1.471038>, <9.505167, 5.772503, -1.555066>, <9.499767, 5.772503, -1.615401>, 
      <9.487469, 5.821690, -1.413858>, <9.507462, 5.821690, -1.471038>, <9.505167, 5.810710, -1.555066>, <9.499767, 5.810710, -1.615401>, 
      <9.448540, 5.862624, -1.426506>, <9.464200, 5.862624, -1.470387>, <9.453945, 5.862624, -1.558294>, <9.449118, 5.862624, -1.604635>, 
      <9.401760, 5.862624, -1.441706>, <9.417420, 5.862624, -1.485587>, <9.416574, 5.862624, -1.550350>, <9.411746, 5.862624, -1.596691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.354780, 5.682382, -1.892719>, <9.323158, 5.682382, -2.049346>, <9.289719, 5.682382, -2.260377>, <9.246679, 5.682382, -2.414258>, 
      <9.402893, 5.682382, -1.902946>, <9.371270, 5.682382, -2.059573>, <9.327119, 5.682382, -2.268327>, <9.284078, 5.682382, -2.422208>, 
      <9.442932, 5.723315, -1.911456>, <9.411334, 5.723315, -2.068088>, <9.379802, 5.734268, -2.279667>, <9.334831, 5.734268, -2.432996>, 
      <9.442932, 5.772503, -1.911456>, <9.411334, 5.772503, -2.068088>, <9.379802, 5.772503, -2.279667>, <9.334831, 5.772503, -2.432996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.266628, 5.772503, -1.873982>, <9.234963, 5.772503, -2.030600>, <9.199355, 5.772503, -2.241037>, <9.158530, 5.772503, -2.395521>, 
      <9.266628, 5.723315, -1.873982>, <9.234963, 5.723315, -2.030600>, <9.199355, 5.734268, -2.241037>, <9.158530, 5.734268, -2.395521>, 
      <9.306667, 5.682382, -1.882493>, <9.275045, 5.682382, -2.039120>, <9.252320, 5.682382, -2.252427>, <9.209280, 5.682382, -2.406309>, 
      <9.354780, 5.682382, -1.892719>, <9.323158, 5.682382, -2.049346>, <9.289719, 5.682382, -2.260377>, <9.246679, 5.682382, -2.414258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.354780, 5.862624, -1.892719>, <9.323158, 5.862624, -2.049346>, <9.289719, 5.862624, -2.260377>, <9.246679, 5.862624, -2.414258>, 
      <9.306667, 5.862624, -1.882493>, <9.275045, 5.862624, -2.039120>, <9.252320, 5.862624, -2.252427>, <9.209280, 5.862624, -2.406309>, 
      <9.266628, 5.821691, -1.873982>, <9.234963, 5.821691, -2.030600>, <9.199355, 5.810738, -2.241037>, <9.158530, 5.810738, -2.395521>, 
      <9.266628, 5.772503, -1.873982>, <9.234963, 5.772503, -2.030600>, <9.199355, 5.772503, -2.241037>, <9.158530, 5.772503, -2.395521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.442932, 5.772503, -1.911456>, <9.411334, 5.772503, -2.068088>, <9.379802, 5.772503, -2.279667>, <9.334831, 5.772503, -2.432996>, 
      <9.442932, 5.821691, -1.911456>, <9.411334, 5.821691, -2.068088>, <9.379802, 5.810738, -2.279667>, <9.334831, 5.810738, -2.432996>, 
      <9.402893, 5.862624, -1.902946>, <9.371270, 5.862624, -2.059573>, <9.327119, 5.862624, -2.268327>, <9.284078, 5.862624, -2.422208>, 
      <9.354780, 5.862624, -1.892719>, <9.323158, 5.862624, -2.049346>, <9.289719, 5.862624, -2.260377>, <9.246679, 5.862624, -2.414258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.169930, 5.682382, -2.553617>, <9.131431, 5.682382, -2.593491>, <9.067694, 5.682382, -2.637114>, <9.014980, 5.682382, -2.654242>, 
      <9.206483, 5.682382, -2.586529>, <9.167985, 5.682382, -2.626404>, <9.082905, 5.682382, -2.685836>, <9.030190, 5.682382, -2.702963>, 
      <9.236902, 5.723315, -2.613919>, <9.188830, 5.723315, -2.665604>, <9.109961, 5.721462, -2.725127>, <9.042830, 5.721462, -2.746940>, 
      <9.236902, 5.772503, -2.613919>, <9.188830, 5.772503, -2.665604>, <9.109961, 5.772503, -2.725127>, <9.042830, 5.772503, -2.746940>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.102957, 5.772503, -2.493315>, <9.073798, 5.772503, -2.522748>, <9.026536, 5.772503, -2.555728>, <8.987132, 5.772503, -2.568532>, 
      <9.102957, 5.723315, -2.493315>, <9.073798, 5.723315, -2.522748>, <9.026536, 5.723315, -2.555728>, <8.987132, 5.723315, -2.568532>, 
      <9.133376, 5.682382, -2.520704>, <9.094878, 5.682382, -2.560579>, <9.053037, 5.682382, -2.590161>, <9.000322, 5.682382, -2.607289>, 
      <9.169930, 5.682382, -2.553617>, <9.131431, 5.682382, -2.593491>, <9.067694, 5.682382, -2.637114>, <9.014980, 5.682382, -2.654242>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.169930, 5.862624, -2.553617>, <9.131431, 5.862624, -2.593491>, <9.067694, 5.862624, -2.637114>, <9.014980, 5.862624, -2.654242>, 
      <9.133376, 5.862624, -2.520704>, <9.094878, 5.862624, -2.560579>, <9.053037, 5.862624, -2.590161>, <9.000322, 5.862624, -2.607289>, 
      <9.102957, 5.821690, -2.493315>, <9.073798, 5.821690, -2.522748>, <9.026536, 5.821691, -2.555728>, <8.987132, 5.821691, -2.568532>, 
      <9.102957, 5.772503, -2.493315>, <9.073798, 5.772503, -2.522748>, <9.026536, 5.772503, -2.555728>, <8.987132, 5.772503, -2.568532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.236902, 5.772503, -2.613919>, <9.188830, 5.772503, -2.665604>, <9.109961, 5.772503, -2.725127>, <9.042830, 5.772503, -2.746940>, 
      <9.236902, 5.821690, -2.613919>, <9.188830, 5.821690, -2.665604>, <9.109961, 5.823544, -2.725127>, <9.042830, 5.823544, -2.746940>, 
      <9.206483, 5.862624, -2.586529>, <9.167985, 5.862624, -2.626404>, <9.082905, 5.862624, -2.685836>, <9.030190, 5.862624, -2.702963>, 
      <9.169930, 5.862624, -2.553617>, <9.131431, 5.862624, -2.593491>, <9.067694, 5.862624, -2.637114>, <9.014980, 5.862624, -2.654242>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.014980, 5.682382, -2.654242>, <8.962267, 5.682382, -2.671370>, <8.885586, 5.688250, -2.664811>, <8.830478, 5.682382, -2.663911>, 
      <9.030190, 5.682382, -2.702963>, <8.977477, 5.682382, -2.720091>, <8.875359, 5.688250, -2.712924>, <8.820253, 5.682382, -2.712024>, 
      <9.042830, 5.721462, -2.746940>, <8.976880, 5.721462, -2.768368>, <8.880979, 5.723315, -2.748232>, <8.811742, 5.723315, -2.752062>, 
      <9.042830, 5.772503, -2.746940>, <8.976880, 5.772503, -2.768368>, <8.880979, 5.772503, -2.748232>, <8.811742, 5.772503, -2.752062>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.987132, 5.772503, -2.568532>, <8.947728, 5.772503, -2.581335>, <8.890096, 5.772503, -2.582504>, <8.849217, 5.772503, -2.575760>, 
      <8.987132, 5.723315, -2.568532>, <8.947728, 5.723315, -2.581335>, <8.890096, 5.723315, -2.582504>, <8.849217, 5.723315, -2.575760>, 
      <9.000322, 5.682382, -2.607289>, <8.947609, 5.682382, -2.624417>, <8.895812, 5.688250, -2.616699>, <8.840705, 5.682382, -2.615798>, 
      <9.014980, 5.682382, -2.654242>, <8.962267, 5.682382, -2.671370>, <8.885586, 5.688250, -2.664811>, <8.830478, 5.682382, -2.663911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.014980, 5.862624, -2.654242>, <8.962267, 5.862624, -2.671370>, <8.885586, 5.856755, -2.664811>, <8.830478, 5.862624, -2.663911>, 
      <9.000322, 5.862624, -2.607289>, <8.947609, 5.862624, -2.624417>, <8.895812, 5.856755, -2.616699>, <8.840705, 5.862624, -2.615798>, 
      <8.987132, 5.821691, -2.568532>, <8.947728, 5.821691, -2.581335>, <8.890096, 5.821690, -2.582504>, <8.849217, 5.821690, -2.575760>, 
      <8.987132, 5.772503, -2.568532>, <8.947728, 5.772503, -2.581335>, <8.890096, 5.772503, -2.582504>, <8.849217, 5.772503, -2.575760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.042830, 5.772503, -2.746940>, <8.976880, 5.772503, -2.768368>, <8.880979, 5.772503, -2.748232>, <8.811742, 5.772503, -2.752062>, 
      <9.042830, 5.823544, -2.746940>, <8.976880, 5.823544, -2.768368>, <8.880979, 5.821690, -2.748232>, <8.811742, 5.821690, -2.752062>, 
      <9.030190, 5.862624, -2.702963>, <8.977477, 5.862624, -2.720091>, <8.875359, 5.856755, -2.712924>, <8.820253, 5.862624, -2.712024>, 
      <9.014980, 5.862624, -2.654242>, <8.962267, 5.862624, -2.671370>, <8.885586, 5.856755, -2.664811>, <8.830478, 5.862624, -2.663911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.830478, 5.682382, -2.663911>, <8.810287, 5.680232, -2.663581>, <8.787829, 5.664088, -2.654335>, <8.769550, 5.656248, -2.650231>, 
      <8.820253, 5.682382, -2.712024>, <8.800062, 5.680232, -2.711694>, <8.773555, 5.664088, -2.716161>, <8.755277, 5.656248, -2.712057>, 
      <8.811742, 5.723315, -2.752062>, <8.790986, 5.723315, -2.753211>, <8.763902, 5.709051, -2.760073>, <8.743398, 5.709051, -2.763506>, 
      <8.811742, 5.772503, -2.752062>, <8.790986, 5.772503, -2.753211>, <8.763902, 5.772503, -2.760073>, <8.743398, 5.772503, -2.763506>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.849217, 5.772503, -2.575760>, <8.829650, 5.772503, -2.572533>, <8.811756, 5.772503, -2.548596>, <8.795702, 5.772503, -2.536954>, 
      <8.849217, 5.723315, -2.575760>, <8.829650, 5.723315, -2.572533>, <8.811756, 5.709051, -2.548596>, <8.795702, 5.709051, -2.536954>, 
      <8.840705, 5.682382, -2.615798>, <8.820514, 5.680232, -2.615468>, <8.802102, 5.664088, -2.592509>, <8.783824, 5.656248, -2.588405>, 
      <8.830478, 5.682382, -2.663911>, <8.810287, 5.680232, -2.663581>, <8.787829, 5.664088, -2.654335>, <8.769550, 5.656248, -2.650231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.830478, 5.862624, -2.663911>, <8.810287, 5.864774, -2.663581>, <8.787829, 5.880918, -2.654335>, <8.769550, 5.888759, -2.650231>, 
      <8.840705, 5.862624, -2.615798>, <8.820514, 5.864774, -2.615468>, <8.802102, 5.880918, -2.592509>, <8.783824, 5.888759, -2.588405>, 
      <8.849217, 5.821690, -2.575760>, <8.829650, 5.821690, -2.572533>, <8.811756, 5.835955, -2.548596>, <8.795702, 5.835955, -2.536954>, 
      <8.849217, 5.772503, -2.575760>, <8.829650, 5.772503, -2.572533>, <8.811756, 5.772503, -2.548596>, <8.795702, 5.772503, -2.536954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.811742, 5.772503, -2.752062>, <8.790986, 5.772503, -2.753211>, <8.763902, 5.772503, -2.760073>, <8.743398, 5.772503, -2.763506>, 
      <8.811742, 5.821690, -2.752062>, <8.790986, 5.821690, -2.753211>, <8.763902, 5.835955, -2.760073>, <8.743398, 5.835955, -2.763506>, 
      <8.820253, 5.862624, -2.712024>, <8.800062, 5.864774, -2.711694>, <8.773555, 5.880918, -2.716161>, <8.755277, 5.888759, -2.712057>, 
      <8.830478, 5.862624, -2.663911>, <8.810287, 5.864774, -2.663581>, <8.787829, 5.880918, -2.654335>, <8.769550, 5.888759, -2.650231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -6.202972, -7.705383>, <4.871354, -6.202972, -7.705383>, <4.974221, -6.261974, -7.621120>, <4.974221, -6.332875, -7.519864>, 
      <4.747743, -6.002437, -7.572215>, <4.871354, -6.002437, -7.572215>, <4.980162, -6.061708, -7.480892>, <4.980162, -6.132608, -7.379635>, 
      <4.747743, -5.742863, -7.383211>, <4.871452, -5.742863, -7.383211>, <4.974221, -5.797373, -7.295862>, <4.974221, -5.865448, -7.192568>, 
      <4.747743, -5.545673, -7.245138>, <4.871452, -5.545673, -7.245138>, <4.974221, -5.597048, -7.155594>, <4.974221, -5.665123, -7.052298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -6.241089, -7.706938>, <4.860117, -6.241089, -7.706938>, <4.953632, -6.294727, -7.630335>, <4.953632, -6.359182, -7.538284>, 
      <4.747743, -6.233324, -7.715346>, <4.860117, -6.233324, -7.715346>, <4.964972, -6.293468, -7.629453>, <4.964972, -6.357922, -7.537402>, 
      <4.747743, -6.212506, -7.711714>, <4.871354, -6.212506, -7.711714>, <4.973943, -6.271346, -7.627682>, <4.973943, -6.342247, -7.526426>, 
      <4.747743, -6.202972, -7.705383>, <4.871354, -6.202972, -7.705383>, <4.974221, -6.261974, -7.621120>, <4.974221, -6.332875, -7.519864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -6.230070, -7.676042>, <4.849752, -6.230070, -7.676042>, <4.934643, -6.278761, -7.606503>, <4.934643, -6.337272, -7.522942>, 
      <4.747743, -6.238002, -7.681866>, <4.849752, -6.238002, -7.681866>, <4.934865, -6.286820, -7.612146>, <4.934865, -6.345331, -7.528585>, 
      <4.747743, -6.247766, -7.699710>, <4.860117, -6.247766, -7.699710>, <4.943880, -6.295811, -7.631094>, <4.943880, -6.360266, -7.539042>, 
      <4.747743, -6.241089, -7.706938>, <4.860117, -6.241089, -7.706938>, <4.953632, -6.294727, -7.630335>, <4.953632, -6.359182, -7.538284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.974221, -6.332875, -7.519864>, <4.974221, -6.403776, -7.418606>, <4.871354, -6.462778, -7.334343>, <4.747743, -6.462778, -7.334343>, 
      <4.980162, -6.132608, -7.379635>, <4.980162, -6.203509, -7.278378>, <4.871354, -6.265919, -7.189249>, <4.747743, -6.265919, -7.189249>, 
      <4.974221, -5.865448, -7.192568>, <4.974221, -5.933470, -7.089354>, <4.871354, -5.995351, -7.007048>, <4.747743, -5.995351, -7.007048>, 
      <4.974221, -5.665123, -7.052298>, <4.974221, -5.733144, -6.949086>, <4.871354, -5.795026, -6.866778>, <4.747743, -5.795026, -6.866778>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.953632, -6.359182, -7.538284>, <4.953632, -6.423637, -7.446232>, <4.860117, -6.477276, -7.369629>, <4.747743, -6.477276, -7.369629>, 
      <4.964972, -6.357922, -7.537402>, <4.964972, -6.422378, -7.445350>, <4.860117, -6.482520, -7.359457>, <4.747743, -6.482520, -7.359457>, 
      <4.973943, -6.342247, -7.526426>, <4.973943, -6.413148, -7.425169>, <4.871354, -6.471990, -7.341133>, <4.747743, -6.471990, -7.341133>, 
      <4.974221, -6.332875, -7.519864>, <4.974221, -6.403776, -7.418606>, <4.871354, -6.462778, -7.334343>, <4.747743, -6.462778, -7.334343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.934643, -6.337272, -7.522942>, <4.934643, -6.395782, -7.439380>, <4.849752, -6.444473, -7.369842>, <4.747743, -6.444473, -7.369842>, 
      <4.934865, -6.345331, -7.528585>, <4.934865, -6.403841, -7.445023>, <4.849752, -6.452660, -7.375304>, <4.747743, -6.452660, -7.375304>, 
      <4.943880, -6.360266, -7.539042>, <4.943880, -6.424721, -7.446990>, <4.860117, -6.472766, -7.378375>, <4.747743, -6.472766, -7.378375>, 
      <4.953632, -6.359182, -7.538284>, <4.953632, -6.423637, -7.446232>, <4.860117, -6.477276, -7.369629>, <4.747743, -6.477276, -7.369629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -6.462778, -7.334343>, <4.624131, -6.462778, -7.334343>, <4.521264, -6.403776, -7.418606>, <4.521264, -6.332875, -7.519864>, 
      <4.747743, -6.265919, -7.189249>, <4.624131, -6.265919, -7.189249>, <4.515324, -6.203509, -7.278378>, <4.515324, -6.132608, -7.379635>, 
      <4.747743, -5.995351, -7.007048>, <4.624131, -5.995351, -7.007048>, <4.521264, -5.933470, -7.089354>, <4.521264, -5.865448, -7.192568>, 
      <4.747743, -5.795026, -6.866778>, <4.624131, -5.795026, -6.866778>, <4.521264, -5.733144, -6.949086>, <4.521264, -5.665123, -7.052298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -6.477276, -7.369629>, <4.635368, -6.477276, -7.369629>, <4.541854, -6.423637, -7.446232>, <4.541854, -6.359182, -7.538284>, 
      <4.747743, -6.482520, -7.359457>, <4.635368, -6.482520, -7.359457>, <4.530513, -6.422378, -7.445350>, <4.530513, -6.357922, -7.537402>, 
      <4.747743, -6.471990, -7.341133>, <4.624131, -6.471990, -7.341133>, <4.521542, -6.413148, -7.425169>, <4.521542, -6.342247, -7.526426>, 
      <4.747743, -6.462778, -7.334343>, <4.624131, -6.462778, -7.334343>, <4.521264, -6.403776, -7.418606>, <4.521264, -6.332875, -7.519864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -6.444473, -7.369842>, <4.645733, -6.444473, -7.369842>, <4.560842, -6.395782, -7.439380>, <4.560842, -6.337272, -7.522942>, 
      <4.747743, -6.452660, -7.375304>, <4.645733, -6.452660, -7.375304>, <4.560620, -6.403841, -7.445023>, <4.560620, -6.345331, -7.528585>, 
      <4.747743, -6.472766, -7.378375>, <4.635368, -6.472766, -7.378375>, <4.551605, -6.424721, -7.446990>, <4.551605, -6.360266, -7.539042>, 
      <4.747743, -6.477276, -7.369629>, <4.635368, -6.477276, -7.369629>, <4.541854, -6.423637, -7.446232>, <4.541854, -6.359182, -7.538284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.521264, -6.332875, -7.519864>, <4.521264, -6.261974, -7.621120>, <4.624131, -6.202972, -7.705383>, <4.747743, -6.202972, -7.705383>, 
      <4.515324, -6.132608, -7.379635>, <4.515324, -6.061708, -7.480892>, <4.624131, -6.002437, -7.572215>, <4.747743, -6.002437, -7.572215>, 
      <4.521264, -5.865448, -7.192568>, <4.521264, -5.797373, -7.295862>, <4.624033, -5.742863, -7.383211>, <4.747743, -5.742863, -7.383211>, 
      <4.521264, -5.665123, -7.052298>, <4.521264, -5.597048, -7.155594>, <4.624033, -5.545673, -7.245138>, <4.747743, -5.545673, -7.245138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.541854, -6.359182, -7.538284>, <4.541854, -6.294727, -7.630335>, <4.635368, -6.241089, -7.706938>, <4.747743, -6.241089, -7.706938>, 
      <4.530513, -6.357922, -7.537402>, <4.530513, -6.293468, -7.629453>, <4.635368, -6.233324, -7.715346>, <4.747743, -6.233324, -7.715346>, 
      <4.521542, -6.342247, -7.526426>, <4.521542, -6.271346, -7.627682>, <4.624131, -6.212506, -7.711714>, <4.747743, -6.212506, -7.711714>, 
      <4.521264, -6.332875, -7.519864>, <4.521264, -6.261974, -7.621120>, <4.624131, -6.202972, -7.705383>, <4.747743, -6.202972, -7.705383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.560842, -6.337272, -7.522942>, <4.560842, -6.278761, -7.606503>, <4.645733, -6.230070, -7.676042>, <4.747743, -6.230070, -7.676042>, 
      <4.560620, -6.345331, -7.528585>, <4.560620, -6.286820, -7.612146>, <4.645733, -6.238002, -7.681866>, <4.747743, -6.238002, -7.681866>, 
      <4.551605, -6.360266, -7.539042>, <4.551605, -6.295811, -7.631094>, <4.635368, -6.247766, -7.699710>, <4.747743, -6.247766, -7.699710>, 
      <4.541854, -6.359182, -7.538284>, <4.541854, -6.294727, -7.630335>, <4.635368, -6.241089, -7.706938>, <4.747743, -6.241089, -7.706938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -6.230070, -7.676042>, <4.747743, -6.033101, -7.531390>, <4.747743, -5.762977, -7.348979>, <4.747743, -5.562794, -7.208810>, 
      <4.645733, -6.230070, -7.676042>, <4.645733, -6.033101, -7.531390>, <4.645733, -5.762977, -7.348979>, <4.645733, -5.562794, -7.208810>, 
      <4.560842, -6.278761, -7.606503>, <4.566357, -6.078629, -7.466369>, <4.560842, -5.811668, -7.279442>, <4.560842, -5.611485, -7.139272>, 
      <4.560842, -6.337272, -7.522942>, <4.566357, -6.137140, -7.382808>, <4.560842, -5.870178, -7.195880>, <4.560842, -5.669995, -7.055710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.934643, -6.337272, -7.522942>, <4.929129, -6.137140, -7.382808>, <4.934643, -5.870178, -7.195880>, <4.934643, -5.669995, -7.055710>, 
      <4.934643, -6.278761, -7.606503>, <4.929129, -6.078629, -7.466369>, <4.934643, -5.811668, -7.279442>, <4.934643, -5.611485, -7.139272>, 
      <4.849752, -6.230070, -7.676042>, <4.849752, -6.033101, -7.531390>, <4.849752, -5.762977, -7.348979>, <4.849752, -5.562794, -7.208810>, 
      <4.747743, -6.230070, -7.676042>, <4.747743, -6.033101, -7.531390>, <4.747743, -5.762977, -7.348979>, <4.747743, -5.562794, -7.208810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -6.444473, -7.369842>, <4.747743, -6.241178, -7.234226>, <4.747743, -5.977380, -7.042780>, <4.747743, -5.777197, -6.902610>, 
      <4.849752, -6.444473, -7.369842>, <4.849752, -6.241178, -7.234226>, <4.849752, -5.977380, -7.042780>, <4.849752, -5.777197, -6.902610>, 
      <4.934643, -6.395782, -7.439380>, <4.929129, -6.195650, -7.299246>, <4.934643, -5.928688, -7.112318>, <4.934643, -5.728506, -6.972149>, 
      <4.934643, -6.337272, -7.522942>, <4.929129, -6.137140, -7.382808>, <4.934643, -5.870178, -7.195880>, <4.934643, -5.669995, -7.055710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.560842, -6.337272, -7.522942>, <4.566357, -6.137140, -7.382808>, <4.560842, -5.870178, -7.195880>, <4.560842, -5.669995, -7.055710>, 
      <4.560842, -6.395782, -7.439380>, <4.566357, -6.195650, -7.299246>, <4.560842, -5.928688, -7.112318>, <4.560842, -5.728506, -6.972149>, 
      <4.645733, -6.444473, -7.369842>, <4.645733, -6.241178, -7.234226>, <4.645733, -5.977380, -7.042780>, <4.645733, -5.777197, -6.902610>, 
      <4.747743, -6.444473, -7.369842>, <4.747743, -6.241178, -7.234226>, <4.747743, -5.977380, -7.042780>, <4.747743, -5.777197, -6.902610>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.202972, -7.705383>, <4.871354, 6.202972, -7.705383>, <4.974221, 6.261974, -7.621120>, <4.974221, 6.332875, -7.519864>, 
      <4.747743, 6.002437, -7.572215>, <4.871354, 6.002437, -7.572215>, <4.980162, 6.061708, -7.480892>, <4.980162, 6.132608, -7.379635>, 
      <4.747743, 5.742863, -7.383211>, <4.871452, 5.742863, -7.383211>, <4.974221, 5.797373, -7.295862>, <4.974221, 5.865448, -7.192568>, 
      <4.747743, 5.545673, -7.245138>, <4.871452, 5.545673, -7.245138>, <4.974221, 5.597048, -7.155594>, <4.974221, 5.665123, -7.052298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.241089, -7.706938>, <4.860117, 6.241089, -7.706938>, <4.953632, 6.294727, -7.630335>, <4.953632, 6.359182, -7.538284>, 
      <4.747743, 6.233324, -7.715346>, <4.860117, 6.233324, -7.715346>, <4.964972, 6.293468, -7.629453>, <4.964972, 6.357922, -7.537402>, 
      <4.747743, 6.212506, -7.711714>, <4.871354, 6.212506, -7.711714>, <4.973943, 6.271346, -7.627682>, <4.973943, 6.342247, -7.526426>, 
      <4.747743, 6.202972, -7.705383>, <4.871354, 6.202972, -7.705383>, <4.974221, 6.261974, -7.621120>, <4.974221, 6.332875, -7.519864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.230070, -7.676042>, <4.849752, 6.230070, -7.676042>, <4.934643, 6.278761, -7.606503>, <4.934643, 6.337272, -7.522942>, 
      <4.747743, 6.238002, -7.681866>, <4.849752, 6.238002, -7.681866>, <4.934865, 6.286820, -7.612146>, <4.934865, 6.345331, -7.528585>, 
      <4.747743, 6.247766, -7.699710>, <4.860117, 6.247766, -7.699710>, <4.943880, 6.295811, -7.631094>, <4.943880, 6.360266, -7.539042>, 
      <4.747743, 6.241089, -7.706938>, <4.860117, 6.241089, -7.706938>, <4.953632, 6.294727, -7.630335>, <4.953632, 6.359182, -7.538284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.974221, 6.332875, -7.519864>, <4.974221, 6.403776, -7.418606>, <4.871354, 6.462778, -7.334343>, <4.747743, 6.462778, -7.334343>, 
      <4.980162, 6.132608, -7.379635>, <4.980162, 6.203509, -7.278378>, <4.871354, 6.265919, -7.189249>, <4.747743, 6.265919, -7.189249>, 
      <4.974221, 5.865448, -7.192568>, <4.974221, 5.933470, -7.089354>, <4.871354, 5.995351, -7.007048>, <4.747743, 5.995351, -7.007048>, 
      <4.974221, 5.665123, -7.052298>, <4.974221, 5.733144, -6.949086>, <4.871354, 5.795026, -6.866778>, <4.747743, 5.795026, -6.866778>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.953632, 6.359182, -7.538284>, <4.953632, 6.423637, -7.446232>, <4.860117, 6.477276, -7.369629>, <4.747743, 6.477276, -7.369629>, 
      <4.964972, 6.357922, -7.537402>, <4.964972, 6.422378, -7.445350>, <4.860117, 6.482520, -7.359457>, <4.747743, 6.482520, -7.359457>, 
      <4.973943, 6.342247, -7.526426>, <4.973943, 6.413148, -7.425169>, <4.871354, 6.471990, -7.341133>, <4.747743, 6.471990, -7.341133>, 
      <4.974221, 6.332875, -7.519864>, <4.974221, 6.403776, -7.418606>, <4.871354, 6.462778, -7.334343>, <4.747743, 6.462778, -7.334343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.934643, 6.337272, -7.522942>, <4.934643, 6.395782, -7.439380>, <4.849752, 6.444473, -7.369842>, <4.747743, 6.444473, -7.369842>, 
      <4.934865, 6.345331, -7.528585>, <4.934865, 6.403841, -7.445023>, <4.849752, 6.452660, -7.375304>, <4.747743, 6.452660, -7.375304>, 
      <4.943880, 6.360266, -7.539042>, <4.943880, 6.424721, -7.446990>, <4.860117, 6.472766, -7.378375>, <4.747743, 6.472766, -7.378375>, 
      <4.953632, 6.359182, -7.538284>, <4.953632, 6.423637, -7.446232>, <4.860117, 6.477276, -7.369629>, <4.747743, 6.477276, -7.369629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.462778, -7.334343>, <4.624131, 6.462778, -7.334343>, <4.521264, 6.403776, -7.418606>, <4.521264, 6.332875, -7.519864>, 
      <4.747743, 6.265919, -7.189249>, <4.624131, 6.265919, -7.189249>, <4.515324, 6.203509, -7.278378>, <4.515324, 6.132608, -7.379635>, 
      <4.747743, 5.995351, -7.007048>, <4.624131, 5.995351, -7.007048>, <4.521264, 5.933470, -7.089354>, <4.521264, 5.865448, -7.192568>, 
      <4.747743, 5.795026, -6.866778>, <4.624131, 5.795026, -6.866778>, <4.521264, 5.733144, -6.949086>, <4.521264, 5.665123, -7.052298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.477276, -7.369629>, <4.635368, 6.477276, -7.369629>, <4.541854, 6.423637, -7.446232>, <4.541854, 6.359182, -7.538284>, 
      <4.747743, 6.482520, -7.359457>, <4.635368, 6.482520, -7.359457>, <4.530513, 6.422378, -7.445350>, <4.530513, 6.357922, -7.537402>, 
      <4.747743, 6.471990, -7.341133>, <4.624131, 6.471990, -7.341133>, <4.521542, 6.413148, -7.425169>, <4.521542, 6.342247, -7.526426>, 
      <4.747743, 6.462778, -7.334343>, <4.624131, 6.462778, -7.334343>, <4.521264, 6.403776, -7.418606>, <4.521264, 6.332875, -7.519864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.444473, -7.369842>, <4.645733, 6.444473, -7.369842>, <4.560842, 6.395782, -7.439380>, <4.560842, 6.337272, -7.522942>, 
      <4.747743, 6.452660, -7.375304>, <4.645733, 6.452660, -7.375304>, <4.560620, 6.403841, -7.445023>, <4.560620, 6.345331, -7.528585>, 
      <4.747743, 6.472766, -7.378375>, <4.635368, 6.472766, -7.378375>, <4.551605, 6.424721, -7.446990>, <4.551605, 6.360266, -7.539042>, 
      <4.747743, 6.477276, -7.369629>, <4.635368, 6.477276, -7.369629>, <4.541854, 6.423637, -7.446232>, <4.541854, 6.359182, -7.538284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.521264, 6.332875, -7.519864>, <4.521264, 6.261974, -7.621120>, <4.624131, 6.202972, -7.705383>, <4.747743, 6.202972, -7.705383>, 
      <4.515324, 6.132608, -7.379635>, <4.515324, 6.061708, -7.480892>, <4.624131, 6.002437, -7.572215>, <4.747743, 6.002437, -7.572215>, 
      <4.521264, 5.865448, -7.192568>, <4.521264, 5.797373, -7.295862>, <4.624033, 5.742863, -7.383211>, <4.747743, 5.742863, -7.383211>, 
      <4.521264, 5.665123, -7.052298>, <4.521264, 5.597048, -7.155594>, <4.624033, 5.545673, -7.245138>, <4.747743, 5.545673, -7.245138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.541854, 6.359182, -7.538284>, <4.541854, 6.294727, -7.630335>, <4.635368, 6.241089, -7.706938>, <4.747743, 6.241089, -7.706938>, 
      <4.530513, 6.357922, -7.537402>, <4.530513, 6.293468, -7.629453>, <4.635368, 6.233324, -7.715346>, <4.747743, 6.233324, -7.715346>, 
      <4.521542, 6.342247, -7.526426>, <4.521542, 6.271346, -7.627682>, <4.624131, 6.212506, -7.711714>, <4.747743, 6.212506, -7.711714>, 
      <4.521264, 6.332875, -7.519864>, <4.521264, 6.261974, -7.621120>, <4.624131, 6.202972, -7.705383>, <4.747743, 6.202972, -7.705383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.560842, 6.337272, -7.522942>, <4.560842, 6.278761, -7.606503>, <4.645733, 6.230070, -7.676042>, <4.747743, 6.230070, -7.676042>, 
      <4.560620, 6.345331, -7.528585>, <4.560620, 6.286820, -7.612146>, <4.645733, 6.238002, -7.681866>, <4.747743, 6.238002, -7.681866>, 
      <4.551605, 6.360266, -7.539042>, <4.551605, 6.295811, -7.631094>, <4.635368, 6.247766, -7.699710>, <4.747743, 6.247766, -7.699710>, 
      <4.541854, 6.359182, -7.538284>, <4.541854, 6.294727, -7.630335>, <4.635368, 6.241089, -7.706938>, <4.747743, 6.241089, -7.706938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.230070, -7.676042>, <4.747743, 6.033101, -7.531390>, <4.747743, 5.762977, -7.348979>, <4.747743, 5.562794, -7.208810>, 
      <4.645733, 6.230070, -7.676042>, <4.645733, 6.033101, -7.531390>, <4.645733, 5.762977, -7.348979>, <4.645733, 5.562794, -7.208810>, 
      <4.560842, 6.278761, -7.606503>, <4.566357, 6.078629, -7.466369>, <4.560842, 5.811668, -7.279442>, <4.560842, 5.611485, -7.139272>, 
      <4.560842, 6.337272, -7.522942>, <4.566357, 6.137140, -7.382808>, <4.560842, 5.870178, -7.195880>, <4.560842, 5.669995, -7.055710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.934643, 6.337272, -7.522942>, <4.929129, 6.137140, -7.382808>, <4.934643, 5.870178, -7.195880>, <4.934643, 5.669995, -7.055710>, 
      <4.934643, 6.278761, -7.606503>, <4.929129, 6.078629, -7.466369>, <4.934643, 5.811668, -7.279442>, <4.934643, 5.611485, -7.139272>, 
      <4.849752, 6.230070, -7.676042>, <4.849752, 6.033101, -7.531390>, <4.849752, 5.762977, -7.348979>, <4.849752, 5.562794, -7.208810>, 
      <4.747743, 6.230070, -7.676042>, <4.747743, 6.033101, -7.531390>, <4.747743, 5.762977, -7.348979>, <4.747743, 5.562794, -7.208810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.444473, -7.369842>, <4.747743, 6.241178, -7.234226>, <4.747743, 5.977380, -7.042780>, <4.747743, 5.777197, -6.902610>, 
      <4.849752, 6.444473, -7.369842>, <4.849752, 6.241178, -7.234226>, <4.849752, 5.977380, -7.042780>, <4.849752, 5.777197, -6.902610>, 
      <4.934643, 6.395782, -7.439380>, <4.929129, 6.195650, -7.299246>, <4.934643, 5.928688, -7.112318>, <4.934643, 5.728506, -6.972149>, 
      <4.934643, 6.337272, -7.522942>, <4.929129, 6.137140, -7.382808>, <4.934643, 5.870178, -7.195880>, <4.934643, 5.669995, -7.055710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.560842, 6.337272, -7.522942>, <4.566357, 6.137140, -7.382808>, <4.560842, 5.870178, -7.195880>, <4.560842, 5.669995, -7.055710>, 
      <4.560842, 6.395782, -7.439380>, <4.566357, 6.195650, -7.299246>, <4.560842, 5.928688, -7.112318>, <4.560842, 5.728506, -6.972149>, 
      <4.645733, 6.444473, -7.369842>, <4.645733, 6.241178, -7.234226>, <4.645733, 5.977380, -7.042780>, <4.645733, 5.777197, -6.902610>, 
      <4.747743, 6.444473, -7.369842>, <4.747743, 6.241178, -7.234226>, <4.747743, 5.977380, -7.042780>, <4.747743, 5.777197, -6.902610>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.557890, 4.015228, -7.514659>, <4.672554, 4.010394, -7.534800>, <4.822931, 3.938343, -7.534800>, <4.937596, 3.933510, -7.514659>, 
      <4.557890, 4.622615, -7.514659>, <4.672554, 4.617782, -7.534800>, <4.818952, 4.575914, -7.534800>, <4.933616, 4.571081, -7.514659>, 
      <4.550325, 5.432512, -7.514659>, <4.655105, 5.433461, -7.533305>, <4.813510, 5.415463, -7.514659>, <4.919791, 5.421099, -7.514659>, 
      <4.557890, 6.039852, -7.514659>, <4.662670, 6.040802, -7.533305>, <4.805879, 6.053002, -7.514659>, <4.912160, 6.058637, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.524828, -6.040832, -7.169174>, <6.590495, -5.437006, -7.169174>, <6.524828, -4.623596, -7.169174>, <6.524828, -4.016209, -7.169174>, 
      <6.117054, -6.040664, -7.436009>, <6.182721, -5.436838, -7.436009>, <6.113884, -4.623432, -7.431100>, <6.113884, -4.016045, -7.431100>, 
      <5.417567, -6.039638, -7.430354>, <5.425132, -5.432297, -7.430354>, <5.417154, -4.642616, -7.430426>, <5.417154, -4.035229, -7.430426>, 
      <4.937596, -6.039638, -7.514659>, <4.945160, -5.432297, -7.514659>, <4.937596, -4.622400, -7.514659>, <4.937596, -4.015013, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -7.321330, -1.836110>, <4.871354, -7.321330, -1.836110>, <4.974221, -7.321330, -1.733243>, <4.974221, -7.321330, -1.609632>, 
      <4.747743, -7.080678, -1.842047>, <4.871354, -7.080678, -1.842047>, <4.980162, -7.076850, -1.733243>, <4.980162, -7.076850, -1.609632>, 
      <4.747743, -6.759640, -1.836110>, <4.871452, -6.759640, -1.836110>, <4.974221, -6.754191, -1.733292>, <4.974221, -6.750707, -1.609632>, 
      <4.747743, -6.518915, -1.836110>, <4.871452, -6.518915, -1.836110>, <4.974221, -6.509638, -1.733292>, <4.974221, -6.506154, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -7.353445, -1.815521>, <4.860117, -7.353445, -1.815521>, <4.953632, -7.353445, -1.722006>, <4.953632, -7.353445, -1.609632>, 
      <4.747743, -7.351906, -1.826861>, <4.860117, -7.351906, -1.826861>, <4.964972, -7.351906, -1.722006>, <4.964972, -7.351906, -1.609632>, 
      <4.747743, -7.332770, -1.835827>, <4.871354, -7.332770, -1.835827>, <4.973943, -7.332771, -1.733243>, <4.973943, -7.332771, -1.609632>, 
      <4.747743, -7.321330, -1.836110>, <4.871354, -7.321330, -1.836110>, <4.974221, -7.321330, -1.733243>, <4.974221, -7.321330, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -7.326696, -1.796532>, <4.849752, -7.326696, -1.796532>, <4.934643, -7.326696, -1.711641>, <4.934643, -7.326696, -1.609632>, 
      <4.747743, -7.336535, -1.796754>, <4.849752, -7.336535, -1.796754>, <4.934865, -7.336535, -1.711641>, <4.934865, -7.336535, -1.609632>, 
      <4.747743, -7.354767, -1.805769>, <4.860117, -7.354767, -1.805769>, <4.943880, -7.354767, -1.722006>, <4.943880, -7.354767, -1.609632>, 
      <4.747743, -7.353445, -1.815521>, <4.860117, -7.353445, -1.815521>, <4.953632, -7.353445, -1.722006>, <4.953632, -7.353445, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.974221, -7.321330, -1.609632>, <4.974221, -7.321330, -1.486020>, <4.871354, -7.321330, -1.383153>, <4.747743, -7.321330, -1.383153>, 
      <4.980162, -7.076850, -1.609632>, <4.980162, -7.076850, -1.486020>, <4.871354, -7.076850, -1.377212>, <4.747743, -7.076850, -1.377212>, 
      <4.974221, -6.750707, -1.609632>, <4.974221, -6.747226, -1.486069>, <4.871354, -6.750707, -1.383153>, <4.747743, -6.750707, -1.383153>, 
      <4.974221, -6.506154, -1.609632>, <4.974221, -6.502674, -1.486069>, <4.871354, -6.506154, -1.383153>, <4.747743, -6.506154, -1.383153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.953632, -7.353445, -1.609632>, <4.953632, -7.353445, -1.497257>, <4.860117, -7.353445, -1.403742>, <4.747743, -7.353445, -1.403742>, 
      <4.964972, -7.351906, -1.609632>, <4.964972, -7.351906, -1.497257>, <4.860117, -7.351906, -1.392401>, <4.747743, -7.351906, -1.392401>, 
      <4.973943, -7.332771, -1.609632>, <4.973943, -7.332771, -1.486020>, <4.871354, -7.332771, -1.383431>, <4.747743, -7.332771, -1.383431>, 
      <4.974221, -7.321330, -1.609632>, <4.974221, -7.321330, -1.486020>, <4.871354, -7.321330, -1.383153>, <4.747743, -7.321330, -1.383153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.934643, -7.326696, -1.609632>, <4.934643, -7.326696, -1.507622>, <4.849752, -7.326696, -1.422731>, <4.747743, -7.326696, -1.422731>, 
      <4.934865, -7.336535, -1.609632>, <4.934865, -7.336535, -1.507622>, <4.849752, -7.336535, -1.422509>, <4.747743, -7.336535, -1.422509>, 
      <4.943880, -7.354767, -1.609632>, <4.943880, -7.354767, -1.497257>, <4.860117, -7.354767, -1.413494>, <4.747743, -7.354767, -1.413494>, 
      <4.953632, -7.353445, -1.609632>, <4.953632, -7.353445, -1.497257>, <4.860117, -7.353445, -1.403742>, <4.747743, -7.353445, -1.403742>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -7.321330, -1.383153>, <4.624131, -7.321330, -1.383153>, <4.521264, -7.321330, -1.486020>, <4.521264, -7.321330, -1.609632>, 
      <4.747743, -7.076850, -1.377212>, <4.624131, -7.076850, -1.377212>, <4.515324, -7.076850, -1.486020>, <4.515324, -7.076850, -1.609632>, 
      <4.747743, -6.750707, -1.383153>, <4.624131, -6.750707, -1.383153>, <4.521264, -6.747226, -1.486069>, <4.521264, -6.750707, -1.609632>, 
      <4.747743, -6.506154, -1.383153>, <4.624131, -6.506154, -1.383153>, <4.521264, -6.502674, -1.486069>, <4.521264, -6.506154, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -7.353445, -1.403742>, <4.635368, -7.353445, -1.403742>, <4.541854, -7.353445, -1.497257>, <4.541854, -7.353445, -1.609632>, 
      <4.747743, -7.351906, -1.392401>, <4.635368, -7.351906, -1.392401>, <4.530513, -7.351906, -1.497257>, <4.530513, -7.351906, -1.609632>, 
      <4.747743, -7.332771, -1.383431>, <4.624131, -7.332771, -1.383431>, <4.521542, -7.332771, -1.486020>, <4.521542, -7.332771, -1.609632>, 
      <4.747743, -7.321330, -1.383153>, <4.624131, -7.321330, -1.383153>, <4.521264, -7.321330, -1.486020>, <4.521264, -7.321330, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -7.326696, -1.422731>, <4.645733, -7.326696, -1.422731>, <4.560842, -7.326696, -1.507622>, <4.560842, -7.326696, -1.609632>, 
      <4.747743, -7.336535, -1.422509>, <4.645733, -7.336535, -1.422509>, <4.560620, -7.336535, -1.507622>, <4.560620, -7.336535, -1.609632>, 
      <4.747743, -7.354767, -1.413494>, <4.635368, -7.354767, -1.413494>, <4.551605, -7.354767, -1.497257>, <4.551605, -7.354767, -1.609632>, 
      <4.747743, -7.353445, -1.403742>, <4.635368, -7.353445, -1.403742>, <4.541854, -7.353445, -1.497257>, <4.541854, -7.353445, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.521264, -7.321330, -1.609632>, <4.521264, -7.321330, -1.733243>, <4.624131, -7.321330, -1.836110>, <4.747743, -7.321330, -1.836110>, 
      <4.515324, -7.076850, -1.609632>, <4.515324, -7.076850, -1.733243>, <4.624131, -7.080678, -1.842047>, <4.747743, -7.080678, -1.842047>, 
      <4.521264, -6.750707, -1.609632>, <4.521264, -6.754191, -1.733292>, <4.624033, -6.759640, -1.836110>, <4.747743, -6.759640, -1.836110>, 
      <4.521264, -6.506154, -1.609632>, <4.521264, -6.509638, -1.733292>, <4.624033, -6.518915, -1.836110>, <4.747743, -6.518915, -1.836110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.541854, -7.353445, -1.609632>, <4.541854, -7.353445, -1.722006>, <4.635368, -7.353445, -1.815521>, <4.747743, -7.353445, -1.815521>, 
      <4.530513, -7.351906, -1.609632>, <4.530513, -7.351906, -1.722006>, <4.635368, -7.351906, -1.826861>, <4.747743, -7.351906, -1.826861>, 
      <4.521542, -7.332771, -1.609632>, <4.521542, -7.332771, -1.733243>, <4.624131, -7.332770, -1.835827>, <4.747743, -7.332770, -1.835827>, 
      <4.521264, -7.321330, -1.609632>, <4.521264, -7.321330, -1.733243>, <4.624131, -7.321330, -1.836110>, <4.747743, -7.321330, -1.836110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.560842, -7.326696, -1.609632>, <4.560842, -7.326696, -1.711641>, <4.645733, -7.326696, -1.796532>, <4.747743, -7.326696, -1.796532>, 
      <4.560620, -7.336535, -1.609632>, <4.560620, -7.336535, -1.711641>, <4.645733, -7.336535, -1.796754>, <4.747743, -7.336535, -1.796754>, 
      <4.551605, -7.354767, -1.609632>, <4.551605, -7.354767, -1.722006>, <4.635368, -7.354767, -1.805769>, <4.747743, -7.354767, -1.805769>, 
      <4.541854, -7.353445, -1.609632>, <4.541854, -7.353445, -1.722006>, <4.635368, -7.353445, -1.815521>, <4.747743, -7.353445, -1.815521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -7.326696, -1.796532>, <4.747743, -7.082381, -1.791017>, <4.747743, -6.756481, -1.796532>, <4.747743, -6.512103, -1.796532>, 
      <4.645733, -7.326696, -1.796532>, <4.645733, -7.082381, -1.791017>, <4.645733, -6.756481, -1.796532>, <4.645733, -6.512103, -1.796532>, 
      <4.560842, -7.326696, -1.711641>, <4.566357, -7.082381, -1.711641>, <4.560842, -6.756481, -1.711641>, <4.560842, -6.512103, -1.711641>, 
      <4.560842, -7.326696, -1.609632>, <4.566357, -7.082381, -1.609632>, <4.560842, -6.756481, -1.609632>, <4.560842, -6.512103, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.934643, -7.326696, -1.609632>, <4.929129, -7.082381, -1.609632>, <4.934643, -6.756481, -1.609632>, <4.934643, -6.512103, -1.609632>, 
      <4.934643, -7.326696, -1.711641>, <4.929129, -7.082381, -1.711641>, <4.934643, -6.756481, -1.711641>, <4.934643, -6.512103, -1.711641>, 
      <4.849752, -7.326696, -1.796532>, <4.849752, -7.082381, -1.791017>, <4.849752, -6.756481, -1.796532>, <4.849752, -6.512103, -1.796532>, 
      <4.747743, -7.326696, -1.796532>, <4.747743, -7.082381, -1.791017>, <4.747743, -6.756481, -1.796532>, <4.747743, -6.512103, -1.796532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -7.326696, -1.422731>, <4.747743, -7.082381, -1.428246>, <4.747743, -6.756481, -1.422731>, <4.747743, -6.512103, -1.422731>, 
      <4.849752, -7.326696, -1.422731>, <4.849752, -7.082381, -1.428246>, <4.849752, -6.756481, -1.422731>, <4.849752, -6.512103, -1.422731>, 
      <4.934643, -7.326696, -1.507622>, <4.929129, -7.082381, -1.507622>, <4.934643, -6.756481, -1.507622>, <4.934643, -6.512103, -1.507622>, 
      <4.934643, -7.326696, -1.609632>, <4.929129, -7.082381, -1.609632>, <4.934643, -6.756481, -1.609632>, <4.934643, -6.512103, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.560842, -7.326696, -1.609632>, <4.566357, -7.082381, -1.609632>, <4.560842, -6.756481, -1.609632>, <4.560842, -6.512103, -1.609632>, 
      <4.560842, -7.326696, -1.507622>, <4.566357, -7.082381, -1.507622>, <4.560842, -6.756481, -1.507622>, <4.560842, -6.512103, -1.507622>, 
      <4.645733, -7.326696, -1.422731>, <4.645733, -7.082381, -1.428246>, <4.645733, -6.756481, -1.422731>, <4.645733, -6.512103, -1.422731>, 
      <4.747743, -7.326696, -1.422731>, <4.747743, -7.082381, -1.428246>, <4.747743, -6.756481, -1.422731>, <4.747743, -6.512103, -1.422731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.666539, -6.119236, -1.397774>, <8.666539, -6.119236, -1.532774>, <8.666539, -6.194007, -1.735371>, <8.666539, -6.119236, -1.847773>, 
      <8.666539, -6.017986, -1.362291>, <8.666539, -6.017986, -1.497290>, <8.666539, -6.137125, -1.820881>, <8.666539, -6.062354, -1.933283>, 
      <8.666539, -5.882986, -1.314979>, <8.725013, -5.801660, -1.473706>, <8.725013, -5.801660, -1.729194>, <8.666539, -5.882986, -1.887920>, 
      <8.666539, -5.781736, -1.279496>, <8.725013, -5.700411, -1.438223>, <8.725013, -5.700411, -1.746400>, <8.666539, -5.781737, -1.905126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.436062, -6.439786, -1.397774>, <8.548180, -6.401601, -1.397774>, <8.597396, -6.215401, -1.397774>, <8.666539, -6.119236, -1.397774>, 
      <8.436062, -6.338536, -1.362291>, <8.548180, -6.300352, -1.362291>, <8.597396, -6.114152, -1.362291>, <8.666539, -6.017986, -1.362291>, 
      <8.436062, -6.203536, -1.314979>, <8.548180, -6.165351, -1.314979>, <8.629638, -5.934307, -1.214814>, <8.666539, -5.882986, -1.314979>, 
      <8.436062, -6.102286, -1.279496>, <8.548180, -6.064102, -1.279496>, <8.629638, -5.833058, -1.179331>, <8.666539, -5.781736, -1.279496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.877195, -6.728645, -1.847773>, <6.241202, -6.796686, -1.847773>, <5.387366, -6.834374, -1.847773>, <4.747743, -6.834374, -1.847773>, 
      <6.877195, -6.671762, -1.933283>, <6.241202, -6.739803, -1.933283>, <5.387366, -6.780766, -1.935372>, <4.747743, -6.780766, -1.935372>, 
      <6.877195, -6.492395, -1.887920>, <6.241202, -6.560436, -1.887920>, <5.387366, -6.598125, -1.887920>, <4.747743, -6.598125, -1.887920>, 
      <6.877195, -6.391145, -1.905126>, <6.241202, -6.459186, -1.905126>, <5.387366, -6.496875, -1.905126>, <4.747743, -6.496875, -1.905126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -6.834374, -1.847773>, <4.108120, -6.834374, -1.847773>, <3.254284, -6.796686, -1.847773>, <2.618291, -6.728645, -1.847773>, 
      <4.747743, -6.780766, -1.935372>, <4.108120, -6.780766, -1.935372>, <3.254284, -6.739802, -1.933283>, <2.618291, -6.671762, -1.933283>, 
      <4.747743, -6.598125, -1.887920>, <4.108120, -6.598125, -1.887920>, <3.254284, -6.560436, -1.887920>, <2.618291, -6.492395, -1.887920>, 
      <4.747743, -6.496875, -1.905126>, <4.108120, -6.496875, -1.905126>, <3.254284, -6.459186, -1.905126>, <2.618291, -6.391145, -1.905126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.618291, -6.728645, -1.847773>, <2.145369, -6.678050, -1.847773>, <1.503059, -6.611261, -1.847773>, <1.059424, -6.439786, -1.847773>, 
      <2.618291, -6.671762, -1.933283>, <2.145369, -6.621167, -1.933283>, <1.503059, -6.554378, -1.933283>, <1.059424, -6.382904, -1.933283>, 
      <2.618291, -6.492395, -1.887920>, <2.145369, -6.441800, -1.887920>, <1.503059, -6.375010, -1.887920>, <1.059424, -6.203536, -1.887920>, 
      <2.618291, -6.391145, -1.905126>, <2.145369, -6.340550, -1.905126>, <1.503059, -6.273761, -1.905126>, <1.059424, -6.102287, -1.905126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.059424, -6.439786, -1.847773>, <0.929573, -6.389596, -1.847773>, <0.898090, -6.157854, -1.847773>, <0.828946, -6.037026, -1.847773>, 
      <1.059424, -6.382904, -1.933283>, <0.929573, -6.332714, -1.933283>, <0.898090, -6.100971, -1.933283>, <0.828946, -5.980143, -1.933283>, 
      <1.059424, -6.203536, -1.887920>, <0.929573, -6.153346, -1.887920>, <0.870138, -5.872758, -1.999733>, <0.828946, -5.800776, -1.887920>, 
      <1.059424, -6.102287, -1.905126>, <0.929573, -6.052097, -1.905126>, <0.870138, -5.771508, -2.016939>, <0.828946, -5.699526, -1.905126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.828946, -6.037026, -1.847773>, <0.828946, -6.111797, -1.735371>, <0.828946, -6.105961, -1.513846>, <0.828946, -6.037026, -1.397774>, 
      <0.828946, -5.980143, -1.933283>, <0.828946, -6.054914, -1.820881>, <0.828946, -6.051176, -1.421601>, <0.828946, -5.982241, -1.305528>, 
      <0.828946, -5.800776, -1.887920>, <0.773412, -5.703729, -1.737172>, <0.773412, -5.703729, -1.465727>, <0.828946, -5.800776, -1.314979>, 
      <0.828946, -5.699526, -1.905126>, <0.773412, -5.602480, -1.754378>, <0.773412, -5.602479, -1.430244>, <0.828946, -5.699526, -1.279496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -6.834374, -1.847773>, <4.747743, -6.911754, -1.721330>, <4.747743, -6.910071, -1.481093>, <4.747743, -6.834374, -1.353635>, 
      <5.387366, -6.834374, -1.847773>, <5.387366, -6.911754, -1.721330>, <5.387503, -6.910071, -1.481093>, <5.387503, -6.834374, -1.353635>, 
      <6.241202, -6.796686, -1.847773>, <6.241202, -6.871457, -1.735371>, <6.241111, -6.865630, -1.506234>, <6.241111, -6.796695, -1.390162>, 
      <6.877195, -6.728645, -1.847773>, <6.877195, -6.803416, -1.735371>, <6.877195, -6.797580, -1.513846>, <6.877195, -6.728645, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.618291, -6.728645, -1.847773>, <2.618291, -6.803416, -1.735371>, <2.618291, -6.797580, -1.513846>, <2.618291, -6.728645, -1.397774>, 
      <3.254284, -6.796686, -1.847773>, <3.254284, -6.871457, -1.735371>, <3.254376, -6.865630, -1.506234>, <3.254376, -6.796695, -1.390162>, 
      <4.108120, -6.834374, -1.847773>, <4.108120, -6.911754, -1.721330>, <4.107984, -6.910071, -1.481093>, <4.107984, -6.834374, -1.353635>, 
      <4.747743, -6.834374, -1.847773>, <4.747743, -6.911754, -1.721330>, <4.747743, -6.910071, -1.481093>, <4.747743, -6.834374, -1.353635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.059424, -6.439786, -1.847773>, <1.059424, -6.514558, -1.735371>, <1.059424, -6.508722, -1.513846>, <1.059424, -6.439786, -1.397774>, 
      <1.503059, -6.611261, -1.847773>, <1.503059, -6.686032, -1.735371>, <1.503059, -6.680196, -1.513846>, <1.503059, -6.611261, -1.397774>, 
      <2.145369, -6.678050, -1.847773>, <2.145369, -6.752822, -1.735371>, <2.145402, -6.746990, -1.519506>, <2.145402, -6.678054, -1.403433>, 
      <2.618291, -6.728645, -1.847773>, <2.618291, -6.803416, -1.735371>, <2.618291, -6.797580, -1.513846>, <2.618291, -6.728645, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.828946, -6.037026, -1.847773>, <0.828946, -6.111797, -1.735371>, <0.828946, -6.105961, -1.513846>, <0.828946, -6.037026, -1.397774>, 
      <0.898090, -6.157854, -1.847773>, <0.898090, -6.232625, -1.735371>, <0.898090, -6.226789, -1.513846>, <0.898090, -6.157854, -1.397774>, 
      <0.929573, -6.389596, -1.847773>, <0.929573, -6.464368, -1.735371>, <0.929573, -6.458532, -1.513846>, <0.929573, -6.389596, -1.397774>, 
      <1.059424, -6.439786, -1.847773>, <1.059424, -6.514558, -1.735371>, <1.059424, -6.508722, -1.513846>, <1.059424, -6.439786, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.436062, -6.439786, -1.847773>, <7.985836, -6.593122, -1.847773>, <7.350118, -6.678050, -1.847773>, <6.877195, -6.728645, -1.847773>, 
      <8.436062, -6.382904, -1.933283>, <7.985836, -6.536240, -1.933283>, <7.350118, -6.621167, -1.933283>, <6.877195, -6.671762, -1.933283>, 
      <8.436062, -6.203536, -1.887920>, <7.985836, -6.356873, -1.887920>, <7.350118, -6.441800, -1.887920>, <6.877195, -6.492395, -1.887920>, 
      <8.436062, -6.102287, -1.905126>, <7.985836, -6.255623, -1.905126>, <7.350118, -6.340550, -1.905126>, <6.877195, -6.391145, -1.905126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.436062, -6.439786, -1.397774>, <7.985836, -6.593122, -1.397774>, <7.350084, -6.678054, -1.403433>, <6.877195, -6.728645, -1.397774>, 
      <8.384086, -6.512074, -1.499253>, <7.933861, -6.665410, -1.499253>, <7.350084, -6.746990, -1.519506>, <6.877195, -6.797580, -1.513846>, 
      <8.436062, -6.514557, -1.735371>, <7.985836, -6.667894, -1.735371>, <7.350118, -6.752822, -1.735371>, <6.877195, -6.803416, -1.735371>, 
      <8.436062, -6.439786, -1.847773>, <7.985836, -6.593122, -1.847773>, <7.350118, -6.678050, -1.847773>, <6.877195, -6.728645, -1.847773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.666539, -5.781737, -1.905126>, <8.629640, -5.833058, -2.005291>, <8.548180, -6.064102, -1.905126>, <8.436062, -6.102287, -1.905126>, 
      <8.666539, -5.882986, -1.887920>, <8.629640, -5.934308, -1.988085>, <8.548180, -6.165352, -1.887920>, <8.436062, -6.203536, -1.887920>, 
      <8.666539, -6.062354, -1.933283>, <8.597396, -6.158519, -1.933283>, <8.548180, -6.344719, -1.933283>, <8.436062, -6.382904, -1.933283>, 
      <8.666539, -6.119236, -1.847773>, <8.597396, -6.215401, -1.847773>, <8.548180, -6.401601, -1.847773>, <8.436062, -6.439786, -1.847773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.436062, -6.439786, -1.397774>, <8.384086, -6.512074, -1.499253>, <8.436062, -6.514557, -1.735371>, <8.436062, -6.439786, -1.847773>, 
      <8.548180, -6.401601, -1.397774>, <8.496204, -6.473889, -1.499253>, <8.548180, -6.476373, -1.735371>, <8.548180, -6.401601, -1.847773>, 
      <8.597396, -6.215401, -1.397774>, <8.597396, -6.215401, -1.532774>, <8.597396, -6.290172, -1.735371>, <8.597396, -6.215401, -1.847773>, 
      <8.666539, -6.119236, -1.397774>, <8.666539, -6.119236, -1.532774>, <8.666539, -6.194007, -1.735371>, <8.666539, -6.119236, -1.847773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.877195, -6.728645, -1.397774>, <6.877195, -6.673860, -1.305528>, <6.877195, -6.492395, -1.314979>, <6.877195, -6.391145, -1.279496>, 
      <7.350084, -6.678054, -1.403433>, <7.350084, -6.623269, -1.311187>, <7.350118, -6.441800, -1.314979>, <7.350118, -6.340550, -1.279496>, 
      <7.985836, -6.593122, -1.397774>, <7.985836, -6.491873, -1.362291>, <7.985836, -6.356872, -1.314979>, <7.985836, -6.255623, -1.279496>, 
      <8.436062, -6.439786, -1.397774>, <8.436062, -6.338536, -1.362291>, <8.436062, -6.203536, -1.314979>, <8.436062, -6.102286, -1.279496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -6.834374, -1.353635>, <4.747743, -6.781440, -1.264505>, <4.747743, -6.598124, -1.301738>, <4.747743, -6.496875, -1.279496>, 
      <5.387503, -6.834374, -1.353635>, <5.387503, -6.781440, -1.264505>, <5.387366, -6.598124, -1.301738>, <5.387366, -6.496875, -1.279496>, 
      <6.241111, -6.796695, -1.390162>, <6.241111, -6.741910, -1.297916>, <6.241202, -6.560436, -1.314979>, <6.241202, -6.459186, -1.279496>, 
      <6.877195, -6.728645, -1.397774>, <6.877195, -6.673860, -1.305528>, <6.877195, -6.492395, -1.314979>, <6.877195, -6.391145, -1.279496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.618291, -6.728645, -1.397774>, <2.618291, -6.673860, -1.305528>, <2.618291, -6.492395, -1.314979>, <2.618291, -6.391145, -1.279496>, 
      <3.254376, -6.796695, -1.390162>, <3.254376, -6.741910, -1.297916>, <3.254284, -6.560435, -1.314979>, <3.254284, -6.459186, -1.279496>, 
      <4.107984, -6.834374, -1.353635>, <4.107984, -6.781440, -1.264505>, <4.108120, -6.598124, -1.301738>, <4.108120, -6.496875, -1.279496>, 
      <4.747743, -6.834374, -1.353635>, <4.747743, -6.781440, -1.264505>, <4.747743, -6.598124, -1.301738>, <4.747743, -6.496875, -1.279496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.059424, -6.439786, -1.397774>, <1.059424, -6.385002, -1.305528>, <1.059424, -6.203536, -1.314979>, <1.059424, -6.102287, -1.279496>, 
      <1.503059, -6.611261, -1.397774>, <1.503059, -6.556476, -1.305528>, <1.503059, -6.375011, -1.314979>, <1.503059, -6.273761, -1.279496>, 
      <2.145402, -6.678054, -1.403433>, <2.145402, -6.623269, -1.311187>, <2.145369, -6.441800, -1.314979>, <2.145369, -6.340550, -1.279496>, 
      <2.618291, -6.728645, -1.397774>, <2.618291, -6.673860, -1.305528>, <2.618291, -6.492395, -1.314979>, <2.618291, -6.391145, -1.279496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.828946, -6.037026, -1.397774>, <0.828946, -5.982241, -1.305528>, <0.828946, -5.800776, -1.314979>, <0.828946, -5.699526, -1.279496>, 
      <0.898090, -6.157854, -1.397774>, <0.898090, -6.103069, -1.305528>, <0.870138, -5.872758, -1.203166>, <0.870138, -5.771508, -1.167683>, 
      <0.929573, -6.389596, -1.397774>, <0.929573, -6.334812, -1.305528>, <0.929573, -6.153346, -1.314979>, <0.929573, -6.052097, -1.279496>, 
      <1.059424, -6.439786, -1.397774>, <1.059424, -6.385002, -1.305528>, <1.059424, -6.203536, -1.314979>, <1.059424, -6.102287, -1.279496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 7.321330, -1.836110>, <4.871354, 7.321330, -1.836110>, <4.974221, 7.321330, -1.733243>, <4.974221, 7.321330, -1.609632>, 
      <4.747743, 7.080678, -1.842047>, <4.871354, 7.080678, -1.842047>, <4.980162, 7.076850, -1.733243>, <4.980162, 7.076850, -1.609632>, 
      <4.747743, 6.759640, -1.836110>, <4.871452, 6.759640, -1.836110>, <4.974221, 6.754191, -1.733292>, <4.974221, 6.750707, -1.609632>, 
      <4.747743, 6.518915, -1.836110>, <4.871452, 6.518915, -1.836110>, <4.974221, 6.509638, -1.733292>, <4.974221, 6.506154, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 7.353445, -1.815521>, <4.860117, 7.353445, -1.815521>, <4.953632, 7.353445, -1.722006>, <4.953632, 7.353445, -1.609632>, 
      <4.747743, 7.351906, -1.826861>, <4.860117, 7.351906, -1.826861>, <4.964972, 7.351906, -1.722006>, <4.964972, 7.351906, -1.609632>, 
      <4.747743, 7.332770, -1.835827>, <4.871354, 7.332770, -1.835827>, <4.973943, 7.332771, -1.733243>, <4.973943, 7.332771, -1.609632>, 
      <4.747743, 7.321330, -1.836110>, <4.871354, 7.321330, -1.836110>, <4.974221, 7.321330, -1.733243>, <4.974221, 7.321330, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 7.326696, -1.796532>, <4.849752, 7.326696, -1.796532>, <4.934643, 7.326696, -1.711641>, <4.934643, 7.326696, -1.609632>, 
      <4.747743, 7.336535, -1.796754>, <4.849752, 7.336535, -1.796754>, <4.934865, 7.336535, -1.711641>, <4.934865, 7.336535, -1.609632>, 
      <4.747743, 7.354767, -1.805769>, <4.860117, 7.354767, -1.805769>, <4.943880, 7.354767, -1.722006>, <4.943880, 7.354767, -1.609632>, 
      <4.747743, 7.353445, -1.815521>, <4.860117, 7.353445, -1.815521>, <4.953632, 7.353445, -1.722006>, <4.953632, 7.353445, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.974221, 7.321330, -1.609632>, <4.974221, 7.321330, -1.486020>, <4.871354, 7.321330, -1.383153>, <4.747743, 7.321330, -1.383153>, 
      <4.980162, 7.076850, -1.609632>, <4.980162, 7.076850, -1.486020>, <4.871354, 7.076850, -1.377212>, <4.747743, 7.076850, -1.377212>, 
      <4.974221, 6.750707, -1.609632>, <4.974221, 6.747226, -1.486069>, <4.871354, 6.750707, -1.383153>, <4.747743, 6.750707, -1.383153>, 
      <4.974221, 6.506154, -1.609632>, <4.974221, 6.502674, -1.486069>, <4.871354, 6.506154, -1.383153>, <4.747743, 6.506154, -1.383153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.953632, 7.353445, -1.609632>, <4.953632, 7.353445, -1.497257>, <4.860117, 7.353445, -1.403742>, <4.747743, 7.353445, -1.403742>, 
      <4.964972, 7.351906, -1.609632>, <4.964972, 7.351906, -1.497257>, <4.860117, 7.351906, -1.392401>, <4.747743, 7.351906, -1.392401>, 
      <4.973943, 7.332771, -1.609632>, <4.973943, 7.332771, -1.486020>, <4.871354, 7.332771, -1.383431>, <4.747743, 7.332771, -1.383431>, 
      <4.974221, 7.321330, -1.609632>, <4.974221, 7.321330, -1.486020>, <4.871354, 7.321330, -1.383153>, <4.747743, 7.321330, -1.383153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.934643, 7.326696, -1.609632>, <4.934643, 7.326696, -1.507622>, <4.849752, 7.326696, -1.422731>, <4.747743, 7.326696, -1.422731>, 
      <4.934865, 7.336535, -1.609632>, <4.934865, 7.336535, -1.507622>, <4.849752, 7.336535, -1.422509>, <4.747743, 7.336535, -1.422509>, 
      <4.943880, 7.354767, -1.609632>, <4.943880, 7.354767, -1.497257>, <4.860117, 7.354767, -1.413494>, <4.747743, 7.354767, -1.413494>, 
      <4.953632, 7.353445, -1.609632>, <4.953632, 7.353445, -1.497257>, <4.860117, 7.353445, -1.403742>, <4.747743, 7.353445, -1.403742>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 7.321330, -1.383153>, <4.624131, 7.321330, -1.383153>, <4.521264, 7.321330, -1.486020>, <4.521264, 7.321330, -1.609632>, 
      <4.747743, 7.076850, -1.377212>, <4.624131, 7.076850, -1.377212>, <4.515324, 7.076850, -1.486020>, <4.515324, 7.076850, -1.609632>, 
      <4.747743, 6.750707, -1.383153>, <4.624131, 6.750707, -1.383153>, <4.521264, 6.747226, -1.486069>, <4.521264, 6.750707, -1.609632>, 
      <4.747743, 6.506154, -1.383153>, <4.624131, 6.506154, -1.383153>, <4.521264, 6.502674, -1.486069>, <4.521264, 6.506154, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 7.353445, -1.403742>, <4.635368, 7.353445, -1.403742>, <4.541854, 7.353445, -1.497257>, <4.541854, 7.353445, -1.609632>, 
      <4.747743, 7.351906, -1.392401>, <4.635368, 7.351906, -1.392401>, <4.530513, 7.351906, -1.497257>, <4.530513, 7.351906, -1.609632>, 
      <4.747743, 7.332771, -1.383431>, <4.624131, 7.332771, -1.383431>, <4.521542, 7.332771, -1.486020>, <4.521542, 7.332771, -1.609632>, 
      <4.747743, 7.321330, -1.383153>, <4.624131, 7.321330, -1.383153>, <4.521264, 7.321330, -1.486020>, <4.521264, 7.321330, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 7.326696, -1.422731>, <4.645733, 7.326696, -1.422731>, <4.560842, 7.326696, -1.507622>, <4.560842, 7.326696, -1.609632>, 
      <4.747743, 7.336535, -1.422509>, <4.645733, 7.336535, -1.422509>, <4.560620, 7.336535, -1.507622>, <4.560620, 7.336535, -1.609632>, 
      <4.747743, 7.354767, -1.413494>, <4.635368, 7.354767, -1.413494>, <4.551605, 7.354767, -1.497257>, <4.551605, 7.354767, -1.609632>, 
      <4.747743, 7.353445, -1.403742>, <4.635368, 7.353445, -1.403742>, <4.541854, 7.353445, -1.497257>, <4.541854, 7.353445, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.521264, 7.321330, -1.609632>, <4.521264, 7.321330, -1.733243>, <4.624131, 7.321330, -1.836110>, <4.747743, 7.321330, -1.836110>, 
      <4.515324, 7.076850, -1.609632>, <4.515324, 7.076850, -1.733243>, <4.624131, 7.080678, -1.842047>, <4.747743, 7.080678, -1.842047>, 
      <4.521264, 6.750707, -1.609632>, <4.521264, 6.754191, -1.733292>, <4.624033, 6.759640, -1.836110>, <4.747743, 6.759640, -1.836110>, 
      <4.521264, 6.506154, -1.609632>, <4.521264, 6.509638, -1.733292>, <4.624033, 6.518915, -1.836110>, <4.747743, 6.518915, -1.836110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.541854, 7.353445, -1.609632>, <4.541854, 7.353445, -1.722006>, <4.635368, 7.353445, -1.815521>, <4.747743, 7.353445, -1.815521>, 
      <4.530513, 7.351906, -1.609632>, <4.530513, 7.351906, -1.722006>, <4.635368, 7.351906, -1.826861>, <4.747743, 7.351906, -1.826861>, 
      <4.521542, 7.332771, -1.609632>, <4.521542, 7.332771, -1.733243>, <4.624131, 7.332770, -1.835827>, <4.747743, 7.332770, -1.835827>, 
      <4.521264, 7.321330, -1.609632>, <4.521264, 7.321330, -1.733243>, <4.624131, 7.321330, -1.836110>, <4.747743, 7.321330, -1.836110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.560842, 7.326696, -1.609632>, <4.560842, 7.326696, -1.711641>, <4.645733, 7.326696, -1.796532>, <4.747743, 7.326696, -1.796532>, 
      <4.560620, 7.336535, -1.609632>, <4.560620, 7.336535, -1.711641>, <4.645733, 7.336535, -1.796754>, <4.747743, 7.336535, -1.796754>, 
      <4.551605, 7.354767, -1.609632>, <4.551605, 7.354767, -1.722006>, <4.635368, 7.354767, -1.805769>, <4.747743, 7.354767, -1.805769>, 
      <4.541854, 7.353445, -1.609632>, <4.541854, 7.353445, -1.722006>, <4.635368, 7.353445, -1.815521>, <4.747743, 7.353445, -1.815521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 7.326696, -1.796532>, <4.747743, 7.082381, -1.791017>, <4.747743, 6.756481, -1.796532>, <4.747743, 6.512103, -1.796532>, 
      <4.645733, 7.326696, -1.796532>, <4.645733, 7.082381, -1.791017>, <4.645733, 6.756481, -1.796532>, <4.645733, 6.512103, -1.796532>, 
      <4.560842, 7.326696, -1.711641>, <4.566357, 7.082381, -1.711641>, <4.560842, 6.756481, -1.711641>, <4.560842, 6.512103, -1.711641>, 
      <4.560842, 7.326696, -1.609632>, <4.566357, 7.082381, -1.609632>, <4.560842, 6.756481, -1.609632>, <4.560842, 6.512103, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.934643, 7.326696, -1.609632>, <4.929129, 7.082381, -1.609632>, <4.934643, 6.756481, -1.609632>, <4.934643, 6.512103, -1.609632>, 
      <4.934643, 7.326696, -1.711641>, <4.929129, 7.082381, -1.711641>, <4.934643, 6.756481, -1.711641>, <4.934643, 6.512103, -1.711641>, 
      <4.849752, 7.326696, -1.796532>, <4.849752, 7.082381, -1.791017>, <4.849752, 6.756481, -1.796532>, <4.849752, 6.512103, -1.796532>, 
      <4.747743, 7.326696, -1.796532>, <4.747743, 7.082381, -1.791017>, <4.747743, 6.756481, -1.796532>, <4.747743, 6.512103, -1.796532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 7.326696, -1.422731>, <4.747743, 7.082381, -1.428246>, <4.747743, 6.756481, -1.422731>, <4.747743, 6.512103, -1.422731>, 
      <4.849752, 7.326696, -1.422731>, <4.849752, 7.082381, -1.428246>, <4.849752, 6.756481, -1.422731>, <4.849752, 6.512103, -1.422731>, 
      <4.934643, 7.326696, -1.507622>, <4.929129, 7.082381, -1.507622>, <4.934643, 6.756481, -1.507622>, <4.934643, 6.512103, -1.507622>, 
      <4.934643, 7.326696, -1.609632>, <4.929129, 7.082381, -1.609632>, <4.934643, 6.756481, -1.609632>, <4.934643, 6.512103, -1.609632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.560842, 7.326696, -1.609632>, <4.566357, 7.082381, -1.609632>, <4.560842, 6.756481, -1.609632>, <4.560842, 6.512103, -1.609632>, 
      <4.560842, 7.326696, -1.507622>, <4.566357, 7.082381, -1.507622>, <4.560842, 6.756481, -1.507622>, <4.560842, 6.512103, -1.507622>, 
      <4.645733, 7.326696, -1.422731>, <4.645733, 7.082381, -1.428246>, <4.645733, 6.756481, -1.422731>, <4.645733, 6.512103, -1.422731>, 
      <4.747743, 7.326696, -1.422731>, <4.747743, 7.082381, -1.428246>, <4.747743, 6.756481, -1.422731>, <4.747743, 6.512103, -1.422731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.666539, 6.119236, -1.397774>, <8.666539, 6.119236, -1.532774>, <8.666539, 6.194007, -1.735371>, <8.666539, 6.119236, -1.847773>, 
      <8.666539, 6.017986, -1.362291>, <8.666539, 6.017986, -1.497290>, <8.666539, 6.137125, -1.820881>, <8.666539, 6.062354, -1.933283>, 
      <8.666539, 5.882986, -1.314979>, <8.725013, 5.801660, -1.473706>, <8.725013, 5.801660, -1.729194>, <8.666539, 5.882986, -1.887920>, 
      <8.666539, 5.781736, -1.279496>, <8.725013, 5.700411, -1.438223>, <8.725013, 5.700411, -1.746400>, <8.666539, 5.781737, -1.905126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.436062, 6.439786, -1.397774>, <8.548180, 6.401601, -1.397774>, <8.597396, 6.215401, -1.397774>, <8.666539, 6.119236, -1.397774>, 
      <8.436062, 6.338536, -1.362291>, <8.548180, 6.300352, -1.362291>, <8.597396, 6.114152, -1.362291>, <8.666539, 6.017986, -1.362291>, 
      <8.436062, 6.203536, -1.314979>, <8.548180, 6.165351, -1.314979>, <8.629638, 5.934307, -1.214814>, <8.666539, 5.882986, -1.314979>, 
      <8.436062, 6.102286, -1.279496>, <8.548180, 6.064102, -1.279496>, <8.629638, 5.833058, -1.179331>, <8.666539, 5.781736, -1.279496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.877195, 6.728645, -1.847773>, <6.241202, 6.796686, -1.847773>, <5.387366, 6.834374, -1.847773>, <4.747743, 6.834374, -1.847773>, 
      <6.877195, 6.671762, -1.933283>, <6.241202, 6.739803, -1.933283>, <5.387366, 6.780766, -1.935372>, <4.747743, 6.780766, -1.935372>, 
      <6.877195, 6.492395, -1.887920>, <6.241202, 6.560436, -1.887920>, <5.387366, 6.598125, -1.887920>, <4.747743, 6.598125, -1.887920>, 
      <6.877195, 6.391145, -1.905126>, <6.241202, 6.459186, -1.905126>, <5.387366, 6.496875, -1.905126>, <4.747743, 6.496875, -1.905126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.834374, -1.847773>, <4.108120, 6.834374, -1.847773>, <3.254284, 6.796686, -1.847773>, <2.618291, 6.728645, -1.847773>, 
      <4.747743, 6.780766, -1.935372>, <4.108120, 6.780766, -1.935372>, <3.254284, 6.739802, -1.933283>, <2.618291, 6.671762, -1.933283>, 
      <4.747743, 6.598125, -1.887920>, <4.108120, 6.598125, -1.887920>, <3.254284, 6.560436, -1.887920>, <2.618291, 6.492395, -1.887920>, 
      <4.747743, 6.496875, -1.905126>, <4.108120, 6.496875, -1.905126>, <3.254284, 6.459186, -1.905126>, <2.618291, 6.391145, -1.905126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.618291, 6.728645, -1.847773>, <2.145369, 6.678050, -1.847773>, <1.503059, 6.611261, -1.847773>, <1.059424, 6.439786, -1.847773>, 
      <2.618291, 6.671762, -1.933283>, <2.145369, 6.621167, -1.933283>, <1.503059, 6.554378, -1.933283>, <1.059424, 6.382904, -1.933283>, 
      <2.618291, 6.492395, -1.887920>, <2.145369, 6.441800, -1.887920>, <1.503059, 6.375010, -1.887920>, <1.059424, 6.203536, -1.887920>, 
      <2.618291, 6.391145, -1.905126>, <2.145369, 6.340550, -1.905126>, <1.503059, 6.273761, -1.905126>, <1.059424, 6.102287, -1.905126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.059424, 6.439786, -1.847773>, <0.929573, 6.389596, -1.847773>, <0.898090, 6.157854, -1.847773>, <0.828946, 6.037026, -1.847773>, 
      <1.059424, 6.382904, -1.933283>, <0.929573, 6.332714, -1.933283>, <0.898090, 6.100971, -1.933283>, <0.828946, 5.980143, -1.933283>, 
      <1.059424, 6.203536, -1.887920>, <0.929573, 6.153346, -1.887920>, <0.870138, 5.872758, -1.999733>, <0.828946, 5.800776, -1.887920>, 
      <1.059424, 6.102287, -1.905126>, <0.929573, 6.052097, -1.905126>, <0.870138, 5.771508, -2.016939>, <0.828946, 5.699526, -1.905126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.828946, 6.037026, -1.847773>, <0.828946, 6.111797, -1.735371>, <0.828946, 6.105961, -1.513846>, <0.828946, 6.037026, -1.397774>, 
      <0.828946, 5.980143, -1.933283>, <0.828946, 6.054914, -1.820881>, <0.828946, 6.051176, -1.421601>, <0.828946, 5.982241, -1.305528>, 
      <0.828946, 5.800776, -1.887920>, <0.773412, 5.703729, -1.737172>, <0.773412, 5.703729, -1.465727>, <0.828946, 5.800776, -1.314979>, 
      <0.828946, 5.699526, -1.905126>, <0.773412, 5.602480, -1.754378>, <0.773412, 5.602479, -1.430244>, <0.828946, 5.699526, -1.279496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.834374, -1.847773>, <4.747743, 6.911754, -1.721330>, <4.747743, 6.910071, -1.481093>, <4.747743, 6.834374, -1.353635>, 
      <5.387366, 6.834374, -1.847773>, <5.387366, 6.911754, -1.721330>, <5.387503, 6.910071, -1.481093>, <5.387503, 6.834374, -1.353635>, 
      <6.241202, 6.796686, -1.847773>, <6.241202, 6.871457, -1.735371>, <6.241111, 6.865630, -1.506234>, <6.241111, 6.796695, -1.390162>, 
      <6.877195, 6.728645, -1.847773>, <6.877195, 6.803416, -1.735371>, <6.877195, 6.797580, -1.513846>, <6.877195, 6.728645, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.618291, 6.728645, -1.847773>, <2.618291, 6.803416, -1.735371>, <2.618291, 6.797580, -1.513846>, <2.618291, 6.728645, -1.397774>, 
      <3.254284, 6.796686, -1.847773>, <3.254284, 6.871457, -1.735371>, <3.254376, 6.865630, -1.506234>, <3.254376, 6.796695, -1.390162>, 
      <4.108120, 6.834374, -1.847773>, <4.108120, 6.911754, -1.721330>, <4.107984, 6.910071, -1.481093>, <4.107984, 6.834374, -1.353635>, 
      <4.747743, 6.834374, -1.847773>, <4.747743, 6.911754, -1.721330>, <4.747743, 6.910071, -1.481093>, <4.747743, 6.834374, -1.353635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.059424, 6.439786, -1.847773>, <1.059424, 6.514558, -1.735371>, <1.059424, 6.508722, -1.513846>, <1.059424, 6.439786, -1.397774>, 
      <1.503059, 6.611261, -1.847773>, <1.503059, 6.686032, -1.735371>, <1.503059, 6.680196, -1.513846>, <1.503059, 6.611261, -1.397774>, 
      <2.145369, 6.678050, -1.847773>, <2.145369, 6.752822, -1.735371>, <2.145402, 6.746990, -1.519506>, <2.145402, 6.678054, -1.403433>, 
      <2.618291, 6.728645, -1.847773>, <2.618291, 6.803416, -1.735371>, <2.618291, 6.797580, -1.513846>, <2.618291, 6.728645, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.828946, 6.037026, -1.847773>, <0.828946, 6.111797, -1.735371>, <0.828946, 6.105961, -1.513846>, <0.828946, 6.037026, -1.397774>, 
      <0.898090, 6.157854, -1.847773>, <0.898090, 6.232625, -1.735371>, <0.898090, 6.226789, -1.513846>, <0.898090, 6.157854, -1.397774>, 
      <0.929573, 6.389596, -1.847773>, <0.929573, 6.464368, -1.735371>, <0.929573, 6.458532, -1.513846>, <0.929573, 6.389596, -1.397774>, 
      <1.059424, 6.439786, -1.847773>, <1.059424, 6.514558, -1.735371>, <1.059424, 6.508722, -1.513846>, <1.059424, 6.439786, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.436062, 6.439786, -1.847773>, <7.985836, 6.593122, -1.847773>, <7.350118, 6.678050, -1.847773>, <6.877195, 6.728645, -1.847773>, 
      <8.436062, 6.382904, -1.933283>, <7.985836, 6.536240, -1.933283>, <7.350118, 6.621167, -1.933283>, <6.877195, 6.671762, -1.933283>, 
      <8.436062, 6.203536, -1.887920>, <7.985836, 6.356873, -1.887920>, <7.350118, 6.441800, -1.887920>, <6.877195, 6.492395, -1.887920>, 
      <8.436062, 6.102287, -1.905126>, <7.985836, 6.255623, -1.905126>, <7.350118, 6.340550, -1.905126>, <6.877195, 6.391145, -1.905126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.436062, 6.439786, -1.397774>, <7.985836, 6.593122, -1.397774>, <7.350084, 6.678054, -1.403433>, <6.877195, 6.728645, -1.397774>, 
      <8.384086, 6.512074, -1.499253>, <7.933861, 6.665410, -1.499253>, <7.350084, 6.746990, -1.519506>, <6.877195, 6.797580, -1.513846>, 
      <8.436062, 6.514557, -1.735371>, <7.985836, 6.667894, -1.735371>, <7.350118, 6.752822, -1.735371>, <6.877195, 6.803416, -1.735371>, 
      <8.436062, 6.439786, -1.847773>, <7.985836, 6.593122, -1.847773>, <7.350118, 6.678050, -1.847773>, <6.877195, 6.728645, -1.847773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.666539, 5.781737, -1.905126>, <8.629640, 5.833058, -2.005291>, <8.548180, 6.064102, -1.905126>, <8.436062, 6.102287, -1.905126>, 
      <8.666539, 5.882986, -1.887920>, <8.629640, 5.934308, -1.988085>, <8.548180, 6.165352, -1.887920>, <8.436062, 6.203536, -1.887920>, 
      <8.666539, 6.062354, -1.933283>, <8.597396, 6.158519, -1.933283>, <8.548180, 6.344719, -1.933283>, <8.436062, 6.382904, -1.933283>, 
      <8.666539, 6.119236, -1.847773>, <8.597396, 6.215401, -1.847773>, <8.548180, 6.401601, -1.847773>, <8.436062, 6.439786, -1.847773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.436062, 6.439786, -1.397774>, <8.384086, 6.512074, -1.499253>, <8.436062, 6.514557, -1.735371>, <8.436062, 6.439786, -1.847773>, 
      <8.548180, 6.401601, -1.397774>, <8.496204, 6.473889, -1.499253>, <8.548180, 6.476373, -1.735371>, <8.548180, 6.401601, -1.847773>, 
      <8.597396, 6.215401, -1.397774>, <8.597396, 6.215401, -1.532774>, <8.597396, 6.290172, -1.735371>, <8.597396, 6.215401, -1.847773>, 
      <8.666539, 6.119236, -1.397774>, <8.666539, 6.119236, -1.532774>, <8.666539, 6.194007, -1.735371>, <8.666539, 6.119236, -1.847773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.877195, 6.728645, -1.397774>, <6.877195, 6.673860, -1.305528>, <6.877195, 6.492395, -1.314979>, <6.877195, 6.391145, -1.279496>, 
      <7.350084, 6.678054, -1.403433>, <7.350084, 6.623269, -1.311187>, <7.350118, 6.441800, -1.314979>, <7.350118, 6.340550, -1.279496>, 
      <7.985836, 6.593122, -1.397774>, <7.985836, 6.491873, -1.362291>, <7.985836, 6.356872, -1.314979>, <7.985836, 6.255623, -1.279496>, 
      <8.436062, 6.439786, -1.397774>, <8.436062, 6.338536, -1.362291>, <8.436062, 6.203536, -1.314979>, <8.436062, 6.102286, -1.279496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.834374, -1.353635>, <4.747743, 6.781440, -1.264505>, <4.747743, 6.598124, -1.301738>, <4.747743, 6.496875, -1.279496>, 
      <5.387503, 6.834374, -1.353635>, <5.387503, 6.781440, -1.264505>, <5.387366, 6.598124, -1.301738>, <5.387366, 6.496875, -1.279496>, 
      <6.241111, 6.796695, -1.390162>, <6.241111, 6.741910, -1.297916>, <6.241202, 6.560436, -1.314979>, <6.241202, 6.459186, -1.279496>, 
      <6.877195, 6.728645, -1.397774>, <6.877195, 6.673860, -1.305528>, <6.877195, 6.492395, -1.314979>, <6.877195, 6.391145, -1.279496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.618291, 6.728645, -1.397774>, <2.618291, 6.673860, -1.305528>, <2.618291, 6.492395, -1.314979>, <2.618291, 6.391145, -1.279496>, 
      <3.254376, 6.796695, -1.390162>, <3.254376, 6.741910, -1.297916>, <3.254284, 6.560435, -1.314979>, <3.254284, 6.459186, -1.279496>, 
      <4.107984, 6.834374, -1.353635>, <4.107984, 6.781440, -1.264505>, <4.108120, 6.598124, -1.301738>, <4.108120, 6.496875, -1.279496>, 
      <4.747743, 6.834374, -1.353635>, <4.747743, 6.781440, -1.264505>, <4.747743, 6.598124, -1.301738>, <4.747743, 6.496875, -1.279496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.059424, 6.439786, -1.397774>, <1.059424, 6.385002, -1.305528>, <1.059424, 6.203536, -1.314979>, <1.059424, 6.102287, -1.279496>, 
      <1.503059, 6.611261, -1.397774>, <1.503059, 6.556476, -1.305528>, <1.503059, 6.375011, -1.314979>, <1.503059, 6.273761, -1.279496>, 
      <2.145402, 6.678054, -1.403433>, <2.145402, 6.623269, -1.311187>, <2.145369, 6.441800, -1.314979>, <2.145369, 6.340550, -1.279496>, 
      <2.618291, 6.728645, -1.397774>, <2.618291, 6.673860, -1.305528>, <2.618291, 6.492395, -1.314979>, <2.618291, 6.391145, -1.279496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.828946, 6.037026, -1.397774>, <0.828946, 5.982241, -1.305528>, <0.828946, 5.800776, -1.314979>, <0.828946, 5.699526, -1.279496>, 
      <0.898090, 6.157854, -1.397774>, <0.898090, 6.103069, -1.305528>, <0.870138, 5.872758, -1.203166>, <0.870138, 5.771508, -1.167683>, 
      <0.929573, 6.389596, -1.397774>, <0.929573, 6.334812, -1.305528>, <0.929573, 6.153346, -1.314979>, <0.929573, 6.052097, -1.279496>, 
      <1.059424, 6.439786, -1.397774>, <1.059424, 6.385002, -1.305528>, <1.059424, 6.203536, -1.314979>, <1.059424, 6.102287, -1.279496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.937596, 3.933510, -7.514659>, <4.941247, 3.348630, -7.514659>, <4.937596, 2.568763, -7.514659>, <4.937596, 1.983872, -7.514659>, 
      <4.822931, 3.938343, -7.534800>, <4.826582, 3.353463, -7.534800>, <4.825385, 2.569215, -7.534369>, <4.825385, 1.984324, -7.534369>, 
      <4.672554, 4.010394, -7.534800>, <4.672554, 3.403008, -7.534800>, <4.670101, 2.597539, -7.534369>, <4.670101, 1.990152, -7.534369>, 
      <4.557890, 4.015228, -7.514659>, <4.557890, 3.407841, -7.514659>, <4.557890, 2.597992, -7.514659>, <4.557890, 1.990605, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.524828, 3.932315, -7.169174>, <6.524828, 4.584694, -7.169174>, <6.592778, 5.458081, -7.169174>, <6.524828, 6.106911, -7.169174>, 
      <6.113884, 3.932479, -7.431100>, <6.113884, 4.584858, -7.431100>, <6.177514, 5.460573, -7.438552>, <6.109564, 6.109403, -7.438552>, 
      <5.417154, 3.913294, -7.430426>, <5.413175, 4.550866, -7.430426>, <5.403592, 5.435581, -7.411014>, <5.395961, 6.073119, -7.411014>, 
      <4.937596, 3.933510, -7.514659>, <4.933616, 4.571081, -7.514659>, <4.919791, 5.421099, -7.514659>, <4.912160, 6.058637, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.937596, 1.983872, -7.514659>, <4.937596, 1.398980, -7.514659>, <4.937596, 0.619125, -7.514659>, <4.937596, 0.034234, -7.514659>, 
      <4.825385, 1.984324, -7.534369>, <4.825385, 1.399433, -7.534369>, <4.823668, 0.615241, -7.534670>, <4.823668, 0.030350, -7.534670>, 
      <4.670101, 1.990152, -7.534369>, <4.670101, 1.382765, -7.534369>, <4.671818, 0.577252, -7.534670>, <4.671818, -0.030135, -7.534670>, 
      <4.557890, 1.990605, -7.514659>, <4.557890, 1.383217, -7.514659>, <4.557890, 0.573368, -7.514659>, <4.557890, -0.034019, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.524828, 1.982677, -7.169174>, <6.524828, 2.567568, -7.169174>, <6.524828, 3.347423, -7.169174>, <6.524828, 3.932315, -7.169174>, 
      <6.113884, 1.982842, -7.431100>, <6.113884, 2.567733, -7.431100>, <6.113884, 3.347588, -7.431100>, <6.113884, 3.932479, -7.431100>, 
      <5.417564, 1.981937, -7.430354>, <5.417564, 2.566829, -7.430354>, <5.420806, 3.328415, -7.430426>, <5.417154, 3.913294, -7.430426>, 
      <4.937596, 1.983872, -7.514659>, <4.937596, 2.568763, -7.514659>, <4.941247, 3.348630, -7.514659>, <4.937596, 3.933510, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.937596, 0.034234, -7.514659>, <4.937596, -0.573153, -7.514659>, <4.937596, -1.383003, -7.514659>, <4.937596, -1.990390, -7.514659>, 
      <4.823668, 0.030350, -7.534670>, <4.823668, -0.577037, -7.534670>, <4.825385, -1.382550, -7.534369>, <4.825385, -1.989938, -7.534369>, 
      <4.671818, -0.030135, -7.534670>, <4.671818, -0.615027, -7.534670>, <4.670101, -1.399218, -7.534369>, <4.670101, -1.984110, -7.534369>, 
      <4.557890, -0.034019, -7.514659>, <4.557890, -0.618911, -7.514659>, <4.557890, -1.398766, -7.514659>, <4.557890, -1.983657, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.524828, 0.033039, -7.169174>, <6.524828, 0.617931, -7.169174>, <6.524828, 1.397786, -7.169174>, <6.524828, 1.982677, -7.169174>, 
      <6.117054, 0.033207, -7.436009>, <6.117054, 0.618098, -7.436009>, <6.113884, 1.397950, -7.431100>, <6.113884, 1.982842, -7.431100>, 
      <5.417297, 0.050588, -7.430402>, <5.417297, 0.635480, -7.430402>, <5.417564, 1.397046, -7.430354>, <5.417564, 1.981937, -7.430354>, 
      <4.937596, 0.034234, -7.514659>, <4.937596, 0.619125, -7.514659>, <4.937596, 1.398980, -7.514659>, <4.937596, 1.983872, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.937596, -1.990390, -7.514659>, <4.937596, -2.597777, -7.514659>, <4.937596, -3.407626, -7.514659>, <4.937596, -4.015013, -7.514659>, 
      <4.825385, -1.989938, -7.534369>, <4.825385, -2.597325, -7.534369>, <4.822931, -3.402792, -7.534800>, <4.822931, -4.010180, -7.534800>, 
      <4.670101, -1.984110, -7.534369>, <4.670101, -2.569001, -7.534369>, <4.672554, -3.353237, -7.534800>, <4.672554, -3.938128, -7.534800>, 
      <4.557890, -1.983657, -7.514659>, <4.557890, -2.568548, -7.514659>, <4.557890, -3.348403, -7.514659>, <4.557890, -3.933295, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.524828, -1.991585, -7.169174>, <6.524828, -1.384198, -7.169174>, <6.524828, -0.574348, -7.169174>, <6.524828, 0.033039, -7.169174>, 
      <6.113884, -1.991420, -7.431100>, <6.113884, -1.384033, -7.431100>, <6.117054, -0.574180, -7.436009>, <6.117054, 0.033207, -7.436009>, 
      <5.417564, -1.992324, -7.430354>, <5.417564, -1.384937, -7.430354>, <5.417297, -0.556799, -7.430402>, <5.417297, 0.050588, -7.430402>, 
      <4.937596, -1.990390, -7.514659>, <4.937596, -1.383003, -7.514659>, <4.937596, -0.573153, -7.514659>, <4.937596, 0.034234, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.937596, -4.015013, -7.514659>, <4.937596, -4.622400, -7.514659>, <4.945160, -5.432297, -7.514659>, <4.937596, -6.039638, -7.514659>, 
      <4.822931, -4.010180, -7.534800>, <4.822931, -4.617566, -7.534800>, <4.832965, -5.432297, -7.534366>, <4.825401, -6.039638, -7.534366>, 
      <4.672554, -3.938128, -7.534800>, <4.672554, -4.570390, -7.534800>, <4.465930, -5.530706, -7.514659>, <4.578098, -6.152938, -7.514659>, 
      <4.557890, -3.933295, -7.514659>, <4.557890, -4.565556, -7.514659>, <4.445721, -5.418600, -7.514659>, <4.557890, -6.040832, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.524828, -4.016209, -7.169174>, <6.524828, -3.408822, -7.169174>, <6.524828, -2.598972, -7.169174>, <6.524828, -1.991585, -7.169174>, 
      <6.113884, -4.016045, -7.431100>, <6.113884, -3.408657, -7.431100>, <6.113884, -2.598807, -7.431100>, <6.113884, -1.991420, -7.431100>, 
      <5.417154, -4.035229, -7.430426>, <5.417154, -3.427842, -7.430426>, <5.417564, -2.599711, -7.430354>, <5.417564, -1.992324, -7.430354>, 
      <4.937596, -4.015013, -7.514659>, <4.937596, -3.407626, -7.514659>, <4.937596, -2.597777, -7.514659>, <4.937596, -1.990390, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.030410, 6.773667, 0.395234>, <6.984446, 6.758914, -0.142668>, <6.932712, 6.744699, -0.860951>, <6.877195, 6.724493, -1.397774>, 
      <7.537359, 6.719432, 0.395234>, <7.491395, 6.704680, -0.142668>, <7.405634, 6.694105, -0.860951>, <7.350118, 6.673898, -1.397774>, 
      <8.215986, 6.619831, 0.395234>, <8.136373, 6.611313, -0.142668>, <8.074663, 6.578125, -0.862587>, <7.978798, 6.566494, -1.397774>, 
      <8.701437, 6.464025, 0.395234>, <8.621824, 6.455508, -0.142668>, <8.531927, 6.447265, -0.862587>, <8.436062, 6.435634, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.887003, 0.395234>, <4.747743, 6.869970, -0.142668>, <4.747743, 6.853591, -0.860109>, <4.747743, 6.830222, -1.397774>, 
      <5.433387, 6.887003, 0.395234>, <5.433387, 6.869970, -0.142668>, <5.387366, 6.853591, -0.860109>, <5.387366, 6.830222, -1.397774>, 
      <6.348657, 6.846603, 0.395234>, <6.302692, 6.831850, -0.142668>, <6.296718, 6.812740, -0.860951>, <6.241202, 6.792534, -1.397774>, 
      <7.030410, 6.773667, 0.395234>, <6.984446, 6.758914, -0.142668>, <6.932712, 6.744699, -0.860951>, <6.877195, 6.724493, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.465077, 6.773667, 0.395234>, <2.511041, 6.758914, -0.142668>, <2.562774, 6.744699, -0.860951>, <2.618291, 6.724493, -1.397774>, 
      <3.146830, 6.846603, 0.395234>, <3.192794, 6.831850, -0.142668>, <3.198767, 6.812740, -0.860951>, <3.254284, 6.792534, -1.397774>, 
      <4.062100, 6.887003, 0.395234>, <4.062100, 6.869970, -0.142668>, <4.108120, 6.853591, -0.860109>, <4.108120, 6.830222, -1.397774>, 
      <4.747743, 6.887003, 0.395234>, <4.747743, 6.869970, -0.142668>, <4.747743, 6.853591, -0.860109>, <4.747743, 6.830222, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.182411, 6.041047, 0.395234>, <0.274339, 6.038595, -0.142668>, <0.378307, 6.032874, -0.863378>, <0.488839, 6.032874, -1.397774>, 
      <0.236497, 6.257486, 0.395234>, <0.328426, 6.255034, -0.142668>, <0.434608, 6.234692, -0.863378>, <0.545139, 6.234692, -1.397774>, 
      <0.581627, 6.395849, 0.395234>, <0.661240, 6.387332, -0.142668>, <0.764282, 6.382542, -0.862587>, <0.860147, 6.370912, -1.397774>, 
      <0.794049, 6.464026, 0.395234>, <0.873662, 6.455508, -0.142668>, <0.963559, 6.447265, -0.862587>, <1.059424, 6.435635, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.182411, 4.016424, 0.395234>, <0.242367, 4.013971, -0.142668>, <0.284827, 4.008249, -0.865378>, <0.382265, 4.008249, -1.397774>, 
      <0.182411, 4.623811, 0.395234>, <0.242367, 4.621358, -0.142668>, <0.300830, 4.616267, -0.865378>, <0.398267, 4.616267, -1.397774>, 
      <0.035157, 5.451780, 0.395234>, <0.127085, 5.449328, -0.142668>, <0.214872, 5.447015, -0.863378>, <0.325404, 5.447015, -1.397774>, 
      <0.182411, 6.041047, 0.395234>, <0.274339, 6.038595, -0.142668>, <0.378307, 6.032874, -0.863378>, <0.488839, 6.032874, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.182411, 1.991800, 0.395234>, <0.242367, 1.989348, -0.142668>, <0.284827, 1.983626, -0.865378>, <0.382265, 1.983626, -1.397774>, 
      <0.182411, 2.599187, 0.395234>, <0.242367, 2.596735, -0.142668>, <0.268846, 2.590802, -0.865378>, <0.366284, 2.590802, -1.397774>, 
      <0.182411, 3.409037, 0.395234>, <0.242367, 3.406584, -0.142668>, <0.268846, 3.401072, -0.865378>, <0.366284, 3.401072, -1.397774>, 
      <0.182411, 4.016424, 0.395234>, <0.242367, 4.013971, -0.142668>, <0.284827, 4.008249, -0.865378>, <0.382265, 4.008249, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.182411, -0.032824, 0.395234>, <0.274339, -0.035276, -0.142668>, <0.378307, -0.040998, -0.863378>, <0.488839, -0.040998, -1.397774>, 
      <0.182411, 0.574563, 0.395234>, <0.274339, 0.572111, -0.142668>, <0.378307, 0.567230, -0.863378>, <0.488839, 0.567230, -1.397774>, 
      <0.182411, 1.384413, 0.395234>, <0.242367, 1.381960, -0.142668>, <0.300830, 1.375608, -0.865378>, <0.398267, 1.375608, -1.397774>, 
      <0.182411, 1.991800, 0.395234>, <0.242367, 1.989348, -0.142668>, <0.284827, 1.983626, -0.865378>, <0.382265, 1.983626, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.182411, -1.982462, 0.395234>, <0.242367, -1.984914, -0.142668>, <0.284827, -1.990636, -0.865378>, <0.382265, -1.990636, -1.397774>, 
      <0.182411, -1.397571, 0.395234>, <0.242367, -1.400023, -0.142668>, <0.300831, -1.405090, -0.865378>, <0.398269, -1.405090, -1.397774>, 
      <0.182411, -0.617716, 0.395234>, <0.274339, -0.620168, -0.142668>, <0.378307, -0.626763, -0.863378>, <0.488839, -0.626763, -1.397774>, 
      <0.182411, -0.032824, 0.395234>, <0.274339, -0.035276, -0.142668>, <0.378307, -0.040998, -0.863378>, <0.488839, -0.040998, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.182411, -3.932100, 0.395234>, <0.242367, -3.934552, -0.142668>, <0.284827, -3.940274, -0.865378>, <0.382265, -3.940274, -1.397774>, 
      <0.182411, -3.347208, 0.395234>, <0.242367, -3.349660, -0.142668>, <0.269442, -3.355585, -0.865378>, <0.366880, -3.355585, -1.397774>, 
      <0.182411, -2.567353, 0.395234>, <0.242367, -2.569806, -0.142668>, <0.268847, -2.575309, -0.865378>, <0.366284, -2.575309, -1.397774>, 
      <0.182411, -1.982462, 0.395234>, <0.242367, -1.984914, -0.142668>, <0.284827, -1.990636, -0.865378>, <0.382265, -1.990636, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.182411, -6.040832, 0.395234>, <0.093218, -5.917223, -0.128746>, <0.378323, -6.031900, -0.863455>, <0.488839, -6.040832, -1.397774>, 
      <0.182411, -5.408212, 0.395234>, <0.093218, -5.284603, -0.128746>, <0.213060, -5.422949, -0.863455>, <0.323575, -5.431881, -1.397774>, 
      <0.182411, -4.564719, 0.395234>, <0.242367, -4.567171, -0.142668>, <0.301424, -4.571034, -0.865378>, <0.398862, -4.571034, -1.397774>, 
      <0.182411, -3.932100, 0.395234>, <0.242367, -3.934552, -0.142668>, <0.284827, -3.940274, -0.865378>, <0.382265, -3.940274, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.859200, 6.326224, -7.169174>, <3.661867, 6.305113, -7.169174>, <3.397707, 6.266343, -7.169174>, <3.208742, 6.205694, -7.169174>, 
      <4.020893, 6.277844, -7.380787>, <3.823560, 6.256733, -7.380787>, <3.737719, 6.232270, -7.426087>, <3.548754, 6.171621, -7.426087>, 
      <4.414731, 6.147926, -7.411014>, <4.393884, 6.143705, -7.411014>, <4.191797, 6.106139, -7.411014>, <4.170950, 6.101918, -7.411014>, 
      <4.652816, 6.071513, -7.514659>, <4.631968, 6.067292, -7.514659>, <4.604172, 6.061664, -7.514659>, <4.583325, 6.057442, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.970658, -6.106696, -7.169174>, <3.378766, -6.106696, -7.436227>, <4.081195, -6.055101, -7.412536>, <4.557890, -6.040832, -7.514659>, 
      <2.902708, -5.457866, -7.169174>, <3.310816, -5.457866, -7.436227>, <3.969027, -5.432870, -7.412536>, <4.445721, -5.418600, -7.514659>, 
      <2.970658, -4.584479, -7.169174>, <3.381601, -4.584643, -7.431100>, <4.078331, -4.545341, -7.430426>, <4.557890, -4.565556, -7.514659>, 
      <2.970658, -3.932100, -7.169174>, <3.381601, -3.932264, -7.431100>, <4.078331, -3.913080, -7.430426>, <4.557890, -3.933295, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.208742, -6.205480, -7.169174>, <3.548734, -6.171571, -7.426073>, <4.170950, -6.102540, -7.411014>, <4.583325, -6.058423, -7.514659>, 
      <3.133666, -6.186950, -7.169174>, <3.473658, -6.153040, -7.426073>, <4.163319, -6.097263, -7.411014>, <4.575694, -6.053146, -7.514659>, 
      <2.978712, -6.183605, -7.169174>, <3.386820, -6.183605, -7.436227>, <4.090263, -6.054830, -7.414478>, <4.566958, -6.040561, -7.516602>, 
      <2.970658, -6.106696, -7.169174>, <3.378766, -6.106696, -7.436227>, <4.081195, -6.055101, -7.412536>, <4.557890, -6.040832, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.524828, -4.016209, -7.169174>, <7.053619, -4.016421, -6.832133>, <7.609986, -4.016209, -6.158008>, <7.920667, -4.016209, -5.613312>, 
      <6.524828, -4.623596, -7.169174>, <7.053619, -4.623808, -6.832133>, <7.598361, -4.623929, -6.158008>, <7.909042, -4.623929, -5.613312>, 
      <6.590495, -5.437006, -7.169174>, <7.102426, -5.437216, -6.834180>, <7.678202, -5.446535, -6.150625>, <7.970758, -5.446535, -5.613312>, 
      <6.524828, -6.040832, -7.169174>, <7.036759, -6.041042, -6.834180>, <7.550650, -6.040832, -6.150625>, <7.843207, -6.040832, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.524828, -1.991585, -7.169174>, <7.053619, -1.991796, -6.832133>, <7.609986, -1.991585, -6.158008>, <7.920667, -1.991585, -5.613312>, 
      <6.524828, -2.598972, -7.169174>, <7.053619, -2.599184, -6.832133>, <7.621602, -2.598861, -6.158008>, <7.932284, -2.598861, -5.613312>, 
      <6.524828, -3.408822, -7.169174>, <7.053619, -3.409034, -6.832133>, <7.621602, -3.408933, -6.158008>, <7.932284, -3.408933, -5.613312>, 
      <6.524828, -4.016209, -7.169174>, <7.053619, -4.016421, -6.832133>, <7.609986, -4.016209, -6.158008>, <7.920667, -4.016209, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.524828, 0.033039, -7.169174>, <7.036759, 0.032829, -6.834180>, <7.550650, 0.033039, -6.150625>, <7.843207, 0.033039, -5.613312>, 
      <6.524828, -0.574348, -7.169174>, <7.036759, -0.574559, -6.834180>, <7.550650, -0.574792, -6.150625>, <7.843207, -0.574792, -5.613312>, 
      <6.524828, -1.384198, -7.169174>, <7.053619, -1.384409, -6.832133>, <7.598361, -1.383864, -6.158008>, <7.909042, -1.383864, -5.613312>, 
      <6.524828, -1.991585, -7.169174>, <7.053619, -1.991796, -6.832133>, <7.609986, -1.991585, -6.158008>, <7.920667, -1.991585, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.524828, 1.982677, -7.169174>, <7.053619, 1.982465, -6.832133>, <7.609986, 1.982677, -6.158008>, <7.920667, 1.982677, -5.613312>, 
      <6.524828, 1.397786, -7.169174>, <7.053619, 1.397574, -6.832133>, <7.598360, 1.397440, -6.158008>, <7.909042, 1.397440, -5.613312>, 
      <6.524828, 0.617931, -7.169174>, <7.036759, 0.617720, -6.834180>, <7.550650, 0.618392, -6.150625>, <7.843207, 0.618392, -5.613312>, 
      <6.524828, 0.033039, -7.169174>, <7.036759, 0.032829, -6.834180>, <7.550650, 0.033039, -6.150625>, <7.843207, 0.033039, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.524828, 3.932315, -7.169174>, <7.053619, 3.932103, -6.832133>, <7.609986, 3.932315, -6.158008>, <7.920667, 3.932315, -5.613312>, 
      <6.524828, 3.347423, -7.169174>, <7.053619, 3.347212, -6.832133>, <7.621147, 3.347530, -6.158008>, <7.931829, 3.347530, -5.613312>, 
      <6.524828, 2.567568, -7.169174>, <7.053619, 2.567357, -6.832133>, <7.621602, 2.567453, -6.158008>, <7.932284, 2.567453, -5.613312>, 
      <6.524828, 1.982677, -7.169174>, <7.053619, 1.982465, -6.832133>, <7.609986, 1.982677, -6.158008>, <7.920667, 1.982677, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.524828, 6.106911, -7.169174>, <7.038352, 6.103829, -6.836054>, <7.550498, 6.041047, -6.150905>, <7.843207, 6.041047, -5.613312>, 
      <6.592778, 5.458081, -7.169174>, <7.106302, 5.454999, -6.836054>, <7.678837, 5.421146, -6.150905>, <7.971546, 5.421146, -5.613312>, 
      <6.524828, 4.584694, -7.169174>, <7.053619, 4.584482, -6.832133>, <7.597905, 4.565246, -6.158008>, <7.908586, 4.565246, -5.613312>, 
      <6.524828, 3.932315, -7.169174>, <7.053619, 3.932103, -6.832133>, <7.609986, 3.932315, -6.158008>, <7.920667, 3.932315, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.286744, 6.205694, -7.169174>, <6.747872, 6.251685, -6.820743>, <7.181443, 6.284639, -6.137240>, <7.428494, 6.309606, -5.613312>, 
      <6.361820, 6.187164, -7.169174>, <6.822949, 6.233155, -6.820743>, <7.323394, 6.241977, -6.137240>, <7.570444, 6.266944, -5.613312>, 
      <6.516774, 6.183820, -7.169174>, <7.030298, 6.180738, -6.836054>, <7.520449, 6.186192, -6.150905>, <7.813158, 6.186192, -5.613312>, 
      <6.524828, 6.106911, -7.169174>, <7.038352, 6.103829, -6.836054>, <7.550498, 6.041047, -6.150905>, <7.843207, 6.041047, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.636285, 6.326224, -7.169174>, <5.474592, 6.277844, -7.380787>, <5.080754, 6.147926, -7.411014>, <4.842670, 6.071513, -7.514659>, 
      <5.833619, 6.305113, -7.169174>, <5.671926, 6.256733, -7.380787>, <5.101602, 6.144064, -7.411014>, <4.863517, 6.067650, -7.514659>, 
      <6.094067, 6.253252, -7.169174>, <5.754074, 6.219342, -7.426073>, <5.303688, 6.106617, -7.411014>, <4.891313, 6.062500, -7.514659>, 
      <6.286744, 6.205694, -7.169174>, <5.946751, 6.171785, -7.426073>, <5.324535, 6.102754, -7.411014>, <4.912160, 6.058637, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.370341, -7.169174>, <4.747743, 6.335598, -7.300782>, <4.747743, 6.164462, -7.411014>, <4.747743, 6.076228, -7.514659>, 
      <5.014634, 6.370341, -7.169174>, <5.014634, 6.335598, -7.300782>, <4.776221, 6.163047, -7.411014>, <4.776221, 6.074813, -7.514659>, 
      <5.370908, 6.354615, -7.169174>, <5.209215, 6.306235, -7.380787>, <5.052276, 6.149341, -7.411014>, <4.814191, 6.072928, -7.514659>, 
      <5.636285, 6.326224, -7.169174>, <5.474592, 6.277844, -7.380787>, <5.080754, 6.147926, -7.411014>, <4.842670, 6.071513, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.859200, 6.326224, -7.169174>, <4.020893, 6.277844, -7.380787>, <4.414731, 6.147926, -7.411014>, <4.652816, 6.071513, -7.514659>, 
      <4.124577, 6.354615, -7.169174>, <4.286270, 6.306235, -7.380787>, <4.443209, 6.149341, -7.411014>, <4.681294, 6.072928, -7.514659>, 
      <4.480852, 6.370341, -7.169174>, <4.480852, 6.335598, -7.300782>, <4.719264, 6.163047, -7.411014>, <4.719264, 6.074813, -7.514659>, 
      <4.747743, 6.370341, -7.169174>, <4.747743, 6.335598, -7.300782>, <4.747743, 6.164462, -7.411014>, <4.747743, 6.076228, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.208742, 6.205694, -7.169174>, <2.747627, 6.251903, -6.820754>, <2.314043, 6.284639, -6.137240>, <2.066992, 6.309606, -5.613312>, 
      <3.397707, 6.266343, -7.169174>, <2.936592, 6.312552, -6.820754>, <2.644429, 6.383934, -6.137240>, <2.397378, 6.408901, -5.613312>, 
      <3.661867, 6.305113, -7.169174>, <3.357336, 6.396231, -6.770620>, <2.990234, 6.431344, -6.103648>, <2.856745, 6.471816, -5.613312>, 
      <3.859200, 6.326224, -7.169174>, <3.554669, 6.417343, -6.770620>, <3.333500, 6.465733, -6.103648>, <3.200011, 6.506205, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.970658, 6.041047, -7.169174>, <3.378431, 6.040879, -7.436009>, <4.078126, 6.035505, -7.429286>, <4.557890, 6.039852, -7.514659>, 
      <2.980046, 6.127378, -7.169174>, <3.387820, 6.127211, -7.436009>, <4.078242, 6.044782, -7.429286>, <4.558005, 6.049129, -7.514659>, 
      <3.126055, 6.179156, -7.169174>, <3.466067, 6.145083, -7.426087>, <4.163319, 6.096640, -7.411014>, <4.575694, 6.052165, -7.514659>, 
      <3.208742, 6.205694, -7.169174>, <3.548754, 6.171621, -7.426087>, <4.170950, 6.101918, -7.411014>, <4.583325, 6.057442, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.970658, 4.016423, -7.169174>, <3.381601, 4.016259, -7.431100>, <4.078331, 4.035443, -7.430426>, <4.557890, 4.015228, -7.514659>, 
      <2.970658, 4.623810, -7.169174>, <3.381601, 4.623646, -7.431100>, <4.078331, 4.642830, -7.430426>, <4.557890, 4.622615, -7.514659>, 
      <2.904991, 5.437220, -7.169174>, <3.312764, 5.437052, -7.436009>, <4.070562, 5.428165, -7.429286>, <4.550325, 5.432512, -7.514659>, 
      <2.970658, 6.041047, -7.169174>, <3.378431, 6.040879, -7.436009>, <4.078126, 6.035505, -7.429286>, <4.557890, 6.039852, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.970658, 1.991799, -7.169174>, <3.381601, 1.991635, -7.431100>, <4.077922, 1.992539, -7.430354>, <4.557890, 1.990605, -7.514659>, 
      <2.970658, 2.599186, -7.169174>, <3.381601, 2.599022, -7.431100>, <4.077922, 2.599926, -7.430354>, <4.557890, 2.597992, -7.514659>, 
      <2.970658, 3.409036, -7.169174>, <3.381601, 3.408872, -7.431100>, <4.078331, 3.428056, -7.430426>, <4.557890, 3.407841, -7.514659>, 
      <2.970658, 4.016423, -7.169174>, <3.381601, 4.016259, -7.431100>, <4.078331, 4.035443, -7.430426>, <4.557890, 4.015228, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.970658, -0.032825, -7.169174>, <3.378431, -0.032992, -7.436009>, <4.078188, -0.050374, -7.430402>, <4.557890, -0.034019, -7.514659>, 
      <2.970658, 0.574563, -7.169174>, <3.378431, 0.574395, -7.436009>, <4.078188, 0.557014, -7.430402>, <4.557890, 0.573368, -7.514659>, 
      <2.970658, 1.384412, -7.169174>, <3.381601, 1.384247, -7.431100>, <4.077922, 1.385152, -7.430354>, <4.557890, 1.383217, -7.514659>, 
      <2.970658, 1.991799, -7.169174>, <3.381601, 1.991635, -7.431100>, <4.077922, 1.992539, -7.430354>, <4.557890, 1.990605, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.970658, -1.982463, -7.169174>, <3.381601, -1.982627, -7.431100>, <4.077922, -1.981723, -7.430354>, <4.557890, -1.983657, -7.514659>, 
      <2.970658, -1.397571, -7.169174>, <3.381601, -1.397736, -7.431100>, <4.077922, -1.396831, -7.430354>, <4.557890, -1.398766, -7.514659>, 
      <2.970658, -0.617716, -7.169174>, <3.378431, -0.617884, -7.436009>, <4.078188, -0.635265, -7.430402>, <4.557890, -0.618911, -7.514659>, 
      <2.970658, -0.032825, -7.169174>, <3.378431, -0.032992, -7.436009>, <4.078188, -0.050374, -7.430402>, <4.557890, -0.034019, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.970658, -3.932100, -7.169174>, <3.381601, -3.932264, -7.431100>, <4.078331, -3.913080, -7.430426>, <4.557890, -3.933295, -7.514659>, 
      <2.970658, -3.347209, -7.169174>, <3.381601, -3.347373, -7.431100>, <4.078331, -3.328188, -7.430426>, <4.557890, -3.348403, -7.514659>, 
      <2.970658, -2.567354, -7.169174>, <3.381601, -2.567518, -7.431100>, <4.077922, -2.566614, -7.430354>, <4.557890, -2.568548, -7.514659>, 
      <2.970658, -1.982463, -7.169174>, <3.381601, -1.982627, -7.431100>, <4.077922, -1.981723, -7.430354>, <4.557890, -1.983657, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.997402, -6.106696, -3.545067>, <1.170631, -6.106696, -4.172735>, <1.340911, -6.040832, -5.041450>, <1.652278, -6.040832, -5.613312>, 
      <0.842749, -5.472289, -3.545067>, <1.015978, -5.472289, -4.172735>, <1.212572, -5.420931, -5.041450>, <1.523940, -5.420931, -5.613312>, 
      <0.918409, -4.584917, -3.545067>, <1.095982, -4.583700, -4.172767>, <1.263699, -4.565031, -5.046670>, <1.586899, -4.565031, -5.613312>, 
      <0.903554, -3.932100, -3.545067>, <1.081127, -3.930883, -4.172767>, <1.251619, -3.932100, -5.046670>, <1.574818, -3.932100, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.499852, -6.378181, -3.545067>, <1.649429, -6.359472, -4.170877>, <1.792706, -6.337111, -5.031624>, <2.066992, -6.309392, -5.613312>, 
      <1.334716, -6.332525, -3.545067>, <1.484293, -6.313816, -4.170877>, <1.650755, -6.294449, -5.031624>, <1.925041, -6.266729, -5.613312>, 
      <1.037981, -6.273152, -3.545067>, <1.211210, -6.273152, -4.172735>, <1.370961, -6.185977, -5.041450>, <1.682328, -6.185977, -5.613312>, 
      <0.997402, -6.106696, -3.545067>, <1.170631, -6.106696, -4.172735>, <1.340911, -6.040832, -5.041450>, <1.652278, -6.040832, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.591931, -4.016209, -3.545067>, <8.772381, -4.014972, -2.907197>, <8.993879, -4.008035, -2.049846>, <9.113220, -4.008035, -1.397774>, 
      <8.577842, -4.624085, -3.545067>, <8.758292, -4.622848, -2.907197>, <8.977877, -4.616053, -2.049846>, <9.097218, -4.616053, -1.397774>, 
      <8.646918, -5.451290, -3.545067>, <8.823041, -5.450053, -2.906913>, <9.035993, -5.446801, -2.046065>, <9.170082, -5.446801, -1.397774>, 
      <8.498083, -6.040832, -3.545067>, <8.674206, -6.039595, -2.906913>, <8.872558, -6.032660, -2.046065>, <9.006647, -6.032660, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.591931, -1.991585, -3.545067>, <8.772381, -1.990348, -2.907197>, <8.993879, -1.983411, -2.049846>, <9.113220, -1.983411, -1.397774>, 
      <8.606005, -2.598809, -3.545067>, <8.786454, -2.597572, -2.907197>, <9.009860, -2.590588, -2.049846>, <9.129201, -2.590588, -1.397774>, 
      <8.606005, -3.408985, -3.545067>, <8.786454, -3.407748, -2.907197>, <9.009860, -3.400858, -2.049846>, <9.129201, -3.400858, -1.397774>, 
      <8.591931, -4.016209, -3.545067>, <8.772381, -4.014972, -2.907197>, <8.993879, -4.008035, -2.049846>, <9.113220, -4.008035, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.498083, 0.033039, -3.545067>, <8.674206, 0.034277, -2.906913>, <8.872558, 0.041213, -2.046065>, <9.006647, 0.041213, -1.397774>, 
      <8.498083, -0.575000, -3.545067>, <8.674206, -0.573763, -2.906913>, <8.872558, -0.567016, -2.046065>, <9.006647, -0.567016, -1.397774>, 
      <8.577842, -1.383709, -3.545067>, <8.758292, -1.382472, -2.907197>, <8.977877, -1.375394, -2.049846>, <9.097218, -1.375394, -1.397774>, 
      <8.591931, -1.991585, -3.545067>, <8.772381, -1.990348, -2.907197>, <8.993879, -1.983411, -2.049846>, <9.113220, -1.983411, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.591931, 1.982677, -3.545067>, <8.772381, 1.983914, -2.907197>, <8.993879, 1.990851, -2.049846>, <9.113220, 1.990850, -1.397774>, 
      <8.577842, 1.397278, -3.545067>, <8.758291, 1.398515, -2.907197>, <8.977876, 1.405305, -2.049846>, <9.097217, 1.405305, -1.397774>, 
      <8.498083, 0.618608, -3.545067>, <8.674206, 0.619845, -2.906913>, <8.872558, 0.626977, -2.046065>, <9.006647, 0.626977, -1.397774>, 
      <8.498083, 0.033039, -3.545067>, <8.674206, 0.034277, -2.906913>, <8.872558, 0.041213, -2.046065>, <9.006647, 0.041213, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.591931, 3.932315, -3.545067>, <8.772381, 3.933551, -2.907197>, <8.993879, 3.940488, -2.049846>, <9.113220, 3.940488, -1.397774>, 
      <8.605237, 3.347575, -3.545067>, <8.785686, 3.348811, -2.907197>, <9.008988, 3.355792, -2.049846>, <9.128330, 3.355792, -1.397774>, 
      <8.606005, 2.567399, -3.545067>, <8.786454, 2.568636, -2.907197>, <9.009859, 2.575523, -2.049846>, <9.129200, 2.575523, -1.397774>, 
      <8.591931, 1.982677, -3.545067>, <8.772381, 1.983914, -2.907197>, <8.993879, 1.990851, -2.049846>, <9.113220, 1.990850, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.498083, 6.106911, -3.545067>, <8.674181, 6.118117, -2.907003>, <8.872576, 6.125919, -2.045978>, <9.006647, 6.115084, -1.397774>, 
      <8.652737, 5.472503, -3.545067>, <8.828834, 5.483709, -2.907003>, <9.043650, 5.495559, -2.045978>, <9.177721, 5.484724, -1.397774>, 
      <8.577076, 4.585132, -3.545067>, <8.757526, 4.586368, -2.907197>, <8.977007, 4.593432, -2.049846>, <9.096348, 4.593432, -1.397774>, 
      <8.591931, 3.932315, -3.545067>, <8.772381, 3.933551, -2.907197>, <8.993879, 3.940488, -2.049846>, <9.113220, 3.940488, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.995634, 6.378396, -3.545067>, <8.148490, 6.397515, -2.905535>, <8.320102, 6.421566, -2.045143>, <8.436062, 6.435634, -1.397774>, 
      <8.160770, 6.332739, -3.545067>, <8.313626, 6.351859, -2.905535>, <8.508863, 6.367546, -2.045143>, <8.624822, 6.381614, -1.397774>, 
      <8.457506, 6.273368, -3.545067>, <8.633603, 6.284574, -2.907003>, <8.821152, 6.315404, -2.045978>, <8.955223, 6.304569, -1.397774>, 
      <8.498083, 6.106911, -3.545067>, <8.674181, 6.118117, -2.907003>, <8.872576, 6.125919, -2.045978>, <9.006647, 6.115084, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.622913, 6.625352, -3.545067>, <6.537013, 6.593118, -4.167559>, <6.460236, 6.556157, -5.008107>, <6.295475, 6.506205, -5.613312>, 
      <7.039102, 6.582124, -3.545067>, <6.953202, 6.549890, -4.167559>, <6.803502, 6.521768, -5.008107>, <6.638742, 6.471816, -5.613312>, 
      <7.592337, 6.489898, -3.545067>, <7.442760, 6.471188, -4.170877>, <7.372393, 6.436620, -5.031624>, <7.098107, 6.408901, -5.613312>, 
      <7.995634, 6.378396, -3.545067>, <7.846057, 6.359686, -4.170877>, <7.702779, 6.337326, -5.031624>, <7.428494, 6.309606, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.715745, -3.545067>, <4.747743, 6.678629, -4.165803>, <4.747743, 6.637163, -4.994272>, <4.747743, 6.578164, -5.613312>, 
      <5.310948, 6.715745, -3.545067>, <5.310948, 6.678629, -4.165803>, <5.212564, 6.637163, -4.994272>, <5.212564, 6.578164, -5.613312>, 
      <6.062723, 6.683538, -3.545067>, <5.976822, 6.651304, -4.167559>, <5.997730, 6.602491, -5.008107>, <5.832969, 6.552538, -5.613312>, 
      <6.622913, 6.625352, -3.545067>, <6.537013, 6.593118, -4.167559>, <6.460236, 6.556157, -5.008107>, <6.295475, 6.506205, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.872573, 6.625352, -3.545067>, <2.958473, 6.593118, -4.167559>, <3.035250, 6.556157, -5.008107>, <3.200011, 6.506205, -5.613312>, 
      <3.432763, 6.683538, -3.545067>, <3.518664, 6.651304, -4.167559>, <3.497756, 6.602491, -5.008107>, <3.662517, 6.552538, -5.613312>, 
      <4.184539, 6.715745, -3.545067>, <4.184539, 6.678629, -4.165803>, <4.282922, 6.637163, -4.994272>, <4.282922, 6.578164, -5.613312>, 
      <4.747743, 6.715745, -3.545067>, <4.747743, 6.678629, -4.165803>, <4.747743, 6.637163, -4.994272>, <4.747743, 6.578164, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.499853, 6.378396, -3.545067>, <1.346996, 6.397515, -2.905535>, <1.175384, 6.421566, -2.045143>, <1.059424, 6.435635, -1.397774>, 
      <1.899335, 6.502875, -3.545067>, <1.746479, 6.521994, -2.905535>, <1.627744, 6.568487, -2.045143>, <1.511784, 6.582556, -1.397774>, 
      <2.456384, 6.582124, -3.545067>, <2.367733, 6.615390, -2.902637>, <2.212122, 6.649602, -2.043247>, <2.145369, 6.673898, -1.397774>, 
      <2.872573, 6.625352, -3.545067>, <2.783921, 6.658618, -2.902637>, <2.685044, 6.700197, -2.043247>, <2.618291, 6.724493, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.997402, 6.041047, -3.545067>, <1.170551, 6.042263, -4.172445>, <1.341054, 6.041047, -5.041714>, <1.652278, 6.041047, -5.613312>, 
      <1.041844, 6.217082, -3.545067>, <1.214993, 6.218298, -4.172445>, <1.372158, 6.185969, -5.041714>, <1.683383, 6.185969, -5.613312>, 
      <1.326515, 6.324383, -3.545067>, <1.476091, 6.305674, -4.170877>, <1.650756, 6.294664, -5.031624>, <1.925042, 6.266944, -5.613312>, 
      <1.499853, 6.378396, -3.545067>, <1.649429, 6.359686, -4.170877>, <1.792707, 6.337326, -5.031624>, <2.066992, 6.309606, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.903554, 4.016423, -3.545067>, <1.081127, 4.017640, -4.172767>, <1.251619, 4.016423, -5.046670>, <1.574818, 4.016423, -5.613312>, 
      <0.917643, 4.624299, -3.545067>, <1.095216, 4.625516, -4.172767>, <1.263244, 4.624144, -5.046670>, <1.586443, 4.624144, -5.613312>, 
      <0.848568, 5.451505, -3.545067>, <1.021717, 5.452721, -4.172445>, <1.213503, 5.446749, -5.041714>, <1.524727, 5.446749, -5.613312>, 
      <0.997402, 6.041047, -3.545067>, <1.170551, 6.042263, -4.172445>, <1.341054, 6.041047, -5.041714>, <1.652278, 6.041047, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.903554, 1.991799, -3.545067>, <1.081127, 1.993016, -4.172767>, <1.251619, 1.991799, -5.046670>, <1.574818, 1.991799, -5.613312>, 
      <0.889480, 2.599024, -3.545067>, <1.067053, 2.600241, -4.172767>, <1.240002, 2.599076, -5.046670>, <1.563201, 2.599076, -5.613312>, 
      <0.889480, 3.409199, -3.545067>, <1.067053, 3.410416, -4.172767>, <1.240002, 3.409147, -5.046670>, <1.563201, 3.409147, -5.613312>, 
      <0.903554, 4.016423, -3.545067>, <1.081127, 4.017640, -4.172767>, <1.251619, 4.016423, -5.046670>, <1.574818, 4.016423, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.997402, -0.032825, -3.545067>, <1.170551, -0.031608, -4.172445>, <1.341054, -0.032825, -5.041714>, <1.652278, -0.032825, -5.613312>, 
      <0.997402, 0.575215, -3.545067>, <1.170551, 0.576431, -4.172445>, <1.341054, 0.575007, -5.041714>, <1.652278, 0.575007, -5.613312>, 
      <0.917643, 1.383923, -3.545067>, <1.095216, 1.385140, -4.172767>, <1.263244, 1.384079, -5.046670>, <1.586443, 1.384079, -5.613312>, 
      <0.903554, 1.991799, -3.545067>, <1.081127, 1.993016, -4.172767>, <1.251619, 1.991799, -5.046670>, <1.574818, 1.991799, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.903554, -1.982463, -3.545067>, <1.081127, -1.981246, -4.172767>, <1.251619, -1.982463, -5.046670>, <1.574818, -1.982463, -5.613312>, 
      <0.917643, -1.397064, -3.545067>, <1.095216, -1.395847, -4.172767>, <1.263245, -1.397225, -5.046670>, <1.586444, -1.397225, -5.613312>, 
      <0.997402, -0.618393, -3.545067>, <1.170551, -0.617177, -4.172445>, <1.341054, -0.618178, -5.041714>, <1.652278, -0.618178, -5.613312>, 
      <0.997402, -0.032825, -3.545067>, <1.170551, -0.031608, -4.172445>, <1.341054, -0.032825, -5.041714>, <1.652278, -0.032825, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.903554, -3.932100, -3.545067>, <1.081127, -3.930883, -4.172767>, <1.251619, -3.932100, -5.046670>, <1.574818, -3.932100, -5.613312>, 
      <0.890248, -3.347360, -3.545067>, <1.067821, -3.346143, -4.172767>, <1.240457, -3.347315, -5.046670>, <1.563657, -3.347315, -5.613312>, 
      <0.889481, -2.567184, -3.545067>, <1.067054, -2.565968, -4.172767>, <1.240002, -2.567238, -5.046670>, <1.563201, -2.567238, -5.613312>, 
      <0.903554, -1.982463, -3.545067>, <1.081127, -1.981246, -4.172767>, <1.251619, -1.982463, -5.046670>, <1.574818, -1.982463, -5.613312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.059423, -6.435420, -1.397774>, <1.175383, -6.421352, -2.045143>, <1.346995, -6.397301, -2.905535>, <1.499852, -6.378181, -3.545067>, 
      <0.861259, -6.371820, -1.397774>, <0.977219, -6.357751, -2.045143>, <1.181860, -6.351644, -2.905535>, <1.334716, -6.332525, -3.545067>, 
      <0.543349, -6.241687, -1.397774>, <0.677479, -6.252527, -2.046262>, <0.861780, -6.273152, -2.906632>, <1.037981, -6.273152, -3.545067>, 
      <0.488839, -6.040832, -1.397774>, <0.622969, -6.051672, -2.046262>, <0.821202, -6.106696, -2.906632>, <0.997402, -6.106696, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.113220, -4.008035, -1.397774>, <9.210658, -4.008035, -0.865378>, <9.253118, -4.013757, -0.142668>, <9.313074, -4.016210, 0.395234>, 
      <9.097218, -4.616053, -1.397774>, <9.194655, -4.616053, -0.865378>, <9.253118, -4.621144, -0.142668>, <9.313074, -4.623597, 0.395234>, 
      <9.170082, -5.446801, -1.397774>, <9.280614, -5.446801, -0.863378>, <9.368398, -5.449114, -0.142668>, <9.460327, -5.451566, 0.395234>, 
      <9.006647, -6.032660, -1.397774>, <9.117179, -6.032660, -0.863378>, <9.221146, -6.038381, -0.142668>, <9.313074, -6.040832, 0.395234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.113220, -1.983411, -1.397774>, <9.210658, -1.983412, -0.865378>, <9.253118, -1.989133, -0.142668>, <9.313074, -1.991585, 0.395234>, 
      <9.129201, -2.590588, -1.397774>, <9.226638, -2.590589, -0.865378>, <9.253118, -2.596521, -0.142668>, <9.313074, -2.598973, 0.395234>, 
      <9.129201, -3.400858, -1.397774>, <9.226638, -3.400858, -0.865378>, <9.253118, -3.406370, -0.142668>, <9.313074, -3.408822, 0.395234>, 
      <9.113220, -4.008035, -1.397774>, <9.210658, -4.008035, -0.865378>, <9.253118, -4.013757, -0.142668>, <9.313074, -4.016210, 0.395234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.006647, 0.041213, -1.397774>, <9.117179, 0.041212, -0.863378>, <9.221146, 0.035491, -0.142668>, <9.313074, 0.033039, 0.395234>, 
      <9.006647, -0.567016, -1.397774>, <9.117179, -0.567016, -0.863378>, <9.221146, -0.571897, -0.142668>, <9.313074, -0.574349, 0.395234>, 
      <9.097218, -1.375394, -1.397774>, <9.194655, -1.375394, -0.865378>, <9.253118, -1.381746, -0.142668>, <9.313074, -1.384198, 0.395234>, 
      <9.113220, -1.983411, -1.397774>, <9.210658, -1.983412, -0.865378>, <9.253118, -1.989133, -0.142668>, <9.313074, -1.991585, 0.395234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.113220, 1.990850, -1.397774>, <9.210658, 1.990850, -0.865378>, <9.253118, 1.985129, -0.142668>, <9.313074, 1.982677, 0.395234>, 
      <9.097217, 1.405305, -1.397774>, <9.194654, 1.405304, -0.865378>, <9.253118, 1.400237, -0.142668>, <9.313074, 1.397785, 0.395234>, 
      <9.006647, 0.626977, -1.397774>, <9.117179, 0.626977, -0.863378>, <9.221146, 0.620382, -0.142668>, <9.313074, 0.617930, 0.395234>, 
      <9.006647, 0.041213, -1.397774>, <9.117179, 0.041212, -0.863378>, <9.221146, 0.035491, -0.142668>, <9.313074, 0.033039, 0.395234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.113220, 3.940488, -1.397774>, <9.210658, 3.940488, -0.865378>, <9.253118, 3.934766, -0.142668>, <9.313074, 3.932314, 0.395234>, 
      <9.128330, 3.355792, -1.397774>, <9.225767, 3.355792, -0.865378>, <9.253118, 3.349875, -0.142668>, <9.313074, 3.347423, 0.395234>, 
      <9.129200, 2.575523, -1.397774>, <9.226638, 2.575523, -0.865378>, <9.253118, 2.570020, -0.142668>, <9.313074, 2.567568, 0.395234>, 
      <9.113220, 1.990850, -1.397774>, <9.210658, 1.990850, -0.865378>, <9.253118, 1.985129, -0.142668>, <9.313074, 1.982677, 0.395234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.006647, 6.115084, -1.397774>, <9.117254, 6.106145, -0.863013>, <9.221146, 6.063258, -0.142668>, <9.313074, 6.041047, 0.395234>, 
      <9.177721, 5.484724, -1.397774>, <9.288328, 5.475785, -0.863013>, <9.221146, 5.430638, -0.142668>, <9.313074, 5.408427, 0.395234>, 
      <9.096348, 4.593432, -1.397774>, <9.193786, 4.593432, -0.865378>, <9.253118, 4.567386, -0.142668>, <9.313074, 4.564934, 0.395234>, 
      <9.113220, 3.940488, -1.397774>, <9.210658, 3.940488, -0.865378>, <9.253118, 3.934766, -0.142668>, <9.313074, 3.932314, 0.395234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.436062, 6.435634, -1.397774>, <8.531927, 6.447265, -0.862587>, <8.621824, 6.455508, -0.142668>, <8.701437, 6.464025, 0.395234>, 
      <8.624822, 6.381614, -1.397774>, <8.720688, 6.393245, -0.862587>, <8.834246, 6.387331, -0.142668>, <8.913858, 6.395848, 0.395234>, 
      <8.955223, 6.304569, -1.397774>, <9.065830, 6.295630, -0.863013>, <9.037655, 6.190151, -0.142668>, <9.129583, 6.167940, 0.395234>, 
      <9.006647, 6.115084, -1.397774>, <9.117254, 6.106145, -0.863013>, <9.221146, 6.063258, -0.142668>, <9.313074, 6.041047, 0.395234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.877195, 6.724493, -1.397774>, <6.810442, 6.700197, -2.043247>, <6.711565, 6.658618, -2.902637>, <6.622913, 6.625352, -3.545067>, 
      <7.350118, 6.673898, -1.397774>, <7.283364, 6.649602, -2.043247>, <7.127754, 6.615390, -2.902637>, <7.039102, 6.582124, -3.545067>, 
      <7.978798, 6.566494, -1.397774>, <7.862838, 6.552426, -2.045143>, <7.745193, 6.509017, -2.905535>, <7.592337, 6.489898, -3.545067>, 
      <8.436062, 6.435634, -1.397774>, <8.320102, 6.421566, -2.045143>, <8.148490, 6.397515, -2.905535>, <7.995634, 6.378396, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.830222, -1.397774>, <4.747743, 6.802211, -2.042268>, <4.747743, 6.754248, -2.901114>, <4.747743, 6.715745, -3.545067>, 
      <5.387366, 6.830222, -1.397774>, <5.387366, 6.802211, -2.042268>, <5.310948, 6.754248, -2.901114>, <5.310948, 6.715745, -3.545067>, 
      <6.241202, 6.792534, -1.397774>, <6.174448, 6.768238, -2.043247>, <6.151374, 6.716803, -2.902637>, <6.062723, 6.683538, -3.545067>, 
      <6.877195, 6.724493, -1.397774>, <6.810442, 6.700197, -2.043247>, <6.711565, 6.658618, -2.902637>, <6.622913, 6.625352, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.618291, 6.724493, -1.397774>, <2.685044, 6.700197, -2.043247>, <2.783921, 6.658618, -2.902637>, <2.872573, 6.625352, -3.545067>, 
      <3.254284, 6.792534, -1.397774>, <3.321038, 6.768238, -2.043247>, <3.344112, 6.716803, -2.902637>, <3.432763, 6.683538, -3.545067>, 
      <4.108120, 6.830222, -1.397774>, <4.108120, 6.802211, -2.042268>, <4.184539, 6.754248, -2.901114>, <4.184539, 6.715745, -3.545067>, 
      <4.747743, 6.830222, -1.397774>, <4.747743, 6.802211, -2.042268>, <4.747743, 6.754248, -2.901114>, <4.747743, 6.715745, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.059424, 6.435635, -1.397774>, <0.963559, 6.447265, -0.862587>, <0.873662, 6.455508, -0.142668>, <0.794049, 6.464026, 0.395234>, 
      <1.511784, 6.582556, -1.397774>, <1.415920, 6.594186, -0.862587>, <1.359114, 6.611314, -0.142668>, <1.279501, 6.619831, 0.395234>, 
      <2.145369, 6.673898, -1.397774>, <2.089852, 6.694105, -0.860951>, <2.004092, 6.704680, -0.142668>, <1.958127, 6.719432, 0.395234>, 
      <2.618291, 6.724493, -1.397774>, <2.562774, 6.744699, -0.860951>, <2.511041, 6.758914, -0.142668>, <2.465077, 6.773667, 0.395234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.488839, 6.032874, -1.397774>, <0.622928, 6.032874, -2.046065>, <0.821279, 6.039809, -2.906913>, <0.997402, 6.041047, -3.545067>, 
      <0.545139, 6.234692, -1.397774>, <0.679229, 6.234692, -2.046065>, <0.865721, 6.215845, -2.906913>, <1.041844, 6.217082, -3.545067>, 
      <0.860147, 6.370912, -1.397774>, <0.976106, 6.356843, -2.045143>, <1.173658, 6.343503, -2.905535>, <1.326515, 6.324383, -3.545067>, 
      <1.059424, 6.435635, -1.397774>, <1.175384, 6.421566, -2.045143>, <1.346996, 6.397515, -2.905535>, <1.499853, 6.378396, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.382265, 4.008249, -1.397774>, <0.501605, 4.008249, -2.049846>, <0.723104, 4.015186, -2.907197>, <0.903554, 4.016423, -3.545067>, 
      <0.398267, 4.616267, -1.397774>, <0.517608, 4.616267, -2.049846>, <0.737193, 4.623062, -2.907197>, <0.917643, 4.624299, -3.545067>, 
      <0.325404, 5.447015, -1.397774>, <0.459493, 5.447015, -2.046065>, <0.672445, 5.450267, -2.906913>, <0.848568, 5.451505, -3.545067>, 
      <0.488839, 6.032874, -1.397774>, <0.622928, 6.032874, -2.046065>, <0.821279, 6.039809, -2.906913>, <0.997402, 6.041047, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.382265, 1.983626, -1.397774>, <0.501605, 1.983626, -2.049846>, <0.723104, 1.990563, -2.907197>, <0.903554, 1.991799, -3.545067>, 
      <0.366284, 2.590802, -1.397774>, <0.485625, 2.590802, -2.049846>, <0.709031, 2.597787, -2.907197>, <0.889480, 2.599024, -3.545067>, 
      <0.366284, 3.401072, -1.397774>, <0.485625, 3.401072, -2.049846>, <0.709031, 3.407962, -2.907197>, <0.889480, 3.409199, -3.545067>, 
      <0.382265, 4.008249, -1.397774>, <0.501605, 4.008249, -2.049846>, <0.723104, 4.015186, -2.907197>, <0.903554, 4.016423, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.488839, -0.040998, -1.397774>, <0.622928, -0.040998, -2.046065>, <0.821279, -0.034062, -2.906913>, <0.997402, -0.032825, -3.545067>, 
      <0.488839, 0.567230, -1.397774>, <0.622928, 0.567230, -2.046065>, <0.821279, 0.573978, -2.906913>, <0.997402, 0.575215, -3.545067>, 
      <0.398267, 1.375608, -1.397774>, <0.517608, 1.375608, -2.049846>, <0.737193, 1.382686, -2.907197>, <0.917643, 1.383923, -3.545067>, 
      <0.382265, 1.983626, -1.397774>, <0.501605, 1.983626, -2.049846>, <0.723104, 1.990563, -2.907197>, <0.903554, 1.991799, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.382265, -1.990636, -1.397774>, <0.501605, -1.990636, -2.049846>, <0.723104, -1.983699, -2.907197>, <0.903554, -1.982463, -3.545067>, 
      <0.398269, -1.405090, -1.397774>, <0.517609, -1.405090, -2.049846>, <0.737193, -1.398300, -2.907197>, <0.917643, -1.397064, -3.545067>, 
      <0.488839, -0.626763, -1.397774>, <0.622928, -0.626763, -2.046065>, <0.821279, -0.619631, -2.906913>, <0.997402, -0.618393, -3.545067>, 
      <0.488839, -0.040998, -1.397774>, <0.622928, -0.040998, -2.046065>, <0.821279, -0.034062, -2.906913>, <0.997402, -0.032825, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.382265, -3.940274, -1.397774>, <0.501605, -3.940274, -2.049846>, <0.723104, -3.933337, -2.907197>, <0.903554, -3.932100, -3.545067>, 
      <0.366880, -3.355585, -1.397774>, <0.486220, -3.355585, -2.049846>, <0.709798, -3.348597, -2.907197>, <0.890248, -3.347360, -3.545067>, 
      <0.366284, -2.575309, -1.397774>, <0.485625, -2.575309, -2.049846>, <0.709031, -2.568421, -2.907197>, <0.889481, -2.567184, -3.545067>, 
      <0.382265, -1.990636, -1.397774>, <0.501605, -1.990636, -2.049846>, <0.723104, -1.983699, -2.907197>, <0.903554, -1.982463, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.488839, -6.040832, -1.397774>, <0.622969, -6.051672, -2.046262>, <0.821202, -6.106696, -2.906632>, <0.997402, -6.106696, -3.545067>, 
      <0.323575, -5.431881, -1.397774>, <0.457705, -5.442721, -2.046262>, <0.666548, -5.472289, -2.906632>, <0.842749, -5.472289, -3.545067>, 
      <0.398862, -4.571034, -1.397774>, <0.518203, -4.571034, -2.049846>, <0.737959, -4.586154, -2.907197>, <0.918409, -4.584917, -3.545067>, 
      <0.382265, -3.940274, -1.397774>, <0.501605, -3.940274, -2.049846>, <0.723104, -3.933337, -2.907197>, <0.903554, -3.932100, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.872572, -6.625137, -3.545067>, <3.432763, -6.683323, -3.545067>, <4.184538, -6.715530, -3.545067>, <4.747742, -6.715530, -3.545067>, 
      <2.783920, -6.658403, -2.902637>, <3.344111, -6.716589, -2.902637>, <4.184538, -6.754034, -2.901114>, <4.747742, -6.754034, -2.901114>, 
      <2.685043, -6.699983, -2.043247>, <3.321037, -6.768023, -2.043247>, <4.108120, -6.801996, -2.042268>, <4.747742, -6.801996, -2.042268>, 
      <2.618290, -6.724279, -1.397774>, <3.254283, -6.792319, -1.397774>, <4.108120, -6.830008, -1.397774>, <4.747742, -6.830008, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.200010, -6.505990, -5.613312>, <3.662516, -6.552324, -5.613312>, <4.282921, -6.577950, -5.613312>, <4.747742, -6.577950, -5.613312>, 
      <3.035249, -6.555942, -5.008107>, <3.497755, -6.602276, -5.008107>, <4.282921, -6.636949, -4.994272>, <4.747742, -6.636949, -4.994272>, 
      <2.958472, -6.592904, -4.167559>, <3.518663, -6.651089, -4.167559>, <4.184538, -6.678414, -4.165803>, <4.747742, -6.678414, -4.165803>, 
      <2.872572, -6.625137, -3.545067>, <3.432763, -6.683323, -3.545067>, <4.184538, -6.715530, -3.545067>, <4.747742, -6.715530, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.652816, -6.071299, -7.514659>, <4.681294, -6.072713, -7.514659>, <4.719264, -6.074599, -7.514659>, <4.747743, -6.076013, -7.514659>, 
      <4.414731, -6.147712, -7.411014>, <4.443209, -6.149126, -7.411014>, <4.719264, -6.162833, -7.411014>, <4.747743, -6.164247, -7.411014>, 
      <4.020893, -6.277629, -7.380787>, <4.286269, -6.306020, -7.380787>, <4.480851, -6.335383, -7.300782>, <4.747743, -6.335383, -7.300782>, 
      <3.859200, -6.326009, -7.169174>, <4.124576, -6.354400, -7.169174>, <4.480851, -6.370126, -7.169174>, <4.747743, -6.370126, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747742, -6.830008, -1.397774>, <4.108120, -6.830008, -1.397774>, <3.254283, -6.792319, -1.397774>, <2.618290, -6.724279, -1.397774>, 
      <4.747742, -6.853377, -0.860109>, <4.108120, -6.853377, -0.860109>, <3.198766, -6.812526, -0.860951>, <2.562773, -6.744486, -0.860951>, 
      <4.747742, -6.869754, -0.142668>, <4.062098, -6.869754, -0.142668>, <3.192793, -6.831636, -0.142668>, <2.511040, -6.758700, -0.142668>, 
      <4.747742, -6.886789, 0.395234>, <4.062098, -6.886789, 0.395234>, <3.146829, -6.846388, 0.395234>, <2.465076, -6.773452, 0.395234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747742, -6.715530, -3.545067>, <5.310946, -6.715530, -3.545067>, <6.062722, -6.683323, -3.545067>, <6.622912, -6.625137, -3.545067>, 
      <4.747742, -6.754034, -2.901114>, <5.310946, -6.754034, -2.901114>, <6.151373, -6.716589, -2.902637>, <6.711564, -6.658403, -2.902637>, 
      <4.747742, -6.801996, -2.042268>, <5.387365, -6.801996, -2.042268>, <6.174448, -6.768023, -2.043247>, <6.810441, -6.699983, -2.043247>, 
      <4.747742, -6.830008, -1.397774>, <5.387365, -6.830008, -1.397774>, <6.241201, -6.792319, -1.397774>, <6.877194, -6.724279, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747742, -6.577950, -5.613312>, <5.212564, -6.577950, -5.613312>, <5.832968, -6.552324, -5.613312>, <6.295474, -6.505990, -5.613312>, 
      <4.747742, -6.636949, -4.994272>, <5.212564, -6.636949, -4.994272>, <5.997729, -6.602276, -5.008107>, <6.460235, -6.555942, -5.008107>, 
      <4.747742, -6.678414, -4.165803>, <5.310946, -6.678414, -4.165803>, <5.976822, -6.651089, -4.167559>, <6.537012, -6.592904, -4.167559>, 
      <4.747742, -6.715530, -3.545067>, <5.310946, -6.715530, -3.545067>, <6.062722, -6.683323, -3.545067>, <6.622912, -6.625137, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, -6.076013, -7.514659>, <4.776221, -6.074599, -7.514659>, <4.814191, -6.072713, -7.514659>, <4.842670, -6.071299, -7.514659>, 
      <4.747743, -6.164247, -7.411014>, <4.776221, -6.162833, -7.411014>, <5.052276, -6.149126, -7.411014>, <5.080754, -6.147712, -7.411014>, 
      <4.747743, -6.335383, -7.300782>, <5.014634, -6.335383, -7.300782>, <5.209216, -6.306020, -7.380787>, <5.474592, -6.277629, -7.380787>, 
      <4.747743, -6.370126, -7.169174>, <5.014634, -6.370126, -7.169174>, <5.370908, -6.354400, -7.169174>, <5.636285, -6.326009, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.436061, -6.435420, -1.397774>, <8.635338, -6.370698, -1.397774>, <8.950346, -6.234478, -1.397774>, <9.006647, -6.032660, -1.397774>, 
      <8.531926, -6.447051, -0.862587>, <8.731204, -6.382328, -0.862587>, <9.060878, -6.234478, -0.863378>, <9.117179, -6.032660, -0.863378>, 
      <8.621823, -6.455294, -0.142668>, <8.834245, -6.387117, -0.142668>, <9.167059, -6.254819, -0.142668>, <9.221146, -6.038381, -0.142668>, 
      <8.701436, -6.463811, 0.395234>, <8.913858, -6.395635, 0.395234>, <9.258987, -6.257271, 0.395234>, <9.313074, -6.040832, 0.395234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.995633, -6.378181, -3.545067>, <8.168971, -6.324169, -3.545067>, <8.453642, -6.216868, -3.545067>, <8.498083, -6.040832, -3.545067>, 
      <8.148489, -6.397301, -2.905535>, <8.321827, -6.343288, -2.905535>, <8.629766, -6.215630, -2.906913>, <8.674206, -6.039595, -2.906913>, 
      <8.320102, -6.421352, -2.045143>, <8.519380, -6.356629, -2.045143>, <8.816257, -6.234478, -2.046065>, <8.872558, -6.032660, -2.046065>, 
      <8.436061, -6.435420, -1.397774>, <8.635338, -6.370698, -1.397774>, <8.950346, -6.234478, -1.397774>, <9.006647, -6.032660, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.428493, -6.309392, -5.613312>, <7.570444, -6.266729, -5.613312>, <7.812102, -6.185755, -5.613312>, <7.843207, -6.040832, -5.613312>, 
      <7.702778, -6.337111, -5.031624>, <7.844729, -6.294449, -5.031624>, <8.123327, -6.185755, -5.041714>, <8.154431, -6.040832, -5.041714>, 
      <7.846056, -6.359472, -4.170877>, <8.019394, -6.305460, -4.170877>, <8.280493, -6.218084, -4.172445>, <8.324934, -6.042048, -4.172445>, 
      <7.995633, -6.378181, -3.545067>, <8.168971, -6.324169, -3.545067>, <8.453642, -6.216868, -3.545067>, <8.498083, -6.040832, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.912160, -6.057227, -7.514659>, <4.919791, -6.051950, -7.514659>, <4.937480, -6.048914, -7.514659>, <4.937596, -6.039638, -7.514659>, 
      <5.324535, -6.101703, -7.411014>, <5.332166, -6.096426, -7.411014>, <5.417452, -6.048914, -7.430354>, <5.417567, -6.039638, -7.430354>, 
      <5.946732, -6.171407, -7.426087>, <6.029419, -6.144869, -7.426087>, <6.107666, -6.126996, -7.436009>, <6.117054, -6.040664, -7.436009>, 
      <6.286744, -6.205480, -7.169174>, <6.369430, -6.178942, -7.169174>, <6.515440, -6.127164, -7.169174>, <6.524828, -6.040832, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.208742, -6.205480, -7.169174>, <3.401419, -6.253038, -7.169174>, <3.661867, -6.304898, -7.169174>, <3.859200, -6.326009, -7.169174>, 
      <3.548734, -6.171571, -7.426073>, <3.741411, -6.219128, -7.426073>, <3.823560, -6.256518, -7.380787>, <4.020893, -6.277629, -7.380787>, 
      <4.170950, -6.102540, -7.411014>, <4.191797, -6.106403, -7.411014>, <4.393884, -6.143849, -7.411014>, <4.414731, -6.147712, -7.411014>, 
      <4.583325, -6.058423, -7.514659>, <4.604172, -6.062286, -7.514659>, <4.631968, -6.067436, -7.514659>, <4.652816, -6.071299, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.066992, -6.309392, -5.613312>, <2.397377, -6.408686, -5.613312>, <2.856744, -6.471602, -5.613312>, <3.200010, -6.505990, -5.613312>, 
      <2.314042, -6.284424, -6.137240>, <2.644428, -6.383719, -6.137240>, <2.990233, -6.431130, -6.103648>, <3.333499, -6.465518, -6.103648>, 
      <2.747613, -6.251471, -6.820743>, <2.940290, -6.299028, -6.820743>, <3.357335, -6.396016, -6.770620>, <3.554668, -6.417128, -6.770620>, 
      <3.208742, -6.205480, -7.169174>, <3.401419, -6.253038, -7.169174>, <3.661867, -6.304898, -7.169174>, <3.859200, -6.326009, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.059423, -6.435420, -1.397774>, <1.512291, -6.580768, -1.397774>, <2.145368, -6.673684, -1.397774>, <2.618290, -6.724279, -1.397774>, 
      <1.175383, -6.421352, -2.045143>, <1.628251, -6.566700, -2.045143>, <2.212121, -6.649388, -2.043247>, <2.685043, -6.699983, -2.043247>, 
      <1.346995, -6.397301, -2.905535>, <1.750293, -6.508803, -2.905535>, <2.367732, -6.615175, -2.902637>, <2.783920, -6.658403, -2.902637>, 
      <1.499852, -6.378181, -3.545067>, <1.903149, -6.489683, -3.545067>, <2.456384, -6.581909, -3.545067>, <2.872572, -6.625137, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.794048, -6.463810, 0.395234>, <0.581626, -6.395634, 0.395234>, <0.218875, -6.091366, 0.609448>, <0.182411, -6.040832, 0.395234>, 
      <0.873660, -6.455293, -0.142668>, <0.661239, -6.387116, -0.142668>, <0.129682, -5.967757, 0.085468>, <0.093218, -5.917223, -0.128746>, 
      <0.963558, -6.447050, -0.862587>, <0.765394, -6.383450, -0.862587>, <0.432833, -6.232755, -0.863455>, <0.378323, -6.031900, -0.863455>, 
      <1.059423, -6.435420, -1.397774>, <0.861259, -6.371820, -1.397774>, <0.543349, -6.241687, -1.397774>, <0.488839, -6.040832, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.794048, -6.463810, 0.395234>, <1.279500, -6.619616, 0.395234>, <1.958126, -6.719217, 0.395234>, <2.465076, -6.773452, 0.395234>, 
      <0.873660, -6.455293, -0.142668>, <1.359113, -6.611099, -0.142668>, <2.004091, -6.704465, -0.142668>, <2.511040, -6.758700, -0.142668>, 
      <0.963558, -6.447050, -0.862587>, <1.416426, -6.592399, -0.862587>, <2.089851, -6.693890, -0.860951>, <2.562773, -6.744486, -0.860951>, 
      <1.059423, -6.435420, -1.397774>, <1.512291, -6.580768, -1.397774>, <2.145368, -6.673684, -1.397774>, <2.618290, -6.724279, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.636285, -6.326009, -7.169174>, <5.833618, -6.304898, -7.169174>, <6.097778, -6.266128, -7.169174>, <6.286744, -6.205480, -7.169174>, 
      <5.474592, -6.277629, -7.380787>, <5.671926, -6.256518, -7.380787>, <5.757767, -6.232056, -7.426087>, <5.946732, -6.171407, -7.426087>, 
      <5.080754, -6.147712, -7.411014>, <5.101602, -6.143491, -7.411014>, <5.303688, -6.105925, -7.411014>, <5.324535, -6.101703, -7.411014>, 
      <4.842670, -6.071299, -7.514659>, <4.863517, -6.067078, -7.514659>, <4.891313, -6.061448, -7.514659>, <4.912160, -6.057227, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.295474, -6.505990, -5.613312>, <6.638740, -6.471602, -5.613312>, <7.098107, -6.408686, -5.613312>, <7.428493, -6.309392, -5.613312>, 
      <6.161985, -6.465518, -6.103648>, <6.505252, -6.431130, -6.103648>, <6.851057, -6.383719, -6.137240>, <7.181442, -6.284424, -6.137240>, 
      <5.940816, -6.417128, -6.770620>, <6.138150, -6.396016, -6.770620>, <6.558893, -6.312337, -6.820754>, <6.747858, -6.251689, -6.820754>, 
      <5.636285, -6.326009, -7.169174>, <5.833618, -6.304898, -7.169174>, <6.097778, -6.266128, -7.169174>, <6.286744, -6.205480, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.877194, -6.724279, -1.397774>, <7.350117, -6.673684, -1.397774>, <7.983701, -6.582341, -1.397774>, <8.436061, -6.435420, -1.397774>, 
      <6.810441, -6.699983, -2.043247>, <7.283363, -6.649388, -2.043247>, <7.867742, -6.568272, -2.045143>, <8.320102, -6.421352, -2.045143>, 
      <6.711564, -6.658403, -2.902637>, <7.127752, -6.615175, -2.902637>, <7.749006, -6.521780, -2.905535>, <8.148489, -6.397301, -2.905535>, 
      <6.622912, -6.625137, -3.545067>, <7.039101, -6.581909, -3.545067>, <7.596150, -6.502660, -3.545067>, <7.995633, -6.378181, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.030408, -6.773452, 0.395234>, <6.348655, -6.846388, 0.395234>, <5.433386, -6.886789, 0.395234>, <4.747742, -6.886789, 0.395234>, 
      <6.984444, -6.758700, -0.142668>, <6.302691, -6.831636, -0.142668>, <5.433386, -6.869754, -0.142668>, <4.747742, -6.869754, -0.142668>, 
      <6.932711, -6.744486, -0.860951>, <6.296718, -6.812526, -0.860951>, <5.387365, -6.853377, -0.860109>, <4.747742, -6.853377, -0.860109>, 
      <6.877194, -6.724279, -1.397774>, <6.241201, -6.792319, -1.397774>, <5.387365, -6.830008, -1.397774>, <4.747742, -6.830008, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.030408, -6.773452, 0.395234>, <7.537358, -6.719217, 0.395234>, <8.215984, -6.619616, 0.395234>, <8.701436, -6.463811, 0.395234>, 
      <6.984444, -6.758700, -0.142668>, <7.491394, -6.704465, -0.142668>, <8.136372, -6.611099, -0.142668>, <8.621823, -6.455294, -0.142668>, 
      <6.932711, -6.744486, -0.860951>, <7.405634, -6.693890, -0.860951>, <8.079566, -6.593972, -0.862587>, <8.531926, -6.447051, -0.862587>, 
      <6.877194, -6.724279, -1.397774>, <7.350117, -6.673684, -1.397774>, <7.983701, -6.582341, -1.397774>, <8.436061, -6.435420, -1.397774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.066992, -6.309392, -5.613312>, <2.314042, -6.284424, -6.137240>, <2.747613, -6.251471, -6.820743>, <3.208742, -6.205480, -7.169174>, 
      <1.925041, -6.266729, -5.613312>, <2.172091, -6.241762, -6.137240>, <2.672537, -6.232941, -6.820743>, <3.133666, -6.186950, -7.169174>, 
      <1.682328, -6.185977, -5.613312>, <1.975037, -6.185977, -6.150905>, <2.466513, -6.183605, -6.834006>, <2.978712, -6.183605, -7.169174>, 
      <1.652278, -6.040832, -5.613312>, <1.944987, -6.040832, -6.150905>, <2.458459, -6.106696, -6.834006>, <2.970658, -6.106696, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.200010, -6.505990, -5.613312>, <3.035249, -6.555942, -5.008107>, <2.958472, -6.592904, -4.167559>, <2.872572, -6.625137, -3.545067>, 
      <2.856744, -6.471602, -5.613312>, <2.691983, -6.521554, -5.008107>, <2.542284, -6.549676, -4.167559>, <2.456384, -6.581909, -3.545067>, 
      <2.397377, -6.408686, -5.613312>, <2.123092, -6.436406, -5.031624>, <2.052726, -6.470974, -4.170877>, <1.903149, -6.489683, -3.545067>, 
      <2.066992, -6.309392, -5.613312>, <1.792706, -6.337111, -5.031624>, <1.649429, -6.359472, -4.170877>, <1.499852, -6.378181, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747742, -6.577950, -5.613312>, <4.747742, -6.533272, -6.082091>, <4.747743, -6.490322, -6.713867>, <4.747743, -6.370126, -7.169174>, 
      <4.282921, -6.577950, -5.613312>, <4.282921, -6.533272, -6.082091>, <4.480851, -6.490322, -6.713867>, <4.480851, -6.370126, -7.169174>, 
      <3.662516, -6.552324, -5.613312>, <3.796005, -6.511852, -6.103648>, <3.820045, -6.445518, -6.770620>, <4.124576, -6.354400, -7.169174>, 
      <3.200010, -6.505990, -5.613312>, <3.333499, -6.465518, -6.103648>, <3.554668, -6.417128, -6.770620>, <3.859200, -6.326009, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.295474, -6.505990, -5.613312>, <6.161985, -6.465518, -6.103648>, <5.940816, -6.417128, -6.770620>, <5.636285, -6.326009, -7.169174>, 
      <5.832968, -6.552324, -5.613312>, <5.699479, -6.511852, -6.103648>, <5.675440, -6.445518, -6.770620>, <5.370908, -6.354400, -7.169174>, 
      <5.212564, -6.577950, -5.613312>, <5.212564, -6.533272, -6.082091>, <5.014634, -6.490322, -6.713867>, <5.014634, -6.370126, -7.169174>, 
      <4.747742, -6.577950, -5.613312>, <4.747742, -6.533272, -6.082091>, <4.747743, -6.490322, -6.713867>, <4.747743, -6.370126, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.428493, -6.309392, -5.613312>, <7.702778, -6.337111, -5.031624>, <7.846056, -6.359472, -4.170877>, <7.995633, -6.378181, -3.545067>, 
      <7.098107, -6.408686, -5.613312>, <7.372392, -6.436406, -5.031624>, <7.446574, -6.483951, -4.170877>, <7.596150, -6.502660, -3.545067>, 
      <6.638740, -6.471602, -5.613312>, <6.803502, -6.521554, -5.008107>, <6.953200, -6.549676, -4.167559>, <7.039101, -6.581909, -3.545067>, 
      <6.295474, -6.505990, -5.613312>, <6.460235, -6.555942, -5.008107>, <6.537012, -6.592904, -4.167559>, <6.622912, -6.625137, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.843207, -6.040832, -5.613312>, <7.550650, -6.040832, -6.150625>, <7.036759, -6.041042, -6.834180>, <6.524828, -6.040832, -7.169174>, 
      <7.812102, -6.185755, -5.613312>, <7.519546, -6.185755, -6.150625>, <7.027371, -6.127375, -6.834180>, <6.515440, -6.127164, -7.169174>, 
      <7.570444, -6.266729, -5.613312>, <7.323394, -6.241762, -6.137240>, <6.830546, -6.225150, -6.820754>, <6.369430, -6.178942, -7.169174>, 
      <7.428493, -6.309392, -5.613312>, <7.181442, -6.284424, -6.137240>, <6.747858, -6.251689, -6.820754>, <6.286744, -6.205480, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.920667, -4.016209, -5.613312>, <8.243866, -4.016209, -5.046670>, <8.414358, -4.017426, -4.172767>, <8.591931, -4.016209, -3.545067>, 
      <7.909042, -4.623929, -5.613312>, <8.232241, -4.623929, -5.046670>, <8.400270, -4.625302, -4.172767>, <8.577842, -4.624085, -3.545067>, 
      <7.970758, -5.446535, -5.613312>, <8.281982, -5.446535, -5.041714>, <8.473768, -5.452506, -4.172445>, <8.646918, -5.451290, -3.545067>, 
      <7.843207, -6.040832, -5.613312>, <8.154431, -6.040832, -5.041714>, <8.324934, -6.042048, -4.172445>, <8.498083, -6.040832, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.920667, -1.991585, -5.613312>, <8.243866, -1.991585, -5.046670>, <8.414358, -1.992802, -4.172767>, <8.591931, -1.991585, -3.545067>, 
      <7.932284, -2.598861, -5.613312>, <8.255482, -2.598861, -5.046670>, <8.428431, -2.600026, -4.172767>, <8.606005, -2.598809, -3.545067>, 
      <7.932284, -3.408933, -5.613312>, <8.255482, -3.408933, -5.046670>, <8.428431, -3.410202, -4.172767>, <8.606005, -3.408985, -3.545067>, 
      <7.920667, -4.016209, -5.613312>, <8.243866, -4.016209, -5.046670>, <8.414358, -4.017426, -4.172767>, <8.591931, -4.016209, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.843207, 0.033039, -5.613312>, <8.154431, 0.033039, -5.041714>, <8.324934, 0.031823, -4.172445>, <8.498083, 0.033039, -3.545067>, 
      <7.843207, -0.574792, -5.613312>, <8.154431, -0.574792, -5.041714>, <8.324934, -0.576217, -4.172445>, <8.498083, -0.575000, -3.545067>, 
      <7.909042, -1.383864, -5.613312>, <8.232241, -1.383864, -5.046670>, <8.400270, -1.384926, -4.172767>, <8.577842, -1.383709, -3.545067>, 
      <7.920667, -1.991585, -5.613312>, <8.243866, -1.991585, -5.046670>, <8.414358, -1.992802, -4.172767>, <8.591931, -1.991585, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.920667, 1.982677, -5.613312>, <8.243866, 1.982677, -5.046670>, <8.414358, 1.981460, -4.172767>, <8.591931, 1.982677, -3.545067>, 
      <7.909042, 1.397440, -5.613312>, <8.232241, 1.397440, -5.046670>, <8.400269, 1.396061, -4.172767>, <8.577842, 1.397278, -3.545067>, 
      <7.843207, 0.618392, -5.613312>, <8.154431, 0.618392, -5.041714>, <8.324934, 0.617391, -4.172445>, <8.498083, 0.618608, -3.545067>, 
      <7.843207, 0.033039, -5.613312>, <8.154431, 0.033039, -5.041714>, <8.324934, 0.031823, -4.172445>, <8.498083, 0.033039, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.920667, 3.932315, -5.613312>, <8.243866, 3.932315, -5.046670>, <8.414358, 3.931098, -4.172767>, <8.591931, 3.932315, -3.545067>, 
      <7.931829, 3.347530, -5.613312>, <8.255028, 3.347530, -5.046670>, <8.427664, 3.346358, -4.172767>, <8.605237, 3.347575, -3.545067>, 
      <7.932284, 2.567453, -5.613312>, <8.255482, 2.567453, -5.046670>, <8.428431, 2.566182, -4.172767>, <8.606005, 2.567399, -3.545067>, 
      <7.920667, 1.982677, -5.613312>, <8.243866, 1.982677, -5.046670>, <8.414358, 1.981460, -4.172767>, <8.591931, 1.982677, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.843207, 6.041047, -5.613312>, <8.154574, 6.041047, -5.041450>, <8.324878, 6.095889, -4.172645>, <8.498083, 6.106911, -3.545067>, 
      <7.971546, 5.421146, -5.613312>, <8.282914, 5.421146, -5.041450>, <8.479532, 5.461481, -4.172645>, <8.652737, 5.472503, -3.545067>, 
      <7.908586, 4.565246, -5.613312>, <8.231785, 4.565246, -5.046670>, <8.399502, 4.583915, -4.172767>, <8.577076, 4.585132, -3.545067>, 
      <7.920667, 3.932315, -5.613312>, <8.243866, 3.932315, -5.046670>, <8.414358, 3.931098, -4.172767>, <8.591931, 3.932315, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.428494, 6.309606, -5.613312>, <7.702779, 6.337326, -5.031624>, <7.846057, 6.359686, -4.170877>, <7.995634, 6.378396, -3.545067>, 
      <7.570444, 6.266944, -5.613312>, <7.844730, 6.294664, -5.031624>, <8.011192, 6.314030, -4.170877>, <8.160770, 6.332739, -3.545067>, 
      <7.813158, 6.186192, -5.613312>, <8.124525, 6.186192, -5.041450>, <8.284301, 6.262345, -4.172645>, <8.457506, 6.273368, -3.545067>, 
      <7.843207, 6.041047, -5.613312>, <8.154574, 6.041047, -5.041450>, <8.324878, 6.095889, -4.172645>, <8.498083, 6.106911, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.295475, 6.506205, -5.613312>, <6.161986, 6.465733, -6.103648>, <5.940817, 6.417343, -6.770620>, <5.636285, 6.326224, -7.169174>, 
      <6.638742, 6.471816, -5.613312>, <6.505252, 6.431344, -6.103648>, <6.138150, 6.396231, -6.770620>, <5.833619, 6.305113, -7.169174>, 
      <7.098107, 6.408901, -5.613312>, <6.851057, 6.383934, -6.137240>, <6.555195, 6.299242, -6.820743>, <6.094067, 6.253252, -7.169174>, 
      <7.428494, 6.309606, -5.613312>, <7.181443, 6.284639, -6.137240>, <6.747872, 6.251685, -6.820743>, <6.286744, 6.205694, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747743, 6.578164, -5.613312>, <4.747743, 6.533486, -6.082091>, <4.747743, 6.490537, -6.713867>, <4.747743, 6.370341, -7.169174>, 
      <5.212564, 6.578164, -5.613312>, <5.212564, 6.533486, -6.082091>, <5.014634, 6.490537, -6.713867>, <5.014634, 6.370341, -7.169174>, 
      <5.832969, 6.552538, -5.613312>, <5.699480, 6.512067, -6.103648>, <5.675440, 6.445734, -6.770620>, <5.370908, 6.354615, -7.169174>, 
      <6.295475, 6.506205, -5.613312>, <6.161986, 6.465733, -6.103648>, <5.940817, 6.417343, -6.770620>, <5.636285, 6.326224, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.200011, 6.506205, -5.613312>, <3.333500, 6.465733, -6.103648>, <3.554669, 6.417343, -6.770620>, <3.859200, 6.326224, -7.169174>, 
      <3.662517, 6.552538, -5.613312>, <3.796006, 6.512067, -6.103648>, <3.820046, 6.445734, -6.770620>, <4.124577, 6.354615, -7.169174>, 
      <4.282922, 6.578164, -5.613312>, <4.282922, 6.533486, -6.082091>, <4.480852, 6.490537, -6.713867>, <4.480852, 6.370341, -7.169174>, 
      <4.747743, 6.578164, -5.613312>, <4.747743, 6.533486, -6.082091>, <4.747743, 6.490537, -6.713867>, <4.747743, 6.370341, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.066992, 6.309606, -5.613312>, <1.792707, 6.337326, -5.031624>, <1.649429, 6.359686, -4.170877>, <1.499853, 6.378396, -3.545067>, 
      <2.397378, 6.408901, -5.613312>, <2.123093, 6.436620, -5.031624>, <2.048912, 6.484166, -4.170877>, <1.899335, 6.502875, -3.545067>, 
      <2.856745, 6.471816, -5.613312>, <2.691984, 6.521768, -5.008107>, <2.542285, 6.549890, -4.167559>, <2.456384, 6.582124, -3.545067>, 
      <3.200011, 6.506205, -5.613312>, <3.035250, 6.556157, -5.008107>, <2.958473, 6.593118, -4.167559>, <2.872573, 6.625352, -3.545067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.652278, 6.041047, -5.613312>, <1.944835, 6.041047, -6.150625>, <2.458726, 6.041257, -6.834180>, <2.970658, 6.041047, -7.169174>, 
      <1.683383, 6.185969, -5.613312>, <1.975939, 6.185969, -6.150625>, <2.468115, 6.127589, -6.834180>, <2.980046, 6.127378, -7.169174>, 
      <1.925042, 6.266944, -5.613312>, <2.172092, 6.241977, -6.137240>, <2.664940, 6.225365, -6.820754>, <3.126055, 6.179156, -7.169174>, 
      <2.066992, 6.309606, -5.613312>, <2.314043, 6.284639, -6.137240>, <2.747627, 6.251903, -6.820754>, <3.208742, 6.205694, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.574818, 4.016423, -5.613312>, <1.885500, 4.016423, -6.158008>, <2.441866, 4.016635, -6.832133>, <2.970658, 4.016423, -7.169174>, 
      <1.586443, 4.624144, -5.613312>, <1.897125, 4.624144, -6.158008>, <2.441866, 4.624022, -6.832133>, <2.970658, 4.623810, -7.169174>, 
      <1.524727, 5.446749, -5.613312>, <1.817284, 5.446749, -6.150625>, <2.393059, 5.437430, -6.834180>, <2.904991, 5.437220, -7.169174>, 
      <1.652278, 6.041047, -5.613312>, <1.944835, 6.041047, -6.150625>, <2.458726, 6.041257, -6.834180>, <2.970658, 6.041047, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.574818, 1.991799, -5.613312>, <1.885500, 1.991799, -6.158008>, <2.441866, 1.992011, -6.832133>, <2.970658, 1.991799, -7.169174>, 
      <1.563201, 2.599076, -5.613312>, <1.873883, 2.599076, -6.158008>, <2.441866, 2.599398, -6.832133>, <2.970658, 2.599186, -7.169174>, 
      <1.563201, 3.409147, -5.613312>, <1.873883, 3.409147, -6.158008>, <2.441866, 3.409248, -6.832133>, <2.970658, 3.409036, -7.169174>, 
      <1.574818, 4.016423, -5.613312>, <1.885500, 4.016423, -6.158008>, <2.441866, 4.016635, -6.832133>, <2.970658, 4.016423, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.652278, -0.032825, -5.613312>, <1.944835, -0.032825, -6.150625>, <2.458726, -0.032614, -6.834180>, <2.970658, -0.032825, -7.169174>, 
      <1.652278, 0.575007, -5.613312>, <1.944835, 0.575007, -6.150625>, <2.458726, 0.574773, -6.834180>, <2.970658, 0.574563, -7.169174>, 
      <1.586443, 1.384079, -5.613312>, <1.897125, 1.384079, -6.158008>, <2.441866, 1.384624, -6.832133>, <2.970658, 1.384412, -7.169174>, 
      <1.574818, 1.991799, -5.613312>, <1.885500, 1.991799, -6.158008>, <2.441866, 1.992011, -6.832133>, <2.970658, 1.991799, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.574818, -1.982463, -5.613312>, <1.885500, -1.982463, -6.158008>, <2.441866, -1.982251, -6.832133>, <2.970658, -1.982463, -7.169174>, 
      <1.586444, -1.397225, -5.613312>, <1.897126, -1.397225, -6.158008>, <2.441866, -1.397359, -6.832133>, <2.970658, -1.397571, -7.169174>, 
      <1.652278, -0.618178, -5.613312>, <1.944835, -0.618178, -6.150625>, <2.458726, -0.617506, -6.834180>, <2.970658, -0.617716, -7.169174>, 
      <1.652278, -0.032825, -5.613312>, <1.944835, -0.032825, -6.150625>, <2.458726, -0.032614, -6.834180>, <2.970658, -0.032825, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.574818, -3.932100, -5.613312>, <1.885500, -3.932100, -6.158008>, <2.441866, -3.931888, -6.832133>, <2.970658, -3.932100, -7.169174>, 
      <1.563657, -3.347315, -5.613312>, <1.874338, -3.347315, -6.158008>, <2.441866, -3.346997, -6.832133>, <2.970658, -3.347209, -7.169174>, 
      <1.563201, -2.567238, -5.613312>, <1.873883, -2.567238, -6.158008>, <2.441866, -2.567142, -6.832133>, <2.970658, -2.567354, -7.169174>, 
      <1.574818, -1.982463, -5.613312>, <1.885500, -1.982463, -6.158008>, <2.441866, -1.982251, -6.832133>, <2.970658, -1.982463, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.652278, -6.040832, -5.613312>, <1.944987, -6.040832, -6.150905>, <2.458459, -6.106696, -6.834006>, <2.970658, -6.106696, -7.169174>, 
      <1.523940, -5.420931, -5.613312>, <1.816649, -5.420931, -6.150905>, <2.390509, -5.457866, -6.834006>, <2.902708, -5.457866, -7.169174>, 
      <1.586899, -4.565031, -5.613312>, <1.897580, -4.565031, -6.158008>, <2.441866, -4.584267, -6.832133>, <2.970658, -4.584479, -7.169174>, 
      <1.574818, -3.932100, -5.613312>, <1.885500, -3.932100, -6.158008>, <2.441866, -3.931888, -6.832133>, <2.970658, -3.932100, -7.169174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.912160, 6.058637, -7.514659>, <4.805879, 6.053002, -7.514659>, <4.662670, 6.040802, -7.533305>, <4.557890, 6.039852, -7.514659>, 
      <4.912160, 6.058637, -7.514659>, <4.805879, 6.053002, -7.514659>, <4.767450, 6.041751, -7.551950>, <4.557890, 6.039852, -7.514659>, 
      <4.912160, 6.058637, -7.514659>, <4.805879, 6.053002, -7.514659>, <4.767450, 6.041751, -7.551950>, <4.557890, 6.039852, -7.514659>, 
      <4.912160, 6.058637, -7.514659>, <4.805879, 6.053002, -7.514659>, <4.662670, 6.040802, -7.533305>, <4.557890, 6.039852, -7.514659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.286744, 6.205694, -7.169174>, <5.946751, 6.171785, -7.426073>, <5.324535, 6.102754, -7.411014>, <4.912160, 6.058637, -7.514659>, 
      <6.361820, 6.187164, -7.169174>, <6.021827, 6.153254, -7.426073>, <5.808336, 6.117236, -7.307368>, <4.912160, 6.058637, -7.514659>, 
      <6.516774, 6.183820, -7.169174>, <6.101510, 6.186312, -7.438552>, <5.808336, 6.117236, -7.307368>, <4.912160, 6.058637, -7.514659>, 
      <6.524828, 6.106911, -7.169174>, <6.109564, 6.109403, -7.438552>, <5.395961, 6.073119, -7.411014>, <4.912160, 6.058637, -7.514659>
    }
  }
}
#declare contenedor_cuerpo = union {
  object { tapa }
  object { contendor_base }
  translate  <-4.75, 0.0, 9.0>
}
#declare pata1 = union {
  object { // apoyo_rueda1 -> apoyo_rueda
    apoyo_rueda
    translate  -4.0*z
  }
  object { // rueda1 -> rueda
    rueda
    rotate 20.0*z
    translate  -4.0*z
  }
  translate  <3.0, 5.0, 0.0>
}
#declare pata2 = union {
  object { // apoyo_rueda2 -> apoyo_rueda
    apoyo_rueda
    translate  -4.0*z
  }
  object { // rueda2 -> rueda
    rueda
    rotate 75.0*z
    translate  -4.0*z
  }
  translate  <3.0, -5.0, 0.0>
}
#declare pata3 = union {
  object { // apoyo_rueda3 -> apoyo_rueda
    apoyo_rueda
    translate  -4.0*z
  }
  object { // rueda3 -> rueda
    rueda
    rotate -65.0*z
    translate  -4.0*z
  }
  scale -1.0
  rotate -180.0*x
  translate  <-3.0, 5.0, 0.0>
}
#declare pata4 = union {
  object { // apoyo_rueda4 -> apoyo_rueda
    apoyo_rueda
    translate  -4.0*z
  }
  object { // rueda4 -> rueda
    rueda
    rotate -75.0*z
    translate  -4.0*z
  }
  scale -1.0
  rotate -180.0*x
  translate  <-3.0, -5.0, 0.0>
}
#declare patas = union {
  object { rueda }
  object { apoyo_rueda }
  object { pata1 }
  object { pata2 }
  object { pata3 }
  object { pata4 }
}
union { // contenedor
  object { contenedor_cuerpo }
  object { patas }
  material {
    contenedor_sucio_txt
  }
  scale 0.7
  translate  <2.545975, 8.253723, 0.12302>
}

/*
#declare diferencia_puerta_vieja = intersection {
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    scale <36.0, 29.117647, 4.0>
    rotate 90.0*x
    translate  20.955184*z
  }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    scale <21.6, 2.0, 25.0>
    translate  <0.0, -2.0, 25.0>
  }
  material {
    muro_txt
  }
  scale <1.0, 2.0, 1.0>
  translate  <-0.0, 2.260378, 0.0>
}

#declare fachada1 = difference {
  object { HgtFld001 }
  object { diferencia_puerta_vieja }
  material {
    fachada_txt
  }
}  */
#declare puerta_vieja_2 = union {
  object { tabla_puerta11 }
  object { // tabla_puerta12 -> tabla puerta11
    tabla_puerta11
    translate  2.0*x
  }
  object { // tabla_puerta13 -> tabla puerta11
    tabla_puerta11
    translate  4.0*x
  }
  object { // tabla_puerta14 -> tabla puerta11
    tabla_puerta11
    translate  6.0*x
  }
  object { // tabla_puerta15 -> tabla puerta11
    tabla_puerta11
    translate  8.0*x
  }
  object { // tabla_puerta16 -> tabla puerta11
    tabla_puerta11
    translate  10.0*x
  }
  object { // tabla_puerta17 -> tabla puerta11
    tabla_puerta11
    translate  12.0*x
  }
  object { // tabla_puerta18 -> tabla puerta11
    tabla_puerta11
    translate  14.0*x
  }
  object { // tabla_puerta19 -> tabla puerta11
    tabla_puerta11
    translate  16.0*x
  }
  object { // tabla_puerta20 -> tabla puerta11
    tabla_puerta11
    translate  18.0*x
  }
  object { // tabla_puerta21 -> tabla puerta11
    tabla_puerta11
    translate  20.0*x
  }
  translate  <-21.138285, 0.0, 20.005877>
}
#declare puerta_vieja_base1 = difference {
  object { puerta_vieja_2 }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 1.0, 6.0>
    translate  <-11.195427, 0.0, 40.979488>
  }
  material {
    puerta_vieja2_txt
  }
}
#declare CSG014 = difference {
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 0.3, 6.0>
    translate  <-11.195427, 0.0, 40.979488>
  }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    scale <8.75, 0.4, 5.75>
    translate  <-11.195427, 0.0, 40.979488>
  }
  material {
    hierro_txt
  }
}
#declare rejas1 = union {
  object { Cylndr123 }
  object { // Cylndr124 -> Cylndr123
    Cylndr123
    rotate <0.0, -0.0, -0.0>
    translate  <2.857, 0.0, 0.0>
  }
  object { // Cylndr125 -> Cylndr123
    Cylndr123
    rotate <0.0, -0.0, -0.0>
    translate  <5.714, 0.0, 0.0>
  }
  object { // Cylndr126 -> Cylndr123
    Cylndr123
    rotate <0.0, -0.0, -0.0>
    translate  <8.571, 0.0, 0.0>
  }
  object { // Cylndr127 -> Cylndr123
    Cylndr123
    rotate <0.0, -0.0, -0.0>
    translate  <11.428, 0.0, 0.0>
  }
  object { // Cylndr128 -> Cylndr123
    Cylndr123
    rotate <0.0, -0.0, -0.0>
    translate  <14.285, 0.0, 0.0>
  }
  translate  -0.145639*y
}
#declare ventana_vieja1 = union {
  object { CSG014 }
  object { rejas1 }
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    material {
      cristal_puerta_vieja_txt
    }
    scale <8.9, 0.1, 5.9>
    translate  <-11.195427, 0.121366, 41.007173>
  }
}
/*
#declare mirilla_hf = object { 
  height_field {
    tga "C:\TXEMI\MORAY FOR WINDOWS\Maps\mirilla_hf.tga"
    water_level 0.2857
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    mirilla_txt
  }
  scale <2.0, 2.0, 0.4>
  rotate 90.0*x
  translate  <-4.252669, -0.365129, 23.959145>
}
#declare mirilla = union {
  object { mirilla_hf }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    material {
      negro_tx
    }
    scale <1.7, 1.7, 0.094444>
    rotate -90.0*x
    translate  <-4.2526, -0.219102, 23.9591>
  }
  scale -0.9
  rotate -180.0*x
  translate  <-23.913866, -0.034139, 4.793319>
} */
#declare puerta_vieja2 = union {
  object { puerta_vieja_base1 }
  object { ventana_vieja1 }
 // object { mirilla }
  scale <-1.0, 1.0, 1.0>
  translate  -22.15*x
}
#declare puerta_vieja_1 = union {
  object { tabla_puerta }
  object { // tabla_puerta1 -> tabla puerta
    tabla_puerta
    translate  2.0*x
  }
  object { // tabla_puerta2 -> tabla puerta
    tabla_puerta
    translate  4.0*x
  }
  object { // tabla_puerta3 -> tabla puerta
    tabla_puerta
    translate  6.0*x
  }
  object { // tabla_puerta4 -> tabla puerta
    tabla_puerta
    translate  8.0*x
  }
  object { // tabla_puerta5 -> tabla puerta
    tabla_puerta
    translate  10.0*x
  }
  object { // tabla_puerta6 -> tabla puerta
    tabla_puerta
    translate  12.0*x
  }
  object { // tabla_puerta7 -> tabla puerta
    tabla_puerta
    translate  14.0*x
  }
  object { // tabla_puerta8 -> tabla puerta
    tabla_puerta
    translate  16.0*x
  }
  object { // tabla_puerta9 -> tabla puerta
    tabla_puerta
    translate  18.0*x
  }
  object { // tabla_puerta10 -> tabla puerta
    tabla_puerta
    translate  20.0*x
  }
  translate  <-21.138285, 0.0, 20.005877>
}
#declare puerta_vieja_base = difference {
  object { puerta_vieja_1 }
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 1.0, 6.0>
    translate  <-11.195427, 0.0, 40.979488>
  }
  material {
    puerta_vieja2_txt
  }
}
#declare CSG015 = difference {
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 0.3, 6.0>
    translate  <-11.195427, 0.0, 40.979488>
  }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    scale <8.75, 0.4, 5.75>
    translate  <-11.195427, 0.0, 40.979488>
  }
  material {
    hierro_txt
  }
}
#declare rejas = union {
  object { Cylndr132 }
  object { // Cylndr133 -> Cylndr132
    Cylndr132
    rotate <0.0, -0.0, -0.0>
    translate  <2.857, 0.0, 0.0>
  }
  object { // Cylndr134 -> Cylndr132
    Cylndr132
    rotate <0.0, -0.0, -0.0>
    translate  <5.714, 0.0, 0.0>
  }
  object { // Cylndr135 -> Cylndr132
    Cylndr132
    rotate <0.0, -0.0, -0.0>
    translate  <8.571, 0.0, 0.0>
  }
  object { // Cylndr136 -> Cylndr132
    Cylndr132
    rotate <0.0, -0.0, -0.0>
    translate  <11.428, 0.0, 0.0>
  }
  object { // Cylndr137 -> Cylndr132
    Cylndr132
    rotate <0.0, -0.0, -0.0>
    translate  <14.285, 0.0, 0.0>
  }
  translate  -0.145639*y
}
#declare ventana_vieja = union {
  object { CSG015 }
  object { rejas }
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    material {
      cristal_puerta_vieja_txt
    }
    scale <8.9, 0.1, 5.9>
    translate  <-11.195427, 0.121366, 41.007173>
  }
}
#declare puerta_vieja1 = union {
  object { puerta_vieja_base }
  object { ventana_vieja }
  translate  22.15*x
}
#declare puerta1 = union {
  object { puerta_vieja2 }
  object { puerta_vieja1 }
}
#declare placa_calle = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.685426, 0.000000, 1.969312>, <1.074170, 0.000000, 1.969312>, <-1.074170, 0.000000, 1.969312>, <-2.685426, 0.000000, 1.969312>, 
      <2.612474, 0.000000, 1.987458>, <1.001219, 0.000000, 1.987458>, <-1.001219, 0.000000, 1.987458>, <-2.612474, 0.000000, 1.987458>, 
      <2.515206, 0.000000, 2.011654>, <1.049853, 0.000000, 2.011654>, <-1.049853, 0.000000, 2.011654>, <-2.515206, 0.000000, 2.011654>, 
      <2.442255, 0.000000, 2.029800>, <0.976902, 0.000000, 2.029800>, <-0.976902, 0.000000, 2.029800>, <-2.442255, 0.000000, 2.029800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.740230, 0.000000, 1.703078>, <1.096092, 0.000000, 1.703078>, <-1.096092, 0.000000, 1.703078>, <-2.740230, 0.000000, 1.703078>, 
      <2.739013, 0.000000, 1.784613>, <1.094875, 0.000000, 1.784613>, <-1.094875, 0.000000, 1.784613>, <-2.739013, 0.000000, 1.784613>, 
      <2.701867, 0.000000, 1.889442>, <1.090612, 0.000000, 1.889442>, <-1.090612, 0.000000, 1.889442>, <-2.701867, 0.000000, 1.889442>, 
      <2.685426, 0.000000, 1.969312>, <1.074170, 0.000000, 1.969312>, <-1.074170, 0.000000, 1.969312>, <-2.685426, 0.000000, 1.969312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.740230, 0.000000, -1.703077>, <1.096092, 0.000000, -1.703077>, <-1.096092, 0.000000, -1.703077>, <-2.740230, 0.000000, -1.703077>, 
      <2.755478, 0.000000, -0.681345>, <1.111340, 0.000000, -0.681345>, <-1.111340, 0.000000, -0.681345>, <-2.755478, 0.000000, -0.681345>, 
      <2.755478, 0.000000, 0.681345>, <1.111340, 0.000000, 0.681345>, <-1.111340, 0.000000, 0.681345>, <-2.755478, 0.000000, 0.681345>, 
      <2.740230, 0.000000, 1.703078>, <1.096092, 0.000000, 1.703078>, <-1.096092, 0.000000, 1.703078>, <-2.740230, 0.000000, 1.703078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.685426, 0.000000, -1.969312>, <1.074170, 0.000000, -1.969312>, <-1.074170, 0.000000, -1.969312>, <-2.685426, 0.000000, -1.969312>, 
      <2.701867, 0.000000, -1.889442>, <1.090612, 0.000000, -1.889442>, <-1.090612, 0.000000, -1.889442>, <-2.701867, 0.000000, -1.889442>, 
      <2.739013, 0.000000, -1.784613>, <1.094875, 0.000000, -1.784613>, <-1.094875, 0.000000, -1.784613>, <-2.739013, 0.000000, -1.784613>, 
      <2.740230, 0.000000, -1.703077>, <1.096092, 0.000000, -1.703077>, <-1.096092, 0.000000, -1.703077>, <-2.740230, 0.000000, -1.703077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.442255, 0.000000, -2.029800>, <0.976902, 0.000000, -2.029800>, <-0.976902, 0.000000, -2.029800>, <-2.442255, 0.000000, -2.029800>, 
      <2.515207, 0.000000, -2.011654>, <1.049853, 0.000000, -2.011654>, <-1.049853, 0.000000, -2.011654>, <-2.515207, 0.000000, -2.011654>, 
      <2.612474, 0.000000, -1.987458>, <1.001219, 0.000000, -1.987458>, <-1.001219, 0.000000, -1.987458>, <-2.612474, 0.000000, -1.987458>, 
      <2.685426, 0.000000, -1.969312>, <1.074170, 0.000000, -1.969312>, <-1.074170, 0.000000, -1.969312>, <-2.685426, 0.000000, -1.969312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.847690, -0.082099, 1.769865>, <-2.863536, -0.082099, 0.708064>, <-2.863536, -0.082099, -0.708064>, <-2.847690, -0.082099, -1.769865>, 
      <-2.899311, -0.077445, 1.804958>, <-2.915157, -0.077445, 0.743157>, <-2.915157, -0.077445, -0.743157>, <-2.899311, -0.077445, -1.804957>, 
      <-2.947359, -0.005473, 1.844199>, <-2.963997, -0.005473, 0.718688>, <-2.963997, -0.005473, -0.718688>, <-2.947359, -0.005473, -1.844199>, 
      <-2.990074, 0.027366, 1.876057>, <-3.006712, 0.027366, 0.750546>, <-3.006712, 0.027366, -0.750545>, <-2.990074, 0.027366, -1.876056>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.847690, -0.082099, -1.769865>, <-2.846425, -0.082099, -1.854598>, <-2.807822, -0.082099, -1.963537>, <-2.790736, -0.082099, -2.046540>, 
      <-2.899311, -0.077445, -1.804957>, <-2.898047, -0.077445, -1.889691>, <-2.858173, -0.077467, -2.003925>, <-2.841087, -0.077467, -2.086927>, 
      <-2.947359, -0.005473, -1.844199>, <-2.946032, -0.005473, -1.933982>, <-2.906352, -0.005473, -2.044512>, <-2.888412, -0.005473, -2.132495>, 
      <-2.990074, 0.027366, -1.876056>, <-2.988747, 0.027366, -1.965840>, <-2.948213, 0.027366, -2.081350>, <-2.930273, 0.027366, -2.169332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.790736, -0.082099, -2.046540>, <-2.714924, -0.082099, -2.065398>, <-2.616147, -0.082099, -2.108478>, <-2.538030, -0.082099, -2.109400>, 
      <-2.841087, -0.077467, -2.086927>, <-2.765275, -0.077467, -2.105785>, <-2.662636, -0.077396, -2.150741>, <-2.584519, -0.077396, -2.151662>, 
      <-2.888412, -0.005473, -2.132495>, <-2.808809, -0.005473, -2.152484>, <-2.708929, -0.005473, -2.197017>, <-2.626861, -0.005473, -2.197994>, 
      <-2.930273, 0.027366, -2.169332>, <-2.850670, 0.027366, -2.189322>, <-2.747000, 0.027366, -2.234986>, <-2.664932, 0.027366, -2.235964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.538030, -0.082099, -2.109400>, <-1.015318, -0.082099, -2.127362>, <1.015318, -0.082099, -2.127362>, <2.538030, -0.082099, -2.109400>, 
      <-2.584519, -0.077396, -2.151662>, <-1.061807, -0.077396, -2.169625>, <1.061807, -0.077396, -2.169625>, <2.584519, -0.077396, -2.151662>, 
      <-2.626861, -0.005473, -2.197994>, <-1.028016, -0.005473, -2.217035>, <1.028015, -0.005473, -2.217035>, <2.626861, -0.005473, -2.197994>, 
      <-2.664932, 0.027366, -2.235964>, <-1.066086, 0.027366, -2.255004>, <1.066086, 0.027366, -2.255004>, <2.664931, 0.027366, -2.235964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.538030, -0.082099, -2.109400>, <2.616146, -0.082099, -2.108478>, <2.714924, -0.082099, -2.065398>, <2.790736, -0.082099, -2.046540>, 
      <2.584519, -0.077396, -2.151662>, <2.662635, -0.077396, -2.150741>, <2.765275, -0.077467, -2.105785>, <2.841087, -0.077467, -2.086927>, 
      <2.626861, -0.005473, -2.197994>, <2.708929, -0.005473, -2.197017>, <2.808809, -0.005473, -2.152484>, <2.888412, -0.005473, -2.132495>, 
      <2.664931, 0.027366, -2.235964>, <2.746999, 0.027366, -2.234986>, <2.850670, 0.027366, -2.189322>, <2.930273, 0.027366, -2.169332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.790736, -0.082099, -2.046540>, <2.807822, -0.082099, -1.963537>, <2.846425, -0.082099, -1.854598>, <2.847690, -0.082099, -1.769865>, 
      <2.841087, -0.077467, -2.086927>, <2.858173, -0.077467, -2.003925>, <2.898047, -0.077445, -1.889691>, <2.899311, -0.077445, -1.804958>, 
      <2.888412, -0.005473, -2.132495>, <2.906352, -0.005473, -2.044512>, <2.946032, -0.005473, -1.933982>, <2.947359, -0.005473, -1.844199>, 
      <2.930273, 0.027366, -2.169332>, <2.948213, 0.027366, -2.081350>, <2.988747, 0.027366, -1.965840>, <2.990074, 0.027366, -1.876057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.847690, -0.082099, -1.769865>, <2.863536, -0.082099, -0.708064>, <2.863536, -0.082099, 0.708064>, <2.847690, -0.082099, 1.769865>, 
      <2.899311, -0.077445, -1.804958>, <2.915157, -0.077445, -0.743157>, <2.915157, -0.077445, 0.743157>, <2.899311, -0.077445, 1.804957>, 
      <2.947359, -0.005473, -1.844199>, <2.963997, -0.005473, -0.718688>, <2.963997, -0.005473, 0.718688>, <2.947359, -0.005473, 1.844199>, 
      <2.990074, 0.027366, -1.876057>, <3.006712, 0.027366, -0.750546>, <3.006712, 0.027366, 0.750545>, <2.990074, 0.027366, 1.876056>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.847690, -0.082099, 1.769865>, <2.846425, -0.082099, 1.854598>, <2.807822, -0.082099, 1.963537>, <2.790736, -0.082099, 2.046540>, 
      <2.899311, -0.077445, 1.804957>, <2.898047, -0.077445, 1.889691>, <2.858173, -0.077467, 2.003925>, <2.841087, -0.077467, 2.086927>, 
      <2.947359, -0.005473, 1.844199>, <2.946032, -0.005473, 1.933982>, <2.906352, -0.005473, 2.044512>, <2.888412, -0.005473, 2.132495>, 
      <2.990074, 0.027366, 1.876056>, <2.988747, 0.027366, 1.965840>, <2.948213, 0.027366, 2.081350>, <2.930273, 0.027366, 2.169332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.790736, -0.082099, 2.046540>, <2.714924, -0.082099, 2.065398>, <2.616147, -0.082099, 2.108478>, <2.538030, -0.082099, 2.109400>, 
      <2.841087, -0.077467, 2.086927>, <2.765275, -0.077467, 2.105785>, <2.662636, -0.077396, 2.150741>, <2.584519, -0.077396, 2.151662>, 
      <2.888412, -0.005473, 2.132495>, <2.808809, -0.005473, 2.152484>, <2.708929, -0.005473, 2.197017>, <2.626861, -0.005473, 2.197994>, 
      <2.930273, 0.027366, 2.169332>, <2.850670, 0.027366, 2.189322>, <2.747000, 0.027366, 2.234986>, <2.664932, 0.027366, 2.235964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.538030, -0.082099, 2.109400>, <1.015318, -0.082099, 2.127362>, <-1.015318, -0.082099, 2.127362>, <-2.538030, -0.082099, 2.109400>, 
      <2.584519, -0.077396, 2.151662>, <1.061807, -0.077396, 2.169625>, <-1.061807, -0.077396, 2.169625>, <-2.584519, -0.077396, 2.151662>, 
      <2.626861, -0.005473, 2.197994>, <1.028016, -0.005473, 2.217035>, <-1.028015, -0.005473, 2.217035>, <-2.626861, -0.005473, 2.197994>, 
      <2.664932, 0.027366, 2.235964>, <1.066086, 0.027366, 2.255004>, <-1.066086, 0.027366, 2.255004>, <-2.664931, 0.027366, 2.235964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.538030, -0.082099, 2.109400>, <-2.616146, -0.082099, 2.108478>, <-2.714924, -0.082099, 2.065398>, <-2.790736, -0.082099, 2.046540>, 
      <-2.584519, -0.077396, 2.151662>, <-2.662635, -0.077396, 2.150741>, <-2.765275, -0.077467, 2.105785>, <-2.841087, -0.077467, 2.086927>, 
      <-2.626861, -0.005473, 2.197994>, <-2.708929, -0.005473, 2.197017>, <-2.808809, -0.005473, 2.152484>, <-2.888412, -0.005473, 2.132495>, 
      <-2.664931, 0.027366, 2.235964>, <-2.746999, 0.027366, 2.234986>, <-2.850670, 0.027366, 2.189322>, <-2.930273, 0.027366, 2.169332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.790736, -0.082099, 2.046540>, <-2.807822, -0.082099, 1.963537>, <-2.846425, -0.082099, 1.854598>, <-2.847690, -0.082099, 1.769865>, 
      <-2.841087, -0.077467, 2.086927>, <-2.858173, -0.077467, 2.003925>, <-2.898047, -0.077445, 1.889691>, <-2.899311, -0.077445, 1.804958>, 
      <-2.888412, -0.005473, 2.132495>, <-2.906352, -0.005473, 2.044512>, <-2.946032, -0.005473, 1.933982>, <-2.947359, -0.005473, 1.844199>, 
      <-2.930273, 0.027366, 2.169332>, <-2.948213, 0.027366, 2.081350>, <-2.988747, 0.027366, 1.965840>, <-2.990074, 0.027366, 1.876057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.847690, -0.082099, 1.769865>, <-2.796529, -0.086710, 1.735085>, <-2.734857, -0.024630, 1.699738>, <-2.686500, 0.000000, 1.669684>, 
      <-2.846425, -0.082099, 1.854598>, <-2.795265, -0.086710, 1.819819>, <-2.733664, -0.024630, 1.779675>, <-2.685307, 0.000000, 1.749621>, 
      <-2.807822, -0.082099, 1.963537>, <-2.758245, -0.086659, 1.923770>, <-2.696279, -0.024630, 1.887146>, <-2.648889, 0.000000, 1.852394>, 
      <-2.790736, -0.082099, 2.046540>, <-2.741159, -0.086659, 2.006773>, <-2.680160, -0.024630, 1.965451>, <-2.632770, 0.000000, 1.930698>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.847690, -0.082099, -1.769865>, <-2.796529, -0.086710, -1.735085>, <-2.734857, -0.024630, -1.699738>, <-2.686500, 0.000000, -1.669684>, 
      <-2.863536, -0.082099, -0.708064>, <-2.812375, -0.086710, -0.673285>, <-2.749806, -0.024630, -0.698039>, <-2.701449, 0.000000, -0.667985>, 
      <-2.863536, -0.082099, 0.708064>, <-2.812375, -0.086710, 0.673285>, <-2.749806, -0.024630, 0.698039>, <-2.701449, 0.000000, 0.667985>, 
      <-2.847690, -0.082099, 1.769865>, <-2.796529, -0.086710, 1.735085>, <-2.734857, -0.024630, 1.699738>, <-2.686500, 0.000000, 1.669684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.790736, -0.082099, -2.046540>, <-2.741159, -0.086659, -2.006773>, <-2.680160, -0.024630, -1.965451>, <-2.632770, 0.000000, -1.930698>, 
      <-2.807822, -0.082099, -1.963537>, <-2.758245, -0.086659, -1.923770>, <-2.696279, -0.024630, -1.887146>, <-2.648889, 0.000000, -1.852394>, 
      <-2.846425, -0.082099, -1.854598>, <-2.795265, -0.086710, -1.819819>, <-2.733664, -0.024630, -1.779675>, <-2.685307, 0.000000, -1.749621>, 
      <-2.847690, -0.082099, -1.769865>, <-2.796529, -0.086710, -1.735085>, <-2.734857, -0.024630, -1.699738>, <-2.686500, 0.000000, -1.669684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.538030, -0.082099, -2.109400>, <-2.492862, -0.086667, -2.068338>, <-2.437467, -0.024630, -2.025820>, <-2.394368, 0.000000, -1.990000>, 
      <-2.616147, -0.082099, -2.108478>, <-2.570978, -0.086667, -2.067416>, <-2.511162, -0.024630, -2.024951>, <-2.468063, 0.000000, -1.989131>, 
      <-2.714924, -0.082099, -2.065398>, <-2.665347, -0.086659, -2.025631>, <-2.608639, -0.024630, -1.983241>, <-2.561249, 0.000000, -1.948489>, 
      <-2.790736, -0.082099, -2.046540>, <-2.741159, -0.086659, -2.006773>, <-2.680160, -0.024630, -1.965451>, <-2.632770, 0.000000, -1.930698>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.538030, -0.082099, -2.109400>, <2.492861, -0.086667, -2.068338>, <2.437466, -0.024630, -2.025820>, <2.394368, 0.000000, -1.990000>, 
      <1.015318, -0.082099, -2.127362>, <0.970149, -0.086667, -2.086300>, <1.000945, -0.024630, -2.042766>, <0.957847, 0.000000, -2.006946>, 
      <-1.015318, -0.082099, -2.127362>, <-0.970149, -0.086667, -2.086300>, <-1.000946, -0.024630, -2.042766>, <-0.957847, 0.000000, -2.006946>, 
      <-2.538030, -0.082099, -2.109400>, <-2.492862, -0.086667, -2.068338>, <-2.437467, -0.024630, -2.025820>, <-2.394368, 0.000000, -1.990000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.790736, -0.082099, -2.046540>, <2.741159, -0.086659, -2.006773>, <2.680160, -0.024630, -1.965451>, <2.632770, 0.000000, -1.930698>, 
      <2.714924, -0.082099, -2.065398>, <2.665347, -0.086659, -2.025631>, <2.608639, -0.024630, -1.983241>, <2.561249, 0.000000, -1.948489>, 
      <2.616146, -0.082099, -2.108478>, <2.570978, -0.086667, -2.067416>, <2.511161, -0.024630, -2.024951>, <2.468063, 0.000000, -1.989131>, 
      <2.538030, -0.082099, -2.109400>, <2.492861, -0.086667, -2.068338>, <2.437466, -0.024630, -2.025820>, <2.394368, 0.000000, -1.990000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.847690, -0.082099, -1.769865>, <2.796529, -0.086710, -1.735085>, <2.734857, -0.024630, -1.699738>, <2.686500, 0.000000, -1.669684>, 
      <2.846425, -0.082099, -1.854598>, <2.795265, -0.086710, -1.819819>, <2.733664, -0.024630, -1.779675>, <2.685307, 0.000000, -1.749621>, 
      <2.807822, -0.082099, -1.963537>, <2.758245, -0.086659, -1.923770>, <2.696279, -0.024630, -1.887146>, <2.648889, 0.000000, -1.852394>, 
      <2.790736, -0.082099, -2.046540>, <2.741159, -0.086659, -2.006773>, <2.680160, -0.024630, -1.965451>, <2.632770, 0.000000, -1.930698>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.847690, -0.082099, 1.769865>, <2.796529, -0.086710, 1.735085>, <2.734857, -0.024630, 1.699738>, <2.686500, 0.000000, 1.669684>, 
      <2.863536, -0.082099, 0.708064>, <2.812375, -0.086710, 0.673285>, <2.749806, -0.024630, 0.698039>, <2.701449, 0.000000, 0.667985>, 
      <2.863536, -0.082099, -0.708064>, <2.812375, -0.086710, -0.673285>, <2.749806, -0.024630, -0.698039>, <2.701449, 0.000000, -0.667985>, 
      <2.847690, -0.082099, -1.769865>, <2.796529, -0.086710, -1.735085>, <2.734857, -0.024630, -1.699738>, <2.686500, 0.000000, -1.669684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.790736, -0.082099, 2.046540>, <2.741159, -0.086659, 2.006773>, <2.680160, -0.024630, 1.965451>, <2.632770, 0.000000, 1.930698>, 
      <2.807822, -0.082099, 1.963537>, <2.758245, -0.086659, 1.923770>, <2.696279, -0.024630, 1.887146>, <2.648889, 0.000000, 1.852394>, 
      <2.846425, -0.082099, 1.854598>, <2.795265, -0.086710, 1.819819>, <2.733664, -0.024630, 1.779675>, <2.685307, 0.000000, 1.749621>, 
      <2.847690, -0.082099, 1.769865>, <2.796529, -0.086710, 1.735085>, <2.734857, -0.024630, 1.699738>, <2.686500, 0.000000, 1.669684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.538030, -0.082099, 2.109400>, <2.492862, -0.086667, 2.068338>, <2.437467, -0.024630, 2.025820>, <2.394368, 0.000000, 1.990000>, 
      <2.616147, -0.082099, 2.108478>, <2.570978, -0.086667, 2.067416>, <2.511162, -0.024630, 2.024951>, <2.468063, 0.000000, 1.989131>, 
      <2.714924, -0.082099, 2.065398>, <2.665347, -0.086659, 2.025631>, <2.608639, -0.024630, 1.983241>, <2.561249, 0.000000, 1.948489>, 
      <2.790736, -0.082099, 2.046540>, <2.741159, -0.086659, 2.006773>, <2.680160, -0.024630, 1.965451>, <2.632770, 0.000000, 1.930698>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.538030, -0.082099, 2.109400>, <-2.492861, -0.086667, 2.068338>, <-2.437466, -0.024630, 2.025820>, <-2.394368, 0.000000, 1.990000>, 
      <-1.015318, -0.082099, 2.127362>, <-0.970149, -0.086667, 2.086300>, <-1.000945, -0.024630, 2.042766>, <-0.957847, 0.000000, 2.006946>, 
      <1.015318, -0.082099, 2.127362>, <0.970149, -0.086667, 2.086300>, <1.000946, -0.024630, 2.042766>, <0.957847, 0.000000, 2.006946>, 
      <2.538030, -0.082099, 2.109400>, <2.492862, -0.086667, 2.068338>, <2.437467, -0.024630, 2.025820>, <2.394368, 0.000000, 1.990000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.790736, -0.082099, 2.046540>, <-2.741159, -0.086659, 2.006773>, <-2.680160, -0.024630, 1.965451>, <-2.632770, 0.000000, 1.930698>, 
      <-2.714924, -0.082099, 2.065398>, <-2.665347, -0.086659, 2.025631>, <-2.608639, -0.024630, 1.983241>, <-2.561249, 0.000000, 1.948489>, 
      <-2.616146, -0.082099, 2.108478>, <-2.570978, -0.086667, 2.067416>, <-2.511161, -0.024630, 2.024951>, <-2.468063, 0.000000, 1.989131>, 
      <-2.538030, -0.082099, 2.109400>, <-2.492861, -0.086667, 2.068338>, <-2.437466, -0.024630, 2.025820>, <-2.394368, 0.000000, 1.990000>
    }
  }
  material {
    placa_txt_1
    scale 0.92
    translate <0.252229, 0.000000, 0.914328>
  }
  scale 2.0
  translate  <47.594586, -3.881919, 55.508009>
}
#declare CSG016 = difference {
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.2, 1.0>
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 1.2>
    translate  -0.1*z
  }
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.9, 0.6>
    translate  <0.0, -0.443651, 0.5>
  }
  scale <40.0, 24.0, 3.0>
  rotate 90.0*x
  translate  33.016732*z
}
#declare CSG017 = union {
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 2.5, 7.0>
    rotate -30.0*y
    translate  <-29.893025, -1.460918, 45.702172>
  }
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 2.5, 7.0>
    rotate 30.0*y
    translate  <29.89302, -1.460918, 45.702172>
  }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 8.0>
    rotate -7.5*y
    translate  <-5.143009, -1.334208, 55.763809>
  }
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 8.0>
    rotate 15.0*y
    translate  <11.48605, -1.334208, 54.563773>
  }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 8.0>
    rotate -22.5*y
    translate  <-17.657664, -1.334208, 52.163702>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 8.0>
    rotate 7.5*y
    translate  <5.14301, -1.334208, 55.763809>
  }
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 8.0>
    rotate -15.0*y
    translate  <-11.48605, -1.334208, 54.563773>
  }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 8.0>
    rotate 22.5*y
    translate  <17.65766, -1.334208, 52.163702>
  }
}
#declare arco = difference {
  object { CSG016 }
  object { CSG017 }
  translate  2.056397*y
}
#declare apoyo1 = difference {
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 4.0>
    translate  <-28.603045, 0.0, 44.837205>
  }
  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.5, 7.0>
    rotate -30.0*y
    translate  <-19.5, -1.128945, 51.2>
  }
}
#declare vert_puerta1 = union {
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 9.2>
    translate  <-28.603045, 0.0, 6.644875>
  }
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 1.0, 4.0>
    translate  <-24.651873, 0.0, 36.591282>
  }
  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 4.0>
    translate  <-28.603045, 0.0, 28.34536>
  }
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 1.0, 4.0>
    translate  <-24.651873, 0.0, 20.099437>
  }
  object { apoyo1 }
  translate  <-0.820207, 0.0, 1.342157>
}
#declare apoyo2 = difference {
  box { // Cube066
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 4.0>
    translate  <-28.603045, 0.0, 44.837205>
  }
  box { // Cube067
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.5, 7.0>
    rotate -30.0*y
    translate  <-19.5, -1.128945, 51.2>
  }
}
#declare vert_puerta2 = union {
  box { // Cube062
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 9.2>
    translate  <-28.603045, 0.0, 6.644875>
  }
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 1.0, 4.0>
    translate  <-24.651873, 0.0, 36.591282>
  }
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 4.0>
    translate  <-28.603045, 0.0, 28.34536>
  }
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 1.0, 4.0>
    translate  <-24.651873, 0.0, 20.099437>
  }
  object { apoyo2 }
  scale -1.0
  rotate -180.0*x
  translate  <0.82021, 0.0, 1.342157>
}
/*
#declare placapov = object { 
  height_field {
    tga "C:\TXEMI\MORAY FOR WINDOWS\Maps\pov.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <3.846154, 3.846154, 0.384615>
  rotate <90.0, -90.0, 0.0>
  translate  <-0.023465, -0.981873, 56.446074>
} */
#declare resto_pared = union {
  object { Cube068 }
  object { // Cube069 -> Cube068
    Cube068
    translate  4.02*y
  }
  object { // Cube070 -> Cube068
    Cube068
    translate  8.04*y
  }
  object { // Cube071 -> Cube068
    Cube068
    translate  12.06*y
  }
  object { // Cube072 -> Cube068
    Cube068
    translate  16.08*y
  }
  scale 3.846154
  rotate <0.0, 0.0, -90.0>
  translate  <-11.485738, -58.66748, -1.232577>
}
#declare entrada = union {
  object { arco }
  object { vert_puerta1 }
  object { vert_puerta2 }
//  object { placapov }
  object { resto_pared }
  box { // Cube073
    <-1, -1, -1>, <1, 1, 1>
    scale <1.92308, 21.346161, 1.92308>
    rotate -90.0*z
    translate  <0.01426, 0.46204, -1.85802>
  }
  material {
    fachada_txt
  }
  hollow
  rotate <-0.0, 0.0, -0.0>
  translate  <0.000017, -2.589003, -0.000015>
}
union { // puerta_casa
//  object { fachada1 }
  object { puerta1 }
  object { placa_calle }
/*  object { // HgtFld002 -> HgtFld001
    HgtFld001
    rotate <-0.0, -0.0, -0.0>
    translate  <91.398561, 0.0, 0.0>
  }  */
  object { entrada }
  hollow
  scale 0.26
  rotate 90.0*z
  translate  <-15.926685, 2.986287, 0.320474>
}

#declare desague = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.628531, -2.153831, -2.427934>, <-0.772859, -2.153831, -2.283607>, <-0.889011, -2.153831, -2.003514>, <-0.889011, -2.153831, -1.799403>, 
      <-0.623480, -1.941295, -2.422883>, <-0.767808, -1.941295, -2.278555>, <-0.881867, -1.941295, -2.003514>, <-0.881867, -1.941295, -1.799403>, 
      <-0.628531, -1.657632, -2.427934>, <-0.772859, -1.657632, -2.283607>, <-0.889011, -1.657632, -2.003514>, <-0.889011, -1.657632, -1.799403>, 
      <-0.628531, -1.444975, -2.427934>, <-0.772859, -1.444975, -2.283607>, <-0.889011, -1.444976, -2.003514>, <-0.889011, -1.444976, -1.799403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.647970, -2.262886, -2.447374>, <-0.796762, -2.262886, -2.298582>, <-0.916507, -2.262886, -2.009827>, <-0.916507, -2.262886, -1.799403>, 
      <-0.628610, -2.243170, -2.428013>, <-0.777401, -2.243170, -2.279222>, <-0.889125, -2.243172, -2.009827>, <-0.889125, -2.243172, -1.799403>, 
      <-0.629332, -2.187552, -2.428736>, <-0.773660, -2.187552, -2.284408>, <-0.890145, -2.187553, -2.003514>, <-0.890145, -2.187553, -1.799403>, 
      <-0.628531, -2.153831, -2.427934>, <-0.772859, -2.153831, -2.283607>, <-0.889011, -2.153831, -2.003514>, <-0.889011, -2.153831, -1.799403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, -2.208359, -2.481477>, <-0.838697, -2.208359, -2.324854>, <-0.964744, -2.208359, -2.020902>, <-0.964744, -2.208359, -1.799403>, 
      <-0.680939, -2.230139, -2.480342>, <-0.837562, -2.230139, -2.323719>, <-0.963138, -2.230140, -2.020902>, <-0.963138, -2.230140, -1.799403>, 
      <-0.660502, -2.275648, -2.459905>, <-0.809293, -2.275648, -2.311113>, <-0.934231, -2.275648, -2.009827>, <-0.934231, -2.275648, -1.799403>, 
      <-0.647970, -2.262886, -2.447374>, <-0.796762, -2.262886, -2.298582>, <-0.916507, -2.262886, -2.009827>, <-0.916507, -2.262886, -1.799403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, -1.608558, -2.481477>, <-0.838697, -1.608558, -2.324854>, <-0.964744, -1.608558, -2.020902>, <-0.964744, -1.608558, -1.799403>, 
      <-0.682074, -1.788498, -2.481477>, <-0.838697, -1.788498, -2.324854>, <-0.964744, -1.788498, -2.020902>, <-0.964744, -1.788498, -1.799403>, 
      <-0.691427, -2.028905, -2.490830>, <-0.848050, -2.028905, -2.334208>, <-0.977973, -2.028906, -2.020902>, <-0.977973, -2.028906, -1.799403>, 
      <-0.682074, -2.208359, -2.481477>, <-0.838697, -2.208359, -2.324854>, <-0.964744, -2.208359, -2.020902>, <-0.964744, -2.208359, -1.799403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, -1.390448, -2.481477>, <-0.838697, -1.390448, -2.324854>, <-0.964744, -1.390448, -2.020902>, <-0.964744, -1.390448, -1.799403>, 
      <-0.682074, -1.455872, -2.482590>, <-0.838697, -1.455872, -2.325967>, <-0.964744, -1.455881, -2.020902>, <-0.964744, -1.455881, -1.799403>, 
      <-0.682074, -1.543125, -2.481477>, <-0.838697, -1.543125, -2.324854>, <-0.964744, -1.543125, -2.020902>, <-0.964744, -1.543125, -1.799403>, 
      <-0.682074, -1.608558, -2.481477>, <-0.838697, -1.608558, -2.324854>, <-0.964744, -1.608558, -2.020902>, <-0.964744, -1.608558, -1.799403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, -0.999370, -2.471115>, <-0.838697, -1.026568, -2.316871>, <-0.964744, -1.079349, -2.017536>, <-0.964744, -1.117811, -1.799403>, 
      <-0.682074, -1.114197, -2.495388>, <-0.838697, -1.141395, -2.341145>, <-0.964744, -1.159772, -2.032430>, <-0.964744, -1.198235, -1.814297>, 
      <-0.682074, -1.273101, -2.479481>, <-0.838697, -1.273101, -2.322858>, <-0.964744, -1.308657, -2.020902>, <-0.964744, -1.308657, -1.799403>, 
      <-0.682074, -1.390448, -2.481477>, <-0.838697, -1.390448, -2.324854>, <-0.964744, -1.390448, -2.020902>, <-0.964744, -1.390448, -1.799403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, -0.313292, -2.253778>, <-0.838697, -0.391603, -2.118139>, <-0.964744, -0.543580, -1.854908>, <-0.964744, -0.654329, -1.663085>, 
      <-0.682074, -0.500848, -2.360723>, <-0.838697, -0.579160, -2.225083>, <-0.964744, -0.669676, -1.926362>, <-0.964744, -0.780425, -1.734539>, 
      <-0.682074, -0.788134, -2.426462>, <-0.838697, -0.815332, -2.272218>, <-0.964744, -0.936838, -1.991145>, <-0.964744, -0.975300, -1.773012>, 
      <-0.682074, -0.999370, -2.471115>, <-0.838697, -1.026568, -2.316871>, <-0.964744, -1.079349, -2.017536>, <-0.964744, -1.117811, -1.799403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, 0.222598, -1.774349>, <-0.838697, 0.102618, -1.673674>, <-0.964744, -0.130223, -1.478297>, <-0.964744, -0.299901, -1.335921>, 
      <-0.682074, 0.088067, -1.942973>, <-0.838697, -0.031913, -1.842298>, <-0.964744, -0.219062, -1.592519>, <-0.964744, -0.388740, -1.450142>, 
      <-0.682074, -0.125900, -2.146927>, <-0.838697, -0.204211, -2.011288>, <-0.964744, -0.417685, -1.783567>, <-0.964744, -0.528434, -1.591744>, 
      <-0.682074, -0.313292, -2.253778>, <-0.838697, -0.391603, -2.118139>, <-0.964744, -0.543580, -1.854908>, <-0.964744, -0.654329, -1.663085>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, 0.559149, -1.160248>, <-0.838697, 0.411971, -1.106680>, <-0.964744, 0.126349, -1.002722>, <-0.964744, -0.081791, -0.926965>, 
      <-0.682074, 0.490922, -1.358944>, <-0.838697, 0.343745, -1.305376>, <-0.964744, 0.082379, -1.134632>, <-0.964744, -0.125761, -1.058875>, 
      <-0.682074, 0.353617, -1.610128>, <-0.838697, 0.233637, -1.509453>, <-0.964744, -0.044858, -1.368542>, <-0.964744, -0.214535, -1.226165>, 
      <-0.682074, 0.222598, -1.774349>, <-0.838697, 0.102618, -1.673674>, <-0.964744, -0.130223, -1.478297>, <-0.964744, -0.299901, -1.335921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, 0.682074, -0.436219>, <-0.838697, 0.525451, -0.436219>, <-0.964744, 0.221498, -0.436219>, <-0.964744, 0.000000, -0.436219>, 
      <-0.682074, 0.661279, -0.655552>, <-0.838697, 0.504656, -0.655552>, <-0.964744, 0.210051, -0.585034>, <-0.964744, -0.011447, -0.585034>, 
      <-0.682074, 0.630699, -0.951873>, <-0.838697, 0.483521, -0.898305>, <-0.964744, 0.173548, -0.861127>, <-0.964744, -0.034593, -0.785370>, 
      <-0.682074, 0.559149, -1.160248>, <-0.838697, 0.411971, -1.106680>, <-0.964744, 0.126349, -1.002722>, <-0.964744, -0.081791, -0.926965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, 0.682074, 0.136319>, <-0.838697, 0.525451, 0.136319>, <-0.964744, 0.221498, 0.136319>, <-0.964744, 0.000000, 0.136319>, 
      <-0.682074, 0.682074, -0.035443>, <-0.838697, 0.525451, -0.035443>, <-0.964744, 0.221498, -0.035443>, <-0.964744, 0.000000, -0.035443>, 
      <-0.682074, 0.698286, -0.265224>, <-0.838697, 0.541663, -0.265224>, <-0.964744, 0.234672, -0.264964>, <-0.964744, 0.013173, -0.264964>, 
      <-0.682074, 0.682074, -0.436219>, <-0.838697, 0.525451, -0.436219>, <-0.964744, 0.221498, -0.436219>, <-0.964744, 0.000000, -0.436219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, 0.682074, 0.654329>, <-0.838697, 0.525451, 0.654329>, <-0.964744, 0.221498, 0.654329>, <-0.964744, 0.000000, 0.654329>, 
      <-0.667768, 0.667768, 0.500248>, <-0.824391, 0.511145, 0.500248>, <-0.944510, 0.221498, 0.500249>, <-0.944510, 0.000000, 0.500249>, 
      <-0.682074, 0.682074, 0.291722>, <-0.838697, 0.525451, 0.291722>, <-0.964744, 0.221498, 0.291722>, <-0.964744, 0.000000, 0.291722>, 
      <-0.682074, 0.682074, 0.136319>, <-0.838697, 0.525451, 0.136319>, <-0.964744, 0.221498, 0.136319>, <-0.964744, 0.000000, 0.136319>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.742825, 0.742825, 0.790647>, <-0.913398, 0.572252, 0.790647>, <-1.050672, 0.241227, 0.790647>, <-1.050672, 0.000000, 0.790647>, 
      <-0.734143, 0.734143, 0.743892>, <-0.904716, 0.563570, 0.743892>, <-1.038392, 0.241227, 0.743891>, <-1.038392, 0.000000, 0.743891>, 
      <-0.686524, 0.686524, 0.702257>, <-0.843147, 0.529901, 0.702257>, <-0.971038, 0.221498, 0.702259>, <-0.971038, 0.000000, 0.702259>, 
      <-0.682074, 0.682074, 0.654329>, <-0.838697, 0.525451, 0.654329>, <-0.964744, 0.221498, 0.654329>, <-0.964744, 0.000000, 0.654329>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.720540, 0.720540, 1.772140>, <-0.885996, 0.555084, 1.772140>, <-1.019152, 0.233990, 1.772140>, <-1.019152, 0.000000, 1.772140>, 
      <-0.733900, 0.733900, 1.772140>, <-0.899356, 0.568445, 1.772140>, <-1.038047, 0.233990, 1.772140>, <-1.038047, 0.000000, 1.772140>, 
      <-0.742293, 0.742293, 1.736491>, <-0.912866, 0.571720, 1.736491>, <-1.049919, 0.241227, 1.736492>, <-1.049919, 0.000000, 1.736492>, 
      <-0.742825, 0.742825, 1.717613>, <-0.913398, 0.572252, 1.717613>, <-1.050672, 0.241227, 1.717613>, <-1.050672, 0.000000, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.698924, 0.698924, 1.717613>, <-0.859416, 0.538432, 1.717613>, <-0.988577, 0.226970, 1.717613>, <-0.988577, 0.000000, 1.717613>, 
      <-0.699496, 0.699496, 1.736349>, <-0.859988, 0.539003, 1.736349>, <-0.989386, 0.226970, 1.736349>, <-0.989386, 0.000000, 1.736349>, 
      <-0.707279, 0.707279, 1.772140>, <-0.872735, 0.541824, 1.772140>, <-1.000398, 0.233990, 1.772140>, <-1.000398, 0.000000, 1.772140>, 
      <-0.720540, 0.720540, 1.772140>, <-0.885996, 0.555084, 1.772140>, <-1.019152, 0.233990, 1.772140>, <-1.019152, 0.000000, 1.772140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.698924, 0.698924, 1.063284>, <-0.859416, 0.538432, 1.063284>, <-0.988577, 0.226970, 1.063284>, <-0.988577, 0.000000, 1.063284>, 
      <-0.698924, 0.698924, 1.259583>, <-0.859416, 0.538432, 1.259583>, <-0.988577, 0.226970, 1.259583>, <-0.988577, 0.000000, 1.259583>, 
      <-0.692944, 0.692944, 1.521496>, <-0.853436, 0.532452, 1.521496>, <-0.980118, 0.226970, 1.521496>, <-0.980118, 0.000000, 1.521496>, 
      <-0.698924, 0.698924, 1.717613>, <-0.859416, 0.538432, 1.717613>, <-0.988577, 0.226970, 1.717613>, <-0.988577, 0.000000, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.889011, -2.153831, -1.799403>, <-0.889011, -2.153831, -1.595293>, <-0.772859, -2.153831, -1.315200>, <-0.628531, -2.153831, -1.170872>, 
      <-0.881867, -1.941295, -1.799403>, <-0.881867, -1.941295, -1.595293>, <-0.767808, -1.941295, -1.320252>, <-0.623480, -1.941295, -1.175924>, 
      <-0.889011, -1.657632, -1.799403>, <-0.889011, -1.657632, -1.595293>, <-0.772859, -1.657632, -1.315200>, <-0.628531, -1.657632, -1.170872>, 
      <-0.889011, -1.444976, -1.799403>, <-0.889011, -1.444976, -1.595293>, <-0.772859, -1.444975, -1.315200>, <-0.628531, -1.444975, -1.170872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.916507, -2.262886, -1.799403>, <-0.916507, -2.262886, -1.588980>, <-0.796762, -2.262886, -1.300225>, <-0.647970, -2.262886, -1.151433>, 
      <-0.889125, -2.243172, -1.799403>, <-0.889125, -2.243172, -1.588980>, <-0.777401, -2.243170, -1.319585>, <-0.628610, -2.243170, -1.170794>, 
      <-0.890145, -2.187553, -1.799403>, <-0.890145, -2.187553, -1.595293>, <-0.773660, -2.187552, -1.314399>, <-0.629332, -2.187552, -1.170071>, 
      <-0.889011, -2.153831, -1.799403>, <-0.889011, -2.153831, -1.595293>, <-0.772859, -2.153831, -1.315200>, <-0.628531, -2.153831, -1.170872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.964744, -2.208359, -1.799403>, <-0.964744, -2.208359, -1.577905>, <-0.838697, -2.208359, -1.273953>, <-0.682074, -2.208359, -1.117330>, 
      <-0.963138, -2.230140, -1.799403>, <-0.963138, -2.230140, -1.577905>, <-0.837561, -2.230139, -1.275088>, <-0.680939, -2.230139, -1.118465>, 
      <-0.934231, -2.275648, -1.799403>, <-0.934231, -2.275648, -1.588980>, <-0.809293, -2.275648, -1.287694>, <-0.660502, -2.275648, -1.138902>, 
      <-0.916507, -2.262886, -1.799403>, <-0.916507, -2.262886, -1.588980>, <-0.796762, -2.262886, -1.300225>, <-0.647970, -2.262886, -1.151433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.964744, -1.608558, -1.799403>, <-0.964744, -1.608558, -1.577905>, <-0.838697, -1.608558, -1.273953>, <-0.682074, -1.608558, -1.117330>, 
      <-0.964744, -1.788498, -1.799403>, <-0.964744, -1.788498, -1.577905>, <-0.838697, -1.788498, -1.273953>, <-0.682074, -1.788498, -1.117330>, 
      <-0.977973, -2.028906, -1.799403>, <-0.977973, -2.028906, -1.577905>, <-0.848050, -2.028905, -1.264599>, <-0.691427, -2.028905, -1.107976>, 
      <-0.964744, -2.208359, -1.799403>, <-0.964744, -2.208359, -1.577905>, <-0.838697, -2.208359, -1.273953>, <-0.682074, -2.208359, -1.117330>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.964744, -1.390448, -1.799403>, <-0.964744, -1.390448, -1.577905>, <-0.838697, -1.390448, -1.273953>, <-0.682074, -1.390448, -1.117330>, 
      <-0.964744, -1.455881, -1.799403>, <-0.964744, -1.455881, -1.577905>, <-0.838697, -1.455856, -1.272132>, <-0.682074, -1.455856, -1.115509>, 
      <-0.964744, -1.543125, -1.799403>, <-0.964744, -1.543125, -1.577905>, <-0.838697, -1.543125, -1.273953>, <-0.682074, -1.543125, -1.117330>, 
      <-0.964744, -1.608558, -1.799403>, <-0.964744, -1.608558, -1.577905>, <-0.838697, -1.608558, -1.273953>, <-0.682074, -1.608558, -1.117330>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.964744, -1.117811, -1.799403>, <-0.964744, -1.156274, -1.581270>, <-0.838697, -1.209055, -1.281935>, <-0.682074, -1.236252, -1.127692>, 
      <-0.964744, -1.198235, -1.814297>, <-0.964744, -1.236698, -1.596164>, <-0.838697, -1.255121, -1.287175>, <-0.682074, -1.282318, -1.132932>, 
      <-0.964744, -1.308657, -1.799403>, <-0.964744, -1.308657, -1.577905>, <-0.838697, -1.344103, -1.275242>, <-0.682074, -1.344103, -1.118619>, 
      <-0.964744, -1.390448, -1.799403>, <-0.964744, -1.390448, -1.577905>, <-0.838697, -1.390448, -1.273953>, <-0.682074, -1.390448, -1.117330>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.964744, -0.654329, -1.663085>, <-0.964744, -0.765078, -1.471262>, <-0.838697, -0.917054, -1.208031>, <-0.682074, -0.995366, -1.072392>, 
      <-0.964744, -0.780425, -1.734539>, <-0.964744, -0.891174, -1.542716>, <-0.838697, -0.981851, -1.244073>, <-0.682074, -1.060162, -1.108434>, 
      <-0.964744, -0.975300, -1.773012>, <-0.964744, -1.013763, -1.554879>, <-0.838697, -1.135384, -1.273556>, <-0.682074, -1.162581, -1.119312>, 
      <-0.964744, -1.117811, -1.799403>, <-0.964744, -1.156274, -1.581270>, <-0.838697, -1.209055, -1.281935>, <-0.682074, -1.236252, -1.127692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.964744, -0.299901, -1.335921>, <-0.964744, -0.469578, -1.193544>, <-0.838697, -0.702419, -0.998167>, <-0.682074, -0.822399, -0.897492>, 
      <-0.964744, -0.388740, -1.450142>, <-0.964744, -0.558417, -1.307766>, <-0.838697, -0.745534, -1.058057>, <-0.682074, -0.865514, -0.957382>, 
      <-0.964744, -0.528434, -1.591744>, <-0.964744, -0.639183, -1.399921>, <-0.838697, -0.852565, -1.172160>, <-0.682074, -0.930876, -1.036520>, 
      <-0.964744, -0.654329, -1.663085>, <-0.964744, -0.765078, -1.471262>, <-0.838697, -0.917054, -1.208031>, <-0.682074, -0.995366, -1.072392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.964744, -0.081791, -0.926965>, <-0.964744, -0.289931, -0.851209>, <-0.838697, -0.575554, -0.747251>, <-0.682074, -0.722731, -0.693682>, 
      <-0.964744, -0.125761, -1.058875>, <-0.964744, -0.333901, -0.983118>, <-0.838697, -0.595363, -0.812367>, <-0.682074, -0.742540, -0.758798>, 
      <-0.964744, -0.214535, -1.226165>, <-0.964744, -0.384213, -1.083789>, <-0.838697, -0.662654, -0.942930>, <-0.682074, -0.782634, -0.842255>, 
      <-0.964744, -0.299901, -1.335921>, <-0.964744, -0.469578, -1.193544>, <-0.838697, -0.702419, -0.998167>, <-0.682074, -0.822399, -0.897492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.964744, 0.000000, -0.436219>, <-0.964744, -0.221498, -0.436219>, <-0.838697, -0.525451, -0.436219>, <-0.682074, -0.682074, -0.436219>, 
      <-0.964744, -0.011447, -0.585034>, <-0.964744, -0.232946, -0.585034>, <-0.838697, -0.529277, -0.514321>, <-0.682074, -0.685900, -0.514321>, 
      <-0.964744, -0.034593, -0.785370>, <-0.964744, -0.242733, -0.709613>, <-0.838697, -0.552795, -0.672439>, <-0.682074, -0.699972, -0.618871>, 
      <-0.964744, -0.081791, -0.926965>, <-0.964744, -0.289931, -0.851209>, <-0.838697, -0.575554, -0.747251>, <-0.682074, -0.722731, -0.693682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.964744, 0.000000, 0.136319>, <-0.964744, -0.221498, 0.136319>, <-0.838697, -0.525451, 0.136319>, <-0.682074, -0.682074, 0.136319>, 
      <-0.964744, 0.000000, -0.035443>, <-0.964744, -0.221498, -0.035443>, <-0.838697, -0.525451, -0.035443>, <-0.682074, -0.682074, -0.035443>, 
      <-0.964744, 0.013173, -0.264964>, <-0.964744, -0.208325, -0.264964>, <-0.838697, -0.517047, -0.264663>, <-0.682074, -0.673670, -0.264663>, 
      <-0.964744, 0.000000, -0.436219>, <-0.964744, -0.221498, -0.436219>, <-0.838697, -0.525451, -0.436219>, <-0.682074, -0.682074, -0.436219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.964744, 0.000000, 0.654329>, <-0.964744, -0.221498, 0.654329>, <-0.838697, -0.525451, 0.654329>, <-0.682074, -0.682074, 0.654329>, 
      <-0.944510, 0.000000, 0.500249>, <-0.944510, -0.221498, 0.500249>, <-0.824391, -0.511145, 0.500248>, <-0.667768, -0.667768, 0.500248>, 
      <-0.964744, 0.000000, 0.291722>, <-0.964744, -0.221498, 0.291722>, <-0.838697, -0.525451, 0.291722>, <-0.682074, -0.682074, 0.291722>, 
      <-0.964744, 0.000000, 0.136319>, <-0.964744, -0.221498, 0.136319>, <-0.838697, -0.525451, 0.136319>, <-0.682074, -0.682074, 0.136319>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.050672, 0.000000, 0.790647>, <-1.050672, -0.241227, 0.790647>, <-0.913398, -0.572252, 0.790647>, <-0.742825, -0.742825, 0.790647>, 
      <-1.038392, 0.000000, 0.743891>, <-1.038392, -0.241227, 0.743891>, <-0.904716, -0.563570, 0.743892>, <-0.734143, -0.734143, 0.743892>, 
      <-0.971038, 0.000000, 0.702259>, <-0.971038, -0.221498, 0.702259>, <-0.843147, -0.529901, 0.702257>, <-0.686524, -0.686524, 0.702257>, 
      <-0.964744, 0.000000, 0.654329>, <-0.964744, -0.221498, 0.654329>, <-0.838697, -0.525451, 0.654329>, <-0.682074, -0.682074, 0.654329>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.019152, 0.000000, 1.772140>, <-1.019152, -0.233990, 1.772140>, <-0.885996, -0.555084, 1.772140>, <-0.720540, -0.720540, 1.772140>, 
      <-1.038047, 0.000000, 1.772140>, <-1.038047, -0.233990, 1.772140>, <-0.899356, -0.568445, 1.772140>, <-0.733900, -0.733900, 1.772140>, 
      <-1.049919, 0.000000, 1.736492>, <-1.049919, -0.241227, 1.736492>, <-0.912866, -0.571720, 1.736491>, <-0.742293, -0.742293, 1.736491>, 
      <-1.050672, 0.000000, 1.717613>, <-1.050672, -0.241227, 1.717613>, <-0.913398, -0.572252, 1.717613>, <-0.742825, -0.742825, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.988577, 0.000000, 1.717613>, <-0.988577, -0.226970, 1.717613>, <-0.859416, -0.538432, 1.717613>, <-0.698924, -0.698924, 1.717613>, 
      <-0.989386, 0.000000, 1.736349>, <-0.989386, -0.226970, 1.736349>, <-0.859988, -0.539003, 1.736349>, <-0.699496, -0.699496, 1.736349>, 
      <-1.000398, 0.000000, 1.772140>, <-1.000398, -0.233990, 1.772140>, <-0.872735, -0.541824, 1.772140>, <-0.707279, -0.707279, 1.772140>, 
      <-1.019152, 0.000000, 1.772140>, <-1.019152, -0.233990, 1.772140>, <-0.885996, -0.555084, 1.772140>, <-0.720540, -0.720540, 1.772140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.988577, 0.000000, 1.063284>, <-0.988577, -0.226970, 1.063284>, <-0.859416, -0.538432, 1.063284>, <-0.698924, -0.698924, 1.063284>, 
      <-0.988577, 0.000000, 1.259583>, <-0.988577, -0.226970, 1.259583>, <-0.859416, -0.538432, 1.259583>, <-0.698924, -0.698924, 1.259583>, 
      <-0.980118, 0.000000, 1.521496>, <-0.980118, -0.226970, 1.521496>, <-0.853436, -0.532452, 1.521496>, <-0.692944, -0.692944, 1.521496>, 
      <-0.988577, 0.000000, 1.717613>, <-0.988577, -0.226970, 1.717613>, <-0.859416, -0.538432, 1.717613>, <-0.698924, -0.698924, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.628531, -2.153831, -1.170872>, <-0.484203, -2.153831, -1.026545>, <-0.204111, -2.153831, -0.910392>, <0.000000, -2.153831, -0.910392>, 
      <-0.623480, -1.941295, -1.175924>, <-0.479152, -1.941295, -1.031596>, <-0.204111, -1.941295, -0.917537>, <0.000000, -1.941295, -0.917537>, 
      <-0.628531, -1.657632, -1.170872>, <-0.484203, -1.657632, -1.026545>, <-0.204111, -1.657632, -0.910392>, <0.000000, -1.657632, -0.910392>, 
      <-0.628531, -1.444975, -1.170872>, <-0.484203, -1.444975, -1.026545>, <-0.204111, -1.444975, -0.910392>, <0.000000, -1.444975, -0.910392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.647970, -2.262886, -1.151433>, <-0.499178, -2.262886, -1.002642>, <-0.210423, -2.262886, -0.882897>, <0.000000, -2.262886, -0.882897>, 
      <-0.628610, -2.243170, -1.170794>, <-0.479818, -2.243170, -1.022002>, <-0.210423, -2.243171, -0.910278>, <0.000000, -2.243171, -0.910278>, 
      <-0.629332, -2.187552, -1.170071>, <-0.485005, -2.187552, -1.025743>, <-0.204111, -2.187552, -0.909258>, <0.000000, -2.187552, -0.909258>, 
      <-0.628531, -2.153831, -1.170872>, <-0.484203, -2.153831, -1.026545>, <-0.204111, -2.153831, -0.910392>, <0.000000, -2.153831, -0.910392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, -2.208359, -1.117330>, <-0.525451, -2.208359, -0.960707>, <-0.221498, -2.208359, -0.834660>, <0.000000, -2.208359, -0.834660>, 
      <-0.680939, -2.230139, -1.118465>, <-0.524316, -2.230139, -0.961842>, <-0.221498, -2.230140, -0.836265>, <0.000000, -2.230140, -0.836265>, 
      <-0.660502, -2.275648, -1.138902>, <-0.511710, -2.275648, -0.990110>, <-0.210423, -2.275648, -0.865173>, <0.000000, -2.275648, -0.865173>, 
      <-0.647970, -2.262886, -1.151433>, <-0.499178, -2.262886, -1.002642>, <-0.210423, -2.262886, -0.882897>, <0.000000, -2.262886, -0.882897>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, -1.608558, -1.117330>, <-0.525451, -1.608558, -0.960707>, <-0.221498, -1.608558, -0.834660>, <0.000000, -1.608558, -0.834660>, 
      <-0.682074, -1.788498, -1.117330>, <-0.525451, -1.788498, -0.960707>, <-0.221498, -1.788498, -0.834660>, <0.000000, -1.788498, -0.834660>, 
      <-0.691427, -2.028905, -1.107976>, <-0.534804, -2.028905, -0.951353>, <-0.221498, -2.028905, -0.821430>, <0.000000, -2.028905, -0.821430>, 
      <-0.682074, -2.208359, -1.117330>, <-0.525451, -2.208359, -0.960707>, <-0.221498, -2.208359, -0.834660>, <0.000000, -2.208359, -0.834660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, -1.390448, -1.117330>, <-0.525451, -1.390448, -0.960707>, <-0.221498, -1.390448, -0.834660>, <0.000000, -1.390448, -0.834660>, 
      <-0.682074, -1.455856, -1.115509>, <-0.525451, -1.455856, -0.958886>, <-0.221498, -1.455814, -0.831696>, <0.000000, -1.455814, -0.831696>, 
      <-0.682074, -1.543125, -1.117330>, <-0.525451, -1.543125, -0.960707>, <-0.221498, -1.543125, -0.834660>, <0.000000, -1.543125, -0.834660>, 
      <-0.682074, -1.608558, -1.117330>, <-0.525451, -1.608558, -0.960707>, <-0.221498, -1.608558, -0.834660>, <0.000000, -1.608558, -0.834660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, -1.236252, -1.127692>, <-0.525451, -1.263449, -0.973448>, <-0.221498, -1.285337, -0.849316>, <0.000000, -1.285337, -0.849316>, 
      <-0.682074, -1.282318, -1.132932>, <-0.525451, -1.309516, -0.978688>, <-0.221498, -1.317163, -0.850202>, <0.000000, -1.317163, -0.850202>, 
      <-0.682074, -1.344103, -1.118619>, <-0.525451, -1.344103, -0.961997>, <-0.221498, -1.358643, -0.836102>, <0.000000, -1.358643, -0.836102>, 
      <-0.682074, -1.390448, -1.117330>, <-0.525451, -1.390448, -0.960707>, <-0.221498, -1.390448, -0.834660>, <0.000000, -1.390448, -0.834660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, -0.995366, -1.072392>, <-0.525451, -1.073677, -0.936752>, <-0.221498, -1.136700, -0.827592>, <0.000000, -1.136700, -0.827592>, 
      <-0.682074, -1.060162, -1.108434>, <-0.525451, -1.138473, -0.972794>, <-0.221498, -1.176322, -0.849062>, <0.000000, -1.176322, -0.849062>, 
      <-0.682074, -1.162581, -1.119312>, <-0.525451, -1.189779, -0.965069>, <-0.221498, -1.240290, -0.848061>, <0.000000, -1.240290, -0.848061>, 
      <-0.682074, -1.236252, -1.127692>, <-0.525451, -1.263449, -0.973448>, <-0.221498, -1.285337, -0.849316>, <0.000000, -1.285337, -0.849316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, -0.822399, -0.897492>, <-0.525451, -0.942380, -0.796817>, <-0.221498, -1.038937, -0.715795>, <0.000000, -1.038937, -0.715795>, 
      <-0.682074, -0.865514, -0.957382>, <-0.525451, -0.985494, -0.856706>, <-0.221498, -1.063043, -0.753265>, <0.000000, -1.063043, -0.753265>, 
      <-0.682074, -0.930876, -1.036520>, <-0.525451, -1.009187, -0.900881>, <-0.221498, -1.097528, -0.806365>, <0.000000, -1.097528, -0.806365>, 
      <-0.682074, -0.995366, -1.072392>, <-0.525451, -1.073677, -0.936752>, <-0.221498, -1.136700, -0.827592>, <0.000000, -1.136700, -0.827592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, -0.722731, -0.693682>, <-0.525451, -0.869908, -0.640114>, <-0.221498, -0.988354, -0.597004>, <0.000000, -0.988354, -0.597004>, 
      <-0.682074, -0.742540, -0.758798>, <-0.525451, -0.889717, -0.705230>, <-0.221498, -0.998289, -0.634442>, <0.000000, -0.998289, -0.634442>, 
      <-0.682074, -0.782634, -0.842255>, <-0.525451, -0.902614, -0.741579>, <-0.221498, -1.017981, -0.683220>, <0.000000, -1.017981, -0.683220>, 
      <-0.682074, -0.822399, -0.897492>, <-0.525451, -0.942380, -0.796817>, <-0.221498, -1.038937, -0.715795>, <0.000000, -1.038937, -0.715795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, -0.682074, -0.436219>, <-0.525451, -0.838697, -0.436219>, <-0.221498, -0.964744, -0.436219>, <0.000000, -0.964744, -0.436219>, 
      <-0.682074, -0.685900, -0.514321>, <-0.525451, -0.842522, -0.514321>, <-0.221498, -0.966313, -0.484946>, <0.000000, -0.966313, -0.484946>, 
      <-0.682074, -0.699972, -0.618871>, <-0.525451, -0.847150, -0.565303>, <-0.221498, -0.975849, -0.549882>, <0.000000, -0.975849, -0.549882>, 
      <-0.682074, -0.722731, -0.693682>, <-0.525451, -0.869908, -0.640114>, <-0.221498, -0.988354, -0.597004>, <0.000000, -0.988354, -0.597004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, -0.682074, 0.136319>, <-0.525451, -0.838697, 0.136319>, <-0.221498, -0.964744, 0.136319>, <0.000000, -0.964744, 0.136319>, 
      <-0.682074, -0.682074, -0.035443>, <-0.525451, -0.838697, -0.035443>, <-0.221498, -0.964744, -0.035443>, <0.000000, -0.964744, -0.035443>, 
      <-0.682074, -0.673670, -0.264663>, <-0.525451, -0.830293, -0.264663>, <-0.221498, -0.959217, -0.264547>, <0.000000, -0.959217, -0.264547>, 
      <-0.682074, -0.682074, -0.436219>, <-0.525451, -0.838697, -0.436219>, <-0.221498, -0.964744, -0.436219>, <0.000000, -0.964744, -0.436219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682074, -0.682074, 0.654329>, <-0.525451, -0.838697, 0.654329>, <-0.221498, -0.964744, 0.654329>, <0.000000, -0.964744, 0.654329>, 
      <-0.667768, -0.667768, 0.500248>, <-0.511145, -0.824391, 0.500248>, <-0.221498, -0.944510, 0.500249>, <0.000000, -0.944510, 0.500249>, 
      <-0.682074, -0.682074, 0.291722>, <-0.525451, -0.838697, 0.291722>, <-0.221498, -0.964744, 0.291722>, <0.000000, -0.964744, 0.291722>, 
      <-0.682074, -0.682074, 0.136319>, <-0.525451, -0.838697, 0.136319>, <-0.221498, -0.964744, 0.136319>, <0.000000, -0.964744, 0.136319>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.742825, -0.742825, 0.790647>, <-0.572252, -0.913398, 0.790647>, <-0.241227, -1.050672, 0.790647>, <0.000000, -1.050672, 0.790647>, 
      <-0.734143, -0.734143, 0.743892>, <-0.563570, -0.904716, 0.743892>, <-0.241227, -1.038392, 0.743891>, <0.000000, -1.038392, 0.743891>, 
      <-0.686524, -0.686524, 0.702257>, <-0.529901, -0.843147, 0.702257>, <-0.221498, -0.971038, 0.702259>, <0.000000, -0.971038, 0.702259>, 
      <-0.682074, -0.682074, 0.654329>, <-0.525451, -0.838697, 0.654329>, <-0.221498, -0.964744, 0.654329>, <0.000000, -0.964744, 0.654329>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.720540, -0.720540, 1.772140>, <-0.555084, -0.885996, 1.772140>, <-0.233990, -1.019152, 1.772140>, <0.000000, -1.019152, 1.772140>, 
      <-0.733900, -0.733900, 1.772140>, <-0.568445, -0.899356, 1.772140>, <-0.233990, -1.038047, 1.772140>, <0.000000, -1.038047, 1.772140>, 
      <-0.742293, -0.742293, 1.736491>, <-0.571720, -0.912866, 1.736491>, <-0.241227, -1.049919, 1.736492>, <0.000000, -1.049919, 1.736492>, 
      <-0.742825, -0.742825, 1.717613>, <-0.572252, -0.913398, 1.717613>, <-0.241227, -1.050672, 1.717613>, <0.000000, -1.050672, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.698924, -0.698924, 1.717613>, <-0.538432, -0.859416, 1.717613>, <-0.226970, -0.988577, 1.717613>, <0.000000, -0.988577, 1.717613>, 
      <-0.699496, -0.699496, 1.736349>, <-0.539003, -0.859988, 1.736349>, <-0.226970, -0.989386, 1.736349>, <0.000000, -0.989386, 1.736349>, 
      <-0.707279, -0.707279, 1.772140>, <-0.541824, -0.872735, 1.772140>, <-0.233990, -1.000398, 1.772140>, <0.000000, -1.000398, 1.772140>, 
      <-0.720540, -0.720540, 1.772140>, <-0.555084, -0.885996, 1.772140>, <-0.233990, -1.019152, 1.772140>, <0.000000, -1.019152, 1.772140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.698924, -0.698924, 1.063284>, <-0.538432, -0.859416, 1.063284>, <-0.226970, -0.988577, 1.063284>, <0.000000, -0.988577, 1.063284>, 
      <-0.698924, -0.698924, 1.259583>, <-0.538432, -0.859416, 1.259583>, <-0.226970, -0.988577, 1.259583>, <0.000000, -0.988577, 1.259583>, 
      <-0.692944, -0.692944, 1.521496>, <-0.532452, -0.853436, 1.521496>, <-0.226970, -0.980118, 1.521496>, <0.000000, -0.980118, 1.521496>, 
      <-0.698924, -0.698924, 1.717613>, <-0.538432, -0.859416, 1.717613>, <-0.226970, -0.988577, 1.717613>, <0.000000, -0.988577, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.153831, -0.910392>, <0.204111, -2.153831, -0.910392>, <0.484203, -2.153831, -1.026545>, <0.628531, -2.153831, -1.170872>, 
      <0.000000, -1.941295, -0.917537>, <0.204111, -1.941295, -0.917537>, <0.479152, -1.941295, -1.031596>, <0.623480, -1.941295, -1.175924>, 
      <0.000000, -1.657632, -0.910392>, <0.204111, -1.657632, -0.910392>, <0.484203, -1.657632, -1.026545>, <0.628531, -1.657632, -1.170872>, 
      <0.000000, -1.444975, -0.910392>, <0.204111, -1.444975, -0.910392>, <0.484203, -1.444975, -1.026545>, <0.628531, -1.444975, -1.170872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.262886, -0.882897>, <0.210423, -2.262886, -0.882897>, <0.499178, -2.262886, -1.002642>, <0.647970, -2.262886, -1.151433>, 
      <0.000000, -2.243171, -0.910278>, <0.210423, -2.243171, -0.910278>, <0.479818, -2.243170, -1.022002>, <0.628610, -2.243170, -1.170794>, 
      <0.000000, -2.187552, -0.909258>, <0.204111, -2.187552, -0.909258>, <0.485005, -2.187552, -1.025743>, <0.629332, -2.187552, -1.170071>, 
      <0.000000, -2.153831, -0.910392>, <0.204111, -2.153831, -0.910392>, <0.484203, -2.153831, -1.026545>, <0.628531, -2.153831, -1.170872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.208359, -0.834660>, <0.221498, -2.208359, -0.834660>, <0.525451, -2.208359, -0.960707>, <0.682074, -2.208359, -1.117330>, 
      <0.000000, -2.230140, -0.836265>, <0.221498, -2.230140, -0.836265>, <0.524316, -2.230139, -0.961842>, <0.680939, -2.230139, -1.118465>, 
      <0.000000, -2.275648, -0.865173>, <0.210423, -2.275648, -0.865173>, <0.511710, -2.275648, -0.990110>, <0.660502, -2.275648, -1.138902>, 
      <0.000000, -2.262886, -0.882897>, <0.210423, -2.262886, -0.882897>, <0.499178, -2.262886, -1.002642>, <0.647970, -2.262886, -1.151433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.608558, -0.834660>, <0.221498, -1.608558, -0.834660>, <0.525451, -1.608558, -0.960707>, <0.682074, -1.608558, -1.117330>, 
      <0.000000, -1.788498, -0.834660>, <0.221498, -1.788498, -0.834660>, <0.525451, -1.788498, -0.960707>, <0.682074, -1.788498, -1.117330>, 
      <0.000000, -2.028905, -0.821430>, <0.221498, -2.028905, -0.821430>, <0.534804, -2.028905, -0.951353>, <0.691427, -2.028905, -1.107976>, 
      <0.000000, -2.208359, -0.834660>, <0.221498, -2.208359, -0.834660>, <0.525451, -2.208359, -0.960707>, <0.682074, -2.208359, -1.117330>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.390448, -0.834660>, <0.221498, -1.390448, -0.834660>, <0.525451, -1.390448, -0.960707>, <0.682074, -1.390448, -1.117330>, 
      <0.000000, -1.455814, -0.831696>, <0.221498, -1.455814, -0.831696>, <0.525451, -1.455856, -0.958886>, <0.682074, -1.455856, -1.115509>, 
      <0.000000, -1.543125, -0.834660>, <0.221498, -1.543125, -0.834660>, <0.525451, -1.543125, -0.960707>, <0.682074, -1.543125, -1.117330>, 
      <0.000000, -1.608558, -0.834660>, <0.221498, -1.608558, -0.834660>, <0.525451, -1.608558, -0.960707>, <0.682074, -1.608558, -1.117330>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.285337, -0.849316>, <0.221498, -1.285337, -0.849316>, <0.525451, -1.263449, -0.973448>, <0.682074, -1.236252, -1.127692>, 
      <0.000000, -1.317163, -0.850202>, <0.221498, -1.317163, -0.850202>, <0.525451, -1.309516, -0.978688>, <0.682074, -1.282318, -1.132932>, 
      <0.000000, -1.358643, -0.836102>, <0.221498, -1.358643, -0.836102>, <0.525451, -1.344103, -0.961997>, <0.682074, -1.344103, -1.118619>, 
      <0.000000, -1.390448, -0.834660>, <0.221498, -1.390448, -0.834660>, <0.525451, -1.390448, -0.960707>, <0.682074, -1.390448, -1.117330>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.136700, -0.827592>, <0.221498, -1.136700, -0.827592>, <0.525451, -1.073677, -0.936752>, <0.682074, -0.995366, -1.072392>, 
      <0.000000, -1.176322, -0.849062>, <0.221498, -1.176322, -0.849062>, <0.525451, -1.138473, -0.972794>, <0.682074, -1.060162, -1.108434>, 
      <0.000000, -1.240290, -0.848061>, <0.221498, -1.240290, -0.848061>, <0.525451, -1.189779, -0.965069>, <0.682074, -1.162581, -1.119312>, 
      <0.000000, -1.285337, -0.849316>, <0.221498, -1.285337, -0.849316>, <0.525451, -1.263449, -0.973448>, <0.682074, -1.236252, -1.127692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.038937, -0.715795>, <0.221498, -1.038937, -0.715795>, <0.525451, -0.942380, -0.796817>, <0.682074, -0.822399, -0.897492>, 
      <0.000000, -1.063043, -0.753265>, <0.221498, -1.063043, -0.753265>, <0.525451, -0.985494, -0.856706>, <0.682074, -0.865514, -0.957382>, 
      <0.000000, -1.097528, -0.806365>, <0.221498, -1.097528, -0.806365>, <0.525451, -1.009187, -0.900881>, <0.682074, -0.930876, -1.036520>, 
      <0.000000, -1.136700, -0.827592>, <0.221498, -1.136700, -0.827592>, <0.525451, -1.073677, -0.936752>, <0.682074, -0.995366, -1.072392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.988354, -0.597004>, <0.221498, -0.988354, -0.597004>, <0.525451, -0.869908, -0.640114>, <0.682074, -0.722731, -0.693682>, 
      <0.000000, -0.998289, -0.634442>, <0.221498, -0.998289, -0.634442>, <0.525451, -0.889717, -0.705230>, <0.682074, -0.742540, -0.758798>, 
      <0.000000, -1.017981, -0.683220>, <0.221498, -1.017981, -0.683220>, <0.525451, -0.902614, -0.741579>, <0.682074, -0.782634, -0.842255>, 
      <0.000000, -1.038937, -0.715795>, <0.221498, -1.038937, -0.715795>, <0.525451, -0.942380, -0.796817>, <0.682074, -0.822399, -0.897492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.964744, -0.436219>, <0.221498, -0.964744, -0.436219>, <0.525451, -0.838697, -0.436219>, <0.682074, -0.682074, -0.436219>, 
      <0.000000, -0.966313, -0.484946>, <0.221498, -0.966313, -0.484946>, <0.525451, -0.842522, -0.514321>, <0.682074, -0.685900, -0.514321>, 
      <0.000000, -0.975849, -0.549882>, <0.221498, -0.975849, -0.549882>, <0.525451, -0.847150, -0.565303>, <0.682074, -0.699972, -0.618871>, 
      <0.000000, -0.988354, -0.597004>, <0.221498, -0.988354, -0.597004>, <0.525451, -0.869908, -0.640114>, <0.682074, -0.722731, -0.693682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.964744, 0.136319>, <0.221498, -0.964744, 0.136319>, <0.525451, -0.838697, 0.136319>, <0.682074, -0.682074, 0.136319>, 
      <0.000000, -0.964744, -0.035443>, <0.221498, -0.964744, -0.035443>, <0.525451, -0.838697, -0.035443>, <0.682074, -0.682074, -0.035443>, 
      <0.000000, -0.959217, -0.264547>, <0.221498, -0.959217, -0.264547>, <0.525451, -0.830293, -0.264663>, <0.682074, -0.673670, -0.264663>, 
      <0.000000, -0.964744, -0.436219>, <0.221498, -0.964744, -0.436219>, <0.525451, -0.838697, -0.436219>, <0.682074, -0.682074, -0.436219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.964744, 0.654329>, <0.221498, -0.964744, 0.654329>, <0.525451, -0.838697, 0.654329>, <0.682074, -0.682074, 0.654329>, 
      <0.000000, -0.944510, 0.500249>, <0.221498, -0.944510, 0.500249>, <0.511145, -0.824391, 0.500248>, <0.667768, -0.667768, 0.500248>, 
      <0.000000, -0.964744, 0.291722>, <0.221498, -0.964744, 0.291722>, <0.525451, -0.838697, 0.291722>, <0.682074, -0.682074, 0.291722>, 
      <0.000000, -0.964744, 0.136319>, <0.221498, -0.964744, 0.136319>, <0.525451, -0.838697, 0.136319>, <0.682074, -0.682074, 0.136319>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.050672, 0.790647>, <0.241227, -1.050672, 0.790647>, <0.572252, -0.913398, 0.790647>, <0.742825, -0.742825, 0.790647>, 
      <0.000000, -1.038392, 0.743891>, <0.241227, -1.038392, 0.743891>, <0.563570, -0.904716, 0.743892>, <0.734143, -0.734143, 0.743892>, 
      <0.000000, -0.971038, 0.702259>, <0.221498, -0.971038, 0.702259>, <0.529901, -0.843147, 0.702257>, <0.686524, -0.686524, 0.702257>, 
      <0.000000, -0.964744, 0.654329>, <0.221498, -0.964744, 0.654329>, <0.525451, -0.838697, 0.654329>, <0.682074, -0.682074, 0.654329>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.019152, 1.772140>, <0.233990, -1.019152, 1.772140>, <0.555084, -0.885996, 1.772140>, <0.720540, -0.720540, 1.772140>, 
      <0.000000, -1.038047, 1.772140>, <0.233990, -1.038047, 1.772140>, <0.568445, -0.899356, 1.772140>, <0.733900, -0.733900, 1.772140>, 
      <0.000000, -1.049919, 1.736492>, <0.241227, -1.049919, 1.736492>, <0.571720, -0.912866, 1.736491>, <0.742293, -0.742293, 1.736491>, 
      <0.000000, -1.050672, 1.717613>, <0.241227, -1.050672, 1.717613>, <0.572252, -0.913398, 1.717613>, <0.742825, -0.742825, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.988577, 1.717613>, <0.226970, -0.988577, 1.717613>, <0.538432, -0.859416, 1.717613>, <0.698924, -0.698924, 1.717613>, 
      <0.000000, -0.989386, 1.736349>, <0.226970, -0.989386, 1.736349>, <0.539003, -0.859988, 1.736349>, <0.699496, -0.699496, 1.736349>, 
      <0.000000, -1.000398, 1.772140>, <0.233990, -1.000398, 1.772140>, <0.541824, -0.872735, 1.772140>, <0.707279, -0.707279, 1.772140>, 
      <0.000000, -1.019152, 1.772140>, <0.233990, -1.019152, 1.772140>, <0.555084, -0.885996, 1.772140>, <0.720540, -0.720540, 1.772140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.988577, 1.063284>, <0.226970, -0.988577, 1.063284>, <0.538432, -0.859416, 1.063284>, <0.698924, -0.698924, 1.063284>, 
      <0.000000, -0.988577, 1.259583>, <0.226970, -0.988577, 1.259583>, <0.538432, -0.859416, 1.259583>, <0.698924, -0.698924, 1.259583>, 
      <0.000000, -0.980118, 1.521496>, <0.226970, -0.980118, 1.521496>, <0.532452, -0.853436, 1.521496>, <0.692944, -0.692944, 1.521496>, 
      <0.000000, -0.988577, 1.717613>, <0.226970, -0.988577, 1.717613>, <0.538432, -0.859416, 1.717613>, <0.698924, -0.698924, 1.717613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.628531, -2.153831, -1.170872>, <0.772859, -2.153831, -1.315200>, <0.889011, -2.153831, -1.595293>, <0.889011, -2.153831, -1.799403>, 
      <0.623480, -1.941295, -1.175924>, <0.767808, -1.941295, -1.320252>, <0.881867, -1.941295, -1.595293>, <0.881867, -1.941295, -1.799403>, 
      <0.628531, -1.657632, -1.170872>, <0.772859, -1.657632, -1.315200>, <0.889011, -1.657632, -1.595293>, <0.889011, -1.657632, -1.799403>, 
      <0.628531, -1.444975, -1.170872>, <0.772859, -1.444975, -1.315200>, <0.889011, -1.444976, -1.595293>, <0.889011, -1.444976, -1.799403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.647970, -2.262886, -1.151433>, <0.796762, -2.262886, -1.300225>, <0.916507, -2.262886, -1.588980>, <0.916507, -2.262886, -1.799403>, 
      <0.628610, -2.243170, -1.170794>, <0.777401, -2.243170, -1.319585>, <0.889125, -2.243172, -1.588980>, <0.889125, -2.243172, -1.799403>, 
      <0.629332, -2.187552, -1.170071>, <0.773660, -2.187552, -1.314399>, <0.890145, -2.187553, -1.595293>, <0.890145, -2.187553, -1.799403>, 
      <0.628531, -2.153831, -1.170872>, <0.772859, -2.153831, -1.315200>, <0.889011, -2.153831, -1.595293>, <0.889011, -2.153831, -1.799403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.682074, -2.208359, -1.117330>, <0.838697, -2.208359, -1.273953>, <0.964744, -2.208359, -1.577905>, <0.964744, -2.208359, -1.799403>, 
      <0.680939, -2.230139, -1.118465>, <0.837561, -2.230139, -1.275088>, <0.963138, -2.230140, -1.577905>, <0.963138, -2.230140, -1.799403>, 
      <0.660502, -2.275648, -1.138902>, <0.809293, -2.275648, -1.287694>, <0.934231, -2.275648, -1.588980>, <0.934231, -2.275648, -1.799403>, 
      <0.647970, -2.262886, -1.151433>, <0.796762, -2.262886, -1.300225>, <0.916507, -2.262886, -1.588980>, <0.916507, -2.262886, -1.799403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.682074, -1.608558, -1.117330>, <0.838697, -1.608558, -1.273953>, <0.964744, -1.608558, -1.577905>, <0.964744, -1.608558, -1.799403>, 
      <0.682074, -1.788498, -1.117330>, <0.838697, -1.788498, -1.273953>, <0.964744, -1.788498, -1.577905>, <0.964744, -1.788498, -1.799403>, 
      <0.691427, -2.028905, -1.107976>, <0.848050, -2.028905, -1.264599>, <0.977973, -2.028906, -1.577905>, <0.977973, -2.028906, -1.799403>, 
      <0.682074, -2.208359, -1.117330>, <0.838697, -2.208359, -1.273953>, <0.964744, -2.208359, -1.577905>, <0.964744, -2.208359, -1.799403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.682074, -1.390448, -1.117330>, <0.838697, -1.390448, -1.273953>, <0.964744, -1.390448, -1.577905>, <0.964744, -1.390448, -1.799403>, 
      <0.682074, -1.455856, -1.115509>, <0.838697, -1.455856, -1.272132>, <0.964744, -1.455881, -1.577905>, <0.964744, -1.455881, -1.799403>, 
      <0.682074, -1.543125, -1.117330>, <0.838697, -1.543125, -1.273953>, <0.964744, -1.543125, -1.577905>, <0.964744, -1.543125, -1.799403>, 
      <0.682074, -1.608558, -1.117330>, <0.838697, -1.608558, -1.273953>, <0.964744, -1.608558, -1.577905>, <0.964744, -1.608558, -1.799403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.682074, -1.236252, -1.1