// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio http://www.kurtz-fernhout.com

#declare GrassyClump = union {
	union { // Internode
		cylinder { <0.0, 0.0, 0.0>, <-0.00002451, 0.001866, -0.00003871>, 0.001974 }
		cylinder { <-0.00002451, 0.001866, -0.00003871>, <-0.00007352, 0.003731, -0.0001161>, 0.001974 }
		cylinder { <-0.00007352, 0.003731, -0.0001161>, <-0.000147, 0.005592, -0.0002321>, 0.001974 }
		texture {T_ClumpStem}}
	union { // Internode
		cylinder { <-0.000147, 0.005592, -0.0002321>, <-0.0005318, 0.01192, -0.0001794>, 0.006709 }
		cylinder { <-0.0005318, 0.01192, -0.0001794>, <-0.001049, 0.01822, 0.0003198>, 0.006709 }
		cylinder { <-0.001049, 0.01822, 0.0003198>, <-0.001698, 0.02446, 0.001262>, 0.006709 }
		texture {T_ClumpStem}}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-0.001698, 0.02446, 0.001262>, <-0.002601, 0.0292, 0.003339>, 0.0003727 }
			cylinder { <-0.002601, 0.0292, 0.003339>, <-0.003804, 0.03316, 0.006561>, 0.0003727 }
			cylinder { <-0.003804, 0.03316, 0.006561>, <-0.005222, 0.03607, 0.01069>, 0.0003727 }
			texture {T_ClumpLeaf}}
		union { // compound leaf
			union { // Petiole
				cylinder { <-0.005222, 0.03607, 0.01069>, <-0.005652, 0.03691, 0.01195>, 0.0003727 }
				cylinder { <-0.005652, 0.03691, 0.01195>, <-0.006085, 0.03772, 0.01323>, 0.0003727 }
				cylinder { <-0.006085, 0.03772, 0.01323>, <-0.006523, 0.03849, 0.01453>, 0.0003727 }
				texture {T_ClumpLeaf}}
			union { // Petiole
				cylinder { <-0.006523, 0.03849, 0.01453>, <-0.008282, 0.04003, 0.01695>, 0.0002389 }
				cylinder { <-0.008282, 0.04003, 0.01695>, <-0.01073, 0.04136, 0.01884>, 0.0002389 }
				cylinder { <-0.01073, 0.04136, 0.01884>, <-0.01371, 0.04236, 0.02005>, 0.0002389 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <-0.01371, 0.04236, 0.02005>, <-0.0276, 0.08053, 0.01928>, <-0.0276, 0.08053, 0.01928> }
				triangle { <-0.01371, 0.04236, 0.02005>, <-0.0276, 0.08053, 0.01928>, <-0.0276, 0.08053, 0.01928> }
				triangle { <-0.0276, 0.08053, 0.01928>, <-0.03687, 0.1059, 0.01876>, <-0.0276, 0.08053, 0.01928> }
				triangle { <-0.0276, 0.08053, 0.01928>, <-0.0276, 0.08053, 0.01928>, <-0.03687, 0.1059, 0.01876> }
				triangle { <-0.03687, 0.1059, 0.01876>, <-0.0554, 0.1568, 0.01773>, <-0.04613, 0.1314, 0.01825> }
				triangle { <-0.03687, 0.1059, 0.01876>, <-0.04613, 0.1314, 0.01825>, <-0.0554, 0.1568, 0.01773> }
				triangle { <-0.0554, 0.1568, 0.01773>, <-0.06583, 0.2105, 0.006195>, <-0.06003, 0.1696, 0.01747> }
				triangle { <-0.0554, 0.1568, 0.01773>, <-0.06003, 0.1696, 0.01747>, <-0.06583, 0.2105, 0.006195> }
				triangle { <-0.06583, 0.2105, 0.006195>, <-0.08436, 0.2614, 0.005165>, <-0.08782, 0.2459, 0.01593> }
				triangle { <-0.06583, 0.2105, 0.006195>, <-0.08782, 0.2459, 0.01593>, <-0.08436, 0.2614, 0.005165> }
				triangle { <-0.08436, 0.2614, 0.005165>, <-0.1028, 0.3123, 0.004135>, <-0.09306, 0.316, 0.01267> }
				triangle { <-0.08436, 0.2614, 0.005165>, <-0.09306, 0.316, 0.01267>, <-0.1028, 0.3123, 0.004135> }
				triangle { <-0.1028, 0.3123, 0.004135>, <-0.1133, 0.3659, -0.007404>, <-0.09306, 0.316, 0.01267> }
				triangle { <-0.1028, 0.3123, 0.004135>, <-0.09306, 0.316, 0.01267>, <-0.1133, 0.3659, -0.007404> }
				triangle { <-0.1133, 0.3659, -0.007404>, <-0.1318, 0.4168, -0.008434>, <-0.1208, 0.3924, 0.01112> }
				triangle { <-0.1133, 0.3659, -0.007404>, <-0.1208, 0.3924, 0.01112>, <-0.1318, 0.4168, -0.008434> }
				triangle { <-0.1318, 0.4168, -0.008434>, <-0.1503, 0.4677, -0.009464>, <-0.1359, 0.4587, -0.0006682> }
				triangle { <-0.1318, 0.4168, -0.008434>, <-0.1359, 0.4587, -0.0006682>, <-0.1503, 0.4677, -0.009464> }
				triangle { <-0.1503, 0.4677, -0.009464>, <-0.1608, 0.5213, -0.021>, <-0.1509, 0.5251, -0.01246> }
				triangle { <-0.1503, 0.4677, -0.009464>, <-0.1509, 0.5251, -0.01246>, <-0.1608, 0.5213, -0.021> }
				triangle { <-0.1608, 0.5213, -0.021>, <-0.1712, 0.575, -0.03254>, <-0.1509, 0.5251, -0.01246> }
				triangle { <-0.1608, 0.5213, -0.021>, <-0.1509, 0.5251, -0.01246>, <-0.1712, 0.575, -0.03254> }
				triangle { <-0.1712, 0.575, -0.03254>, <-0.1897, 0.6259, -0.03357>, <-0.1741, 0.5887, -0.01375> }
				triangle { <-0.1712, 0.575, -0.03254>, <-0.1741, 0.5887, -0.01375>, <-0.1897, 0.6259, -0.03357> }
				triangle { <-0.1897, 0.6259, -0.03357>, <-0.1955, 0.6668, -0.04485>, <-0.1938, 0.6678, -0.0258> }
				triangle { <-0.1897, 0.6259, -0.03357>, <-0.1938, 0.6678, -0.0258>, <-0.1955, 0.6668, -0.04485> }
				triangle { <-0.1955, 0.6668, -0.04485>, <-0.206, 0.7204, -0.05639>, <-0.2008, 0.7369, -0.04811> }
				triangle { <-0.1955, 0.6668, -0.04485>, <-0.2008, 0.7369, -0.04811>, <-0.206, 0.7204, -0.05639> }
				triangle { <-0.206, 0.7204, -0.05639>, <-0.2164, 0.774, -0.06793>, <-0.2008, 0.7369, -0.04811> }
				triangle { <-0.206, 0.7204, -0.05639>, <-0.2008, 0.7369, -0.04811>, <-0.2164, 0.774, -0.06793> }
				triangle { <-0.2164, 0.774, -0.06793>, <-0.2268, 0.8277, -0.07947>, <-0.2158, 0.8032, -0.05991> }
				triangle { <-0.2164, 0.774, -0.06793>, <-0.2158, 0.8032, -0.05991>, <-0.2268, 0.8277, -0.07947> }
				triangle { <-0.2268, 0.8277, -0.07947>, <-0.2471, 0.8776, -0.09955>, <-0.2407, 0.8658, -0.08025> }
				triangle { <-0.2268, 0.8277, -0.07947>, <-0.2407, 0.8658, -0.08025>, <-0.2471, 0.8776, -0.09955> }
				triangle { <-0.2471, 0.8776, -0.09955>, <-0.2529, 0.9185, -0.1108>, <-0.2477, 0.9349, -0.1025> }
				triangle { <-0.2471, 0.8776, -0.09955>, <-0.2477, 0.9349, -0.1025>, <-0.2529, 0.9185, -0.1108> }
				triangle { <-0.2529, 0.9185, -0.1108>, <-0.2633, 0.9721, -0.1223>, <-0.2668, 0.9566, -0.1116> }
				triangle { <-0.2529, 0.9185, -0.1108>, <-0.2668, 0.9566, -0.1116>, <-0.2633, 0.9721, -0.1223> }
				triangle { <-0.2633, 0.9721, -0.1223>, <-0.279, 1.009302, -0.1422>, <-0.2726, 0.9975, -0.1228> }
				triangle { <-0.2633, 0.9721, -0.1223>, <-0.2726, 0.9975, -0.1228>, <-0.279, 1.009302, -0.1422> }
				triangle { <-0.279, 1.009302, -0.1422>, <-0.2894, 1.06293, -0.1537>, <-0.2929, 1.04747, -0.1429> }
				triangle { <-0.279, 1.009302, -0.1422>, <-0.2929, 1.04747, -0.1429>, <-0.2894, 1.06293, -0.1537> }
				triangle { <-0.2894, 1.06293, -0.1537>, <-0.305, 1.1, -0.1735>, <-0.3131, 1.09736, -0.163> }
				triangle { <-0.2894, 1.06293, -0.1537>, <-0.3131, 1.09736, -0.163>, <-0.305, 1.1, -0.1735> }
				triangle { <-0.305, 1.1, -0.1735>, <-0.3253, 1.1499, -0.1936>, <-0.3253, 1.1499, -0.1936> }
				triangle { <-0.305, 1.1, -0.1735>, <-0.3253, 1.1499, -0.1936>, <-0.3253, 1.1499, -0.1936> }
				triangle { <-0.3253, 1.1499, -0.1936>, <-0.3409, 1.1871, -0.2134>, <-0.3253, 1.1499, -0.1936> }
				triangle { <-0.3253, 1.1499, -0.1936>, <-0.3253, 1.1499, -0.1936>, <-0.3409, 1.1871, -0.2134> }
				triangle { <-0.3253, 1.1499, -0.1936>, <-0.3131, 1.09736, -0.163>, <-0.305, 1.1, -0.1735> }
				triangle { <-0.3253, 1.1499, -0.1936>, <-0.305, 1.1, -0.1735>, <-0.3131, 1.09736, -0.163> }
				triangle { <-0.3131, 1.09736, -0.163>, <-0.2929, 1.04747, -0.1429>, <-0.2894, 1.06293, -0.1537> }
				triangle { <-0.3131, 1.09736, -0.163>, <-0.2894, 1.06293, -0.1537>, <-0.2929, 1.04747, -0.1429> }
				triangle { <-0.2929, 1.04747, -0.1429>, <-0.2726, 0.9975, -0.1228>, <-0.279, 1.009302, -0.1422> }
				triangle { <-0.2929, 1.04747, -0.1429>, <-0.279, 1.009302, -0.1422>, <-0.2726, 0.9975, -0.1228> }
				triangle { <-0.2726, 0.9975, -0.1228>, <-0.2668, 0.9566, -0.1116>, <-0.2633, 0.9721, -0.1223> }
				triangle { <-0.2726, 0.9975, -0.1228>, <-0.2633, 0.9721, -0.1223>, <-0.2668, 0.9566, -0.1116> }
				triangle { <-0.06003, 0.1696, 0.01747>, <-0.04613, 0.1314, 0.01825>, <-0.0554, 0.1568, 0.01773> }
				triangle { <-0.06003, 0.1696, 0.01747>, <-0.0554, 0.1568, 0.01773>, <-0.04613, 0.1314, 0.01825> }
				triangle { <-0.04613, 0.1314, 0.01825>, <-0.0276, 0.08053, 0.01928>, <-0.03687, 0.1059, 0.01876> }
				triangle { <-0.04613, 0.1314, 0.01825>, <-0.03687, 0.1059, 0.01876>, <-0.0276, 0.08053, 0.01928> }
				triangle { <-0.2668, 0.9566, -0.1116>, <-0.2477, 0.9349, -0.1025>, <-0.2529, 0.9185, -0.1108> }
				triangle { <-0.2668, 0.9566, -0.1116>, <-0.2529, 0.9185, -0.1108>, <-0.2477, 0.9349, -0.1025> }
				triangle { <-0.2477, 0.9349, -0.1025>, <-0.2407, 0.8658, -0.08025>, <-0.2471, 0.8776, -0.09955> }
				triangle { <-0.2477, 0.9349, -0.1025>, <-0.2471, 0.8776, -0.09955>, <-0.2407, 0.8658, -0.08025> }
				triangle { <-0.2407, 0.8658, -0.08025>, <-0.2158, 0.8032, -0.05991>, <-0.2268, 0.8277, -0.07947> }
				triangle { <-0.2407, 0.8658, -0.08025>, <-0.2268, 0.8277, -0.07947>, <-0.2158, 0.8032, -0.05991> }
				triangle { <-0.2158, 0.8032, -0.05991>, <-0.2008, 0.7369, -0.04811>, <-0.2164, 0.774, -0.06793> }
				triangle { <-0.2158, 0.8032, -0.05991>, <-0.2164, 0.774, -0.06793>, <-0.2008, 0.7369, -0.04811> }
				triangle { <-0.2008, 0.7369, -0.04811>, <-0.1938, 0.6678, -0.0258>, <-0.1955, 0.6668, -0.04485> }
				triangle { <-0.2008, 0.7369, -0.04811>, <-0.1955, 0.6668, -0.04485>, <-0.1938, 0.6678, -0.0258> }
				triangle { <-0.1938, 0.6678, -0.0258>, <-0.1741, 0.5887, -0.01375>, <-0.1897, 0.6259, -0.03357> }
				triangle { <-0.1938, 0.6678, -0.0258>, <-0.1897, 0.6259, -0.03357>, <-0.1741, 0.5887, -0.01375> }
				triangle { <-0.1741, 0.5887, -0.01375>, <-0.1509, 0.5251, -0.01246>, <-0.1712, 0.575, -0.03254> }
				triangle { <-0.1741, 0.5887, -0.01375>, <-0.1712, 0.575, -0.03254>, <-0.1509, 0.5251, -0.01246> }
				triangle { <-0.1509, 0.5251, -0.01246>, <-0.1359, 0.4587, -0.0006682>, <-0.1503, 0.4677, -0.009464> }
				triangle { <-0.1509, 0.5251, -0.01246>, <-0.1503, 0.4677, -0.009464>, <-0.1359, 0.4587, -0.0006682> }
				triangle { <-0.1359, 0.4587, -0.0006682>, <-0.1208, 0.3924, 0.01112>, <-0.1318, 0.4168, -0.008434> }
				triangle { <-0.1359, 0.4587, -0.0006682>, <-0.1318, 0.4168, -0.008434>, <-0.1208, 0.3924, 0.01112> }
				triangle { <-0.1208, 0.3924, 0.01112>, <-0.09306, 0.316, 0.01267>, <-0.1133, 0.3659, -0.007404> }
				triangle { <-0.1208, 0.3924, 0.01112>, <-0.1133, 0.3659, -0.007404>, <-0.09306, 0.316, 0.01267> }
				triangle { <-0.09306, 0.316, 0.01267>, <-0.08782, 0.2459, 0.01593>, <-0.08436, 0.2614, 0.005165> }
				triangle { <-0.09306, 0.316, 0.01267>, <-0.08436, 0.2614, 0.005165>, <-0.08782, 0.2459, 0.01593> }
				triangle { <-0.08782, 0.2459, 0.01593>, <-0.06003, 0.1696, 0.01747>, <-0.06583, 0.2105, 0.006195> }
				triangle { <-0.08782, 0.2459, 0.01593>, <-0.06583, 0.2105, 0.006195>, <-0.06003, 0.1696, 0.01747> }
				texture {T_ClumpLeaf2}}
			union { // Petiole
				cylinder { <-0.006523, 0.03849, 0.01453>, <-0.007458, 0.04014, 0.01731>, 0.0002389 }
				cylinder { <-0.007458, 0.04014, 0.01731>, <-0.008393, 0.0418, 0.02009>, 0.0002389 }
				cylinder { <-0.008393, 0.0418, 0.02009>, <-0.009328, 0.04345, 0.02287>, 0.0002389 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <-0.009328, 0.04345, 0.02287>, <-0.005026, 0.0834, 0.02888>, <-0.005026, 0.0834, 0.02888> }
				triangle { <-0.009328, 0.04345, 0.02287>, <-0.005026, 0.0834, 0.02888>, <-0.005026, 0.0834, 0.02888> }
				triangle { <-0.005026, 0.0834, 0.02888>, <-0.002158, 0.11, 0.03288>, <-0.005026, 0.0834, 0.02888> }
				triangle { <-0.005026, 0.0834, 0.02888>, <-0.005026, 0.0834, 0.02888>, <-0.002158, 0.11, 0.03288> }
				triangle { <-0.002158, 0.11, 0.03288>, <0.003577, 0.1633, 0.0409>, <0.0007095, 0.1366, 0.03689> }
				triangle { <-0.002158, 0.11, 0.03288>, <0.0007095, 0.1366, 0.03689>, <0.003577, 0.1633, 0.0409> }
				triangle { <0.003577, 0.1633, 0.0409>, <0.009483, 0.2185, 0.03552>, <0.005011, 0.1766, 0.0429> }
				triangle { <0.003577, 0.1633, 0.0409>, <0.005011, 0.1766, 0.0429>, <0.009483, 0.2185, 0.03552> }
				triangle { <0.009483, 0.2185, 0.03552>, <0.01521, 0.2718, 0.04353>, <0.01361, 0.2565, 0.05492> }
				triangle { <0.009483, 0.2185, 0.03552>, <0.01361, 0.2565, 0.05492>, <0.01521, 0.2718, 0.04353> }
				triangle { <0.01521, 0.2718, 0.04353>, <0.02095, 0.3251, 0.05155>, <0.03442, 0.3236, 0.0515> }
				triangle { <0.01521, 0.2718, 0.04353>, <0.03442, 0.3236, 0.0515>, <0.02095, 0.3251, 0.05155> }
				triangle { <0.02095, 0.3251, 0.05155>, <0.02686, 0.3804, 0.04616>, <0.03442, 0.3236, 0.0515> }
				triangle { <0.02095, 0.3251, 0.05155>, <0.03442, 0.3236, 0.0515>, <0.02686, 0.3804, 0.04616> }
				triangle { <0.02686, 0.3804, 0.04616>, <0.03259, 0.4336, 0.05418>, <0.04302, 0.4035, 0.06352> }
				triangle { <0.02686, 0.3804, 0.04616>, <0.04302, 0.4035, 0.06352>, <0.03259, 0.4336, 0.05418> }
				triangle { <0.03259, 0.4336, 0.05418>, <0.03833, 0.4869, 0.06219>, <0.05036, 0.4721, 0.06014> }
				triangle { <0.03259, 0.4336, 0.05418>, <0.05036, 0.4721, 0.06014>, <0.03833, 0.4869, 0.06219> }
				triangle { <0.03833, 0.4869, 0.06219>, <0.04423, 0.5422, 0.05681>, <0.0577, 0.5407, 0.05677> }
				triangle { <0.03833, 0.4869, 0.06219>, <0.0577, 0.5407, 0.05677>, <0.04423, 0.5422, 0.05681> }
				triangle { <0.04423, 0.5422, 0.05681>, <0.05014, 0.5974, 0.05143>, <0.0577, 0.5407, 0.05677> }
				triangle { <0.04423, 0.5422, 0.05681>, <0.0577, 0.5407, 0.05677>, <0.05014, 0.5974, 0.05143> }
				triangle { <0.05014, 0.5974, 0.05143>, <0.05587, 0.6507, 0.05944>, <0.06487, 0.6073, 0.06678> }
				triangle { <0.05014, 0.5974, 0.05143>, <0.06487, 0.6073, 0.06678>, <0.05587, 0.6507, 0.05944> }
				triangle { <0.05587, 0.6507, 0.05944>, <0.06035, 0.6927, 0.05206>, <0.07364, 0.6892, 0.06541> }
				triangle { <0.05587, 0.6507, 0.05944>, <0.07364, 0.6892, 0.06541>, <0.06035, 0.6927, 0.05206> }
				triangle { <0.06035, 0.6927, 0.05206>, <0.06625, 0.7479, 0.04668>, <0.08115, 0.7598, 0.04864> }
				triangle { <0.06035, 0.6927, 0.05206>, <0.08115, 0.7598, 0.04864>, <0.06625, 0.7479, 0.04668> }
				triangle { <0.06625, 0.7479, 0.04668>, <0.07216, 0.8032, 0.0413>, <0.08115, 0.7598, 0.04864> }
				triangle { <0.06625, 0.7479, 0.04668>, <0.08115, 0.7598, 0.04864>, <0.07216, 0.8032, 0.0413> }
				triangle { <0.07216, 0.8032, 0.0413>, <0.07806, 0.8585, 0.03592>, <0.08849, 0.8284, 0.04526> }
				triangle { <0.07216, 0.8032, 0.0413>, <0.08849, 0.8284, 0.04526>, <0.07806, 0.8585, 0.03592> }
				triangle { <0.07806, 0.8585, 0.03592>, <0.0705, 0.9152, 0.03058>, <0.08236, 0.8984, 0.04193> }
				triangle { <0.07806, 0.8585, 0.03592>, <0.08236, 0.8984, 0.04193>, <0.0705, 0.9152, 0.03058> }
				triangle { <0.0705, 0.9152, 0.03058>, <0.07497, 0.9571, 0.02319>, <0.08987, 0.969, 0.02515> }
				triangle { <0.0705, 0.9152, 0.03058>, <0.08987, 0.969, 0.02515>, <0.07497, 0.9571, 0.02319> }
				triangle { <0.07497, 0.9571, 0.02319>, <0.08088, 1.01244, 0.01781>, <0.07927, 0.9971, 0.02921> }
				triangle { <0.07497, 0.9571, 0.02319>, <0.07927, 0.9971, 0.02921>, <0.08088, 1.01244, 0.01781> }
				triangle { <0.08088, 1.01244, 0.01781>, <0.07188, 1.05584, 0.01047>, <0.08375, 1.03908, 0.02182> }
				triangle { <0.08088, 1.01244, 0.01781>, <0.08375, 1.03908, 0.02182>, <0.07188, 1.05584, 0.01047> }
				triangle { <0.07188, 1.05584, 0.01047>, <0.07779, 1.1111, 0.005097>, <0.07618, 1.09579, 0.01648> }
				triangle { <0.07188, 1.05584, 0.01047>, <0.07618, 1.09579, 0.01648>, <0.07779, 1.1111, 0.005097> }
				triangle { <0.07779, 1.1111, 0.005097>, <0.06879, 1.1545, -0.002242>, <0.06862, 1.1525, 0.01115> }
				triangle { <0.07779, 1.1111, 0.005097>, <0.06862, 1.1525, 0.01115>, <0.06879, 1.1545, -0.002242> }
				triangle { <0.06879, 1.1545, -0.002242>, <0.06123, 1.2112, -0.007579>, <0.06123, 1.2112, -0.007579> }
				triangle { <0.06879, 1.1545, -0.002242>, <0.06123, 1.2112, -0.007579>, <0.06123, 1.2112, -0.007579> }
				triangle { <0.06123, 1.2112, -0.007579>, <0.05224, 1.2546, -0.01491>, <0.06123, 1.2112, -0.007579> }
				triangle { <0.06123, 1.2112, -0.007579>, <0.06123, 1.2112, -0.007579>, <0.05224, 1.2546, -0.01491> }
				triangle { <0.06123, 1.2112, -0.007579>, <0.06862, 1.1525, 0.01115>, <0.06879, 1.1545, -0.002242> }
				triangle { <0.06123, 1.2112, -0.007579>, <0.06879, 1.1545, -0.002242>, <0.06862, 1.1525, 0.01115> }
				triangle { <0.06862, 1.1525, 0.01115>, <0.07618, 1.09579, 0.01648>, <0.07779, 1.1111, 0.005097> }
				triangle { <0.06862, 1.1525, 0.01115>, <0.07779, 1.1111, 0.005097>, <0.07618, 1.09579, 0.01648> }
				triangle { <0.07618, 1.09579, 0.01648>, <0.08375, 1.03908, 0.02182>, <0.07188, 1.05584, 0.01047> }
				triangle { <0.07618, 1.09579, 0.01648>, <0.07188, 1.05584, 0.01047>, <0.08375, 1.03908, 0.02182> }
				triangle { <0.08375, 1.03908, 0.02182>, <0.07927, 0.9971, 0.02921>, <0.08088, 1.01244, 0.01781> }
				triangle { <0.08375, 1.03908, 0.02182>, <0.08088, 1.01244, 0.01781>, <0.07927, 0.9971, 0.02921> }
				triangle { <0.005011, 0.1766, 0.0429>, <0.0007095, 0.1366, 0.03689>, <0.003577, 0.1633, 0.0409> }
				triangle { <0.005011, 0.1766, 0.0429>, <0.003577, 0.1633, 0.0409>, <0.0007095, 0.1366, 0.03689> }
				triangle { <0.0007095, 0.1366, 0.03689>, <-0.005026, 0.0834, 0.02888>, <-0.002158, 0.11, 0.03288> }
				triangle { <0.0007095, 0.1366, 0.03689>, <-0.002158, 0.11, 0.03288>, <-0.005026, 0.0834, 0.02888> }
				triangle { <0.07927, 0.9971, 0.02921>, <0.08987, 0.969, 0.02515>, <0.07497, 0.9571, 0.02319> }
				triangle { <0.07927, 0.9971, 0.02921>, <0.07497, 0.9571, 0.02319>, <0.08987, 0.969, 0.02515> }
				triangle { <0.08987, 0.969, 0.02515>, <0.08236, 0.8984, 0.04193>, <0.0705, 0.9152, 0.03058> }
				triangle { <0.08987, 0.969, 0.02515>, <0.0705, 0.9152, 0.03058>, <0.08236, 0.8984, 0.04193> }
				triangle { <0.08236, 0.8984, 0.04193>, <0.08849, 0.8284, 0.04526>, <0.07806, 0.8585, 0.03592> }
				triangle { <0.08236, 0.8984, 0.04193>, <0.07806, 0.8585, 0.03592>, <0.08849, 0.8284, 0.04526> }
				triangle { <0.08849, 0.8284, 0.04526>, <0.08115, 0.7598, 0.04864>, <0.07216, 0.8032, 0.0413> }
				triangle { <0.08849, 0.8284, 0.04526>, <0.07216, 0.8032, 0.0413>, <0.08115, 0.7598, 0.04864> }
				triangle { <0.08115, 0.7598, 0.04864>, <0.07364, 0.6892, 0.06541>, <0.06035, 0.6927, 0.05206> }
				triangle { <0.08115, 0.7598, 0.04864>, <0.06035, 0.6927, 0.05206>, <0.07364, 0.6892, 0.06541> }
				triangle { <0.07364, 0.6892, 0.06541>, <0.06487, 0.6073, 0.06678>, <0.05587, 0.6507, 0.05944> }
				triangle { <0.07364, 0.6892, 0.06541>, <0.05587, 0.6507, 0.05944>, <0.06487, 0.6073, 0.06678> }
				triangle { <0.06487, 0.6073, 0.06678>, <0.0577, 0.5407, 0.05677>, <0.05014, 0.5974, 0.05143> }
				triangle { <0.06487, 0.6073, 0.06678>, <0.05014, 0.5974, 0.05143>, <0.0577, 0.5407, 0.05677> }
				triangle { <0.0577, 0.5407, 0.05677>, <0.05036, 0.4721, 0.06014>, <0.03833, 0.4869, 0.06219> }
				triangle { <0.0577, 0.5407, 0.05677>, <0.03833, 0.4869, 0.06219>, <0.05036, 0.4721, 0.06014> }
				triangle { <0.05036, 0.4721, 0.06014>, <0.04302, 0.4035, 0.06352>, <0.03259, 0.4336, 0.05418> }
				triangle { <0.05036, 0.4721, 0.06014>, <0.03259, 0.4336, 0.05418>, <0.04302, 0.4035, 0.06352> }
				triangle { <0.04302, 0.4035, 0.06352>, <0.03442, 0.3236, 0.0515>, <0.02686, 0.3804, 0.04616> }
				triangle { <0.04302, 0.4035, 0.06352>, <0.02686, 0.3804, 0.04616>, <0.03442, 0.3236, 0.0515> }
				triangle { <0.03442, 0.3236, 0.0515>, <0.01361, 0.2565, 0.05492>, <0.01521, 0.2718, 0.04353> }
				triangle { <0.03442, 0.3236, 0.0515>, <0.01521, 0.2718, 0.04353>, <0.01361, 0.2565, 0.05492> }
				triangle { <0.01361, 0.2565, 0.05492>, <0.005011, 0.1766, 0.0429>, <0.009483, 0.2185, 0.03552> }
				triangle { <0.01361, 0.2565, 0.05492>, <0.009483, 0.2185, 0.03552>, <0.005011, 0.1766, 0.0429> }
				texture {T_ClumpLeaf2}}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-0.001698, 0.02446, 0.001262>, <-0.001829, 0.02968, 0.0006909>, 0.0003727 }
			cylinder { <-0.001829, 0.02968, 0.0006909>, <-0.001546, 0.03457, -0.001192>, 0.0003727 }
			cylinder { <-0.001546, 0.03457, -0.001192>, <-0.0008684, 0.03878, -0.00425>, 0.0003727 }
			texture {T_ClumpLeaf}}
		union { // compound leaf
			union { // Petiole
				cylinder { <-0.0008684, 0.03878, -0.00425>, <-0.000655, 0.04002, -0.005196>, 0.0003727 }
				cylinder { <-0.000655, 0.04002, -0.005196>, <-0.0004316, 0.04124, -0.006171>, 0.0003727 }
				cylinder { <-0.0004316, 0.04124, -0.006171>, <-0.0001982, 0.04243, -0.007174>, 0.0003727 }
				texture {T_ClumpLeaf}}
			union { // Petiole
				cylinder { <-0.0001982, 0.04243, -0.007174>, <0.00114, 0.04493, -0.00898>, 0.0002389 }
				cylinder { <0.00114, 0.04493, -0.00898>, <0.003221, 0.04721, -0.01031>, 0.0002389 }
				cylinder { <0.003221, 0.04721, -0.01031>, <0.005894, 0.04911, -0.01109>, 0.0002389 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <0.005894, 0.04911, -0.01109>, <0.01184, 0.08736, 0.001232>, <0.01184, 0.08736, 0.001232> }
				triangle { <0.005894, 0.04911, -0.01109>, <0.01184, 0.08736, 0.001232>, <0.01184, 0.08736, 0.001232> }
				triangle { <0.01184, 0.08736, 0.001232>, <0.01581, 0.1128, 0.00945>, <0.01184, 0.08736, 0.001232> }
				triangle { <0.01184, 0.08736, 0.001232>, <0.01184, 0.08736, 0.001232>, <0.01581, 0.1128, 0.00945> }
				triangle { <0.01581, 0.1128, 0.00945>, <0.02375, 0.1638, 0.02588>, <0.01978, 0.1383, 0.01766> }
				triangle { <0.01581, 0.1128, 0.00945>, <0.01978, 0.1383, 0.01766>, <0.02375, 0.1638, 0.02588> }
				triangle { <0.02375, 0.1638, 0.02588>, <0.02354, 0.2127, 0.05292>, <0.02574, 0.1766, 0.02999> }
				triangle { <0.02375, 0.1638, 0.02588>, <0.02574, 0.1766, 0.02999>, <0.02354, 0.2127, 0.05292> }
				triangle { <0.02354, 0.2127, 0.05292>, <0.03147, 0.2637, 0.06935>, <0.03764, 0.2531, 0.05465> }
				triangle { <0.02354, 0.2127, 0.05292>, <0.03764, 0.2531, 0.05465>, <0.03147, 0.2637, 0.06935> }
				triangle { <0.03147, 0.2637, 0.06935>, <0.03941, 0.3147, 0.08579>, <0.02878, 0.3187, 0.07843> }
				triangle { <0.03147, 0.2637, 0.06935>, <0.02878, 0.3187, 0.07843>, <0.03941, 0.3147, 0.08579> }
				triangle { <0.03941, 0.3147, 0.08579>, <0.0392, 0.3636, 0.1128>, <0.02878, 0.3187, 0.07843> }
				triangle { <0.03941, 0.3147, 0.08579>, <0.02878, 0.3187, 0.07843>, <0.0392, 0.3636, 0.1128> }
				triangle { <0.0392, 0.3636, 0.1128>, <0.04713, 0.4146, 0.1292>, <0.04069, 0.3953, 0.103> }
				triangle { <0.0392, 0.3636, 0.1128>, <0.04069, 0.3953, 0.103>, <0.04713, 0.4146, 0.1292> }
				triangle { <0.04713, 0.4146, 0.1292>, <0.05507, 0.4656, 0.1457>, <0.04246, 0.4569, 0.1342> }
				triangle { <0.04713, 0.4146, 0.1292>, <0.04246, 0.4569, 0.1342>, <0.05507, 0.4656, 0.1457> }
				triangle { <0.05507, 0.4656, 0.1457>, <0.05486, 0.5145, 0.1727>, <0.04423, 0.5185, 0.1653> }
				triangle { <0.05507, 0.4656, 0.1457>, <0.04423, 0.5185, 0.1653>, <0.05486, 0.5145, 0.1727> }
				triangle { <0.05486, 0.5145, 0.1727>, <0.05464, 0.5633, 0.1997>, <0.04423, 0.5185, 0.1653> }
				triangle { <0.05486, 0.5145, 0.1727>, <0.04423, 0.5185, 0.1653>, <0.05464, 0.5633, 0.1997> }
				triangle { <0.05464, 0.5633, 0.1997>, <0.06258, 0.6143, 0.2162>, <0.05415, 0.5822, 0.1859> }
				triangle { <0.05464, 0.5633, 0.1997>, <0.05415, 0.5822, 0.1859>, <0.06258, 0.6143, 0.2162> }
				triangle { <0.06258, 0.6143, 0.2162>, <0.06038, 0.6504, 0.2391>, <0.0579, 0.6566, 0.2211> }
				triangle { <0.06258, 0.6143, 0.2162>, <0.0579, 0.6566, 0.2211>, <0.06038, 0.6504, 0.2391> }
				triangle { <0.06038, 0.6504, 0.2391>, <0.06016, 0.6993, 0.2661>, <0.05152, 0.7161, 0.2629> }
				triangle { <0.06038, 0.6504, 0.2391>, <0.05152, 0.7161, 0.2629>, <0.06016, 0.6993, 0.2661> }
				triangle { <0.06016, 0.6993, 0.2661>, <0.05995, 0.7482, 0.2932>, <0.05152, 0.7161, 0.2629> }
				triangle { <0.06016, 0.6993, 0.2661>, <0.05152, 0.7161, 0.2629>, <0.05995, 0.7482, 0.2932> }
				triangle { <0.05995, 0.7482, 0.2932>, <0.05973, 0.797, 0.3202>, <0.05329, 0.7777, 0.294> }
				triangle { <0.05995, 0.7482, 0.2932>, <0.05329, 0.7777, 0.294>, <0.05973, 0.797, 0.3202> }
				triangle { <0.05973, 0.797, 0.3202>, <0.07015, 0.8419, 0.3546>, <0.06568, 0.8353, 0.3325> }
				triangle { <0.05973, 0.797, 0.3202>, <0.06568, 0.8353, 0.3325>, <0.07015, 0.8419, 0.3546> }
				triangle { <0.07015, 0.8419, 0.3546>, <0.06795, 0.878, 0.3775>, <0.0593, 0.8947, 0.3743> }
				triangle { <0.07015, 0.8419, 0.3546>, <0.0593, 0.8947, 0.3743>, <0.06795, 0.878, 0.3775> }
				triangle { <0.06795, 0.878, 0.3775>, <0.06773, 0.9268, 0.4046>, <0.0739, 0.9162, 0.3898> }
				triangle { <0.06795, 0.878, 0.3775>, <0.0739, 0.9162, 0.3898>, <0.06773, 0.9268, 0.4046> }
				triangle { <0.06773, 0.9268, 0.4046>, <0.07616, 0.9589, 0.4348>, <0.0717, 0.9523, 0.4128> }
				triangle { <0.06773, 0.9268, 0.4046>, <0.0717, 0.9523, 0.4128>, <0.07616, 0.9589, 0.4348> }
				triangle { <0.07616, 0.9589, 0.4348>, <0.07594, 1.007828, 0.4619>, <0.08211, 0.9972, 0.4472> }
				triangle { <0.07616, 0.9589, 0.4348>, <0.08211, 0.9972, 0.4472>, <0.07594, 1.007828, 0.4619> }
				triangle { <0.07594, 1.007828, 0.4619>, <0.08437, 1.03991, 0.4922>, <0.09253, 1.04205, 0.4816> }
				triangle { <0.07594, 1.007828, 0.4619>, <0.09253, 1.04205, 0.4816>, <0.08437, 1.03991, 0.4922> }
				triangle { <0.08437, 1.03991, 0.4922>, <0.09479, 1.08474, 0.5266>, <0.09479, 1.08474, 0.5266> }
				triangle { <0.08437, 1.03991, 0.4922>, <0.09479, 1.08474, 0.5266>, <0.09479, 1.08474, 0.5266> }
				triangle { <0.09479, 1.08474, 0.5266>, <0.1032, 1.1168, 0.5569>, <0.09479, 1.08474, 0.5266> }
				triangle { <0.09479, 1.08474, 0.5266>, <0.09479, 1.08474, 0.5266>, <0.1032, 1.1168, 0.5569> }
				triangle { <0.09479, 1.08474, 0.5266>, <0.09253, 1.04205, 0.4816>, <0.08437, 1.03991, 0.4922> }
				triangle { <0.09479, 1.08474, 0.5266>, <0.08437, 1.03991, 0.4922>, <0.09253, 1.04205, 0.4816> }
				triangle { <0.09253, 1.04205, 0.4816>, <0.08211, 0.9972, 0.4472>, <0.07594, 1.007828, 0.4619> }
				triangle { <0.09253, 1.04205, 0.4816>, <0.07594, 1.007828, 0.4619>, <0.08211, 0.9972, 0.4472> }
				triangle { <0.08211, 0.9972, 0.4472>, <0.0717, 0.9523, 0.4128>, <0.07616, 0.9589, 0.4348> }
				triangle { <0.08211, 0.9972, 0.4472>, <0.07616, 0.9589, 0.4348>, <0.0717, 0.9523, 0.4128> }
				triangle { <0.0717, 0.9523, 0.4128>, <0.0739, 0.9162, 0.3898>, <0.06773, 0.9268, 0.4046> }
				triangle { <0.0717, 0.9523, 0.4128>, <0.06773, 0.9268, 0.4046>, <0.0739, 0.9162, 0.3898> }
				triangle { <0.02574, 0.1766, 0.02999>, <0.01978, 0.1383, 0.01766>, <0.02375, 0.1638, 0.02588> }
				triangle { <0.02574, 0.1766, 0.02999>, <0.02375, 0.1638, 0.02588>, <0.01978, 0.1383, 0.01766> }
				triangle { <0.01978, 0.1383, 0.01766>, <0.01184, 0.08736, 0.001232>, <0.01581, 0.1128, 0.00945> }
				triangle { <0.01978, 0.1383, 0.01766>, <0.01581, 0.1128, 0.00945>, <0.01184, 0.08736, 0.001232> }
				triangle { <0.0739, 0.9162, 0.3898>, <0.0593, 0.8947, 0.3743>, <0.06795, 0.878, 0.3775> }
				triangle { <0.0739, 0.9162, 0.3898>, <0.06795, 0.878, 0.3775>, <0.0593, 0.8947, 0.3743> }
				triangle { <0.0593, 0.8947, 0.3743>, <0.06568, 0.8353, 0.3325>, <0.07015, 0.8419, 0.3546> }
				triangle { <0.0593, 0.8947, 0.3743>, <0.07015, 0.8419, 0.3546>, <0.06568, 0.8353, 0.3325> }
				triangle { <0.06568, 0.8353, 0.3325>, <0.05329, 0.7777, 0.294>, <0.05973, 0.797, 0.3202> }
				triangle { <0.06568, 0.8353, 0.3325>, <0.05973, 0.797, 0.3202>, <0.05329, 0.7777, 0.294> }
				triangle { <0.05329, 0.7777, 0.294>, <0.05152, 0.7161, 0.2629>, <0.05995, 0.7482, 0.2932> }
				triangle { <0.05329, 0.7777, 0.294>, <0.05995, 0.7482, 0.2932>, <0.05152, 0.7161, 0.2629> }
				triangle { <0.05152, 0.7161, 0.2629>, <0.0579, 0.6566, 0.2211>, <0.06038, 0.6504, 0.2391> }
				triangle { <0.05152, 0.7161, 0.2629>, <0.06038, 0.6504, 0.2391>, <0.0579, 0.6566, 0.2211> }
				triangle { <0.0579, 0.6566, 0.2211>, <0.05415, 0.5822, 0.1859>, <0.06258, 0.6143, 0.2162> }
				triangle { <0.0579, 0.6566, 0.2211>, <0.06258, 0.6143, 0.2162>, <0.05415, 0.5822, 0.1859> }
				triangle { <0.05415, 0.5822, 0.1859>, <0.04423, 0.5185, 0.1653>, <0.05464, 0.5633, 0.1997> }
				triangle { <0.05415, 0.5822, 0.1859>, <0.05464, 0.5633, 0.1997>, <0.04423, 0.5185, 0.1653> }
				triangle { <0.04423, 0.5185, 0.1653>, <0.04246, 0.4569, 0.1342>, <0.05507, 0.4656, 0.1457> }
				triangle { <0.04423, 0.5185, 0.1653>, <0.05507, 0.4656, 0.1457>, <0.04246, 0.4569, 0.1342> }
				triangle { <0.04246, 0.4569, 0.1342>, <0.04069, 0.3953, 0.103>, <0.04713, 0.4146, 0.1292> }
				triangle { <0.04246, 0.4569, 0.1342>, <0.04713, 0.4146, 0.1292>, <0.04069, 0.3953, 0.103> }
				triangle { <0.04069, 0.3953, 0.103>, <0.02878, 0.3187, 0.07843>, <0.0392, 0.3636, 0.1128> }
				triangle { <0.04069, 0.3953, 0.103>, <0.0392, 0.3636, 0.1128>, <0.02878, 0.3187, 0.07843> }
				triangle { <0.02878, 0.3187, 0.07843>, <0.03764, 0.2531, 0.05465>, <0.03147, 0.2637, 0.06935> }
				triangle { <0.02878, 0.3187, 0.07843>, <0.03147, 0.2637, 0.06935>, <0.03764, 0.2531, 0.05465> }
				triangle { <0.03764, 0.2531, 0.05465>, <0.02574, 0.1766, 0.02999>, <0.02354, 0.2127, 0.05292> }
				triangle { <0.03764, 0.2531, 0.05465>, <0.02354, 0.2127, 0.05292>, <0.02574, 0.1766, 0.02999> }
				texture {T_ClumpLeaf2}}
			union { // Petiole
				cylinder { <-0.0001982, 0.04243, -0.007174>, <0.0003002, 0.04498, -0.009317>, 0.0002389 }
				cylinder { <0.0003002, 0.04498, -0.009317>, <0.0007988, 0.04752, -0.01146>, 0.0002389 }
				cylinder { <0.0007988, 0.04752, -0.01146>, <0.001297, 0.05007, -0.0136>, 0.0002389 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <0.001297, 0.05007, -0.0136>, <-0.01113, 0.08831, -0.007791>, <-0.01113, 0.08831, -0.007791> }
				triangle { <0.001297, 0.05007, -0.0136>, <-0.01113, 0.08831, -0.007791>, <-0.01113, 0.08831, -0.007791> }
				triangle { <-0.01113, 0.08831, -0.007791>, <-0.01941, 0.1138, -0.003917>, <-0.01113, 0.08831, -0.007791> }
				triangle { <-0.01113, 0.08831, -0.007791>, <-0.01113, 0.08831, -0.007791>, <-0.01941, 0.1138, -0.003917> }
				triangle { <-0.01941, 0.1138, -0.003917>, <-0.03598, 0.1648, 0.003831>, <-0.0277, 0.1393, -0.00004269> }
				triangle { <-0.01941, 0.1138, -0.003917>, <-0.0277, 0.1393, -0.00004269>, <-0.03598, 0.1648, 0.003831> }
				triangle { <-0.03598, 0.1648, 0.003831>, <-0.05271, 0.2137, 0.02496>, <-0.04012, 0.1775, 0.005769> }
				triangle { <-0.03598, 0.1648, 0.003831>, <-0.04012, 0.1775, 0.005769>, <-0.05271, 0.2137, 0.02496> }
				triangle { <-0.05271, 0.2137, 0.02496>, <-0.06928, 0.2647, 0.03271>, <-0.06498, 0.254, 0.01739> }
				triangle { <-0.05271, 0.2137, 0.02496>, <-0.06498, 0.254, 0.01739>, <-0.06928, 0.2647, 0.03271> }
				triangle { <-0.06928, 0.2647, 0.03271>, <-0.08585, 0.3157, 0.04046>, <-0.09875, 0.3116, 0.03967> }
				triangle { <-0.06928, 0.2647, 0.03271>, <-0.09875, 0.3116, 0.03967>, <-0.08585, 0.3157, 0.04046> }
				triangle { <-0.08585, 0.3157, 0.04046>, <-0.1025, 0.3646, 0.06159>, <-0.09875, 0.3116, 0.03967> }
				triangle { <-0.08585, 0.3157, 0.04046>, <-0.09875, 0.3116, 0.03967>, <-0.1025, 0.3646, 0.06159> }
				triangle { <-0.1025, 0.3646, 0.06159>, <-0.1191, 0.4156, 0.06934>, <-0.1236, 0.3881, 0.05129> }
				triangle { <-0.1025, 0.3646, 0.06159>, <-0.1236, 0.3881, 0.05129>, <-0.1191, 0.4156, 0.06934> }
				triangle { <-0.1191, 0.4156, 0.06934>, <-0.1357, 0.4666, 0.07708>, <-0.1444, 0.4497, 0.07436> }
				triangle { <-0.1191, 0.4156, 0.06934>, <-0.1444, 0.4497, 0.07436>, <-0.1357, 0.4666, 0.07708> }
				triangle { <-0.1357, 0.4666, 0.07708>, <-0.1524, 0.5155, 0.09822>, <-0.1653, 0.5114, 0.09743> }
				triangle { <-0.1357, 0.4666, 0.07708>, <-0.1653, 0.5114, 0.09743>, <-0.1524, 0.5155, 0.09822> }
				triangle { <-0.1524, 0.5155, 0.09822>, <-0.1691, 0.5644, 0.1193>, <-0.1653, 0.5114, 0.09743> }
				triangle { <-0.1524, 0.5155, 0.09822>, <-0.1653, 0.5114, 0.09743>, <-0.1691, 0.5644, 0.1193> }
				triangle { <-0.1691, 0.5644, 0.1193>, <-0.1857, 0.6154, 0.127>, <-0.186, 0.5751, 0.1071> }
				triangle { <-0.1691, 0.5644, 0.1193>, <-0.186, 0.5751, 0.1071>, <-0.1857, 0.6154, 0.127> }
				triangle { <-0.1857, 0.6154, 0.127>, <-0.1983, 0.6515, 0.1462>, <-0.211, 0.6495, 0.1321> }
				triangle { <-0.1857, 0.6154, 0.127>, <-0.211, 0.6495, 0.1321>, <-0.1983, 0.6515, 0.1462> }
				triangle { <-0.1983, 0.6515, 0.1462>, <-0.215, 0.7004, 0.1674>, <-0.2321, 0.7091, 0.1685> }
				triangle { <-0.1983, 0.6515, 0.1462>, <-0.2321, 0.7091, 0.1685>, <-0.215, 0.7004, 0.1674> }
				triangle { <-0.215, 0.7004, 0.1674>, <-0.2318, 0.7493, 0.1885>, <-0.2321, 0.7091, 0.1685> }
				triangle { <-0.215, 0.7004, 0.1674>, <-0.2321, 0.7091, 0.1685>, <-0.2318, 0.7493, 0.1885> }
				triangle { <-0.2318, 0.7493, 0.1885>, <-0.2485, 0.7983, 0.2096>, <-0.2529, 0.7708, 0.1916> }
				triangle { <-0.2318, 0.7493, 0.1885>, <-0.2529, 0.7708, 0.1916>, <-0.2485, 0.7983, 0.2096> }
				triangle { <-0.2485, 0.7983, 0.2096>, <-0.2523, 0.8512, 0.2316>, <-0.2609, 0.8365, 0.2154> }
				triangle { <-0.2485, 0.7983, 0.2096>, <-0.2609, 0.8365, 0.2154>, <-0.2523, 0.8512, 0.2316> }
				triangle { <-0.2523, 0.8512, 0.2316>, <-0.2649, 0.8874, 0.2507>, <-0.282, 0.8961, 0.2519> }
				triangle { <-0.2523, 0.8512, 0.2316>, <-0.282, 0.8961, 0.2519>, <-0.2649, 0.8874, 0.2507> }
				triangle { <-0.2649, 0.8874, 0.2507>, <-0.2817, 0.9363, 0.2719>, <-0.2774, 0.9256, 0.2566> }
				triangle { <-0.2649, 0.8874, 0.2507>, <-0.2774, 0.9256, 0.2566>, <-0.2817, 0.9363, 0.2719> }
				triangle { <-0.2817, 0.9363, 0.2719>, <-0.2813, 0.9765, 0.2919>, <-0.2899, 0.9618, 0.2758> }
				triangle { <-0.2817, 0.9363, 0.2719>, <-0.2899, 0.9618, 0.2758>, <-0.2813, 0.9765, 0.2919> }
				triangle { <-0.2813, 0.9765, 0.2919>, <-0.2981, 1.02549, 0.313>, <-0.2938, 1.01482, 0.2977> }
				triangle { <-0.2813, 0.9765, 0.2919>, <-0.2938, 1.01482, 0.2977>, <-0.2981, 1.02549, 0.313> }
				triangle { <-0.2981, 1.02549, 0.313>, <-0.2978, 1.06572, 0.333>, <-0.2976, 1.0678, 0.3196> }
				triangle { <-0.2981, 1.02549, 0.313>, <-0.2976, 1.0678, 0.3196>, <-0.2978, 1.06572, 0.333> }
				triangle { <-0.2978, 1.06572, 0.333>, <-0.3016, 1.1187, 0.3549>, <-0.3016, 1.1187, 0.3549> }
				triangle { <-0.2978, 1.06572, 0.333>, <-0.3016, 1.1187, 0.3549>, <-0.3016, 1.1187, 0.3549> }
				triangle { <-0.3016, 1.1187, 0.3549>, <-0.3013, 1.1589, 0.3749>, <-0.3016, 1.1187, 0.3549> }
				triangle { <-0.3016, 1.1187, 0.3549>, <-0.3016, 1.1187, 0.3549>, <-0.3013, 1.1589, 0.3749> }
				triangle { <-0.3016, 1.1187, 0.3549>, <-0.2976, 1.0678, 0.3196>, <-0.2978, 1.06572, 0.333> }
				triangle { <-0.3016, 1.1187, 0.3549>, <-0.2978, 1.06572, 0.333>, <-0.2976, 1.0678, 0.3196> }
				triangle { <-0.2976, 1.0678, 0.3196>, <-0.2938, 1.01482, 0.2977>, <-0.2981, 1.02549, 0.313> }
				triangle { <-0.2976, 1.0678, 0.3196>, <-0.2981, 1.02549, 0.313>, <-0.2938, 1.01482, 0.2977> }
				triangle { <-0.2938, 1.01482, 0.2977>, <-0.2899, 0.9618, 0.2758>, <-0.2813, 0.9765, 0.2919> }
				triangle { <-0.2938, 1.01482, 0.2977>, <-0.2813, 0.9765, 0.2919>, <-0.2899, 0.9618, 0.2758> }
				triangle { <-0.2899, 0.9618, 0.2758>, <-0.2774, 0.9256, 0.2566>, <-0.2817, 0.9363, 0.2719> }
				triangle { <-0.2899, 0.9618, 0.2758>, <-0.2817, 0.9363, 0.2719>, <-0.2774, 0.9256, 0.2566> }
				triangle { <-0.04012, 0.1775, 0.005769>, <-0.0277, 0.1393, -0.00004269>, <-0.03598, 0.1648, 0.003831> }
				triangle { <-0.04012, 0.1775, 0.005769>, <-0.03598, 0.1648, 0.003831>, <-0.0277, 0.1393, -0.00004269> }
				triangle { <-0.0277, 0.1393, -0.00004269>, <-0.01113, 0.08831, -0.007791>, <-0.01941, 0.1138, -0.003917> }
				triangle { <-0.0277, 0.1393, -0.00004269>, <-0.01941, 0.1138, -0.003917>, <-0.01113, 0.08831, -0.007791> }
				triangle { <-0.2774, 0.9256, 0.2566>, <-0.282, 0.8961, 0.2519>, <-0.2649, 0.8874, 0.2507> }
				triangle { <-0.2774, 0.9256, 0.2566>, <-0.2649, 0.8874, 0.2507>, <-0.282, 0.8961, 0.2519> }
				triangle { <-0.282, 0.8961, 0.2519>, <-0.2609, 0.8365, 0.2154>, <-0.2523, 0.8512, 0.2316> }
				triangle { <-0.282, 0.8961, 0.2519>, <-0.2523, 0.8512, 0.2316>, <-0.2609, 0.8365, 0.2154> }
				triangle { <-0.2609, 0.8365, 0.2154>, <-0.2529, 0.7708, 0.1916>, <-0.2485, 0.7983, 0.2096> }
				triangle { <-0.2609, 0.8365, 0.2154>, <-0.2485, 0.7983, 0.2096>, <-0.2529, 0.7708, 0.1916> }
				triangle { <-0.2529, 0.7708, 0.1916>, <-0.2321, 0.7091, 0.1685>, <-0.2318, 0.7493, 0.1885> }
				triangle { <-0.2529, 0.7708, 0.1916>, <-0.2318, 0.7493, 0.1885>, <-0.2321, 0.7091, 0.1685> }
				triangle { <-0.2321, 0.7091, 0.1685>, <-0.211, 0.6495, 0.1321>, <-0.1983, 0.6515, 0.1462> }
				triangle { <-0.2321, 0.7091, 0.1685>, <-0.1983, 0.6515, 0.1462>, <-0.211, 0.6495, 0.1321> }
				triangle { <-0.211, 0.6495, 0.1321>, <-0.186, 0.5751, 0.1071>, <-0.1857, 0.6154, 0.127> }
				triangle { <-0.211, 0.6495, 0.1321>, <-0.1857, 0.6154, 0.127>, <-0.186, 0.5751, 0.1071> }
				triangle { <-0.186, 0.5751, 0.1071>, <-0.1653, 0.5114, 0.09743>, <-0.1691, 0.5644, 0.1193> }
				triangle { <-0.186, 0.5751, 0.1071>, <-0.1691, 0.5644, 0.1193>, <-0.1653, 0.5114, 0.09743> }
				triangle { <-0.1653, 0.5114, 0.09743>, <-0.1444, 0.4497, 0.07436>, <-0.1357, 0.4666, 0.07708> }
				triangle { <-0.1653, 0.5114, 0.09743>, <-0.1357, 0.4666, 0.07708>, <-0.1444, 0.4497, 0.07436> }
				triangle { <-0.1444, 0.4497, 0.07436>, <-0.1236, 0.3881, 0.05129>, <-0.1191, 0.4156, 0.06934> }
				triangle { <-0.1444, 0.4497, 0.07436>, <-0.1191, 0.4156, 0.06934>, <-0.1236, 0.3881, 0.05129> }
				triangle { <-0.1236, 0.3881, 0.05129>, <-0.09875, 0.3116, 0.03967>, <-0.1025, 0.3646, 0.06159> }
				triangle { <-0.1236, 0.3881, 0.05129>, <-0.1025, 0.3646, 0.06159>, <-0.09875, 0.3116, 0.03967> }
				triangle { <-0.09875, 0.3116, 0.03967>, <-0.06498, 0.254, 0.01739>, <-0.06928, 0.2647, 0.03271> }
				triangle { <-0.09875, 0.3116, 0.03967>, <-0.06928, 0.2647, 0.03271>, <-0.06498, 0.254, 0.01739> }
				triangle { <-0.06498, 0.254, 0.01739>, <-0.04012, 0.1775, 0.005769>, <-0.05271, 0.2137, 0.02496> }
				triangle { <-0.06498, 0.254, 0.01739>, <-0.05271, 0.2137, 0.02496>, <-0.04012, 0.1775, 0.005769> }
				texture {T_ClumpLeaf2}}
			}
		}
	union { // Internode
		cylinder { <-0.001698, 0.02446, 0.001262>, <-0.002261, 0.03141, 0.00224>, 0.00745 }
		cylinder { <-0.002261, 0.03141, 0.00224>, <-0.002668, 0.03838, 0.003148>, 0.00745 }
		cylinder { <-0.002668, 0.03838, 0.003148>, <-0.002917, 0.04537, 0.003986>, 0.00745 }
		texture {T_ClumpStem}}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-0.002917, 0.04537, 0.003986>, <-0.001507, 0.052, 0.004023>, 0.0004809 }
			cylinder { <-0.001507, 0.052, 0.004023>, <0.001451, 0.05805, 0.003289>, 0.0004809 }
			cylinder { <0.001451, 0.05805, 0.003289>, <0.005745, 0.06308, 0.001837>, 0.0004809 }
			texture {T_ClumpLeaf}}
		union { // compound leaf
			union { // Petiole
				cylinder { <0.005745, 0.06308, 0.001837>, <0.007065, 0.06456, 0.001383>, 0.0004809 }
				cylinder { <0.007065, 0.06456, 0.001383>, <0.008416, 0.066, 0.0009118>, 0.0004809 }
				cylinder { <0.008416, 0.066, 0.0009118>, <0.009798, 0.06741, 0.0004223>, 0.0004809 }
				texture {T_ClumpLeaf}}
			union { // Petiole
				cylinder { <0.009798, 0.06741, 0.0004223>, <0.01409, 0.07101, 0.0004737>, 0.0003978 }
				cylinder { <0.01409, 0.07101, 0.0004737>, <0.01855, 0.07407, 0.001922>, 0.0003978 }
				cylinder { <0.01855, 0.07407, 0.001922>, <0.02287, 0.07636, 0.004663>, 0.0003978 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <0.02287, 0.07636, 0.004663>, <0.02315, 0.1243, 0.02573>, <0.02315, 0.1243, 0.02573> }
				triangle { <0.02287, 0.07636, 0.004663>, <0.02315, 0.1243, 0.02573>, <0.02315, 0.1243, 0.02573> }
				triangle { <0.02315, 0.1243, 0.02573>, <0.02333, 0.1563, 0.03978>, <0.02315, 0.1243, 0.02573> }
				triangle { <0.02315, 0.1243, 0.02573>, <0.02315, 0.1243, 0.02573>, <0.02333, 0.1563, 0.03978> }
				triangle { <0.02333, 0.1563, 0.03978>, <0.0237, 0.2204, 0.06787>, <0.02352, 0.1884, 0.05382> }
				triangle { <0.02333, 0.1563, 0.03978>, <0.02352, 0.1884, 0.05382>, <0.0237, 0.2204, 0.06787> }
				triangle { <0.0237, 0.2204, 0.06787>, <0.00663, 0.284, 0.09701>, <0.02379, 0.2364, 0.07489> }
				triangle { <0.0237, 0.2204, 0.06787>, <0.02379, 0.2364, 0.07489>, <0.00663, 0.284, 0.09701> }
				triangle { <0.00663, 0.284, 0.09701>, <0.006999, 0.348, 0.1251>, <0.02435, 0.3324, 0.117> }
				triangle { <0.00663, 0.284, 0.09701>, <0.02435, 0.3324, 0.117>, <0.006999, 0.348, 0.1251> }
				triangle { <0.006999, 0.348, 0.1251>, <0.007368, 0.4121, 0.1532>, <0.00626, 0.4191, 0.1372> }
				triangle { <0.006999, 0.348, 0.1251>, <0.00626, 0.4191, 0.1372>, <0.007368, 0.4121, 0.1532> }
				triangle { <0.007368, 0.4121, 0.1532>, <-0.009704, 0.4757, 0.1823>, <0.00626, 0.4191, 0.1372> }
				triangle { <0.007368, 0.4121, 0.1532>, <0.00626, 0.4191, 0.1372>, <-0.009704, 0.4757, 0.1823> }
				triangle { <-0.009704, 0.4757, 0.1823>, <-0.009336, 0.5397, 0.2104>, <0.006813, 0.5151, 0.1793> }
				triangle { <-0.009704, 0.4757, 0.1823>, <0.006813, 0.5151, 0.1793>, <-0.009336, 0.5397, 0.2104> }
				triangle { <-0.009336, 0.5397, 0.2104>, <-0.008967, 0.6037, 0.2385>, <-0.01016, 0.5948, 0.2155> }
				triangle { <-0.009336, 0.5397, 0.2104>, <-0.01016, 0.5948, 0.2155>, <-0.008967, 0.6037, 0.2385> }
				triangle { <-0.008967, 0.6037, 0.2385>, <-0.02604, 0.6674, 0.2676>, <-0.02714, 0.6744, 0.2517> }
				triangle { <-0.008967, 0.6037, 0.2385>, <-0.02714, 0.6744, 0.2517>, <-0.02604, 0.6674, 0.2676> }
				triangle { <-0.02604, 0.6674, 0.2676>, <-0.04311, 0.7311, 0.2968>, <-0.02714, 0.6744, 0.2517> }
				triangle { <-0.02604, 0.6674, 0.2676>, <-0.02714, 0.6744, 0.2517>, <-0.04311, 0.7311, 0.2968> }
				triangle { <-0.04311, 0.7311, 0.2968>, <-0.04274, 0.7951, 0.3249>, <-0.02668, 0.7544, 0.2868> }
				triangle { <-0.04311, 0.7311, 0.2968>, <-0.02668, 0.7544, 0.2868>, <-0.04274, 0.7951, 0.3249> }
				triangle { <-0.04274, 0.7951, 0.3249>, <-0.05991, 0.8427, 0.347>, <-0.04357, 0.8501, 0.33> }
				triangle { <-0.04274, 0.7951, 0.3249>, <-0.04357, 0.8501, 0.33>, <-0.05991, 0.8427, 0.347> }
				triangle { <-0.05991, 0.8427, 0.347>, <-0.07698, 0.9064, 0.3761>, <-0.078, 0.9294, 0.3672> }
				triangle { <-0.05991, 0.8427, 0.347>, <-0.078, 0.9294, 0.3672>, <-0.07698, 0.9064, 0.3761> }
				triangle { <-0.07698, 0.9064, 0.3761>, <-0.09405, 0.97, 0.4053>, <-0.078, 0.9294, 0.3672> }
				triangle { <-0.07698, 0.9064, 0.3761>, <-0.078, 0.9294, 0.3672>, <-0.09405, 0.97, 0.4053> }
				triangle { <-0.09405, 0.97, 0.4053>, <-0.1111, 1.03374, 0.4344>, <-0.09498, 1.009113, 0.4034> }
				triangle { <-0.09405, 0.97, 0.4053>, <-0.09498, 1.009113, 0.4034>, <-0.1111, 1.03374, 0.4344> }
				triangle { <-0.1111, 1.03374, 0.4344>, <-0.127, 1.09038, 0.4795>, <-0.1108, 1.08176, 0.4555> }
				triangle { <-0.1111, 1.03374, 0.4344>, <-0.1108, 1.08176, 0.4555>, <-0.127, 1.09038, 0.4795> }
				triangle { <-0.127, 1.09038, 0.4795>, <-0.1442, 1.138, 0.5017>, <-0.1452, 1.161, 0.4927> }
				triangle { <-0.127, 1.09038, 0.4795>, <-0.1452, 1.161, 0.4927>, <-0.1442, 1.138, 0.5017> }
				triangle { <-0.1442, 1.138, 0.5017>, <-0.1613, 1.2016, 0.5308>, <-0.1439, 1.186, 0.5227> }
				triangle { <-0.1442, 1.138, 0.5017>, <-0.1439, 1.186, 0.5227>, <-0.1613, 1.2016, 0.5308> }
				triangle { <-0.1613, 1.2016, 0.5308>, <-0.1773, 1.2423, 0.5689>, <-0.1611, 1.2337, 0.5449> }
				triangle { <-0.1613, 1.2016, 0.5308>, <-0.1611, 1.2337, 0.5449>, <-0.1773, 1.2423, 0.5689> }
				triangle { <-0.1773, 1.2423, 0.5689>, <-0.1944, 1.3059, 0.598>, <-0.1771, 1.2903, 0.59> }
				triangle { <-0.1773, 1.2423, 0.5689>, <-0.1771, 1.2903, 0.59>, <-0.1944, 1.3059, 0.598> }
				triangle { <-0.1944, 1.3059, 0.598>, <-0.2105, 1.3466, 0.6361>, <-0.193, 1.3469, 0.6351> }
				triangle { <-0.1944, 1.3059, 0.598>, <-0.193, 1.3469, 0.6351>, <-0.2105, 1.3466, 0.6361> }
				triangle { <-0.2105, 1.3466, 0.6361>, <-0.2264, 1.4032, 0.6813>, <-0.2264, 1.4032, 0.6813> }
				triangle { <-0.2105, 1.3466, 0.6361>, <-0.2264, 1.4032, 0.6813>, <-0.2264, 1.4032, 0.6813> }
				triangle { <-0.2264, 1.4032, 0.6813>, <-0.2425, 1.4439, 0.7193>, <-0.2264, 1.4032, 0.6813> }
				triangle { <-0.2264, 1.4032, 0.6813>, <-0.2264, 1.4032, 0.6813>, <-0.2425, 1.4439, 0.7193> }
				triangle { <-0.2264, 1.4032, 0.6813>, <-0.193, 1.3469, 0.6351>, <-0.2105, 1.3466, 0.6361> }
				triangle { <-0.2264, 1.4032, 0.6813>, <-0.2105, 1.3466, 0.6361>, <-0.193, 1.3469, 0.6351> }
				triangle { <-0.193, 1.3469, 0.6351>, <-0.1771, 1.2903, 0.59>, <-0.1944, 1.3059, 0.598> }
				triangle { <-0.193, 1.3469, 0.6351>, <-0.1944, 1.3059, 0.598>, <-0.1771, 1.2903, 0.59> }
				triangle { <-0.1771, 1.2903, 0.59>, <-0.1611, 1.2337, 0.5449>, <-0.1773, 1.2423, 0.5689> }
				triangle { <-0.1771, 1.2903, 0.59>, <-0.1773, 1.2423, 0.5689>, <-0.1611, 1.2337, 0.5449> }
				triangle { <-0.1611, 1.2337, 0.5449>, <-0.1439, 1.186, 0.5227>, <-0.1613, 1.2016, 0.5308> }
				triangle { <-0.1611, 1.2337, 0.5449>, <-0.1613, 1.2016, 0.5308>, <-0.1439, 1.186, 0.5227> }
				triangle { <0.02379, 0.2364, 0.07489>, <0.02352, 0.1884, 0.05382>, <0.0237, 0.2204, 0.06787> }
				triangle { <0.02379, 0.2364, 0.07489>, <0.0237, 0.2204, 0.06787>, <0.02352, 0.1884, 0.05382> }
				triangle { <0.02352, 0.1884, 0.05382>, <0.02315, 0.1243, 0.02573>, <0.02333, 0.1563, 0.03978> }
				triangle { <0.02352, 0.1884, 0.05382>, <0.02333, 0.1563, 0.03978>, <0.02315, 0.1243, 0.02573> }
				triangle { <-0.1439, 1.186, 0.5227>, <-0.1452, 1.161, 0.4927>, <-0.1442, 1.138, 0.5017> }
				triangle { <-0.1439, 1.186, 0.5227>, <-0.1442, 1.138, 0.5017>, <-0.1452, 1.161, 0.4927> }
				triangle { <-0.1452, 1.161, 0.4927>, <-0.1108, 1.08176, 0.4555>, <-0.127, 1.09038, 0.4795> }
				triangle { <-0.1452, 1.161, 0.4927>, <-0.127, 1.09038, 0.4795>, <-0.1108, 1.08176, 0.4555> }
				triangle { <-0.1108, 1.08176, 0.4555>, <-0.09498, 1.009113, 0.4034>, <-0.1111, 1.03374, 0.4344> }
				triangle { <-0.1108, 1.08176, 0.4555>, <-0.1111, 1.03374, 0.4344>, <-0.09498, 1.009113, 0.4034> }
				triangle { <-0.09498, 1.009113, 0.4034>, <-0.078, 0.9294, 0.3672>, <-0.09405, 0.97, 0.4053> }
				triangle { <-0.09498, 1.009113, 0.4034>, <-0.09405, 0.97, 0.4053>, <-0.078, 0.9294, 0.3672> }
				triangle { <-0.078, 0.9294, 0.3672>, <-0.04357, 0.8501, 0.33>, <-0.05991, 0.8427, 0.347> }
				triangle { <-0.078, 0.9294, 0.3672>, <-0.05991, 0.8427, 0.347>, <-0.04357, 0.8501, 0.33> }
				triangle { <-0.04357, 0.8501, 0.33>, <-0.02668, 0.7544, 0.2868>, <-0.04274, 0.7951, 0.3249> }
				triangle { <-0.04357, 0.8501, 0.33>, <-0.04274, 0.7951, 0.3249>, <-0.02668, 0.7544, 0.2868> }
				triangle { <-0.02668, 0.7544, 0.2868>, <-0.02714, 0.6744, 0.2517>, <-0.04311, 0.7311, 0.2968> }
				triangle { <-0.02668, 0.7544, 0.2868>, <-0.04311, 0.7311, 0.2968>, <-0.02714, 0.6744, 0.2517> }
				triangle { <-0.02714, 0.6744, 0.2517>, <-0.01016, 0.5948, 0.2155>, <-0.008967, 0.6037, 0.2385> }
				triangle { <-0.02714, 0.6744, 0.2517>, <-0.008967, 0.6037, 0.2385>, <-0.01016, 0.5948, 0.2155> }
				triangle { <-0.01016, 0.5948, 0.2155>, <0.006813, 0.5151, 0.1793>, <-0.009336, 0.5397, 0.2104> }
				triangle { <-0.01016, 0.5948, 0.2155>, <-0.009336, 0.5397, 0.2104>, <0.006813, 0.5151, 0.1793> }
				triangle { <0.006813, 0.5151, 0.1793>, <0.00626, 0.4191, 0.1372>, <-0.009704, 0.4757, 0.1823> }
				triangle { <0.006813, 0.5151, 0.1793>, <-0.009704, 0.4757, 0.1823>, <0.00626, 0.4191, 0.1372> }
				triangle { <0.00626, 0.4191, 0.1372>, <0.02435, 0.3324, 0.117>, <0.006999, 0.348, 0.1251> }
				triangle { <0.00626, 0.4191, 0.1372>, <0.006999, 0.348, 0.1251>, <0.02435, 0.3324, 0.117> }
				triangle { <0.02435, 0.3324, 0.117>, <0.02379, 0.2364, 0.07489>, <0.00663, 0.284, 0.09701> }
				triangle { <0.02435, 0.3324, 0.117>, <0.00663, 0.284, 0.09701>, <0.02379, 0.2364, 0.07489> }
				texture {T_ClumpLeaf2}}
			union { // Petiole
				cylinder { <0.009798, 0.06741, 0.0004223>, <0.0136, 0.07129, -0.0009273>, 0.0003978 }
				cylinder { <0.0136, 0.07129, -0.0009273>, <0.01742, 0.07517, -0.002277>, 0.0003978 }
				cylinder { <0.01742, 0.07517, -0.002277>, <0.02123, 0.07905, -0.003626>, 0.0003978 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <0.02123, 0.07905, -0.003626>, <0.01231, 0.1306, -0.005704>, <0.01231, 0.1306, -0.005704> }
				triangle { <0.02123, 0.07905, -0.003626>, <0.01231, 0.1306, -0.005704>, <0.01231, 0.1306, -0.005704> }
				triangle { <0.01231, 0.1306, -0.005704>, <0.006376, 0.1651, -0.00709>, <0.01231, 0.1306, -0.005704> }
				triangle { <0.01231, 0.1306, -0.005704>, <0.01231, 0.1306, -0.005704>, <0.006376, 0.1651, -0.00709> }
				triangle { <0.006376, 0.1651, -0.00709>, <-0.005508, 0.2339, -0.009861>, <0.0004339, 0.1995, -0.008475> }
				triangle { <0.006376, 0.1651, -0.00709>, <0.0004339, 0.1995, -0.008475>, <-0.005508, 0.2339, -0.009861> }
				triangle { <-0.005508, 0.2339, -0.009861>, <-0.03077, 0.3009, -0.00155>, <-0.008479, 0.2511, -0.01055> }
				triangle { <-0.005508, 0.2339, -0.009861>, <-0.008479, 0.2511, -0.01055>, <-0.03077, 0.3009, -0.00155> }
				triangle { <-0.03077, 0.3009, -0.00155>, <-0.04266, 0.3697, -0.004321>, <-0.0263, 0.3544, -0.01471> }
				triangle { <-0.03077, 0.3009, -0.00155>, <-0.0263, 0.3544, -0.01471>, <-0.04266, 0.3697, -0.004321> }
				triangle { <-0.04266, 0.3697, -0.004321>, <-0.05454, 0.4385, -0.007092>, <-0.06538, 0.4361, -0.02059> }
				triangle { <-0.04266, 0.3697, -0.004321>, <-0.06538, 0.4361, -0.02059>, <-0.05454, 0.4385, -0.007092> }
				triangle { <-0.05454, 0.4385, -0.007092>, <-0.07981, 0.5055, 0.001217>, <-0.06538, 0.4361, -0.02059> }
				triangle { <-0.05454, 0.4385, -0.007092>, <-0.06538, 0.4361, -0.02059>, <-0.07981, 0.5055, 0.001217> }
				triangle { <-0.07981, 0.5055, 0.001217>, <-0.0917, 0.5744, -0.001553>, <-0.08321, 0.5394, -0.02474> }
				triangle { <-0.07981, 0.5055, 0.001217>, <-0.08321, 0.5394, -0.02474>, <-0.0917, 0.5744, -0.001553> }
				triangle { <-0.0917, 0.5744, -0.001553>, <-0.1035, 0.6432, -0.004324>, <-0.1114, 0.6236, -0.01712> }
				triangle { <-0.0917, 0.5744, -0.001553>, <-0.1114, 0.6236, -0.01712>, <-0.1035, 0.6432, -0.004324> }
				triangle { <-0.1035, 0.6432, -0.004324>, <-0.1288, 0.7102, 0.003986>, <-0.1396, 0.7078, -0.009511> }
				triangle { <-0.1035, 0.6432, -0.004324>, <-0.1396, 0.7078, -0.009511>, <-0.1288, 0.7102, 0.003986> }
				triangle { <-0.1288, 0.7102, 0.003986>, <-0.1541, 0.7771, 0.01229>, <-0.1396, 0.7078, -0.009511> }
				triangle { <-0.1288, 0.7102, 0.003986>, <-0.1396, 0.7078, -0.009511>, <-0.1541, 0.7771, 0.01229> }
				triangle { <-0.1541, 0.7771, 0.01229>, <-0.166, 0.846, 0.009526>, <-0.1545, 0.7938, -0.01297> }
				triangle { <-0.1541, 0.7771, 0.01229>, <-0.1545, 0.7938, -0.01297>, <-0.166, 0.846, 0.009526> }
				triangle { <-0.166, 0.846, 0.009526>, <-0.1883, 0.8957, 0.01852>, <-0.1857, 0.8952, -0.00605> }
				triangle { <-0.166, 0.846, 0.009526>, <-0.1857, 0.8952, -0.00605>, <-0.1883, 0.8957, 0.01852> }
				triangle { <-0.1883, 0.8957, 0.01852>, <-0.2135, 0.9627, 0.02683>, <-0.2273, 0.9775, 0.01264> }
				triangle { <-0.1883, 0.8957, 0.01852>, <-0.2273, 0.9775, 0.01264>, <-0.2135, 0.9627, 0.02683> }
				triangle { <-0.2135, 0.9627, 0.02683>, <-0.2388, 1.02973, 0.03515>, <-0.2273, 0.9775, 0.01264> }
				triangle { <-0.2135, 0.9627, 0.02683>, <-0.2273, 0.9775, 0.01264>, <-0.2388, 1.02973, 0.03515> }
				triangle { <-0.2388, 1.02973, 0.03515>, <-0.2641, 1.09671, 0.04346>, <-0.2556, 1.06174, 0.02026> }
				triangle { <-0.2388, 1.02973, 0.03515>, <-0.2556, 1.06174, 0.02026>, <-0.2641, 1.09671, 0.04346> }
				triangle { <-0.2641, 1.09671, 0.04346>, <-0.2785, 1.166, 0.06526>, <-0.273, 1.1483, 0.04138> }
				triangle { <-0.2641, 1.09671, 0.04346>, <-0.273, 1.1483, 0.04138>, <-0.2785, 1.166, 0.06526> }
				triangle { <-0.2785, 1.166, 0.06526>, <-0.3008, 1.2158, 0.07427>, <-0.3146, 1.2306, 0.06008> }
				triangle { <-0.2785, 1.166, 0.06526>, <-0.3146, 1.2306, 0.06008>, <-0.3008, 1.2158, 0.07427> }
				triangle { <-0.3008, 1.2158, 0.07427>, <-0.3261, 1.2828, 0.08258>, <-0.3097, 1.2674, 0.07219> }
				triangle { <-0.3008, 1.2158, 0.07427>, <-0.3097, 1.2674, 0.07219>, <-0.3261, 1.2828, 0.08258> }
				triangle { <-0.3261, 1.2828, 0.08258>, <-0.3375, 1.335, 0.105>, <-0.332, 1.3172, 0.08119> }
				triangle { <-0.3261, 1.2828, 0.08258>, <-0.332, 1.3172, 0.08119>, <-0.3375, 1.335, 0.105> }
				triangle { <-0.3375, 1.335, 0.105>, <-0.3628, 1.4019, 0.1133>, <-0.3465, 1.3866, 0.103> }
				triangle { <-0.3375, 1.335, 0.105>, <-0.3465, 1.3866, 0.103>, <-0.3628, 1.4019, 0.1133> }
				triangle { <-0.3628, 1.4019, 0.1133>, <-0.3743, 1.4541, 0.1358>, <-0.3609, 1.456, 0.1248> }
				triangle { <-0.3628, 1.4019, 0.1133>, <-0.3609, 1.456, 0.1248>, <-0.3743, 1.4541, 0.1358> }
				triangle { <-0.3743, 1.4541, 0.1358>, <-0.3887, 1.5235, 0.1577>, <-0.3887, 1.5235, 0.1577> }
				triangle { <-0.3743, 1.4541, 0.1358>, <-0.3887, 1.5235, 0.1577>, <-0.3887, 1.5235, 0.1577> }
				triangle { <-0.3887, 1.5235, 0.1577>, <-0.4002, 1.5757, 0.1802>, <-0.3887, 1.5235, 0.1577> }
				triangle { <-0.3887, 1.5235, 0.1577>, <-0.3887, 1.5235, 0.1577>, <-0.4002, 1.5757, 0.1802> }
				triangle { <-0.3887, 1.5235, 0.1577>, <-0.3609, 1.456, 0.1248>, <-0.3743, 1.4541, 0.1358> }
				triangle { <-0.3887, 1.5235, 0.1577>, <-0.3743, 1.4541, 0.1358>, <-0.3609, 1.456, 0.1248> }
				triangle { <-0.3609, 1.456, 0.1248>, <-0.3465, 1.3866, 0.103>, <-0.3628, 1.4019, 0.1133> }
				triangle { <-0.3609, 1.456, 0.1248>, <-0.3628, 1.4019, 0.1133>, <-0.3465, 1.3866, 0.103> }
				triangle { <-0.3465, 1.3866, 0.103>, <-0.332, 1.3172, 0.08119>, <-0.3375, 1.335, 0.105> }
				triangle { <-0.3465, 1.3866, 0.103>, <-0.3375, 1.335, 0.105>, <-0.332, 1.3172, 0.08119> }
				triangle { <-0.332, 1.3172, 0.08119>, <-0.3097, 1.2674, 0.07219>, <-0.3261, 1.2828, 0.08258> }
				triangle { <-0.332, 1.3172, 0.08119>, <-0.3261, 1.2828, 0.08258>, <-0.3097, 1.2674, 0.07219> }
				triangle { <-0.008479, 0.2511, -0.01055>, <0.0004339, 0.1995, -0.008475>, <-0.005508, 0.2339, -0.009861> }
				triangle { <-0.008479, 0.2511, -0.01055>, <-0.005508, 0.2339, -0.009861>, <0.0004339, 0.1995, -0.008475> }
				triangle { <0.0004339, 0.1995, -0.008475>, <0.01231, 0.1306, -0.005704>, <0.006376, 0.1651, -0.00709> }
				triangle { <0.0004339, 0.1995, -0.008475>, <0.006376, 0.1651, -0.00709>, <0.01231, 0.1306, -0.005704> }
				triangle { <-0.3097, 1.2674, 0.07219>, <-0.3146, 1.2306, 0.06008>, <-0.3008, 1.2158, 0.07427> }
				triangle { <-0.3097, 1.2674, 0.07219>, <-0.3008, 1.2158, 0.07427>, <-0.3146, 1.2306, 0.06008> }
				triangle { <-0.3146, 1.2306, 0.06008>, <-0.273, 1.1483, 0.04138>, <-0.2785, 1.166, 0.06526> }
				triangle { <-0.3146, 1.2306, 0.06008>, <-0.2785, 1.166, 0.06526>, <-0.273, 1.1483, 0.04138> }
				triangle { <-0.273, 1.1483, 0.04138>, <-0.2556, 1.06174, 0.02026>, <-0.2641, 1.09671, 0.04346> }
				triangle { <-0.273, 1.1483, 0.04138>, <-0.2641, 1.09671, 0.04346>, <-0.2556, 1.06174, 0.02026> }
				triangle { <-0.2556, 1.06174, 0.02026>, <-0.2273, 0.9775, 0.01264>, <-0.2388, 1.02973, 0.03515> }
				triangle { <-0.2556, 1.06174, 0.02026>, <-0.2388, 1.02973, 0.03515>, <-0.2273, 0.9775, 0.01264> }
				triangle { <-0.2273, 0.9775, 0.01264>, <-0.1857, 0.8952, -0.00605>, <-0.1883, 0.8957, 0.01852> }
				triangle { <-0.2273, 0.9775, 0.01264>, <-0.1883, 0.8957, 0.01852>, <-0.1857, 0.8952, -0.00605> }
				triangle { <-0.1857, 0.8952, -0.00605>, <-0.1545, 0.7938, -0.01297>, <-0.166, 0.846, 0.009526> }
				triangle { <-0.1857, 0.8952, -0.00605>, <-0.166, 0.846, 0.009526>, <-0.1545, 0.7938, -0.01297> }
				triangle { <-0.1545, 0.7938, -0.01297>, <-0.1396, 0.7078, -0.009511>, <-0.1541, 0.7771, 0.01229> }
				triangle { <-0.1545, 0.7938, -0.01297>, <-0.1541, 0.7771, 0.01229>, <-0.1396, 0.7078, -0.009511> }
				triangle { <-0.1396, 0.7078, -0.009511>, <-0.1114, 0.6236, -0.01712>, <-0.1035, 0.6432, -0.004324> }
				triangle { <-0.1396, 0.7078, -0.009511>, <-0.1035, 0.6432, -0.004324>, <-0.1114, 0.6236, -0.01712> }
				triangle { <-0.1114, 0.6236, -0.01712>, <-0.08321, 0.5394, -0.02474>, <-0.0917, 0.5744, -0.001553> }
				triangle { <-0.1114, 0.6236, -0.01712>, <-0.0917, 0.5744, -0.001553>, <-0.08321, 0.5394, -0.02474> }
				triangle { <-0.08321, 0.5394, -0.02474>, <-0.06538, 0.4361, -0.02059>, <-0.07981, 0.5055, 0.001217> }
				triangle { <-0.08321, 0.5394, -0.02474>, <-0.07981, 0.5055, 0.001217>, <-0.06538, 0.4361, -0.02059> }
				triangle { <-0.06538, 0.4361, -0.02059>, <-0.0263, 0.3544, -0.01471>, <-0.04266, 0.3697, -0.004321> }
				triangle { <-0.06538, 0.4361, -0.02059>, <-0.04266, 0.3697, -0.004321>, <-0.0263, 0.3544, -0.01471> }
				triangle { <-0.0263, 0.3544, -0.01471>, <-0.008479, 0.2511, -0.01055>, <-0.03077, 0.3009, -0.00155> }
				triangle { <-0.0263, 0.3544, -0.01471>, <-0.03077, 0.3009, -0.00155>, <-0.008479, 0.2511, -0.01055> }
				texture {T_ClumpLeaf2}}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-0.002917, 0.04537, 0.003986>, <-0.004791, 0.0517, 0.005502>, 0.0004809 }
			cylinder { <-0.004791, 0.0517, 0.005502>, <-0.008162, 0.05718, 0.007618>, 0.0004809 }
			cylinder { <-0.008162, 0.05718, 0.007618>, <-0.01278, 0.06142, 0.01018>, 0.0004809 }
			texture {T_ClumpLeaf}}
		union { // compound leaf
			union { // Petiole
				cylinder { <-0.01278, 0.06142, 0.01018>, <-0.0142, 0.06265, 0.01095>, 0.0004809 }
				cylinder { <-0.0142, 0.06265, 0.01095>, <-0.01564, 0.06384, 0.01174>, 0.0004809 }
				cylinder { <-0.01564, 0.06384, 0.01174>, <-0.01712, 0.06499, 0.01254>, 0.0004809 }
				texture {T_ClumpLeaf}}
			union { // Petiole
				cylinder { <-0.01712, 0.06499, 0.01254>, <-0.02166, 0.06819, 0.0133>, 0.0003978 }
				cylinder { <-0.02166, 0.06819, 0.0133>, <-0.02634, 0.07119, 0.01258>, 0.0003978 }
				cylinder { <-0.02634, 0.07119, 0.01258>, <-0.03083, 0.07376, 0.01042>, 0.0003978 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <-0.03083, 0.07376, 0.01042>, <-0.03466, 0.1252, 0.00128>, <-0.03466, 0.1252, 0.00128> }
				triangle { <-0.03083, 0.07376, 0.01042>, <-0.03466, 0.1252, 0.00128>, <-0.03466, 0.1252, 0.00128> }
				triangle { <-0.03466, 0.1252, 0.00128>, <-0.03721, 0.1595, -0.004816>, <-0.03466, 0.1252, 0.00128> }
				triangle { <-0.03466, 0.1252, 0.00128>, <-0.03466, 0.1252, 0.00128>, <-0.03721, 0.1595, -0.004816> }
				triangle { <-0.03721, 0.1595, -0.004816>, <-0.04232, 0.2282, -0.01701>, <-0.03977, 0.1938, -0.01091> }
				triangle { <-0.03721, 0.1595, -0.004816>, <-0.03977, 0.1938, -0.01091>, <-0.04232, 0.2282, -0.01701> }
				triangle { <-0.04232, 0.2282, -0.01701>, <-0.03001, 0.2979, -0.03016>, <-0.0436, 0.2453, -0.02005> }
				triangle { <-0.04232, 0.2282, -0.01701>, <-0.0436, 0.2453, -0.02005>, <-0.03001, 0.2979, -0.03016> }
				triangle { <-0.03001, 0.2979, -0.03016>, <-0.03512, 0.3666, -0.04235>, <-0.05126, 0.3483, -0.03834> }
				triangle { <-0.03001, 0.2979, -0.03016>, <-0.05126, 0.3483, -0.03834>, <-0.03512, 0.3666, -0.04235> }
				triangle { <-0.03512, 0.3666, -0.04235>, <-0.04023, 0.4352, -0.05455>, <-0.03948, 0.4384, -0.03736> }
				triangle { <-0.03512, 0.3666, -0.04235>, <-0.03948, 0.4384, -0.03736>, <-0.04023, 0.4352, -0.05455> }
				triangle { <-0.04023, 0.4352, -0.05455>, <-0.02792, 0.505, -0.0677>, <-0.03948, 0.4384, -0.03736> }
				triangle { <-0.04023, 0.4352, -0.05455>, <-0.03948, 0.4384, -0.03736>, <-0.02792, 0.505, -0.0677> }
				triangle { <-0.02792, 0.505, -0.0677>, <-0.03303, 0.5737, -0.07989>, <-0.04715, 0.5413, -0.05565> }
				triangle { <-0.02792, 0.505, -0.0677>, <-0.04715, 0.5413, -0.05565>, <-0.03303, 0.5737, -0.07989> }
				triangle { <-0.03303, 0.5737, -0.07989>, <-0.03814, 0.6423, -0.09209>, <-0.03612, 0.6283, -0.07185> }
				triangle { <-0.03303, 0.5737, -0.07989>, <-0.03612, 0.6283, -0.07185>, <-0.03814, 0.6423, -0.09209> }
				triangle { <-0.03814, 0.6423, -0.09209>, <-0.02583, 0.7121, -0.1052>, <-0.02509, 0.7152, -0.08806> }
				triangle { <-0.03814, 0.6423, -0.09209>, <-0.02509, 0.7152, -0.08806>, <-0.02583, 0.7121, -0.1052> }
				triangle { <-0.02583, 0.7121, -0.1052>, <-0.01353, 0.7819, -0.1183>, <-0.02509, 0.7152, -0.08806> }
				triangle { <-0.02583, 0.7121, -0.1052>, <-0.02509, 0.7152, -0.08806>, <-0.01353, 0.7819, -0.1183> }
				triangle { <-0.01353, 0.7819, -0.1183>, <-0.01864, 0.8505, -0.1305>, <-0.03147, 0.801, -0.1033> }
				triangle { <-0.01353, 0.7819, -0.1183>, <-0.03147, 0.801, -0.1033>, <-0.01864, 0.8505, -0.1305> }
				triangle { <-0.01864, 0.8505, -0.1305>, <-0.005057, 0.9031, -0.1406>, <-0.02172, 0.9051, -0.1225> }
				triangle { <-0.01864, 0.8505, -0.1305>, <-0.02172, 0.9051, -0.1225>, <-0.005057, 0.9031, -0.1406> }
				triangle { <-0.005057, 0.9031, -0.1406>, <0.007249, 0.9729, -0.1538>, <0.006718, 0.9932, -0.1397> }
				triangle { <-0.005057, 0.9031, -0.1406>, <0.006718, 0.9932, -0.1397>, <0.007249, 0.9729, -0.1538> }
				triangle { <0.007249, 0.9729, -0.1538>, <0.01955, 1.04274, -0.167>, <0.006718, 0.9932, -0.1397> }
				triangle { <0.007249, 0.9729, -0.1538>, <0.006718, 0.9932, -0.1397>, <0.01955, 1.04274, -0.167> }
				triangle { <0.01955, 1.04274, -0.167>, <0.03186, 1.1125, -0.1801>, <0.01774, 1.08017, -0.1559> }
				triangle { <0.01955, 1.04274, -0.167>, <0.01774, 1.08017, -0.1559>, <0.03186, 1.1125, -0.1801> }
				triangle { <0.03186, 1.1125, -0.1801>, <0.04342, 1.1791, -0.2104>, <0.02803, 1.164, -0.1893> }
				triangle { <0.03186, 1.1125, -0.1801>, <0.02803, 1.164, -0.1893>, <0.04342, 1.1791, -0.2104> }
				triangle { <0.04342, 1.1791, -0.2104>, <0.057, 1.2317, -0.2206>, <0.05647, 1.252, -0.2064> }
				triangle { <0.04342, 1.1791, -0.2104>, <0.05647, 1.252, -0.2064>, <0.057, 1.2317, -0.2206> }
				triangle { <0.057, 1.2317, -0.2206>, <0.06931, 1.3015, -0.2337>, <0.05317, 1.2832, -0.2297> }
				triangle { <0.057, 1.2317, -0.2206>, <0.05317, 1.2832, -0.2297>, <0.06931, 1.3015, -0.2337> }
				triangle { <0.06931, 1.3015, -0.2337>, <0.08215, 1.351, -0.261>, <0.06675, 1.3358, -0.2398> }
				triangle { <0.06931, 1.3015, -0.2337>, <0.06675, 1.3358, -0.2398>, <0.08215, 1.351, -0.261> }
				triangle { <0.08215, 1.351, -0.261>, <0.09445, 1.4208, -0.2741>, <0.07831, 1.4025, -0.2701> }
				triangle { <0.08215, 1.351, -0.261>, <0.07831, 1.4025, -0.2701>, <0.09445, 1.4208, -0.2741> }
				triangle { <0.09445, 1.4208, -0.2741>, <0.1072, 1.4703, -0.3014>, <0.08987, 1.4692, -0.3005> }
				triangle { <0.09445, 1.4208, -0.2741>, <0.08987, 1.4692, -0.3005>, <0.1072, 1.4703, -0.3014> }
				triangle { <0.1072, 1.4703, -0.3014>, <0.1188, 1.537, -0.3318>, <0.1188, 1.537, -0.3318> }
				triangle { <0.1072, 1.4703, -0.3014>, <0.1188, 1.537, -0.3318>, <0.1188, 1.537, -0.3318> }
				triangle { <0.1188, 1.537, -0.3318>, <0.1316, 1.5865, -0.3591>, <0.1188, 1.537, -0.3318> }
				triangle { <0.1188, 1.537, -0.3318>, <0.1188, 1.537, -0.3318>, <0.1316, 1.5865, -0.3591> }
				triangle { <0.1188, 1.537, -0.3318>, <0.08987, 1.4692, -0.3005>, <0.1072, 1.4703, -0.3014> }
				triangle { <0.1188, 1.537, -0.3318>, <0.1072, 1.4703, -0.3014>, <0.08987, 1.4692, -0.3005> }
				triangle { <0.08987, 1.4692, -0.3005>, <0.07831, 1.4025, -0.2701>, <0.09445, 1.4208, -0.2741> }
				triangle { <0.08987, 1.4692, -0.3005>, <0.09445, 1.4208, -0.2741>, <0.07831, 1.4025, -0.2701> }
				triangle { <0.07831, 1.4025, -0.2701>, <0.06675, 1.3358, -0.2398>, <0.08215, 1.351, -0.261> }
				triangle { <0.07831, 1.4025, -0.2701>, <0.08215, 1.351, -0.261>, <0.06675, 1.3358, -0.2398> }
				triangle { <0.06675, 1.3358, -0.2398>, <0.05317, 1.2832, -0.2297>, <0.06931, 1.3015, -0.2337> }
				triangle { <0.06675, 1.3358, -0.2398>, <0.06931, 1.3015, -0.2337>, <0.05317, 1.2832, -0.2297> }
				triangle { <-0.0436, 0.2453, -0.02005>, <-0.03977, 0.1938, -0.01091>, <-0.04232, 0.2282, -0.01701> }
				triangle { <-0.0436, 0.2453, -0.02005>, <-0.04232, 0.2282, -0.01701>, <-0.03977, 0.1938, -0.01091> }
				triangle { <-0.03977, 0.1938, -0.01091>, <-0.03466, 0.1252, 0.00128>, <-0.03721, 0.1595, -0.004816> }
				triangle { <-0.03977, 0.1938, -0.01091>, <-0.03721, 0.1595, -0.004816>, <-0.03466, 0.1252, 0.00128> }
				triangle { <0.05317, 1.2832, -0.2297>, <0.05647, 1.252, -0.2064>, <0.057, 1.2317, -0.2206> }
				triangle { <0.05317, 1.2832, -0.2297>, <0.057, 1.2317, -0.2206>, <0.05647, 1.252, -0.2064> }
				triangle { <0.05647, 1.252, -0.2064>, <0.02803, 1.164, -0.1893>, <0.04342, 1.1791, -0.2104> }
				triangle { <0.05647, 1.252, -0.2064>, <0.04342, 1.1791, -0.2104>, <0.02803, 1.164, -0.1893> }
				triangle { <0.02803, 1.164, -0.1893>, <0.01774, 1.08017, -0.1559>, <0.03186, 1.1125, -0.1801> }
				triangle { <0.02803, 1.164, -0.1893>, <0.03186, 1.1125, -0.1801>, <0.01774, 1.08017, -0.1559> }
				triangle { <0.01774, 1.08017, -0.1559>, <0.006718, 0.9932, -0.1397>, <0.01955, 1.04274, -0.167> }
				triangle { <0.01774, 1.08017, -0.1559>, <0.01955, 1.04274, -0.167>, <0.006718, 0.9932, -0.1397> }
				triangle { <0.006718, 0.9932, -0.1397>, <-0.02172, 0.9051, -0.1225>, <-0.005057, 0.9031, -0.1406> }
				triangle { <0.006718, 0.9932, -0.1397>, <-0.005057, 0.9031, -0.1406>, <-0.02172, 0.9051, -0.1225> }
				triangle { <-0.02172, 0.9051, -0.1225>, <-0.03147, 0.801, -0.1033>, <-0.01864, 0.8505, -0.1305> }
				triangle { <-0.02172, 0.9051, -0.1225>, <-0.01864, 0.8505, -0.1305>, <-0.03147, 0.801, -0.1033> }
				triangle { <-0.03147, 0.801, -0.1033>, <-0.02509, 0.7152, -0.08806>, <-0.01353, 0.7819, -0.1183> }
				triangle { <-0.03147, 0.801, -0.1033>, <-0.01353, 0.7819, -0.1183>, <-0.02509, 0.7152, -0.08806> }
				triangle { <-0.02509, 0.7152, -0.08806>, <-0.03612, 0.6283, -0.07185>, <-0.03814, 0.6423, -0.09209> }
				triangle { <-0.02509, 0.7152, -0.08806>, <-0.03814, 0.6423, -0.09209>, <-0.03612, 0.6283, -0.07185> }
				triangle { <-0.03612, 0.6283, -0.07185>, <-0.04715, 0.5413, -0.05565>, <-0.03303, 0.5737, -0.07989> }
				triangle { <-0.03612, 0.6283, -0.07185>, <-0.03303, 0.5737, -0.07989>, <-0.04715, 0.5413, -0.05565> }
				triangle { <-0.04715, 0.5413, -0.05565>, <-0.03948, 0.4384, -0.03736>, <-0.02792, 0.505, -0.0677> }
				triangle { <-0.04715, 0.5413, -0.05565>, <-0.02792, 0.505, -0.0677>, <-0.03948, 0.4384, -0.03736> }
				triangle { <-0.03948, 0.4384, -0.03736>, <-0.05126, 0.3483, -0.03834>, <-0.03512, 0.3666, -0.04235> }
				triangle { <-0.03948, 0.4384, -0.03736>, <-0.03512, 0.3666, -0.04235>, <-0.05126, 0.3483, -0.03834> }
				triangle { <-0.05126, 0.3483, -0.03834>, <-0.0436, 0.2453, -0.02005>, <-0.03001, 0.2979, -0.03016> }
				triangle { <-0.05126, 0.3483, -0.03834>, <-0.03001, 0.2979, -0.03016>, <-0.0436, 0.2453, -0.02005> }
				texture {T_ClumpLeaf2}}
			union { // Petiole
				cylinder { <-0.01712, 0.06499, 0.01254>, <-0.02118, 0.06817, 0.01473>, 0.0003978 }
				cylinder { <-0.02118, 0.06817, 0.01473>, <-0.02524, 0.07134, 0.01693>, 0.0003978 }
				cylinder { <-0.02524, 0.07134, 0.01693>, <-0.02931, 0.07452, 0.01912>, 0.0003978 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <-0.02931, 0.07452, 0.01912>, <-0.02403, 0.1246, 0.0334>, <-0.02403, 0.1246, 0.0334> }
				triangle { <-0.02931, 0.07452, 0.01912>, <-0.02403, 0.1246, 0.0334>, <-0.02403, 0.1246, 0.0334> }
				triangle { <-0.02403, 0.1246, 0.0334>, <-0.02051, 0.1581, 0.04292>, <-0.02403, 0.1246, 0.0334> }
				triangle { <-0.02403, 0.1246, 0.0334>, <-0.02403, 0.1246, 0.0334>, <-0.02051, 0.1581, 0.04292> }
				triangle { <-0.02051, 0.1581, 0.04292>, <-0.01348, 0.225, 0.06196>, <-0.017, 0.1915, 0.05244> }
				triangle { <-0.02051, 0.1581, 0.04292>, <-0.017, 0.1915, 0.05244>, <-0.01348, 0.225, 0.06196> }
				triangle { <-0.01348, 0.225, 0.06196>, <0.006942, 0.2936, 0.0699>, <-0.01172, 0.2417, 0.06672> }
				triangle { <-0.01348, 0.225, 0.06196>, <-0.01172, 0.2417, 0.06672>, <0.006942, 0.2936, 0.0699> }
				triangle { <0.006942, 0.2936, 0.0699>, <0.01397, 0.3605, 0.08894>, <-0.001171, 0.3421, 0.09528> }
				triangle { <0.006942, 0.2936, 0.0699>, <-0.001171, 0.3421, 0.09528>, <0.01397, 0.3605, 0.08894> }
				triangle { <0.01397, 0.3605, 0.08894>, <0.02101, 0.4274, 0.1079>, <0.0321, 0.4227, 0.1206> }
				triangle { <0.01397, 0.3605, 0.08894>, <0.0321, 0.4227, 0.1206>, <0.02101, 0.4274, 0.1079> }
				triangle { <0.02101, 0.4274, 0.1079>, <0.04143, 0.4961, 0.1159>, <0.0321, 0.4227, 0.1206> }
				triangle { <0.02101, 0.4274, 0.1079>, <0.0321, 0.4227, 0.1206>, <0.04143, 0.4961, 0.1159> }
				triangle { <0.04143, 0.4961, 0.1159>, <0.04847, 0.563, 0.1349>, <0.04265, 0.523, 0.1491> }
				triangle { <0.04143, 0.4961, 0.1159>, <0.04265, 0.523, 0.1491>, <0.04847, 0.563, 0.1349> }
				triangle { <0.04847, 0.563, 0.1349>, <0.0555, 0.6299, 0.154>, <0.06484, 0.6084, 0.1618> }
				triangle { <0.04847, 0.563, 0.1349>, <0.06484, 0.6084, 0.1618>, <0.0555, 0.6299, 0.154> }
				triangle { <0.0555, 0.6299, 0.154>, <0.07593, 0.6986, 0.1619>, <0.08702, 0.6938, 0.1745> }
				triangle { <0.0555, 0.6299, 0.154>, <0.08702, 0.6938, 0.1745>, <0.07593, 0.6986, 0.1619> }
				triangle { <0.07593, 0.6986, 0.1619>, <0.09636, 0.7672, 0.1698>, <0.08702, 0.6938, 0.1745> }
				triangle { <0.07593, 0.6986, 0.1619>, <0.08702, 0.6938, 0.1745>, <0.09636, 0.7672, 0.1698> }
				triangle { <0.09636, 0.7672, 0.1698>, <0.1033, 0.8341, 0.1889>, <0.09582, 0.7774, 0.1983> }
				triangle { <0.09636, 0.7672, 0.1698>, <0.09582, 0.7774, 0.1983>, <0.1033, 0.8341, 0.1889> }
				triangle { <0.1033, 0.8341, 0.1889>, <0.122, 0.886, 0.1921>, <0.1197, 0.8795, 0.2158> }
				triangle { <0.1033, 0.8341, 0.1889>, <0.1197, 0.8795, 0.2158>, <0.122, 0.886, 0.1921> }
				triangle { <0.122, 0.886, 0.1921>, <0.1424, 0.9547, 0.2>, <0.1553, 0.9666, 0.2174> }
				triangle { <0.122, 0.886, 0.1921>, <0.1553, 0.9666, 0.2174>, <0.1424, 0.9547, 0.2> }
				triangle { <0.1424, 0.9547, 0.2>, <0.1629, 1.02337, 0.208>, <0.1553, 0.9666, 0.2174> }
				triangle { <0.1424, 0.9547, 0.2>, <0.1553, 0.9666, 0.2174>, <0.1629, 1.02337, 0.208> }
				triangle { <0.1629, 1.02337, 0.208>, <0.1833, 1.09202, 0.2159>, <0.1775, 1.05206, 0.2301> }
				triangle { <0.1629, 1.02337, 0.208>, <0.1775, 1.05206, 0.2301>, <0.1833, 1.09202, 0.2159> }
				triangle { <0.1833, 1.09202, 0.2159>, <0.1926, 1.1654, 0.2112>, <0.1886, 1.1422, 0.2302> }
				triangle { <0.1833, 1.09202, 0.2159>, <0.1886, 1.1422, 0.2302>, <0.1926, 1.1654, 0.2112> }
				triangle { <0.1926, 1.1654, 0.2112>, <0.2113, 1.2173, 0.2144>, <0.2241, 1.2293, 0.2318> }
				triangle { <0.1926, 1.1654, 0.2112>, <0.2241, 1.2293, 0.2318>, <0.2113, 1.2173, 0.2144> }
				triangle { <0.2113, 1.2173, 0.2144>, <0.2317, 1.286, 0.2223>, <0.2166, 1.2675, 0.2287> }
				triangle { <0.2113, 1.2173, 0.2144>, <0.2166, 1.2675, 0.2287>, <0.2317, 1.286, 0.2223> }
				triangle { <0.2317, 1.286, 0.2223>, <0.2393, 1.3427, 0.2129>, <0.2352, 1.3194, 0.2318> }
				triangle { <0.2317, 1.286, 0.2223>, <0.2352, 1.3194, 0.2318>, <0.2393, 1.3427, 0.2129> }
				triangle { <0.2393, 1.3427, 0.2129>, <0.2597, 1.4113, 0.2208>, <0.2446, 1.3928, 0.2272> }
				triangle { <0.2393, 1.3427, 0.2129>, <0.2446, 1.3928, 0.2272>, <0.2597, 1.4113, 0.2208> }
				triangle { <0.2597, 1.4113, 0.2208>, <0.2673, 1.468, 0.2114>, <0.2539, 1.4662, 0.2225> }
				triangle { <0.2597, 1.4113, 0.2208>, <0.2539, 1.4662, 0.2225>, <0.2673, 1.468, 0.2114> }
				triangle { <0.2673, 1.468, 0.2114>, <0.2766, 1.5414, 0.2067>, <0.2766, 1.5414, 0.2067> }
				triangle { <0.2673, 1.468, 0.2114>, <0.2766, 1.5414, 0.2067>, <0.2766, 1.5414, 0.2067> }
				triangle { <0.2766, 1.5414, 0.2067>, <0.2842, 1.5981, 0.1972>, <0.2766, 1.5414, 0.2067> }
				triangle { <0.2766, 1.5414, 0.2067>, <0.2766, 1.5414, 0.2067>, <0.2842, 1.5981, 0.1972> }
				triangle { <0.2766, 1.5414, 0.2067>, <0.2539, 1.4662, 0.2225>, <0.2673, 1.468, 0.2114> }
				triangle { <0.2766, 1.5414, 0.2067>, <0.2673, 1.468, 0.2114>, <0.2539, 1.4662, 0.2225> }
				triangle { <0.2539, 1.4662, 0.2225>, <0.2446, 1.3928, 0.2272>, <0.2597, 1.4113, 0.2208> }
				triangle { <0.2539, 1.4662, 0.2225>, <0.2597, 1.4113, 0.2208>, <0.2446, 1.3928, 0.2272> }
				triangle { <0.2446, 1.3928, 0.2272>, <0.2352, 1.3194, 0.2318>, <0.2393, 1.3427, 0.2129> }
				triangle { <0.2446, 1.3928, 0.2272>, <0.2393, 1.3427, 0.2129>, <0.2352, 1.3194, 0.2318> }
				triangle { <0.2352, 1.3194, 0.2318>, <0.2166, 1.2675, 0.2287>, <0.2317, 1.286, 0.2223> }
				triangle { <0.2352, 1.3194, 0.2318>, <0.2317, 1.286, 0.2223>, <0.2166, 1.2675, 0.2287> }
				triangle { <-0.01172, 0.2417, 0.06672>, <-0.017, 0.1915, 0.05244>, <-0.01348, 0.225, 0.06196> }
				triangle { <-0.01172, 0.2417, 0.06672>, <-0.01348, 0.225, 0.06196>, <-0.017, 0.1915, 0.05244> }
				triangle { <-0.017, 0.1915, 0.05244>, <-0.02403, 0.1246, 0.0334>, <-0.02051, 0.1581, 0.04292> }
				triangle { <-0.017, 0.1915, 0.05244>, <-0.02051, 0.1581, 0.04292>, <-0.02403, 0.1246, 0.0334> }
				triangle { <0.2166, 1.2675, 0.2287>, <0.2241, 1.2293, 0.2318>, <0.2113, 1.2173, 0.2144> }
				triangle { <0.2166, 1.2675, 0.2287>, <0.2113, 1.2173, 0.2144>, <0.2241, 1.2293, 0.2318> }
				triangle { <0.2241, 1.2293, 0.2318>, <0.1886, 1.1422, 0.2302>, <0.1926, 1.1654, 0.2112> }
				triangle { <0.2241, 1.2293, 0.2318>, <0.1926, 1.1654, 0.2112>, <0.1886, 1.1422, 0.2302> }
				triangle { <0.1886, 1.1422, 0.2302>, <0.1775, 1.05206, 0.2301>, <0.1833, 1.09202, 0.2159> }
				triangle { <0.1886, 1.1422, 0.2302>, <0.1833, 1.09202, 0.2159>, <0.1775, 1.05206, 0.2301> }
				triangle { <0.1775, 1.05206, 0.2301>, <0.1553, 0.9666, 0.2174>, <0.1629, 1.02337, 0.208> }
				triangle { <0.1775, 1.05206, 0.2301>, <0.1629, 1.02337, 0.208>, <0.1553, 0.9666, 0.2174> }
				triangle { <0.1553, 0.9666, 0.2174>, <0.1197, 0.8795, 0.2158>, <0.122, 0.886, 0.1921> }
				triangle { <0.1553, 0.9666, 0.2174>, <0.122, 0.886, 0.1921>, <0.1197, 0.8795, 0.2158> }
				triangle { <0.1197, 0.8795, 0.2158>, <0.09582, 0.7774, 0.1983>, <0.1033, 0.8341, 0.1889> }
				triangle { <0.1197, 0.8795, 0.2158>, <0.1033, 0.8341, 0.1889>, <0.09582, 0.7774, 0.1983> }
				triangle { <0.09582, 0.7774, 0.1983>, <0.08702, 0.6938, 0.1745>, <0.09636, 0.7672, 0.1698> }
				triangle { <0.09582, 0.7774, 0.1983>, <0.09636, 0.7672, 0.1698>, <0.08702, 0.6938, 0.1745> }
				triangle { <0.08702, 0.6938, 0.1745>, <0.06484, 0.6084, 0.1618>, <0.0555, 0.6299, 0.154> }
				triangle { <0.08702, 0.6938, 0.1745>, <0.0555, 0.6299, 0.154>, <0.06484, 0.6084, 0.1618> }
				triangle { <0.06484, 0.6084, 0.1618>, <0.04265, 0.523, 0.1491>, <0.04847, 0.563, 0.1349> }
				triangle { <0.06484, 0.6084, 0.1618>, <0.04847, 0.563, 0.1349>, <0.04265, 0.523, 0.1491> }
				triangle { <0.04265, 0.523, 0.1491>, <0.0321, 0.4227, 0.1206>, <0.04143, 0.4961, 0.1159> }
				triangle { <0.04265, 0.523, 0.1491>, <0.04143, 0.4961, 0.1159>, <0.0321, 0.4227, 0.1206> }
				triangle { <0.0321, 0.4227, 0.1206>, <-0.001171, 0.3421, 0.09528>, <0.01397, 0.3605, 0.08894> }
				triangle { <0.0321, 0.4227, 0.1206>, <0.01397, 0.3605, 0.08894>, <-0.001171, 0.3421, 0.09528> }
				triangle { <-0.001171, 0.3421, 0.09528>, <-0.01172, 0.2417, 0.06672>, <0.006942, 0.2936, 0.0699> }
				triangle { <-0.001171, 0.3421, 0.09528>, <0.006942, 0.2936, 0.0699>, <-0.01172, 0.2417, 0.06672> }
				texture {T_ClumpLeaf2}}
			}
		}
	union { // Internode
		cylinder { <-0.002917, 0.04537, 0.003986>, <-0.003324, 0.05236, 0.004751>, 0.007449 }
		cylinder { <-0.003324, 0.05236, 0.004751>, <-0.003887, 0.05935, 0.005443>, 0.007449 }
		cylinder { <-0.003887, 0.05935, 0.005443>, <-0.004607, 0.06632, 0.006062>, 0.007449 }
		texture {T_ClumpStem}}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-0.004607, 0.06632, 0.006062>, <-0.006789, 0.07237, 0.005877>, 0.0004565 }
			cylinder { <-0.006789, 0.07237, 0.005877>, <-0.01033, 0.07765, 0.004955>, 0.0004565 }
			cylinder { <-0.01033, 0.07765, 0.004955>, <-0.01499, 0.08179, 0.003363>, 0.0004565 }
			texture {T_ClumpLeaf}}
		union { // compound leaf
			union { // Petiole
				cylinder { <-0.01499, 0.08179, 0.003363>, <-0.01642, 0.08299, 0.002869>, 0.0004565 }
				cylinder { <-0.01642, 0.08299, 0.002869>, <-0.01787, 0.08416, 0.002359>, 0.0004565 }
				cylinder { <-0.01787, 0.08416, 0.002359>, <-0.01934, 0.08529, 0.001832>, 0.0004565 }
				texture {T_ClumpLeaf}}
			union { // Petiole
				cylinder { <-0.01934, 0.08529, 0.001832>, <-0.02249, 0.0883, -0.0007097>, 0.0003584 }
				cylinder { <-0.02249, 0.0883, -0.0007097>, <-0.02471, 0.09116, -0.00423>, 0.0003584 }
				cylinder { <-0.02471, 0.09116, -0.00423>, <-0.02585, 0.09365, -0.008475>, 0.0003584 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <-0.02585, 0.09365, -0.008475>, <-0.02108, 0.1427, -0.01504>, <-0.02108, 0.1427, -0.01504> }
				triangle { <-0.02585, 0.09365, -0.008475>, <-0.02108, 0.1427, -0.01504>, <-0.02108, 0.1427, -0.01504> }
				triangle { <-0.02108, 0.1427, -0.01504>, <-0.0179, 0.1754, -0.01943>, <-0.02108, 0.1427, -0.01504> }
				triangle { <-0.02108, 0.1427, -0.01504>, <-0.02108, 0.1427, -0.01504>, <-0.0179, 0.1754, -0.01943> }
				triangle { <-0.0179, 0.1754, -0.01943>, <-0.01155, 0.2409, -0.02819>, <-0.01473, 0.2082, -0.02381> }
				triangle { <-0.0179, 0.1754, -0.01943>, <-0.01473, 0.2082, -0.02381>, <-0.01155, 0.2409, -0.02819> }
				triangle { <-0.01155, 0.2409, -0.02819>, <0.006268, 0.3069, -0.02498>, <-0.009967, 0.2573, -0.03038> }
				triangle { <-0.01155, 0.2409, -0.02819>, <-0.009967, 0.2573, -0.03038>, <0.006268, 0.3069, -0.02498> }
				triangle { <0.006268, 0.3069, -0.02498>, <0.01262, 0.3724, -0.03374>, <-0.0004368, 0.3555, -0.04353> }
				triangle { <0.006268, 0.3069, -0.02498>, <-0.0004368, 0.3555, -0.04353>, <0.01262, 0.3724, -0.03374> }
				triangle { <0.01262, 0.3724, -0.03374>, <0.01897, 0.4378, -0.04251>, <0.007096, 0.4405, -0.03124> }
				triangle { <0.01262, 0.3724, -0.03374>, <0.007096, 0.4405, -0.03124>, <0.01897, 0.4378, -0.04251> }
				triangle { <0.01897, 0.4378, -0.04251>, <0.0368, 0.5038, -0.0393>, <0.007096, 0.4405, -0.03124> }
				triangle { <0.01897, 0.4378, -0.04251>, <0.007096, 0.4405, -0.03124>, <0.0368, 0.5038, -0.0393> }
				triangle { <0.0368, 0.5038, -0.0393>, <0.04315, 0.5693, -0.04806>, <0.01662, 0.5387, -0.04439> }
				triangle { <0.0368, 0.5038, -0.0393>, <0.01662, 0.5387, -0.04439>, <0.04315, 0.5693, -0.04806> }
				triangle { <0.04315, 0.5693, -0.04806>, <0.0495, 0.6347, -0.05683>, <0.03604, 0.621, -0.04337> }
				triangle { <0.04315, 0.5693, -0.04806>, <0.03604, 0.621, -0.04337>, <0.0495, 0.6347, -0.05683> }
				triangle { <0.0495, 0.6347, -0.05683>, <0.06733, 0.7007, -0.05362>, <0.05545, 0.7034, -0.04235> }
				triangle { <0.0495, 0.6347, -0.05683>, <0.05545, 0.7034, -0.04235>, <0.06733, 0.7007, -0.05362> }
				triangle { <0.06733, 0.7007, -0.05362>, <0.08515, 0.7667, -0.05041>, <0.05545, 0.7034, -0.04235> }
				triangle { <0.06733, 0.7007, -0.05362>, <0.05545, 0.7034, -0.04235>, <0.08515, 0.7667, -0.05041> }
				triangle { <0.08515, 0.7667, -0.05041>, <0.09151, 0.8321, -0.05917>, <0.06339, 0.7852, -0.0533> }
				triangle { <0.08515, 0.7667, -0.05041>, <0.06339, 0.7852, -0.0533>, <0.09151, 0.8321, -0.05917> }
				triangle { <0.09151, 0.8321, -0.05917>, <0.1077, 0.8817, -0.05377>, <0.08439, 0.8839, -0.05447> }
				triangle { <0.09151, 0.8321, -0.05917>, <0.08439, 0.8839, -0.05447>, <0.1077, 0.8817, -0.05377> }
				triangle { <0.1077, 0.8817, -0.05377>, <0.1255, 0.9477, -0.05056>, <0.1152, 0.9667, -0.04148> }
				triangle { <0.1077, 0.8817, -0.05377>, <0.1152, 0.9667, -0.04148>, <0.1255, 0.9477, -0.05056> }
				triangle { <0.1255, 0.9477, -0.05056>, <0.1433, 1.01369, -0.04735>, <0.1152, 0.9667, -0.04148> }
				triangle { <0.1255, 0.9477, -0.05056>, <0.1152, 0.9667, -0.04148>, <0.1433, 1.01369, -0.04735> }
				triangle { <0.1433, 1.01369, -0.04735>, <0.1612, 1.07965, -0.04414>, <0.1346, 1.04909, -0.04046> }
				triangle { <0.1433, 1.01369, -0.04735>, <0.1346, 1.04909, -0.04046>, <0.1612, 1.07965, -0.04414> }
				triangle { <0.1612, 1.07965, -0.04414>, <0.1909, 1.1429, -0.0522>, <0.1659, 1.1287, -0.05071> }
				triangle { <0.1612, 1.07965, -0.04414>, <0.1659, 1.1287, -0.05071>, <0.1909, 1.1429, -0.0522> }
				triangle { <0.1909, 1.1429, -0.0522>, <0.2071, 1.1925, -0.04679>, <0.1968, 1.2115, -0.03771> }
				triangle { <0.1909, 1.1429, -0.0522>, <0.1968, 1.2115, -0.03771>, <0.2071, 1.1925, -0.04679> }
				triangle { <0.2071, 1.1925, -0.04679>, <0.2249, 1.2585, -0.04358>, <0.2119, 1.2416, -0.05337> }
				triangle { <0.2071, 1.1925, -0.04679>, <0.2119, 1.2416, -0.05337>, <0.2249, 1.2585, -0.04358> }
				triangle { <0.2249, 1.2585, -0.04358>, <0.2531, 1.3054, -0.04945>, <0.2281, 1.2912, -0.04797> }
				triangle { <0.2249, 1.2585, -0.04358>, <0.2281, 1.2912, -0.04797>, <0.2531, 1.3054, -0.04945> }
				triangle { <0.2531, 1.3054, -0.04945>, <0.2709, 1.3714, -0.04624>, <0.2578, 1.3545, -0.05603> }
				triangle { <0.2531, 1.3054, -0.04945>, <0.2578, 1.3545, -0.05603>, <0.2709, 1.3714, -0.04624> }
				triangle { <0.2709, 1.3714, -0.04624>, <0.299, 1.4183, -0.05211>, <0.2875, 1.4178, -0.06409> }
				triangle { <0.2709, 1.3714, -0.04624>, <0.2875, 1.4178, -0.06409>, <0.299, 1.4183, -0.05211> }
				triangle { <0.299, 1.4183, -0.05211>, <0.3287, 1.4816, -0.06017>, <0.3287, 1.4816, -0.06017> }
				triangle { <0.299, 1.4183, -0.05211>, <0.3287, 1.4816, -0.06017>, <0.3287, 1.4816, -0.06017> }
				triangle { <0.3287, 1.4816, -0.06017>, <0.3568, 1.5285, -0.06604>, <0.3287, 1.4816, -0.06017> }
				triangle { <0.3287, 1.4816, -0.06017>, <0.3287, 1.4816, -0.06017>, <0.3568, 1.5285, -0.06604> }
				triangle { <0.3287, 1.4816, -0.06017>, <0.2875, 1.4178, -0.06409>, <0.299, 1.4183, -0.05211> }
				triangle { <0.3287, 1.4816, -0.06017>, <0.299, 1.4183, -0.05211>, <0.2875, 1.4178, -0.06409> }
				triangle { <0.2875, 1.4178, -0.06409>, <0.2578, 1.3545, -0.05603>, <0.2709, 1.3714, -0.04624> }
				triangle { <0.2875, 1.4178, -0.06409>, <0.2709, 1.3714, -0.04624>, <0.2578, 1.3545, -0.05603> }
				triangle { <0.2578, 1.3545, -0.05603>, <0.2281, 1.2912, -0.04797>, <0.2531, 1.3054, -0.04945> }
				triangle { <0.2578, 1.3545, -0.05603>, <0.2531, 1.3054, -0.04945>, <0.2281, 1.2912, -0.04797> }
				triangle { <0.2281, 1.2912, -0.04797>, <0.2119, 1.2416, -0.05337>, <0.2249, 1.2585, -0.04358> }
				triangle { <0.2281, 1.2912, -0.04797>, <0.2249, 1.2585, -0.04358>, <0.2119, 1.2416, -0.05337> }
				triangle { <-0.009967, 0.2573, -0.03038>, <-0.01473, 0.2082, -0.02381>, <-0.01155, 0.2409, -0.02819> }
				triangle { <-0.009967, 0.2573, -0.03038>, <-0.01155, 0.2409, -0.02819>, <-0.01473, 0.2082, -0.02381> }
				triangle { <-0.01473, 0.2082, -0.02381>, <-0.02108, 0.1427, -0.01504>, <-0.0179, 0.1754, -0.01943> }
				triangle { <-0.01473, 0.2082, -0.02381>, <-0.0179, 0.1754, -0.01943>, <-0.02108, 0.1427, -0.01504> }
				triangle { <0.2119, 1.2416, -0.05337>, <0.1968, 1.2115, -0.03771>, <0.2071, 1.1925, -0.04679> }
				triangle { <0.2119, 1.2416, -0.05337>, <0.2071, 1.1925, -0.04679>, <0.1968, 1.2115, -0.03771> }
				triangle { <0.1968, 1.2115, -0.03771>, <0.1659, 1.1287, -0.05071>, <0.1909, 1.1429, -0.0522> }
				triangle { <0.1968, 1.2115, -0.03771>, <0.1909, 1.1429, -0.0522>, <0.1659, 1.1287, -0.05071> }
				triangle { <0.1659, 1.1287, -0.05071>, <0.1346, 1.04909, -0.04046>, <0.1612, 1.07965, -0.04414> }
				triangle { <0.1659, 1.1287, -0.05071>, <0.1612, 1.07965, -0.04414>, <0.1346, 1.04909, -0.04046> }
				triangle { <0.1346, 1.04909, -0.04046>, <0.1152, 0.9667, -0.04148>, <0.1433, 1.01369, -0.04735> }
				triangle { <0.1346, 1.04909, -0.04046>, <0.1433, 1.01369, -0.04735>, <0.1152, 0.9667, -0.04148> }
				triangle { <0.1152, 0.9667, -0.04148>, <0.08439, 0.8839, -0.05447>, <0.1077, 0.8817, -0.05377> }
				triangle { <0.1152, 0.9667, -0.04148>, <0.1077, 0.8817, -0.05377>, <0.08439, 0.8839, -0.05447> }
				triangle { <0.08439, 0.8839, -0.05447>, <0.06339, 0.7852, -0.0533>, <0.09151, 0.8321, -0.05917> }
				triangle { <0.08439, 0.8839, -0.05447>, <0.09151, 0.8321, -0.05917>, <0.06339, 0.7852, -0.0533> }
				triangle { <0.06339, 0.7852, -0.0533>, <0.05545, 0.7034, -0.04235>, <0.08515, 0.7667, -0.05041> }
				triangle { <0.06339, 0.7852, -0.0533>, <0.08515, 0.7667, -0.05041>, <0.05545, 0.7034, -0.04235> }
				triangle { <0.05545, 0.7034, -0.04235>, <0.03604, 0.621, -0.04337>, <0.0495, 0.6347, -0.05683> }
				triangle { <0.05545, 0.7034, -0.04235>, <0.0495, 0.6347, -0.05683>, <0.03604, 0.621, -0.04337> }
				triangle { <0.03604, 0.621, -0.04337>, <0.01662, 0.5387, -0.04439>, <0.04315, 0.5693, -0.04806> }
				triangle { <0.03604, 0.621, -0.04337>, <0.04315, 0.5693, -0.04806>, <0.01662, 0.5387, -0.04439> }
				triangle { <0.01662, 0.5387, -0.04439>, <0.007096, 0.4405, -0.03124>, <0.0368, 0.5038, -0.0393> }
				triangle { <0.01662, 0.5387, -0.04439>, <0.0368, 0.5038, -0.0393>, <0.007096, 0.4405, -0.03124> }
				triangle { <0.007096, 0.4405, -0.03124>, <-0.0004368, 0.3555, -0.04353>, <0.01262, 0.3724, -0.03374> }
				triangle { <0.007096, 0.4405, -0.03124>, <0.01262, 0.3724, -0.03374>, <-0.0004368, 0.3555, -0.04353> }
				triangle { <-0.0004368, 0.3555, -0.04353>, <-0.009967, 0.2573, -0.03038>, <0.006268, 0.3069, -0.02498> }
				triangle { <-0.0004368, 0.3555, -0.04353>, <0.006268, 0.3069, -0.02498>, <-0.009967, 0.2573, -0.03038> }
				texture {T_ClumpLeaf2}}
			union { // Petiole
				cylinder { <-0.01934, 0.08529, 0.001832>, <-0.02319, 0.08825, 0.0004533>, 0.0003584 }
				cylinder { <-0.02319, 0.08825, 0.0004533>, <-0.02704, 0.0912, -0.0009255>, 0.0003584 }
				cylinder { <-0.02704, 0.0912, -0.0009255>, <-0.0309, 0.09416, -0.002304>, 0.0003584 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <-0.0309, 0.09416, -0.002304>, <-0.03738, 0.1413, 0.0121>, <-0.03738, 0.1413, 0.0121> }
				triangle { <-0.0309, 0.09416, -0.002304>, <-0.03738, 0.1413, 0.0121>, <-0.03738, 0.1413, 0.0121> }
				triangle { <-0.03738, 0.1413, 0.0121>, <-0.04171, 0.1728, 0.02171>, <-0.03738, 0.1413, 0.0121> }
				triangle { <-0.03738, 0.1413, 0.0121>, <-0.03738, 0.1413, 0.0121>, <-0.04171, 0.1728, 0.02171> }
				triangle { <-0.04171, 0.1728, 0.02171>, <-0.05036, 0.2357, 0.04093>, <-0.04603, 0.2042, 0.03132> }
				triangle { <-0.04171, 0.1728, 0.02171>, <-0.04603, 0.2042, 0.03132>, <-0.05036, 0.2357, 0.04093> }
				triangle { <-0.05036, 0.2357, 0.04093>, <-0.04272, 0.3, 0.06298>, <-0.05252, 0.2514, 0.04573> }
				triangle { <-0.05036, 0.2357, 0.04093>, <-0.05252, 0.2514, 0.04573>, <-0.04272, 0.3, 0.06298> }
				triangle { <-0.04272, 0.3, 0.06298>, <-0.05136, 0.3629, 0.0822>, <-0.06549, 0.3458, 0.07456> }
				triangle { <-0.04272, 0.3, 0.06298>, <-0.06549, 0.3458, 0.07456>, <-0.05136, 0.3629, 0.0822> }
				triangle { <-0.05136, 0.3629, 0.0822>, <-0.06001, 0.4259, 0.1014>, <-0.06231, 0.4208, 0.117> }
				triangle { <-0.05136, 0.3629, 0.0822>, <-0.06231, 0.4208, 0.117>, <-0.06001, 0.4259, 0.1014> }
				triangle { <-0.06001, 0.4259, 0.1014>, <-0.05237, 0.4901, 0.1234>, <-0.06231, 0.4208, 0.117> }
				triangle { <-0.06001, 0.4259, 0.1014>, <-0.06231, 0.4208, 0.117>, <-0.05237, 0.4901, 0.1234> }
				triangle { <-0.05237, 0.4901, 0.1234>, <-0.06102, 0.5531, 0.1426>, <-0.07528, 0.5152, 0.1458> }
				triangle { <-0.05237, 0.4901, 0.1234>, <-0.07528, 0.5152, 0.1458>, <-0.06102, 0.5531, 0.1426> }
				triangle { <-0.06102, 0.5531, 0.1426>, <-0.06967, 0.616, 0.1619>, <-0.0698, 0.5952, 0.1727> }
				triangle { <-0.06102, 0.5531, 0.1426>, <-0.0698, 0.5952, 0.1727>, <-0.06967, 0.616, 0.1619> }
				triangle { <-0.06967, 0.616, 0.1619>, <-0.06203, 0.6803, 0.1839>, <-0.06432, 0.6752, 0.1995> }
				triangle { <-0.06967, 0.616, 0.1619>, <-0.06432, 0.6752, 0.1995>, <-0.06203, 0.6803, 0.1839> }
				triangle { <-0.06203, 0.6803, 0.1839>, <-0.05439, 0.7446, 0.206>, <-0.06432, 0.6752, 0.1995> }
				triangle { <-0.06203, 0.6803, 0.1839>, <-0.06432, 0.6752, 0.1995>, <-0.05439, 0.7446, 0.206> }
				triangle { <-0.05439, 0.7446, 0.206>, <-0.06304, 0.8075, 0.2252>, <-0.07513, 0.7539, 0.2236> }
				triangle { <-0.05439, 0.7446, 0.206>, <-0.07513, 0.7539, 0.2236>, <-0.06304, 0.8075, 0.2252> }
				triangle { <-0.06304, 0.8075, 0.2252>, <-0.05324, 0.8561, 0.2424>, <-0.07182, 0.8496, 0.2552> }
				triangle { <-0.06304, 0.8075, 0.2252>, <-0.07182, 0.8496, 0.2552>, <-0.05324, 0.8561, 0.2424> }
				triangle { <-0.05324, 0.8561, 0.2424>, <-0.0456, 0.9204, 0.2645>, <-0.05005, 0.931, 0.2849> }
				triangle { <-0.05324, 0.8561, 0.2424>, <-0.05005, 0.931, 0.2849>, <-0.0456, 0.9204, 0.2645> }
				triangle { <-0.0456, 0.9204, 0.2645>, <-0.03796, 0.9847, 0.2865>, <-0.05005, 0.931, 0.2849> }
				triangle { <-0.0456, 0.9204, 0.2645>, <-0.05005, 0.931, 0.2849>, <-0.03796, 0.9847, 0.2865> }
				triangle { <-0.03796, 0.9847, 0.2865>, <-0.03032, 1.04903, 0.3086>, <-0.04457, 1.01111, 0.3118> }
				triangle { <-0.03796, 0.9847, 0.2865>, <-0.04457, 1.01111, 0.3118>, <-0.03032, 1.04903, 0.3086> }
				triangle { <-0.03032, 1.04903, 0.3086>, <-0.02039, 1.1184, 0.315>, <-0.0368, 1.09623, 0.323> }
				triangle { <-0.03032, 1.04903, 0.3086>, <-0.0368, 1.09623, 0.323>, <-0.02039, 1.1184, 0.315> }
				triangle { <-0.02039, 1.1184, 0.315>, <-0.01058, 1.1669, 0.3323>, <-0.01504, 1.1776, 0.3527> }
				triangle { <-0.02039, 1.1184, 0.315>, <-0.01504, 1.1776, 0.3527>, <-0.01058, 1.1669, 0.3323> }
				triangle { <-0.01058, 1.1669, 0.3323>, <-0.002948, 1.2312, 0.3543>, <-0.01707, 1.2141, 0.3467> }
				triangle { <-0.01058, 1.1669, 0.3323>, <-0.01707, 1.2141, 0.3467>, <-0.002948, 1.2312, 0.3543> }
				triangle { <-0.002948, 1.2312, 0.3543>, <0.009146, 1.2849, 0.356>, <-0.007272, 1.2627, 0.3639> }
				triangle { <-0.002948, 1.2312, 0.3543>, <-0.007272, 1.2627, 0.3639>, <0.009146, 1.2849, 0.356> }
				triangle { <0.009146, 1.2849, 0.356>, <0.01678, 1.3492, 0.378>, <0.002659, 1.3321, 0.3704> }
				triangle { <0.009146, 1.2849, 0.356>, <0.002659, 1.3321, 0.3704>, <0.01678, 1.3492, 0.378> }
				triangle { <0.01678, 1.3492, 0.378>, <0.02888, 1.4028, 0.3796>, <0.01259, 1.4015, 0.3768> }
				triangle { <0.01678, 1.3492, 0.378>, <0.01259, 1.4015, 0.3768>, <0.02888, 1.4028, 0.3796> }
				triangle { <0.02888, 1.4028, 0.3796>, <0.03881, 1.4722, 0.3861>, <0.03881, 1.4722, 0.3861> }
				triangle { <0.02888, 1.4028, 0.3796>, <0.03881, 1.4722, 0.3861>, <0.03881, 1.4722, 0.3861> }
				triangle { <0.03881, 1.4722, 0.3861>, <0.0509, 1.5259, 0.3877>, <0.03881, 1.4722, 0.3861> }
				triangle { <0.03881, 1.4722, 0.3861>, <0.03881, 1.4722, 0.3861>, <0.0509, 1.5259, 0.3877> }
				triangle { <0.03881, 1.4722, 0.3861>, <0.01259, 1.4015, 0.3768>, <0.02888, 1.4028, 0.3796> }
				triangle { <0.03881, 1.4722, 0.3861>, <0.02888, 1.4028, 0.3796>, <0.01259, 1.4015, 0.3768> }
				triangle { <0.01259, 1.4015, 0.3768>, <0.002659, 1.3321, 0.3704>, <0.01678, 1.3492, 0.378> }
				triangle { <0.01259, 1.4015, 0.3768>, <0.01678, 1.3492, 0.378>, <0.002659, 1.3321, 0.3704> }
				triangle { <0.002659, 1.3321, 0.3704>, <-0.007272, 1.2627, 0.3639>, <0.009146, 1.2849, 0.356> }
				triangle { <0.002659, 1.3321, 0.3704>, <0.009146, 1.2849, 0.356>, <-0.007272, 1.2627, 0.3639> }
				triangle { <-0.007272, 1.2627, 0.3639>, <-0.01707, 1.2141, 0.3467>, <-0.002948, 1.2312, 0.3543> }
				triangle { <-0.007272, 1.2627, 0.3639>, <-0.002948, 1.2312, 0.3543>, <-0.01707, 1.2141, 0.3467> }
				triangle { <-0.05252, 0.2514, 0.04573>, <-0.04603, 0.2042, 0.03132>, <-0.05036, 0.2357, 0.04093> }
				triangle { <-0.05252, 0.2514, 0.04573>, <-0.05036, 0.2357, 0.04093>, <-0.04603, 0.2042, 0.03132> }
				triangle { <-0.04603, 0.2042, 0.03132>, <-0.03738, 0.1413, 0.0121>, <-0.04171, 0.1728, 0.02171> }
				triangle { <-0.04603, 0.2042, 0.03132>, <-0.04171, 0.1728, 0.02171>, <-0.03738, 0.1413, 0.0121> }
				triangle { <-0.01707, 1.2141, 0.3467>, <-0.01504, 1.1776, 0.3527>, <-0.01058, 1.1669, 0.3323> }
				triangle { <-0.01707, 1.2141, 0.3467>, <-0.01058, 1.1669, 0.3323>, <-0.01504, 1.1776, 0.3527> }
				triangle { <-0.01504, 1.1776, 0.3527>, <-0.0368, 1.09623, 0.323>, <-0.02039, 1.1184, 0.315> }
				triangle { <-0.01504, 1.1776, 0.3527>, <-0.02039, 1.1184, 0.315>, <-0.0368, 1.09623, 0.323> }
				triangle { <-0.0368, 1.09623, 0.323>, <-0.04457, 1.01111, 0.3118>, <-0.03032, 1.04903, 0.3086> }
				triangle { <-0.0368, 1.09623, 0.323>, <-0.03032, 1.04903, 0.3086>, <-0.04457, 1.01111, 0.3118> }
				triangle { <-0.04457, 1.01111, 0.3118>, <-0.05005, 0.931, 0.2849>, <-0.03796, 0.9847, 0.2865> }
				triangle { <-0.04457, 1.01111, 0.3118>, <-0.03796, 0.9847, 0.2865>, <-0.05005, 0.931, 0.2849> }
				triangle { <-0.05005, 0.931, 0.2849>, <-0.07182, 0.8496, 0.2552>, <-0.05324, 0.8561, 0.2424> }
				triangle { <-0.05005, 0.931, 0.2849>, <-0.05324, 0.8561, 0.2424>, <-0.07182, 0.8496, 0.2552> }
				triangle { <-0.07182, 0.8496, 0.2552>, <-0.07513, 0.7539, 0.2236>, <-0.06304, 0.8075, 0.2252> }
				triangle { <-0.07182, 0.8496, 0.2552>, <-0.06304, 0.8075, 0.2252>, <-0.07513, 0.7539, 0.2236> }
				triangle { <-0.07513, 0.7539, 0.2236>, <-0.06432, 0.6752, 0.1995>, <-0.05439, 0.7446, 0.206> }
				triangle { <-0.07513, 0.7539, 0.2236>, <-0.05439, 0.7446, 0.206>, <-0.06432, 0.6752, 0.1995> }
				triangle { <-0.06432, 0.6752, 0.1995>, <-0.0698, 0.5952, 0.1727>, <-0.06967, 0.616, 0.1619> }
				triangle { <-0.06432, 0.6752, 0.1995>, <-0.06967, 0.616, 0.1619>, <-0.0698, 0.5952, 0.1727> }
				triangle { <-0.0698, 0.5952, 0.1727>, <-0.07528, 0.5152, 0.1458>, <-0.06102, 0.5531, 0.1426> }
				triangle { <-0.0698, 0.5952, 0.1727>, <-0.06102, 0.5531, 0.1426>, <-0.07528, 0.5152, 0.1458> }
				triangle { <-0.07528, 0.5152, 0.1458>, <-0.06231, 0.4208, 0.117>, <-0.05237, 0.4901, 0.1234> }
				triangle { <-0.07528, 0.5152, 0.1458>, <-0.05237, 0.4901, 0.1234>, <-0.06231, 0.4208, 0.117> }
				triangle { <-0.06231, 0.4208, 0.117>, <-0.06549, 0.3458, 0.07456>, <-0.05136, 0.3629, 0.0822> }
				triangle { <-0.06231, 0.4208, 0.117>, <-0.05136, 0.3629, 0.0822>, <-0.06549, 0.3458, 0.07456> }
				triangle { <-0.06549, 0.3458, 0.07456>, <-0.05252, 0.2514, 0.04573>, <-0.04272, 0.3, 0.06298> }
				triangle { <-0.06549, 0.3458, 0.07456>, <-0.04272, 0.3, 0.06298>, <-0.05252, 0.2514, 0.04573> }
				texture {T_ClumpLeaf2}}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-0.004607, 0.06632, 0.006062>, <-0.003691, 0.07256, 0.007336>, 0.0004565 }
			cylinder { <-0.003691, 0.07256, 0.007336>, <-0.001268, 0.07821, 0.009227>, 0.0004565 }
			cylinder { <-0.001268, 0.07821, 0.009227>, <0.002485, 0.08286, 0.01159>, 0.0004565 }
			texture {T_ClumpLeaf}}
		union { // compound leaf
			union { // Petiole
				cylinder { <0.002485, 0.08286, 0.01159>, <0.003644, 0.08422, 0.01231>, 0.0004565 }
				cylinder { <0.003644, 0.08422, 0.01231>, <0.004834, 0.08555, 0.01305>, 0.0004565 }
				cylinder { <0.004834, 0.08555, 0.01305>, <0.006056, 0.08685, 0.01379>, 0.0004565 }
				texture {T_ClumpLeaf}}
			union { // Petiole
				cylinder { <0.006056, 0.08685, 0.01379>, <0.008578, 0.08995, 0.01687>, 0.0003584 }
				cylinder { <0.008578, 0.08995, 0.01687>, <0.01024, 0.09254, 0.02088>, 0.0003584 }
				cylinder { <0.01024, 0.09254, 0.02088>, <0.01092, 0.09443, 0.02551>, 0.0003584 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <0.01092, 0.09443, 0.02551>, <-0.003568, 0.1396, 0.04045>, <-0.003568, 0.1396, 0.04045> }
				triangle { <0.01092, 0.09443, 0.02551>, <-0.003568, 0.1396, 0.04045>, <-0.003568, 0.1396, 0.04045> }
				triangle { <-0.003568, 0.1396, 0.04045>, <-0.01322, 0.1697, 0.0504>, <-0.003568, 0.1396, 0.04045> }
				triangle { <-0.003568, 0.1396, 0.04045>, <-0.003568, 0.1396, 0.04045>, <-0.01322, 0.1697, 0.0504> }
				triangle { <-0.01322, 0.1697, 0.0504>, <-0.03255, 0.23, 0.07032>, <-0.02289, 0.1999, 0.06036> }
				triangle { <-0.01322, 0.1697, 0.0504>, <-0.02289, 0.1999, 0.06036>, <-0.03255, 0.23, 0.07032> }
				triangle { <-0.03255, 0.23, 0.07032>, <-0.06341, 0.2905, 0.07832>, <-0.03738, 0.2451, 0.0753> }
				triangle { <-0.03255, 0.23, 0.07032>, <-0.03738, 0.2451, 0.0753>, <-0.06341, 0.2905, 0.07832> }
				triangle { <-0.06341, 0.2905, 0.07832>, <-0.08273, 0.3508, 0.09824>, <-0.06636, 0.3355, 0.1051> }
				triangle { <-0.06341, 0.2905, 0.07832>, <-0.06636, 0.3355, 0.1051>, <-0.08273, 0.3508, 0.09824> }
				triangle { <-0.08273, 0.3508, 0.09824>, <-0.102, 0.4111, 0.1181>, <-0.09117, 0.418, 0.1077> }
				triangle { <-0.08273, 0.3508, 0.09824>, <-0.09117, 0.418, 0.1077>, <-0.102, 0.4111, 0.1181> }
				triangle { <-0.102, 0.4111, 0.1181>, <-0.1329, 0.4716, 0.1261>, <-0.09117, 0.418, 0.1077> }
				triangle { <-0.102, 0.4111, 0.1181>, <-0.09117, 0.418, 0.1077>, <-0.1329, 0.4716, 0.1261> }
				triangle { <-0.1329, 0.4716, 0.1261>, <-0.1522, 0.5319, 0.146>, <-0.1201, 0.5084, 0.1376> }
				triangle { <-0.1329, 0.4716, 0.1261>, <-0.1201, 0.5084, 0.1376>, <-0.1522, 0.5319, 0.146> }
				triangle { <-0.1522, 0.5319, 0.146>, <-0.1715, 0.5922, 0.1659>, <-0.1558, 0.584, 0.1505> }
				triangle { <-0.1522, 0.5319, 0.146>, <-0.1558, 0.584, 0.1505>, <-0.1715, 0.5922, 0.1659> }
				triangle { <-0.1715, 0.5922, 0.1659>, <-0.2024, 0.6527, 0.174>, <-0.1915, 0.6596, 0.1635> }
				triangle { <-0.1715, 0.5922, 0.1659>, <-0.1915, 0.6596, 0.1635>, <-0.2024, 0.6527, 0.174> }
				triangle { <-0.2024, 0.6527, 0.174>, <-0.2333, 0.7132, 0.182>, <-0.1915, 0.6596, 0.1635> }
				triangle { <-0.2024, 0.6527, 0.174>, <-0.1915, 0.6596, 0.1635>, <-0.2333, 0.7132, 0.182> }
				triangle { <-0.2333, 0.7132, 0.182>, <-0.2526, 0.7735, 0.2019>, <-0.2156, 0.735, 0.1884> }
				triangle { <-0.2333, 0.7132, 0.182>, <-0.2156, 0.735, 0.1884>, <-0.2526, 0.7735, 0.2019> }
				triangle { <-0.2526, 0.7735, 0.2019>, <-0.2786, 0.8189, 0.2049>, <-0.2562, 0.8256, 0.2064> }
				triangle { <-0.2526, 0.7735, 0.2019>, <-0.2562, 0.8256, 0.2064>, <-0.2786, 0.8189, 0.2049> }
				triangle { <-0.2786, 0.8189, 0.2049>, <-0.3095, 0.8794, 0.2129>, <-0.3034, 0.9015, 0.2075> }
				triangle { <-0.2786, 0.8189, 0.2049>, <-0.3034, 0.9015, 0.2075>, <-0.3095, 0.8794, 0.2129> }
				triangle { <-0.3095, 0.8794, 0.2129>, <-0.3403, 0.94, 0.2209>, <-0.3034, 0.9015, 0.2075> }
				triangle { <-0.3095, 0.8794, 0.2129>, <-0.3034, 0.9015, 0.2075>, <-0.3403, 0.94, 0.2209> }
				triangle { <-0.3403, 0.94, 0.2209>, <-0.3712, 1.000529, 0.2289>, <-0.3391, 0.977, 0.2204> }
				triangle { <-0.3403, 0.94, 0.2209>, <-0.3391, 0.977, 0.2204>, <-0.3712, 1.000529, 0.2289> }
				triangle { <-0.3712, 1.000529, 0.2289>, <-0.413, 1.05411, 0.2473>, <-0.3857, 1.04574, 0.2438> }
				triangle { <-0.3712, 1.000529, 0.2289>, <-0.3857, 1.04574, 0.2438>, <-0.413, 1.05411, 0.2473> }
				triangle { <-0.413, 1.05411, 0.2473>, <-0.439, 1.09955, 0.2504>, <-0.4329, 1.1215, 0.2449> }
				triangle { <-0.413, 1.05411, 0.2473>, <-0.4329, 1.1215, 0.2449>, <-0.439, 1.09955, 0.2504> }
				triangle { <-0.439, 1.09955, 0.2504>, <-0.4699, 1.16, 0.2584>, <-0.4535, 1.1447, 0.2653> }
				triangle { <-0.439, 1.09955, 0.2504>, <-0.4535, 1.1447, 0.2653>, <-0.4699, 1.16, 0.2584> }
				triangle { <-0.4699, 1.16, 0.2584>, <-0.5068, 1.1985, 0.2718>, <-0.4795, 1.1902, 0.2683> }
				triangle { <-0.4699, 1.16, 0.2584>, <-0.4795, 1.1902, 0.2683>, <-0.5068, 1.1985, 0.2718> }
				triangle { <-0.5068, 1.1985, 0.2718>, <-0.5377, 1.2591, 0.2798>, <-0.5213, 1.2437, 0.2867> }
				triangle { <-0.5068, 1.1985, 0.2718>, <-0.5213, 1.2437, 0.2867>, <-0.5377, 1.2591, 0.2798> }
				triangle { <-0.5377, 1.2591, 0.2798>, <-0.5746, 1.2976, 0.2933>, <-0.5631, 1.2973, 0.3052> }
				triangle { <-0.5377, 1.2591, 0.2798>, <-0.5631, 1.2973, 0.3052>, <-0.5746, 1.2976, 0.2933> }
				triangle { <-0.5746, 1.2976, 0.2933>, <-0.6164, 1.3511, 0.3117>, <-0.6164, 1.3511, 0.3117> }
				triangle { <-0.5746, 1.2976, 0.2933>, <-0.6164, 1.3511, 0.3117>, <-0.6164, 1.3511, 0.3117> }
				triangle { <-0.6164, 1.3511, 0.3117>, <-0.6533, 1.3897, 0.3251>, <-0.6164, 1.3511, 0.3117> }
				triangle { <-0.6164, 1.3511, 0.3117>, <-0.6164, 1.3511, 0.3117>, <-0.6533, 1.3897, 0.3251> }
				triangle { <-0.6164, 1.3511, 0.3117>, <-0.5631, 1.2973, 0.3052>, <-0.5746, 1.2976, 0.2933> }
				triangle { <-0.6164, 1.3511, 0.3117>, <-0.5746, 1.2976, 0.2933>, <-0.5631, 1.2973, 0.3052> }
				triangle { <-0.5631, 1.2973, 0.3052>, <-0.5213, 1.2437, 0.2867>, <-0.5377, 1.2591, 0.2798> }
				triangle { <-0.5631, 1.2973, 0.3052>, <-0.5377, 1.2591, 0.2798>, <-0.5213, 1.2437, 0.2867> }
				triangle { <-0.5213, 1.2437, 0.2867>, <-0.4795, 1.1902, 0.2683>, <-0.5068, 1.1985, 0.2718> }
				triangle { <-0.5213, 1.2437, 0.2867>, <-0.5068, 1.1985, 0.2718>, <-0.4795, 1.1902, 0.2683> }
				triangle { <-0.4795, 1.1902, 0.2683>, <-0.4535, 1.1447, 0.2653>, <-0.4699, 1.16, 0.2584> }
				triangle { <-0.4795, 1.1902, 0.2683>, <-0.4699, 1.16, 0.2584>, <-0.4535, 1.1447, 0.2653> }
				triangle { <-0.03738, 0.2451, 0.0753>, <-0.02289, 0.1999, 0.06036>, <-0.03255, 0.23, 0.07032> }
				triangle { <-0.03738, 0.2451, 0.0753>, <-0.03255, 0.23, 0.07032>, <-0.02289, 0.1999, 0.06036> }
				triangle { <-0.02289, 0.1999, 0.06036>, <-0.003568, 0.1396, 0.04045>, <-0.01322, 0.1697, 0.0504> }
				triangle { <-0.02289, 0.1999, 0.06036>, <-0.01322, 0.1697, 0.0504>, <-0.003568, 0.1396, 0.04045> }
				triangle { <-0.4535, 1.1447, 0.2653>, <-0.4329, 1.1215, 0.2449>, <-0.439, 1.09955, 0.2504> }
				triangle { <-0.4535, 1.1447, 0.2653>, <-0.439, 1.09955, 0.2504>, <-0.4329, 1.1215, 0.2449> }
				triangle { <-0.4329, 1.1215, 0.2449>, <-0.3857, 1.04574, 0.2438>, <-0.413, 1.05411, 0.2473> }
				triangle { <-0.4329, 1.1215, 0.2449>, <-0.413, 1.05411, 0.2473>, <-0.3857, 1.04574, 0.2438> }
				triangle { <-0.3857, 1.04574, 0.2438>, <-0.3391, 0.977, 0.2204>, <-0.3712, 1.000529, 0.2289> }
				triangle { <-0.3857, 1.04574, 0.2438>, <-0.3712, 1.000529, 0.2289>, <-0.3391, 0.977, 0.2204> }
				triangle { <-0.3391, 0.977, 0.2204>, <-0.3034, 0.9015, 0.2075>, <-0.3403, 0.94, 0.2209> }
				triangle { <-0.3391, 0.977, 0.2204>, <-0.3403, 0.94, 0.2209>, <-0.3034, 0.9015, 0.2075> }
				triangle { <-0.3034, 0.9015, 0.2075>, <-0.2562, 0.8256, 0.2064>, <-0.2786, 0.8189, 0.2049> }
				triangle { <-0.3034, 0.9015, 0.2075>, <-0.2786, 0.8189, 0.2049>, <-0.2562, 0.8256, 0.2064> }
				triangle { <-0.2562, 0.8256, 0.2064>, <-0.2156, 0.735, 0.1884>, <-0.2526, 0.7735, 0.2019> }
				triangle { <-0.2562, 0.8256, 0.2064>, <-0.2526, 0.7735, 0.2019>, <-0.2156, 0.735, 0.1884> }
				triangle { <-0.2156, 0.735, 0.1884>, <-0.1915, 0.6596, 0.1635>, <-0.2333, 0.7132, 0.182> }
				triangle { <-0.2156, 0.735, 0.1884>, <-0.2333, 0.7132, 0.182>, <-0.1915, 0.6596, 0.1635> }
				triangle { <-0.1915, 0.6596, 0.1635>, <-0.1558, 0.584, 0.1505>, <-0.1715, 0.5922, 0.1659> }
				triangle { <-0.1915, 0.6596, 0.1635>, <-0.1715, 0.5922, 0.1659>, <-0.1558, 0.584, 0.1505> }
				triangle { <-0.1558, 0.584, 0.1505>, <-0.1201, 0.5084, 0.1376>, <-0.1522, 0.5319, 0.146> }
				triangle { <-0.1558, 0.584, 0.1505>, <-0.1522, 0.5319, 0.146>, <-0.1201, 0.5084, 0.1376> }
				triangle { <-0.1201, 0.5084, 0.1376>, <-0.09117, 0.418, 0.1077>, <-0.1329, 0.4716, 0.1261> }
				triangle { <-0.1201, 0.5084, 0.1376>, <-0.1329, 0.4716, 0.1261>, <-0.09117, 0.418, 0.1077> }
				triangle { <-0.09117, 0.418, 0.1077>, <-0.06636, 0.3355, 0.1051>, <-0.08273, 0.3508, 0.09824> }
				triangle { <-0.09117, 0.418, 0.1077>, <-0.08273, 0.3508, 0.09824>, <-0.06636, 0.3355, 0.1051> }
				triangle { <-0.06636, 0.3355, 0.1051>, <-0.03738, 0.2451, 0.0753>, <-0.06341, 0.2905, 0.07832> }
				triangle { <-0.06636, 0.3355, 0.1051>, <-0.06341, 0.2905, 0.07832>, <-0.03738, 0.2451, 0.0753> }
				texture {T_ClumpLeaf2}}
			union { // Petiole
				cylinder { <0.006056, 0.08685, 0.01379>, <0.009255, 0.09024, 0.01573>, 0.0003584 }
				cylinder { <0.009255, 0.09024, 0.01573>, <0.01245, 0.09363, 0.01767>, 0.0003584 }
				cylinder { <0.01245, 0.09363, 0.01767>, <0.01565, 0.09702, 0.01961>, 0.0003584 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <0.01565, 0.09702, 0.01961>, <0.01218, 0.1463, 0.01376>, <0.01218, 0.1463, 0.01376> }
				triangle { <0.01565, 0.09702, 0.01961>, <0.01218, 0.1463, 0.01376>, <0.01218, 0.1463, 0.01376> }
				triangle { <0.01218, 0.1463, 0.01376>, <0.009878, 0.1791, 0.009859>, <0.01218, 0.1463, 0.01376> }
				triangle { <0.01218, 0.1463, 0.01376>, <0.01218, 0.1463, 0.01376>, <0.009878, 0.1791, 0.009859> }
				triangle { <0.009878, 0.1791, 0.009859>, <0.005258, 0.2449, 0.002051>, <0.007568, 0.212, 0.005955> }
				triangle { <0.009878, 0.1791, 0.009859>, <0.007568, 0.212, 0.005955>, <0.005258, 0.2449, 0.002051> }
				triangle { <0.005258, 0.2449, 0.002051>, <-0.01563, 0.3091, -0.008602>, <0.004104, 0.2613, 0.00009966> }
				triangle { <0.005258, 0.2449, 0.002051>, <0.004104, 0.2613, 0.00009966>, <-0.01563, 0.3091, -0.008602> }
				triangle { <-0.01563, 0.3091, -0.008602>, <-0.02025, 0.3749, -0.01641>, <-0.002824, 0.3599, -0.01161> }
				triangle { <-0.01563, 0.3091, -0.008602>, <-0.002824, 0.3599, -0.01161>, <-0.02025, 0.3749, -0.01641> }
				triangle { <-0.02025, 0.3749, -0.01641>, <-0.02487, 0.4406, -0.02421>, <-0.02188, 0.4389, -0.04044> }
				triangle { <-0.02025, 0.3749, -0.01641>, <-0.02188, 0.4389, -0.04044>, <-0.02487, 0.4406, -0.02421> }
				triangle { <-0.02487, 0.4406, -0.02421>, <-0.04577, 0.5049, -0.03487>, <-0.02188, 0.4389, -0.04044> }
				triangle { <-0.02487, 0.4406, -0.02421>, <-0.02188, 0.4389, -0.04044>, <-0.04577, 0.5049, -0.03487> }
				triangle { <-0.04577, 0.5049, -0.03487>, <-0.05039, 0.5706, -0.04268>, <-0.02881, 0.5375, -0.05215> }
				triangle { <-0.04577, 0.5049, -0.03487>, <-0.02881, 0.5375, -0.05215>, <-0.05039, 0.5706, -0.04268> }
				triangle { <-0.05039, 0.5706, -0.04268>, <-0.05501, 0.6363, -0.05048>, <-0.05086, 0.6182, -0.06476> }
				triangle { <-0.05039, 0.5706, -0.04268>, <-0.05086, 0.6182, -0.06476>, <-0.05501, 0.6363, -0.05048> }
				triangle { <-0.05501, 0.6363, -0.05048>, <-0.0759, 0.7006, -0.06114>, <-0.07291, 0.6989, -0.07737> }
				triangle { <-0.05501, 0.6363, -0.05048>, <-0.07291, 0.6989, -0.07737>, <-0.0759, 0.7006, -0.06114> }
				triangle { <-0.0759, 0.7006, -0.06114>, <-0.0968, 0.7649, -0.07179>, <-0.07291, 0.6989, -0.07737> }
				triangle { <-0.0759, 0.7006, -0.06114>, <-0.07291, 0.6989, -0.07737>, <-0.0968, 0.7649, -0.07179> }
				triangle { <-0.0968, 0.7649, -0.07179>, <-0.1014, 0.8306, -0.0796>, <-0.07868, 0.7811, -0.08712> }
				triangle { <-0.0968, 0.7649, -0.07179>, <-0.07868, 0.7811, -0.08712>, <-0.1014, 0.8306, -0.0796> }
				triangle { <-0.1014, 0.8306, -0.0796>, <-0.1211, 0.8784, -0.0883>, <-0.1018, 0.8782, -0.1016> }
				triangle { <-0.1014, 0.8306, -0.0796>, <-0.1018, 0.8782, -0.1016>, <-0.1211, 0.8784, -0.0883> }
				triangle { <-0.1211, 0.8784, -0.0883>, <-0.142, 0.9427, -0.09896>, <-0.1402, 0.9574, -0.1171> }
				triangle { <-0.1211, 0.8784, -0.0883>, <-0.1402, 0.9574, -0.1171>, <-0.142, 0.9427, -0.09896> }
				triangle { <-0.142, 0.9427, -0.09896>, <-0.1629, 1.006983, -0.1096>, <-0.1402, 0.9574, -0.1171> }
				triangle { <-0.142, 0.9427, -0.09896>, <-0.1402, 0.9574, -0.1171>, <-0.1629, 1.006983, -0.1096> }
				triangle { <-0.1629, 1.006983, -0.1096>, <-0.1838, 1.07123, -0.1202>, <-0.1622, 1.03813, -0.1297> }
				triangle { <-0.1629, 1.006983, -0.1096>, <-0.1622, 1.03813, -0.1297>, <-0.1838, 1.07123, -0.1202> }
				triangle { <-0.1838, 1.07123, -0.1202>, <-0.2077, 1.1372, -0.1146>, <-0.1873, 1.1205, -0.1261> }
				triangle { <-0.1838, 1.07123, -0.1202>, <-0.1873, 1.1205, -0.1261>, <-0.2077, 1.1372, -0.1146> }
				triangle { <-0.2077, 1.1372, -0.1146>, <-0.2274, 1.185, -0.1234>, <-0.2256, 1.1997, -0.1415> }
				triangle { <-0.2077, 1.1372, -0.1146>, <-0.2256, 1.1997, -0.1415>, <-0.2274, 1.185, -0.1234> }
				triangle { <-0.2274, 1.185, -0.1234>, <-0.2483, 1.2492, -0.134>, <-0.2309, 1.2343, -0.1292> }
				triangle { <-0.2274, 1.185, -0.1234>, <-0.2309, 1.2343, -0.1292>, <-0.2483, 1.2492, -0.134> }
				triangle { <-0.2483, 1.2492, -0.134>, <-0.2711, 1.2988, -0.1265>, <-0.2506, 1.2821, -0.1379> }
				triangle { <-0.2483, 1.2492, -0.134>, <-0.2506, 1.2821, -0.1379>, <-0.2711, 1.2988, -0.1265> }
				triangle { <-0.2711, 1.2988, -0.1265>, <-0.292, 1.363, -0.1371>, <-0.2745, 1.3481, -0.1323> }
				triangle { <-0.2711, 1.2988, -0.1265>, <-0.2745, 1.3481, -0.1323>, <-0.292, 1.363, -0.1371> }
				triangle { <-0.292, 1.363, -0.1371>, <-0.3147, 1.4126, -0.1296>, <-0.2984, 1.4141, -0.1268> }
				triangle { <-0.292, 1.363, -0.1371>, <-0.2984, 1.4141, -0.1268>, <-0.3147, 1.4126, -0.1296> }
				triangle { <-0.3147, 1.4126, -0.1296>, <-0.3386, 1.4785, -0.124>, <-0.3386, 1.4785, -0.124> }
				triangle { <-0.3147, 1.4126, -0.1296>, <-0.3386, 1.4785, -0.124>, <-0.3386, 1.4785, -0.124> }
				triangle { <-0.3386, 1.4785, -0.124>, <-0.3613, 1.5281, -0.1165>, <-0.3386, 1.4785, -0.124> }
				triangle { <-0.3386, 1.4785, -0.124>, <-0.3386, 1.4785, -0.124>, <-0.3613, 1.5281, -0.1165> }
				triangle { <-0.3386, 1.4785, -0.124>, <-0.2984, 1.4141, -0.1268>, <-0.3147, 1.4126, -0.1296> }
				triangle { <-0.3386, 1.4785, -0.124>, <-0.3147, 1.4126, -0.1296>, <-0.2984, 1.4141, -0.1268> }
				triangle { <-0.2984, 1.4141, -0.1268>, <-0.2745, 1.3481, -0.1323>, <-0.292, 1.363, -0.1371> }
				triangle { <-0.2984, 1.4141, -0.1268>, <-0.292, 1.363, -0.1371>, <-0.2745, 1.3481, -0.1323> }
				triangle { <-0.2745, 1.3481, -0.1323>, <-0.2506, 1.2821, -0.1379>, <-0.2711, 1.2988, -0.1265> }
				triangle { <-0.2745, 1.3481, -0.1323>, <-0.2711, 1.2988, -0.1265>, <-0.2506, 1.2821, -0.1379> }
				triangle { <-0.2506, 1.2821, -0.1379>, <-0.2309, 1.2343, -0.1292>, <-0.2483, 1.2492, -0.134> }
				triangle { <-0.2506, 1.2821, -0.1379>, <-0.2483, 1.2492, -0.134>, <-0.2309, 1.2343, -0.1292> }
				triangle { <0.004104, 0.2613, 0.00009966>, <0.007568, 0.212, 0.005955>, <0.005258, 0.2449, 0.002051> }
				triangle { <0.004104, 0.2613, 0.00009966>, <0.005258, 0.2449, 0.002051>, <0.007568, 0.212, 0.005955> }
				triangle { <0.007568, 0.212, 0.005955>, <0.01218, 0.1463, 0.01376>, <0.009878, 0.1791, 0.009859> }
				triangle { <0.007568, 0.212, 0.005955>, <0.009878, 0.1791, 0.009859>, <0.01218, 0.1463, 0.01376> }
				triangle { <-0.2309, 1.2343, -0.1292>, <-0.2256, 1.1997, -0.1415>, <-0.2274, 1.185, -0.1234> }
				triangle { <-0.2309, 1.2343, -0.1292>, <-0.2274, 1.185, -0.1234>, <-0.2256, 1.1997, -0.1415> }
				triangle { <-0.2256, 1.1997, -0.1415>, <-0.1873, 1.1205, -0.1261>, <-0.2077, 1.1372, -0.1146> }
				triangle { <-0.2256, 1.1997, -0.1415>, <-0.2077, 1.1372, -0.1146>, <-0.1873, 1.1205, -0.1261> }
				triangle { <-0.1873, 1.1205, -0.1261>, <-0.1622, 1.03813, -0.1297>, <-0.1838, 1.07123, -0.1202> }
				triangle { <-0.1873, 1.1205, -0.1261>, <-0.1838, 1.07123, -0.1202>, <-0.1622, 1.03813, -0.1297> }
				triangle { <-0.1622, 1.03813, -0.1297>, <-0.1402, 0.9574, -0.1171>, <-0.1629, 1.006983, -0.1096> }
				triangle { <-0.1622, 1.03813, -0.1297>, <-0.1629, 1.006983, -0.1096>, <-0.1402, 0.9574, -0.1171> }
				triangle { <-0.1402, 0.9574, -0.1171>, <-0.1018, 0.8782, -0.1016>, <-0.1211, 0.8784, -0.0883> }
				triangle { <-0.1402, 0.9574, -0.1171>, <-0.1211, 0.8784, -0.0883>, <-0.1018, 0.8782, -0.1016> }
				triangle { <-0.1018, 0.8782, -0.1016>, <-0.07868, 0.7811, -0.08712>, <-0.1014, 0.8306, -0.0796> }
				triangle { <-0.1018, 0.8782, -0.1016>, <-0.1014, 0.8306, -0.0796>, <-0.07868, 0.7811, -0.08712> }
				triangle { <-0.07868, 0.7811, -0.08712>, <-0.07291, 0.6989, -0.07737>, <-0.0968, 0.7649, -0.07179> }
				triangle { <-0.07868, 0.7811, -0.08712>, <-0.0968, 0.7649, -0.07179>, <-0.07291, 0.6989, -0.07737> }
				triangle { <-0.07291, 0.6989, -0.07737>, <-0.05086, 0.6182, -0.06476>, <-0.05501, 0.6363, -0.05048> }
				triangle { <-0.07291, 0.6989, -0.07737>, <-0.05501, 0.6363, -0.05048>, <-0.05086, 0.6182, -0.06476> }
				triangle { <-0.05086, 0.6182, -0.06476>, <-0.02881, 0.5375, -0.05215>, <-0.05039, 0.5706, -0.04268> }
				triangle { <-0.05086, 0.6182, -0.06476>, <-0.05039, 0.5706, -0.04268>, <-0.02881, 0.5375, -0.05215> }
				triangle { <-0.02881, 0.5375, -0.05215>, <-0.02188, 0.4389, -0.04044>, <-0.04577, 0.5049, -0.03487> }
				triangle { <-0.02881, 0.5375, -0.05215>, <-0.04577, 0.5049, -0.03487>, <-0.02188, 0.4389, -0.04044> }
				triangle { <-0.02188, 0.4389, -0.04044>, <-0.002824, 0.3599, -0.01161>, <-0.02025, 0.3749, -0.01641> }
				triangle { <-0.02188, 0.4389, -0.04044>, <-0.02025, 0.3749, -0.01641>, <-0.002824, 0.3599, -0.01161> }
				triangle { <-0.002824, 0.3599, -0.01161>, <0.004104, 0.2613, 0.00009966>, <-0.01563, 0.3091, -0.008602> }
				triangle { <-0.002824, 0.3599, -0.01161>, <-0.01563, 0.3091, -0.008602>, <0.004104, 0.2613, 0.00009966> }
				texture {T_ClumpLeaf2}}
			}
		}
	union { // Internode
		cylinder { <-0.004607, 0.06632, 0.006062>, <-0.004943, 0.06981, 0.006454>, 0.003728 }
		cylinder { <-0.004943, 0.06981, 0.006454>, <-0.005255, 0.07329, 0.00693>, 0.003728 }
		cylinder { <-0.005255, 0.07329, 0.00693>, <-0.005543, 0.07676, 0.007488>, 0.003728 }
		texture {T_ClumpStem}}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-0.005543, 0.07676, 0.007488>, <-0.005549, 0.07819, 0.008123>, 0.000111 }
			cylinder { <-0.005549, 0.07819, 0.008123>, <-0.005432, 0.0794, 0.009099>, 0.000111 }
			cylinder { <-0.005432, 0.0794, 0.009099>, <-0.005202, 0.08032, 0.01034>, 0.000111 }
			texture {T_ClumpLeaf}}
		union { // compound leaf
			union { // Petiole
				cylinder { <-0.005202, 0.08032, 0.01034>, <-0.00513, 0.08058, 0.01072>, 0.000111 }
				cylinder { <-0.00513, 0.08058, 0.01072>, <-0.005055, 0.08084, 0.01111>, 0.000111 }
				cylinder { <-0.005055, 0.08084, 0.01111>, <-0.004977, 0.08108, 0.0115>, 0.000111 }
				texture {T_ClumpLeaf}}
			union { // Petiole
				cylinder { <-0.004977, 0.08108, 0.0115>, <-0.005006, 0.08122, 0.01176>, 0.0000212 }
				cylinder { <-0.005006, 0.08122, 0.01176>, <-0.00511, 0.08134, 0.01202>, 0.0000212 }
				cylinder { <-0.00511, 0.08134, 0.01202>, <-0.005283, 0.08142, 0.01225>, 0.0000212 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <-0.005283, 0.08142, 0.01225>, <-0.009759, 0.09253, 0.014>, <-0.009759, 0.09253, 0.014> }
				triangle { <-0.005283, 0.08142, 0.01225>, <-0.009759, 0.09253, 0.014>, <-0.009759, 0.09253, 0.014> }
				triangle { <-0.009759, 0.09253, 0.014>, <-0.01274, 0.09993, 0.01517>, <-0.009759, 0.09253, 0.014> }
				triangle { <-0.009759, 0.09253, 0.014>, <-0.009759, 0.09253, 0.014>, <-0.01274, 0.09993, 0.01517> }
				triangle { <-0.01274, 0.09993, 0.01517>, <-0.01871, 0.1147, 0.01751>, <-0.01572, 0.1073, 0.01634> }
				triangle { <-0.01274, 0.09993, 0.01517>, <-0.01572, 0.1073, 0.01634>, <-0.01871, 0.1147, 0.01751> }
				triangle { <-0.01871, 0.1147, 0.01751>, <-0.02436, 0.1303, 0.0159>, <-0.0202, 0.1184, 0.0181> }
				triangle { <-0.01871, 0.1147, 0.01751>, <-0.0202, 0.1184, 0.0181>, <-0.02436, 0.1303, 0.0159> }
				triangle { <-0.02436, 0.1303, 0.0159>, <-0.03032, 0.1451, 0.01824>, <-0.02915, 0.1406, 0.02161> }
				triangle { <-0.02436, 0.1303, 0.0159>, <-0.02915, 0.1406, 0.02161>, <-0.03032, 0.1451, 0.01824> }
				triangle { <-0.03032, 0.1451, 0.01824>, <-0.03629, 0.1599, 0.02059>, <-0.03256, 0.1613, 0.02115> }
				triangle { <-0.03032, 0.1451, 0.01824>, <-0.03256, 0.1613, 0.02115>, <-0.03629, 0.1599, 0.02059> }
				triangle { <-0.03629, 0.1599, 0.02059>, <-0.04194, 0.1754, 0.01898>, <-0.03256, 0.1613, 0.02115> }
				triangle { <-0.03629, 0.1599, 0.02059>, <-0.03256, 0.1613, 0.02115>, <-0.04194, 0.1754, 0.01898> }
				triangle { <-0.04194, 0.1754, 0.01898>, <-0.04791, 0.1903, 0.02132>, <-0.04151, 0.1835, 0.02467> }
				triangle { <-0.04194, 0.1754, 0.01898>, <-0.04151, 0.1835, 0.02467>, <-0.04791, 0.1903, 0.02132> }
				triangle { <-0.04791, 0.1903, 0.02132>, <-0.05388, 0.2051, 0.02366>, <-0.04865, 0.2028, 0.02364> }
				triangle { <-0.04791, 0.1903, 0.02132>, <-0.04865, 0.2028, 0.02364>, <-0.05388, 0.2051, 0.02366> }
				triangle { <-0.05388, 0.2051, 0.02366>, <-0.05953, 0.2206, 0.02205>, <-0.0558, 0.222, 0.02262> }
				triangle { <-0.05388, 0.2051, 0.02366>, <-0.0558, 0.222, 0.02262>, <-0.05953, 0.2206, 0.02205> }
				triangle { <-0.05953, 0.2206, 0.02205>, <-0.06518, 0.2362, 0.02044>, <-0.0558, 0.222, 0.02262> }
				triangle { <-0.05953, 0.2206, 0.02205>, <-0.0558, 0.222, 0.02262>, <-0.06518, 0.2362, 0.02044> }
				triangle { <-0.06518, 0.2362, 0.02044>, <-0.07115, 0.251, 0.02278>, <-0.06326, 0.2406, 0.02554> }
				triangle { <-0.06518, 0.2362, 0.02044>, <-0.06326, 0.2406, 0.02554>, <-0.07115, 0.251, 0.02278> }
				triangle { <-0.07115, 0.251, 0.02278>, <-0.07531, 0.2629, 0.02058>, <-0.07189, 0.2635, 0.0251> }
				triangle { <-0.07115, 0.251, 0.02278>, <-0.07189, 0.2635, 0.0251>, <-0.07531, 0.2629, 0.02058> }
				triangle { <-0.07531, 0.2629, 0.02058>, <-0.08096, 0.2784, 0.01897>, <-0.07872, 0.2835, 0.02013> }
				triangle { <-0.07531, 0.2629, 0.02058>, <-0.07872, 0.2835, 0.02013>, <-0.08096, 0.2784, 0.01897> }
				triangle { <-0.08096, 0.2784, 0.01897>, <-0.08661, 0.294, 0.01736>, <-0.07872, 0.2835, 0.02013> }
				triangle { <-0.08096, 0.2784, 0.01897>, <-0.07872, 0.2835, 0.02013>, <-0.08661, 0.294, 0.01736> }
				triangle { <-0.08661, 0.294, 0.01736>, <-0.09226, 0.3095, 0.01575>, <-0.08586, 0.3028, 0.0191> }
				triangle { <-0.08661, 0.294, 0.01736>, <-0.08586, 0.3028, 0.0191>, <-0.09226, 0.3095, 0.01575> }
				triangle { <-0.09226, 0.3095, 0.01575>, <-0.1016, 0.3237, 0.01357>, <-0.09674, 0.3207, 0.01751> }
				triangle { <-0.09226, 0.3095, 0.01575>, <-0.09674, 0.3207, 0.01751>, <-0.1016, 0.3237, 0.01357> }
				triangle { <-0.1016, 0.3237, 0.01357>, <-0.1058, 0.3355, 0.01138>, <-0.1035, 0.3407, 0.01253> }
				triangle { <-0.1016, 0.3237, 0.01357>, <-0.1035, 0.3407, 0.01253>, <-0.1058, 0.3355, 0.01138> }
				triangle { <-0.1058, 0.3355, 0.01138>, <-0.1114, 0.3511, 0.009772>, <-0.1102, 0.3467, 0.01313> }
				triangle { <-0.1058, 0.3355, 0.01138>, <-0.1102, 0.3467, 0.01313>, <-0.1114, 0.3511, 0.009772> }
				triangle { <-0.1114, 0.3511, 0.009772>, <-0.1193, 0.3616, 0.007008>, <-0.1144, 0.3585, 0.01094> }
				triangle { <-0.1114, 0.3511, 0.009772>, <-0.1144, 0.3585, 0.01094>, <-0.1193, 0.3616, 0.007008> }
				triangle { <-0.1193, 0.3616, 0.007008>, <-0.125, 0.3771, 0.005398>, <-0.1238, 0.3727, 0.008763> }
				triangle { <-0.1193, 0.3616, 0.007008>, <-0.1238, 0.3727, 0.008763>, <-0.125, 0.3771, 0.005398> }
				triangle { <-0.125, 0.3771, 0.005398>, <-0.1329, 0.3876, 0.002634>, <-0.1332, 0.3868, 0.006585> }
				triangle { <-0.125, 0.3771, 0.005398>, <-0.1332, 0.3868, 0.006585>, <-0.1329, 0.3876, 0.002634> }
				triangle { <-0.1329, 0.3876, 0.002634>, <-0.1422, 0.4017, 0.0004556>, <-0.1422, 0.4017, 0.0004556> }
				triangle { <-0.1329, 0.3876, 0.002634>, <-0.1422, 0.4017, 0.0004556>, <-0.1422, 0.4017, 0.0004556> }
				triangle { <-0.1422, 0.4017, 0.0004556>, <-0.1501, 0.4122, -0.002308>, <-0.1422, 0.4017, 0.0004556> }
				triangle { <-0.1422, 0.4017, 0.0004556>, <-0.1422, 0.4017, 0.0004556>, <-0.1501, 0.4122, -0.002308> }
				triangle { <-0.1422, 0.4017, 0.0004556>, <-0.1332, 0.3868, 0.006585>, <-0.1329, 0.3876, 0.002634> }
				triangle { <-0.1422, 0.4017, 0.0004556>, <-0.1329, 0.3876, 0.002634>, <-0.1332, 0.3868, 0.006585> }
				triangle { <-0.1332, 0.3868, 0.006585>, <-0.1238, 0.3727, 0.008763>, <-0.125, 0.3771, 0.005398> }
				triangle { <-0.1332, 0.3868, 0.006585>, <-0.125, 0.3771, 0.005398>, <-0.1238, 0.3727, 0.008763> }
				triangle { <-0.1238, 0.3727, 0.008763>, <-0.1144, 0.3585, 0.01094>, <-0.1193, 0.3616, 0.007008> }
				triangle { <-0.1238, 0.3727, 0.008763>, <-0.1193, 0.3616, 0.007008>, <-0.1144, 0.3585, 0.01094> }
				triangle { <-0.1144, 0.3585, 0.01094>, <-0.1102, 0.3467, 0.01313>, <-0.1114, 0.3511, 0.009772> }
				triangle { <-0.1144, 0.3585, 0.01094>, <-0.1114, 0.3511, 0.009772>, <-0.1102, 0.3467, 0.01313> }
				triangle { <-0.0202, 0.1184, 0.0181>, <-0.01572, 0.1073, 0.01634>, <-0.01871, 0.1147, 0.01751> }
				triangle { <-0.0202, 0.1184, 0.0181>, <-0.01871, 0.1147, 0.01751>, <-0.01572, 0.1073, 0.01634> }
				triangle { <-0.01572, 0.1073, 0.01634>, <-0.009759, 0.09253, 0.014>, <-0.01274, 0.09993, 0.01517> }
				triangle { <-0.01572, 0.1073, 0.01634>, <-0.01274, 0.09993, 0.01517>, <-0.009759, 0.09253, 0.014> }
				triangle { <-0.1102, 0.3467, 0.01313>, <-0.1035, 0.3407, 0.01253>, <-0.1058, 0.3355, 0.01138> }
				triangle { <-0.1102, 0.3467, 0.01313>, <-0.1058, 0.3355, 0.01138>, <-0.1035, 0.3407, 0.01253> }
				triangle { <-0.1035, 0.3407, 0.01253>, <-0.09674, 0.3207, 0.01751>, <-0.1016, 0.3237, 0.01357> }
				triangle { <-0.1035, 0.3407, 0.01253>, <-0.1016, 0.3237, 0.01357>, <-0.09674, 0.3207, 0.01751> }
				triangle { <-0.09674, 0.3207, 0.01751>, <-0.08586, 0.3028, 0.0191>, <-0.09226, 0.3095, 0.01575> }
				triangle { <-0.09674, 0.3207, 0.01751>, <-0.09226, 0.3095, 0.01575>, <-0.08586, 0.3028, 0.0191> }
				triangle { <-0.08586, 0.3028, 0.0191>, <-0.07872, 0.2835, 0.02013>, <-0.08661, 0.294, 0.01736> }
				triangle { <-0.08586, 0.3028, 0.0191>, <-0.08661, 0.294, 0.01736>, <-0.07872, 0.2835, 0.02013> }
				triangle { <-0.07872, 0.2835, 0.02013>, <-0.07189, 0.2635, 0.0251>, <-0.07531, 0.2629, 0.02058> }
				triangle { <-0.07872, 0.2835, 0.02013>, <-0.07531, 0.2629, 0.02058>, <-0.07189, 0.2635, 0.0251> }
				triangle { <-0.07189, 0.2635, 0.0251>, <-0.06326, 0.2406, 0.02554>, <-0.07115, 0.251, 0.02278> }
				triangle { <-0.07189, 0.2635, 0.0251>, <-0.07115, 0.251, 0.02278>, <-0.06326, 0.2406, 0.02554> }
				triangle { <-0.06326, 0.2406, 0.02554>, <-0.0558, 0.222, 0.02262>, <-0.06518, 0.2362, 0.02044> }
				triangle { <-0.06326, 0.2406, 0.02554>, <-0.06518, 0.2362, 0.02044>, <-0.0558, 0.222, 0.02262> }
				triangle { <-0.0558, 0.222, 0.02262>, <-0.04865, 0.2028, 0.02364>, <-0.05388, 0.2051, 0.02366> }
				triangle { <-0.0558, 0.222, 0.02262>, <-0.05388, 0.2051, 0.02366>, <-0.04865, 0.2028, 0.02364> }
				triangle { <-0.04865, 0.2028, 0.02364>, <-0.04151, 0.1835, 0.02467>, <-0.04791, 0.1903, 0.02132> }
				triangle { <-0.04865, 0.2028, 0.02364>, <-0.04791, 0.1903, 0.02132>, <-0.04151, 0.1835, 0.02467> }
				triangle { <-0.04151, 0.1835, 0.02467>, <-0.03256, 0.1613, 0.02115>, <-0.04194, 0.1754, 0.01898> }
				triangle { <-0.04151, 0.1835, 0.02467>, <-0.04194, 0.1754, 0.01898>, <-0.03256, 0.1613, 0.02115> }
				triangle { <-0.03256, 0.1613, 0.02115>, <-0.02915, 0.1406, 0.02161>, <-0.03032, 0.1451, 0.01824> }
				triangle { <-0.03256, 0.1613, 0.02115>, <-0.03032, 0.1451, 0.01824>, <-0.02915, 0.1406, 0.02161> }
				triangle { <-0.02915, 0.1406, 0.02161>, <-0.0202, 0.1184, 0.0181>, <-0.02436, 0.1303, 0.0159> }
				triangle { <-0.02915, 0.1406, 0.02161>, <-0.02436, 0.1303, 0.0159>, <-0.0202, 0.1184, 0.0181> }
				texture {T_ClumpLeaf2}}
			union { // Petiole
				cylinder { <-0.004977, 0.08108, 0.0115>, <-0.004928, 0.08124, 0.01175>, 0.0000212 }
				cylinder { <-0.004928, 0.08124, 0.01175>, <-0.004878, 0.0814, 0.012>, 0.0000212 }
				cylinder { <-0.004878, 0.0814, 0.012>, <-0.004829, 0.08155, 0.01225>, 0.0000212 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <-0.004829, 0.08155, 0.01225>, <-0.003695, 0.09359, 0.01282>, <-0.003695, 0.09359, 0.01282> }
				triangle { <-0.004829, 0.08155, 0.01225>, <-0.003695, 0.09359, 0.01282>, <-0.003695, 0.09359, 0.01282> }
				triangle { <-0.003695, 0.09359, 0.01282>, <-0.002939, 0.1016, 0.01319>, <-0.003695, 0.09359, 0.01282> }
				triangle { <-0.003695, 0.09359, 0.01282>, <-0.003695, 0.09359, 0.01282>, <-0.002939, 0.1016, 0.01319> }
				triangle { <-0.002939, 0.1016, 0.01319>, <-0.001427, 0.1176, 0.01395>, <-0.002183, 0.1096, 0.01357> }
				triangle { <-0.002939, 0.1016, 0.01319>, <-0.002183, 0.1096, 0.01357>, <-0.001427, 0.1176, 0.01395> }
				triangle { <-0.001427, 0.1176, 0.01395>, <-0.002032, 0.134, 0.01129>, <-0.001049, 0.1216, 0.01414> }
				triangle { <-0.001427, 0.1176, 0.01395>, <-0.001049, 0.1216, 0.01414>, <-0.002032, 0.134, 0.01129> }
				triangle { <-0.002032, 0.134, 0.01129>, <-0.0005201, 0.1501, 0.01204>, <0.001218, 0.1457, 0.01527> }
				triangle { <-0.002032, 0.134, 0.01129>, <0.001218, 0.1457, 0.01527>, <-0.0005201, 0.1501, 0.01204> }
				triangle { <-0.0005201, 0.1501, 0.01204>, <0.0009917, 0.1661, 0.01279>, <0.004405, 0.1659, 0.01066> }
				triangle { <-0.0005201, 0.1501, 0.01204>, <0.004405, 0.1659, 0.01066>, <0.0009917, 0.1661, 0.01279> }
				triangle { <0.0009917, 0.1661, 0.01279>, <0.0003874, 0.1825, 0.01013>, <0.004405, 0.1659, 0.01066> }
				triangle { <0.0009917, 0.1661, 0.01279>, <0.004405, 0.1659, 0.01066>, <0.0003874, 0.1825, 0.01013> }
				triangle { <0.0003874, 0.1825, 0.01013>, <0.001899, 0.1986, 0.01089>, <0.006673, 0.19, 0.01179> }
				triangle { <0.0003874, 0.1825, 0.01013>, <0.006673, 0.19, 0.01179>, <0.001899, 0.1986, 0.01089> }
				triangle { <0.001899, 0.1986, 0.01089>, <0.003411, 0.2146, 0.01164>, <0.006447, 0.2104, 0.00932> }
				triangle { <0.001899, 0.1986, 0.01089>, <0.006447, 0.2104, 0.00932>, <0.003411, 0.2146, 0.01164> }
				triangle { <0.003411, 0.2146, 0.01164>, <0.002806, 0.231, 0.008986>, <0.00622, 0.2308, 0.006847> }
				triangle { <0.003411, 0.2146, 0.01164>, <0.00622, 0.2308, 0.006847>, <0.002806, 0.231, 0.008986> }
				triangle { <0.002806, 0.231, 0.008986>, <0.002202, 0.2475, 0.006324>, <0.00622, 0.2308, 0.006847> }
				triangle { <0.002806, 0.231, 0.008986>, <0.00622, 0.2308, 0.006847>, <0.002202, 0.2475, 0.006324> }
				triangle { <0.002202, 0.2475, 0.006324>, <0.003714, 0.2635, 0.007079>, <0.00811, 0.2509, 0.007791> }
				triangle { <0.002202, 0.2475, 0.006324>, <0.00811, 0.2509, 0.007791>, <0.003714, 0.2635, 0.007079> }
				triangle { <0.003714, 0.2635, 0.007079>, <0.002732, 0.2759, 0.004229>, <0.008262, 0.2753, 0.005506> }
				triangle { <0.003714, 0.2635, 0.007079>, <0.008262, 0.2753, 0.005506>, <0.002732, 0.2759, 0.004229> }
				triangle { <0.002732, 0.2759, 0.004229>, <0.002127, 0.2923, 0.001567>, <0.00592, 0.2961, -0.0003819> }
				triangle { <0.002732, 0.2759, 0.004229>, <0.00592, 0.2961, -0.0003819>, <0.002127, 0.2923, 0.001567> }
				triangle { <0.002127, 0.2923, 0.001567>, <0.001523, 0.3087, -0.001093>, <0.00592, 0.2961, -0.0003819> }
				triangle { <0.002127, 0.2923, 0.001567>, <0.00592, 0.2961, -0.0003819>, <0.001523, 0.3087, -0.001093> }
				triangle { <0.001523, 0.3087, -0.001093>, <0.0009194, 0.3251, -0.003755>, <0.005693, 0.3165, -0.002854> }
				triangle { <0.001523, 0.3087, -0.001093>, <0.005693, 0.3165, -0.002854>, <0.0009194, 0.3251, -0.003755> }
				triangle { <0.0009194, 0.3251, -0.003755>, <-0.003098, 0.3418, -0.004278>, <0.002053, 0.3372, -0.003189> }
				triangle { <0.0009194, 0.3251, -0.003755>, <0.002053, 0.3372, -0.003189>, <-0.003098, 0.3418, -0.004278> }
				triangle { <-0.003098, 0.3418, -0.004278>, <-0.004081, 0.3542, -0.007128>, <-0.0002891, 0.3579, -0.009078> }
				triangle { <-0.003098, 0.3418, -0.004278>, <-0.0002891, 0.3579, -0.009078>, <-0.004081, 0.3542, -0.007128> }
				triangle { <-0.004081, 0.3542, -0.007128>, <-0.004685, 0.3706, -0.009789>, <-0.002947, 0.3662, -0.006562> }
				triangle { <-0.004081, 0.3542, -0.007128>, <-0.002947, 0.3662, -0.006562>, <-0.004685, 0.3706, -0.009789> }
				triangle { <-0.004685, 0.3706, -0.009789>, <-0.009081, 0.3832, -0.0105>, <-0.003929, 0.3786, -0.009412> }
				triangle { <-0.004685, 0.3706, -0.009789>, <-0.003929, 0.3786, -0.009412>, <-0.009081, 0.3832, -0.0105> }
				triangle { <-0.009081, 0.3832, -0.0105>, <-0.009686, 0.3996, -0.01316>, <-0.007947, 0.3952, -0.009935> }
				triangle { <-0.009081, 0.3832, -0.0105>, <-0.007947, 0.3952, -0.009935>, <-0.009686, 0.3996, -0.01316> }
				triangle { <-0.009686, 0.3996, -0.01316>, <-0.01408, 0.4122, -0.01387>, <-0.01196, 0.4118, -0.01045> }
				triangle { <-0.009686, 0.3996, -0.01316>, <-0.01196, 0.4118, -0.01045>, <-0.01408, 0.4122, -0.01387> }
				triangle { <-0.01408, 0.4122, -0.01387>, <-0.0181, 0.4288, -0.01439>, <-0.0181, 0.4288, -0.01439> }
				triangle { <-0.01408, 0.4122, -0.01387>, <-0.0181, 0.4288, -0.01439>, <-0.0181, 0.4288, -0.01439> }
				triangle { <-0.0181, 0.4288, -0.01439>, <-0.02249, 0.4415, -0.01511>, <-0.0181, 0.4288, -0.01439> }
				triangle { <-0.0181, 0.4288, -0.01439>, <-0.0181, 0.4288, -0.01439>, <-0.02249, 0.4415, -0.01511> }
				triangle { <-0.0181, 0.4288, -0.01439>, <-0.01196, 0.4118, -0.01045>, <-0.01408, 0.4122, -0.01387> }
				triangle { <-0.0181, 0.4288, -0.01439>, <-0.01408, 0.4122, -0.01387>, <-0.01196, 0.4118, -0.01045> }
				triangle { <-0.01196, 0.4118, -0.01045>, <-0.007947, 0.3952, -0.009935>, <-0.009686, 0.3996, -0.01316> }
				triangle { <-0.01196, 0.4118, -0.01045>, <-0.009686, 0.3996, -0.01316>, <-0.007947, 0.3952, -0.009935> }
				triangle { <-0.007947, 0.3952, -0.009935>, <-0.003929, 0.3786, -0.009412>, <-0.009081, 0.3832, -0.0105> }
				triangle { <-0.007947, 0.3952, -0.009935>, <-0.009081, 0.3832, -0.0105>, <-0.003929, 0.3786, -0.009412> }
				triangle { <-0.003929, 0.3786, -0.009412>, <-0.002947, 0.3662, -0.006562>, <-0.004685, 0.3706, -0.009789> }
				triangle { <-0.003929, 0.3786, -0.009412>, <-0.004685, 0.3706, -0.009789>, <-0.002947, 0.3662, -0.006562> }
				triangle { <-0.001049, 0.1216, 0.01414>, <-0.002183, 0.1096, 0.01357>, <-0.001427, 0.1176, 0.01395> }
				triangle { <-0.001049, 0.1216, 0.01414>, <-0.001427, 0.1176, 0.01395>, <-0.002183, 0.1096, 0.01357> }
				triangle { <-0.002183, 0.1096, 0.01357>, <-0.003695, 0.09359, 0.01282>, <-0.002939, 0.1016, 0.01319> }
				triangle { <-0.002183, 0.1096, 0.01357>, <-0.002939, 0.1016, 0.01319>, <-0.003695, 0.09359, 0.01282> }
				triangle { <-0.002947, 0.3662, -0.006562>, <-0.0002891, 0.3579, -0.009078>, <-0.004081, 0.3542, -0.007128> }
				triangle { <-0.002947, 0.3662, -0.006562>, <-0.004081, 0.3542, -0.007128>, <-0.0002891, 0.3579, -0.009078> }
				triangle { <-0.0002891, 0.3579, -0.009078>, <0.002053, 0.3372, -0.003189>, <-0.003098, 0.3418, -0.004278> }
				triangle { <-0.0002891, 0.3579, -0.009078>, <-0.003098, 0.3418, -0.004278>, <0.002053, 0.3372, -0.003189> }
				triangle { <0.002053, 0.3372, -0.003189>, <0.005693, 0.3165, -0.002854>, <0.0009194, 0.3251, -0.003755> }
				triangle { <0.002053, 0.3372, -0.003189>, <0.0009194, 0.3251, -0.003755>, <0.005693, 0.3165, -0.002854> }
				triangle { <0.005693, 0.3165, -0.002854>, <0.00592, 0.2961, -0.0003819>, <0.001523, 0.3087, -0.001093> }
				triangle { <0.005693, 0.3165, -0.002854>, <0.001523, 0.3087, -0.001093>, <0.00592, 0.2961, -0.0003819> }
				triangle { <0.00592, 0.2961, -0.0003819>, <0.008262, 0.2753, 0.005506>, <0.002732, 0.2759, 0.004229> }
				triangle { <0.00592, 0.2961, -0.0003819>, <0.002732, 0.2759, 0.004229>, <0.008262, 0.2753, 0.005506> }
				triangle { <0.008262, 0.2753, 0.005506>, <0.00811, 0.2509, 0.007791>, <0.003714, 0.2635, 0.007079> }
				triangle { <0.008262, 0.2753, 0.005506>, <0.003714, 0.2635, 0.007079>, <0.00811, 0.2509, 0.007791> }
				triangle { <0.00811, 0.2509, 0.007791>, <0.00622, 0.2308, 0.006847>, <0.002202, 0.2475, 0.006324> }
				triangle { <0.00811, 0.2509, 0.007791>, <0.002202, 0.2475, 0.006324>, <0.00622, 0.2308, 0.006847> }
				triangle { <0.00622, 0.2308, 0.006847>, <0.006447, 0.2104, 0.00932>, <0.003411, 0.2146, 0.01164> }
				triangle { <0.00622, 0.2308, 0.006847>, <0.003411, 0.2146, 0.01164>, <0.006447, 0.2104, 0.00932> }
				triangle { <0.006447, 0.2104, 0.00932>, <0.006673, 0.19, 0.01179>, <0.001899, 0.1986, 0.01089> }
				triangle { <0.006447, 0.2104, 0.00932>, <0.001899, 0.1986, 0.01089>, <0.006673, 0.19, 0.01179> }
				triangle { <0.006673, 0.19, 0.01179>, <0.004405, 0.1659, 0.01066>, <0.0003874, 0.1825, 0.01013> }
				triangle { <0.006673, 0.19, 0.01179>, <0.0003874, 0.1825, 0.01013>, <0.004405, 0.1659, 0.01066> }
				triangle { <0.004405, 0.1659, 0.01066>, <0.001218, 0.1457, 0.01527>, <-0.0005201, 0.1501, 0.01204> }
				triangle { <0.004405, 0.1659, 0.01066>, <-0.0005201, 0.1501, 0.01204>, <0.001218, 0.1457, 0.01527> }
				triangle { <0.001218, 0.1457, 0.01527>, <-0.001049, 0.1216, 0.01414>, <-0.002032, 0.134, 0.01129> }
				triangle { <0.001218, 0.1457, 0.01527>, <-0.002032, 0.134, 0.01129>, <-0.001049, 0.1216, 0.01414> }
				texture {T_ClumpLeaf2}}
			}
		}
	union { // leaf, petiole and stipule
		union { // Petiole
			cylinder { <-0.005543, 0.07676, 0.007488>, <-0.005784, 0.07829, 0.007329>, 0.000111 }
			cylinder { <-0.005784, 0.07829, 0.007329>, <-0.006119, 0.07972, 0.006777>, 0.000111 }
			cylinder { <-0.006119, 0.07972, 0.006777>, <-0.006526, 0.08093, 0.005871>, 0.000111 }
			texture {T_ClumpLeaf}}
		union { // compound leaf
			union { // Petiole
				cylinder { <-0.006526, 0.08093, 0.005871>, <-0.00665, 0.08128, 0.00559>, 0.000111 }
				cylinder { <-0.00665, 0.08128, 0.00559>, <-0.006775, 0.08163, 0.005301>, 0.000111 }
				cylinder { <-0.006775, 0.08163, 0.005301>, <-0.006901, 0.08197, 0.005003>, 0.000111 }
				texture {T_ClumpLeaf}}
			union { // Petiole
				cylinder { <-0.006901, 0.08197, 0.005003>, <-0.006902, 0.08219, 0.0048>, 0.0000212 }
				cylinder { <-0.006902, 0.08219, 0.0048>, <-0.006824, 0.08239, 0.004596>, 0.0000212 }
				cylinder { <-0.006824, 0.08239, 0.004596>, <-0.006673, 0.08257, 0.004408>, 0.0000212 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <-0.006673, 0.08257, 0.004408>, <-0.004089, 0.09424, 0.006315>, <-0.004089, 0.09424, 0.006315> }
				triangle { <-0.006673, 0.08257, 0.004408>, <-0.004089, 0.09424, 0.006315>, <-0.004089, 0.09424, 0.006315> }
				triangle { <-0.004089, 0.09424, 0.006315>, <-0.002366, 0.102, 0.007586>, <-0.004089, 0.09424, 0.006315> }
				triangle { <-0.004089, 0.09424, 0.006315>, <-0.004089, 0.09424, 0.006315>, <-0.002366, 0.102, 0.007586> }
				triangle { <-0.002366, 0.102, 0.007586>, <0.00108, 0.1175, 0.01012>, <-0.0006429, 0.1098, 0.008858> }
				triangle { <-0.002366, 0.102, 0.007586>, <-0.0006429, 0.1098, 0.008858>, <0.00108, 0.1175, 0.01012> }
				triangle { <0.00108, 0.1175, 0.01012>, <0.004195, 0.1325, 0.01665>, <0.001941, 0.1214, 0.01076> }
				triangle { <0.00108, 0.1175, 0.01012>, <0.001941, 0.1214, 0.01076>, <0.004195, 0.1325, 0.01665> }
				triangle { <0.004195, 0.1325, 0.01665>, <0.007641, 0.1481, 0.01919>, <0.00711, 0.1448, 0.01457> }
				triangle { <0.004195, 0.1325, 0.01665>, <0.00711, 0.1448, 0.01457>, <0.007641, 0.1481, 0.01919> }
				triangle { <0.007641, 0.1481, 0.01919>, <0.01108, 0.1636, 0.02173>, <0.00716, 0.1645, 0.02154> }
				triangle { <0.007641, 0.1481, 0.01919>, <0.00716, 0.1645, 0.02154>, <0.01108, 0.1636, 0.02173> }
				triangle { <0.01108, 0.1636, 0.02173>, <0.0142, 0.1786, 0.02825>, <0.00716, 0.1645, 0.02154> }
				triangle { <0.01108, 0.1636, 0.02173>, <0.00716, 0.1645, 0.02154>, <0.0142, 0.1786, 0.02825> }
				triangle { <0.0142, 0.1786, 0.02825>, <0.01764, 0.1942, 0.0308>, <0.01232, 0.1879, 0.02535> }
				triangle { <0.0142, 0.1786, 0.02825>, <0.01232, 0.1879, 0.02535>, <0.01764, 0.1942, 0.0308> }
				triangle { <0.01764, 0.1942, 0.0308>, <0.02109, 0.2097, 0.03334>, <0.0163, 0.2067, 0.03251> }
				triangle { <0.01764, 0.1942, 0.0308>, <0.0163, 0.2067, 0.03251>, <0.02109, 0.2097, 0.03334> }
				triangle { <0.02109, 0.2097, 0.03334>, <0.02421, 0.2247, 0.03986>, <0.02028, 0.2256, 0.03967> }
				triangle { <0.02109, 0.2097, 0.03334>, <0.02028, 0.2256, 0.03967>, <0.02421, 0.2247, 0.03986> }
				triangle { <0.02421, 0.2247, 0.03986>, <0.02732, 0.2397, 0.04638>, <0.02028, 0.2256, 0.03967> }
				triangle { <0.02421, 0.2247, 0.03986>, <0.02028, 0.2256, 0.03967>, <0.02732, 0.2397, 0.04638> }
				triangle { <0.02732, 0.2397, 0.04638>, <0.03077, 0.2553, 0.04893>, <0.02459, 0.2451, 0.04285> }
				triangle { <0.02732, 0.2397, 0.04638>, <0.02459, 0.2451, 0.04285>, <0.03077, 0.2553, 0.04893> }
				triangle { <0.03077, 0.2553, 0.04893>, <0.03302, 0.2663, 0.05481>, <0.02942, 0.2678, 0.05064> }
				triangle { <0.03077, 0.2553, 0.04893>, <0.02942, 0.2678, 0.05064>, <0.03302, 0.2663, 0.05481> }
				triangle { <0.03302, 0.2663, 0.05481>, <0.03614, 0.2813, 0.06134>, <0.03307, 0.2861, 0.06178> }
				triangle { <0.03302, 0.2663, 0.05481>, <0.03307, 0.2861, 0.06178>, <0.03614, 0.2813, 0.06134> }
				triangle { <0.03614, 0.2813, 0.06134>, <0.03925, 0.2963, 0.06786>, <0.03307, 0.2861, 0.06178> }
				triangle { <0.03614, 0.2813, 0.06134>, <0.03307, 0.2861, 0.06178>, <0.03925, 0.2963, 0.06786> }
				triangle { <0.03925, 0.2963, 0.06786>, <0.04237, 0.3113, 0.07438>, <0.03705, 0.305, 0.06893> }
				triangle { <0.03925, 0.2963, 0.06786>, <0.03705, 0.305, 0.06893>, <0.04237, 0.3113, 0.07438> }
				triangle { <0.04237, 0.3113, 0.07438>, <0.04941, 0.3254, 0.0811>, <0.04495, 0.323, 0.07629> }
				triangle { <0.04237, 0.3113, 0.07438>, <0.04495, 0.323, 0.07629>, <0.04941, 0.3254, 0.0811> }
				triangle { <0.04941, 0.3254, 0.0811>, <0.05166, 0.3365, 0.08698>, <0.0486, 0.3413, 0.08742> }
				triangle { <0.04941, 0.3254, 0.0811>, <0.0486, 0.3413, 0.08742>, <0.05166, 0.3365, 0.08698> }
				triangle { <0.05166, 0.3365, 0.08698>, <0.05478, 0.3514, 0.09351>, <0.05425, 0.3481, 0.08889> }
				triangle { <0.05166, 0.3365, 0.08698>, <0.05425, 0.3481, 0.08889>, <0.05478, 0.3514, 0.09351> }
				triangle { <0.05478, 0.3514, 0.09351>, <0.06096, 0.3616, 0.09959>, <0.0565, 0.3592, 0.09478> }
				triangle { <0.05478, 0.3514, 0.09351>, <0.0565, 0.3592, 0.09478>, <0.06096, 0.3616, 0.09959> }
				triangle { <0.06096, 0.3616, 0.09959>, <0.06407, 0.3766, 0.1061>, <0.06354, 0.3733, 0.1015> }
				triangle { <0.06096, 0.3616, 0.09959>, <0.06354, 0.3733, 0.1015>, <0.06407, 0.3766, 0.1061> }
				triangle { <0.06407, 0.3766, 0.1061>, <0.07026, 0.3868, 0.1121>, <0.07059, 0.3874, 0.1082> }
				triangle { <0.06407, 0.3766, 0.1061>, <0.07059, 0.3874, 0.1082>, <0.07026, 0.3868, 0.1121> }
				triangle { <0.07026, 0.3868, 0.1121>, <0.0773, 0.4009, 0.1189>, <0.0773, 0.4009, 0.1189> }
				triangle { <0.07026, 0.3868, 0.1121>, <0.0773, 0.4009, 0.1189>, <0.0773, 0.4009, 0.1189> }
				triangle { <0.0773, 0.4009, 0.1189>, <0.08348, 0.4111, 0.1249>, <0.0773, 0.4009, 0.1189> }
				triangle { <0.0773, 0.4009, 0.1189>, <0.0773, 0.4009, 0.1189>, <0.08348, 0.4111, 0.1249> }
				triangle { <0.0773, 0.4009, 0.1189>, <0.07059, 0.3874, 0.1082>, <0.07026, 0.3868, 0.1121> }
				triangle { <0.0773, 0.4009, 0.1189>, <0.07026, 0.3868, 0.1121>, <0.07059, 0.3874, 0.1082> }
				triangle { <0.07059, 0.3874, 0.1082>, <0.06354, 0.3733, 0.1015>, <0.06407, 0.3766, 0.1061> }
				triangle { <0.07059, 0.3874, 0.1082>, <0.06407, 0.3766, 0.1061>, <0.06354, 0.3733, 0.1015> }
				triangle { <0.06354, 0.3733, 0.1015>, <0.0565, 0.3592, 0.09478>, <0.06096, 0.3616, 0.09959> }
				triangle { <0.06354, 0.3733, 0.1015>, <0.06096, 0.3616, 0.09959>, <0.0565, 0.3592, 0.09478> }
				triangle { <0.0565, 0.3592, 0.09478>, <0.05425, 0.3481, 0.08889>, <0.05478, 0.3514, 0.09351> }
				triangle { <0.0565, 0.3592, 0.09478>, <0.05478, 0.3514, 0.09351>, <0.05425, 0.3481, 0.08889> }
				triangle { <0.001941, 0.1214, 0.01076>, <-0.0006429, 0.1098, 0.008858>, <0.00108, 0.1175, 0.01012> }
				triangle { <0.001941, 0.1214, 0.01076>, <0.00108, 0.1175, 0.01012>, <-0.0006429, 0.1098, 0.008858> }
				triangle { <-0.0006429, 0.1098, 0.008858>, <-0.004089, 0.09424, 0.006315>, <-0.002366, 0.102, 0.007586> }
				triangle { <-0.0006429, 0.1098, 0.008858>, <-0.002366, 0.102, 0.007586>, <-0.004089, 0.09424, 0.006315> }
				triangle { <0.05425, 0.3481, 0.08889>, <0.0486, 0.3413, 0.08742>, <0.05166, 0.3365, 0.08698> }
				triangle { <0.05425, 0.3481, 0.08889>, <0.05166, 0.3365, 0.08698>, <0.0486, 0.3413, 0.08742> }
				triangle { <0.0486, 0.3413, 0.08742>, <0.04495, 0.323, 0.07629>, <0.04941, 0.3254, 0.0811> }
				triangle { <0.0486, 0.3413, 0.08742>, <0.04941, 0.3254, 0.0811>, <0.04495, 0.323, 0.07629> }
				triangle { <0.04495, 0.323, 0.07629>, <0.03705, 0.305, 0.06893>, <0.04237, 0.3113, 0.07438> }
				triangle { <0.04495, 0.323, 0.07629>, <0.04237, 0.3113, 0.07438>, <0.03705, 0.305, 0.06893> }
				triangle { <0.03705, 0.305, 0.06893>, <0.03307, 0.2861, 0.06178>, <0.03925, 0.2963, 0.06786> }
				triangle { <0.03705, 0.305, 0.06893>, <0.03925, 0.2963, 0.06786>, <0.03307, 0.2861, 0.06178> }
				triangle { <0.03307, 0.2861, 0.06178>, <0.02942, 0.2678, 0.05064>, <0.03302, 0.2663, 0.05481> }
				triangle { <0.03307, 0.2861, 0.06178>, <0.03302, 0.2663, 0.05481>, <0.02942, 0.2678, 0.05064> }
				triangle { <0.02942, 0.2678, 0.05064>, <0.02459, 0.2451, 0.04285>, <0.03077, 0.2553, 0.04893> }
				triangle { <0.02942, 0.2678, 0.05064>, <0.03077, 0.2553, 0.04893>, <0.02459, 0.2451, 0.04285> }
				triangle { <0.02459, 0.2451, 0.04285>, <0.02028, 0.2256, 0.03967>, <0.02732, 0.2397, 0.04638> }
				triangle { <0.02459, 0.2451, 0.04285>, <0.02732, 0.2397, 0.04638>, <0.02028, 0.2256, 0.03967> }
				triangle { <0.02028, 0.2256, 0.03967>, <0.0163, 0.2067, 0.03251>, <0.02109, 0.2097, 0.03334> }
				triangle { <0.02028, 0.2256, 0.03967>, <0.02109, 0.2097, 0.03334>, <0.0163, 0.2067, 0.03251> }
				triangle { <0.0163, 0.2067, 0.03251>, <0.01232, 0.1879, 0.02535>, <0.01764, 0.1942, 0.0308> }
				triangle { <0.0163, 0.2067, 0.03251>, <0.01764, 0.1942, 0.0308>, <0.01232, 0.1879, 0.02535> }
				triangle { <0.01232, 0.1879, 0.02535>, <0.00716, 0.1645, 0.02154>, <0.0142, 0.1786, 0.02825> }
				triangle { <0.01232, 0.1879, 0.02535>, <0.0142, 0.1786, 0.02825>, <0.00716, 0.1645, 0.02154> }
				triangle { <0.00716, 0.1645, 0.02154>, <0.00711, 0.1448, 0.01457>, <0.007641, 0.1481, 0.01919> }
				triangle { <0.00716, 0.1645, 0.02154>, <0.007641, 0.1481, 0.01919>, <0.00711, 0.1448, 0.01457> }
				triangle { <0.00711, 0.1448, 0.01457>, <0.001941, 0.1214, 0.01076>, <0.004195, 0.1325, 0.01665> }
				triangle { <0.00711, 0.1448, 0.01457>, <0.004195, 0.1325, 0.01665>, <0.001941, 0.1214, 0.01076> }
				texture {T_ClumpLeaf2}}
			union { // Petiole
				cylinder { <-0.006901, 0.08197, 0.005003>, <-0.006981, 0.08218, 0.004814>, 0.0000212 }
				cylinder { <-0.006981, 0.08218, 0.004814>, <-0.007062, 0.0824, 0.004624>, 0.0000212 }
				cylinder { <-0.007062, 0.0824, 0.004624>, <-0.007142, 0.08262, 0.004435>, 0.0000212 }
				texture {T_ClumpLeaf}}
			mesh { // Leaf 3D object
				triangle { <-0.007142, 0.08262, 0.004435>, <-0.01021, 0.09388, 0.007617>, <-0.01021, 0.09388, 0.007617> }
				triangle { <-0.007142, 0.08262, 0.004435>, <-0.01021, 0.09388, 0.007617>, <-0.01021, 0.09388, 0.007617> }
				triangle { <-0.01021, 0.09388, 0.007617>, <-0.01225, 0.1014, 0.009738>, <-0.01021, 0.09388, 0.007617> }
				triangle { <-0.01021, 0.09388, 0.007617>, <-0.01021, 0.09388, 0.007617>, <-0.01225, 0.1014, 0.009738> }
				triangle { <-0.01225, 0.1014, 0.009738>, <-0.01634, 0.1164, 0.01398>, <-0.0143, 0.1089, 0.01185> }
				triangle { <-0.01225, 0.1014, 0.009738>, <-0.0143, 0.1089, 0.01185>, <-0.01634, 0.1164, 0.01398> }
				triangle { <-0.01634, 0.1164, 0.01398>, <-0.01832, 0.131, 0.02163>, <-0.01737, 0.1201, 0.01504> }
				triangle { <-0.01634, 0.1164, 0.01398>, <-0.01737, 0.1201, 0.01504>, <-0.01832, 0.131, 0.02163> }
				triangle { <-0.01832, 0.131, 0.02163>, <-0.02241, 0.146, 0.02587>, <-0.02351, 0.1427, 0.0214> }
				triangle { <-0.01832, 0.131, 0.02163>, <-0.02351, 0.1427, 0.0214>, <-0.02241, 0.146, 0.02587> }
				triangle { <-0.02241, 0.146, 0.02587>, <-0.0265, 0.1611, 0.03011>, <-0.02978, 0.1596, 0.03199> }
				triangle { <-0.02241, 0.146, 0.02587>, <-0.02978, 0.1596, 0.03199>, <-0.0265, 0.1611, 0.03011> }
				triangle { <-0.0265, 0.1611, 0.03011>, <-0.02848, 0.1757, 0.03777>, <-0.02978, 0.1596, 0.03199> }
				triangle { <-0.0265, 0.1611, 0.03011>, <-0.02978, 0.1596, 0.03199>, <-0.02848, 0.1757, 0.03777> }
				triangle { <-0.02848, 0.1757, 0.03777>, <-0.03257, 0.1907, 0.04201>, <-0.03592, 0.1822, 0.03835> }
				triangle { <-0.02848, 0.1757, 0.03777>, <-0.03592, 0.1822, 0.03835>, <-0.03257, 0.1907, 0.04201> }
				triangle { <-0.03257, 0.1907, 0.04201>, <-0.03666, 0.2057, 0.04625>, <-0.03891, 0.2006, 0.04707> }
				triangle { <-0.03257, 0.1907, 0.04201>, <-0.03891, 0.2006, 0.04707>, <-0.03666, 0.2057, 0.04625> }
				triangle { <-0.03666, 0.2057, 0.04625>, <-0.03863, 0.2204, 0.05391>, <-0.04191, 0.219, 0.05578> }
				triangle { <-0.03666, 0.2057, 0.04625>, <-0.04191, 0.219, 0.05578>, <-0.03863, 0.2204, 0.05391> }
				triangle { <-0.03863, 0.2204, 0.05391>, <-0.04061, 0.235, 0.06156>, <-0.04191, 0.219, 0.05578> }
				triangle { <-0.03863, 0.2204, 0.05391>, <-0.04191, 0.219, 0.05578>, <-0.04061, 0.235, 0.06156> }
				triangle { <-0.04061, 0.235, 0.06156>, <-0.0447, 0.25, 0.0658>, <-0.04703, 0.2377, 0.06108> }
				triangle { <-0.04061, 0.235, 0.06156>, <-0.04703, 0.2377, 0.06108>, <-0.0447, 0.25, 0.0658> }
				triangle { <-0.0447, 0.25, 0.0658>, <-0.04565, 0.2609, 0.0724>, <-0.05104, 0.2599, 0.07086> }
				triangle { <-0.0447, 0.25, 0.0658>, <-0.05104, 0.2599, 0.07086>, <-0.04565, 0.2609, 0.0724> }
				triangle { <-0.04565, 0.2609, 0.0724>, <-0.04762, 0.2756, 0.08005>, <-0.05192, 0.2779, 0.08298> }
				triangle { <-0.04565, 0.2609, 0.0724>, <-0.05192, 0.2779, 0.08298>, <-0.04762, 0.2756, 0.08005> }
				triangle { <-0.04762, 0.2756, 0.08005>, <-0.0496, 0.2902, 0.0877>, <-0.05192, 0.2779, 0.08298> }
				triangle { <-0.04762, 0.2756, 0.08005>, <-0.05192, 0.2779, 0.08298>, <-0.0496, 0.2902, 0.0877> }
				triangle { <-0.0496, 0.2902, 0.0877>, <-0.05157, 0.3048, 0.09536>, <-0.05492, 0.2963, 0.0917> }
				triangle { <-0.0496, 0.2902, 0.0877>, <-0.05492, 0.2963, 0.0917>, <-0.05157, 0.3048, 0.09536> }
				triangle { <-0.05157, 0.3048, 0.09536>, <-0.05026, 0.3209, 0.1011>, <-0.05464, 0.3161, 0.09854> }
				triangle { <-0.05157, 0.3048, 0.09536>, <-0.05464, 0.3161, 0.09854>, <-0.05026, 0.3209, 0.1011> }
				triangle { <-0.05026, 0.3209, 0.1011>, <-0.05122, 0.3318, 0.1077>, <-0.05552, 0.3341, 0.1106> }
				triangle { <-0.05026, 0.3209, 0.1011>, <-0.05552, 0.3341, 0.1106>, <-0.05122, 0.3318, 0.1077> }
				triangle { <-0.05122, 0.3318, 0.1077>, <-0.05319, 0.3464, 0.1153>, <-0.05428, 0.343, 0.1109> }
				triangle { <-0.05122, 0.3318, 0.1077>, <-0.05428, 0.343, 0.1109>, <-0.05319, 0.3464, 0.1153> }
				triangle { <-0.05319, 0.3464, 0.1153>, <-0.05086, 0.3587, 0.1201>, <-0.05523, 0.3539, 0.1175> }
				triangle { <-0.05319, 0.3464, 0.1153>, <-0.05523, 0.3539, 0.1175>, <-0.05086, 0.3587, 0.1201> }
				triangle { <-0.05086, 0.3587, 0.1201>, <-0.05284, 0.3733, 0.1277>, <-0.05393, 0.37, 0.1232> }
				triangle { <-0.05086, 0.3587, 0.1201>, <-0.05393, 0.37, 0.1232>, <-0.05284, 0.3733, 0.1277> }
				triangle { <-0.05284, 0.3733, 0.1277>, <-0.05051, 0.3856, 0.1324>, <-0.05263, 0.386, 0.129> }
				triangle { <-0.05284, 0.3733, 0.1277>, <-0.05263, 0.386, 0.129>, <-0.05051, 0.3856, 0.1324> }
				triangle { <-0.05051, 0.3856, 0.1324>, <-0.0492, 0.4017, 0.1382>, <-0.0492, 0.4017, 0.1382> }
				triangle { <-0.05051, 0.3856, 0.1324>, <-0.0492, 0.4017, 0.1382>, <-0.0492, 0.4017, 0.1382> }
				triangle { <-0.0492, 0.4017, 0.1382>, <-0.04688, 0.414, 0.1429>, <-0.0492, 0.4017, 0.1382> }
				triangle { <-0.0492, 0.4017, 0.1382>, <-0.0492, 0.4017, 0.1382>, <-0.04688, 0.414, 0.1429> }
				triangle { <-0.0492, 0.4017, 0.1382>, <-0.05263, 0.386, 0.129>, <-0.05051, 0.3856, 0.1324> }
				triangle { <-0.0492, 0.4017, 0.1382>, <-0.05051, 0.3856, 0.1324>, <-0.05263, 0.386, 0.129> }
				triangle { <-0.05263, 0.386, 0.129>, <-0.05393, 0.37, 0.1232>, <-0.05284, 0.3733, 0.1277> }
				triangle { <-0.05263, 0.386, 0.129>, <-0.05284, 0.3733, 0.1277>, <-0.05393, 0.37, 0.1232> }
				triangle { <-0.05393, 0.37, 0.1232>, <-0.05523, 0.3539, 0.1175>, <-0.05086, 0.3587, 0.1201> }
				triangle { <-0.05393, 0.37, 0.1232>, <-0.05086, 0.3587, 0.1201>, <-0.05523, 0.3539, 0.1175> }
				triangle { <-0.05523, 0.3539, 0.1175>, <-0.05428, 0.343, 0.1109>, <-0.05319, 0.3464, 0.1153> }
				triangle { <-0.05523, 0.3539, 0.1175>, <-0.05319, 0.3464, 0.1153>, <-0.05428, 0.343, 0.1109> }
				triangle { <-0.01737, 0.1201, 0.01504>, <-0.0143, 0.1089, 0.01185>, <-0.01634, 0.1164, 0.01398> }
				triangle { <-0.01737, 0.1201, 0.01504>, <-0.01634, 0.1164, 0.01398>, <-0.0143, 0.1089, 0.01185> }
				triangle { <-0.0143, 0.1089, 0.01185>, <-0.01021, 0.09388, 0.007617>, <-0.01225, 0.1014, 0.009738> }
				triangle { <-0.0143, 0.1089, 0.01185>, <-0.01225, 0.1014, 0.009738>, <-0.01021, 0.09388, 0.007617> }
				triangle { <-0.05428, 0.343, 0.1109>, <-0.05552, 0.3341, 0.1106>, <-0.05122, 0.3318, 0.1077> }
				triangle { <-0.05428, 0.343, 0.1109>, <-0.05122, 0.3318, 0.1077>, <-0.05552, 0.3341, 0.1106> }
				triangle { <-0.05552, 0.3341, 0.1106>, <-0.05464, 0.3161, 0.09854>, <-0.05026, 0.3209, 0.1011> }
				triangle { <-0.05552, 0.3341, 0.1106>, <-0.05026, 0.3209, 0.1011>, <-0.05464, 0.3161, 0.09854> }
				triangle { <-0.05464, 0.3161, 0.09854>, <-0.05492, 0.2963, 0.0917>, <-0.05157, 0.3048, 0.09536> }
				triangle { <-0.05464, 0.3161, 0.09854>, <-0.05157, 0.3048, 0.09536>, <-0.05492, 0.2963, 0.0917> }
				triangle { <-0.05492, 0.2963, 0.0917>, <-0.05192, 0.2779, 0.08298>, <-0.0496, 0.2902, 0.0877> }
				triangle { <-0.05492, 0.2963, 0.0917>, <-0.0496, 0.2902, 0.0877>, <-0.05192, 0.2779, 0.08298> }
				triangle { <-0.05192, 0.2779, 0.08298>, <-0.05104, 0.2599, 0.07086>, <-0.04565, 0.2609, 0.0724> }
				triangle { <-0.05192, 0.2779, 0.08298>, <-0.04565, 0.2609, 0.0724>, <-0.05104, 0.2599, 0.07086> }
				triangle { <-0.05104, 0.2599, 0.07086>, <-0.04703, 0.2377, 0.06108>, <-0.0447, 0.25, 0.0658> }
				triangle { <-0.05104, 0.2599, 0.07086>, <-0.0447, 0.25, 0.0658>, <-0.04703, 0.2377, 0.06108> }
				triangle { <-0.04703, 0.2377, 0.06108>, <-0.04191, 0.219, 0.05578>, <-0.04061, 0.235, 0.06156> }
				triangle { <-0.04703, 0.2377, 0.06108>, <-0.04061, 0.235, 0.06156>, <-0.04191, 0.219, 0.05578> }
				triangle { <-0.04191, 0.219, 0.05578>, <-0.03891, 0.2006, 0.04707>, <-0.03666, 0.2057, 0.04625> }
				triangle { <-0.04191, 0.219, 0.05578>, <-0.03666, 0.2057, 0.04625>, <-0.03891, 0.2006, 0.04707> }
				triangle { <-0.03891, 0.2006, 0.04707>, <-0.03592, 0.1822, 0.03835>, <-0.03257, 0.1907, 0.04201> }
				triangle { <-0.03891, 0.2006, 0.04707>, <-0.03257, 0.1907, 0.04201>, <-0.03592, 0.1822, 0.03835> }
				triangle { <-0.03592, 0.1822, 0.03835>, <-0.02978, 0.1596, 0.03199>, <-0.02848, 0.1757, 0.03777> }
				triangle { <-0.03592, 0.1822, 0.03835>, <-0.02848, 0.1757, 0.03777>, <-0.02978, 0.1596, 0.03199> }
				triangle { <-0.02978, 0.1596, 0.03199>, <-0.02351, 0.1427, 0.0214>, <-0.02241, 0.146, 0.02587> }
				triangle { <-0.02978, 0.1596, 0.03199>, <-0.02241, 0.146, 0.02587>, <-0.02351, 0.1427, 0.0214> }
				triangle { <-0.02351, 0.1427, 0.0214>, <-0.01737, 0.1201, 0.01504>, <-0.01832, 0.131, 0.02163> }
				triangle { <-0.02351, 0.1427, 0.0214>, <-0.01832, 0.131, 0.02163>, <-0.01737, 0.1201, 0.01504> }
				texture {T_ClumpLeaf2}}
			}
		}
} // end Nigels_grassy_clump
