// Persistence of Vision Ray Tracer Scene Description File
// File: Goodbye.pov
// Vers: 3.5
// Desc: Sometimes goodbye is forever
// Date: 6 July 2002
// Auth: Gail Shaw (aka GilaMonster)

// cmd:+H640 +W1024

#declare isoGround=1;
#declare showPlants=1;
#declare showGrass=1;
#declare showTrees=1;
#declare showWall=1;
#declare showWater=1;
#declare showStone=1;
#declare showAtmosphere=1;
#declare showRain=1;
#declare wetSurface=1;
#declare useBlur=1;
#declare useAreaLight=1;

#include "textures.inc"

#include "colors.inc"
#include "functions.inc"
#if (showStone=1)
 #include "metals.inc"
 #include "stones1.inc"
 #include "rose05VI.inc"
#end
#if (showWall=1)
 #include "stones.inc"
 #include "mur.inc"
#end
#if (showPlants=1)
 #include "plantTex.inc"
 #include "Clump.inc"
 #include "Bluebell.inc"
 #include "LillyOfValley.inc"
 #include "Lilac.inc"
 #include "SmallFlower.inc"
 #include "Daylily.inc"
 #include "Thistle.inc"
#end
#if (showGrass=1)
 #include "grass\mgrassMod.pov"
#end
#if (showTrees=1)
 #include "tree\maketree.pov"
 #include "tree\txttree.inc"
 #include "treesettings.inc"
#end

#if (wetSurface=1)
 #default {finish {ambient 0 specular 0.8 roughness 0.01 /*reflection {0.3,0.6}*/}}
#else
 #default {finish {ambient 0}}
#end

global_settings {
 max_trace_level 45
}

#declare SceneCamera=
 camera {
  location <4,1.25,-4.5>
  look_at <-0.75,0.5,0>
  right x*image_width/image_height
  #if (useBlur=1)
   aperture 0.115          
   blur_samples 250
   focal_point <0,0.25,-0.5>    
   confidence 0.99        
   variance 1/1024        
  #end
  angle 23  //20
 }

#declare StoneCamera=
 camera {
  location <1.5,1,-2>
  look_at <-0.1,0.2,0>
  angle 18
 }
 
camera {SceneCamera}

light_source {
 <800,3000,-1000>
 White*0.5
 #if (useAreaLight=1)
  area_light <10,0,0>,<0,0,10>,3,3
  adaptive 1
  jitter
  circular
  orient
 #end
}

light_source {
 <800,3000,-1000>
 White*0.6
 shadowless
}

light_source {
 <4,1.25,-4.5>
 White*0.3
 /*#if (useAreaLight=1)
  area_light <15,0,0>,<0,0,15>,4,4
  adaptive 1
  jitter
  circular
  orient
 #end*/
}

// textures

#declare T_Water =
 texture {
  pigment {rgbf <0.95,0.95,0.975,0.98>}
  finish {
   specular 0.9
   roughness 0.002
   reflection {0.2,1.0 fresnel on}
  }
  normal { bumps 0.5 scale 0.01}
 }
 
#declare T_Water2 =
 texture {
  pigment{rgbt<0.8,0.8,.9,0.75>} 
  finish {ambient 0.2 specular 1 roughness 0.001}
 }
 /*texture {
	pigment { color rgbf <0.8,0.8,0.9,0.9> }
	normal { bumps .5 scale <.4,.4,.7> }
	finish { ambient 0.3 specular .9 roughness .002 reflection .08 } // added specular
 }*/

#declare F_Noise=function {f_noise3d(x*2,y*2,z*2)}

#macro m_strata(freq,amnt)  // by Samuel T Benge 
 function{noise3d(y*freq+noise3d(y+noise3d(x*4,y*4,z*4),z,x)*amnt,0,0)}
#end

#declare T_Dirt=
 texture {
  pigment {
   function {f_noise3d(x*2/1.5,0,z*2/1.5)} 
   turbulence 0.05
   pigment_map {
    [0.3  bozo   
          scale 0.25
          color_map {
           [0.0 rgb <0.419,0.242,0.168>]
           [1.0 rgb <0.46,0.281,0.218>]
          }
    ]
    [1.0  bozo  
          turbulence 0.4
          scale 0.5
          color_map {
           [0.0 rgb <0.489,0.315,0.247>]
           [1.0 rgb <0.5598,0.408,0.30>]
          }
    ]           
   }
  }
  finish {diffuse 0.7}
  normal {
   bozo    
   scale 0.25
   turbulence 0.5
   normal_map {
    [0.0 bumps 0.35 scale 0.075]
    [0.5 bumps 0.4 scale 0.05]
    [1.0 bumps 0.5 scale 0.1]
   } 
  }
 }
 texture {
  pigment {
   bozo     
   scale 0.005
   color_map {
    [0.0 rgbt 1]
    [1.0 rgbt <0.7,0.5,0.4,0.5>]
   }
  }
 }

#declare T_Stone =
 texture {
  pigment {
   granite
   color_map {
     [0.000 rgbft CRGBGrey(rgb <0.973, 0.973, 0.976>)*0.75]
     [0.241 rgbft CRGBGrey(rgb <0.973, 0.973, 0.976>)*0.75]
     [0.241 rgbft CRGBGrey(rgb <0.973, 0.973, 0.976>)*0.75]
     [0.284 rgbft CRGBGrey(rgb <0.600, 0.741, 0.608>)*0.75]
     [0.284 rgbft CRGBGrey(rgb <0.600, 0.741, 0.608>)*0.75]
     [0.336 rgbft CRGBGrey(rgb <0.820, 0.643, 0.537>)*0.75]
     [0.336 rgbft CRGBGrey(rgb <0.820, 0.643, 0.537>)*0.75]
     [0.474 rgbft CRGBGrey(rgb <0.886, 0.780, 0.714>)*0.75]
     [0.474 rgbft CRGBGrey(rgb <0.886, 0.780, 0.714>)*0.75]
     [0.810 rgbft CRGBGrey(rgb <0.996, 0.643, 0.537>)*0.75]
     [0.810 rgbft CRGBGrey(rgb <0.996, 0.643, 0.537>)*0.75]
     [0.836 rgbft CRGBGrey(rgb <0.973, 0.973, 0.976>)*0.75]
     [0.836 rgbft CRGBGrey(rgb <0.973, 0.973, 0.976>)*0.75]
     [1.001 rgbft CRGBGrey(rgb <0.973, 0.973, 0.976>)*0.75]
    }
  }
  finish {crand 0.02}
  scale <1, 0.7, 0.5>*0.1 rotate <0, 0, 40>
 }
 texture{
  pigment {
   granite
   turbulence 0.0
   color_map {
    [0.0, 0.2 color White transmit 0.0 color White transmit 0.7]
    [0.2, 0.3 color White transmit 0.7 color Clear]
    [0.3, 1.0 color Clear color Clear]
   }
  }
  normal {
   granite 0.1
   turbulence 0.0
  }
  finish {crand 0.02}
  scale <2, 3, 1>*0.1
  rotate <10, 0, -20>
 }

#declare T_Rain =
  texture {
   pigment {
    spotted
    color_map {
     [ 0.0     rgbf <1.0, 1.0, 1.0, 1.0> ]
     [ 0.925     rgbf <1.0, 1.0, 1.0, 1.0> ]
     [ 1.0     rgbf <0.8, 0.8, 0.8, 0.4> ]
    }
    frequency 2
    scale  <0.001, 0.001, 0.1>*4
    rotate    <90.0, 0.0, -5.0>
   }
   finish {ambient 0.25 specular 0}
  }


#if (showStone=1)

// gravestone //T_Stone19, T_Grnt15 scale 0.1
 #declare GraveStone = 
  union {
   difference {
    union {
     box {
      <-0.29,0,-0.2>,<0.29,0.5,0.2>
     }
     box {
      <-0.3,0,-0.19>,<0.3,0.5,0.19>
     }
     cylinder {
      <-0.29,0,-0.19>,<-0.29,0.5,-0.19>,0.01
     }
     cylinder {
      <0.29,0,-0.19>,<0.29,0.5,-0.19>,0.01
     }
     cylinder {
      <-0.29,0,0.19>,<-0.29,0.5,0.19>,0.01
     }
     cylinder {
      <0.29,0,0.19>,<0.29,0.5,0.19>,0.01
     }
    }
    difference {
     box {
      <-0.35,0,-0.3>,<0.35,0.4,0.3>
     }
     box {
      <-0.29,-0.1,-0.2003>,<0.29,0.01,0.2003>
     }
     cylinder {
      <-0.29,0,-0.2003>,<-0.29,0,0.2003>,0.01
     }
     cylinder {
      <0.29,0,-0.2003>,<0.29,0,0.2003>,0.01
     }
     cylinder {
      <-0.29,0,-0.2003>,<0.29,0,-0.2003>,0.01
     }
     cylinder {
      <-0.29,0,0.2003>,<0.29,0,0.2003>,0.01
     }
     sphere {
      <-0.29,0,-0.2003>,0.01
     }
     sphere {
      <0.29,0,-0.2003>,0.01
     }
     sphere {
      <-0.29,0,0.2003>,0.01
     }
     sphere {
      <0.29,0,0.2003>,0.01
     }
     rotate x*-18
     translate y*0.235
    }
    difference {
     box {
      <-0.25,0,-0.15>,<0.25,0.1,0.15>
     }
     cylinder {
      <-0.25,0,-0.15>,<0.25,0,-0.15>,0.005
     }
     cylinder {
      <-0.25,0,0.15>,<0.25,0,0.15>,0.005
     }
     cylinder {
      <-0.25,0,-0.15>,<-0.25,0,0.15>,0.005
     }
     cylinder {
      <0.25,0,-0.15>,<0.25,0,0.15>,0.005
     }
     sphere {
      <-0.25,0,-0.15>,0.005
     }
     sphere {
      <0.25,0,-0.15>,0.005
     }
     sphere {
      <-0.25,0,0.15>,0.005
     }
     sphere {
      <0.25,0,0.15>,0.005
     }
     rotate x*-18
     translate y*0.245
    }
    texture {T_Stone}
   }
   box {
    <-0.25,-0.01,-0.15>,<0.25,0.01,0.15>
    rotate x*-18
    translate y*0.24
    texture {T_Grnt15 scale 0.1}
   }
   union {
    text {
     ttf "chancery.ttf" "Captain Susan de Marko",0.1,0
     translate <-5,2,-0.27>
    }
    text {
     ttf "chancery.ttf" "United Earth Defence",0.1,0
     translate <-4.5,0.8,-0.27>
    }
    text {
     ttf "chancery.ttf" "2163-2198",0.1,0
     translate <-2,-0.4,-0.27>
    }
    text {
     ttf "chancery.ttf" "The love that makes undaunted",0.1,0
     scale 0.875
     translate <-5.4,-1.6,-0.27>
    }
    text {
     ttf "chancery.ttf" "the final sacrifice",0.1,0
     scale 0.875
     translate <-3,-2.8,-0.27>
    }
    scale 0.045
    rotate x*(90-18)
    translate y*0.24
    //pigment {Red}
    texture {T_Silver_3C}
   }
  }  
#end
 
// ground
#if (isoGround=1)
 #declare objGround = 
  isosurface {
   function {y-f_noise3d(x,y,z)*0.175-f_noise3d(x*2.5-1.2578,y,z*2.5-9.35)*0.075-f_noise3d(x*5+5.2635,y,z*5-2.5648)*0.05 + 0.07}
   contained_by {box {<-10,-1.5,-10>,<10,1,15>}}
   max_gradient 1.2
   //pigment {DarkBrown}
   texture {T_Dirt scale 5}
   translate z*0.2
   translate <4,0,3>
  } 

 #if (showWater=1)
  box {
   <-10,-1.5,-10>,<10,0.08,15>
   material {
    texture {T_Water}
    interior {ior 1.33}
   }
  }
 #end
 
#else
 #declare objGround=
  plane {
   y,0.1
   texture {T_Dirt scale 5}
  }
#end

object {objGround translate <-4,0,-3>}

#if (showStone=1)
 object {GraveStone}
 object{rose05VI scale 0.05 rotate y*-17  translate <-0.29,0.09,-0.5>}
#end

// plants
#if (showPlants=1)
 // plants around gravestone
 object {GrassyClump scale 0.22 translate <0.38,0,-0.04>}
 object {GrassyClump scale 0.2 rotate y*175 translate <0.39,0,-0.04>}
 object {GrassyClump scale 0.25 rotate y*115 translate <0.4,0,-0.05>}
 object {GrassyClump scale 0.2 rotate y*20 translate <0.39,0,-0.1>}
 object {GrassyClump scale 0.2 rotate y*275 translate <-0.34,0,0.04>}
 object {GrassyClump scale 0.25 rotate y*15 translate <-0.39,0,0.05>}
 object {GrassyClump scale 0.2 rotate y*90 translate <-0.39,0,0.12>}
 object {GrassyClump scale 0.28 rotate y*-68 translate <-0.2,0,0.35>}
 object {GrassyClump scale 0.26 rotate y*-28 translate <-0.22,0,0.32>}
 object {GrassyClump scale 0.28 rotate y*-168 translate <0.15,0,0.35>}
 object {GrassyClump scale 0.26 rotate y*-128 translate <0.19,0,0.3>}
 // plants scattered in the grass
 #declare rnd=seed(838);
 #declare i=0;
 #while (i<2500)
  #declare vStart=<rand(rnd)*12,5,rand(rnd)*12>;
  #declare vNorm=<0,0,0>;
  #declare vLoc = trace(objGround,vStart,-y,vNorm);
  object {SmallFlower scale 0.0009 rotate y*rand(rnd)*360 translate (vLoc+<-4,0.0175,-3>)}
  #declare i=i+1;
 #end
 #declare i=0;
 #while (i<50)
  #declare vStart=<2+rand(rnd)*5,5,-1+rand(rnd)*5>;
  #declare vNorm=<0,0,0>;
  #declare vLoc = trace(objGround,vStart,-y,vNorm);
  object {Thistle scale 18 rotate y*rand(rnd)*360 translate (vLoc+<-4,0.02,-3>)}
  #declare i=i+1;
 #end
 // plants at edge of forest
 object {BlueBell scale 26*0.75 rotate y*95 translate <-3.2,0.1,4.7>}
 object {BlueBell scale 26*0.75 rotate y*5 translate <-3.8,0.1,3.7>}
 object {BlueBell scale 24.5*0.75 rotate y*175 translate <-4,0.1,5>}
 object {BlueBell scale 24.8*0.75 rotate y*275 translate <-4.35,0.1,5.1>}
 object {BlueBell scale 24*0.75 rotate y*75 translate <-4.7,0.1,4.9>}
 object {BlueBell scale 25*0.75 translate <-4.5,0.1,2.2>}
 object {BlueBell scale 24.6*0.75 rotate y*50 translate <-4.8,0.1,2>}
 object {BlueBell scale 22*0.75 rotate y*70 translate <-4.85,0.1,2.4>}
 object {LillyOfValley scale 17 translate <-4.6,0.1,2.8>}
 object {LillyOfValley scale 16.5 rotate y*50 translate <-4.5,0.05,1.3>}
 object {LillyOfValley scale 16.5 rotate y*30 translate <-4.1,0.1,4.4>}
 object {LillyOfValley scale 16.5 rotate y*230 translate <-4.2,0.1,4.2>}
 object {LillyOfValley scale 16.5 rotate y*160 translate <-4.15,0.1,5.2>}
 object {Lilac scale 22 translate <-5,0.1,4.6>}
 object {Lilac scale 22 rotate y*75 translate <-5.3,0.1,5.8>}
 object {Lilac scale 22 rotate y*75 translate <-4.3,0.1,5.7>}
 object {Lilac scale 22 rotate y*125 translate <-5.6,0.1,2.2>}
 object {DayLily scale 20 translate <-5.2,0.1,1.65>}
 object {DayLily scale 21 rotate y*45 translate <-4.7,0.1,3.5>}
 object {DayLily scale 20.75 rotate y*85 translate <-4.2,0.1,4.8>}
#end


// grass
#if (showGrass=1)
 #declare PdV=<0,55,-80>;
 #declare PdA=<0,12,10>; 
 #declare Blanc1=rgb<0.95,0.85,0.85>;
 #declare Green1=rgb<0.3,0.8,0.2>*0.6;
 #declare Green2=rgb<0.23,0.52,0.1>*1.2;
 // --------------------------------------
 // Grass texture
 // --------------------------------------
 #declare pigSpotted =pigment {
 spotted
     color_map {
         [0.0, 0.2   color Tan*0.1 color Tan*0.4]
         [0.2, 0.3   color Tan*0.4 color Green1]
         [0.3, 1.01   color Green1 color Green1*1.2]
     }
 }

 #declare pigEarth =pigment {
     spotted
     color_map {
         [0 color Tan*0.3]
         [0.6 color Tan*0.3]
         [0.6 color Green1*0.4]
         [1   color Green1*0.4]
     }
 }
 #declare pigGreen=pigment{Green2}
 #declare txtGrass=
  texture {
   pigment {
    gradient y
    turbulence 0.2
    pigment_map {                                
        [0.0 pigEarth]
        [0.3 pigGreen]
        [0.9 pigSpotted]
        [1.00 pigEarth]
    }
   }
   //finish{ambient 0.01 diffuse 0.7 specular 0.9 roughness 0.0015}
   normal {bumps 0.005 scale 0.5}
   scale <0.001,1,0.001>
 } 
 // --------------------------------------
 // Patch parameters
 // --------------------------------------
 // Final number of triangles = nBlade x nBlade x segBlade x 2 (or 4 if dofold = true)
 // --------------------------------------
 #declare lPatch=0.2;               // size of patch
 #declare nBlade=25;                // number of blades per line (there will be nBlade x nBlade blades)
 //#declare nBlade=4;                // number of blades per line (there will be nBlade x nBlade blades)
 #declare ryBlade = 0;            // initial y rotation of blade
 #declare segBlade= 10;            // number of blade segments
 #declare lBlade = 0.02;             // length of blade
 #declare wBlade = 0.0045;            // width of blade at start
 #declare wBladeEnd = 0.0015;         // width of blade at the end
 #declare doSmooth=false;          // true makes smooth triangles
 #declare startBend = <0,1,0.4>;   // bending of blade at start (<0,1,0>=no bending)
 #declare vBend = <0,1,0>;         // force bending the blade (<0,1,1> = 45)
 #declare pwBend = 4;              // bending power (how slowly the curve bends)
 #declare rd = 459;                // seed
 #declare stdposBlade = 0.3;         // standard deviation of blade position 0..1
 #declare stdrotBlade = 360;       // standard deviation of rotation
 #declare stdBlade = 1;           // standard deviation of blade scale
 #declare stdBend = 3;            // standard deviation of blade bending
 #declare dofold = false;          // true creates a central fold in the blade (twice more triangles)
 #declare dofile = false;          // true creates a mesh file
 #declare fname = "fgrass2.inc"     // name of the mesh file to create

 // --------------------------------------
 // Prairie parameters
 // --------------------------------------
 #declare nxPrairie=60;            // number of patches for the first line
 #declare addPatches=0;            // number of patches to add at each line
 #declare nzPrairie=60;             // number of lines of patches
 #declare rd=seed(779);            // random seed
 #declare stdscale=1;              // stddev of scale
 #declare stdrotate=1;             // stddev of rotation
 #declare doTest=false;            // replaces the patch with a sphere

 // --------------------------------------
 // Create the patch and the prairie
 // --------------------------------------
 #if (dofile=true) // if the patch is already created, turn off the next line
         MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
         #declare objectPatch=#include fname
 #else        
         #declare objectPatch=object{MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)}
 #end        

 object{
  MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest,objGround)
  texture{txtGrass scale 0.4}
  translate <-4,0,-3>
 }
#end

#if (showTrees=1)

 #declare txtLeaf_5=
  texture {
   pigment {
    agate 
    color_map {
     [0.0 color colLeaf_1]
     [0.3 color colLeaf_2] 
     [0.7 color colLeaf_2]
     [1.0 color colLeaf_1] 
    }
   }
   normal {
    bumps 0.1 scale 0.01
   }
   scale 10
  }                 

 #declare Leaf=
  object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)
 } 
//#declare level0=3;      // recursion level
//#declare leafproba=0;   // probability of leaf 0=no leaf ; 1=leaf on each segment

#declare rsd=210;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves
 
 object{
  MakeTree()
  texture {txtLeaf}
  scale 0.08 
  translate <-5.5,0,3.5>
 }

#declare rsd=217;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves
 
 /*object{
  MakeTree()
  texture {txtLeaf}
  scale 0.08 
  translate <-4,0,6.5>
 }*/

#declare rsd=219;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves
 
 object{
  MakeTree()
  texture {txtLeaf}
  scale 0.08 
  translate <-5,0,5.2>
 }

#declare rsd=229;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves
 
 object{
  MakeTree()
  texture {txtLeaf}
  scale 0.08 
  translate <-5,0,1>
 }
 
 box {
  0,1
  hollow
  texture {
   pigment {
    image_map {png "cherry.png" interpolate 2}
   }
   finish {specular 0 reflection 0}
  }
  translate <-0.5,0,-0.5>
  scale <4,3,0.001>
  rotate y*-45
  translate <-7,0,3>
 }
 
 box {
  0,1
  hollow
  /*texture {
   pigment {Green}
  }*/
  texture {
   pigment {
    image_map {png "cherry.png" interpolate 2}
   }
   finish {specular 0 reflection 0}
  }
  translate <-0.5,0,-0.5>
  scale <4,3,0.001>
  rotate y*-35
  translate <-6.75,0,5.5>
 }
 
 /*box {
  0,1
  hollow
  texture {
   pigment {
    image_map {png "cherry.png" interpolate 2}
   }
   finish {specular 0 reflection 0}
  }
  translate <-0.5,0,-0.5>
  scale <-4,3,0.001>
  rotate y*-25
  translate <-3.5,0,7>
 }*/

 box {
  0,1
  hollow
  texture {
   pigment {
    image_map {png "plum.png" interpolate 2}
   }
   finish {specular 0 reflection 0}
  }
  translate <-0.5,0,-0.5>
  scale <4,3,0.001>*0.9
  rotate y*-35
  translate <-5.25,0,6>
 }


 box {
  0,1
  hollow
  /*texture {
   pigment {Blue}
  }*/
  texture {
   pigment {
    image_map {png "cherry.png" interpolate 2}
   }
   finish {specular 0 reflection 0}
  }
  translate <-0.5,0,-0.5>
  scale <4,3,0.001>
  rotate y*-30
  translate <-4.75,0,6.5>
 }

 box {
  0,1
  hollow
  texture {
   pigment {
    image_map {png "fern.png" interpolate 2}
   }
   finish {specular 0 reflection 0}
  }
  translate <-0.5,0,-0.5>
  scale <4,3,0.001>*0.4
  rotate y*-30
  translate <-4.25,-0.2,6>
 }

 box {
  0,1
  hollow
  texture {
   pigment {
    image_map {png "fern.png" interpolate 2}
   }
   finish {specular 0 reflection 0}
  }
  translate <-0.5,0,-0.5>
  scale <4,3,0.001>*0.375
  rotate y*-35
  translate <-6.5,-0.2,3>
 }

 box {
  0,1
  hollow
  texture {
   pigment {
    image_map {png "fern.png" interpolate 2}
   }
   finish {specular 0 reflection 0}
  }
  translate <-0.5,0,-0.5>
  scale <4,3,0.001>*0.375
  rotate y*-30
  translate <-4.6,-0.2,3.5>
 }

 box {
  0,1
  hollow
  texture {
   pigment {
    image_map {png "youngbirch.png" interpolate 2}
   }
   finish {specular 0 reflection 0}
  }
  translate <-0.5,0,-0.5>
  scale <4,4,0.001>
  rotate y*-30
  translate <-6.1,-1.5,7.8>
 }

 box {
  0,1
  hollow
  texture {
   pigment {
    image_map {png "youngbirch.png" interpolate 2}
   }
   finish {specular 0 reflection 0}
  }
  translate <-0.5,0,-0.5>
  scale <4,4,0.001>
  rotate y*-30
  translate <-5.4,-1.5,7.7>
 }
 
 box {
  0,1
  hollow
  texture {
   pigment {
    image_map {png "youngbirch.png" interpolate 2}
   }
   finish {specular 0 reflection 0}
  }
  translate <-0.5,0,-0.5>
  scale <4,4,0.001>
  rotate y*-30
  translate <-7.3,-1.5,6.6>
 }

 box {
  0,1
  hollow
  texture {
   pigment {
    image_map {png "youngbirch.png" interpolate 2}
   }
   finish {specular 0 reflection 0}
  }
  translate <-0.5,0,-0.5>
  scale <4,4,0.001>
  rotate y*-30
  translate <-7.5,-1.25,5.25>
 }

 box {
  0,1
  hollow
  texture {
   pigment {
    image_map {png "youngbirch.png" interpolate 2}
   }
   finish {specular 0 reflection 0}
  }
  translate <-0.5,0,-0.5>
  scale <4,4,0.001>
  rotate y*-30
  translate <-7.6,-1.25,4>
 }
 
 box {
  0,1
  hollow
  texture {
   pigment {
    image_map {png "youngbirch.png" interpolate 2}
   }
   finish {specular 0 reflection 0}
  }
  translate <-0.5,0,-0.5>
  scale <4,4,0.001>
  rotate y*-30
  translate <-7.8,-1.25,3.5>
 }

#end

// wall
#if (showWall=1)
#declare StoneWallStoneTexture=
 texture 
  { 
   T_Stone8 
   normal { dents scale 0.2 } 
   finish { phong 0 specular 0 crand 0.1 } 
  }
#declare StoneWallRGBlow = <0.7,0.5,0.35>;
#declare StoneWallRGBhigh = <1,0.9,.7>;
#declare MortarTexture=
 texture  
  {  
   pigment { Gray } 
   normal { dents scale 0.1 } 
   finish { crand 0.05 } scale 0.2 
  }

 object {
  stone_wall( 1, 
              80,20, 
              1,5,
              1,5,
              <0.25,0.25>, 0.1,
              StoneWallStoneTexture, StoneWallRGBlow, StoneWallRGBhigh,
              MortarTexture 
             )
  scale <80,20,1>*0.09
  rotate y*-90
  translate <-9,0,2>
 }
 
 object {
  stone_wall( 1, 
              80,20, 
              1,5,
              1,5,
              <0.25,0.25>, 0.1,
              StoneWallStoneTexture, StoneWallRGBlow, StoneWallRGBhigh,
              MortarTexture 
             )
  scale <80,20,1>*0.09
  translate <-10,0,9>
 }

#end

#if (showAtmosphere=1)
 background {Gray70}

 fog {
  fog_type   2
  distance   3
  color      rgb <0.5,0.5,0.55>
  fog_offset -0.1
  fog_alt    0.25
  turbulence 0.5
 }
 
 fog {
  fog_type   1
  distance   18
  color      rgb <0.75,0.75,0.8>
  turbulence 0.5
 }
#end

#if (showRain=1)

 plane { 
  z,0
  texture {T_Rain}
  no_shadow
  hollow
  rotate z*-10
  rotate y*-40
  translate  <3, 0, -0.75> //3,0,-0.75
 }
 
 plane { 
  z,0
  texture {T_Rain translate <1.25,6,0.85>}
  no_shadow
  hollow
  rotate z*-10
  rotate y*-40
  translate  <1, 0, 0>
 }

 plane { 
  z,0
  texture {T_Rain translate <3.1124,6,-0.25>}
  no_shadow
  hollow
  rotate z*-10
  rotate y*-40
  translate  <-0.75, 0, 0.5> //-1,0,0.75
 }

#end
