//---------------------------------------------------------------------------------------------------//
//                                        Atmosphere.inc                                             //
// Objects included:                                                                                 //
// - Atmosphere Media Block                                                                          //
// - Crucial Light sources                                                                           //
// - Sky Sphere                                                                                      //
// - Moon                                                                                            //
//---------------------------------------------------------------------------------------------------//

//Changed:
//Light source brightness multiplier
//Smoke Colour adder
//Smoke settings,, omega
//Atmosphere block size

//---------------------------------------------------------------------------------------------------//
//                                   Experimental Light Sources                                      //
//---------------------------------------------------------------------------------------------------//
//Strong bright light coming from the right side
/*light_source {<125,150,100>,<5,3.5,2.5>*0.4
        spotlight radius 8 falloff 12 point_at <0,0,0>
}*/

//Light on the right, facing mostly toward camera 
/*light_source {<50,100,100>,<5,3.5,2.5>*0.4      //<5,4,2.5>
        spotlight radius 8 falloff 15 point_at <0,0,-10>
}*/

//In between first and second light - Exp#3
/*light_source {<70,120,40>,<5,3.5,2.5>*0.5
        spotlight radius 8 falloff 12 point_at <-8,0,-3>
}*/

//Two light combination to achieve different effect
//light_source {<70,130,80>,<5,3.5,2.5>*0.35 spotlight radius 6 falloff 9 point_at <-10,0,-5> }
//light_source {<120,150,100>,<5,3.5,2.5>*0.4 spotlight radius 5 falloff 10 point_at <-5,0,-5> }

#declare Pri_light_loc = <105,115,150>;      //a spot light, 110,100,110=>0,5,-5 / second setting 90,115,150=>0,2,0 (or 100,130,150=>-10,5,0)
#declare Pri_light_pt_at = <-15,3,-3>;         //-10,2,0 and -10,-5,-3
//#declare Pri_light_loc = <90,115,150>;      //second setting 90,115,150=>0,2,0 (or 100,130,150=>-10,5,0)
//#declare Pri_light_pt_at = <0,2,0>;

//DO the math
//115/110 = 1.045 atan =>46.27
//Light_length = sqrt(115^2 + 110^2) = 159.14 =>185.3375299 => ang = 30.83572356

#declare y_ang = radians(46.27303002);
#declare xz_ang = radians(30.83572356);
#declare light_length = 185.3375299;
#declare extension = 80;

//#declare Pri_light_loc = <110+(extension*cos(xz_ang)),(extension * sin(y_ang))+100,110+(extension*sin(xz_ang))>;

#declare Sec_light_loc = <100,100,50>;
#declare Sec_light_loc2 = <100,100,0>;
//#declare Light_Colour = //<5,3.5,2.5>*0.4; //1,0.7,0.5 => 2,1.4,1
//#declare Light_Colour = RGBColour (222,204,180)*1.8;     //must x1.6 or higher
#declare Light_Colour = RGBColour (184,206,212)*1;     //must x1.6 or higher or 1.42 (1.7 old setting)
//Colour representing sadness and loneiness => cold, blueish grey

//Soft light comparable to first light
light_source { 
     Pri_light_loc, Light_Colour
     spotlight
     point_at Pri_light_pt_at
     radius 9       //9
     falloff 24     //or 18 (15 old setting)
     tightness 30   //30
     fade_distance 150   //120 /140/ 160
     fade_power 1
}

//Secondary lights.....
light_source { 
     Sec_light_loc, Light_Colour*0.8
     parallel
     point_at <-21,5,-5>
     shadowless
     media_interaction off
}

//light_source {<-100,100,-100>*1000 colour rgb 0.2 shadowless}

/*light_source { 
     Pri_light_loc, Light_Colour*0.3
     parallel
     point_at <-100,5,150>
     shadowless
     media_interaction off
}*/


/*light_source { 
     Sec_light_loc2, Light_Colour*0.5
     media_interaction off
}*/

//Show Light vector as a cylinder
#if (Show_Light_Vector > 0)
union {
     cylinder { Sec_light_loc, <-21,0,-5>, Show_Light_Vector }
     cylinder { Pri_light_loc,Pri_light_pt_at, Show_Light_Vector }
     pigment{
          gradient y
          colour_map {
               [0 Blue]
               [0.5 White]
               [1 Blue]
          }
          translate -y/2
          scale <1,2,1>
     }
     finish {ambient 1}
}
#end

//---------------------------------------------------------------------------------------------------//
//                                   Air Density Definitions                                         //
//---------------------------------------------------------------------------------------------------//

//--------------------- Major Variables --------------------
#declare Smoke_Colour = <1,1.05,1.2>+2.4;  //+2.8
#declare Smoke_Black_Colour = 0.5;      //0.6
#declare FG_Smoke_Colour = <0.2,0.2,0.3>+6;
#declare Air_Colour_Close = 0.1;
#declare Air_Colour_Mid = 0.72;   //.73
#declare Air_Colour_Far = 0.05;     //0.05
//#declare Colour_Deviation = 0.05;

//Variable for single y controller
#declare Smoke_Height = 0.026;      //Height of smoke from ground (0..1) (13)
#declare Smoke_Thickness = 0.31;    //Smoke thickness in the z direction (0..1) (50)
#declare Smoke_Distance = 0.18;     //Distance of smoke from camera (approx.) (0..1) (30)(22)
#declare Fade_Factor = 0.07;        //How fast does the smoke fade (0..1) (0.07)
#declare Fog_Height = 0.0042;       //Foreground fog height distance
#declare Near_Fog_FF = 0.0043;       //Fade factor for near_fog

#declare BG_Fog_H = 0.05;
#declare BG_Fog_F = 0.05;

//Smoke to Air ratio param, 5 sections, 3 param's each: Smoke Position, Smoke Height and Fade Factor
//#declare Smoke_Ratio = array [4][3] { {0,0.053,0.01}, {0.4,0.045,0.03}, {0.48,0.018,0.05}, {1,0.032,0.06} };//, {1,0.05,0.05} };
#declare Smoke_Ratio = array [4][3] { {0,0.055,0.05}, {0.4,0.045,0.03}, {0.48,0.02,0.03}, {1,0.025,0.03} };//, {1,0.05,0.05} };

#declare Air_Intervals = Atmo_Qual_Level;
#declare Atmo_Radius = 13;         //a multiplier

//---------------- Smoke component of the air ---------------
#if (True_Smoke)
     #declare Smoke_Density = density {
          //spherical
          agate
          agate_turb 0.2
          warp {
               turbulence 0.5//0.8
               octaves 6
               lambda 2
               omega 0.8     //(0.7)
          }
          frequency 6    //4
          colour_map{
               [0.00 colour rgb Smoke_Black_Colour]
               //[0.02 colour rgb 0]
               //[0.00 colour rgb Smoke_Colour]
               //[0.24 colour rgb Smoke_Black_Colour]
               //[0.80 colour rgb Smoke_Colour]
               [1.00 colour rgb Smoke_Colour ]    //0.6
          }
     }
     //Backup
     /*#declare Smoke_Density = density {
          //spherical
          agate
          agate_turb 0.55
          turbulence 0.75//1.3
          frequency 5//8.5 (spherica)
          //phase -0.2
          octaves 6
          lambda 2
          omega 0.7      //(0.7)
          colour_map{
               [0.00 colour rgb Smoke_Black_Colour]
               //[0.02 colour rgb 0]
               //[0.00 colour rgb Smoke_Colour]
               //[0.24 colour rgb Smoke_Black_Colour]
               //[0.80 colour rgb Smoke_Colour]
               [1.00 colour rgb Smoke_Colour ]    //0.6
          }
     }*/

     #declare FG_Smoke_Density = density {
          wrinkles
          //agate
          //agate_turb 0.55
          turbulence 1.5
          frequency 5
          octaves 6
          lambda 2
          omega 0.65      //(0.7)
          colour_map{
               [0.00 colour rgb 0]
               [0.4 colour rgb 0]
               [1.00 colour rgb FG_Smoke_Colour ]    //0.6
          }
          scale <0.3,0.1,0.2>
     }
#else
     #declare Smoke_Density = density { rgb <1,0,0> }
     #declare FG_Smoke_Density = density { rgb <1,0,0> }     
#end      

//---------------- The Remaining Air -------------------------
#macro Air_Density (Colour)
     rgb Colour
#end

//------------ Y Gradient Smoke-Air Controller Macro ----------
#macro Atmo_Density_y (Pos, Smoke_h, Fadeout)
     #local y_Density = density {
          gradient y
          density_map {
               [0 Smoke_Density]
               [Smoke_h Smoke_Density]
               [Smoke_h+Fadeout Air_Density(Air_Colour_Mid)]
               //[Smoke_h+Fadeout+Fog_Height Air_Density(Air_Colour_Mid)]
               //[Smoke_h+(2*Fadeout)+Fog_Height Air_Density(Air_Colour_Close)]
               [1 Air_Density(Air_Colour_Mid)]
          }
     }
     [Pos y_Density]
#end

//----------- Atmosphere density in the x gradient -----------
//Contain Left (-x), Center, and Right (+x)
#declare x_Fade = 0.05;
#declare Atmo_Density_x = density {
     gradient x
     density_map {
          Atmo_Density_y(Smoke_Ratio[0][0],Smoke_Ratio[0][1],Smoke_Ratio[0][2])
          Atmo_Density_y(Smoke_Ratio[1][0],Smoke_Ratio[1][1],Smoke_Ratio[1][2])
          Atmo_Density_y(Smoke_Ratio[2][0],Smoke_Ratio[2][1],Smoke_Ratio[2][2])
          Atmo_Density_y(Smoke_Ratio[3][0],Smoke_Ratio[3][1],Smoke_Ratio[3][2])
          //Atmo_Density_y(Smoke_Ratio[4][0],Smoke_Ratio[4][1],Smoke_Ratio[4][2])
     }
     translate -x/2
     scale <2,1,1>
}

//---------------- Special Near Fog ---------------------------
#declare FG_Fog = density {
     gradient y
     turbulence 0.01
     density_map {
          //[0 FG_Smoke_Density]             //for use with turbulent fog
          //[Fog_Height FG_Smoke_Density]
          [0 colour rgb FG_Smoke_Colour]
          [Fog_Height colour rgb FG_Smoke_Colour]
          [Fog_Height+Near_Fog_FF Air_Density(Air_Colour_Close)]      //Close to zero density
          [1 Air_Density(Air_Colour_Close)]
     }
}

//------------ Atmosphere density in the z gradient ----------
#declare Atmo_Density_z = density {
     gradient z
     density_map {
          [0 FG_Fog]
          [Smoke_Distance-Fade_Factor FG_Fog]
          //[0 Air_Density(Air_Colour_Close)]
          //[Smoke_Distance-Fade_Factor Air_Density(Air_Colour_Close)]
          
          [Smoke_Distance Atmo_Density_x]
          [Smoke_Distance+Smoke_Thickness Atmo_Density_x]
          [Smoke_Distance+Smoke_Thickness+Fade_Factor Air_Density(Air_Colour_Far)]
          [1 Air_Density(Air_Colour_Far)]
          //[Smoke_Distance+Smoke_Thickness+Fade_Factor BG_Fog]
          //[1 FG_Fog]
     }
     translate -z/2
     scale <1,1,2>
}
     

//----- Air Media Object... Add a bit of fog into the scene -----
#declare air = cylinder { <0,0,0>, <0,1,0>, 1
     material {
          texture {
               pigment { rgb 1 #if(!Atmo_Test_Mode) filter 1 #end }
          }
          interior {
               media {
                    method 3
                    intervals Air_Intervals
                    #if (HQ_Atmo_Settings > 0)
                         samples HQ_Atmo_Settings,HQ_Atmo_Settings
                         //aa_threshold 0.3
                         confidence 0.9999
                         variance 1/1000
                    #end
                    //emission 0.001
                    //absorption 0.01
                    //Smaller scattering colour value, brighter scene
                    //When using light at 150*z => colour 0.025 ext 0.4
                    //WHen using light at 110*z => colour 0.03 ext 0.4
                    scattering { 1, 0.025 extinction 0.4}  //old method
                    //scattering { 4, 0.03 extinction 1 }
                    density { Atmo_Density_z }
               }
          }
     }
     #if (Atmo_Test_Mode) scale <10,2,10>*Atmo_Radius
     #else scale <10,20,10>*Atmo_Radius #end      //old setting: scale <10,20,10>*5 translate <0,0,20>
     translate <0,0,80>
     hollow
}

/*gradient y
     density_map {
          [0 Smoke_Density scale 0.8]
          [0.1 Smoke_Density scale 0.7]
          [0.2 rgb <5,3.5,2.5>*0.02]
          [1 rgb <5,3.5,2.5>*0.02]
     }
     rotate 10*x*/

//---------------------------------------------------------------------------------------------------//
//                                          Sky Sphere                                               //
//---------------------------------------------------------------------------------------------------//

#declare image_scl = 140;
#declare sp_w_scl = 4/3;


#if (Show_Sky)

sky_sphere {
     pigment {
          gradient y
          color_map {
               [0 colour rgb RGBColour(174,150,115)]//RGBColour (180,160,128)]
               [1 colour rgb 0]//RGBColour (63,69,77)]
          }
          scale 2
          translate -1
     }
}
#end

//Setting 1
/*sky_sphere {
     pigment {
          image_map {
               sys "texturez\cloud2.bmp"
               map_type 0
               interpolate 2
          }
          scale <1,1.3,1>
          rotate <0,46,0>
          rotate <28,0,0>
          rotate <-22,-8,0>
     }
}*/

//---------------------------------------------------------------------------------------------------//
//                                           The Moon                                                //
//---------------------------------------------------------------------------------------------------//

#declare Mid_Point = 0.65;     //(0..1) point at which the moon fades out
#declare Fade_Factor = 0.2;  //(0..1) how fast does the fade out occurs

#declare T_Moon = texture {
     pigment {
          image_map {
               jpeg "texturez\moon.jpg"
               map_type 1
               interpolate 2
          }
          rotate <0,10,-145>
     }
     finish { ambient RGBColour(183,219,242)*2 diffuse 0 }
}

#declare T_Clear = texture {
     pigment { colour rgbt 1 }
}

#declare Moon = sphere { 0, 1
     texture {
          gradient z
          texture_map {
               [0 T_Moon]
               [Mid_Point T_Moon]
               [Mid_Point+Fade_Factor T_Clear]
               [1 T_Clear]
          }
          translate <0,-1,1>*0.5
          scale 2
     }
     rotate 180*x
}