//---------------------------------------------------------------------------------------------------//
//                                          Ground.inc                                               //
// Objects Included:                                                                                 //
// - Basic Ground Plane used in Scene                                                                //
//---------------------------------------------------------------------------------------------------//

//---------------------------------------------------------------------------------------------------//
//                                   Noise functions                                                 //
//---------------------------------------------------------------------------------------------------//
//----- f_ridge parameters -------
//P0 : Lambda 
//P1 : Octaves 
//P2 : Omega 
//P3 : Offset 
//P4 : Ridge 
//P5 : Generator type used to generate the noise3d. 0, 1, 2 and 3 are legal values. 
#declare fn_noise1 = function { f_ridge(x,y,z, 3, 1.5, 0.6, 0, 1, 0) };
#declare fn_noise2 = function { f_noise3d(x, y/2, z) };

//---------------------------------------------------------------------------------------------------//
//                                 Ground ISOsurface definition                                      //
//---------------------------------------------------------------------------------------------------//

//Remember to set the width and height for the image
#declare Image_W = 640;
#declare Image_H = 424;
#declare length_inc = Image_W / Image_H;
#declare image_map_scl = 20;
#declare hf_yscale = 0.4;     //0.4 for ground1.tga, 0.6 for ground2
#declare hf_hill_yscale = 2;

#declare T_Ground = texture {
     pigment {
          image_map {
               sys "texturez/dry_grass2.bmp"
               map_type 0
               interpolate 2
          }
     }
     normal {
          bump_map {
               sys "texturez/dry_grass1.bmp"
               map_type 0
               interpolate 2
               bump_size 4
          }
     }
     finish { ambient 0.05 diffuse 0.35 }
     rotate 90*x
     scale <length_inc,1,1>
}

#declare Ground_HF = height_field {
     tga "hf/ground1.tga"
     smooth
     translate <-0.5,0,-0.5>
    
     //rotate <0,-90,0>     //for ground2.tga
     scale <10, hf_yscale, 10>*<12,10,15>

     //pigment { White }
     texture { T_Ground scale image_map_scl}
     
     rotate <3,180,0>
     translate <0,-2,0>

}

#declare Hill_HF = height_field {
     tga "hf/ground2.tga"
     smooth
     translate <-0.5,0,-0.5>
     scale <10,hf_hill_yscale,10>*<24,10,30>
     rotate -90*y
     rotate <2,0,0>
     
     translate <0,-1/*((15*10)/2)*sin((3/180)*pi)*/,190>//((15*10)/2)+((10*30)/2)>
     texture { T_Ground scale image_map_scl}
     rotate <3,0,0>
}

/*#declare ground = isosurface {
     //function { y+f_ridged_mf(x,y,z, 0.2, 1, 1.5, 0, 0, 1)}
     function { y+fn_noise1(x,y,z) }
     contained_by { box {<-3,-2,-3>,<3,3,3>} }
     max_gradient 4
     texture {
          normal {
               wrinkles 0.5
               turbulence 0.2
               scale 0.3
          }
          pigment { colour rgb 1 }
          //finish { ambient 0.3 diffuse 0.5 specular 0.2 roughness 0.1 }
     }
     scale <2,1,2>
}*/
