#version unofficial MegaPov 0.7;

#macro chain_link(position1,position2,waver,height,obj)

#local S1 = seed(481);

#local test = 0;

#local overall_length = vlength(position2-position1);

#local section_length = height*1.6;

#local diameter = height/45;

#local point_offset = <0,0,0>;

#local point_current = position1 + point_offset;

#local norm1 = <0,0,0>;

#local norm2 = <0,0,0>;

#local numbars = 0;

#local numbars_max = 30;

union{

#while ( vlength( point_current - position1 ) < overall_length - section_length )

  #local point_current = position1 + point_offset;

  #local new_vect = section_length * vnormalize(position2 - point_current);
  
  #local waver_amt = waver*rand(S1)-waver/2;

  #local point_offset = point_offset + vaxis_rotate(<new_vect.x,0,new_vect.z>,<0,1,0>,waver_amt);
  
  #local pos1 = trace ( obj, <point_current.x,30,point_current.z>, <0,-1,0>, norm1 );
  
  #local point_next = position1 + point_offset; 
  
  #local pos2 = trace ( obj, <point_next.x,30,point_next.z>, <0,-1,0>, norm2 );
  
  #if ( norm1.y != 0 & norm2.y != 0 )
  
  cylinder{ pos1, pos1+<0,height,0>, diameter texture{ aluminum } }
  
  #local vect_cross_pole = pos2 - pos1;
  
  cylinder{ pos1+(.02*vect_cross_pole) pos1+(.98*vect_cross_pole), diameter texture{ aluminum } translate height*.95*y }
  
  prism{
    -.05,+.05,5
    <0,0>,<section_length,pos2.y-pos1.y>,<section_length,(pos2.y-pos1.y)+height*.95>,<0,height*.95>,<0,0>
    rotate -90*x
    texture{ fence_tex }
    rotate -(180/pi*atan2(pos2.z-pos1.z,pos2.x-pos1.x)-0)*y
    translate pos1
  }
  
#end #end

}

#end





