#version unofficial MegaPov 0.7;

#include "flower.inc"

#macro flower_patch(rad,scal,locat,flow_count,tex,fseed)

#local S1 = seed(fseed);
#local flow_num = 0;

#while ( flow_num < flow_count )

  #if ( vlength( tex ) = 0 )
  
    #local prand = rand(S1);
   
    #local pig1 = pigment{ color rgb <0.41961, 0.18431, 0.5098> }
    #local pig2 = pigment{ color rgb <0.84706, 0.71373, 0.89412> }
    #local pig3 = pigment{ color rgb <0.95294, 0.9451, 0.56078> }
    
          #switch ( prand )
            #range ( 0,.3 )
              #local gtex =
                texture{
                  pigment{ pig1 }
                  finish{ phong .05 phong_size 10 ambient .3 diffuse .9 }
                }
            #break
            #range ( .3,.65 )
              #local gtex =
                texture{
                  pigment{ pig2 }
                  finish{ phong .05 phong_size 10 ambient .3 diffuse .9 }
                }
            #break
            #range ( .65,1 )
              #local gtex =
                texture{
                  pigment{ pig3 }
                  finish{ phong .05 phong_size 10 ambient .3 diffuse .9 }
                }
            #break
          #end
    
  #else
  
    #local gtex =
    texture{
      pigment{ color rgb tex }
      finish{ phong .05 phong_size 10 ambient .3 diffuse .9 }
      }
    
  #end 

  #local radi = rad*(rand(S1)+.1*rand(S1));
  #local theta1 = 360*(rand(S1)+.1*rand(S1));
  #local theta2 = 40*(rand(S1)+.1*rand(S1))-20;
  #local theta3 = 40*(rand(S1)+.1*rand(S1))-20;
  #local theta4 = 360*(rand(S1)+.1*rand(S1));
  #local flower_scale = scal/2+.5*scal*rand(S1);
  
  union{
    object{ flower_petals texture{ gtex } }
    object{ flower_base texture{ grass_tex } }
    object{ flower_stem texture{ grass_tex } }
    rotate theta1*y
    rotate <theta2,0,theta3>
    scale flower_scale
    translate radi*x
    rotate theta4*y
    translate locat 

  }

  #local flow_num = flow_num + 1;

#end

#end







