#version unofficial MegaPov 0.7;

#macro gravel_patch(field_width,field_depth,field_center,particle_count,scale_min,scale_max,obj,sd)

#local S1 = seed(sd);

#local grav_num = 0;

#local Rock = function    {"sphere", <1> }
#local Rough_Rock = 
    function{ Rock +
              noise3d(x*.5,y*.5,z*.5)*2 +
              noise3d(x*5,y*5,z*5)*0.15  
    }

#while ( grav_num < particle_count )
  
  #local posx = field_center.x+field_width*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1))-field_width/2;
  #local posz = field_center.z+field_depth*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1))-field_depth/2;
  
  #local gscale = (rand(S1)+.1*rand(S1))*(scale_max-scale_min)+scale_min;
  
  #local norm = <0,0,0>;

  #local pos = trace ( obj, <posx,30,posz>, <0,-1,0>, norm );
  
  #if ( norm.y != 0 )

  isosurface {
    function{ Rough_Rock }
    contained_by{ box { <-1,-1,-1> <1,1,1> }}
    eval
    threshold 0.85
    method 2
    rotate <360*rand(S1),360*rand(S1),360*rand(S1)>
    scale <gscale,gscale/1.5,gscale>
    translate pos
    texture{ road_gravel } 
  }
  
  #end

  #local grav_num = grav_num + 1;

#end

#end


