#version unofficial MegaPov 0.7;

#declare camera_position = 
  <-13,11.5,-39>;
  
#declare camera_look =
  <-2.5,4,-8>;
  
#declare focal_dist = vlength(camera_position-camera_look);

global_settings{ 
  ini_option "+QR"
  post_process { focal_blur { focal_dist+8, 20, 3, 0.5 } } 
  max_trace_level 20
  ambient_light 0
  radiosity {
      pretrace_start 0.08
      pretrace_end   0.007
      count 40

      nearest_count 5
      error_bound .5
      recursion_limit 1

      low_error_factor 0.5
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1.3
      normal on

      adc_bailout 0.01/2
      always_sample off
    }
}

camera{
  location camera_position
  look_at camera_look
  }

/////////////// Always-on light //////////////////////

light_source{ <-500,400,300> color rgb .3 shadowless }

/////////////// Lights for no-radiosity //////////////

//light_source{ <1000,1000,-600> color rgb .2 parallel point_at <0,0,100> }
//light_source{ <600,600,-400> color rgb .4 shadowless }


////////////////////////////////////////////
/////////////// Objects ////////////////////
////////////////////////////////////////////


#declare heightfields_obj   =  1;  // 1 for heightfield ground
#declare building_obj       =  1;  // 1 for outbuildings
#declare woods_obj          =  0;  // 1 for woods
#declare rain_obj           =  1;  // 1 for raindrops
#declare grass_main_obj     =  1;  // 1 for close up grass blades
#declare weeds_obj          =  1;  // 1 for weeds at fence line
#declare fence_obj          =  1;  // 1 for fence
#declare gravel_obj         =  0;  // 1 for gravel in roadway


#declare tombstone_main_obj =  1;  // 1 for complex, -1 for simple
#declare widow_obj          =  1;  // 1 for widow
#declare clip_obj           =  0;  // 1 for car front end
#declare cardrop_obj        =  0;  // 1 for drops on car
#declare pot_obj            =  1;  // 1 for pots at main grave
#declare pot_flowers_obj    =  1;  // 1 for flowers in the pots
#declare misc_tombs_obj     =  1;  // 1 for other tombstones
#declare stone_drop_obj     =  0;  // 1 for raindrops on front tombstones


#include "objects.inc" 



















