#version unofficial MegaPov 0.7;

#include "tex.inc"
#include "raindrop_patch.inc"
#include "grass_patch.inc"
#include "woods_patch.inc"
#include "groundpatch.inc"
#include "tyre.inc"
#include "chainlink.inc"
#include "flower_patch.inc"
#include "rain.inc"
#include "gravel_patch.inc"
#include "rain_streams.inc"


//////////// Sky Sphere /////////////

sky_sphere{
  pigment{ gradient y
    color_map {
      [ 0.5  color <0.5098, 0.54118, 0.6> ]
      [ 1.0  color <0.5098, 0.54118, 0.6> ]
    }
  scale 2
  translate -1
  }
}

//////////// Fog /////////////////////

fog{ 
  fog_type 1 
  distance 180 
  color rgbf <0.5098, 0.54118, 0.6, .5> 
  turbulence .9 turb_depth 10
  } 

//////////// Tombstone ///////////////

#switch ( tombstone_main_obj )
  #case ( 1 )
    #declare tstone_qual = 1;
    #include "tombstone_main.inc"
    object{ tombstone scale 3.7 texture{ clear } translate <-10,.5,1> }
  #break
  #case ( -1 )
    #declare tstone_qual = 0;
    #include "tombstone_main.inc"
    object{ tombstone scale 3.7 translate <-10,.5,1> }
  #break
  #case ( 0 )
  #break
#end

//////////// Ground /////////////////

#if ( heightfields_obj )
  #declare back_ground =
  height_field{
    png "hf.png"
    smooth
    texture{ grass_tex_far }
    translate <-.5,-.5,-.5>
    scale <600,10,600>
    translate <100,0,250>
    water_level .35
  }
  object{ back_ground }

  #declare road_bed =
  height_field{
    png "road_bed.png"
    smooth
    texture{ road_bed }
    translate <-.5,-.5,-.5>
    scale <600,8,600>
    translate <100,1,250>
    water_level .35
  }
  object{ road_bed }
#end

//////////// Woods //////////////////

#if ( woods_obj )  
  woods_patch(200,300,<220,0,195>,80,.5,2,back_ground,1528)
  woods_patch(100,300,<-100,0,280>,50,.5,3,back_ground,9521)
#end



//////////// Grass //////////////////

#declare ogd = 70000; //Optimal grass density at close field (~70000)

#if ( grass_main_obj )
  //grass_patch(80,20,<0,0,-25>,ogd,back_ground,.7,.4,.08,.05,.75,.1,.3,.8,3,<0,0,0>) //from -35 to -15
  //grass_patch(80,10,<0,0,-10>,(20/40)*ogd,back_ground,.7,.4,.08,.05,.75,.1,.3,.8,3,<0,0,0>) //from -15 to -5
  grass_patch(110,30,<0,0,10>,(30/40)*ogd,back_ground,.7,.4,.08,.05,.75,.1,.3,.8,3,<0,0,0>) //from -5 to 25
  grass_patch(250,50,<0,0,50>,(35/40)*ogd,back_ground,.7,.4,.08,.05,.75,.1,.3,.8,3,<0,0,0>) //from 25 to 75
  grass_patch(300,50,<0,0,100>,(10/40)*ogd,back_ground,1.5,.4,.08,.05,.75,.1,.3,.8,3,<0,0,0>) //from 75 to 125
#end

//////////// Fence /////////////////

#if ( fence_obj )
  chain_link(<-70,0,170>,<250,0,170>,10,12,back_ground)
  chain_link(<-70,0,170>,<-90,0,100>,10,12,back_ground)
#end

//////////// Front Clip ////////////

#if ( clip_obj )
  #include "car_wheel.inc"
  #include "car_clip.inc"
  #include "car_flrbrds.inc"
  #include "car_headlight.inc"
  #include "car_wheelplug.inc"
  #include "car_lugs.inc"
  #include "car_spoiler.inc"
  object{ 
    union{ 
      object{ car_clip texture{ paint } texture{ clearcoat } }
      object{ car_flrbrds texture{rubber} }
      object{ car_headlight texture{ lens_tex } }
      object{ car_spoiler texture{ flat_black } }
      #if ( cardrop_obj ) 
        raindrop_patch(50,50,<0,10,-10>,<0,0,0>,1200,.15,.2,car_clip,1582)
        #include "car_stream1.inc" object{ car_stream1 texture{ clear } interior{ ior 1.5 } }
        #include "car_stream2.inc" object{ car_stream2 texture{ clear } interior{ ior 1.5 } }
      #end
      union{
        object{ Tyre( 10.5, 7.0, 6.5, "tread.png", .15, .35, .35, .15 ) texture{rubber} scale 1.11 rotate 90*x translate 1.46*z }  
        object{ car_wheel texture{ aluminum_brushed } }
        object{ wheelplug texture{ pont_logo } }
        object{ wheel_lugs texture{ gloss_black } }
        cylinder{ <0,0,.3> <0,0,.4>, 5 texture{ aluminum } }
        scale <.9,.9,.7> rotate 4*y translate <0,-.2,0>
      }
      union{
        object{ Tyre( 10.5, 7.0, 6.5, "tread.png", .15, .35, .35, .15 ) texture{rubber} scale 1.11 rotate 90*x translate 1.46*z }  
        object{ car_wheel texture{ aluminum_brushed } }
        cylinder{ <0,0,.3> <0,0,.4>, 5 texture{ aluminum } }
        scale <.9,.9,.7> rotate -7*y translate <0,-.2,0>
        translate -45*z scale <1,1,-1>
      }
    }
    rotate 95*y
    scale .4 
    translate <30,5.5,1.5>
    }
#end

//////////// Weeds /////////////////

#if ( weeds_obj )
  grass_patch(150,150,<-80,0,200>,2000,back_ground,12,5,.18,.05,.75,.1,.3,.8,3,<.8,.9,.2>)
  grass_patch(200,150,<-90,0,440>,4000,back_ground,12,5,.18,.05,.75,.1,.3,.8,3,<.8,.9,.2>)
  grass_patch(200,150,<220,0,190>,2000,back_ground,12,5,.18,.05,.75,.1,.3,.8,3,<.8,.9,.2>)
#end

//////////// Pots //////////////////

#if ( pot_obj )
  #include "pot_main.inc"
  #declare pot1 = object{ pot_main texture{ pot_tex } scale .8 rotate <1,-2,1> translate <-17,1.5,.5> }
  #declare pot2 = object{ pot_main texture{ pot_tex } scale .8 rotate <-1,2,1> translate <-3,1.5,.5> }
  object{ pot1 }
  object{ pot2 }
#end

#if ( pot_flowers_obj )
  grass_patch(2,2,<-17,2.6,.5>,30,pot1,2,.5,.10,.05,.75,.1,.3,.8,5,<.2,.6,.2>)
  grass_patch(2,2,<-3,2.8,.5>,30,pot2,2,.5,.10,.05,.75,.1,.3,.8,5,<.2,.6,.2>)
  flower_patch(1.0,.2,<-17.25,3.5,.5>,25,<0,0,0>,8421)
  flower_patch(1.0,.2,<-3,3.5,.5>,25,<0,0,0>,8351)
#end

//////////// Rain //////////////////

#if ( rain_obj )
  rain(150,30,80,.02,.8,6,<10,5,-35>,3500)
#end

//////////// Buildings /////////////

#if ( building_obj )
  #include "house.inc"
  object{ house(60,90,35,9) rotate 40*y translate <150,-10,350>}
  object{ house(60,90,40,10) rotate -30*y translate <40,-10,350>}
#end

//////////// Widow /////////////////

#if ( widow_obj )
  #include "umbrella_canopy.inc"
  #include "umbrella_ribs.inc"
  #include "cloak_main.inc"
  #include "cloak_seams.inc"
  #include "cloak_buttons.inc"
  #include "pant_leg.inc"
  #include "shoe.inc"
  union{
    union{
      object{ umbrella_canopy texture{ wet_velvet } }
      object{ umbrella_ribs texture{ gloss_black } }
      object{ raindrop_patch(40,40,<-6,30,-50>,<0,42,-16>,800,.1,.15,umbrella_canopy,851) }
      rotate 20*y rotate 35*x rotate -10*z scale 1.1 translate <.1,0,-14> 
    }
    object{ cloak_main texture{ grey_fleece } }
    object{ cloak_seams texture{ grey_fleece_seams } }
    object{ cloak_buttons texture{ flat_black } }
    object{ shoe texture{ flat_black } }
    object{ pant_leg texture{ charcoal } translate .4*x }
    scale <.24,.25,.24> rotate -20*y translate <-5.6,1.5,-15>
  }
  stream(<-1.13,8.2,-17.25>,6,.02,10)
  stream(<-5,8.0,-18.5>,8,.02,15)
  stream(<-8.7,8.9,-17.25>,3,.02,5)
  stream(<-10.2,11,-14.0>,6,.02,10)
#end

//////////// Gravel /////////////////

#if ( gravel_obj )
  gravel_patch(200,200,<50,0,30>,100000,.05,.2,road_bed,4845)
  gravel_patch(200,200,<50,0,30>,40000,.2,.3,road_bed,4845)
#end

//////////// Misc Tombstones /////////////

#if ( misc_tombs_obj )
  #include "misc_tombstones.inc" 
  
    object{ stone_1 texture{ stone_tex1 } texture{ clear } scale <2.5,3,2.5> translate <-36,0,130> }

    object{ stone_3 texture{ stone_tex1 } texture{ clear } scale <2.5,3,2.5> translate <-17,0,55> }
    object{ stone_2 texture{ stone_tex2 } texture{ clear } scale 2.5 translate <-36,0,55> }

    object{ iso_stone2 texture{ clear } scale 2.5 rotate 3*z translate <8,.5,1> }
    object{ iso_stone1 texture{ clear } scale 2.5 rotate -6*x translate <-27,1,1> }

    object{ iso_stone2 texture{ clear } scale 2.5 rotate -6*x translate <-16,1,-29> }
    object{ iso_stone3 texture{ clear } scale 1.5 translate <.5,1,-29> }
    
#end

//////////// Puddles /////////////////////

cylinder{ <0,0,0> <0,1,0>, 9 texture{ puddle } translate <70,.4,77> }
cylinder{ <0,0,0> <0,1,0>, 9 texture{ puddle } translate <33,.4,37> }

//////////// Raindrops on gravestones ///

#if ( stone_drop_obj )
   object{ raindrop_patch(5,5,<-1,10,0>,<0,1,0>,1000,.02,.025,iso_stone3,851) scale 1.5 translate <.5,1,-29> }
   object{ raindrop_patch(5,5,<.1,10,0>,<0,1,0>,500,.02,.025,iso_stone2,851) scale 2.5 rotate -6*x translate <-16,1,-29> }
#end







