#version unofficial MegaPov 0.7;

#macro raindrop_patch(field_width,field_depth,field_center,targ,particle_count,scale_min,scale_max,obj,sd)

#local vect = targ - field_center;

#local S1 = seed(sd);

#local drop_num = 0;

union{

#while ( drop_num < particle_count )
  
  #local posx = field_center.x+field_width*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1))-field_width/2;
  #local posz = field_center.z+field_depth*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1))-field_depth/2;
  #local posy = field_center.y+field_depth*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1))-field_depth/2;
  
  #local dscale = (rand(S1)+.1*rand(S1))*(scale_max-scale_min)+scale_min;
  
  #local norm = <0,0,0>;

  #local pos = trace ( obj, <posx,posy,posz>, vect, norm );
  
  #if ( norm.y != 0 )

  sphere{ 
    <0,0,0> 1 
    scale dscale 
    translate pos
    texture{
      pigment{ color rgbf 1 }
      finish{ reflection .1 }
      }
    interior{ ior 1.5 }
    } 
  
  #end

  #local drop_num = drop_num + 1;

#end

}

#end


