#version unofficial MegaPov 0.7;

#include "tree.inc"

#macro woods_patch(field_width,field_depth,field_center,tree_count,scale_min,scale_max,obj,sd)

#local S1 = seed(sd);

#local tree_num = 0;

#while ( tree_num < tree_count )
  
  #local posx = field_center.x+field_width*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1))-field_width/2;
  #local posz = field_center.z+field_depth*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1))-field_depth/2;
  
  #local tscale = (rand(S1)+.1*rand(S1))*(scale_max-scale_min)+scale_min;
  
  #local norm = <0,0,0>;

  #local pos = trace ( obj, <posx,30,posz>, <0,-1,0>, norm );
  
  #if ( norm.y =! 0 )
  
  union{ 
    tree(9,<0,6,0>,<0,0,0>,.6,.935,bark_tex,leave_tex)
    scale tscale
    translate pos 
  }

  #end
  
  #local tree_num = tree_num + 1;

#end

#end





