// Persistence of Vision Ray Tracer Scene Description File
// File: 019e.pov
// Vers: 3.5
// Desc: Change the walls and door textures, change the mirror, and you have a better scene...
// Date: 2002.08.28-2002.08.29
// Auth: James Richard Skemp III (http://jrs_images.tripod.com/)
// Title: Room for Ahbo Part 6
// Title2: IRTC Loneliness: Ahbo's Seperation

#declare scale_size = 1.0; // Scale size for the room
#declare scale_size_a = 0.75; // scale size for Ahbo
#declare trans_clr = 0.01; // transmit color for the walls (set at 0 for complete walls, closer to 1 for invisible walls)
#declare corner_lt_clr = 0.50; // corner lights rgb value
#declare translate_jrs = <20, 9.5, 70>;
#declare rotate_jrs = <0, 0, 10>;
#declare scale_size_ah = 0.50;
#declare translate_ah = <27.5, 11.250, 70>;
#declare rotate_ah = <0, 0, 0>;



#declare sphere_light = sphere {
 <0, 0, 0>, 1
 pigment {
  color rgb 1
 }
}

camera {
 //location <57.0*scale_size, 42.5*scale_size, 77.0*scale_size> // default
 location <57.0*scale_size, 42.5*scale_size, 33.50*scale_size>
 sky <0, 1, 0> // default
 //look_at <30*scale_size, 16*scale_size, 40*scale_size> // default
 look_at <35*scale_size, 16*scale_size, 1*scale_size>
 //look_at <0.25, 40, 0.25> // test

}

/*light_source {
 <0, 500, 0>
 color rgb 1
}*/

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

//----------------------------------------------------

plane {
 y, -0.0001
 pigment {
  color rgb 0.75
  scale 0.25
 }
}         
// south wall
box {
 <0, 0, 0>, <60, 40, 0.5>
 pigment {
  gradient x*1
  color_map {
   [0.5 color rgb 0.502 transmit trans_clr]
   [1.0 color rgb 0.624 transmit trans_clr]
  }
 }
 scale scale_size
}
// west wall
box {
 <0, 0, 0>, <0.5, 40, 80>
 pigment {
  gradient z*1
  color_map {
   [0.5 color rgb 0.502 transmit trans_clr]
   [1.0 color rgb 0.624 transmit trans_clr]
  }
 }
 scale scale_size
}
// north wall
box {
 <0, 40, 80>, <60, 0, 79.5>
 pigment {
  gradient x*1
  color_map {
   [0.5 color rgb 0.502 transmit trans_clr]
   [1.0 color rgb 0.624 transmit trans_clr]
  }
 }
 scale scale_size
}
// east wall
box {
 <60, 40, 80>, <59.5, 0, 0>
 pigment {
  gradient z*1
  color_map {
   [0.5 color rgb 0.502 transmit trans_clr]
   [1.0 color rgb 0.624 transmit trans_clr]
  }
 }
 scale scale_size
}

// floor
box {
 <0, 0, 0>, <60, 0.5, 80>
 pigment {
  checker color rgb 0.525 color rgb 0.475
 }
 scale scale_size
}

// mirror for the south wall
box {
 <6.1, 16.1, 0.1>, <53.9, 38.9, 0.6>
 pigment {
  color rgb 1
 }
 finish {
  ambient 0
  diffuse 0
  reflection {
   1
   falloff 1.0
  }
 }
 scale scale_size
}
// light on the right of the mirror (southwest)
light_source {
 <0.75, 39.0, 0.75>
 color rgb corner_lt_clr
 looks_like { sphere_light }
 scale scale_size
}
// light on the left of the mirror (southeast)
light_source {
 <59.25, 39.0, 0.75>
 color rgb corner_lt_clr
 looks_like { sphere_light }
 scale scale_size
}
// light to the northwest
light_source {
 <0.75, 39.0, 79.25>
 color rgb corner_lt_clr
 looks_like { sphere_light }
 scale scale_size
}
// light to the northeast
light_source {
 <59.25, 39.0, 79.25>
 color rgb corner_lt_clr
 looks_like { sphere_light }
 scale scale_size
}


//--------------insert Ahbo---------------------

// open blob
blob {
 threshold 0.01
 sphere {
  <0, 10, 0>, 10, 1.0
  pigment {
   color rgb <0.624, 0.373, 0.624>
  }
 }
///* could be a nose
 sphere {
  <0, 10, -8.90>, 1.15, 1.0
  pigment {
   color rgb <0.624, 0.373, 0.624>
  }
 }
 sphere {
  <0.5, 9.5, -9.8>, 0.3, -5
  pigment {
   color rgb 0
  }
 }
 sphere {
  <-0.5, 9.5, -9.8>, 0.3, -5
  pigment {
   color rgb 0
  }
 }
//*/

// left eye - fully open
 sphere {
  <-2.0, 12.5, -8.0>, 1.75, -5.0
  pigment {
   color rgb <0, 0, 0>
  }
 }
// right eye - fully open
 sphere {
  <2.0, 12.5, -8.0>, 1.75, -5.0
  pigment {
   color rgb <0, 0, 0>
  }
 }
/* left nose
 sphere {
  <-0.80, 9.5, -8.90>, 0.75, -5.0
  pigment {
   color rgb <0, 0, 0>
  }
 }
*/
/* right nose
 sphere {
  <0.80, 9.5, -8.90>, 0.75, -5.0
  pigment {
   color rgb <0, 0, 0>
  }
 }
*/
/* right weird mouth
 cylinder {
  <-2.0, 7.35, -8.0> <3.0, 7.65, -8.9>, 0.75, -5.0
  pigment {
   color rgb 0
  }
 }
*/
/* right smaller weird mouth
 cylinder {
  <-2.0, 7.35, -7.5> <2.0, 7.65, -8.5>, 0.75, -5.0
  pigment {
   color rgb 0
  }
 }
*/
/* middle weird mouth
 cylinder {
  <-2.0, 7.35, -8> <2.0, 7.65, -10>, 0.75, -5
 }
*/
///* middle scared mouth open wide
 cylinder {
  <-2.0, 7.5, -8.0> <2.0, 7.5, -8.0>, 1.25, -5
 }
//*/
/* // middle scared mouth open wider
 cylinder {
  <-2.0, 7.5, -8.5> <2.0, 7.5, -8.5>, 1.25, -5
 }
*/
/* // mouth with corners that are raised (next 3)
 cylinder {
  <-2.0, 7.5, -8.75> <-2.2, 7.75, -8.75>, .85, -5
 }
 cylinder {
  <-2.0, 7.5, -8.75> <2.0, 7.5, -8.75>, .85, -5
 }
 cylinder {
  <2.0, 7.5, -8.75> <2.2, 7.75, -8.75>, .85, -5
 }
*/
 sturm
 scale scale_size_a
 translate translate_jrs
 rotate rotate_jrs
}
// close blob

//----------non-blob stuff--------------------------


// left eye cover, play with transmit to change visibility, 1=no cover
difference {
 sphere {
  <-2.0, 12.5, -8.0>, 1.75
  pigment {
   color rgbft <0.624, 0.373, 0.624, 0, 0.005>
  }
  scale scale_size_a
  translate translate_jrs
  rotate rotate_jrs
  hollow
 }
 //cylinder { <-3.1, 12.5, -9.85> <-0.9, 12.5, -9.85> 0.75 pigment { color rgbt 1 } scale scale_size} // larger slits w/ corners
 //cylinder { <-3.1, 12.5, -9.85> <-0.9, 12.5, -9.85> 0.5 pigment { color rgbt 1 } } // normal slits
 //cylinder { <-3.1, 12.75, -9.85> <-0.9, 12.25, -9.85> 0.5 pigment { color rgbt 1 } } // normal slits - high out, low in
 cylinder { <-3.1, 12.25, -9.85> <-0.9, 12.75, -9.85> 0.5 pigment { color rgbt 1 } scale scale_size_a translate translate_jrs rotate rotate_jrs} // normal slits - high in, low out

}

// right eye cover, play with transmit to change visibility, 1=no cover
difference {
 sphere {
  <2.0, 12.5, -8.0>, 1.75
  pigment {
   color rgbft <0.624, 0.373, 0.624, 0, 0.005>
  }
  scale scale_size_a
  translate translate_jrs
  rotate rotate_jrs
  hollow
 }
 //cylinder { <3.1, 12.5, -9.85> <0.9, 12.5, -9.85> 0.75 pigment { color rgbt 1 } scale scale_size} // larger slits w/ corners
 //cylinder { <3.1, 12.5, -9.85> <0.9, 12.5, -9.85> 0.5 pigment { color rgbt 1 } } // normal slits
 //cylinder { <3.1, 12.75, -9.85> <0.9, 12.25, -9.85> 0.5 pigment { color rgbt 1 } } // normal slits - high out, low in
 cylinder { <3.1, 12.25, -9.85> <0.9, 12.75, -9.85> 0.5 pigment { color rgbt 1 } scale scale_size_a translate translate_jrs rotate rotate_jrs} // normal slits - high in, low out

}

// left eye whites
sphere {
 <-2.0, 12.5, -7.0>, 1.75
 pigment {
  color rgb 1 transmit 0
 }
 finish {
  //ambient 0.25
 }
 scale scale_size_a
 translate translate_jrs
 rotate rotate_jrs
}

// right eye whites
sphere {
 <2.0, 12.5, -7.0>, 1.75
 pigment {
  color rgb 1 transmit 0
 }
 finish {
  //ambient 0.25
 }
 scale scale_size_a
 translate translate_jrs
 rotate rotate_jrs
}

// lt eye pigment...
light_source {<-2, 12.5, -9.1> color rgb 0.7}
sphere {
 <-2.0, 12.5, -8.1>, 0.75
 pigment {
  color rgb <0, 1, 0> transmit 0
 }
 finish {
  //ambient 0.15
  reflection {
   0.25
  }
 }
 scale scale_size_a
 translate translate_jrs
 rotate rotate_jrs
}

// rt eye pigment...
light_source {<2, 12.5, -9.1> color rgb 0.7}
sphere {
 <2.0, 12.5, -8.1>, 0.75
 pigment {
  color rgb <0, 1, 0> transmit 0
 }
 finish {
  //ambient 0.15
  reflection {
   0.25
  }
 }
 scale scale_size_a
 translate translate_jrs
 rotate rotate_jrs
}

// top teeth
box {
 <-3, 8.75, -8.24> <3, 7.70, -7.95>
 pigment {
  color rgb 0.92
 }
 finish {
  reflection {
   0.05
  }
 }
 scale scale_size_a
 translate translate_jrs
 rotate rotate_jrs
}

// bottom teeth
box {
 //<-3, 6.5, -8.25> <3, 7.30, -7.95> // with mouth with corners
 <-3, 6.37, -8.24> <3, 7.17, -7.95> // with 'middle scared mouth open wider'
 pigment {
  color rgb 0.92
 }
 finish {
  reflection {
   0.05
  }
 }
 scale scale_size_a
 translate translate_jrs
 rotate rotate_jrs
}


//---------------insert a 'table'-------------

union { // table
 box {
  <7.5, 17.5, 56> <42.5, 0.1, 58>
  pigment {
   color rgb 0.323
  }
 }
 box {
  <7.5, 17.5, 58> <9.5, 15.5, 69>
  pigment {
   color rgb 0.323
  }
 }
 box {
  <42.5, 0.1, 58> <40.5, 2.1, 69>
  pigment {
   color rgb 0.323
  }
 }
 box {
  <7.5, 0.1, 58> <9.5, 2.1, 69>
  pigment {
   color rgb 0.323
  }
 }
 box {
  <42.5, 17.5, 58> <40.5, 15.5, 69>
  pigment {
   color rgb 0.323
  }
 }
 scale scale_size
}
// 'body', temporary, for Ahbo
sphere {
 <17.5, 7.5, 68.5>, 10
 pigment {
  color rgb <0.624, 0.373, 0.624>
 }
}

//--------------------get a hand in there...------------

blob {
 threshold 0.25
 sphere {
  <-2, 5, 0>, 3.5, 1 // top left hand
 }
 sphere {
  <1, 5, 0>, 3.5, 1 // top right hand
 }
 sphere {
  <-1.75, 3, 0>, 3.25, 1 // middle left hand
 }
 sphere {
  <0.75, 3, 0>, 3.25, 1 // middle right hand
 }
 sphere {
  <0.65, 0.9, 0>, 3.25, 1 // bottom center hand
 }
 sphere {
  <0.0, 4, -3.5>, 2.4375, -5 // hand in grove... maybe remove
 }
 
 cylinder {
  <-2, 5, 0>, <-3.25, 8, 0>, 2.75, 1 // lower left finger
 }
 cylinder {
  <1, 5, 0>, <2.25, 8, 0>, 2.75, 1 // lower right finger
 }
 cylinder {
  <-3.25, 9, -3.25>, <-3.25, 9, 0>, 2.75, 1 // upper left finger
 }
 cylinder {
  <2.25, 9, -3.25>, <2.25, 9, 0>, 2.75, 1 // upper right finger
 } 
 cylinder {
  <0.65, 0.9, -0.5>, <1.15, -1.00, -0.5>, 2.75, 1 // upper lower finger
 }
 cylinder {
  <1.15, -1.2, -0.5>, <1.15, -1.2, -2.75>, 2.75, 1 // lower lower finger
 }
 pigment {
  color rgb <0.624, 0.373, 0.624>
 }
 scale scale_size_ah
 translate translate_ah
 rotate rotate_ah
}
// door
box {
 <0.4, 0.95, 25> <0.8, 39, 45>
 pigment {
  gradient <0, 0.25, 1>
  color_map {
   [0.5 color rgb 0.512 transmit trans_clr]
   [1.0 color rgb 0.644 transmit trans_clr]
  }
 }
 no_shadow
}
// light under the door
box {
 <0.4, 0, 25> <0.6, 0.94, 45>
 pigment {
  color rgb <0.785, 0.785, 0>
 }
 finish {
  ambient <0.785, 0.785, 0>
 }
 no_shadow
}

box {
 <0.44, 0, 25.0> <0.6, 19.4, 24.9>
 pigment {
  color rgb <0.785, 0.785, 0>
 }
 finish {
  ambient <0.785, 0.785, 0>
 }
 no_shadow
}

box {
 <0.4, 21.0, 25.0> <0.6, 38.9, 24.9>
 pigment {
  color rgb <0.785, 0.785, 0>
 }
 finish {
  ambient <0.785, 0.785, 0>
 }
 no_shadow
}

light_source {
 <30, 500, 40>
 color rgb 0.5
}

