// Persistence of Vision Ray Tracer Scene Description File
// File: LastEnem.pov
// Vers: Megapov 0.7
// Desc: Entry for IRTC - Theme: Loneliness
// Title: The Last Enemy
// Date: July-August 2002
// Auth: John Guthkelch (aka Doctor John)

#version unofficial Megapov 0.7;

global_settings {
  assumed_gamma 1.0
  adc_bailout 0.01
  max_trace_level 25
  }
 
#include "colors.inc"
#include "metals.inc"
#include "glass.inc"

camera { 
  location <0.0, 150.0, -320>
  look_at <0.0, 80.0, -100.0>
  }

//------Two suns - the second one is imaged using a glow; unfortunately Megapov 0.7
//------won't let me use a looks_like statement for a glow :-(  <mutter> <mumble> <winge> 

light_source {
  <-40, 450, -400>*4
  color rgb <1, 0.85, 0.95>*2
  shadowless
  //media_interaction off
  }
  
light_source {
  <-800, -100, 1500>*6
  color rgb <1.0, 1.0, 0>
  }

glow {
	type 0
	location <0, 0, 0>
  size 3000
	radius 11000
	fade_power 1.24
	color	rgb <0.65, 0.35, 0>
	translate <-800, -100, 1500>*6
	}

//-----The usual fog stuff to give a bit of distance perspective-----

fog {
  distance 200
  color rgbf<0.8, 0.1, 0.1, 0.3>
  fog_type 2
  fog_offset 0
  fog_alt 120
  turbulence 0.7
  }

//------The planet's surface------
    
#declare Planet_Mat = material {
  texture {
    pigment {
      granite
      color_map {
        [0.0 rgb 0.3 ]
        [1.0 rgb 0.7 ]
        }
      scale 0.01
      }
    normal  {
      granite 0.75 
      scale 0.01
      }
    }
  texture {
    pigment {
      wrinkles
      turbulence 0.3
      scale 0.04
      color_map {
        [0.0 rgbt< 0.50, 0.25, 0.10, 0.85>]
        [1.0 rgbt< 0.65, 0.40, 0.00, 0.65>]
        }
      }
    }
  }
 
height_field {
  png "planethf3.png"
  smooth
  material { 
    Planet_Mat
    } 
  scale <200,256,200>
  scale <2.0, 0.75, 2.0>
  translate <-200, -50.0, -450.0>
  }  

//------The Sky using a separate cloud sphere------

sky_sphere {
  pigment {
    gradient y
    color_map {
        [0.0 color rgb <0.4, 0.1, 0.0>]
        [1.0 color rgb <0.8, 0.0, 0.0>]
      }
    rotate x*45
    }
  }

union {
  sphere {
    <0, 80, -350>, 1000
    texture {
      finish {
        ambient 0
        diffuse 0.7
        }
      pigment {
        bozo
        turbulence 1.00
        translate 200*y
        color_map {
          [0.5, rgb 1 filter 0.6]
          [1.0, rgb 1 filter 0.9]
          }
        scale 0.125
        }
      scale 1500
      }
    }
  sphere {
    <0, 80, -350>, 1200
    }
  texture {
    finish {
      ambient 0
      diffuse 0.7
      }
    pigment {
      bozo
      turbulence 0.35
      translate 300*y
      color_map {
        [0.5, rgb 1 transmit 1.0]
        [0.8, rgb 1 transmit 0.5]
        }
      scale 10 
      warp {
        turbulence 0.7
        }
      scale 0.1
      scale 0.125
      }
    scale 2500
    }
  texture {
    finish {
      ambient 0
      diffuse 0.5
      }
    pigment {
      bozo
      turbulence 0.35
      translate 400*y
      color_map {
        [0.5, rgb 1 transmit 1.0]
        [0.8, rgb 1 transmit 0.4]
        }
      scale 10
      warp {
        turbulence 0.7
        }
      scale 0.1
      scale 0.125
      }
    scale 2500
    }
  hollow
  double_illuminate
  }
 
//------The moon using the moonmap image twice, once for colour and once for bumps------

sphere {
  <0, 0, 0>, 1
  pigment {
    image_map {
      png "moonmap.png"
      map_type 1
      }
    }
  normal {
    bump_map {
      png "moonmap.png" 
      map_type 1 
      interpolate 2
      }
    bump_size 30    
    }
  finish {
    ambient 0 //<1.0, 0.4, 0.4>
    }
  rotate y*120
  scale 300
  translate <450, 375, 1500>
  }

//------The starship and its necessary declarations------

#declare Ss_Scale = 1.25;  
#declare Ss_Rot = < 25, 140, -10>;
#declare Ss_Trans = < 7, 140, -270>;

#include "starship.inc"

object {
  Starship
  }
  
    