// ImageA42.pov for POV-Ray Megapatch 0.7 : The lonely (but happy) bush  (c) 2002 Ch. Gerber

#version unofficial MegaPov 0.7; 

#include "colors.inc"
#include "mytextures.inc"

#declare Softshadow_on = 0;
#declare Clouds_on     = 1;
#declare Foreground_on = 1;
#declare Background_on = 1;

global_settings {
   assumed_gamma 2.6
   max_trace_level 50
 //post_process {focal_blur {100,1000,3,0.5}}
   ini_option "+QR"
   radiosity {
      pretrace_start 0.08
      pretrace_end   0.01
      count 20
      nearest_count 5
      error_bound 0.4
      recursion_limit 1
      low_error_factor 0.5
      gray_threshold 1
      minimum_reuse 0.015
      brightness 1.5
      adc_bailout 0.006
      normal on
   }
}


camera {
   location <0, 15, -125>
   direction 1.2*z
   right 4/3*x
   look_at <0, 25, 0>
}

//--- Sun and Sky ---

#declare sun_color = color rgb 1.5*<1,0.8,0.6>;

light_source {
   -10000*z 
   color sun_color 
   #if (Softshadow_on=1)
    area_light <1500,0,0>, <0,1500,0>, 5, 5 
    jitter 
    adaptive 1
    orient
   #end
   rotate <40,45,0>  
}

#declare sky_color     = rgb <0.5,0.7,0.8>;
#declare clouds_height = 1000;
#declare plane_dist    = 8;
#declare textu_dist    = 8;
#declare cnt_planes    = 1;
#if (Clouds_on=1) #declare num_planes=30; #else #declare num_planes=3; #end

union{
   #while (cnt_planes<=num_planes)
      #declare p  = sky_color*0.4+Gray50*0.1+White*0.5;
      #declare p1 = p*(1-(cnt_planes/num_planes))+White*(cnt_planes/num_planes);
      #declare p2 = p*0.9*(1-(cnt_planes/num_planes))+White*0.9*(cnt_planes/num_planes);
      plane {
         y,0 hollow
         texture {
            pigment {
               granite
               octaves 9
               lambda 3
               turbulence 4
               color_map {
                  [0.0 Clear]
                  [0.3 Clear]
                  [0.4 p1 filter 0.7+0.1*(cnt_planes/num_planes)]
                  [1.0 p2 filter 0.7+0.1*(cnt_planes/num_planes)]
               }
               scale 300000
            }
            finish {ambient 1.2/1.5*sun_color diffuse 0.12}
            translate (clouds_height+textu_dist*cnt_planes)*y
         }
         no_shadow
         translate (clouds_height+plane_dist*cnt_planes)*y
      }
      #declare cnt_planes=cnt_planes+1;
   #end
   translate 4000*z
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.5,0.7,0.8>]
      [0.2 rgb <0.5,0.7,0.8>]
      [0.6 rgb <0.2,0.2,0.8>]
    }
  }    
}

fog {
   fog_type 2
   color rgb <0.901, 0.875,0.788>
   distance 5000
   fog_alt 500
   fog_offset 1
}

plane {y, -15 hollow texture {GroundTex}}


//--- Foreground Rocks and Bush ---

#if (Foreground_on = 1)

#declare Leaf = object {#include "leaf.inc"}
#declare Foilage = object {#include "foilage.inc" texture {LeafTex}}
#declare Stem = object {#include "bush.inc"}
#declare Bush = union {
   object {Stem}
   object {Foilage}
}

#declare Branch = object {#include "branch.inc"}
    
#declare BigRock = object {
   height_field {tga "Stone_Hf.tga" smooth translate <-0.5, 0, -0.5>}
   scale <200, 20, 200> 
   translate -15*y
   texture {MossyStoneTex}
}

#declare Stone_1 = object {#declare Seed = 317; #declare Splits = 3; #declare Rough = 0.3; #include "rock.inc" scale <2.4,1.1,2.4> translate 11.0*y texture {StoneTex}} 
#declare Stone_2 = object {#declare Seed = 248; #declare Splits = 3; #declare Rough = 0.3; #include "rock.inc" scale <0.8,0.5,0.8> translate  5.0*y texture {StoneTex}} 
#declare Stone_3 = object {#declare Seed = 666; #declare Splits = 3; #declare Rough = 0.3; #include "rock.inc" scale <0.4,0.3,0.4> translate  3.0*y texture {StoneTex}} 
#declare Stone_4 = object {#declare Seed = 509; #declare Splits = 3; #declare Rough = 0.3; #include "rock.inc" scale <0.3,0.2,0.3> translate  1.3*y texture {StoneTex}} 

#macro obj_pos(obj_x,obj_z) 
   (trace(BigRock,<obj_x,50,obj_z>,<0,-1,0>))
#end  

object {BigRock}
object {Bush scale 1.2 translate <1.5,4.0,-10>}
object {Stone_1 translate obj_pos(68, 30)}
object {Stone_2 translate obj_pos(65, 10)}
object {Stone_3 translate obj_pos(50,  0)}
object {Stone_4 translate obj_pos(15,-55)}
object {Stone_4 rotate 60*y translate obj_pos(-35,-10)}
object {Branch scale 0.6 rotate <-95.5,30,0> translate obj_pos(-10,-35)+0.4*y} 

#include "Lizard.inc"

object {Lizard scale <-20,20,20> rotate 105*y rotate -9*x translate obj_pos(-5,-60)+0.1*y}

#end


//--- Background Hills and Forest ---

#if (Background_on = 1)

#include "PineMesh.inc"

#declare VegeObject = object {
   height_field {
      tga "Hills_Hf.tga"
      scale <5000, 625, 5000>
      texture {
         slope y
         texture_map {
            [0.0  RockTex]
            [0.8  RockTex]
            [0.95 GroundTex]
            [1.0  GroundTex]
         }
      }
   }
   translate <-2500, 0, 100>
}

#declare Pine01 = union {
   object {BranchesIteration1 uv_mapping texture {PineTrunkTex} no_shadow}
   object {BranchesIteration2 texture {PineTrunkTexPlain} no_shadow}
   object {BranchesIteration3 texture {PineTrunkTexPlain} no_shadow}
   object {Leaves uv_mapping  texture {PineLeafTex} double_illuminate}
}

#declare Pine02 = union {
   object {BranchesIteration1 uv_mapping texture {PineTrunkTex} no_shadow}
   object {BranchesIteration2 texture {PineTrunkTexPlain} no_shadow}
   object {BranchesIteration3 texture {PineTrunkTexPlain} no_shadow}
   object {Leaves uv_mapping  texture {PineLeafTex finish {ambient <0.3,0.15,0.15>}} double_illuminate}
}

#declare VegeList = array[3] 
#declare VegeList[0] = object {Pine01 scale 20}
#declare VegeList[1] = object {Pine01 scale 20}
#declare VegeList[2] = object {Pine02 scale 20}
#declare VegeSeed = seed(1968);
#declare VegeNumber = 15000;
#declare VegeWaterLevel = 0;
#declare VegeTimberLine = 400;
#declare VegeMaxSlope = 55;
#declare VegeMaxScale = 1.3; 
#declare VegeMinScale = 0.7;
#declare VegeTypesGauss = off;
#declare VegeAlign = off;    

union {
   #include "vegetate.inc"
   object {VegeObject}
   translate -15*y
}

#undef VegeMinBox
#undef VegeMaxBox
#declare VegeSeed = seed (2002);
#declare VegeNumber = 20;
#declare VegeObject = box {<-200,0,60>,<200,-1,100>}

union {#include "vegetate.inc" translate -15*y}
object {Pine01 scale 27 translate <-70,-15,55>}

height_field {
   tga "Mountain_Hf.tga"
   texture {
      slope y, y
      texture_map {
         [0.50 MossTex scale <0.0001,0.001,0.0001>]
         [0.55 RockTex scale <0.0001,0.001,0.0001>]
         [0.65 RockTex scale <0.0001,0.001,0.0001>]
         [0.75 SnowTex scale <0.0001,0.001,0.0001>]
         [1.00 SnowTex scale <0.0001,0.001,0.0001>]
      }
   }
   scale <12000,1000,12000>
   translate <-5000,-15,5100>     
}

#include "bird.inc"
object {Bird rotate <30, 150, 10> translate <-120, 235, 550>}    
object {Bird rotate <10, 120,  5> translate <-170, 185, 500>} 

#end
