#version unofficial MegaPov 0.7;

#declare Dummy = texture {pigment {rgb 1} finish {ambient 0.2 diffuse 0.8}} 

#declare StoneTex = texture {
  pigment {
    crackle 
    color_map {
      [0    rgb <0.80,0.6,0.40>]
      [0.25 rgb <0.80,0.8,0.65>]
      [0.5  rgb 1]
      [0.75 rgb <0.99,0.9,0.7>]
      [1    rgb <0.99,0.8,0.6>]
    }
    scale 0.5
    solid
  }                                                         
  normal {granite 3 scallop_wave scale 0.025}
  finish {ambient 0.0 diffuse 0.65 brilliance 3}
}
texture {
  pigment {
    crackle 
    color_map {
      [0    rgbt 1]
      [0.25 rgb <0.80,0.9,0.5>]
      [0.5  rgbt 1]
      [0.75 rgb <0.99,0.9,0.7>]
      [1    rgbt 1]
    }
    scale 0.15
    solid
  }  
  normal {
    bozo 
    normal_map { 
      [0   bozo 1.5 scallop_wave scale  2]
      [0.2 bozo 6.0 scallop_wave scale  6]
      [0.9 bozo 7.5 scallop_wave scale  1]
      [1   bozo 3.0 scallop_wave scale 12]
    }
    turbulence 0.3
  }
  finish {specular 0.125 ambient 0.0 diffuse 0.7 crand 0.125 brilliance 2} 
}

#declare MossTex = texture {
  pigment {
    bozo
    color_map {
      [0.00 color rgb <0.400, 0.612, 0.247>]
      [0.12 color rgb <0.645, 0.800, 0.325>]
      [0.32 color rgb <0.220, 0.522, 0.067>]
      [0.49 color rgb <0.757, 0.961, 0.600>]
      [0.59 color rgb <0.392, 0.894, 0.298>]
      [0.80 color rgb <0.318, 0.612, 0.051>]
      [1.00 color rgb <0.620, 0.867, 0.455>]
    }
    scale 0.025
  }
  finish {ambient 0.0 diffuse 0.55}
}
texture {
  pigment {
    agate
    agate_turb 0.8
    color_map {
      [0.00 color rgbf <0.980, 0.991, 0.729, 0.761>]
      [0.22 color rgbf <0.761, 0.857, 0.580, 0.278>]
      [0.50 color rgbf <0.792, 0.837, 0.604, 0.098>]
      [0.64 color rgbf <0.298, 0.861, 0.329, 0.761>]
      [0.79 color rgbf <0.557, 0.775, 0.251, 0.506>]
      [0.87 color rgbf <0.302, 0.590, 0.204, 0.694>]
      [1.00 color rgbf <1.000, 1.000, 1.000, 0.365>]
    }
    scale 0.05
  }
  finish {ambient 0.0 diffuse 0.55 crand 0.1}
}

#declare MossyStoneTex = texture {
  bozo
  turbulence 0.5
  texture_map {
    [0.0 StoneTex]
    [0.6 StoneTex]
    [1.0 MossTex scale 0.01]
  }
  scale 25
  warp {reset_children}
}

#macro m_strata (freq, amnt)
  function {noise3d(y*freq+noise3d(y+noise3d(x*4,y*4,z*4),z,x)*amnt,0,0)}
#end

#declare Rock_L1 = texture {
  pigment {
    m_strata (20, 1)
    turbulence 0.5
    color_map {
      [0.00 0.29 color Gray80 color Gray85]
      [0.29 0.31 color Gray85 color Gray80]
      [0.31 0.43 color Gray80 color White ]
      [0.43 0.64 color White  color Gray80]
      [0.64 0.69 color Gray80 color Gray95]
      [0.69 1.00 color Gray95 color Gray80]
    }
    scale 4
  }
  finish {ambient 0.0 diffuse 0.5 brilliance 3}
  normal {crackle 0.75 turbulence 0.5}
  rotate 10*z scale 2
}

#declare Rock_L2 = texture {
  pigment {
    crackle
    turbulence 0.5
    solid
    color_map {
      [0.0 color rgbf <0.9, 0.8, 0.8, 0.6>]
      [0.2 color Gray85 filter 0.6]
      [0.4 color Gray75 filter 0.6]
      [0.6 color White  filter 0.6]
      [1.0 color rgbf <0.9, 0.8, 0.7, 0.6>]
    }
  }
  finish {ambient 0.0 diffuse 0.55 specular 0.125 brilliance 2}
  normal {crackle 0.75 turbulence 0.5}
  scale <6,18,6>
}

#declare RockTex = texture {Rock_L1 scale 5} texture {Rock_L2 scale 5}

#declare Ground_L1 = texture {
  pigment {
    crackle 
    turbulence 0.25 
    scale 0.01 
    pigment_map {
      [0.0 MediumForestGreen]
      [0.5 MediumWood]
      [1.0 DarkWood]
    }
  }
//normal {crackle turbulence 0.25 scale 0.01}
  finish {ambient 0.0 diffuse 0.6}
}

#declare Ground_L2 = texture {
  pigment {rgb <0.4,0.3,0.0>}
//normal {average normal_map {[bozo scale 0.1][agate scale 0.1]}}
  finish {ambient 0.0 diffuse 0.6}
}

#declare Ground_L3 = texture {
  wrinkles 
  turbulence 0.25 
  scale 0.2
  texture_map{
    [0.50 Ground_L2]
    [0.55 Ground_L1]
  }
}

#declare Ground_L4 = texture{
  gradient y
  texture_map {
    [0.5 Ground_L3]
    [1.0 Ground_L1]
  }
}

#declare GroundTex = texture {
  wrinkles 
  turbulence 0.25 
  scale 0.2
  texture_map {
    [0.50 Ground_L4]
    [0.60 Ground_L1]
  }
}  

#declare SnowTex = texture {
  pigment {
    bozo
    turbulence 0.2
    color_map {
      [0.00 0.90 color rgb <1.0, 1.0, 1.0> color rgb <0.9, 0.9, 1.0>]
      [0.90 0.99 color rgb <0.9, 0.9, 1.0> color rgb <0.9, 1.0, 0.9>]
      [0.99 1.00 color rgb <0.9, 1.0, 0.9> color rgb <1.0, 1.0, 1.0>]
    }
  }
  finish {diffuse 0.8 specular 0.3 roughness 0.1 brilliance 2}
}

#declare BarkCol = rgb <1,0.8,0.64>;
#declare LeafCol = rgb <0.65,0.8,0.3>*0.7;
#declare Clear = rgbf <1,1,1,1>;

#declare BarkTex = texture { 
  pigment {
    gradient y
    turbulence 0.7 
    lambda 4 
    color_map {
      [0   color BarkCol*0.3] 
      [0.1 color BarkCol]
      [0.9 color BarkCol]
      [1   color BarkCol*0.4]
    }
  }
  finish {ambient 0.2 diffuse 0.9}
}
texture {
  pigment {
    bozo 
    turbulence 0.7 
    lambda 4 
    color_map {
      [0   color BarkCol*0.2]
      [0.1 color BarkCol*0.3] 
      [0.3 color BarkCol*0.4]
      [0.4 color Clear]
      [0.9 color Clear]
      [1   color BarkCol*0.4]
    }
  }
  finish {ambient 0.2 diffuse 0.9}
}

#declare LeafTex = texture {
  pigment {LeafCol} 
  finish {ambient 0.2 diffuse 0.9 specular 0.3 roughness 0.01}
}

#declare LizardSkinTex = texture {
  pigment {image_map {sys "LizardTex.bmp" interpolate 2}}
  normal{bump_map {sys "LizardBump.bmp" bump_size 1 interpolate 2}}
  finish {ambient 0.0 diffuse 0.7 phong 0.2 phong_size 10}
}

#declare PineTrunkTex = texture {
  pigment {image_map {png "PineBark.png" map_type 0 interpolate 2}}
  normal {granite 0.81 scale 0.04}
  finish {ambient 0.2 diffuse 0.9 phong 0.1 phong_size 150}
}

#declare PineLeafTex = texture {
  pigment {image_map {png "PineSpruceLeaf.png" map_type 0 interpolate 2}}
  finish {ambient 0.2 diffuse 0.9 phong 0.05 phong_size 150}
}

#declare PineTrunkTexPlain = texture {
  pigment {color rgb <0.392,0.365,0.251>}
  finish {ambient 0.2 diffuse 0.9 phong 0.1 phong_size 150}
}

#declare PineLeafTexPlain = texture {
  pigment {color rgb <0.482,0.447,0.255>}
  finish {ambient 0.2 diffuse 0.9 phong 0.05 phong_size 150}
}


