/* $Id: candle.pov,v 1.3 2002/08/26 19:33:33 ziotom Exp $ */

/***********************************************************************
 * The "Candle" and "CandleLight" macros. These macros will create a
 * "candle" with base at <0, 0, 0> and a given height (the height refers
 * to the body: the flame is not counted, and it is always FLAMEHEIGHT
 * tall), and the light associated with it. The CandleLight requires you
 * specify the position of the *base* of the candle (not the position
 * of the light itself!). These two macros should be called always
 * together, as in the following example:
 *
 * #local CandlePos = <0.5, 0, 0>;
 * #local CandleTr = transform { translate CandlePos }
 * object { Candle(0.7) transform { CandleTr } }
 * CandleLight(CandleTr, 0.7)
 ***********************************************************************/

#declare Candle_FlameHeight = 0.35;
#declare Candle_Radius = 0.05;
#declare Candle_FlameColor = color rgb <0.89, 0.89, 0.63>;

#declare Candle_Flame =
object {
	Piriform

	pigment { color <1, 0, 0> * 5 transmit 1 }

	hollow
	no_shadow
	no_reflection

	interior {
		media {
			emission rgb <1, 0.4, 0.4>
		}
	}

	rotate -90*z
	scale <0.1, Candle_FlameHeight, 0.1>

	no_shadow
}

#declare Candle_Body =
cylinder {
	<0, 0, 0>, <0, 1, 0>, Candle_Radius
	pigment { color rgb <0.90, 0.86, 0.64> * 1.5 }
}


#declare Candle_Brightness = 2;

#declare Candle_LightSphere =
sphere {
	<0, 0, 0>, 1

	pigment { color White transmit 1 }

	hollow
	no_shadow
	no_reflection

	interior {
		media {
			emission rgb 1 * Candle_Brightness

			density {
				spherical
				color_map {
					[0 rgb 0]
					[0.2 rgb <0, 0, 0.2>]
					[0.4 rgb <0.5, 0.4, 0.3>]
					[0.6 rgb <0.8, 0.8, 0.4>]
					[1.0 color Candle_FlameColor]
				}
			}

			scale 0.6
		}
	}
}

#macro Candle(height)
union {
	object {
		Candle_Body
		scale <1.0, height, 1.0>
	}

	object { Candle_Flame
		translate <0, (height + Candle_FlameHeight), 0>
	}

	object {
		Candle_LightSphere
		translate <0, height + Candle_FlameHeight / 2, 0>
	}
}
#end

#macro CandleLight(transformation, height)
light_source {
	<0, height + Candle_FlameHeight / 2, 0>
	color Candle_FlameColor * 0.05

	// Quadratic fading is, physically speaking, the most
	// accurate type of light falloff.
	fade_power 2
	fade_distance 6

	transform { transformation }
#ifdef (USE_MEDIA)
	media_interaction off
#end
}
#end

