/* $Id: church.pov,v 1.12 2002/08/26 20:59:38 ziotom Exp $ */

#version 3.5;

// Comment some of these to speed up rendering a
// bit...
#declare USE_WALLS = 1;
#declare USE_ALTAR = 1;
#declare USE_ARCHES = 1;
#declare USE_BENCHES = 1;
#declare USE_WINDOWS = 1;
#declare USE_GIRL = 1;
#declare USE_CANDLESTICK = 1;
#declare USE_CANDLES = 1;
#declare USE_BALCONY = 1;
#declare USE_VASES = 1;

// ...but comment *these* if you really want to go fast!
// (especially USE_MEDIA)
#declare USE_RADIOSITY = 1;
#declare USE_MEDIA = 1;

// Better not to use it. It produces poor scattering
// (but it is three times faster than the default setting!)
//#declare USE_QUICK_MEDIA = 1;

// Uncomment this to use a single, parallel light
// Faster, but the shadows have sharper edges
//#declare PARALLEL_LIGHTING = 1;

// Uncomment this to have a brighter scene.
// WARNING: The result is not realistic. Use radiosity instead.
// #declare ENLIGHTEN_SCENE = 1;

#declare IMPORT_SPATCH = 1;
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "woods.inc"
#include "shapes.inc"
#include "shapesq.inc"

#ifdef (USE_GIRL)
#include "kneeling-stool.pov"
#include "pray.pov"
#end

#declare ChurchHeight = 36;

#declare WallColor = <1, 1, 0.9>;

#declare WallTexture =
texture {
	pigment { color rgb WallColor quick_color WallColor }

	normal {
		wrinkles 1
		frequency 0.1
		noise_generator 3
		normal_map {
			[0.0 granite .5 scale 1.5]
			[0.5 agate .5 turbulence 1 scale 0.8]
			[1.0 agate .5 turbulence 1 scale 0.8]
		}
		scale 0.5
	}	
}
texture {
	pigment {
		bozo
		pigment_map {
			[0.00 color rgbt <1, 1, 1, 1>]
			[0.30 color rgb WallColor*0.85 filter 1]
			[0.40 color rgbt <1, 1, 1, 1>]
			[1.00 color rgbt <1, 1, 1, 1>]
		}
		scale 0.5
	}

	normal { granite bump_size 0.1 turbulence 0.01 }
}

#declare LittleColumnTexture = texture {
	pigment { color rgb WallColor * 0.85 }
}

#declare AltarStepTexture = texture {
	T_Grnt16
	pigment {
		quick_color Green
	}
}

#ifdef (USE_BALCONY)
#declare BalconyColumnTexture =
texture { T_Grnt25 rotate (z + 0.5 * x) * 30 scale 0.3 }

#declare BalconyBarTexture =
texture { T_Grnt26 rotate (z + 0.5 * x) * 30 scale 0.3 }
#end

#ifdef (USE_ARCHES)
#include "arch.pov"
#include "arches.pov"
#end

#ifdef (USE_BENCHES)
#include "church-bench.pov"
#include "benches.pov"
#end

#include "floor.pov"
#include "window.pov"

#ifdef (USE_ALTAR)
#include "altar-piece.pov"
#end

#ifdef (USE_CANDLESTICK)
#include "candlestick.pov"
#end

#ifdef (USE_CANDLES)
#include "candle.pov"
#end

#ifdef (USE_BALCONY)
#include "balccol.pov"
#end

#ifdef (USE_VASES)
#include "vase.pov"
#end

/***********************************************************************/
/* Camera and light sources */
/***********************************************************************/

#declare CameraTilt = 2.0;

camera {
	location <26, 3, 9.15 - CameraTilt>
	look_at <0, 6, 9.15>
	up y
	right x * (450 / 600)
}

#declare ParallelLightSource = <-9.25, 44, -6.55>;

light_source {
#ifdef (USE_WINDOWS)
	// If there are windows, we have to use brighter light sources
	ParallelLightSource color rgb <1, 1, 0.8> * 6
#else
	ParallelLightSource color rgb <1, 1, 0.8> * 2
#end

#ifdef (PARALLEL_LIGHT)
	parallel
	point_at (ParallelLightSource + <6.12, -24.00, 7.85>)
#else
	area_light <.567, .382, .729> * 4, <-.789, 0, .614> * 4, 3, 3
	adaptive 1
	jitter
#end
	
#ifdef (USE_MEDIA)
        media_interaction on
#end
}


#ifdef (ENLIGHTEN_SCENE)

/* These light sources are used only to lighten the scene. */

light_source {
	<4.92, 1, 5.00> color rgb <1, 1, 0.8> * 0.15
	shadowless

#ifdef (USE_MEDIA)
        media_interaction off
#end	
}

light_source {
	<26, 10, 4.00> color rgb <1, 1, 0.8> * 0.15
	shadowless

#ifdef (USE_MEDIA)
	media_interaction off
#end
}


light_source {
	<-5, 10, 9.15> color rgb <1, 1, 0.8> * 0.15
	shadowless

#ifdef (USE_MEDIA)
	media_interaction off
#end
}
#end /* ENLIGHTEN_SCENE */

/***********************************************************************/
/* Global settings */
/***********************************************************************/

global_settings {

#ifdef (USE_RADIOSITY)
	radiosity {
#ifdef (USE_MEDIA)
		media on
#end /* USE_MEDIA */
		brightness 0.5
	}
#end /* USE_RADIOSITY */

	max_trace_level 10
}


/***********************************************************************/
/* A sky sphere. */
/***********************************************************************/

sky_sphere {
	pigment { color <0.8, 0.85, 1> }
}

/***********************************************************************/
/* The dust */
/***********************************************************************/

#ifdef (USE_MEDIA)

#declare Dust =
interior {
	media {
		scattering { 3, rgb 0.15 extinction 0.0 }

#ifdef (USE_QUICK_MEDIA)		
		method 3
		intervals 1

		jitter 1
		samples 3, 3
		aa_level 3
		aa_threshold 0.3
#else
		method 2

		intervals 25
		samples 1, 5
#end
	}
}

box {
        <-11.1, 0, 1.3>, <5, ChurchHeight, 17>
	pigment { color White transmit 1 }
        interior { Dust }
	
	hollow
	no_shadow
}

#end /* USE_MEDIA */

/***********************************************************************/
/* Windows */
/***********************************************************************/

#declare WindowHeight = 22;

#declare WindowTransformation = array[5]

#declare WindowTransformation[0] =
transform {
	scale <12, WindowHeight, 1.2>
	rotate 90*y
	translate <-11.1 - 0.5, 4.0, 9.15>
}

#declare WindowTransformation[1] =
transform {
	scale <14, WindowHeight, 1.2>
	rotate -45*y
	translate <-8.8, 4.0, 14.7>
}

#declare WindowTransformation[2] =
transform {
	scale <14, WindowHeight, 1.2>
	rotate 45*y
	translate <-8.8, 4.0, 3.6>
}

#declare WindowTransformation[3] =
transform {
	scale <14, WindowHeight, 3>
	translate <-6.5/2, 4.0, 1.3>
}

#declare WindowTransformation[4] =
transform {
	scale <14, WindowHeight, 3>
	translate <-6.5/2, 4.0, 17>
}

#declare Windows =
union {

	#declare Count = 0;
	#while (Count < 5)
		object {
			Window
			transform { WindowTransformation[Count] }
		}
		#declare Count = Count + 1;
	#end

	pigment { color rgb WallColor }
}

#ifdef (USE_WINDOWS)

#declare WindowGlassFileName = array[5]

#declare WindowGlassFileName[0] = "window3.jpg"
#declare WindowGlassFileName[1] = "window2.jpg"
#declare WindowGlassFileName[2] = "window4.jpg"
#declare WindowGlassFileName[3] = "window1.jpg"
#declare WindowGlassFileName[4] = "window5.jpg"

#declare WindowGlass =
object {
	box { <-0.125, 0, -0.5>, <0.125, 1, 0.5> }
	scale <1.0, 1.0, 0.01>
}

union {
	#declare Count = 0;
	#while (Count < 5)
		object {
			WindowGlass

			pigment {
				image_map {
					jpeg WindowGlassFileName[Count]
					filter all 0.15
					transmit all 0.35
					interpolate 2
				}

				scale <0.25, 1.0, 1.0>
				translate <-0.125, 0, 0>
			}

			finish {
				ambient 1
				diffuse 0
			}

			transform { WindowTransformation[Count] }

			double_illuminate
		}
		#declare Count = Count + 1;
	#end
}

#end /* USE_WINDOWS */


/***********************************************************************/
/* Church (interior) */
/***********************************************************************/

#ifdef (USE_WALLS)

#declare Octagon =
union {
	box { <-6.5, 0, 1.3 - 1>, <0, 1, 1.3> }

	box { <-6.5, 0, 17.0>, <0, 1, 17.0 + 1> }

	object {
		box { <-6.5/2, 0, -1/2>, <6.5/2, 1, 1/2> }
		rotate 45*y
		translate <-8.8, 0, 3.6>
	}

	object {
		box { <-6.5/2, 0, -1/2>, <6.5/2, 1, 1/2> }
		rotate -45*y
		translate <-8.8, 0, 14.7>
	}

	box { <-11.1 - 1, 0, 5.9>, <-11.1, 1, 12.4> }
}

#declare Aisle =
union {
	/* Walls */

	box { <0, 0, -15 - 1>, <40, 1, -15> }
	box { <30, 0, -15>, <30 + 1, 1, 40> }
	box { <-1, 0, 40>, <30 + 1, 1, 40 + 1> }

	box { <-1, 0, -15>, <1, 1, 1.3> }
	box { <-1, 0, 17>, <1, 1, 40> }

	/* Roof */

	box { <0, 1, -15 - 1>, <30 + 1, 1, 40> }
}


#declare churchSpace =
union {
	object { Aisle scale <1.0, ChurchHeight, 1.0> }
	object { Octagon scale <1.0, ChurchHeight, 1.0> }
}

difference {
	object {
		churchSpace
		texture { WallTexture }
		finish { diffuse 0.65 ambient 0 }
	}

	object { Windows }
}

#end /* USE_WALLS */


/***********************************************************************/
/* Octagon steps */
/***********************************************************************/

#declare OctagonalStepHeight = 0.2;

#declare OctagonalStep =
prism {
	linear_spline
	0, 1, 9,
	<1.5, 12.4>, <1.5, 5.9>, <0, 1.3>,
	<-6.5, 1.3>, <-11.1, 5.9>, <-11.1, 12.4>,
	<-6.5, 17>, <0, 17>, <1.5, 12.4>
}

object {
	OctagonalStep
	scale <1.0, OctagonalStepHeight, 1.0>
	translate <0, OctagonalStepHeight, 0>
	texture { AltarStepTexture }
	finish { diffuse 0.65 ambient 0 }
}

object {
	OctagonalStep
	scale <1.0, OctagonalStepHeight, 1.0>
	translate <-OctagonalStepHeight, OctagonalStepHeight * 2, 0>
	texture { AltarStepTexture }
	finish { diffuse 0.65 ambient 0 }
}

object {
	OctagonalStep	
	scale <1.0, OctagonalStepHeight, 1.0>
	translate <-OctagonalStepHeight * 2, OctagonalStepHeight * 3, 0>
	texture { AltarStepTexture }
	finish { diffuse 0.65 ambient 0 }
}

object {
	OctagonalStep
	translate <0, ChurchHeight, 0>

	texture { AltarStepTexture }
	finish { diffuse 0.65 ambient 0 }
}

/***********************************************************************/
/* The praying girl */
/***********************************************************************/

#ifdef (USE_GIRL)

#declare Girl =
union {
	object {
		GirlBody
		pigment { image_map { png "zigzag.png" } }
		finish { diffuse 0.65 ambient 0 }
	}

	object {
		GirlArms
		pigment { color rgb <1.00, 0.73, 0.73> }
		finish { diffuse 0.65 ambient 0 }
	}

	object {
		GirlHead
		pigment { color rgb <1.00, 0.73, 0.73> }
		finish { diffuse 0.65 ambient 0 }
	}

	object {
		GirlHair
		pigment { color rgb 0.1 }
		finish { diffuse 0.65 ambient 0 }
	}
}

object {
	Girl
	rotate y*90
	scale <0.5, 0.5, 0.5>
	translate <3, 1.15, 9.15>
}

#end /* USE_GIRL */


/***********************************************************************/
/* Little columns (under the arches) */
/**********************************************************************/

#ifdef (USE_ARCHES)
#declare LittleColumn =
union {
	cylinder {
		<0, 0, 0>, <0, 2, 0>, 0.15
	}

	box {
		<-0.2, 1.8, -0.2>, <0.2, 2, 0.2>
	}

	texture { LittleColumnTexture }
	finish { diffuse 0.65 ambient 0 }
}

object { LittleColumn translate <-11.1, 0, 9.15> }

object { LittleColumn rotate -45*y translate <-8.8 + 0.3, 0, 14.7 - 0.3> }
object { LittleColumn rotate -45*y translate <-8.8 + 0.3, 0, 3.6 + 0.3> }

object { LittleColumn translate <-0.4 - (6.5 - 0.4)/3, 0, 1.3> }
object { LittleColumn translate <-0.4 - 2*(6.5 - 0.4)/3, 0, 1.3> }

object { LittleColumn translate <-0.4 - (6.5 - 0.4)/3, 0, 17> }
object { LittleColumn translate <-0.4 - 2*(6.5 - 0.4)/3, 0, 17> }

#end /* USE_ARCHES */


/***********************************************************************/
/* Medium-sized columns (edges of two adjacent walls) */
/***********************************************************************/

#declare Column =
cylinder {
	<0, 0, 0>, <0, ChurchHeight, 0>, 0.5
	texture { WallTexture }
	finish { diffuse 0.65 ambient 0 }
}

object { Column translate <0 + sqrt(2) * 0.3, 0, 17 + 0.1> }
object { Column translate <0 + sqrt(2) * 0.3, 0, 1.3 - 0.1> }
object { Column translate <-6.5, 0, 1.3 + sqrt(2) * 0.3> }
object { Column translate <-6.5, 0, 17 - sqrt(2) * 0.3> }
object { Column translate <-11.1 + 0.3, 0, 5.9 + 0.3> }
object { Column translate <-11.1 + 0.3, 0, 12.4 - 0.3> }

//object { Column translate <0, 0, 17 + 11.24> }
//object { Column translate <0, 0, 1.3 - 11.24> }

/***********************************************************************/
/* Altar piece */
/***********************************************************************/

#ifdef (USE_ALTAR)
object {
	Altar
	scale <4, 3, 4>
	translate <-5, OctagonalStepHeight * 3, 9.15>
}
#end

/***********************************************************************/
/* Candlestick */
/***********************************************************************/

#ifdef (USE_CANDLESTICK)

object {
	Candlestick
	scale <2, 1, 1.5>
	rotate (-90 + 23.5)*y
	translate <3, 0, 3.6>
}

object {
	Candlestick
	scale <2, 1, 1.5>
	rotate (-90 - 23.5)*y
	translate <3, 0, 14.7>
}

#end


/***********************************************************************/
/* Candles */
/***********************************************************************/

#ifdef (USE_CANDLES)

#macro CreateSetOfCandles(NumOfCandles, Angle, Width)
	#local Count = 0;

	#while (Count < NumOfCandles)
		#local Displacement =
			z * ((Count / (NumOfCandles - 1) - 1/2) * Width);
		#local CandleHeight = rand(Stream);
	
		#local Transformation = transform {
			translate Displacement
			rotate y*Angle
			translate CandleBasePos
		}

		object {
			Candle(0.25 + 0.75 * CandleHeight)
	
			scale 0.5
			transform { Transformation }
		}
	
		CandleLight (Transformation, CandleHeight)
		#declare Count = Count + 1;
	#end
#end

#declare CandleBasePos = <3, 1, 3.6>;
#declare Stream = seed(12);
CreateSetOfCandles(5, 23.5, 1)

#declare CandleBasePos = <3, 1, 14.7>;
#declare Stream = seed(12);
CreateSetOfCandles(5, -23.5, 1.2)

#end /* USE_CANDLES */


/***********************************************************************/
/* Vases with flowers */
/***********************************************************************/

#ifdef (USE_VASES)

#declare Tr = transform { translate <0.4, 1.2 + 0.2 * 4, 5.9 - 0.6> }
VaseWithFlowers(8, 7, Tr)

#declare Tr = transform { translate <0.4, 1.2 + 0.2 * 4, 12.4 + 0.6> }
VaseWithFlowers(8, 12, Tr)

#end /* USE_VASES */

/***********************************************************************/
/* Balcony */
/***********************************************************************/

#ifdef (USE_BALCONY)

#declare NumOfColumns = 5;

#declare Count = 0;
#while (Count < NumOfColumns)
	object {
		BalconyColumn
		rotate 23.5*y
		translate <-1, OctagonalStepHeight * 4, 1.3>
		+ <1.5 * Count / (NumOfColumns - 1), 0,
		   4.6 * Count / (NumOfColumns - 1)>
	}
	#declare Count = Count + 1;
#end

#declare Count = 0;
#while (Count < NumOfColumns)
	object {
		BalconyColumn
		rotate -23.5*y
		translate <-1, OctagonalStepHeight * 4, 17>
		+ <1.5 * Count / (NumOfColumns - 1), 0,
		   -4.6 * Count / (NumOfColumns - 1)>
	}
	#declare Count = Count + 1;
#end

#declare BalconyLength = sqrt ( 1.5*1.5 + 4.6*4.6 ) + 0.5;

box {
	<-0.5, 1, -BalconyLength / 2>, <0.5, 1.2, BalconyLength / 2>
	rotate 23.5*y
	translate <-1 + 1.5 / 2, OctagonalStepHeight * 4, 1.3 + 4.6 / 2>
	texture { BalconyBarTexture }
}

box {
	<-0.5, 1, -BalconyLength / 2>, <0.5, 1.2, BalconyLength / 2>
	rotate -23.5*y
	translate <-1 + 1.5 / 2, OctagonalStepHeight * 4, 17 - 4.6 / 2>
	texture { BalconyBarTexture }
}

#end /* USE_BALCONY */
