/* $Id: vase.pov,v 1.3 2002/08/26 19:32:57 ziotom Exp $ */

/***********************************************************************
 * Macro VaseWithFlowers(NumOfFlowers, StartSeed, Transformation).
 * The purpose of this macro is to create a vase with NUMOFFLOWERS in
 * it. The value of STARTSEED is used to generate random numbers for the
 * displacement of the flowers and for their colors. TRANSFORMATION will
 * be applied to the whole object (vase and flowers).
 ***********************************************************************/

// Vase + single flower: from <-0.3, 0, -0.3> to <0.3, 1, 0.3> (approx)

// File generated by sPatch, Copyright 1996-1998 by Mike Clifton
#ifndef (IMPORT_SPATCH)

background { color rgb <0, 0, 0> }

camera {
	location <1.437, 0.519, -1.984>
	look_at <0.000, 0.535, 0.000>
}

light_source { < 0, 100, -200 > color rgb <1, 1, 1> }
light_source { < 200, 10, 0 > color rgb <0.4, 0.5, 0.4> }
light_source { < -50, 10, 200 > color rgb <0.4, 0.25, 0.25> }

#end

#declare Vase =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
		<0.060, 0.000, 0.000> <0.060, 0.000, 0.000> <0.052, 0.000, -0.030> <0.052, 0.000, -0.030> 
		<0.140, 0.000, 0.000> <0.140, 0.000, -0.031> <0.137, 0.000, -0.043> <0.121, 0.000, -0.070> 
		<0.200, 0.000, 0.000> <0.200, 0.000, -0.031> <0.189, 0.000, -0.073> <0.173, 0.000, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, 0.000> <0.060, 0.000, 0.000> <0.140, 0.000, 0.000> <0.200, 0.000, 0.000> 
		<0.000, 0.000, 0.000> <0.060, 0.000, 0.000> <0.140, 0.000, 0.031> <0.200, 0.000, 0.031> 
		<0.000, 0.000, 0.000> <0.052, 0.000, 0.030> <0.137, 0.000, 0.043> <0.189, 0.000, 0.073> 
		<0.000, 0.000, 0.000> <0.052, 0.000, 0.030> <0.121, 0.000, 0.070> <0.173, 0.000, 0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.200, 0.000, 0.000> <0.200, 0.000, -0.031> <0.189, 0.000, -0.073> <0.173, 0.000, -0.100> 
		<0.215, 0.060, 0.000> <0.215, 0.060, -0.031> <0.202, 0.060, -0.081> <0.186, 0.060, -0.108> 
		<0.250, 0.138, 0.000> <0.250, 0.138, -0.039> <0.236, 0.138, -0.091> <0.217, 0.138, -0.125> 
		<0.250, 0.200, 0.000> <0.250, 0.200, -0.039> <0.236, 0.200, -0.091> <0.217, 0.200, -0.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.200, 0.000, 0.000> <0.215, 0.060, 0.000> <0.250, 0.138, 0.000> <0.250, 0.200, 0.000> 
		<0.200, 0.000, 0.031> <0.215, 0.060, 0.031> <0.250, 0.138, 0.039> <0.250, 0.200, 0.039> 
		<0.189, 0.000, 0.073> <0.202, 0.060, 0.081> <0.236, 0.138, 0.091> <0.236, 0.200, 0.091> 
		<0.173, 0.000, 0.100> <0.186, 0.060, 0.108> <0.217, 0.138, 0.125> <0.217, 0.200, 0.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.250, 0.200, 0.000> <0.250, 0.200, -0.039> <0.236, 0.200, -0.091> <0.217, 0.200, -0.125> 
		<0.250, 0.291, 0.000> <0.250, 0.291, -0.039> <0.236, 0.291, -0.091> <0.217, 0.291, -0.125> 
		<0.200, 0.409, 0.000> <0.200, 0.409, -0.031> <0.189, 0.409, -0.073> <0.173, 0.409, -0.100> 
		<0.200, 0.500, 0.000> <0.200, 0.500, -0.031> <0.189, 0.500, -0.073> <0.173, 0.500, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.250, 0.200, 0.000> <0.250, 0.291, 0.000> <0.200, 0.409, 0.000> <0.200, 0.500, 0.000> 
		<0.250, 0.200, 0.039> <0.250, 0.291, 0.039> <0.200, 0.409, 0.031> <0.200, 0.500, 0.031> 
		<0.236, 0.200, 0.091> <0.236, 0.291, 0.091> <0.189, 0.409, 0.073> <0.189, 0.500, 0.073> 
		<0.217, 0.200, 0.125> <0.217, 0.291, 0.125> <0.173, 0.409, 0.100> <0.173, 0.500, 0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.200, 0.500, 0.000> <0.200, 0.500, -0.031> <0.189, 0.500, -0.073> <0.173, 0.500, -0.100> 
		<0.200, 0.562, 0.000> <0.200, 0.562, -0.031> <0.189, 0.562, -0.073> <0.173, 0.562, -0.100> 
		<0.216, 0.649, 0.000> <0.216, 0.649, -0.039> <0.206, 0.649, -0.074> <0.187, 0.649, -0.108> 
		<0.250, 0.700, 0.000> <0.250, 0.700, -0.039> <0.236, 0.700, -0.091> <0.217, 0.700, -0.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.200, 0.500, 0.000> <0.200, 0.562, 0.000> <0.216, 0.649, 0.000> <0.250, 0.700, 0.000> 
		<0.200, 0.500, 0.031> <0.200, 0.562, 0.031> <0.216, 0.649, 0.039> <0.250, 0.700, 0.039> 
		<0.189, 0.500, 0.073> <0.189, 0.562, 0.073> <0.206, 0.649, 0.074> <0.236, 0.700, 0.091> 
		<0.173, 0.500, 0.100> <0.173, 0.562, 0.100> <0.187, 0.649, 0.108> <0.217, 0.700, 0.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.250, 0.700, 0.000> <0.250, 0.700, -0.039> <0.236, 0.700, -0.091> <0.217, 0.700, -0.125> 
		<0.262, 0.718, 0.000> <0.262, 0.718, -0.039> <0.246, 0.718, -0.097> <0.227, 0.718, -0.131> 
		<0.279, 0.650, 0.000> <0.279, 0.650, -0.047> <0.265, 0.650, -0.099> <0.241, 0.650, -0.139> 
		<0.300, 0.650, 0.000> <0.300, 0.650, -0.047> <0.283, 0.650, -0.110> <0.260, 0.650, -0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.250, 0.700, 0.000> <0.262, 0.718, 0.000> <0.279, 0.650, 0.000> <0.300, 0.650, 0.000> 
		<0.250, 0.700, 0.039> <0.262, 0.718, 0.039> <0.279, 0.650, 0.047> <0.300, 0.650, 0.047> 
		<0.236, 0.700, 0.091> <0.246, 0.718, 0.097> <0.265, 0.650, 0.099> <0.283, 0.650, 0.110> 
		<0.217, 0.700, 0.125> <0.227, 0.718, 0.131> <0.241, 0.650, 0.139> <0.260, 0.650, 0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.300, 0.650, 0.000> <0.300, 0.650, -0.047> <0.283, 0.650, -0.110> <0.260, 0.650, -0.150> 
		<0.321, 0.650, 0.000> <0.321, 0.650, -0.047> <0.301, 0.650, -0.120> <0.278, 0.650, -0.161> 
		<0.350, 0.679, 0.000> <0.350, 0.679, -0.054> <0.330, 0.679, -0.128> <0.303, 0.679, -0.175> 
		<0.350, 0.700, 0.000> <0.350, 0.700, -0.054> <0.330, 0.700, -0.128> <0.303, 0.700, -0.175> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.300, 0.650, 0.000> <0.321, 0.650, 0.000> <0.350, 0.679, 0.000> <0.350, 0.700, 0.000> 
		<0.300, 0.650, 0.047> <0.321, 0.650, 0.047> <0.350, 0.679, 0.054> <0.350, 0.700, 0.054> 
		<0.283, 0.650, 0.110> <0.301, 0.650, 0.120> <0.330, 0.679, 0.128> <0.330, 0.700, 0.128> 
		<0.260, 0.650, 0.150> <0.278, 0.650, 0.161> <0.303, 0.679, 0.175> <0.303, 0.700, 0.175> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.350, 0.700, 0.000> <0.350, 0.700, -0.054> <0.330, 0.700, -0.128> <0.303, 0.700, -0.175> 
		<0.350, 0.721, 0.000> <0.350, 0.721, -0.054> <0.330, 0.721, -0.128> <0.303, 0.721, -0.175> 
		<0.320, 0.743, 0.000> <0.320, 0.743, -0.047> <0.301, 0.743, -0.120> <0.277, 0.743, -0.160> 
		<0.300, 0.750, 0.000> <0.300, 0.750, -0.047> <0.283, 0.750, -0.110> <0.260, 0.750, -0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.350, 0.700, 0.000> <0.350, 0.721, 0.000> <0.320, 0.743, 0.000> <0.300, 0.750, 0.000> 
		<0.350, 0.700, 0.054> <0.350, 0.721, 0.054> <0.320, 0.743, 0.047> <0.300, 0.750, 0.047> 
		<0.330, 0.700, 0.128> <0.330, 0.721, 0.128> <0.301, 0.743, 0.120> <0.283, 0.750, 0.110> 
		<0.303, 0.700, 0.175> <0.303, 0.721, 0.175> <0.277, 0.743, 0.160> <0.260, 0.750, 0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.300, 0.750, 0.000> <0.300, 0.750, -0.047> <0.283, 0.750, -0.110> <0.260, 0.750, -0.150> 
		<0.272, 0.759, 0.000> <0.272, 0.759, -0.047> <0.258, 0.759, -0.095> <0.235, 0.759, -0.136> 
		<0.218, 0.774, 0.000> <0.218, 0.774, -0.031> <0.204, 0.774, -0.082> <0.189, 0.774, -0.109> 
		<0.200, 0.750, 0.000> <0.200, 0.750, -0.031> <0.189, 0.750, -0.073> <0.173, 0.750, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.300, 0.750, 0.000> <0.272, 0.759, 0.000> <0.218, 0.774, 0.000> <0.200, 0.750, 0.000> 
		<0.300, 0.750, 0.047> <0.272, 0.759, 0.047> <0.218, 0.774, 0.031> <0.200, 0.750, 0.031> 
		<0.283, 0.750, 0.110> <0.258, 0.759, 0.095> <0.204, 0.774, 0.082> <0.189, 0.750, 0.073> 
		<0.260, 0.750, 0.150> <0.235, 0.759, 0.136> <0.189, 0.774, 0.109> <0.173, 0.750, 0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.200, 0.750, 0.000> <0.200, 0.750, -0.031> <0.189, 0.750, -0.073> <0.173, 0.750, -0.100> 
		<0.163, 0.701, 0.000> <0.163, 0.701, -0.031> <0.157, 0.701, -0.055> <0.141, 0.701, -0.081> 
		<0.150, 0.612, 0.000> <0.150, 0.612, -0.023> <0.142, 0.612, -0.055> <0.130, 0.612, -0.075> 
		<0.150, 0.550, 0.000> <0.150, 0.550, -0.023> <0.142, 0.550, -0.055> <0.130, 0.550, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.200, 0.750, 0.000> <0.163, 0.701, 0.000> <0.150, 0.612, 0.000> <0.150, 0.550, 0.000> 
		<0.200, 0.750, 0.031> <0.163, 0.701, 0.031> <0.150, 0.612, 0.023> <0.150, 0.550, 0.023> 
		<0.189, 0.750, 0.073> <0.157, 0.701, 0.055> <0.142, 0.612, 0.055> <0.142, 0.550, 0.055> 
		<0.173, 0.750, 0.100> <0.141, 0.701, 0.081> <0.130, 0.612, 0.075> <0.130, 0.550, 0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.150, 0.550, 0.000> <0.150, 0.550, -0.023> <0.142, 0.550, -0.055> <0.130, 0.550, -0.075> 
		<0.150, 0.444, 0.000> <0.150, 0.444, -0.023> <0.142, 0.444, -0.055> <0.130, 0.444, -0.075> 
		<0.200, 0.306, 0.000> <0.200, 0.306, -0.031> <0.189, 0.306, -0.073> <0.173, 0.306, -0.100> 
		<0.200, 0.200, 0.000> <0.200, 0.200, -0.031> <0.189, 0.200, -0.073> <0.173, 0.200, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.150, 0.550, 0.000> <0.150, 0.444, 0.000> <0.200, 0.306, 0.000> <0.200, 0.200, 0.000> 
		<0.150, 0.550, 0.023> <0.150, 0.444, 0.023> <0.200, 0.306, 0.031> <0.200, 0.200, 0.031> 
		<0.142, 0.550, 0.055> <0.142, 0.444, 0.055> <0.189, 0.306, 0.073> <0.189, 0.200, 0.073> 
		<0.130, 0.550, 0.075> <0.130, 0.444, 0.075> <0.173, 0.306, 0.100> <0.173, 0.200, 0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.200, 0.200, 0.000> <0.200, 0.200, -0.031> <0.189, 0.200, -0.073> <0.173, 0.200, -0.100> 
		<0.200, 0.153, 0.000> <0.200, 0.153, -0.031> <0.189, 0.153, -0.073> <0.173, 0.153, -0.100> 
		<0.165, 0.095, 0.000> <0.165, 0.095, -0.023> <0.155, 0.095, -0.062> <0.143, 0.095, -0.083> 
		<0.150, 0.050, 0.000> <0.150, 0.050, -0.023> <0.142, 0.050, -0.055> <0.130, 0.050, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.200, 0.200, 0.000> <0.200, 0.153, 0.000> <0.165, 0.095, 0.000> <0.150, 0.050, 0.000> 
		<0.200, 0.200, 0.031> <0.200, 0.153, 0.031> <0.165, 0.095, 0.023> <0.150, 0.050, 0.023> 
		<0.189, 0.200, 0.073> <0.189, 0.153, 0.073> <0.155, 0.095, 0.062> <0.142, 0.050, 0.055> 
		<0.173, 0.200, 0.100> <0.173, 0.153, 0.100> <0.143, 0.095, 0.083> <0.130, 0.050, 0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.050, 0.000> <0.045, 0.050, 0.000> <0.105, 0.050, 0.000> <0.150, 0.050, 0.000> 
		<0.000, 0.050, 0.000> <0.045, 0.050, 0.000> <0.105, 0.050, -0.023> <0.150, 0.050, -0.023> 
		<0.000, 0.050, 0.000> <0.039, 0.050, -0.023> <0.103, 0.050, -0.032> <0.142, 0.050, -0.055> 
		<0.000, 0.050, 0.000> <0.039, 0.050, -0.023> <0.091, 0.050, -0.053> <0.130, 0.050, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> 
		<0.045, 0.050, 0.000> <0.045, 0.050, 0.000> <0.039, 0.050, 0.023> <0.039, 0.050, 0.023> 
		<0.105, 0.050, 0.000> <0.105, 0.050, 0.023> <0.103, 0.050, 0.032> <0.091, 0.050, 0.053> 
		<0.150, 0.050, 0.000> <0.150, 0.050, 0.023> <0.142, 0.050, 0.055> <0.130, 0.050, 0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> 
		<0.039, 0.050, 0.023> <0.039, 0.050, 0.023> <0.023, 0.050, 0.039> <0.023, 0.050, 0.039> 
		<0.091, 0.050, 0.053> <0.079, 0.050, 0.073> <0.073, 0.050, 0.079> <0.053, 0.050, 0.091> 
		<0.130, 0.050, 0.075> <0.118, 0.050, 0.095> <0.095, 0.050, 0.118> <0.075, 0.050, 0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> 
		<0.023, 0.050, 0.039> <0.023, 0.050, 0.039> <0.000, 0.050, 0.045> <0.000, 0.050, 0.045> 
		<0.053, 0.050, 0.091> <0.032, 0.050, 0.103> <0.023, 0.050, 0.105> <0.000, 0.050, 0.105> 
		<0.075, 0.050, 0.130> <0.055, 0.050, 0.142> <0.023, 0.050, 0.150> <0.000, 0.050, 0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> 
		<0.000, 0.050, 0.045> <0.000, 0.050, 0.045> <-0.023, 0.050, 0.039> <-0.023, 0.050, 0.039> 
		<0.000, 0.050, 0.105> <-0.023, 0.050, 0.105> <-0.032, 0.050, 0.103> <-0.053, 0.050, 0.091> 
		<0.000, 0.050, 0.150> <-0.023, 0.050, 0.150> <-0.055, 0.050, 0.142> <-0.075, 0.050, 0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> 
		<-0.023, 0.050, 0.039> <-0.023, 0.050, 0.039> <-0.039, 0.050, 0.023> <-0.039, 0.050, 0.023> 
		<-0.053, 0.050, 0.091> <-0.073, 0.050, 0.079> <-0.079, 0.050, 0.073> <-0.091, 0.050, 0.053> 
		<-0.075, 0.050, 0.130> <-0.095, 0.050, 0.118> <-0.118, 0.050, 0.095> <-0.130, 0.050, 0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> 
		<-0.039, 0.050, 0.023> <-0.039, 0.050, 0.023> <-0.045, 0.050, 0.000> <-0.045, 0.050, 0.000> 
		<-0.091, 0.050, 0.053> <-0.103, 0.050, 0.032> <-0.105, 0.050, 0.023> <-0.105, 0.050, 0.000> 
		<-0.130, 0.050, 0.075> <-0.142, 0.050, 0.055> <-0.150, 0.050, 0.023> <-0.150, 0.050, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> 
		<-0.045, 0.050, 0.000> <-0.045, 0.050, 0.000> <-0.039, 0.050, -0.023> <-0.039, 0.050, -0.023> 
		<-0.105, 0.050, 0.000> <-0.105, 0.050, -0.023> <-0.103, 0.050, -0.032> <-0.091, 0.050, -0.053> 
		<-0.150, 0.050, 0.000> <-0.150, 0.050, -0.023> <-0.142, 0.050, -0.055> <-0.130, 0.050, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> 
		<-0.039, 0.050, -0.023> <-0.039, 0.050, -0.023> <-0.023, 0.050, -0.039> <-0.023, 0.050, -0.039> 
		<-0.091, 0.050, -0.053> <-0.079, 0.050, -0.073> <-0.073, 0.050, -0.079> <-0.053, 0.050, -0.091> 
		<-0.130, 0.050, -0.075> <-0.118, 0.050, -0.095> <-0.095, 0.050, -0.118> <-0.075, 0.050, -0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> 
		<-0.023, 0.050, -0.039> <-0.023, 0.050, -0.039> <0.000, 0.050, -0.045> <0.000, 0.050, -0.045> 
		<-0.053, 0.050, -0.091> <-0.032, 0.050, -0.103> <-0.023, 0.050, -0.105> <0.000, 0.050, -0.105> 
		<-0.075, 0.050, -0.130> <-0.055, 0.050, -0.142> <-0.023, 0.050, -0.150> <0.000, 0.050, -0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> 
		<0.000, 0.050, -0.045> <0.000, 0.050, -0.045> <0.023, 0.050, -0.039> <0.023, 0.050, -0.039> 
		<0.000, 0.050, -0.105> <0.023, 0.050, -0.105> <0.032, 0.050, -0.103> <0.053, 0.050, -0.091> 
		<0.000, 0.050, -0.150> <0.023, 0.050, -0.150> <0.055, 0.050, -0.142> <0.075, 0.050, -0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> <0.000, 0.050, 0.000> 
		<0.023, 0.050, -0.039> <0.023, 0.050, -0.039> <0.039, 0.050, -0.023> <0.039, 0.050, -0.023> 
		<0.053, 0.050, -0.091> <0.073, 0.050, -0.079> <0.079, 0.050, -0.073> <0.091, 0.050, -0.053> 
		<0.075, 0.050, -0.130> <0.095, 0.050, -0.118> <0.118, 0.050, -0.095> <0.130, 0.050, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.130, 0.050, 0.075> <0.118, 0.050, 0.095> <0.095, 0.050, 0.118> <0.075, 0.050, 0.130> 
		<0.143, 0.095, 0.083> <0.131, 0.095, 0.103> <0.103, 0.095, 0.131> <0.083, 0.095, 0.143> 
		<0.173, 0.153, 0.100> <0.158, 0.153, 0.127> <0.127, 0.153, 0.158> <0.100, 0.153, 0.173> 
		<0.173, 0.200, 0.100> <0.158, 0.200, 0.127> <0.127, 0.200, 0.158> <0.100, 0.200, 0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 0.050, 0.130> <0.055, 0.050, 0.142> <0.023, 0.050, 0.150> <0.000, 0.050, 0.150> 
		<0.083, 0.095, 0.143> <0.062, 0.095, 0.155> <0.023, 0.095, 0.165> <0.000, 0.095, 0.165> 
		<0.100, 0.153, 0.173> <0.073, 0.153, 0.189> <0.031, 0.153, 0.200> <0.000, 0.153, 0.200> 
		<0.100, 0.200, 0.173> <0.073, 0.200, 0.189> <0.031, 0.200, 0.200> <0.000, 0.200, 0.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.050, 0.150> <-0.023, 0.050, 0.150> <-0.055, 0.050, 0.142> <-0.075, 0.050, 0.130> 
		<0.000, 0.095, 0.165> <-0.023, 0.095, 0.165> <-0.062, 0.095, 0.155> <-0.083, 0.095, 0.143> 
		<0.000, 0.153, 0.200> <-0.031, 0.153, 0.200> <-0.073, 0.153, 0.189> <-0.100, 0.153, 0.173> 
		<0.000, 0.200, 0.200> <-0.031, 0.200, 0.200> <-0.073, 0.200, 0.189> <-0.100, 0.200, 0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.075, 0.050, 0.130> <-0.095, 0.050, 0.118> <-0.118, 0.050, 0.095> <-0.130, 0.050, 0.075> 
		<-0.083, 0.095, 0.143> <-0.103, 0.095, 0.131> <-0.131, 0.095, 0.103> <-0.143, 0.095, 0.083> 
		<-0.100, 0.153, 0.173> <-0.127, 0.153, 0.158> <-0.158, 0.153, 0.127> <-0.173, 0.153, 0.100> 
		<-0.100, 0.200, 0.173> <-0.127, 0.200, 0.158> <-0.158, 0.200, 0.127> <-0.173, 0.200, 0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.130, 0.050, 0.075> <-0.142, 0.050, 0.055> <-0.150, 0.050, 0.023> <-0.150, 0.050, 0.000> 
		<-0.143, 0.095, 0.083> <-0.155, 0.095, 0.062> <-0.165, 0.095, 0.023> <-0.165, 0.095, 0.000> 
		<-0.173, 0.153, 0.100> <-0.189, 0.153, 0.073> <-0.200, 0.153, 0.031> <-0.200, 0.153, 0.000> 
		<-0.173, 0.200, 0.100> <-0.189, 0.200, 0.073> <-0.200, 0.200, 0.031> <-0.200, 0.200, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 0.050, 0.000> <-0.150, 0.050, -0.023> <-0.142, 0.050, -0.055> <-0.130, 0.050, -0.075> 
		<-0.165, 0.095, 0.000> <-0.165, 0.095, -0.023> <-0.155, 0.095, -0.062> <-0.143, 0.095, -0.083> 
		<-0.200, 0.153, 0.000> <-0.200, 0.153, -0.031> <-0.189, 0.153, -0.073> <-0.173, 0.153, -0.100> 
		<-0.200, 0.200, 0.000> <-0.200, 0.200, -0.031> <-0.189, 0.200, -0.073> <-0.173, 0.200, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.130, 0.050, -0.075> <-0.118, 0.050, -0.095> <-0.095, 0.050, -0.118> <-0.075, 0.050, -0.130> 
		<-0.143, 0.095, -0.083> <-0.131, 0.095, -0.103> <-0.103, 0.095, -0.131> <-0.083, 0.095, -0.143> 
		<-0.173, 0.153, -0.100> <-0.158, 0.153, -0.127> <-0.127, 0.153, -0.158> <-0.100, 0.153, -0.173> 
		<-0.173, 0.200, -0.100> <-0.158, 0.200, -0.127> <-0.127, 0.200, -0.158> <-0.100, 0.200, -0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.075, 0.050, -0.130> <-0.055, 0.050, -0.142> <-0.023, 0.050, -0.150> <0.000, 0.050, -0.150> 
		<-0.083, 0.095, -0.143> <-0.062, 0.095, -0.155> <-0.023, 0.095, -0.165> <0.000, 0.095, -0.165> 
		<-0.100, 0.153, -0.173> <-0.073, 0.153, -0.189> <-0.031, 0.153, -0.200> <0.000, 0.153, -0.200> 
		<-0.100, 0.200, -0.173> <-0.073, 0.200, -0.189> <-0.031, 0.200, -0.200> <0.000, 0.200, -0.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.050, -0.150> <0.023, 0.050, -0.150> <0.055, 0.050, -0.142> <0.075, 0.050, -0.130> 
		<0.000, 0.095, -0.165> <0.023, 0.095, -0.165> <0.062, 0.095, -0.155> <0.083, 0.095, -0.143> 
		<0.000, 0.153, -0.200> <0.031, 0.153, -0.200> <0.073, 0.153, -0.189> <0.100, 0.153, -0.173> 
		<0.000, 0.200, -0.200> <0.031, 0.200, -0.200> <0.073, 0.200, -0.189> <0.100, 0.200, -0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 0.050, -0.130> <0.095, 0.050, -0.118> <0.118, 0.050, -0.095> <0.130, 0.050, -0.075> 
		<0.083, 0.095, -0.143> <0.103, 0.095, -0.131> <0.131, 0.095, -0.103> <0.143, 0.095, -0.083> 
		<0.100, 0.153, -0.173> <0.127, 0.153, -0.158> <0.158, 0.153, -0.127> <0.173, 0.153, -0.100> 
		<0.100, 0.200, -0.173> <0.127, 0.200, -0.158> <0.158, 0.200, -0.127> <0.173, 0.200, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.173, 0.200, 0.100> <0.158, 0.200, 0.127> <0.127, 0.200, 0.158> <0.100, 0.200, 0.173> 
		<0.173, 0.306, 0.100> <0.158, 0.306, 0.127> <0.127, 0.306, 0.158> <0.100, 0.306, 0.173> 
		<0.130, 0.444, 0.075> <0.118, 0.444, 0.095> <0.095, 0.444, 0.118> <0.075, 0.444, 0.130> 
		<0.130, 0.550, 0.075> <0.118, 0.550, 0.095> <0.095, 0.550, 0.118> <0.075, 0.550, 0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 0.200, 0.173> <0.073, 0.200, 0.189> <0.031, 0.200, 0.200> <0.000, 0.200, 0.200> 
		<0.100, 0.306, 0.173> <0.073, 0.306, 0.189> <0.031, 0.306, 0.200> <0.000, 0.306, 0.200> 
		<0.075, 0.444, 0.130> <0.055, 0.444, 0.142> <0.023, 0.444, 0.150> <0.000, 0.444, 0.150> 
		<0.075, 0.550, 0.130> <0.055, 0.550, 0.142> <0.023, 0.550, 0.150> <0.000, 0.550, 0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.200, 0.200> <-0.031, 0.200, 0.200> <-0.073, 0.200, 0.189> <-0.100, 0.200, 0.173> 
		<0.000, 0.306, 0.200> <-0.031, 0.306, 0.200> <-0.073, 0.306, 0.189> <-0.100, 0.306, 0.173> 
		<0.000, 0.444, 0.150> <-0.023, 0.444, 0.150> <-0.055, 0.444, 0.142> <-0.075, 0.444, 0.130> 
		<0.000, 0.550, 0.150> <-0.023, 0.550, 0.150> <-0.055, 0.550, 0.142> <-0.075, 0.550, 0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.100, 0.200, 0.173> <-0.127, 0.200, 0.158> <-0.158, 0.200, 0.127> <-0.173, 0.200, 0.100> 
		<-0.100, 0.306, 0.173> <-0.127, 0.306, 0.158> <-0.158, 0.306, 0.127> <-0.173, 0.306, 0.100> 
		<-0.075, 0.444, 0.130> <-0.095, 0.444, 0.118> <-0.118, 0.444, 0.095> <-0.130, 0.444, 0.075> 
		<-0.075, 0.550, 0.130> <-0.095, 0.550, 0.118> <-0.118, 0.550, 0.095> <-0.130, 0.550, 0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.173, 0.200, 0.100> <-0.189, 0.200, 0.073> <-0.200, 0.200, 0.031> <-0.200, 0.200, 0.000> 
		<-0.173, 0.306, 0.100> <-0.189, 0.306, 0.073> <-0.200, 0.306, 0.031> <-0.200, 0.306, 0.000> 
		<-0.130, 0.444, 0.075> <-0.142, 0.444, 0.055> <-0.150, 0.444, 0.023> <-0.150, 0.444, 0.000> 
		<-0.130, 0.550, 0.075> <-0.142, 0.550, 0.055> <-0.150, 0.550, 0.023> <-0.150, 0.550, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.200, 0.200, 0.000> <-0.200, 0.200, -0.031> <-0.189, 0.200, -0.073> <-0.173, 0.200, -0.100> 
		<-0.200, 0.306, 0.000> <-0.200, 0.306, -0.031> <-0.189, 0.306, -0.073> <-0.173, 0.306, -0.100> 
		<-0.150, 0.444, 0.000> <-0.150, 0.444, -0.023> <-0.142, 0.444, -0.055> <-0.130, 0.444, -0.075> 
		<-0.150, 0.550, 0.000> <-0.150, 0.550, -0.023> <-0.142, 0.550, -0.055> <-0.130, 0.550, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.173, 0.200, -0.100> <-0.158, 0.200, -0.127> <-0.127, 0.200, -0.158> <-0.100, 0.200, -0.173> 
		<-0.173, 0.306, -0.100> <-0.158, 0.306, -0.127> <-0.127, 0.306, -0.158> <-0.100, 0.306, -0.173> 
		<-0.130, 0.444, -0.075> <-0.118, 0.444, -0.095> <-0.095, 0.444, -0.118> <-0.075, 0.444, -0.130> 
		<-0.130, 0.550, -0.075> <-0.118, 0.550, -0.095> <-0.095, 0.550, -0.118> <-0.075, 0.550, -0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.100, 0.200, -0.173> <-0.073, 0.200, -0.189> <-0.031, 0.200, -0.200> <0.000, 0.200, -0.200> 
		<-0.100, 0.306, -0.173> <-0.073, 0.306, -0.189> <-0.031, 0.306, -0.200> <0.000, 0.306, -0.200> 
		<-0.075, 0.444, -0.130> <-0.055, 0.444, -0.142> <-0.023, 0.444, -0.150> <0.000, 0.444, -0.150> 
		<-0.075, 0.550, -0.130> <-0.055, 0.550, -0.142> <-0.023, 0.550, -0.150> <0.000, 0.550, -0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.200, -0.200> <0.031, 0.200, -0.200> <0.073, 0.200, -0.189> <0.100, 0.200, -0.173> 
		<0.000, 0.306, -0.200> <0.031, 0.306, -0.200> <0.073, 0.306, -0.189> <0.100, 0.306, -0.173> 
		<0.000, 0.444, -0.150> <0.023, 0.444, -0.150> <0.055, 0.444, -0.142> <0.075, 0.444, -0.130> 
		<0.000, 0.550, -0.150> <0.023, 0.550, -0.150> <0.055, 0.550, -0.142> <0.075, 0.550, -0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 0.200, -0.173> <0.127, 0.200, -0.158> <0.158, 0.200, -0.127> <0.173, 0.200, -0.100> 
		<0.100, 0.306, -0.173> <0.127, 0.306, -0.158> <0.158, 0.306, -0.127> <0.173, 0.306, -0.100> 
		<0.075, 0.444, -0.130> <0.095, 0.444, -0.118> <0.118, 0.444, -0.095> <0.130, 0.444, -0.075> 
		<0.075, 0.550, -0.130> <0.095, 0.550, -0.118> <0.118, 0.550, -0.095> <0.130, 0.550, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.130, 0.550, 0.075> <0.118, 0.550, 0.095> <0.095, 0.550, 0.118> <0.075, 0.550, 0.130> 
		<0.130, 0.612, 0.075> <0.118, 0.612, 0.095> <0.095, 0.612, 0.118> <0.075, 0.612, 0.130> 
		<0.141, 0.701, 0.081> <0.126, 0.701, 0.108> <0.108, 0.701, 0.126> <0.081, 0.701, 0.141> 
		<0.173, 0.750, 0.100> <0.158, 0.750, 0.127> <0.127, 0.750, 0.158> <0.100, 0.750, 0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 0.550, 0.130> <0.055, 0.550, 0.142> <0.023, 0.550, 0.150> <0.000, 0.550, 0.150> 
		<0.075, 0.612, 0.130> <0.055, 0.612, 0.142> <0.023, 0.612, 0.150> <0.000, 0.612, 0.150> 
		<0.081, 0.701, 0.141> <0.055, 0.701, 0.157> <0.031, 0.701, 0.163> <0.000, 0.701, 0.163> 
		<0.100, 0.750, 0.173> <0.073, 0.750, 0.189> <0.031, 0.750, 0.200> <0.000, 0.750, 0.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.550, 0.150> <-0.023, 0.550, 0.150> <-0.055, 0.550, 0.142> <-0.075, 0.550, 0.130> 
		<0.000, 0.612, 0.150> <-0.023, 0.612, 0.150> <-0.055, 0.612, 0.142> <-0.075, 0.612, 0.130> 
		<0.000, 0.701, 0.163> <-0.031, 0.701, 0.163> <-0.055, 0.701, 0.157> <-0.081, 0.701, 0.141> 
		<0.000, 0.750, 0.200> <-0.031, 0.750, 0.200> <-0.073, 0.750, 0.189> <-0.100, 0.750, 0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.075, 0.550, 0.130> <-0.095, 0.550, 0.118> <-0.118, 0.550, 0.095> <-0.130, 0.550, 0.075> 
		<-0.075, 0.612, 0.130> <-0.095, 0.612, 0.118> <-0.118, 0.612, 0.095> <-0.130, 0.612, 0.075> 
		<-0.081, 0.701, 0.141> <-0.108, 0.701, 0.126> <-0.126, 0.701, 0.108> <-0.141, 0.701, 0.081> 
		<-0.100, 0.750, 0.173> <-0.127, 0.750, 0.158> <-0.158, 0.750, 0.127> <-0.173, 0.750, 0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.130, 0.550, 0.075> <-0.142, 0.550, 0.055> <-0.150, 0.550, 0.023> <-0.150, 0.550, 0.000> 
		<-0.130, 0.612, 0.075> <-0.142, 0.612, 0.055> <-0.150, 0.612, 0.023> <-0.150, 0.612, 0.000> 
		<-0.141, 0.701, 0.081> <-0.157, 0.701, 0.055> <-0.163, 0.701, 0.031> <-0.163, 0.701, 0.000> 
		<-0.173, 0.750, 0.100> <-0.189, 0.750, 0.073> <-0.200, 0.750, 0.031> <-0.200, 0.750, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 0.550, 0.000> <-0.150, 0.550, -0.023> <-0.142, 0.550, -0.055> <-0.130, 0.550, -0.075> 
		<-0.150, 0.612, 0.000> <-0.150, 0.612, -0.023> <-0.142, 0.612, -0.055> <-0.130, 0.612, -0.075> 
		<-0.163, 0.701, 0.000> <-0.163, 0.701, -0.031> <-0.157, 0.701, -0.055> <-0.141, 0.701, -0.081> 
		<-0.200, 0.750, 0.000> <-0.200, 0.750, -0.031> <-0.189, 0.750, -0.073> <-0.173, 0.750, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.130, 0.550, -0.075> <-0.118, 0.550, -0.095> <-0.095, 0.550, -0.118> <-0.075, 0.550, -0.130> 
		<-0.130, 0.612, -0.075> <-0.118, 0.612, -0.095> <-0.095, 0.612, -0.118> <-0.075, 0.612, -0.130> 
		<-0.141, 0.701, -0.081> <-0.126, 0.701, -0.108> <-0.108, 0.701, -0.126> <-0.081, 0.701, -0.141> 
		<-0.173, 0.750, -0.100> <-0.158, 0.750, -0.127> <-0.127, 0.750, -0.158> <-0.100, 0.750, -0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.075, 0.550, -0.130> <-0.055, 0.550, -0.142> <-0.023, 0.550, -0.150> <0.000, 0.550, -0.150> 
		<-0.075, 0.612, -0.130> <-0.055, 0.612, -0.142> <-0.023, 0.612, -0.150> <0.000, 0.612, -0.150> 
		<-0.081, 0.701, -0.141> <-0.055, 0.701, -0.157> <-0.031, 0.701, -0.163> <0.000, 0.701, -0.163> 
		<-0.100, 0.750, -0.173> <-0.073, 0.750, -0.189> <-0.031, 0.750, -0.200> <0.000, 0.750, -0.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.550, -0.150> <0.023, 0.550, -0.150> <0.055, 0.550, -0.142> <0.075, 0.550, -0.130> 
		<0.000, 0.612, -0.150> <0.023, 0.612, -0.150> <0.055, 0.612, -0.142> <0.075, 0.612, -0.130> 
		<0.000, 0.701, -0.163> <0.031, 0.701, -0.163> <0.055, 0.701, -0.157> <0.081, 0.701, -0.141> 
		<0.000, 0.750, -0.200> <0.031, 0.750, -0.200> <0.073, 0.750, -0.189> <0.100, 0.750, -0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 0.550, -0.130> <0.095, 0.550, -0.118> <0.118, 0.550, -0.095> <0.130, 0.550, -0.075> 
		<0.075, 0.612, -0.130> <0.095, 0.612, -0.118> <0.118, 0.612, -0.095> <0.130, 0.612, -0.075> 
		<0.081, 0.701, -0.141> <0.108, 0.701, -0.126> <0.126, 0.701, -0.108> <0.141, 0.701, -0.081> 
		<0.100, 0.750, -0.173> <0.127, 0.750, -0.158> <0.158, 0.750, -0.127> <0.173, 0.750, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.173, 0.750, 0.100> <0.158, 0.750, 0.127> <0.127, 0.750, 0.158> <0.100, 0.750, 0.173> 
		<0.189, 0.774, 0.109> <0.173, 0.774, 0.136> <0.136, 0.774, 0.173> <0.109, 0.774, 0.189> 
		<0.235, 0.759, 0.136> <0.212, 0.759, 0.176> <0.176, 0.759, 0.212> <0.136, 0.759, 0.235> 
		<0.260, 0.750, 0.150> <0.237, 0.750, 0.190> <0.190, 0.750, 0.237> <0.150, 0.750, 0.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 0.750, 0.173> <0.073, 0.750, 0.189> <0.031, 0.750, 0.200> <0.000, 0.750, 0.200> 
		<0.109, 0.774, 0.189> <0.082, 0.774, 0.204> <0.031, 0.774, 0.218> <0.000, 0.774, 0.218> 
		<0.136, 0.759, 0.235> <0.095, 0.759, 0.258> <0.047, 0.759, 0.272> <0.000, 0.759, 0.272> 
		<0.150, 0.750, 0.260> <0.110, 0.750, 0.283> <0.047, 0.750, 0.300> <0.000, 0.750, 0.300> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.750, 0.200> <-0.031, 0.750, 0.200> <-0.073, 0.750, 0.189> <-0.100, 0.750, 0.173> 
		<0.000, 0.774, 0.218> <-0.031, 0.774, 0.218> <-0.082, 0.774, 0.204> <-0.109, 0.774, 0.189> 
		<0.000, 0.759, 0.272> <-0.047, 0.759, 0.272> <-0.095, 0.759, 0.258> <-0.136, 0.759, 0.235> 
		<0.000, 0.750, 0.300> <-0.047, 0.750, 0.300> <-0.110, 0.750, 0.283> <-0.150, 0.750, 0.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.100, 0.750, 0.173> <-0.127, 0.750, 0.158> <-0.158, 0.750, 0.127> <-0.173, 0.750, 0.100> 
		<-0.109, 0.774, 0.189> <-0.136, 0.774, 0.173> <-0.173, 0.774, 0.136> <-0.189, 0.774, 0.109> 
		<-0.136, 0.759, 0.235> <-0.176, 0.759, 0.212> <-0.212, 0.759, 0.176> <-0.235, 0.759, 0.136> 
		<-0.150, 0.750, 0.260> <-0.190, 0.750, 0.237> <-0.237, 0.750, 0.190> <-0.260, 0.750, 0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.173, 0.750, 0.100> <-0.189, 0.750, 0.073> <-0.200, 0.750, 0.031> <-0.200, 0.750, 0.000> 
		<-0.189, 0.774, 0.109> <-0.204, 0.774, 0.082> <-0.218, 0.774, 0.031> <-0.218, 0.774, 0.000> 
		<-0.235, 0.759, 0.136> <-0.258, 0.759, 0.095> <-0.272, 0.759, 0.047> <-0.272, 0.759, 0.000> 
		<-0.260, 0.750, 0.150> <-0.283, 0.750, 0.110> <-0.300, 0.750, 0.047> <-0.300, 0.750, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.200, 0.750, 0.000> <-0.200, 0.750, -0.031> <-0.189, 0.750, -0.073> <-0.173, 0.750, -0.100> 
		<-0.218, 0.774, 0.000> <-0.218, 0.774, -0.031> <-0.204, 0.774, -0.082> <-0.189, 0.774, -0.109> 
		<-0.272, 0.759, 0.000> <-0.272, 0.759, -0.047> <-0.258, 0.759, -0.095> <-0.235, 0.759, -0.136> 
		<-0.300, 0.750, 0.000> <-0.300, 0.750, -0.047> <-0.283, 0.750, -0.110> <-0.260, 0.750, -0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.173, 0.750, -0.100> <-0.158, 0.750, -0.127> <-0.127, 0.750, -0.158> <-0.100, 0.750, -0.173> 
		<-0.189, 0.774, -0.109> <-0.173, 0.774, -0.136> <-0.136, 0.774, -0.173> <-0.109, 0.774, -0.189> 
		<-0.235, 0.759, -0.136> <-0.212, 0.759, -0.176> <-0.176, 0.759, -0.212> <-0.136, 0.759, -0.235> 
		<-0.260, 0.750, -0.150> <-0.237, 0.750, -0.190> <-0.190, 0.750, -0.237> <-0.150, 0.750, -0.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.100, 0.750, -0.173> <-0.073, 0.750, -0.189> <-0.031, 0.750, -0.200> <0.000, 0.750, -0.200> 
		<-0.109, 0.774, -0.189> <-0.082, 0.774, -0.204> <-0.031, 0.774, -0.218> <0.000, 0.774, -0.218> 
		<-0.136, 0.759, -0.235> <-0.095, 0.759, -0.258> <-0.047, 0.759, -0.272> <0.000, 0.759, -0.272> 
		<-0.150, 0.750, -0.260> <-0.110, 0.750, -0.283> <-0.047, 0.750, -0.300> <0.000, 0.750, -0.300> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.750, -0.200> <0.031, 0.750, -0.200> <0.073, 0.750, -0.189> <0.100, 0.750, -0.173> 
		<0.000, 0.774, -0.218> <0.031, 0.774, -0.218> <0.082, 0.774, -0.204> <0.109, 0.774, -0.189> 
		<0.000, 0.759, -0.272> <0.047, 0.759, -0.272> <0.095, 0.759, -0.258> <0.136, 0.759, -0.235> 
		<0.000, 0.750, -0.300> <0.047, 0.750, -0.300> <0.110, 0.750, -0.283> <0.150, 0.750, -0.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 0.750, -0.173> <0.127, 0.750, -0.158> <0.158, 0.750, -0.127> <0.173, 0.750, -0.100> 
		<0.109, 0.774, -0.189> <0.136, 0.774, -0.173> <0.173, 0.774, -0.136> <0.189, 0.774, -0.109> 
		<0.136, 0.759, -0.235> <0.176, 0.759, -0.212> <0.212, 0.759, -0.176> <0.235, 0.759, -0.136> 
		<0.150, 0.750, -0.260> <0.190, 0.750, -0.237> <0.237, 0.750, -0.190> <0.260, 0.750, -0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.260, 0.750, 0.150> <0.237, 0.750, 0.190> <0.190, 0.750, 0.237> <0.150, 0.750, 0.260> 
		<0.277, 0.743, 0.160> <0.254, 0.743, 0.200> <0.200, 0.743, 0.254> <0.160, 0.743, 0.277> 
		<0.303, 0.721, 0.175> <0.276, 0.721, 0.222> <0.222, 0.721, 0.276> <0.175, 0.721, 0.303> 
		<0.303, 0.700, 0.175> <0.276, 0.700, 0.222> <0.222, 0.700, 0.276> <0.175, 0.700, 0.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.150, 0.750, 0.260> <0.110, 0.750, 0.283> <0.047, 0.750, 0.300> <0.000, 0.750, 0.300> 
		<0.160, 0.743, 0.277> <0.120, 0.743, 0.301> <0.047, 0.743, 0.320> <0.000, 0.743, 0.320> 
		<0.175, 0.721, 0.303> <0.128, 0.721, 0.330> <0.054, 0.721, 0.350> <0.000, 0.721, 0.350> 
		<0.175, 0.700, 0.303> <0.128, 0.700, 0.330> <0.054, 0.700, 0.350> <0.000, 0.700, 0.350> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.750, 0.300> <-0.047, 0.750, 0.300> <-0.110, 0.750, 0.283> <-0.150, 0.750, 0.260> 
		<0.000, 0.743, 0.320> <-0.047, 0.743, 0.320> <-0.120, 0.743, 0.301> <-0.160, 0.743, 0.277> 
		<0.000, 0.721, 0.350> <-0.054, 0.721, 0.350> <-0.128, 0.721, 0.330> <-0.175, 0.721, 0.303> 
		<0.000, 0.700, 0.350> <-0.054, 0.700, 0.350> <-0.128, 0.700, 0.330> <-0.175, 0.700, 0.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 0.750, 0.260> <-0.190, 0.750, 0.237> <-0.237, 0.750, 0.190> <-0.260, 0.750, 0.150> 
		<-0.160, 0.743, 0.277> <-0.200, 0.743, 0.254> <-0.254, 0.743, 0.200> <-0.277, 0.743, 0.160> 
		<-0.175, 0.721, 0.303> <-0.222, 0.721, 0.276> <-0.276, 0.721, 0.222> <-0.303, 0.721, 0.175> 
		<-0.175, 0.700, 0.303> <-0.222, 0.700, 0.276> <-0.276, 0.700, 0.222> <-0.303, 0.700, 0.175> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.260, 0.750, 0.150> <-0.283, 0.750, 0.110> <-0.300, 0.750, 0.047> <-0.300, 0.750, 0.000> 
		<-0.277, 0.743, 0.160> <-0.301, 0.743, 0.120> <-0.320, 0.743, 0.047> <-0.320, 0.743, 0.000> 
		<-0.303, 0.721, 0.175> <-0.330, 0.721, 0.128> <-0.350, 0.721, 0.054> <-0.350, 0.721, 0.000> 
		<-0.303, 0.700, 0.175> <-0.330, 0.700, 0.128> <-0.350, 0.700, 0.054> <-0.350, 0.700, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.300, 0.750, 0.000> <-0.300, 0.750, -0.047> <-0.283, 0.750, -0.110> <-0.260, 0.750, -0.150> 
		<-0.320, 0.743, 0.000> <-0.320, 0.743, -0.047> <-0.301, 0.743, -0.120> <-0.277, 0.743, -0.160> 
		<-0.350, 0.721, 0.000> <-0.350, 0.721, -0.054> <-0.330, 0.721, -0.128> <-0.303, 0.721, -0.175> 
		<-0.350, 0.700, 0.000> <-0.350, 0.700, -0.054> <-0.330, 0.700, -0.128> <-0.303, 0.700, -0.175> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.260, 0.750, -0.150> <-0.237, 0.750, -0.190> <-0.190, 0.750, -0.237> <-0.150, 0.750, -0.260> 
		<-0.277, 0.743, -0.160> <-0.254, 0.743, -0.200> <-0.200, 0.743, -0.254> <-0.160, 0.743, -0.277> 
		<-0.303, 0.721, -0.175> <-0.276, 0.721, -0.222> <-0.222, 0.721, -0.276> <-0.175, 0.721, -0.303> 
		<-0.303, 0.700, -0.175> <-0.276, 0.700, -0.222> <-0.222, 0.700, -0.276> <-0.175, 0.700, -0.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 0.750, -0.260> <-0.110, 0.750, -0.283> <-0.047, 0.750, -0.300> <0.000, 0.750, -0.300> 
		<-0.160, 0.743, -0.277> <-0.120, 0.743, -0.301> <-0.047, 0.743, -0.320> <0.000, 0.743, -0.320> 
		<-0.175, 0.721, -0.303> <-0.128, 0.721, -0.330> <-0.054, 0.721, -0.350> <0.000, 0.721, -0.350> 
		<-0.175, 0.700, -0.303> <-0.128, 0.700, -0.330> <-0.054, 0.700, -0.350> <0.000, 0.700, -0.350> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.750, -0.300> <0.047, 0.750, -0.300> <0.110, 0.750, -0.283> <0.150, 0.750, -0.260> 
		<0.000, 0.743, -0.320> <0.047, 0.743, -0.320> <0.120, 0.743, -0.301> <0.160, 0.743, -0.277> 
		<0.000, 0.721, -0.350> <0.054, 0.721, -0.350> <0.128, 0.721, -0.330> <0.175, 0.721, -0.303> 
		<0.000, 0.700, -0.350> <0.054, 0.700, -0.350> <0.128, 0.700, -0.330> <0.175, 0.700, -0.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.150, 0.750, -0.260> <0.190, 0.750, -0.237> <0.237, 0.750, -0.190> <0.260, 0.750, -0.150> 
		<0.160, 0.743, -0.277> <0.200, 0.743, -0.254> <0.254, 0.743, -0.200> <0.277, 0.743, -0.160> 
		<0.175, 0.721, -0.303> <0.222, 0.721, -0.276> <0.276, 0.721, -0.222> <0.303, 0.721, -0.175> 
		<0.175, 0.700, -0.303> <0.222, 0.700, -0.276> <0.276, 0.700, -0.222> <0.303, 0.700, -0.175> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.303, 0.700, 0.175> <0.276, 0.700, 0.222> <0.222, 0.700, 0.276> <0.175, 0.700, 0.303> 
		<0.303, 0.679, 0.175> <0.276, 0.679, 0.222> <0.222, 0.679, 0.276> <0.175, 0.679, 0.303> 
		<0.278, 0.650, 0.161> <0.255, 0.650, 0.201> <0.201, 0.650, 0.255> <0.161, 0.650, 0.278> 
		<0.260, 0.650, 0.150> <0.237, 0.650, 0.190> <0.190, 0.650, 0.237> <0.150, 0.650, 0.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.175, 0.700, 0.303> <0.128, 0.700, 0.330> <0.054, 0.700, 0.350> <0.000, 0.700, 0.350> 
		<0.175, 0.679, 0.303> <0.128, 0.679, 0.330> <0.054, 0.679, 0.350> <0.000, 0.679, 0.350> 
		<0.161, 0.650, 0.278> <0.120, 0.650, 0.301> <0.047, 0.650, 0.321> <0.000, 0.650, 0.321> 
		<0.150, 0.650, 0.260> <0.110, 0.650, 0.283> <0.047, 0.650, 0.300> <0.000, 0.650, 0.300> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.700, 0.350> <-0.054, 0.700, 0.350> <-0.128, 0.700, 0.330> <-0.175, 0.700, 0.303> 
		<0.000, 0.679, 0.350> <-0.054, 0.679, 0.350> <-0.128, 0.679, 0.330> <-0.175, 0.679, 0.303> 
		<0.000, 0.650, 0.321> <-0.047, 0.650, 0.321> <-0.120, 0.650, 0.301> <-0.161, 0.650, 0.278> 
		<0.000, 0.650, 0.300> <-0.047, 0.650, 0.300> <-0.110, 0.650, 0.283> <-0.150, 0.650, 0.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.175, 0.700, 0.303> <-0.222, 0.700, 0.276> <-0.276, 0.700, 0.222> <-0.303, 0.700, 0.175> 
		<-0.175, 0.679, 0.303> <-0.222, 0.679, 0.276> <-0.276, 0.679, 0.222> <-0.303, 0.679, 0.175> 
		<-0.161, 0.650, 0.278> <-0.201, 0.650, 0.255> <-0.255, 0.650, 0.201> <-0.278, 0.650, 0.161> 
		<-0.150, 0.650, 0.260> <-0.190, 0.650, 0.237> <-0.237, 0.650, 0.190> <-0.260, 0.650, 0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.303, 0.700, 0.175> <-0.330, 0.700, 0.128> <-0.350, 0.700, 0.054> <-0.350, 0.700, 0.000> 
		<-0.303, 0.679, 0.175> <-0.330, 0.679, 0.128> <-0.350, 0.679, 0.054> <-0.350, 0.679, 0.000> 
		<-0.278, 0.650, 0.161> <-0.301, 0.650, 0.120> <-0.321, 0.650, 0.047> <-0.321, 0.650, 0.000> 
		<-0.260, 0.650, 0.150> <-0.283, 0.650, 0.110> <-0.300, 0.650, 0.047> <-0.300, 0.650, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.350, 0.700, 0.000> <-0.350, 0.700, -0.054> <-0.330, 0.700, -0.128> <-0.303, 0.700, -0.175> 
		<-0.350, 0.679, 0.000> <-0.350, 0.679, -0.054> <-0.330, 0.679, -0.128> <-0.303, 0.679, -0.175> 
		<-0.321, 0.650, 0.000> <-0.321, 0.650, -0.047> <-0.301, 0.650, -0.120> <-0.278, 0.650, -0.161> 
		<-0.300, 0.650, 0.000> <-0.300, 0.650, -0.047> <-0.283, 0.650, -0.110> <-0.260, 0.650, -0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.303, 0.700, -0.175> <-0.276, 0.700, -0.222> <-0.222, 0.700, -0.276> <-0.175, 0.700, -0.303> 
		<-0.303, 0.679, -0.175> <-0.276, 0.679, -0.222> <-0.222, 0.679, -0.276> <-0.175, 0.679, -0.303> 
		<-0.278, 0.650, -0.161> <-0.255, 0.650, -0.201> <-0.201, 0.650, -0.255> <-0.161, 0.650, -0.278> 
		<-0.260, 0.650, -0.150> <-0.237, 0.650, -0.190> <-0.190, 0.650, -0.237> <-0.150, 0.650, -0.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.175, 0.700, -0.303> <-0.128, 0.700, -0.330> <-0.054, 0.700, -0.350> <0.000, 0.700, -0.350> 
		<-0.175, 0.679, -0.303> <-0.128, 0.679, -0.330> <-0.054, 0.679, -0.350> <0.000, 0.679, -0.350> 
		<-0.161, 0.650, -0.278> <-0.120, 0.650, -0.301> <-0.047, 0.650, -0.321> <0.000, 0.650, -0.321> 
		<-0.150, 0.650, -0.260> <-0.110, 0.650, -0.283> <-0.047, 0.650, -0.300> <0.000, 0.650, -0.300> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.700, -0.350> <0.054, 0.700, -0.350> <0.128, 0.700, -0.330> <0.175, 0.700, -0.303> 
		<0.000, 0.679, -0.350> <0.054, 0.679, -0.350> <0.128, 0.679, -0.330> <0.175, 0.679, -0.303> 
		<0.000, 0.650, -0.321> <0.047, 0.650, -0.321> <0.120, 0.650, -0.301> <0.161, 0.650, -0.278> 
		<0.000, 0.650, -0.300> <0.047, 0.650, -0.300> <0.110, 0.650, -0.283> <0.150, 0.650, -0.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.175, 0.700, -0.303> <0.222, 0.700, -0.276> <0.276, 0.700, -0.222> <0.303, 0.700, -0.175> 
		<0.175, 0.679, -0.303> <0.222, 0.679, -0.276> <0.276, 0.679, -0.222> <0.303, 0.679, -0.175> 
		<0.161, 0.650, -0.278> <0.201, 0.650, -0.255> <0.255, 0.650, -0.201> <0.278, 0.650, -0.161> 
		<0.150, 0.650, -0.260> <0.190, 0.650, -0.237> <0.237, 0.650, -0.190> <0.260, 0.650, -0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.260, 0.650, 0.150> <0.237, 0.650, 0.190> <0.190, 0.650, 0.237> <0.150, 0.650, 0.260> 
		<0.241, 0.650, 0.139> <0.218, 0.650, 0.180> <0.180, 0.650, 0.218> <0.139, 0.650, 0.241> 
		<0.227, 0.718, 0.131> <0.207, 0.718, 0.165> <0.165, 0.718, 0.207> <0.131, 0.718, 0.227> 
		<0.217, 0.700, 0.125> <0.197, 0.700, 0.159> <0.159, 0.700, 0.197> <0.125, 0.700, 0.217> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.150, 0.650, 0.260> <0.110, 0.650, 0.283> <0.047, 0.650, 0.300> <0.000, 0.650, 0.300> 
		<0.139, 0.650, 0.241> <0.099, 0.650, 0.265> <0.047, 0.650, 0.279> <0.000, 0.650, 0.279> 
		<0.131, 0.718, 0.227> <0.097, 0.718, 0.246> <0.039, 0.718, 0.262> <0.000, 0.718, 0.262> 
		<0.125, 0.700, 0.217> <0.091, 0.700, 0.236> <0.039, 0.700, 0.250> <0.000, 0.700, 0.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.650, 0.300> <-0.047, 0.650, 0.300> <-0.110, 0.650, 0.283> <-0.150, 0.650, 0.260> 
		<0.000, 0.650, 0.279> <-0.047, 0.650, 0.279> <-0.099, 0.650, 0.265> <-0.139, 0.650, 0.241> 
		<0.000, 0.718, 0.262> <-0.039, 0.718, 0.262> <-0.097, 0.718, 0.246> <-0.131, 0.718, 0.227> 
		<0.000, 0.700, 0.250> <-0.039, 0.700, 0.250> <-0.091, 0.700, 0.236> <-0.125, 0.700, 0.217> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 0.650, 0.260> <-0.190, 0.650, 0.237> <-0.237, 0.650, 0.190> <-0.260, 0.650, 0.150> 
		<-0.139, 0.650, 0.241> <-0.180, 0.650, 0.218> <-0.218, 0.650, 0.180> <-0.241, 0.650, 0.139> 
		<-0.131, 0.718, 0.227> <-0.165, 0.718, 0.207> <-0.207, 0.718, 0.165> <-0.227, 0.718, 0.131> 
		<-0.125, 0.700, 0.217> <-0.159, 0.700, 0.197> <-0.197, 0.700, 0.159> <-0.217, 0.700, 0.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.260, 0.650, 0.150> <-0.283, 0.650, 0.110> <-0.300, 0.650, 0.047> <-0.300, 0.650, 0.000> 
		<-0.241, 0.650, 0.139> <-0.265, 0.650, 0.099> <-0.279, 0.650, 0.047> <-0.279, 0.650, 0.000> 
		<-0.227, 0.718, 0.131> <-0.246, 0.718, 0.097> <-0.262, 0.718, 0.039> <-0.262, 0.718, 0.000> 
		<-0.217, 0.700, 0.125> <-0.236, 0.700, 0.091> <-0.250, 0.700, 0.039> <-0.250, 0.700, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.300, 0.650, 0.000> <-0.300, 0.650, -0.047> <-0.283, 0.650, -0.110> <-0.260, 0.650, -0.150> 
		<-0.279, 0.650, 0.000> <-0.279, 0.650, -0.047> <-0.265, 0.650, -0.099> <-0.241, 0.650, -0.139> 
		<-0.262, 0.718, 0.000> <-0.262, 0.718, -0.039> <-0.246, 0.718, -0.097> <-0.227, 0.718, -0.131> 
		<-0.250, 0.700, 0.000> <-0.250, 0.700, -0.039> <-0.236, 0.700, -0.091> <-0.217, 0.700, -0.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.260, 0.650, -0.150> <-0.237, 0.650, -0.190> <-0.190, 0.650, -0.237> <-0.150, 0.650, -0.260> 
		<-0.241, 0.650, -0.139> <-0.218, 0.650, -0.180> <-0.180, 0.650, -0.218> <-0.139, 0.650, -0.241> 
		<-0.227, 0.718, -0.131> <-0.207, 0.718, -0.165> <-0.165, 0.718, -0.207> <-0.131, 0.718, -0.227> 
		<-0.217, 0.700, -0.125> <-0.197, 0.700, -0.159> <-0.159, 0.700, -0.197> <-0.125, 0.700, -0.217> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 0.650, -0.260> <-0.110, 0.650, -0.283> <-0.047, 0.650, -0.300> <0.000, 0.650, -0.300> 
		<-0.139, 0.650, -0.241> <-0.099, 0.650, -0.265> <-0.047, 0.650, -0.279> <0.000, 0.650, -0.279> 
		<-0.131, 0.718, -0.227> <-0.097, 0.718, -0.246> <-0.039, 0.718, -0.262> <0.000, 0.718, -0.262> 
		<-0.125, 0.700, -0.217> <-0.091, 0.700, -0.236> <-0.039, 0.700, -0.250> <0.000, 0.700, -0.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.650, -0.300> <0.047, 0.650, -0.300> <0.110, 0.650, -0.283> <0.150, 0.650, -0.260> 
		<0.000, 0.650, -0.279> <0.047, 0.650, -0.279> <0.099, 0.650, -0.265> <0.139, 0.650, -0.241> 
		<0.000, 0.718, -0.262> <0.039, 0.718, -0.262> <0.097, 0.718, -0.246> <0.131, 0.718, -0.227> 
		<0.000, 0.700, -0.250> <0.039, 0.700, -0.250> <0.091, 0.700, -0.236> <0.125, 0.700, -0.217> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.150, 0.650, -0.260> <0.190, 0.650, -0.237> <0.237, 0.650, -0.190> <0.260, 0.650, -0.150> 
		<0.139, 0.650, -0.241> <0.180, 0.650, -0.218> <0.218, 0.650, -0.180> <0.241, 0.650, -0.139> 
		<0.131, 0.718, -0.227> <0.165, 0.718, -0.207> <0.207, 0.718, -0.165> <0.227, 0.718, -0.131> 
		<0.125, 0.700, -0.217> <0.159, 0.700, -0.197> <0.197, 0.700, -0.159> <0.217, 0.700, -0.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.217, 0.700, 0.125> <0.197, 0.700, 0.159> <0.159, 0.700, 0.197> <0.125, 0.700, 0.217> 
		<0.187, 0.649, 0.108> <0.167, 0.649, 0.141> <0.141, 0.649, 0.167> <0.108, 0.649, 0.187> 
		<0.173, 0.562, 0.100> <0.158, 0.562, 0.127> <0.127, 0.562, 0.158> <0.100, 0.562, 0.173> 
		<0.173, 0.500, 0.100> <0.158, 0.500, 0.127> <0.127, 0.500, 0.158> <0.100, 0.500, 0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.125, 0.700, 0.217> <0.091, 0.700, 0.236> <0.039, 0.700, 0.250> <0.000, 0.700, 0.250> 
		<0.108, 0.649, 0.187> <0.074, 0.649, 0.206> <0.039, 0.649, 0.216> <0.000, 0.649, 0.216> 
		<0.100, 0.562, 0.173> <0.073, 0.562, 0.189> <0.031, 0.562, 0.200> <0.000, 0.562, 0.200> 
		<0.100, 0.500, 0.173> <0.073, 0.500, 0.189> <0.031, 0.500, 0.200> <0.000, 0.500, 0.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.700, 0.250> <-0.039, 0.700, 0.250> <-0.091, 0.700, 0.236> <-0.125, 0.700, 0.217> 
		<0.000, 0.649, 0.216> <-0.039, 0.649, 0.216> <-0.074, 0.649, 0.206> <-0.108, 0.649, 0.187> 
		<0.000, 0.562, 0.200> <-0.031, 0.562, 0.200> <-0.073, 0.562, 0.189> <-0.100, 0.562, 0.173> 
		<0.000, 0.500, 0.200> <-0.031, 0.500, 0.200> <-0.073, 0.500, 0.189> <-0.100, 0.500, 0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.125, 0.700, 0.217> <-0.159, 0.700, 0.197> <-0.197, 0.700, 0.159> <-0.217, 0.700, 0.125> 
		<-0.108, 0.649, 0.187> <-0.141, 0.649, 0.167> <-0.167, 0.649, 0.141> <-0.187, 0.649, 0.108> 
		<-0.100, 0.562, 0.173> <-0.127, 0.562, 0.158> <-0.158, 0.562, 0.127> <-0.173, 0.562, 0.100> 
		<-0.100, 0.500, 0.173> <-0.127, 0.500, 0.158> <-0.158, 0.500, 0.127> <-0.173, 0.500, 0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.217, 0.700, 0.125> <-0.236, 0.700, 0.091> <-0.250, 0.700, 0.039> <-0.250, 0.700, 0.000> 
		<-0.187, 0.649, 0.108> <-0.206, 0.649, 0.074> <-0.216, 0.649, 0.039> <-0.216, 0.649, 0.000> 
		<-0.173, 0.562, 0.100> <-0.189, 0.562, 0.073> <-0.200, 0.562, 0.031> <-0.200, 0.562, 0.000> 
		<-0.173, 0.500, 0.100> <-0.189, 0.500, 0.073> <-0.200, 0.500, 0.031> <-0.200, 0.500, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.250, 0.700, 0.000> <-0.250, 0.700, -0.039> <-0.236, 0.700, -0.091> <-0.217, 0.700, -0.125> 
		<-0.216, 0.649, 0.000> <-0.216, 0.649, -0.039> <-0.206, 0.649, -0.074> <-0.187, 0.649, -0.108> 
		<-0.200, 0.562, 0.000> <-0.200, 0.562, -0.031> <-0.189, 0.562, -0.073> <-0.173, 0.562, -0.100> 
		<-0.200, 0.500, 0.000> <-0.200, 0.500, -0.031> <-0.189, 0.500, -0.073> <-0.173, 0.500, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.217, 0.700, -0.125> <-0.197, 0.700, -0.159> <-0.159, 0.700, -0.197> <-0.125, 0.700, -0.217> 
		<-0.187, 0.649, -0.108> <-0.167, 0.649, -0.141> <-0.141, 0.649, -0.167> <-0.108, 0.649, -0.187> 
		<-0.173, 0.562, -0.100> <-0.158, 0.562, -0.127> <-0.127, 0.562, -0.158> <-0.100, 0.562, -0.173> 
		<-0.173, 0.500, -0.100> <-0.158, 0.500, -0.127> <-0.127, 0.500, -0.158> <-0.100, 0.500, -0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.125, 0.700, -0.217> <-0.091, 0.700, -0.236> <-0.039, 0.700, -0.250> <0.000, 0.700, -0.250> 
		<-0.108, 0.649, -0.187> <-0.074, 0.649, -0.206> <-0.039, 0.649, -0.216> <0.000, 0.649, -0.216> 
		<-0.100, 0.562, -0.173> <-0.073, 0.562, -0.189> <-0.031, 0.562, -0.200> <0.000, 0.562, -0.200> 
		<-0.100, 0.500, -0.173> <-0.073, 0.500, -0.189> <-0.031, 0.500, -0.200> <0.000, 0.500, -0.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.700, -0.250> <0.039, 0.700, -0.250> <0.091, 0.700, -0.236> <0.125, 0.700, -0.217> 
		<0.000, 0.649, -0.216> <0.039, 0.649, -0.216> <0.074, 0.649, -0.206> <0.108, 0.649, -0.187> 
		<0.000, 0.562, -0.200> <0.031, 0.562, -0.200> <0.073, 0.562, -0.189> <0.100, 0.562, -0.173> 
		<0.000, 0.500, -0.200> <0.031, 0.500, -0.200> <0.073, 0.500, -0.189> <0.100, 0.500, -0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.125, 0.700, -0.217> <0.159, 0.700, -0.197> <0.197, 0.700, -0.159> <0.217, 0.700, -0.125> 
		<0.108, 0.649, -0.187> <0.141, 0.649, -0.167> <0.167, 0.649, -0.141> <0.187, 0.649, -0.108> 
		<0.100, 0.562, -0.173> <0.127, 0.562, -0.158> <0.158, 0.562, -0.127> <0.173, 0.562, -0.100> 
		<0.100, 0.500, -0.173> <0.127, 0.500, -0.158> <0.158, 0.500, -0.127> <0.173, 0.500, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.173, 0.500, 0.100> <0.158, 0.500, 0.127> <0.127, 0.500, 0.158> <0.100, 0.500, 0.173> 
		<0.173, 0.409, 0.100> <0.158, 0.409, 0.127> <0.127, 0.409, 0.158> <0.100, 0.409, 0.173> 
		<0.217, 0.291, 0.125> <0.197, 0.291, 0.159> <0.159, 0.291, 0.197> <0.125, 0.291, 0.217> 
		<0.217, 0.200, 0.125> <0.197, 0.200, 0.159> <0.159, 0.200, 0.197> <0.125, 0.200, 0.217> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 0.500, 0.173> <0.073, 0.500, 0.189> <0.031, 0.500, 0.200> <0.000, 0.500, 0.200> 
		<0.100, 0.409, 0.173> <0.073, 0.409, 0.189> <0.031, 0.409, 0.200> <0.000, 0.409, 0.200> 
		<0.125, 0.291, 0.217> <0.091, 0.291, 0.236> <0.039, 0.291, 0.250> <0.000, 0.291, 0.250> 
		<0.125, 0.200, 0.217> <0.091, 0.200, 0.236> <0.039, 0.200, 0.250> <0.000, 0.200, 0.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.500, 0.200> <-0.031, 0.500, 0.200> <-0.073, 0.500, 0.189> <-0.100, 0.500, 0.173> 
		<0.000, 0.409, 0.200> <-0.031, 0.409, 0.200> <-0.073, 0.409, 0.189> <-0.100, 0.409, 0.173> 
		<0.000, 0.291, 0.250> <-0.039, 0.291, 0.250> <-0.091, 0.291, 0.236> <-0.125, 0.291, 0.217> 
		<0.000, 0.200, 0.250> <-0.039, 0.200, 0.250> <-0.091, 0.200, 0.236> <-0.125, 0.200, 0.217> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.100, 0.500, 0.173> <-0.127, 0.500, 0.158> <-0.158, 0.500, 0.127> <-0.173, 0.500, 0.100> 
		<-0.100, 0.409, 0.173> <-0.127, 0.409, 0.158> <-0.158, 0.409, 0.127> <-0.173, 0.409, 0.100> 
		<-0.125, 0.291, 0.217> <-0.159, 0.291, 0.197> <-0.197, 0.291, 0.159> <-0.217, 0.291, 0.125> 
		<-0.125, 0.200, 0.217> <-0.159, 0.200, 0.197> <-0.197, 0.200, 0.159> <-0.217, 0.200, 0.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.173, 0.500, 0.100> <-0.189, 0.500, 0.073> <-0.200, 0.500, 0.031> <-0.200, 0.500, 0.000> 
		<-0.173, 0.409, 0.100> <-0.189, 0.409, 0.073> <-0.200, 0.409, 0.031> <-0.200, 0.409, 0.000> 
		<-0.217, 0.291, 0.125> <-0.236, 0.291, 0.091> <-0.250, 0.291, 0.039> <-0.250, 0.291, 0.000> 
		<-0.217, 0.200, 0.125> <-0.236, 0.200, 0.091> <-0.250, 0.200, 0.039> <-0.250, 0.200, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.200, 0.500, 0.000> <-0.200, 0.500, -0.031> <-0.189, 0.500, -0.073> <-0.173, 0.500, -0.100> 
		<-0.200, 0.409, 0.000> <-0.200, 0.409, -0.031> <-0.189, 0.409, -0.073> <-0.173, 0.409, -0.100> 
		<-0.250, 0.291, 0.000> <-0.250, 0.291, -0.039> <-0.236, 0.291, -0.091> <-0.217, 0.291, -0.125> 
		<-0.250, 0.200, 0.000> <-0.250, 0.200, -0.039> <-0.236, 0.200, -0.091> <-0.217, 0.200, -0.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.173, 0.500, -0.100> <-0.158, 0.500, -0.127> <-0.127, 0.500, -0.158> <-0.100, 0.500, -0.173> 
		<-0.173, 0.409, -0.100> <-0.158, 0.409, -0.127> <-0.127, 0.409, -0.158> <-0.100, 0.409, -0.173> 
		<-0.217, 0.291, -0.125> <-0.197, 0.291, -0.159> <-0.159, 0.291, -0.197> <-0.125, 0.291, -0.217> 
		<-0.217, 0.200, -0.125> <-0.197, 0.200, -0.159> <-0.159, 0.200, -0.197> <-0.125, 0.200, -0.217> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.100, 0.500, -0.173> <-0.073, 0.500, -0.189> <-0.031, 0.500, -0.200> <0.000, 0.500, -0.200> 
		<-0.100, 0.409, -0.173> <-0.073, 0.409, -0.189> <-0.031, 0.409, -0.200> <0.000, 0.409, -0.200> 
		<-0.125, 0.291, -0.217> <-0.091, 0.291, -0.236> <-0.039, 0.291, -0.250> <0.000, 0.291, -0.250> 
		<-0.125, 0.200, -0.217> <-0.091, 0.200, -0.236> <-0.039, 0.200, -0.250> <0.000, 0.200, -0.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.500, -0.200> <0.031, 0.500, -0.200> <0.073, 0.500, -0.189> <0.100, 0.500, -0.173> 
		<0.000, 0.409, -0.200> <0.031, 0.409, -0.200> <0.073, 0.409, -0.189> <0.100, 0.409, -0.173> 
		<0.000, 0.291, -0.250> <0.039, 0.291, -0.250> <0.091, 0.291, -0.236> <0.125, 0.291, -0.217> 
		<0.000, 0.200, -0.250> <0.039, 0.200, -0.250> <0.091, 0.200, -0.236> <0.125, 0.200, -0.217> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 0.500, -0.173> <0.127, 0.500, -0.158> <0.158, 0.500, -0.127> <0.173, 0.500, -0.100> 
		<0.100, 0.409, -0.173> <0.127, 0.409, -0.158> <0.158, 0.409, -0.127> <0.173, 0.409, -0.100> 
		<0.125, 0.291, -0.217> <0.159, 0.291, -0.197> <0.197, 0.291, -0.159> <0.217, 0.291, -0.125> 
		<0.125, 0.200, -0.217> <0.159, 0.200, -0.197> <0.197, 0.200, -0.159> <0.217, 0.200, -0.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.217, 0.200, 0.125> <0.197, 0.200, 0.159> <0.159, 0.200, 0.197> <0.125, 0.200, 0.217> 
		<0.217, 0.138, 0.125> <0.197, 0.138, 0.159> <0.159, 0.138, 0.197> <0.125, 0.138, 0.217> 
		<0.186, 0.060, 0.108> <0.171, 0.060, 0.134> <0.134, 0.060, 0.171> <0.108, 0.060, 0.186> 
		<0.173, 0.000, 0.100> <0.158, 0.000, 0.127> <0.127, 0.000, 0.158> <0.100, 0.000, 0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.125, 0.200, 0.217> <0.091, 0.200, 0.236> <0.039, 0.200, 0.250> <0.000, 0.200, 0.250> 
		<0.125, 0.138, 0.217> <0.091, 0.138, 0.236> <0.039, 0.138, 0.250> <0.000, 0.138, 0.250> 
		<0.108, 0.060, 0.186> <0.081, 0.060, 0.202> <0.031, 0.060, 0.215> <0.000, 0.060, 0.215> 
		<0.100, 0.000, 0.173> <0.073, 0.000, 0.189> <0.031, 0.000, 0.200> <0.000, 0.000, 0.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.200, 0.250> <-0.039, 0.200, 0.250> <-0.091, 0.200, 0.236> <-0.125, 0.200, 0.217> 
		<0.000, 0.138, 0.250> <-0.039, 0.138, 0.250> <-0.091, 0.138, 0.236> <-0.125, 0.138, 0.217> 
		<0.000, 0.060, 0.215> <-0.031, 0.060, 0.215> <-0.081, 0.060, 0.202> <-0.108, 0.060, 0.186> 
		<0.000, 0.000, 0.200> <-0.031, 0.000, 0.200> <-0.073, 0.000, 0.189> <-0.100, 0.000, 0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.125, 0.200, 0.217> <-0.159, 0.200, 0.197> <-0.197, 0.200, 0.159> <-0.217, 0.200, 0.125> 
		<-0.125, 0.138, 0.217> <-0.159, 0.138, 0.197> <-0.197, 0.138, 0.159> <-0.217, 0.138, 0.125> 
		<-0.108, 0.060, 0.186> <-0.134, 0.060, 0.171> <-0.171, 0.060, 0.134> <-0.186, 0.060, 0.108> 
		<-0.100, 0.000, 0.173> <-0.127, 0.000, 0.158> <-0.158, 0.000, 0.127> <-0.173, 0.000, 0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.217, 0.200, 0.125> <-0.236, 0.200, 0.091> <-0.250, 0.200, 0.039> <-0.250, 0.200, 0.000> 
		<-0.217, 0.138, 0.125> <-0.236, 0.138, 0.091> <-0.250, 0.138, 0.039> <-0.250, 0.138, 0.000> 
		<-0.186, 0.060, 0.108> <-0.202, 0.060, 0.081> <-0.215, 0.060, 0.031> <-0.215, 0.060, 0.000> 
		<-0.173, 0.000, 0.100> <-0.189, 0.000, 0.073> <-0.200, 0.000, 0.031> <-0.200, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.250, 0.200, 0.000> <-0.250, 0.200, -0.039> <-0.236, 0.200, -0.091> <-0.217, 0.200, -0.125> 
		<-0.250, 0.138, 0.000> <-0.250, 0.138, -0.039> <-0.236, 0.138, -0.091> <-0.217, 0.138, -0.125> 
		<-0.215, 0.060, 0.000> <-0.215, 0.060, -0.031> <-0.202, 0.060, -0.081> <-0.186, 0.060, -0.108> 
		<-0.200, 0.000, 0.000> <-0.200, 0.000, -0.031> <-0.189, 0.000, -0.073> <-0.173, 0.000, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.217, 0.200, -0.125> <-0.197, 0.200, -0.159> <-0.159, 0.200, -0.197> <-0.125, 0.200, -0.217> 
		<-0.217, 0.138, -0.125> <-0.197, 0.138, -0.159> <-0.159, 0.138, -0.197> <-0.125, 0.138, -0.217> 
		<-0.186, 0.060, -0.108> <-0.171, 0.060, -0.134> <-0.134, 0.060, -0.171> <-0.108, 0.060, -0.186> 
		<-0.173, 0.000, -0.100> <-0.158, 0.000, -0.127> <-0.127, 0.000, -0.158> <-0.100, 0.000, -0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.125, 0.200, -0.217> <-0.091, 0.200, -0.236> <-0.039, 0.200, -0.250> <0.000, 0.200, -0.250> 
		<-0.125, 0.138, -0.217> <-0.091, 0.138, -0.236> <-0.039, 0.138, -0.250> <0.000, 0.138, -0.250> 
		<-0.108, 0.060, -0.186> <-0.081, 0.060, -0.202> <-0.031, 0.060, -0.215> <0.000, 0.060, -0.215> 
		<-0.100, 0.000, -0.173> <-0.073, 0.000, -0.189> <-0.031, 0.000, -0.200> <0.000, 0.000, -0.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.200, -0.250> <0.039, 0.200, -0.250> <0.091, 0.200, -0.236> <0.125, 0.200, -0.217> 
		<0.000, 0.138, -0.250> <0.039, 0.138, -0.250> <0.091, 0.138, -0.236> <0.125, 0.138, -0.217> 
		<0.000, 0.060, -0.215> <0.031, 0.060, -0.215> <0.081, 0.060, -0.202> <0.108, 0.060, -0.186> 
		<0.000, 0.000, -0.200> <0.031, 0.000, -0.200> <0.073, 0.000, -0.189> <0.100, 0.000, -0.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.125, 0.200, -0.217> <0.159, 0.200, -0.197> <0.197, 0.200, -0.159> <0.217, 0.200, -0.125> 
		<0.125, 0.138, -0.217> <0.159, 0.138, -0.197> <0.197, 0.138, -0.159> <0.217, 0.138, -0.125> 
		<0.108, 0.060, -0.186> <0.134, 0.060, -0.171> <0.171, 0.060, -0.134> <0.186, 0.060, -0.108> 
		<0.100, 0.000, -0.173> <0.127, 0.000, -0.158> <0.158, 0.000, -0.127> <0.173, 0.000, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.173, 0.000, 0.100> <0.158, 0.000, 0.127> <0.127, 0.000, 0.158> <0.100, 0.000, 0.173> 
		<0.121, 0.000, 0.070> <0.106, 0.000, 0.097> <0.097, 0.000, 0.106> <0.070, 0.000, 0.121> 
		<0.052, 0.000, 0.030> <0.052, 0.000, 0.030> <0.030, 0.000, 0.052> <0.030, 0.000, 0.052> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 0.000, 0.173> <0.073, 0.000, 0.189> <0.031, 0.000, 0.200> <0.000, 0.000, 0.200> 
		<0.070, 0.000, 0.121> <0.043, 0.000, 0.137> <0.031, 0.000, 0.140> <0.000, 0.000, 0.140> 
		<0.030, 0.000, 0.052> <0.030, 0.000, 0.052> <0.000, 0.000, 0.060> <0.000, 0.000, 0.060> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, 0.200> <-0.031, 0.000, 0.200> <-0.073, 0.000, 0.189> <-0.100, 0.000, 0.173> 
		<0.000, 0.000, 0.140> <-0.031, 0.000, 0.140> <-0.043, 0.000, 0.137> <-0.070, 0.000, 0.121> 
		<0.000, 0.000, 0.060> <0.000, 0.000, 0.060> <-0.030, 0.000, 0.052> <-0.030, 0.000, 0.052> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.100, 0.000, 0.173> <-0.127, 0.000, 0.158> <-0.158, 0.000, 0.127> <-0.173, 0.000, 0.100> 
		<-0.070, 0.000, 0.121> <-0.097, 0.000, 0.106> <-0.106, 0.000, 0.097> <-0.121, 0.000, 0.070> 
		<-0.030, 0.000, 0.052> <-0.030, 0.000, 0.052> <-0.052, 0.000, 0.030> <-0.052, 0.000, 0.030> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.173, 0.000, 0.100> <-0.189, 0.000, 0.073> <-0.200, 0.000, 0.031> <-0.200, 0.000, 0.000> 
		<-0.121, 0.000, 0.070> <-0.137, 0.000, 0.043> <-0.140, 0.000, 0.031> <-0.140, 0.000, 0.000> 
		<-0.052, 0.000, 0.030> <-0.052, 0.000, 0.030> <-0.060, 0.000, 0.000> <-0.060, 0.000, 0.000> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.200, 0.000, 0.000> <-0.200, 0.000, -0.031> <-0.189, 0.000, -0.073> <-0.173, 0.000, -0.100> 
		<-0.140, 0.000, 0.000> <-0.140, 0.000, -0.031> <-0.137, 0.000, -0.043> <-0.121, 0.000, -0.070> 
		<-0.060, 0.000, 0.000> <-0.060, 0.000, 0.000> <-0.052, 0.000, -0.030> <-0.052, 0.000, -0.030> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.173, 0.000, -0.100> <-0.158, 0.000, -0.127> <-0.127, 0.000, -0.158> <-0.100, 0.000, -0.173> 
		<-0.121, 0.000, -0.070> <-0.106, 0.000, -0.097> <-0.097, 0.000, -0.106> <-0.070, 0.000, -0.121> 
		<-0.052, 0.000, -0.030> <-0.052, 0.000, -0.030> <-0.030, 0.000, -0.052> <-0.030, 0.000, -0.052> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.100, 0.000, -0.173> <-0.073, 0.000, -0.189> <-0.031, 0.000, -0.200> <0.000, 0.000, -0.200> 
		<-0.070, 0.000, -0.121> <-0.043, 0.000, -0.137> <-0.031, 0.000, -0.140> <0.000, 0.000, -0.140> 
		<-0.030, 0.000, -0.052> <-0.030, 0.000, -0.052> <0.000, 0.000, -0.060> <0.000, 0.000, -0.060> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, -0.200> <0.031, 0.000, -0.200> <0.073, 0.000, -0.189> <0.100, 0.000, -0.173> 
		<0.000, 0.000, -0.140> <0.031, 0.000, -0.140> <0.043, 0.000, -0.137> <0.070, 0.000, -0.121> 
		<0.000, 0.000, -0.060> <0.000, 0.000, -0.060> <0.030, 0.000, -0.052> <0.030, 0.000, -0.052> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 0.000, -0.173> <0.127, 0.000, -0.158> <0.158, 0.000, -0.127> <0.173, 0.000, -0.100> 
		<0.070, 0.000, -0.121> <0.097, 0.000, -0.106> <0.106, 0.000, -0.097> <0.121, 0.000, -0.070> 
		<0.030, 0.000, -0.052> <0.030, 0.000, -0.052> <0.052, 0.000, -0.030> <0.052, 0.000, -0.030> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}

	pigment { rgb < 0.67, 0.57, 0.49 > }
	normal {
		agate 0.05
		scale 0.3
	}
	finish { ambient 0 diffuse 0.65 }
}


#declare FlowerStem =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.084, 0.050, -0.016> <0.084, 0.133, -0.017> <0.084, 0.245, -0.011> <0.084, 0.328, -0.019> 
		<0.084, 0.050, -0.021> <0.084, 0.133, -0.021> <0.084, 0.245, -0.016> <0.084, 0.328, -0.023> 
		<0.091, 0.050, -0.026> <0.091, 0.133, -0.027> <0.091, 0.245, -0.021> <0.091, 0.328, -0.029> 
		<0.096, 0.050, -0.026> <0.096, 0.133, -0.027> <0.096, 0.245, -0.021> <0.096, 0.328, -0.029> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.084, 0.050, -0.016> <0.083, 0.050, -0.011> <0.090, 0.050, -0.005> <0.094, 0.050, -0.005> 
		<0.084, 0.133, -0.017> <0.083, 0.133, -0.012> <0.090, 0.133, -0.006> <0.094, 0.133, -0.006> 
		<0.084, 0.245, -0.011> <0.083, 0.245, -0.006> <0.090, 0.245, -0.000> <0.094, 0.245, -0.000> 
		<0.084, 0.328, -0.019> <0.083, 0.328, -0.014> <0.090, 0.328, -0.008> <0.094, 0.328, -0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.094, 0.050, -0.005> <0.099, 0.050, -0.005> <0.106, 0.050, -0.011> <0.106, 0.050, -0.016> 
		<0.094, 0.133, -0.006> <0.099, 0.133, -0.006> <0.106, 0.133, -0.012> <0.106, 0.133, -0.017> 
		<0.094, 0.245, -0.000> <0.099, 0.245, -0.000> <0.106, 0.245, -0.006> <0.106, 0.245, -0.011> 
		<0.094, 0.328, -0.008> <0.099, 0.328, -0.008> <0.106, 0.328, -0.014> <0.106, 0.328, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.050, -0.016> <0.107, 0.050, -0.020> <0.100, 0.050, -0.026> <0.096, 0.050, -0.026> 
		<0.106, 0.133, -0.017> <0.107, 0.133, -0.021> <0.100, 0.133, -0.027> <0.096, 0.133, -0.027> 
		<0.106, 0.245, -0.011> <0.107, 0.245, -0.015> <0.100, 0.245, -0.021> <0.096, 0.245, -0.021> 
		<0.106, 0.328, -0.018> <0.107, 0.328, -0.023> <0.100, 0.328, -0.029> <0.096, 0.328, -0.029> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.084, 0.914, -0.096> <0.084, 0.911, -0.100> <0.091, 0.914, -0.106> <0.096, 0.914, -0.106> 
		<0.084, 0.738, -0.073> <0.084, 0.736, -0.077> <0.091, 0.738, -0.083> <0.096, 0.738, -0.083> 
		<0.084, 0.505, -0.035> <0.084, 0.505, -0.040> <0.091, 0.505, -0.045> <0.096, 0.505, -0.045> 
		<0.084, 0.328, -0.019> <0.084, 0.328, -0.023> <0.091, 0.328, -0.029> <0.096, 0.328, -0.029> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.084, 0.914, -0.096> <0.084, 0.738, -0.073> <0.084, 0.505, -0.035> <0.084, 0.328, -0.019> 
		<0.083, 0.917, -0.091> <0.083, 0.741, -0.067> <0.083, 0.505, -0.030> <0.083, 0.328, -0.014> 
		<0.088, 0.928, -0.085> <0.088, 0.748, -0.062> <0.090, 0.509, -0.024> <0.090, 0.328, -0.008> 
		<0.094, 0.928, -0.085> <0.094, 0.748, -0.062> <0.094, 0.509, -0.024> <0.094, 0.328, -0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.094, 0.928, -0.085> <0.094, 0.748, -0.062> <0.094, 0.509, -0.024> <0.094, 0.328, -0.008> 
		<0.101, 0.928, -0.085> <0.101, 0.748, -0.062> <0.099, 0.509, -0.024> <0.099, 0.328, -0.008> 
		<0.106, 0.917, -0.090> <0.106, 0.742, -0.067> <0.106, 0.505, -0.030> <0.106, 0.328, -0.014> 
		<0.106, 0.914, -0.096> <0.106, 0.738, -0.073> <0.106, 0.505, -0.035> <0.106, 0.328, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.914, -0.096> <0.106, 0.738, -0.073> <0.106, 0.505, -0.035> <0.106, 0.328, -0.018> 
		<0.107, 0.911, -0.100> <0.107, 0.736, -0.076> <0.107, 0.505, -0.039> <0.107, 0.328, -0.023> 
		<0.100, 0.914, -0.106> <0.100, 0.738, -0.083> <0.100, 0.505, -0.045> <0.100, 0.328, -0.029> 
		<0.096, 0.914, -0.106> <0.096, 0.738, -0.083> <0.096, 0.505, -0.045> <0.096, 0.328, -0.029> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.059, 0.948, -0.096> <0.059, 0.948, -0.077> <0.075, 0.948, -0.061> <0.094, 0.948, -0.061> 
		<0.059, 0.948, -0.115> <0.059, 0.948, -0.096> <0.075, 0.929, -0.061> <0.094, 0.929, -0.061> 
		<0.075, 0.948, -0.132> <0.075, 0.929, -0.132> <0.094, 0.913, -0.096> <0.094, 0.913, -0.077> 
		<0.094, 0.948, -0.132> <0.094, 0.929, -0.132> <0.094, 0.913, -0.115> <0.094, 0.913, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.059, 0.948, -0.096> <0.059, 0.948, -0.096> <0.059, 0.948, -0.096> <0.059, 0.948, -0.096> 
		<0.059, 0.929, -0.096> <0.059, 0.929, -0.115> <0.059, 0.929, -0.115> <0.059, 0.948, -0.115> 
		<0.075, 0.913, -0.096> <0.075, 0.913, -0.115> <0.075, 0.929, -0.132> <0.075, 0.948, -0.132> 
		<0.094, 0.913, -0.096> <0.094, 0.913, -0.115> <0.094, 0.929, -0.132> <0.094, 0.948, -0.132> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.059, 0.948, -0.096> <0.059, 0.948, -0.115> <0.075, 0.948, -0.132> <0.094, 0.948, -0.132> 
		<0.059, 0.948, -0.077> <0.059, 0.948, -0.096> <0.075, 0.967, -0.132> <0.094, 0.967, -0.132> 
		<0.075, 0.948, -0.061> <0.075, 0.967, -0.061> <0.094, 0.983, -0.096> <0.094, 0.983, -0.115> 
		<0.094, 0.948, -0.061> <0.094, 0.967, -0.061> <0.094, 0.983, -0.077> <0.094, 0.983, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.059, 0.948, -0.096> <0.059, 0.948, -0.096> <0.059, 0.948, -0.096> <0.059, 0.948, -0.096> 
		<0.059, 0.967, -0.096> <0.059, 0.967, -0.115> <0.059, 0.967, -0.115> <0.059, 0.948, -0.115> 
		<0.075, 0.983, -0.096> <0.075, 0.983, -0.115> <0.075, 0.967, -0.132> <0.075, 0.948, -0.132> 
		<0.094, 0.983, -0.096> <0.094, 0.983, -0.115> <0.094, 0.967, -0.132> <0.094, 0.948, -0.132> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.059, 0.948, -0.096> <0.059, 0.948, -0.115> <0.075, 0.948, -0.132> <0.094, 0.948, -0.132> 
		<0.059, 0.967, -0.096> <0.059, 0.967, -0.115> <0.094, 0.948, -0.132> <0.113, 0.948, -0.132> 
		<0.075, 0.983, -0.096> <0.094, 0.983, -0.096> <0.129, 0.967, -0.115> <0.129, 0.948, -0.115> 
		<0.094, 0.983, -0.096> <0.113, 0.983, -0.096> <0.129, 0.967, -0.096> <0.129, 0.948, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.059, 0.948, -0.096> <0.059, 0.948, -0.115> <0.075, 0.948, -0.132> <0.094, 0.948, -0.132> 
		<0.059, 0.929, -0.096> <0.059, 0.929, -0.115> <0.094, 0.948, -0.132> <0.113, 0.948, -0.132> 
		<0.075, 0.913, -0.096> <0.094, 0.913, -0.096> <0.129, 0.929, -0.115> <0.129, 0.948, -0.115> 
		<0.094, 0.913, -0.096> <0.113, 0.913, -0.096> <0.129, 0.929, -0.096> <0.129, 0.948, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.059, 0.948, -0.096> <0.059, 0.948, -0.096> <0.059, 0.948, -0.096> <0.059, 0.948, -0.096> 
		<0.059, 0.967, -0.096> <0.059, 0.967, -0.077> <0.059, 0.967, -0.077> <0.059, 0.948, -0.077> 
		<0.075, 0.983, -0.096> <0.075, 0.983, -0.077> <0.075, 0.967, -0.061> <0.075, 0.948, -0.061> 
		<0.094, 0.983, -0.096> <0.094, 0.983, -0.077> <0.094, 0.967, -0.061> <0.094, 0.948, -0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.059, 0.948, -0.096> <0.059, 0.948, -0.096> <0.059, 0.948, -0.096> <0.059, 0.948, -0.096> 
		<0.059, 0.948, -0.077> <0.059, 0.929, -0.077> <0.059, 0.929, -0.077> <0.059, 0.929, -0.096> 
		<0.075, 0.948, -0.061> <0.075, 0.929, -0.061> <0.075, 0.913, -0.077> <0.075, 0.913, -0.096> 
		<0.094, 0.948, -0.061> <0.094, 0.929, -0.061> <0.094, 0.913, -0.077> <0.094, 0.913, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.059, 0.948, -0.096> <0.059, 0.967, -0.096> <0.075, 0.983, -0.096> <0.094, 0.983, -0.096> 
		<0.059, 0.948, -0.077> <0.059, 0.967, -0.077> <0.094, 0.983, -0.096> <0.113, 0.983, -0.096> 
		<0.075, 0.948, -0.061> <0.094, 0.948, -0.061> <0.129, 0.967, -0.077> <0.129, 0.967, -0.096> 
		<0.094, 0.948, -0.061> <0.113, 0.948, -0.061> <0.129, 0.948, -0.077> <0.129, 0.948, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.059, 0.948, -0.096> <0.059, 0.948, -0.077> <0.075, 0.948, -0.061> <0.094, 0.948, -0.061> 
		<0.059, 0.929, -0.096> <0.059, 0.929, -0.077> <0.094, 0.948, -0.061> <0.113, 0.948, -0.061> 
		<0.075, 0.913, -0.096> <0.094, 0.913, -0.096> <0.129, 0.929, -0.077> <0.129, 0.948, -0.077> 
		<0.094, 0.913, -0.096> <0.113, 0.913, -0.096> <0.129, 0.929, -0.096> <0.129, 0.948, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.059, 0.948, -0.096> <0.059, 0.929, -0.096> <0.075, 0.913, -0.096> <0.094, 0.913, -0.096> 
		<0.059, 0.967, -0.096> <0.059, 0.948, -0.096> <0.075, 0.913, -0.077> <0.094, 0.913, -0.077> 
		<0.075, 0.983, -0.096> <0.075, 0.983, -0.077> <0.094, 0.948, -0.061> <0.094, 0.929, -0.061> 
		<0.094, 0.983, -0.096> <0.094, 0.983, -0.077> <0.094, 0.967, -0.061> <0.094, 0.948, -0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.059, 0.948, -0.096> <0.059, 0.929, -0.096> <0.075, 0.913, -0.096> <0.094, 0.913, -0.096> 
		<0.059, 0.967, -0.096> <0.059, 0.948, -0.096> <0.075, 0.913, -0.115> <0.094, 0.913, -0.115> 
		<0.075, 0.983, -0.096> <0.075, 0.983, -0.115> <0.094, 0.948, -0.132> <0.094, 0.929, -0.132> 
		<0.094, 0.983, -0.096> <0.094, 0.983, -0.115> <0.094, 0.967, -0.132> <0.094, 0.948, -0.132> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.129, 0.948, -0.096> <0.129, 0.948, -0.077> <0.113, 0.948, -0.061> <0.094, 0.948, -0.061> 
		<0.129, 0.948, -0.115> <0.129, 0.948, -0.096> <0.113, 0.967, -0.061> <0.094, 0.967, -0.061> 
		<0.113, 0.948, -0.132> <0.113, 0.967, -0.132> <0.094, 0.983, -0.096> <0.094, 0.983, -0.077> 
		<0.094, 0.948, -0.132> <0.094, 0.967, -0.132> <0.094, 0.983, -0.115> <0.094, 0.983, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.129, 0.948, -0.096> <0.129, 0.948, -0.096> <0.129, 0.948, -0.096> <0.129, 0.948, -0.096> 
		<0.129, 0.967, -0.096> <0.129, 0.967, -0.077> <0.129, 0.967, -0.077> <0.129, 0.948, -0.077> 
		<0.113, 0.983, -0.096> <0.113, 0.983, -0.077> <0.113, 0.967, -0.061> <0.113, 0.948, -0.061> 
		<0.094, 0.983, -0.096> <0.094, 0.983, -0.077> <0.094, 0.967, -0.061> <0.094, 0.948, -0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.129, 0.948, -0.096> <0.129, 0.948, -0.115> <0.113, 0.948, -0.132> <0.094, 0.948, -0.132> 
		<0.129, 0.948, -0.077> <0.129, 0.948, -0.096> <0.113, 0.929, -0.132> <0.094, 0.929, -0.132> 
		<0.113, 0.948, -0.061> <0.113, 0.929, -0.061> <0.094, 0.913, -0.096> <0.094, 0.913, -0.115> 
		<0.094, 0.948, -0.061> <0.094, 0.929, -0.061> <0.094, 0.913, -0.077> <0.094, 0.913, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.129, 0.948, -0.096> <0.129, 0.948, -0.096> <0.129, 0.948, -0.096> <0.129, 0.948, -0.096> 
		<0.129, 0.929, -0.096> <0.129, 0.929, -0.077> <0.129, 0.929, -0.077> <0.129, 0.948, -0.077> 
		<0.113, 0.913, -0.096> <0.113, 0.913, -0.077> <0.113, 0.929, -0.061> <0.113, 0.948, -0.061> 
		<0.094, 0.913, -0.096> <0.094, 0.913, -0.077> <0.094, 0.929, -0.061> <0.094, 0.948, -0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.129, 0.948, -0.096> <0.129, 0.948, -0.096> <0.129, 0.948, -0.096> <0.129, 0.948, -0.096> 
		<0.129, 0.929, -0.096> <0.129, 0.929, -0.115> <0.129, 0.929, -0.115> <0.129, 0.948, -0.115> 
		<0.113, 0.913, -0.096> <0.113, 0.913, -0.115> <0.113, 0.929, -0.132> <0.113, 0.948, -0.132> 
		<0.094, 0.913, -0.096> <0.094, 0.913, -0.115> <0.094, 0.929, -0.132> <0.094, 0.948, -0.132> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.129, 0.948, -0.096> <0.129, 0.948, -0.096> <0.129, 0.948, -0.096> <0.129, 0.948, -0.096> 
		<0.129, 0.967, -0.096> <0.129, 0.967, -0.115> <0.129, 0.967, -0.115> <0.129, 0.948, -0.115> 
		<0.113, 0.983, -0.096> <0.113, 0.983, -0.115> <0.113, 0.967, -0.132> <0.113, 0.948, -0.132> 
		<0.094, 0.983, -0.096> <0.094, 0.983, -0.115> <0.094, 0.967, -0.132> <0.094, 0.948, -0.132> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.129, 0.948, -0.096> <0.129, 0.967, -0.096> <0.113, 0.983, -0.096> <0.094, 0.983, -0.096> 
		<0.129, 0.929, -0.096> <0.129, 0.948, -0.096> <0.113, 0.983, -0.115> <0.094, 0.983, -0.115> 
		<0.113, 0.913, -0.096> <0.113, 0.913, -0.115> <0.094, 0.948, -0.132> <0.094, 0.967, -0.132> 
		<0.094, 0.913, -0.096> <0.094, 0.913, -0.115> <0.094, 0.929, -0.132> <0.094, 0.948, -0.132> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.129, 0.948, -0.096> <0.129, 0.967, -0.096> <0.113, 0.983, -0.096> <0.094, 0.983, -0.096> 
		<0.129, 0.929, -0.096> <0.129, 0.948, -0.096> <0.113, 0.983, -0.077> <0.094, 0.983, -0.077> 
		<0.113, 0.913, -0.096> <0.113, 0.913, -0.077> <0.094, 0.948, -0.061> <0.094, 0.967, -0.061> 
		<0.094, 0.913, -0.096> <0.094, 0.913, -0.077> <0.094, 0.929, -0.061> <0.094, 0.948, -0.061> 
	}
	
	pigment { rgb < 0.53, 0.37, 0.19 > }
}

#declare FlowerPetals =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.063, 0.948, -0.129> <0.051, 0.943, -0.130> <0.032, 0.944, -0.130> <0.021, 0.948, -0.129> 
		<0.069, 0.951, -0.128> <0.057, 0.946, -0.129> <0.035, 0.954, -0.134> <0.023, 0.958, -0.133> 
		<0.074, 0.964, -0.124> <0.066, 0.973, -0.121> <0.041, 0.975, -0.127> <0.028, 0.976, -0.127> 
		<0.070, 0.969, -0.122> <0.061, 0.978, -0.119> <0.043, 0.981, -0.118> <0.030, 0.982, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.063, 0.948, -0.129> <0.063, 0.948, -0.129> <0.063, 0.948, -0.129> <0.063, 0.948, -0.129> 
		<0.051, 0.943, -0.130> <0.057, 0.946, -0.129> <0.057, 0.946, -0.129> <0.069, 0.951, -0.128> 
		<0.032, 0.944, -0.130> <0.047, 0.950, -0.128> <0.061, 0.961, -0.133> <0.074, 0.964, -0.124> 
		<0.021, 0.948, -0.129> <0.035, 0.955, -0.127> <0.057, 0.966, -0.131> <0.070, 0.969, -0.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.063, 0.948, -0.129> <0.069, 0.951, -0.128> <0.074, 0.964, -0.124> <0.070, 0.969, -0.122> 
		<0.063, 0.946, -0.120> <0.069, 0.948, -0.119> <0.082, 0.966, -0.119> <0.077, 0.971, -0.117> 
		<0.063, 0.942, -0.109> <0.069, 0.945, -0.108> <0.082, 0.960, -0.098> <0.077, 0.965, -0.097> 
		<0.063, 0.939, -0.100> <0.069, 0.942, -0.099> <0.074, 0.955, -0.095> <0.070, 0.960, -0.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.063, 0.948, -0.129> <0.063, 0.946, -0.120> <0.063, 0.942, -0.109> <0.063, 0.939, -0.100> 
		<0.051, 0.943, -0.130> <0.051, 0.941, -0.122> <0.051, 0.937, -0.110> <0.051, 0.935, -0.102> 
		<0.032, 0.944, -0.130> <0.030, 0.936, -0.127> <0.025, 0.934, -0.106> <0.033, 0.936, -0.101> 
		<0.021, 0.948, -0.129> <0.019, 0.940, -0.125> <0.013, 0.938, -0.105> <0.021, 0.939, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 0.975, -0.120> <-0.011, 0.964, -0.124> <0.009, 0.953, -0.127> <0.021, 0.948, -0.129> 
		<-0.005, 0.986, -0.117> <-0.008, 0.975, -0.120> <0.024, 0.959, -0.125> <0.035, 0.955, -0.127> 
		<0.019, 0.983, -0.118> <0.031, 0.982, -0.118> <0.048, 0.975, -0.128> <0.057, 0.966, -0.131> 
		<0.030, 0.982, -0.118> <0.043, 0.981, -0.118> <0.061, 0.978, -0.119> <0.070, 0.969, -0.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 0.975, -0.120> <-0.011, 0.964, -0.124> <0.009, 0.953, -0.127> <0.021, 0.948, -0.129> 
		<-0.009, 0.971, -0.112> <-0.012, 0.960, -0.116> <0.008, 0.945, -0.124> <0.019, 0.940, -0.125> 
		<-0.018, 0.962, -0.099> <-0.021, 0.951, -0.102> <0.002, 0.941, -0.104> <0.013, 0.938, -0.105> 
		<-0.010, 0.961, -0.093> <-0.014, 0.951, -0.097> <0.009, 0.943, -0.099> <0.021, 0.939, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 0.975, -0.120> <-0.008, 0.975, -0.120> <-0.008, 0.975, -0.120> <-0.008, 0.975, -0.120> 
		<-0.011, 0.964, -0.124> <-0.008, 0.975, -0.120> <-0.008, 0.975, -0.120> <-0.005, 0.986, -0.117> 
		<0.009, 0.953, -0.127> <0.012, 0.963, -0.131> <0.016, 0.977, -0.127> <0.019, 0.983, -0.118> 
		<0.021, 0.948, -0.129> <0.023, 0.958, -0.133> <0.028, 0.976, -0.127> <0.030, 0.982, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 0.975, -0.120> <-0.005, 0.986, -0.117> <0.019, 0.983, -0.118> <0.030, 0.982, -0.118> 
		<-0.009, 0.971, -0.112> <-0.006, 0.982, -0.109> <0.020, 0.988, -0.110> <0.032, 0.987, -0.111> 
		<-0.018, 0.962, -0.099> <-0.014, 0.973, -0.095> <0.024, 0.977, -0.094> <0.037, 0.977, -0.094> 
		<-0.010, 0.961, -0.093> <-0.007, 0.973, -0.090> <0.017, 0.974, -0.090> <0.030, 0.974, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, 0.975, -0.120> <-0.005, 0.986, -0.117> <0.019, 0.983, -0.118> <0.030, 0.982, -0.118> 
		<-0.009, 0.971, -0.112> <-0.006, 0.982, -0.109> <0.020, 0.988, -0.110> <0.032, 0.987, -0.111> 
		<-0.018, 0.962, -0.099> <-0.008, 0.961, -0.091> <0.027, 0.972, -0.088> <0.037, 0.977, -0.094> 
		<-0.010, 0.961, -0.093> <-0.000, 0.961, -0.085> <0.020, 0.968, -0.084> <0.030, 0.974, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.063, 0.939, -0.100> <0.063, 0.939, -0.100> <0.063, 0.939, -0.100> <0.063, 0.939, -0.100> 
		<0.051, 0.935, -0.102> <0.057, 0.937, -0.101> <0.057, 0.937, -0.101> <0.069, 0.942, -0.099> 
		<0.033, 0.936, -0.101> <0.046, 0.939, -0.092> <0.061, 0.948, -0.090> <0.074, 0.955, -0.095> 
		<0.021, 0.939, -0.100> <0.033, 0.943, -0.091> <0.057, 0.952, -0.088> <0.070, 0.960, -0.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.030, 0.982, -0.118> <0.030, 0.982, -0.118> <0.030, 0.982, -0.118> <0.030, 0.982, -0.118> 
		<0.043, 0.981, -0.118> <0.041, 0.975, -0.127> <0.041, 0.975, -0.127> <0.028, 0.976, -0.127> 
		<0.061, 0.978, -0.119> <0.048, 0.975, -0.128> <0.038, 0.965, -0.131> <0.023, 0.958, -0.133> 
		<0.070, 0.969, -0.122> <0.057, 0.966, -0.131> <0.035, 0.955, -0.127> <0.021, 0.948, -0.129> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.030, 0.982, -0.118> <0.043, 0.981, -0.118> <0.061, 0.978, -0.119> <0.070, 0.969, -0.122> 
		<0.032, 0.987, -0.111> <0.045, 0.986, -0.111> <0.068, 0.980, -0.114> <0.077, 0.971, -0.117> 
		<0.037, 0.977, -0.094> <0.050, 0.977, -0.094> <0.068, 0.973, -0.094> <0.077, 0.965, -0.097> 
		<0.030, 0.974, -0.090> <0.043, 0.973, -0.090> <0.061, 0.969, -0.091> <0.070, 0.960, -0.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.021, 0.939, -0.100> <0.009, 0.943, -0.099> <-0.014, 0.951, -0.097> <-0.010, 0.961, -0.093> 
		<0.033, 0.943, -0.091> <0.022, 0.946, -0.090> <-0.010, 0.962, -0.093> <-0.007, 0.973, -0.090> 
		<0.057, 0.952, -0.088> <0.048, 0.961, -0.085> <0.030, 0.974, -0.090> <0.017, 0.974, -0.090> 
		<0.070, 0.960, -0.094> <0.061, 0.969, -0.091> <0.043, 0.973, -0.090> <0.030, 0.974, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.021, 0.939, -0.100> <0.009, 0.943, -0.099> <-0.014, 0.951, -0.097> <-0.010, 0.961, -0.093> 
		<0.033, 0.943, -0.091> <0.022, 0.946, -0.090> <-0.004, 0.950, -0.089> <-0.000, 0.961, -0.085> 
		<0.057, 0.952, -0.088> <0.048, 0.961, -0.085> <0.033, 0.968, -0.084> <0.020, 0.968, -0.084> 
		<0.070, 0.960, -0.094> <0.061, 0.969, -0.091> <0.043, 0.973, -0.090> <0.030, 0.974, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.067, 0.936, -0.133> <0.059, 0.927, -0.136> <0.043, 0.917, -0.139> <0.030, 0.915, -0.139> 
		<0.070, 0.939, -0.132> <0.062, 0.930, -0.135> <0.041, 0.926, -0.143> <0.028, 0.923, -0.144> 
		<0.068, 0.950, -0.128> <0.055, 0.952, -0.128> <0.035, 0.944, -0.137> <0.022, 0.939, -0.139> 
		<0.064, 0.951, -0.128> <0.051, 0.953, -0.127> <0.032, 0.948, -0.129> <0.020, 0.944, -0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.067, 0.936, -0.133> <0.067, 0.936, -0.133> <0.067, 0.936, -0.133> <0.067, 0.936, -0.133> 
		<0.059, 0.927, -0.136> <0.062, 0.930, -0.135> <0.062, 0.930, -0.135> <0.070, 0.939, -0.132> 
		<0.043, 0.917, -0.139> <0.053, 0.928, -0.135> <0.060, 0.943, -0.139> <0.068, 0.950, -0.128> 
		<0.030, 0.915, -0.139> <0.040, 0.926, -0.136> <0.055, 0.944, -0.138> <0.064, 0.951, -0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.067, 0.936, -0.133> <0.070, 0.939, -0.132> <0.068, 0.950, -0.128> <0.064, 0.951, -0.128> 
		<0.067, 0.933, -0.124> <0.070, 0.937, -0.123> <0.073, 0.954, -0.122> <0.069, 0.955, -0.122> 
		<0.067, 0.930, -0.112> <0.070, 0.933, -0.111> <0.073, 0.948, -0.102> <0.069, 0.948, -0.102> 
		<0.067, 0.927, -0.104> <0.070, 0.930, -0.103> <0.068, 0.941, -0.100> <0.064, 0.941, -0.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.067, 0.936, -0.133> <0.067, 0.933, -0.124> <0.067, 0.930, -0.112> <0.067, 0.927, -0.104> 
		<0.059, 0.927, -0.136> <0.059, 0.924, -0.127> <0.059, 0.920, -0.115> <0.059, 0.918, -0.107> 
		<0.043, 0.917, -0.139> <0.045, 0.909, -0.134> <0.038, 0.904, -0.116> <0.043, 0.908, -0.110> 
		<0.030, 0.915, -0.139> <0.032, 0.907, -0.135> <0.025, 0.902, -0.117> <0.030, 0.906, -0.110> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.022, 0.918, -0.138> <-0.017, 0.904, -0.143> <0.015, 0.912, -0.140> <0.030, 0.915, -0.139> 
		<-0.027, 0.932, -0.134> <-0.022, 0.918, -0.138> <0.025, 0.923, -0.137> <0.040, 0.926, -0.136> 
		<0.006, 0.939, -0.132> <0.018, 0.943, -0.130> <0.042, 0.946, -0.138> <0.055, 0.944, -0.138> 
		<0.020, 0.944, -0.130> <0.032, 0.948, -0.129> <0.051, 0.953, -0.127> <0.064, 0.951, -0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.022, 0.918, -0.138> <-0.017, 0.904, -0.143> <0.015, 0.912, -0.140> <0.030, 0.915, -0.139> 
		<-0.022, 0.916, -0.129> <-0.017, 0.902, -0.134> <0.017, 0.904, -0.136> <0.032, 0.907, -0.135> 
		<-0.028, 0.908, -0.115> <-0.023, 0.894, -0.119> <0.010, 0.899, -0.118> <0.025, 0.902, -0.117> 
		<-0.021, 0.910, -0.109> <-0.016, 0.896, -0.113> <0.015, 0.903, -0.111> <0.030, 0.906, -0.110> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.022, 0.918, -0.138> <-0.022, 0.918, -0.138> <-0.022, 0.918, -0.138> <-0.022, 0.918, -0.138> 
		<-0.017, 0.904, -0.143> <-0.022, 0.918, -0.138> <-0.022, 0.918, -0.138> <-0.027, 0.932, -0.134> 
		<0.015, 0.912, -0.140> <0.013, 0.920, -0.145> <0.008, 0.934, -0.140> <0.006, 0.939, -0.132> 
		<0.030, 0.915, -0.139> <0.028, 0.923, -0.144> <0.022, 0.939, -0.139> <0.020, 0.944, -0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.022, 0.918, -0.138> <-0.027, 0.932, -0.134> <0.006, 0.939, -0.132> <0.020, 0.944, -0.130> 
		<-0.022, 0.916, -0.129> <-0.027, 0.930, -0.125> <0.004, 0.943, -0.124> <0.018, 0.948, -0.122> 
		<-0.028, 0.908, -0.115> <-0.032, 0.921, -0.111> <0.013, 0.935, -0.106> <0.027, 0.940, -0.105> 
		<-0.021, 0.910, -0.109> <-0.026, 0.923, -0.105> <0.007, 0.930, -0.103> <0.020, 0.935, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.022, 0.918, -0.138> <-0.027, 0.932, -0.134> <0.006, 0.939, -0.132> <0.020, 0.944, -0.130> 
		<-0.022, 0.916, -0.129> <-0.027, 0.930, -0.125> <0.004, 0.943, -0.124> <0.018, 0.948, -0.122> 
		<-0.028, 0.908, -0.115> <-0.017, 0.912, -0.106> <0.016, 0.932, -0.099> <0.027, 0.940, -0.105> 
		<-0.021, 0.910, -0.109> <-0.011, 0.914, -0.100> <0.010, 0.926, -0.096> <0.020, 0.935, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.067, 0.927, -0.104> <0.067, 0.927, -0.104> <0.067, 0.927, -0.104> <0.067, 0.927, -0.104> 
		<0.059, 0.918, -0.107> <0.062, 0.921, -0.106> <0.062, 0.921, -0.106> <0.070, 0.930, -0.103> 
		<0.043, 0.908, -0.110> <0.052, 0.915, -0.099> <0.060, 0.929, -0.095> <0.068, 0.941, -0.100> 
		<0.030, 0.906, -0.110> <0.039, 0.913, -0.100> <0.055, 0.930, -0.095> <0.064, 0.941, -0.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.020, 0.944, -0.130> <0.020, 0.944, -0.130> <0.020, 0.944, -0.130> <0.020, 0.944, -0.130> 
		<0.032, 0.948, -0.129> <0.035, 0.944, -0.137> <0.035, 0.944, -0.137> <0.022, 0.939, -0.139> 
		<0.051, 0.953, -0.127> <0.042, 0.946, -0.138> <0.038, 0.934, -0.140> <0.028, 0.923, -0.144> 
		<0.064, 0.951, -0.128> <0.055, 0.944, -0.138> <0.040, 0.926, -0.136> <0.030, 0.915, -0.139> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.020, 0.944, -0.130> <0.032, 0.948, -0.129> <0.051, 0.953, -0.127> <0.064, 0.951, -0.128> 
		<0.018, 0.948, -0.122> <0.030, 0.952, -0.121> <0.056, 0.957, -0.121> <0.069, 0.955, -0.122> 
		<0.027, 0.940, -0.105> <0.039, 0.945, -0.103> <0.056, 0.951, -0.101> <0.069, 0.948, -0.102> 
		<0.020, 0.935, -0.101> <0.032, 0.939, -0.100> <0.051, 0.944, -0.099> <0.064, 0.941, -0.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.030, 0.906, -0.110> <0.015, 0.903, -0.111> <-0.016, 0.896, -0.113> <-0.021, 0.910, -0.109> 
		<0.039, 0.913, -0.100> <0.024, 0.910, -0.101> <-0.021, 0.909, -0.109> <-0.026, 0.923, -0.105> 
		<0.055, 0.930, -0.095> <0.042, 0.932, -0.094> <0.019, 0.934, -0.102> <0.007, 0.930, -0.103> 
		<0.064, 0.941, -0.099> <0.051, 0.944, -0.099> <0.032, 0.939, -0.100> <0.020, 0.935, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.030, 0.906, -0.110> <0.015, 0.903, -0.111> <-0.016, 0.896, -0.113> <-0.021, 0.910, -0.109> 
		<0.039, 0.913, -0.100> <0.024, 0.910, -0.101> <-0.006, 0.900, -0.104> <-0.011, 0.914, -0.100> 
		<0.055, 0.930, -0.095> <0.042, 0.932, -0.094> <0.022, 0.931, -0.095> <0.010, 0.926, -0.096> 
		<0.064, 0.941, -0.099> <0.051, 0.944, -0.099> <0.032, 0.939, -0.100> <0.020, 0.935, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.082, 0.991, -0.116> <0.076, 1.002, -0.112> <0.077, 1.020, -0.107> <0.078, 1.032, -0.103> 
		<0.086, 0.985, -0.117> <0.079, 0.996, -0.114> <0.085, 1.020, -0.114> <0.087, 1.032, -0.110> 
		<0.100, 0.981, -0.119> <0.109, 0.990, -0.116> <0.109, 1.017, -0.115> <0.107, 1.029, -0.111> 
		<0.105, 0.986, -0.117> <0.114, 0.995, -0.114> <0.117, 1.013, -0.109> <0.116, 1.025, -0.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.082, 0.991, -0.116> <0.082, 0.991, -0.116> <0.082, 0.991, -0.116> <0.082, 0.991, -0.116> 
		<0.076, 1.002, -0.112> <0.079, 0.996, -0.114> <0.079, 0.996, -0.114> <0.086, 0.985, -0.117> 
		<0.077, 1.020, -0.107> <0.085, 1.006, -0.111> <0.093, 0.995, -0.122> <0.100, 0.981, -0.119> 
		<0.078, 1.032, -0.103> <0.086, 1.018, -0.107> <0.098, 1.000, -0.121> <0.105, 0.986, -0.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.082, 0.991, -0.116> <0.086, 0.985, -0.117> <0.100, 0.981, -0.119> <0.105, 0.986, -0.117> 
		<0.082, 0.988, -0.107> <0.086, 0.982, -0.109> <0.104, 0.973, -0.117> <0.109, 0.978, -0.115> 
		<0.082, 0.985, -0.095> <0.086, 0.979, -0.097> <0.104, 0.967, -0.096> <0.109, 0.972, -0.094> 
		<0.082, 0.982, -0.087> <0.086, 0.976, -0.089> <0.100, 0.972, -0.090> <0.105, 0.977, -0.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.082, 0.991, -0.116> <0.082, 0.988, -0.107> <0.082, 0.985, -0.095> <0.082, 0.982, -0.087> 
		<0.076, 1.002, -0.112> <0.076, 0.999, -0.104> <0.076, 0.995, -0.092> <0.076, 0.993, -0.083> 
		<0.077, 1.020, -0.107> <0.070, 1.019, -0.101> <0.073, 1.018, -0.080> <0.077, 1.011, -0.078> 
		<0.078, 1.032, -0.103> <0.071, 1.031, -0.097> <0.075, 1.031, -0.076> <0.078, 1.023, -0.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.070, -0.091> <0.081, 1.072, -0.090> <0.080, 1.044, -0.099> <0.078, 1.032, -0.103> 
		<0.108, 1.067, -0.092> <0.096, 1.069, -0.091> <0.088, 1.030, -0.103> <0.086, 1.018, -0.107> 
		<0.113, 1.040, -0.100> <0.115, 1.028, -0.104> <0.107, 1.009, -0.118> <0.098, 1.000, -0.121> 
		<0.116, 1.025, -0.105> <0.117, 1.013, -0.109> <0.114, 0.995, -0.114> <0.105, 0.986, -0.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.070, -0.091> <0.081, 1.072, -0.090> <0.080, 1.044, -0.099> <0.078, 1.032, -0.103> 
		<0.093, 1.067, -0.082> <0.081, 1.069, -0.082> <0.073, 1.043, -0.093> <0.071, 1.031, -0.097> 
		<0.090, 1.069, -0.064> <0.077, 1.071, -0.064> <0.076, 1.043, -0.072> <0.075, 1.031, -0.076> 
		<0.093, 1.061, -0.062> <0.081, 1.063, -0.061> <0.080, 1.035, -0.070> <0.078, 1.023, -0.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.070, -0.091> <0.093, 1.070, -0.091> <0.093, 1.070, -0.091> <0.093, 1.070, -0.091> 
		<0.081, 1.072, -0.090> <0.096, 1.069, -0.091> <0.096, 1.069, -0.091> <0.108, 1.067, -0.092> 
		<0.080, 1.044, -0.099> <0.089, 1.044, -0.106> <0.105, 1.044, -0.106> <0.113, 1.040, -0.100> 
		<0.078, 1.032, -0.103> <0.087, 1.032, -0.110> <0.107, 1.029, -0.111> <0.116, 1.025, -0.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.070, -0.091> <0.108, 1.067, -0.092> <0.113, 1.040, -0.100> <0.116, 1.025, -0.105> 
		<0.093, 1.067, -0.082> <0.108, 1.064, -0.083> <0.120, 1.037, -0.095> <0.123, 1.023, -0.100> 
		<0.090, 1.069, -0.064> <0.105, 1.066, -0.065> <0.117, 1.026, -0.078> <0.119, 1.011, -0.082> 
		<0.093, 1.061, -0.062> <0.108, 1.058, -0.063> <0.113, 1.031, -0.071> <0.116, 1.016, -0.076> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 1.070, -0.091> <0.108, 1.067, -0.092> <0.113, 1.040, -0.100> <0.116, 1.025, -0.105> 
		<0.093, 1.067, -0.082> <0.108, 1.064, -0.083> <0.120, 1.037, -0.095> <0.123, 1.023, -0.100> 
		<0.090, 1.069, -0.064> <0.095, 1.055, -0.060> <0.113, 1.020, -0.071> <0.119, 1.011, -0.082> 
		<0.093, 1.061, -0.062> <0.099, 1.047, -0.058> <0.110, 1.026, -0.065> <0.116, 1.016, -0.076> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.082, 0.982, -0.087> <0.082, 0.982, -0.087> <0.082, 0.982, -0.087> <0.082, 0.982, -0.087> 
		<0.076, 0.993, -0.083> <0.079, 0.987, -0.085> <0.079, 0.987, -0.085> <0.086, 0.976, -0.089> 
		<0.077, 1.011, -0.078> <0.084, 0.996, -0.074> <0.093, 0.982, -0.078> <0.100, 0.972, -0.090> 
		<0.078, 1.023, -0.074> <0.085, 1.008, -0.070> <0.098, 0.987, -0.077> <0.105, 0.977, -0.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.116, 1.025, -0.105> <0.116, 1.025, -0.105> <0.116, 1.025, -0.105> <0.116, 1.025, -0.105> 
		<0.117, 1.013, -0.109> <0.109, 1.017, -0.115> <0.109, 1.017, -0.115> <0.107, 1.029, -0.111> 
		<0.114, 0.995, -0.114> <0.107, 1.009, -0.118> <0.095, 1.019, -0.114> <0.087, 1.032, -0.110> 
		<0.105, 0.986, -0.117> <0.098, 1.000, -0.121> <0.086, 1.018, -0.107> <0.078, 1.032, -0.103> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.116, 1.025, -0.105> <0.117, 1.013, -0.109> <0.114, 0.995, -0.114> <0.105, 0.986, -0.117> 
		<0.123, 1.023, -0.100> <0.124, 1.010, -0.103> <0.118, 0.987, -0.112> <0.109, 0.978, -0.115> 
		<0.119, 1.011, -0.082> <0.121, 0.999, -0.086> <0.118, 0.981, -0.092> <0.109, 0.972, -0.094> 
		<0.116, 1.016, -0.076> <0.117, 1.004, -0.080> <0.114, 0.986, -0.085> <0.105, 0.977, -0.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.078, 1.023, -0.074> <0.080, 1.035, -0.070> <0.081, 1.063, -0.061> <0.093, 1.061, -0.062> 
		<0.085, 1.008, -0.070> <0.087, 1.020, -0.066> <0.096, 1.060, -0.062> <0.108, 1.058, -0.063> 
		<0.098, 0.987, -0.077> <0.107, 0.996, -0.074> <0.115, 1.019, -0.075> <0.113, 1.031, -0.071> 
		<0.105, 0.977, -0.088> <0.114, 0.986, -0.085> <0.117, 1.004, -0.080> <0.116, 1.016, -0.076> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.078, 1.023, -0.074> <0.080, 1.035, -0.070> <0.081, 1.063, -0.061> <0.093, 1.061, -0.062> 
		<0.085, 1.008, -0.070> <0.087, 1.020, -0.066> <0.086, 1.049, -0.058> <0.099, 1.047, -0.058> 
		<0.098, 0.987, -0.077> <0.107, 0.996, -0.074> <0.112, 1.013, -0.069> <0.110, 1.026, -0.065> 
		<0.105, 0.977, -0.088> <0.114, 0.986, -0.085> <0.117, 1.004, -0.080> <0.116, 1.016, -0.076> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.114, 0.969, -0.123> <0.122, 0.977, -0.120> <0.138, 0.983, -0.118> <0.149, 0.984, -0.118> 
		<0.109, 0.964, -0.124> <0.117, 0.972, -0.121> <0.139, 0.977, -0.128> <0.151, 0.978, -0.128> 
		<0.108, 0.950, -0.128> <0.119, 0.944, -0.130> <0.143, 0.953, -0.135> <0.155, 0.957, -0.134> 
		<0.114, 0.946, -0.129> <0.125, 0.940, -0.131> <0.145, 0.941, -0.131> <0.157, 0.946, -0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.114, 0.969, -0.123> <0.114, 0.969, -0.123> <0.114, 0.969, -0.123> <0.114, 0.969, -0.123> 
		<0.122, 0.977, -0.120> <0.117, 0.972, -0.121> <0.117, 0.972, -0.121> <0.109, 0.964, -0.124> 
		<0.138, 0.983, -0.118> <0.127, 0.972, -0.122> <0.117, 0.962, -0.133> <0.108, 0.950, -0.128> 
		<0.149, 0.984, -0.118> <0.139, 0.973, -0.121> <0.123, 0.959, -0.134> <0.114, 0.946, -0.129> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.114, 0.969, -0.123> <0.109, 0.964, -0.124> <0.108, 0.950, -0.128> <0.114, 0.946, -0.129> 
		<0.114, 0.966, -0.114> <0.109, 0.961, -0.115> <0.103, 0.943, -0.126> <0.109, 0.939, -0.127> 
		<0.114, 0.962, -0.102> <0.109, 0.958, -0.104> <0.102, 0.937, -0.106> <0.108, 0.934, -0.107> 
		<0.114, 0.960, -0.094> <0.109, 0.955, -0.095> <0.108, 0.941, -0.100> <0.114, 0.937, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.114, 0.969, -0.123> <0.114, 0.966, -0.114> <0.114, 0.962, -0.102> <0.114, 0.960, -0.094> 
		<0.122, 0.977, -0.120> <0.122, 0.974, -0.111> <0.122, 0.970, -0.100> <0.122, 0.967, -0.091> 
		<0.138, 0.983, -0.118> <0.137, 0.988, -0.110> <0.145, 0.976, -0.093> <0.139, 0.969, -0.091> 
		<0.149, 0.984, -0.118> <0.148, 0.989, -0.110> <0.156, 0.977, -0.093> <0.151, 0.970, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.196, 0.977, -0.120> <0.194, 0.990, -0.116> <0.164, 0.986, -0.117> <0.149, 0.984, -0.118> 
		<0.199, 0.962, -0.124> <0.197, 0.976, -0.120> <0.153, 0.974, -0.121> <0.139, 0.973, -0.121> 
		<0.171, 0.951, -0.128> <0.159, 0.947, -0.129> <0.134, 0.953, -0.136> <0.123, 0.959, -0.134> 
		<0.157, 0.946, -0.130> <0.145, 0.941, -0.131> <0.125, 0.940, -0.131> <0.114, 0.946, -0.129> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.196, 0.977, -0.120> <0.194, 0.990, -0.116> <0.164, 0.986, -0.117> <0.149, 0.984, -0.118> 
		<0.196, 0.974, -0.111> <0.194, 0.988, -0.107> <0.162, 0.991, -0.109> <0.148, 0.989, -0.110> 
		<0.202, 0.974, -0.094> <0.200, 0.987, -0.090> <0.170, 0.978, -0.093> <0.156, 0.977, -0.093> 
		<0.196, 0.968, -0.091> <0.194, 0.981, -0.087> <0.165, 0.971, -0.090> <0.151, 0.970, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.196, 0.977, -0.120> <0.196, 0.977, -0.120> <0.196, 0.977, -0.120> <0.196, 0.977, -0.120> 
		<0.194, 0.990, -0.116> <0.197, 0.976, -0.120> <0.197, 0.976, -0.120> <0.199, 0.962, -0.124> 
		<0.164, 0.986, -0.117> <0.165, 0.979, -0.128> <0.169, 0.963, -0.132> <0.171, 0.951, -0.128> 
		<0.149, 0.984, -0.118> <0.151, 0.978, -0.128> <0.155, 0.957, -0.134> <0.157, 0.946, -0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.196, 0.977, -0.120> <0.199, 0.962, -0.124> <0.171, 0.951, -0.128> <0.157, 0.946, -0.130> 
		<0.196, 0.974, -0.111> <0.199, 0.960, -0.116> <0.172, 0.943, -0.125> <0.158, 0.937, -0.127> 
		<0.202, 0.974, -0.094> <0.205, 0.960, -0.098> <0.165, 0.939, -0.105> <0.151, 0.933, -0.107> 
		<0.196, 0.968, -0.091> <0.199, 0.953, -0.096> <0.171, 0.942, -0.099> <0.157, 0.937, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.196, 0.977, -0.120> <0.199, 0.962, -0.124> <0.171, 0.951, -0.128> <0.157, 0.946, -0.130> 
		<0.196, 0.974, -0.111> <0.199, 0.960, -0.116> <0.172, 0.943, -0.125> <0.158, 0.937, -0.127> 
		<0.202, 0.974, -0.094> <0.192, 0.964, -0.089> <0.161, 0.939, -0.097> <0.151, 0.933, -0.107> 
		<0.196, 0.968, -0.091> <0.186, 0.958, -0.086> <0.167, 0.942, -0.091> <0.157, 0.937, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.114, 0.960, -0.094> <0.114, 0.960, -0.094> <0.114, 0.960, -0.094> <0.114, 0.960, -0.094> 
		<0.122, 0.967, -0.091> <0.117, 0.963, -0.093> <0.117, 0.963, -0.093> <0.109, 0.955, -0.095> 
		<0.139, 0.969, -0.091> <0.131, 0.957, -0.087> <0.117, 0.947, -0.090> <0.108, 0.941, -0.100> 
		<0.151, 0.970, -0.090> <0.142, 0.958, -0.086> <0.124, 0.943, -0.091> <0.114, 0.937, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.157, 0.946, -0.130> <0.157, 0.946, -0.130> <0.157, 0.946, -0.130> <0.157, 0.946, -0.130> 
		<0.145, 0.941, -0.131> <0.143, 0.953, -0.135> <0.143, 0.953, -0.135> <0.155, 0.957, -0.134> 
		<0.125, 0.940, -0.131> <0.134, 0.953, -0.136> <0.140, 0.967, -0.132> <0.151, 0.978, -0.128> 
		<0.114, 0.946, -0.129> <0.123, 0.959, -0.134> <0.139, 0.973, -0.121> <0.149, 0.984, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.157, 0.946, -0.130> <0.145, 0.941, -0.131> <0.125, 0.940, -0.131> <0.114, 0.946, -0.129> 
		<0.158, 0.937, -0.127> <0.146, 0.933, -0.128> <0.120, 0.933, -0.129> <0.109, 0.939, -0.127> 
		<0.151, 0.933, -0.107> <0.139, 0.929, -0.108> <0.119, 0.928, -0.108> <0.108, 0.934, -0.107> 
		<0.157, 0.937, -0.101> <0.145, 0.932, -0.102> <0.125, 0.931, -0.102> <0.114, 0.937, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.151, 0.970, -0.090> <0.165, 0.971, -0.090> <0.194, 0.981, -0.087> <0.196, 0.968, -0.091> 
		<0.142, 0.958, -0.086> <0.156, 0.960, -0.086> <0.197, 0.966, -0.092> <0.199, 0.953, -0.096> 
		<0.124, 0.943, -0.091> <0.135, 0.937, -0.092> <0.159, 0.938, -0.100> <0.171, 0.942, -0.099> 
		<0.114, 0.937, -0.101> <0.125, 0.931, -0.102> <0.145, 0.932, -0.102> <0.157, 0.937, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.151, 0.970, -0.090> <0.165, 0.971, -0.090> <0.194, 0.981, -0.087> <0.196, 0.968, -0.091> 
		<0.142, 0.958, -0.086> <0.156, 0.960, -0.086> <0.184, 0.970, -0.082> <0.186, 0.958, -0.086> 
		<0.124, 0.943, -0.091> <0.135, 0.937, -0.092> <0.155, 0.938, -0.092> <0.167, 0.942, -0.091> 
		<0.114, 0.937, -0.101> <0.125, 0.931, -0.102> <0.145, 0.932, -0.102> <0.157, 0.937, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.185, 0.911, -0.141> <0.174, 0.905, -0.142> <0.155, 0.907, -0.142> <0.142, 0.909, -0.141> 
		<0.192, 0.914, -0.140> <0.180, 0.908, -0.141> <0.159, 0.916, -0.146> <0.147, 0.918, -0.146> 
		<0.196, 0.927, -0.136> <0.190, 0.934, -0.133> <0.168, 0.935, -0.141> <0.159, 0.934, -0.141> 
		<0.191, 0.932, -0.134> <0.186, 0.939, -0.132> <0.170, 0.941, -0.131> <0.161, 0.940, -0.131> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.185, 0.911, -0.141> <0.185, 0.911, -0.141> <0.185, 0.911, -0.141> <0.185, 0.911, -0.141> 
		<0.174, 0.905, -0.142> <0.180, 0.908, -0.141> <0.180, 0.908, -0.141> <0.192, 0.914, -0.140> 
		<0.155, 0.907, -0.142> <0.170, 0.914, -0.140> <0.183, 0.923, -0.145> <0.196, 0.927, -0.136> 
		<0.142, 0.909, -0.141> <0.157, 0.916, -0.139> <0.179, 0.928, -0.143> <0.191, 0.932, -0.134> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.185, 0.911, -0.141> <0.192, 0.914, -0.140> <0.196, 0.927, -0.136> <0.191, 0.932, -0.134> 
		<0.185, 0.908, -0.132> <0.192, 0.911, -0.131> <0.203, 0.929, -0.130> <0.199, 0.934, -0.129> 
		<0.185, 0.904, -0.120> <0.192, 0.907, -0.119> <0.204, 0.923, -0.110> <0.199, 0.928, -0.108> 
		<0.185, 0.902, -0.112> <0.192, 0.905, -0.111> <0.197, 0.919, -0.106> <0.191, 0.923, -0.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.185, 0.911, -0.141> <0.185, 0.908, -0.132> <0.185, 0.904, -0.120> <0.185, 0.902, -0.112> 
		<0.174, 0.905, -0.142> <0.174, 0.902, -0.134> <0.174, 0.899, -0.122> <0.174, 0.896, -0.113> 
		<0.155, 0.907, -0.142> <0.152, 0.899, -0.138> <0.148, 0.895, -0.118> <0.155, 0.898, -0.113> 
		<0.142, 0.909, -0.141> <0.139, 0.901, -0.138> <0.135, 0.898, -0.118> <0.142, 0.900, -0.112> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.103, 0.924, -0.136> <0.097, 0.914, -0.140> <0.130, 0.911, -0.141> <0.142, 0.909, -0.141> 
		<0.112, 0.939, -0.132> <0.106, 0.929, -0.135> <0.145, 0.918, -0.138> <0.157, 0.916, -0.139> 
		<0.143, 0.938, -0.132> <0.152, 0.939, -0.132> <0.173, 0.935, -0.141> <0.179, 0.928, -0.143> 
		<0.161, 0.940, -0.131> <0.170, 0.941, -0.131> <0.186, 0.939, -0.132> <0.191, 0.932, -0.134> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.103, 0.924, -0.136> <0.097, 0.914, -0.140> <0.130, 0.911, -0.141> <0.142, 0.909, -0.141> 
		<0.103, 0.922, -0.128> <0.097, 0.911, -0.131> <0.126, 0.903, -0.137> <0.139, 0.901, -0.138> 
		<0.096, 0.914, -0.113> <0.093, 0.903, -0.116> <0.123, 0.900, -0.117> <0.135, 0.898, -0.118> 
		<0.103, 0.915, -0.107> <0.100, 0.904, -0.111> <0.130, 0.902, -0.112> <0.142, 0.900, -0.112> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.103, 0.924, -0.136> <0.103, 0.924, -0.136> <0.103, 0.924, -0.136> <0.103, 0.924, -0.136> 
		<0.097, 0.914, -0.140> <0.106, 0.929, -0.135> <0.106, 0.929, -0.135> <0.112, 0.939, -0.132> 
		<0.130, 0.911, -0.141> <0.134, 0.920, -0.145> <0.141, 0.933, -0.142> <0.143, 0.938, -0.132> 
		<0.142, 0.909, -0.141> <0.147, 0.918, -0.146> <0.159, 0.934, -0.141> <0.161, 0.940, -0.131> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.103, 0.924, -0.136> <0.112, 0.939, -0.132> <0.143, 0.938, -0.132> <0.161, 0.940, -0.131> 
		<0.103, 0.922, -0.128> <0.112, 0.937, -0.123> <0.145, 0.943, -0.124> <0.162, 0.945, -0.123> 
		<0.096, 0.914, -0.113> <0.100, 0.928, -0.108> <0.144, 0.933, -0.106> <0.159, 0.934, -0.106> 
		<0.103, 0.915, -0.107> <0.107, 0.929, -0.103> <0.136, 0.930, -0.103> <0.150, 0.931, -0.103> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.103, 0.924, -0.136> <0.112, 0.939, -0.132> <0.143, 0.938, -0.132> <0.161, 0.940, -0.131> 
		<0.103, 0.922, -0.128> <0.112, 0.937, -0.123> <0.145, 0.943, -0.124> <0.162, 0.945, -0.123> 
		<0.096, 0.914, -0.113> <0.108, 0.916, -0.104> <0.146, 0.929, -0.101> <0.159, 0.934, -0.106> 
		<0.103, 0.915, -0.107> <0.115, 0.917, -0.099> <0.138, 0.925, -0.097> <0.150, 0.931, -0.103> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.185, 0.902, -0.112> <0.185, 0.902, -0.112> <0.185, 0.902, -0.112> <0.185, 0.902, -0.112> 
		<0.174, 0.896, -0.113> <0.180, 0.899, -0.113> <0.180, 0.899, -0.113> <0.192, 0.905, -0.111> 
		<0.155, 0.898, -0.113> <0.168, 0.901, -0.104> <0.184, 0.910, -0.101> <0.197, 0.919, -0.106> 
		<0.142, 0.900, -0.112> <0.155, 0.903, -0.103> <0.179, 0.915, -0.099> <0.191, 0.923, -0.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.161, 0.940, -0.131> <0.161, 0.940, -0.131> <0.161, 0.940, -0.131> <0.161, 0.940, -0.131> 
		<0.170, 0.941, -0.131> <0.168, 0.935, -0.141> <0.168, 0.935, -0.141> <0.159, 0.934, -0.141> 
		<0.186, 0.939, -0.132> <0.173, 0.935, -0.141> <0.161, 0.925, -0.144> <0.147, 0.918, -0.146> 
		<0.191, 0.932, -0.134> <0.179, 0.928, -0.143> <0.157, 0.916, -0.139> <0.142, 0.909, -0.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.161, 0.940, -0.131> <0.170, 0.941, -0.131> <0.186, 0.939, -0.132> <0.191, 0.932, -0.134> 
		<0.162, 0.945, -0.123> <0.172, 0.946, -0.123> <0.193, 0.941, -0.126> <0.199, 0.934, -0.129> 
		<0.159, 0.934, -0.106> <0.171, 0.936, -0.106> <0.189, 0.936, -0.106> <0.199, 0.928, -0.108> 
		<0.150, 0.931, -0.103> <0.163, 0.932, -0.102> <0.182, 0.931, -0.103> <0.191, 0.923, -0.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.142, 0.900, -0.112> <0.130, 0.902, -0.112> <0.100, 0.904, -0.111> <0.103, 0.915, -0.107> 
		<0.155, 0.903, -0.103> <0.143, 0.906, -0.102> <0.104, 0.917, -0.107> <0.107, 0.929, -0.103> 
		<0.179, 0.915, -0.099> <0.169, 0.922, -0.097> <0.148, 0.931, -0.103> <0.136, 0.930, -0.103> 
		<0.191, 0.923, -0.105> <0.182, 0.931, -0.103> <0.163, 0.932, -0.102> <0.150, 0.931, -0.103> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.142, 0.900, -0.112> <0.130, 0.902, -0.112> <0.100, 0.904, -0.111> <0.103, 0.915, -0.107> 
		<0.155, 0.903, -0.103> <0.143, 0.906, -0.102> <0.112, 0.905, -0.102> <0.115, 0.917, -0.099> 
		<0.179, 0.915, -0.099> <0.169, 0.922, -0.097> <0.150, 0.927, -0.097> <0.138, 0.925, -0.097> 
		<0.191, 0.923, -0.105> <0.182, 0.931, -0.103> <0.163, 0.932, -0.102> <0.150, 0.931, -0.103> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.095, 0.920, -0.138> <0.099, 0.910, -0.141> <0.091, 0.894, -0.146> <0.088, 0.884, -0.149> 
		<0.093, 0.927, -0.136> <0.097, 0.916, -0.139> <0.085, 0.897, -0.152> <0.082, 0.886, -0.155> 
		<0.078, 0.932, -0.134> <0.069, 0.924, -0.137> <0.064, 0.902, -0.150> <0.065, 0.890, -0.154> 
		<0.073, 0.927, -0.135> <0.063, 0.919, -0.138> <0.058, 0.901, -0.144> <0.058, 0.889, -0.147> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.095, 0.920, -0.138> <0.095, 0.920, -0.138> <0.095, 0.920, -0.138> <0.095, 0.920, -0.138> 
		<0.099, 0.910, -0.141> <0.097, 0.916, -0.139> <0.097, 0.916, -0.139> <0.093, 0.927, -0.136> 
		<0.091, 0.894, -0.146> <0.087, 0.908, -0.142> <0.082, 0.923, -0.145> <0.078, 0.932, -0.134> 
		<0.088, 0.884, -0.149> <0.084, 0.897, -0.145> <0.077, 0.919, -0.146> <0.073, 0.927, -0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.095, 0.920, -0.138> <0.093, 0.927, -0.136> <0.078, 0.932, -0.134> <0.073, 0.927, -0.135> 
		<0.095, 0.918, -0.129> <0.093, 0.924, -0.127> <0.076, 0.937, -0.127> <0.070, 0.933, -0.129> 
		<0.095, 0.914, -0.117> <0.093, 0.920, -0.115> <0.076, 0.931, -0.108> <0.071, 0.927, -0.109> 
		<0.095, 0.911, -0.109> <0.093, 0.918, -0.107> <0.078, 0.923, -0.105> <0.073, 0.918, -0.107> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.095, 0.920, -0.138> <0.095, 0.918, -0.129> <0.095, 0.914, -0.117> <0.095, 0.911, -0.109> 
		<0.099, 0.910, -0.141> <0.099, 0.907, -0.132> <0.098, 0.903, -0.121> <0.098, 0.901, -0.112> 
		<0.091, 0.894, -0.146> <0.097, 0.891, -0.140> <0.091, 0.881, -0.123> <0.088, 0.887, -0.116> 
		<0.088, 0.884, -0.149> <0.095, 0.881, -0.143> <0.088, 0.870, -0.127> <0.085, 0.876, -0.120> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.076, 0.843, -0.162> <0.089, 0.841, -0.163> <0.085, 0.871, -0.153> <0.088, 0.884, -0.149> 
		<0.061, 0.846, -0.161> <0.074, 0.843, -0.162> <0.081, 0.884, -0.149> <0.084, 0.897, -0.145> 
		<0.059, 0.874, -0.152> <0.058, 0.887, -0.148> <0.067, 0.910, -0.149> <0.077, 0.919, -0.146> 
		<0.058, 0.889, -0.147> <0.058, 0.901, -0.144> <0.063, 0.919, -0.138> <0.073, 0.927, -0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.076, 0.843, -0.162> <0.089, 0.841, -0.163> <0.085, 0.871, -0.153> <0.088, 0.884, -0.149> 
		<0.076, 0.840, -0.153> <0.089, 0.838, -0.154> <0.091, 0.868, -0.147> <0.095, 0.881, -0.143> 
		<0.079, 0.828, -0.139> <0.092, 0.826, -0.140> <0.085, 0.858, -0.131> <0.088, 0.870, -0.127> 
		<0.076, 0.834, -0.133> <0.089, 0.832, -0.134> <0.082, 0.863, -0.124> <0.085, 0.876, -0.120> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.076, 0.843, -0.162> <0.076, 0.843, -0.162> <0.076, 0.843, -0.162> <0.076, 0.843, -0.162> 
		<0.089, 0.841, -0.163> <0.074, 0.843, -0.162> <0.074, 0.843, -0.162> <0.061, 0.846, -0.161> 
		<0.085, 0.871, -0.153> <0.079, 0.874, -0.159> <0.065, 0.875, -0.159> <0.059, 0.874, -0.152> 
		<0.088, 0.884, -0.149> <0.082, 0.886, -0.155> <0.065, 0.890, -0.154> <0.058, 0.889, -0.147> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.076, 0.843, -0.162> <0.061, 0.846, -0.161> <0.059, 0.874, -0.152> <0.058, 0.889, -0.147> 
		<0.076, 0.840, -0.153> <0.061, 0.843, -0.152> <0.052, 0.874, -0.146> <0.052, 0.888, -0.141> 
		<0.079, 0.828, -0.139> <0.063, 0.831, -0.139> <0.056, 0.874, -0.125> <0.056, 0.888, -0.121> 
		<0.076, 0.834, -0.133> <0.061, 0.836, -0.132> <0.059, 0.865, -0.123> <0.058, 0.880, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.076, 0.843, -0.162> <0.061, 0.846, -0.161> <0.059, 0.874, -0.152> <0.058, 0.889, -0.147> 
		<0.076, 0.840, -0.153> <0.061, 0.843, -0.152> <0.052, 0.874, -0.146> <0.052, 0.888, -0.141> 
		<0.079, 0.828, -0.139> <0.074, 0.838, -0.128> <0.060, 0.874, -0.117> <0.056, 0.888, -0.121> 
		<0.076, 0.834, -0.133> <0.071, 0.844, -0.122> <0.063, 0.866, -0.115> <0.058, 0.880, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.095, 0.911, -0.109> <0.095, 0.911, -0.109> <0.095, 0.911, -0.109> <0.095, 0.911, -0.109> 
		<0.098, 0.901, -0.112> <0.096, 0.907, -0.110> <0.096, 0.907, -0.110> <0.093, 0.918, -0.107> 
		<0.088, 0.887, -0.116> <0.084, 0.895, -0.106> <0.081, 0.910, -0.101> <0.078, 0.923, -0.105> 
		<0.085, 0.876, -0.120> <0.082, 0.884, -0.109> <0.076, 0.905, -0.103> <0.073, 0.918, -0.107> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.058, 0.889, -0.147> <0.058, 0.889, -0.147> <0.058, 0.889, -0.147> <0.058, 0.889, -0.147> 
		<0.058, 0.901, -0.144> <0.064, 0.902, -0.150> <0.064, 0.902, -0.150> <0.065, 0.890, -0.154> 
		<0.063, 0.919, -0.138> <0.067, 0.910, -0.149> <0.078, 0.900, -0.151> <0.082, 0.886, -0.155> 
		<0.073, 0.927, -0.135> <0.077, 0.919, -0.146> <0.084, 0.897, -0.145> <0.088, 0.884, -0.149> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.058, 0.889, -0.147> <0.058, 0.901, -0.144> <0.063, 0.919, -0.138> <0.073, 0.927, -0.135> 
		<0.052, 0.888, -0.141> <0.051, 0.901, -0.137> <0.061, 0.925, -0.131> <0.070, 0.933, -0.129> 
		<0.056, 0.888, -0.121> <0.055, 0.901, -0.117> <0.061, 0.919, -0.112> <0.071, 0.927, -0.109> 
		<0.058, 0.880, -0.118> <0.058, 0.892, -0.115> <0.063, 0.910, -0.109> <0.073, 0.918, -0.107> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.085, 0.876, -0.120> <0.082, 0.863, -0.124> <0.089, 0.832, -0.134> <0.076, 0.834, -0.133> 
		<0.082, 0.884, -0.109> <0.079, 0.872, -0.113> <0.074, 0.834, -0.133> <0.061, 0.836, -0.132> 
		<0.076, 0.905, -0.103> <0.066, 0.897, -0.105> <0.058, 0.878, -0.119> <0.059, 0.865, -0.123> 
		<0.073, 0.918, -0.107> <0.063, 0.910, -0.109> <0.058, 0.892, -0.115> <0.058, 0.880, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.085, 0.876, -0.120> <0.082, 0.863, -0.124> <0.089, 0.832, -0.134> <0.076, 0.834, -0.133> 
		<0.082, 0.884, -0.109> <0.079, 0.872, -0.113> <0.085, 0.842, -0.122> <0.071, 0.844, -0.122> 
		<0.076, 0.905, -0.103> <0.066, 0.897, -0.105> <0.062, 0.878, -0.111> <0.063, 0.866, -0.115> 
		<0.073, 0.918, -0.107> <0.063, 0.910, -0.109> <0.058, 0.892, -0.115> <0.058, 0.880, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.114, 0.924, -0.136> <0.124, 0.921, -0.137> <0.134, 0.911, -0.140> <0.139, 0.903, -0.143> 
		<0.108, 0.926, -0.136> <0.117, 0.923, -0.137> <0.128, 0.910, -0.148> <0.132, 0.902, -0.151> 
		<0.094, 0.923, -0.137> <0.092, 0.913, -0.140> <0.109, 0.899, -0.151> <0.116, 0.892, -0.154> 
		<0.093, 0.916, -0.139> <0.091, 0.906, -0.142> <0.102, 0.894, -0.146> <0.109, 0.886, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.114, 0.924, -0.136> <0.114, 0.924, -0.136> <0.114, 0.924, -0.136> <0.114, 0.924, -0.136> 
		<0.124, 0.921, -0.137> <0.117, 0.923, -0.137> <0.117, 0.923, -0.137> <0.108, 0.926, -0.136> 
		<0.134, 0.911, -0.140> <0.120, 0.915, -0.139> <0.105, 0.922, -0.145> <0.094, 0.923, -0.137> 
		<0.139, 0.903, -0.143> <0.125, 0.907, -0.142> <0.104, 0.915, -0.147> <0.093, 0.916, -0.139> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.114, 0.924, -0.136> <0.108, 0.926, -0.136> <0.094, 0.923, -0.137> <0.093, 0.916, -0.139> 
		<0.114, 0.922, -0.128> <0.108, 0.924, -0.127> <0.086, 0.923, -0.132> <0.085, 0.917, -0.134> 
		<0.114, 0.918, -0.116> <0.108, 0.921, -0.115> <0.087, 0.918, -0.112> <0.086, 0.911, -0.114> 
		<0.114, 0.915, -0.108> <0.108, 0.918, -0.107> <0.094, 0.914, -0.108> <0.093, 0.907, -0.110> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.114, 0.924, -0.136> <0.114, 0.922, -0.128> <0.114, 0.918, -0.116> <0.114, 0.915, -0.108> 
		<0.124, 0.921, -0.137> <0.124, 0.919, -0.129> <0.124, 0.914, -0.117> <0.124, 0.911, -0.109> 
		<0.134, 0.911, -0.140> <0.140, 0.912, -0.133> <0.138, 0.897, -0.118> <0.131, 0.898, -0.113> 
		<0.139, 0.903, -0.143> <0.145, 0.903, -0.136> <0.143, 0.889, -0.121> <0.136, 0.889, -0.116> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 0.853, -0.159> <0.166, 0.861, -0.156> <0.146, 0.889, -0.147> <0.139, 0.903, -0.143> 
		<0.137, 0.846, -0.161> <0.151, 0.853, -0.159> <0.132, 0.893, -0.146> <0.125, 0.907, -0.142> 
		<0.120, 0.875, -0.152> <0.113, 0.882, -0.150> <0.103, 0.905, -0.150> <0.104, 0.915, -0.147> 
		<0.109, 0.886, -0.148> <0.102, 0.894, -0.146> <0.091, 0.906, -0.142> <0.093, 0.916, -0.139> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 0.853, -0.159> <0.166, 0.861, -0.156> <0.146, 0.889, -0.147> <0.139, 0.903, -0.143> 
		<0.152, 0.851, -0.150> <0.166, 0.858, -0.148> <0.152, 0.890, -0.140> <0.145, 0.903, -0.136> 
		<0.158, 0.841, -0.135> <0.172, 0.846, -0.134> <0.150, 0.876, -0.125> <0.143, 0.889, -0.121> 
		<0.152, 0.844, -0.130> <0.166, 0.849, -0.128> <0.142, 0.877, -0.120> <0.136, 0.889, -0.116> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 0.853, -0.159> <0.152, 0.853, -0.159> <0.152, 0.853, -0.159> <0.152, 0.853, -0.159> 
		<0.166, 0.861, -0.156> <0.151, 0.853, -0.159> <0.151, 0.853, -0.159> <0.137, 0.846, -0.161> 
		<0.146, 0.889, -0.147> <0.139, 0.888, -0.155> <0.127, 0.880, -0.157> <0.120, 0.875, -0.152> 
		<0.139, 0.903, -0.143> <0.132, 0.902, -0.151> <0.116, 0.892, -0.154> <0.109, 0.886, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 0.853, -0.159> <0.137, 0.846, -0.161> <0.120, 0.875, -0.152> <0.109, 0.886, -0.148> 
		<0.152, 0.851, -0.150> <0.137, 0.843, -0.152> <0.114, 0.870, -0.147> <0.103, 0.882, -0.143> 
		<0.158, 0.841, -0.135> <0.142, 0.835, -0.137> <0.113, 0.873, -0.125> <0.101, 0.885, -0.122> 
		<0.152, 0.844, -0.130> <0.136, 0.838, -0.132> <0.119, 0.867, -0.123> <0.107, 0.879, -0.119> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 0.853, -0.159> <0.137, 0.846, -0.161> <0.120, 0.875, -0.152> <0.109, 0.886, -0.148> 
		<0.152, 0.851, -0.150> <0.137, 0.843, -0.152> <0.114, 0.870, -0.147> <0.103, 0.882, -0.143> 
		<0.158, 0.841, -0.135> <0.146, 0.848, -0.125> <0.113, 0.873, -0.116> <0.101, 0.885, -0.122> 
		<0.152, 0.844, -0.130> <0.140, 0.851, -0.119> <0.119, 0.867, -0.114> <0.107, 0.879, -0.119> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.114, 0.915, -0.108> <0.114, 0.915, -0.108> <0.114, 0.915, -0.108> <0.114, 0.915, -0.108> 
		<0.124, 0.911, -0.109> <0.117, 0.914, -0.108> <0.117, 0.914, -0.108> <0.108, 0.918, -0.107> 
		<0.131, 0.898, -0.113> <0.120, 0.899, -0.105> <0.105, 0.907, -0.102> <0.094, 0.914, -0.108> 
		<0.136, 0.889, -0.116> <0.124, 0.890, -0.107> <0.103, 0.900, -0.104> <0.093, 0.907, -0.110> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.109, 0.886, -0.148> <0.109, 0.886, -0.148> <0.109, 0.886, -0.148> <0.109, 0.886, -0.148> 
		<0.102, 0.894, -0.146> <0.109, 0.899, -0.151> <0.109, 0.899, -0.151> <0.116, 0.892, -0.154> 
		<0.091, 0.906, -0.142> <0.103, 0.905, -0.150> <0.118, 0.906, -0.150> <0.132, 0.902, -0.151> 
		<0.093, 0.916, -0.139> <0.104, 0.915, -0.147> <0.125, 0.907, -0.142> <0.139, 0.903, -0.143> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.109, 0.886, -0.148> <0.102, 0.894, -0.146> <0.091, 0.906, -0.142> <0.093, 0.916, -0.139> 
		<0.103, 0.882, -0.143> <0.096, 0.889, -0.141> <0.084, 0.907, -0.137> <0.085, 0.917, -0.134> 
		<0.101, 0.885, -0.122> <0.094, 0.892, -0.119> <0.084, 0.902, -0.117> <0.086, 0.911, -0.114> 
		<0.107, 0.879, -0.119> <0.101, 0.886, -0.117> <0.091, 0.898, -0.113> <0.093, 0.907, -0.110> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.136, 0.889, -0.116> <0.142, 0.877, -0.120> <0.166, 0.849, -0.128> <0.152, 0.844, -0.130> 
		<0.124, 0.890, -0.107> <0.131, 0.878, -0.111> <0.150, 0.844, -0.130> <0.136, 0.838, -0.132> 
		<0.103, 0.900, -0.104> <0.102, 0.891, -0.107> <0.112, 0.874, -0.121> <0.119, 0.867, -0.123> 
		<0.093, 0.907, -0.110> <0.091, 0.898, -0.113> <0.101, 0.886, -0.117> <0.107, 0.879, -0.119> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.136, 0.889, -0.116> <0.142, 0.877, -0.120> <0.166, 0.849, -0.128> <0.152, 0.844, -0.130> 
		<0.124, 0.890, -0.107> <0.131, 0.878, -0.111> <0.154, 0.856, -0.118> <0.140, 0.851, -0.119> 
		<0.103, 0.900, -0.104> <0.102, 0.891, -0.107> <0.112, 0.874, -0.112> <0.119, 0.867, -0.114> 
		<0.093, 0.907, -0.110> <0.091, 0.898, -0.113> <0.101, 0.886, -0.117> <0.107, 0.879, -0.119> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 0.924, -0.136> <0.077, 0.912, -0.140> <0.072, 0.894, -0.146> <0.063, 0.885, -0.149> 
		<0.074, 0.931, -0.134> <0.076, 0.919, -0.138> <0.064, 0.901, -0.151> <0.056, 0.891, -0.154> 
		<0.062, 0.940, -0.132> <0.051, 0.934, -0.133> <0.044, 0.913, -0.147> <0.039, 0.901, -0.151> 
		<0.056, 0.937, -0.132> <0.044, 0.931, -0.134> <0.036, 0.915, -0.139> <0.031, 0.904, -0.143> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 0.924, -0.136> <0.075, 0.924, -0.136> <0.075, 0.924, -0.136> <0.075, 0.924, -0.136> 
		<0.077, 0.912, -0.140> <0.076, 0.919, -0.138> <0.076, 0.919, -0.138> <0.074, 0.931, -0.134> 
		<0.072, 0.894, -0.146> <0.070, 0.910, -0.141> <0.064, 0.929, -0.143> <0.062, 0.940, -0.132> 
		<0.063, 0.885, -0.149> <0.061, 0.900, -0.144> <0.058, 0.926, -0.144> <0.056, 0.937, -0.132> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 0.924, -0.136> <0.074, 0.931, -0.134> <0.062, 0.940, -0.132> <0.056, 0.937, -0.132> 
		<0.075, 0.922, -0.128> <0.074, 0.928, -0.126> <0.061, 0.946, -0.125> <0.055, 0.943, -0.126> 
		<0.075, 0.918, -0.116> <0.074, 0.925, -0.114> <0.061, 0.940, -0.104> <0.055, 0.937, -0.105> 
		<0.075, 0.915, -0.107> <0.074, 0.922, -0.105> <0.062, 0.931, -0.103> <0.056, 0.928, -0.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 0.924, -0.136> <0.075, 0.922, -0.128> <0.075, 0.918, -0.116> <0.075, 0.915, -0.107> 
		<0.077, 0.912, -0.140> <0.077, 0.909, -0.132> <0.077, 0.906, -0.120> <0.077, 0.903, -0.111> 
		<0.072, 0.894, -0.146> <0.078, 0.889, -0.141> <0.073, 0.879, -0.123> <0.072, 0.885, -0.117> 
		<0.063, 0.885, -0.149> <0.069, 0.880, -0.144> <0.064, 0.870, -0.126> <0.063, 0.876, -0.120> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.022, 0.865, -0.155> <0.034, 0.858, -0.157> <0.054, 0.875, -0.152> <0.063, 0.885, -0.149> 
		<0.011, 0.871, -0.153> <0.023, 0.864, -0.155> <0.052, 0.890, -0.147> <0.061, 0.900, -0.144> 
		<0.026, 0.893, -0.146> <0.031, 0.904, -0.143> <0.046, 0.920, -0.146> <0.058, 0.926, -0.144> 
		<0.031, 0.904, -0.143> <0.036, 0.915, -0.139> <0.044, 0.931, -0.134> <0.056, 0.937, -0.132> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.022, 0.865, -0.155> <0.034, 0.858, -0.157> <0.054, 0.875, -0.152> <0.063, 0.885, -0.149> 
		<0.020, 0.862, -0.146> <0.032, 0.855, -0.149> <0.060, 0.870, -0.148> <0.069, 0.880, -0.144> 
		<0.015, 0.849, -0.134> <0.028, 0.841, -0.136> <0.054, 0.859, -0.130> <0.064, 0.870, -0.126> 
		<0.017, 0.854, -0.127> <0.030, 0.847, -0.129> <0.053, 0.865, -0.123> <0.063, 0.876, -0.120> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.022, 0.865, -0.155> <0.022, 0.865, -0.155> <0.022, 0.865, -0.155> <0.022, 0.865, -0.155> 
		<0.034, 0.858, -0.157> <0.023, 0.864, -0.155> <0.023, 0.864, -0.155> <0.011, 0.871, -0.153> 
		<0.054, 0.875, -0.152> <0.047, 0.881, -0.157> <0.033, 0.891, -0.154> <0.026, 0.893, -0.146> 
		<0.063, 0.885, -0.149> <0.056, 0.891, -0.154> <0.039, 0.901, -0.151> <0.031, 0.904, -0.143> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.022, 0.865, -0.155> <0.011, 0.871, -0.153> <0.026, 0.893, -0.146> <0.031, 0.904, -0.143> 
		<0.020, 0.862, -0.146> <0.010, 0.868, -0.144> <0.020, 0.895, -0.140> <0.025, 0.906, -0.136> 
		<0.015, 0.849, -0.134> <0.004, 0.856, -0.132> <0.027, 0.892, -0.120> <0.033, 0.903, -0.117> 
		<0.017, 0.854, -0.127> <0.006, 0.861, -0.124> <0.025, 0.883, -0.117> <0.031, 0.895, -0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.022, 0.865, -0.155> <0.011, 0.871, -0.153> <0.026, 0.893, -0.146> <0.031, 0.904, -0.143> 
		<0.020, 0.862, -0.146> <0.010, 0.868, -0.144> <0.020, 0.895, -0.140> <0.025, 0.906, -0.136> 
		<0.015, 0.849, -0.134> <0.018, 0.857, -0.123> <0.030, 0.891, -0.113> <0.033, 0.903, -0.117> 
		<0.017, 0.854, -0.127> <0.019, 0.862, -0.116> <0.028, 0.882, -0.110> <0.031, 0.895, -0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 0.915, -0.107> <0.075, 0.915, -0.107> <0.075, 0.915, -0.107> <0.075, 0.915, -0.107> 
		<0.077, 0.903, -0.111> <0.076, 0.910, -0.109> <0.076, 0.910, -0.109> <0.074, 0.922, -0.105> 
		<0.072, 0.885, -0.117> <0.070, 0.896, -0.105> <0.064, 0.915, -0.099> <0.062, 0.931, -0.103> 
		<0.063, 0.876, -0.120> <0.061, 0.887, -0.108> <0.058, 0.912, -0.100> <0.056, 0.928, -0.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.031, 0.904, -0.143> <0.031, 0.904, -0.143> <0.031, 0.904, -0.143> <0.031, 0.904, -0.143> 
		<0.036, 0.915, -0.139> <0.044, 0.913, -0.147> <0.044, 0.913, -0.147> <0.039, 0.901, -0.151> 
		<0.044, 0.931, -0.134> <0.046, 0.920, -0.146> <0.054, 0.907, -0.149> <0.056, 0.891, -0.154> 
		<0.056, 0.937, -0.132> <0.058, 0.926, -0.144> <0.061, 0.900, -0.144> <0.063, 0.885, -0.149> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.031, 0.904, -0.143> <0.036, 0.915, -0.139> <0.044, 0.931, -0.134> <0.056, 0.937, -0.132> 
		<0.025, 0.906, -0.136> <0.030, 0.917, -0.133> <0.043, 0.938, -0.128> <0.055, 0.943, -0.126> 
		<0.033, 0.903, -0.117> <0.039, 0.914, -0.113> <0.043, 0.931, -0.107> <0.055, 0.937, -0.105> 
		<0.031, 0.895, -0.114> <0.037, 0.906, -0.111> <0.044, 0.922, -0.105> <0.056, 0.928, -0.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.063, 0.876, -0.120> <0.053, 0.865, -0.123> <0.030, 0.847, -0.129> <0.017, 0.854, -0.127> 
		<0.061, 0.887, -0.108> <0.051, 0.876, -0.111> <0.019, 0.853, -0.127> <0.006, 0.861, -0.124> 
		<0.058, 0.912, -0.100> <0.046, 0.906, -0.102> <0.031, 0.894, -0.114> <0.025, 0.883, -0.117> 
		<0.056, 0.928, -0.104> <0.044, 0.922, -0.105> <0.037, 0.906, -0.111> <0.031, 0.895, -0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.063, 0.876, -0.120> <0.053, 0.865, -0.123> <0.030, 0.847, -0.129> <0.017, 0.854, -0.127> 
		<0.061, 0.887, -0.108> <0.051, 0.876, -0.111> <0.033, 0.854, -0.118> <0.019, 0.862, -0.116> 
		<0.058, 0.912, -0.100> <0.046, 0.906, -0.102> <0.033, 0.893, -0.106> <0.028, 0.882, -0.110> 
		<0.056, 0.928, -0.104> <0.044, 0.922, -0.105> <0.037, 0.906, -0.111> <0.031, 0.895, -0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.968, -0.130> <0.053, 0.972, -0.129> <0.031, 0.983, -0.126> <0.019, 0.996, -0.122> 
		<0.077, 0.966, -0.131> <0.059, 0.970, -0.130> <0.032, 0.988, -0.131> <0.020, 1.000, -0.127> 
		<0.093, 0.975, -0.128> <0.079, 0.990, -0.123> <0.043, 1.003, -0.124> <0.025, 1.014, -0.121> 
		<0.089, 0.980, -0.127> <0.075, 0.995, -0.122> <0.047, 1.005, -0.119> <0.029, 1.015, -0.116> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.968, -0.130> <0.070, 0.968, -0.130> <0.070, 0.968, -0.130> <0.070, 0.968, -0.130> 
		<0.053, 0.972, -0.129> <0.059, 0.970, -0.130> <0.059, 0.970, -0.130> <0.077, 0.966, -0.131> 
		<0.031, 0.983, -0.126> <0.052, 0.978, -0.127> <0.075, 0.983, -0.137> <0.093, 0.975, -0.128> 
		<0.019, 0.996, -0.122> <0.040, 0.991, -0.123> <0.071, 0.988, -0.136> <0.089, 0.980, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.968, -0.130> <0.077, 0.966, -0.131> <0.093, 0.975, -0.128> <0.089, 0.980, -0.127> 
		<0.070, 0.964, -0.118> <0.077, 0.962, -0.118> <0.104, 0.970, -0.122> <0.100, 0.975, -0.121> 
		<0.070, 0.959, -0.100> <0.077, 0.957, -0.101> <0.103, 0.957, -0.094> <0.101, 0.963, -0.092> 
		<0.070, 0.955, -0.088> <0.077, 0.953, -0.088> <0.092, 0.958, -0.087> <0.090, 0.964, -0.085> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.968, -0.130> <0.070, 0.964, -0.118> <0.070, 0.959, -0.100> <0.070, 0.955, -0.088> 
		<0.053, 0.972, -0.129> <0.053, 0.968, -0.116> <0.053, 0.963, -0.099> <0.053, 0.959, -0.086> 
		<0.031, 0.983, -0.126> <0.029, 0.975, -0.115> <0.021, 0.976, -0.088> <0.032, 0.971, -0.083> 
		<0.019, 0.996, -0.122> <0.016, 0.987, -0.112> <0.009, 0.989, -0.084> <0.020, 0.984, -0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.017, 1.022, -0.113> <0.013, 1.015, -0.116> <0.013, 1.001, -0.120> <0.019, 0.996, -0.122> 
		<0.019, 1.026, -0.112> <0.015, 1.019, -0.114> <0.034, 0.997, -0.121> <0.040, 0.991, -0.123> 
		<0.026, 1.017, -0.115> <0.043, 1.007, -0.118> <0.057, 1.003, -0.131> <0.071, 0.988, -0.136> 
		<0.029, 1.015, -0.116> <0.047, 1.005, -0.119> <0.075, 0.995, -0.122> <0.089, 0.980, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.017, 1.022, -0.113> <0.013, 1.015, -0.116> <0.013, 1.001, -0.120> <0.019, 0.996, -0.122> 
		<0.017, 1.019, -0.100> <0.014, 1.012, -0.102> <0.011, 0.993, -0.110> <0.016, 0.987, -0.112> 
		<0.010, 1.016, -0.079> <0.003, 1.011, -0.081> <0.003, 0.995, -0.082> <0.009, 0.989, -0.084> 
		<0.019, 1.012, -0.070> <0.012, 1.007, -0.071> <0.014, 0.990, -0.076> <0.020, 0.984, -0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.017, 1.022, -0.113> <0.017, 1.022, -0.113> <0.017, 1.022, -0.113> <0.017, 1.022, -0.113> 
		<0.013, 1.015, -0.116> <0.015, 1.019, -0.114> <0.015, 1.019, -0.114> <0.019, 1.026, -0.112> 
		<0.013, 1.001, -0.120> <0.014, 1.006, -0.125> <0.022, 1.016, -0.121> <0.026, 1.017, -0.115> 
		<0.019, 0.996, -0.122> <0.020, 1.000, -0.127> <0.025, 1.014, -0.121> <0.029, 1.015, -0.116> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.017, 1.022, -0.113> <0.019, 1.026, -0.112> <0.026, 1.017, -0.115> <0.029, 1.015, -0.116> 
		<0.017, 1.019, -0.100> <0.019, 1.023, -0.099> <0.034, 1.020, -0.102> <0.038, 1.018, -0.103> 
		<0.010, 1.016, -0.079> <0.019, 1.022, -0.078> <0.048, 1.013, -0.084> <0.056, 1.008, -0.086> 
		<0.019, 1.012, -0.070> <0.027, 1.018, -0.068> <0.044, 1.013, -0.069> <0.053, 1.007, -0.071> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.017, 1.022, -0.113> <0.019, 1.026, -0.112> <0.026, 1.017, -0.115> <0.029, 1.015, -0.116> 
		<0.017, 1.019, -0.100> <0.019, 1.023, -0.099> <0.034, 1.020, -0.102> <0.038, 1.018, -0.103> 
		<0.010, 1.016, -0.079> <0.017, 1.013, -0.072> <0.054, 1.007, -0.076> <0.056, 1.008, -0.086> 
		<0.019, 1.012, -0.070> <0.025, 1.010, -0.062> <0.050, 1.006, -0.061> <0.053, 1.007, -0.071> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.955, -0.088> <0.070, 0.955, -0.088> <0.070, 0.955, -0.088> <0.070, 0.955, -0.088> 
		<0.053, 0.959, -0.086> <0.060, 0.958, -0.087> <0.060, 0.958, -0.087> <0.077, 0.953, -0.088> 
		<0.032, 0.971, -0.083> <0.050, 0.963, -0.073> <0.074, 0.959, -0.074> <0.092, 0.958, -0.087> 
		<0.020, 0.984, -0.079> <0.038, 0.976, -0.069> <0.072, 0.965, -0.072> <0.090, 0.964, -0.085> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.029, 1.015, -0.116> <0.029, 1.015, -0.116> <0.029, 1.015, -0.116> <0.029, 1.015, -0.116> 
		<0.047, 1.005, -0.119> <0.043, 1.003, -0.124> <0.043, 1.003, -0.124> <0.025, 1.014, -0.121> 
		<0.075, 0.995, -0.122> <0.057, 1.003, -0.131> <0.041, 0.995, -0.128> <0.020, 1.000, -0.127> 
		<0.089, 0.980, -0.127> <0.071, 0.988, -0.136> <0.040, 0.991, -0.123> <0.019, 0.996, -0.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.029, 1.015, -0.116> <0.047, 1.005, -0.119> <0.075, 0.995, -0.122> <0.089, 0.980, -0.127> 
		<0.038, 1.018, -0.103> <0.055, 1.007, -0.106> <0.086, 0.990, -0.116> <0.100, 0.975, -0.121> 
		<0.056, 1.008, -0.086> <0.070, 0.998, -0.089> <0.095, 0.979, -0.087> <0.101, 0.963, -0.092> 
		<0.053, 1.007, -0.071> <0.067, 0.997, -0.074> <0.084, 0.980, -0.080> <0.090, 0.964, -0.085> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.020, 0.984, -0.079> <0.014, 0.990, -0.076> <0.012, 1.007, -0.071> <0.019, 1.012, -0.070> 
		<0.038, 0.976, -0.069> <0.032, 0.982, -0.067> <0.020, 1.013, -0.069> <0.027, 1.018, -0.068> 
		<0.072, 0.965, -0.072> <0.067, 0.981, -0.067> <0.058, 1.003, -0.073> <0.044, 1.013, -0.069> 
		<0.090, 0.964, -0.085> <0.084, 0.980, -0.080> <0.067, 0.997, -0.074> <0.053, 1.007, -0.071> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.020, 0.984, -0.079> <0.014, 0.990, -0.076> <0.012, 1.007, -0.071> <0.019, 1.012, -0.070> 
		<0.038, 0.976, -0.069> <0.032, 0.982, -0.067> <0.018, 1.004, -0.064> <0.025, 1.010, -0.062> 
		<0.072, 0.965, -0.072> <0.067, 0.981, -0.067> <0.065, 0.997, -0.064> <0.050, 1.006, -0.061> 
		<0.090, 0.964, -0.085> <0.084, 0.980, -0.080> <0.067, 0.997, -0.074> <0.053, 1.007, -0.071> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.988, -0.116> <0.111, 0.999, -0.113> <0.124, 1.012, -0.109> <0.136, 1.017, -0.107> 
		<0.104, 0.982, -0.118> <0.108, 0.993, -0.115> <0.129, 1.007, -0.118> <0.140, 1.012, -0.116> 
		<0.110, 0.969, -0.122> <0.123, 0.968, -0.122> <0.141, 0.988, -0.124> <0.150, 0.996, -0.121> 
		<0.117, 0.968, -0.122> <0.130, 0.968, -0.122> <0.145, 0.979, -0.119> <0.155, 0.986, -0.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.988, -0.116> <0.106, 0.988, -0.116> <0.106, 0.988, -0.116> <0.106, 0.988, -0.116> 
		<0.111, 0.999, -0.113> <0.108, 0.993, -0.115> <0.108, 0.993, -0.115> <0.104, 0.982, -0.118> 
		<0.124, 1.012, -0.109> <0.119, 0.997, -0.113> <0.115, 0.984, -0.126> <0.110, 0.969, -0.122> 
		<0.136, 1.017, -0.107> <0.130, 1.002, -0.112> <0.122, 0.984, -0.126> <0.117, 0.968, -0.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.988, -0.116> <0.104, 0.982, -0.118> <0.110, 0.969, -0.122> <0.117, 0.968, -0.122> 
		<0.106, 0.985, -0.108> <0.104, 0.979, -0.110> <0.108, 0.960, -0.120> <0.114, 0.960, -0.120> 
		<0.106, 0.982, -0.096> <0.104, 0.975, -0.098> <0.108, 0.954, -0.100> <0.114, 0.954, -0.100> 
		<0.106, 0.979, -0.088> <0.104, 0.973, -0.090> <0.110, 0.960, -0.094> <0.117, 0.960, -0.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.988, -0.116> <0.106, 0.985, -0.108> <0.106, 0.982, -0.096> <0.106, 0.979, -0.088> 
		<0.111, 0.999, -0.113> <0.111, 0.996, -0.104> <0.111, 0.993, -0.093> <0.111, 0.990, -0.084> 
		<0.124, 1.012, -0.109> <0.121, 1.016, -0.102> <0.127, 1.010, -0.083> <0.125, 1.002, -0.081> 
		<0.136, 1.017, -0.107> <0.132, 1.021, -0.100> <0.138, 1.016, -0.081> <0.136, 1.008, -0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.176, 1.017, -0.107> <0.170, 1.027, -0.104> <0.147, 1.021, -0.106> <0.136, 1.017, -0.107> 
		<0.182, 1.008, -0.110> <0.176, 1.018, -0.107> <0.141, 1.007, -0.110> <0.130, 1.002, -0.112> 
		<0.163, 0.994, -0.114> <0.154, 0.986, -0.117> <0.135, 0.983, -0.126> <0.122, 0.984, -0.126> 
		<0.155, 0.986, -0.117> <0.145, 0.979, -0.119> <0.130, 0.968, -0.122> <0.117, 0.968, -0.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.176, 1.017, -0.107> <0.170, 1.027, -0.104> <0.147, 1.021, -0.106> <0.136, 1.017, -0.107> 
		<0.175, 1.016, -0.098> <0.169, 1.026, -0.095> <0.143, 1.026, -0.099> <0.132, 1.021, -0.100> 
		<0.178, 1.021, -0.080> <0.172, 1.031, -0.077> <0.148, 1.021, -0.079> <0.138, 1.016, -0.081> 
		<0.174, 1.014, -0.077> <0.168, 1.024, -0.074> <0.146, 1.013, -0.077> <0.136, 1.008, -0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.176, 1.017, -0.107> <0.176, 1.017, -0.107> <0.176, 1.017, -0.107> <0.176, 1.017, -0.107> 
		<0.170, 1.027, -0.104> <0.176, 1.018, -0.107> <0.176, 1.018, -0.107> <0.182, 1.008, -0.110> 
		<0.147, 1.021, -0.106> <0.151, 1.016, -0.115> <0.159, 1.003, -0.119> <0.163, 0.994, -0.114> 
		<0.136, 1.017, -0.107> <0.140, 1.012, -0.116> <0.150, 0.996, -0.121> <0.155, 0.986, -0.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.176, 1.017, -0.107> <0.182, 1.008, -0.110> <0.163, 0.994, -0.114> <0.155, 0.986, -0.117> 
		<0.175, 1.016, -0.098> <0.181, 1.007, -0.101> <0.167, 0.986, -0.111> <0.158, 0.979, -0.113> 
		<0.178, 1.021, -0.080> <0.184, 1.011, -0.084> <0.160, 0.982, -0.092> <0.151, 0.973, -0.095> 
		<0.174, 1.014, -0.077> <0.180, 1.004, -0.080> <0.164, 0.986, -0.086> <0.155, 0.978, -0.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.176, 1.017, -0.107> <0.182, 1.008, -0.110> <0.163, 0.994, -0.114> <0.155, 0.986, -0.117> 
		<0.175, 1.016, -0.098> <0.181, 1.007, -0.101> <0.167, 0.986, -0.111> <0.158, 0.979, -0.113> 
		<0.178, 1.021, -0.080> <0.172, 1.011, -0.076> <0.156, 0.980, -0.085> <0.151, 0.973, -0.095> 
		<0.174, 1.014, -0.077> <0.168, 1.004, -0.072> <0.159, 0.984, -0.079> <0.155, 0.978, -0.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.979, -0.088> <0.106, 0.979, -0.088> <0.106, 0.979, -0.088> <0.106, 0.979, -0.088> 
		<0.111, 0.990, -0.084> <0.108, 0.984, -0.086> <0.108, 0.984, -0.086> <0.104, 0.973, -0.090> 
		<0.125, 1.002, -0.081> <0.120, 0.987, -0.077> <0.115, 0.970, -0.082> <0.110, 0.960, -0.094> 
		<0.136, 1.008, -0.079> <0.131, 0.993, -0.075> <0.122, 0.970, -0.083> <0.117, 0.960, -0.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.155, 0.986, -0.117> <0.155, 0.986, -0.117> <0.155, 0.986, -0.117> <0.155, 0.986, -0.117> 
		<0.145, 0.979, -0.119> <0.141, 0.988, -0.124> <0.141, 0.988, -0.124> <0.150, 0.996, -0.121> 
		<0.130, 0.968, -0.122> <0.135, 0.983, -0.126> <0.135, 0.997, -0.121> <0.140, 1.012, -0.116> 
		<0.117, 0.968, -0.122> <0.122, 0.984, -0.126> <0.130, 1.002, -0.112> <0.136, 1.017, -0.107> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.155, 0.986, -0.117> <0.145, 0.979, -0.119> <0.130, 0.968, -0.122> <0.117, 0.968, -0.122> 
		<0.158, 0.979, -0.113> <0.149, 0.971, -0.116> <0.127, 0.960, -0.120> <0.114, 0.960, -0.120> 
		<0.151, 0.973, -0.095> <0.142, 0.964, -0.098> <0.127, 0.954, -0.100> <0.114, 0.954, -0.100> 
		<0.155, 0.978, -0.088> <0.146, 0.969, -0.091> <0.130, 0.959, -0.094> <0.117, 0.960, -0.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.136, 1.008, -0.079> <0.146, 1.013, -0.077> <0.168, 1.024, -0.074> <0.174, 1.014, -0.077> 
		<0.131, 0.993, -0.075> <0.141, 0.998, -0.074> <0.174, 1.013, -0.077> <0.180, 1.004, -0.080> 
		<0.122, 0.970, -0.083> <0.135, 0.970, -0.083> <0.155, 0.978, -0.088> <0.164, 0.986, -0.086> 
		<0.117, 0.960, -0.094> <0.130, 0.959, -0.094> <0.146, 0.969, -0.091> <0.155, 0.978, -0.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.136, 1.008, -0.079> <0.146, 1.013, -0.077> <0.168, 1.024, -0.074> <0.174, 1.014, -0.077> 
		<0.131, 0.993, -0.075> <0.141, 0.998, -0.074> <0.162, 1.013, -0.069> <0.168, 1.004, -0.072> 
		<0.122, 0.970, -0.083> <0.135, 0.970, -0.083> <0.150, 0.976, -0.081> <0.159, 0.984, -0.079> 
		<0.117, 0.960, -0.094> <0.130, 0.959, -0.094> <0.146, 0.969, -0.091> <0.155, 0.978, -0.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.976, -0.120> <0.060, 0.983, -0.118> <0.050, 0.999, -0.113> <0.048, 1.011, -0.109> 
		<0.076, 0.973, -0.121> <0.065, 0.980, -0.119> <0.058, 1.003, -0.119> <0.056, 1.015, -0.115> 
		<0.090, 0.975, -0.120> <0.094, 0.987, -0.116> <0.081, 1.010, -0.117> <0.075, 1.020, -0.113> 
		<0.092, 0.982, -0.118> <0.096, 0.993, -0.115> <0.089, 1.010, -0.109> <0.083, 1.021, -0.106> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.976, -0.120> <0.070, 0.976, -0.120> <0.070, 0.976, -0.120> <0.070, 0.976, -0.120> 
		<0.060, 0.983, -0.118> <0.065, 0.980, -0.119> <0.065, 0.980, -0.119> <0.076, 0.973, -0.121> 
		<0.050, 0.999, -0.113> <0.063, 0.990, -0.115> <0.079, 0.985, -0.125> <0.090, 0.975, -0.120> 
		<0.048, 1.011, -0.109> <0.061, 1.002, -0.112> <0.081, 0.992, -0.123> <0.092, 0.982, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.976, -0.120> <0.076, 0.973, -0.121> <0.090, 0.975, -0.120> <0.092, 0.982, -0.118> 
		<0.070, 0.974, -0.111> <0.076, 0.970, -0.112> <0.097, 0.970, -0.117> <0.099, 0.976, -0.115> 
		<0.070, 0.970, -0.100> <0.076, 0.967, -0.101> <0.097, 0.964, -0.097> <0.099, 0.970, -0.095> 
		<0.070, 0.968, -0.091> <0.076, 0.964, -0.093> <0.090, 0.966, -0.092> <0.092, 0.973, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.976, -0.120> <0.070, 0.974, -0.111> <0.070, 0.970, -0.100> <0.070, 0.968, -0.091> 
		<0.060, 0.983, -0.118> <0.060, 0.981, -0.109> <0.060, 0.977, -0.098> <0.060, 0.974, -0.089> 
		<0.050, 0.999, -0.113> <0.043, 0.995, -0.108> <0.045, 0.996, -0.087> <0.051, 0.990, -0.084> 
		<0.048, 1.011, -0.109> <0.041, 1.007, -0.104> <0.042, 1.007, -0.083> <0.048, 1.002, -0.081> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.057, 1.048, -0.097> <0.046, 1.045, -0.098> <0.046, 1.022, -0.105> <0.048, 1.011, -0.109> 
		<0.068, 1.051, -0.096> <0.057, 1.048, -0.097> <0.059, 1.013, -0.108> <0.061, 1.002, -0.112> 
		<0.078, 1.031, -0.103> <0.084, 1.020, -0.106> <0.084, 1.003, -0.120> <0.081, 0.992, -0.123> 
		<0.083, 1.021, -0.106> <0.089, 1.010, -0.109> <0.096, 0.993, -0.115> <0.092, 0.982, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.057, 1.048, -0.097> <0.046, 1.045, -0.098> <0.046, 1.022, -0.105> <0.048, 1.011, -0.109> 
		<0.055, 1.045, -0.089> <0.044, 1.042, -0.090> <0.039, 1.019, -0.101> <0.041, 1.007, -0.104> 
		<0.046, 1.045, -0.073> <0.035, 1.042, -0.074> <0.039, 1.018, -0.080> <0.042, 1.007, -0.083> 
		<0.051, 1.039, -0.069> <0.040, 1.035, -0.070> <0.045, 1.013, -0.077> <0.048, 1.002, -0.081> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.057, 1.048, -0.097> <0.057, 1.048, -0.097> <0.057, 1.048, -0.097> <0.057, 1.048, -0.097> 
		<0.046, 1.045, -0.098> <0.057, 1.048, -0.097> <0.057, 1.048, -0.097> <0.068, 1.051, -0.096> 
		<0.046, 1.022, -0.105> <0.054, 1.027, -0.111> <0.070, 1.030, -0.110> <0.078, 1.031, -0.103> 
		<0.048, 1.011, -0.109> <0.056, 1.015, -0.115> <0.075, 1.020, -0.113> <0.083, 1.021, -0.106> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.057, 1.048, -0.097> <0.068, 1.051, -0.096> <0.078, 1.031, -0.103> <0.083, 1.021, -0.106> 
		<0.055, 1.045, -0.089> <0.067, 1.048, -0.088> <0.085, 1.031, -0.097> <0.090, 1.021, -0.100> 
		<0.046, 1.045, -0.073> <0.059, 1.049, -0.072> <0.082, 1.019, -0.081> <0.089, 1.009, -0.084> 
		<0.051, 1.039, -0.069> <0.063, 1.042, -0.068> <0.077, 1.022, -0.074> <0.083, 1.012, -0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.057, 1.048, -0.097> <0.068, 1.051, -0.096> <0.078, 1.031, -0.103> <0.083, 1.021, -0.106> 
		<0.055, 1.045, -0.089> <0.067, 1.048, -0.088> <0.085, 1.031, -0.097> <0.090, 1.021, -0.100> 
		<0.046, 1.045, -0.073> <0.053, 1.036, -0.068> <0.081, 1.013, -0.075> <0.089, 1.009, -0.084> 
		<0.051, 1.039, -0.069> <0.058, 1.029, -0.064> <0.076, 1.016, -0.069> <0.083, 1.012, -0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.968, -0.091> <0.070, 0.968, -0.091> <0.070, 0.968, -0.091> <0.070, 0.968, -0.091> 
		<0.060, 0.974, -0.089> <0.065, 0.971, -0.090> <0.065, 0.971, -0.090> <0.076, 0.964, -0.093> 
		<0.051, 0.990, -0.084> <0.063, 0.980, -0.079> <0.079, 0.972, -0.082> <0.090, 0.966, -0.092> 
		<0.048, 1.002, -0.081> <0.060, 0.992, -0.076> <0.081, 0.978, -0.080> <0.092, 0.973, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.083, 1.021, -0.106> <0.083, 1.021, -0.106> <0.083, 1.021, -0.106> <0.083, 1.021, -0.106> 
		<0.089, 1.010, -0.109> <0.081, 1.010, -0.117> <0.081, 1.010, -0.117> <0.075, 1.020, -0.113> 
		<0.096, 0.993, -0.115> <0.084, 1.003, -0.120> <0.070, 1.006, -0.118> <0.056, 1.015, -0.115> 
		<0.092, 0.982, -0.118> <0.081, 0.992, -0.123> <0.061, 1.002, -0.112> <0.048, 1.011, -0.109> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.083, 1.021, -0.106> <0.089, 1.010, -0.109> <0.096, 0.993, -0.115> <0.092, 0.982, -0.118> 
		<0.090, 1.021, -0.100> <0.096, 1.010, -0.103> <0.102, 0.988, -0.112> <0.099, 0.976, -0.115> 
		<0.089, 1.009, -0.084> <0.095, 0.999, -0.087> <0.102, 0.981, -0.092> <0.099, 0.970, -0.095> 
		<0.083, 1.012, -0.078> <0.090, 1.002, -0.081> <0.096, 0.984, -0.086> <0.092, 0.973, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.048, 1.002, -0.081> <0.045, 1.013, -0.077> <0.040, 1.035, -0.070> <0.051, 1.039, -0.069> 
		<0.060, 0.992, -0.076> <0.057, 1.003, -0.072> <0.052, 1.039, -0.069> <0.063, 1.042, -0.068> 
		<0.081, 0.978, -0.080> <0.084, 0.990, -0.076> <0.083, 1.012, -0.078> <0.077, 1.022, -0.074> 
		<0.092, 0.973, -0.090> <0.096, 0.984, -0.086> <0.090, 1.002, -0.081> <0.083, 1.012, -0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.048, 1.002, -0.081> <0.045, 1.013, -0.077> <0.040, 1.035, -0.070> <0.051, 1.039, -0.069> 
		<0.060, 0.992, -0.076> <0.057, 1.003, -0.072> <0.047, 1.026, -0.065> <0.058, 1.029, -0.064> 
		<0.081, 0.978, -0.080> <0.084, 0.990, -0.076> <0.082, 1.006, -0.072> <0.076, 1.016, -0.069> 
		<0.092, 0.973, -0.090> <0.096, 0.984, -0.086> <0.090, 1.002, -0.081> <0.083, 1.012, -0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.107, 0.919, -0.138> <0.116, 0.910, -0.140> <0.121, 0.893, -0.146> <0.120, 0.881, -0.150> 
		<0.103, 0.924, -0.136> <0.111, 0.915, -0.139> <0.112, 0.895, -0.153> <0.111, 0.883, -0.156> 
		<0.088, 0.925, -0.136> <0.082, 0.915, -0.139> <0.089, 0.894, -0.153> <0.092, 0.882, -0.157> 
		<0.084, 0.919, -0.138> <0.078, 0.909, -0.141> <0.080, 0.891, -0.146> <0.083, 0.879, -0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.107, 0.919, -0.138> <0.107, 0.919, -0.138> <0.107, 0.919, -0.138> <0.107, 0.919, -0.138> 
		<0.116, 0.910, -0.140> <0.111, 0.915, -0.139> <0.111, 0.915, -0.139> <0.103, 0.924, -0.136> 
		<0.121, 0.893, -0.146> <0.110, 0.905, -0.142> <0.097, 0.917, -0.146> <0.088, 0.925, -0.136> 
		<0.120, 0.881, -0.150> <0.109, 0.892, -0.146> <0.094, 0.912, -0.148> <0.084, 0.919, -0.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.107, 0.919, -0.138> <0.103, 0.924, -0.136> <0.088, 0.925, -0.136> <0.084, 0.919, -0.138> 
		<0.107, 0.917, -0.129> <0.103, 0.922, -0.128> <0.083, 0.929, -0.130> <0.079, 0.924, -0.132> 
		<0.107, 0.913, -0.118> <0.103, 0.918, -0.116> <0.083, 0.923, -0.110> <0.079, 0.917, -0.112> 
		<0.107, 0.910, -0.109> <0.103, 0.915, -0.108> <0.088, 0.916, -0.107> <0.084, 0.911, -0.109> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.107, 0.919, -0.138> <0.107, 0.917, -0.129> <0.107, 0.913, -0.118> <0.107, 0.910, -0.109> 
		<0.116, 0.910, -0.140> <0.116, 0.908, -0.132> <0.116, 0.904, -0.121> <0.116, 0.901, -0.112> 
		<0.121, 0.893, -0.146> <0.128, 0.892, -0.140> <0.125, 0.880, -0.123> <0.120, 0.884, -0.118> 
		<0.120, 0.881, -0.150> <0.127, 0.879, -0.144> <0.125, 0.868, -0.127> <0.120, 0.872, -0.121> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.102, 0.847, -0.160> <0.114, 0.847, -0.160> <0.119, 0.869, -0.153> <0.120, 0.881, -0.150> 
		<0.090, 0.846, -0.160> <0.102, 0.847, -0.160> <0.108, 0.881, -0.150> <0.109, 0.892, -0.146> 
		<0.086, 0.869, -0.153> <0.083, 0.880, -0.150> <0.087, 0.901, -0.151> <0.094, 0.912, -0.148> 
		<0.083, 0.879, -0.150> <0.080, 0.891, -0.146> <0.078, 0.909, -0.141> <0.084, 0.919, -0.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.102, 0.847, -0.160> <0.114, 0.847, -0.160> <0.119, 0.869, -0.153> <0.120, 0.881, -0.150> 
		<0.103, 0.844, -0.152> <0.115, 0.844, -0.152> <0.126, 0.868, -0.148> <0.127, 0.879, -0.144> 
		<0.111, 0.833, -0.139> <0.123, 0.833, -0.139> <0.125, 0.857, -0.131> <0.125, 0.868, -0.127> 
		<0.108, 0.837, -0.132> <0.119, 0.838, -0.132> <0.120, 0.861, -0.125> <0.120, 0.872, -0.121> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.102, 0.847, -0.160> <0.102, 0.847, -0.160> <0.102, 0.847, -0.160> <0.102, 0.847, -0.160> 
		<0.114, 0.847, -0.160> <0.102, 0.847, -0.160> <0.102, 0.847, -0.160> <0.090, 0.846, -0.160> 
		<0.119, 0.869, -0.153> <0.110, 0.871, -0.160> <0.094, 0.871, -0.160> <0.086, 0.869, -0.153> 
		<0.120, 0.881, -0.150> <0.111, 0.883, -0.156> <0.092, 0.882, -0.157> <0.083, 0.879, -0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.102, 0.847, -0.160> <0.090, 0.846, -0.160> <0.086, 0.869, -0.153> <0.083, 0.879, -0.150> 
		<0.103, 0.844, -0.152> <0.092, 0.844, -0.152> <0.079, 0.867, -0.148> <0.076, 0.878, -0.145> 
		<0.111, 0.833, -0.139> <0.098, 0.832, -0.139> <0.083, 0.866, -0.128> <0.079, 0.878, -0.125> 
		<0.108, 0.837, -0.132> <0.095, 0.837, -0.132> <0.087, 0.859, -0.125> <0.083, 0.871, -0.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.102, 0.847, -0.160> <0.090, 0.846, -0.160> <0.086, 0.869, -0.153> <0.083, 0.879, -0.150> 
		<0.103, 0.844, -0.152> <0.092, 0.844, -0.152> <0.079, 0.867, -0.148> <0.076, 0.878, -0.145> 
		<0.111, 0.833, -0.139> <0.106, 0.839, -0.129> <0.085, 0.867, -0.120> <0.079, 0.878, -0.125> 
		<0.108, 0.837, -0.132> <0.103, 0.843, -0.122> <0.089, 0.860, -0.117> <0.083, 0.871, -0.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.107, 0.910, -0.109> <0.107, 0.910, -0.109> <0.107, 0.910, -0.109> <0.107, 0.910, -0.109> 
		<0.116, 0.901, -0.112> <0.111, 0.906, -0.111> <0.111, 0.906, -0.111> <0.103, 0.915, -0.108> 
		<0.120, 0.884, -0.118> <0.111, 0.892, -0.107> <0.097, 0.904, -0.103> <0.088, 0.916, -0.107> 
		<0.120, 0.872, -0.121> <0.111, 0.880, -0.111> <0.094, 0.898, -0.105> <0.084, 0.911, -0.109> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.083, 0.879, -0.150> <0.083, 0.879, -0.150> <0.083, 0.879, -0.150> <0.083, 0.879, -0.150> 
		<0.080, 0.891, -0.146> <0.089, 0.894, -0.153> <0.089, 0.894, -0.153> <0.092, 0.882, -0.157> 
		<0.078, 0.909, -0.141> <0.087, 0.901, -0.151> <0.101, 0.894, -0.153> <0.111, 0.883, -0.156> 
		<0.084, 0.919, -0.138> <0.094, 0.912, -0.148> <0.109, 0.892, -0.146> <0.120, 0.881, -0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.083, 0.879, -0.150> <0.080, 0.891, -0.146> <0.078, 0.909, -0.141> <0.084, 0.919, -0.138> 
		<0.076, 0.878, -0.145> <0.073, 0.889, -0.141> <0.073, 0.913, -0.135> <0.079, 0.924, -0.132> 
		<0.079, 0.878, -0.125> <0.075, 0.889, -0.121> <0.073, 0.907, -0.115> <0.079, 0.917, -0.112> 
		<0.083, 0.871, -0.122> <0.079, 0.882, -0.118> <0.078, 0.900, -0.113> <0.084, 0.911, -0.109> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.120, 0.872, -0.121> <0.120, 0.861, -0.125> <0.119, 0.838, -0.132> <0.108, 0.837, -0.132> 
		<0.111, 0.880, -0.111> <0.111, 0.869, -0.114> <0.106, 0.837, -0.132> <0.095, 0.837, -0.132> 
		<0.094, 0.898, -0.105> <0.087, 0.888, -0.108> <0.083, 0.870, -0.122> <0.087, 0.859, -0.125> 
		<0.084, 0.911, -0.109> <0.078, 0.900, -0.113> <0.079, 0.882, -0.118> <0.083, 0.871, -0.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.120, 0.872, -0.121> <0.120, 0.861, -0.125> <0.119, 0.838, -0.132> <0.108, 0.837, -0.132> 
		<0.111, 0.880, -0.111> <0.111, 0.869, -0.114> <0.114, 0.844, -0.122> <0.103, 0.843, -0.122> 
		<0.094, 0.898, -0.105> <0.087, 0.888, -0.108> <0.085, 0.872, -0.114> <0.089, 0.860, -0.117> 
		<0.084, 0.911, -0.109> <0.078, 0.900, -0.113> <0.079, 0.882, -0.118> <0.083, 0.871, -0.122> 
	}
	pigment { rgb < 0.92, 0.42, 0 > }
}

// Create a single flower using PetalColor for the petals, and
// apply Transformation on the whole object

#macro Flower(PetalColor)
union {
	object { FlowerStem }
	object {
		FlowerPetals
		pigment { color rgb PetalColor }
	}
}
#end

// Create a vase full of flowers (randomly placed using StartSeed),
// and apply Transformation on the whole object

#macro VaseWithFlowers(NumOfFlowers, StartSeed, Transformation)
	#local Color1 = <0.92, 0.42, 0>;
	#local Color2 = <0.82, 0.84, 0.06>;

	#declare Stream = seed (StartSeed);
	
	union {
		object { Vase }
	
		#declare Count = 0;
		
		#while (Count < NumOfFlowers)
			// Horizontal vector to perform a small rotation
			// for every flower
			#local HorVect =
				vnormalize (<rand(Stream), 0, rand(Stream)>);
	
			object {
				#if (rand (Stream) < 0.5)
					Flower(Color1)
				#else
					Flower(Color2)
				#end
	
				translate <0, -0.4, 0>
				rotate HorVect * 30 * (rand(Stream) - 1/2)
				translate <0, 0.4, 0>
	
				rotate y * 360 * rand(Stream)
				translate <0.05 * rand(Stream),
				           0.2 * rand(Stream),
				           0.05 * rand (Stream)>
			}
			#declare Count = Count + 1;
		#end

		transform { Transformation }
	}
#end
