// Persistence Of Vision Ray Tracer version 3.5
// By the window Scene File
// By S.Nishimura


#include "coordinate_color.mcr.inc"


global_settings { assumed_gamma 2.2 max_trace_level 5 }

camera { location < 0, 0, -400 > look_at < 0, 0, 0 > angle 53 rotate -30*y translate 50*x }

light_source { < 0, 0, -400 > color rgb 1 fade_distance 400 fade_power 1 shadowless }
light_source { < 0, 0, -200 > color rgb 1 fade_distance 100 fade_power 1 }
light_source { < 0, 50, -100 > color rgb 1 fade_distance 50 fade_power 1 shadowless }

//**********************************************************************************
coordinate_color( 210, 0.7, 0.9, 1, 0 )
background { color rgb < R0, G0, B0 > }
//**********************************************************************************
// sky
coordinate_color( 360, 0.00, 0.85, 1, 1 )
coordinate_color( 360, 0.00, 0.75, 1, 2 )
coordinate_color( 270, 0.13, 0.21, 1, 3 )
//
#local Sky_seg =
sky_sphere {
 pigment { bozo
           turbulence 0.7
           octaves 6
           omega 0.7
           lambda 2
           color_map { [ 0.0, 0.1 color rgb < R1, G1, B1 > color rgb < R2, G2, B2 > ]
                       [ 0.1, 0.5 color rgb < R2, G2, B2 > color rgb < R3, G3, B3 > ]
                       [ 0.5, 1.0 color rgb < R3, G3, B3 > color rgb < R3, G3, B3 > ] } }
}
//
sky_sphere { Sky_seg translate 1.7*x scale <1,0.6,1>*0.1 }
//----------------------------------------------------------------------------------
plane { z, 50 hollow 
 pigment { gradient x 
           color_map { [0.0 rgbt <0,0,0,0>]
                       [1.0 rgbt <1,1,1,1>]} translate 0.4*x scale 500 }
}
//----------------------------------------------------------------------------------
// moon
coordinate_color( 11, 1.00, 0.70, 1, 1 )
coordinate_color( 31, 1.00, 0.65, 1, 2 )
coordinate_color(  4, 0.31, 0.80, 1, 3 )
#local M_moon =
 media { emission rgb 0.006
         confidence 0.999
         variance 0.001
         density { spherical
                   color_map { [ 0.0 rgb < 0, 0, 0 > ]
                               [ 0.4 rgb < R1, G1, B1 > ]
                               [ 0.6 rgb < R2, G2, B2 > ]
                               [ 0.8 rgb < R3, G3, B3 > ]
                               [ 0.9 rgb < R1, G1, B1 > ]
                               [ 1.0 rgb < 0, 0, 0 > ] } }
 }
//
#local Moon_org = difference { sphere { 0, 30 } cylinder { 0,31*z 31 } }
#local Moon_seg = object {Moon_org hollow pigment { color rgbt < 1, 1, 1, 1 > } interior { media { M_moon scale 36 } } }
//
object { Moon_seg scale 10 translate < -460, 480, 2000 >*3 }
//**********************************************************************************
// rainbow
coordinate_color(270,1.0,0.75,1,1)
coordinate_color(210,1.0,0.75,1,3)
coordinate_color(210,1.0,0.60,1,4)
coordinate_color(150,1.0,0.60,1,5)
coordinate_color( 90,1.0,0.60,1,6)
coordinate_color( 30,1.0,0.60,1,7)
coordinate_color(352,1.0,0.60,1,8)
coordinate_color(330,1.0,0.60,1,9)
//
#local Cmap_rainbow =
color_map { [0.000  rgbft < R1,G1,B1,1.0,0.98>]
            [0.100  rgbft < R1,G1,B1,0.8,0.96>]
            [0.214  rgbft < R3,G3,B3,0.8,0.94>]
            [0.328  rgbft < R4,G4,B4,0.8,0.92>]
            [0.442  rgbft < R5,G5,B5,0.8,0.90>]
            [0.556  rgbft < R6,G6,B6,0.8,0.92>]
            [0.670  rgbft < R7,G7,B7,0.8,0.94>]
            [0.784  rgbft < R8,G8,B8,0.8,0.96>]
            [0.900  rgbft < R9,G9,B9,0.8,0.98>] }
//----------------------------------------------------------------------------------
rainbow {
  angle 6 width 5 falloff_angle 30 distance 1 direction <-0.5, 0, 1> jitter 0.01
  color_map { Cmap_rainbow }
}
//**********************************************************************************
#include "Scan_surface.mcr.inc"
//----------------------------------------------------------------------------------
#macro Line_function(Tp,Px,Py,Pz,Func_type)
 #switch(Func_type)
  #case(1) #local Px=0; #local Py=pow(Tp,2)-25; #local Pz=2*Tp; #break // bone
  #case(2) #local Px=2*Tp; #local Py=0; #local Pz=1.1*sin(Tp); #break // start
  #case(3) #local Px=2*Tp; #local Py=0; #local Pz=0.5*sin(Tp); #break // end
 #end
#end
//----------------------------------------------------------------------------------
// curtain
coordinate_color(90,1.0,0.7,1,1)
#local T_Curtain =
texture {
 pigment { hexagon color rgbf <R1,G1,B1,0.6> color rgbf <R1,G1,B1,0.59> color rgbf <R1,G1,B1,0.61> }
 finish { phong 0.2 brilliance 0.5 ambient 0.4 diffuse 0.5 reflection 0 }
}
//----------------------------------------------------------------------------------
#local Curtain_org = Scan_surface(<2,1>,pi*<-5,5,1/8>,<0,7,1.5>,1)
#local Curtain_seg = object { Curtain_org scale 3.4 translate <0,-5,-62> }
//**********************************************************************************
// window
coordinate_color(20,0.6,0.8,1,1)
#local T_rod =
texture {
 pigment { color rgb <R1,G1,B1> }
 normal { bumps 0.1 scale <1,3,1>*0.4 }
 finish { phong 0.1 brilliance 0.5 }
}
//
coordinate_color(355,0.66,0.64,1,1)
coordinate_color(349,0.31,0.45,1,2)
#local T_wood_a =
texture {
 pigment { wood
           turbulence 0.04
           octaves 3
           scale <0.05,0.05,1>
           color_map { [0.1 rgb <R1,G1,B1>]
                       [0.9 rgb <R2,G2,B2>] } }
 finish { specular 0.25 roughness 0.05 ambient 0.45 diffuse 0.33 reflection 0.15 }
}
coordinate_color(11,0.35,0.55,1,3)
coordinate_color( 7,0.57,0.55,1,4)
coordinate_color( 0,0.50,0.40,1,5)
#local T_wood_b =
texture {
 pigment { wood
           turbulence <0.1,0.5,1>
           octaves 5
           lambda 3.25
           scale <0.15,0.5,1>
           color_map { [0.0 rgbf <R3,G3,B3,0.100>]
                       [0.1 rgbf <R4,G4,B4,0.500>]
                       [0.1 rgbf <R4,G4,B4,0.650>]
                       [0.9 rgbf <R5,G5,B5,0.975>]
                       [1.0 rgbf <R5,G5,B5,1.000>] } rotate <5,10,5> translate -2*x }
 finish { specular 0.25 roughness 0.0005 ambient 0.1 diffuse 0.33 }
}
#local T_wood = texture { T_wood_a } texture { T_wood_b }
//
coordinate_color(10,1,0.3,1,6)
#local T_window = texture { T_wood scale 20 } texture { pigment { color rgbf <R6,G6,B6,0.3> } }
//
coordinate_color(10,1,0.7,1,7)
#local T_frame = texture { T_wood scale 20 } texture { pigment { color rgbf <R7,G7,B7,0.3> } }
//
coordinate_color(360,0,1,1,8)
#local T_wall = texture { T_wood scale 20 } texture { pigment { color rgbf <R8,G8,B8,0.3> } }
//
coordinate_color( 210, 0.9, 0.5, 1, 1 )
#local M_glass =
material {
 texture {
  pigment { color rgbt <R1,G1,B1,0.8> }
  finish { specular 0.6 roughness 0.003 ambient 0.1 diffuse 0.1 reflection { 0.05, 1.0 } conserve_energy }
 }
 interior { ior 1.5 fade_distance 10.0 fade_power 1001 }
}
//
#local Window_base = superellipsoid { <0.25,0.25> translate y scale <1.08,10,0.5>*4 }
#local Window_org = union { object { Window_base rotate -90*z } object { Window_base rotate -90*z translate 60*x } }
//
#local Window_seg =
union {
 object { Window_org rotate 90*z translate (140-8)*x }
 object { Window_org rotate 90*z }
 object { Window_org translate <-4,140-4,0> }
 object { Window_org scale <1,0.5,1> translate <-4,70,0> }
 object { Window_org translate <-4,4,0> }
 //
 box {<0,70,-1>,<140-8,140,1> material { M_glass } }
 box {<0, 0,-1>,<140-8, 70,1> material { M_glass } }
 scale 1.5
}
//
#local Window_obj =
union {
object { Window_seg texture { T_window } translate -105*y translate -30*x }
object { Window_seg texture { T_window } translate <-210+12,-105,6> translate 60*x }
//
object { Window_org texture { T_frame } scale <1.99,0.5,1.6>*1.5 translate <-105*2, 105-0.2,0> }
object { Window_org texture { T_frame } scale <1.99,0.5,1.6>*1.5 translate <-105*2,-105+0.2,0> }
object { Window_org texture { T_frame } scale <1.01,0.5,1.6>*1.5 rotate 90*z translate <-210+4,-105-1,0> }
object { Window_org texture { T_frame } scale <1.01,0.5,1.6>*1.5 rotate 90*z translate < 210-4,-105-1,0> }
//
union {
 box { <-210*2,-105,-2>,<-210,105,2> }
 box { <210,-105,-2>,<210*2,105,2> }
 box { <-210*2,105,-2>,<210*2,105*2,2> }
 box { <-210*2,-105,-2>,<210*2,-105*2,2> }
 texture { T_wall }
}
//
difference {
 object { Window_org texture { T_rod } scale <2,0.5,1>*1.5 translate <-105*2, 105,-6> }
 object { Window_org texture { T_rod } scale <2,0.2,1>*1.5*0.99 translate <-105*2, 105,-8> }
 scale 0.99 }
//
 torus { 3, 1 texture { T_rod } rotate <-90,90,0> translate <4,105,-11> }
 torus { 3, 1 texture { T_rod } rotate <-90,90,0> translate <-27,105,-11> }
 torus { 3, 1 texture { T_rod } rotate <-90,90,0> translate <-70,105,-11> }
 torus { 3, 1 texture { T_rod } rotate <-90,90,0> translate <-113,105,-11> }
 torus { 3, 1 texture { T_rod } rotate <-90,90,0> translate <-155,105,-11> }
 torus { 3, 1 texture { T_rod } rotate <-90,90,0> translate <-202,105,-11> }
}
//
union {
 object { Window_obj }
 object { Curtain_seg texture { T_Curtain } translate (-105+5-2)*x }
}
//**********************************************************************************
// night view
#local T_bldg = texture { pigment { color rgbt <0,0,1,0.6> } }
//
#local T_lum_m =
texture {
 pigment { color rgbt <1,0,1,0.5> }
 finish { ambient 1 diffuse 0 }
}
//
#local T_lum_y =
texture {
 pigment { color rgbt <1,1,0,0.5> }
 finish { ambient 1 diffuse 0 }
}
//----------------------------------------------------------------------------------
#local Floor_base =
difference {
 superellipsoid { <1,0.12> texture { T_bldg } rotate -90*x scale <10,2,10>*4 }
 #local Ei=24; #local Si=0; #while(Si<Ei)
  box { <-2,-1,-3> <2,1,3> texture { T_lum_y } translate 40*x rotate 360*Si/Ei*y translate 3*y }
  box { <-2,-1,-3> <2,1,3> texture { T_lum_y } translate 40*x rotate 360*Si/Ei*y translate -3*y }
 #local Si=Si+1; #end
}
//
#local Cbldg_org =
union {
superellipsoid { <1,0.12> texture { T_bldg } rotate -90*x scale <3,10,3>*10 }
#local Ei=7; #local Si=0; #while(Si<Ei)
 object { Floor_base translate (-40+20*Si)*y }
#local Si=Si+1; #end
difference {
 superellipsoid { <1,0.12> texture { T_bldg } rotate -90*x scale <10,8,10>*4 }
 #local Ei=32; #local Si=0; #while(Si<Ei)
  box { <-2,-1,-3> <2,1,3> texture { T_lum_m } translate 40*x rotate 360*Si/Ei*y translate 3*7*y }
  box { <-2,-1,-3> <2,1,3> texture { T_lum_m } translate 40*x rotate 360*Si/Ei*y translate 3*5*y }
  box { <-2,-1,-3> <2,1,3> texture { T_lum_m } translate 40*x rotate 360*Si/Ei*y translate 3*3*y }
  box { <-2,-1,-3> <2,1,3> texture { T_lum_m } translate 40*x rotate 360*Si/Ei*y translate 3*1*y }
 #local Si=Si+1; #end
 translate -80*y }
 superellipsoid { <0.12,0.12> texture { T_bldg } rotate -90*x scale <10,4,10>*4 translate <40,-95.5,0> }
}
//
object { Cbldg_org translate <0,-30,60> }
//**********************************************************************************
//
coordinate_color( 172, 0.81, 0.50, 1, 0 )
coordinate_color( 110, 1.00, 0.45, 1, 1 )
coordinate_color( 254, 0.11, 0.90, 1, 2 )
coordinate_color( 254, 0.11, 0.90, 1, 3 )
coordinate_color( 254, 0.28, 0.78, 1, 4 )
coordinate_color( 254, 0.28, 0.78, 1, 5 )
coordinate_color( 254, 0.74, 0.56, 1, 6 )
// body
#local tx0 =
 texture {
  pigment { color rgb < 0.9, 0.7, 0.7 > }
  normal { bumps 0.1 scale 0.08 } 
 }
// hair
#local tx1 =
  texture { pigment { color rgb < R0, G0, B0 > } }
  texture { 
   pigment { gradient y
             color_map { [ 0.00 rgbf < R1, G1, B1, 0.00 > ]
                         [ 0.20 rgbf < R2, G2, B2, 0.65 > ]
                         [ 0.40 rgbf < R3, G3, B3, 0.65 > ]
                         [ 0.60 rgbf < R4, G5, B5, 0.85 > ]
                         [ 0.80 rgbf < R5, G5, B5, 0.85 > ]
                         [ 1.00 rgbf < R6, G6, B6, 0.95 > ] } }
  finish { reflection 0.6 }
  scale < 0.01, 0.2, 0.3 >  
 }
// mouth
#local tx2 =
 texture { 
  pigment { color rgb < 1.00, 0.43, 0.78 > }
  normal { bumps 0.2 scale 0.1 }
 }
// eyebrow
#local tx3 =
  texture { pigment { color rgb < 0.1, 0.6, 0.9 > } }
  texture { 
   pigment { gradient x
             color_map { [ 0.00 rgbf < 0.00, 0.9, 0.3, 0 > ]
                         [ 0.20 rgbf < 0.94, 0.81, 0.99, 0.65 > ]
                         [ 0.40 rgbf < 0.94, 0.81, 0.99, 0.65 > ]
                         [ 0.60 rgbf < 0.87, 0.58, 0.98, 0.85 > ]
                         [ 0.80 rgbf < 0.87, 0.58, 0.98, 0.85 > ]
                         [ 1.00 rgbf < 0.73, 0.16, 0.96, 0.95 > ] } }
   normal { bumps 0.1 scale 0.1 }
   scale < 0.01, 0.2, 0.3 > 
 }
// eyemask
#local tx4 = texture { pigment { color rgb < 1, 1, 1 > } }
// dress
#local tx5 =
  texture { 
   pigment { marble 
             color_map { [ 0.00 rgb < 0.95, 0.40, 0.70 > ]
                         [ 0.15 rgb < 0.90, 0.35, 0.75 > ]
                         [ 0.35 rgb < 0.85, 0.30, 0.80 > ]
                         [ 0.55 rgb < 0.80, 0.25, 0.85 > ]
                         [ 0.75 rgb < 0.75, 0.20, 0.90 > ]
                         [ 0.85 rgb < 0.70, 0.15, 0.95 > ] } }
   normal { bumps 0.1 scale 0.1 }
   scale < 0.05, 0.10, 0.15 > 
 }
//
#include "Lady_R01a.def.inc"
#local Lady_obj =
union {
 object { Lady_form }
 // R eye
 sphere { < 4.2, 85.2, 8.2 > 1.25
  texture {
   pigment { wood
             color_map { [ 0.0 rgbf < 0.4, 0.9, 0.5, 0.4 > ]
                         [ 0.4 rgbf < 0.3, 0.9, 0.5, 0.4 > ]
                         [ 0.6 rgbf < 0.2, 0.6, 0.5, 0.4 > ]
                         [ 0.8 rgbf < 0.1, 0.5, 0.5, 0.4 > ]
                         [ 1.0 rgbf < 0.0, 0.4, 0.5, 0.4 > ] } scale 1.1 rotate < 90, 0, 0 > }
   finish { ambient 0.2 diffuse 0.1 reflection 0.1 specular 0.8 roughness 0.0003 phong 1 phong_size 400 }
  }
  interior { ior 1.45 }  
 }
// L eye
 sphere { < -4.2, 85.2, 8.2 > 1.25
  texture {
   pigment { wood
             color_map { [ 0.0 rgbf < 0.4, 0.9, 0.5, 0.4 > ]
                         [ 0.4 rgbf < 0.3, 0.9, 0.5, 0.4 > ]
                         [ 0.6 rgbf < 0.2, 0.6, 0.5, 0.4 > ]
                         [ 0.8 rgbf < 0.1, 0.5, 0.5, 0.4 > ]
                         [ 1.0 rgbf < 0.0, 0.4, 0.5, 0.4 > ] } scale 1.1 rotate < 90, 0, 0 > }
   finish { ambient 0 diffuse 0.1 reflection 0.1 specular 0.8 roughness 0.0003 phong 1 phong_size 400 }
  }
  interior { ior 1.45 }
 }
}
object { Lady_obj rotate (180+30)*y scale 2 translate < 6, -105, -300 > }
//**********************************************************************************
union {
 box { <-210*2, 105*2,-105*4>,< 210*2, 107*2,2> }
 box { <-210*2,-105*2,-105*4>,<-210*2, 105*2,2> }
 box { <-210*2,-105*2,-105*4>,< 210*2,-107*2,2> }
 box { <-210*2,-105*2,-105*4>,< 210*2, 105*2,-106*4> }
 pigment { color rgb 1 }
 finish { ambient 0 diffuse 0 reflection 0 }
}
//**********************************************************************************