// modelling environment
#ifndef(BOAT)
light_source { <8,-8,0> rgb 1 }
light_source { <-18,10,-10> rgb 1 }
camera { location <-4,6,10> look_at <0,2,5> }
//camera { location <0,2,10> look_at <0,2,0> }

background {rgb 1 }

#end

#declare water_difference =
intersection {
	plane { y 2.5 }
	intersection {
		sphere { < 15,15,0> 22 }
		sphere { <-15,15,0> 22 }
		sphere { <0,25,0> 25 }
		scale <1,.7,.9>
	}
}
#declare t_hull =
texture {
	pigment { granite color_map { [0 rgb <.6,.4,.3>][1 rgb <.4,.2,.1>]}scale <3,1,1> }
	normal { granite .0125 scale <1,.1,1> }
	finish { diffuse .6 brilliance 3 }
}

#declare t_laudat =
texture {
	pigment { granite color_map { [0 rgb <.6,.4,.3>][1 rgb <.4,.2,.1>]}scale <3,1,1> }
	normal { granite .0125 scale <1,.1,1> }
	finish { diffuse .3 brilliance 3 }
}

#declare t_metal =
texture {
	pigment { rgb .1 }
	normal { granite 1 scale .5 }
	finish { specular .3 }
//	pigment { rgb x } finish { ambient 1 }
}

#declare t_rope =
texture {
	pigment { rgb <.5,.4,.2> }
}

#declare zarr = array[7] {-9,-6,-4,0,4,6,9}
#declare hull =
union {


// outer parts
	// lauta 1
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,0>,<9,0>,<9,1>,<0,1>
		<3.0,2.0,zarr[3]><3.0,2.0,zarr[4]><2.7,2.1,zarr[5]><.1,3.2,zarr[6]+1.5>
		<2.9,1.8,zarr[3]><2.9,2.0,zarr[4]><2.65,2.1,zarr[5]><.1,3.0,zarr[6]+1.5>
		<2.8,1.55,zarr[3]><2.8,1.35,zarr[4]><2.55,1.6,zarr[5]><.1,2.9,zarr[6]+1.45>
		<2.7,1.35,zarr[3]><2.7,1.35,zarr[4]><2.5,1.6,zarr[5]><.1,2.7,zarr[6]+1.45>
	}
	
	// lauta 1, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,0>,<9,0>,<9,1>,<0,1>
		<2.7,1.35,zarr[3]><2.7,1.35,zarr[4]><2.5,1.6,zarr[5]><.1,2.7,zarr[6]+1.45>
		<2.69,1.35,zarr[3]><2.69,1.35,zarr[4]><2.47,1.6,zarr[5]><.1,2.7,zarr[6]+1.43>
		<2.66,1.35,zarr[3]><2.66,1.35,zarr[4]><2.43,1.6,zarr[5]><.1,2.7,zarr[6]+1.42>
		<2.65,1.35,zarr[3]><2.65,1.35,zarr[4]><2.4,1.6,zarr[5]><.1,2.7,zarr[6]+1.4>
	}

	// lauta 2
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,2>,<9,2>,<9,1>,<0,1>
		<2.65,1.35,zarr[3]><2.65,1.35,zarr[4]><2.4,1.6,zarr[5]><.1,2.7,zarr[6]+1.4>
		<2.45,1.15,zarr[3]><2.45,1.15,zarr[4]><2.2,1.4,zarr[5]><.1,2.5,zarr[6]+1.33>
		<2.2,.85,zarr[3]><2.2,.85,zarr[4]><2.00,1.2,zarr[5]><.1,2.3,zarr[6]+1.27>
		<2.1,.65,zarr[3]><2.0,.65,zarr[4]><1.85,1.0,zarr[5]><.1,2.1,zarr[6]+1.2>
	}
	
	// lauta 2, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,2>,<9,2>,<9,1>,<0,1>
		<2.1,.65,zarr[3]><2.0,.65,zarr[4]><1.85,1.0,zarr[5]><.1,2.1,zarr[6]+1.2>
		<2.1,.65,zarr[3]><2.0,.65,zarr[4]><1.85,1.0,zarr[5]><.1,2.1,zarr[6]+1.2>
		<2.0,.65,zarr[3]><1.9,.65,zarr[4]><1.75,1.0,zarr[5]><.1,2.1,zarr[6]+1.15>
		<2.0,.65,zarr[3]><1.9,.65,zarr[4]><1.75,1.0,zarr[5]><.1,2.1,zarr[6]+1.15>
	}
	
	// lauta 3
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,2>,<9,2>,<9,3>,<0,3>
		<2.0,.65,zarr[3]><1.9,.65,zarr[4]><1.75,1.0,zarr[5]><.1,2.1,zarr[6]+1.15>
		<1.9,.57,zarr[3]><1.8,.57,zarr[4]><1.65,.9,zarr[5]><.1,1.9,zarr[6]+1.15>
		<1.7,0.53,zarr[3]><1.7,0.53,zarr[4]><1.55,0.8,zarr[5]><.1,1.8,zarr[6]+.9>
		<1.6,0.5,zarr[3]><1.6,0.5,zarr[4]><1.45,0.7,zarr[5]><.1,1.7,zarr[6]+.9>
	}
	
	// lauta 3, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,2>,<9,2>,<9,3>,<0,3>
		<1.6,0.5,zarr[3]><1.6,0.5,zarr[4]><1.45,0.7,zarr[5]><.1,1.7,zarr[6]+.9>
		<1.6,0.5,zarr[3]><1.6,0.5,zarr[4]><1.45,0.7,zarr[5]><.1,1.7,zarr[6]+.9>
		<1.5,0.5,zarr[3]><1.5,0.5,zarr[4]><1.35,0.7,zarr[5]><.1,1.7,zarr[6]+.85>
		<1.5,0.5,zarr[3]><1.5,0.5,zarr[4]><1.35,0.7,zarr[5]><.1,1.7,zarr[6]+.85>
	}
	
	// lauta 4
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,4>,<9,4>,<9,3>,<0,3>
		<1.5,0.5,zarr[3]><1.5,0.5,zarr[4]><1.35,0.7,zarr[5]><.1,1.7,zarr[6]+.85>
		<1.4,0.47,zarr[3]><1.4,0.47,zarr[4]><1.25,0.63,zarr[5]><.1,1.6,zarr[6]+.75>
		<1.2,0.43,zarr[3]><1.2,0.43,zarr[4]><1.15,0.57,zarr[5]><.1,1.5,zarr[6]+.65>
		<1.1,0.4,zarr[3]><1.1,0.4,zarr[4]><1.05,0.5,zarr[5]><.1,1.4,zarr[6]+.55>
	}
	
	// lauta 4, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,4>,<9,4>,<9,3>,<0,3>
		<1.1,0.4,zarr[3]><1.1,0.4,zarr[4]><1.05,0.5,zarr[5]><.1,1.4,zarr[6]+.55>
		<1.1,0.4,zarr[3]><1.1,0.4,zarr[4]><1.05,0.5,zarr[5]><.1,1.4,zarr[6]+.55>
		<1.0,0.4,zarr[3]><1.0,0.4,zarr[4]><.95,0.5,zarr[5]><.1,1.4,zarr[6]+.5>
		<1.0,0.4,zarr[3]><1.0,0.4,zarr[4]><.95,0.5,zarr[5]><.1,1.4,zarr[6]+.5>
	}
	
	// lauta 5
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,4>,<9,4>,<9,5>,<0,5>
		<1.0,0.4,zarr[3]><1.0,0.4,zarr[4]><.95,0.5,zarr[5]><.1,1.4,zarr[6]+.5>
		<0.9,0.37,zarr[3]><.9,0.37,zarr[4]><.85,0.47,zarr[5]><.1,1.33,zarr[6]+.5>
		<0.8,0.33,zarr[3]><0.8,0.33,zarr[4]><0.7,0.43,zarr[5]><.1,1.27,zarr[6]+.05>
		<0.7,0.3,zarr[3]><0.7,0.3,zarr[4]><0.6,0.4,zarr[5]><.1,1.2,zarr[6]+.05>
	}
	
	// lauta 5, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,4>,<9,4>,<9,5>,<0,5>
		<0.7,0.3,zarr[3]><0.7,0.3,zarr[4]><0.6,0.4,zarr[5]><.1,1.2,zarr[6]+.05>
		<0.7,0.3,zarr[3]><0.7,0.3,zarr[4]><0.6,0.4,zarr[5]><.1,1.2,zarr[6]+.05>
		<0.6,0.3,zarr[3]><0.6,0.3,zarr[4]><0.5,0.4,zarr[5]><.1,1.2,zarr[6]>
		<0.6,0.3,zarr[3]><0.6,0.3,zarr[4]><0.5,0.4,zarr[5]><.1,1.2,zarr[6]>
	}

	// lauta 6
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,6>,<9,6>,<9,5>,<0,5>
		<0.6,.3,zarr[3]><0.6,.3,zarr[4]><0.5,.4,zarr[5]><.1,1.2,zarr[6]>
		<0.4,.27,zarr[3]><0.4,.27,zarr[4]><0.4,.35,zarr[5]><.1,1.1,zarr[6]>
		<0.3,.23,zarr[3]><0.3,.23,zarr[4]><0.2,.3,zarr[5]><.1,1,zarr[6]-.5>
		<0.1,.2,zarr[3]><0.1,.2,zarr[4]><0.1,.25,zarr[5]><.1,.9,zarr[6]-.5>
	}


// inner parts (outer +/-.2 in appropriate axis)
	// lauta 1
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,0>,<9,0>,<9,1>,<0,1>
		<2.8,2.0,zarr[3]><2.8,2.0,zarr[4]><2.5,2.1,zarr[5]><.1,3.2,zarr[6]+1.3>
		<2.8,2.0,zarr[3]><2.8,2.0,zarr[4]><2.5,2.1,zarr[5]><.1,3.2,zarr[6]+1.3>
		<2.5,1.35,zarr[3]><2.5,1.35,zarr[4]><2.3,1.6,zarr[5]><.1,2.7,zarr[6]+1.25>
		<2.5,1.35,zarr[3]><2.5,1.35,zarr[4]><2.3,1.6,zarr[5]><.1,2.7,zarr[6]+1.25>
	}
	
	// lauta 1, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,0>,<9,0>,<9,1>,<0,1>
		<2.5,1.35,zarr[3]><2.5,1.35,zarr[4]><2.3,1.6,zarr[5]><.1,2.7,zarr[6]+1.25>
		<2.5,1.35,zarr[3]><2.5,1.35,zarr[4]><2.3,1.6,zarr[5]><.1,2.7,zarr[6]+1.25>
		<2.4,1.35,zarr[3]><2.4,1.35,zarr[4]><2.2,1.6,zarr[5]><.1,2.7,zarr[6]+1.2>
		<2.4,1.35,zarr[3]><2.4,1.35,zarr[4]><2.2,1.6,zarr[5]><.1,2.7,zarr[6]+1.2>
	}

	// lauta 2
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,2>,<9,2>,<9,1>,<0,1>
		<2.4,1.35,zarr[3]><2.4,1.35,zarr[4]><2.2,1.6,zarr[5]><.1,2.7,zarr[6]+1.2>
		<2.4,1.35,zarr[3]><2.4,1.35,zarr[4]><2.2,1.6,zarr[5]><.1,2.7,zarr[6]+1.2>
		<1.9,.65,zarr[3]><1.8,.65,zarr[4]><1.65,1.0,zarr[5]><.1,2.1,zarr[6]+1>
		<1.9,.65,zarr[3]><1.8,.65,zarr[4]><1.65,1.0,zarr[5]><.1,2.1,zarr[6]+1>
	}
	
	// lauta 2, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,2>,<9,2>,<9,1>,<0,1>
		<1.9,.65,zarr[3]><1.8,.65,zarr[4]><1.65,1.0,zarr[5]><.1,2.1,zarr[6]+1>
		<1.9,.65,zarr[3]><1.8,.65,zarr[4]><1.65,1.0,zarr[5]><.1,2.1,zarr[6]+1>
		<1.8,.65,zarr[3]><1.7,.65,zarr[4]><1.55,1.0,zarr[5]><.1,2.1,zarr[6]+.95>
		<1.8,.65,zarr[3]><1.7,.65,zarr[4]><1.55,1.0,zarr[5]><.1,2.1,zarr[6]+.95>
	}
	
	// lauta 3
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,2>,<9,2>,<9,3>,<0,3>
		<1.8,.65,zarr[3]><1.7,.65,zarr[4]><1.55,1.0,zarr[5]><.1,2.1,zarr[6]+.95>
		<1.8,.65,zarr[3]><1.7,.65,zarr[4]><1.55,1.0,zarr[5]><.1,2.1,zarr[6]+.95>
		<1.4,0.5,zarr[3]><1.4,0.5,zarr[4]><1.25,0.7,zarr[5]><.1,1.7,zarr[6]+.7>
		<1.4,0.5,zarr[3]><1.4,0.5,zarr[4]><1.25,0.7,zarr[5]><.1,1.7,zarr[6]+.7>
	}
	
	// lauta 3, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,2>,<9,2>,<9,3>,<0,3>
		<1.4,0.5,zarr[3]><1.4,0.5,zarr[4]><1.25,0.7,zarr[5]><.1,1.7,zarr[6]+.7>
		<1.4,0.5,zarr[3]><1.4,0.5,zarr[4]><1.25,0.7,zarr[5]><.1,1.7,zarr[6]+.7>
		<1.3,0.5,zarr[3]><1.3,0.5,zarr[4]><1.15,0.7,zarr[5]><.1,1.7,zarr[6]+.65>
		<1.3,0.5,zarr[3]><1.3,0.5,zarr[4]><1.15,0.7,zarr[5]><.1,1.7,zarr[6]+.65>
	}
	
	// lauta 4
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,4>,<9,4>,<9,3>,<0,3>
		<1.3,0.5,zarr[3]><1.3,0.5,zarr[4]><1.15,0.7,zarr[5]><.1,1.7,zarr[6]+.65>
		<1.3,0.5,zarr[3]><1.3,0.5,zarr[4]><1.15,0.7,zarr[5]><.1,1.7,zarr[6]+.65>
		<0.9,0.4,zarr[3]><0.9,0.4,zarr[4]><0.85,0.5,zarr[5]><.1,1.4,zarr[6]+.35>
		<0.9,0.4,zarr[3]><0.9,0.4,zarr[4]><0.85,0.5,zarr[5]><.1,1.4,zarr[6]+.35>
	}
	
	// lauta 4, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,4>,<9,4>,<9,3>,<0,3>
		<0.9,0.4,zarr[3]><0.9,0.4,zarr[4]><0.85,0.5,zarr[5]><.1,1.4,zarr[6]+.35>
		<0.9,0.4,zarr[3]><0.9,0.4,zarr[4]><0.85,0.5,zarr[5]><.1,1.4,zarr[6]+.35>
		<0.8,0.4,zarr[3]><0.8,0.4,zarr[4]><.75,0.5,zarr[5]><.1,1.4,zarr[6]+.3>
		<0.8,0.4,zarr[3]><0.8,0.4,zarr[4]><.75,0.5,zarr[5]><.1,1.4,zarr[6]+.3>
	}
	
	// lauta 5
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,4>,<9,4>,<9,5>,<0,5>
		<0.8,0.4,zarr[3]><0.8,0.4,zarr[4]><.75,0.5,zarr[5]><.1,1.4,zarr[6]+.3>
		<0.8,0.4,zarr[3]><0.8,0.4,zarr[4]><.75,0.5,zarr[5]><.1,1.4,zarr[6]+.3>
		<0.5,0.3,zarr[3]><0.5,0.3,zarr[4]><0.4,0.4,zarr[5]><.1,1.2,zarr[6]-.15>
		<0.5,0.3,zarr[3]><0.5,0.3,zarr[4]><0.4,0.4,zarr[5]><.1,1.2,zarr[6]-.15>
	}
	
	// lauta 5, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,4>,<9,4>,<9,5>,<0,5>
		<0.5,0.3,zarr[3]><0.5,0.3,zarr[4]><0.4,0.4,zarr[5]><.1,1.2,zarr[6]-.15>
		<0.5,0.3,zarr[3]><0.5,0.3,zarr[4]><0.4,0.4,zarr[5]><.1,1.2,zarr[6]-.15>
		<0.4,0.3,zarr[3]><0.4,0.3,zarr[4]><0.3,0.4,zarr[5]><.1,1.2,zarr[6]-.2>
		<0.4,0.3,zarr[3]><0.4,0.3,zarr[4]><0.3,0.4,zarr[5]><.1,1.2,zarr[6]-.2>
	}

	// lauta 6
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		uv_vectors <0,6>,<9,6>,<9,5>,<0,5>
		<0.4,0.3,zarr[3]><0.4,0.3,zarr[4]><0.3,0.4,zarr[5]><.1,1.2,zarr[6]-.2>
		<0.4,0.3,zarr[3]><0.4,0.3,zarr[4]><0.3,0.4,zarr[5]><.1,1.2,zarr[6]-.2>
		<0.1,.2,zarr[3]><0.1,.2,zarr[4]><0.1,.25,zarr[5]><.1,.9,zarr[6]-.7>
		<0.1,.2,zarr[3]><0.1,.2,zarr[4]><0.1,.25,zarr[5]><.1,.9,zarr[6]-.7>
	}
	
// keel
	bicubic_patch {
		type 1 u_steps 0 v_steps 8
		uv_vectors <0,0>,<15,0>,<15,1>,<0,1>
		<.09,3.4,zarr[6]+1.3><.1,.4,zarr[6]+1.4><.1,.4,zarr[5]+.4><0.1,.4,zarr[3]>
		<.09,3.4,zarr[6]+1.4><.1,.4,zarr[6]+1.5><.1,.3,zarr[5]+.4><0.1,.3,zarr[3]>
		<.09,3.4,zarr[6]+1.5><.1,0,zarr[6]+1.6><.1,.1,zarr[5]+.4><0.1,.1,zarr[3]>
		<.09,3.4,zarr[6]+1.6><.1,0,zarr[6]+1.7><.1,0,zarr[5]+.4><0.1,0,zarr[3]>
	}
	
// railing
	bicubic_patch {
		type 1 u_steps 4 v_steps 4
		uv_vectors <0,0>,<10,0>,<10,1>,<0,1>
		<3.0,2.0,zarr[3]><3.0,2.0,zarr[4]><2.7,2.1,zarr[5]><.1,3.2,zarr[6]+1.5>
		<3.0,2.05,zarr[3]><3.0,2.05,zarr[4]><2.7,2.15,zarr[5]><.1,3.25,zarr[6]+1.5>
		<2.8,2.05,zarr[3]><2.8,2.05,zarr[4]><2.5,2.15,zarr[5]><.1,3.25,zarr[6]+1.3>
		<2.8,2.0,zarr[3]><2.8,2.0,zarr[4]><2.5,2.1,zarr[5]><.1,3.2,zarr[6]+1.3>
		texture { uv_mapping t_laudat rotate y*90 }
	}
}

#declare asym_hull =
union {
// keel, bottom
	bicubic_patch {
		type 1 u_steps 0 v_steps 8
		uv_vectors <0,0>,<15,0>,<15,1>,<0,1>
		<.09,3.4,zarr[6]+1.3><.1,.4,zarr[6]+1.4><.1,.4,zarr[5]+.4><0.1,0,zarr[3]>
		<.05,3.4,zarr[6]+1.3><.05,.4,zarr[6]+1.4><.05,.4,zarr[5]+.4><0.05,0,zarr[3]>
		<-.05,3.4,zarr[6]+1.3><-.05,.4,zarr[6]+1.4><-.05,.4,zarr[5]+.4><-.05,0,zarr[3]>
		<-.09,3.4,zarr[6]+1.3><-.1,.4,zarr[6]+1.4><-.1,.4,zarr[5]+.4><-.1,0,zarr[3]>
		uv_mapping 
	}
	
// keel, top
	bicubic_patch {
		type 1 u_steps 0 v_steps 8
		uv_vectors <0,0>,<15,0>,<15,1>,<0,1>
		<.09,3.4,zarr[6]+1.6><.1,0,zarr[6]+1.7><.1,0,zarr[5]+.4><0.1,0,zarr[3]>
		<.05,3.4,zarr[6]+1.6><.05,0,zarr[6]+1.7><.05,0,zarr[5]+.4><0.05,0,zarr[3]>
		<-.05,3.4,zarr[6]+1.6><-.05,0,zarr[6]+1.7><-.05,0,zarr[5]+.4><-.05,0,zarr[3]>
		<-.09,3.4,zarr[6]+1.6><-.1,0,zarr[6]+1.7><-.1,0,zarr[5]+.4><-.1,0,zarr[3]>
		uv_mapping 
	}
// keel, cap
	intersection {
		cylinder { <.09,0,0> <-.09,0,0> .15 scale <1,.3,1> }
		cylinder { <0,0,.15> <0,0,-.15> .09 scale <1,.5,1> }
		texture { t_hull scale <1/.18,.2,1/.3>*<.2,1,1>}
		translate <0,3.4,zarr[6]+1.45>
	}
}

#declare naula =
sphere { 
	<0,0,0> .025
	scale <1,.5,1>
	no_shadow
}

#declare naulat =
union {
object { naula rotate z*70 rotate y*-20 translate <.15,3.1,10.4> }
object { naula rotate z*70 rotate y*-20 translate <.15,2.75,10.4> }
object { naula rotate z*70 rotate y*-20 translate <.17,2.6,10.32> }
object { naula rotate z*70 rotate y*-20 translate <.17,2.15,10.11> }
object { naula rotate z*70 rotate y*-20 translate <.16,2.0,10.0> }
object { naula rotate z*70 rotate y*-20 translate <.15,1.75,9.85> }
object { naula rotate z*70 rotate y*-20 translate <.15,1.6,9.7> }

object { naula rotate z*70 rotate y*-30 translate <.92,2.7,9> }
object { naula rotate z*70 rotate y*-30 translate <.87,2.4,9> }
object { naula rotate z*70 rotate y*-30 translate <.82,2.2,9> }
object { naula rotate z*70 rotate y*-30 translate <.65,1.85,9> }
object { naula rotate z*70 rotate y*-30 translate <.6,1.75,9> }
object { naula rotate z*70 rotate y*-30 translate <.45,1.5,9> }
object { naula rotate z*70 rotate y*-30 translate <.3,1.3,9> }

object { naula rotate z*90 rotate y*-20 translate <1.9,2.3,7> }
object { naula rotate z*80 rotate y*-20 translate <1.85,2.0,7> }
object { naula rotate z*70 rotate y*-20 translate <1.65,1.8,7> }
object { naula rotate z*60 rotate y*-20 translate <1.4,1.4,7> }
object { naula rotate z*60 rotate y*-20 translate <1.3,1.3,7> }
object { naula rotate z*60 rotate y*-20 translate <1.0,1.0,7> }
object { naula rotate z*60 rotate y*-20 translate <0.9,0.8,7> }

object { naula rotate z*90 rotate y*-10 translate <2.55,2.1,5> }
object { naula rotate z*90 rotate y*-10 translate <2.4,1.8,5> }
object { naula rotate z*70 rotate y*-10 translate <2.3,1.6,5> }
object { naula rotate z*70 rotate y*-10 translate <2.1,1.3,5> }
object { naula rotate z*70 rotate y*-10 translate <1.8,1.0,5> }
object { naula rotate z*50 rotate y*-10 translate <1.6,0.8,5> }
object { naula rotate z*40 rotate y*-10 translate <1.3,0.7,5> }
object { naula rotate z*40 rotate y*-10 translate <0.6,0.4,5> }

object { naula rotate z*90 translate <2.85,1.9,3> }
object { naula rotate z*90 translate <2.8,1.7,3> }
object { naula rotate z*90 translate <2.7,1.5,3> }
object { naula rotate z*70 translate <2.4,1.1,3> }
object { naula rotate z*50 translate <1.9,.7,3> }
object { naula rotate z*50 translate <1.5,.5,3> }
object { naula rotate z*50 translate <1.1,.4,3> }

object { naula rotate z*80 translate <2.9,1.8,1> }
object { naula rotate z*70 translate <2.7,1.4,1> }
object { naula rotate z*60 translate <2.4,1.1,1> }
object { naula rotate z*50 translate <2.0,.8,1> }
object { naula rotate z*30 translate <1.6,.5,1> }
object { naula rotate z*30 translate <1.1,.3,1> }


} // union
#declare vanteet =
union {
difference {
	cylinder { <0,4.5,8.9> <0,4.5,9.1> 3.1}
	cylinder { <0,4.5,8.8> <0,4.5,9.2> 2.95}
	plane { -y,-2.9 }
	scale <.3,1,1>
}
difference {
	cylinder { <0,4.0,6.9> <0,4.0,7.1> 3.2 }
	cylinder { <0,4.0,6.8> <0,4.0,7.2> 3.05 }
	plane { -y,-2.5 }
	scale <.6,1,1>
}
difference {
	cylinder { <0,3.3,4.9> <0,3.3,5.1> 2.6}
	cylinder { <0,3.3,4.8> <0,3.3,5.2> 2.45}
	plane { -y,-2.2 }
}
difference {
	cylinder { <0,3.5,2.9> <0,3.5,3.1> 3.1}
	cylinder { <0,3.5,2.8> <0,3.5,3.2> 2.95}
	plane { -y,-2.05 }
}
difference {
	cylinder { <0,2,.9> <0,2,1.1> 1.6}
	cylinder { <0,2,.8> <0,2,1.2> 1.45 scale <1.05,1,1> }
	plane { -y,-2.0 }
	scale <1.7,1,1>
}
}

#declare laudat =
union {

// middle seat
box {<1.9,1,0><1.8,1.05,3.2>}
box {<-1.9,1,0><-1.8,1.05,3.2>}
box {<1.95,1.1,.1><-1.95,1.05,1.2>texture { t_laudat rotate y*90 scale <1,1,.5>*3 }}

// front and aft seats
intersection {
	union {
		box {<-1.65,1.1,5.1><-1.05,1.15,12> }
		box {<-.95,1.1,5.1><-.05,1.15,12> }
		box {<.95,1.1,5.1><.05,1.15,12> }
		box {<1.65,1.1,5.1><1.05,1.15,12> }
		
		box {<-2,0,0><2,-.25,.1> rotate x*5 translate <0,1.1,5.2> texture { t_laudat scale <1,1,.5>*3 } }
		
		rotate x*-5 
	}
	object {water_difference }
	texture { t_laudat scale <1,1,.5>*3 rotate y*90 }
}
}

#declare r_rope = 0.02;
#declare decorations=
union {
	torus { .15 .02 translate <0,0,-.15> rotate x*-90 translate <0,2.75,-10.6> texture { t_metal } }
	torus { .045 .02 rotate z*-90 translate <0,2.75,-10.6> texture { t_metal }}
	cylinder {<0,.2,0> <0,1.3,0> .1 translate <0,-.2,4.8> texture { t_laudat} }
	
}



union {
	union {
		object { hull }
		object { hull matrix <1,0,0,0,1,0,0,0,-1,0,0,0> }
		object { hull matrix <-1,0,0,0,1,0,0,0,1,0,0,0> }
		object { hull matrix <-1,0,0,0,1,0,0,0,-1,0,0,0> }

		object { asym_hull }
		object { asym_hull matrix <1,0,0,0,1,0,0,0,-1,0,0,0> }
		texture { uv_mapping t_hull }
	}
	union {
		object { laudat }
		object { laudat matrix <1,0,0,0,1,0,0,0,-1,0,0,0> }
		texture { t_laudat scale <.5,1,1> }
	}
	union {
		object { vanteet }
		object { vanteet matrix <1,0,0,0,1,0,0,0,-1,0,0,0> }
		texture { t_laudat rotate y*90 scale <1,1,1>}
	}
	union {
		object { naulat }
		object { naulat matrix <1,0,0,0,1,0,0,0,-1,0,0,0> }
		object { naulat matrix <-1,0,0,0,1,0,0,0,1,0,0,0> }
		object { naulat matrix <-1,0,0,0,1,0,0,0,-1,0,0,0> }
		texture {t_metal}
	}
	object { decorations }
}
