// -----------------------------------------------------------------------------
//  inkpaint.inc -- IRTC Still July-August 2002, "Loneliness"
//
//  Copyright (c) 2002 Aaron 'Serac' Hill <serac@hillvisions.com>
//
//  This program is free for all to use, copy, modify, and distribute, provided
//  the above copyright notice is included in all versions.  Please contact the
//  developer for ideas and suggestions for improving this program.
// -----------------------------------------------------------------------------

#declare OUTPUT_NONE       =  0;
#declare OUTPUT_ID         =  1;
#declare OUTPUT_LIGHT      =  2;
#declare OUTPUT_SHADOWS    =  3;
#declare OUTPUT_DEPTH      =  4;
#declare OUTPUT_DEPTHLOCAL =  5;
#declare OUTPUT_SLOPE      =  6;
#declare OUTPUT_NORMALX    =  7;
#declare OUTPUT_NORMALY    =  8;
#declare OUTPUT_NORMALZ    =  9;
#declare OUTPUT_NUMTYPES   = 10;

#declare OUTPUT_NORMALS = < OUTPUT_NORMALX, OUTPUT_NORMALY, OUTPUT_NORMALZ >;
#declare OUTPUT_PIGMENT = <-1, -1, -1>;

#declare InkPaintDot      = function(x,y,z,a,b,c)     { x*a+y*b+z*c }
#declare InkPaintLength   = function(x,y,z)           { sqrt(InkPaintDot(x,y,z,x,y,z)) }
#declare InkPaintDistance = function(x,y,z,a,b,c)     { InkPaintLength(x-a,y-b,z-c) }
#declare InkPaintClamp    = function(x,y,z)           { max(min(x,z),y) }
#declare InkPaintDepth    = function(x,y,z,a,b,c,n,f) { InkPaintClamp(1-(InkPaintDistance(x,y,z,a,b,c)-n)/(f-n),0,1) }

#macro InkPaintGetBoundingSphere(Object,Center,Radius)
    #local a = min_extent(Object);
    #local b = max_extent(Object);
    #declare Center = (a+b)/2;
    #declare Radius = vlength(a-Center);
#end

#macro InkPaintLight(Location,Intensity,Parallel,Shadowless)
    #ifndef (InkPaintOutput)
        #error "INK: 'InkPaintOutput' must be defined.\n"
    #end

    #if (InkPaintOutput.red = OUTPUT_LIGHT | InkPaintOutput.red = OUTPUT_SHADOWS)
        light_source { Location, color rgb <1, 0, 0>*Intensity fade_distance 1 fade_power 0
            #if (Parallel = true) parallel point_at <0,0,0> #end
            #if (InkPaintOutput.red = OUTPUT_LIGHT | Shadowless = true) shadowless #end
        }
    #end
    #if (InkPaintOutput.green = OUTPUT_LIGHT | InkPaintOutput.green = OUTPUT_SHADOWS)
        light_source { Location, color rgb <0, 1, 0>*Intensity fade_distance 1 fade_power 0
            #if (Parallel = true) parallel point_at <0,0,0> #end
            #if (InkPaintOutput.green = OUTPUT_LIGHT | Shadowless = true) shadowless #end
        }
    #end
    #if (InkPaintOutput.blue = OUTPUT_LIGHT | InkPaintOutput.blue = OUTPUT_SHADOWS)
        light_source { Location, color rgb <0, 0, 1>*Intensity fade_distance 1 fade_power 0
            #if (Parallel = true) parallel point_at <0,0,0> #end
            #if (InkPaintOutput.blue = OUTPUT_LIGHT | Shadowless = true) shadowless #end
        }
    #end
#end

#macro InkPaintObject(Object,Pigment)
    #ifndef (InkPaintOutput)
        #error "INK: 'InkPaintOutput' must be defined.\n"
    #end
    #ifndef (InkPaintCamera)
        #error "INK: 'InkPaintCamera' must be defined.\n"
    #end
    #ifndef (InkPaintMaxIds)
        #error "INK: 'InkPaintMaxIds' must be defined.\n"
    #end

    #ifndef (InkPaintLastObjectId)
        #declare InkPaintLastObjectId = 0;
    #else
        #declare InkPaintLastObjectId = InkPaintLastObjectId + 1;
        #if (InkPaintLastObjectId = InkPaintMaxIds)
            #error "INK: Too many objects.  Increase 'InkPaintMaxIds'.\n"
        #end
    #end
    #local Id = (InkPaintLastObjectId + 1) / InkPaintMaxIds;
    
    object
    {
        Object

        #if (InkPaintOutput.red = OUTPUT_PIGMENT.red &
             InkPaintOutput.green = OUTPUT_PIGMENT.green &
             InkPaintOutput.blue = OUTPUT_PIGMENT.blue)

            texture
            {
                finish { ambient 1 diffuse 0 specular 0 }
                pigment { Pigment }
            }

        #else

            #local cx = 1 * InkPaintCamera.x;
            #local cy = 1 * InkPaintCamera.y;
            #local cz = 1 * InkPaintCamera.z;
            #local n = 1 * InkPaintCamera.filter;
            #local f = 1 * InkPaintCamera.transmit;
            #local c = <0,0,0>;
            #local r = 0;
            InkPaintGetBoundingSphere(Object,c,r)
            #local nl = 1 * (vlength(<cx, cy, cz> - c) - r);
            #local fl = 1 * (nl + 2 * r);
    
            texture
            {
            
                finish
                {
                    #local AmbientValues = array[OUTPUT_NUMTYPES] { 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, }
                    ambient < AmbientValues[InkPaintOutput.red],
                              AmbientValues[InkPaintOutput.green],
                              AmbientValues[InkPaintOutput.blue] >
                    
                    diffuse 1
                    specular 0
                }
                
                pigment
                {
                    average
                    pigment_map
                    {
                        // OUTPUT_NONE
                        [ 1 color rgb 0 ]
        
                        // OUTPUT_ID            
                        [ 1 color rgb < (InkPaintOutput.red = OUTPUT_ID) * Id,
                                        (InkPaintOutput.green = OUTPUT_ID) * Id,
                                        (InkPaintOutput.blue = OUTPUT_ID) * Id > * OUTPUT_NUMTYPES ]
        
                        // OUTPUT_LIGHT
                        [ 1 color rgb < (InkPaintOutput.red = OUTPUT_LIGHT),
                                        (InkPaintOutput.green = OUTPUT_LIGHT),
                                        (InkPaintOutput.blue = OUTPUT_LIGHT) > * OUTPUT_NUMTYPES ]
        
                        // OUTPUT_SHADOWS
                        [ 1 color rgb < (InkPaintOutput.red = OUTPUT_SHADOWS),
                                        (InkPaintOutput.green = OUTPUT_SHADOWS),
                                        (InkPaintOutput.blue = OUTPUT_SHADOWS) > * OUTPUT_NUMTYPES ]
                        
                        // OUTPUT_DEPTH
                        [ 1 function { InkPaintDepth(x, y, z, cx, cy, cz, n, f) }
                            color_map { [ 0 color rgb 0 ]
                                [ 1 color rgb < (InkPaintOutput.red = OUTPUT_DEPTH),
                                                (InkPaintOutput.green = OUTPUT_DEPTH),
                                                (InkPaintOutput.blue = OUTPUT_DEPTH) > * OUTPUT_NUMTYPES ] } ]
                                                
                        // OUTPUT_DEPTHLOCAL
                        [ 1 function { InkPaintDepth(x, y, z, cx, cy, cz, nl, fl) }
                            color_map { [ 0 color rgb 0 ]
                                [ 1 color rgb < (InkPaintOutput.red = OUTPUT_DEPTHLOCAL),
                                                (InkPaintOutput.green = OUTPUT_DEPTHLOCAL),
                                                (InkPaintOutput.blue = OUTPUT_DEPTHLOCAL) > * OUTPUT_NUMTYPES ] } ]
        
                        // OUTPUT_SLOPE
                        [ 1 slope { <cx, cy, cz> } color_map { [ 1/2 color rgb 0 ]
                            [ 1 color rgb < (InkPaintOutput.red = OUTPUT_SLOPE),
                                            (InkPaintOutput.green = OUTPUT_SLOPE),
                                            (InkPaintOutput.blue = OUTPUT_SLOPE) > * OUTPUT_NUMTYPES ] } ]
        
                        // OUTPUT_NORMALX
                        [ 1 slope { x } color_map { [ 0 color rgb 0 ]
                            [ 1 color rgb < (InkPaintOutput.red = OUTPUT_NORMALX),
                                            (InkPaintOutput.green = OUTPUT_NORMALX),
                                            (InkPaintOutput.blue = OUTPUT_NORMALX) > * OUTPUT_NUMTYPES ] } ]
        
                        // OUTPUT_NORMALY
                        [ 1 slope { y } color_map { [ 0 color rgb 0 ]
                            [ 1 color rgb < (InkPaintOutput.red = OUTPUT_NORMALY),
                                            (InkPaintOutput.green = OUTPUT_NORMALY),
                                            (InkPaintOutput.blue = OUTPUT_NORMALY) > * OUTPUT_NUMTYPES ] } ]
        
                        // OUTPUT_NORMALZ
                        [ 1 slope { z } color_map { [ 0 color rgb 0 ]
                            [ 1 color rgb < (InkPaintOutput.red = OUTPUT_NORMALZ),
                                            (InkPaintOutput.green = OUTPUT_NORMALZ),
                                            (InkPaintOutput.blue = OUTPUT_NORMALZ) > * OUTPUT_NUMTYPES ] } ]
                    }
                }
            }
            
        #end
    }
#end