// -----------------------------------------------------------------------------
//  lonely.pov -- IRTC Still July-August 2002, "Loneliness"
//
//  Copyright (c) 2002 Aaron 'Serac' Hill <serac@hillvisions.com>
//
//  This program is free for all to use, copy, modify, and distribute, provided
//  the above copyright notice is included in all versions.  Please contact the
//  developer for ideas and suggestions for improving this program.
// -----------------------------------------------------------------------------

// +w5760 +h3240 -a -d +kfi0 +kff3

#include "inkpaint.inc"
#declare InkPaintMaxIds = 50;
#declare InkPaintCamera = <-8, 3, 3, 6, 13>;
#switch (mod(frame_number,4))
    #case (0) #declare InkPaintOutput = OUTPUT_PIGMENT; #break
    #case (1) #declare InkPaintOutput = OUTPUT_NORMALS; #break
    #case (2) #declare InkPaintOutput = <OUTPUT_DEPTH, OUTPUT_DEPTHLOCAL, OUTPUT_SLOPE>; #break
    #case (3) #declare InkPaintOutput = <OUTPUT_LIGHT, OUTPUT_SHADOWS, OUTPUT_ID>; #break
    #default #declare InkPaintOutput = <0,0,0>; #break
#end

camera
{
    perspective up <0,9,0> right <16,0,0>
    location <InkPaintCamera.x, InkPaintCamera.y, InkPaintCamera.z>
    look_at <-3, 2.5, -1> angle 70
}

InkPaintLight(<2,6,-1>*50,1,false,false)
InkPaintLight(<0,1,10>,5/12,false,true)

#if (InkPaintOutput.x = OUTPUT_PIGMENT.x)
    background { color rgb <70,112,207>/255 }
#else
    background { color rgb
        <(InkPaintOutput.x = OUTPUT_LIGHT | InkPaintOutput.x = OUTPUT_SHADOWS),
         (InkPaintOutput.y = OUTPUT_LIGHT | InkPaintOutput.y = OUTPUT_SHADOWS),
         (InkPaintOutput.z = OUTPUT_LIGHT | InkPaintOutput.z = OUTPUT_SHADOWS)> }
#end

#declare _PatchType = 1;
#declare _PatchFlatness = 0;
#declare _PatchUSteps = 4;
#declare _PatchVSteps = 4;

#include "lonely.inc"

#declare _PatchUSteps = 3;
#declare _PatchVSteps = 3;

#include "other1a.inc"
#include "other1b.inc"
#include "other2a.inc"
#include "other2b.inc"
#include "other3a.inc"
#include "other3b.inc"

#declare _PatchUSteps = 2;
#declare _PatchVSteps = 2;

#include "trees.inc"

InkPaintObject(LonelyBody, pigment { color rgb <129,108,62>/255 })
InkPaintObject(LonelyShoeTops, pigment { color rgb <75,50,39>/255 })
InkPaintObject(LonelyShoeBottoms, pigment { color rgb <53,36,28>/255 })
InkPaintObject(LonelyEyes, pigment { color rgb <192,192,192>/255 })
InkPaintObject(LonelyPupils, pigment { color rgb <0,0,0>/255 })

InkPaintObject(
    sphere { <3.5,-59.9,-.5>,60 no_shadow },
    pigment { color rgb <83,109,62>/255 }
)

#declare T = transform { scale 0.6 rotate <0,22.5,0> translate <3.5,-1/4,-1> }
InkPaintObject(object { Trunk transform { T } }, pigment { BarkPigmentDark transform { T } })
InkPaintObject(object { GenerateLeaves(13) transform { T } }, pigment { LeavesPigment transform { T } })
#declare T = transform { scale 0.4 translate <42,-5.75,-40> }
InkPaintObject(object { Trunk transform { T } }, pigment { BarkPigment transform { T } })
InkPaintObject(object { GenerateLeaves(7) transform { T } }, pigment { LeavesPigment transform { T } })
#declare T = transform { scale 0.3 rotate <0,0,-4> translate <39.5,-5.1,-70.5> }
InkPaintObject(object { Trunk transform { T } }, pigment { BarkPigment transform { T } })
InkPaintObject(object { GenerateLeaves(9) transform { T } }, pigment { LeavesPigment transform { T } })
#declare T = transform { scale 0.35 rotate <0,0,-6> translate <13,-5.5,-53> }
InkPaintObject(object { Trunk transform { T } }, pigment { BarkPigment transform { T } })
InkPaintObject(object { GenerateLeaves(11) transform { T } }, pigment { LeavesPigment transform { T } })

#declare T = transform { translate <38,-6,-32> }
InkPaintObject(object { Other1aBody transform { T } }, pigment { color rgb <216,160,38>/255 })
InkPaintObject(object { Other1aShoeTops transform { T } }, pigment { color rgb <124,59,28>/255 })
InkPaintObject(object { Other1aShoeBottoms transform { T } }, pigment { color rgb <89,42,20>/255 })
InkPaintObject(object { Other1aEyes transform { T } }, pigment { color rgb <255,255,255>/255 })
InkPaintObject(object { Other1aPupils transform { T } }, pigment { color rgb <0,0,0>/255 })
   
InkPaintObject(sphere { <-0.75,0.75,0.75>,0.75 transform { T } },
    pigment { planar color_map
        { [0.7 color rgb <60,120,240>/255][0.7 color rgb <240,120,60>/255]
          [0.9 color rgb <240,120,60>/255][0.9 color rgb <240,240,60>/255] }
        rotate <5,0,-20> translate <-0.75,0.75,0.75>
        transform { T }
    }
)

#declare T = transform { rotate <0, 75, 0> translate <33,-6,-36> }
InkPaintObject(object { Other1bBody transform { T } }, pigment { color rgb <216,160,38>/255 })
InkPaintObject(object { Other1bShoeTops transform { T } }, pigment { color rgb <124,59,28>/255 })
InkPaintObject(object { Other1bShoeBottoms transform { T } }, pigment { color rgb <89,42,20>/255 })
InkPaintObject(object { Other1bEyes transform { T } }, pigment { color rgb <255,255,255>/255 })
InkPaintObject(object { Other1bPupils transform { T } }, pigment { color rgb <0,0,0>/255 })

#declare T = transform { rotate <0, 60, 0> translate <43.2,-5.8,-73.9> }
InkPaintObject(object { Other2aBody transform { T } }, pigment { color rgb <216,160,38>/255 })
InkPaintObject(object { Other2aShoeTops transform { T } }, pigment { color rgb <124,59,28>/255 })
InkPaintObject(object { Other2aShoeBottoms transform { T } }, pigment { color rgb <89,42,20>/255 })
InkPaintObject(object { Other2aEyes transform { T } }, pigment { color rgb <255,255,255>/255 })
InkPaintObject(object { Other2aPupils transform { T } }, pigment { color rgb <0,0,0>/255 })

#declare T = transform { rotate <0, 60, 0> translate <38,-4.9,-68.5> }
InkPaintObject(object { Other2bBody transform { T } }, pigment { color rgb <216,160,38>/255 })
InkPaintObject(object { Other2bShoeTops transform { T } }, pigment { color rgb <124,59,28>/255 })
InkPaintObject(object { Other2bShoeBottoms transform { T } }, pigment { color rgb <89,42,20>/255 })
InkPaintObject(object { Other2bEyeLidTops transform { T } }, pigment { color rgb <247,193,75>/255 })
InkPaintObject(object { Other2bEyeLidBottoms transform { T } }, pigment { color rgb <167,125,31>/255 })

#declare T = transform { rotate <0, 90, 0> translate <13,-5.5,-51> }
InkPaintObject(object { Other3aBody transform { T } }, pigment { color rgb <216,160,38>/255 })
InkPaintObject(object { Other3aShoeTops transform { T } }, pigment { color rgb <124,59,28>/255 })
InkPaintObject(object { Other3aShoeBottoms transform { T } }, pigment { color rgb <89,42,20>/255 })
InkPaintObject(object { Other3aEyes transform { T } }, pigment { color rgb <255,255,255>/255 })
InkPaintObject(object { Other3aPupils transform { T } }, pigment { color rgb <0,0,0>/255 })
InkPaintObject(object { Other3bBody transform { T } }, pigment { color rgb <216,160,38>/255 })
InkPaintObject(object { Other3bShoeTops transform { T } }, pigment { color rgb <124,59,28>/255 })
InkPaintObject(object { Other3bShoeBottoms transform { T } }, pigment { color rgb <89,42,20>/255 })
InkPaintObject(object { Other3bEyes transform { T } }, pigment { color rgb <255,255,255>/255 })
InkPaintObject(object { Other3bPupils transform { T } }, pigment { color rgb <0,0,0>/255 })

#declare Field = height_field {
    function 200,200 { pattern { bozo scale 1/2 } }
    translate <-0.1,-0.5,-0.9> scale <200,48,200>
}
#declare Path = difference {
    cylinder { <0,-1,0>,<0,1,0>,143 }
    cylinder { <0,-2,0>,<0,2,0>,137 }
    scale <1,96,1> rotate <0,0,-2> rotate <-1,0,0>
    translate <-20,-6,-180>
}
InkPaintObject(
    difference { object { Field } object { Path } },
    pigment { color rgb <104,152,64>/255 }
)
InkPaintObject(
    intersection { object { Field } object { Path } },
    pigment { color rgb <210,202,149>/255 }
)

InkPaintObject(
    merge {
        #declare R1 = seed(2);
        #declare I = 0;
        #while (I < 40)
            #declare P = <rand(R1),rand(R1)/3,0>*80;
            #declare R = (rand(R1)+1)*8;
            sphere { P, R scale <1,1,1/8> }
        #declare I = I + 1; #end
        no_shadow
        rotate <0,-40,0>
        translate <200,40,-200>
    },
    pigment { color rgb <232,238,193>/255 }
)
InkPaintObject(
    merge {
        #declare R1 = seed(4);
        #declare I = 0;
        #while (I < 40)
            #declare P = <rand(R1),rand(R1)/3,0>*80;
            #declare R = (rand(R1)+1)*8;
            sphere { P, R scale <1,1,1/8> }
        #declare I = I + 1; #end
        no_shadow
        rotate <0,-30,0>
        translate <100,32,-300>
    },
    pigment { color rgb <232,238,193>/255 }
)
InkPaintObject(
    merge {
        #declare R1 = seed(7);
        #declare I = 0;
        #while (I < 40)
            #declare P = <rand(R1),rand(R1)/3,0>*80;
            #declare R = (rand(R1)+1)*8;
            sphere { P, R scale <1,1,1/8> }
        #declare I = I + 1; #end
        no_shadow
        rotate <0,-60,0>
        translate <300,25,-50>
    },
    pigment { color rgb <232,238,193>/255 }
)